# MochiTransformer3DModel

A Diffusion Transformer model for 3D video-like data was introduced in [Mochi-1 Preview](https://huggingface.co/genmo/mochi-1-preview) by Genmo.

The model can be loaded with the following code snippet.

```python
from diffusers import MochiTransformer3DModel

transformer = MochiTransformer3DModel.from_pretrained("genmo/mochi-1-preview", subfolder="transformer", torch_dtype=torch.float16).to("cuda")
```

## MochiTransformer3DModel[[diffusers.MochiTransformer3DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.MochiTransformer3DModel</name><anchor>diffusers.MochiTransformer3DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_mochi.py#L309</source><parameters>[{"name": "patch_size", "val": ": int = 2"}, {"name": "num_attention_heads", "val": ": int = 24"}, {"name": "attention_head_dim", "val": ": int = 128"}, {"name": "num_layers", "val": ": int = 48"}, {"name": "pooled_projection_dim", "val": ": int = 1536"}, {"name": "in_channels", "val": ": int = 12"}, {"name": "out_channels", "val": ": typing.Optional[int] = None"}, {"name": "qk_norm", "val": ": str = 'rms_norm'"}, {"name": "text_embed_dim", "val": ": int = 4096"}, {"name": "time_embed_dim", "val": ": int = 256"}, {"name": "activation_fn", "val": ": str = 'swiglu'"}, {"name": "max_sequence_length", "val": ": int = 256"}]</parameters><paramsdesc>- **patch_size** (`int`, defaults to `2`) --
  The size of the patches to use in the patch embedding layer.
- **num_attention_heads** (`int`, defaults to `24`) --
  The number of heads to use for multi-head attention.
- **attention_head_dim** (`int`, defaults to `128`) --
  The number of channels in each head.
- **num_layers** (`int`, defaults to `48`) --
  The number of layers of Transformer blocks to use.
- **in_channels** (`int`, defaults to `12`) --
  The number of channels in the input.
- **out_channels** (`int`, *optional*, defaults to `None`) --
  The number of channels in the output.
- **qk_norm** (`str`, defaults to `"rms_norm"`) --
  The normalization layer to use.
- **text_embed_dim** (`int`, defaults to `4096`) --
  Input dimension of text embeddings from the text encoder.
- **time_embed_dim** (`int`, defaults to `256`) --
  Output dimension of timestep embeddings.
- **activation_fn** (`str`, defaults to `"swiglu"`) --
  Activation function to use in feed-forward.
- **max_sequence_length** (`int`, defaults to `256`) --
  The maximum sequence length of text embeddings supported.</paramsdesc><paramgroups>0</paramgroups></docstring>

A Transformer model for video-like data introduced in [Mochi](https://huggingface.co/genmo/mochi-1-preview).




</div>

## Transformer2DModelOutput[[diffusers.models.modeling_outputs.Transformer2DModelOutput]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.models.modeling_outputs.Transformer2DModelOutput</name><anchor>diffusers.models.modeling_outputs.Transformer2DModelOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_outputs.py#L21</source><parameters>[{"name": "sample", "val": ": torch.Tensor"}]</parameters><paramsdesc>- **sample** (`torch.Tensor` of shape `(batch_size, num_channels, height, width)` or `(batch size, num_vector_embeds - 1, num_latent_pixels)` if [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel) is discrete) --
  The hidden states output conditioned on the `encoder_hidden_states` input. If discrete, returns probability
  distributions for the unnoised latent pixels.</paramsdesc><paramgroups>0</paramgroups></docstring>

The output of [Transformer2DModel](/docs/diffusers/main/en/api/models/transformer2d#diffusers.Transformer2DModel).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/mochi_transformer3d.md" />