# OmniGenTransformer2DModel

A Transformer model that accepts multimodal instructions to generate images for [OmniGen](https://github.com/VectorSpaceLab/OmniGen/).

The abstract from the paper is:

*The emergence of Large Language Models (LLMs) has unified language  generation tasks and revolutionized human-machine interaction.  However, in the realm of image generation, a unified model capable of handling various tasks within a single framework remains largely unexplored. In this work, we introduce OmniGen, a new diffusion model for unified image generation. OmniGen is characterized by the following features: 1) Unification: OmniGen not only demonstrates text-to-image generation capabilities but also inherently supports various downstream tasks, such as image editing, subject-driven generation, and visual conditional generation. 2) Simplicity: The architecture of OmniGen is highly simplified, eliminating the need for additional plugins. Moreover, compared to existing diffusion models, it is more user-friendly and can complete complex tasks end-to-end through instructions without the need for extra intermediate steps, greatly simplifying the image generation workflow. 3) Knowledge Transfer: Benefit from learning in a unified format, OmniGen effectively transfers knowledge across different tasks, manages unseen tasks and domains, and exhibits novel capabilities. We also explore the model’s reasoning capabilities and potential applications of the chain-of-thought mechanism.  This work represents the first attempt at a general-purpose image generation model,  and we will release our resources at https://github.com/VectorSpaceLab/OmniGen to foster future advancements.*

```python
import torch
from diffusers import OmniGenTransformer2DModel

transformer = OmniGenTransformer2DModel.from_pretrained("Shitao/OmniGen-v1-diffusers", subfolder="transformer", torch_dtype=torch.bfloat16)
```

## OmniGenTransformer2DModel[[diffusers.OmniGenTransformer2DModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.OmniGenTransformer2DModel</name><anchor>diffusers.OmniGenTransformer2DModel</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformers/transformer_omnigen.py#L284</source><parameters>[{"name": "in_channels", "val": ": int = 4"}, {"name": "patch_size", "val": ": int = 2"}, {"name": "hidden_size", "val": ": int = 3072"}, {"name": "rms_norm_eps", "val": ": float = 1e-05"}, {"name": "num_attention_heads", "val": ": int = 32"}, {"name": "num_key_value_heads", "val": ": int = 32"}, {"name": "intermediate_size", "val": ": int = 8192"}, {"name": "num_layers", "val": ": int = 32"}, {"name": "pad_token_id", "val": ": int = 32000"}, {"name": "vocab_size", "val": ": int = 32064"}, {"name": "max_position_embeddings", "val": ": int = 131072"}, {"name": "original_max_position_embeddings", "val": ": int = 4096"}, {"name": "rope_base", "val": ": int = 10000"}, {"name": "rope_scaling", "val": ": typing.Dict = None"}, {"name": "pos_embed_max_size", "val": ": int = 192"}, {"name": "time_step_dim", "val": ": int = 256"}, {"name": "flip_sin_to_cos", "val": ": bool = True"}, {"name": "downscale_freq_shift", "val": ": int = 0"}, {"name": "timestep_activation_fn", "val": ": str = 'silu'"}]</parameters><paramsdesc>- **in_channels** (`int`, defaults to `4`) --
  The number of channels in the input.
- **patch_size** (`int`, defaults to `2`) --
  The size of the spatial patches to use in the patch embedding layer.
- **hidden_size** (`int`, defaults to `3072`) --
  The dimensionality of the hidden layers in the model.
- **rms_norm_eps** (`float`, defaults to `1e-5`) --
  Eps for RMSNorm layer.
- **num_attention_heads** (`int`, defaults to `32`) --
  The number of heads to use for multi-head attention.
- **num_key_value_heads** (`int`, defaults to `32`) --
  The number of heads to use for keys and values in multi-head attention.
- **intermediate_size** (`int`, defaults to `8192`) --
  Dimension of the hidden layer in FeedForward layers.
- **num_layers** (`int`, default to `32`) --
  The number of layers of transformer blocks to use.
- **pad_token_id** (`int`, default to `32000`) --
  The id of the padding token.
- **vocab_size** (`int`, default to `32064`) --
  The size of the vocabulary of the embedding vocabulary.
- **rope_base** (`int`, default to `10000`) --
  The default theta value to use when creating RoPE.
- **rope_scaling** (`Dict`, optional) --
  The scaling factors for the RoPE. Must contain `short_factor` and `long_factor`.
- **pos_embed_max_size** (`int`, default to `192`) --
  The maximum size of the positional embeddings.
- **time_step_dim** (`int`, default to `256`) --
  Output dimension of timestep embeddings.
- **flip_sin_to_cos** (`bool`, default to `True`) --
  Whether to flip the sin and cos in the positional embeddings when preparing timestep embeddings.
- **downscale_freq_shift** (`int`, default to `0`) --
  The frequency shift to use when downscaling the timestep embeddings.
- **timestep_activation_fn** (`str`, default to `silu`) --
  The activation function to use for the timestep embeddings.</paramsdesc><paramgroups>0</paramgroups></docstring>

The Transformer model introduced in OmniGen (https://huggingface.co/papers/2409.11340).




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/omnigen_transformer.md" />