# Components and configs

## ComponentSpec[[diffusers.ComponentSpec]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ComponentSpec</name><anchor>diffusers.ComponentSpec</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L71</source><parameters>[{"name": "name", "val": ": typing.Optional[str] = None"}, {"name": "type_hint", "val": ": typing.Optional[typing.Type] = None"}, {"name": "description", "val": ": typing.Optional[str] = None"}, {"name": "config", "val": ": typing.Optional[diffusers.configuration_utils.FrozenDict] = None"}, {"name": "repo", "val": ": typing.Union[str, typing.List[str], NoneType] = None"}, {"name": "subfolder", "val": ": typing.Optional[str] = ''"}, {"name": "variant", "val": ": typing.Optional[str] = None"}, {"name": "revision", "val": ": typing.Optional[str] = None"}, {"name": "default_creation_method", "val": ": typing.Literal['from_config', 'from_pretrained'] = 'from_pretrained'"}]</parameters><paramsdesc>- **name** -- Name of the component
- **type_hint** -- Type of the component (e.g. UNet2DConditionModel)
- **description** -- Optional description of the component
- **config** -- Optional config dict for __init__ creation
- **repo** -- Optional repo path for from_pretrained creation
- **subfolder** -- Optional subfolder in repo
- **variant** -- Optional variant in repo
- **revision** -- Optional revision in repo
- **default_creation_method** -- Preferred creation method - "from_config" or "from_pretrained"</paramsdesc><paramgroups>0</paramgroups></docstring>
Specification for a pipeline component.

A component can be created in two ways:
1. From scratch using __init__ with a config dict
2. using `from_pretrained`





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>create</name><anchor>diffusers.ComponentSpec.create</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L232</source><parameters>[{"name": "config", "val": ": typing.Union[diffusers.configuration_utils.FrozenDict, typing.Dict[str, typing.Any], NoneType] = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>
Create component using from_config with config.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>decode_load_id</name><anchor>diffusers.ComponentSpec.decode_load_id</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L194</source><parameters>[{"name": "load_id", "val": ": str"}]</parameters><paramsdesc>- **load_id** -- The load_id string to decode, format: "repo|subfolder|variant|revision"
  where None values are represented as "null"</paramsdesc><paramgroups>0</paramgroups><retdesc>Dict mapping loading field names to their values. e.g. {
"repo": "path/to/repo", "subfolder": "subfolder", "variant": "variant", "revision": "revision"
} If a segment value is "null", it's replaced with None. Returns None if load_id is "null" (indicating
component not created with `load` method).</retdesc></docstring>

Decode a load_id string back into a dictionary of loading fields and values.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_component</name><anchor>diffusers.ComponentSpec.from_component</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L115</source><parameters>[{"name": "name", "val": ": str"}, {"name": "component", "val": ": typing.Any"}]</parameters><paramsdesc>- **name** -- Name of the component
- **component** -- Component object to create spec from</paramsdesc><paramgroups>0</paramgroups><retdesc>ComponentSpec object</retdesc><raises>- ``ValueError`` -- If component is not supported (e.g. nn.Module without load_id, non-ConfigMixin)</raises><raisederrors>``ValueError``</raisederrors></docstring>
Create a ComponentSpec from a Component.

Currently supports:
- Components created with `ComponentSpec.load()` method
- Components that are ConfigMixin subclasses but not nn.Modules (e.g. schedulers, guiders)










</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>load</name><anchor>diffusers.ComponentSpec.load</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L260</source><parameters>[{"name": "**kwargs", "val": ""}]</parameters></docstring>
Load component using from_pretrained.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>loading_fields</name><anchor>diffusers.ComponentSpec.loading_fields</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L175</source><parameters>[]</parameters></docstring>

Return the names of all loading‐related fields (i.e. those whose field.metadata["loading"] is True).


</div></div>

## ConfigSpec[[diffusers.modular_pipelines.ConfigSpec]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.ConfigSpec</name><anchor>diffusers.modular_pipelines.ConfigSpec</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L298</source><parameters>[{"name": "name", "val": ": str"}, {"name": "default", "val": ": typing.Any"}, {"name": "description", "val": ": typing.Optional[str] = None"}]</parameters></docstring>
Specification for a pipeline configuration parameter.

</div>

## ComponentsManager[[diffusers.ComponentsManager]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ComponentsManager</name><anchor>diffusers.ComponentsManager</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L281</source><parameters>[]</parameters></docstring>

A central registry and management system for model components across multiple pipelines.

[ComponentsManager](/docs/diffusers/main/en/api/modular_diffusers/pipeline_components#diffusers.ComponentsManager) provides a unified way to register, track, and reuse model components (like UNet, VAE, text
encoders, etc.) across different modular pipelines. It includes features for duplicate detection, memory
management, and component organization.

> [!WARNING] > This is an experimental feature and is likely to change in the future.

<ExampleCodeBlock anchor="diffusers.ComponentsManager.example">

Example:
```python
from diffusers import ComponentsManager

# Create a components manager
cm = ComponentsManager()

# Add components
cm.add("unet", unet_model, collection="sdxl")
cm.add("vae", vae_model, collection="sdxl")

# Enable auto offloading
cm.enable_auto_cpu_offload()

# Retrieve components
unet = cm.get_one(name="unet", collection="sdxl")
```

</ExampleCodeBlock>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>add</name><anchor>diffusers.ComponentsManager.add</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L374</source><parameters>[{"name": "name", "val": ": str"}, {"name": "component", "val": ": typing.Any"}, {"name": "collection", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **name** (str) -- The name of the component
- **component** (Any) -- The component to add
- **collection** (Optional[str]) -- The collection to add the component to</paramsdesc><paramgroups>0</paramgroups><rettype>str</rettype><retdesc>The unique component ID, which is generated as "{name}_{id(component)}" where
id(component) is Python's built-in unique identifier for the object</retdesc></docstring>

Add a component to the ComponentsManager.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>disable_auto_cpu_offload</name><anchor>diffusers.ComponentsManager.disable_auto_cpu_offload</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L729</source><parameters>[]</parameters></docstring>

Disable automatic CPU offloading for all components.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>enable_auto_cpu_offload</name><anchor>diffusers.ComponentsManager.enable_auto_cpu_offload</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L682</source><parameters>[{"name": "device", "val": ": typing.Union[str, int, torch.device] = None"}, {"name": "memory_reserve_margin", "val": " = '3GB'"}]</parameters><paramsdesc>- **device** (Union[str, int, torch.device]) -- The execution device where models are moved for forward passes
- **memory_reserve_margin** (str) -- The memory reserve margin to use, default is 3GB. This is the amount of
  memory to keep free on the device to avoid running out of memory during model
  execution (e.g., for intermediate activations, gradients, etc.)</paramsdesc><paramgroups>0</paramgroups></docstring>

Enable automatic CPU offloading for all components.

The algorithm works as follows:
1. All models start on CPU by default
2. When a model's forward pass is called, it's moved to the execution device
3. If there's insufficient memory, other models on the device are moved back to CPU
4. The system tries to offload the smallest combination of models that frees enough memory
5. Models stay on the execution device until another model needs memory and forces them off




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_components_by_ids</name><anchor>diffusers.ComponentsManager.get_components_by_ids</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L1023</source><parameters>[{"name": "ids", "val": ": typing.List[str]"}, {"name": "return_dict_with_names", "val": ": typing.Optional[bool] = True"}]</parameters><paramsdesc>- **ids** (List[str]) --
  List of component IDs
- **return_dict_with_names** (Optional[bool]) --
  Whether to return a dictionary with component names as keys:</paramsdesc><paramgroups>0</paramgroups><rettype>Dict[str, Any]</rettype><retdesc>Dictionary of components.
- If return_dict_with_names=True, keys are component names.
- If return_dict_with_names=False, keys are component IDs.</retdesc><raises>- ``ValueError`` -- If duplicate component names are found in the search results when return_dict_with_names=True</raises><raisederrors>``ValueError``</raisederrors></docstring>

Get components by a list of IDs.












</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_components_by_names</name><anchor>diffusers.ComponentsManager.get_components_by_names</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L1056</source><parameters>[{"name": "names", "val": ": typing.List[str]"}, {"name": "collection", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **names** (List[str]) -- List of component names
- **collection** (Optional[str]) -- Optional collection to filter by</paramsdesc><paramgroups>0</paramgroups><rettype>Dict[str, Any]</rettype><retdesc>Dictionary of components with component names as keys</retdesc><raises>- ``ValueError`` -- If duplicate component names are found in the search results</raises><raisederrors>``ValueError``</raisederrors></docstring>

Get components by a list of names, optionally filtered by collection.












</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_ids</name><anchor>diffusers.ComponentsManager.get_ids</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L1005</source><parameters>[{"name": "names", "val": ": typing.Union[str, typing.List[str]] = None"}, {"name": "collection", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **names** (Union[str, List[str]]) -- List of component names
- **collection** (Optional[str]) -- Optional collection to filter by</paramsdesc><paramgroups>0</paramgroups><rettype>List[str]</rettype><retdesc>List of component IDs</retdesc></docstring>

Get component IDs by a list of names, optionally filtered by collection.








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_model_info</name><anchor>diffusers.ComponentsManager.get_model_info</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L746</source><parameters>[{"name": "component_id", "val": ": str"}, {"name": "fields", "val": ": typing.Union[str, typing.List[str], NoneType] = None"}]</parameters><paramsdesc>- **component_id** (str) -- Name of the component to get info for
- **fields** (Optional[Union[str, List[str]]]) --
  Field(s) to return. Can be a string for single field or list of fields. If None, uses the
  available_info_fields setting.</paramsdesc><paramgroups>0</paramgroups><retdesc>Dictionary containing requested component metadata. If fields is specified, returns only those fields.
Otherwise, returns all fields.</retdesc></docstring>
Get comprehensive information about a component.






</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_one</name><anchor>diffusers.ComponentsManager.get_one</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L960</source><parameters>[{"name": "component_id", "val": ": typing.Optional[str] = None"}, {"name": "name", "val": ": typing.Optional[str] = None"}, {"name": "collection", "val": ": typing.Optional[str] = None"}, {"name": "load_id", "val": ": typing.Optional[str] = None"}]</parameters><paramsdesc>- **component_id** (Optional[str]) -- Optional component ID to get
- **name** (Optional[str]) -- Component name or pattern
- **collection** (Optional[str]) -- Optional collection to filter by
- **load_id** (Optional[str]) -- Optional load_id to filter by</paramsdesc><paramgroups>0</paramgroups><retdesc>A single component</retdesc><raises>- ``ValueError`` -- If no components match or multiple components match</raises><raisederrors>``ValueError``</raisederrors></docstring>

Get a single component by either:
- searching name (pattern matching), collection, or load_id.
- passing in a component_id
Raises an error if multiple components match or none are found.










</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>remove</name><anchor>diffusers.ComponentsManager.remove</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L463</source><parameters>[{"name": "component_id", "val": ": str = None"}]</parameters><paramsdesc>- **component_id** (str) -- The ID of the component to remove</paramsdesc><paramgroups>0</paramgroups></docstring>

Remove a component from the ComponentsManager.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>remove_from_collection</name><anchor>diffusers.ComponentsManager.remove_from_collection</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L445</source><parameters>[{"name": "component_id", "val": ": str"}, {"name": "collection", "val": ": str"}]</parameters></docstring>

Remove a component from a collection.


</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>search_components</name><anchor>diffusers.ComponentsManager.search_components</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/components_manager.py#L496</source><parameters>[{"name": "names", "val": ": typing.Optional[str] = None"}, {"name": "collection", "val": ": typing.Optional[str] = None"}, {"name": "load_id", "val": ": typing.Optional[str] = None"}, {"name": "return_dict_with_names", "val": ": bool = True"}]</parameters><paramsdesc>- **names** -- Component name(s) or pattern(s)
  Patterns:
  - "unet" : match any component with base name "unet" (e.g., unet_123abc)
  - "!unet" : everything except components with base name "unet"
  - "unet*" : anything with base name starting with "unet"
  - "!unet*" : anything with base name NOT starting with "unet"
  - "*unet*" : anything with base name containing "unet"
  - "!*unet*" : anything with base name NOT containing "unet"
  - "refiner|vae|unet" : anything with base name exactly matching "refiner", "vae", or "unet"
  - "!refiner|vae|unet" : anything with base name NOT exactly matching "refiner", "vae", or "unet"
  - "unet*|vae*" : anything with base name starting with "unet" OR starting with "vae"
- **collection** -- Optional collection to filter by
- **load_id** -- Optional load_id to filter by
- **return_dict_with_names** --
  If True, returns a dictionary with component names as keys, throw an error if
  multiple components with the same name are found If False, returns a dictionary
  with component IDs as keys</paramsdesc><paramgroups>0</paramgroups><retdesc>Dictionary mapping component names to components if return_dict_with_names=True, or a dictionary mapping
component IDs to components if return_dict_with_names=False</retdesc></docstring>

Search components by name with simple pattern matching. Optionally filter by collection or load_id.






</div></div>

## InsertableDict[[diffusers.modular_pipelines.InsertableDict]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.modular_pipelines.InsertableDict</name><anchor>diffusers.modular_pipelines.InsertableDict</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/modular_pipelines/modular_pipeline_utils.py#L33</source><parameters>""</parameters></docstring>


</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/modular_diffusers/pipeline_components.md" />