# unCLIP

[Hierarchical Text-Conditional Image Generation with CLIP Latents](https://huggingface.co/papers/2204.06125) is by Aditya Ramesh, Prafulla Dhariwal, Alex Nichol, Casey Chu, Mark Chen. The unCLIP model in 🤗 Diffusers comes from kakaobrain's [karlo](https://github.com/kakaobrain/karlo).

The abstract from the paper is following:

*Contrastive models like CLIP have been shown to learn robust representations of images that capture both semantics and style. To leverage these representations for image generation, we propose a two-stage model: a prior that generates a CLIP image embedding given a text caption, and a decoder that generates an image conditioned on the image embedding. We show that explicitly generating image representations improves image diversity with minimal loss in photorealism and caption similarity. Our decoders conditioned on image representations can also produce variations of an image that preserve both its semantics and style, while varying the non-essential details absent from the image representation. Moreover, the joint embedding space of CLIP enables language-guided image manipulations in a zero-shot fashion. We use diffusion models for the decoder and experiment with both autoregressive and diffusion models for the prior, finding that the latter are computationally more efficient and produce higher-quality samples.*

You can find lucidrains' DALL-E 2 recreation at [lucidrains/DALLE2-pytorch](https://github.com/lucidrains/DALLE2-pytorch).

> [!TIP]
> Make sure to check out the Schedulers [guide](../../using-diffusers/schedulers) to learn how to explore the tradeoff between scheduler speed and quality, and see the [reuse components across pipelines](../../using-diffusers/loading#reuse-a-pipeline) section to learn how to efficiently load the same components into multiple pipelines.

## UnCLIPPipeline[[diffusers.UnCLIPPipeline]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.UnCLIPPipeline</name><anchor>diffusers.UnCLIPPipeline</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unclip/pipeline_unclip.py#L41</source><parameters>[{"name": "prior", "val": ": PriorTransformer"}, {"name": "decoder", "val": ": UNet2DConditionModel"}, {"name": "text_encoder", "val": ": CLIPTextModelWithProjection"}, {"name": "tokenizer", "val": ": CLIPTokenizer"}, {"name": "text_proj", "val": ": UnCLIPTextProjModel"}, {"name": "super_res_first", "val": ": UNet2DModel"}, {"name": "super_res_last", "val": ": UNet2DModel"}, {"name": "prior_scheduler", "val": ": UnCLIPScheduler"}, {"name": "decoder_scheduler", "val": ": UnCLIPScheduler"}, {"name": "super_res_scheduler", "val": ": UnCLIPScheduler"}]</parameters><paramsdesc>- **text_encoder** ([CLIPTextModelWithProjection](https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection)) --
  Frozen text-encoder.
- **tokenizer** ([CLIPTokenizer](https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer)) --
  A `CLIPTokenizer` to tokenize text.
- **prior** ([PriorTransformer](/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer)) --
  The canonical unCLIP prior to approximate the image embedding from the text embedding.
- **text_proj** (`UnCLIPTextProjModel`) --
  Utility class to prepare and combine the embeddings before they are passed to the decoder.
- **decoder** ([UNet2DConditionModel](/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel)) --
  The decoder to invert the image embedding into an image.
- **super_res_first** ([UNet2DModel](/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel)) --
  Super resolution UNet. Used in all but the last step of the super resolution diffusion process.
- **super_res_last** ([UNet2DModel](/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel)) --
  Super resolution UNet. Used in the last step of the super resolution diffusion process.
- **prior_scheduler** (`UnCLIPScheduler`) --
  Scheduler used in the prior denoising process (a modified [DDPMScheduler](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler)).
- **decoder_scheduler** (`UnCLIPScheduler`) --
  Scheduler used in the decoder denoising process (a modified [DDPMScheduler](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler)).
- **super_res_scheduler** (`UnCLIPScheduler`) --
  Scheduler used in the super resolution denoising process (a modified [DDPMScheduler](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler)).</paramsdesc><paramgroups>0</paramgroups></docstring>

Pipeline for text-to-image generation using unCLIP.

This model inherits from [DiffusionPipeline](/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline). Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__call__</name><anchor>diffusers.UnCLIPPipeline.__call__</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unclip/pipeline_unclip.py#L219</source><parameters>[{"name": "prompt", "val": ": typing.Union[str, typing.List[str], NoneType] = None"}, {"name": "num_images_per_prompt", "val": ": int = 1"}, {"name": "prior_num_inference_steps", "val": ": int = 25"}, {"name": "decoder_num_inference_steps", "val": ": int = 25"}, {"name": "super_res_num_inference_steps", "val": ": int = 7"}, {"name": "generator", "val": ": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"}, {"name": "prior_latents", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "decoder_latents", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "super_res_latents", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "text_model_output", "val": ": typing.Union[transformers.models.clip.modeling_clip.CLIPTextModelOutput, typing.Tuple, NoneType] = None"}, {"name": "text_attention_mask", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "prior_guidance_scale", "val": ": float = 4.0"}, {"name": "decoder_guidance_scale", "val": ": float = 8.0"}, {"name": "output_type", "val": ": typing.Optional[str] = 'pil'"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **prompt** (`str` or `List[str]`) --
  The prompt or prompts to guide image generation. This can only be left undefined if `text_model_output`
  and `text_attention_mask` is passed.
- **num_images_per_prompt** (`int`, *optional*, defaults to 1) --
  The number of images to generate per prompt.
- **prior_num_inference_steps** (`int`, *optional*, defaults to 25) --
  The number of denoising steps for the prior. More denoising steps usually lead to a higher quality
  image at the expense of slower inference.
- **decoder_num_inference_steps** (`int`, *optional*, defaults to 25) --
  The number of denoising steps for the decoder. More denoising steps usually lead to a higher quality
  image at the expense of slower inference.
- **super_res_num_inference_steps** (`int`, *optional*, defaults to 7) --
  The number of denoising steps for super resolution. More denoising steps usually lead to a higher
  quality image at the expense of slower inference.
- **generator** (`torch.Generator` or `List[torch.Generator]`, *optional*) --
  A [`torch.Generator`](https://pytorch.org/docs/stable/generated/torch.Generator.html) to make
  generation deterministic.
- **prior_latents** (`torch.Tensor` of shape (batch size, embeddings dimension), *optional*) --
  Pre-generated noisy latents to be used as inputs for the prior.
- **decoder_latents** (`torch.Tensor` of shape (batch size, channels, height, width), *optional*) --
  Pre-generated noisy latents to be used as inputs for the decoder.
- **super_res_latents** (`torch.Tensor` of shape (batch size, channels, super res height, super res width), *optional*) --
  Pre-generated noisy latents to be used as inputs for the decoder.
- **prior_guidance_scale** (`float`, *optional*, defaults to 4.0) --
  A higher guidance scale value encourages the model to generate images closely linked to the text
  `prompt` at the expense of lower image quality. Guidance scale is enabled when `guidance_scale > 1`.
- **decoder_guidance_scale** (`float`, *optional*, defaults to 4.0) --
  A higher guidance scale value encourages the model to generate images closely linked to the text
  `prompt` at the expense of lower image quality. Guidance scale is enabled when `guidance_scale > 1`.
- **text_model_output** (`CLIPTextModelOutput`, *optional*) --
  Pre-defined `CLIPTextModel` outputs that can be derived from the text encoder. Pre-defined text
  outputs can be passed for tasks like text embedding interpolations. Make sure to also pass
  `text_attention_mask` in this case. `prompt` can the be left `None`.
- **text_attention_mask** (`torch.Tensor`, *optional*) --
  Pre-defined CLIP text attention mask that can be derived from the tokenizer. Pre-defined text attention
  masks are necessary when passing `text_model_output`.
- **output_type** (`str`, *optional*, defaults to `"pil"`) --
  The output format of the generated image. Choose between `PIL.Image` or `np.array`.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a [ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput) instead of a plain tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>[ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput) or `tuple`</rettype><retdesc>If `return_dict` is `True`, [ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput) is returned, otherwise a `tuple` is
returned where the first element is a list with the generated images.</retdesc></docstring>

The call function to the pipeline for generation.








</div></div>

## UnCLIPImageVariationPipeline[[diffusers.UnCLIPImageVariationPipeline]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.UnCLIPImageVariationPipeline</name><anchor>diffusers.UnCLIPImageVariationPipeline</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unclip/pipeline_unclip_image_variation.py#L46</source><parameters>[{"name": "decoder", "val": ": UNet2DConditionModel"}, {"name": "text_encoder", "val": ": CLIPTextModelWithProjection"}, {"name": "tokenizer", "val": ": CLIPTokenizer"}, {"name": "text_proj", "val": ": UnCLIPTextProjModel"}, {"name": "feature_extractor", "val": ": CLIPImageProcessor"}, {"name": "image_encoder", "val": ": CLIPVisionModelWithProjection"}, {"name": "super_res_first", "val": ": UNet2DModel"}, {"name": "super_res_last", "val": ": UNet2DModel"}, {"name": "decoder_scheduler", "val": ": UnCLIPScheduler"}, {"name": "super_res_scheduler", "val": ": UnCLIPScheduler"}]</parameters><paramsdesc>- **text_encoder** ([CLIPTextModelWithProjection](https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection)) --
  Frozen text-encoder.
- **tokenizer** ([CLIPTokenizer](https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer)) --
  A `CLIPTokenizer` to tokenize text.
- **feature_extractor** ([CLIPImageProcessor](https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor)) --
  Model that extracts features from generated images to be used as inputs for the `image_encoder`.
- **image_encoder** ([CLIPVisionModelWithProjection](https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection)) --
  Frozen CLIP image-encoder ([clip-vit-large-patch14](https://huggingface.co/openai/clip-vit-large-patch14)).
- **text_proj** (`UnCLIPTextProjModel`) --
  Utility class to prepare and combine the embeddings before they are passed to the decoder.
- **decoder** ([UNet2DConditionModel](/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel)) --
  The decoder to invert the image embedding into an image.
- **super_res_first** ([UNet2DModel](/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel)) --
  Super resolution UNet. Used in all but the last step of the super resolution diffusion process.
- **super_res_last** ([UNet2DModel](/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel)) --
  Super resolution UNet. Used in the last step of the super resolution diffusion process.
- **decoder_scheduler** (`UnCLIPScheduler`) --
  Scheduler used in the decoder denoising process (a modified [DDPMScheduler](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler)).
- **super_res_scheduler** (`UnCLIPScheduler`) --
  Scheduler used in the super resolution denoising process (a modified [DDPMScheduler](/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler)).</paramsdesc><paramgroups>0</paramgroups></docstring>

Pipeline to generate image variations from an input image using UnCLIP.

This model inherits from [DiffusionPipeline](/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline). Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).





<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__call__</name><anchor>diffusers.UnCLIPImageVariationPipeline.__call__</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/unclip/pipeline_unclip_image_variation.py#L207</source><parameters>[{"name": "image", "val": ": typing.Union[PIL.Image.Image, typing.List[PIL.Image.Image], torch.Tensor, NoneType] = None"}, {"name": "num_images_per_prompt", "val": ": int = 1"}, {"name": "decoder_num_inference_steps", "val": ": int = 25"}, {"name": "super_res_num_inference_steps", "val": ": int = 7"}, {"name": "generator", "val": ": typing.Optional[torch._C.Generator] = None"}, {"name": "decoder_latents", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "super_res_latents", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "image_embeddings", "val": ": typing.Optional[torch.Tensor] = None"}, {"name": "decoder_guidance_scale", "val": ": float = 8.0"}, {"name": "output_type", "val": ": typing.Optional[str] = 'pil'"}, {"name": "return_dict", "val": ": bool = True"}]</parameters><paramsdesc>- **image** (`PIL.Image.Image` or `List[PIL.Image.Image]` or `torch.Tensor`) --
  `Image` or tensor representing an image batch to be used as the starting point. If you provide a
  tensor, it needs to be compatible with the `CLIPImageProcessor`
  [configuration](https://huggingface.co/fusing/karlo-image-variations-diffusers/blob/main/feature_extractor/preprocessor_config.json).
  Can be left as `None` only when `image_embeddings` are passed.
- **num_images_per_prompt** (`int`, *optional*, defaults to 1) --
  The number of images to generate per prompt.
- **decoder_num_inference_steps** (`int`, *optional*, defaults to 25) --
  The number of denoising steps for the decoder. More denoising steps usually lead to a higher quality
  image at the expense of slower inference.
- **super_res_num_inference_steps** (`int`, *optional*, defaults to 7) --
  The number of denoising steps for super resolution. More denoising steps usually lead to a higher
  quality image at the expense of slower inference.
- **generator** (`torch.Generator`, *optional*) --
  A [`torch.Generator`](https://pytorch.org/docs/stable/generated/torch.Generator.html) to make
  generation deterministic.
- **decoder_latents** (`torch.Tensor` of shape (batch size, channels, height, width), *optional*) --
  Pre-generated noisy latents to be used as inputs for the decoder.
- **super_res_latents** (`torch.Tensor` of shape (batch size, channels, super res height, super res width), *optional*) --
  Pre-generated noisy latents to be used as inputs for the decoder.
- **decoder_guidance_scale** (`float`, *optional*, defaults to 4.0) --
  A higher guidance scale value encourages the model to generate images closely linked to the text
  `prompt` at the expense of lower image quality. Guidance scale is enabled when `guidance_scale > 1`.
- **image_embeddings** (`torch.Tensor`, *optional*) --
  Pre-defined image embeddings that can be derived from the image encoder. Pre-defined image embeddings
  can be passed for tasks like image interpolations. `image` can be left as `None`.
- **output_type** (`str`, *optional*, defaults to `"pil"`) --
  The output format of the generated image. Choose between `PIL.Image` or `np.array`.
- **return_dict** (`bool`, *optional*, defaults to `True`) --
  Whether or not to return a [ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput) instead of a plain tuple.</paramsdesc><paramgroups>0</paramgroups><rettype>[ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput) or `tuple`</rettype><retdesc>If `return_dict` is `True`, [ImagePipelineOutput](/docs/diffusers/main/en/api/pipelines/dit#diffusers.ImagePipelineOutput) is returned, otherwise a `tuple` is
returned where the first element is a list with the generated images.</retdesc></docstring>

The call function to the pipeline for generation.








</div></div>

## ImagePipelineOutput[[diffusers.ImagePipelineOutput]]
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class diffusers.ImagePipelineOutput</name><anchor>diffusers.ImagePipelineOutput</anchor><source>https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L118</source><parameters>[{"name": "images", "val": ": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}]</parameters><paramsdesc>- **images** (`List[PIL.Image.Image]` or `np.ndarray`) --
  List of denoised PIL images of length `batch_size` or NumPy array of shape `(batch_size, height, width,
  num_channels)`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Output class for image pipelines.




</div>

<EditOnGithub source="https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/unclip.md" />