import{s as jl,f as Tl,o as Cl,n as vl}from"../chunks/scheduler.f6319a2a.js";import{S as $l,i as Il,g as n,s,r as u,A as Zl,h as i,f as l,c as a,j as Ul,u as d,x as r,k as Rt,y as _l,a as o,v as h,d as m,t as c,w as M}from"../chunks/index.85aa684c.js";import{T as Jl}from"../chunks/Tip.3d397a88.js";import{C as b}from"../chunks/CodeBlock.97b48fd2.js";import{D as Hl}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as w,E as Gl}from"../chunks/EditOnGithub.006048dd.js";function kl(je){let p,f='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){p=n("p"),p.innerHTML=f},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p1d9vw"&&(p.innerHTML=f)},m(y,g){o(y,p,g)},p:vl,d(y){y&&l(p)}}}function xl(je){let p,f="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){p=n("p"),p.textContent=f},l(y){p=i(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-h9mzfm"&&(p.textContent=f)},m(y,g){o(y,p,g)},p:vl,d(y){y&&l(p)}}}function Bl(je){let p,f,y,g,J,Ze,v,_e,j,Vt="Here, we’re going to see advanced tool usage.",He,T,Ge,C,Wt='<li><a href="#tools">Tools</a><ul><li><a href="#what-is-a-tool-and-how-to-build-one">What is a tool, and how to build one?</a></li> <li><a href="#share-your-tool-to-the-hub">Share your tool to the Hub</a></li> <li><a href="#import-a-space-as-a-tool">Import a Space as a tool</a></li> <li><a href="#use-langchain-tools">Use LangChain tools</a></li> <li><a href="#manage-your-agents-toolbox">Manage your agent’s toolbox</a></li> <li><a href="#use-a-collection-of-tools">Use a collection of tools</a></li></ul></li>',ke,$,xe,I,Et="A tool is mostly a function that an LLM can use in an agentic system.",Be,Z,Qt="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Re,_,At="So it cannot be only a function. It should be a class.",Ve,H,Nt="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",We,G,Ft="Here’s how it looks:",Ee,k,Qe,x,St='The custom tool subclasses <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',Ae,B,qt='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',Ne,R,Lt="And that’s all it needs to be used in an agent!",Fe,V,Xt='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/main/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',Se,W,Yt='In this case, you can build your tool by subclassing <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool">Tool</a> as described above.',qe,E,Le,Q,zt='You can share your custom tool to the Hub by calling <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',Xe,A,Ye,N,Pt="For the push to Hub to work, your tool will need to respect some rules:",ze,F,Kt='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',Pe,S,Dt='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',Ke,q,Ot='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',De,L,el=`Then you can load the tool with <a href="/docs/smolagents/main/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,Oe,X,et,Y,tt,z,tl='You can directly import a Space from the Hub as a tool using the <a href="/docs/smolagents/main/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',lt,P,ll='You only need to provide the id of the Space on the Hub, its name, and a description that will help you agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',ot,K,ol='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',st,D,at,O,sl="And voilà, here’s your image! 🏖️",nt,Ce,al,it,ee,nl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt  <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",rt,te,pt,le,ut,$e,il,dt,oe,rl="How cool is this? 🤩",ht,se,mt,ae,pl=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,ct,ne,ul=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,Mt,ie,yt,re,bt,pe,dl="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",ft,ue,hl="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",wt,de,gt,he,ml="Now we can leverage the new tool:",Tt,me,Ut,U,Jt,ce,vt,Me,cl="You can leverage tool collections by using the <code>ToolCollection</code> object. It supports loading either a collection from the Hub or an MCP server tools.",jt,ye,Ct,be,Ml=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,$t,fe,It,we,yl="To speed up the start, tools are loaded only if called by the agent.",Zt,ge,_t,Te,bl='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Ht,Ue,fl="The MCP servers tools can be loaded in a <code>ToolCollection</code> object as follow:",Gt,Je,kt,ve,xt,Ie,Bt;return J=new w({props:{title:"Tools",local:"tools",headingTag:"h1"}}),v=new Hl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),T=new Jl({props:{warning:!1,$$slots:{default:[kl]},$$scope:{ctx:je}}}),$=new w({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),k=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),E=new w({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new b({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),X=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Y=new w({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),D=new b({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),te=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMHNwYWNlJTIwc3VpdCclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),le=new b({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),se=new w({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),ie=new b({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),re=new w({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),de=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEFhZ2VudC50b29scyU1Qm1vZGVsX2Rvd25sb2FkX3Rvb2wubmFtZSU1RCUyMCUzRCUyMG1vZGVsX2Rvd25sb2FkX3Rvb2w=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel

model = HfApiModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),me=new b({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),U=new Jl({props:{warning:!1,$$slots:{default:[xl]},$$scope:{ctx:je}}}),ce=new w({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),ye=new w({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),fe=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),ge=new w({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),Je=new b({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXYlMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEF3aXRoJTIwVG9vbENvbGxlY3Rpb24uZnJvbV9tY3Aoc2VydmVyX3BhcmFtZXRlcnMpJTIwYXMlMjB0b29sX2NvbGxlY3Rpb24lM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1Qip0b29sX2NvbGxlY3Rpb24udG9vbHMlNUQlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjBhJTIwcmVtZWR5JTIwZm9yJTIwaGFuZ292ZXIuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uv&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ve=new Gl({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.mdx"}}),{c(){p=n("meta"),f=s(),y=n("p"),g=s(),u(J.$$.fragment),Ze=s(),u(v.$$.fragment),_e=s(),j=n("p"),j.textContent=Vt,He=s(),u(T.$$.fragment),Ge=s(),C=n("ul"),C.innerHTML=Wt,ke=s(),u($.$$.fragment),xe=s(),I=n("p"),I.textContent=Et,Be=s(),Z=n("p"),Z.textContent=Qt,Re=s(),_=n("p"),_.textContent=At,Ve=s(),H=n("p"),H.textContent=Nt,We=s(),G=n("p"),G.textContent=Ft,Ee=s(),u(k.$$.fragment),Qe=s(),x=n("p"),x.innerHTML=St,Ae=s(),B=n("ul"),B.innerHTML=qt,Ne=s(),R=n("p"),R.textContent=Lt,Fe=s(),V=n("p"),V.innerHTML=Xt,Se=s(),W=n("p"),W.innerHTML=Yt,qe=s(),u(E.$$.fragment),Le=s(),Q=n("p"),Q.innerHTML=zt,Xe=s(),u(A.$$.fragment),Ye=s(),N=n("p"),N.textContent=Pt,ze=s(),F=n("ul"),F.innerHTML=Kt,Pe=s(),S=n("p"),S.innerHTML=Dt,Ke=s(),q=n("p"),q.innerHTML=Ot,De=s(),L=n("p"),L.innerHTML=el,Oe=s(),u(X.$$.fragment),et=s(),u(Y.$$.fragment),tt=s(),z=n("p"),z.innerHTML=tl,lt=s(),P=n("p"),P.innerHTML=ll,ot=s(),K=n("p"),K.innerHTML=ol,st=s(),u(D.$$.fragment),at=s(),O=n("p"),O.textContent=sl,nt=s(),Ce=n("img"),it=s(),ee=n("p"),ee.innerHTML=nl,rt=s(),u(te.$$.fragment),pt=s(),u(le.$$.fragment),ut=s(),$e=n("img"),dt=s(),oe=n("p"),oe.textContent=rl,ht=s(),u(se.$$.fragment),mt=s(),ae=n("p"),ae.innerHTML=pl,ct=s(),ne=n("p"),ne.innerHTML=ul,Mt=s(),u(ie.$$.fragment),yt=s(),u(re.$$.fragment),bt=s(),pe=n("p"),pe.innerHTML=dl,ft=s(),ue=n("p"),ue.innerHTML=hl,wt=s(),u(de.$$.fragment),gt=s(),he=n("p"),he.textContent=ml,Tt=s(),u(me.$$.fragment),Ut=s(),u(U.$$.fragment),Jt=s(),u(ce.$$.fragment),vt=s(),Me=n("p"),Me.innerHTML=cl,jt=s(),u(ye.$$.fragment),Ct=s(),be=n("p"),be.textContent=Ml,$t=s(),u(fe.$$.fragment),It=s(),we=n("p"),we.textContent=yl,Zt=s(),u(ge.$$.fragment),_t=s(),Te=n("p"),Te.innerHTML=bl,Ht=s(),Ue=n("p"),Ue.innerHTML=fl,Gt=s(),u(Je.$$.fragment),kt=s(),u(ve.$$.fragment),xt=s(),Ie=n("p"),this.h()},l(e){const t=Zl("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),f=a(e),y=i(e,"P",{}),Ul(y).forEach(l),g=a(e),d(J.$$.fragment,e),Ze=a(e),d(v.$$.fragment,e),_e=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-8951oz"&&(j.textContent=Vt),He=a(e),d(T.$$.fragment,e),Ge=a(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-gdosxb"&&(C.innerHTML=Wt),ke=a(e),d($.$$.fragment,e),xe=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-50z9h0"&&(I.textContent=Et),Be=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1llqfcr"&&(Z.textContent=Qt),Re=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-eilpgu"&&(_.textContent=At),Ve=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-suz7fy"&&(H.textContent=Nt),We=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x18ywb"&&(G.textContent=Ft),Ee=a(e),d(k.$$.fragment,e),Qe=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-prn7f3"&&(x.innerHTML=St),Ae=a(e),B=i(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-xqgwuf"&&(B.innerHTML=qt),Ne=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-220ayw"&&(R.textContent=Lt),Fe=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-13idprj"&&(V.innerHTML=Xt),Se=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1lot62h"&&(W.innerHTML=Yt),qe=a(e),d(E.$$.fragment,e),Le=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1p4y3bf"&&(Q.innerHTML=zt),Xe=a(e),d(A.$$.fragment,e),Ye=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-hoocvd"&&(N.textContent=Pt),ze=a(e),F=i(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-cqj6gr"&&(F.innerHTML=Kt),Pe=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4n5s3c"&&(S.innerHTML=Dt),Ke=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1knl8v8"&&(q.innerHTML=Ot),De=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1skw0cc"&&(L.innerHTML=el),Oe=a(e),d(X.$$.fragment,e),et=a(e),d(Y.$$.fragment,e),tt=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-6y3nzn"&&(z.innerHTML=tl),lt=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1xkj0c9"&&(P.innerHTML=ll),ot=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1gucs20"&&(K.innerHTML=ol),st=a(e),d(D.$$.fragment,e),at=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-sgspwr"&&(O.textContent=sl),nt=a(e),Ce=i(e,"IMG",{src:!0}),it=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1qp1ya7"&&(ee.innerHTML=nl),rt=a(e),d(te.$$.fragment,e),pt=a(e),d(le.$$.fragment,e),ut=a(e),$e=i(e,"IMG",{src:!0}),dt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-i5dtbz"&&(oe.textContent=rl),ht=a(e),d(se.$$.fragment,e),mt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1rq40pf"&&(ae.innerHTML=pl),ct=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1g7jkvd"&&(ne.innerHTML=ul),Mt=a(e),d(ie.$$.fragment,e),yt=a(e),d(re.$$.fragment,e),bt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-69p3x"&&(pe.innerHTML=dl),ft=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-ocb8u2"&&(ue.innerHTML=hl),wt=a(e),d(de.$$.fragment,e),gt=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-o3ledg"&&(he.textContent=ml),Tt=a(e),d(me.$$.fragment,e),Ut=a(e),d(U.$$.fragment,e),Jt=a(e),d(ce.$$.fragment,e),vt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-8x945s"&&(Me.innerHTML=cl),jt=a(e),d(ye.$$.fragment,e),Ct=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-qubpc6"&&(be.textContent=Ml),$t=a(e),d(fe.$$.fragment,e),It=a(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-6r1jgt"&&(we.textContent=yl),Zt=a(e),d(ge.$$.fragment,e),_t=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1q39vf"&&(Te.innerHTML=bl),Ht=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-15ae6eh"&&(Ue.innerHTML=fl),Gt=a(e),d(Je.$$.fragment,e),kt=a(e),d(ve.$$.fragment,e),xt=a(e),Ie=i(e,"P",{}),Ul(Ie).forEach(l),this.h()},h(){Rt(p,"name","hf:doc:metadata"),Rt(p,"content",Rl),Tl(Ce.src,al="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||Rt(Ce,"src",al),Tl($e.src,il="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||Rt($e,"src",il)},m(e,t){_l(document.head,p),o(e,f,t),o(e,y,t),o(e,g,t),h(J,e,t),o(e,Ze,t),h(v,e,t),o(e,_e,t),o(e,j,t),o(e,He,t),h(T,e,t),o(e,Ge,t),o(e,C,t),o(e,ke,t),h($,e,t),o(e,xe,t),o(e,I,t),o(e,Be,t),o(e,Z,t),o(e,Re,t),o(e,_,t),o(e,Ve,t),o(e,H,t),o(e,We,t),o(e,G,t),o(e,Ee,t),h(k,e,t),o(e,Qe,t),o(e,x,t),o(e,Ae,t),o(e,B,t),o(e,Ne,t),o(e,R,t),o(e,Fe,t),o(e,V,t),o(e,Se,t),o(e,W,t),o(e,qe,t),h(E,e,t),o(e,Le,t),o(e,Q,t),o(e,Xe,t),h(A,e,t),o(e,Ye,t),o(e,N,t),o(e,ze,t),o(e,F,t),o(e,Pe,t),o(e,S,t),o(e,Ke,t),o(e,q,t),o(e,De,t),o(e,L,t),o(e,Oe,t),h(X,e,t),o(e,et,t),h(Y,e,t),o(e,tt,t),o(e,z,t),o(e,lt,t),o(e,P,t),o(e,ot,t),o(e,K,t),o(e,st,t),h(D,e,t),o(e,at,t),o(e,O,t),o(e,nt,t),o(e,Ce,t),o(e,it,t),o(e,ee,t),o(e,rt,t),h(te,e,t),o(e,pt,t),h(le,e,t),o(e,ut,t),o(e,$e,t),o(e,dt,t),o(e,oe,t),o(e,ht,t),h(se,e,t),o(e,mt,t),o(e,ae,t),o(e,ct,t),o(e,ne,t),o(e,Mt,t),h(ie,e,t),o(e,yt,t),h(re,e,t),o(e,bt,t),o(e,pe,t),o(e,ft,t),o(e,ue,t),o(e,wt,t),h(de,e,t),o(e,gt,t),o(e,he,t),o(e,Tt,t),h(me,e,t),o(e,Ut,t),h(U,e,t),o(e,Jt,t),h(ce,e,t),o(e,vt,t),o(e,Me,t),o(e,jt,t),h(ye,e,t),o(e,Ct,t),o(e,be,t),o(e,$t,t),h(fe,e,t),o(e,It,t),o(e,we,t),o(e,Zt,t),h(ge,e,t),o(e,_t,t),o(e,Te,t),o(e,Ht,t),o(e,Ue,t),o(e,Gt,t),h(Je,e,t),o(e,kt,t),h(ve,e,t),o(e,xt,t),o(e,Ie,t),Bt=!0},p(e,[t]){const wl={};t&2&&(wl.$$scope={dirty:t,ctx:e}),T.$set(wl);const gl={};t&2&&(gl.$$scope={dirty:t,ctx:e}),U.$set(gl)},i(e){Bt||(m(J.$$.fragment,e),m(v.$$.fragment,e),m(T.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(E.$$.fragment,e),m(A.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(U.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(fe.$$.fragment,e),m(ge.$$.fragment,e),m(Je.$$.fragment,e),m(ve.$$.fragment,e),Bt=!0)},o(e){c(J.$$.fragment,e),c(v.$$.fragment,e),c(T.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(A.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(U.$$.fragment,e),c(ce.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(ge.$$.fragment,e),c(Je.$$.fragment,e),c(ve.$$.fragment,e),Bt=!1},d(e){e&&(l(f),l(y),l(g),l(Ze),l(_e),l(j),l(He),l(Ge),l(C),l(ke),l(xe),l(I),l(Be),l(Z),l(Re),l(_),l(Ve),l(H),l(We),l(G),l(Ee),l(Qe),l(x),l(Ae),l(B),l(Ne),l(R),l(Fe),l(V),l(Se),l(W),l(qe),l(Le),l(Q),l(Xe),l(Ye),l(N),l(ze),l(F),l(Pe),l(S),l(Ke),l(q),l(De),l(L),l(Oe),l(et),l(tt),l(z),l(lt),l(P),l(ot),l(K),l(st),l(at),l(O),l(nt),l(Ce),l(it),l(ee),l(rt),l(pt),l(ut),l($e),l(dt),l(oe),l(ht),l(mt),l(ae),l(ct),l(ne),l(Mt),l(yt),l(bt),l(pe),l(ft),l(ue),l(wt),l(gt),l(he),l(Tt),l(Ut),l(Jt),l(vt),l(Me),l(jt),l(Ct),l(be),l($t),l(It),l(we),l(Zt),l(_t),l(Te),l(Ht),l(Ue),l(Gt),l(kt),l(xt),l(Ie)),l(p),M(J,e),M(v,e),M(T,e),M($,e),M(k,e),M(E,e),M(A,e),M(X,e),M(Y,e),M(D,e),M(te,e),M(le,e),M(se,e),M(ie,e),M(re,e),M(de,e),M(me,e),M(U,e),M(ce,e),M(ye,e),M(fe,e),M(ge,e),M(Je,e),M(ve,e)}}}const Rl='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4},{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4}],"depth":3}],"depth":1}';function Vl(je){return Cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends $l{constructor(p){super(),Il(this,p,Vl,Bl,jl,{})}}export{Sl as component};
