import{s as Vn,n as Kn,o as el}from"../chunks/scheduler.9039eef2.js";import{S as tl,i as al,g as s,s as n,r as m,A as nl,h as i,f as a,c as l,j as y,u as h,x as d,k as T,l as ll,y as r,a as o,v as M,d as u,t as g,w as f}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as gt}from"../chunks/CodeBlock.8580f3e8.js";import{H as _}from"../chunks/Heading.f027f30d.js";function ol(tn){let C,ft,Mt,yt,q,Tt,L,an='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',bt,R,nn="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",wt,O,_t,F,ln='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',vt,I,on='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',jt,G,rn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Jt,H,sn="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Ut,N,dn="for example:",Ct,X,It,z,pn="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",xt,Q,$t,Y,cn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",At,S,Dt,V,mn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Pt,K,Et,ee,hn="After this one can then call:",kt,te,Bt,ae,Mn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",Zt,ne,Wt,le,un="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",qt,oe,gn='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',Lt,re,fn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer.',Rt,se,yn='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Use the <code>loss_type=&quot;cdpo&quot;</code> argument to the trainer to use it.',Ot,ie,Tn='The <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">KTO</a> loss is derived to directly maximize the utility of LLM generations instead of the log-likelihood of preferences. Thus the dataset are not necessarily preferences but rather desirable vs undesirable completions. For paired preference data as required by the <code>DPOTrainer</code>, use the <code>loss_type=&quot;kto_pair&quot;</code> argument to the trainer to utilize this loss, while for the more general case of desired and undesirable data, use the as of yet unimplemented <code>KTOTrainer</code>.',Ft,de,Gt,pe,bn="While training and evaluating we record the following reward metrics:",Ht,ce,wn="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Nt,me,Xt,he,_n=`You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) and even full-finetuning (1.1x faster) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is compatible with <code>DPOTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama as well) and Mistral architectures.
First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth#installation-instructions---conda" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLlamaModel</code> or <code>FastMistralModel</code> as follows:`,zt,Me,Qt,ue,vn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',Yt,ge,St,fe,jn="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",Vt,ye,Jn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",Kt,Te,ea,be,Un='As suggested by <a href="https://twitter.com/Tim_Dettmers/status/1694654191325573456" rel="nofollow">Tim Dettmers</a>, the best option for merging QLoRA adapters is to first quantize the base model, merge the adapter, then convert back to bf16.  Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>',ta,we,Cn="You can also just merge the adapters the standard way without quantizing the base model, but then you have 1-2% reduced performance (and evidently, more issues with empty responses).",aa,_e,In="If you use the recommended approach, which quantizes the model, you’re now in a situation where to use QLoRA for DPO, you will need to re-quantize the merged model again or use an unquantized merge with lower overall performance.",na,ve,la,je,xn="To avoid the downsides with option 2, at the expense of slightly increased VRAM, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",oa,Je,$n="For example:",ra,Ue,sa,Ce,ia,p,Ie,ba,Fe,An="Initialize DPOTrainer.",wa,x,xe,_a,Ge,Dn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,va,$,$e,ja,He,Pn="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Ja,v,Ae,Ua,Ne,En="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Ca,Xe,kn="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Ia,A,De,xa,ze,Bn="Concatenate the chosen and rejected inputs into a single tensor.",$a,D,Pe,Aa,Qe,Zn="Compute the DPO loss for a batch of policy and reference model log probabilities.",Da,j,Ee,Pa,Ye,Wn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ea,Se,qn="Works both with or without labels.",ka,P,ke,Ba,Ve,Ln="Compute the log probabilities of the given labels under the given logits.",Za,E,Be,Wa,Ke,Rn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",qa,k,Ze,La,et,On="Generate samples from the model and reference model for the given batch of inputs.",Ra,J,We,Oa,tt,Fn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Fa,at,Gn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Ga,U,qe,Ha,nt,Hn="Returns the training <code>~torch.utils.data.DataLoader</code>.",Na,lt,Nn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Xa,B,Le,za,ot,Xn="Log <code>logs</code> on the various objects watching training, including stored metrics.",Qa,Z,Re,Ya,rt,zn="Context manager for handling null reference model (that is, peft adapter manipulation).",Sa,w,Oe,Va,st,Qn="Tokenize a single row from a DPO specific dataset.",Ka,it,Yn=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,en,dt,Sn=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,da,ut,pa;return q=new _({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),O=new _({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),X=new gt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),Q=new _({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),S=new _({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),K=new gt({props:{code:"JTIwZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:` dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),te=new gt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ne=new _({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),de=new _({props:{title:"Logging",local:"logging",headingTag:"h2"}}),me=new _({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Me=new gt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLlamaModel, FastMistralModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>
dtype = <span class="hljs-literal">None</span> <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
load_in_4bit = <span class="hljs-literal">True</span> <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>

<span class="hljs-comment"># Load Llama model</span>
model, tokenizer = FastLlamaModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/llama-2-7b&quot;</span>, <span class="hljs-comment"># Supports any llama model eg meta-llama/Llama-2-7b-hf</span>
    max_seq_length = max_seq_length,
    dtype = dtype,
    load_in_4bit = load_in_4bit,
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLlamaModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Currently only supports dropout = 0</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Currently only supports bias = &quot;none&quot;</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
    max_seq_length = max_seq_length,
)

args = TrainingArguments(output_dir=<span class="hljs-string">&quot;./output&quot;</span>)

dpo_trainer = DPOTrainer(
    model,
    model_ref=<span class="hljs-literal">None</span>,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)

dpo_trainer.train()`,wrap:!1}}),ge=new _({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Te=new _({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),ve=new _({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Ue=new gt({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbC4lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9oYXNfZnAxNl93ZWlnaHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaXN0cmFsYWklMkZtaXh0cmFsLTh4N2ItdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSklMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWRhcHRlci4lMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5hYmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUyMyUyMExvYWQlMjB0aGUlMjBhZGFwdGVyJTIwYSUyMHNlY29uZCUyMHRpbWUlMkMlMjB3aXRoJTIwYSUyMGRpZmZlcmVudCUyMG5hbWUlMkMlMjB3aGljaCUyMHdpbGwlMjBiZSUyMG91ciUyMHJlZmVyZW5jZSUyMG1vZGVsLiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycmVmZXJlbmNlJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjB0cmFpbmVyJTJDJTIwd2l0aG91dCUyMGElMjByZWZfbW9kZWwlMjBwYXJhbS4lMEFkcG9fdHJhaW5lciUyMCUzRCUyMERQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjBtb2RlbF9hZGFwdGVyX25hbWUlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZl9hZGFwdGVyX25hbWUlM0QlMjJyZWZlcmVuY2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
dpo_trainer = DPOTrainer(
    model,
    ...
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)`,wrap:!1}}),Ce=new _({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Ie=new b({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge', 'ipo', 'kto'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"model_adapter_name",val:": str = None"},{name:"ref_adapter_name",val:": str = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L64"}}),xe=new b({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L519"}}),$e=new b({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": typing.Dict"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L727"}}),Ae=new b({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L928"}}),De=new b({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": typing.Optional[torch.device] = None"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L749",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Pe=new b({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L811",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ee=new b({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L1137"}}),ke=new b({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L892",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Be=new b({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L974"}}),Ze=new b({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L1053"}}),We=new b({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <code>Dataset</code>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L467"}}),qe=new b({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L424"}}),Le=new b({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L1187"}}),Re=new b({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L715"}}),Oe=new b({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"}],source:"https://github.com/huggingface/trl/blob/v0.7.8/trl/trainer/dpo_trainer.py#L569"}}),{c(){C=s("meta"),ft=n(),Mt=s("p"),yt=n(),m(q.$$.fragment),Tt=n(),L=s("p"),L.innerHTML=an,bt=n(),R=s("p"),R.textContent=nn,wt=n(),m(O.$$.fragment),_t=n(),F=s("p"),F.innerHTML=ln,vt=n(),I=s("div"),I.innerHTML=on,jt=n(),G=s("p"),G.innerHTML=rn,Jt=n(),H=s("ul"),H.innerHTML=sn,Ut=n(),N=s("p"),N.textContent=dn,Ct=n(),m(X.$$.fragment),It=n(),z=s("p"),z.innerHTML=pn,xt=n(),m(Q.$$.fragment),$t=n(),Y=s("p"),Y.innerHTML=cn,At=n(),m(S.$$.fragment),Dt=n(),V=s("p"),V.innerHTML=mn,Pt=n(),m(K.$$.fragment),Et=n(),ee=s("p"),ee.textContent=hn,kt=n(),m(te.$$.fragment),Bt=n(),ae=s("p"),ae.innerHTML=Mn,Zt=n(),m(ne.$$.fragment),Wt=n(),le=s("p"),le.innerHTML=un,qt=n(),oe=s("p"),oe.innerHTML=gn,Lt=n(),re=s("p"),re.innerHTML=fn,Rt=n(),se=s("p"),se.innerHTML=yn,Ot=n(),ie=s("p"),ie.innerHTML=Tn,Ft=n(),m(de.$$.fragment),Gt=n(),pe=s("p"),pe.textContent=bn,Ht=n(),ce=s("ul"),ce.innerHTML=wn,Nt=n(),m(me.$$.fragment),Xt=n(),he=s("p"),he.innerHTML=_n,zt=n(),m(Me.$$.fragment),Qt=n(),ue=s("p"),ue.innerHTML=vn,Yt=n(),m(ge.$$.fragment),St=n(),fe=s("p"),fe.textContent=jn,Vt=n(),ye=s("ol"),ye.innerHTML=Jn,Kt=n(),m(Te.$$.fragment),ea=n(),be=s("p"),be.innerHTML=Un,ta=n(),we=s("p"),we.textContent=Cn,aa=n(),_e=s("p"),_e.textContent=In,na=n(),m(ve.$$.fragment),la=n(),je=s("p"),je.textContent=xn,oa=n(),Je=s("p"),Je.textContent=$n,ra=n(),m(Ue.$$.fragment),sa=n(),m(Ce.$$.fragment),ia=n(),p=s("div"),m(Ie.$$.fragment),ba=n(),Fe=s("p"),Fe.textContent=An,wa=n(),x=s("div"),m(xe.$$.fragment),_a=n(),Ge=s("p"),Ge.innerHTML=Dn,va=n(),$=s("div"),m($e.$$.fragment),ja=n(),He=s("p"),He.textContent=Pn,Ja=n(),v=s("div"),m(Ae.$$.fragment),Ua=n(),Ne=s("p"),Ne.textContent=En,Ca=n(),Xe=s("p"),Xe.textContent=kn,Ia=n(),A=s("div"),m(De.$$.fragment),xa=n(),ze=s("p"),ze.textContent=Bn,$a=n(),D=s("div"),m(Pe.$$.fragment),Aa=n(),Qe=s("p"),Qe.textContent=Zn,Da=n(),j=s("div"),m(Ee.$$.fragment),Pa=n(),Ye=s("p"),Ye.innerHTML=Wn,Ea=n(),Se=s("p"),Se.textContent=qn,ka=n(),P=s("div"),m(ke.$$.fragment),Ba=n(),Ve=s("p"),Ve.textContent=Ln,Za=n(),E=s("div"),m(Be.$$.fragment),Wa=n(),Ke=s("p"),Ke.textContent=Rn,qa=n(),k=s("div"),m(Ze.$$.fragment),La=n(),et=s("p"),et.textContent=On,Ra=n(),J=s("div"),m(We.$$.fragment),Oa=n(),tt=s("p"),tt.innerHTML=Fn,Fa=n(),at=s("p"),at.innerHTML=Gn,Ga=n(),U=s("div"),m(qe.$$.fragment),Ha=n(),nt=s("p"),nt.innerHTML=Hn,Na=n(),lt=s("p"),lt.innerHTML=Nn,Xa=n(),B=s("div"),m(Le.$$.fragment),za=n(),ot=s("p"),ot.innerHTML=Xn,Qa=n(),Z=s("div"),m(Re.$$.fragment),Ya=n(),rt=s("p"),rt.textContent=zn,Sa=n(),w=s("div"),m(Oe.$$.fragment),Va=n(),st=s("p"),st.textContent=Qn,Ka=n(),it=s("p"),it.textContent=Yn,en=n(),dt=s("p"),dt.textContent=Sn,da=n(),ut=s("p"),this.h()},l(e){const t=nl("svelte-u9bgzb",document.head);C=i(t,"META",{name:!0,content:!0}),t.forEach(a),ft=l(e),Mt=i(e,"P",{}),y(Mt).forEach(a),yt=l(e),h(q.$$.fragment,e),Tt=l(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-5p7twb"&&(L.innerHTML=an),bt=l(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-xh4sh7"&&(R.textContent=nn),wt=l(e),h(O.$$.fragment,e),_t=l(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-dcawbe"&&(F.innerHTML=ln),vt=l(e),I=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(I)!=="svelte-z15c7z"&&(I.innerHTML=on),jt=l(e),G=i(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-cb9b0v"&&(G.innerHTML=rn),Jt=l(e),H=i(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-17vxuta"&&(H.innerHTML=sn),Ut=l(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1gl9mvz"&&(N.textContent=dn),Ct=l(e),h(X.$$.fragment,e),It=l(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1a8oxjk"&&(z.innerHTML=pn),xt=l(e),h(Q.$$.fragment,e),$t=l(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-174yw9s"&&(Y.innerHTML=cn),At=l(e),h(S.$$.fragment,e),Dt=l(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1wn9xrv"&&(V.innerHTML=mn),Pt=l(e),h(K.$$.fragment,e),Et=l(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1lg6q1l"&&(ee.textContent=hn),kt=l(e),h(te.$$.fragment,e),Bt=l(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1ac5mum"&&(ae.innerHTML=Mn),Zt=l(e),h(ne.$$.fragment,e),Wt=l(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-7nvktz"&&(le.innerHTML=un),qt=l(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-bl9wh7"&&(oe.innerHTML=gn),Lt=l(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1x8box7"&&(re.innerHTML=fn),Rt=l(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-x8vvul"&&(se.innerHTML=yn),Ot=l(e),ie=i(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-qfh893"&&(ie.innerHTML=Tn),Ft=l(e),h(de.$$.fragment,e),Gt=l(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-132s7j9"&&(pe.textContent=bn),Ht=l(e),ce=i(e,"UL",{"data-svelte-h":!0}),d(ce)!=="svelte-1oji3mm"&&(ce.innerHTML=wn),Nt=l(e),h(me.$$.fragment,e),Xt=l(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1g6cmk7"&&(he.innerHTML=_n),zt=l(e),h(Me.$$.fragment,e),Qt=l(e),ue=i(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1o18rwj"&&(ue.innerHTML=vn),Yt=l(e),h(ge.$$.fragment,e),St=l(e),fe=i(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-4infz6"&&(fe.textContent=jn),Vt=l(e),ye=i(e,"OL",{"data-svelte-h":!0}),d(ye)!=="svelte-1p7od7"&&(ye.innerHTML=Jn),Kt=l(e),h(Te.$$.fragment,e),ea=l(e),be=i(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-qnlv77"&&(be.innerHTML=Un),ta=l(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-a6wqh1"&&(we.textContent=Cn),aa=l(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-18ysviz"&&(_e.textContent=In),na=l(e),h(ve.$$.fragment,e),la=l(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1gj19cj"&&(je.textContent=xn),oa=l(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1gkqha7"&&(Je.textContent=$n),ra=l(e),h(Ue.$$.fragment,e),sa=l(e),h(Ce.$$.fragment,e),ia=l(e),p=i(e,"DIV",{class:!0});var c=y(p);h(Ie.$$.fragment,c),ba=l(c),Fe=i(c,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-n6cc8y"&&(Fe.textContent=An),wa=l(c),x=i(c,"DIV",{class:!0});var ca=y(x);h(xe.$$.fragment,ca),_a=l(ca),Ge=i(ca,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-mcz8nm"&&(Ge.innerHTML=Dn),ca.forEach(a),va=l(c),$=i(c,"DIV",{class:!0});var ma=y($);h($e.$$.fragment,ma),ja=l(ma),He=i(ma,"P",{"data-svelte-h":!0}),d(He)!=="svelte-10t1062"&&(He.textContent=Pn),ma.forEach(a),Ja=l(c),v=i(c,"DIV",{class:!0});var pt=y(v);h(Ae.$$.fragment,pt),Ua=l(pt),Ne=i(pt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-16i1nac"&&(Ne.textContent=En),Ca=l(pt),Xe=i(pt,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-tgti68"&&(Xe.textContent=kn),pt.forEach(a),Ia=l(c),A=i(c,"DIV",{class:!0});var ha=y(A);h(De.$$.fragment,ha),xa=l(ha),ze=i(ha,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1cvsgkk"&&(ze.textContent=Bn),ha.forEach(a),$a=l(c),D=i(c,"DIV",{class:!0});var Ma=y(D);h(Pe.$$.fragment,Ma),Aa=l(Ma),Qe=i(Ma,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-ymgxq7"&&(Qe.textContent=Zn),Ma.forEach(a),Da=l(c),j=i(c,"DIV",{class:!0});var ct=y(j);h(Ee.$$.fragment,ct),Pa=l(ct),Ye=i(ct,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-8qlty5"&&(Ye.innerHTML=Wn),Ea=l(ct),Se=i(ct,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1tyo99t"&&(Se.textContent=qn),ct.forEach(a),ka=l(c),P=i(c,"DIV",{class:!0});var ua=y(P);h(ke.$$.fragment,ua),Ba=l(ua),Ve=i(ua,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-4nmimv"&&(Ve.textContent=Ln),ua.forEach(a),Za=l(c),E=i(c,"DIV",{class:!0});var ga=y(E);h(Be.$$.fragment,ga),Wa=l(ga),Ke=i(ga,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-11q8u7l"&&(Ke.textContent=Rn),ga.forEach(a),qa=l(c),k=i(c,"DIV",{class:!0});var fa=y(k);h(Ze.$$.fragment,fa),La=l(fa),et=i(fa,"P",{"data-svelte-h":!0}),d(et)!=="svelte-18uwvbi"&&(et.textContent=On),fa.forEach(a),Ra=l(c),J=i(c,"DIV",{class:!0});var mt=y(J);h(We.$$.fragment,mt),Oa=l(mt),tt=i(mt,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-xesobz"&&(tt.innerHTML=Fn),Fa=l(mt),at=i(mt,"P",{"data-svelte-h":!0}),d(at)!=="svelte-qg43tm"&&(at.innerHTML=Gn),mt.forEach(a),Ga=l(c),U=i(c,"DIV",{class:!0});var ht=y(U);h(qe.$$.fragment,ht),Ha=l(ht),nt=i(ht,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-dkae9b"&&(nt.innerHTML=Hn),Na=l(ht),lt=i(ht,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-hmd5cw"&&(lt.innerHTML=Nn),ht.forEach(a),Xa=l(c),B=i(c,"DIV",{class:!0});var ya=y(B);h(Le.$$.fragment,ya),za=l(ya),ot=i(ya,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-nqksfz"&&(ot.innerHTML=Xn),ya.forEach(a),Qa=l(c),Z=i(c,"DIV",{class:!0});var Ta=y(Z);h(Re.$$.fragment,Ta),Ya=l(Ta),rt=i(Ta,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-17kjsy4"&&(rt.textContent=zn),Ta.forEach(a),Sa=l(c),w=i(c,"DIV",{class:!0});var W=y(w);h(Oe.$$.fragment,W),Va=l(W),st=i(W,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1861yti"&&(st.textContent=Qn),Ka=l(W),it=i(W,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1mn1gnw"&&(it.textContent=Yn),en=l(W),dt=i(W,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1xvpyih"&&(dt.textContent=Sn),W.forEach(a),c.forEach(a),da=l(e),ut=i(e,"P",{}),y(ut).forEach(a),this.h()},h(){T(C,"name","hf:doc:metadata"),T(C,"content",rl),ll(I,"text-align","center"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,C),o(e,ft,t),o(e,Mt,t),o(e,yt,t),M(q,e,t),o(e,Tt,t),o(e,L,t),o(e,bt,t),o(e,R,t),o(e,wt,t),M(O,e,t),o(e,_t,t),o(e,F,t),o(e,vt,t),o(e,I,t),o(e,jt,t),o(e,G,t),o(e,Jt,t),o(e,H,t),o(e,Ut,t),o(e,N,t),o(e,Ct,t),M(X,e,t),o(e,It,t),o(e,z,t),o(e,xt,t),M(Q,e,t),o(e,$t,t),o(e,Y,t),o(e,At,t),M(S,e,t),o(e,Dt,t),o(e,V,t),o(e,Pt,t),M(K,e,t),o(e,Et,t),o(e,ee,t),o(e,kt,t),M(te,e,t),o(e,Bt,t),o(e,ae,t),o(e,Zt,t),M(ne,e,t),o(e,Wt,t),o(e,le,t),o(e,qt,t),o(e,oe,t),o(e,Lt,t),o(e,re,t),o(e,Rt,t),o(e,se,t),o(e,Ot,t),o(e,ie,t),o(e,Ft,t),M(de,e,t),o(e,Gt,t),o(e,pe,t),o(e,Ht,t),o(e,ce,t),o(e,Nt,t),M(me,e,t),o(e,Xt,t),o(e,he,t),o(e,zt,t),M(Me,e,t),o(e,Qt,t),o(e,ue,t),o(e,Yt,t),M(ge,e,t),o(e,St,t),o(e,fe,t),o(e,Vt,t),o(e,ye,t),o(e,Kt,t),M(Te,e,t),o(e,ea,t),o(e,be,t),o(e,ta,t),o(e,we,t),o(e,aa,t),o(e,_e,t),o(e,na,t),M(ve,e,t),o(e,la,t),o(e,je,t),o(e,oa,t),o(e,Je,t),o(e,ra,t),M(Ue,e,t),o(e,sa,t),M(Ce,e,t),o(e,ia,t),o(e,p,t),M(Ie,p,null),r(p,ba),r(p,Fe),r(p,wa),r(p,x),M(xe,x,null),r(x,_a),r(x,Ge),r(p,va),r(p,$),M($e,$,null),r($,ja),r($,He),r(p,Ja),r(p,v),M(Ae,v,null),r(v,Ua),r(v,Ne),r(v,Ca),r(v,Xe),r(p,Ia),r(p,A),M(De,A,null),r(A,xa),r(A,ze),r(p,$a),r(p,D),M(Pe,D,null),r(D,Aa),r(D,Qe),r(p,Da),r(p,j),M(Ee,j,null),r(j,Pa),r(j,Ye),r(j,Ea),r(j,Se),r(p,ka),r(p,P),M(ke,P,null),r(P,Ba),r(P,Ve),r(p,Za),r(p,E),M(Be,E,null),r(E,Wa),r(E,Ke),r(p,qa),r(p,k),M(Ze,k,null),r(k,La),r(k,et),r(p,Ra),r(p,J),M(We,J,null),r(J,Oa),r(J,tt),r(J,Fa),r(J,at),r(p,Ga),r(p,U),M(qe,U,null),r(U,Ha),r(U,nt),r(U,Na),r(U,lt),r(p,Xa),r(p,B),M(Le,B,null),r(B,za),r(B,ot),r(p,Qa),r(p,Z),M(Re,Z,null),r(Z,Ya),r(Z,rt),r(p,Sa),r(p,w),M(Oe,w,null),r(w,Va),r(w,st),r(w,Ka),r(w,it),r(w,en),r(w,dt),o(e,da,t),o(e,ut,t),pa=!0},p:Kn,i(e){pa||(u(q.$$.fragment,e),u(O.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),u(Te.$$.fragment,e),u(ve.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ae.$$.fragment,e),u(De.$$.fragment,e),u(Pe.$$.fragment,e),u(Ee.$$.fragment,e),u(ke.$$.fragment,e),u(Be.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u(qe.$$.fragment,e),u(Le.$$.fragment,e),u(Re.$$.fragment,e),u(Oe.$$.fragment,e),pa=!0)},o(e){g(q.$$.fragment,e),g(O.$$.fragment,e),g(X.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(Me.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g(Ue.$$.fragment,e),g(Ce.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Ae.$$.fragment,e),g(De.$$.fragment,e),g(Pe.$$.fragment,e),g(Ee.$$.fragment,e),g(ke.$$.fragment,e),g(Be.$$.fragment,e),g(Ze.$$.fragment,e),g(We.$$.fragment,e),g(qe.$$.fragment,e),g(Le.$$.fragment,e),g(Re.$$.fragment,e),g(Oe.$$.fragment,e),pa=!1},d(e){e&&(a(ft),a(Mt),a(yt),a(Tt),a(L),a(bt),a(R),a(wt),a(_t),a(F),a(vt),a(I),a(jt),a(G),a(Jt),a(H),a(Ut),a(N),a(Ct),a(It),a(z),a(xt),a($t),a(Y),a(At),a(Dt),a(V),a(Pt),a(Et),a(ee),a(kt),a(Bt),a(ae),a(Zt),a(Wt),a(le),a(qt),a(oe),a(Lt),a(re),a(Rt),a(se),a(Ot),a(ie),a(Ft),a(Gt),a(pe),a(Ht),a(ce),a(Nt),a(Xt),a(he),a(zt),a(Qt),a(ue),a(Yt),a(St),a(fe),a(Vt),a(ye),a(Kt),a(ea),a(be),a(ta),a(we),a(aa),a(_e),a(na),a(la),a(je),a(oa),a(Je),a(ra),a(sa),a(ia),a(p),a(da),a(ut)),a(C),f(q,e),f(O,e),f(X,e),f(Q,e),f(S,e),f(K,e),f(te,e),f(ne,e),f(de,e),f(me,e),f(Me,e),f(ge,e),f(Te,e),f(ve,e),f(Ue,e),f(Ce,e),f(Ie),f(xe),f($e),f(Ae),f(De),f(Pe),f(Ee),f(ke),f(Be),f(Ze),f(We),f(qe),f(Le),f(Re),f(Oe)}}}const rl='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function sl(tn){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends tl{constructor(C){super(),al(this,C,sl,ol,Vn,{})}}export{hl as component};
