import{s as Gn,o as Rn,n as j}from"../chunks/scheduler.9bc65507.js";import{S as Bn,i as Vn,g as m,s as r,r as h,A as Xn,h as p,f as n,c as i,j as $,u as f,x as y,k as F,y as l,a as c,v as g,d as u,t as _,w as T}from"../chunks/index.707bf1b6.js";import{T as re}from"../chunks/Tip.c2ecdbf4.js";import{D as I}from"../chunks/Docstring.17db21ae.js";import{C as he}from"../chunks/CodeBlock.54a9f38d.js";import{E as pe}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as Yn}from"../chunks/PipelineTag.44585822.js";import{H as J}from"../chunks/Heading.342b1fa6.js";function En(w){let t,b=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-j665pk"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function Pn(w){let t,b="Example:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlaVRDb25maWclMkMlMjBEZWlUTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwRGVpVCUyMGRlaXQtYmFzZS1kaXN0aWxsZWQtcGF0Y2gxNi0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRGVpVENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBEZWlUTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DeiTConfig, DeiTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a DeiT deit-base-distilled-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = DeiTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the deit-base-distilled-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeiTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function Ln(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function Hn(w){let t,b="Example:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlaVRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwRGVpVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmRlaXQtYmFzZS1kaXN0aWxsZWQtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeiTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeiTModel.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">198</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function Sn(w){let t,b=`Note that we provide a script to pre-train this model on custom data in our <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">examples
directory</a>.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-7i3y9o"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function qn(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function Qn(w){let t,b="Examples:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlaVRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGVpdC1iYXNlLWRpc3RpbGxlZC1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMERlaVRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmRlaXQtYmFzZS1kaXN0aWxsZWQtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQobG93JTNEMCUyQyUyMGhpZ2glM0QyJTJDJTIwc2l6ZSUzRCgxJTJDJTIwbnVtX3BhdGNoZXMpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMkMlMjByZWNvbnN0cnVjdGVkX3BpeGVsX3ZhbHVlcyUyMCUzRCUyMG91dHB1dHMubG9zcyUyQyUyMG91dHB1dHMucmVjb25zdHJ1Y3Rpb24lMEFsaXN0KHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeiTForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeiTForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function An(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function On(w){let t,b="Examples:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlaVRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXRvcmNoLm1hbnVhbF9zZWVkKDMpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMG5vdGUlM0ElMjB3ZSUyMGFyZSUyMGxvYWRpbmclMjBhJTIwRGVpVEZvckltYWdlQ2xhc3NpZmljYXRpb25XaXRoVGVhY2hlciUyMGZyb20lMjB0aGUlMjBodWIlMjBoZXJlJTJDJTBBJTIzJTIwc28lMjB0aGUlMjBoZWFkJTIwd2lsbCUyMGJlJTIwcmFuZG9tbHklMjBpbml0aWFsaXplZCUyQyUyMGhlbmNlJTIwdGhlJTIwcHJlZGljdGlvbnMlMjB3aWxsJTIwYmUlMjByYW5kb20lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGVpdC1iYXNlLWRpc3RpbGxlZC1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMERlaVRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmRlaXQtYmFzZS1kaXN0aWxsZWQtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeiTForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note: we are loading a DeiTForImageClassificationWithTeacher from the hub here,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># so the head will be randomly initialized, hence the predictions will be random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeiTForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: magpie`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function Kn(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function ea(w){let t,b="Example:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMERlaVRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uV2l0aFRlYWNoZXIlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGVpdC1iYXNlLWRpc3RpbGxlZC1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMERlaVRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uV2l0aFRlYWNoZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGVpdC1iYXNlLWRpc3RpbGxlZC1wYXRjaDE2LTIyNCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, DeiTForImageClassificationWithTeacher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = DeiTForImageClassificationWithTeacher.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function ta(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function oa(w){let t,b="Example:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRGVpVE1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZEZWlUTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGZGVpdC1iYXNlLWRpc3RpbGxlZC1wYXRjaDE2LTIyNCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFDeiTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFDeiTModel.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">198</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function sa(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function na(w){let t,b="Examples:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRGVpVEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZEZWlURm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQSUwQW51bV9wYXRjaGVzJTIwJTNEJTIwKG1vZGVsLmNvbmZpZy5pbWFnZV9zaXplJTIwJTJGJTJGJTIwbW9kZWwuY29uZmlnLnBhdGNoX3NpemUpJTIwKiolMjAyJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMikucGl4ZWxfdmFsdWVzJTBBJTIzJTIwY3JlYXRlJTIwcmFuZG9tJTIwYm9vbGVhbiUyMG1hc2slMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcGF0Y2hlcyklMEFib29sX21hc2tlZF9wb3MlMjAlM0QlMjB0Zi5jYXN0KHRmLnJhbmRvbS51bmlmb3JtKCgxJTJDJTIwbnVtX3BhdGNoZXMpJTJDJTIwbWludmFsJTNEMCUyQyUyMG1heHZhbCUzRDIlMkMlMjBkdHlwZSUzRHRmLmludDMyKSUyQyUyMHRmLmJvb2wpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyUyQyUyMGJvb2xfbWFza2VkX3BvcyUzRGJvb2xfbWFza2VkX3BvcyklMEFsb3NzJTJDJTIwcmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMkMlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uJTBBbGlzdChyZWNvbnN0cnVjdGVkX3BpeGVsX3ZhbHVlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFDeiTForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFDeiTForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = tf.cast(tf.random.uniform((<span class="hljs-number">1</span>, num_patches), minval=<span class="hljs-number">0</span>, maxval=<span class="hljs-number">2</span>, dtype=tf.int32), tf.<span class="hljs-built_in">bool</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function aa(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function ra(w){let t,b="Examples:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRGVpVEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdGYua2VyYXMudXRpbHMuc2V0X3JhbmRvbV9zZWVkKDMpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMG5vdGUlM0ElMjB3ZSUyMGFyZSUyMGxvYWRpbmclMjBhJTIwVEZEZWlURm9ySW1hZ2VDbGFzc2lmaWNhdGlvbldpdGhUZWFjaGVyJTIwZnJvbSUyMHRoZSUyMGh1YiUyMGhlcmUlMkMlMEElMjMlMjBzbyUyMHRoZSUyMGhlYWQlMjB3aWxsJTIwYmUlMjByYW5kb21seSUyMGluaXRpYWxpemVkJTJDJTIwaGVuY2UlMjB0aGUlMjBwcmVkaWN0aW9ucyUyMHdpbGwlMjBiZSUyMHJhbmRvbSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZEZWlURm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjB0Zi5tYXRoLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTVCMCU1RCUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCaW50KHByZWRpY3RlZF9jbGFzc19pZHgpJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFDeiTForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>tf.keras.utils.set_random_seed(<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note: we are loading a TFDeiTForImageClassificationWithTeacher from the hub here,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># so the head will be randomly initialized, hence the predictions will be random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFDeiTForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[<span class="hljs-built_in">int</span>(predicted_class_idx)])
Predicted <span class="hljs-keyword">class</span>: little blue heron, Egretta caerulea`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-kvfsh7"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function ia(w){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=b},l(a){t=p(a,"P",{"data-svelte-h":!0}),y(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(a,d){c(a,t,d)},p:j,d(a){a&&n(t)}}}function la(w){let t,b="Example:",a,d,M;return d=new he({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGRGVpVEZvckltYWdlQ2xhc3NpZmljYXRpb25XaXRoVGVhY2hlciUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZWl0LWJhc2UtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZEZWlURm9ySW1hZ2VDbGFzc2lmaWNhdGlvbldpdGhUZWFjaGVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmRlaXQtYmFzZS1kaXN0aWxsZWQtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGludCh0Zi5tYXRoLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFDeiTForImageClassificationWithTeacher
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFDeiTForImageClassificationWithTeacher.from_pretrained(<span class="hljs-string">&quot;facebook/deit-base-distilled-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=b,a=r(),h(d.$$.fragment)},l(o){t=p(o,"P",{"data-svelte-h":!0}),y(t)!=="svelte-11lpom8"&&(t.textContent=b),a=i(o),f(d.$$.fragment,o)},m(o,v){c(o,t,v),c(o,a,v),g(d,o,v),M=!0},p:j,i(o){M||(u(d.$$.fragment,o),M=!0)},o(o){_(d.$$.fragment,o),M=!1},d(o){o&&(n(t),n(a)),T(d,o)}}}function da(w){let t,b,a,d,M,o,v,io,Ue,lo,ze,Qs=`The DeiT model was proposed in <a href="https://arxiv.org/abs/2012.12877" rel="nofollow">Training data-efficient image transformers &amp; distillation through attention</a> by Hugo Touvron, Matthieu Cord, Matthijs Douze, Francisco Massa, Alexandre
Sablayrolles, Hervé Jégou. The <a href="vit">Vision Transformer (ViT)</a> introduced in <a href="https://arxiv.org/abs/2010.11929" rel="nofollow">Dosovitskiy et al., 2020</a> has shown that one can match or even outperform existing convolutional neural
networks using a Transformer encoder (BERT-like). However, the ViT models introduced in that paper required training on
expensive infrastructure for multiple weeks, using external data. DeiT (data-efficient image transformers) are more
efficiently trained transformers for image classification, requiring far less data and far less computing resources
compared to the original ViT models.`,co,Ne,As="The abstract from the paper is the following:",mo,Ge,Os=`<em>Recently, neural networks purely based on attention were shown to address image understanding tasks such as image
classification. However, these visual transformers are pre-trained with hundreds of millions of images using an
expensive infrastructure, thereby limiting their adoption. In this work, we produce a competitive convolution-free
transformer by training on Imagenet only. We train them on a single computer in less than 3 days. Our reference vision
transformer (86M parameters) achieves top-1 accuracy of 83.1% (single-crop evaluation) on ImageNet with no external
data. More importantly, we introduce a teacher-student strategy specific to transformers. It relies on a distillation
token ensuring that the student learns from the teacher through attention. We show the interest of this token-based
distillation, especially when using a convnet as a teacher. This leads us to report results competitive with convnets
for both Imagenet (where we obtain up to 85.2% accuracy) and when transferring to other tasks. We share our code and
models.</em>`,po,Re,Ks="Tips:",ho,Be,en=`<li>Compared to ViT, DeiT models use a so-called distillation token to effectively learn from a teacher (which, in the
DeiT paper, is a ResNet like-model). The distillation token is learned through backpropagation, by interacting with
the class ([CLS]) and patch tokens through the self-attention layers.</li> <li>There are 2 ways to fine-tune distilled models, either (1) in a classic way, by only placing a prediction head on top
of the final hidden state of the class token and not using the distillation signal, or (2) by placing both a
prediction head on top of the class token and on top of the distillation token. In that case, the [CLS] prediction
head is trained using regular cross-entropy between the prediction of the head and the ground-truth label, while the
distillation prediction head is trained using hard distillation (cross-entropy between the prediction of the
distillation head and the label predicted by the teacher). At inference time, one takes the average prediction
between both heads as final prediction. (2) is also called “fine-tuning with distillation”, because one relies on a
teacher that has already been fine-tuned on the downstream dataset. In terms of models, (1) corresponds to
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> and (2) corresponds to
<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForImageClassificationWithTeacher">DeiTForImageClassificationWithTeacher</a>.</li> <li>Note that the authors also did try soft distillation for (2) (in which case the distillation prediction head is
trained using KL divergence to match the softmax output of the teacher), but hard distillation gave the best results.</li> <li>All released checkpoints were pre-trained and fine-tuned on ImageNet-1k only. No external data was used. This is in
contrast with the original ViT model, which used external data like the JFT-300M dataset/Imagenet-21k for
pre-training.</li> <li>The authors of DeiT also released more efficiently trained ViT models, which you can directly plug into
<a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTModel">ViTModel</a> or <a href="/docs/transformers/v4.34.0/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a>. Techniques like data
augmentation, optimization, and regularization were used in order to simulate training on a much larger dataset
(while only using ImageNet-1k for pre-training). There are 4 variants available (in 3 different sizes):
<em>facebook/deit-tiny-patch16-224</em>, <em>facebook/deit-small-patch16-224</em>, <em>facebook/deit-base-patch16-224</em> and
<em>facebook/deit-base-patch16-384</em>. Note that one should use <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTImageProcessor">DeiTImageProcessor</a> in order to
prepare images for the model.</li>`,fo,Ve,tn='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The TensorFlow version of this model was added by <a href="https://huggingface.co/amyeroberts" rel="nofollow">amyeroberts</a>.',go,Xe,uo,Ye,on="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with DeiT.",_o,Ee,To,Pe,sn='<li><a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',bo,Le,nn="Besides that:",yo,He,an='<li><a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForMaskedImageModeling">DeiTForMaskedImageModeling</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">example script</a>.</li>',Mo,Se,rn="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",vo,qe,wo,Z,Qe,Lo,xt,ln=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a>. It is used to instantiate an DeiT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the DeiT
<a href="https://huggingface.co/facebook/deit-base-distilled-patch16-224" rel="nofollow">facebook/deit-base-distilled-patch16-224</a>
architecture.`,Ho,Wt,dn=`Configuration objects inherit from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,So,fe,$o,Ae,Fo,ie,Oe,qo,ge,Ke,Qo,Jt,cn="Preprocess an image or a batch of images.",Io,et,jo,L,tt,Ao,Zt,mn="Constructs a DeiT image processor.",Oo,ue,ot,Ko,Dt,pn="Preprocess an image or batch of images.",Co,st,ko,H,nt,es,Ut,hn=`The bare DeiT Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ts,N,at,os,zt,fn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTModel">DeiTModel</a> forward method, overrides the <code>__call__</code> special method.',ss,_e,ns,Te,xo,rt,Wo,x,it,as,Nt,gn='DeiT Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.',rs,be,is,Gt,un=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ls,G,lt,ds,Rt,_n='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForMaskedImageModeling">DeiTForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',cs,ye,ms,Me,Jo,dt,Zo,D,ct,ps,Bt,Tn=`DeiT Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,hs,Vt,bn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,fs,R,mt,gs,Xt,yn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',us,ve,_s,we,Do,pt,Uo,C,ht,Ts,Yt,Mn=`DeiT Model transformer with image classification heads on top (a linear layer on top of the final hidden state of
the [CLS] token and a linear layer on top of the final hidden state of the distillation token) e.g. for ImageNet.`,bs,Et,vn=".. warning::",ys,Pt,wn=`This model supports inference-only. Fine-tuning with distillation (i.e. with a teacher) is not yet
supported.`,Ms,Lt,$n=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,vs,B,ft,ws,Ht,Fn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTForImageClassificationWithTeacher">DeiTForImageClassificationWithTeacher</a> forward method, overrides the <code>__call__</code> special method.',$s,$e,Fs,Fe,zo,gt,No,S,ut,Is,St,In=`The bare DeiT Model transformer outputting raw hidden-states without any specific head on top.
This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,js,V,_t,Cs,qt,jn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> forward method, overrides the <code>__call__</code> special method.',ks,Ie,xs,je,Go,Tt,Ro,q,bt,Ws,Qt,Cn=`DeiT Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.
This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,Js,X,yt,Zs,At,kn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.TFDeiTForMaskedImageModeling">TFDeiTForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',Ds,Ce,Us,ke,Bo,Mt,Vo,U,vt,zs,Ot,xn=`DeiT Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,Ns,Kt,Wn=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,Gs,Y,wt,Rs,eo,Jn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.TFDeiTForImageClassification">TFDeiTForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Bs,xe,Vs,We,Xo,$t,Yo,k,Ft,Xs,to,Zn=`DeiT Model transformer with image classification heads on top (a linear layer on top of the final hidden state of
the [CLS] token and a linear layer on top of the final hidden state of the distillation token) e.g. for ImageNet.`,Ys,oo,Dn=".. warning::",Es,so,Un=`This model supports inference-only. Fine-tuning with distillation (i.e. with a teacher) is not yet
supported.`,Ps,no,zn=`This model is a TensorFlow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">tf.keras.layers.Layer</a>. Use it as a regular
TensorFlow Module and refer to the TensorFlow documentation for all matter related to general usage and behavior.`,Ls,E,It,Hs,ao,Nn='The <a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.TFDeiTForImageClassificationWithTeacher">TFDeiTForImageClassificationWithTeacher</a> forward method, overrides the <code>__call__</code> special method.',Ss,Je,qs,Ze,Eo,ro,Po;return M=new J({props:{title:"DeiT",local:"deit",headingTag:"h1"}}),v=new re({props:{$$slots:{default:[En]},$$scope:{ctx:w}}}),Ue=new J({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Xe=new J({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ee=new Yn({props:{pipeline:"image-classification"}}),qe=new J({props:{title:"DeiTConfig",local:"transformers.DeiTConfig",headingTag:"h2"}}),Qe=new I({props:{name:"class transformers.DeiTConfig",anchor:"transformers.DeiTConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"encoder_stride",val:" = 16"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeiTConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.DeiTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.DeiTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.DeiTConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.DeiTConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.DeiTConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.DeiTConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.DeiTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.DeiTConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.DeiTConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>224</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.DeiTConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.DeiTConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3</code>) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.DeiTConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.DeiTConfig.encoder_stride",description:`<strong>encoder_stride</strong> (<code>int</code>, <code>optional</code>, defaults to 16) &#x2014;
Factor to increase the spatial resolution by in the decoder head for masked image modeling.`,name:"encoder_stride"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/configuration_deit.py#L37"}}),fe=new pe({props:{anchor:"transformers.DeiTConfig.example",$$slots:{default:[Pn]},$$scope:{ctx:w}}}),Ae=new J({props:{title:"DeiTFeatureExtractor",local:"transformers.DeiTFeatureExtractor",headingTag:"h2"}}),Oe=new I({props:{name:"class transformers.DeiTFeatureExtractor",anchor:"transformers.DeiTFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/feature_extraction_deit.py#L26"}}),Ke=new I({props:{name:"__call__",anchor:"transformers.DeiTFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/image_processing_utils.py#L544"}}),et=new J({props:{title:"DeiTImageProcessor",local:"transformers.DeiTImageProcessor",headingTag:"h2"}}),tt=new I({props:{name:"class transformers.DeiTImageProcessor",anchor:"transformers.DeiTImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = 3"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeiTImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.DeiTImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the image after <code>resize</code>. Can be overridden by <code>size</code> in <code>preprocess</code>.`,name:"size"},{anchor:"transformers.DeiTImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> filter, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.DeiTImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by <code>do_center_crop</code> in <code>preprocess</code>.`,name:"do_center_crop"},{anchor:"transformers.DeiTImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Desired output size when applying center-cropping. Can be overridden by <code>crop_size</code> in <code>preprocess</code>.`,name:"crop_size"},{anchor:"transformers.DeiTImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.DeiTImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.DeiTImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.DeiTImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.DeiTImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/image_processing_deit.py#L45"}}),ot=new I({props:{name:"preprocess",anchor:"transformers.DeiTImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:" = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.DeiTImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.DeiTImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.DeiTImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after <code>resize</code>.`,name:"size"},{anchor:"transformers.DeiTImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
PILImageResampling filter to use if resizing the image Only has an effect if <code>do_resize</code> is set to
<code>True</code>.`,name:"resample"},{anchor:"transformers.DeiTImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.DeiTImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.DeiTImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.DeiTImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.DeiTImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.DeiTImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.DeiTImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.DeiTImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.DeiTImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.DeiTImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/image_processing_deit.py#L161"}}),st=new J({props:{title:"DeiTModel",local:"transformers.DeiTModel",headingTag:"h2"}}),nt=new I({props:{name:"class transformers.DeiTModel",anchor:"transformers.DeiTModel",parameters:[{name:"config",val:": DeiTConfig"},{name:"add_pooling_layer",val:": bool = True"},{name:"use_mask_token",val:": bool = False"}],parametersDescription:[{anchor:"transformers.DeiTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L461"}}),at=new I({props:{name:"forward",anchor:"transformers.DeiTModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DeiTModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DeiTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DeiTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeiTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeiTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DeiTModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L486",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new re({props:{$$slots:{default:[Ln]},$$scope:{ctx:w}}}),Te=new pe({props:{anchor:"transformers.DeiTModel.forward.example",$$slots:{default:[Hn]},$$scope:{ctx:w}}}),rt=new J({props:{title:"DeiTForMaskedImageModeling",local:"transformers.DeiTForMaskedImageModeling",headingTag:"h2"}}),it=new I({props:{name:"class transformers.DeiTForMaskedImageModeling",anchor:"transformers.DeiTForMaskedImageModeling",parameters:[{name:"config",val:": DeiTConfig"}],parametersDescription:[{anchor:"transformers.DeiTForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L581"}}),be=new re({props:{$$slots:{default:[Sn]},$$scope:{ctx:w}}}),lt=new I({props:{name:"forward",anchor:"transformers.DeiTForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DeiTForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DeiTForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DeiTForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeiTForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeiTForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DeiTForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L599",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.MaskedImageModelingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Reconstruction loss.</li>
<li><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed / completed images.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or</li>
<li><strong>when</strong> <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when</li>
<li><strong><code>config.output_attentions=True</code>):</strong>
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.MaskedImageModelingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new re({props:{$$slots:{default:[qn]},$$scope:{ctx:w}}}),Me=new pe({props:{anchor:"transformers.DeiTForMaskedImageModeling.forward.example",$$slots:{default:[Qn]},$$scope:{ctx:w}}}),dt=new J({props:{title:"DeiTForImageClassification",local:"transformers.DeiTForImageClassification",headingTag:"h2"}}),ct=new I({props:{name:"class transformers.DeiTForImageClassification",anchor:"transformers.DeiTForImageClassification",parameters:[{name:"config",val:": DeiTConfig"}],parametersDescription:[{anchor:"transformers.DeiTForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L693"}}),mt=new I({props:{name:"forward",anchor:"transformers.DeiTForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DeiTForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DeiTForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DeiTForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeiTForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeiTForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.DeiTForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L706",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new re({props:{$$slots:{default:[An]},$$scope:{ctx:w}}}),we=new pe({props:{anchor:"transformers.DeiTForImageClassification.forward.example",$$slots:{default:[On]},$$scope:{ctx:w}}}),pt=new J({props:{title:"DeiTForImageClassificationWithTeacher",local:"transformers.DeiTForImageClassificationWithTeacher",headingTag:"h2"}}),ht=new I({props:{name:"class transformers.DeiTForImageClassificationWithTeacher",anchor:"transformers.DeiTForImageClassificationWithTeacher",parameters:[{name:"config",val:": DeiTConfig"}],parametersDescription:[{anchor:"transformers.DeiTForImageClassificationWithTeacher.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L843"}}),ft=new I({props:{name:"forward",anchor:"transformers.DeiTForImageClassificationWithTeacher.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.DeiTForImageClassificationWithTeacher.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.DeiTForImageClassificationWithTeacher.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.DeiTForImageClassificationWithTeacher.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.DeiTForImageClassificationWithTeacher.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.DeiTForImageClassificationWithTeacher.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_deit.py#L861",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.deit.modeling_deit.DeiTForImageClassificationWithTeacherOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores as the average of the cls_logits and distillation logits.</li>
<li><strong>cls_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the classification head (i.e. the linear layer on top of the final hidden state of the
class token).</li>
<li><strong>distillation_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the distillation head (i.e. the linear layer on top of the final hidden state of the
distillation token).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.deit.modeling_deit.DeiTForImageClassificationWithTeacherOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new re({props:{$$slots:{default:[Kn]},$$scope:{ctx:w}}}),Fe=new pe({props:{anchor:"transformers.DeiTForImageClassificationWithTeacher.forward.example",$$slots:{default:[ea]},$$scope:{ctx:w}}}),gt=new J({props:{title:"TFDeiTModel",local:"transformers.TFDeiTModel",headingTag:"h2"}}),ut=new I({props:{name:"class transformers.TFDeiTModel",anchor:"transformers.TFDeiTModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFDeiTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L610"}}),_t=new I({props:{name:"call",anchor:"transformers.TFDeiTModel.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFDeiTModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFDeiTModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFDeiTModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFDeiTModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFDeiTModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L620",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) further processed by a
Linear layer and a Tanh activation function. The Linear layer weights are trained from the next sentence
prediction (classification) objective during pretraining.</p>
<p>This output is usually <em>not</em> a good summary of the semantic content of the input, you’re often better with
averaging or pooling the sequence of hidden-states for the whole input sequence.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPooling</a> or <code>tuple(tf.Tensor)</code></p>
`}}),Ie=new re({props:{$$slots:{default:[ta]},$$scope:{ctx:w}}}),je=new pe({props:{anchor:"transformers.TFDeiTModel.call.example",$$slots:{default:[oa]},$$scope:{ctx:w}}}),Tt=new J({props:{title:"TFDeiTForMaskedImageModeling",local:"transformers.TFDeiTForMaskedImageModeling",headingTag:"h2"}}),bt=new I({props:{name:"class transformers.TFDeiTForMaskedImageModeling",anchor:"transformers.TFDeiTForMaskedImageModeling",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFDeiTForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L718"}}),yt=new I({props:{name:"call",anchor:"transformers.TFDeiTForMaskedImageModeling.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFDeiTForMaskedImageModeling.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFDeiTForMaskedImageModeling.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFDeiTForMaskedImageModeling.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFDeiTForMaskedImageModeling.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFDeiTForMaskedImageModeling.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFDeiTForMaskedImageModeling.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of type bool and shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L725",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_tf_outputs.TFMaskedImageModelingOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Reconstruction loss.</li>
<li><strong>reconstruction</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed / completed images.</li>
<li><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when</li>
<li><strong><code>config.output_hidden_states=True</code>):</strong>
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called
feature maps) of the model at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when</li>
<li><strong><code>config.output_attentions=True</code>):</strong>
Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.
Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_tf_outputs.TFMaskedImageModelingOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Ce=new re({props:{$$slots:{default:[sa]},$$scope:{ctx:w}}}),ke=new pe({props:{anchor:"transformers.TFDeiTForMaskedImageModeling.call.example",$$slots:{default:[na]},$$scope:{ctx:w}}}),Mt=new J({props:{title:"TFDeiTForImageClassification",local:"transformers.TFDeiTForImageClassification",headingTag:"h2"}}),vt=new I({props:{name:"class transformers.TFDeiTForImageClassification",anchor:"transformers.TFDeiTForImageClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFDeiTForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L833"}}),wt=new I({props:{name:"call",anchor:"transformers.TFDeiTForImageClassification.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFDeiTForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFDeiTForImageClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFDeiTForImageClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFDeiTForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFDeiTForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFDeiTForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L847",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_tf_outputs.TFImageClassifierOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings, if the model has an embedding layer, + one for
the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called
feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_tf_outputs.TFImageClassifierOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),xe=new re({props:{$$slots:{default:[aa]},$$scope:{ctx:w}}}),We=new pe({props:{anchor:"transformers.TFDeiTForImageClassification.call.example",$$slots:{default:[ra]},$$scope:{ctx:w}}}),$t=new J({props:{title:"TFDeiTForImageClassificationWithTeacher",local:"transformers.TFDeiTForImageClassificationWithTeacher",headingTag:"h2"}}),Ft=new I({props:{name:"class transformers.TFDeiTForImageClassificationWithTeacher",anchor:"transformers.TFDeiTForImageClassificationWithTeacher",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L935"}}),It=new I({props:{name:"call",anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.0/en/model_doc/levit#transformers.LevitFeatureExtractor.__call__">DeiTImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/deit/modeling_tf_deit.py#L954",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.deit.modeling_tf_deit.TFDeiTForImageClassificationWithTeacherOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/v4.34.0/en/model_doc/deit#transformers.DeiTConfig"
>DeiTConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores as the average of the cls_logits and distillation logits.</li>
<li><strong>cls_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the classification head (i.e. the linear layer on top of the final hidden state of the
class token).</li>
<li><strong>distillation_logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Prediction scores of the distillation head (i.e. the linear layer on top of the final hidden state of the
distillation token).</li>
<li><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.deit.modeling_tf_deit.TFDeiTForImageClassificationWithTeacherOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),Je=new re({props:{$$slots:{default:[ia]},$$scope:{ctx:w}}}),Ze=new pe({props:{anchor:"transformers.TFDeiTForImageClassificationWithTeacher.call.example",$$slots:{default:[la]},$$scope:{ctx:w}}}),{c(){t=m("meta"),b=r(),a=m("p"),d=r(),h(M.$$.fragment),o=r(),h(v.$$.fragment),io=r(),h(Ue.$$.fragment),lo=r(),ze=m("p"),ze.innerHTML=Qs,co=r(),Ne=m("p"),Ne.textContent=As,mo=r(),Ge=m("p"),Ge.innerHTML=Os,po=r(),Re=m("p"),Re.textContent=Ks,ho=r(),Be=m("ul"),Be.innerHTML=en,fo=r(),Ve=m("p"),Ve.innerHTML=tn,go=r(),h(Xe.$$.fragment),uo=r(),Ye=m("p"),Ye.textContent=on,_o=r(),h(Ee.$$.fragment),To=r(),Pe=m("ul"),Pe.innerHTML=sn,bo=r(),Le=m("p"),Le.textContent=nn,yo=r(),He=m("ul"),He.innerHTML=an,Mo=r(),Se=m("p"),Se.textContent=rn,vo=r(),h(qe.$$.fragment),wo=r(),Z=m("div"),h(Qe.$$.fragment),Lo=r(),xt=m("p"),xt.innerHTML=ln,Ho=r(),Wt=m("p"),Wt.innerHTML=dn,So=r(),h(fe.$$.fragment),$o=r(),h(Ae.$$.fragment),Fo=r(),ie=m("div"),h(Oe.$$.fragment),qo=r(),ge=m("div"),h(Ke.$$.fragment),Qo=r(),Jt=m("p"),Jt.textContent=cn,Io=r(),h(et.$$.fragment),jo=r(),L=m("div"),h(tt.$$.fragment),Ao=r(),Zt=m("p"),Zt.textContent=mn,Oo=r(),ue=m("div"),h(ot.$$.fragment),Ko=r(),Dt=m("p"),Dt.textContent=pn,Co=r(),h(st.$$.fragment),ko=r(),H=m("div"),h(nt.$$.fragment),es=r(),Ut=m("p"),Ut.innerHTML=hn,ts=r(),N=m("div"),h(at.$$.fragment),os=r(),zt=m("p"),zt.innerHTML=fn,ss=r(),h(_e.$$.fragment),ns=r(),h(Te.$$.fragment),xo=r(),h(rt.$$.fragment),Wo=r(),x=m("div"),h(it.$$.fragment),as=r(),Nt=m("p"),Nt.innerHTML=gn,rs=r(),h(be.$$.fragment),is=r(),Gt=m("p"),Gt.innerHTML=un,ls=r(),G=m("div"),h(lt.$$.fragment),ds=r(),Rt=m("p"),Rt.innerHTML=_n,cs=r(),h(ye.$$.fragment),ms=r(),h(Me.$$.fragment),Jo=r(),h(dt.$$.fragment),Zo=r(),D=m("div"),h(ct.$$.fragment),ps=r(),Bt=m("p"),Bt.textContent=Tn,hs=r(),Vt=m("p"),Vt.innerHTML=bn,fs=r(),R=m("div"),h(mt.$$.fragment),gs=r(),Xt=m("p"),Xt.innerHTML=yn,us=r(),h(ve.$$.fragment),_s=r(),h(we.$$.fragment),Do=r(),h(pt.$$.fragment),Uo=r(),C=m("div"),h(ht.$$.fragment),Ts=r(),Yt=m("p"),Yt.textContent=Mn,bs=r(),Et=m("p"),Et.textContent=vn,ys=r(),Pt=m("p"),Pt.textContent=wn,Ms=r(),Lt=m("p"),Lt.innerHTML=$n,vs=r(),B=m("div"),h(ft.$$.fragment),ws=r(),Ht=m("p"),Ht.innerHTML=Fn,$s=r(),h($e.$$.fragment),Fs=r(),h(Fe.$$.fragment),zo=r(),h(gt.$$.fragment),No=r(),S=m("div"),h(ut.$$.fragment),Is=r(),St=m("p"),St.innerHTML=In,js=r(),V=m("div"),h(_t.$$.fragment),Cs=r(),qt=m("p"),qt.innerHTML=jn,ks=r(),h(Ie.$$.fragment),xs=r(),h(je.$$.fragment),Go=r(),h(Tt.$$.fragment),Ro=r(),q=m("div"),h(bt.$$.fragment),Ws=r(),Qt=m("p"),Qt.innerHTML=Cn,Js=r(),X=m("div"),h(yt.$$.fragment),Zs=r(),At=m("p"),At.innerHTML=kn,Ds=r(),h(Ce.$$.fragment),Us=r(),h(ke.$$.fragment),Bo=r(),h(Mt.$$.fragment),Vo=r(),U=m("div"),h(vt.$$.fragment),zs=r(),Ot=m("p"),Ot.textContent=xn,Ns=r(),Kt=m("p"),Kt.innerHTML=Wn,Gs=r(),Y=m("div"),h(wt.$$.fragment),Rs=r(),eo=m("p"),eo.innerHTML=Jn,Bs=r(),h(xe.$$.fragment),Vs=r(),h(We.$$.fragment),Xo=r(),h($t.$$.fragment),Yo=r(),k=m("div"),h(Ft.$$.fragment),Xs=r(),to=m("p"),to.textContent=Zn,Ys=r(),oo=m("p"),oo.textContent=Dn,Es=r(),so=m("p"),so.textContent=Un,Ps=r(),no=m("p"),no.innerHTML=zn,Ls=r(),E=m("div"),h(It.$$.fragment),Hs=r(),ao=m("p"),ao.innerHTML=Nn,Ss=r(),h(Je.$$.fragment),qs=r(),h(Ze.$$.fragment),Eo=r(),ro=m("p"),this.h()},l(e){const s=Xn("svelte-u9bgzb",document.head);t=p(s,"META",{name:!0,content:!0}),s.forEach(n),b=i(e),a=p(e,"P",{}),$(a).forEach(n),d=i(e),f(M.$$.fragment,e),o=i(e),f(v.$$.fragment,e),io=i(e),f(Ue.$$.fragment,e),lo=i(e),ze=p(e,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-1igs2l2"&&(ze.innerHTML=Qs),co=i(e),Ne=p(e,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-vfdo9a"&&(Ne.textContent=As),mo=i(e),Ge=p(e,"P",{"data-svelte-h":!0}),y(Ge)!=="svelte-13f6p0y"&&(Ge.innerHTML=Os),po=i(e),Re=p(e,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-axv494"&&(Re.textContent=Ks),ho=i(e),Be=p(e,"UL",{"data-svelte-h":!0}),y(Be)!=="svelte-1ys4k2w"&&(Be.innerHTML=en),fo=i(e),Ve=p(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-176e55m"&&(Ve.innerHTML=tn),go=i(e),f(Xe.$$.fragment,e),uo=i(e),Ye=p(e,"P",{"data-svelte-h":!0}),y(Ye)!=="svelte-1l32li1"&&(Ye.textContent=on),_o=i(e),f(Ee.$$.fragment,e),To=i(e),Pe=p(e,"UL",{"data-svelte-h":!0}),y(Pe)!=="svelte-stp1zj"&&(Pe.innerHTML=sn),bo=i(e),Le=p(e,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-1k821ua"&&(Le.textContent=nn),yo=i(e),He=p(e,"UL",{"data-svelte-h":!0}),y(He)!=="svelte-2zyki9"&&(He.innerHTML=an),Mo=i(e),Se=p(e,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-1xesile"&&(Se.textContent=rn),vo=i(e),f(qe.$$.fragment,e),wo=i(e),Z=p(e,"DIV",{class:!0});var Q=$(Z);f(Qe.$$.fragment,Q),Lo=i(Q),xt=p(Q,"P",{"data-svelte-h":!0}),y(xt)!=="svelte-bfnw63"&&(xt.innerHTML=ln),Ho=i(Q),Wt=p(Q,"P",{"data-svelte-h":!0}),y(Wt)!=="svelte-10kqkkl"&&(Wt.innerHTML=dn),So=i(Q),f(fe.$$.fragment,Q),Q.forEach(n),$o=i(e),f(Ae.$$.fragment,e),Fo=i(e),ie=p(e,"DIV",{class:!0});var jt=$(ie);f(Oe.$$.fragment,jt),qo=i(jt),ge=p(jt,"DIV",{class:!0});var Ct=$(ge);f(Ke.$$.fragment,Ct),Qo=i(Ct),Jt=p(Ct,"P",{"data-svelte-h":!0}),y(Jt)!=="svelte-khengj"&&(Jt.textContent=cn),Ct.forEach(n),jt.forEach(n),Io=i(e),f(et.$$.fragment,e),jo=i(e),L=p(e,"DIV",{class:!0});var le=$(L);f(tt.$$.fragment,le),Ao=i(le),Zt=p(le,"P",{"data-svelte-h":!0}),y(Zt)!=="svelte-19jpkyi"&&(Zt.textContent=mn),Oo=i(le),ue=p(le,"DIV",{class:!0});var kt=$(ue);f(ot.$$.fragment,kt),Ko=i(kt),Dt=p(kt,"P",{"data-svelte-h":!0}),y(Dt)!=="svelte-1x3yxsa"&&(Dt.textContent=pn),kt.forEach(n),le.forEach(n),Co=i(e),f(st.$$.fragment,e),ko=i(e),H=p(e,"DIV",{class:!0});var de=$(H);f(nt.$$.fragment,de),es=i(de),Ut=p(de,"P",{"data-svelte-h":!0}),y(Ut)!=="svelte-1g5epvj"&&(Ut.innerHTML=hn),ts=i(de),N=p(de,"DIV",{class:!0});var A=$(N);f(at.$$.fragment,A),os=i(A),zt=p(A,"P",{"data-svelte-h":!0}),y(zt)!=="svelte-j1abkb"&&(zt.innerHTML=fn),ss=i(A),f(_e.$$.fragment,A),ns=i(A),f(Te.$$.fragment,A),A.forEach(n),de.forEach(n),xo=i(e),f(rt.$$.fragment,e),Wo=i(e),x=p(e,"DIV",{class:!0});var z=$(x);f(it.$$.fragment,z),as=i(z),Nt=p(z,"P",{"data-svelte-h":!0}),y(Nt)!=="svelte-1lv61v1"&&(Nt.innerHTML=gn),rs=i(z),f(be.$$.fragment,z),is=i(z),Gt=p(z,"P",{"data-svelte-h":!0}),y(Gt)!=="svelte-1gjh92c"&&(Gt.innerHTML=un),ls=i(z),G=p(z,"DIV",{class:!0});var O=$(G);f(lt.$$.fragment,O),ds=i(O),Rt=p(O,"P",{"data-svelte-h":!0}),y(Rt)!=="svelte-14a15kn"&&(Rt.innerHTML=_n),cs=i(O),f(ye.$$.fragment,O),ms=i(O),f(Me.$$.fragment,O),O.forEach(n),z.forEach(n),Jo=i(e),f(dt.$$.fragment,e),Zo=i(e),D=p(e,"DIV",{class:!0});var K=$(D);f(ct.$$.fragment,K),ps=i(K),Bt=p(K,"P",{"data-svelte-h":!0}),y(Bt)!=="svelte-1azp76l"&&(Bt.textContent=Tn),hs=i(K),Vt=p(K,"P",{"data-svelte-h":!0}),y(Vt)!=="svelte-1gjh92c"&&(Vt.innerHTML=bn),fs=i(K),R=p(K,"DIV",{class:!0});var ee=$(R);f(mt.$$.fragment,ee),gs=i(ee),Xt=p(ee,"P",{"data-svelte-h":!0}),y(Xt)!=="svelte-1qy9l5b"&&(Xt.innerHTML=yn),us=i(ee),f(ve.$$.fragment,ee),_s=i(ee),f(we.$$.fragment,ee),ee.forEach(n),K.forEach(n),Do=i(e),f(pt.$$.fragment,e),Uo=i(e),C=p(e,"DIV",{class:!0});var W=$(C);f(ht.$$.fragment,W),Ts=i(W),Yt=p(W,"P",{"data-svelte-h":!0}),y(Yt)!=="svelte-17o4rh5"&&(Yt.textContent=Mn),bs=i(W),Et=p(W,"P",{"data-svelte-h":!0}),y(Et)!=="svelte-zri3pk"&&(Et.textContent=vn),ys=i(W),Pt=p(W,"P",{"data-svelte-h":!0}),y(Pt)!=="svelte-1gp6z48"&&(Pt.textContent=wn),Ms=i(W),Lt=p(W,"P",{"data-svelte-h":!0}),y(Lt)!=="svelte-1gjh92c"&&(Lt.innerHTML=$n),vs=i(W),B=p(W,"DIV",{class:!0});var te=$(B);f(ft.$$.fragment,te),ws=i(te),Ht=p(te,"P",{"data-svelte-h":!0}),y(Ht)!=="svelte-g08xrr"&&(Ht.innerHTML=Fn),$s=i(te),f($e.$$.fragment,te),Fs=i(te),f(Fe.$$.fragment,te),te.forEach(n),W.forEach(n),zo=i(e),f(gt.$$.fragment,e),No=i(e),S=p(e,"DIV",{class:!0});var ce=$(S);f(ut.$$.fragment,ce),Is=i(ce),St=p(ce,"P",{"data-svelte-h":!0}),y(St)!=="svelte-1gvd2x3"&&(St.innerHTML=In),js=i(ce),V=p(ce,"DIV",{class:!0});var oe=$(V);f(_t.$$.fragment,oe),Cs=i(oe),qt=p(oe,"P",{"data-svelte-h":!0}),y(qt)!=="svelte-1iax617"&&(qt.innerHTML=jn),ks=i(oe),f(Ie.$$.fragment,oe),xs=i(oe),f(je.$$.fragment,oe),oe.forEach(n),ce.forEach(n),Go=i(e),f(Tt.$$.fragment,e),Ro=i(e),q=p(e,"DIV",{class:!0});var me=$(q);f(bt.$$.fragment,me),Ws=i(me),Qt=p(me,"P",{"data-svelte-h":!0}),y(Qt)!=="svelte-1y4me3j"&&(Qt.innerHTML=Cn),Js=i(me),X=p(me,"DIV",{class:!0});var se=$(X);f(yt.$$.fragment,se),Zs=i(se),At=p(se,"P",{"data-svelte-h":!0}),y(At)!=="svelte-a9t7xz"&&(At.innerHTML=kn),Ds=i(se),f(Ce.$$.fragment,se),Us=i(se),f(ke.$$.fragment,se),se.forEach(n),me.forEach(n),Bo=i(e),f(Mt.$$.fragment,e),Vo=i(e),U=p(e,"DIV",{class:!0});var ne=$(U);f(vt.$$.fragment,ne),zs=i(ne),Ot=p(ne,"P",{"data-svelte-h":!0}),y(Ot)!=="svelte-1azp76l"&&(Ot.textContent=xn),Ns=i(ne),Kt=p(ne,"P",{"data-svelte-h":!0}),y(Kt)!=="svelte-1y4qz5o"&&(Kt.innerHTML=Wn),Gs=i(ne),Y=p(ne,"DIV",{class:!0});var ae=$(Y);f(wt.$$.fragment,ae),Rs=i(ae),eo=p(ae,"P",{"data-svelte-h":!0}),y(eo)!=="svelte-4ad2gv"&&(eo.innerHTML=Jn),Bs=i(ae),f(xe.$$.fragment,ae),Vs=i(ae),f(We.$$.fragment,ae),ae.forEach(n),ne.forEach(n),Xo=i(e),f($t.$$.fragment,e),Yo=i(e),k=p(e,"DIV",{class:!0});var P=$(k);f(Ft.$$.fragment,P),Xs=i(P),to=p(P,"P",{"data-svelte-h":!0}),y(to)!=="svelte-17o4rh5"&&(to.textContent=Zn),Ys=i(P),oo=p(P,"P",{"data-svelte-h":!0}),y(oo)!=="svelte-zri3pk"&&(oo.textContent=Dn),Es=i(P),so=p(P,"P",{"data-svelte-h":!0}),y(so)!=="svelte-1gp6z48"&&(so.textContent=Un),Ps=i(P),no=p(P,"P",{"data-svelte-h":!0}),y(no)!=="svelte-1y4qz5o"&&(no.innerHTML=zn),Ls=i(P),E=p(P,"DIV",{class:!0});var De=$(E);f(It.$$.fragment,De),Hs=i(De),ao=p(De,"P",{"data-svelte-h":!0}),y(ao)!=="svelte-s9mvcv"&&(ao.innerHTML=Nn),Ss=i(De),f(Je.$$.fragment,De),qs=i(De),f(Ze.$$.fragment,De),De.forEach(n),P.forEach(n),Eo=i(e),ro=p(e,"P",{}),$(ro).forEach(n),this.h()},h(){F(t,"name","hf:doc:metadata"),F(t,"content",ca),F(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){l(document.head,t),c(e,b,s),c(e,a,s),c(e,d,s),g(M,e,s),c(e,o,s),g(v,e,s),c(e,io,s),g(Ue,e,s),c(e,lo,s),c(e,ze,s),c(e,co,s),c(e,Ne,s),c(e,mo,s),c(e,Ge,s),c(e,po,s),c(e,Re,s),c(e,ho,s),c(e,Be,s),c(e,fo,s),c(e,Ve,s),c(e,go,s),g(Xe,e,s),c(e,uo,s),c(e,Ye,s),c(e,_o,s),g(Ee,e,s),c(e,To,s),c(e,Pe,s),c(e,bo,s),c(e,Le,s),c(e,yo,s),c(e,He,s),c(e,Mo,s),c(e,Se,s),c(e,vo,s),g(qe,e,s),c(e,wo,s),c(e,Z,s),g(Qe,Z,null),l(Z,Lo),l(Z,xt),l(Z,Ho),l(Z,Wt),l(Z,So),g(fe,Z,null),c(e,$o,s),g(Ae,e,s),c(e,Fo,s),c(e,ie,s),g(Oe,ie,null),l(ie,qo),l(ie,ge),g(Ke,ge,null),l(ge,Qo),l(ge,Jt),c(e,Io,s),g(et,e,s),c(e,jo,s),c(e,L,s),g(tt,L,null),l(L,Ao),l(L,Zt),l(L,Oo),l(L,ue),g(ot,ue,null),l(ue,Ko),l(ue,Dt),c(e,Co,s),g(st,e,s),c(e,ko,s),c(e,H,s),g(nt,H,null),l(H,es),l(H,Ut),l(H,ts),l(H,N),g(at,N,null),l(N,os),l(N,zt),l(N,ss),g(_e,N,null),l(N,ns),g(Te,N,null),c(e,xo,s),g(rt,e,s),c(e,Wo,s),c(e,x,s),g(it,x,null),l(x,as),l(x,Nt),l(x,rs),g(be,x,null),l(x,is),l(x,Gt),l(x,ls),l(x,G),g(lt,G,null),l(G,ds),l(G,Rt),l(G,cs),g(ye,G,null),l(G,ms),g(Me,G,null),c(e,Jo,s),g(dt,e,s),c(e,Zo,s),c(e,D,s),g(ct,D,null),l(D,ps),l(D,Bt),l(D,hs),l(D,Vt),l(D,fs),l(D,R),g(mt,R,null),l(R,gs),l(R,Xt),l(R,us),g(ve,R,null),l(R,_s),g(we,R,null),c(e,Do,s),g(pt,e,s),c(e,Uo,s),c(e,C,s),g(ht,C,null),l(C,Ts),l(C,Yt),l(C,bs),l(C,Et),l(C,ys),l(C,Pt),l(C,Ms),l(C,Lt),l(C,vs),l(C,B),g(ft,B,null),l(B,ws),l(B,Ht),l(B,$s),g($e,B,null),l(B,Fs),g(Fe,B,null),c(e,zo,s),g(gt,e,s),c(e,No,s),c(e,S,s),g(ut,S,null),l(S,Is),l(S,St),l(S,js),l(S,V),g(_t,V,null),l(V,Cs),l(V,qt),l(V,ks),g(Ie,V,null),l(V,xs),g(je,V,null),c(e,Go,s),g(Tt,e,s),c(e,Ro,s),c(e,q,s),g(bt,q,null),l(q,Ws),l(q,Qt),l(q,Js),l(q,X),g(yt,X,null),l(X,Zs),l(X,At),l(X,Ds),g(Ce,X,null),l(X,Us),g(ke,X,null),c(e,Bo,s),g(Mt,e,s),c(e,Vo,s),c(e,U,s),g(vt,U,null),l(U,zs),l(U,Ot),l(U,Ns),l(U,Kt),l(U,Gs),l(U,Y),g(wt,Y,null),l(Y,Rs),l(Y,eo),l(Y,Bs),g(xe,Y,null),l(Y,Vs),g(We,Y,null),c(e,Xo,s),g($t,e,s),c(e,Yo,s),c(e,k,s),g(Ft,k,null),l(k,Xs),l(k,to),l(k,Ys),l(k,oo),l(k,Es),l(k,so),l(k,Ps),l(k,no),l(k,Ls),l(k,E),g(It,E,null),l(E,Hs),l(E,ao),l(E,Ss),g(Je,E,null),l(E,qs),g(Ze,E,null),c(e,Eo,s),c(e,ro,s),Po=!0},p(e,[s]){const Q={};s&2&&(Q.$$scope={dirty:s,ctx:e}),v.$set(Q);const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),fe.$set(jt);const Ct={};s&2&&(Ct.$$scope={dirty:s,ctx:e}),_e.$set(Ct);const le={};s&2&&(le.$$scope={dirty:s,ctx:e}),Te.$set(le);const kt={};s&2&&(kt.$$scope={dirty:s,ctx:e}),be.$set(kt);const de={};s&2&&(de.$$scope={dirty:s,ctx:e}),ye.$set(de);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),Me.$set(A);const z={};s&2&&(z.$$scope={dirty:s,ctx:e}),ve.$set(z);const O={};s&2&&(O.$$scope={dirty:s,ctx:e}),we.$set(O);const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),$e.$set(K);const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),Fe.$set(ee);const W={};s&2&&(W.$$scope={dirty:s,ctx:e}),Ie.$set(W);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),je.$set(te);const ce={};s&2&&(ce.$$scope={dirty:s,ctx:e}),Ce.$set(ce);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),ke.$set(oe);const me={};s&2&&(me.$$scope={dirty:s,ctx:e}),xe.$set(me);const se={};s&2&&(se.$$scope={dirty:s,ctx:e}),We.$set(se);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:e}),Je.$set(ne);const ae={};s&2&&(ae.$$scope={dirty:s,ctx:e}),Ze.$set(ae)},i(e){Po||(u(M.$$.fragment,e),u(v.$$.fragment,e),u(Ue.$$.fragment,e),u(Xe.$$.fragment,e),u(Ee.$$.fragment,e),u(qe.$$.fragment,e),u(Qe.$$.fragment,e),u(fe.$$.fragment,e),u(Ae.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(st.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(_e.$$.fragment,e),u(Te.$$.fragment,e),u(rt.$$.fragment,e),u(it.$$.fragment,e),u(be.$$.fragment,e),u(lt.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(pt.$$.fragment,e),u(ht.$$.fragment,e),u(ft.$$.fragment,e),u($e.$$.fragment,e),u(Fe.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(_t.$$.fragment,e),u(Ie.$$.fragment,e),u(je.$$.fragment,e),u(Tt.$$.fragment,e),u(bt.$$.fragment,e),u(yt.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),u(Mt.$$.fragment,e),u(vt.$$.fragment,e),u(wt.$$.fragment,e),u(xe.$$.fragment,e),u(We.$$.fragment,e),u($t.$$.fragment,e),u(Ft.$$.fragment,e),u(It.$$.fragment,e),u(Je.$$.fragment,e),u(Ze.$$.fragment,e),Po=!0)},o(e){_(M.$$.fragment,e),_(v.$$.fragment,e),_(Ue.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(qe.$$.fragment,e),_(Qe.$$.fragment,e),_(fe.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(st.$$.fragment,e),_(nt.$$.fragment,e),_(at.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(rt.$$.fragment,e),_(it.$$.fragment,e),_(be.$$.fragment,e),_(lt.$$.fragment,e),_(ye.$$.fragment,e),_(Me.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(mt.$$.fragment,e),_(ve.$$.fragment,e),_(we.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(ft.$$.fragment,e),_($e.$$.fragment,e),_(Fe.$$.fragment,e),_(gt.$$.fragment,e),_(ut.$$.fragment,e),_(_t.$$.fragment,e),_(Ie.$$.fragment,e),_(je.$$.fragment,e),_(Tt.$$.fragment,e),_(bt.$$.fragment,e),_(yt.$$.fragment,e),_(Ce.$$.fragment,e),_(ke.$$.fragment,e),_(Mt.$$.fragment,e),_(vt.$$.fragment,e),_(wt.$$.fragment,e),_(xe.$$.fragment,e),_(We.$$.fragment,e),_($t.$$.fragment,e),_(Ft.$$.fragment,e),_(It.$$.fragment,e),_(Je.$$.fragment,e),_(Ze.$$.fragment,e),Po=!1},d(e){e&&(n(b),n(a),n(d),n(o),n(io),n(lo),n(ze),n(co),n(Ne),n(mo),n(Ge),n(po),n(Re),n(ho),n(Be),n(fo),n(Ve),n(go),n(uo),n(Ye),n(_o),n(To),n(Pe),n(bo),n(Le),n(yo),n(He),n(Mo),n(Se),n(vo),n(wo),n(Z),n($o),n(Fo),n(ie),n(Io),n(jo),n(L),n(Co),n(ko),n(H),n(xo),n(Wo),n(x),n(Jo),n(Zo),n(D),n(Do),n(Uo),n(C),n(zo),n(No),n(S),n(Go),n(Ro),n(q),n(Bo),n(Vo),n(U),n(Xo),n(Yo),n(k),n(Eo),n(ro)),n(t),T(M,e),T(v,e),T(Ue,e),T(Xe,e),T(Ee,e),T(qe,e),T(Qe),T(fe),T(Ae,e),T(Oe),T(Ke),T(et,e),T(tt),T(ot),T(st,e),T(nt),T(at),T(_e),T(Te),T(rt,e),T(it),T(be),T(lt),T(ye),T(Me),T(dt,e),T(ct),T(mt),T(ve),T(we),T(pt,e),T(ht),T(ft),T($e),T(Fe),T(gt,e),T(ut),T(_t),T(Ie),T(je),T(Tt,e),T(bt),T(yt),T(Ce),T(ke),T(Mt,e),T(vt),T(wt),T(xe),T(We),T($t,e),T(Ft),T(It),T(Je),T(Ze)}}}const ca='{"title":"DeiT","local":"deit","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"DeiTConfig","local":"transformers.DeiTConfig","sections":[],"depth":2},{"title":"DeiTFeatureExtractor","local":"transformers.DeiTFeatureExtractor","sections":[],"depth":2},{"title":"DeiTImageProcessor","local":"transformers.DeiTImageProcessor","sections":[],"depth":2},{"title":"DeiTModel","local":"transformers.DeiTModel","sections":[],"depth":2},{"title":"DeiTForMaskedImageModeling","local":"transformers.DeiTForMaskedImageModeling","sections":[],"depth":2},{"title":"DeiTForImageClassification","local":"transformers.DeiTForImageClassification","sections":[],"depth":2},{"title":"DeiTForImageClassificationWithTeacher","local":"transformers.DeiTForImageClassificationWithTeacher","sections":[],"depth":2},{"title":"TFDeiTModel","local":"transformers.TFDeiTModel","sections":[],"depth":2},{"title":"TFDeiTForMaskedImageModeling","local":"transformers.TFDeiTForMaskedImageModeling","sections":[],"depth":2},{"title":"TFDeiTForImageClassification","local":"transformers.TFDeiTForImageClassification","sections":[],"depth":2},{"title":"TFDeiTForImageClassificationWithTeacher","local":"transformers.TFDeiTForImageClassificationWithTeacher","sections":[],"depth":2}],"depth":1}';function ma(w){return Rn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends Bn{constructor(t){super(),Vn(this,t,ma,da,Gn,{})}}export{ya as component};
