import{s as qs,o as zs,n as vt}from"../chunks/scheduler.9bc65507.js";import{S as Ps,i as Es,g as i,s,r as p,A as Qs,h as o,f as l,c as a,j as As,u as d,x as r,k as Ns,l as Cn,y as Ys,a as n,v as u,d as f,t as c,w as b}from"../chunks/index.707bf1b6.js";import{T as $t}from"../chunks/Tip.c2ecdbf4.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";import{H as T}from"../chunks/Heading.342b1fa6.js";function Ss(w){let m,y="Note that this feature is experimental and might considerably change in future versions. For instance, the Flash Attention 2 API might migrate to <code>BetterTransformer</code> API in the near future.";return{c(){m=i("p"),m.innerHTML=y},l(h){m=o(h,"P",{"data-svelte-h":!0}),r(m)!=="svelte-fxlao8"&&(m.innerHTML=y)},m(h,g){n(h,m,g)},p:vt,d(h){h&&l(m)}}}function Ds(w){let m,y="Flash Attention 2 can only be used when the models’ dtype is  <code>fp16</code> or <code>bf16</code> and runs only on NVIDIA-GPU devices. Make sure to cast your model to the appropriate dtype and load them on a supported device before using that feature.";return{c(){m=i("p"),m.innerHTML=y},l(h){m=o(h,"P",{"data-svelte-h":!0}),r(m)!=="svelte-eut2r7"&&(m.innerHTML=y)},m(h,g){n(h,m,g)},p:vt,d(h){h&&l(m)}}}function Ks(w){let m,y="Flash Attention can only be used for models using fp16 or bf16 dtype. Make sure to cast your model to the appropriate dtype before using BetterTransformer.";return{c(){m=i("p"),m.textContent=y},l(h){m=o(h,"P",{"data-svelte-h":!0}),r(m)!=="svelte-1291w1c"&&(m.textContent=y)},m(h,g){n(h,m,g)},p:vt,d(h){h&&l(m)}}}function Os(w){let m,y="Note that this feature can also be used in a multi GPU setup.";return{c(){m=i("p"),m.textContent=y},l(h){m=o(h,"P",{"data-svelte-h":!0}),r(m)!=="svelte-8elnl8"&&(m.textContent=y)},m(h,g){n(h,m,g)},p:vt,d(h){h&&l(m)}}}function ea(w){let m,y="Note that this feature can also be used in a multi GPU setup.";return{c(){m=i("p"),m.textContent=y},l(h){m=o(h,"P",{"data-svelte-h":!0}),r(m)!=="svelte-8elnl8"&&(m.textContent=y)},m(h,g){n(h,m,g)},p:vt,d(h){h&&l(m)}}}function ta(w){let m,y,h,g,Z,xt,j,kn='In addition to this guide, relevant information can be found as well in <a href="perf_train_gpu_one">the guide for training on a single GPU</a> and <a href="perf_infer_cpu">the guide for inference on CPUs</a>.',_t,B,Ct,J,kt,G,Un='Flash Attention 2 can considerably speed up transformer-based models’ training and inference speed. Flash Attention 2 has been introduced in the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">official Flash Attention repository</a> by Tri Dao et al. The scientific paper on Flash Attention can be found <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">here</a>.',Ut,I,Wn="Make sure to follow the installation guide on the repository mentioned above to properly install Flash Attention 2. Once that package is installed, you can benefit from this feature.",Wt,F,Zn="We natively support Flash Attention 2 for the following models:",Zt,V,jn="<li>Llama</li> <li>Mistral</li> <li>Falcon</li>",jt,X,Bn="You can request to add Flash Attention 2 support for more models by opening an issue on GitHub, and even open a Pull Request to integrate the changes. The supported models can be used for inference and training, including training with padding tokens - <em>which is currently not supported for <code>BetterTransformer</code> API below.</em>",Bt,$,Gt,R,It,H,Gn="To enable Flash Attention 2 in your model, add <code>use_flash_attention_2</code> in the <code>from_pretrained</code> arguments:",Ft,L,Vt,A,In="And use it for generation or fine-tuning.",Xt,N,Rt,q,Fn="You can benefit from considerable speedups for fine-tuning and inference, especially for long sequences. However, since Flash Attention does not support computing attention scores with padding tokens under the hood, we must manually pad / unpad the attention scores for batched inference when the sequence contains padding tokens. This leads to a significant slowdown for batched generations with padding tokens.",Ht,z,Vn='To overcome this, one should use Flash Attention without padding tokens in the sequence for training (e.g., by packing a dataset, i.e., concatenating sequences until reaching the maximum sequence length. An example is provided <a href="https://github.com/huggingface/transformers/blob/main/examples/pytorch/language-modeling/run_clm.py#L516" rel="nofollow">here</a>.',Lt,P,Xn='Below is the expected speedup you can get for a simple forward pass on <a href="https://hf.co/tiiuae/falcon-7b" rel="nofollow">tiiuae/falcon-7b</a> with a sequence length of 4096 and various batch sizes, without padding tokens:',At,v,Rn='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/falcon-7b-inference-large-seqlen.png"/>',Nt,E,Hn='Below is the expected speedup you can get for a simple forward pass on <a href="https://hf.co/meta-llama/Llama-7b-hf" rel="nofollow"><code>meta-llama/Llama-7b-hf</code></a> with a sequence length of 4096 and various batch sizes, without padding tokens:',qt,x,Ln='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/llama-7b-inference-large-seqlen.png"/>',zt,Q,An="For sequences with padding tokens (training with padding tokens or generating with padding tokens), we need to unpad / pad the input sequences to compute correctly the attention scores. For relatively small sequence length, on pure forward pass, this creates an overhead leading to a small speedup (below 30% of the input has been filled with padding tokens).",Pt,_,Nn='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/llama-2-small-seqlen-padding.png"/>',Et,Y,qn="But for large sequence length you can benefit from interesting speedup for pure inference (also training)",Qt,S,zn='Note that Flash Attention makes the attention computation more memory efficient, meaning you can train with much larger sequence lengths without facing CUDA OOM issues. It can lead up to memory reduction up to 20 for large sequence length. Check out <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">the official flash attention repository</a> for more details.',Yt,C,Pn='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/llama-2-large-seqlen-padding.png"/>',St,D,Dt,K,En="You can combine this feature with many exisiting feature for model optimization. Check out few examples below:",Kt,O,Ot,ee,Qn="You can combine this feature together with 8-bit quantization:",el,te,tl,le,ll,ne,Yn="You can combine this feature together with 4-bit quantization:",nl,se,sl,ae,al,ie,Sn="You can combine this feature together with PEFT for training adapters using Flash Attention 2 under the hood:",il,oe,ol,re,rl,me,Dn='<a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">BetterTransformer</a> converts 🤗 Transformers models to use the PyTorch-native fastpath execution, which calls optimized kernels like Flash Attention under the hood.',ml,pe,Kn="BetterTransformer is also supported for faster inference on single and multi-GPU for text, image, and audio models.",pl,k,dl,de,ul,ue,On='PyTorch-native <a href="https://pytorch.org/blog/a-better-transformer-for-fast-transformer-encoder-inference/" rel="nofollow"><code>nn.MultiHeadAttention</code></a> attention fastpath, called BetterTransformer, can be used with Transformers through the integration in the <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">🤗 Optimum library</a>.',fl,fe,es='PyTorch’s attention fastpath allows to speed up inference through kernel fusions and the use of <a href="https://pytorch.org/docs/stable/nested.html" rel="nofollow">nested tensors</a>. Detailed benchmarks can be found in <a href="https://medium.com/pytorch/bettertransformer-out-of-the-box-performance-for-huggingface-transformers-3fbe27d50ab2" rel="nofollow">this blog post</a>.',cl,ce,ts='After installing the <a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a> package, to use Better Transformer during inference, the relevant internal modules are replaced by calling <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.to_bettertransformer">to_bettertransformer()</a>:',bl,be,hl,he,ls='The method <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.reverse_bettertransformer">reverse_bettertransformer()</a> allows to go back to the original modeling, which should be used before saving the model in order to use the canonical transformers modeling:',Tl,Te,yl,ye,ns='Have a look at this <a href="https://medium.com/pytorch/bettertransformer-out-of-the-box-performance-for-huggingface-transformers-3fbe27d50ab2" rel="nofollow">blog post</a> to learn more about what is possible to do with <code>BetterTransformer</code> API for encoder models.',Ml,Me,gl,ge,ss='For text models, especially decoder-based models (GPT, T5, Llama, etc.), the BetterTransformer API converts all attention operations to use the <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code> operator</a> (SDPA) that is only available in PyTorch 2.0 and onwards.',wl,we,as="To convert a model to BetterTransformer:",Jl,Je,$l,$e,is='SDPA can also call <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> kernels under the hood. To enable Flash Attention or to check that it is available in a given setting (hardware, problem size), use <a href="https://pytorch.org/docs/master/backends.html#torch.backends.cuda.sdp_kernel" rel="nofollow"><code>torch.backends.cuda.sdp_kernel</code></a> as a context manager:',vl,ve,xl,xe,os="If you see a bug with a traceback saying",_l,_e,Cl,Ce,rs="try using the PyTorch nightly version, which may have a broader coverage for Flash Attention:",kl,ke,Ul,Ue,ms="Or make sure your model is correctly casted in float16 or bfloat16",Wl,We,ps='Have a look at <a href="https://pytorch.org/blog/out-of-the-box-acceleration/" rel="nofollow">this detailed blogpost</a> to read more about what is possible to do with <code>BetterTransformer</code> + SDPA API.',Zl,Ze,jl,je,ds="You can install <code>bitsandbytes</code> and benefit from easy model compression on GPUs. Using FP4 quantization you can expect to reduce up to 8x the model size compared to its native full precision version. Check out below how to get started.",Bl,U,Gl,Be,Il,Ge,us=`<li><p>Latest <code>bitsandbytes</code> library
<code>pip install bitsandbytes&gt;=0.39.0</code></p></li> <li><p>Install latest <code>accelerate</code> from source
<code>pip install git+https://github.com/huggingface/accelerate.git</code></p></li> <li><p>Install latest <code>transformers</code> from source
<code>pip install git+https://github.com/huggingface/transformers.git</code></p></li>`,Fl,Ie,Vl,Fe,fs="You can quickly run a FP4 model on a single GPU by running the following code:",Xl,Ve,Rl,Xe,cs="Note that <code>device_map</code> is optional but setting <code>device_map = &#39;auto&#39;</code> is prefered for inference as it will dispatch efficiently the model on the available ressources.",Hl,Re,Ll,He,bs="The way to load your mixed 4-bit model in multiple GPUs is as follows (same command as single GPU setup):",Al,Le,Nl,Ae,hs="But you can control the GPU RAM you want to allocate on each GPU using <code>accelerate</code>. Use the <code>max_memory</code> argument as follows:",ql,Ne,zl,qe,Ts="In this example, the first GPU will use 600MB of memory and the second 1GB.",Pl,ze,El,Pe,ys='For more advanced usage of this method, please have a look at the <a href="main_classes/quantization">quantization</a> documentation page.',Ql,Ee,Yl,W,Sl,Qe,Ms=`From the paper <a href="https://arxiv.org/abs/2208.07339" rel="nofollow"><code>LLM.int8() : 8-bit Matrix Multiplication for Transformers at Scale</code></a>, we support Hugging Face integration for all models in the Hub with a few lines of code.
The method reduces <code>nn.Linear</code> size by 2 for <code>float16</code> and <code>bfloat16</code> weights and by 4 for <code>float32</code> weights, with close to no impact to the quality by operating on the outliers in half-precision.`,Dl,Ye,gs='<img src="https://cdn-uploads.huggingface.co/production/uploads/1659861207959-62441d1d9fdefb55a0b7d12c.png" alt="HFxbitsandbytes.png"/>',Kl,Se,ws=`Int8 mixed-precision matrix decomposition works by separating a matrix multiplication into two streams: (1) a systematic feature outlier stream matrix multiplied in fp16 (0.01%), (2) a regular stream of int8 matrix multiplication (99.9%). With this method, int8 inference with no predictive degradation is possible for very large models.
For more details regarding the method, check out the <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">paper</a> or our <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blogpost about the integration</a>.`,Ol,De,Js='<img src="https://cdn-uploads.huggingface.co/production/uploads/1660567469965-62441d1d9fdefb55a0b7d12c.gif" alt="MixedInt8.gif"/>',en,Ke,$s=`Note, that you would require a GPU to run mixed-8bit models as the kernels have been compiled for GPUs only. Make sure that you have enough GPU memory to store the quarter (or half if your model weights are in half precision) of the model before using this feature.
Below are some notes to help you use this module, or follow the demos on <a href="#colab-demos">Google colab</a>.`,tn,Oe,ln,et,vs=`<li>If you have <code>bitsandbytes&lt;0.37.0</code>, make sure you run on NVIDIA GPUs that support 8-bit tensor cores (Turing, Ampere or newer architectures - e.g. T4, RTX20s RTX30s, A40-A100). For <code>bitsandbytes&gt;=0.37.0</code>, all GPUs should be supported.</li> <li>Install the correct version of <code>bitsandbytes</code> by running:
<code>pip install bitsandbytes&gt;=0.31.5</code></li> <li>Install <code>accelerate</code> <code>pip install accelerate&gt;=0.12.0</code></li>`,nn,tt,sn,lt,xs="After installing the required libraries, the way to load your mixed 8-bit model is as follows:",an,nt,on,st,_s="For text generation, we recommend:",rn,at,Cs="<li>using the model’s <code>generate()</code> method instead of the <code>pipeline()</code> function. Although inference is possible with the <code>pipeline()</code> function, it is not optimized for mixed-8bit models, and will be slower than using the <code>generate()</code> method. Moreover, some sampling strategies are like nucleaus sampling are not supported by the <code>pipeline()</code> function for mixed-8bit models.</li> <li>placing all inputs on the same device as the model.</li>",mn,it,ks="Here is a simple example:",pn,ot,dn,rt,un,mt,Us="The way to load your mixed 8-bit model in multiple GPUs is as follows (same command as single GPU setup):",fn,pt,cn,dt,Ws="But you can control the GPU RAM you want to allocate on each GPU using <code>accelerate</code>. Use the <code>max_memory</code> argument as follows:",bn,ut,hn,ft,Zs="In this example, the first GPU will use 1GB of memory and the second 2GB.",Tn,ct,yn,bt,js=`With this method you can infer on models that were not possible to infer on a Google Colab before.
Check out the demo for running T5-11b (42GB in fp32)! Using 8-bit quantization on Google Colab:`,Mn,ht,Bs='<a href="https://colab.research.google.com/drive/1YORPWx4okIHXnjW7MSAidXN29mPVNT7F?usp=sharing" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab: T5-11b demo"/></a>',gn,Tt,Gs="Or this demo for BLOOM-3B:",wn,yt,Is='<a href="https://colab.research.google.com/drive/1qOjXfQIAULfKvZqwCen8-MoWKGdSatZ4?usp=sharing" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab: BLOOM-3b demo"/></a>',Jn,Mt,$n,gt,Fs="You can combine the different methods described above to get the best performance for your model. For example, you can use BetterTransformer with FP4 mixed-precision inference + flash attention:",vn,wt,xn,Jt,_n;return Z=new T({props:{title:"Efficient Inference on a Single GPU",local:"efficient-inference-on-a-single-gpu",headingTag:"h1"}}),B=new T({props:{title:"Flash Attention 2",local:"flash-attention-2",headingTag:"h2"}}),J=new $t({props:{$$slots:{default:[Ss]},$$scope:{ctx:w}}}),$=new $t({props:{$$slots:{default:[Ds]},$$scope:{ctx:w}}}),R=new T({props:{title:"Quick usage",local:"quick-usage",headingTag:"h3"}}),L=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGlpdWFlJTJGZmFsY29uLTdiJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LlamaForCausalLM

model_id = <span class="hljs-string">&quot;tiiuae/falcon-7b&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(
    model_id, 
    torch_dtype=torch.bfloat16, 
    use_flash_attention_2=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),N=new T({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),D=new T({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h3"}}),O=new T({props:{title:"Combining Flash Attention 2 and 8-bit models",local:"combining-flash-attention-2-and-8-bit-models",headingTag:"h3"}}),te=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGlpdWFlJTJGZmFsY29uLTdiJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LlamaForCausalLM

model_id = <span class="hljs-string">&quot;tiiuae/falcon-7b&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(
    model_id, 
    load_in_8bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),le=new T({props:{title:"Combining Flash Attention 2 and 4-bit models",local:"combining-flash-attention-2-and-4-bit-models",headingTag:"h3"}}),se=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTGxhbWFGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIydGlpdWFlJTJGZmFsY29uLTdiJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LlamaForCausalLM

model_id = <span class="hljs-string">&quot;tiiuae/falcon-7b&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(
    model_id, 
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ae=new T({props:{title:"Combining Flash Attention 2 and PEFT",local:"combining-flash-attention-2-and-peft",headingTag:"h3"}}),oe=new M({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIzJTIwdHJhaW4lMjB5b3VyJTIwbW9kZWw=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LlamaForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model_id = <span class="hljs-string">&quot;tiiuae/falcon-7b&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(
    model_id, 
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>,
)

lora_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model.add_adapter(lora_config)

<span class="hljs-meta">... </span><span class="hljs-comment"># train your model</span>`,wrap:!1}}),re=new T({props:{title:"BetterTransformer",local:"bettertransformer",headingTag:"h2"}}),k=new $t({props:{$$slots:{default:[Ks]},$$scope:{ctx:w}}}),de=new T({props:{title:"Encoder models",local:"encoder-models",headingTag:"h3"}}),be=new M({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigp",highlighted:"model = model.to_bettertransformer()",wrap:!1}}),Te=new M({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC5yZXZlcnNlX2JldHRlcnRyYW5zZm9ybWVyKCklMEFtb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyc2F2ZWRfbW9kZWwlMjIp",highlighted:`model = model.reverse_bettertransformer()
model.save_pretrained(<span class="hljs-string">&quot;saved_model&quot;</span>)`,wrap:!1}}),Me=new T({props:{title:"Decoder models",local:"decoder-models",headingTag:"h3"}}),Je=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMjMlMjBjb252ZXJ0JTIwdGhlJTIwbW9kZWwlMjB0byUyMEJldHRlclRyYW5zZm9ybWVyJTBBbW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKSUwQSUwQSUyMyUyMFVzZSUyMGl0JTIwZm9yJTIwdHJhaW5pbmclMjBvciUyMGluZmVyZW5jZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-comment"># convert the model to BetterTransformer</span>
model.to_bettertransformer()

<span class="hljs-comment"># Use it for training or inference</span>`,wrap:!1}}),ve=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUyMyUyMGNvbnZlcnQlMjB0aGUlMjBtb2RlbCUyMHRvJTIwQmV0dGVyVHJhbnNmb3JtZXIlMEFtb2RlbC50b19iZXR0ZXJ0cmFuc2Zvcm1lcigpJTBBJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTJCJTIwd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`import torch
from transformers import AutoModelForCausalLM, AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(&quot;facebook/opt-350m&quot;)
model = AutoModelForCausalLM.from_pretrained(&quot;facebook/opt-350m&quot;, torch_dtype=torch.float16).to(&quot;cuda&quot;)
# convert the model to BetterTransformer
model.to_bettertransformer()

input_text = &quot;Hello my dog is cute and&quot;
inputs = tokenizer(input_text, return_tensors=&quot;pt&quot;).to(&quot;cuda&quot;)

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    outputs = model.generate(**inputs)

print(tokenizer.decode(outputs[0], skip_special_tokens=True))`,wrap:!1}}),_e=new M({props:{code:"UnVudGltZUVycm9yJTNBJTIwTm8lMjBhdmFpbGFibGUlMjBrZXJuZWwuJTIwJTIwQWJvcnRpbmclMjBleGVjdXRpb24u",highlighted:"RuntimeError: No available kernel.  Aborting execution.",wrap:!1}}),ke=new M({props:{code:"cGlwMyUyMGluc3RhbGwlMjAtVSUyMC0tcHJlJTIwdG9yY2glMjB0b3JjaHZpc2lvbiUyMHRvcmNoYXVkaW8lMjAtLWluZGV4LXVybCUyMGh0dHBzJTNBJTJGJTJGZG93bmxvYWQucHl0b3JjaC5vcmclMkZ3aGwlMkZuaWdodGx5JTJGY3UxMTg=",highlighted:"pip3 install -U --pre torch torchvision torchaudio --index-url https://download.pytorch.org/whl/nightly/cu118",wrap:!1}}),Ze=new T({props:{title:"bitsandbytes integration for FP4 mixed-precision inference",local:"bitsandbytes-integration-for-fp4-mixed-precision-inference",headingTag:"h2"}}),U=new $t({props:{$$slots:{default:[Os]},$$scope:{ctx:w}}}),Be=new T({props:{title:"Requirements",local:"requirements-for-fp4-mixedprecision-inference",headingTag:"h3"}}),Ie=new T({props:{title:"Running FP4 models - single GPU setup - Quickstart",local:"running-fp4-models---single-gpu-setup---quickstart",headingTag:"h3"}}),Ve=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbS0yYjUlMjIlMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_name = <span class="hljs-string">&quot;bigscience/bloom-2b5&quot;</span>
model_4bit = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),Re=new T({props:{title:"Running FP4 models - multi GPU setup",local:"running-fp4-models---multi-gpu-setup",headingTag:"h3"}}),Le=new M({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbS0yYjUlMjIlMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUp",highlighted:`model_name = <span class="hljs-string">&quot;bigscience/bloom-2b5&quot;</span>
model_4bit = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ne=new M({props:{code:"bWF4X21lbW9yeV9tYXBwaW5nJTIwJTNEJTIwJTdCMCUzQSUyMCUyMjYwME1CJTIyJTJDJTIwMSUzQSUyMCUyMjFHQiUyMiU3RCUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tM2IlMjIlMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBtYXhfbWVtb3J5JTNEbWF4X21lbW9yeV9tYXBwaW5nJTBBKQ==",highlighted:`max_memory_mapping = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;600MB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;1GB&quot;</span>}
model_name = <span class="hljs-string">&quot;bigscience/bloom-3b&quot;</span>
model_4bit = AutoModelForCausalLM.from_pretrained(
    model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, max_memory=max_memory_mapping
)`,wrap:!1}}),ze=new T({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h3"}}),Ee=new T({props:{title:"bitsandbytes integration for Int8 mixed-precision matrix decomposition",local:"bitsandbytes-integration-for-int8-mixed-precision-matrix-decomposition",headingTag:"h2"}}),W=new $t({props:{$$slots:{default:[ea]},$$scope:{ctx:w}}}),Oe=new T({props:{title:"Requirements",local:"requirements-for-int8-mixedprecision-matrix-decomposition",headingTag:"h3"}}),tt=new T({props:{title:"Running mixed-Int8 models - single GPU setup",local:"running-mixed-int8-models---single-gpu-setup",headingTag:"h3"}}),nt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbS0yYjUlMjIlMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_name = <span class="hljs-string">&quot;bigscience/bloom-2b5&quot;</span>
model_8bit = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),ot=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMmI1JTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySGVsbG8lMkMlMjBteSUyMGxsYW1hJTIwaXMlMjBjdXRlJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQW91dHB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_name = <span class="hljs-string">&quot;bigscience/bloom-2b5&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_name)
model_8bit = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)

prompt = <span class="hljs-string">&quot;Hello, my llama is cute&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generated_ids = model.generate(**inputs)
outputs = tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),rt=new T({props:{title:"Running mixed-int8 models - multi GPU setup",local:"running-mixed-int8-models---multi-gpu-setup",headingTag:"h3"}}),pt=new M({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbS0yYjUlMjIlMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX25hbWUlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUp",highlighted:`model_name = <span class="hljs-string">&quot;bigscience/bloom-2b5&quot;</span>
model_8bit = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),ut=new M({props:{code:"bWF4X21lbW9yeV9tYXBwaW5nJTIwJTNEJTIwJTdCMCUzQSUyMCUyMjFHQiUyMiUyQyUyMDElM0ElMjAlMjIyR0IlMjIlN0QlMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTNiJTIyJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwbWF4X21lbW9yeSUzRG1heF9tZW1vcnlfbWFwcGluZyUwQSk=",highlighted:`max_memory_mapping = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;1GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;2GB&quot;</span>}
model_name = <span class="hljs-string">&quot;bigscience/bloom-3b&quot;</span>
model_8bit = AutoModelForCausalLM.from_pretrained(
    model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, max_memory=max_memory_mapping
)`,wrap:!1}}),ct=new T({props:{title:"Colab demos",local:"colab-demos",headingTag:"h3"}}),Mt=new T({props:{title:"Advanced usage: mixing FP4 (or Int8) and BetterTransformer",local:"advanced-usage-mixing-fp4-or-int8-and-bettertransformer",headingTag:"h2"}}),wt=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBJTBBaW5wdXRfdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0cyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.float16
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, quantization_config=quantization_config)

input_text = <span class="hljs-string">&quot;Hello my dog is cute and&quot;</span>
inputs = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    outputs = model.generate(**inputs)

<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),{c(){m=i("meta"),y=s(),h=i("p"),g=s(),p(Z.$$.fragment),xt=s(),j=i("p"),j.innerHTML=kn,_t=s(),p(B.$$.fragment),Ct=s(),p(J.$$.fragment),kt=s(),G=i("p"),G.innerHTML=Un,Ut=s(),I=i("p"),I.textContent=Wn,Wt=s(),F=i("p"),F.textContent=Zn,Zt=s(),V=i("ul"),V.innerHTML=jn,jt=s(),X=i("p"),X.innerHTML=Bn,Bt=s(),p($.$$.fragment),Gt=s(),p(R.$$.fragment),It=s(),H=i("p"),H.innerHTML=Gn,Ft=s(),p(L.$$.fragment),Vt=s(),A=i("p"),A.textContent=In,Xt=s(),p(N.$$.fragment),Rt=s(),q=i("p"),q.textContent=Fn,Ht=s(),z=i("p"),z.innerHTML=Vn,Lt=s(),P=i("p"),P.innerHTML=Xn,At=s(),v=i("div"),v.innerHTML=Rn,Nt=s(),E=i("p"),E.innerHTML=Hn,qt=s(),x=i("div"),x.innerHTML=Ln,zt=s(),Q=i("p"),Q.textContent=An,Pt=s(),_=i("div"),_.innerHTML=Nn,Et=s(),Y=i("p"),Y.textContent=qn,Qt=s(),S=i("p"),S.innerHTML=zn,Yt=s(),C=i("div"),C.innerHTML=Pn,St=s(),p(D.$$.fragment),Dt=s(),K=i("p"),K.textContent=En,Kt=s(),p(O.$$.fragment),Ot=s(),ee=i("p"),ee.textContent=Qn,el=s(),p(te.$$.fragment),tl=s(),p(le.$$.fragment),ll=s(),ne=i("p"),ne.textContent=Yn,nl=s(),p(se.$$.fragment),sl=s(),p(ae.$$.fragment),al=s(),ie=i("p"),ie.textContent=Sn,il=s(),p(oe.$$.fragment),ol=s(),p(re.$$.fragment),rl=s(),me=i("p"),me.innerHTML=Dn,ml=s(),pe=i("p"),pe.textContent=Kn,pl=s(),p(k.$$.fragment),dl=s(),p(de.$$.fragment),ul=s(),ue=i("p"),ue.innerHTML=On,fl=s(),fe=i("p"),fe.innerHTML=es,cl=s(),ce=i("p"),ce.innerHTML=ts,bl=s(),p(be.$$.fragment),hl=s(),he=i("p"),he.innerHTML=ls,Tl=s(),p(Te.$$.fragment),yl=s(),ye=i("p"),ye.innerHTML=ns,Ml=s(),p(Me.$$.fragment),gl=s(),ge=i("p"),ge.innerHTML=ss,wl=s(),we=i("p"),we.textContent=as,Jl=s(),p(Je.$$.fragment),$l=s(),$e=i("p"),$e.innerHTML=is,vl=s(),p(ve.$$.fragment),xl=s(),xe=i("p"),xe.textContent=os,_l=s(),p(_e.$$.fragment),Cl=s(),Ce=i("p"),Ce.textContent=rs,kl=s(),p(ke.$$.fragment),Ul=s(),Ue=i("p"),Ue.textContent=ms,Wl=s(),We=i("p"),We.innerHTML=ps,Zl=s(),p(Ze.$$.fragment),jl=s(),je=i("p"),je.innerHTML=ds,Bl=s(),p(U.$$.fragment),Gl=s(),p(Be.$$.fragment),Il=s(),Ge=i("ul"),Ge.innerHTML=us,Fl=s(),p(Ie.$$.fragment),Vl=s(),Fe=i("p"),Fe.textContent=fs,Xl=s(),p(Ve.$$.fragment),Rl=s(),Xe=i("p"),Xe.innerHTML=cs,Hl=s(),p(Re.$$.fragment),Ll=s(),He=i("p"),He.textContent=bs,Al=s(),p(Le.$$.fragment),Nl=s(),Ae=i("p"),Ae.innerHTML=hs,ql=s(),p(Ne.$$.fragment),zl=s(),qe=i("p"),qe.textContent=Ts,Pl=s(),p(ze.$$.fragment),El=s(),Pe=i("p"),Pe.innerHTML=ys,Ql=s(),p(Ee.$$.fragment),Yl=s(),p(W.$$.fragment),Sl=s(),Qe=i("p"),Qe.innerHTML=Ms,Dl=s(),Ye=i("p"),Ye.innerHTML=gs,Kl=s(),Se=i("p"),Se.innerHTML=ws,Ol=s(),De=i("p"),De.innerHTML=Js,en=s(),Ke=i("p"),Ke.innerHTML=$s,tn=s(),p(Oe.$$.fragment),ln=s(),et=i("ul"),et.innerHTML=vs,nn=s(),p(tt.$$.fragment),sn=s(),lt=i("p"),lt.textContent=xs,an=s(),p(nt.$$.fragment),on=s(),st=i("p"),st.textContent=_s,rn=s(),at=i("ul"),at.innerHTML=Cs,mn=s(),it=i("p"),it.textContent=ks,pn=s(),p(ot.$$.fragment),dn=s(),p(rt.$$.fragment),un=s(),mt=i("p"),mt.textContent=Us,fn=s(),p(pt.$$.fragment),cn=s(),dt=i("p"),dt.innerHTML=Ws,bn=s(),p(ut.$$.fragment),hn=s(),ft=i("p"),ft.textContent=Zs,Tn=s(),p(ct.$$.fragment),yn=s(),bt=i("p"),bt.textContent=js,Mn=s(),ht=i("p"),ht.innerHTML=Bs,gn=s(),Tt=i("p"),Tt.textContent=Gs,wn=s(),yt=i("p"),yt.innerHTML=Is,Jn=s(),p(Mt.$$.fragment),$n=s(),gt=i("p"),gt.textContent=Fs,vn=s(),p(wt.$$.fragment),xn=s(),Jt=i("p"),this.h()},l(e){const t=Qs("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),h=o(e,"P",{}),As(h).forEach(l),g=a(e),d(Z.$$.fragment,e),xt=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1rc8nma"&&(j.innerHTML=kn),_t=a(e),d(B.$$.fragment,e),Ct=a(e),d(J.$$.fragment,e),kt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-8zv7xu"&&(G.innerHTML=Un),Ut=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-19glxn"&&(I.textContent=Wn),Wt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1r90pu2"&&(F.textContent=Zn),Zt=a(e),V=o(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-wxur4f"&&(V.innerHTML=jn),jt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-t8med0"&&(X.innerHTML=Bn),Bt=a(e),d($.$$.fragment,e),Gt=a(e),d(R.$$.fragment,e),It=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1s6uht7"&&(H.innerHTML=Gn),Ft=a(e),d(L.$$.fragment,e),Vt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-4hbxax"&&(A.textContent=In),Xt=a(e),d(N.$$.fragment,e),Rt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-100hbud"&&(q.textContent=Fn),Ht=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1yuo00u"&&(z.innerHTML=Vn),Lt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-kc1n9k"&&(P.innerHTML=Xn),At=a(e),v=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(v)!=="svelte-u3wzwi"&&(v.innerHTML=Rn),Nt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-7kubyj"&&(E.innerHTML=Hn),qt=a(e),x=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(x)!=="svelte-1yuov6e"&&(x.innerHTML=Ln),zt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1iptpyc"&&(Q.textContent=An),Pt=a(e),_=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(_)!=="svelte-cixhj1"&&(_.innerHTML=Nn),Et=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-19b9k6o"&&(Y.textContent=qn),Qt=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1xslun6"&&(S.innerHTML=zn),Yt=a(e),C=o(e,"DIV",{style:!0,"data-svelte-h":!0}),r(C)!=="svelte-13f0ql9"&&(C.innerHTML=Pn),St=a(e),d(D.$$.fragment,e),Dt=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1y5jr6"&&(K.textContent=En),Kt=a(e),d(O.$$.fragment,e),Ot=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-5u6scl"&&(ee.textContent=Qn),el=a(e),d(te.$$.fragment,e),tl=a(e),d(le.$$.fragment,e),ll=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1eto5t5"&&(ne.textContent=Yn),nl=a(e),d(se.$$.fragment,e),sl=a(e),d(ae.$$.fragment,e),al=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1clb6eb"&&(ie.textContent=Sn),il=a(e),d(oe.$$.fragment,e),ol=a(e),d(re.$$.fragment,e),rl=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ytgap0"&&(me.innerHTML=Dn),ml=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-6mes7v"&&(pe.textContent=Kn),pl=a(e),d(k.$$.fragment,e),dl=a(e),d(de.$$.fragment,e),ul=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-nfnal9"&&(ue.innerHTML=On),fl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-hiiwis"&&(fe.innerHTML=es),cl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-hmfprl"&&(ce.innerHTML=ts),bl=a(e),d(be.$$.fragment,e),hl=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1jwwx1c"&&(he.innerHTML=ls),Tl=a(e),d(Te.$$.fragment,e),yl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-zi1ja6"&&(ye.innerHTML=ns),Ml=a(e),d(Me.$$.fragment,e),gl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1jgnsw9"&&(ge.innerHTML=ss),wl=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1fsfh6a"&&(we.textContent=as),Jl=a(e),d(Je.$$.fragment,e),$l=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-2zsmk5"&&($e.innerHTML=is),vl=a(e),d(ve.$$.fragment,e),xl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-143u65w"&&(xe.textContent=os),_l=a(e),d(_e.$$.fragment,e),Cl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-10v9ayf"&&(Ce.textContent=rs),kl=a(e),d(ke.$$.fragment,e),Ul=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1chszbv"&&(Ue.textContent=ms),Wl=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1c2vyan"&&(We.innerHTML=ps),Zl=a(e),d(Ze.$$.fragment,e),jl=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1f2adro"&&(je.innerHTML=ds),Bl=a(e),d(U.$$.fragment,e),Gl=a(e),d(Be.$$.fragment,e),Il=a(e),Ge=o(e,"UL",{"data-svelte-h":!0}),r(Ge)!=="svelte-1aope0v"&&(Ge.innerHTML=us),Fl=a(e),d(Ie.$$.fragment,e),Vl=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-3n5bqx"&&(Fe.textContent=fs),Xl=a(e),d(Ve.$$.fragment,e),Rl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-35690t"&&(Xe.innerHTML=cs),Hl=a(e),d(Re.$$.fragment,e),Ll=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-az9b"&&(He.textContent=bs),Al=a(e),d(Le.$$.fragment,e),Nl=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1imlesv"&&(Ae.innerHTML=hs),ql=a(e),d(Ne.$$.fragment,e),zl=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-11kj62i"&&(qe.textContent=Ts),Pl=a(e),d(ze.$$.fragment,e),El=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1y7v4xy"&&(Pe.innerHTML=ys),Ql=a(e),d(Ee.$$.fragment,e),Yl=a(e),d(W.$$.fragment,e),Sl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1t0ywex"&&(Qe.innerHTML=Ms),Dl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1tsrdqi"&&(Ye.innerHTML=gs),Kl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-l1kytk"&&(Se.innerHTML=ws),Ol=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-y2mgdg"&&(De.innerHTML=Js),en=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-2owjpw"&&(Ke.innerHTML=$s),tn=a(e),d(Oe.$$.fragment,e),ln=a(e),et=o(e,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-1xubufj"&&(et.innerHTML=vs),nn=a(e),d(tt.$$.fragment,e),sn=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-x2jn0o"&&(lt.textContent=xs),an=a(e),d(nt.$$.fragment,e),on=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-17lx9k4"&&(st.textContent=_s),rn=a(e),at=o(e,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-4vnupa"&&(at.innerHTML=Cs),mn=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-cbb8c3"&&(it.textContent=ks),pn=a(e),d(ot.$$.fragment,e),dn=a(e),d(rt.$$.fragment,e),un=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-14p1xbn"&&(mt.textContent=Us),fn=a(e),d(pt.$$.fragment,e),cn=a(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1imlesv"&&(dt.innerHTML=Ws),bn=a(e),d(ut.$$.fragment,e),hn=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1fnofha"&&(ft.textContent=Zs),Tn=a(e),d(ct.$$.fragment,e),yn=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1gqy9xc"&&(bt.textContent=js),Mn=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1yb5ek4"&&(ht.innerHTML=Bs),gn=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1spl0eu"&&(Tt.textContent=Gs),wn=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-6z7881"&&(yt.innerHTML=Is),Jn=a(e),d(Mt.$$.fragment,e),$n=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1mbq6eb"&&(gt.textContent=Fs),vn=a(e),d(wt.$$.fragment,e),xn=a(e),Jt=o(e,"P",{}),As(Jt).forEach(l),this.h()},h(){Ns(m,"name","hf:doc:metadata"),Ns(m,"content",la),Cn(v,"text-align","center"),Cn(x,"text-align","center"),Cn(_,"text-align","center"),Cn(C,"text-align","center")},m(e,t){Ys(document.head,m),n(e,y,t),n(e,h,t),n(e,g,t),u(Z,e,t),n(e,xt,t),n(e,j,t),n(e,_t,t),u(B,e,t),n(e,Ct,t),u(J,e,t),n(e,kt,t),n(e,G,t),n(e,Ut,t),n(e,I,t),n(e,Wt,t),n(e,F,t),n(e,Zt,t),n(e,V,t),n(e,jt,t),n(e,X,t),n(e,Bt,t),u($,e,t),n(e,Gt,t),u(R,e,t),n(e,It,t),n(e,H,t),n(e,Ft,t),u(L,e,t),n(e,Vt,t),n(e,A,t),n(e,Xt,t),u(N,e,t),n(e,Rt,t),n(e,q,t),n(e,Ht,t),n(e,z,t),n(e,Lt,t),n(e,P,t),n(e,At,t),n(e,v,t),n(e,Nt,t),n(e,E,t),n(e,qt,t),n(e,x,t),n(e,zt,t),n(e,Q,t),n(e,Pt,t),n(e,_,t),n(e,Et,t),n(e,Y,t),n(e,Qt,t),n(e,S,t),n(e,Yt,t),n(e,C,t),n(e,St,t),u(D,e,t),n(e,Dt,t),n(e,K,t),n(e,Kt,t),u(O,e,t),n(e,Ot,t),n(e,ee,t),n(e,el,t),u(te,e,t),n(e,tl,t),u(le,e,t),n(e,ll,t),n(e,ne,t),n(e,nl,t),u(se,e,t),n(e,sl,t),u(ae,e,t),n(e,al,t),n(e,ie,t),n(e,il,t),u(oe,e,t),n(e,ol,t),u(re,e,t),n(e,rl,t),n(e,me,t),n(e,ml,t),n(e,pe,t),n(e,pl,t),u(k,e,t),n(e,dl,t),u(de,e,t),n(e,ul,t),n(e,ue,t),n(e,fl,t),n(e,fe,t),n(e,cl,t),n(e,ce,t),n(e,bl,t),u(be,e,t),n(e,hl,t),n(e,he,t),n(e,Tl,t),u(Te,e,t),n(e,yl,t),n(e,ye,t),n(e,Ml,t),u(Me,e,t),n(e,gl,t),n(e,ge,t),n(e,wl,t),n(e,we,t),n(e,Jl,t),u(Je,e,t),n(e,$l,t),n(e,$e,t),n(e,vl,t),u(ve,e,t),n(e,xl,t),n(e,xe,t),n(e,_l,t),u(_e,e,t),n(e,Cl,t),n(e,Ce,t),n(e,kl,t),u(ke,e,t),n(e,Ul,t),n(e,Ue,t),n(e,Wl,t),n(e,We,t),n(e,Zl,t),u(Ze,e,t),n(e,jl,t),n(e,je,t),n(e,Bl,t),u(U,e,t),n(e,Gl,t),u(Be,e,t),n(e,Il,t),n(e,Ge,t),n(e,Fl,t),u(Ie,e,t),n(e,Vl,t),n(e,Fe,t),n(e,Xl,t),u(Ve,e,t),n(e,Rl,t),n(e,Xe,t),n(e,Hl,t),u(Re,e,t),n(e,Ll,t),n(e,He,t),n(e,Al,t),u(Le,e,t),n(e,Nl,t),n(e,Ae,t),n(e,ql,t),u(Ne,e,t),n(e,zl,t),n(e,qe,t),n(e,Pl,t),u(ze,e,t),n(e,El,t),n(e,Pe,t),n(e,Ql,t),u(Ee,e,t),n(e,Yl,t),u(W,e,t),n(e,Sl,t),n(e,Qe,t),n(e,Dl,t),n(e,Ye,t),n(e,Kl,t),n(e,Se,t),n(e,Ol,t),n(e,De,t),n(e,en,t),n(e,Ke,t),n(e,tn,t),u(Oe,e,t),n(e,ln,t),n(e,et,t),n(e,nn,t),u(tt,e,t),n(e,sn,t),n(e,lt,t),n(e,an,t),u(nt,e,t),n(e,on,t),n(e,st,t),n(e,rn,t),n(e,at,t),n(e,mn,t),n(e,it,t),n(e,pn,t),u(ot,e,t),n(e,dn,t),u(rt,e,t),n(e,un,t),n(e,mt,t),n(e,fn,t),u(pt,e,t),n(e,cn,t),n(e,dt,t),n(e,bn,t),u(ut,e,t),n(e,hn,t),n(e,ft,t),n(e,Tn,t),u(ct,e,t),n(e,yn,t),n(e,bt,t),n(e,Mn,t),n(e,ht,t),n(e,gn,t),n(e,Tt,t),n(e,wn,t),n(e,yt,t),n(e,Jn,t),u(Mt,e,t),n(e,$n,t),n(e,gt,t),n(e,vn,t),u(wt,e,t),n(e,xn,t),n(e,Jt,t),_n=!0},p(e,[t]){const Vs={};t&2&&(Vs.$$scope={dirty:t,ctx:e}),J.$set(Vs);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),$.$set(Xs);const Rs={};t&2&&(Rs.$$scope={dirty:t,ctx:e}),k.$set(Rs);const Hs={};t&2&&(Hs.$$scope={dirty:t,ctx:e}),U.$set(Hs);const Ls={};t&2&&(Ls.$$scope={dirty:t,ctx:e}),W.$set(Ls)},i(e){_n||(f(Z.$$.fragment,e),f(B.$$.fragment,e),f(J.$$.fragment,e),f($.$$.fragment,e),f(R.$$.fragment,e),f(L.$$.fragment,e),f(N.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(k.$$.fragment,e),f(de.$$.fragment,e),f(be.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(Je.$$.fragment,e),f(ve.$$.fragment,e),f(_e.$$.fragment,e),f(ke.$$.fragment,e),f(Ze.$$.fragment,e),f(U.$$.fragment,e),f(Be.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(Re.$$.fragment,e),f(Le.$$.fragment,e),f(Ne.$$.fragment,e),f(ze.$$.fragment,e),f(Ee.$$.fragment,e),f(W.$$.fragment,e),f(Oe.$$.fragment,e),f(tt.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(pt.$$.fragment,e),f(ut.$$.fragment,e),f(ct.$$.fragment,e),f(Mt.$$.fragment,e),f(wt.$$.fragment,e),_n=!0)},o(e){c(Z.$$.fragment,e),c(B.$$.fragment,e),c(J.$$.fragment,e),c($.$$.fragment,e),c(R.$$.fragment,e),c(L.$$.fragment,e),c(N.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(k.$$.fragment,e),c(de.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(Me.$$.fragment,e),c(Je.$$.fragment,e),c(ve.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(Ze.$$.fragment,e),c(U.$$.fragment,e),c(Be.$$.fragment,e),c(Ie.$$.fragment,e),c(Ve.$$.fragment,e),c(Re.$$.fragment,e),c(Le.$$.fragment,e),c(Ne.$$.fragment,e),c(ze.$$.fragment,e),c(Ee.$$.fragment,e),c(W.$$.fragment,e),c(Oe.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(ot.$$.fragment,e),c(rt.$$.fragment,e),c(pt.$$.fragment,e),c(ut.$$.fragment,e),c(ct.$$.fragment,e),c(Mt.$$.fragment,e),c(wt.$$.fragment,e),_n=!1},d(e){e&&(l(y),l(h),l(g),l(xt),l(j),l(_t),l(Ct),l(kt),l(G),l(Ut),l(I),l(Wt),l(F),l(Zt),l(V),l(jt),l(X),l(Bt),l(Gt),l(It),l(H),l(Ft),l(Vt),l(A),l(Xt),l(Rt),l(q),l(Ht),l(z),l(Lt),l(P),l(At),l(v),l(Nt),l(E),l(qt),l(x),l(zt),l(Q),l(Pt),l(_),l(Et),l(Y),l(Qt),l(S),l(Yt),l(C),l(St),l(Dt),l(K),l(Kt),l(Ot),l(ee),l(el),l(tl),l(ll),l(ne),l(nl),l(sl),l(al),l(ie),l(il),l(ol),l(rl),l(me),l(ml),l(pe),l(pl),l(dl),l(ul),l(ue),l(fl),l(fe),l(cl),l(ce),l(bl),l(hl),l(he),l(Tl),l(yl),l(ye),l(Ml),l(gl),l(ge),l(wl),l(we),l(Jl),l($l),l($e),l(vl),l(xl),l(xe),l(_l),l(Cl),l(Ce),l(kl),l(Ul),l(Ue),l(Wl),l(We),l(Zl),l(jl),l(je),l(Bl),l(Gl),l(Il),l(Ge),l(Fl),l(Vl),l(Fe),l(Xl),l(Rl),l(Xe),l(Hl),l(Ll),l(He),l(Al),l(Nl),l(Ae),l(ql),l(zl),l(qe),l(Pl),l(El),l(Pe),l(Ql),l(Yl),l(Sl),l(Qe),l(Dl),l(Ye),l(Kl),l(Se),l(Ol),l(De),l(en),l(Ke),l(tn),l(ln),l(et),l(nn),l(sn),l(lt),l(an),l(on),l(st),l(rn),l(at),l(mn),l(it),l(pn),l(dn),l(un),l(mt),l(fn),l(cn),l(dt),l(bn),l(hn),l(ft),l(Tn),l(yn),l(bt),l(Mn),l(ht),l(gn),l(Tt),l(wn),l(yt),l(Jn),l($n),l(gt),l(vn),l(xn),l(Jt)),l(m),b(Z,e),b(B,e),b(J,e),b($,e),b(R,e),b(L,e),b(N,e),b(D,e),b(O,e),b(te,e),b(le,e),b(se,e),b(ae,e),b(oe,e),b(re,e),b(k,e),b(de,e),b(be,e),b(Te,e),b(Me,e),b(Je,e),b(ve,e),b(_e,e),b(ke,e),b(Ze,e),b(U,e),b(Be,e),b(Ie,e),b(Ve,e),b(Re,e),b(Le,e),b(Ne,e),b(ze,e),b(Ee,e),b(W,e),b(Oe,e),b(tt,e),b(nt,e),b(ot,e),b(rt,e),b(pt,e),b(ut,e),b(ct,e),b(Mt,e),b(wt,e)}}}const la='{"title":"Efficient Inference on a Single GPU","local":"efficient-inference-on-a-single-gpu","sections":[{"title":"Flash Attention 2","local":"flash-attention-2","sections":[{"title":"Quick usage","local":"quick-usage","sections":[],"depth":3},{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3},{"title":"Advanced usage","local":"advanced-usage","sections":[],"depth":3},{"title":"Combining Flash Attention 2 and 8-bit models","local":"combining-flash-attention-2-and-8-bit-models","sections":[],"depth":3},{"title":"Combining Flash Attention 2 and 4-bit models","local":"combining-flash-attention-2-and-4-bit-models","sections":[],"depth":3},{"title":"Combining Flash Attention 2 and PEFT","local":"combining-flash-attention-2-and-peft","sections":[],"depth":3}],"depth":2},{"title":"BetterTransformer","local":"bettertransformer","sections":[{"title":"Encoder models","local":"encoder-models","sections":[],"depth":3},{"title":"Decoder models","local":"decoder-models","sections":[],"depth":3}],"depth":2},{"title":"bitsandbytes integration for FP4 mixed-precision inference","local":"bitsandbytes-integration-for-fp4-mixed-precision-inference","sections":[{"title":"Requirements","local":"requirements-for-fp4-mixedprecision-inference","sections":[],"depth":3},{"title":"Running FP4 models - single GPU setup - Quickstart","local":"running-fp4-models---single-gpu-setup---quickstart","sections":[],"depth":3},{"title":"Running FP4 models - multi GPU setup","local":"running-fp4-models---multi-gpu-setup","sections":[],"depth":3},{"title":"Advanced usage","local":"advanced-usage","sections":[],"depth":3}],"depth":2},{"title":"bitsandbytes integration for Int8 mixed-precision matrix decomposition","local":"bitsandbytes-integration-for-int8-mixed-precision-matrix-decomposition","sections":[{"title":"Requirements","local":"requirements-for-int8-mixedprecision-matrix-decomposition","sections":[],"depth":3},{"title":"Running mixed-Int8 models - single GPU setup","local":"running-mixed-int8-models---single-gpu-setup","sections":[],"depth":3},{"title":"Running mixed-int8 models - multi GPU setup","local":"running-mixed-int8-models---multi-gpu-setup","sections":[],"depth":3},{"title":"Colab demos","local":"colab-demos","sections":[],"depth":3}],"depth":2},{"title":"Advanced usage: mixing FP4 (or Int8) and BetterTransformer","local":"advanced-usage-mixing-fp4-or-int8-and-bettertransformer","sections":[],"depth":2}],"depth":1}';function na(w){return zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends Ps{constructor(m){super(),Es(this,m,na,ta,qs,{})}}export{ma as component};
