import{s as de,n as ue,o as he}from"../chunks/scheduler.9bc65507.js";import{S as ce,i as me,g as s,s as n,r as F,A as fe,h as r,f as a,c as o,j as le,u as S,x as l,k as D,y as pe,a as i,v as E,d as G,t as X,w as R}from"../chunks/index.707bf1b6.js";import{C as ge}from"../chunks/CodeBlock.54a9f38d.js";import{H as V}from"../chunks/Heading.342b1fa6.js";function be(O){let d,C,M,L,h,k,c,K="Transformers supports and integrates many quantization methods such as QLoRA, GPTQ, LLM.int8, and AWQ. However, there are other quantization approaches that are not yet integrated. To make adding and using these quantization methods with Transformers models easier, you should use the <code>HfQuantizer</code> class. The <code>HfQuantizer</code> is designed as an internal helper class for adding a quantization method instead of something you apply to every PyTorch module.",$,m,N="This guide will show you how to integrate a new quantization method with the <code>HfQuantizer</code> class.",U,f,x,p,ee="Before integrating a new quantization method into Transformers, ensure the method you are trying to add meets the following prerequisites. Only quantization methods that can be run with PyTorch modules are currently supported.",H,g,te="<li>The quantization method is available through a Python package that is pip-installable by anyone (it is also fine if you can only install the package from source). Ideally, pre-compiled kernels are included in the pip package.</li> <li>The method can run on commonly-used hardware (CPU, GPU, …).</li> <li>The method is wrapped in a <code>nn.Module</code> (e.g., <code>Linear8bitLt</code>, <code>Linear4bit</code>), and the quantized linear layer should have the following definition:</li>",P,b,J,y,ae="This way, Transformers models can be easily quantized by replacing some instances of <code>nn.Linear</code> with a target class.",j,w,ie="<li>The quantization method should be serializable. You can save the quantized weights locally or push them to the Hub.</li> <li>Make sure the package that contains the quantization kernels/primitive is stable (no frequent breaking changes).</li>",Q,q,ne="For some quantization methods, they may require “pre-quantizing” the models through data calibration (e.g., AWQ). In this case, we prefer to only support inference in Transformers and let the third-party library maintained by the ML community deal with the model quantization itself.",I,_,A,z,oe='<li><p>Create a new quantization config class inside <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/utils/quantization_config.py" rel="nofollow">src/transformers/utils/quantization_config.py</a> and make sure to expose the new quantization config inside Transformers main <code>init</code> by adding it to the <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/__init__.py#L1088" rel="nofollow"><code>_import_structure</code></a> object of <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/__init__.py" rel="nofollow">src/transformers/<strong>init</strong>.py</a>.</p></li> <li><p>Create a new file inside <a href="https://github.com/huggingface/transformers/tree/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers" rel="nofollow">src/transformers/quantizers/</a> named <code>quantizer_your_method.py</code>, and make it inherit from <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/base.py#L28" rel="nofollow">src/transformers/quantizers/base.py::HfQuantizer</a>. Make sure to add the new quantizer and quantization config in the quantization auto-mapping in <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/auto.py" rel="nofollow">src/transformers/quantizers/auto.py</a>.</p></li> <li><p>Define the following class attributes/property methods for your quantization method:</p></li>',W,T,se='<li><code>requires_calibration</code>: Whether the quantization method requires a data calibration process. If set to <code>True</code>, you can only support inference (with quantized weights) and not inference and quantization.</li> <li><code>required_packages</code>: A list of strings of the required packages to use the quantized weights. You might need to define some new utility methods such as <code>is_auto_awq_available</code> in <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/utils/import_utils.py" rel="nofollow">transformers/src/utils/import_utils.py</a>.</li> <li><code>requires_parameters_quantization</code>: Only required if your quantization method requires extra attention to the underlying <code>nn.Parameter</code> object. For example, bitsandbytes uses <code>Params4bit</code> and <code>Int8Param</code>, which requires some extra attention when quantizing the model. Most of the recent quantization method packs int2/int4 weights inside <code>torch.uint8</code> weights, so this flag should not be really required (set to <code>False</code> by default).</li> <li><code>is_serializable</code>: A property method to determine whether the method is serializable or not.</li> <li><code>is_trainable</code>:  A property method to determine whether you can fine-tune models on top of the quantization method (with or without PEFT approaches).</li>',Z,u,re='<li><p>Write the <code>validate_environment</code> and <code>update_torch_dtype</code> methods. These methods are called before creating the quantized model to ensure users use the right configuration. You can have a look at how this is done on other quantizers.</p></li> <li><p>Write the <code>_process_model_before_weight_loading</code> method. In Transformers, the quantized models are initialized first on the <code>&quot;meta&quot;</code> device before loading the weights. This means the <code>_process_model_before_weight_loading</code> method takes care of manipulating the model skeleton to replace some modules (e.g., <code>nn.Linear</code>) with the target modules (quantization modules). You can define a module replacement logic or any other utility method by creating a new file in <a href="https://github.com/huggingface/transformers/tree/abbffc4525566a48a9733639797c812301218b83/src/transformers/integrations" rel="nofollow">transformers/src/integrations/</a> and exposing the relevant methods in that folder’s <code>__init__.py</code> file. The best starting point would be to have a look at another quantization methods such as <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/src/transformers/quantizers/quantizer_awq.py" rel="nofollow">quantizer_awq.py</a>.</p></li> <li><p>Write the <code>_process_model_after_weight_loading</code> method. This method enables implementing additional features that require manipulating the model after loading the weights.</p></li> <li><p>Document everything! Make sure your quantization method is documented in the <a href="https://github.com/huggingface/transformers/blob/abbffc4525566a48a9733639797c812301218b83/docs/source/en/quantization.md" rel="nofollow"><code>docs/source/en/quantization.md</code></a> file.</p></li> <li><p>Add tests! You should add tests by first adding the package in our nightly Dockerfile inside <code>docker/transformers-all-latest-gpu</code> and then adding a new test file in <code>tests/quantization/xxx</code>. Feel free to check out how it is implemented for other quantization methods.</p></li>',B,v,Y;return h=new V({props:{title:"Contribute new quantization method",local:"contribute-new-quantization-method",headingTag:"h1"}}),f=new V({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),b=new ge({props:{code:"Y2xhc3MlMjBMaW5lYXI0Yml0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbXlfNGJpdF9rZXJuZWwoeCUyQyUyMHNlbGYud2VpZ2h0JTJDJTIwc2VsZi5iaWFzKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Linear4bit</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, ...</span>):
        ...
    
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> my_4bit_kernel(x, self.weight, self.bias)`,wrap:!1}}),_=new V({props:{title:"Build a new HFQuantizer class",local:"build-a-new-hfquantizer-class",headingTag:"h2"}}),{c(){d=s("meta"),C=n(),M=s("p"),L=n(),F(h.$$.fragment),k=n(),c=s("p"),c.innerHTML=K,$=n(),m=s("p"),m.innerHTML=N,U=n(),F(f.$$.fragment),x=n(),p=s("p"),p.textContent=ee,H=n(),g=s("ul"),g.innerHTML=te,P=n(),F(b.$$.fragment),J=n(),y=s("p"),y.innerHTML=ae,j=n(),w=s("ul"),w.innerHTML=ie,Q=n(),q=s("p"),q.textContent=ne,I=n(),F(_.$$.fragment),A=n(),z=s("ol"),z.innerHTML=oe,W=n(),T=s("ul"),T.innerHTML=se,Z=n(),u=s("ol"),u.innerHTML=re,B=n(),v=s("p"),this.h()},l(e){const t=fe("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(a),C=o(e),M=r(e,"P",{}),le(M).forEach(a),L=o(e),S(h.$$.fragment,e),k=o(e),c=r(e,"P",{"data-svelte-h":!0}),l(c)!=="svelte-1pq1qlp"&&(c.innerHTML=K),$=o(e),m=r(e,"P",{"data-svelte-h":!0}),l(m)!=="svelte-z2f8d2"&&(m.innerHTML=N),U=o(e),S(f.$$.fragment,e),x=o(e),p=r(e,"P",{"data-svelte-h":!0}),l(p)!=="svelte-1r9sp5d"&&(p.textContent=ee),H=o(e),g=r(e,"UL",{"data-svelte-h":!0}),l(g)!=="svelte-6z9s8p"&&(g.innerHTML=te),P=o(e),S(b.$$.fragment,e),J=o(e),y=r(e,"P",{"data-svelte-h":!0}),l(y)!=="svelte-e9o9mb"&&(y.innerHTML=ae),j=o(e),w=r(e,"UL",{"data-svelte-h":!0}),l(w)!=="svelte-yqp59g"&&(w.innerHTML=ie),Q=o(e),q=r(e,"P",{"data-svelte-h":!0}),l(q)!=="svelte-1e8yc6a"&&(q.textContent=ne),I=o(e),S(_.$$.fragment,e),A=o(e),z=r(e,"OL",{"data-svelte-h":!0}),l(z)!=="svelte-luvagu"&&(z.innerHTML=oe),W=o(e),T=r(e,"UL",{"data-svelte-h":!0}),l(T)!=="svelte-dy6msy"&&(T.innerHTML=se),Z=o(e),u=r(e,"OL",{start:!0,"data-svelte-h":!0}),l(u)!=="svelte-1r5nqcr"&&(u.innerHTML=re),B=o(e),v=r(e,"P",{}),le(v).forEach(a),this.h()},h(){D(d,"name","hf:doc:metadata"),D(d,"content",ye),D(u,"start","4")},m(e,t){pe(document.head,d),i(e,C,t),i(e,M,t),i(e,L,t),E(h,e,t),i(e,k,t),i(e,c,t),i(e,$,t),i(e,m,t),i(e,U,t),E(f,e,t),i(e,x,t),i(e,p,t),i(e,H,t),i(e,g,t),i(e,P,t),E(b,e,t),i(e,J,t),i(e,y,t),i(e,j,t),i(e,w,t),i(e,Q,t),i(e,q,t),i(e,I,t),E(_,e,t),i(e,A,t),i(e,z,t),i(e,W,t),i(e,T,t),i(e,Z,t),i(e,u,t),i(e,B,t),i(e,v,t),Y=!0},p:ue,i(e){Y||(G(h.$$.fragment,e),G(f.$$.fragment,e),G(b.$$.fragment,e),G(_.$$.fragment,e),Y=!0)},o(e){X(h.$$.fragment,e),X(f.$$.fragment,e),X(b.$$.fragment,e),X(_.$$.fragment,e),Y=!1},d(e){e&&(a(C),a(M),a(L),a(k),a(c),a($),a(m),a(U),a(x),a(p),a(H),a(g),a(P),a(J),a(y),a(j),a(w),a(Q),a(q),a(I),a(A),a(z),a(W),a(T),a(Z),a(u),a(B),a(v)),a(d),R(h,e),R(f,e),R(b,e),R(_,e)}}}const ye='{"title":"Contribute new quantization method","local":"contribute-new-quantization-method","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Build a new HFQuantizer class","local":"build-a-new-hfquantizer-class","sections":[],"depth":2}],"depth":1}';function we(O){return he(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Me extends ce{constructor(d){super(),me(this,d,we,be,de,{})}}export{Me as component};
