import{s as io,o as co,n as tr}from"../chunks/scheduler.9bc65507.js";import{S as mo,i as po,g as l,s,r as p,A as fo,h as i,f as t,c as a,j as x,u as f,x as d,k as $,y as o,a as n,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as la}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.570ddb64.js";import{C as sr}from"../chunks/CodeBlock.54a9f38d.js";import{E as ia}from"../chunks/ExampleCodeBlock.bc2be6bc.js";import{H as pe,E as uo}from"../chunks/EditOnGithub.922df6ba.js";function ho(U){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.40.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.40.1/en/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-17yt1s1"&&(c.innerHTML=T)},m(v,b){n(v,c,b)},p:tr,d(v){v&&t(c)}}}function go(U){let c,T="Examples:",v,b,C;return b=new sr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(b.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(b.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(b,m,I),C=!0},p:tr,i(m){C||(h(b.$$.fragment,m),C=!0)},o(m){g(b.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(b,m)}}}function _o(U){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=l("p"),c.textContent=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,b){n(v,c,b)},p:tr,d(v){v&&t(c)}}}function vo(U){let c,T=`This class method is simply calling <a href="/docs/transformers/v4.40.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.40.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-sgbmq"&&(c.innerHTML=T)},m(v,b){n(v,c,b)},p:tr,d(v){v&&t(c)}}}function bo(U){let c,T="Examples:",v,b,C;return b=new sr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(b.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(b.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(b,m,I),C=!0},p:tr,i(m){C||(h(b.$$.fragment,m),C=!0)},o(m){g(b.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(b,m)}}}function xo(U){let c,T="Example:",v,b,C;return b=new sr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(b.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=a(m),f(b.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(b,m,I),C=!0},p:tr,i(m){C||(h(b.$$.fragment,m),C=!0)},o(m){g(b.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(b,m)}}}function $o(U){let c,T,v,b,C,m,I,da="Processors can mean two different things in the Transformers library:",ar,fe,ca=`<li>the objects that pre-process inputs for multi-modal models such as <a href="../model_doc/wav2vec2">Wav2Vec2</a> (speech and text)
or <a href="../model_doc/clip">CLIP</a> (text and vision)</li> <li>deprecated objects that were used in older versions of the library to preprocess data for GLUE or SQUAD.</li>`,or,ue,nr,he,ma=`Any multi-modal model will require an object to encode or decode the data that groups several modalities (among text,
vision and audio). This is handled by objects called processors, which group together two or more processing objects
such as tokenizers (for the text modality), image processors (for vision) and feature extractors (for audio).`,lr,ge,pa="Those processors inherit from the following base class that implements the saving and loading functionality:",ir,y,_e,is,Mt,fa="This is a mixin used to provide saving/loading functionality for all processor classes.",ds,D,ve,cs,wt,ua="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ms,Z,be,ps,Tt,ha="Instantiate a processor associated with a pretrained model.",fs,G,us,R,xe,hs,Ct,ga=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,gs,q,$e,_s,Pt,_a="Upload the processor files to the 🤗 Model Hub.",vs,W,bs,V,ye,xs,It,va=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,$s,Q,ys,E,Me,Ms,kt,ba=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ws,A,Ts,Y,we,Cs,Xt,xa="Serializes this instance to a Python dictionary.",Ps,O,Te,Is,Ut,$a="Save this instance to a JSON file.",ks,K,Ce,Xs,jt,ya="Serializes this instance to a JSON string.",dr,Pe,cr,Ie,Ma=`All processors follow the same architecture which is that of the
<a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.DataProcessor">DataProcessor</a>. The processor returns a list of
<a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputExample">InputExample</a>. These
<a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputExample">InputExample</a> can be converted to
<a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputFeatures">InputFeatures</a> in order to be fed to the model.`,mr,P,ke,Us,Jt,wa="Base class for data converters for sequence classification data sets.",js,ee,Xe,Js,Lt,Ta='Gets a collection of <a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Ls,te,Ue,Zs,Zt,Ca="Gets an example from a dict with tensorflow tensors.",qs,re,je,Vs,qt,Pa="Gets the list of labels for this data set.",Es,se,Je,zs,Vt,Ia='Gets a collection of <a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Hs,ae,Le,Ns,Et,ka='Gets a collection of <a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Bs,oe,Ze,Fs,zt,Xa=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,pr,j,qe,Ss,Ht,Ua="A single training/test example for simple sequence classification.",Ds,ne,Ve,Gs,Nt,ja="Serializes this instance to a JSON string.",fr,J,Ee,Rs,Bt,Ja="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Ws,le,ze,Qs,Ft,La="Serializes this instance to a JSON string.",ur,He,hr,Ne,Za=`<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> is a benchmark that evaluates the
performance of models across a diverse set of existing NLU tasks. It was released together with the paper <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
multi-task benchmark and analysis platform for natural language understanding</a>`,gr,Be,qa=`This library hosts a total of 10 processors for the following tasks: MRPC, MNLI, MNLI (mismatched), CoLA, SST2, STSB,
QQP, QNLI, RTE and WNLI.`,_r,Fe,Va="Those processors are:",vr,Se,Ea="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",br,De,za=`Additionally, the following method can be used to load values from a data file and convert them to a list of
<a href="/docs/transformers/v4.40.1/en/main_classes/processors#transformers.InputExample">InputExample</a>.`,xr,N,Ge,As,St,Ha="Loads a data file into a list of <code>InputFeatures</code>",$r,Re,yr,We,Na=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">The Cross-Lingual NLI Corpus (XNLI)</a> is a benchmark that evaluates the
quality of cross-lingual text representations. XNLI is crowd-sourced dataset based on <a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>: pairs of text are labeled with textual entailment annotations for 15
different languages (including both high-resource language such as English and low-resource languages such as Swahili).`,Mr,Qe,Ba='It was released together with the paper <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a>',wr,Ae,Fa="This library hosts the processor to load the XNLI data:",Tr,Ye,Sa="<li><code>~data.processors.utils.XnliProcessor</code></li>",Cr,Oe,Da="Please note that since the gold labels are available on the test set, evaluation is performed on the test set.",Pr,Ke,Ga='An example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> script.',Ir,et,kr,tt,Ra=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> is a benchmark that
evaluates the performance of models on question answering. Two versions are available, v1.1 and v2.0. The first version
(v1.1) was released together with the paper <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a>. The second version (v2.0) was released alongside the paper <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t
Know: Unanswerable Questions for SQuAD</a>.`,Xr,rt,Wa="This library hosts a processor for each of the two versions:",Ur,st,jr,at,Qa="Those processors are:",Jr,ot,Aa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Lr,nt,Ya="They both inherit from the abstract class <code>~data.processors.utils.SquadProcessor</code>",Zr,X,lt,Ys,Dt,Oa=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Os,ie,it,Ks,Gt,Ka="Returns the evaluation example from the data directory.",ea,z,dt,ta,Rt,eo="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ra,de,sa,ce,ct,aa,Wt,to="Returns the training examples from the data directory.",qr,mt,ro=`Additionally, the following method can be used to convert SQuAD examples into
<code>~data.processors.utils.SquadFeatures</code> that can be used as model inputs.`,Vr,L,pt,oa,Qt,so=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,na,me,Er,ft,ao=`These processors as well as the aforementioned method can be used with files containing the data as well as with the
<em>tensorflow_datasets</em> package. Examples are given below.`,zr,ut,Hr,ht,oo="Here is an example using the processors as well as the conversion method using data files:",Nr,gt,Br,_t,no="Using <em>tensorflow_datasets</em> is as easy as using a data file:",Fr,vt,Sr,bt,lo='Another example using these processors is given in the <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> script.',Dr,xt,Gr,rr,Rr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),be=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.40.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.40.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L406"}}),G=new la({props:{$$slots:{default:[ho]},$$scope:{ctx:U}}}),xe=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),$e=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/utils/hub.py#L768"}}),W=new ia({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[go]},$$scope:{ctx:U}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L470"}}),Q=new la({props:{warning:!0,$$slots:{default:[_o]},$$scope:{ctx:U}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.40.1/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L167"}}),A=new la({props:{$$slots:{default:[vo]},$$scope:{ctx:U}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),ke=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L80"}}),Xe=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L97"}}),Ue=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L83"}}),je=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L105"}}),Je=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L93"}}),Ze=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L109"}}),qe=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L49"}}),Ee=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L54"}}),ze=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),Re=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new ia({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[bo]},$$scope:{ctx:U}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/v4.40.1/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new ia({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[xo]},$$scope:{ctx:U}}}),ut=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),gt=new sr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new sr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),xt=new uo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/main_classes/processors.md"}}),{c(){c=l("meta"),T=s(),v=l("p"),b=s(),p(C.$$.fragment),m=s(),I=l("p"),I.textContent=da,ar=s(),fe=l("ul"),fe.innerHTML=ca,or=s(),p(ue.$$.fragment),nr=s(),he=l("p"),he.textContent=ma,lr=s(),ge=l("p"),ge.textContent=pa,ir=s(),y=l("div"),p(_e.$$.fragment),is=s(),Mt=l("p"),Mt.textContent=fa,ds=s(),D=l("div"),p(ve.$$.fragment),cs=s(),wt=l("p"),wt.innerHTML=ua,ms=s(),Z=l("div"),p(be.$$.fragment),ps=s(),Tt=l("p"),Tt.textContent=ha,fs=s(),p(G.$$.fragment),us=s(),R=l("div"),p(xe.$$.fragment),hs=s(),Ct=l("p"),Ct.innerHTML=ga,gs=s(),q=l("div"),p($e.$$.fragment),_s=s(),Pt=l("p"),Pt.textContent=_a,vs=s(),p(W.$$.fragment),bs=s(),V=l("div"),p(ye.$$.fragment),xs=s(),It=l("p"),It.innerHTML=va,$s=s(),p(Q.$$.fragment),ys=s(),E=l("div"),p(Me.$$.fragment),Ms=s(),kt=l("p"),kt.innerHTML=ba,ws=s(),p(A.$$.fragment),Ts=s(),Y=l("div"),p(we.$$.fragment),Cs=s(),Xt=l("p"),Xt.textContent=xa,Ps=s(),O=l("div"),p(Te.$$.fragment),Is=s(),Ut=l("p"),Ut.textContent=$a,ks=s(),K=l("div"),p(Ce.$$.fragment),Xs=s(),jt=l("p"),jt.textContent=ya,dr=s(),p(Pe.$$.fragment),cr=s(),Ie=l("p"),Ie.innerHTML=Ma,mr=s(),P=l("div"),p(ke.$$.fragment),Us=s(),Jt=l("p"),Jt.textContent=wa,js=s(),ee=l("div"),p(Xe.$$.fragment),Js=s(),Lt=l("p"),Lt.innerHTML=Ta,Ls=s(),te=l("div"),p(Ue.$$.fragment),Zs=s(),Zt=l("p"),Zt.textContent=Ca,qs=s(),re=l("div"),p(je.$$.fragment),Vs=s(),qt=l("p"),qt.textContent=Pa,Es=s(),se=l("div"),p(Je.$$.fragment),zs=s(),Vt=l("p"),Vt.innerHTML=Ia,Hs=s(),ae=l("div"),p(Le.$$.fragment),Ns=s(),Et=l("p"),Et.innerHTML=ka,Bs=s(),oe=l("div"),p(Ze.$$.fragment),Fs=s(),zt=l("p"),zt.textContent=Xa,pr=s(),j=l("div"),p(qe.$$.fragment),Ss=s(),Ht=l("p"),Ht.textContent=Ua,Ds=s(),ne=l("div"),p(Ve.$$.fragment),Gs=s(),Nt=l("p"),Nt.textContent=ja,fr=s(),J=l("div"),p(Ee.$$.fragment),Rs=s(),Bt=l("p"),Bt.textContent=Ja,Ws=s(),le=l("div"),p(ze.$$.fragment),Qs=s(),Ft=l("p"),Ft.textContent=La,ur=s(),p(He.$$.fragment),hr=s(),Ne=l("p"),Ne.innerHTML=Za,gr=s(),Be=l("p"),Be.textContent=qa,_r=s(),Fe=l("p"),Fe.textContent=Va,vr=s(),Se=l("ul"),Se.innerHTML=Ea,br=s(),De=l("p"),De.innerHTML=za,xr=s(),N=l("div"),p(Ge.$$.fragment),As=s(),St=l("p"),St.innerHTML=Ha,$r=s(),p(Re.$$.fragment),yr=s(),We=l("p"),We.innerHTML=Na,Mr=s(),Qe=l("p"),Qe.innerHTML=Ba,wr=s(),Ae=l("p"),Ae.textContent=Fa,Tr=s(),Ye=l("ul"),Ye.innerHTML=Sa,Cr=s(),Oe=l("p"),Oe.textContent=Da,Pr=s(),Ke=l("p"),Ke.innerHTML=Ga,Ir=s(),p(et.$$.fragment),kr=s(),tt=l("p"),tt.innerHTML=Ra,Xr=s(),rt=l("p"),rt.textContent=Wa,Ur=s(),p(st.$$.fragment),jr=s(),at=l("p"),at.textContent=Qa,Jr=s(),ot=l("ul"),ot.innerHTML=Aa,Lr=s(),nt=l("p"),nt.innerHTML=Ya,Zr=s(),X=l("div"),p(lt.$$.fragment),Ys=s(),Dt=l("p"),Dt.textContent=Oa,Os=s(),ie=l("div"),p(it.$$.fragment),Ks=s(),Gt=l("p"),Gt.textContent=Ka,ea=s(),z=l("div"),p(dt.$$.fragment),ta=s(),Rt=l("p"),Rt.innerHTML=eo,ra=s(),p(de.$$.fragment),sa=s(),ce=l("div"),p(ct.$$.fragment),aa=s(),Wt=l("p"),Wt.textContent=to,qr=s(),mt=l("p"),mt.innerHTML=ro,Vr=s(),L=l("div"),p(pt.$$.fragment),oa=s(),Qt=l("p"),Qt.textContent=so,na=s(),p(me.$$.fragment),Er=s(),ft=l("p"),ft.innerHTML=ao,zr=s(),p(ut.$$.fragment),Hr=s(),ht=l("p"),ht.textContent=oo,Nr=s(),p(gt.$$.fragment),Br=s(),_t=l("p"),_t.innerHTML=no,Fr=s(),p(vt.$$.fragment),Sr=s(),bt=l("p"),bt.innerHTML=lo,Dr=s(),p(xt.$$.fragment),Gr=s(),rr=l("p"),this.h()},l(e){const r=fo("svelte-u9bgzb",document.head);c=i(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=i(e,"P",{}),x(v).forEach(t),b=a(e),f(C.$$.fragment,e),m=a(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-8nvl5z"&&(I.textContent=da),ar=a(e),fe=i(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1r5mt3j"&&(fe.innerHTML=ca),or=a(e),f(ue.$$.fragment,e),nr=a(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-16hpp4n"&&(he.textContent=ma),lr=a(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-x3ucqc"&&(ge.textContent=pa),ir=a(e),y=i(e,"DIV",{class:!0});var w=x(y);f(_e.$$.fragment,w),is=a(w),Mt=i(w,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1s4wckx"&&(Mt.textContent=fa),ds=a(w),D=i(w,"DIV",{class:!0});var $t=x(D);f(ve.$$.fragment,$t),cs=a($t),wt=i($t,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1i2d3vx"&&(wt.innerHTML=ua),$t.forEach(t),ms=a(w),Z=i(w,"DIV",{class:!0});var B=x(Z);f(be.$$.fragment,B),ps=a(B),Tt=i(B,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1cj8dcb"&&(Tt.textContent=ha),fs=a(B),f(G.$$.fragment,B),B.forEach(t),us=a(w),R=i(w,"DIV",{class:!0});var yt=x(R);f(xe.$$.fragment,yt),hs=a(yt),Ct=i(yt,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-hsvutq"&&(Ct.innerHTML=ga),yt.forEach(t),gs=a(w),q=i(w,"DIV",{class:!0});var F=x(q);f($e.$$.fragment,F),_s=a(F),Pt=i(F,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1cwsjho"&&(Pt.textContent=_a),vs=a(F),f(W.$$.fragment,F),F.forEach(t),bs=a(w),V=i(w,"DIV",{class:!0});var S=x(V);f(ye.$$.fragment,S),xs=a(S),It=i(S,"P",{"data-svelte-h":!0}),d(It)!=="svelte-hhsvto"&&(It.innerHTML=va),$s=a(S),f(Q.$$.fragment,S),S.forEach(t),ys=a(w),E=i(w,"DIV",{class:!0});var At=x(E);f(Me.$$.fragment,At),Ms=a(At),kt=i(At,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1lbqmiz"&&(kt.innerHTML=ba),ws=a(At),f(A.$$.fragment,At),At.forEach(t),Ts=a(w),Y=i(w,"DIV",{class:!0});var Wr=x(Y);f(we.$$.fragment,Wr),Cs=a(Wr),Xt=i(Wr,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1ww3wqq"&&(Xt.textContent=xa),Wr.forEach(t),Ps=a(w),O=i(w,"DIV",{class:!0});var Qr=x(O);f(Te.$$.fragment,Qr),Is=a(Qr),Ut=i(Qr,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1g70y32"&&(Ut.textContent=$a),Qr.forEach(t),ks=a(w),K=i(w,"DIV",{class:!0});var Ar=x(K);f(Ce.$$.fragment,Ar),Xs=a(Ar),jt=i(Ar,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-5ayq1f"&&(jt.textContent=ya),Ar.forEach(t),w.forEach(t),dr=a(e),f(Pe.$$.fragment,e),cr=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1fn81xt"&&(Ie.innerHTML=Ma),mr=a(e),P=i(e,"DIV",{class:!0});var k=x(P);f(ke.$$.fragment,k),Us=a(k),Jt=i(k,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1bsw04k"&&(Jt.textContent=wa),js=a(k),ee=i(k,"DIV",{class:!0});var Yr=x(ee);f(Xe.$$.fragment,Yr),Js=a(Yr),Lt=i(Yr,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1eqt1dc"&&(Lt.innerHTML=Ta),Yr.forEach(t),Ls=a(k),te=i(k,"DIV",{class:!0});var Or=x(te);f(Ue.$$.fragment,Or),Zs=a(Or),Zt=i(Or,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-pplryq"&&(Zt.textContent=Ca),Or.forEach(t),qs=a(k),re=i(k,"DIV",{class:!0});var Kr=x(re);f(je.$$.fragment,Kr),Vs=a(Kr),qt=i(Kr,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-3oqyjr"&&(qt.textContent=Pa),Kr.forEach(t),Es=a(k),se=i(k,"DIV",{class:!0});var es=x(se);f(Je.$$.fragment,es),zs=a(es),Vt=i(es,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-1t1mjdd"&&(Vt.innerHTML=Ia),es.forEach(t),Hs=a(k),ae=i(k,"DIV",{class:!0});var ts=x(ae);f(Le.$$.fragment,ts),Ns=a(ts),Et=i(ts,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-wyradf"&&(Et.innerHTML=ka),ts.forEach(t),Bs=a(k),oe=i(k,"DIV",{class:!0});var rs=x(oe);f(Ze.$$.fragment,rs),Fs=a(rs),zt=i(rs,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1jevh15"&&(zt.textContent=Xa),rs.forEach(t),k.forEach(t),pr=a(e),j=i(e,"DIV",{class:!0});var Yt=x(j);f(qe.$$.fragment,Yt),Ss=a(Yt),Ht=i(Yt,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-vkt0pi"&&(Ht.textContent=Ua),Ds=a(Yt),ne=i(Yt,"DIV",{class:!0});var ss=x(ne);f(Ve.$$.fragment,ss),Gs=a(ss),Nt=i(ss,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-5ayq1f"&&(Nt.textContent=ja),ss.forEach(t),Yt.forEach(t),fr=a(e),J=i(e,"DIV",{class:!0});var Ot=x(J);f(Ee.$$.fragment,Ot),Rs=a(Ot),Bt=i(Ot,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-168wf64"&&(Bt.textContent=Ja),Ws=a(Ot),le=i(Ot,"DIV",{class:!0});var as=x(le);f(ze.$$.fragment,as),Qs=a(as),Ft=i(as,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-5ayq1f"&&(Ft.textContent=La),as.forEach(t),Ot.forEach(t),ur=a(e),f(He.$$.fragment,e),hr=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-pgkk87"&&(Ne.innerHTML=Za),gr=a(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1iz8kjk"&&(Be.textContent=qa),_r=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-ejlsq2"&&(Fe.textContent=Va),vr=a(e),Se=i(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-my8qym"&&(Se.innerHTML=Ea),br=a(e),De=i(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-n86jx6"&&(De.innerHTML=za),xr=a(e),N=i(e,"DIV",{class:!0});var os=x(N);f(Ge.$$.fragment,os),As=a(os),St=i(os,"P",{"data-svelte-h":!0}),d(St)!=="svelte-5lvrve"&&(St.innerHTML=Ha),os.forEach(t),$r=a(e),f(Re.$$.fragment,e),yr=a(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-9mlx1z"&&(We.innerHTML=Na),Mr=a(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1qabksm"&&(Qe.innerHTML=Ba),wr=a(e),Ae=i(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-uho2qa"&&(Ae.textContent=Fa),Tr=a(e),Ye=i(e,"UL",{"data-svelte-h":!0}),d(Ye)!=="svelte-1e2xq99"&&(Ye.innerHTML=Sa),Cr=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-sz5yy2"&&(Oe.textContent=Da),Pr=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1mss3di"&&(Ke.innerHTML=Ga),Ir=a(e),f(et.$$.fragment,e),kr=a(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1i4abtq"&&(tt.innerHTML=Ra),Xr=a(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-zxdzom"&&(rt.textContent=Wa),Ur=a(e),f(st.$$.fragment,e),jr=a(e),at=i(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-ejlsq2"&&(at.textContent=Qa),Jr=a(e),ot=i(e,"UL",{"data-svelte-h":!0}),d(ot)!=="svelte-1qiv3qf"&&(ot.innerHTML=Aa),Lr=a(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1r22nj6"&&(nt.innerHTML=Ya),Zr=a(e),X=i(e,"DIV",{class:!0});var H=x(X);f(lt.$$.fragment,H),Ys=a(H),Dt=i(H,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-173gxyd"&&(Dt.textContent=Oa),Os=a(H),ie=i(H,"DIV",{class:!0});var ns=x(ie);f(it.$$.fragment,ns),Ks=a(ns),Gt=i(ns,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-wmaktk"&&(Gt.textContent=Ka),ns.forEach(t),ea=a(H),z=i(H,"DIV",{class:!0});var Kt=x(z);f(dt.$$.fragment,Kt),ta=a(Kt),Rt=i(Kt,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-11nqnea"&&(Rt.innerHTML=eo),ra=a(Kt),f(de.$$.fragment,Kt),Kt.forEach(t),sa=a(H),ce=i(H,"DIV",{class:!0});var ls=x(ce);f(ct.$$.fragment,ls),aa=a(ls),Wt=i(ls,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-d5zv1x"&&(Wt.textContent=to),ls.forEach(t),H.forEach(t),qr=a(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-12wzh89"&&(mt.innerHTML=ro),Vr=a(e),L=i(e,"DIV",{class:!0});var er=x(L);f(pt.$$.fragment,er),oa=a(er),Qt=i(er,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-169nh0g"&&(Qt.textContent=so),na=a(er),f(me.$$.fragment,er),er.forEach(t),Er=a(e),ft=i(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-2mj9lk"&&(ft.innerHTML=ao),zr=a(e),f(ut.$$.fragment,e),Hr=a(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1q119ra"&&(ht.textContent=oo),Nr=a(e),f(gt.$$.fragment,e),Br=a(e),_t=i(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-9ecb4t"&&(_t.innerHTML=no),Fr=a(e),f(vt.$$.fragment,e),Sr=a(e),bt=i(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-8lr0dh"&&(bt.innerHTML=lo),Dr=a(e),f(xt.$$.fragment,e),Gr=a(e),rr=i(e,"P",{}),x(rr).forEach(t),this.h()},h(){$(c,"name","hf:doc:metadata"),$(c,"content",yo),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){o(document.head,c),n(e,T,r),n(e,v,r),n(e,b,r),u(C,e,r),n(e,m,r),n(e,I,r),n(e,ar,r),n(e,fe,r),n(e,or,r),u(ue,e,r),n(e,nr,r),n(e,he,r),n(e,lr,r),n(e,ge,r),n(e,ir,r),n(e,y,r),u(_e,y,null),o(y,is),o(y,Mt),o(y,ds),o(y,D),u(ve,D,null),o(D,cs),o(D,wt),o(y,ms),o(y,Z),u(be,Z,null),o(Z,ps),o(Z,Tt),o(Z,fs),u(G,Z,null),o(y,us),o(y,R),u(xe,R,null),o(R,hs),o(R,Ct),o(y,gs),o(y,q),u($e,q,null),o(q,_s),o(q,Pt),o(q,vs),u(W,q,null),o(y,bs),o(y,V),u(ye,V,null),o(V,xs),o(V,It),o(V,$s),u(Q,V,null),o(y,ys),o(y,E),u(Me,E,null),o(E,Ms),o(E,kt),o(E,ws),u(A,E,null),o(y,Ts),o(y,Y),u(we,Y,null),o(Y,Cs),o(Y,Xt),o(y,Ps),o(y,O),u(Te,O,null),o(O,Is),o(O,Ut),o(y,ks),o(y,K),u(Ce,K,null),o(K,Xs),o(K,jt),n(e,dr,r),u(Pe,e,r),n(e,cr,r),n(e,Ie,r),n(e,mr,r),n(e,P,r),u(ke,P,null),o(P,Us),o(P,Jt),o(P,js),o(P,ee),u(Xe,ee,null),o(ee,Js),o(ee,Lt),o(P,Ls),o(P,te),u(Ue,te,null),o(te,Zs),o(te,Zt),o(P,qs),o(P,re),u(je,re,null),o(re,Vs),o(re,qt),o(P,Es),o(P,se),u(Je,se,null),o(se,zs),o(se,Vt),o(P,Hs),o(P,ae),u(Le,ae,null),o(ae,Ns),o(ae,Et),o(P,Bs),o(P,oe),u(Ze,oe,null),o(oe,Fs),o(oe,zt),n(e,pr,r),n(e,j,r),u(qe,j,null),o(j,Ss),o(j,Ht),o(j,Ds),o(j,ne),u(Ve,ne,null),o(ne,Gs),o(ne,Nt),n(e,fr,r),n(e,J,r),u(Ee,J,null),o(J,Rs),o(J,Bt),o(J,Ws),o(J,le),u(ze,le,null),o(le,Qs),o(le,Ft),n(e,ur,r),u(He,e,r),n(e,hr,r),n(e,Ne,r),n(e,gr,r),n(e,Be,r),n(e,_r,r),n(e,Fe,r),n(e,vr,r),n(e,Se,r),n(e,br,r),n(e,De,r),n(e,xr,r),n(e,N,r),u(Ge,N,null),o(N,As),o(N,St),n(e,$r,r),u(Re,e,r),n(e,yr,r),n(e,We,r),n(e,Mr,r),n(e,Qe,r),n(e,wr,r),n(e,Ae,r),n(e,Tr,r),n(e,Ye,r),n(e,Cr,r),n(e,Oe,r),n(e,Pr,r),n(e,Ke,r),n(e,Ir,r),u(et,e,r),n(e,kr,r),n(e,tt,r),n(e,Xr,r),n(e,rt,r),n(e,Ur,r),u(st,e,r),n(e,jr,r),n(e,at,r),n(e,Jr,r),n(e,ot,r),n(e,Lr,r),n(e,nt,r),n(e,Zr,r),n(e,X,r),u(lt,X,null),o(X,Ys),o(X,Dt),o(X,Os),o(X,ie),u(it,ie,null),o(ie,Ks),o(ie,Gt),o(X,ea),o(X,z),u(dt,z,null),o(z,ta),o(z,Rt),o(z,ra),u(de,z,null),o(X,sa),o(X,ce),u(ct,ce,null),o(ce,aa),o(ce,Wt),n(e,qr,r),n(e,mt,r),n(e,Vr,r),n(e,L,r),u(pt,L,null),o(L,oa),o(L,Qt),o(L,na),u(me,L,null),n(e,Er,r),n(e,ft,r),n(e,zr,r),u(ut,e,r),n(e,Hr,r),n(e,ht,r),n(e,Nr,r),u(gt,e,r),n(e,Br,r),n(e,_t,r),n(e,Fr,r),u(vt,e,r),n(e,Sr,r),n(e,bt,r),n(e,Dr,r),u(xt,e,r),n(e,Gr,r),n(e,rr,r),Rr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const $t={};r&2&&($t.$$scope={dirty:r,ctx:e}),W.$set($t);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Q.$set(B);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),A.$set(yt);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),de.$set(F);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),me.$set(S)},i(e){Rr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(G.$$.fragment,e),h(xe.$$.fragment,e),h($e.$$.fragment,e),h(W.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(A.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(ke.$$.fragment,e),h(Xe.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Je.$$.fragment,e),h(Le.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ee.$$.fragment,e),h(ze.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(Re.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(de.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(me.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h(xt.$$.fragment,e),Rr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(G.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(W.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(A.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(ke.$$.fragment,e),g(Xe.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Je.$$.fragment,e),g(Le.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ee.$$.fragment,e),g(ze.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(Re.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(de.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(me.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),g(xt.$$.fragment,e),Rr=!1},d(e){e&&(t(T),t(v),t(b),t(m),t(I),t(ar),t(fe),t(or),t(nr),t(he),t(lr),t(ge),t(ir),t(y),t(dr),t(cr),t(Ie),t(mr),t(P),t(pr),t(j),t(fr),t(J),t(ur),t(hr),t(Ne),t(gr),t(Be),t(_r),t(Fe),t(vr),t(Se),t(br),t(De),t(xr),t(N),t($r),t(yr),t(We),t(Mr),t(Qe),t(wr),t(Ae),t(Tr),t(Ye),t(Cr),t(Oe),t(Pr),t(Ke),t(Ir),t(kr),t(tt),t(Xr),t(rt),t(Ur),t(jr),t(at),t(Jr),t(ot),t(Lr),t(nt),t(Zr),t(X),t(qr),t(mt),t(Vr),t(L),t(Er),t(ft),t(zr),t(Hr),t(ht),t(Nr),t(Br),t(_t),t(Fr),t(Sr),t(bt),t(Dr),t(Gr),t(rr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(be),_(G),_(xe),_($e),_(W),_(ye),_(Q),_(Me),_(A),_(we),_(Te),_(Ce),_(Pe,e),_(ke),_(Xe),_(Ue),_(je),_(Je),_(Le),_(Ze),_(qe),_(Ve),_(Ee),_(ze),_(He,e),_(Ge),_(Re,e),_(et,e),_(st,e),_(lt),_(it),_(dt),_(de),_(ct),_(pt),_(me),_(ut,e),_(gt,e),_(vt,e),_(xt,e)}}}const yo='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function Mo(U){return co(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Uo extends mo{constructor(c){super(),po(this,c,Mo,$o,io,{})}}export{Uo as component};
