import{s as al,o as il,n as fs}from"../chunks/scheduler.182ea377.js";import{S as ol,i as pl,g as i,s as n,r as f,A as rl,h as o,f as s,c as a,j as nl,u,x as p,k as ps,y as fl,a as l,v as m,d,t as c,w as h}from"../chunks/index.abf12888.js";import{T as rs}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as ul}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as Be}from"../chunks/Heading.16916d63.js";function ml(M){let r,b='The quicktour is a simplified version of the introductory 🧨 Diffusers <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/diffusers_intro.ipynb" rel="nofollow">notebook</a> to help you get started quickly. If you want to learn more about 🧨 Diffusers goal, design philosophy, and additional details about it’s core API, check out the notebook!';return{c(){r=i("p"),r.innerHTML=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-16mh6wm"&&(r.innerHTML=b)},m(g,w){l(g,r,w)},p:fs,d(g){g&&s(r)}}}function dl(M){let r,b='For <a href="https://huggingface.co/CompVis/stable-diffusion" rel="nofollow">Stable Diffusion</a> models, please carefully read the <a href="https://huggingface.co/spaces/CompVis/stable-diffusion-license" rel="nofollow">license</a> first before running the model. 🧨 Diffusers implements a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow"><code>safety_checker</code></a> to prevent offensive or harmful content, but the model’s improved image generation capabilities can still produce potentially harmful content.';return{c(){r=i("p"),r.innerHTML=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1rkwh7b"&&(r.innerHTML=b)},m(g,w){l(g,r,w)},p:fs,d(g){g&&s(r)}}}function cl(M){let r,b='🧨 Diffusers is a toolbox for building diffusion systems. While the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a convenient way to get started with a pre-built diffusion system, you can also choose your own model and scheduler components separately to build a custom diffusion system.';return{c(){r=i("p"),r.innerHTML=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1d30mol"&&(r.innerHTML=b)},m(g,w){l(g,r,w)},p:fs,d(g){g&&s(r)}}}function hl(M){let r,b="💡 Notice how the scheduler is instantiated from a configuration. Unlike a model, a scheduler does not have trainable weights and is parameter-free!";return{c(){r=i("p"),r.textContent=b},l(g){r=o(g,"P",{"data-svelte-h":!0}),p(r)!=="svelte-ynuxca"&&(r.textContent=b)},m(g,w){l(g,r,w)},p:fs,d(g){g&&s(r)}}}function gl(M){let r,b,g,w,k,Ne,C,Ve,x,us="Diffusion models are trained to denoise random Gaussian noise step-by-step to generate a sample of interest, such as an image or audio. This has sparked a tremendous amount of interest in generative AI, and you have probably seen examples of diffusion generated images on the internet. 🧨 Diffusers is a library aimed at making diffusion models widely accessible to everyone.",ze,Z,ms="Whether you’re a developer or an everyday user, this quicktour will introduce you to 🧨 Diffusers and help you get up and generating quickly! There are three main components of the library to know about:",Xe,J,ds='<li>The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is a high-level end-to-end class designed to rapidly generate samples from pretrained diffusion models for inference.</li> <li>Popular pretrained <a href="./api/models">model</a> architectures and modules that can be used as building blocks for creating diffusion systems.</li> <li>Many different <a href="./api/schedulers/overview">schedulers</a> - algorithms that control how noise is added for training, and how to generate denoised images during inference.</li>',Ye,G,cs='The quicktour will show you how to use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for inference, and then walk you through how to combine a model and scheduler to replicate what’s happening inside the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Re,$,Ee,W,hs="Before you begin, make sure you have all the necessary libraries installed:",Fe,q,Qe,S,gs='<li><a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate</a> speeds up model loading for inference and training.</li> <li><a href="https://huggingface.co/docs/transformers/index" rel="nofollow">🤗 Transformers</a> is required to run the most popular diffusion models, such as <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>.</li>',Ae,H,Ke,I,ys='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is the easiest way to use a pretrained diffusion system for inference. It is an end-to-end system containing the model and the scheduler. You can use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> out-of-the-box for many tasks. Take a look at the table below for some supported tasks, and for a complete list of supported tasks, check out the <a href="./api/pipelines/overview#diffusers-summary">🧨 Diffusers Summary</a> table.',Oe,P,bs='<thead><tr><th><strong>Task</strong></th> <th><strong>Description</strong></th> <th><strong>Pipeline</strong></th></tr></thead> <tbody><tr><td>Unconditional Image Generation</td> <td>generate an image from Gaussian noise</td> <td><a href="./using-diffusers/unconditional_image_generation">unconditional_image_generation</a></td></tr> <tr><td>Text-Guided Image Generation</td> <td>generate an image given a text prompt</td> <td><a href="./using-diffusers/conditional_image_generation">conditional_image_generation</a></td></tr> <tr><td>Text-Guided Image-to-Image Translation</td> <td>adapt an image guided by a text prompt</td> <td><a href="./using-diffusers/img2img">img2img</a></td></tr> <tr><td>Text-Guided Image-Inpainting</td> <td>fill the masked part of an image given the image, the mask and a text prompt</td> <td><a href="./using-diffusers/inpaint">inpaint</a></td></tr> <tr><td>Text-Guided Depth-to-Image Translation</td> <td>adapt parts of an image guided by a text prompt while preserving structure via depth estimation</td> <td><a href="./using-diffusers/depth2img">depth2img</a></td></tr></tbody>',et,L,ws=`Start by creating an instance of a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and specify which pipeline checkpoint you would like to download.
You can use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for any <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">checkpoint</a> stored on the Hugging Face Hub.
In this quicktour, you’ll load the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5</code></a> checkpoint for text-to-image generation.`,tt,j,st,B,Ms='Load the model with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',lt,D,nt,N,$s='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> downloads and caches all modeling, tokenization, and scheduling components. You’ll see that the Stable Diffusion pipeline is composed of the <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> among other things:',at,V,it,z,js=`We strongly recommend running the pipeline on a GPU because the model consists of roughly 1.4 billion parameters.
You can move the generator object to a GPU, just like you would in PyTorch:`,ot,X,pt,Y,vs='Now you can pass a text prompt to the <code>pipeline</code> to generate an image, and then access the denoised image. By default, the image output is wrapped in a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html?highlight=image#the-image-class" rel="nofollow"><code>PIL.Image</code></a> object.',rt,R,ft,v,Ts='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/image_of_squirrel_painting.png"/>',ut,E,Us="Save the image by calling <code>save</code>:",mt,F,dt,Q,ct,A,_s="You can also use the pipeline locally. The only difference is you need to download the weights first:",ht,K,gt,O,ks="Then load the saved weights into the pipeline:",yt,ee,bt,te,Cs="Now you can run the pipeline as you would in the section above.",wt,se,Mt,le,xs='Different schedulers come with different denoising speeds and quality trade-offs. The best way to find out which one works best for you is to try them out! One of the main features of 🧨 Diffusers is to allow you to easily switch between schedulers. For example, to replace the default <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with the <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>, load it with the <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method:',$t,ne,jt,ae,Zs="Try generating an image with the new scheduler and see if you notice a difference!",vt,ie,Js='In the next section, you’ll take a closer look at the components - the model and scheduler - that make up the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> and learn how to use these components to generate an image of a cat.',Tt,oe,Ut,pe,Gs='Most models take a noisy sample, and at each timestep it predicts the <em>noise residual</em> (other models learn to predict the previous sample directly or the velocity or <a href="https://github.com/huggingface/diffusers/blob/5e5ce13e2f89ac45a0066cb3f369462a3cf1d9ef/src/diffusers/schedulers/scheduling_ddim.py#L110" rel="nofollow"><code>v-prediction</code></a>), the difference between a less noisy image and the input image. You can mix and match models to create other diffusion systems.',_t,re,Ws='Models are initiated with the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method which also locally caches the model weights so it is faster the next time you load the model. For the quicktour, you’ll load the <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>, a basic unconditional image generation model with a checkpoint trained on cat images:',kt,fe,Ct,ue,qs="To access the model parameters, call <code>model.config</code>:",xt,me,Zt,de,Ss="The model configuration is a 🧊 frozen 🧊 dictionary, which means those parameters can’t be changed after the model is created. This is intentional and ensures that the parameters used to define the model architecture at the start remain the same, while other parameters can still be adjusted during inference.",Jt,ce,Hs="Some of the most important parameters are:",Gt,he,Is="<li><code>sample_size</code>: the height and width dimension of the input sample.</li> <li><code>in_channels</code>: the number of input channels of the input sample.</li> <li><code>down_block_types</code> and <code>up_block_types</code>: the type of down- and upsampling blocks used to create the UNet architecture.</li> <li><code>block_out_channels</code>: the number of output channels of the downsampling blocks; also used in reverse order for the number of input channels of the upsampling blocks.</li> <li><code>layers_per_block</code>: the number of ResNet blocks present in each UNet block.</li>",Wt,ge,Ps="To use the model for inference, create the image shape with random Gaussian noise. It should have a <code>batch</code> axis because the model can receive multiple random noises, a <code>channel</code> axis corresponding to the number of input channels, and a <code>sample_size</code> axis for the height and width of the image:",qt,ye,St,be,Ls="For inference, pass the noisy image to the model and a <code>timestep</code>. The <code>timestep</code> indicates how noisy the input image is, with more noise at the beginning and less at the end. This helps the model determine its position in the diffusion process, whether it is closer to the start or the end. Use the <code>sample</code> method to get the model output:",Ht,we,It,Me,Bs="To generate actual examples though, you’ll need a scheduler to guide the denoising process. In the next section, you’ll learn how to couple a model with a scheduler.",Pt,$e,Lt,je,Ds="Schedulers manage going from a noisy sample to a less noisy sample given the model output - in this case, it is the <code>noisy_residual</code>.",Bt,T,Dt,ve,Ns='For the quicktour, you’ll instantiate the <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> with it’s <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> method:',Nt,Te,Vt,U,zt,Ue,Vs="Some of the most important parameters are:",Xt,_e,zs="<li><code>num_train_timesteps</code>: the length of the denoising process or in other words, the number of timesteps required to process random Gaussian noise into a data sample.</li> <li><code>beta_schedule</code>: the type of noise schedule to use for inference and training.</li> <li><code>beta_start</code> and <code>beta_end</code>: the start and end noise values for the noise schedule.</li>",Yt,ke,Xs='To predict a slightly less noisy image, pass the following to the scheduler’s <a href="/docs/diffusers/main/en/api/schedulers/ddpm#diffusers.DDPMScheduler.step">step()</a> method: model output, <code>timestep</code>, and current <code>sample</code>.',Rt,Ce,Et,xe,Ys="The <code>less_noisy_sample</code> can be passed to the next <code>timestep</code> where it’ll get even less noisier! Let’s bring it all together now and visualize the entire denoising process.",Ft,Ze,Rs="First, create a function that postprocesses and displays the denoised image as a <code>PIL.Image</code>:",Qt,Je,At,Ge,Es="To speed up the denoising process, move the input and model to a GPU:",Kt,We,Ot,qe,Fs="Now create a denoising loop that predicts the residual of the less noisy sample, and computes the less noisy sample with the scheduler:",es,Se,ts,He,Qs="Sit back and watch as a cat is generated from nothing but noise! 😻",ss,_,As='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/diffusion-quicktour.png"/>',ls,Ie,ns,Pe,Ks="Hopefully you generated some cool images with 🧨 Diffusers in this quicktour! For your next steps, you can:",as,Le,Os='<li>Train or finetune a model to generate your own images in the <a href="./tutorials/basic_training">training</a> tutorial.</li> <li>See example official and community <a href="https://github.com/huggingface/diffusers/tree/main/examples#-diffusers-examples" rel="nofollow">training or finetuning scripts</a> for a variety of use cases.</li> <li>Learn more about loading, accessing, changing and comparing schedulers in the <a href="./using-diffusers/schedulers">Using different Schedulers</a> guide.</li> <li>Explore prompt engineering, speed and memory optimizations, and tips and tricks for generating higher quality images with the <a href="./stable_diffusion">Stable Diffusion</a> guide.</li> <li>Dive deeper into speeding up 🧨 Diffusers with guides on <a href="./optimization/fp16">optimized PyTorch on a GPU</a>, and inference guides for running <a href="./optimization/mps">Stable Diffusion on Apple Silicon (M1/M2)</a> and <a href="./optimization/onnx">ONNX Runtime</a>.</li>',is,De,os;return k=new ul({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/quicktour.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/quicktour.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/quicktour.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/quicktour.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/quicktour.ipynb"}]}}),C=new Be({props:{title:"Quicktour",local:"quicktour",headingTag:"h1"}}),$=new rs({props:{$$slots:{default:[ml]},$$scope:{ctx:M}}}),q=new y({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwZGlmZnVzZXJzJTIwYWNjZWxlcmF0ZSUyMHRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install --upgrade diffusers accelerate transformers</span>`,wrap:!1}}),H=new Be({props:{title:"DiffusionPipeline",local:"diffusionpipeline",headingTag:"h2"}}),j=new rs({props:{warning:!0,$$slots:{default:[dl]},$$scope:{ctx:M}}}),D=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),V=new y({props:{code:"cGlwZWxpbmU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline
StableDiffusionPipeline {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  ...,
  <span class="hljs-string">&quot;scheduler&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  ],
  ...,
  <span class="hljs-string">&quot;unet&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  ],
  <span class="hljs-string">&quot;vae&quot;</span>: [
    <span class="hljs-string">&quot;diffusers&quot;</span>,
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  ]
}`,wrap:!1}}),X=new y({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),R=new y({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBbiUyMGltYWdlJTIwb2YlMjBhJTIwc3F1aXJyZWwlMjBpbiUyMFBpY2Fzc28lMjBzdHlsZSUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline(<span class="hljs-string">&quot;An image of a squirrel in Picasso style&quot;</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),F=new y({props:{code:"aW1hZ2Uuc2F2ZSglMjJpbWFnZV9vZl9zcXVpcnJlbF9wYWludGluZy5wbmclMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;image_of_squirrel_painting.png&quot;</span>)',wrap:!1}}),Q=new Be({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),K=new y({props:{code:"IWdpdCUyMGxmcyUyMGluc3RhbGwlMEEhZ2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:`!git lfs install
!git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),ee=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)',wrap:!1}}),se=new Be({props:{title:"Swapping schedulers",local:"swapping-schedulers",headingTag:"h3"}}),ne=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),oe=new Be({props:{title:"Models",local:"models",headingTag:"h2"}}),fe=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2F0LTI1NiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;google/ddpm-cat-256&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new y({props:{code:"bW9kZWwuY29uZmln",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config',wrap:!1}}),ye=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQW5vaXN5X3NhbXBsZSUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjBtb2RlbC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUlMkMlMjBtb2RlbC5jb25maWcuc2FtcGxlX3NpemUpJTBBbm9pc3lfc2FtcGxlLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = torch.randn(<span class="hljs-number">1</span>, model.config.in_channels, model.config.sample_size, model.config.sample_size)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),we=new y({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5vaXN5X3Jlc2lkdWFsJTIwJTNEJTIwbW9kZWwoc2FtcGxlJTNEbm9pc3lfc2FtcGxlJTJDJTIwdGltZXN0ZXAlM0QyKS5zYW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    noisy_residual = model(sample=noisy_sample, timestep=<span class="hljs-number">2</span>).sample`,wrap:!1}}),$e=new Be({props:{title:"Schedulers",local:"schedulers",headingTag:"h2"}}),T=new rs({props:{$$slots:{default:[cl]},$$scope:{ctx:M}}}),Te=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fY29uZmlnKHJlcG9faWQpJTBBc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = DDPMScheduler.from_config(repo_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler
DDPMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;DDPMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.13.1&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.02</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.0001</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: true,
  <span class="hljs-string">&quot;clip_sample_range&quot;</span>: <span class="hljs-number">1.0</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;prediction_type&quot;</span>: <span class="hljs-string">&quot;epsilon&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: null,
  <span class="hljs-string">&quot;variance_type&quot;</span>: <span class="hljs-string">&quot;fixed_small&quot;</span>
}`,wrap:!1}}),U=new rs({props:{$$slots:{default:[hl]},$$scope:{ctx:M}}}),Ce=new y({props:{code:"bGVzc19ub2lzeV9zYW1wbGUlMjAlM0QlMjBzY2hlZHVsZXIuc3RlcChtb2RlbF9vdXRwdXQlM0Rub2lzeV9yZXNpZHVhbCUyQyUyMHRpbWVzdGVwJTNEMiUyQyUyMHNhbXBsZSUzRG5vaXN5X3NhbXBsZSkucHJldl9zYW1wbGUlMEFsZXNzX25vaXN5X3NhbXBsZS5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample = scheduler.step(model_output=noisy_residual, timestep=<span class="hljs-number">2</span>, sample=noisy_sample).prev_sample
<span class="hljs-meta">&gt;&gt;&gt; </span>less_noisy_sample.shape`,wrap:!1}}),Je=new y({props:{code:"aW1wb3J0JTIwUElMLkltYWdlJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwZGlzcGxheV9zYW1wbGUoc2FtcGxlJTJDJTIwaSklM0ElMEElMjAlMjAlMjAlMjBpbWFnZV9wcm9jZXNzZWQlMjAlM0QlMjBzYW1wbGUuY3B1KCkucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMGltYWdlX3Byb2Nlc3NlZCUyMCUzRCUyMChpbWFnZV9wcm9jZXNzZWQlMjAlMkIlMjAxLjApJTIwKiUyMDEyNy41JTBBJTIwJTIwJTIwJTIwaW1hZ2VfcHJvY2Vzc2VkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc2VkLm51bXB5KCkuYXN0eXBlKG5wLnVpbnQ4KSUwQSUwQSUyMCUyMCUyMCUyMGltYWdlX3BpbCUyMCUzRCUyMFBJTC5JbWFnZS5mcm9tYXJyYXkoaW1hZ2VfcHJvY2Vzc2VkJTVCMCU1RCklMEElMjAlMjAlMjAlMjBkaXNwbGF5KGYlMjJJbWFnZSUyMGF0JTIwc3RlcCUyMCU3QmklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZGlzcGxheShpbWFnZV9waWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL.Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_sample</span>(<span class="hljs-params">sample, i</span>):
<span class="hljs-meta">... </span>    image_processed = sample.cpu().permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    image_processed = (image_processed + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>
<span class="hljs-meta">... </span>    image_processed = image_processed.numpy().astype(np.uint8)

<span class="hljs-meta">... </span>    image_pil = PIL.Image.fromarray(image_processed[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    display(<span class="hljs-string">f&quot;Image at step <span class="hljs-subst">{i}</span>&quot;</span>)
<span class="hljs-meta">... </span>    display(image_pil)`,wrap:!1}}),We=new y({props:{code:"bW9kZWwudG8oJTIyY3VkYSUyMiklMEFub2lzeV9zYW1wbGUlMjAlM0QlMjBub2lzeV9zYW1wbGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_sample = noisy_sample.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Se=new y({props:{code:"aW1wb3J0JTIwdHFkbSUwQSUwQXNhbXBsZSUyMCUzRCUyMG5vaXN5X3NhbXBsZSUwQSUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjBlbnVtZXJhdGUodHFkbS50cWRtKHNjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMDEuJTIwcHJlZGljdCUyMG5vaXNlJTIwcmVzaWR1YWwlMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzaWR1YWwlMjAlM0QlMjBtb2RlbChzYW1wbGUlMkMlMjB0KS5zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAyLiUyMGNvbXB1dGUlMjBsZXNzJTIwbm9pc3klMjBpbWFnZSUyMGFuZCUyMHNldCUyMHhfdCUyMC0lM0UlMjB4X3QtMSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHNhbXBsZSkucHJldl9zYW1wbGUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjAzLiUyMG9wdGlvbmFsbHklMjBsb29rJTIwYXQlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMGlmJTIwKGklMjAlMkIlMjAxKSUyMCUyNSUyMDUwJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3BsYXlfc2FtcGxlKHNhbXBsZSUyQyUyMGklMjAlMkIlMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>sample = noisy_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm.tqdm(scheduler.timesteps)):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># 1. predict noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = model(sample, t).sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 2. compute less noisy image and set x_t -&gt; x_t-1</span>
<span class="hljs-meta">... </span>    sample = scheduler.step(residual, t, sample).prev_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># 3. optionally look at image</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> (i + <span class="hljs-number">1</span>) % <span class="hljs-number">50</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        display_sample(sample, i + <span class="hljs-number">1</span>)`,wrap:!1}}),Ie=new Be({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){r=i("meta"),b=n(),g=i("p"),w=n(),f(k.$$.fragment),Ne=n(),f(C.$$.fragment),Ve=n(),x=i("p"),x.textContent=us,ze=n(),Z=i("p"),Z.textContent=ms,Xe=n(),J=i("ul"),J.innerHTML=ds,Ye=n(),G=i("p"),G.innerHTML=cs,Re=n(),f($.$$.fragment),Ee=n(),W=i("p"),W.textContent=hs,Fe=n(),f(q.$$.fragment),Qe=n(),S=i("ul"),S.innerHTML=gs,Ae=n(),f(H.$$.fragment),Ke=n(),I=i("p"),I.innerHTML=ys,Oe=n(),P=i("table"),P.innerHTML=bs,et=n(),L=i("p"),L.innerHTML=ws,tt=n(),f(j.$$.fragment),st=n(),B=i("p"),B.innerHTML=Ms,lt=n(),f(D.$$.fragment),nt=n(),N=i("p"),N.innerHTML=$s,at=n(),f(V.$$.fragment),it=n(),z=i("p"),z.textContent=js,ot=n(),f(X.$$.fragment),pt=n(),Y=i("p"),Y.innerHTML=vs,rt=n(),f(R.$$.fragment),ft=n(),v=i("div"),v.innerHTML=Ts,ut=n(),E=i("p"),E.innerHTML=Us,mt=n(),f(F.$$.fragment),dt=n(),f(Q.$$.fragment),ct=n(),A=i("p"),A.textContent=_s,ht=n(),f(K.$$.fragment),gt=n(),O=i("p"),O.textContent=ks,yt=n(),f(ee.$$.fragment),bt=n(),te=i("p"),te.textContent=Cs,wt=n(),f(se.$$.fragment),Mt=n(),le=i("p"),le.innerHTML=xs,$t=n(),f(ne.$$.fragment),jt=n(),ae=i("p"),ae.textContent=Zs,vt=n(),ie=i("p"),ie.innerHTML=Js,Tt=n(),f(oe.$$.fragment),Ut=n(),pe=i("p"),pe.innerHTML=Gs,_t=n(),re=i("p"),re.innerHTML=Ws,kt=n(),f(fe.$$.fragment),Ct=n(),ue=i("p"),ue.innerHTML=qs,xt=n(),f(me.$$.fragment),Zt=n(),de=i("p"),de.textContent=Ss,Jt=n(),ce=i("p"),ce.textContent=Hs,Gt=n(),he=i("ul"),he.innerHTML=Is,Wt=n(),ge=i("p"),ge.innerHTML=Ps,qt=n(),f(ye.$$.fragment),St=n(),be=i("p"),be.innerHTML=Ls,Ht=n(),f(we.$$.fragment),It=n(),Me=i("p"),Me.textContent=Bs,Pt=n(),f($e.$$.fragment),Lt=n(),je=i("p"),je.innerHTML=Ds,Bt=n(),f(T.$$.fragment),Dt=n(),ve=i("p"),ve.innerHTML=Ns,Nt=n(),f(Te.$$.fragment),Vt=n(),f(U.$$.fragment),zt=n(),Ue=i("p"),Ue.textContent=Vs,Xt=n(),_e=i("ul"),_e.innerHTML=zs,Yt=n(),ke=i("p"),ke.innerHTML=Xs,Rt=n(),f(Ce.$$.fragment),Et=n(),xe=i("p"),xe.innerHTML=Ys,Ft=n(),Ze=i("p"),Ze.innerHTML=Rs,Qt=n(),f(Je.$$.fragment),At=n(),Ge=i("p"),Ge.textContent=Es,Kt=n(),f(We.$$.fragment),Ot=n(),qe=i("p"),qe.textContent=Fs,es=n(),f(Se.$$.fragment),ts=n(),He=i("p"),He.textContent=Qs,ss=n(),_=i("div"),_.innerHTML=As,ls=n(),f(Ie.$$.fragment),ns=n(),Pe=i("p"),Pe.textContent=Ks,as=n(),Le=i("ul"),Le.innerHTML=Os,is=n(),De=i("p"),this.h()},l(e){const t=rl("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(s),b=a(e),g=o(e,"P",{}),nl(g).forEach(s),w=a(e),u(k.$$.fragment,e),Ne=a(e),u(C.$$.fragment,e),Ve=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1cpm7jx"&&(x.textContent=us),ze=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-3g0auf"&&(Z.textContent=ms),Xe=a(e),J=o(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-1qchzzn"&&(J.innerHTML=ds),Ye=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-7kdkxv"&&(G.innerHTML=cs),Re=a(e),u($.$$.fragment,e),Ee=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1c9nexd"&&(W.textContent=hs),Fe=a(e),u(q.$$.fragment,e),Qe=a(e),S=o(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1iag7i0"&&(S.innerHTML=gs),Ae=a(e),u(H.$$.fragment,e),Ke=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-42w8gp"&&(I.innerHTML=ys),Oe=a(e),P=o(e,"TABLE",{"data-svelte-h":!0}),p(P)!=="svelte-1jwscsx"&&(P.innerHTML=bs),et=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-14ivsj7"&&(L.innerHTML=ws),tt=a(e),u(j.$$.fragment,e),st=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1sqaj7s"&&(B.innerHTML=Ms),lt=a(e),u(D.$$.fragment,e),nt=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1rhvpsx"&&(N.innerHTML=$s),at=a(e),u(V.$$.fragment,e),it=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1vgclnr"&&(z.textContent=js),ot=a(e),u(X.$$.fragment,e),pt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1p83go0"&&(Y.innerHTML=vs),rt=a(e),u(R.$$.fragment,e),ft=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-6cjtp1"&&(v.innerHTML=Ts),ut=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-10baso4"&&(E.innerHTML=Us),mt=a(e),u(F.$$.fragment,e),dt=a(e),u(Q.$$.fragment,e),ct=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1hfw8pu"&&(A.textContent=_s),ht=a(e),u(K.$$.fragment,e),gt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1fgahuv"&&(O.textContent=ks),yt=a(e),u(ee.$$.fragment,e),bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-lgl7y7"&&(te.textContent=Cs),wt=a(e),u(se.$$.fragment,e),Mt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-ha3iyl"&&(le.innerHTML=xs),$t=a(e),u(ne.$$.fragment,e),jt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-hnrydi"&&(ae.textContent=Zs),vt=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1wktwe"&&(ie.innerHTML=Js),Tt=a(e),u(oe.$$.fragment,e),Ut=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-tok5h3"&&(pe.innerHTML=Gs),_t=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1ozhfyi"&&(re.innerHTML=Ws),kt=a(e),u(fe.$$.fragment,e),Ct=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-13d7r4d"&&(ue.innerHTML=qs),xt=a(e),u(me.$$.fragment,e),Zt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-yz2ttj"&&(de.textContent=Ss),Jt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1xmzk7t"&&(ce.textContent=Hs),Gt=a(e),he=o(e,"UL",{"data-svelte-h":!0}),p(he)!=="svelte-1t4snl"&&(he.innerHTML=Is),Wt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-18dlapv"&&(ge.innerHTML=Ps),qt=a(e),u(ye.$$.fragment,e),St=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-dj1hwx"&&(be.innerHTML=Ls),Ht=a(e),u(we.$$.fragment,e),It=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1c3hoxe"&&(Me.textContent=Bs),Pt=a(e),u($e.$$.fragment,e),Lt=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-vj25k8"&&(je.innerHTML=Ds),Bt=a(e),u(T.$$.fragment,e),Dt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-t4u3mo"&&(ve.innerHTML=Ns),Nt=a(e),u(Te.$$.fragment,e),Vt=a(e),u(U.$$.fragment,e),zt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1xmzk7t"&&(Ue.textContent=Vs),Xt=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),p(_e)!=="svelte-102d6ev"&&(_e.innerHTML=zs),Yt=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-iouzdr"&&(ke.innerHTML=Xs),Rt=a(e),u(Ce.$$.fragment,e),Et=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1kuo2su"&&(xe.innerHTML=Ys),Ft=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1hb61xc"&&(Ze.innerHTML=Rs),Qt=a(e),u(Je.$$.fragment,e),At=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-12lvw8p"&&(Ge.textContent=Es),Kt=a(e),u(We.$$.fragment,e),Ot=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-vtqbzo"&&(qe.textContent=Fs),es=a(e),u(Se.$$.fragment,e),ts=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-ho6yui"&&(He.textContent=Qs),ss=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(_)!=="svelte-1yzsrw6"&&(_.innerHTML=As),ls=a(e),u(Ie.$$.fragment,e),ns=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-q2krpg"&&(Pe.textContent=Ks),as=a(e),Le=o(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-v1cthu"&&(Le.innerHTML=Os),is=a(e),De=o(e,"P",{}),nl(De).forEach(s),this.h()},h(){ps(r,"name","hf:doc:metadata"),ps(r,"content",yl),ps(v,"class","flex justify-center"),ps(_,"class","flex justify-center")},m(e,t){fl(document.head,r),l(e,b,t),l(e,g,t),l(e,w,t),m(k,e,t),l(e,Ne,t),m(C,e,t),l(e,Ve,t),l(e,x,t),l(e,ze,t),l(e,Z,t),l(e,Xe,t),l(e,J,t),l(e,Ye,t),l(e,G,t),l(e,Re,t),m($,e,t),l(e,Ee,t),l(e,W,t),l(e,Fe,t),m(q,e,t),l(e,Qe,t),l(e,S,t),l(e,Ae,t),m(H,e,t),l(e,Ke,t),l(e,I,t),l(e,Oe,t),l(e,P,t),l(e,et,t),l(e,L,t),l(e,tt,t),m(j,e,t),l(e,st,t),l(e,B,t),l(e,lt,t),m(D,e,t),l(e,nt,t),l(e,N,t),l(e,at,t),m(V,e,t),l(e,it,t),l(e,z,t),l(e,ot,t),m(X,e,t),l(e,pt,t),l(e,Y,t),l(e,rt,t),m(R,e,t),l(e,ft,t),l(e,v,t),l(e,ut,t),l(e,E,t),l(e,mt,t),m(F,e,t),l(e,dt,t),m(Q,e,t),l(e,ct,t),l(e,A,t),l(e,ht,t),m(K,e,t),l(e,gt,t),l(e,O,t),l(e,yt,t),m(ee,e,t),l(e,bt,t),l(e,te,t),l(e,wt,t),m(se,e,t),l(e,Mt,t),l(e,le,t),l(e,$t,t),m(ne,e,t),l(e,jt,t),l(e,ae,t),l(e,vt,t),l(e,ie,t),l(e,Tt,t),m(oe,e,t),l(e,Ut,t),l(e,pe,t),l(e,_t,t),l(e,re,t),l(e,kt,t),m(fe,e,t),l(e,Ct,t),l(e,ue,t),l(e,xt,t),m(me,e,t),l(e,Zt,t),l(e,de,t),l(e,Jt,t),l(e,ce,t),l(e,Gt,t),l(e,he,t),l(e,Wt,t),l(e,ge,t),l(e,qt,t),m(ye,e,t),l(e,St,t),l(e,be,t),l(e,Ht,t),m(we,e,t),l(e,It,t),l(e,Me,t),l(e,Pt,t),m($e,e,t),l(e,Lt,t),l(e,je,t),l(e,Bt,t),m(T,e,t),l(e,Dt,t),l(e,ve,t),l(e,Nt,t),m(Te,e,t),l(e,Vt,t),m(U,e,t),l(e,zt,t),l(e,Ue,t),l(e,Xt,t),l(e,_e,t),l(e,Yt,t),l(e,ke,t),l(e,Rt,t),m(Ce,e,t),l(e,Et,t),l(e,xe,t),l(e,Ft,t),l(e,Ze,t),l(e,Qt,t),m(Je,e,t),l(e,At,t),l(e,Ge,t),l(e,Kt,t),m(We,e,t),l(e,Ot,t),l(e,qe,t),l(e,es,t),m(Se,e,t),l(e,ts,t),l(e,He,t),l(e,ss,t),l(e,_,t),l(e,ls,t),m(Ie,e,t),l(e,ns,t),l(e,Pe,t),l(e,as,t),l(e,Le,t),l(e,is,t),l(e,De,t),os=!0},p(e,[t]){const el={};t&2&&(el.$$scope={dirty:t,ctx:e}),$.$set(el);const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),j.$set(tl);const sl={};t&2&&(sl.$$scope={dirty:t,ctx:e}),T.$set(sl);const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),U.$set(ll)},i(e){os||(d(k.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(H.$$.fragment,e),d(j.$$.fragment,e),d(D.$$.fragment,e),d(V.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(fe.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d($e.$$.fragment,e),d(T.$$.fragment,e),d(Te.$$.fragment,e),d(U.$$.fragment,e),d(Ce.$$.fragment,e),d(Je.$$.fragment,e),d(We.$$.fragment,e),d(Se.$$.fragment,e),d(Ie.$$.fragment,e),os=!0)},o(e){c(k.$$.fragment,e),c(C.$$.fragment,e),c($.$$.fragment,e),c(q.$$.fragment,e),c(H.$$.fragment,e),c(j.$$.fragment,e),c(D.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(R.$$.fragment,e),c(F.$$.fragment,e),c(Q.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(fe.$$.fragment,e),c(me.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c($e.$$.fragment,e),c(T.$$.fragment,e),c(Te.$$.fragment,e),c(U.$$.fragment,e),c(Ce.$$.fragment,e),c(Je.$$.fragment,e),c(We.$$.fragment,e),c(Se.$$.fragment,e),c(Ie.$$.fragment,e),os=!1},d(e){e&&(s(b),s(g),s(w),s(Ne),s(Ve),s(x),s(ze),s(Z),s(Xe),s(J),s(Ye),s(G),s(Re),s(Ee),s(W),s(Fe),s(Qe),s(S),s(Ae),s(Ke),s(I),s(Oe),s(P),s(et),s(L),s(tt),s(st),s(B),s(lt),s(nt),s(N),s(at),s(it),s(z),s(ot),s(pt),s(Y),s(rt),s(ft),s(v),s(ut),s(E),s(mt),s(dt),s(ct),s(A),s(ht),s(gt),s(O),s(yt),s(bt),s(te),s(wt),s(Mt),s(le),s($t),s(jt),s(ae),s(vt),s(ie),s(Tt),s(Ut),s(pe),s(_t),s(re),s(kt),s(Ct),s(ue),s(xt),s(Zt),s(de),s(Jt),s(ce),s(Gt),s(he),s(Wt),s(ge),s(qt),s(St),s(be),s(Ht),s(It),s(Me),s(Pt),s(Lt),s(je),s(Bt),s(Dt),s(ve),s(Nt),s(Vt),s(zt),s(Ue),s(Xt),s(_e),s(Yt),s(ke),s(Rt),s(Et),s(xe),s(Ft),s(Ze),s(Qt),s(At),s(Ge),s(Kt),s(Ot),s(qe),s(es),s(ts),s(He),s(ss),s(_),s(ls),s(ns),s(Pe),s(as),s(Le),s(is),s(De)),s(r),h(k,e),h(C,e),h($,e),h(q,e),h(H,e),h(j,e),h(D,e),h(V,e),h(X,e),h(R,e),h(F,e),h(Q,e),h(K,e),h(ee,e),h(se,e),h(ne,e),h(oe,e),h(fe,e),h(me,e),h(ye,e),h(we,e),h($e,e),h(T,e),h(Te,e),h(U,e),h(Ce,e),h(Je,e),h(We,e),h(Se,e),h(Ie,e)}}}const yl='{"title":"Quicktour","local":"quicktour","sections":[{"title":"DiffusionPipeline","local":"diffusionpipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3},{"title":"Swapping schedulers","local":"swapping-schedulers","sections":[],"depth":3}],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Schedulers","local":"schedulers","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function bl(M){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ul extends ol{constructor(r){super(),pl(this,r,bl,gl,al,{})}}export{Ul as component};
