import{s as Ll,o as Sl,n as Nl}from"../chunks/scheduler.182ea377.js";import{S as zl,i as Ql,g as a,s as i,r as o,A as Yl,h as r,f as l,c as n,j as Xl,u as m,x as p,k as w,y as Dl,a as s,v as u,d as f,t as c,w as d}from"../chunks/index.abf12888.js";import{T as Rl}from"../chunks/Tip.230e2334.js";import{C as M}from"../chunks/CodeBlock.57fe6e13.js";import{D as Fl}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as _}from"../chunks/Heading.16916d63.js";function Pl(He){let h,b='💡 If you don’t have access to a GPU, you can use one for free from a GPU provider like <a href="https://colab.research.google.com/" rel="nofollow">Colab</a>!';return{c(){h=a("p"),h.innerHTML=b},l(y){h=r(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-5o248f"&&(h.innerHTML=b)},m(y,g){s(y,h,g)},p:Nl,d(y){y&&l(h)}}}function El(He){let h,b="💡 We strongly suggest always running your pipelines in <code>float16</code>, and so far, we’ve rarely seen any degradation in output quality.";return{c(){h=a("p"),h.innerHTML=b},l(y){h=r(y,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1i2b108"&&(h.innerHTML=b)},m(y,g){s(y,h,g)},p:Nl,d(y){y&&l(h)}}}function Al(He){let h,b,y,g,k,xe,I,Xe,V,qt='Getting the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to generate images in a certain style or include what you want can be tricky. Often times, you have to run the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> several times before you end up with an image you’re happy with. But generating something out of nothing is a computationally intensive process, especially if you’re running inference over and over again.',Re,C,Kt="This is why it’s important to get the most <em>computational</em> (speed) and <em>memory</em> (GPU RAM) efficiency from the pipeline to reduce the time between inference cycles so you can iterate faster.",Ne,H,Ot='This tutorial walks you through how to generate faster and better with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.',Le,B,el='Begin by loading the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model:',Se,x,ze,X,tl="The example prompt you’ll use is a portrait of an old warrior chief, but feel free to use your own prompt:",Qe,R,Ye,N,De,J,Fe,L,ll="One of the simplest ways to speed up inference is to place the pipeline on a GPU the same way you would with any PyTorch module:",Pe,S,Ee,z,sl='To make sure you can use the same image and improve on it, use a <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>Generator</code></a> and set a seed for <a href="./using-diffusers/reproducibility">reproducibility</a>:',Ae,Q,qe,Y,il="Now you can generate an image:",Ke,D,Oe,T,nl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_1.png"/>',et,F,al='This process took ~30 seconds on a T4 GPU (it might be faster if your allocated GPU is better than a T4). By default, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> runs inference with full <code>float32</code> precision for 50 inference steps. You can speed this up by switching to a lower precision like <code>float16</code> or running fewer inference steps.',tt,P,rl="Let’s start by loading the model in <code>float16</code> and generate an image:",lt,E,st,U,pl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_2.png"/>',it,A,ol="This time, it only took ~11 seconds to generate the image, which is almost 3x faster than before!",nt,Z,at,q,ml='Another option is to reduce the number of inference steps. Choosing a more efficient scheduler could help decrease the number of steps without sacrificing output quality. You can find which schedulers are compatible with the current model in the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> by calling the <code>compatibles</code> method:',rt,K,pt,O,ul='The Stable Diffusion model uses the <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> by default which usually requires ~50 inference steps, but more performant schedulers like <a href="/docs/diffusers/main/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>, require only ~20 or 25 inference steps. Use the <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">ConfigMixin.from_config()</a> method to load a new scheduler:',ot,ee,mt,te,fl="Now set the <code>num_inference_steps</code> to 20:",ut,le,ft,v,cl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_3.png"/>',ct,se,dl="Great, you’ve managed to cut the inference time to just 4 seconds! ⚡️",dt,ie,ht,ne,hl="The other key to improving pipeline performance is consuming less memory, which indirectly implies more speed, since you’re often trying to maximize the number of images generated per second. The easiest way to see how many images you can generate at once is to try out different batch sizes until you get an <code>OutOfMemoryError</code> (OOM).",yt,ae,yl="Create a function that’ll generate a batch of images from a list of prompts and <code>Generators</code>. Make sure to assign each <code>Generator</code> a seed so you can reuse it if it produces a good result.",Mt,re,bt,pe,Ml="Start with <code>batch_size=4</code> and see how much memory you’ve consumed:",wt,oe,gt,me,bl='Unless you have a GPU with more RAM, the code above probably returned an <code>OOM</code> error! Most of the memory is taken up by the cross-attention layers. Instead of running this operation in a batch, you can run it sequentially to save a significant amount of memory. All you have to do is configure the pipeline to use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/depth2img#diffusers.StableDiffusionDepth2ImgPipeline.enable_attention_slicing">enable_attention_slicing()</a> function:',Jt,ue,Tt,fe,wl="Now try increasing the <code>batch_size</code> to 8!",Ut,ce,Zt,G,gl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_5.png"/>',vt,de,Jl="Whereas before you couldn’t even generate a batch of 4 images, now you can generate a batch of 8 images at ~3.5 seconds per image! This is probably the fastest you can go on a T4 GPU without sacrificing quality.",Gt,he,$t,ye,Tl="In the last two sections, you learned how to optimize the speed of your pipeline by using <code>fp16</code>, reducing the number of inference steps by using a more performant scheduler, and enabling attention slicing to reduce memory consumption. Now you’re going to focus on how to improve the quality of generated images.",jt,Me,Wt,be,Ul='The most obvious step is to use better checkpoints. The Stable Diffusion model is a good starting point, and since its official launch, several improved versions have also been released. However, using a newer version doesn’t automatically mean you’ll get better results. You’ll still have to experiment with different checkpoints yourself, and do a little research (such as using <a href="https://minimaxir.com/2022/11/stable-diffusion-negative-prompt/" rel="nofollow">negative prompts</a>) to get the best results.',_t,we,Zl='As the field grows, there are more and more high-quality checkpoints finetuned to produce certain styles. Try exploring the <a href="https://huggingface.co/models?library=diffusers&amp;sort=downloads" rel="nofollow">Hub</a> and <a href="https://huggingface.co/spaces/huggingface-projects/diffusers-gallery" rel="nofollow">Diffusers Gallery</a> to find one you’re interested in!',kt,ge,It,Je,vl='You can also try replacing the current pipeline components with a newer version. Let’s try loading the latest <a href="https://huggingface.co/stabilityai/stable-diffusion-2-1/tree/main/vae" rel="nofollow">autodecoder</a> from Stability AI into the pipeline, and generate some images:',Vt,Te,Ct,$,Gl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_6.png"/>',Ht,Ue,Bt,Ze,$l="The text prompt you use to generate an image is super important, so much so that it is called <em>prompt engineering</em>. Some considerations to keep during prompt engineering are:",xt,ve,jl="<li>How is the image or similar images of the one I want to generate stored on the internet?</li> <li>What additional detail can I give that steers the model towards the style I want?</li>",Xt,Ge,Wl="With this in mind, let’s improve the prompt to include color and higher quality details:",Rt,$e,Nt,je,_l="Generate a batch of images with the new prompt:",Lt,We,St,j,kl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_7.png"/>',zt,_e,Il="Pretty impressive! Let’s tweak the second image - corresponding to the <code>Generator</code> with a seed of <code>1</code> - a bit more by adding some text about the age of the subject:",Qt,ke,Yt,W,Vl='<img src="https://huggingface.co/datasets/diffusers/docs-images/resolve/main/stable_diffusion_101/sd_101_8.png"/>',Dt,Ie,Ft,Ve,Cl='In this tutorial, you learned how to optimize a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> for computational and memory efficiency as well as improving the quality of generated outputs. If you’re interested in making your pipeline even faster, take a look at the following resources:',Pt,Ce,Hl='<li>Learn how <a href="./optimization/torch2.0">PyTorch 2.0</a> and <a href="https://pytorch.org/docs/stable/generated/torch.compile.html" rel="nofollow"><code>torch.compile</code></a> can yield 5 - 300% faster inference speed. On an A100 GPU, inference can be up to 50% faster!</li> <li>If you can’t use PyTorch 2, we recommend you install <a href="./optimization/xformers">xFormers</a>. Its memory-efficient attention mechanism works great with PyTorch 1.13.1 for faster speed and reduced memory consumption.</li> <li>Other optimization techniques, such as model offloading, are covered in <a href="./optimization/fp16">this guide</a>.</li>',Et,Be,At;return k=new _({props:{title:"Effective and efficient diffusion",local:"effective-and-efficient-diffusion",headingTag:"h1"}}),I=new Fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/stable_diffusion.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/stable_diffusion.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/stable_diffusion.ipynb"}]}}),x=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),R=new M({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMG9sZCUyMHdhcnJpb3IlMjBjaGllZiUyMg==",highlighted:'prompt = <span class="hljs-string">&quot;portrait photo of a old warrior chief&quot;</span>',wrap:!1}}),N=new _({props:{title:"Speed",local:"speed",headingTag:"h2"}}),J=new Rl({props:{$$slots:{default:[Pl]},$$scope:{ctx:He}}}),S=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:'pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),Q=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCk=",highlighted:`<span class="hljs-keyword">import</span> torch

generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)`,wrap:!1}}),D=new M({props:{code:"aW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),E=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Z=new Rl({props:{$$slots:{default:[El]},$$scope:{ctx:He}}}),K=new M({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVzJTBBJTVCJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19sbXNfZGlzY3JldGUuTE1TRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX3VuaXBjX211bHRpc3RlcC5VbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9kaXNjcmV0ZS5LRFBNMkRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9kaXNjcmV0ZS5FdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfbXVsdGlzdGVwLkRQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRwbS5ERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kcG1zb2x2ZXJfc2luZ2xlc3RlcC5EUE1Tb2x2ZXJTaW5nbGVzdGVwU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19rX2RwbV8yX2FuY2VzdHJhbF9kaXNjcmV0ZS5LRFBNMkFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19oZXVuX2Rpc2NyZXRlLkhldW5EaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfcG5kbS5QTkRNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19ldWxlcl9hbmNlc3RyYWxfZGlzY3JldGUuRXVsZXJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZGRpbS5ERElNU2NoZWR1bGVyJTJDJTBBJTVE",highlighted:`pipeline.scheduler.compatibles
[
    diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
    diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
    diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
    diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
    diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
    diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
    diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
    diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
    diffusers.schedulers.scheduling_pndm.PNDMScheduler,
    diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
    diffusers.schedulers.scheduling_ddim.DDIMScheduler,
]`,wrap:!1}}),ee=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),le=new M({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ie=new _({props:{title:"Memory",local:"memory",headingTag:"h2"}}),re=new M({props:{code:"ZGVmJTIwZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNEMSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlMjAlM0QlMjAlNUJ0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoaSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShiYXRjaF9zaXplKSU1RCUwQSUyMCUyMCUyMCUyMHByb21wdHMlMjAlM0QlMjBiYXRjaF9zaXplJTIwKiUyMCU1QnByb21wdCU1RCUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjAyMCUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnByb21wdCUyMiUzQSUyMHByb21wdHMlMkMlMjAlMjJnZW5lcmF0b3IlMjIlM0ElMjBnZW5lcmF0b3IlMkMlMjAlMjJudW1faW5mZXJlbmNlX3N0ZXBzJTIyJTNBJTIwbnVtX2luZmVyZW5jZV9zdGVwcyU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_inputs</span>(<span class="hljs-params">batch_size=<span class="hljs-number">1</span></span>):
    generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(i) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size)]
    prompts = batch_size * [prompt]
    num_inference_steps = <span class="hljs-number">20</span>

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;prompt&quot;</span>: prompts, <span class="hljs-string">&quot;generator&quot;</span>: generator, <span class="hljs-string">&quot;num_inference_steps&quot;</span>: num_inference_steps}`,wrap:!1}}),oe=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMG1ha2VfaW1hZ2VfZ3JpZCUyMCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCoqZ2V0X2lucHV0cyhiYXRjaF9zaXplJTNENCkpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZChpbWFnZXMlMkMlMjAyJTJDJTIwMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid 

images = pipeline(**get_inputs(batch_size=<span class="hljs-number">4</span>)).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),ue=new M({props:{code:"cGlwZWxpbmUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCk=",highlighted:"pipeline.enable_attention_slicing()",wrap:!1}}),ce=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),he=new _({props:{title:"Quality",local:"quality",headingTag:"h2"}}),Me=new _({props:{title:"Better checkpoints",local:"better-checkpoints",headingTag:"h3"}}),ge=new _({props:{title:"Better pipeline components",local:"better-pipeline-components",headingTag:"h3"}}),Te=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9lbmNvZGVyS0wlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkLXZhZS1mdC1tc2UlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudmFlJTIwJTNEJTIwdmFlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;stabilityai/sd-vae-ft-mse&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.vae = vae
images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),Ue=new _({props:{title:"Better prompt engineering",local:"better-prompt-engineering",headingTag:"h3"}}),$e=new M({props:{code:"cHJvbXB0JTIwJTJCJTNEJTIwJTIyJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMiUwQXByb21wdCUyMCUyQiUzRCUyMCUyMiUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMg==",highlighted:`prompt += <span class="hljs-string">&quot;, tribal panther make up, blue on red, side profile, looking away, serious eyes&quot;</span>
prompt += <span class="hljs-string">&quot; 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>`,wrap:!1}}),We=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoKipnZXRfaW5wdXRzKGJhdGNoX3NpemUlM0Q4KSkuaW1hZ2VzJTBBbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0QyJTJDJTIwY29scyUzRDQp",highlighted:`images = pipeline(**get_inputs(batch_size=<span class="hljs-number">8</span>)).images
make_image_grid(images, rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">4</span>)`,wrap:!1}}),ke=new M({props:{code:"cHJvbXB0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnBvcnRyYWl0JTIwcGhvdG8lMjBvZiUyMHRoZSUyMG9sZGVzdCUyMHdhcnJpb3IlMjBjaGllZiUyQyUyMHRyaWJhbCUyMHBhbnRoZXIlMjBtYWtlJTIwdXAlMkMlMjBibHVlJTIwb24lMjByZWQlMkMlMjBzaWRlJTIwcHJvZmlsZSUyQyUyMGxvb2tpbmclMjBhd2F5JTJDJTIwc2VyaW91cyUyMGV5ZXMlMjA1MG1tJTIwcG9ydHJhaXQlMjBwaG90b2dyYXBoeSUyQyUyMGhhcmQlMjByaW0lMjBsaWdodGluZyUyMHBob3RvZ3JhcGh5LS1iZXRhJTIwLS1hciUyMDIlM0EzJTIwJTIwLS1iZXRhJTIwLS11cGJldGElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwb3J0cmFpdCUyMHBob3RvJTIwb2YlMjBhJTIwb2xkJTIwd2FycmlvciUyMGNoaWVmJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBvcnRyYWl0JTIwcGhvdG8lMjBvZiUyMGElMjB3YXJyaW9yJTIwY2hpZWYlMkMlMjB0cmliYWwlMjBwYW50aGVyJTIwbWFrZSUyMHVwJTJDJTIwYmx1ZSUyMG9uJTIwcmVkJTJDJTIwc2lkZSUyMHByb2ZpbGUlMkMlMjBsb29raW5nJTIwYXdheSUyQyUyMHNlcmlvdXMlMjBleWVzJTIwNTBtbSUyMHBvcnRyYWl0JTIwcGhvdG9ncmFwaHklMkMlMjBoYXJkJTIwcmltJTIwbGlnaHRpbmclMjBwaG90b2dyYXBoeS0tYmV0YSUyMC0tYXIlMjAyJTNBMyUyMCUyMC0tYmV0YSUyMC0tdXBiZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycG9ydHJhaXQlMjBwaG90byUyMG9mJTIwYSUyMHlvdW5nJTIwd2FycmlvciUyMGNoaWVmJTJDJTIwdHJpYmFsJTIwcGFudGhlciUyMG1ha2UlMjB1cCUyQyUyMGJsdWUlMjBvbiUyMHJlZCUyQyUyMHNpZGUlMjBwcm9maWxlJTJDJTIwbG9va2luZyUyMGF3YXklMkMlMjBzZXJpb3VzJTIwZXllcyUyMDUwbW0lMjBwb3J0cmFpdCUyMHBob3RvZ3JhcGh5JTJDJTIwaGFyZCUyMHJpbSUyMGxpZ2h0aW5nJTIwcGhvdG9ncmFwaHktLWJldGElMjAtLWFyJTIwMiUzQTMlMjAlMjAtLWJldGElMjAtLXVwYmV0YSUyMiUyQyUwQSU1RCUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMCU1QnRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgxKSUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKGxlbihwcm9tcHRzKSklNUQlMEFpbWFnZXMlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0Rwcm9tcHRzJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlMEFtYWtlX2ltYWdlX2dyaWQoaW1hZ2VzJTJDJTIwMiUyQyUyMDIp",highlighted:`prompts = [
    <span class="hljs-string">&quot;portrait photo of the oldest warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a old warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
    <span class="hljs-string">&quot;portrait photo of a young warrior chief, tribal panther make up, blue on red, side profile, looking away, serious eyes 50mm portrait photography, hard rim lighting photography--beta --ar 2:3  --beta --upbeta&quot;</span>,
]

generator = [torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">1</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(prompts))]
images = pipeline(prompt=prompts, generator=generator, num_inference_steps=<span class="hljs-number">25</span>).images
make_image_grid(images, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>)`,wrap:!1}}),Ie=new _({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){h=a("meta"),b=i(),y=a("p"),g=i(),o(k.$$.fragment),xe=i(),o(I.$$.fragment),Xe=i(),V=a("p"),V.innerHTML=qt,Re=i(),C=a("p"),C.innerHTML=Kt,Ne=i(),H=a("p"),H.innerHTML=Ot,Le=i(),B=a("p"),B.innerHTML=el,Se=i(),o(x.$$.fragment),ze=i(),X=a("p"),X.textContent=tl,Qe=i(),o(R.$$.fragment),Ye=i(),o(N.$$.fragment),De=i(),o(J.$$.fragment),Fe=i(),L=a("p"),L.textContent=ll,Pe=i(),o(S.$$.fragment),Ee=i(),z=a("p"),z.innerHTML=sl,Ae=i(),o(Q.$$.fragment),qe=i(),Y=a("p"),Y.textContent=il,Ke=i(),o(D.$$.fragment),Oe=i(),T=a("div"),T.innerHTML=nl,et=i(),F=a("p"),F.innerHTML=al,tt=i(),P=a("p"),P.innerHTML=rl,lt=i(),o(E.$$.fragment),st=i(),U=a("div"),U.innerHTML=pl,it=i(),A=a("p"),A.textContent=ol,nt=i(),o(Z.$$.fragment),at=i(),q=a("p"),q.innerHTML=ml,rt=i(),o(K.$$.fragment),pt=i(),O=a("p"),O.innerHTML=ul,ot=i(),o(ee.$$.fragment),mt=i(),te=a("p"),te.innerHTML=fl,ut=i(),o(le.$$.fragment),ft=i(),v=a("div"),v.innerHTML=cl,ct=i(),se=a("p"),se.textContent=dl,dt=i(),o(ie.$$.fragment),ht=i(),ne=a("p"),ne.innerHTML=hl,yt=i(),ae=a("p"),ae.innerHTML=yl,Mt=i(),o(re.$$.fragment),bt=i(),pe=a("p"),pe.innerHTML=Ml,wt=i(),o(oe.$$.fragment),gt=i(),me=a("p"),me.innerHTML=bl,Jt=i(),o(ue.$$.fragment),Tt=i(),fe=a("p"),fe.innerHTML=wl,Ut=i(),o(ce.$$.fragment),Zt=i(),G=a("div"),G.innerHTML=gl,vt=i(),de=a("p"),de.textContent=Jl,Gt=i(),o(he.$$.fragment),$t=i(),ye=a("p"),ye.innerHTML=Tl,jt=i(),o(Me.$$.fragment),Wt=i(),be=a("p"),be.innerHTML=Ul,_t=i(),we=a("p"),we.innerHTML=Zl,kt=i(),o(ge.$$.fragment),It=i(),Je=a("p"),Je.innerHTML=vl,Vt=i(),o(Te.$$.fragment),Ct=i(),$=a("div"),$.innerHTML=Gl,Ht=i(),o(Ue.$$.fragment),Bt=i(),Ze=a("p"),Ze.innerHTML=$l,xt=i(),ve=a("ul"),ve.innerHTML=jl,Xt=i(),Ge=a("p"),Ge.textContent=Wl,Rt=i(),o($e.$$.fragment),Nt=i(),je=a("p"),je.textContent=_l,Lt=i(),o(We.$$.fragment),St=i(),j=a("div"),j.innerHTML=kl,zt=i(),_e=a("p"),_e.innerHTML=Il,Qt=i(),o(ke.$$.fragment),Yt=i(),W=a("div"),W.innerHTML=Vl,Dt=i(),o(Ie.$$.fragment),Ft=i(),Ve=a("p"),Ve.innerHTML=Cl,Pt=i(),Ce=a("ul"),Ce.innerHTML=Hl,Et=i(),Be=a("p"),this.h()},l(e){const t=Yl("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(l),b=n(e),y=r(e,"P",{}),Xl(y).forEach(l),g=n(e),m(k.$$.fragment,e),xe=n(e),m(I.$$.fragment,e),Xe=n(e),V=r(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1uuxgs9"&&(V.innerHTML=qt),Re=n(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-171p2w6"&&(C.innerHTML=Kt),Ne=n(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1bliwv1"&&(H.innerHTML=Ot),Le=n(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-rvt2dy"&&(B.innerHTML=el),Se=n(e),m(x.$$.fragment,e),ze=n(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-10ouxny"&&(X.textContent=tl),Qe=n(e),m(R.$$.fragment,e),Ye=n(e),m(N.$$.fragment,e),De=n(e),m(J.$$.fragment,e),Fe=n(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-kanimh"&&(L.textContent=ll),Pe=n(e),m(S.$$.fragment,e),Ee=n(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-13gt4wm"&&(z.innerHTML=sl),Ae=n(e),m(Q.$$.fragment,e),qe=n(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-fvhhns"&&(Y.textContent=il),Ke=n(e),m(D.$$.fragment,e),Oe=n(e),T=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-1of5nwm"&&(T.innerHTML=nl),et=n(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-7i96yi"&&(F.innerHTML=al),tt=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-11ahf9b"&&(P.innerHTML=rl),lt=n(e),m(E.$$.fragment,e),st=n(e),U=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1why3l7"&&(U.innerHTML=pl),it=n(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-19ensh2"&&(A.textContent=ol),nt=n(e),m(Z.$$.fragment,e),at=n(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1lsshmr"&&(q.innerHTML=ml),rt=n(e),m(K.$$.fragment,e),pt=n(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-11ttwbu"&&(O.innerHTML=ul),ot=n(e),m(ee.$$.fragment,e),mt=n(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-cj4zg7"&&(te.innerHTML=fl),ut=n(e),m(le.$$.fragment,e),ft=n(e),v=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-19w49w4"&&(v.innerHTML=cl),ct=n(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-t554e8"&&(se.textContent=dl),dt=n(e),m(ie.$$.fragment,e),ht=n(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-xwat8v"&&(ne.innerHTML=hl),yt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-ubghtf"&&(ae.innerHTML=yl),Mt=n(e),m(re.$$.fragment,e),bt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-136nem1"&&(pe.innerHTML=Ml),wt=n(e),m(oe.$$.fragment,e),gt=n(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-pyhiq9"&&(me.innerHTML=bl),Jt=n(e),m(ue.$$.fragment,e),Tt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1kyeye"&&(fe.innerHTML=wl),Ut=n(e),m(ce.$$.fragment,e),Zt=n(e),G=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(G)!=="svelte-vxa9bu"&&(G.innerHTML=gl),vt=n(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-8y2h2l"&&(de.textContent=Jl),Gt=n(e),m(he.$$.fragment,e),$t=n(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-nie66e"&&(ye.innerHTML=Tl),jt=n(e),m(Me.$$.fragment,e),Wt=n(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-n6uci0"&&(be.innerHTML=Ul),_t=n(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1m9vwtz"&&(we.innerHTML=Zl),kt=n(e),m(ge.$$.fragment,e),It=n(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1tn2lqc"&&(Je.innerHTML=vl),Vt=n(e),m(Te.$$.fragment,e),Ct=n(e),$=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p($)!=="svelte-610rhb"&&($.innerHTML=Gl),Ht=n(e),m(Ue.$$.fragment,e),Bt=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1cdb512"&&(Ze.innerHTML=$l),xt=n(e),ve=r(e,"UL",{"data-svelte-h":!0}),p(ve)!=="svelte-o0cjrb"&&(ve.innerHTML=jl),Xt=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-dljusi"&&(Ge.textContent=Wl),Rt=n(e),m($e.$$.fragment,e),Nt=n(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-11z4mci"&&(je.textContent=_l),Lt=n(e),m(We.$$.fragment,e),St=n(e),j=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-n1o5lk"&&(j.innerHTML=kl),zt=n(e),_e=r(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-fmxgeo"&&(_e.innerHTML=Il),Qt=n(e),m(ke.$$.fragment,e),Yt=n(e),W=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-1lkw2bx"&&(W.innerHTML=Vl),Dt=n(e),m(Ie.$$.fragment,e),Ft=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1rftb9p"&&(Ve.innerHTML=Cl),Pt=n(e),Ce=r(e,"UL",{"data-svelte-h":!0}),p(Ce)!=="svelte-1vrqfkr"&&(Ce.innerHTML=Hl),Et=n(e),Be=r(e,"P",{}),Xl(Be).forEach(l),this.h()},h(){w(h,"name","hf:doc:metadata"),w(h,"content",ql),w(T,"class","flex justify-center"),w(U,"class","flex justify-center"),w(v,"class","flex justify-center"),w(G,"class","flex justify-center"),w($,"class","flex justify-center"),w(j,"class","flex justify-center"),w(W,"class","flex justify-center")},m(e,t){Dl(document.head,h),s(e,b,t),s(e,y,t),s(e,g,t),u(k,e,t),s(e,xe,t),u(I,e,t),s(e,Xe,t),s(e,V,t),s(e,Re,t),s(e,C,t),s(e,Ne,t),s(e,H,t),s(e,Le,t),s(e,B,t),s(e,Se,t),u(x,e,t),s(e,ze,t),s(e,X,t),s(e,Qe,t),u(R,e,t),s(e,Ye,t),u(N,e,t),s(e,De,t),u(J,e,t),s(e,Fe,t),s(e,L,t),s(e,Pe,t),u(S,e,t),s(e,Ee,t),s(e,z,t),s(e,Ae,t),u(Q,e,t),s(e,qe,t),s(e,Y,t),s(e,Ke,t),u(D,e,t),s(e,Oe,t),s(e,T,t),s(e,et,t),s(e,F,t),s(e,tt,t),s(e,P,t),s(e,lt,t),u(E,e,t),s(e,st,t),s(e,U,t),s(e,it,t),s(e,A,t),s(e,nt,t),u(Z,e,t),s(e,at,t),s(e,q,t),s(e,rt,t),u(K,e,t),s(e,pt,t),s(e,O,t),s(e,ot,t),u(ee,e,t),s(e,mt,t),s(e,te,t),s(e,ut,t),u(le,e,t),s(e,ft,t),s(e,v,t),s(e,ct,t),s(e,se,t),s(e,dt,t),u(ie,e,t),s(e,ht,t),s(e,ne,t),s(e,yt,t),s(e,ae,t),s(e,Mt,t),u(re,e,t),s(e,bt,t),s(e,pe,t),s(e,wt,t),u(oe,e,t),s(e,gt,t),s(e,me,t),s(e,Jt,t),u(ue,e,t),s(e,Tt,t),s(e,fe,t),s(e,Ut,t),u(ce,e,t),s(e,Zt,t),s(e,G,t),s(e,vt,t),s(e,de,t),s(e,Gt,t),u(he,e,t),s(e,$t,t),s(e,ye,t),s(e,jt,t),u(Me,e,t),s(e,Wt,t),s(e,be,t),s(e,_t,t),s(e,we,t),s(e,kt,t),u(ge,e,t),s(e,It,t),s(e,Je,t),s(e,Vt,t),u(Te,e,t),s(e,Ct,t),s(e,$,t),s(e,Ht,t),u(Ue,e,t),s(e,Bt,t),s(e,Ze,t),s(e,xt,t),s(e,ve,t),s(e,Xt,t),s(e,Ge,t),s(e,Rt,t),u($e,e,t),s(e,Nt,t),s(e,je,t),s(e,Lt,t),u(We,e,t),s(e,St,t),s(e,j,t),s(e,zt,t),s(e,_e,t),s(e,Qt,t),u(ke,e,t),s(e,Yt,t),s(e,W,t),s(e,Dt,t),u(Ie,e,t),s(e,Ft,t),s(e,Ve,t),s(e,Pt,t),s(e,Ce,t),s(e,Et,t),s(e,Be,t),At=!0},p(e,[t]){const Bl={};t&2&&(Bl.$$scope={dirty:t,ctx:e}),J.$set(Bl);const xl={};t&2&&(xl.$$scope={dirty:t,ctx:e}),Z.$set(xl)},i(e){At||(f(k.$$.fragment,e),f(I.$$.fragment,e),f(x.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(J.$$.fragment,e),f(S.$$.fragment,e),f(Q.$$.fragment,e),f(D.$$.fragment,e),f(E.$$.fragment,e),f(Z.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(oe.$$.fragment,e),f(ue.$$.fragment,e),f(ce.$$.fragment,e),f(he.$$.fragment,e),f(Me.$$.fragment,e),f(ge.$$.fragment,e),f(Te.$$.fragment,e),f(Ue.$$.fragment,e),f($e.$$.fragment,e),f(We.$$.fragment,e),f(ke.$$.fragment,e),f(Ie.$$.fragment,e),At=!0)},o(e){c(k.$$.fragment,e),c(I.$$.fragment,e),c(x.$$.fragment,e),c(R.$$.fragment,e),c(N.$$.fragment,e),c(J.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(D.$$.fragment,e),c(E.$$.fragment,e),c(Z.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(oe.$$.fragment,e),c(ue.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(Me.$$.fragment,e),c(ge.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c($e.$$.fragment,e),c(We.$$.fragment,e),c(ke.$$.fragment,e),c(Ie.$$.fragment,e),At=!1},d(e){e&&(l(b),l(y),l(g),l(xe),l(Xe),l(V),l(Re),l(C),l(Ne),l(H),l(Le),l(B),l(Se),l(ze),l(X),l(Qe),l(Ye),l(De),l(Fe),l(L),l(Pe),l(Ee),l(z),l(Ae),l(qe),l(Y),l(Ke),l(Oe),l(T),l(et),l(F),l(tt),l(P),l(lt),l(st),l(U),l(it),l(A),l(nt),l(at),l(q),l(rt),l(pt),l(O),l(ot),l(mt),l(te),l(ut),l(ft),l(v),l(ct),l(se),l(dt),l(ht),l(ne),l(yt),l(ae),l(Mt),l(bt),l(pe),l(wt),l(gt),l(me),l(Jt),l(Tt),l(fe),l(Ut),l(Zt),l(G),l(vt),l(de),l(Gt),l($t),l(ye),l(jt),l(Wt),l(be),l(_t),l(we),l(kt),l(It),l(Je),l(Vt),l(Ct),l($),l(Ht),l(Bt),l(Ze),l(xt),l(ve),l(Xt),l(Ge),l(Rt),l(Nt),l(je),l(Lt),l(St),l(j),l(zt),l(_e),l(Qt),l(Yt),l(W),l(Dt),l(Ft),l(Ve),l(Pt),l(Ce),l(Et),l(Be)),l(h),d(k,e),d(I,e),d(x,e),d(R,e),d(N,e),d(J,e),d(S,e),d(Q,e),d(D,e),d(E,e),d(Z,e),d(K,e),d(ee,e),d(le,e),d(ie,e),d(re,e),d(oe,e),d(ue,e),d(ce,e),d(he,e),d(Me,e),d(ge,e),d(Te,e),d(Ue,e),d($e,e),d(We,e),d(ke,e),d(Ie,e)}}}const ql='{"title":"Effective and efficient diffusion","local":"effective-and-efficient-diffusion","sections":[{"title":"Speed","local":"speed","sections":[],"depth":2},{"title":"Memory","local":"memory","sections":[],"depth":2},{"title":"Quality","local":"quality","sections":[{"title":"Better checkpoints","local":"better-checkpoints","sections":[],"depth":3},{"title":"Better pipeline components","local":"better-pipeline-components","sections":[],"depth":3},{"title":"Better prompt engineering","local":"better-prompt-engineering","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Kl(He){return Sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends zl{constructor(h){super(),Ql(this,h,Kl,Al,Ll,{})}}export{ns as component};
