import{s as Vn,o as Hn,n as V}from"../chunks/scheduler.182ea377.js";import{S as Bn,i as Ln,g as l,s,r as g,A as Fn,h as d,f as p,c as a,j as P,u as b,x as h,k as D,y as n,a as x,v as _,d as y,t as w,w as v}from"../chunks/index.abf12888.js";import{T as tt}from"../chunks/Tip.230e2334.js";import{D as U}from"../chunks/Docstring.93f6f462.js";import{C as st}from"../chunks/CodeBlock.57fe6e13.js";import{E as it}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Nn}from"../chunks/Heading.16916d63.js";function Rn(T){let t,u=`You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training or finetuning a diffusion model. Individual
components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.`;return{c(){t=l("p"),t.innerHTML=u},l(i){t=d(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-seoymy"&&(t.innerHTML=u)},m(i,r){x(i,t,r)},p:V,d(i){i&&p(t)}}}function Sn(T){let t,u=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){t=l("p"),t.textContent=u},l(i){t=d(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-18gkv0g"&&(t.textContent=u)},m(i,r){x(i,t,r)},p:V,d(i){i&&p(t)}}}function Xn(T){let t,u="Examples:",i,r,$;return r=new st({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){t=l("p"),t.textContent=u,i=s(),g(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=a(o),b(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,i,M),_(r,o,M),$=!0},p:V,i(o){$||(y(r.$$.fragment,o),$=!0)},o(o){w(r.$$.fragment,o),$=!1},d(o){o&&(p(t),p(i)),v(r,o)}}}function En(T){let t,u=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){t=l("p"),t.innerHTML=u},l(i){t=d(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-6jnfc0"&&(t.innerHTML=u)},m(i,r){x(i,t,r)},p:V,d(i){i&&p(t)}}}function Yn(T){let t,u=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){t=l("p"),t.innerHTML=u},l(i){t=d(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ackzsn"&&(t.innerHTML=u)},m(i,r){x(i,t,r)},p:V,d(i){i&&p(t)}}}function zn(T){let t,u="Examples:",i,r,$;return r=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=l("p"),t.textContent=u,i=s(),g(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=a(o),b(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,i,M),_(r,o,M),$=!0},p:V,i(o){$||(y(r.$$.fragment,o),$=!0)},o(o){w(r.$$.fragment,o),$=!1},d(o){o&&(p(t),p(i)),v(r,o)}}}function qn(T){let t,u=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){t=l("p"),t.textContent=u},l(i){t=d(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-17p1lpg"&&(t.textContent=u)},m(i,r){x(i,t,r)},p:V,d(i){i&&p(t)}}}function Qn(T){let t,u="Examples:",i,r,$;return r=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){t=l("p"),t.textContent=u,i=s(),g(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=a(o),b(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,i,M),_(r,o,M),$=!0},p:V,i(o){$||(y(r.$$.fragment,o),$=!0)},o(o){w(r.$$.fragment,o),$=!1},d(o){o&&(p(t),p(i)),v(r,o)}}}function An(T){let t,u="If you get the error message below, you need to finetune the weights for your downstream task:",i,r,$;return r=new st({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`,wrap:!1}}),{c(){t=l("p"),t.textContent=u,i=s(),g(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-xueb0m"&&(t.textContent=u),i=a(o),b(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,i,M),_(r,o,M),$=!0},p:V,i(o){$||(y(r.$$.fragment,o),$=!0)},o(o){w(r.$$.fragment,o),$=!1},d(o){o&&(p(t),p(i)),v(r,o)}}}function On(T){let t,u=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){t=l("p"),t.innerHTML=u},l(i){t=d(i,"P",{"data-svelte-h":!0}),h(t)!=="svelte-x73rgs"&&(t.innerHTML=u)},m(i,r){x(i,t,r)},p:V,d(i){i&&p(t)}}}function Kn(T){let t,u="Examples:",i,r,$;return r=new st({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){t=l("p"),t.textContent=u,i=s(),g(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),i=a(o),b(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,i,M),_(r,o,M),$=!0},p:V,i(o){$||(y(r.$$.fragment,o),$=!0)},o(o){w(r.$$.fragment,o),$=!1},d(o){o&&(p(t),p(i)),v(r,o)}}}function eo(T){let t,u,i,r,$,o,M,cn='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is the quickest way to load any pretrained diffusion pipeline from the <a href="https://huggingface.co/models?library=diffusers" rel="nofollow">Hub</a> for inference.',at,L,rt,re,fn=`The pipeline type (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) of any diffusion pipeline loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> is automatically
detected and pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.`,lt,le,mn='Any pipeline object can be saved locally with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.',dt,de,pt,c,pe,gt,Ze,un="Base class for all pipelines.",bt,Je,hn=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,_t,Ge,gn="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",yt,Ie,bn="Class attributes:",wt,Ce,_n=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,vt,F,ce,$t,We,yn="Call self as a function.",xt,Ne,fe,Mt,k,me,Tt,Ve,wn=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,Pt,R,Dt,He,vn="Here are the ways to call <code>to</code>:",jt,Be,$n=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,Ut,J,ue,kt,Le,xn=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,Zt,Fe,Mn=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,Jt,S,Gt,X,he,It,Re,Tn=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Ct,E,ge,Wt,Se,Pn='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Nt,H,be,Vt,Xe,Dn="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",Ht,Y,Bt,G,_e,Lt,Ee,jn=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ft,z,Rt,q,St,Q,ye,Xt,Ye,Un=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Et,A,we,Yt,ze,kn=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,zt,I,ve,qt,qe,Zn=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Qt,O,At,K,Ot,j,$e,Kt,Qe,Jn="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",en,Ae,Gn="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",tn,ee,nn,te,on,ne,sn,oe,xe,an,Oe,In=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,rn,ie,Me,ln,Ke,Cn="Convert a NumPy image or a batch of images to a PIL image.",dn,se,Te,pn,et,Wn=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,ct,nt,ft;return $=new Nn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),L=new tt({props:{$$slots:{default:[Rn]},$$scope:{ctx:T}}}),de=new Nn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),pe=new U({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L478"}}),ce=new U({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),fe=new U({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L832",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),me=new U({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L673",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),R=new tt({props:{$$slots:{default:[Sn]},$$scope:{ctx:T}}}),ue=new U({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1803"}}),S=new it({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[Xn]},$$scope:{ctx:T}}}),he=new U({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1965"}}),ge=new U({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1899"}}),be=new U({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),Y=new tt({props:{$$slots:{default:[En]},$$scope:{ctx:T}}}),_e=new U({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1925"}}),z=new tt({props:{warning:!0,$$slots:{default:[Yn]},$$scope:{ctx:T}}}),q=new it({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[zn]},$$scope:{ctx:T}}}),ye=new U({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1329"}}),we=new U({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1418"}}),ve=new U({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),O=new tt({props:{warning:!0,$$slots:{default:[qn]},$$scope:{ctx:T}}}),K=new it({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Qn]},$$scope:{ctx:T}}}),$e=new U({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L862"}}),ee=new it({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[An]},$$scope:{ctx:T}}}),te=new tt({props:{$$slots:{default:[On]},$$scope:{ctx:T}}}),ne=new it({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Kn]},$$scope:{ctx:T}}}),xe=new U({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1399"}}),Me=new U({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1839"}}),Te=new U({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L560"}}),{c(){t=l("meta"),u=s(),i=l("p"),r=s(),g($.$$.fragment),o=s(),M=l("p"),M.innerHTML=cn,at=s(),g(L.$$.fragment),rt=s(),re=l("p"),re.innerHTML=fn,lt=s(),le=l("p"),le.innerHTML=mn,dt=s(),g(de.$$.fragment),pt=s(),c=l("div"),g(pe.$$.fragment),gt=s(),Ze=l("p"),Ze.textContent=un,bt=s(),Je=l("p"),Je.innerHTML=hn,_t=s(),Ge=l("ul"),Ge.innerHTML=gn,yt=s(),Ie=l("p"),Ie.textContent=bn,wt=s(),Ce=l("ul"),Ce.innerHTML=_n,vt=s(),F=l("div"),g(ce.$$.fragment),$t=s(),We=l("p"),We.textContent=yn,xt=s(),Ne=l("div"),g(fe.$$.fragment),Mt=s(),k=l("div"),g(me.$$.fragment),Tt=s(),Ve=l("p"),Ve.innerHTML=wn,Pt=s(),g(R.$$.fragment),Dt=s(),He=l("p"),He.innerHTML=vn,jt=s(),Be=l("ul"),Be.innerHTML=$n,Ut=s(),J=l("div"),g(ue.$$.fragment),kt=s(),Le=l("p"),Le.innerHTML=xn,Zt=s(),Fe=l("p"),Fe.innerHTML=Mn,Jt=s(),g(S.$$.fragment),Gt=s(),X=l("div"),g(he.$$.fragment),It=s(),Re=l("p"),Re.innerHTML=Tn,Ct=s(),E=l("div"),g(ge.$$.fragment),Wt=s(),Se=l("p"),Se.innerHTML=Pn,Nt=s(),H=l("div"),g(be.$$.fragment),Vt=s(),Xe=l("p"),Xe.textContent=Dn,Ht=s(),g(Y.$$.fragment),Bt=s(),G=l("div"),g(_e.$$.fragment),Lt=s(),Ee=l("p"),Ee.textContent=jn,Ft=s(),g(z.$$.fragment),Rt=s(),g(q.$$.fragment),St=s(),Q=l("div"),g(ye.$$.fragment),Xt=s(),Ye=l("p"),Ye.innerHTML=Un,Et=s(),A=l("div"),g(we.$$.fragment),Yt=s(),ze=l("p"),ze.innerHTML=kn,zt=s(),I=l("div"),g(ve.$$.fragment),qt=s(),qe=l("p"),qe.innerHTML=Zn,Qt=s(),g(O.$$.fragment),At=s(),g(K.$$.fragment),Ot=s(),j=l("div"),g($e.$$.fragment),Kt=s(),Qe=l("p"),Qe.textContent=Jn,en=s(),Ae=l("p"),Ae.innerHTML=Gn,tn=s(),g(ee.$$.fragment),nn=s(),g(te.$$.fragment),on=s(),g(ne.$$.fragment),sn=s(),oe=l("div"),g(xe.$$.fragment),an=s(),Oe=l("p"),Oe.innerHTML=In,rn=s(),ie=l("div"),g(Me.$$.fragment),ln=s(),Ke=l("p"),Ke.textContent=Cn,dn=s(),se=l("div"),g(Te.$$.fragment),pn=s(),et=l("p"),et.innerHTML=Wn,ct=s(),nt=l("p"),this.h()},l(e){const m=Fn("svelte-u9bgzb",document.head);t=d(m,"META",{name:!0,content:!0}),m.forEach(p),u=a(e),i=d(e,"P",{}),P(i).forEach(p),r=a(e),b($.$$.fragment,e),o=a(e),M=d(e,"P",{"data-svelte-h":!0}),h(M)!=="svelte-p8hy61"&&(M.innerHTML=cn),at=a(e),b(L.$$.fragment,e),rt=a(e),re=d(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-1afyk4e"&&(re.innerHTML=fn),lt=a(e),le=d(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1kb1cy9"&&(le.innerHTML=mn),dt=a(e),b(de.$$.fragment,e),pt=a(e),c=d(e,"DIV",{class:!0});var f=P(c);b(pe.$$.fragment,f),gt=a(f),Ze=d(f,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-1neg3rw"&&(Ze.textContent=un),bt=a(f),Je=d(f,"P",{"data-svelte-h":!0}),h(Je)!=="svelte-1kbb8l4"&&(Je.innerHTML=hn),_t=a(f),Ge=d(f,"UL",{"data-svelte-h":!0}),h(Ge)!=="svelte-2a5chx"&&(Ge.innerHTML=gn),yt=a(f),Ie=d(f,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-wz8va1"&&(Ie.textContent=bn),wt=a(f),Ce=d(f,"UL",{"data-svelte-h":!0}),h(Ce)!=="svelte-1ilr6sx"&&(Ce.innerHTML=_n),vt=a(f),F=d(f,"DIV",{class:!0});var Pe=P(F);b(ce.$$.fragment,Pe),$t=a(Pe),We=d(Pe,"P",{"data-svelte-h":!0}),h(We)!=="svelte-1eed40t"&&(We.textContent=yn),Pe.forEach(p),xt=a(f),Ne=d(f,"DIV",{class:!0});var ot=P(Ne);b(fe.$$.fragment,ot),ot.forEach(p),Mt=a(f),k=d(f,"DIV",{class:!0});var Z=P(k);b(me.$$.fragment,Z),Tt=a(Z),Ve=d(Z,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-1vbhnip"&&(Ve.innerHTML=wn),Pt=a(Z),b(R.$$.fragment,Z),Dt=a(Z),He=d(Z,"P",{"data-svelte-h":!0}),h(He)!=="svelte-5ul9n2"&&(He.innerHTML=vn),jt=a(Z),Be=d(Z,"UL",{"data-svelte-h":!0}),h(Be)!=="svelte-1icy6l9"&&(Be.innerHTML=$n),Z.forEach(p),Ut=a(f),J=d(f,"DIV",{class:!0});var W=P(J);b(ue.$$.fragment,W),kt=a(W),Le=d(W,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-had4mb"&&(Le.innerHTML=xn),Zt=a(W),Fe=d(W,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-19k67ce"&&(Fe.innerHTML=Mn),Jt=a(W),b(S.$$.fragment,W),W.forEach(p),Gt=a(f),X=d(f,"DIV",{class:!0});var De=P(X);b(he.$$.fragment,De),It=a(De),Re=d(De,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1lh0nh5"&&(Re.innerHTML=Tn),De.forEach(p),Ct=a(f),E=d(f,"DIV",{class:!0});var je=P(E);b(ge.$$.fragment,je),Wt=a(je),Se=d(je,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-1vfte1e"&&(Se.innerHTML=Pn),je.forEach(p),Nt=a(f),H=d(f,"DIV",{class:!0});var B=P(H);b(be.$$.fragment,B),Vt=a(B),Xe=d(B,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-1mfctah"&&(Xe.textContent=Dn),Ht=a(B),b(Y.$$.fragment,B),B.forEach(p),Bt=a(f),G=d(f,"DIV",{class:!0});var N=P(G);b(_e.$$.fragment,N),Lt=a(N),Ee=d(N,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-10jaql7"&&(Ee.textContent=jn),Ft=a(N),b(z.$$.fragment,N),Rt=a(N),b(q.$$.fragment,N),N.forEach(p),St=a(f),Q=d(f,"DIV",{class:!0});var Ue=P(Q);b(ye.$$.fragment,Ue),Xt=a(Ue),Ye=d(Ue,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-d7vywi"&&(Ye.innerHTML=Un),Ue.forEach(p),Et=a(f),A=d(f,"DIV",{class:!0});var ke=P(A);b(we.$$.fragment,ke),Yt=a(ke),ze=d(ke,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-n1oyuv"&&(ze.innerHTML=kn),ke.forEach(p),zt=a(f),I=d(f,"DIV",{class:!0});var ae=P(I);b(ve.$$.fragment,ae),qt=a(ae),qe=d(ae,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-e03q3e"&&(qe.innerHTML=Zn),Qt=a(ae),b(O.$$.fragment,ae),At=a(ae),b(K.$$.fragment,ae),ae.forEach(p),Ot=a(f),j=d(f,"DIV",{class:!0});var C=P(j);b($e.$$.fragment,C),Kt=a(C),Qe=d(C,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-ccbjek"&&(Qe.textContent=Jn),en=a(C),Ae=d(C,"P",{"data-svelte-h":!0}),h(Ae)!=="svelte-1p5vgmd"&&(Ae.innerHTML=Gn),tn=a(C),b(ee.$$.fragment,C),nn=a(C),b(te.$$.fragment,C),on=a(C),b(ne.$$.fragment,C),C.forEach(p),sn=a(f),oe=d(f,"DIV",{class:!0});var mt=P(oe);b(xe.$$.fragment,mt),an=a(mt),Oe=d(mt,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-zkab0b"&&(Oe.innerHTML=In),mt.forEach(p),rn=a(f),ie=d(f,"DIV",{class:!0});var ut=P(ie);b(Me.$$.fragment,ut),ln=a(ut),Ke=d(ut,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-1gut907"&&(Ke.textContent=Cn),ut.forEach(p),dn=a(f),se=d(f,"DIV",{class:!0});var ht=P(se);b(Te.$$.fragment,ht),pn=a(ht),et=d(ht,"P",{"data-svelte-h":!0}),h(et)!=="svelte-1jcmq84"&&(et.innerHTML=Wn),ht.forEach(p),f.forEach(p),ct=a(e),nt=d(e,"P",{}),P(nt).forEach(p),this.h()},h(){D(t,"name","hf:doc:metadata"),D(t,"content",to),D(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){n(document.head,t),x(e,u,m),x(e,i,m),x(e,r,m),_($,e,m),x(e,o,m),x(e,M,m),x(e,at,m),_(L,e,m),x(e,rt,m),x(e,re,m),x(e,lt,m),x(e,le,m),x(e,dt,m),_(de,e,m),x(e,pt,m),x(e,c,m),_(pe,c,null),n(c,gt),n(c,Ze),n(c,bt),n(c,Je),n(c,_t),n(c,Ge),n(c,yt),n(c,Ie),n(c,wt),n(c,Ce),n(c,vt),n(c,F),_(ce,F,null),n(F,$t),n(F,We),n(c,xt),n(c,Ne),_(fe,Ne,null),n(c,Mt),n(c,k),_(me,k,null),n(k,Tt),n(k,Ve),n(k,Pt),_(R,k,null),n(k,Dt),n(k,He),n(k,jt),n(k,Be),n(c,Ut),n(c,J),_(ue,J,null),n(J,kt),n(J,Le),n(J,Zt),n(J,Fe),n(J,Jt),_(S,J,null),n(c,Gt),n(c,X),_(he,X,null),n(X,It),n(X,Re),n(c,Ct),n(c,E),_(ge,E,null),n(E,Wt),n(E,Se),n(c,Nt),n(c,H),_(be,H,null),n(H,Vt),n(H,Xe),n(H,Ht),_(Y,H,null),n(c,Bt),n(c,G),_(_e,G,null),n(G,Lt),n(G,Ee),n(G,Ft),_(z,G,null),n(G,Rt),_(q,G,null),n(c,St),n(c,Q),_(ye,Q,null),n(Q,Xt),n(Q,Ye),n(c,Et),n(c,A),_(we,A,null),n(A,Yt),n(A,ze),n(c,zt),n(c,I),_(ve,I,null),n(I,qt),n(I,qe),n(I,Qt),_(O,I,null),n(I,At),_(K,I,null),n(c,Ot),n(c,j),_($e,j,null),n(j,Kt),n(j,Qe),n(j,en),n(j,Ae),n(j,tn),_(ee,j,null),n(j,nn),_(te,j,null),n(j,on),_(ne,j,null),n(c,sn),n(c,oe),_(xe,oe,null),n(oe,an),n(oe,Oe),n(c,rn),n(c,ie),_(Me,ie,null),n(ie,ln),n(ie,Ke),n(c,dn),n(c,se),_(Te,se,null),n(se,pn),n(se,et),x(e,ct,m),x(e,nt,m),ft=!0},p(e,[m]){const f={};m&2&&(f.$$scope={dirty:m,ctx:e}),L.$set(f);const Pe={};m&2&&(Pe.$$scope={dirty:m,ctx:e}),R.$set(Pe);const ot={};m&2&&(ot.$$scope={dirty:m,ctx:e}),S.$set(ot);const Z={};m&2&&(Z.$$scope={dirty:m,ctx:e}),Y.$set(Z);const W={};m&2&&(W.$$scope={dirty:m,ctx:e}),z.$set(W);const De={};m&2&&(De.$$scope={dirty:m,ctx:e}),q.$set(De);const je={};m&2&&(je.$$scope={dirty:m,ctx:e}),O.$set(je);const B={};m&2&&(B.$$scope={dirty:m,ctx:e}),K.$set(B);const N={};m&2&&(N.$$scope={dirty:m,ctx:e}),ee.$set(N);const Ue={};m&2&&(Ue.$$scope={dirty:m,ctx:e}),te.$set(Ue);const ke={};m&2&&(ke.$$scope={dirty:m,ctx:e}),ne.$set(ke)},i(e){ft||(y($.$$.fragment,e),y(L.$$.fragment,e),y(de.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(fe.$$.fragment,e),y(me.$$.fragment,e),y(R.$$.fragment,e),y(ue.$$.fragment,e),y(S.$$.fragment,e),y(he.$$.fragment,e),y(ge.$$.fragment,e),y(be.$$.fragment,e),y(Y.$$.fragment,e),y(_e.$$.fragment,e),y(z.$$.fragment,e),y(q.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(ve.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y($e.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(xe.$$.fragment,e),y(Me.$$.fragment,e),y(Te.$$.fragment,e),ft=!0)},o(e){w($.$$.fragment,e),w(L.$$.fragment,e),w(de.$$.fragment,e),w(pe.$$.fragment,e),w(ce.$$.fragment,e),w(fe.$$.fragment,e),w(me.$$.fragment,e),w(R.$$.fragment,e),w(ue.$$.fragment,e),w(S.$$.fragment,e),w(he.$$.fragment,e),w(ge.$$.fragment,e),w(be.$$.fragment,e),w(Y.$$.fragment,e),w(_e.$$.fragment,e),w(z.$$.fragment,e),w(q.$$.fragment,e),w(ye.$$.fragment,e),w(we.$$.fragment,e),w(ve.$$.fragment,e),w(O.$$.fragment,e),w(K.$$.fragment,e),w($e.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),w(xe.$$.fragment,e),w(Me.$$.fragment,e),w(Te.$$.fragment,e),ft=!1},d(e){e&&(p(u),p(i),p(r),p(o),p(M),p(at),p(rt),p(re),p(lt),p(le),p(dt),p(pt),p(c),p(ct),p(nt)),p(t),v($,e),v(L,e),v(de,e),v(pe),v(ce),v(fe),v(me),v(R),v(ue),v(S),v(he),v(ge),v(be),v(Y),v(_e),v(z),v(q),v(ye),v(we),v(ve),v(O),v(K),v($e),v(ee),v(te),v(ne),v(xe),v(Me),v(Te)}}}const to='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2}],"depth":1}';function no(T){return Hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class co extends Bn{constructor(t){super(),Ln(this,t,no,eo,Vn,{})}}export{co as component};
