import{s as An,o as On,n as I}from"../chunks/scheduler.182ea377.js";import{S as Kn,i as es,g as l,s as i,r as u,A as ts,h as d,f as p,c as a,j as U,u as h,x as f,k as j,y as n,a as x,v as g,d as b,t as _,w as y}from"../chunks/index.abf12888.js";import{T as et}from"../chunks/Tip.230e2334.js";import{D as J}from"../chunks/Docstring.93f6f462.js";import{C as ve}from"../chunks/CodeBlock.57fe6e13.js";import{E as ye}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Kt}from"../chunks/Heading.16916d63.js";function os(T){let t,m='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../traininig/overview">Training</a> guides instead!';return{c(){t=l("p"),t.innerHTML=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-1bnx67"&&(t.innerHTML=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function ns(T){let t,m=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){t=l("p"),t.textContent=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-18gkv0g"&&(t.textContent=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function ss(T){let t,m="Examples:",s,r,v;return r=new ve({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function is(T){let t,m=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){t=l("p"),t.innerHTML=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-6jnfc0"&&(t.innerHTML=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function as(T){let t,m=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){t=l("p"),t.innerHTML=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-ackzsn"&&(t.innerHTML=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function rs(T){let t,m="Examples:",s,r,v;return r=new ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function ls(T){let t,m=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){t=l("p"),t.textContent=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-17p1lpg"&&(t.textContent=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function ds(T){let t,m="Examples:",s,r,v;return r=new ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function ps(T){let t,m="If you get the error message below, you need to finetune the weights for your downstream task:",s,r,v;return r=new ve({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-xueb0m"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function cs(T){let t,m=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){t=l("p"),t.innerHTML=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-x73rgs"&&(t.innerHTML=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function fs(T){let t,m="Examples:",s,r,v;return r=new ve({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function ms(T){let t,m="If you get the error message below, you need to finetune the weights for your downstream task:",s,r,v;return r=new ve({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQQ==",highlighted:'Some weights <span class="hljs-keyword">of</span> FlaxUNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:',wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-xueb0m"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function us(T){let t,m=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){t=l("p"),t.innerHTML=m},l(s){t=d(s,"P",{"data-svelte-h":!0}),f(t)!=="svelte-6jnfc0"&&(t.innerHTML=m)},m(s,r){x(s,t,r)},p:I,d(s){s&&p(t)}}}function hs(T){let t,m="Examples:",s,r,v;return r=new ve({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZHBtcHAlMkMlMjBkcG1wcF9zdGF0ZSUyMCUzRCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTJDJTBBKSUwQSUwQWRwbV9waXBlJTJDJTIwZHBtX3BhcmFtcyUyMCUzRCUyMEZsYXhTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, revision=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function gs(T){let t,m="Examples:",s,r,v;return r=new ve({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){t=l("p"),t.textContent=m,s=i(),u(r.$$.fragment)},l(o){t=d(o,"P",{"data-svelte-h":!0}),f(t)!=="svelte-kvfsh7"&&(t.textContent=m),s=a(o),h(r.$$.fragment,o)},m(o,M){x(o,t,M),x(o,s,M),g(r,o,M),v=!0},p:I,i(o){v||(b(r.$$.fragment,o),v=!0)},o(o){_(r.$$.fragment,o),v=!1},d(o){o&&(p(t),p(s)),y(r,o)}}}function bs(T){let t,m,s,r,v,o,M,hn="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different scheduler or even model components.",Vt,we,gn='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components.',Nt,Y,Xt,$e,Rt,w,xe,eo,tt,bn="Base class for all pipelines.",to,ot,_n=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,oo,nt,yn="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",no,st,vn="Class attributes:",so,it,wn=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,io,Q,Me,ao,at,$n="Call self as a function.",ro,rt,Te,lo,G,Ue,po,lt,xn=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,co,q,fo,dt,Mn="Here are the ways to call <code>to</code>:",mo,pt,Tn=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,uo,B,je,ho,ct,Un=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,go,ft,jn=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,bo,A,_o,O,Ze,yo,mt,Zn=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,vo,K,Je,wo,ut,Jn='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',$o,E,Pe,xo,ht,Pn="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",Mo,ee,To,H,ke,Uo,gt,kn=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,jo,te,Zo,oe,Jo,ne,Ce,Po,bt,Cn=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,ko,se,De,Co,_t,Dn=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Do,F,Ie,Io,yt,In=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Go,ie,Wo,ae,Bo,k,Ge,Ho,vt,Gn="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",Fo,wt,Wn="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Vo,re,No,le,Xo,de,Ro,pe,We,Lo,$t,Bn=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,Eo,ce,Be,So,xt,Hn="Convert a NumPy image or a batch of images to a PIL image.",zo,fe,He,Yo,Mt,Fn=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,Lt,Fe,Et,Z,Ve,Qo,Tt,Vn="Base class for Flax-based pipelines.",qo,Ut,Nn=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Ao,jt,Xn="<li>enable/disable the progress bar for the denoising iteration</li>",Oo,Zt,Rn="Class attributes:",Ko,Jt,Ln=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,en,C,Ne,tn,Pt,En="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",on,kt,Sn="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",nn,me,sn,ue,an,he,rn,ge,Xe,ln,Ct,zn="Convert a NumPy image or a batch of images to a PIL image.",dn,be,Re,pn,Dt,Yn=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,St,Le,zt,N,Ee,cn,It,Qn="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",fn,S,Se,mn,Gt,qn="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",un,_e,Yt,Ht,Qt;return v=new Kt({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),Y=new et({props:{warning:!0,$$slots:{default:[os]},$$scope:{ctx:T}}}),$e=new Kt({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),xe=new J({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L478"}}),Me=new J({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Te=new J({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L832",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Ue=new J({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L673",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),q=new et({props:{$$slots:{default:[ns]},$$scope:{ctx:T}}}),je=new J({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1803"}}),A=new ye({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[ss]},$$scope:{ctx:T}}}),Ze=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1965"}}),Je=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1899"}}),Pe=new J({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),ee=new et({props:{$$slots:{default:[is]},$$scope:{ctx:T}}}),ke=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[str, int, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1925"}}),te=new et({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:T}}}),oe=new ye({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[rs]},$$scope:{ctx:T}}}),Ce=new J({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1329"}}),De=new J({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1418"}}),Ie=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1864"}}),ie=new et({props:{warning:!0,$$slots:{default:[ls]},$$scope:{ctx:T}}}),ae=new ye({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ds]},$$scope:{ctx:T}}}),Ge=new J({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L862"}}),re=new ye({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[ps]},$$scope:{ctx:T}}}),le=new et({props:{$$slots:{default:[cs]},$$scope:{ctx:T}}}),de=new ye({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[fs]},$$scope:{ctx:T}}}),We=new J({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1399"}}),Be=new J({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1839"}}),He=new J({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L560"}}),Fe=new Kt({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),Ve=new J({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),Ne=new J({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype. If <code>&quot;auto&quot;</code>, the dtype is
automatically derived from the model&#x2019;s weights.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"use_auth_token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L228"}}),me=new ye({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[ms]},$$scope:{ctx:T}}}),ue=new et({props:{$$slots:{default:[us]},$$scope:{ctx:T}}}),he=new ye({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[hs]},$$scope:{ctx:T}}}),Xe=new J({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L585"}}),Re=new J({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L150"}}),Le=new Kt({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ee=new J({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L373"}}),Se=new J({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L402"}}),_e=new ye({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[gs]},$$scope:{ctx:T}}}),{c(){t=l("meta"),m=i(),s=l("p"),r=i(),u(v.$$.fragment),o=i(),M=l("p"),M.textContent=hn,Vt=i(),we=l("p"),we.innerHTML=gn,Nt=i(),u(Y.$$.fragment),Xt=i(),u($e.$$.fragment),Rt=i(),w=l("div"),u(xe.$$.fragment),eo=i(),tt=l("p"),tt.textContent=bn,to=i(),ot=l("p"),ot.innerHTML=_n,oo=i(),nt=l("ul"),nt.innerHTML=yn,no=i(),st=l("p"),st.textContent=vn,so=i(),it=l("ul"),it.innerHTML=wn,io=i(),Q=l("div"),u(Me.$$.fragment),ao=i(),at=l("p"),at.textContent=$n,ro=i(),rt=l("div"),u(Te.$$.fragment),lo=i(),G=l("div"),u(Ue.$$.fragment),po=i(),lt=l("p"),lt.innerHTML=xn,co=i(),u(q.$$.fragment),fo=i(),dt=l("p"),dt.innerHTML=Mn,mo=i(),pt=l("ul"),pt.innerHTML=Tn,uo=i(),B=l("div"),u(je.$$.fragment),ho=i(),ct=l("p"),ct.innerHTML=Un,go=i(),ft=l("p"),ft.innerHTML=jn,bo=i(),u(A.$$.fragment),_o=i(),O=l("div"),u(Ze.$$.fragment),yo=i(),mt=l("p"),mt.innerHTML=Zn,vo=i(),K=l("div"),u(Je.$$.fragment),wo=i(),ut=l("p"),ut.innerHTML=Jn,$o=i(),E=l("div"),u(Pe.$$.fragment),xo=i(),ht=l("p"),ht.textContent=Pn,Mo=i(),u(ee.$$.fragment),To=i(),H=l("div"),u(ke.$$.fragment),Uo=i(),gt=l("p"),gt.textContent=kn,jo=i(),u(te.$$.fragment),Zo=i(),u(oe.$$.fragment),Jo=i(),ne=l("div"),u(Ce.$$.fragment),Po=i(),bt=l("p"),bt.innerHTML=Cn,ko=i(),se=l("div"),u(De.$$.fragment),Co=i(),_t=l("p"),_t.innerHTML=Dn,Do=i(),F=l("div"),u(Ie.$$.fragment),Io=i(),yt=l("p"),yt.innerHTML=In,Go=i(),u(ie.$$.fragment),Wo=i(),u(ae.$$.fragment),Bo=i(),k=l("div"),u(Ge.$$.fragment),Ho=i(),vt=l("p"),vt.textContent=Gn,Fo=i(),wt=l("p"),wt.innerHTML=Wn,Vo=i(),u(re.$$.fragment),No=i(),u(le.$$.fragment),Xo=i(),u(de.$$.fragment),Ro=i(),pe=l("div"),u(We.$$.fragment),Lo=i(),$t=l("p"),$t.innerHTML=Bn,Eo=i(),ce=l("div"),u(Be.$$.fragment),So=i(),xt=l("p"),xt.textContent=Hn,zo=i(),fe=l("div"),u(He.$$.fragment),Yo=i(),Mt=l("p"),Mt.innerHTML=Fn,Lt=i(),u(Fe.$$.fragment),Et=i(),Z=l("div"),u(Ve.$$.fragment),Qo=i(),Tt=l("p"),Tt.textContent=Vn,qo=i(),Ut=l("p"),Ut.innerHTML=Nn,Ao=i(),jt=l("ul"),jt.innerHTML=Xn,Oo=i(),Zt=l("p"),Zt.textContent=Rn,Ko=i(),Jt=l("ul"),Jt.innerHTML=Ln,en=i(),C=l("div"),u(Ne.$$.fragment),tn=i(),Pt=l("p"),Pt.textContent=En,on=i(),kt=l("p"),kt.textContent=Sn,nn=i(),u(me.$$.fragment),sn=i(),u(ue.$$.fragment),an=i(),u(he.$$.fragment),rn=i(),ge=l("div"),u(Xe.$$.fragment),ln=i(),Ct=l("p"),Ct.textContent=zn,dn=i(),be=l("div"),u(Re.$$.fragment),pn=i(),Dt=l("p"),Dt.innerHTML=Yn,St=i(),u(Le.$$.fragment),zt=i(),N=l("div"),u(Ee.$$.fragment),cn=i(),It=l("p"),It.textContent=Qn,fn=i(),S=l("div"),u(Se.$$.fragment),mn=i(),Gt=l("p"),Gt.textContent=qn,un=i(),u(_e.$$.fragment),Yt=i(),Ht=l("p"),this.h()},l(e){const c=ts("svelte-u9bgzb",document.head);t=d(c,"META",{name:!0,content:!0}),c.forEach(p),m=a(e),s=d(e,"P",{}),U(s).forEach(p),r=a(e),h(v.$$.fragment,e),o=a(e),M=d(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-si2w5z"&&(M.textContent=hn),Vt=a(e),we=d(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-xru948"&&(we.innerHTML=gn),Nt=a(e),h(Y.$$.fragment,e),Xt=a(e),h($e.$$.fragment,e),Rt=a(e),w=d(e,"DIV",{class:!0});var $=U(w);h(xe.$$.fragment,$),eo=a($),tt=d($,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-1neg3rw"&&(tt.textContent=bn),to=a($),ot=d($,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1kbb8l4"&&(ot.innerHTML=_n),oo=a($),nt=d($,"UL",{"data-svelte-h":!0}),f(nt)!=="svelte-2a5chx"&&(nt.innerHTML=yn),no=a($),st=d($,"P",{"data-svelte-h":!0}),f(st)!=="svelte-wz8va1"&&(st.textContent=vn),so=a($),it=d($,"UL",{"data-svelte-h":!0}),f(it)!=="svelte-1ilr6sx"&&(it.innerHTML=wn),io=a($),Q=d($,"DIV",{class:!0});var ze=U(Q);h(Me.$$.fragment,ze),ao=a(ze),at=d(ze,"P",{"data-svelte-h":!0}),f(at)!=="svelte-1eed40t"&&(at.textContent=$n),ze.forEach(p),ro=a($),rt=d($,"DIV",{class:!0});var Ft=U(rt);h(Te.$$.fragment,Ft),Ft.forEach(p),lo=a($),G=d($,"DIV",{class:!0});var W=U(G);h(Ue.$$.fragment,W),po=a(W),lt=d(W,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-1vbhnip"&&(lt.innerHTML=xn),co=a(W),h(q.$$.fragment,W),fo=a(W),dt=d(W,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-5ul9n2"&&(dt.innerHTML=Mn),mo=a(W),pt=d(W,"UL",{"data-svelte-h":!0}),f(pt)!=="svelte-1icy6l9"&&(pt.innerHTML=Tn),W.forEach(p),uo=a($),B=d($,"DIV",{class:!0});var X=U(B);h(je.$$.fragment,X),ho=a(X),ct=d(X,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-had4mb"&&(ct.innerHTML=Un),go=a(X),ft=d(X,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-19k67ce"&&(ft.innerHTML=jn),bo=a(X),h(A.$$.fragment,X),X.forEach(p),_o=a($),O=d($,"DIV",{class:!0});var Ye=U(O);h(Ze.$$.fragment,Ye),yo=a(Ye),mt=d(Ye,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-1lh0nh5"&&(mt.innerHTML=Zn),Ye.forEach(p),vo=a($),K=d($,"DIV",{class:!0});var Qe=U(K);h(Je.$$.fragment,Qe),wo=a(Qe),ut=d(Qe,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-1vfte1e"&&(ut.innerHTML=Jn),Qe.forEach(p),$o=a($),E=d($,"DIV",{class:!0});var z=U(E);h(Pe.$$.fragment,z),xo=a(z),ht=d(z,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-1mfctah"&&(ht.textContent=Pn),Mo=a(z),h(ee.$$.fragment,z),z.forEach(p),To=a($),H=d($,"DIV",{class:!0});var R=U(H);h(ke.$$.fragment,R),Uo=a(R),gt=d(R,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-10jaql7"&&(gt.textContent=kn),jo=a(R),h(te.$$.fragment,R),Zo=a(R),h(oe.$$.fragment,R),R.forEach(p),Jo=a($),ne=d($,"DIV",{class:!0});var qe=U(ne);h(Ce.$$.fragment,qe),Po=a(qe),bt=d(qe,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-d7vywi"&&(bt.innerHTML=Cn),qe.forEach(p),ko=a($),se=d($,"DIV",{class:!0});var Ae=U(se);h(De.$$.fragment,Ae),Co=a(Ae),_t=d(Ae,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-n1oyuv"&&(_t.innerHTML=Dn),Ae.forEach(p),Do=a($),F=d($,"DIV",{class:!0});var L=U(F);h(Ie.$$.fragment,L),Io=a(L),yt=d(L,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-e03q3e"&&(yt.innerHTML=In),Go=a(L),h(ie.$$.fragment,L),Wo=a(L),h(ae.$$.fragment,L),L.forEach(p),Bo=a($),k=d($,"DIV",{class:!0});var D=U(k);h(Ge.$$.fragment,D),Ho=a(D),vt=d(D,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-ccbjek"&&(vt.textContent=Gn),Fo=a(D),wt=d(D,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-1p5vgmd"&&(wt.innerHTML=Wn),Vo=a(D),h(re.$$.fragment,D),No=a(D),h(le.$$.fragment,D),Xo=a(D),h(de.$$.fragment,D),D.forEach(p),Ro=a($),pe=d($,"DIV",{class:!0});var Oe=U(pe);h(We.$$.fragment,Oe),Lo=a(Oe),$t=d(Oe,"P",{"data-svelte-h":!0}),f($t)!=="svelte-zkab0b"&&($t.innerHTML=Bn),Oe.forEach(p),Eo=a($),ce=d($,"DIV",{class:!0});var Ke=U(ce);h(Be.$$.fragment,Ke),So=a(Ke),xt=d(Ke,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-1gut907"&&(xt.textContent=Hn),Ke.forEach(p),zo=a($),fe=d($,"DIV",{class:!0});var qt=U(fe);h(He.$$.fragment,qt),Yo=a(qt),Mt=d(qt,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-1jcmq84"&&(Mt.innerHTML=Fn),qt.forEach(p),$.forEach(p),Lt=a(e),h(Fe.$$.fragment,e),Et=a(e),Z=d(e,"DIV",{class:!0});var P=U(Z);h(Ve.$$.fragment,P),Qo=a(P),Tt=d(P,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-1o1wti6"&&(Tt.textContent=Vn),qo=a(P),Ut=d(P,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-1h33ucg"&&(Ut.innerHTML=Nn),Ao=a(P),jt=d(P,"UL",{"data-svelte-h":!0}),f(jt)!=="svelte-1kk3msp"&&(jt.innerHTML=Xn),Oo=a(P),Zt=d(P,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-wz8va1"&&(Zt.textContent=Rn),Ko=a(P),Jt=d(P,"UL",{"data-svelte-h":!0}),f(Jt)!=="svelte-56flce"&&(Jt.innerHTML=Ln),en=a(P),C=d(P,"DIV",{class:!0});var V=U(C);h(Ne.$$.fragment,V),tn=a(V),Pt=d(V,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-7z61o"&&(Pt.textContent=En),on=a(V),kt=d(V,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-wyh2cr"&&(kt.textContent=Sn),nn=a(V),h(me.$$.fragment,V),sn=a(V),h(ue.$$.fragment,V),an=a(V),h(he.$$.fragment,V),V.forEach(p),rn=a(P),ge=d(P,"DIV",{class:!0});var At=U(ge);h(Xe.$$.fragment,At),ln=a(At),Ct=d(At,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-1gut907"&&(Ct.textContent=zn),At.forEach(p),dn=a(P),be=d(P,"DIV",{class:!0});var Ot=U(be);h(Re.$$.fragment,Ot),pn=a(Ot),Dt=d(Ot,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-spoull"&&(Dt.innerHTML=Yn),Ot.forEach(p),P.forEach(p),St=a(e),h(Le.$$.fragment,e),zt=a(e),N=d(e,"DIV",{class:!0});var Wt=U(N);h(Ee.$$.fragment,Wt),cn=a(Wt),It=d(Wt,"P",{"data-svelte-h":!0}),f(It)!=="svelte-7y8zei"&&(It.textContent=Qn),fn=a(Wt),S=d(Wt,"DIV",{class:!0});var Bt=U(S);h(Se.$$.fragment,Bt),mn=a(Bt),Gt=d(Bt,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-5nfhmh"&&(Gt.textContent=qn),un=a(Bt),h(_e.$$.fragment,Bt),Bt.forEach(p),Wt.forEach(p),Yt=a(e),Ht=d(e,"P",{}),U(Ht).forEach(p),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",_s),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,t),x(e,m,c),x(e,s,c),x(e,r,c),g(v,e,c),x(e,o,c),x(e,M,c),x(e,Vt,c),x(e,we,c),x(e,Nt,c),g(Y,e,c),x(e,Xt,c),g($e,e,c),x(e,Rt,c),x(e,w,c),g(xe,w,null),n(w,eo),n(w,tt),n(w,to),n(w,ot),n(w,oo),n(w,nt),n(w,no),n(w,st),n(w,so),n(w,it),n(w,io),n(w,Q),g(Me,Q,null),n(Q,ao),n(Q,at),n(w,ro),n(w,rt),g(Te,rt,null),n(w,lo),n(w,G),g(Ue,G,null),n(G,po),n(G,lt),n(G,co),g(q,G,null),n(G,fo),n(G,dt),n(G,mo),n(G,pt),n(w,uo),n(w,B),g(je,B,null),n(B,ho),n(B,ct),n(B,go),n(B,ft),n(B,bo),g(A,B,null),n(w,_o),n(w,O),g(Ze,O,null),n(O,yo),n(O,mt),n(w,vo),n(w,K),g(Je,K,null),n(K,wo),n(K,ut),n(w,$o),n(w,E),g(Pe,E,null),n(E,xo),n(E,ht),n(E,Mo),g(ee,E,null),n(w,To),n(w,H),g(ke,H,null),n(H,Uo),n(H,gt),n(H,jo),g(te,H,null),n(H,Zo),g(oe,H,null),n(w,Jo),n(w,ne),g(Ce,ne,null),n(ne,Po),n(ne,bt),n(w,ko),n(w,se),g(De,se,null),n(se,Co),n(se,_t),n(w,Do),n(w,F),g(Ie,F,null),n(F,Io),n(F,yt),n(F,Go),g(ie,F,null),n(F,Wo),g(ae,F,null),n(w,Bo),n(w,k),g(Ge,k,null),n(k,Ho),n(k,vt),n(k,Fo),n(k,wt),n(k,Vo),g(re,k,null),n(k,No),g(le,k,null),n(k,Xo),g(de,k,null),n(w,Ro),n(w,pe),g(We,pe,null),n(pe,Lo),n(pe,$t),n(w,Eo),n(w,ce),g(Be,ce,null),n(ce,So),n(ce,xt),n(w,zo),n(w,fe),g(He,fe,null),n(fe,Yo),n(fe,Mt),x(e,Lt,c),g(Fe,e,c),x(e,Et,c),x(e,Z,c),g(Ve,Z,null),n(Z,Qo),n(Z,Tt),n(Z,qo),n(Z,Ut),n(Z,Ao),n(Z,jt),n(Z,Oo),n(Z,Zt),n(Z,Ko),n(Z,Jt),n(Z,en),n(Z,C),g(Ne,C,null),n(C,tn),n(C,Pt),n(C,on),n(C,kt),n(C,nn),g(me,C,null),n(C,sn),g(ue,C,null),n(C,an),g(he,C,null),n(Z,rn),n(Z,ge),g(Xe,ge,null),n(ge,ln),n(ge,Ct),n(Z,dn),n(Z,be),g(Re,be,null),n(be,pn),n(be,Dt),x(e,St,c),g(Le,e,c),x(e,zt,c),x(e,N,c),g(Ee,N,null),n(N,cn),n(N,It),n(N,fn),n(N,S),g(Se,S,null),n(S,mn),n(S,Gt),n(S,un),g(_e,S,null),x(e,Yt,c),x(e,Ht,c),Qt=!0},p(e,[c]){const $={};c&2&&($.$$scope={dirty:c,ctx:e}),Y.$set($);const ze={};c&2&&(ze.$$scope={dirty:c,ctx:e}),q.$set(ze);const Ft={};c&2&&(Ft.$$scope={dirty:c,ctx:e}),A.$set(Ft);const W={};c&2&&(W.$$scope={dirty:c,ctx:e}),ee.$set(W);const X={};c&2&&(X.$$scope={dirty:c,ctx:e}),te.$set(X);const Ye={};c&2&&(Ye.$$scope={dirty:c,ctx:e}),oe.$set(Ye);const Qe={};c&2&&(Qe.$$scope={dirty:c,ctx:e}),ie.$set(Qe);const z={};c&2&&(z.$$scope={dirty:c,ctx:e}),ae.$set(z);const R={};c&2&&(R.$$scope={dirty:c,ctx:e}),re.$set(R);const qe={};c&2&&(qe.$$scope={dirty:c,ctx:e}),le.$set(qe);const Ae={};c&2&&(Ae.$$scope={dirty:c,ctx:e}),de.$set(Ae);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),me.$set(L);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),ue.$set(D);const Oe={};c&2&&(Oe.$$scope={dirty:c,ctx:e}),he.$set(Oe);const Ke={};c&2&&(Ke.$$scope={dirty:c,ctx:e}),_e.$set(Ke)},i(e){Qt||(b(v.$$.fragment,e),b(Y.$$.fragment,e),b($e.$$.fragment,e),b(xe.$$.fragment,e),b(Me.$$.fragment,e),b(Te.$$.fragment,e),b(Ue.$$.fragment,e),b(q.$$.fragment,e),b(je.$$.fragment,e),b(A.$$.fragment,e),b(Ze.$$.fragment,e),b(Je.$$.fragment,e),b(Pe.$$.fragment,e),b(ee.$$.fragment,e),b(ke.$$.fragment,e),b(te.$$.fragment,e),b(oe.$$.fragment,e),b(Ce.$$.fragment,e),b(De.$$.fragment,e),b(Ie.$$.fragment,e),b(ie.$$.fragment,e),b(ae.$$.fragment,e),b(Ge.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(We.$$.fragment,e),b(Be.$$.fragment,e),b(He.$$.fragment,e),b(Fe.$$.fragment,e),b(Ve.$$.fragment,e),b(Ne.$$.fragment,e),b(me.$$.fragment,e),b(ue.$$.fragment,e),b(he.$$.fragment,e),b(Xe.$$.fragment,e),b(Re.$$.fragment,e),b(Le.$$.fragment,e),b(Ee.$$.fragment,e),b(Se.$$.fragment,e),b(_e.$$.fragment,e),Qt=!0)},o(e){_(v.$$.fragment,e),_(Y.$$.fragment,e),_($e.$$.fragment,e),_(xe.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(Ue.$$.fragment,e),_(q.$$.fragment,e),_(je.$$.fragment,e),_(A.$$.fragment,e),_(Ze.$$.fragment,e),_(Je.$$.fragment,e),_(Pe.$$.fragment,e),_(ee.$$.fragment,e),_(ke.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(Ce.$$.fragment,e),_(De.$$.fragment,e),_(Ie.$$.fragment,e),_(ie.$$.fragment,e),_(ae.$$.fragment,e),_(Ge.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(We.$$.fragment,e),_(Be.$$.fragment,e),_(He.$$.fragment,e),_(Fe.$$.fragment,e),_(Ve.$$.fragment,e),_(Ne.$$.fragment,e),_(me.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(Xe.$$.fragment,e),_(Re.$$.fragment,e),_(Le.$$.fragment,e),_(Ee.$$.fragment,e),_(Se.$$.fragment,e),_(_e.$$.fragment,e),Qt=!1},d(e){e&&(p(m),p(s),p(r),p(o),p(M),p(Vt),p(we),p(Nt),p(Xt),p(Rt),p(w),p(Lt),p(Et),p(Z),p(St),p(zt),p(N),p(Yt),p(Ht)),p(t),y(v,e),y(Y,e),y($e,e),y(xe),y(Me),y(Te),y(Ue),y(q),y(je),y(A),y(Ze),y(Je),y(Pe),y(ee),y(ke),y(te),y(oe),y(Ce),y(De),y(Ie),y(ie),y(ae),y(Ge),y(re),y(le),y(de),y(We),y(Be),y(He),y(Fe,e),y(Ve),y(Ne),y(me),y(ue),y(he),y(Xe),y(Re),y(Le,e),y(Ee),y(Se),y(_e)}}}const _s='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function ys(T){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends Kn{constructor(t){super(),es(this,t,ys,bs,An,{})}}export{js as component};
