import{s as cN,o as mN,n as x}from"../chunks/scheduler.9bc65507.js";import{S as fN,i as gN,g as i,s as r,r as p,A as pN,h as l,f as d,c as a,j as C,u,x as f,k as w,y as t,a as y,v as h,d as b,t as _,w as M}from"../chunks/index.707bf1b6.js";import{T as Jj}from"../chunks/Tip.c2ecdbf4.js";import{D as j}from"../chunks/Docstring.17db21ae.js";import{C as $}from"../chunks/CodeBlock.54a9f38d.js";import{E as k}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as Z}from"../chunks/Heading.342b1fa6.js";function uN(v){let n,F='あなたの<code>NewModelConfig</code>が<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>のサブクラスである場合、その<code>model_type</code>属性がコンフィグを登録するときに使用するキー（ここでは<code>&quot;new-model&quot;</code>）と同じに設定されていることを確認してください。',c,s,m='同様に、あなたの<code>NewModel</code>が<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>のサブクラスである場合、その<code>config_class</code>属性がモデルを登録する際に使用するクラス（ここでは<code>NewModelConfig</code>）と同じに設定されていることを確認してください。';return{c(){n=i("p"),n.innerHTML=F,c=r(),s=i("p"),s.innerHTML=m},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-r0m7dc"&&(n.innerHTML=F),c=a(e),s=l(e,"P",{"data-svelte-h":!0}),f(s)!=="svelte-z947bb"&&(s.innerHTML=m)},m(e,T){y(e,n,T),y(e,c,T),y(e,s,T)},p:x,d(e){e&&(d(n),d(c),d(s))}}}function hN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMCh1c2VyLXVwbG9hZGVkKSUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRibWR6JTJGYmVydC1iYXNlLWdlcm1hbi1jYXNlZCUyMiklMEElMEElMjMlMjBJZiUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlJTIwaXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyQyUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRmJlcnRfc2F2ZWRfbW9kZWwlMkYlMjIpJTBBJTBBJTIzJTIwTG9hZCUyMGElMjBzcGVjaWZpYyUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGYmVydF9zYXZlZF9tb2RlbCUyRm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEElMEElMjMlMjBDaGFuZ2UlMjBzb21lJTIwY29uZmlnJTIwYXR0cmlidXRlcyUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMHByZXRyYWluZWQlMjBjb25maWcuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSUyQyUyMGZvbyUzREZhbHNlKSUwQWNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQWNvbmZpZyUyQyUyMHVudXNlZF9rd2FyZ3MlMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlJTJDJTIwZm9vJTNERmFsc2UlMkMlMjByZXR1cm5fdW51c2VkX2t3YXJncyUzRFRydWUlMEEpJTBBY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBdW51c2VkX2t3YXJncw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If configuration file is in a directory (e.g., was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a specific configuration file.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./test/bert_saved_model/my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Change some config attributes when loading a pretrained config.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>config, unused_kwargs = AutoConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>, foo=<span class="hljs-literal">False</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function bN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBEb3dubG9hZCUyMHZvY2FidWxhcnklMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwdm9jYWJ1bGFyeSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMCh1c2VyLXVwbG9hZGVkKSUyMGFuZCUyMGNhY2hlLiUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRibWR6JTJGYmVydC1iYXNlLWdlcm1hbi1jYXNlZCUyMiklMEElMEElMjMlMjBJZiUyMHZvY2FidWxhcnklMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwdG9rZW5pemVyJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSopJTBBJTIzJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZiZXJ0X3NhdmVkX21vZGVsJTJGJTIyKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwdm9jYWJ1bGFyeSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGRlZmluZSUyMG1vZGVsLXNwZWNpZmljJTIwYXJndW1lbnRzJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyRmFjZWJvb2tBSSUyRnJvYmVydGEtYmFzZSUyMiUyQyUyMGFkZF9wcmVmaXhfc3BhY2UlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co (user-uploaded) and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dbmdz/bert-base-german-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If vocabulary files are in a directory (e.g. tokenizer was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tokenizer = AutoTokenizer.from_pretrained(&quot;./test/bert_saved_model/&quot;)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download vocabulary from huggingface.co and define model-specific arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;FacebookAI/roberta-base&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function _N(v){let n,F="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){n=i("p"),n.innerHTML=F},l(c){n=l(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-15auxyb"&&(n.innerHTML=F)},m(c,s){y(c,n,s)},p:x,d(c){c&&d(n)}}}function MN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1iYXNlLTk2MGglMjIpJTBBJTBBJTIzJTIwSWYlMjBmZWF0dXJlJTIwZXh0cmFjdG9yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMGZlYXR1cmUlMjBleHRyYWN0b3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download feature extractor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If feature extractor files are in a directory (e.g. feature extractor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feature_extractor = AutoFeatureExtractor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function TN(v){let n,F="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){n=i("p"),n.innerHTML=F},l(c){n=l(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-15auxyb"&&(n.innerHTML=F)},m(c,s){y(c,n,s)},p:x,d(c){c&&d(n)}}}function yN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQSUyMyUyMERvd25sb2FkJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyKSUwQSUwQSUyMyUyMElmJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjBmaWxlcyUyMGFyZSUyMGluJTIwYSUyMGRpcmVjdG9yeSUyMChlLmcuJTIwaW1hZ2UlMjBwcm9jZXNzb3IlMjB3YXMlMjBzYXZlZCUyMHVzaW5nJTIwKnNhdmVfcHJldHJhaW5lZCgnLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRicpKiklMEElMjMlMjBpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download image processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If image processor files are in a directory (e.g. image processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># image_processor = AutoImageProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function FN(v){let n,F="Passing <code>token=True</code> is required when you want to use a private model.";return{c(){n=i("p"),n.innerHTML=F},l(c){n=l(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-15auxyb"&&(n.innerHTML=F)},m(c,s){y(c,n,s)},p:x,d(c){c&&d(n)}}}function vN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEElMjMlMjBEb3dubG9hZCUyMHByb2Nlc3NvciUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS05NjBoJTIyKSUwQSUwQSUyMyUyMElmJTIwcHJvY2Vzc29yJTIwZmlsZXMlMjBhcmUlMjBpbiUyMGElMjBkaXJlY3RvcnklMjAoZS5nLiUyMHByb2Nlc3NvciUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqKSUwQSUyMyUyMHByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download processor from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If processor files are in a directory (e.g. processor was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># processor = AutoProcessor.from_pretrained(&quot;./test/saved_model/&quot;)</span>`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function CN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function wN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function jN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function xN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function $N(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function kN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function ZN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function AN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function LN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function BN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function RN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JQcmVUcmFpbmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function WN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUHJlVHJhaW5pbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForPreTraining

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForPreTraining.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function JN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function GN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function VN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function SN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function EN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function IN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function UN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function PN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function qN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function NN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function XN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function DN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTWFza2VkTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMaskedLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function HN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function QN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtdDUlMkZ0NS1iYXNlJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwVEYlMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBQeVRvcmNoJTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZ0Zl9tb2RlbCUyRnQ1X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZ0NV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/t5_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/t5_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function YN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function zN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGdDVfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function ON(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLXQ1JTJGdDUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function KN(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS10NSUyRnQ1LWJhc2UlMjIlMkMlMjBvdXRwdXRfYXR0ZW50aW9ucyUzRFRydWUpJTBBbW9kZWwuY29uZmlnLm91dHB1dF9hdHRlbnRpb25zJTBBJTBBJTIzJTIwTG9hZGluZyUyMGZyb20lMjBhJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFRlbnNvckZsb3clMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnB0X21vZGVsJTJGdDVfcHRfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0NV9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/t5_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSeq2SeqLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/t5_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function eX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function oX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function tX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function nX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function rX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function aX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function sX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function iX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function lX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function dX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function cX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function mX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForMultipleChoice.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function fX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function gX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function pX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function uX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function hX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function bX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yTmV4dFNlbnRlbmNlUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JOZXh0U2VudGVuY2VQcmVkaWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvck5leHRTZW50ZW5jZVByZWRpY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForNextSentencePrediction

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForNextSentencePrediction.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function _X(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function MX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function TX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function yX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function FX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function vX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForTokenClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function CX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function wX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function jX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function xX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function $X(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function kX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function ZX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function AX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEZXB0aEVzdGltYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yRGVwdGhFc3RpbWF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function LX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function BX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function RX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function WX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function JX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function GX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function VX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function SX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpZGVvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function EX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function IX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function UX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function PX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvck1hc2tlZEltYWdlTW9kZWxpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForMaskedImageModeling

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMaskedImageModeling.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function qX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function NX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JPYmplY3REZXRlY3Rpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function XX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function DX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForImageSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForImageSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function HX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function QX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function YX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function zX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGYmVydF9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSemanticSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function OX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW5zdGFuY2VTZWdtZW50YXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function KX(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbnN0YW5jZVNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckluc3RhbmNlU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForInstanceSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForInstanceSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function e3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function o3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclVuaXZlcnNhbFNlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForUniversalSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function t3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function n3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function r3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function a3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclplcm9TaG90SW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yWmVyb1Nob3RJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JaZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForZeroShotImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForZeroShotImageClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function s3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWmVyb1Nob3RPYmplY3REZXRlY3Rpb24uZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function i3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbiUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JaZXJvU2hvdE9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclplcm9TaG90T2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZiZXJ0X3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function l3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function d3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function c3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function m3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForAudioClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function f3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function g3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb0ZyYW1lQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioFrameClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioFrameClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function p3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function u3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDVEMlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNUQy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForCTC

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCTC.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function h3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function b3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function _3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function M3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function T3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function y3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JTcGVlY2hTZXEyU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForSpeechSeq2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForSpeechSeq2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function F3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function v3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JBdWRpb1hWZWN0b3IlMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckF1ZGlvWFZlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForAudioXVector

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForAudioXVector.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function C3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function w3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ0YXBhc190Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnRhcGFzX3RmX2NoZWNrcG9pbnQuY2twdC5pbmRleCUyMiUyQyUyMGZyb21fdGYlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/tapas_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/tapas_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function j3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function x3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclRhYmxlUXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ0YXBhcy1iYXNlLWZpbmV0dW5lZC13dHElMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVGFibGVRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdGFwYXMtYmFzZS1maW5ldHVuZWQtd3RxJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFB5VG9yY2glMjBjaGVja3BvaW50JTIwZmlsZSUyMGluc3RlYWQlMjBvZiUyMGElMjBUZW5zb3JGbG93JTIwbW9kZWwlMjAoc2xvd2VyKSUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMi4lMkZwdF9tb2RlbCUyRnRhcGFzX3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JUYWJsZVF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZ0YXBhc19weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMGZyb21fcHQlM0RUcnVlJTJDJTIwY29uZmlnJTNEY29uZmlnJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForTableQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/tapas_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForTableQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/tapas_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function $3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyaW1waXJhJTJGbGF5b3V0bG0tZG9jdW1lbnQtcWElMjIlMkMlMjByZXZpc2lvbiUzRCUyMjUyZTAxYjMlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function k3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI1MmUwMWIzJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGbGF5b3V0bG1fdGZfbW9kZWxfY29uZmlnLmpzb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGdGZfbW9kZWwlMkZsYXlvdXRsbV90Zl9jaGVja3BvaW50LmNrcHQuaW5kZXglMjIlMkMlMjBmcm9tX3RmJTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/layoutlm_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/layoutlm_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function Z3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function A3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvckRvY3VtZW50UXVlc3Rpb25BbnN3ZXJpbmclMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JEb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZCglMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiUyQyUyMHJldmlzaW9uJTNEJTIyNTJlMDFiMyUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZsYXlvdXRsbV9wdF9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yRG9jdW1lbnRRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnB0X21vZGVsJTJGbGF5b3V0bG1fcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForDocumentQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>, revision=<span class="hljs-string">&quot;52e01b3&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/layoutlm_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForDocumentQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/layoutlm_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function L3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmRhbmRlbGluJTJGdmlsdC1iMzItZmluZXR1bmVkLXZxYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc3VhbFF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function B3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZyUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXN1YWxRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGFuZGVsaW4lMkZ2aWx0LWIzMi1maW5ldHVuZWQtdnFhJTIyJTJDJTIwb3V0cHV0X2F0dGVudGlvbnMlM0RUcnVlKSUwQW1vZGVsLmNvbmZpZy5vdXRwdXRfYXR0ZW50aW9ucyUwQSUwQSUyMyUyMExvYWRpbmclMjBmcm9tJTIwYSUyMFRGJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwUHlUb3JjaCUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGZfbW9kZWwlMkZ2aWx0X3RmX21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yVmlzdWFsUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRnZpbHRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVisualQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;dandelin/vilt-b32-finetuned-vqa&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/vilt_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVisualQuestionAnswering.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/vilt_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function R3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fY29uZmlnKGNvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function W3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBtb2RlbCUyMGFuZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQSUwQSUyMyUyMFVwZGF0ZSUyMGNvbmZpZ3VyYXRpb24lMjBkdXJpbmclMjBsb2FkaW5nJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBURiUyMGNoZWNrcG9pbnQlMjBmaWxlJTIwaW5zdGVhZCUyMG9mJTIwYSUyMFB5VG9yY2glMjBtb2RlbCUyMChzbG93ZXIpJTBBY29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRmX21vZGVsJTJGYmVydF90Zl9tb2RlbF9jb25maWcuanNvbiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZ0Zl9tb2RlbCUyRmJlcnRfdGZfY2hlY2twb2ludC5ja3B0LmluZGV4JTIyJTJDJTIwZnJvbV90ZiUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a TF checkpoint file instead of a PyTorch model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./tf_model/bert_tf_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./tf_model/bert_tf_checkpoint.ckpt.index&quot;</span>, from_tf=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function J3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX2NvbmZpZyhjb25maWcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function G3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBURkF1dG9Nb2RlbEZvclZpc2lvbjJTZXElMEElMEElMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwYW5kJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBVcGRhdGUlMjBjb25maWd1cmF0aW9uJTIwZHVyaW5nJTIwbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B5dG9yY2hfbW9kZWwuYmluJTIyJTJDJTIwZnJvbV9wdCUzRFRydWUlMkMlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, TFAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function V3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwY29uZmlndXJhdGlvbiUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQWNvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9jb25maWcoY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_config(config)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function S3(v){let n,F="Examples:",c,s,m;return s=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcSUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMjAlM0QlMjBGbGF4QXV0b01vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTIzJTIwVXBkYXRlJTIwY29uZmlndXJhdGlvbiUyMGR1cmluZyUyMGxvYWRpbmclMEFtb2RlbCUyMCUzRCUyMEZsYXhBdXRvTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG91dHB1dF9hdHRlbnRpb25zJTNEVHJ1ZSklMEFtb2RlbC5jb25maWcub3V0cHV0X2F0dGVudGlvbnMlMEElMEElMjMlMjBMb2FkaW5nJTIwZnJvbSUyMGElMjBQeVRvcmNoJTIwY2hlY2twb2ludCUyMGZpbGUlMjBpbnN0ZWFkJTIwb2YlMjBhJTIwVGVuc29yRmxvdyUyMG1vZGVsJTIwKHNsb3dlciklMEFjb25maWclMjAlM0QlMjBBdXRvQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGcHRfbW9kZWwlMkZiZXJ0X3B0X21vZGVsX2NvbmZpZy5qc29uJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEF1dG9Nb2RlbEZvclZpc2lvbjJTZXEuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZwdF9tb2RlbCUyRmJlcnRfcHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMjBmcm9tX3B0JTNEVHJ1ZSUyQyUyMGNvbmZpZyUzRGNvbmZpZyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, FlaxAutoModelForVision2Seq

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Update configuration during loading</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, output_attentions=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.output_attentions
<span class="hljs-literal">True</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loading from a PyTorch checkpoint file instead of a TensorFlow model (slower)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;./pt_model/bert_pt_model_config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxAutoModelForVision2Seq.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;./pt_model/bert_pytorch_model.bin&quot;</span>, from_pt=<span class="hljs-literal">True</span>, config=config
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){n=i("p"),n.textContent=F,c=r(),p(s.$$.fragment)},l(e){n=l(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-kvfsh7"&&(n.textContent=F),c=a(e),u(s.$$.fragment,e)},m(e,T){y(e,n,T),y(e,c,T),h(s,e,T),m=!0},p:x,i(e){m||(b(s.$$.fragment,e),m=!0)},o(e){_(s.$$.fragment,e),m=!1},d(e){e&&(d(n),d(c)),M(s,e)}}}function E3(v){let n,F,c,s,m,e,T,IV="多くの場合、<code>from_pretrained()</code>メソッドに与えられた事前学習済みモデルの名前やパスから、使用したいアーキテクチャを推測することができます。自動クラスはこの仕事をあなたに代わって行うためにここにありますので、事前学習済みの重み/設定/語彙への名前/パスを与えると自動的に関連するモデルを取得できます。",xC,vd,UV='<a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoConfig">AutoConfig</a>、<a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoModel">AutoModel</a>、<a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>のいずれかをインスタンス化すると、関連するアーキテクチャのクラスが直接作成されます。例えば、',$C,Cd,kC,wd,PV='これは<a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertModel">BertModel</a>のインスタンスであるモデルを作成します。',ZC,jd,qV="各タスクごと、そして各バックエンド（PyTorch、TensorFlow、またはFlax）ごとに<code>AutoModel</code>のクラスが存在します。",AC,xd,LC,$d,NV="それぞれの自動クラスには、カスタムクラスで拡張するためのメソッドがあります。例えば、<code>NewModel</code>というモデルのカスタムクラスを定義した場合、<code>NewModelConfig</code>を確保しておけばこのようにして自動クラスに追加することができます：",BC,kd,RC,Zd,XV="その後、通常どおりauto classesを使用することができるようになります！",WC,vs,JC,Ad,GC,ce,Ld,Gj,pu,DV=`This is a generic configuration class that will be instantiated as one of the configuration classes of the library
when created with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoConfig.from_pretrained">from_pretrained()</a> class method.`,Vj,uu,HV="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Sj,Uo,Bd,Ej,hu,QV="Instantiate one of the configuration classes of the library from a pretrained model configuration.",Ij,bu,YV=`The configuration class to instantiate is selected based on the <code>model_type</code> property of the config object that
is loaded, or when it’s missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Uj,_u,zV='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/main/ja/model_doc/align#transformers.AlignConfig">AlignConfig</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/ja/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/main/ja/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/ja/model_doc/bark#transformers.BarkConfig">BarkConfig</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitConfig">BeitConfig</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitConfig">BitConfig</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipConfig">BlipConfig</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/ja/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/ja/model_doc/bros#transformers.BrosConfig">BrosConfig</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineConfig">CanineConfig</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> (Chinese-CLIP model)</li> <li><strong>chinese_clip_vision_model</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPVisionConfig">ChineseCLIPVisionConfig</a> (ChineseCLIPVisionModel model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/ja/model_doc/clap#transformers.ClapConfig">ClapConfig</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/ja/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> (CLVP model)</li> <li><strong>code_llama</strong> — <code>LlamaConfig</code> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> (CodeGen model)</li> <li><strong>cohere</strong> — <code>CohereConfig</code> (Cohere model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> (DeiT model)</li> <li><strong>depth_anything</strong> — <code>DepthAnythingConfig</code> (Depth Anything model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/ja/model_doc/deta#transformers.DetaConfig">DetaConfig</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrConfig">DetrConfig</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/ja/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <code>Dinov2Config</code> (DINOv2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertConfig</code> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <code>DonutSwinConfig</code> (DonutSwin model)</li> <li><strong>dpr</strong> — <code>DPRConfig</code> (DPR model)</li> <li><strong>dpt</strong> — <code>DPTConfig</code> (DPT model)</li> <li><strong>efficientformer</strong> — <code>EfficientFormerConfig</code> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <code>EfficientNetConfig</code> (EfficientNet model)</li> <li><strong>electra</strong> — <code>ElectraConfig</code> (ELECTRA model)</li> <li><strong>encodec</strong> — <code>EncodecConfig</code> (EnCodec model)</li> <li><strong>encoder-decoder</strong> — <code>EncoderDecoderConfig</code> (Encoder decoder model)</li> <li><strong>ernie</strong> — <code>ErnieConfig</code> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMConfig</code> (ErnieM model)</li> <li><strong>esm</strong> — <code>EsmConfig</code> (ESM model)</li> <li><strong>falcon</strong> — <code>FalconConfig</code> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <code>FastSpeech2ConformerConfig</code> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <code>FlaubertConfig</code> (FlauBERT model)</li> <li><strong>flava</strong> — <code>FlavaConfig</code> (FLAVA model)</li> <li><strong>fnet</strong> — <code>FNetConfig</code> (FNet model)</li> <li><strong>focalnet</strong> — <code>FocalNetConfig</code> (FocalNet model)</li> <li><strong>fsmt</strong> — <code>FSMTConfig</code> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <code>FunnelConfig</code> (Funnel Transformer model)</li> <li><strong>fuyu</strong> — <code>FuyuConfig</code> (Fuyu model)</li> <li><strong>gemma</strong> — <code>GemmaConfig</code> (Gemma model)</li> <li><strong>git</strong> — <code>GitConfig</code> (GIT model)</li> <li><strong>glpn</strong> — <code>GLPNConfig</code> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <code>GPT2Config</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2Config</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPTBigCodeConfig</code> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <code>GPTNeoConfig</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXConfig</code> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <code>GPTNeoXJapaneseConfig</code> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <code>GPTJConfig</code> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <code>GPTSanJapaneseConfig</code> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <code>GraphormerConfig</code> (Graphormer model)</li> <li><strong>groupvit</strong> — <code>GroupViTConfig</code> (GroupViT model)</li> <li><strong>hubert</strong> — <code>HubertConfig</code> (Hubert model)</li> <li><strong>ibert</strong> — <code>IBertConfig</code> (I-BERT model)</li> <li><strong>idefics</strong> — <code>IdeficsConfig</code> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <code>ImageGPTConfig</code> (ImageGPT model)</li> <li><strong>informer</strong> — <code>InformerConfig</code> (Informer model)</li> <li><strong>instructblip</strong> — <code>InstructBlipConfig</code> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <code>JukeboxConfig</code> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <code>Kosmos2Config</code> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMConfig</code> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2Config</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3Config</code> (LayoutLMv3 model)</li> <li><strong>led</strong> — <code>LEDConfig</code> (LED model)</li> <li><strong>levit</strong> — <code>LevitConfig</code> (LeViT model)</li> <li><strong>lilt</strong> — <code>LiltConfig</code> (LiLT model)</li> <li><strong>llama</strong> — <code>LlamaConfig</code> (LLaMA model)</li> <li><strong>llava</strong> — <code>LlavaConfig</code> (LLaVa model)</li> <li><strong>longformer</strong> — <code>LongformerConfig</code> (Longformer model)</li> <li><strong>longt5</strong> — <code>LongT5Config</code> (LongT5 model)</li> <li><strong>luke</strong> — <code>LukeConfig</code> (LUKE model)</li> <li><strong>lxmert</strong> — <code>LxmertConfig</code> (LXMERT model)</li> <li><strong>m2m_100</strong> — <code>M2M100Config</code> (M2M100 model)</li> <li><strong>mamba</strong> — <code>MambaConfig</code> (Mamba model)</li> <li><strong>marian</strong> — <code>MarianConfig</code> (Marian model)</li> <li><strong>markuplm</strong> — <code>MarkupLMConfig</code> (MarkupLM model)</li> <li><strong>mask2former</strong> — <code>Mask2FormerConfig</code> (Mask2Former model)</li> <li><strong>maskformer</strong> — <code>MaskFormerConfig</code> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinConfig</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <code>MBartConfig</code> (mBART model)</li> <li><strong>mctct</strong> — <code>MCTCTConfig</code> (M-CTC-T model)</li> <li><strong>mega</strong> — <code>MegaConfig</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertConfig</code> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <code>MgpstrConfig</code> (MGP-STR model)</li> <li><strong>mistral</strong> — <code>MistralConfig</code> (Mistral model)</li> <li><strong>mixtral</strong> — <code>MixtralConfig</code> (Mixtral model)</li> <li><strong>mobilebert</strong> — <code>MobileBertConfig</code> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <code>MobileNetV1Config</code> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <code>MobileNetV2Config</code> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <code>MobileViTConfig</code> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <code>MobileViTV2Config</code> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <code>MPNetConfig</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>MptConfig</code> (MPT model)</li> <li><strong>mra</strong> — <code>MraConfig</code> (MRA model)</li> <li><strong>mt5</strong> — <code>MT5Config</code> (MT5 model)</li> <li><strong>musicgen</strong> — <code>MusicgenConfig</code> (MusicGen model)</li> <li><strong>mvp</strong> — <code>MvpConfig</code> (MVP model)</li> <li><strong>nat</strong> — <code>NatConfig</code> (NAT model)</li> <li><strong>nezha</strong> — <code>NezhaConfig</code> (Nezha model)</li> <li><strong>nllb-moe</strong> — <code>NllbMoeConfig</code> (NLLB-MOE model)</li> <li><strong>nougat</strong> — <code>VisionEncoderDecoderConfig</code> (Nougat model)</li> <li><strong>nystromformer</strong> — <code>NystromformerConfig</code> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <code>OneFormerConfig</code> (OneFormer model)</li> <li><strong>open-llama</strong> — <code>OpenLlamaConfig</code> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <code>OpenAIGPTConfig</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>OPTConfig</code> (OPT model)</li> <li><strong>owlv2</strong> — <code>Owlv2Config</code> (OWLv2 model)</li> <li><strong>owlvit</strong> — <code>OwlViTConfig</code> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <code>PatchTSMixerConfig</code> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <code>PatchTSTConfig</code> (PatchTST model)</li> <li><strong>pegasus</strong> — <code>PegasusConfig</code> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <code>PegasusXConfig</code> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <code>PerceiverConfig</code> (Perceiver model)</li> <li><strong>persimmon</strong> — <code>PersimmonConfig</code> (Persimmon model)</li> <li><strong>phi</strong> — <code>PhiConfig</code> (Phi model)</li> <li><strong>pix2struct</strong> — <code>Pix2StructConfig</code> (Pix2Struct model)</li> <li><strong>plbart</strong> — <code>PLBartConfig</code> (PLBart model)</li> <li><strong>poolformer</strong> — <code>PoolFormerConfig</code> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <code>Pop2PianoConfig</code> (Pop2Piano model)</li> <li><strong>prophetnet</strong> — <code>ProphetNetConfig</code> (ProphetNet model)</li> <li><strong>pvt</strong> — <code>PvtConfig</code> (PVT model)</li> <li><strong>pvt_v2</strong> — <code>PvtV2Config</code> (PVTv2 model)</li> <li><strong>qdqbert</strong> — <code>QDQBertConfig</code> (QDQBert model)</li> <li><strong>qwen2</strong> — <code>Qwen2Config</code> (Qwen2 model)</li> <li><strong>rag</strong> — <code>RagConfig</code> (RAG model)</li> <li><strong>realm</strong> — <code>RealmConfig</code> (REALM model)</li> <li><strong>reformer</strong> — <code>ReformerConfig</code> (Reformer model)</li> <li><strong>regnet</strong> — <code>RegNetConfig</code> (RegNet model)</li> <li><strong>rembert</strong> — <code>RemBertConfig</code> (RemBERT model)</li> <li><strong>resnet</strong> — <code>ResNetConfig</code> (ResNet model)</li> <li><strong>retribert</strong> — <code>RetriBertConfig</code> (RetriBERT model)</li> <li><strong>roberta</strong> — <code>RobertaConfig</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormConfig</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertConfig</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerConfig</code> (RoFormer model)</li> <li><strong>rwkv</strong> — <code>RwkvConfig</code> (RWKV model)</li> <li><strong>sam</strong> — <code>SamConfig</code> (SAM model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TConfig</code> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <code>SeamlessM4Tv2Config</code> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <code>SegformerConfig</code> (SegFormer model)</li> <li><strong>seggpt</strong> — <code>SegGptConfig</code> (SegGPT model)</li> <li><strong>sew</strong> — <code>SEWConfig</code> (SEW model)</li> <li><strong>sew-d</strong> — <code>SEWDConfig</code> (SEW-D model)</li> <li><strong>siglip</strong> — <code>SiglipConfig</code> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <code>SiglipVisionConfig</code> (SiglipVisionModel model)</li> <li><strong>speech-encoder-decoder</strong> — <code>SpeechEncoderDecoderConfig</code> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <code>Speech2TextConfig</code> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <code>Speech2Text2Config</code> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <code>SpeechT5Config</code> (SpeechT5 model)</li> <li><strong>splinter</strong> — <code>SplinterConfig</code> (Splinter model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertConfig</code> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <code>StableLmConfig</code> (StableLm model)</li> <li><strong>starcoder2</strong> — <code>Starcoder2Config</code> (Starcoder2 model)</li> <li><strong>swiftformer</strong> — <code>SwiftFormerConfig</code> (SwiftFormer model)</li> <li><strong>swin</strong> — <code>SwinConfig</code> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <code>Swin2SRConfig</code> (Swin2SR model)</li> <li><strong>swinv2</strong> — <code>Swinv2Config</code> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <code>SwitchTransformersConfig</code> (SwitchTransformers model)</li> <li><strong>t5</strong> — <code>T5Config</code> (T5 model)</li> <li><strong>table-transformer</strong> — <code>TableTransformerConfig</code> (Table Transformer model)</li> <li><strong>tapas</strong> — <code>TapasConfig</code> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <code>TimeSeriesTransformerConfig</code> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <code>TimesformerConfig</code> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <code>TimmBackboneConfig</code> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <code>TrajectoryTransformerConfig</code> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <code>TransfoXLConfig</code> (Transformer-XL model)</li> <li><strong>trocr</strong> — <code>TrOCRConfig</code> (TrOCR model)</li> <li><strong>tvlt</strong> — <code>TvltConfig</code> (TVLT model)</li> <li><strong>tvp</strong> — <code>TvpConfig</code> (TVP model)</li> <li><strong>udop</strong> — <code>UdopConfig</code> (UDOP model)</li> <li><strong>umt5</strong> — <code>UMT5Config</code> (UMT5 model)</li> <li><strong>unispeech</strong> — <code>UniSpeechConfig</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatConfig</code> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <code>UnivNetConfig</code> (UnivNet model)</li> <li><strong>upernet</strong> — <code>UperNetConfig</code> (UPerNet model)</li> <li><strong>van</strong> — <code>VanConfig</code> (VAN model)</li> <li><strong>videomae</strong> — <code>VideoMAEConfig</code> (VideoMAE model)</li> <li><strong>vilt</strong> — <code>ViltConfig</code> (ViLT model)</li> <li><strong>vipllava</strong> — <code>VipLlavaConfig</code> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <code>VisionEncoderDecoderConfig</code> (Vision Encoder decoder model)</li> <li><strong>vision-text-dual-encoder</strong> — <code>VisionTextDualEncoderConfig</code> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <code>VisualBertConfig</code> (VisualBERT model)</li> <li><strong>vit</strong> — <code>ViTConfig</code> (ViT model)</li> <li><strong>vit_hybrid</strong> — <code>ViTHybridConfig</code> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <code>ViTMAEConfig</code> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <code>ViTMSNConfig</code> (ViTMSN model)</li> <li><strong>vitdet</strong> — <code>VitDetConfig</code> (VitDet model)</li> <li><strong>vitmatte</strong> — <code>VitMatteConfig</code> (ViTMatte model)</li> <li><strong>vits</strong> — <code>VitsConfig</code> (VITS model)</li> <li><strong>vivit</strong> — <code>VivitConfig</code> (ViViT model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2Config</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2BertConfig</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerConfig</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>WavLMConfig</code> (WavLM model)</li> <li><strong>whisper</strong> — <code>WhisperConfig</code> (Whisper model)</li> <li><strong>xclip</strong> — <code>XCLIPConfig</code> (X-CLIP model)</li> <li><strong>xglm</strong> — <code>XGLMConfig</code> (XGLM model)</li> <li><strong>xlm</strong> — <code>XLMConfig</code> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <code>XLMProphetNetConfig</code> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaConfig</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLConfig</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetConfig</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodConfig</code> (X-MOD model)</li> <li><strong>yolos</strong> — <code>YolosConfig</code> (YOLOS model)</li> <li><strong>yoso</strong> — <code>YosoConfig</code> (YOSO model)</li>',Pj,Cs,qj,ws,Rd,Nj,Mu,OV="Register a new configuration for this class.",VC,Wd,SC,me,Jd,Xj,Tu,KV=`This is a generic tokenizer class that will be instantiated as one of the tokenizer classes of the library when
created with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoTokenizer.from_pretrained">AutoTokenizer.from_pretrained()</a> class method.`,Dj,yu,eS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Hj,Po,Gd,Qj,Fu,oS="Instantiate one of the tokenizer classes of the library from a pretrained model vocabulary.",Yj,vu,tS=`The tokenizer class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,zj,Cu,nS='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ALIGN model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartTokenizer">BartTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartTokenizerFast">BartTokenizerFast</a> (BART model)</li> <li><strong>barthez</strong> — <a href="/docs/transformers/main/ja/model_doc/barthez#transformers.BarthezTokenizer">BarthezTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/barthez#transformers.BarthezTokenizerFast">BarthezTokenizerFast</a> (BARThez model)</li> <li><strong>bartpho</strong> — <a href="/docs/transformers/main/ja/model_doc/bartpho#transformers.BartphoTokenizer">BartphoTokenizer</a> (BARTpho model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationTokenizer">BertGenerationTokenizer</a> (Bert Generation model)</li> <li><strong>bert-japanese</strong> — <a href="/docs/transformers/main/ja/model_doc/bert-japanese#transformers.BertJapaneseTokenizer">BertJapaneseTokenizer</a> (BertJapanese model)</li> <li><strong>bertweet</strong> — <a href="/docs/transformers/main/ja/model_doc/bertweet#transformers.BertweetTokenizer">BertweetTokenizer</a> (BERTweet model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdTokenizer">BigBirdTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdTokenizerFast">BigBirdTokenizerFast</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <code>PegasusTokenizer</code> or <code>PegasusTokenizerFast</code> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptTokenizer">BioGptTokenizer</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotTokenizer">BlenderbotTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotTokenizerFast">BlenderbotTokenizerFast</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallTokenizer">BlenderbotSmallTokenizer</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BLIP model)</li> <li><strong>blip-2</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomTokenizerFast">BloomTokenizerFast</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (BROS model)</li> <li><strong>byt5</strong> — <a href="/docs/transformers/main/ja/model_doc/byt5#transformers.ByT5Tokenizer">ByT5Tokenizer</a> (ByT5 model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertTokenizer">CamembertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertTokenizerFast">CamembertTokenizerFast</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineTokenizer">CanineTokenizer</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpTokenizer">ClvpTokenizer</a> (CLVP model)</li> <li><strong>code_llama</strong> — <a href="/docs/transformers/main/ja/model_doc/code_llama#transformers.CodeLlamaTokenizer">CodeLlamaTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/code_llama#transformers.CodeLlamaTokenizerFast">CodeLlamaTokenizerFast</a> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (CodeGen model)</li> <li><strong>cohere</strong> — <code>CohereTokenizerFast</code> (Cohere model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertTokenizer">ConvBertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertTokenizerFast">ConvBertTokenizerFast</a> (ConvBERT model)</li> <li><strong>cpm</strong> — <a href="/docs/transformers/main/ja/model_doc/cpm#transformers.CpmTokenizer">CpmTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/cpm#transformers.CpmTokenizerFast">CpmTokenizerFast</a> (CPM model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntTokenizer">CpmAntTokenizer</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLTokenizer">CTRLTokenizer</a> (CTRL model)</li> <li><strong>data2vec-audio</strong> — <code>Wav2Vec2CTCTokenizer</code> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaTokenizer">DebertaTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaTokenizerFast">DebertaTokenizerFast</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Tokenizer">DebertaV2Tokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2TokenizerFast">DebertaV2TokenizerFast</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertTokenizer</code> or <code>DistilBertTokenizerFast</code> (DistilBERT model)</li> <li><strong>dpr</strong> — <code>DPRQuestionEncoderTokenizer</code> or <code>DPRQuestionEncoderTokenizerFast</code> (DPR model)</li> <li><strong>electra</strong> — <code>ElectraTokenizer</code> or <code>ElectraTokenizerFast</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMTokenizer</code> (ErnieM model)</li> <li><strong>esm</strong> — <code>EsmTokenizer</code> (ESM model)</li> <li><strong>falcon</strong> — <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> —  (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <code>FlaubertTokenizer</code> (FlauBERT model)</li> <li><strong>fnet</strong> — <code>FNetTokenizer</code> or <code>FNetTokenizerFast</code> (FNet model)</li> <li><strong>fsmt</strong> — <code>FSMTTokenizer</code> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <code>FunnelTokenizer</code> or <code>FunnelTokenizerFast</code> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <code>GemmaTokenizer</code> or <code>GemmaTokenizerFast</code> (Gemma model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (GIT model)</li> <li><strong>gpt-sw3</strong> — <code>GPTSw3Tokenizer</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXTokenizerFast</code> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <code>GPTNeoXJapaneseTokenizer</code> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <code>GPTSanJapaneseTokenizer</code> (GPTSAN-japanese model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (GroupViT model)</li> <li><strong>herbert</strong> — <code>HerbertTokenizer</code> or <code>HerbertTokenizerFast</code> (HerBERT model)</li> <li><strong>hubert</strong> — <code>Wav2Vec2CTCTokenizer</code> (Hubert model)</li> <li><strong>ibert</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (I-BERT model)</li> <li><strong>idefics</strong> — <code>LlamaTokenizerFast</code> (IDEFICS model)</li> <li><strong>instructblip</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (InstructBLIP model)</li> <li><strong>jukebox</strong> — <code>JukeboxTokenizer</code> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <code>XLMRobertaTokenizer</code> or <code>XLMRobertaTokenizerFast</code> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMTokenizer</code> or <code>LayoutLMTokenizerFast</code> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2Tokenizer</code> or <code>LayoutLMv2TokenizerFast</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3Tokenizer</code> or <code>LayoutLMv3TokenizerFast</code> (LayoutLMv3 model)</li> <li><strong>layoutxlm</strong> — <code>LayoutXLMTokenizer</code> or <code>LayoutXLMTokenizerFast</code> (LayoutXLM model)</li> <li><strong>led</strong> — <code>LEDTokenizer</code> or <code>LEDTokenizerFast</code> (LED model)</li> <li><strong>lilt</strong> — <code>LayoutLMv3Tokenizer</code> or <code>LayoutLMv3TokenizerFast</code> (LiLT model)</li> <li><strong>llama</strong> — <code>LlamaTokenizer</code> or <code>LlamaTokenizerFast</code> (LLaMA model)</li> <li><strong>llava</strong> — <code>LlamaTokenizer</code> or <code>LlamaTokenizerFast</code> (LLaVa model)</li> <li><strong>longformer</strong> — <code>LongformerTokenizer</code> or <code>LongformerTokenizerFast</code> (Longformer model)</li> <li><strong>longt5</strong> — <code>T5Tokenizer</code> or <code>T5TokenizerFast</code> (LongT5 model)</li> <li><strong>luke</strong> — <code>LukeTokenizer</code> (LUKE model)</li> <li><strong>lxmert</strong> — <code>LxmertTokenizer</code> or <code>LxmertTokenizerFast</code> (LXMERT model)</li> <li><strong>m2m_100</strong> — <code>M2M100Tokenizer</code> (M2M100 model)</li> <li><strong>mamba</strong> — <code>GPTNeoXTokenizerFast</code> (Mamba model)</li> <li><strong>marian</strong> — <code>MarianTokenizer</code> (Marian model)</li> <li><strong>mbart</strong> — <code>MBartTokenizer</code> or <code>MBartTokenizerFast</code> (mBART model)</li> <li><strong>mbart50</strong> — <code>MBart50Tokenizer</code> or <code>MBart50TokenizerFast</code> (mBART-50 model)</li> <li><strong>mega</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <code>MgpstrTokenizer</code> (MGP-STR model)</li> <li><strong>mistral</strong> — <code>LlamaTokenizer</code> or <code>LlamaTokenizerFast</code> (Mistral model)</li> <li><strong>mixtral</strong> — <code>LlamaTokenizer</code> or <code>LlamaTokenizerFast</code> (Mixtral model)</li> <li><strong>mluke</strong> — <code>MLukeTokenizer</code> (mLUKE model)</li> <li><strong>mobilebert</strong> — <code>MobileBertTokenizer</code> or <code>MobileBertTokenizerFast</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetTokenizer</code> or <code>MPNetTokenizerFast</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>GPTNeoXTokenizerFast</code> (MPT model)</li> <li><strong>mra</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (MRA model)</li> <li><strong>mt5</strong> — <code>MT5Tokenizer</code> or <code>MT5TokenizerFast</code> (MT5 model)</li> <li><strong>musicgen</strong> — <code>T5Tokenizer</code> or <code>T5TokenizerFast</code> (MusicGen model)</li> <li><strong>mvp</strong> — <code>MvpTokenizer</code> or <code>MvpTokenizerFast</code> (MVP model)</li> <li><strong>nezha</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (Nezha model)</li> <li><strong>nllb</strong> — <code>NllbTokenizer</code> or <code>NllbTokenizerFast</code> (NLLB model)</li> <li><strong>nllb-moe</strong> — <code>NllbTokenizer</code> or <code>NllbTokenizerFast</code> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OneFormer model)</li> <li><strong>openai-gpt</strong> — <code>OpenAIGPTTokenizer</code> or <code>OpenAIGPTTokenizerFast</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (OPT model)</li> <li><strong>owlv2</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWLv2 model)</li> <li><strong>owlvit</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (OWL-ViT model)</li> <li><strong>pegasus</strong> — <code>PegasusTokenizer</code> or <code>PegasusTokenizerFast</code> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <code>PegasusTokenizer</code> or <code>PegasusTokenizerFast</code> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <code>PerceiverTokenizer</code> (Perceiver model)</li> <li><strong>persimmon</strong> — <code>LlamaTokenizer</code> or <code>LlamaTokenizerFast</code> (Persimmon model)</li> <li><strong>phi</strong> — <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenTokenizerFast">CodeGenTokenizerFast</a> (Phi model)</li> <li><strong>phobert</strong> — <code>PhobertTokenizer</code> (PhoBERT model)</li> <li><strong>pix2struct</strong> — <code>T5Tokenizer</code> or <code>T5TokenizerFast</code> (Pix2Struct model)</li> <li><strong>plbart</strong> — <code>PLBartTokenizer</code> (PLBart model)</li> <li><strong>prophetnet</strong> — <code>ProphetNetTokenizer</code> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (QDQBert model)</li> <li><strong>qwen2</strong> — <code>Qwen2Tokenizer</code> or <code>Qwen2TokenizerFast</code> (Qwen2 model)</li> <li><strong>rag</strong> — <code>RagTokenizer</code> (RAG model)</li> <li><strong>realm</strong> — <code>RealmTokenizer</code> or <code>RealmTokenizerFast</code> (REALM model)</li> <li><strong>reformer</strong> — <code>ReformerTokenizer</code> or <code>ReformerTokenizerFast</code> (Reformer model)</li> <li><strong>rembert</strong> — <code>RemBertTokenizer</code> or <code>RemBertTokenizerFast</code> (RemBERT model)</li> <li><strong>retribert</strong> — <code>RetriBertTokenizer</code> or <code>RetriBertTokenizerFast</code> (RetriBERT model)</li> <li><strong>roberta</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaTokenizer</code> or <code>RobertaTokenizerFast</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertTokenizer</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerTokenizer</code> or <code>RoFormerTokenizerFast</code> (RoFormer model)</li> <li><strong>rwkv</strong> — <code>GPTNeoXTokenizerFast</code> (RWKV model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TTokenizer</code> or <code>SeamlessM4TTokenizerFast</code> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <code>SeamlessM4TTokenizer</code> or <code>SeamlessM4TTokenizerFast</code> (SeamlessM4Tv2 model)</li> <li><strong>siglip</strong> — <code>SiglipTokenizer</code> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <code>Speech2TextTokenizer</code> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <code>Speech2Text2Tokenizer</code> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <code>SpeechT5Tokenizer</code> (SpeechT5 model)</li> <li><strong>splinter</strong> — <code>SplinterTokenizer</code> or <code>SplinterTokenizerFast</code> (Splinter model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertTokenizer</code> or <code>SqueezeBertTokenizerFast</code> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <code>GPTNeoXTokenizerFast</code> (StableLm model)</li> <li><strong>starcoder2</strong> — <code>GPT2Tokenizer</code> or <code>GPT2TokenizerFast</code> (Starcoder2 model)</li> <li><strong>switch_transformers</strong> — <code>T5Tokenizer</code> or <code>T5TokenizerFast</code> (SwitchTransformers model)</li> <li><strong>t5</strong> — <code>T5Tokenizer</code> or <code>T5TokenizerFast</code> (T5 model)</li> <li><strong>tapas</strong> — <code>TapasTokenizer</code> (TAPAS model)</li> <li><strong>tapex</strong> — <code>TapexTokenizer</code> (TAPEX model)</li> <li><strong>transfo-xl</strong> — <code>TransfoXLTokenizer</code> (Transformer-XL model)</li> <li><strong>tvp</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (TVP model)</li> <li><strong>udop</strong> — <code>UdopTokenizer</code> or <code>UdopTokenizerFast</code> (UDOP model)</li> <li><strong>umt5</strong> — <code>T5Tokenizer</code> or <code>T5TokenizerFast</code> (UMT5 model)</li> <li><strong>vilt</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (ViLT model)</li> <li><strong>vipllava</strong> — <code>LlamaTokenizer</code> or <code>LlamaTokenizerFast</code> (VipLlava model)</li> <li><strong>visual_bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertTokenizerFast">BertTokenizerFast</a> (VisualBERT model)</li> <li><strong>vits</strong> — <code>VitsTokenizer</code> (VITS model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2CTCTokenizer</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2CTCTokenizer</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2CTCTokenizer</code> (Wav2Vec2-Conformer model)</li> <li><strong>wav2vec2_phoneme</strong> — <code>Wav2Vec2PhonemeCTCTokenizer</code> (Wav2Vec2Phoneme model)</li> <li><strong>whisper</strong> — <code>WhisperTokenizer</code> or <code>WhisperTokenizerFast</code> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> (X-CLIP model)</li> <li><strong>xglm</strong> — <code>XGLMTokenizer</code> or <code>XGLMTokenizerFast</code> (XGLM model)</li> <li><strong>xlm</strong> — <code>XLMTokenizer</code> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <code>XLMProphetNetTokenizer</code> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaTokenizer</code> or <code>XLMRobertaTokenizerFast</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaTokenizer</code> or <code>XLMRobertaTokenizerFast</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetTokenizer</code> or <code>XLNetTokenizerFast</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XLMRobertaTokenizer</code> or <code>XLMRobertaTokenizerFast</code> (X-MOD model)</li> <li><strong>yoso</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertTokenizer">AlbertTokenizer</a> or <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertTokenizerFast">AlbertTokenizerFast</a> (YOSO model)</li>',Oj,js,Kj,xs,Vd,ex,wu,rS="Register a new tokenizer in this mapping.",EC,Sd,IC,fe,Ed,ox,ju,aS=`This is a generic feature extractor class that will be instantiated as one of the feature extractor classes of the
library when created with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoFeatureExtractor.from_pretrained">AutoFeatureExtractor.from_pretrained()</a> class method.`,tx,xu,sS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",nx,A,Id,rx,$u,iS="Instantiate one of the feature extractor classes of the library from a pretrained model vocabulary.",ax,ku,lS=`The feature extractor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sx,Zu,dS='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/audio-spectrogram-transformer#transformers.ASTFeatureExtractor">ASTFeatureExtractor</a> (Audio Spectrogram Transformer model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (BEiT model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPFeatureExtractor">ChineseCLIPFeatureExtractor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/ja/model_doc/clap#transformers.ClapFeatureExtractor">ClapFeatureExtractor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <code>ViTFeatureExtractor</code> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpFeatureExtractor">ClvpFeatureExtractor</a> (CLVP model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrFeatureExtractor">ConditionalDetrFeatureExtractor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ConvNeXT model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <code>Wav2Vec2FeatureExtractor</code> (Data2VecAudio model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitFeatureExtractor">BeitFeatureExtractor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrFeatureExtractor">DeformableDetrFeatureExtractor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTFeatureExtractor">DeiTFeatureExtractor</a> (DeiT model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (DETR model)</li> <li><strong>dinat</strong> — <code>ViTFeatureExtractor</code> (DiNAT model)</li> <li><strong>donut-swin</strong> — <code>DonutFeatureExtractor</code> (DonutSwin model)</li> <li><strong>dpt</strong> — <code>DPTFeatureExtractor</code> (DPT model)</li> <li><strong>encodec</strong> — <code>EncodecFeatureExtractor</code> (EnCodec model)</li> <li><strong>flava</strong> — <code>FlavaFeatureExtractor</code> (FLAVA model)</li> <li><strong>glpn</strong> — <code>GLPNFeatureExtractor</code> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <code>Wav2Vec2FeatureExtractor</code> (Hubert model)</li> <li><strong>imagegpt</strong> — <code>ImageGPTFeatureExtractor</code> (ImageGPT model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2FeatureExtractor</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3FeatureExtractor</code> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <code>LevitFeatureExtractor</code> (LeViT model)</li> <li><strong>maskformer</strong> — <code>MaskFormerFeatureExtractor</code> (MaskFormer model)</li> <li><strong>mctct</strong> — <code>MCTCTFeatureExtractor</code> (M-CTC-T model)</li> <li><strong>mobilenet_v1</strong> — <code>MobileNetV1FeatureExtractor</code> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <code>MobileNetV2FeatureExtractor</code> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <code>MobileViTFeatureExtractor</code> (MobileViT model)</li> <li><strong>nat</strong> — <code>ViTFeatureExtractor</code> (NAT model)</li> <li><strong>owlvit</strong> — <code>OwlViTFeatureExtractor</code> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <code>PerceiverFeatureExtractor</code> (Perceiver model)</li> <li><strong>poolformer</strong> — <code>PoolFormerFeatureExtractor</code> (PoolFormer model)</li> <li><strong>pop2piano</strong> — <code>Pop2PianoFeatureExtractor</code> (Pop2Piano model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (ResNet model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TFeatureExtractor</code> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <code>SeamlessM4TFeatureExtractor</code> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <code>SegformerFeatureExtractor</code> (SegFormer model)</li> <li><strong>sew</strong> — <code>Wav2Vec2FeatureExtractor</code> (SEW model)</li> <li><strong>sew-d</strong> — <code>Wav2Vec2FeatureExtractor</code> (SEW-D model)</li> <li><strong>speech_to_text</strong> — <code>Speech2TextFeatureExtractor</code> (Speech2Text model)</li> <li><strong>speecht5</strong> — <code>SpeechT5FeatureExtractor</code> (SpeechT5 model)</li> <li><strong>swiftformer</strong> — <code>ViTFeatureExtractor</code> (SwiftFormer model)</li> <li><strong>swin</strong> — <code>ViTFeatureExtractor</code> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <code>ViTFeatureExtractor</code> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrFeatureExtractor">DetrFeatureExtractor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <code>VideoMAEFeatureExtractor</code> (TimeSformer model)</li> <li><strong>tvlt</strong> — <code>TvltFeatureExtractor</code> (TVLT model)</li> <li><strong>unispeech</strong> — <code>Wav2Vec2FeatureExtractor</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>Wav2Vec2FeatureExtractor</code> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <code>UnivNetFeatureExtractor</code> (UnivNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextFeatureExtractor">ConvNextFeatureExtractor</a> (VAN model)</li> <li><strong>videomae</strong> — <code>VideoMAEFeatureExtractor</code> (VideoMAE model)</li> <li><strong>vilt</strong> — <code>ViltFeatureExtractor</code> (ViLT model)</li> <li><strong>vit</strong> — <code>ViTFeatureExtractor</code> (ViT model)</li> <li><strong>vit_mae</strong> — <code>ViTFeatureExtractor</code> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <code>ViTFeatureExtractor</code> (ViTMSN model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2FeatureExtractor</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2FeatureExtractor</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2FeatureExtractor</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>Wav2Vec2FeatureExtractor</code> (WavLM model)</li> <li><strong>whisper</strong> — <code>WhisperFeatureExtractor</code> (Whisper model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPFeatureExtractor">CLIPFeatureExtractor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <code>YolosFeatureExtractor</code> (YOLOS model)</li>',ix,$s,lx,ks,dx,Zs,Ud,cx,Au,cS="Register a new feature extractor for this class.",UC,Pd,PC,ge,qd,mx,Lu,mS=`This is a generic image processor class that will be instantiated as one of the image processor classes of the
library when created with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoImageProcessor.from_pretrained">AutoImageProcessor.from_pretrained()</a> class method.`,fx,Bu,fS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gx,L,Nd,px,Ru,gS="Instantiate one of the image processor classes of the library from a pretrained model vocabulary.",ux,Wu,pS=`The image processor class to instantiate is selected based on the <code>model_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s
missing, by falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,hx,Ju,uS='<li><strong>align</strong> — <code>EfficientNetImageProcessor</code> (ALIGN model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (BiT model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/ja/model_doc/bridgetower#transformers.BridgeTowerImageProcessor">BridgeTowerImageProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPImageProcessor">ChineseCLIPImageProcessor</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <code>ViTImageProcessor</code> (CLIPSeg model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrImageProcessor">ConditionalDetrImageProcessor</a> (Conditional DETR model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> (Data2VecVision model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrImageProcessor">DeformableDetrImageProcessor</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTImageProcessor">DeiTImageProcessor</a> (DeiT model)</li> <li><strong>depth_anything</strong> — <code>DPTImageProcessor</code> (Depth Anything model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/ja/model_doc/deta#transformers.DetaImageProcessor">DetaImageProcessor</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (DETR model)</li> <li><strong>dinat</strong> — <code>ViTImageProcessor</code> (DiNAT model)</li> <li><strong>dinov2</strong> — <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (DINOv2 model)</li> <li><strong>donut-swin</strong> — <code>DonutImageProcessor</code> (DonutSwin model)</li> <li><strong>dpt</strong> — <code>DPTImageProcessor</code> (DPT model)</li> <li><strong>efficientformer</strong> — <code>EfficientFormerImageProcessor</code> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <code>EfficientNetImageProcessor</code> (EfficientNet model)</li> <li><strong>flava</strong> — <code>FlavaImageProcessor</code> (FLAVA model)</li> <li><strong>focalnet</strong> — <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitImageProcessor">BitImageProcessor</a> (FocalNet model)</li> <li><strong>fuyu</strong> — <code>FuyuImageProcessor</code> (Fuyu model)</li> <li><strong>git</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GIT model)</li> <li><strong>glpn</strong> — <code>GLPNImageProcessor</code> (GLPN model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (GroupViT model)</li> <li><strong>idefics</strong> — <code>IdeficsImageProcessor</code> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <code>ImageGPTImageProcessor</code> (ImageGPT model)</li> <li><strong>instructblip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipImageProcessor">BlipImageProcessor</a> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2ImageProcessor</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3ImageProcessor</code> (LayoutLMv3 model)</li> <li><strong>levit</strong> — <code>LevitImageProcessor</code> (LeViT model)</li> <li><strong>llava</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (LLaVa model)</li> <li><strong>mask2former</strong> — <code>Mask2FormerImageProcessor</code> (Mask2Former model)</li> <li><strong>maskformer</strong> — <code>MaskFormerImageProcessor</code> (MaskFormer model)</li> <li><strong>mgp-str</strong> — <code>ViTImageProcessor</code> (MGP-STR model)</li> <li><strong>mobilenet_v1</strong> — <code>MobileNetV1ImageProcessor</code> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <code>MobileNetV2ImageProcessor</code> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <code>MobileViTImageProcessor</code> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <code>MobileViTImageProcessor</code> (MobileViTV2 model)</li> <li><strong>nat</strong> — <code>ViTImageProcessor</code> (NAT model)</li> <li><strong>nougat</strong> — <code>NougatImageProcessor</code> (Nougat model)</li> <li><strong>oneformer</strong> — <code>OneFormerImageProcessor</code> (OneFormer model)</li> <li><strong>owlv2</strong> — <code>Owlv2ImageProcessor</code> (OWLv2 model)</li> <li><strong>owlvit</strong> — <code>OwlViTImageProcessor</code> (OWL-ViT model)</li> <li><strong>perceiver</strong> — <code>PerceiverImageProcessor</code> (Perceiver model)</li> <li><strong>pix2struct</strong> — <code>Pix2StructImageProcessor</code> (Pix2Struct model)</li> <li><strong>poolformer</strong> — <code>PoolFormerImageProcessor</code> (PoolFormer model)</li> <li><strong>pvt</strong> — <code>PvtImageProcessor</code> (PVT model)</li> <li><strong>pvt_v2</strong> — <code>PvtImageProcessor</code> (PVTv2 model)</li> <li><strong>regnet</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (RegNet model)</li> <li><strong>resnet</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (ResNet model)</li> <li><strong>sam</strong> — <code>SamImageProcessor</code> (SAM model)</li> <li><strong>segformer</strong> — <code>SegformerImageProcessor</code> (SegFormer model)</li> <li><strong>seggpt</strong> — <code>SegGptImageProcessor</code> (SegGPT model)</li> <li><strong>siglip</strong> — <code>SiglipImageProcessor</code> (SigLIP model)</li> <li><strong>swiftformer</strong> — <code>ViTImageProcessor</code> (SwiftFormer model)</li> <li><strong>swin</strong> — <code>ViTImageProcessor</code> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <code>Swin2SRImageProcessor</code> (Swin2SR model)</li> <li><strong>swinv2</strong> — <code>ViTImageProcessor</code> (Swin Transformer V2 model)</li> <li><strong>table-transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrImageProcessor">DetrImageProcessor</a> (Table Transformer model)</li> <li><strong>timesformer</strong> — <code>VideoMAEImageProcessor</code> (TimeSformer model)</li> <li><strong>tvlt</strong> — <code>TvltImageProcessor</code> (TVLT model)</li> <li><strong>tvp</strong> — <code>TvpImageProcessor</code> (TVP model)</li> <li><strong>udop</strong> — <code>LayoutLMv3ImageProcessor</code> (UDOP model)</li> <li><strong>upernet</strong> — <code>SegformerImageProcessor</code> (UPerNet model)</li> <li><strong>van</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextImageProcessor">ConvNextImageProcessor</a> (VAN model)</li> <li><strong>videomae</strong> — <code>VideoMAEImageProcessor</code> (VideoMAE model)</li> <li><strong>vilt</strong> — <code>ViltImageProcessor</code> (ViLT model)</li> <li><strong>vipllava</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (VipLlava model)</li> <li><strong>vit</strong> — <code>ViTImageProcessor</code> (ViT model)</li> <li><strong>vit_hybrid</strong> — <code>ViTHybridImageProcessor</code> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <code>ViTImageProcessor</code> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <code>ViTImageProcessor</code> (ViTMSN model)</li> <li><strong>vitmatte</strong> — <code>VitMatteImageProcessor</code> (ViTMatte model)</li> <li><strong>xclip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> (X-CLIP model)</li> <li><strong>yolos</strong> — <code>YolosImageProcessor</code> (YOLOS model)</li>',bx,As,_x,Ls,Mx,Bs,Xd,Tx,Gu,hS="Register a new image processor for this class.",qC,Dd,NC,pe,Hd,yx,Vu,bS=`This is a generic processor class that will be instantiated as one of the processor classes of the library when
created with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoProcessor.from_pretrained">AutoProcessor.from_pretrained()</a> class method.`,Fx,Su,_S="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",vx,B,Qd,Cx,Eu,MS="Instantiate one of the processor classes of the library from a pretrained model vocabulary.",wx,Iu,TS=`The processor class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible):`,jx,Uu,yS='<li><strong>align</strong> — <a href="/docs/transformers/main/ja/model_doc/align#transformers.AlignProcessor">AlignProcessor</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/ja/model_doc/altclip#transformers.AltCLIPProcessor">AltCLIPProcessor</a> (AltCLIP model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/ja/model_doc/bark#transformers.BarkProcessor">BarkProcessor</a> (Bark model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipProcessor">BlipProcessor</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2Processor">Blip2Processor</a> (BLIP-2 model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/ja/model_doc/bridgetower#transformers.BridgeTowerProcessor">BridgeTowerProcessor</a> (BridgeTower model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPProcessor">ChineseCLIPProcessor</a> (Chinese-CLIP model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/ja/model_doc/clap#transformers.ClapProcessor">ClapProcessor</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/ja/model_doc/clipseg#transformers.CLIPSegProcessor">CLIPSegProcessor</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpProcessor">ClvpProcessor</a> (CLVP model)</li> <li><strong>flava</strong> — <code>FlavaProcessor</code> (FLAVA model)</li> <li><strong>fuyu</strong> — <code>FuyuProcessor</code> (Fuyu model)</li> <li><strong>git</strong> — <code>GitProcessor</code> (GIT model)</li> <li><strong>groupvit</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPProcessor">CLIPProcessor</a> (GroupViT model)</li> <li><strong>hubert</strong> — <code>Wav2Vec2Processor</code> (Hubert model)</li> <li><strong>idefics</strong> — <code>IdeficsProcessor</code> (IDEFICS model)</li> <li><strong>instructblip</strong> — <code>InstructBlipProcessor</code> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <code>Kosmos2Processor</code> (KOSMOS-2 model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2Processor</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3Processor</code> (LayoutLMv3 model)</li> <li><strong>llava</strong> — <code>LlavaProcessor</code> (LLaVa model)</li> <li><strong>markuplm</strong> — <code>MarkupLMProcessor</code> (MarkupLM model)</li> <li><strong>mctct</strong> — <code>MCTCTProcessor</code> (M-CTC-T model)</li> <li><strong>mgp-str</strong> — <code>MgpstrProcessor</code> (MGP-STR model)</li> <li><strong>oneformer</strong> — <code>OneFormerProcessor</code> (OneFormer model)</li> <li><strong>owlv2</strong> — <code>Owlv2Processor</code> (OWLv2 model)</li> <li><strong>owlvit</strong> — <code>OwlViTProcessor</code> (OWL-ViT model)</li> <li><strong>pix2struct</strong> — <code>Pix2StructProcessor</code> (Pix2Struct model)</li> <li><strong>pop2piano</strong> — <code>Pop2PianoProcessor</code> (Pop2Piano model)</li> <li><strong>sam</strong> — <code>SamProcessor</code> (SAM model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TProcessor</code> (SeamlessM4T model)</li> <li><strong>sew</strong> — <code>Wav2Vec2Processor</code> (SEW model)</li> <li><strong>sew-d</strong> — <code>Wav2Vec2Processor</code> (SEW-D model)</li> <li><strong>siglip</strong> — <code>SiglipProcessor</code> (SigLIP model)</li> <li><strong>speech_to_text</strong> — <code>Speech2TextProcessor</code> (Speech2Text model)</li> <li><strong>speech_to_text_2</strong> — <code>Speech2Text2Processor</code> (Speech2Text2 model)</li> <li><strong>speecht5</strong> — <code>SpeechT5Processor</code> (SpeechT5 model)</li> <li><strong>trocr</strong> — <code>TrOCRProcessor</code> (TrOCR model)</li> <li><strong>tvlt</strong> — <code>TvltProcessor</code> (TVLT model)</li> <li><strong>tvp</strong> — <code>TvpProcessor</code> (TVP model)</li> <li><strong>unispeech</strong> — <code>Wav2Vec2Processor</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>Wav2Vec2Processor</code> (UniSpeechSat model)</li> <li><strong>vilt</strong> — <code>ViltProcessor</code> (ViLT model)</li> <li><strong>vipllava</strong> — <code>LlavaProcessor</code> (VipLlava model)</li> <li><strong>vision-text-dual-encoder</strong> — <code>VisionTextDualEncoderProcessor</code> (VisionTextDualEncoder model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2Processor</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2Processor</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2Processor</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>Wav2Vec2Processor</code> (WavLM model)</li> <li><strong>whisper</strong> — <code>WhisperProcessor</code> (Whisper model)</li> <li><strong>xclip</strong> — <code>XCLIPProcessor</code> (X-CLIP model)</li>',xx,Rs,$x,Ws,kx,Js,Yd,Zx,Pu,FS="Register a new processor for this class.",XC,zd,DC,Od,vS="以下の自動クラスは、特定のヘッドを持たないベースモデルクラスをインスタンス化するために利用可能です。",HC,Kd,QC,ue,ec,Ax,qu,CS=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Lx,Nu,wS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Bx,Gn,oc,Rx,Xu,jS="Instantiates one of the base model classes of the library from a configuration.",Wx,Du,xS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Jx,Gs,Gx,R,tc,Vx,Hu,$S="Instantiate one of the base model classes of the library from a pretrained model.",Sx,Qu,kS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Ex,Yu,ZS='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li> <li><strong>align</strong> — <a href="/docs/transformers/main/ja/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/ja/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li> <li><strong>autoformer</strong> — <a href="/docs/transformers/main/ja/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li> <li><strong>bark</strong> — <a href="/docs/transformers/main/ja/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li> <li><strong>bridgetower</strong> — <a href="/docs/transformers/main/ja/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/ja/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>chinese_clip_vision_model</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPVisionModel">ChineseCLIPVisionModel</a> (ChineseCLIPVisionModel model)</li> <li><strong>clap</strong> — <a href="/docs/transformers/main/ja/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clip_vision_model</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/ja/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>clvp</strong> — <a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li> <li><strong>code_llama</strong> — <code>LlamaModel</code> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li> <li><strong>cohere</strong> — <code>CohereModel</code> (Cohere model)</li> <li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>decision_transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/ja/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/ja/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <code>Dinov2Model</code> (DINOv2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertModel</code> (DistilBERT model)</li> <li><strong>donut-swin</strong> — <code>DonutSwinModel</code> (DonutSwin model)</li> <li><strong>dpr</strong> — <code>DPRQuestionEncoder</code> (DPR model)</li> <li><strong>dpt</strong> — <code>DPTModel</code> (DPT model)</li> <li><strong>efficientformer</strong> — <code>EfficientFormerModel</code> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <code>EfficientNetModel</code> (EfficientNet model)</li> <li><strong>electra</strong> — <code>ElectraModel</code> (ELECTRA model)</li> <li><strong>encodec</strong> — <code>EncodecModel</code> (EnCodec model)</li> <li><strong>ernie</strong> — <code>ErnieModel</code> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMModel</code> (ErnieM model)</li> <li><strong>esm</strong> — <code>EsmModel</code> (ESM model)</li> <li><strong>falcon</strong> — <code>FalconModel</code> (Falcon model)</li> <li><strong>fastspeech2_conformer</strong> — <code>FastSpeech2ConformerModel</code> (FastSpeech2Conformer model)</li> <li><strong>flaubert</strong> — <code>FlaubertModel</code> (FlauBERT model)</li> <li><strong>flava</strong> — <code>FlavaModel</code> (FLAVA model)</li> <li><strong>fnet</strong> — <code>FNetModel</code> (FNet model)</li> <li><strong>focalnet</strong> — <code>FocalNetModel</code> (FocalNet model)</li> <li><strong>fsmt</strong> — <code>FSMTModel</code> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <code>FunnelModel</code> or <code>FunnelBaseModel</code> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <code>GemmaModel</code> (Gemma model)</li> <li><strong>git</strong> — <code>GitModel</code> (GIT model)</li> <li><strong>glpn</strong> — <code>GLPNModel</code> (GLPN model)</li> <li><strong>gpt-sw3</strong> — <code>GPT2Model</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2Model</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPTBigCodeModel</code> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <code>GPTNeoModel</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXModel</code> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <code>GPTNeoXJapaneseModel</code> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <code>GPTJModel</code> (GPT-J model)</li> <li><strong>gptsan-japanese</strong> — <code>GPTSanJapaneseForConditionalGeneration</code> (GPTSAN-japanese model)</li> <li><strong>graphormer</strong> — <code>GraphormerModel</code> (Graphormer model)</li> <li><strong>groupvit</strong> — <code>GroupViTModel</code> (GroupViT model)</li> <li><strong>hubert</strong> — <code>HubertModel</code> (Hubert model)</li> <li><strong>ibert</strong> — <code>IBertModel</code> (I-BERT model)</li> <li><strong>idefics</strong> — <code>IdeficsModel</code> (IDEFICS model)</li> <li><strong>imagegpt</strong> — <code>ImageGPTModel</code> (ImageGPT model)</li> <li><strong>informer</strong> — <code>InformerModel</code> (Informer model)</li> <li><strong>jukebox</strong> — <code>JukeboxModel</code> (Jukebox model)</li> <li><strong>kosmos-2</strong> — <code>Kosmos2Model</code> (KOSMOS-2 model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMModel</code> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2Model</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3Model</code> (LayoutLMv3 model)</li> <li><strong>led</strong> — <code>LEDModel</code> (LED model)</li> <li><strong>levit</strong> — <code>LevitModel</code> (LeViT model)</li> <li><strong>lilt</strong> — <code>LiltModel</code> (LiLT model)</li> <li><strong>llama</strong> — <code>LlamaModel</code> (LLaMA model)</li> <li><strong>longformer</strong> — <code>LongformerModel</code> (Longformer model)</li> <li><strong>longt5</strong> — <code>LongT5Model</code> (LongT5 model)</li> <li><strong>luke</strong> — <code>LukeModel</code> (LUKE model)</li> <li><strong>lxmert</strong> — <code>LxmertModel</code> (LXMERT model)</li> <li><strong>m2m_100</strong> — <code>M2M100Model</code> (M2M100 model)</li> <li><strong>mamba</strong> — <code>MambaModel</code> (Mamba model)</li> <li><strong>marian</strong> — <code>MarianModel</code> (Marian model)</li> <li><strong>markuplm</strong> — <code>MarkupLMModel</code> (MarkupLM model)</li> <li><strong>mask2former</strong> — <code>Mask2FormerModel</code> (Mask2Former model)</li> <li><strong>maskformer</strong> — <code>MaskFormerModel</code> (MaskFormer model)</li> <li><strong>maskformer-swin</strong> — <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li> <li><strong>mbart</strong> — <code>MBartModel</code> (mBART model)</li> <li><strong>mctct</strong> — <code>MCTCTModel</code> (M-CTC-T model)</li> <li><strong>mega</strong> — <code>MegaModel</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertModel</code> (Megatron-BERT model)</li> <li><strong>mgp-str</strong> — <code>MgpstrForSceneTextRecognition</code> (MGP-STR model)</li> <li><strong>mistral</strong> — <code>MistralModel</code> (Mistral model)</li> <li><strong>mixtral</strong> — <code>MixtralModel</code> (Mixtral model)</li> <li><strong>mobilebert</strong> — <code>MobileBertModel</code> (MobileBERT model)</li> <li><strong>mobilenet_v1</strong> — <code>MobileNetV1Model</code> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <code>MobileNetV2Model</code> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <code>MobileViTModel</code> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <code>MobileViTV2Model</code> (MobileViTV2 model)</li> <li><strong>mpnet</strong> — <code>MPNetModel</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>MptModel</code> (MPT model)</li> <li><strong>mra</strong> — <code>MraModel</code> (MRA model)</li> <li><strong>mt5</strong> — <code>MT5Model</code> (MT5 model)</li> <li><strong>mvp</strong> — <code>MvpModel</code> (MVP model)</li> <li><strong>nat</strong> — <code>NatModel</code> (NAT model)</li> <li><strong>nezha</strong> — <code>NezhaModel</code> (Nezha model)</li> <li><strong>nllb-moe</strong> — <code>NllbMoeModel</code> (NLLB-MOE model)</li> <li><strong>nystromformer</strong> — <code>NystromformerModel</code> (Nyströmformer model)</li> <li><strong>oneformer</strong> — <code>OneFormerModel</code> (OneFormer model)</li> <li><strong>open-llama</strong> — <code>OpenLlamaModel</code> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <code>OpenAIGPTModel</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>OPTModel</code> (OPT model)</li> <li><strong>owlv2</strong> — <code>Owlv2Model</code> (OWLv2 model)</li> <li><strong>owlvit</strong> — <code>OwlViTModel</code> (OWL-ViT model)</li> <li><strong>patchtsmixer</strong> — <code>PatchTSMixerModel</code> (PatchTSMixer model)</li> <li><strong>patchtst</strong> — <code>PatchTSTModel</code> (PatchTST model)</li> <li><strong>pegasus</strong> — <code>PegasusModel</code> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <code>PegasusXModel</code> (PEGASUS-X model)</li> <li><strong>perceiver</strong> — <code>PerceiverModel</code> (Perceiver model)</li> <li><strong>persimmon</strong> — <code>PersimmonModel</code> (Persimmon model)</li> <li><strong>phi</strong> — <code>PhiModel</code> (Phi model)</li> <li><strong>plbart</strong> — <code>PLBartModel</code> (PLBart model)</li> <li><strong>poolformer</strong> — <code>PoolFormerModel</code> (PoolFormer model)</li> <li><strong>prophetnet</strong> — <code>ProphetNetModel</code> (ProphetNet model)</li> <li><strong>pvt</strong> — <code>PvtModel</code> (PVT model)</li> <li><strong>pvt_v2</strong> — <code>PvtV2Model</code> (PVTv2 model)</li> <li><strong>qdqbert</strong> — <code>QDQBertModel</code> (QDQBert model)</li> <li><strong>qwen2</strong> — <code>Qwen2Model</code> (Qwen2 model)</li> <li><strong>reformer</strong> — <code>ReformerModel</code> (Reformer model)</li> <li><strong>regnet</strong> — <code>RegNetModel</code> (RegNet model)</li> <li><strong>rembert</strong> — <code>RemBertModel</code> (RemBERT model)</li> <li><strong>resnet</strong> — <code>ResNetModel</code> (ResNet model)</li> <li><strong>retribert</strong> — <code>RetriBertModel</code> (RetriBERT model)</li> <li><strong>roberta</strong> — <code>RobertaModel</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormModel</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertModel</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerModel</code> (RoFormer model)</li> <li><strong>rwkv</strong> — <code>RwkvModel</code> (RWKV model)</li> <li><strong>sam</strong> — <code>SamModel</code> (SAM model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TModel</code> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <code>SeamlessM4Tv2Model</code> (SeamlessM4Tv2 model)</li> <li><strong>segformer</strong> — <code>SegformerModel</code> (SegFormer model)</li> <li><strong>seggpt</strong> — <code>SegGptModel</code> (SegGPT model)</li> <li><strong>sew</strong> — <code>SEWModel</code> (SEW model)</li> <li><strong>sew-d</strong> — <code>SEWDModel</code> (SEW-D model)</li> <li><strong>siglip</strong> — <code>SiglipModel</code> (SigLIP model)</li> <li><strong>siglip_vision_model</strong> — <code>SiglipVisionModel</code> (SiglipVisionModel model)</li> <li><strong>speech_to_text</strong> — <code>Speech2TextModel</code> (Speech2Text model)</li> <li><strong>speecht5</strong> — <code>SpeechT5Model</code> (SpeechT5 model)</li> <li><strong>splinter</strong> — <code>SplinterModel</code> (Splinter model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertModel</code> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <code>StableLmModel</code> (StableLm model)</li> <li><strong>starcoder2</strong> — <code>Starcoder2Model</code> (Starcoder2 model)</li> <li><strong>swiftformer</strong> — <code>SwiftFormerModel</code> (SwiftFormer model)</li> <li><strong>swin</strong> — <code>SwinModel</code> (Swin Transformer model)</li> <li><strong>swin2sr</strong> — <code>Swin2SRModel</code> (Swin2SR model)</li> <li><strong>swinv2</strong> — <code>Swinv2Model</code> (Swin Transformer V2 model)</li> <li><strong>switch_transformers</strong> — <code>SwitchTransformersModel</code> (SwitchTransformers model)</li> <li><strong>t5</strong> — <code>T5Model</code> (T5 model)</li> <li><strong>table-transformer</strong> — <code>TableTransformerModel</code> (Table Transformer model)</li> <li><strong>tapas</strong> — <code>TapasModel</code> (TAPAS model)</li> <li><strong>time_series_transformer</strong> — <code>TimeSeriesTransformerModel</code> (Time Series Transformer model)</li> <li><strong>timesformer</strong> — <code>TimesformerModel</code> (TimeSformer model)</li> <li><strong>timm_backbone</strong> — <code>TimmBackbone</code> (TimmBackbone model)</li> <li><strong>trajectory_transformer</strong> — <code>TrajectoryTransformerModel</code> (Trajectory Transformer model)</li> <li><strong>transfo-xl</strong> — <code>TransfoXLModel</code> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <code>TvltModel</code> (TVLT model)</li> <li><strong>tvp</strong> — <code>TvpModel</code> (TVP model)</li> <li><strong>udop</strong> — <code>UdopModel</code> (UDOP model)</li> <li><strong>umt5</strong> — <code>UMT5Model</code> (UMT5 model)</li> <li><strong>unispeech</strong> — <code>UniSpeechModel</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatModel</code> (UniSpeechSat model)</li> <li><strong>univnet</strong> — <code>UnivNetModel</code> (UnivNet model)</li> <li><strong>van</strong> — <code>VanModel</code> (VAN model)</li> <li><strong>videomae</strong> — <code>VideoMAEModel</code> (VideoMAE model)</li> <li><strong>vilt</strong> — <code>ViltModel</code> (ViLT model)</li> <li><strong>vision-text-dual-encoder</strong> — <code>VisionTextDualEncoderModel</code> (VisionTextDualEncoder model)</li> <li><strong>visual_bert</strong> — <code>VisualBertModel</code> (VisualBERT model)</li> <li><strong>vit</strong> — <code>ViTModel</code> (ViT model)</li> <li><strong>vit_hybrid</strong> — <code>ViTHybridModel</code> (ViT Hybrid model)</li> <li><strong>vit_mae</strong> — <code>ViTMAEModel</code> (ViTMAE model)</li> <li><strong>vit_msn</strong> — <code>ViTMSNModel</code> (ViTMSN model)</li> <li><strong>vitdet</strong> — <code>VitDetModel</code> (VitDet model)</li> <li><strong>vits</strong> — <code>VitsModel</code> (VITS model)</li> <li><strong>vivit</strong> — <code>VivitModel</code> (ViViT model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2Model</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2BertModel</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerModel</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>WavLMModel</code> (WavLM model)</li> <li><strong>whisper</strong> — <code>WhisperModel</code> (Whisper model)</li> <li><strong>xclip</strong> — <code>XCLIPModel</code> (X-CLIP model)</li> <li><strong>xglm</strong> — <code>XGLMModel</code> (XGLM model)</li> <li><strong>xlm</strong> — <code>XLMModel</code> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <code>XLMProphetNetModel</code> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaModel</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLModel</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetModel</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodModel</code> (X-MOD model)</li> <li><strong>yolos</strong> — <code>YolosModel</code> (YOLOS model)</li> <li><strong>yoso</strong> — <code>YosoModel</code> (YOSO model)</li>',Ix,zu,AS=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Ux,Vs,YC,nc,zC,he,rc,Px,Ou,LS=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,qx,Ku,BS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Nx,Vn,ac,Xx,eh,RS="Instantiates one of the base model classes of the library from a configuration.",Dx,oh,WS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Hx,Ss,Qx,qo,sc,Yx,th,JS="Instantiate one of the base model classes of the library from a pretrained model.",zx,nh,GS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Ox,rh,VS='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertModel</code> (DistilBERT model)</li> <li><strong>dpr</strong> — <code>TFDPRQuestionEncoder</code> (DPR model)</li> <li><strong>efficientformer</strong> — <code>TFEfficientFormerModel</code> (EfficientFormer model)</li> <li><strong>electra</strong> — <code>TFElectraModel</code> (ELECTRA model)</li> <li><strong>esm</strong> — <code>TFEsmModel</code> (ESM model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertModel</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelModel</code> or <code>TFFunnelBaseModel</code> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <code>TFGPT2Model</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>TFGPT2Model</code> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <code>TFGPTJModel</code> (GPT-J model)</li> <li><strong>groupvit</strong> — <code>TFGroupViTModel</code> (GroupViT model)</li> <li><strong>hubert</strong> — <code>TFHubertModel</code> (Hubert model)</li> <li><strong>layoutlm</strong> — <code>TFLayoutLMModel</code> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <code>TFLayoutLMv3Model</code> (LayoutLMv3 model)</li> <li><strong>led</strong> — <code>TFLEDModel</code> (LED model)</li> <li><strong>longformer</strong> — <code>TFLongformerModel</code> (Longformer model)</li> <li><strong>lxmert</strong> — <code>TFLxmertModel</code> (LXMERT model)</li> <li><strong>marian</strong> — <code>TFMarianModel</code> (Marian model)</li> <li><strong>mbart</strong> — <code>TFMBartModel</code> (mBART model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertModel</code> (MobileBERT model)</li> <li><strong>mobilevit</strong> — <code>TFMobileViTModel</code> (MobileViT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetModel</code> (MPNet model)</li> <li><strong>mt5</strong> — <code>TFMT5Model</code> (MT5 model)</li> <li><strong>openai-gpt</strong> — <code>TFOpenAIGPTModel</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>TFOPTModel</code> (OPT model)</li> <li><strong>pegasus</strong> — <code>TFPegasusModel</code> (Pegasus model)</li> <li><strong>regnet</strong> — <code>TFRegNetModel</code> (RegNet model)</li> <li><strong>rembert</strong> — <code>TFRemBertModel</code> (RemBERT model)</li> <li><strong>resnet</strong> — <code>TFResNetModel</code> (ResNet model)</li> <li><strong>roberta</strong> — <code>TFRobertaModel</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormModel</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerModel</code> (RoFormer model)</li> <li><strong>sam</strong> — <code>TFSamModel</code> (SAM model)</li> <li><strong>segformer</strong> — <code>TFSegformerModel</code> (SegFormer model)</li> <li><strong>speech_to_text</strong> — <code>TFSpeech2TextModel</code> (Speech2Text model)</li> <li><strong>swin</strong> — <code>TFSwinModel</code> (Swin Transformer model)</li> <li><strong>t5</strong> — <code>TFT5Model</code> (T5 model)</li> <li><strong>tapas</strong> — <code>TFTapasModel</code> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <code>TFTransfoXLModel</code> (Transformer-XL model)</li> <li><strong>vision-text-dual-encoder</strong> — <code>TFVisionTextDualEncoderModel</code> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <code>TFViTModel</code> (ViT model)</li> <li><strong>vit_mae</strong> — <code>TFViTMAEModel</code> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <code>TFWav2Vec2Model</code> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <code>TFWhisperModel</code> (Whisper model)</li> <li><strong>xglm</strong> — <code>TFXGLMModel</code> (XGLM model)</li> <li><strong>xlm</strong> — <code>TFXLMModel</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaModel</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetModel</code> (XLNet model)</li>',Kx,Es,OC,ic,KC,be,lc,e1,ah,SS=`This is a generic model class that will be instantiated as one of the base model classes of the library when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,o1,sh,ES="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",t1,Sn,dc,n1,ih,IS="Instantiates one of the base model classes of the library from a configuration.",r1,lh,US=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,a1,Is,s1,No,cc,i1,dh,PS="Instantiate one of the base model classes of the library from a pretrained model.",l1,ch,qS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,d1,mh,NS='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li> <li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li> <li><strong>distilbert</strong> — <code>FlaxDistilBertModel</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>FlaxElectraModel</code> (ELECTRA model)</li> <li><strong>gemma</strong> — <code>FlaxGemmaModel</code> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <code>FlaxGPT2Model</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>FlaxGPT2Model</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <code>FlaxGPTNeoModel</code> (GPT Neo model)</li> <li><strong>gptj</strong> — <code>FlaxGPTJModel</code> (GPT-J model)</li> <li><strong>llama</strong> — <code>FlaxLlamaModel</code> (LLaMA model)</li> <li><strong>longt5</strong> — <code>FlaxLongT5Model</code> (LongT5 model)</li> <li><strong>marian</strong> — <code>FlaxMarianModel</code> (Marian model)</li> <li><strong>mbart</strong> — <code>FlaxMBartModel</code> (mBART model)</li> <li><strong>mistral</strong> — <code>FlaxMistralModel</code> (Mistral model)</li> <li><strong>mt5</strong> — <code>FlaxMT5Model</code> (MT5 model)</li> <li><strong>opt</strong> — <code>FlaxOPTModel</code> (OPT model)</li> <li><strong>pegasus</strong> — <code>FlaxPegasusModel</code> (Pegasus model)</li> <li><strong>regnet</strong> — <code>FlaxRegNetModel</code> (RegNet model)</li> <li><strong>resnet</strong> — <code>FlaxResNetModel</code> (ResNet model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaModel</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormModel</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerModel</code> (RoFormer model)</li> <li><strong>t5</strong> — <code>FlaxT5Model</code> (T5 model)</li> <li><strong>vision-text-dual-encoder</strong> — <code>FlaxVisionTextDualEncoderModel</code> (VisionTextDualEncoder model)</li> <li><strong>vit</strong> — <code>FlaxViTModel</code> (ViT model)</li> <li><strong>wav2vec2</strong> — <code>FlaxWav2Vec2Model</code> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <code>FlaxWhisperModel</code> (Whisper model)</li> <li><strong>xglm</strong> — <code>FlaxXGLMModel</code> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaModel</code> (XLM-RoBERTa model)</li>',c1,Us,e2,mc,o2,fc,XS="以下の自動クラスは、事前学習ヘッドを持つモデルをインスタンス化するために利用可能です。",t2,gc,n2,_e,pc,m1,fh,DS=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,f1,gh,HS="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",g1,En,uc,p1,ph,QS="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",u1,uh,YS=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,h1,Ps,b1,W,hc,_1,hh,zS="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",M1,bh,OS=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,T1,_h,KS='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertForMaskedLM</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>ElectraForPreTraining</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForPreTraining</code> (ERNIE model)</li> <li><strong>flaubert</strong> — <code>FlaubertWithLMHeadModel</code> (FlauBERT model)</li> <li><strong>flava</strong> — <code>FlavaForPreTraining</code> (FLAVA model)</li> <li><strong>fnet</strong> — <code>FNetForPreTraining</code> (FNet model)</li> <li><strong>fsmt</strong> — <code>FSMTForConditionalGeneration</code> (FairSeq Machine-Translation model)</li> <li><strong>funnel</strong> — <code>FunnelForPreTraining</code> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <code>GPT2LMHeadModel</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2LMHeadModel</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPTBigCodeForCausalLM</code> (GPTBigCode model)</li> <li><strong>gptsan-japanese</strong> — <code>GPTSanJapaneseForConditionalGeneration</code> (GPTSAN-japanese model)</li> <li><strong>ibert</strong> — <code>IBertForMaskedLM</code> (I-BERT model)</li> <li><strong>idefics</strong> — <code>IdeficsForVisionText2Text</code> (IDEFICS model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMForMaskedLM</code> (LayoutLM model)</li> <li><strong>llava</strong> — <code>LlavaForConditionalGeneration</code> (LLaVa model)</li> <li><strong>longformer</strong> — <code>LongformerForMaskedLM</code> (Longformer model)</li> <li><strong>luke</strong> — <code>LukeForMaskedLM</code> (LUKE model)</li> <li><strong>lxmert</strong> — <code>LxmertForPreTraining</code> (LXMERT model)</li> <li><strong>mamba</strong> — <code>MambaForCausalLM</code> (Mamba model)</li> <li><strong>mega</strong> — <code>MegaForMaskedLM</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForPreTraining</code> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForPreTraining</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetForMaskedLM</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>MptForCausalLM</code> (MPT model)</li> <li><strong>mra</strong> — <code>MraForMaskedLM</code> (MRA model)</li> <li><strong>mvp</strong> — <code>MvpForConditionalGeneration</code> (MVP model)</li> <li><strong>nezha</strong> — <code>NezhaForPreTraining</code> (Nezha model)</li> <li><strong>nllb-moe</strong> — <code>NllbMoeForConditionalGeneration</code> (NLLB-MOE model)</li> <li><strong>openai-gpt</strong> — <code>OpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li> <li><strong>retribert</strong> — <code>RetriBertModel</code> (RetriBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForMaskedLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForPreTraining</code> (RoCBert model)</li> <li><strong>rwkv</strong> — <code>RwkvForCausalLM</code> (RWKV model)</li> <li><strong>splinter</strong> — <code>SplinterForPreTraining</code> (Splinter model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertForMaskedLM</code> (SqueezeBERT model)</li> <li><strong>switch_transformers</strong> — <code>SwitchTransformersForConditionalGeneration</code> (SwitchTransformers model)</li> <li><strong>t5</strong> — <code>T5ForConditionalGeneration</code> (T5 model)</li> <li><strong>tapas</strong> — <code>TapasForMaskedLM</code> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <code>TransfoXLLMHeadModel</code> (Transformer-XL model)</li> <li><strong>tvlt</strong> — <code>TvltForPreTraining</code> (TVLT model)</li> <li><strong>unispeech</strong> — <code>UniSpeechForPreTraining</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatForPreTraining</code> (UniSpeechSat model)</li> <li><strong>videomae</strong> — <code>VideoMAEForPreTraining</code> (VideoMAE model)</li> <li><strong>vipllava</strong> — <code>VipLlavaForConditionalGeneration</code> (VipLlava model)</li> <li><strong>visual_bert</strong> — <code>VisualBertForPreTraining</code> (VisualBERT model)</li> <li><strong>vit_mae</strong> — <code>ViTMAEForPreTraining</code> (ViTMAE model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForPreTraining</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerForPreTraining</code> (Wav2Vec2-Conformer model)</li> <li><strong>xlm</strong> — <code>XLMWithLMHeadModel</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForMaskedLM</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetLMHeadModel</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodForMaskedLM</code> (X-MOD model)</li>',y1,Mh,eE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,F1,qs,r2,bc,a2,Me,_c,v1,Th,oE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,C1,yh,tE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",w1,In,Mc,j1,Fh,nE="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",x1,vh,rE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,$1,Ns,k1,Xo,Tc,Z1,Ch,aE="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",A1,wh,sE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,L1,jh,iE='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertForMaskedLM</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>TFElectraForPreTraining</code> (ELECTRA model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertWithLMHeadModel</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelForPreTraining</code> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <code>TFGPT2LMHeadModel</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>TFGPT2LMHeadModel</code> (OpenAI GPT-2 model)</li> <li><strong>layoutlm</strong> — <code>TFLayoutLMForMaskedLM</code> (LayoutLM model)</li> <li><strong>lxmert</strong> — <code>TFLxmertForPreTraining</code> (LXMERT model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForPreTraining</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetForMaskedLM</code> (MPNet model)</li> <li><strong>openai-gpt</strong> — <code>TFOpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForMaskedLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>t5</strong> — <code>TFT5ForConditionalGeneration</code> (T5 model)</li> <li><strong>tapas</strong> — <code>TFTapasForMaskedLM</code> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <code>TFTransfoXLLMHeadModel</code> (Transformer-XL model)</li> <li><strong>vit_mae</strong> — <code>TFViTMAEForPreTraining</code> (ViTMAE model)</li> <li><strong>xlm</strong> — <code>TFXLMWithLMHeadModel</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetLMHeadModel</code> (XLNet model)</li>',B1,Xs,s2,yc,i2,Te,Fc,R1,xh,lE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a pretraining head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,W1,$h,dE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",J1,Un,vc,G1,kh,cE="Instantiates one of the model classes of the library (with a pretraining head) from a configuration.",V1,Zh,mE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,S1,Ds,E1,Do,Cc,I1,Ah,fE="Instantiate one of the model classes of the library (with a pretraining head) from a pretrained model.",U1,Lh,gE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,P1,Bh,pE='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li> <li><strong>electra</strong> — <code>FlaxElectraForPreTraining</code> (ELECTRA model)</li> <li><strong>longt5</strong> — <code>FlaxLongT5ForConditionalGeneration</code> (LongT5 model)</li> <li><strong>mbart</strong> — <code>FlaxMBartForConditionalGeneration</code> (mBART model)</li> <li><strong>mt5</strong> — <code>FlaxMT5ForConditionalGeneration</code> (MT5 model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForMaskedLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerForMaskedLM</code> (RoFormer model)</li> <li><strong>t5</strong> — <code>FlaxT5ForConditionalGeneration</code> (T5 model)</li> <li><strong>wav2vec2</strong> — <code>FlaxWav2Vec2ForPreTraining</code> (Wav2Vec2 model)</li> <li><strong>whisper</strong> — <code>FlaxWhisperForConditionalGeneration</code> (Whisper model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>',q1,Hs,l2,wc,d2,jc,uE="以下の自動クラスは、次の自然言語処理タスクに利用可能です。",c2,xc,m2,ye,$c,N1,Rh,hE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,X1,Wh,bE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",D1,Pn,kc,H1,Jh,_E="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",Q1,Gh,ME=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Y1,Qs,z1,J,Zc,O1,Vh,TE="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",K1,Sh,yE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,e$,Eh,FE='<li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li> <li><strong>bert-generation</strong> — <a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>code_llama</strong> — <code>LlamaForCausalLM</code> (CodeLlama model)</li> <li><strong>codegen</strong> — <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li> <li><strong>cohere</strong> — <code>CohereForCausalLM</code> (Cohere model)</li> <li><strong>cpmant</strong> — <a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li> <li><strong>electra</strong> — <code>ElectraForCausalLM</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForCausalLM</code> (ERNIE model)</li> <li><strong>falcon</strong> — <code>FalconForCausalLM</code> (Falcon model)</li> <li><strong>fuyu</strong> — <code>FuyuForCausalLM</code> (Fuyu model)</li> <li><strong>gemma</strong> — <code>GemmaForCausalLM</code> (Gemma model)</li> <li><strong>git</strong> — <code>GitForCausalLM</code> (GIT model)</li> <li><strong>gpt-sw3</strong> — <code>GPT2LMHeadModel</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2LMHeadModel</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPTBigCodeForCausalLM</code> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <code>GPTNeoForCausalLM</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXForCausalLM</code> (GPT NeoX model)</li> <li><strong>gpt_neox_japanese</strong> — <code>GPTNeoXJapaneseForCausalLM</code> (GPT NeoX Japanese model)</li> <li><strong>gptj</strong> — <code>GPTJForCausalLM</code> (GPT-J model)</li> <li><strong>llama</strong> — <code>LlamaForCausalLM</code> (LLaMA model)</li> <li><strong>mamba</strong> — <code>MambaForCausalLM</code> (Mamba model)</li> <li><strong>marian</strong> — <code>MarianForCausalLM</code> (Marian model)</li> <li><strong>mbart</strong> — <code>MBartForCausalLM</code> (mBART model)</li> <li><strong>mega</strong> — <code>MegaForCausalLM</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForCausalLM</code> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <code>MistralForCausalLM</code> (Mistral model)</li> <li><strong>mixtral</strong> — <code>MixtralForCausalLM</code> (Mixtral model)</li> <li><strong>mpt</strong> — <code>MptForCausalLM</code> (MPT model)</li> <li><strong>musicgen</strong> — <code>MusicgenForCausalLM</code> (MusicGen model)</li> <li><strong>mvp</strong> — <code>MvpForCausalLM</code> (MVP model)</li> <li><strong>open-llama</strong> — <code>OpenLlamaForCausalLM</code> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <code>OpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>OPTForCausalLM</code> (OPT model)</li> <li><strong>pegasus</strong> — <code>PegasusForCausalLM</code> (Pegasus model)</li> <li><strong>persimmon</strong> — <code>PersimmonForCausalLM</code> (Persimmon model)</li> <li><strong>phi</strong> — <code>PhiForCausalLM</code> (Phi model)</li> <li><strong>plbart</strong> — <code>PLBartForCausalLM</code> (PLBart model)</li> <li><strong>prophetnet</strong> — <code>ProphetNetForCausalLM</code> (ProphetNet model)</li> <li><strong>qdqbert</strong> — <code>QDQBertLMHeadModel</code> (QDQBert model)</li> <li><strong>qwen2</strong> — <code>Qwen2ForCausalLM</code> (Qwen2 model)</li> <li><strong>reformer</strong> — <code>ReformerModelWithLMHead</code> (Reformer model)</li> <li><strong>rembert</strong> — <code>RemBertForCausalLM</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForCausalLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForCausalLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForCausalLM</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerForCausalLM</code> (RoFormer model)</li> <li><strong>rwkv</strong> — <code>RwkvForCausalLM</code> (RWKV model)</li> <li><strong>speech_to_text_2</strong> — <code>Speech2Text2ForCausalLM</code> (Speech2Text2 model)</li> <li><strong>stablelm</strong> — <code>StableLmForCausalLM</code> (StableLm model)</li> <li><strong>starcoder2</strong> — <code>Starcoder2ForCausalLM</code> (Starcoder2 model)</li> <li><strong>transfo-xl</strong> — <code>TransfoXLLMHeadModel</code> (Transformer-XL model)</li> <li><strong>trocr</strong> — <code>TrOCRForCausalLM</code> (TrOCR model)</li> <li><strong>whisper</strong> — <code>WhisperForCausalLM</code> (Whisper model)</li> <li><strong>xglm</strong> — <code>XGLMForCausalLM</code> (XGLM model)</li> <li><strong>xlm</strong> — <code>XLMWithLMHeadModel</code> (XLM model)</li> <li><strong>xlm-prophetnet</strong> — <code>XLMProphetNetForCausalLM</code> (XLM-ProphetNet model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForCausalLM</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForCausalLM</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetLMHeadModel</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodForCausalLM</code> (X-MOD model)</li>',o$,Ih,vE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,t$,Ys,f2,Ac,g2,Fe,Lc,n$,Uh,CE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,r$,Ph,wE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",a$,qn,Bc,s$,qh,jE="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",i$,Nh,xE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,l$,zs,d$,Ho,Rc,c$,Xh,$E="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",m$,Dh,kE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,f$,Hh,ZE='<li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li> <li><strong>gpt-sw3</strong> — <code>TFGPT2LMHeadModel</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>TFGPT2LMHeadModel</code> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <code>TFGPTJForCausalLM</code> (GPT-J model)</li> <li><strong>openai-gpt</strong> — <code>TFOpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>TFOPTForCausalLM</code> (OPT model)</li> <li><strong>rembert</strong> — <code>TFRemBertForCausalLM</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForCausalLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForCausalLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerForCausalLM</code> (RoFormer model)</li> <li><strong>transfo-xl</strong> — <code>TFTransfoXLLMHeadModel</code> (Transformer-XL model)</li> <li><strong>xglm</strong> — <code>TFXGLMForCausalLM</code> (XGLM model)</li> <li><strong>xlm</strong> — <code>TFXLMWithLMHeadModel</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForCausalLM</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetLMHeadModel</code> (XLNet model)</li>',g$,Os,p2,Wc,u2,ve,Jc,p$,Qh,AE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a causal language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,u$,Yh,LE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",h$,Nn,Gc,b$,zh,BE="Instantiates one of the model classes of the library (with a causal language modeling head) from a configuration.",_$,Oh,RE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,M$,Ks,T$,Qo,Vc,y$,Kh,WE="Instantiate one of the model classes of the library (with a causal language modeling head) from a pretrained model.",F$,eb,JE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,v$,ob,GE='<li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li> <li><strong>electra</strong> — <code>FlaxElectraForCausalLM</code> (ELECTRA model)</li> <li><strong>gemma</strong> — <code>FlaxGemmaForCausalLM</code> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <code>FlaxGPT2LMHeadModel</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>FlaxGPT2LMHeadModel</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <code>FlaxGPTNeoForCausalLM</code> (GPT Neo model)</li> <li><strong>gptj</strong> — <code>FlaxGPTJForCausalLM</code> (GPT-J model)</li> <li><strong>llama</strong> — <code>FlaxLlamaForCausalLM</code> (LLaMA model)</li> <li><strong>mistral</strong> — <code>FlaxMistralForCausalLM</code> (Mistral model)</li> <li><strong>opt</strong> — <code>FlaxOPTForCausalLM</code> (OPT model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForCausalLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForCausalLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>xglm</strong> — <code>FlaxXGLMForCausalLM</code> (XGLM model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForCausalLM</code> (XLM-RoBERTa model)</li>',C$,ei,h2,Sc,b2,Ce,Ec,w$,tb,VE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,j$,nb,SE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",x$,Xn,Ic,$$,rb,EE="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",k$,ab,IE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Z$,oi,A$,G,Uc,L$,sb,UE="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",B$,ib,PE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,R$,lb,qE='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertForMaskedLM</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>ElectraForMaskedLM</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForMaskedLM</code> (ERNIE model)</li> <li><strong>esm</strong> — <code>EsmForMaskedLM</code> (ESM model)</li> <li><strong>flaubert</strong> — <code>FlaubertWithLMHeadModel</code> (FlauBERT model)</li> <li><strong>fnet</strong> — <code>FNetForMaskedLM</code> (FNet model)</li> <li><strong>funnel</strong> — <code>FunnelForMaskedLM</code> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <code>IBertForMaskedLM</code> (I-BERT model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMForMaskedLM</code> (LayoutLM model)</li> <li><strong>longformer</strong> — <code>LongformerForMaskedLM</code> (Longformer model)</li> <li><strong>luke</strong> — <code>LukeForMaskedLM</code> (LUKE model)</li> <li><strong>mbart</strong> — <code>MBartForConditionalGeneration</code> (mBART model)</li> <li><strong>mega</strong> — <code>MegaForMaskedLM</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForMaskedLM</code> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForMaskedLM</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetForMaskedLM</code> (MPNet model)</li> <li><strong>mra</strong> — <code>MraForMaskedLM</code> (MRA model)</li> <li><strong>mvp</strong> — <code>MvpForConditionalGeneration</code> (MVP model)</li> <li><strong>nezha</strong> — <code>NezhaForMaskedLM</code> (Nezha model)</li> <li><strong>nystromformer</strong> — <code>NystromformerForMaskedLM</code> (Nyströmformer model)</li> <li><strong>perceiver</strong> — <code>PerceiverForMaskedLM</code> (Perceiver model)</li> <li><strong>qdqbert</strong> — <code>QDQBertForMaskedLM</code> (QDQBert model)</li> <li><strong>reformer</strong> — <code>ReformerForMaskedLM</code> (Reformer model)</li> <li><strong>rembert</strong> — <code>RemBertForMaskedLM</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForMaskedLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForMaskedLM</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerForMaskedLM</code> (RoFormer model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertForMaskedLM</code> (SqueezeBERT model)</li> <li><strong>tapas</strong> — <code>TapasForMaskedLM</code> (TAPAS model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li> <li><strong>xlm</strong> — <code>XLMWithLMHeadModel</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForMaskedLM</code> (XLM-RoBERTa-XL model)</li> <li><strong>xmod</strong> — <code>XmodForMaskedLM</code> (X-MOD model)</li> <li><strong>yoso</strong> — <code>YosoForMaskedLM</code> (YOSO model)</li>',W$,db,NE=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,J$,ti,_2,Pc,M2,we,qc,G$,cb,XE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,V$,mb,DE="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",S$,Dn,Nc,E$,fb,HE="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",I$,gb,QE=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,U$,ni,P$,Yo,Xc,q$,pb,YE="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",N$,ub,zE=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,X$,hb,OE='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForMaskedLM">TFBertForMaskedLM</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForMaskedLM">TFConvBertForMaskedLM</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaForMaskedLM">TFDebertaForMaskedLM</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForMaskedLM">TFDebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertForMaskedLM</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>TFElectraForMaskedLM</code> (ELECTRA model)</li> <li><strong>esm</strong> — <code>TFEsmForMaskedLM</code> (ESM model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertWithLMHeadModel</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelForMaskedLM</code> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <code>TFLayoutLMForMaskedLM</code> (LayoutLM model)</li> <li><strong>longformer</strong> — <code>TFLongformerForMaskedLM</code> (Longformer model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForMaskedLM</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetForMaskedLM</code> (MPNet model)</li> <li><strong>rembert</strong> — <code>TFRemBertForMaskedLM</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForMaskedLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerForMaskedLM</code> (RoFormer model)</li> <li><strong>tapas</strong> — <code>TFTapasForMaskedLM</code> (TAPAS model)</li> <li><strong>xlm</strong> — <code>TFXLMWithLMHeadModel</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>',D$,ri,T2,Dc,y2,je,Hc,H$,bb,KE=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Q$,_b,eI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Y$,Hn,Qc,z$,Mb,oI="Instantiates one of the model classes of the library (with a masked language modeling head) from a configuration.",O$,Tb,tI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,K$,ai,ek,zo,Yc,ok,yb,nI="Instantiate one of the model classes of the library (with a masked language modeling head) from a pretrained model.",tk,Fb,rI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,nk,vb,aI='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForMaskedLM">FlaxAlbertForMaskedLM</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForMaskedLM">FlaxBertForMaskedLM</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForMaskedLM">FlaxBigBirdForMaskedLM</a> (BigBird model)</li> <li><strong>distilbert</strong> — <code>FlaxDistilBertForMaskedLM</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>FlaxElectraForMaskedLM</code> (ELECTRA model)</li> <li><strong>mbart</strong> — <code>FlaxMBartForConditionalGeneration</code> (mBART model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForMaskedLM</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerForMaskedLM</code> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>',rk,si,F2,zc,v2,Oc,Kc,C2,em,w2,om,tm,j2,nm,x2,xe,rm,ak,Cb,sI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,sk,wb,iI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ik,Qn,am,lk,jb,lI="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",dk,xb,dI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ck,ii,mk,V,sm,fk,$b,cI="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",gk,kb,mI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,pk,Zb,fI='<li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForConditionalGeneration">BigBirdPegasusForConditionalGeneration</a> (BigBird-Pegasus model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotForConditionalGeneration">BlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallForConditionalGeneration">BlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <code>EncoderDecoderModel</code> (Encoder decoder model)</li> <li><strong>fsmt</strong> — <code>FSMTForConditionalGeneration</code> (FairSeq Machine-Translation model)</li> <li><strong>gptsan-japanese</strong> — <code>GPTSanJapaneseForConditionalGeneration</code> (GPTSAN-japanese model)</li> <li><strong>led</strong> — <code>LEDForConditionalGeneration</code> (LED model)</li> <li><strong>longt5</strong> — <code>LongT5ForConditionalGeneration</code> (LongT5 model)</li> <li><strong>m2m_100</strong> — <code>M2M100ForConditionalGeneration</code> (M2M100 model)</li> <li><strong>marian</strong> — <code>MarianMTModel</code> (Marian model)</li> <li><strong>mbart</strong> — <code>MBartForConditionalGeneration</code> (mBART model)</li> <li><strong>mt5</strong> — <code>MT5ForConditionalGeneration</code> (MT5 model)</li> <li><strong>mvp</strong> — <code>MvpForConditionalGeneration</code> (MVP model)</li> <li><strong>nllb-moe</strong> — <code>NllbMoeForConditionalGeneration</code> (NLLB-MOE model)</li> <li><strong>pegasus</strong> — <code>PegasusForConditionalGeneration</code> (Pegasus model)</li> <li><strong>pegasus_x</strong> — <code>PegasusXForConditionalGeneration</code> (PEGASUS-X model)</li> <li><strong>plbart</strong> — <code>PLBartForConditionalGeneration</code> (PLBart model)</li> <li><strong>prophetnet</strong> — <code>ProphetNetForConditionalGeneration</code> (ProphetNet model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TForTextToText</code> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <code>SeamlessM4Tv2ForTextToText</code> (SeamlessM4Tv2 model)</li> <li><strong>switch_transformers</strong> — <code>SwitchTransformersForConditionalGeneration</code> (SwitchTransformers model)</li> <li><strong>t5</strong> — <code>T5ForConditionalGeneration</code> (T5 model)</li> <li><strong>umt5</strong> — <code>UMT5ForConditionalGeneration</code> (UMT5 model)</li> <li><strong>xlm-prophetnet</strong> — <code>XLMProphetNetForConditionalGeneration</code> (XLM-ProphetNet model)</li>',uk,Ab,gI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,hk,li,$2,im,k2,$e,lm,bk,Lb,pI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,_k,Bb,uI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Mk,Yn,dm,Tk,Rb,hI="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",yk,Wb,bI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Fk,di,vk,Oo,cm,Ck,Jb,_I="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",wk,Gb,MI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,jk,Vb,TI='<li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.TFBlenderbotForConditionalGeneration">TFBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.TFBlenderbotSmallForConditionalGeneration">TFBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <code>TFEncoderDecoderModel</code> (Encoder decoder model)</li> <li><strong>led</strong> — <code>TFLEDForConditionalGeneration</code> (LED model)</li> <li><strong>marian</strong> — <code>TFMarianMTModel</code> (Marian model)</li> <li><strong>mbart</strong> — <code>TFMBartForConditionalGeneration</code> (mBART model)</li> <li><strong>mt5</strong> — <code>TFMT5ForConditionalGeneration</code> (MT5 model)</li> <li><strong>pegasus</strong> — <code>TFPegasusForConditionalGeneration</code> (Pegasus model)</li> <li><strong>t5</strong> — <code>TFT5ForConditionalGeneration</code> (T5 model)</li>',xk,ci,Z2,mm,A2,ke,fm,$k,Sb,yI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence language modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,kk,Eb,FI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Zk,zn,gm,Ak,Ib,vI="Instantiates one of the model classes of the library (with a sequence-to-sequence language modeling head) from a configuration.",Lk,Ub,CI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Bk,mi,Rk,Ko,pm,Wk,Pb,wI="Instantiate one of the model classes of the library (with a sequence-to-sequence language modeling head) from a pretrained model.",Jk,qb,jI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Gk,Nb,xI='<li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li> <li><strong>blenderbot</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.FlaxBlenderbotForConditionalGeneration">FlaxBlenderbotForConditionalGeneration</a> (Blenderbot model)</li> <li><strong>blenderbot-small</strong> — <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallForConditionalGeneration">FlaxBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li> <li><strong>encoder-decoder</strong> — <code>FlaxEncoderDecoderModel</code> (Encoder decoder model)</li> <li><strong>longt5</strong> — <code>FlaxLongT5ForConditionalGeneration</code> (LongT5 model)</li> <li><strong>marian</strong> — <code>FlaxMarianMTModel</code> (Marian model)</li> <li><strong>mbart</strong> — <code>FlaxMBartForConditionalGeneration</code> (mBART model)</li> <li><strong>mt5</strong> — <code>FlaxMT5ForConditionalGeneration</code> (MT5 model)</li> <li><strong>pegasus</strong> — <code>FlaxPegasusForConditionalGeneration</code> (Pegasus model)</li> <li><strong>t5</strong> — <code>FlaxT5ForConditionalGeneration</code> (T5 model)</li>',Vk,fi,L2,um,B2,Ze,hm,Sk,Xb,$I=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Ek,Db,kI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Ik,On,bm,Uk,Hb,ZI="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",Pk,Qb,AI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,qk,gi,Nk,S,_m,Xk,Yb,LI="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",Dk,zb,BI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,Hk,Ob,RI='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForSequenceClassification">AlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForSequenceClassification">BartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForSequenceClassification">BigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForSequenceClassification">BigBirdPegasusForSequenceClassification</a> (BigBird-Pegasus model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForSequenceClassification">BloomForSequenceClassification</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForSequenceClassification">CamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a> (CANINE model)</li> <li><strong>code_llama</strong> — <code>LlamaForSequenceClassification</code> (CodeLlama model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForSequenceClassification">ConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForSequenceClassification">Data2VecTextForSequenceClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForSequenceClassification">DebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForSequenceClassification">DebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertForSequenceClassification</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>ElectraForSequenceClassification</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForSequenceClassification</code> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMForSequenceClassification</code> (ErnieM model)</li> <li><strong>esm</strong> — <code>EsmForSequenceClassification</code> (ESM model)</li> <li><strong>falcon</strong> — <code>FalconForSequenceClassification</code> (Falcon model)</li> <li><strong>flaubert</strong> — <code>FlaubertForSequenceClassification</code> (FlauBERT model)</li> <li><strong>fnet</strong> — <code>FNetForSequenceClassification</code> (FNet model)</li> <li><strong>funnel</strong> — <code>FunnelForSequenceClassification</code> (Funnel Transformer model)</li> <li><strong>gemma</strong> — <code>GemmaForSequenceClassification</code> (Gemma model)</li> <li><strong>gpt-sw3</strong> — <code>GPT2ForSequenceClassification</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2ForSequenceClassification</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPTBigCodeForSequenceClassification</code> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <code>GPTNeoForSequenceClassification</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXForSequenceClassification</code> (GPT NeoX model)</li> <li><strong>gptj</strong> — <code>GPTJForSequenceClassification</code> (GPT-J model)</li> <li><strong>ibert</strong> — <code>IBertForSequenceClassification</code> (I-BERT model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMForSequenceClassification</code> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2ForSequenceClassification</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3ForSequenceClassification</code> (LayoutLMv3 model)</li> <li><strong>led</strong> — <code>LEDForSequenceClassification</code> (LED model)</li> <li><strong>lilt</strong> — <code>LiltForSequenceClassification</code> (LiLT model)</li> <li><strong>llama</strong> — <code>LlamaForSequenceClassification</code> (LLaMA model)</li> <li><strong>longformer</strong> — <code>LongformerForSequenceClassification</code> (Longformer model)</li> <li><strong>luke</strong> — <code>LukeForSequenceClassification</code> (LUKE model)</li> <li><strong>markuplm</strong> — <code>MarkupLMForSequenceClassification</code> (MarkupLM model)</li> <li><strong>mbart</strong> — <code>MBartForSequenceClassification</code> (mBART model)</li> <li><strong>mega</strong> — <code>MegaForSequenceClassification</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForSequenceClassification</code> (Megatron-BERT model)</li> <li><strong>mistral</strong> — <code>MistralForSequenceClassification</code> (Mistral model)</li> <li><strong>mixtral</strong> — <code>MixtralForSequenceClassification</code> (Mixtral model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForSequenceClassification</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetForSequenceClassification</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>MptForSequenceClassification</code> (MPT model)</li> <li><strong>mra</strong> — <code>MraForSequenceClassification</code> (MRA model)</li> <li><strong>mt5</strong> — <code>MT5ForSequenceClassification</code> (MT5 model)</li> <li><strong>mvp</strong> — <code>MvpForSequenceClassification</code> (MVP model)</li> <li><strong>nezha</strong> — <code>NezhaForSequenceClassification</code> (Nezha model)</li> <li><strong>nystromformer</strong> — <code>NystromformerForSequenceClassification</code> (Nyströmformer model)</li> <li><strong>open-llama</strong> — <code>OpenLlamaForSequenceClassification</code> (OpenLlama model)</li> <li><strong>openai-gpt</strong> — <code>OpenAIGPTForSequenceClassification</code> (OpenAI GPT model)</li> <li><strong>opt</strong> — <code>OPTForSequenceClassification</code> (OPT model)</li> <li><strong>perceiver</strong> — <code>PerceiverForSequenceClassification</code> (Perceiver model)</li> <li><strong>persimmon</strong> — <code>PersimmonForSequenceClassification</code> (Persimmon model)</li> <li><strong>phi</strong> — <code>PhiForSequenceClassification</code> (Phi model)</li> <li><strong>plbart</strong> — <code>PLBartForSequenceClassification</code> (PLBart model)</li> <li><strong>qdqbert</strong> — <code>QDQBertForSequenceClassification</code> (QDQBert model)</li> <li><strong>qwen2</strong> — <code>Qwen2ForSequenceClassification</code> (Qwen2 model)</li> <li><strong>reformer</strong> — <code>ReformerForSequenceClassification</code> (Reformer model)</li> <li><strong>rembert</strong> — <code>RemBertForSequenceClassification</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForSequenceClassification</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForSequenceClassification</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForSequenceClassification</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerForSequenceClassification</code> (RoFormer model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertForSequenceClassification</code> (SqueezeBERT model)</li> <li><strong>stablelm</strong> — <code>StableLmForSequenceClassification</code> (StableLm model)</li> <li><strong>starcoder2</strong> — <code>Starcoder2ForSequenceClassification</code> (Starcoder2 model)</li> <li><strong>t5</strong> — <code>T5ForSequenceClassification</code> (T5 model)</li> <li><strong>tapas</strong> — <code>TapasForSequenceClassification</code> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <code>TransfoXLForSequenceClassification</code> (Transformer-XL model)</li> <li><strong>umt5</strong> — <code>UMT5ForSequenceClassification</code> (UMT5 model)</li> <li><strong>xlm</strong> — <code>XLMForSequenceClassification</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForSequenceClassification</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForSequenceClassification</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetForSequenceClassification</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodForSequenceClassification</code> (X-MOD model)</li> <li><strong>yoso</strong> — <code>YosoForSequenceClassification</code> (YOSO model)</li>',Qk,Kb,WI=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,Yk,pi,R2,Mm,W2,Ae,Tm,zk,e_,JI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Ok,o_,GI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",Kk,Kn,ym,eZ,t_,VI="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",oZ,n_,SI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,tZ,ui,nZ,et,Fm,rZ,r_,EI="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",aZ,a_,II=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sZ,s_,UI='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForSequenceClassification">TFAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartForSequenceClassification">TFBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForSequenceClassification">TFBertForSequenceClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForSequenceClassification">TFCamembertForSequenceClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForSequenceClassification">TFConvBertForSequenceClassification</a> (ConvBERT model)</li> <li><strong>ctrl</strong> — <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> (CTRL model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaForSequenceClassification">TFDebertaForSequenceClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForSequenceClassification">TFDebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertForSequenceClassification</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>TFElectraForSequenceClassification</code> (ELECTRA model)</li> <li><strong>esm</strong> — <code>TFEsmForSequenceClassification</code> (ESM model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertForSequenceClassification</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelForSequenceClassification</code> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <code>TFGPT2ForSequenceClassification</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>TFGPT2ForSequenceClassification</code> (OpenAI GPT-2 model)</li> <li><strong>gptj</strong> — <code>TFGPTJForSequenceClassification</code> (GPT-J model)</li> <li><strong>layoutlm</strong> — <code>TFLayoutLMForSequenceClassification</code> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <code>TFLayoutLMv3ForSequenceClassification</code> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <code>TFLongformerForSequenceClassification</code> (Longformer model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForSequenceClassification</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetForSequenceClassification</code> (MPNet model)</li> <li><strong>openai-gpt</strong> — <code>TFOpenAIGPTForSequenceClassification</code> (OpenAI GPT model)</li> <li><strong>rembert</strong> — <code>TFRemBertForSequenceClassification</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForSequenceClassification</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForSequenceClassification</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerForSequenceClassification</code> (RoFormer model)</li> <li><strong>tapas</strong> — <code>TFTapasForSequenceClassification</code> (TAPAS model)</li> <li><strong>transfo-xl</strong> — <code>TFTransfoXLForSequenceClassification</code> (Transformer-XL model)</li> <li><strong>xlm</strong> — <code>TFXLMForSequenceClassification</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForSequenceClassification</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetForSequenceClassification</code> (XLNet model)</li>',iZ,hi,J2,vm,G2,Le,Cm,lZ,i_,PI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,dZ,l_,qI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",cZ,er,wm,mZ,d_,NI="Instantiates one of the model classes of the library (with a sequence classification head) from a configuration.",fZ,c_,XI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,gZ,bi,pZ,ot,jm,uZ,m_,DI="Instantiate one of the model classes of the library (with a sequence classification head) from a pretrained model.",hZ,f_,HI=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,bZ,g_,QI='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForSequenceClassification">FlaxAlbertForSequenceClassification</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForSequenceClassification">FlaxBartForSequenceClassification</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForSequenceClassification">FlaxBertForSequenceClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForSequenceClassification">FlaxBigBirdForSequenceClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <code>FlaxDistilBertForSequenceClassification</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>FlaxElectraForSequenceClassification</code> (ELECTRA model)</li> <li><strong>mbart</strong> — <code>FlaxMBartForSequenceClassification</code> (mBART model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForSequenceClassification</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForSequenceClassification</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerForSequenceClassification</code> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForSequenceClassification</code> (XLM-RoBERTa model)</li>',_Z,_i,V2,xm,S2,Be,$m,MZ,p_,YI=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,TZ,u_,zI="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",yZ,or,km,FZ,h_,OI="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",vZ,b_,KI=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,CZ,Mi,wZ,E,Zm,jZ,__,eU="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",xZ,M_,oU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,$Z,T_,tU='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForMultipleChoice">AlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForMultipleChoice">BertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForMultipleChoice">BigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForMultipleChoice">CamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForMultipleChoice">ConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForMultipleChoice">Data2VecTextForMultipleChoice</a> (Data2VecText model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForMultipleChoice">DebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertForMultipleChoice</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>ElectraForMultipleChoice</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForMultipleChoice</code> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMForMultipleChoice</code> (ErnieM model)</li> <li><strong>flaubert</strong> — <code>FlaubertForMultipleChoice</code> (FlauBERT model)</li> <li><strong>fnet</strong> — <code>FNetForMultipleChoice</code> (FNet model)</li> <li><strong>funnel</strong> — <code>FunnelForMultipleChoice</code> (Funnel Transformer model)</li> <li><strong>ibert</strong> — <code>IBertForMultipleChoice</code> (I-BERT model)</li> <li><strong>longformer</strong> — <code>LongformerForMultipleChoice</code> (Longformer model)</li> <li><strong>luke</strong> — <code>LukeForMultipleChoice</code> (LUKE model)</li> <li><strong>mega</strong> — <code>MegaForMultipleChoice</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForMultipleChoice</code> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForMultipleChoice</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetForMultipleChoice</code> (MPNet model)</li> <li><strong>mra</strong> — <code>MraForMultipleChoice</code> (MRA model)</li> <li><strong>nezha</strong> — <code>NezhaForMultipleChoice</code> (Nezha model)</li> <li><strong>nystromformer</strong> — <code>NystromformerForMultipleChoice</code> (Nyströmformer model)</li> <li><strong>qdqbert</strong> — <code>QDQBertForMultipleChoice</code> (QDQBert model)</li> <li><strong>rembert</strong> — <code>RemBertForMultipleChoice</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForMultipleChoice</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForMultipleChoice</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForMultipleChoice</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerForMultipleChoice</code> (RoFormer model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertForMultipleChoice</code> (SqueezeBERT model)</li> <li><strong>xlm</strong> — <code>XLMForMultipleChoice</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForMultipleChoice</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForMultipleChoice</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetForMultipleChoice</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodForMultipleChoice</code> (X-MOD model)</li> <li><strong>yoso</strong> — <code>YosoForMultipleChoice</code> (YOSO model)</li>',kZ,y_,nU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,ZZ,Ti,E2,Am,I2,Re,Lm,AZ,F_,rU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,LZ,v_,aU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",BZ,tr,Bm,RZ,C_,sU="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",WZ,w_,iU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,JZ,yi,GZ,tt,Rm,VZ,j_,lU="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",SZ,x_,dU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,EZ,$_,cU='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForMultipleChoice">TFAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForMultipleChoice">TFBertForMultipleChoice</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForMultipleChoice">TFCamembertForMultipleChoice</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForMultipleChoice">TFConvBertForMultipleChoice</a> (ConvBERT model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForMultipleChoice">TFDebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertForMultipleChoice</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>TFElectraForMultipleChoice</code> (ELECTRA model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertForMultipleChoice</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelForMultipleChoice</code> (Funnel Transformer model)</li> <li><strong>longformer</strong> — <code>TFLongformerForMultipleChoice</code> (Longformer model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForMultipleChoice</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetForMultipleChoice</code> (MPNet model)</li> <li><strong>rembert</strong> — <code>TFRemBertForMultipleChoice</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForMultipleChoice</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForMultipleChoice</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerForMultipleChoice</code> (RoFormer model)</li> <li><strong>xlm</strong> — <code>TFXLMForMultipleChoice</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForMultipleChoice</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetForMultipleChoice</code> (XLNet model)</li>',IZ,Fi,U2,Wm,P2,We,Jm,UZ,k_,mU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a multiple choice head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,PZ,Z_,fU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",qZ,nr,Gm,NZ,A_,gU="Instantiates one of the model classes of the library (with a multiple choice head) from a configuration.",XZ,L_,pU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,DZ,vi,HZ,nt,Vm,QZ,B_,uU="Instantiate one of the model classes of the library (with a multiple choice head) from a pretrained model.",YZ,R_,hU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,zZ,W_,bU='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForMultipleChoice">FlaxAlbertForMultipleChoice</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForMultipleChoice">FlaxBertForMultipleChoice</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForMultipleChoice">FlaxBigBirdForMultipleChoice</a> (BigBird model)</li> <li><strong>distilbert</strong> — <code>FlaxDistilBertForMultipleChoice</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>FlaxElectraForMultipleChoice</code> (ELECTRA model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForMultipleChoice</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForMultipleChoice</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerForMultipleChoice</code> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForMultipleChoice</code> (XLM-RoBERTa model)</li>',OZ,Ci,q2,Sm,N2,Je,Em,KZ,J_,_U=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eA,G_,MU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oA,rr,Im,tA,V_,TU="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",nA,S_,yU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rA,wi,aA,I,Um,sA,E_,FU="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",iA,I_,vU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lA,U_,CU='<li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForNextSentencePrediction">BertForNextSentencePrediction</a> (BERT model)</li> <li><strong>ernie</strong> — <code>ErnieForNextSentencePrediction</code> (ERNIE model)</li> <li><strong>fnet</strong> — <code>FNetForNextSentencePrediction</code> (FNet model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForNextSentencePrediction</code> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForNextSentencePrediction</code> (MobileBERT model)</li> <li><strong>nezha</strong> — <code>NezhaForNextSentencePrediction</code> (Nezha model)</li> <li><strong>qdqbert</strong> — <code>QDQBertForNextSentencePrediction</code> (QDQBert model)</li>',dA,P_,wU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,cA,ji,X2,Pm,D2,Ge,qm,mA,q_,jU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fA,N_,xU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gA,ar,Nm,pA,X_,$U="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",uA,D_,kU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,hA,xi,bA,rt,Xm,_A,H_,ZU="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",MA,Q_,AU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,TA,Y_,LU='<li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForNextSentencePrediction">TFBertForNextSentencePrediction</a> (BERT model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForNextSentencePrediction</code> (MobileBERT model)</li>',yA,$i,H2,Dm,Q2,Ve,Hm,FA,z_,BU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a next sentence prediction head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,vA,O_,RU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",CA,sr,Qm,wA,K_,WU="Instantiates one of the model classes of the library (with a next sentence prediction head) from a configuration.",jA,eM,JU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,xA,ki,$A,at,Ym,kA,oM,GU="Instantiate one of the model classes of the library (with a next sentence prediction head) from a pretrained model.",ZA,tM,VU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,AA,nM,SU='<li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForNextSentencePrediction">FlaxBertForNextSentencePrediction</a> (BERT model)</li>',LA,Zi,Y2,zm,z2,Se,Om,BA,rM,EU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,RA,aM,IU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",WA,ir,Km,JA,sM,UU="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",GA,iM,PU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,VA,Ai,SA,U,ef,EA,lM,qU="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",IA,dM,NU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,UA,cM,XU='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForTokenClassification">AlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForTokenClassification">BertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForTokenClassification">BigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>biogpt</strong> — <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptForTokenClassification">BioGptForTokenClassification</a> (BioGpt model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForTokenClassification">BloomForTokenClassification</a> (BLOOM model)</li> <li><strong>bros</strong> — <a href="/docs/transformers/main/ja/model_doc/bros#transformers.BrosForTokenClassification">BrosForTokenClassification</a> (BROS model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForTokenClassification">CamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineForTokenClassification">CanineForTokenClassification</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForTokenClassification">ConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForTokenClassification">Data2VecTextForTokenClassification</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForTokenClassification">DebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForTokenClassification">DebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertForTokenClassification</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>ElectraForTokenClassification</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForTokenClassification</code> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMForTokenClassification</code> (ErnieM model)</li> <li><strong>esm</strong> — <code>EsmForTokenClassification</code> (ESM model)</li> <li><strong>falcon</strong> — <code>FalconForTokenClassification</code> (Falcon model)</li> <li><strong>flaubert</strong> — <code>FlaubertForTokenClassification</code> (FlauBERT model)</li> <li><strong>fnet</strong> — <code>FNetForTokenClassification</code> (FNet model)</li> <li><strong>funnel</strong> — <code>FunnelForTokenClassification</code> (Funnel Transformer model)</li> <li><strong>gpt-sw3</strong> — <code>GPT2ForTokenClassification</code> (GPT-Sw3 model)</li> <li><strong>gpt2</strong> — <code>GPT2ForTokenClassification</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_bigcode</strong> — <code>GPTBigCodeForTokenClassification</code> (GPTBigCode model)</li> <li><strong>gpt_neo</strong> — <code>GPTNeoForTokenClassification</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXForTokenClassification</code> (GPT NeoX model)</li> <li><strong>ibert</strong> — <code>IBertForTokenClassification</code> (I-BERT model)</li> <li><strong>layoutlm</strong> — <code>LayoutLMForTokenClassification</code> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2ForTokenClassification</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3ForTokenClassification</code> (LayoutLMv3 model)</li> <li><strong>lilt</strong> — <code>LiltForTokenClassification</code> (LiLT model)</li> <li><strong>longformer</strong> — <code>LongformerForTokenClassification</code> (Longformer model)</li> <li><strong>luke</strong> — <code>LukeForTokenClassification</code> (LUKE model)</li> <li><strong>markuplm</strong> — <code>MarkupLMForTokenClassification</code> (MarkupLM model)</li> <li><strong>mega</strong> — <code>MegaForTokenClassification</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForTokenClassification</code> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForTokenClassification</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetForTokenClassification</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>MptForTokenClassification</code> (MPT model)</li> <li><strong>mra</strong> — <code>MraForTokenClassification</code> (MRA model)</li> <li><strong>mt5</strong> — <code>MT5ForTokenClassification</code> (MT5 model)</li> <li><strong>nezha</strong> — <code>NezhaForTokenClassification</code> (Nezha model)</li> <li><strong>nystromformer</strong> — <code>NystromformerForTokenClassification</code> (Nyströmformer model)</li> <li><strong>phi</strong> — <code>PhiForTokenClassification</code> (Phi model)</li> <li><strong>qdqbert</strong> — <code>QDQBertForTokenClassification</code> (QDQBert model)</li> <li><strong>rembert</strong> — <code>RemBertForTokenClassification</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForTokenClassification</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForTokenClassification</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForTokenClassification</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerForTokenClassification</code> (RoFormer model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertForTokenClassification</code> (SqueezeBERT model)</li> <li><strong>t5</strong> — <code>T5ForTokenClassification</code> (T5 model)</li> <li><strong>umt5</strong> — <code>UMT5ForTokenClassification</code> (UMT5 model)</li> <li><strong>xlm</strong> — <code>XLMForTokenClassification</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForTokenClassification</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForTokenClassification</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetForTokenClassification</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodForTokenClassification</code> (X-MOD model)</li> <li><strong>yoso</strong> — <code>YosoForTokenClassification</code> (YOSO model)</li>',PA,mM,DU=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,qA,Li,O2,of,K2,Ee,tf,NA,fM,HU=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,XA,gM,QU="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",DA,lr,nf,HA,pM,YU="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",QA,uM,zU=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,YA,Bi,zA,st,rf,OA,hM,OU="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",KA,bM,KU=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,eL,_M,e9='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForTokenClassification">TFAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForTokenClassification">TFBertForTokenClassification</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForTokenClassification">TFCamembertForTokenClassification</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForTokenClassification">TFConvBertForTokenClassification</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaForTokenClassification">TFDebertaForTokenClassification</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForTokenClassification">TFDebertaV2ForTokenClassification</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertForTokenClassification</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>TFElectraForTokenClassification</code> (ELECTRA model)</li> <li><strong>esm</strong> — <code>TFEsmForTokenClassification</code> (ESM model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertForTokenClassification</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelForTokenClassification</code> (Funnel Transformer model)</li> <li><strong>layoutlm</strong> — <code>TFLayoutLMForTokenClassification</code> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <code>TFLayoutLMv3ForTokenClassification</code> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <code>TFLongformerForTokenClassification</code> (Longformer model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForTokenClassification</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetForTokenClassification</code> (MPNet model)</li> <li><strong>rembert</strong> — <code>TFRemBertForTokenClassification</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForTokenClassification</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForTokenClassification</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerForTokenClassification</code> (RoFormer model)</li> <li><strong>xlm</strong> — <code>TFXLMForTokenClassification</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForTokenClassification</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetForTokenClassification</code> (XLNet model)</li>',oL,Ri,ew,af,ow,Ie,sf,tL,MM,o9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a token classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,nL,TM,t9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",rL,dr,lf,aL,yM,n9="Instantiates one of the model classes of the library (with a token classification head) from a configuration.",sL,FM,r9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,iL,Wi,lL,it,df,dL,vM,a9="Instantiate one of the model classes of the library (with a token classification head) from a pretrained model.",cL,CM,s9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,mL,wM,i9='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForTokenClassification">FlaxAlbertForTokenClassification</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForTokenClassification">FlaxBertForTokenClassification</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForTokenClassification">FlaxBigBirdForTokenClassification</a> (BigBird model)</li> <li><strong>distilbert</strong> — <code>FlaxDistilBertForTokenClassification</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>FlaxElectraForTokenClassification</code> (ELECTRA model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForTokenClassification</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForTokenClassification</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerForTokenClassification</code> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForTokenClassification</code> (XLM-RoBERTa model)</li>',fL,Ji,tw,cf,nw,Ue,mf,gL,jM,l9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,pL,xM,d9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",uL,cr,ff,hL,$M,c9="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",bL,kM,m9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,_L,Gi,ML,P,gf,TL,ZM,f9="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",yL,AM,g9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,FL,LM,p9='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForQuestionAnswering">AlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForQuestionAnswering">BartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForQuestionAnswering">BertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForQuestionAnswering">BigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>bigbird_pegasus</strong> — <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForQuestionAnswering">BigBirdPegasusForQuestionAnswering</a> (BigBird-Pegasus model)</li> <li><strong>bloom</strong> — <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForQuestionAnswering">BloomForQuestionAnswering</a> (BLOOM model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForQuestionAnswering">CamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>canine</strong> — <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineForQuestionAnswering">CanineForQuestionAnswering</a> (CANINE model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForQuestionAnswering">ConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>data2vec-text</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForQuestionAnswering">Data2VecTextForQuestionAnswering</a> (Data2VecText model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForQuestionAnswering">DebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForQuestionAnswering">DebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>DistilBertForQuestionAnswering</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>ElectraForQuestionAnswering</code> (ELECTRA model)</li> <li><strong>ernie</strong> — <code>ErnieForQuestionAnswering</code> (ERNIE model)</li> <li><strong>ernie_m</strong> — <code>ErnieMForQuestionAnswering</code> (ErnieM model)</li> <li><strong>falcon</strong> — <code>FalconForQuestionAnswering</code> (Falcon model)</li> <li><strong>flaubert</strong> — <code>FlaubertForQuestionAnsweringSimple</code> (FlauBERT model)</li> <li><strong>fnet</strong> — <code>FNetForQuestionAnswering</code> (FNet model)</li> <li><strong>funnel</strong> — <code>FunnelForQuestionAnswering</code> (Funnel Transformer model)</li> <li><strong>gpt2</strong> — <code>GPT2ForQuestionAnswering</code> (OpenAI GPT-2 model)</li> <li><strong>gpt_neo</strong> — <code>GPTNeoForQuestionAnswering</code> (GPT Neo model)</li> <li><strong>gpt_neox</strong> — <code>GPTNeoXForQuestionAnswering</code> (GPT NeoX model)</li> <li><strong>gptj</strong> — <code>GPTJForQuestionAnswering</code> (GPT-J model)</li> <li><strong>ibert</strong> — <code>IBertForQuestionAnswering</code> (I-BERT model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2ForQuestionAnswering</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3ForQuestionAnswering</code> (LayoutLMv3 model)</li> <li><strong>led</strong> — <code>LEDForQuestionAnswering</code> (LED model)</li> <li><strong>lilt</strong> — <code>LiltForQuestionAnswering</code> (LiLT model)</li> <li><strong>llama</strong> — <code>LlamaForQuestionAnswering</code> (LLaMA model)</li> <li><strong>longformer</strong> — <code>LongformerForQuestionAnswering</code> (Longformer model)</li> <li><strong>luke</strong> — <code>LukeForQuestionAnswering</code> (LUKE model)</li> <li><strong>lxmert</strong> — <code>LxmertForQuestionAnswering</code> (LXMERT model)</li> <li><strong>markuplm</strong> — <code>MarkupLMForQuestionAnswering</code> (MarkupLM model)</li> <li><strong>mbart</strong> — <code>MBartForQuestionAnswering</code> (mBART model)</li> <li><strong>mega</strong> — <code>MegaForQuestionAnswering</code> (MEGA model)</li> <li><strong>megatron-bert</strong> — <code>MegatronBertForQuestionAnswering</code> (Megatron-BERT model)</li> <li><strong>mobilebert</strong> — <code>MobileBertForQuestionAnswering</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>MPNetForQuestionAnswering</code> (MPNet model)</li> <li><strong>mpt</strong> — <code>MptForQuestionAnswering</code> (MPT model)</li> <li><strong>mra</strong> — <code>MraForQuestionAnswering</code> (MRA model)</li> <li><strong>mt5</strong> — <code>MT5ForQuestionAnswering</code> (MT5 model)</li> <li><strong>mvp</strong> — <code>MvpForQuestionAnswering</code> (MVP model)</li> <li><strong>nezha</strong> — <code>NezhaForQuestionAnswering</code> (Nezha model)</li> <li><strong>nystromformer</strong> — <code>NystromformerForQuestionAnswering</code> (Nyströmformer model)</li> <li><strong>opt</strong> — <code>OPTForQuestionAnswering</code> (OPT model)</li> <li><strong>qdqbert</strong> — <code>QDQBertForQuestionAnswering</code> (QDQBert model)</li> <li><strong>reformer</strong> — <code>ReformerForQuestionAnswering</code> (Reformer model)</li> <li><strong>rembert</strong> — <code>RemBertForQuestionAnswering</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>RobertaForQuestionAnswering</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>RobertaPreLayerNormForQuestionAnswering</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roc_bert</strong> — <code>RoCBertForQuestionAnswering</code> (RoCBert model)</li> <li><strong>roformer</strong> — <code>RoFormerForQuestionAnswering</code> (RoFormer model)</li> <li><strong>splinter</strong> — <code>SplinterForQuestionAnswering</code> (Splinter model)</li> <li><strong>squeezebert</strong> — <code>SqueezeBertForQuestionAnswering</code> (SqueezeBERT model)</li> <li><strong>t5</strong> — <code>T5ForQuestionAnswering</code> (T5 model)</li> <li><strong>umt5</strong> — <code>UMT5ForQuestionAnswering</code> (UMT5 model)</li> <li><strong>xlm</strong> — <code>XLMForQuestionAnsweringSimple</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>XLMRobertaForQuestionAnswering</code> (XLM-RoBERTa model)</li> <li><strong>xlm-roberta-xl</strong> — <code>XLMRobertaXLForQuestionAnswering</code> (XLM-RoBERTa-XL model)</li> <li><strong>xlnet</strong> — <code>XLNetForQuestionAnsweringSimple</code> (XLNet model)</li> <li><strong>xmod</strong> — <code>XmodForQuestionAnswering</code> (X-MOD model)</li> <li><strong>yoso</strong> — <code>YosoForQuestionAnswering</code> (YOSO model)</li>',vL,BM,u9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,CL,Vi,rw,pf,aw,Pe,uf,wL,RM,h9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,jL,WM,b9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",xL,mr,hf,$L,JM,_9="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",kL,GM,M9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,ZL,Si,AL,lt,bf,LL,VM,T9="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",BL,SM,y9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,RL,EM,F9='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForQuestionAnswering">TFAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForQuestionAnswering">TFBertForQuestionAnswering</a> (BERT model)</li> <li><strong>camembert</strong> — <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForQuestionAnswering">TFCamembertForQuestionAnswering</a> (CamemBERT model)</li> <li><strong>convbert</strong> — <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForQuestionAnswering">TFConvBertForQuestionAnswering</a> (ConvBERT model)</li> <li><strong>deberta</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaForQuestionAnswering">TFDebertaForQuestionAnswering</a> (DeBERTa model)</li> <li><strong>deberta-v2</strong> — <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForQuestionAnswering">TFDebertaV2ForQuestionAnswering</a> (DeBERTa-v2 model)</li> <li><strong>distilbert</strong> — <code>TFDistilBertForQuestionAnswering</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>TFElectraForQuestionAnswering</code> (ELECTRA model)</li> <li><strong>flaubert</strong> — <code>TFFlaubertForQuestionAnsweringSimple</code> (FlauBERT model)</li> <li><strong>funnel</strong> — <code>TFFunnelForQuestionAnswering</code> (Funnel Transformer model)</li> <li><strong>gptj</strong> — <code>TFGPTJForQuestionAnswering</code> (GPT-J model)</li> <li><strong>layoutlmv3</strong> — <code>TFLayoutLMv3ForQuestionAnswering</code> (LayoutLMv3 model)</li> <li><strong>longformer</strong> — <code>TFLongformerForQuestionAnswering</code> (Longformer model)</li> <li><strong>mobilebert</strong> — <code>TFMobileBertForQuestionAnswering</code> (MobileBERT model)</li> <li><strong>mpnet</strong> — <code>TFMPNetForQuestionAnswering</code> (MPNet model)</li> <li><strong>rembert</strong> — <code>TFRemBertForQuestionAnswering</code> (RemBERT model)</li> <li><strong>roberta</strong> — <code>TFRobertaForQuestionAnswering</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>TFRobertaPreLayerNormForQuestionAnswering</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>TFRoFormerForQuestionAnswering</code> (RoFormer model)</li> <li><strong>xlm</strong> — <code>TFXLMForQuestionAnsweringSimple</code> (XLM model)</li> <li><strong>xlm-roberta</strong> — <code>TFXLMRobertaForQuestionAnswering</code> (XLM-RoBERTa model)</li> <li><strong>xlnet</strong> — <code>TFXLNetForQuestionAnsweringSimple</code> (XLNet model)</li>',WL,Ei,sw,_f,iw,qe,Mf,JL,IM,v9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,GL,UM,C9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",VL,fr,Tf,SL,PM,w9="Instantiates one of the model classes of the library (with a question answering head) from a configuration.",EL,qM,j9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,IL,Ii,UL,dt,yf,PL,NM,x9="Instantiate one of the model classes of the library (with a question answering head) from a pretrained model.",qL,XM,$9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,NL,DM,k9='<li><strong>albert</strong> — <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForQuestionAnswering">FlaxAlbertForQuestionAnswering</a> (ALBERT model)</li> <li><strong>bart</strong> — <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForQuestionAnswering">FlaxBartForQuestionAnswering</a> (BART model)</li> <li><strong>bert</strong> — <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForQuestionAnswering">FlaxBertForQuestionAnswering</a> (BERT model)</li> <li><strong>big_bird</strong> — <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForQuestionAnswering">FlaxBigBirdForQuestionAnswering</a> (BigBird model)</li> <li><strong>distilbert</strong> — <code>FlaxDistilBertForQuestionAnswering</code> (DistilBERT model)</li> <li><strong>electra</strong> — <code>FlaxElectraForQuestionAnswering</code> (ELECTRA model)</li> <li><strong>mbart</strong> — <code>FlaxMBartForQuestionAnswering</code> (mBART model)</li> <li><strong>roberta</strong> — <code>FlaxRobertaForQuestionAnswering</code> (RoBERTa model)</li> <li><strong>roberta-prelayernorm</strong> — <code>FlaxRobertaPreLayerNormForQuestionAnswering</code> (RoBERTa-PreLayerNorm model)</li> <li><strong>roformer</strong> — <code>FlaxRoFormerForQuestionAnswering</code> (RoFormer model)</li> <li><strong>xlm-roberta</strong> — <code>FlaxXLMRobertaForQuestionAnswering</code> (XLM-RoBERTa model)</li>',XL,Ui,lw,Ff,dw,vf,Cf,cw,wf,mw,jf,xf,fw,$f,gw,kf,Z9="以下の自動クラスは、次のコンピュータービジョンタスクに利用可能です。",pw,Zf,uw,Ne,Af,DL,HM,A9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a depth estimation head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,HL,QM,L9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",QL,gr,Lf,YL,YM,B9="Instantiates one of the model classes of the library (with a depth estimation head) from a configuration.",zL,zM,R9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,OL,Pi,KL,q,Bf,eB,OM,W9="Instantiate one of the model classes of the library (with a depth estimation head) from a pretrained model.",oB,KM,J9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,tB,eT,G9="<li><strong>depth_anything</strong> — <code>DepthAnythingForDepthEstimation</code> (Depth Anything model)</li> <li><strong>dpt</strong> — <code>DPTForDepthEstimation</code> (DPT model)</li> <li><strong>glpn</strong> — <code>GLPNForDepthEstimation</code> (GLPN model)</li>",nB,oT,V9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,rB,qi,hw,Rf,bw,Xe,Wf,aB,tT,S9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,sB,nT,E9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",iB,pr,Jf,lB,rT,I9="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",dB,aT,U9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,cB,Ni,mB,N,Gf,fB,sT,P9="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",gB,iT,q9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,pB,lT,N9='<li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> (BEiT model)</li> <li><strong>bit</strong> — <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitForImageClassification">BitForImageClassification</a> (BiT model)</li> <li><strong>clip</strong> — <code>CLIPForImageClassification</code> (CLIP model)</li> <li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextForImageClassification">ConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.ConvNextV2ForImageClassification">ConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.CvtForImageClassification">CvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionForImageClassification">Data2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTForImageClassification">DeiTForImageClassification</a> or <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTForImageClassificationWithTeacher">DeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>dinat</strong> — <a href="/docs/transformers/main/ja/model_doc/dinat#transformers.DinatForImageClassification">DinatForImageClassification</a> (DiNAT model)</li> <li><strong>dinov2</strong> — <code>Dinov2ForImageClassification</code> (DINOv2 model)</li> <li><strong>efficientformer</strong> — <code>EfficientFormerForImageClassification</code> or <code>EfficientFormerForImageClassificationWithTeacher</code> (EfficientFormer model)</li> <li><strong>efficientnet</strong> — <code>EfficientNetForImageClassification</code> (EfficientNet model)</li> <li><strong>focalnet</strong> — <code>FocalNetForImageClassification</code> (FocalNet model)</li> <li><strong>imagegpt</strong> — <code>ImageGPTForImageClassification</code> (ImageGPT model)</li> <li><strong>levit</strong> — <code>LevitForImageClassification</code> or <code>LevitForImageClassificationWithTeacher</code> (LeViT model)</li> <li><strong>mobilenet_v1</strong> — <code>MobileNetV1ForImageClassification</code> (MobileNetV1 model)</li> <li><strong>mobilenet_v2</strong> — <code>MobileNetV2ForImageClassification</code> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <code>MobileViTForImageClassification</code> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <code>MobileViTV2ForImageClassification</code> (MobileViTV2 model)</li> <li><strong>nat</strong> — <code>NatForImageClassification</code> (NAT model)</li> <li><strong>perceiver</strong> — <code>PerceiverForImageClassificationLearned</code> or <code>PerceiverForImageClassificationFourier</code> or <code>PerceiverForImageClassificationConvProcessing</code> (Perceiver model)</li> <li><strong>poolformer</strong> — <code>PoolFormerForImageClassification</code> (PoolFormer model)</li> <li><strong>pvt</strong> — <code>PvtForImageClassification</code> (PVT model)</li> <li><strong>pvt_v2</strong> — <code>PvtV2ForImageClassification</code> (PVTv2 model)</li> <li><strong>regnet</strong> — <code>RegNetForImageClassification</code> (RegNet model)</li> <li><strong>resnet</strong> — <code>ResNetForImageClassification</code> (ResNet model)</li> <li><strong>segformer</strong> — <code>SegformerForImageClassification</code> (SegFormer model)</li> <li><strong>siglip</strong> — <code>SiglipForImageClassification</code> (SigLIP model)</li> <li><strong>swiftformer</strong> — <code>SwiftFormerForImageClassification</code> (SwiftFormer model)</li> <li><strong>swin</strong> — <code>SwinForImageClassification</code> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <code>Swinv2ForImageClassification</code> (Swin Transformer V2 model)</li> <li><strong>van</strong> — <code>VanForImageClassification</code> (VAN model)</li> <li><strong>vit</strong> — <code>ViTForImageClassification</code> (ViT model)</li> <li><strong>vit_hybrid</strong> — <code>ViTHybridForImageClassification</code> (ViT Hybrid model)</li> <li><strong>vit_msn</strong> — <code>ViTMSNForImageClassification</code> (ViTMSN model)</li>',uB,dT,X9=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,hB,Xi,_w,Vf,Mw,De,Sf,bB,cT,D9=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,_B,mT,H9="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",MB,ur,Ef,TB,fT,Q9="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",yB,gT,Y9=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,FB,Di,vB,ct,If,CB,pT,z9="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",wB,uT,O9=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,jB,hT,K9='<li><strong>convnext</strong> — <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.TFConvNextForImageClassification">TFConvNextForImageClassification</a> (ConvNeXT model)</li> <li><strong>convnextv2</strong> — <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.TFConvNextV2ForImageClassification">TFConvNextV2ForImageClassification</a> (ConvNeXTV2 model)</li> <li><strong>cvt</strong> — <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.TFCvtForImageClassification">TFCvtForImageClassification</a> (CvT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.TFData2VecVisionForImageClassification">TFData2VecVisionForImageClassification</a> (Data2VecVision model)</li> <li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.TFDeiTForImageClassification">TFDeiTForImageClassification</a> or <a href="/docs/transformers/main/ja/model_doc/deit#transformers.TFDeiTForImageClassificationWithTeacher">TFDeiTForImageClassificationWithTeacher</a> (DeiT model)</li> <li><strong>efficientformer</strong> — <code>TFEfficientFormerForImageClassification</code> or <code>TFEfficientFormerForImageClassificationWithTeacher</code> (EfficientFormer model)</li> <li><strong>mobilevit</strong> — <code>TFMobileViTForImageClassification</code> (MobileViT model)</li> <li><strong>regnet</strong> — <code>TFRegNetForImageClassification</code> (RegNet model)</li> <li><strong>resnet</strong> — <code>TFResNetForImageClassification</code> (ResNet model)</li> <li><strong>segformer</strong> — <code>TFSegformerForImageClassification</code> (SegFormer model)</li> <li><strong>swin</strong> — <code>TFSwinForImageClassification</code> (Swin Transformer model)</li> <li><strong>vit</strong> — <code>TFViTForImageClassification</code> (ViT model)</li>',xB,Hi,Tw,Uf,yw,He,Pf,$B,bT,eP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,kB,_T,oP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",ZB,hr,qf,AB,MT,tP="Instantiates one of the model classes of the library (with a image classification head) from a configuration.",LB,TT,nP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,BB,Qi,RB,mt,Nf,WB,yT,rP="Instantiate one of the model classes of the library (with a image classification head) from a pretrained model.",JB,FT,aP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,GB,vT,sP='<li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.FlaxBeitForImageClassification">FlaxBeitForImageClassification</a> (BEiT model)</li> <li><strong>regnet</strong> — <code>FlaxRegNetForImageClassification</code> (RegNet model)</li> <li><strong>resnet</strong> — <code>FlaxResNetForImageClassification</code> (ResNet model)</li> <li><strong>vit</strong> — <code>FlaxViTForImageClassification</code> (ViT model)</li>',VB,Yi,Fw,Xf,vw,Qe,Df,SB,CT,iP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a video classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,EB,wT,lP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",IB,br,Hf,UB,jT,dP="Instantiates one of the model classes of the library (with a video classification head) from a configuration.",PB,xT,cP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,qB,zi,NB,X,Qf,XB,$T,mP="Instantiate one of the model classes of the library (with a video classification head) from a pretrained model.",DB,kT,fP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,HB,ZT,gP="<li><strong>timesformer</strong> — <code>TimesformerForVideoClassification</code> (TimeSformer model)</li> <li><strong>videomae</strong> — <code>VideoMAEForVideoClassification</code> (VideoMAE model)</li> <li><strong>vivit</strong> — <code>VivitForVideoClassification</code> (ViViT model)</li>",QB,AT,pP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,YB,Oi,Cw,Yf,ww,Ye,zf,zB,LT,uP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,OB,BT,hP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",KB,_r,Of,eR,RT,bP="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",oR,WT,_P=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,tR,Ki,nR,D,Kf,rR,JT,MP="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",aR,GT,TP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,sR,VT,yP='<li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTForMaskedImageModeling">DeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>focalnet</strong> — <code>FocalNetForMaskedImageModeling</code> (FocalNet model)</li> <li><strong>swin</strong> — <code>SwinForMaskedImageModeling</code> (Swin Transformer model)</li> <li><strong>swinv2</strong> — <code>Swinv2ForMaskedImageModeling</code> (Swin Transformer V2 model)</li> <li><strong>vit</strong> — <code>ViTForMaskedImageModeling</code> (ViT model)</li>',iR,ST,FP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,lR,el,jw,eg,xw,ze,og,dR,ET,vP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a masked image modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,cR,IT,CP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",mR,Mr,tg,fR,UT,wP="Instantiates one of the model classes of the library (with a masked image modeling head) from a configuration.",gR,PT,jP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,pR,ol,uR,ft,ng,hR,qT,xP="Instantiate one of the model classes of the library (with a masked image modeling head) from a pretrained model.",bR,NT,$P=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,_R,XT,kP='<li><strong>deit</strong> — <a href="/docs/transformers/main/ja/model_doc/deit#transformers.TFDeiTForMaskedImageModeling">TFDeiTForMaskedImageModeling</a> (DeiT model)</li> <li><strong>swin</strong> — <code>TFSwinForMaskedImageModeling</code> (Swin Transformer model)</li>',MR,tl,$w,rg,kw,Oe,ag,TR,DT,ZP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a object detection head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,yR,HT,AP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",FR,Tr,sg,vR,QT,LP="Instantiates one of the model classes of the library (with a object detection head) from a configuration.",CR,YT,BP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,wR,nl,jR,H,ig,xR,zT,RP="Instantiate one of the model classes of the library (with a object detection head) from a pretrained model.",$R,OT,WP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,kR,KT,JP='<li><strong>conditional_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrForObjectDetection">ConditionalDetrForObjectDetection</a> (Conditional DETR model)</li> <li><strong>deformable_detr</strong> — <a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrForObjectDetection">DeformableDetrForObjectDetection</a> (Deformable DETR model)</li> <li><strong>deta</strong> — <a href="/docs/transformers/main/ja/model_doc/deta#transformers.DetaForObjectDetection">DetaForObjectDetection</a> (DETA model)</li> <li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrForObjectDetection">DetrForObjectDetection</a> (DETR model)</li> <li><strong>table-transformer</strong> — <code>TableTransformerForObjectDetection</code> (Table Transformer model)</li> <li><strong>yolos</strong> — <code>YolosForObjectDetection</code> (YOLOS model)</li>',ZR,ey,GP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,AR,rl,Zw,lg,Aw,Ke,dg,LR,oy,VP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a image segmentation head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,BR,ty,SP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",RR,yr,cg,WR,ny,EP="Instantiates one of the model classes of the library (with a image segmentation head) from a configuration.",JR,ry,IP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,GR,al,VR,Q,mg,SR,ay,UP="Instantiate one of the model classes of the library (with a image segmentation head) from a pretrained model.",ER,sy,PP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,IR,iy,qP='<li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li>',UR,ly,NP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,PR,sl,Lw,fg,Bw,gg,pg,Rw,ug,Ww,eo,hg,qR,dy,XP=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,NR,cy,DP="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",XR,Fr,bg,DR,my,HP="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",HR,fy,QP=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,QR,il,YR,Y,_g,zR,gy,YP="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",OR,py,zP=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,KR,uy,OP='<li><strong>beit</strong> — <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> (BEiT model)</li> <li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionForSemanticSegmentation">Data2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>dpt</strong> — <code>DPTForSemanticSegmentation</code> (DPT model)</li> <li><strong>mobilenet_v2</strong> — <code>MobileNetV2ForSemanticSegmentation</code> (MobileNetV2 model)</li> <li><strong>mobilevit</strong> — <code>MobileViTForSemanticSegmentation</code> (MobileViT model)</li> <li><strong>mobilevitv2</strong> — <code>MobileViTV2ForSemanticSegmentation</code> (MobileViTV2 model)</li> <li><strong>segformer</strong> — <code>SegformerForSemanticSegmentation</code> (SegFormer model)</li> <li><strong>upernet</strong> — <code>UperNetForSemanticSegmentation</code> (UPerNet model)</li>',e0,hy,KP=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,o0,ll,Jw,Mg,Gw,oo,Tg,t0,by,e5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a semantic segmentation head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,n0,_y,o5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",r0,vr,yg,a0,My,t5="Instantiates one of the model classes of the library (with a semantic segmentation head) from a configuration.",s0,Ty,n5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,i0,dl,l0,gt,Fg,d0,yy,r5="Instantiate one of the model classes of the library (with a semantic segmentation head) from a pretrained model.",c0,Fy,a5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,m0,vy,s5='<li><strong>data2vec-vision</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.TFData2VecVisionForSemanticSegmentation">TFData2VecVisionForSemanticSegmentation</a> (Data2VecVision model)</li> <li><strong>mobilevit</strong> — <code>TFMobileViTForSemanticSegmentation</code> (MobileViT model)</li> <li><strong>segformer</strong> — <code>TFSegformerForSemanticSegmentation</code> (SegFormer model)</li>',f0,cl,Vw,vg,Sw,to,Cg,g0,Cy,i5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a instance segmentation head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,p0,wy,l5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",u0,Cr,wg,h0,jy,d5="Instantiates one of the model classes of the library (with a instance segmentation head) from a configuration.",b0,xy,c5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,_0,ml,M0,z,jg,T0,$y,m5="Instantiate one of the model classes of the library (with a instance segmentation head) from a pretrained model.",y0,ky,f5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,F0,Zy,g5="<li><strong>maskformer</strong> — <code>MaskFormerForInstanceSegmentation</code> (MaskFormer model)</li>",v0,Ay,p5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,C0,fl,Ew,xg,Iw,no,$g,w0,Ly,u5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a universal image segmentation head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,j0,By,h5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",x0,wr,kg,$0,Ry,b5="Instantiates one of the model classes of the library (with a universal image segmentation head) from a configuration.",k0,Wy,_5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,Z0,gl,A0,O,Zg,L0,Jy,M5="Instantiate one of the model classes of the library (with a universal image segmentation head) from a pretrained model.",B0,Gy,T5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,R0,Vy,y5='<li><strong>detr</strong> — <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrForSegmentation">DetrForSegmentation</a> (DETR model)</li> <li><strong>mask2former</strong> — <code>Mask2FormerForUniversalSegmentation</code> (Mask2Former model)</li> <li><strong>maskformer</strong> — <code>MaskFormerForInstanceSegmentation</code> (MaskFormer model)</li> <li><strong>oneformer</strong> — <code>OneFormerForUniversalSegmentation</code> (OneFormer model)</li>',W0,Sy,F5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,J0,pl,Uw,Ag,Pw,ro,Lg,G0,Ey,v5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,V0,Iy,C5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",S0,jr,Bg,E0,Uy,w5="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",I0,Py,j5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,U0,ul,P0,K,Rg,q0,qy,x5="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",N0,Ny,$5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,X0,Xy,k5='<li><strong>align</strong> — <a href="/docs/transformers/main/ja/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li> <li><strong>altclip</strong> — <a href="/docs/transformers/main/ja/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li> <li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li> <li><strong>chinese_clip</strong> — <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li> <li><strong>clipseg</strong> — <a href="/docs/transformers/main/ja/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li> <li><strong>siglip</strong> — <code>SiglipModel</code> (SigLIP model)</li>',D0,Dy,Z5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,H0,hl,qw,Wg,Nw,ao,Jg,Q0,Hy,A5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot image classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,Y0,Qy,L5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",z0,xr,Gg,O0,Yy,B5="Instantiates one of the model classes of the library (with a zero-shot image classification head) from a configuration.",K0,zy,R5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,eW,bl,oW,pt,Vg,tW,Oy,W5="Instantiate one of the model classes of the library (with a zero-shot image classification head) from a pretrained model.",nW,Ky,J5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,rW,eF,G5='<li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li> <li><strong>clip</strong> — <a href="/docs/transformers/main/ja/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>',aW,_l,Xw,Sg,Dw,so,Eg,sW,oF,V5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a zero-shot object detection head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,iW,tF,S5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",lW,$r,Ig,dW,nF,E5="Instantiates one of the model classes of the library (with a zero-shot object detection head) from a configuration.",cW,rF,I5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,mW,Ml,fW,ee,Ug,gW,aF,U5="Instantiate one of the model classes of the library (with a zero-shot object detection head) from a pretrained model.",pW,sF,P5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,uW,iF,q5="<li><strong>owlv2</strong> — <code>Owlv2ForObjectDetection</code> (OWLv2 model)</li> <li><strong>owlvit</strong> — <code>OwlViTForObjectDetection</code> (OWL-ViT model)</li>",hW,lF,N5=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,bW,Tl,Hw,Pg,Qw,qg,X5="以下の自動クラスは、次の音声タスクに利用可能です。",Yw,Ng,zw,io,Xg,_W,dF,D5=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,MW,cF,H5="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",TW,kr,Dg,yW,mF,Q5="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",FW,fF,Y5=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,vW,yl,CW,oe,Hg,wW,gF,z5="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",jW,pF,O5=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,xW,uF,K5='<li><strong>audio-spectrogram-transformer</strong> — <a href="/docs/transformers/main/ja/model_doc/audio-spectrogram-transformer#transformers.ASTForAudioClassification">ASTForAudioClassification</a> (Audio Spectrogram Transformer model)</li> <li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioForSequenceClassification">Data2VecAudioForSequenceClassification</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <code>HubertForSequenceClassification</code> (Hubert model)</li> <li><strong>sew</strong> — <code>SEWForSequenceClassification</code> (SEW model)</li> <li><strong>sew-d</strong> — <code>SEWDForSequenceClassification</code> (SEW-D model)</li> <li><strong>unispeech</strong> — <code>UniSpeechForSequenceClassification</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatForSequenceClassification</code> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForSequenceClassification</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2BertForSequenceClassification</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerForSequenceClassification</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>WavLMForSequenceClassification</code> (WavLM model)</li> <li><strong>whisper</strong> — <code>WhisperForAudioClassification</code> (Whisper model)</li>',$W,hF,e4=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,kW,Fl,Ow,Qg,Kw,lo,Yg,ZW,bF,o4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,AW,_F,t4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",LW,Zr,zg,BW,MF,n4="Instantiates one of the model classes of the library (with a audio classification head) from a configuration.",RW,TF,r4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WW,vl,JW,ut,Og,GW,yF,a4="Instantiate one of the model classes of the library (with a audio classification head) from a pretrained model.",VW,FF,s4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,SW,vF,i4="<li><strong>wav2vec2</strong> — <code>TFWav2Vec2ForSequenceClassification</code> (Wav2Vec2 model)</li>",EW,Cl,ej,Kg,oj,co,ep,IW,CF,l4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio frame (token) classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,UW,wF,d4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",PW,Ar,op,qW,jF,c4="Instantiates one of the model classes of the library (with a audio frame (token) classification head) from a configuration.",NW,xF,m4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,XW,wl,DW,te,tp,HW,$F,f4="Instantiate one of the model classes of the library (with a audio frame (token) classification head) from a pretrained model.",QW,kF,g4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,YW,ZF,p4='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioForAudioFrameClassification">Data2VecAudioForAudioFrameClassification</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatForAudioFrameClassification</code> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForAudioFrameClassification</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2BertForAudioFrameClassification</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerForAudioFrameClassification</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>WavLMForAudioFrameClassification</code> (WavLM model)</li>',zW,AF,u4=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,OW,jl,tj,np,nj,mo,rp,KW,LF,h4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a connectionist temporal classification head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,eJ,BF,b4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",oJ,Lr,ap,tJ,RF,_4="Instantiates one of the model classes of the library (with a connectionist temporal classification head) from a configuration.",nJ,WF,M4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,rJ,xl,aJ,ne,sp,sJ,JF,T4="Instantiate one of the model classes of the library (with a connectionist temporal classification head) from a pretrained model.",iJ,GF,y4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,lJ,VF,F4='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioForCTC">Data2VecAudioForCTC</a> (Data2VecAudio model)</li> <li><strong>hubert</strong> — <code>HubertForCTC</code> (Hubert model)</li> <li><strong>mctct</strong> — <code>MCTCTForCTC</code> (M-CTC-T model)</li> <li><strong>sew</strong> — <code>SEWForCTC</code> (SEW model)</li> <li><strong>sew-d</strong> — <code>SEWDForCTC</code> (SEW-D model)</li> <li><strong>unispeech</strong> — <code>UniSpeechForCTC</code> (UniSpeech model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatForCTC</code> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForCTC</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2BertForCTC</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerForCTC</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>WavLMForCTC</code> (WavLM model)</li>',dJ,SF,v4=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,cJ,$l,rj,ip,aj,fo,lp,mJ,EF,C4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,fJ,IF,w4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",gJ,Br,dp,pJ,UF,j4="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",uJ,PF,x4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,hJ,kl,bJ,re,cp,_J,qF,$4="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",MJ,NF,k4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,TJ,XF,Z4="<li><strong>pop2piano</strong> — <code>Pop2PianoForConditionalGeneration</code> (Pop2Piano model)</li> <li><strong>seamless_m4t</strong> — <code>SeamlessM4TForSpeechToText</code> (SeamlessM4T model)</li> <li><strong>seamless_m4t_v2</strong> — <code>SeamlessM4Tv2ForSpeechToText</code> (SeamlessM4Tv2 model)</li> <li><strong>speech-encoder-decoder</strong> — <code>SpeechEncoderDecoderModel</code> (Speech Encoder decoder model)</li> <li><strong>speech_to_text</strong> — <code>Speech2TextForConditionalGeneration</code> (Speech2Text model)</li> <li><strong>speecht5</strong> — <code>SpeechT5ForSpeechToText</code> (SpeechT5 model)</li> <li><strong>whisper</strong> — <code>WhisperForConditionalGeneration</code> (Whisper model)</li>",yJ,DF,A4=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,FJ,Zl,sj,mp,ij,go,fp,vJ,HF,L4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,CJ,QF,B4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",wJ,Rr,gp,jJ,YF,R4="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",xJ,zF,W4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,$J,Al,kJ,ht,pp,ZJ,OF,J4="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",AJ,KF,G4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,LJ,ev,V4="<li><strong>speech_to_text</strong> — <code>TFSpeech2TextForConditionalGeneration</code> (Speech2Text model)</li> <li><strong>whisper</strong> — <code>TFWhisperForConditionalGeneration</code> (Whisper model)</li>",BJ,Ll,lj,up,dj,po,hp,RJ,ov,S4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,WJ,tv,E4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",JJ,Wr,bp,GJ,nv,I4="Instantiates one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a configuration.",VJ,rv,U4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,SJ,Bl,EJ,bt,_p,IJ,av,P4="Instantiate one of the model classes of the library (with a sequence-to-sequence speech-to-text modeling head) from a pretrained model.",UJ,sv,q4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,PJ,iv,N4="<li><strong>speech-encoder-decoder</strong> — <code>FlaxSpeechEncoderDecoderModel</code> (Speech Encoder decoder model)</li> <li><strong>whisper</strong> — <code>FlaxWhisperForConditionalGeneration</code> (Whisper model)</li>",qJ,Rl,cj,Mp,mj,uo,Tp,NJ,lv,X4=`This is a generic model class that will be instantiated as one of the model classes of the library (with a audio retrieval via x-vector head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,XJ,dv,D4="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",DJ,Jr,yp,HJ,cv,H4="Instantiates one of the model classes of the library (with a audio retrieval via x-vector head) from a configuration.",QJ,mv,Q4=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,YJ,Wl,zJ,ae,Fp,OJ,fv,Y4="Instantiate one of the model classes of the library (with a audio retrieval via x-vector head) from a pretrained model.",KJ,gv,z4=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,eG,pv,O4='<li><strong>data2vec-audio</strong> — <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioForXVector">Data2VecAudioForXVector</a> (Data2VecAudio model)</li> <li><strong>unispeech-sat</strong> — <code>UniSpeechSatForXVector</code> (UniSpeechSat model)</li> <li><strong>wav2vec2</strong> — <code>Wav2Vec2ForXVector</code> (Wav2Vec2 model)</li> <li><strong>wav2vec2-bert</strong> — <code>Wav2Vec2BertForXVector</code> (Wav2Vec2-BERT model)</li> <li><strong>wav2vec2-conformer</strong> — <code>Wav2Vec2ConformerForXVector</code> (Wav2Vec2-Conformer model)</li> <li><strong>wavlm</strong> — <code>WavLMForXVector</code> (WavLM model)</li>',oG,uv,K4=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,tG,Jl,fj,vp,gj,Cp,wp,pj,jp,uj,xp,$p,hj,kp,bj,Zp,eq="以下の自動クラスは、次のマルチモーダルタスクに利用可能です。",_j,Ap,Mj,ho,Lp,nG,hv,oq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,rG,bv,tq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",aG,Gr,Bp,sG,_v,nq="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",iG,Mv,rq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,lG,Gl,dG,se,Rp,cG,Tv,aq="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",mG,yv,sq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,fG,Fv,iq="<li><strong>tapas</strong> — <code>TapasForQuestionAnswering</code> (TAPAS model)</li>",gG,vv,lq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,pG,Vl,Tj,Wp,yj,bo,Jp,uG,Cv,dq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a table question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,hG,wv,cq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",bG,Vr,Gp,_G,jv,mq="Instantiates one of the model classes of the library (with a table question answering head) from a configuration.",MG,xv,fq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,TG,Sl,yG,_t,Vp,FG,$v,gq="Instantiate one of the model classes of the library (with a table question answering head) from a pretrained model.",vG,kv,pq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,CG,Zv,uq="<li><strong>tapas</strong> — <code>TFTapasForQuestionAnswering</code> (TAPAS model)</li>",wG,El,Fj,Sp,vj,_o,Ep,jG,Av,hq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,xG,Lv,bq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",$G,Sr,Ip,kG,Bv,_q="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",ZG,Rv,Mq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,AG,Il,LG,ie,Up,BG,Wv,Tq="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",RG,Jv,yq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,WG,Gv,Fq="<li><strong>layoutlm</strong> — <code>LayoutLMForQuestionAnswering</code> (LayoutLM model)</li> <li><strong>layoutlmv2</strong> — <code>LayoutLMv2ForQuestionAnswering</code> (LayoutLMv2 model)</li> <li><strong>layoutlmv3</strong> — <code>LayoutLMv3ForQuestionAnswering</code> (LayoutLMv3 model)</li>",JG,Vv,vq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,GG,Ul,Cj,Pp,wj,Mo,qp,VG,Sv,Cq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a document question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,SG,Ev,wq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",EG,Er,Np,IG,Iv,jq="Instantiates one of the model classes of the library (with a document question answering head) from a configuration.",UG,Uv,xq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,PG,Pl,qG,Mt,Xp,NG,Pv,$q="Instantiate one of the model classes of the library (with a document question answering head) from a pretrained model.",XG,qv,kq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,DG,Nv,Zq="<li><strong>layoutlm</strong> — <code>TFLayoutLMForQuestionAnswering</code> (LayoutLM model)</li> <li><strong>layoutlmv3</strong> — <code>TFLayoutLMv3ForQuestionAnswering</code> (LayoutLMv3 model)</li>",HG,ql,jj,Dp,xj,To,Hp,QG,Xv,Aq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a visual question answering head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,YG,Dv,Lq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",zG,Ir,Qp,OG,Hv,Bq="Instantiates one of the model classes of the library (with a visual question answering head) from a configuration.",KG,Qv,Rq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,eV,Nl,oV,le,Yp,tV,Yv,Wq="Instantiate one of the model classes of the library (with a visual question answering head) from a pretrained model.",nV,zv,Jq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,rV,Ov,Gq='<li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipForQuestionAnswering">BlipForQuestionAnswering</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>vilt</strong> — <code>ViltForQuestionAnswering</code> (ViLT model)</li>',aV,Kv,Vq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,sV,Xl,$j,zp,kj,yo,Op,iV,eC,Sq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,lV,oC,Eq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",dV,Ur,Kp,cV,tC,Iq="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",mV,nC,Uq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,fV,Dl,gV,de,eu,pV,rC,Pq="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",uV,aC,qq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,hV,sC,Nq='<li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipForConditionalGeneration">BlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>blip-2</strong> — <a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2ForConditionalGeneration">Blip2ForConditionalGeneration</a> (BLIP-2 model)</li> <li><strong>git</strong> — <code>GitForCausalLM</code> (GIT model)</li> <li><strong>instructblip</strong> — <code>InstructBlipForConditionalGeneration</code> (InstructBLIP model)</li> <li><strong>kosmos-2</strong> — <code>Kosmos2ForConditionalGeneration</code> (KOSMOS-2 model)</li> <li><strong>llava</strong> — <code>LlavaForConditionalGeneration</code> (LLaVa model)</li> <li><strong>pix2struct</strong> — <code>Pix2StructForConditionalGeneration</code> (Pix2Struct model)</li> <li><strong>vipllava</strong> — <code>VipLlavaForConditionalGeneration</code> (VipLlava model)</li> <li><strong>vision-encoder-decoder</strong> — <code>VisionEncoderDecoderModel</code> (Vision Encoder decoder model)</li>',bV,iC,Xq=`The model is set in evaluation mode by default using <code>model.eval()</code> (so for instance, dropout modules are
deactivated). To train the model, you should first set it back in training mode with <code>model.train()</code>`,_V,Hl,Zj,ou,Aj,Fo,tu,MV,lC,Dq=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,TV,dC,Hq="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",yV,Pr,nu,FV,cC,Qq="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",vV,mC,Yq=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,CV,Ql,wV,Tt,ru,jV,fC,zq="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",xV,gC,Oq=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,$V,pC,Kq='<li><strong>blip</strong> — <a href="/docs/transformers/main/ja/model_doc/blip#transformers.TFBlipForConditionalGeneration">TFBlipForConditionalGeneration</a> (BLIP model)</li> <li><strong>vision-encoder-decoder</strong> — <code>TFVisionEncoderDecoderModel</code> (Vision Encoder decoder model)</li>',kV,Yl,Lj,au,Bj,vo,su,ZV,uC,eN=`This is a generic model class that will be instantiated as one of the model classes of the library (with a vision-to-text modeling head) when created
with the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> class method or the <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_config">from_config()</a> class
method.`,AV,hC,oN="This class cannot be instantiated directly using <code>__init__()</code> (throws an error).",LV,qr,iu,BV,bC,tN="Instantiates one of the model classes of the library (with a vision-to-text modeling head) from a configuration.",RV,_C,nN=`Note:
Loading a model from its configuration file does <strong>not</strong> load the model weights. It only affects the
model’s configuration. Use <a href="/docs/transformers/main/ja/model_doc/auto#transformers.FlaxAutoModelForVision2Seq.from_pretrained">from_pretrained()</a> to load the model weights.`,WV,zl,JV,yt,lu,GV,MC,rN="Instantiate one of the model classes of the library (with a vision-to-text modeling head) from a pretrained model.",VV,TC,aN=`The model class to instantiate is selected based on the <code>model_type</code> property of the config object (either
passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible), or when it’s missing, by
falling back to using pattern matching on <code>pretrained_model_name_or_path</code>:`,SV,yC,sN="<li><strong>vision-encoder-decoder</strong> — <code>FlaxVisionEncoderDecoderModel</code> (Vision Encoder decoder model)</li>",EV,Ol,Rj,FC,Wj;return m=new Z({props:{title:"Auto Classes",local:"auto-classes",headingTag:"h1"}}),Cd=new $({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLWNhc2VkJTIyKQ==",highlighted:'model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)',wrap:!1}}),xd=new Z({props:{title:"自動クラスの拡張",local:"自動クラスの拡張",headingTag:"h2"}}),kd=new $({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMEElMEFBdXRvQ29uZmlnLnJlZ2lzdGVyKCUyMm5ldy1tb2RlbCUyMiUyQyUyME5ld01vZGVsQ29uZmlnKSUwQUF1dG9Nb2RlbC5yZWdpc3RlcihOZXdNb2RlbENvbmZpZyUyQyUyME5ld01vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel

AutoConfig.register(<span class="hljs-string">&quot;new-model&quot;</span>, NewModelConfig)
AutoModel.register(NewModelConfig, NewModel)`,wrap:!1}}),vs=new Jj({props:{warning:!0,$$slots:{default:[uN]},$$scope:{ctx:v}}}),Ad=new Z({props:{title:"AutoConfig",local:"transformers.AutoConfig",headingTag:"h2"}}),Ld=new j({props:{name:"class transformers.AutoConfig",anchor:"transformers.AutoConfig",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/configuration_auto.py#L1005"}}),Bd=new j({props:{name:"from_pretrained",anchor:"transformers.AutoConfig.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoConfig.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>A path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.save_pretrained">save_pretrained()</a> method, or the <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> method,
e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a saved configuration JSON <em>file</em>, e.g.,
<code>./my_model_directory/configuration.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoConfig.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoConfig.from_pretrained.kwargs(additional",description:`<strong>kwargs(additional</strong> keyword arguments, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs(additional"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/configuration_auto.py#L1028"}}),Cs=new k({props:{anchor:"transformers.AutoConfig.from_pretrained.example",$$slots:{default:[hN]},$$scope:{ctx:v}}}),Rd=new j({props:{name:"register",anchor:"transformers.AutoConfig.register",parameters:[{name:"model_type",val:""},{name:"config",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoConfig.register.model_type",description:"<strong>model_type</strong> (<code>str</code>) &#x2014; The model type like &#x201C;bert&#x201D; or &#x201C;gpt&#x201D;.",name:"model_type"},{anchor:"transformers.AutoConfig.register.config",description:'<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014; The config to register.',name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/configuration_auto.py#L1167"}}),Wd=new Z({props:{title:"AutoTokenizer",local:"transformers.AutoTokenizer",headingTag:"h2"}}),Jd=new j({props:{name:"class transformers.AutoTokenizer",anchor:"transformers.AutoTokenizer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/tokenization_auto.py#L637"}}),Gd=new j({props:{name:"from_pretrained",anchor:"transformers.AutoTokenizer.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"*inputs",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoTokenizer.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a single saved vocabulary file if and only if the tokenizer only requires a
single vocabulary file (like Bert or XLNet), e.g.: <code>./my_model_directory/vocab.txt</code>. (Not
applicable to all derived classes)</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoTokenizer.from_pretrained.inputs",description:`<strong>inputs</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the Tokenizer <code>__init__()</code> method.`,name:"inputs"},{anchor:"transformers.AutoTokenizer.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
The configuration object used to determine the tokenizer class to instantiate.`,name:"config"},{anchor:"transformers.AutoTokenizer.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoTokenizer.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download the model weights and configuration files and override the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoTokenizer.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoTokenizer.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoTokenizer.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co (e.g. for
facebook/rag-token-base), specify it here.`,name:"subfolder"},{anchor:"transformers.AutoTokenizer.from_pretrained.use_fast",description:`<strong>use_fast</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Use a <a href="https://huggingface.co/docs/tokenizers/index" rel="nofollow">fast Rust-based tokenizer</a> if it is supported for
a given model. If a fast tokenizer is not available for a given model, a normal Python-based tokenizer
is returned instead.`,name:"use_fast"},{anchor:"transformers.AutoTokenizer.from_pretrained.tokenizer_type",description:`<strong>tokenizer_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Tokenizer type to be loaded.`,name:"tokenizer_type"},{anchor:"transformers.AutoTokenizer.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoTokenizer.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Will be passed to the Tokenizer <code>__init__()</code> method. Can be used to set special tokens like
<code>bos_token</code>, <code>eos_token</code>, <code>unk_token</code>, <code>sep_token</code>, <code>pad_token</code>, <code>cls_token</code>, <code>mask_token</code>,
<code>additional_special_tokens</code>. See parameters in the <code>__init__()</code> for more details.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/tokenization_auto.py#L651"}}),js=new k({props:{anchor:"transformers.AutoTokenizer.from_pretrained.example",$$slots:{default:[bN]},$$scope:{ctx:v}}}),Vd=new j({props:{name:"register",anchor:"transformers.AutoTokenizer.register",parameters:[{name:"config_class",val:""},{name:"slow_tokenizer_class",val:" = None"},{name:"fast_tokenizer_class",val:" = None"},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoTokenizer.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoTokenizer.register.slow_tokenizer_class",description:`<strong>slow_tokenizer_class</strong> (<code>PretrainedTokenizer</code>, <em>optional</em>) &#x2014;
The slow tokenizer to register.`,name:"slow_tokenizer_class"},{anchor:"transformers.AutoTokenizer.register.fast_tokenizer_class",description:`<strong>fast_tokenizer_class</strong> (<code>PretrainedTokenizerFast</code>, <em>optional</em>) &#x2014;
The fast tokenizer to register.`,name:"fast_tokenizer_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/tokenization_auto.py#L868"}}),Sd=new Z({props:{title:"AutoFeatureExtractor",local:"transformers.AutoFeatureExtractor",headingTag:"h2"}}),Ed=new j({props:{name:"class transformers.AutoFeatureExtractor",anchor:"transformers.AutoFeatureExtractor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/feature_extraction_auto.py#L238"}}),Id=new j({props:{name:"from_pretrained",anchor:"transformers.AutoFeatureExtractor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/main/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoFeatureExtractor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/feature_extraction_auto.py#L252"}}),$s=new Jj({props:{$$slots:{default:[_N]},$$scope:{ctx:v}}}),ks=new k({props:{anchor:"transformers.AutoFeatureExtractor.from_pretrained.example",$$slots:{default:[MN]},$$scope:{ctx:v}}}),Ud=new j({props:{name:"register",anchor:"transformers.AutoFeatureExtractor.register",parameters:[{name:"config_class",val:""},{name:"feature_extractor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoFeatureExtractor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoFeatureExtractor.register.feature_extractor_class",description:"<strong>feature_extractor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The feature extractor to register.",name:"feature_extractor_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/feature_extraction_auto.py#L386"}}),Pd=new Z({props:{title:"AutoImageProcessor",local:"transformers.AutoImageProcessor",headingTag:"h2"}}),qd=new j({props:{name:"class transformers.AutoImageProcessor",anchor:"transformers.AutoImageProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/image_processing_auto.py#L254"}}),Nd=new j({props:{name:"from_pretrained",anchor:"transformers.AutoImageProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained image_processor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a image processor file saved using the
<a href="/docs/transformers/main/ja/internal/image_processing_utils#transformers.ImageProcessingMixin.save_pretrained">save_pretrained()</a> method, e.g.,
<code>./my_model_directory/</code>.</li>
<li>a path or url to a saved image processor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoImageProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model image processor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoImageProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the image processor files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoImageProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoImageProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoImageProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoImageProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final image processor object. If <code>True</code>, then this
functions returns a <code>Tuple(image_processor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not image processor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>image_processor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoImageProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoImageProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are image processor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> image processor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/image_processing_auto.py#L268"}}),As=new Jj({props:{$$slots:{default:[TN]},$$scope:{ctx:v}}}),Ls=new k({props:{anchor:"transformers.AutoImageProcessor.from_pretrained.example",$$slots:{default:[yN]},$$scope:{ctx:v}}}),Xd=new j({props:{name:"register",anchor:"transformers.AutoImageProcessor.register",parameters:[{name:"config_class",val:""},{name:"image_processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoImageProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoImageProcessor.register.image_processor_class",description:'<strong>image_processor_class</strong> (<a href="/docs/transformers/main/ja/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a>) &#x2014; The image processor to register.',name:"image_processor_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/image_processing_auto.py#L424"}}),Dd=new Z({props:{title:"AutoProcessor",local:"transformers.AutoProcessor",headingTag:"h2"}}),Hd=new j({props:{name:"class transformers.AutoProcessor",anchor:"transformers.AutoProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/processing_auto.py#L129"}}),Qd=new j({props:{name:"from_pretrained",anchor:"transformers.AutoProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a processor files saved using the <code>save_pretrained()</code> method,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoProcessor.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model feature extractor should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoProcessor.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the feature extractor files and override the cached versions
if they exist.`,name:"force_download"},{anchor:"transformers.AutoProcessor.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.AutoProcessor.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoProcessor.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.AutoProcessor.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoProcessor.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final feature extractor object. If <code>True</code>, then this
functions returns a <code>Tuple(feature_extractor, unused_kwargs)</code> where <em>unused_kwargs</em> is a dictionary
consisting of the key/value pairs whose keys are not feature extractor attributes: i.e., the part of
<code>kwargs</code> which has not been used to update <code>feature_extractor</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.AutoProcessor.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoProcessor.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are feature extractor attributes will be used to override the
loaded values. Behavior concerning key/value pairs whose keys are <em>not</em> feature extractor attributes is
controlled by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/processing_auto.py#L143"}}),Rs=new Jj({props:{$$slots:{default:[FN]},$$scope:{ctx:v}}}),Ws=new k({props:{anchor:"transformers.AutoProcessor.from_pretrained.example",$$slots:{default:[vN]},$$scope:{ctx:v}}}),Yd=new j({props:{name:"register",anchor:"transformers.AutoProcessor.register",parameters:[{name:"config_class",val:""},{name:"processor_class",val:""},{name:"exist_ok",val:" = False"}],parametersDescription:[{anchor:"transformers.AutoProcessor.register.config_class",description:`<strong>config_class</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The configuration corresponding to the model to register.`,name:"config_class"},{anchor:"transformers.AutoProcessor.register.processor_class",description:"<strong>processor_class</strong> (<code>FeatureExtractorMixin</code>) &#x2014; The processor to register.",name:"processor_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/processing_auto.py#L346"}}),zd=new Z({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Kd=new Z({props:{title:"AutoModel",local:"transformers.AutoModel",headingTag:"h3"}}),ec=new j({props:{name:"class transformers.AutoModel",anchor:"transformers.AutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1385"}}),oc=new j({props:{name:"from_config",anchor:"transformers.AutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/audio-spectrogram-transformer#transformers.ASTConfig">ASTConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/audio-spectrogram-transformer#transformers.ASTModel">ASTModel</a> (Audio Spectrogram Transformer model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertModel">AlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/align#transformers.AlignConfig">AlignConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/align#transformers.AlignModel">AlignModel</a> (ALIGN model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/altclip#transformers.AltCLIPConfig">AltCLIPConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/altclip#transformers.AltCLIPModel">AltCLIPModel</a> (AltCLIP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/autoformer#transformers.AutoformerConfig">AutoformerConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/autoformer#transformers.AutoformerModel">AutoformerModel</a> (Autoformer model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bark#transformers.BarkConfig">BarkConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bark#transformers.BarkModel">BarkModel</a> (Bark model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartModel">BartModel</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitModel">BeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertModel">BertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationEncoder">BertGenerationEncoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdModel">BigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusModel">BigBirdPegasusModel</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptModel">BioGptModel</a> (BioGpt model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitConfig">BitConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bit#transformers.BitModel">BitModel</a> (BiT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotModel">BlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallModel">BlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2Config">Blip2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blip-2#transformers.Blip2Model">Blip2Model</a> (BLIP-2 model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipModel">BlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomModel">BloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bridgetower#transformers.BridgeTowerConfig">BridgeTowerConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bridgetower#transformers.BridgeTowerModel">BridgeTowerModel</a> (BridgeTower model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bros#transformers.BrosConfig">BrosConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bros#transformers.BrosModel">BrosModel</a> (BROS model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPModel">CLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> (CLIPSeg model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPVisionConfig">CLIPVisionConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPVisionModel">CLIPVisionModel</a> (CLIPVisionModel model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLModel">CTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertModel">CamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineConfig">CanineConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineModel">CanineModel</a> (CANINE model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPConfig">ChineseCLIPConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPModel">ChineseCLIPModel</a> (Chinese-CLIP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPVisionConfig">ChineseCLIPVisionConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/chinese_clip#transformers.ChineseCLIPVisionModel">ChineseCLIPVisionModel</a> (ChineseCLIPVisionModel model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clap#transformers.ClapConfig">ClapConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clap#transformers.ClapModel">ClapModel</a> (CLAP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpConfig">ClvpConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clvp#transformers.ClvpModelForConditionalGeneration">ClvpModelForConditionalGeneration</a> (CLVP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenModel">CodeGenModel</a> (CodeGen model)</li>
<li><code>CohereConfig</code> configuration class: <code>CohereModel</code> (Cohere model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrConfig">ConditionalDetrConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/conditional_detr#transformers.ConditionalDetrModel">ConditionalDetrModel</a> (Conditional DETR model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertModel">ConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextModel">ConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.ConvNextV2Model">ConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntModel">CpmAntModel</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.CvtModel">CvtModel</a> (CvT model)</li>
<li><code>DPRConfig</code> configuration class: <code>DPRQuestionEncoder</code> (DPR model)</li>
<li><code>DPTConfig</code> configuration class: <code>DPTModel</code> (DPT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioConfig">Data2VecAudioConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecAudioModel">Data2VecAudioModel</a> (Data2VecAudio model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextModel">Data2VecTextModel</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionModel">Data2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaModel">DebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Model">DebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/decision_transformer#transformers.DecisionTransformerConfig">DecisionTransformerConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/decision_transformer#transformers.DecisionTransformerModel">DecisionTransformerModel</a> (Decision Transformer model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrConfig">DeformableDetrConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deformable_detr#transformers.DeformableDetrModel">DeformableDetrModel</a> (Deformable DETR model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTModel">DeiTModel</a> (DeiT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deta#transformers.DetaConfig">DetaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deta#transformers.DetaModel">DetaModel</a> (DETA model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrConfig">DetrConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/detr#transformers.DetrModel">DetrModel</a> (DETR model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/dinat#transformers.DinatConfig">DinatConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/dinat#transformers.DinatModel">DinatModel</a> (DiNAT model)</li>
<li><code>Dinov2Config</code> configuration class: <code>Dinov2Model</code> (DINOv2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>DistilBertModel</code> (DistilBERT model)</li>
<li><code>DonutSwinConfig</code> configuration class: <code>DonutSwinModel</code> (DonutSwin model)</li>
<li><code>EfficientFormerConfig</code> configuration class: <code>EfficientFormerModel</code> (EfficientFormer model)</li>
<li><code>EfficientNetConfig</code> configuration class: <code>EfficientNetModel</code> (EfficientNet model)</li>
<li><code>ElectraConfig</code> configuration class: <code>ElectraModel</code> (ELECTRA model)</li>
<li><code>EncodecConfig</code> configuration class: <code>EncodecModel</code> (EnCodec model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieModel</code> (ERNIE model)</li>
<li><code>ErnieMConfig</code> configuration class: <code>ErnieMModel</code> (ErnieM model)</li>
<li><code>EsmConfig</code> configuration class: <code>EsmModel</code> (ESM model)</li>
<li><code>FNetConfig</code> configuration class: <code>FNetModel</code> (FNet model)</li>
<li><code>FSMTConfig</code> configuration class: <code>FSMTModel</code> (FairSeq Machine-Translation model)</li>
<li><code>FalconConfig</code> configuration class: <code>FalconModel</code> (Falcon model)</li>
<li><code>FastSpeech2ConformerConfig</code> configuration class: <code>FastSpeech2ConformerModel</code> (FastSpeech2Conformer model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>FlaubertModel</code> (FlauBERT model)</li>
<li><code>FlavaConfig</code> configuration class: <code>FlavaModel</code> (FLAVA model)</li>
<li><code>FocalNetConfig</code> configuration class: <code>FocalNetModel</code> (FocalNet model)</li>
<li><code>FunnelConfig</code> configuration class: <code>FunnelModel</code> or <code>FunnelBaseModel</code> (Funnel Transformer model)</li>
<li><code>GLPNConfig</code> configuration class: <code>GLPNModel</code> (GLPN model)</li>
<li><code>GPT2Config</code> configuration class: <code>GPT2Model</code> (OpenAI GPT-2 model)</li>
<li><code>GPTBigCodeConfig</code> configuration class: <code>GPTBigCodeModel</code> (GPTBigCode model)</li>
<li><code>GPTJConfig</code> configuration class: <code>GPTJModel</code> (GPT-J model)</li>
<li><code>GPTNeoConfig</code> configuration class: <code>GPTNeoModel</code> (GPT Neo model)</li>
<li><code>GPTNeoXConfig</code> configuration class: <code>GPTNeoXModel</code> (GPT NeoX model)</li>
<li><code>GPTNeoXJapaneseConfig</code> configuration class: <code>GPTNeoXJapaneseModel</code> (GPT NeoX Japanese model)</li>
<li><code>GPTSanJapaneseConfig</code> configuration class: <code>GPTSanJapaneseForConditionalGeneration</code> (GPTSAN-japanese model)</li>
<li><code>GemmaConfig</code> configuration class: <code>GemmaModel</code> (Gemma model)</li>
<li><code>GitConfig</code> configuration class: <code>GitModel</code> (GIT model)</li>
<li><code>GraphormerConfig</code> configuration class: <code>GraphormerModel</code> (Graphormer model)</li>
<li><code>GroupViTConfig</code> configuration class: <code>GroupViTModel</code> (GroupViT model)</li>
<li><code>HubertConfig</code> configuration class: <code>HubertModel</code> (Hubert model)</li>
<li><code>IBertConfig</code> configuration class: <code>IBertModel</code> (I-BERT model)</li>
<li><code>IdeficsConfig</code> configuration class: <code>IdeficsModel</code> (IDEFICS model)</li>
<li><code>ImageGPTConfig</code> configuration class: <code>ImageGPTModel</code> (ImageGPT model)</li>
<li><code>InformerConfig</code> configuration class: <code>InformerModel</code> (Informer model)</li>
<li><code>JukeboxConfig</code> configuration class: <code>JukeboxModel</code> (Jukebox model)</li>
<li><code>Kosmos2Config</code> configuration class: <code>Kosmos2Model</code> (KOSMOS-2 model)</li>
<li><code>LEDConfig</code> configuration class: <code>LEDModel</code> (LED model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>LayoutLMModel</code> (LayoutLM model)</li>
<li><code>LayoutLMv2Config</code> configuration class: <code>LayoutLMv2Model</code> (LayoutLMv2 model)</li>
<li><code>LayoutLMv3Config</code> configuration class: <code>LayoutLMv3Model</code> (LayoutLMv3 model)</li>
<li><code>LevitConfig</code> configuration class: <code>LevitModel</code> (LeViT model)</li>
<li><code>LiltConfig</code> configuration class: <code>LiltModel</code> (LiLT model)</li>
<li><code>LlamaConfig</code> configuration class: <code>LlamaModel</code> (LLaMA model)</li>
<li><code>LongT5Config</code> configuration class: <code>LongT5Model</code> (LongT5 model)</li>
<li><code>LongformerConfig</code> configuration class: <code>LongformerModel</code> (Longformer model)</li>
<li><code>LukeConfig</code> configuration class: <code>LukeModel</code> (LUKE model)</li>
<li><code>LxmertConfig</code> configuration class: <code>LxmertModel</code> (LXMERT model)</li>
<li><code>M2M100Config</code> configuration class: <code>M2M100Model</code> (M2M100 model)</li>
<li><code>MBartConfig</code> configuration class: <code>MBartModel</code> (mBART model)</li>
<li><code>MCTCTConfig</code> configuration class: <code>MCTCTModel</code> (M-CTC-T model)</li>
<li><code>MPNetConfig</code> configuration class: <code>MPNetModel</code> (MPNet model)</li>
<li><code>MT5Config</code> configuration class: <code>MT5Model</code> (MT5 model)</li>
<li><code>MambaConfig</code> configuration class: <code>MambaModel</code> (Mamba model)</li>
<li><code>MarianConfig</code> configuration class: <code>MarianModel</code> (Marian model)</li>
<li><code>MarkupLMConfig</code> configuration class: <code>MarkupLMModel</code> (MarkupLM model)</li>
<li><code>Mask2FormerConfig</code> configuration class: <code>Mask2FormerModel</code> (Mask2Former model)</li>
<li><code>MaskFormerConfig</code> configuration class: <code>MaskFormerModel</code> (MaskFormer model)</li>
<li><code>MaskFormerSwinConfig</code> configuration class: <code>MaskFormerSwinModel</code> (MaskFormerSwin model)</li>
<li><code>MegaConfig</code> configuration class: <code>MegaModel</code> (MEGA model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertModel</code> (Megatron-BERT model)</li>
<li><code>MgpstrConfig</code> configuration class: <code>MgpstrForSceneTextRecognition</code> (MGP-STR model)</li>
<li><code>MistralConfig</code> configuration class: <code>MistralModel</code> (Mistral model)</li>
<li><code>MixtralConfig</code> configuration class: <code>MixtralModel</code> (Mixtral model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>MobileBertModel</code> (MobileBERT model)</li>
<li><code>MobileNetV1Config</code> configuration class: <code>MobileNetV1Model</code> (MobileNetV1 model)</li>
<li><code>MobileNetV2Config</code> configuration class: <code>MobileNetV2Model</code> (MobileNetV2 model)</li>
<li><code>MobileViTConfig</code> configuration class: <code>MobileViTModel</code> (MobileViT model)</li>
<li><code>MobileViTV2Config</code> configuration class: <code>MobileViTV2Model</code> (MobileViTV2 model)</li>
<li><code>MptConfig</code> configuration class: <code>MptModel</code> (MPT model)</li>
<li><code>MraConfig</code> configuration class: <code>MraModel</code> (MRA model)</li>
<li><code>MvpConfig</code> configuration class: <code>MvpModel</code> (MVP model)</li>
<li><code>NatConfig</code> configuration class: <code>NatModel</code> (NAT model)</li>
<li><code>NezhaConfig</code> configuration class: <code>NezhaModel</code> (Nezha model)</li>
<li><code>NllbMoeConfig</code> configuration class: <code>NllbMoeModel</code> (NLLB-MOE model)</li>
<li><code>NystromformerConfig</code> configuration class: <code>NystromformerModel</code> (Nystr&#xF6;mformer model)</li>
<li><code>OPTConfig</code> configuration class: <code>OPTModel</code> (OPT model)</li>
<li><code>OneFormerConfig</code> configuration class: <code>OneFormerModel</code> (OneFormer model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>OpenAIGPTModel</code> (OpenAI GPT model)</li>
<li><code>OpenLlamaConfig</code> configuration class: <code>OpenLlamaModel</code> (OpenLlama model)</li>
<li><code>OwlViTConfig</code> configuration class: <code>OwlViTModel</code> (OWL-ViT model)</li>
<li><code>Owlv2Config</code> configuration class: <code>Owlv2Model</code> (OWLv2 model)</li>
<li><code>PLBartConfig</code> configuration class: <code>PLBartModel</code> (PLBart model)</li>
<li><code>PatchTSMixerConfig</code> configuration class: <code>PatchTSMixerModel</code> (PatchTSMixer model)</li>
<li><code>PatchTSTConfig</code> configuration class: <code>PatchTSTModel</code> (PatchTST model)</li>
<li><code>PegasusConfig</code> configuration class: <code>PegasusModel</code> (Pegasus model)</li>
<li><code>PegasusXConfig</code> configuration class: <code>PegasusXModel</code> (PEGASUS-X model)</li>
<li><code>PerceiverConfig</code> configuration class: <code>PerceiverModel</code> (Perceiver model)</li>
<li><code>PersimmonConfig</code> configuration class: <code>PersimmonModel</code> (Persimmon model)</li>
<li><code>PhiConfig</code> configuration class: <code>PhiModel</code> (Phi model)</li>
<li><code>PoolFormerConfig</code> configuration class: <code>PoolFormerModel</code> (PoolFormer model)</li>
<li><code>ProphetNetConfig</code> configuration class: <code>ProphetNetModel</code> (ProphetNet model)</li>
<li><code>PvtConfig</code> configuration class: <code>PvtModel</code> (PVT model)</li>
<li><code>PvtV2Config</code> configuration class: <code>PvtV2Model</code> (PVTv2 model)</li>
<li><code>QDQBertConfig</code> configuration class: <code>QDQBertModel</code> (QDQBert model)</li>
<li><code>Qwen2Config</code> configuration class: <code>Qwen2Model</code> (Qwen2 model)</li>
<li><code>ReformerConfig</code> configuration class: <code>ReformerModel</code> (Reformer model)</li>
<li><code>RegNetConfig</code> configuration class: <code>RegNetModel</code> (RegNet model)</li>
<li><code>RemBertConfig</code> configuration class: <code>RemBertModel</code> (RemBERT model)</li>
<li><code>ResNetConfig</code> configuration class: <code>ResNetModel</code> (ResNet model)</li>
<li><code>RetriBertConfig</code> configuration class: <code>RetriBertModel</code> (RetriBERT model)</li>
<li><code>RoCBertConfig</code> configuration class: <code>RoCBertModel</code> (RoCBert model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>RoFormerModel</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>RobertaModel</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>RobertaPreLayerNormModel</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>RwkvConfig</code> configuration class: <code>RwkvModel</code> (RWKV model)</li>
<li><code>SEWConfig</code> configuration class: <code>SEWModel</code> (SEW model)</li>
<li><code>SEWDConfig</code> configuration class: <code>SEWDModel</code> (SEW-D model)</li>
<li><code>SamConfig</code> configuration class: <code>SamModel</code> (SAM model)</li>
<li><code>SeamlessM4TConfig</code> configuration class: <code>SeamlessM4TModel</code> (SeamlessM4T model)</li>
<li><code>SeamlessM4Tv2Config</code> configuration class: <code>SeamlessM4Tv2Model</code> (SeamlessM4Tv2 model)</li>
<li><code>SegGptConfig</code> configuration class: <code>SegGptModel</code> (SegGPT model)</li>
<li><code>SegformerConfig</code> configuration class: <code>SegformerModel</code> (SegFormer model)</li>
<li><code>SiglipConfig</code> configuration class: <code>SiglipModel</code> (SigLIP model)</li>
<li><code>SiglipVisionConfig</code> configuration class: <code>SiglipVisionModel</code> (SiglipVisionModel model)</li>
<li><code>Speech2TextConfig</code> configuration class: <code>Speech2TextModel</code> (Speech2Text model)</li>
<li><code>SpeechT5Config</code> configuration class: <code>SpeechT5Model</code> (SpeechT5 model)</li>
<li><code>SplinterConfig</code> configuration class: <code>SplinterModel</code> (Splinter model)</li>
<li><code>SqueezeBertConfig</code> configuration class: <code>SqueezeBertModel</code> (SqueezeBERT model)</li>
<li><code>StableLmConfig</code> configuration class: <code>StableLmModel</code> (StableLm model)</li>
<li><code>Starcoder2Config</code> configuration class: <code>Starcoder2Model</code> (Starcoder2 model)</li>
<li><code>SwiftFormerConfig</code> configuration class: <code>SwiftFormerModel</code> (SwiftFormer model)</li>
<li><code>Swin2SRConfig</code> configuration class: <code>Swin2SRModel</code> (Swin2SR model)</li>
<li><code>SwinConfig</code> configuration class: <code>SwinModel</code> (Swin Transformer model)</li>
<li><code>Swinv2Config</code> configuration class: <code>Swinv2Model</code> (Swin Transformer V2 model)</li>
<li><code>SwitchTransformersConfig</code> configuration class: <code>SwitchTransformersModel</code> (SwitchTransformers model)</li>
<li><code>T5Config</code> configuration class: <code>T5Model</code> (T5 model)</li>
<li><code>TableTransformerConfig</code> configuration class: <code>TableTransformerModel</code> (Table Transformer model)</li>
<li><code>TapasConfig</code> configuration class: <code>TapasModel</code> (TAPAS model)</li>
<li><code>TimeSeriesTransformerConfig</code> configuration class: <code>TimeSeriesTransformerModel</code> (Time Series Transformer model)</li>
<li><code>TimesformerConfig</code> configuration class: <code>TimesformerModel</code> (TimeSformer model)</li>
<li><code>TimmBackboneConfig</code> configuration class: <code>TimmBackbone</code> (TimmBackbone model)</li>
<li><code>TrajectoryTransformerConfig</code> configuration class: <code>TrajectoryTransformerModel</code> (Trajectory Transformer model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TransfoXLModel</code> (Transformer-XL model)</li>
<li><code>TvltConfig</code> configuration class: <code>TvltModel</code> (TVLT model)</li>
<li><code>TvpConfig</code> configuration class: <code>TvpModel</code> (TVP model)</li>
<li><code>UMT5Config</code> configuration class: <code>UMT5Model</code> (UMT5 model)</li>
<li><code>UdopConfig</code> configuration class: <code>UdopModel</code> (UDOP model)</li>
<li><code>UniSpeechConfig</code> configuration class: <code>UniSpeechModel</code> (UniSpeech model)</li>
<li><code>UniSpeechSatConfig</code> configuration class: <code>UniSpeechSatModel</code> (UniSpeechSat model)</li>
<li><code>UnivNetConfig</code> configuration class: <code>UnivNetModel</code> (UnivNet model)</li>
<li><code>VanConfig</code> configuration class: <code>VanModel</code> (VAN model)</li>
<li><code>ViTConfig</code> configuration class: <code>ViTModel</code> (ViT model)</li>
<li><code>ViTHybridConfig</code> configuration class: <code>ViTHybridModel</code> (ViT Hybrid model)</li>
<li><code>ViTMAEConfig</code> configuration class: <code>ViTMAEModel</code> (ViTMAE model)</li>
<li><code>ViTMSNConfig</code> configuration class: <code>ViTMSNModel</code> (ViTMSN model)</li>
<li><code>VideoMAEConfig</code> configuration class: <code>VideoMAEModel</code> (VideoMAE model)</li>
<li><code>ViltConfig</code> configuration class: <code>ViltModel</code> (ViLT model)</li>
<li><code>VisionTextDualEncoderConfig</code> configuration class: <code>VisionTextDualEncoderModel</code> (VisionTextDualEncoder model)</li>
<li><code>VisualBertConfig</code> configuration class: <code>VisualBertModel</code> (VisualBERT model)</li>
<li><code>VitDetConfig</code> configuration class: <code>VitDetModel</code> (VitDet model)</li>
<li><code>VitsConfig</code> configuration class: <code>VitsModel</code> (VITS model)</li>
<li><code>VivitConfig</code> configuration class: <code>VivitModel</code> (ViViT model)</li>
<li><code>Wav2Vec2BertConfig</code> configuration class: <code>Wav2Vec2BertModel</code> (Wav2Vec2-BERT model)</li>
<li><code>Wav2Vec2Config</code> configuration class: <code>Wav2Vec2Model</code> (Wav2Vec2 model)</li>
<li><code>Wav2Vec2ConformerConfig</code> configuration class: <code>Wav2Vec2ConformerModel</code> (Wav2Vec2-Conformer model)</li>
<li><code>WavLMConfig</code> configuration class: <code>WavLMModel</code> (WavLM model)</li>
<li><code>WhisperConfig</code> configuration class: <code>WhisperModel</code> (Whisper model)</li>
<li><code>XCLIPConfig</code> configuration class: <code>XCLIPModel</code> (X-CLIP model)</li>
<li><code>XGLMConfig</code> configuration class: <code>XGLMModel</code> (XGLM model)</li>
<li><code>XLMConfig</code> configuration class: <code>XLMModel</code> (XLM model)</li>
<li><code>XLMProphetNetConfig</code> configuration class: <code>XLMProphetNetModel</code> (XLM-ProphetNet model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>XLMRobertaModel</code> (XLM-RoBERTa model)</li>
<li><code>XLMRobertaXLConfig</code> configuration class: <code>XLMRobertaXLModel</code> (XLM-RoBERTa-XL model)</li>
<li><code>XLNetConfig</code> configuration class: <code>XLNetModel</code> (XLNet model)</li>
<li><code>XmodConfig</code> configuration class: <code>XmodModel</code> (X-MOD model)</li>
<li><code>YolosConfig</code> configuration class: <code>YolosModel</code> (YOLOS model)</li>
<li><code>YosoConfig</code> configuration class: <code>YosoModel</code> (YOSO model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModel.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Gs=new k({props:{anchor:"transformers.AutoModel.from_config.example",$$slots:{default:[CN]},$$scope:{ctx:v}}}),tc=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModel.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModel.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Vs=new k({props:{anchor:"transformers.AutoModel.from_pretrained.example",$$slots:{default:[wN]},$$scope:{ctx:v}}}),nc=new Z({props:{title:"TFAutoModel",local:"transformers.TFAutoModel",headingTag:"h3"}}),rc=new j({props:{name:"class transformers.TFAutoModel",anchor:"transformers.TFAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L531"}}),ac=new j({props:{name:"from_config",anchor:"transformers.TFAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertModel">TFAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartModel">TFBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertModel">TFBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.TFBlenderbotModel">TFBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.TFBlenderbotSmallModel">TFBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blip#transformers.BlipConfig">BlipConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blip#transformers.TFBlipModel">TFBlipModel</a> (BLIP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clip#transformers.TFCLIPModel">TFCLIPModel</a> (CLIP model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLModel">TFCTRLModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertModel">TFCamembertModel</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertModel">TFConvBertModel</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convnext#transformers.ConvNextConfig">ConvNextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convnext#transformers.TFConvNextModel">TFConvNextModel</a> (ConvNeXT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.ConvNextV2Config">ConvNextV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convnextv2#transformers.TFConvNextV2Model">TFConvNextV2Model</a> (ConvNeXTV2 model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/cvt#transformers.CvtConfig">CvtConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/cvt#transformers.TFCvtModel">TFCvtModel</a> (CvT model)</li>
<li><code>DPRConfig</code> configuration class: <code>TFDPRQuestionEncoder</code> (DPR model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecVisionConfig">Data2VecVisionConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.TFData2VecVisionModel">TFData2VecVisionModel</a> (Data2VecVision model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaModel">TFDebertaModel</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2Model">TFDebertaV2Model</a> (DeBERTa-v2 model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deit#transformers.DeiTConfig">DeiTConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deit#transformers.TFDeiTModel">TFDeiTModel</a> (DeiT model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>TFDistilBertModel</code> (DistilBERT model)</li>
<li><code>EfficientFormerConfig</code> configuration class: <code>TFEfficientFormerModel</code> (EfficientFormer model)</li>
<li><code>ElectraConfig</code> configuration class: <code>TFElectraModel</code> (ELECTRA model)</li>
<li><code>EsmConfig</code> configuration class: <code>TFEsmModel</code> (ESM model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>TFFlaubertModel</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>TFFunnelModel</code> or <code>TFFunnelBaseModel</code> (Funnel Transformer model)</li>
<li><code>GPT2Config</code> configuration class: <code>TFGPT2Model</code> (OpenAI GPT-2 model)</li>
<li><code>GPTJConfig</code> configuration class: <code>TFGPTJModel</code> (GPT-J model)</li>
<li><code>GroupViTConfig</code> configuration class: <code>TFGroupViTModel</code> (GroupViT model)</li>
<li><code>HubertConfig</code> configuration class: <code>TFHubertModel</code> (Hubert model)</li>
<li><code>LEDConfig</code> configuration class: <code>TFLEDModel</code> (LED model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>TFLayoutLMModel</code> (LayoutLM model)</li>
<li><code>LayoutLMv3Config</code> configuration class: <code>TFLayoutLMv3Model</code> (LayoutLMv3 model)</li>
<li><code>LongformerConfig</code> configuration class: <code>TFLongformerModel</code> (Longformer model)</li>
<li><code>LxmertConfig</code> configuration class: <code>TFLxmertModel</code> (LXMERT model)</li>
<li><code>MBartConfig</code> configuration class: <code>TFMBartModel</code> (mBART model)</li>
<li><code>MPNetConfig</code> configuration class: <code>TFMPNetModel</code> (MPNet model)</li>
<li><code>MT5Config</code> configuration class: <code>TFMT5Model</code> (MT5 model)</li>
<li><code>MarianConfig</code> configuration class: <code>TFMarianModel</code> (Marian model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>TFMobileBertModel</code> (MobileBERT model)</li>
<li><code>MobileViTConfig</code> configuration class: <code>TFMobileViTModel</code> (MobileViT model)</li>
<li><code>OPTConfig</code> configuration class: <code>TFOPTModel</code> (OPT model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>TFOpenAIGPTModel</code> (OpenAI GPT model)</li>
<li><code>PegasusConfig</code> configuration class: <code>TFPegasusModel</code> (Pegasus model)</li>
<li><code>RegNetConfig</code> configuration class: <code>TFRegNetModel</code> (RegNet model)</li>
<li><code>RemBertConfig</code> configuration class: <code>TFRemBertModel</code> (RemBERT model)</li>
<li><code>ResNetConfig</code> configuration class: <code>TFResNetModel</code> (ResNet model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>TFRoFormerModel</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>TFRobertaModel</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>TFRobertaPreLayerNormModel</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>SamConfig</code> configuration class: <code>TFSamModel</code> (SAM model)</li>
<li><code>SegformerConfig</code> configuration class: <code>TFSegformerModel</code> (SegFormer model)</li>
<li><code>Speech2TextConfig</code> configuration class: <code>TFSpeech2TextModel</code> (Speech2Text model)</li>
<li><code>SwinConfig</code> configuration class: <code>TFSwinModel</code> (Swin Transformer model)</li>
<li><code>T5Config</code> configuration class: <code>TFT5Model</code> (T5 model)</li>
<li><code>TapasConfig</code> configuration class: <code>TFTapasModel</code> (TAPAS model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TFTransfoXLModel</code> (Transformer-XL model)</li>
<li><code>ViTConfig</code> configuration class: <code>TFViTModel</code> (ViT model)</li>
<li><code>ViTMAEConfig</code> configuration class: <code>TFViTMAEModel</code> (ViTMAE model)</li>
<li><code>VisionTextDualEncoderConfig</code> configuration class: <code>TFVisionTextDualEncoderModel</code> (VisionTextDualEncoder model)</li>
<li><code>Wav2Vec2Config</code> configuration class: <code>TFWav2Vec2Model</code> (Wav2Vec2 model)</li>
<li><code>WhisperConfig</code> configuration class: <code>TFWhisperModel</code> (Whisper model)</li>
<li><code>XGLMConfig</code> configuration class: <code>TFXGLMModel</code> (XGLM model)</li>
<li><code>XLMConfig</code> configuration class: <code>TFXLMModel</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>TFXLMRobertaModel</code> (XLM-RoBERTa model)</li>
<li><code>XLNetConfig</code> configuration class: <code>TFXLNetModel</code> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModel.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ss=new k({props:{anchor:"transformers.TFAutoModel.from_config.example",$$slots:{default:[jN]},$$scope:{ctx:v}}}),sc=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Es=new k({props:{anchor:"transformers.TFAutoModel.from_pretrained.example",$$slots:{default:[xN]},$$scope:{ctx:v}}}),ic=new Z({props:{title:"FlaxAutoModel",local:"transformers.FlaxAutoModel",headingTag:"h3"}}),lc=new j({props:{name:"class transformers.FlaxAutoModel",anchor:"transformers.FlaxAutoModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L280"}}),dc=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModel.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertModel">FlaxAlbertModel</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartModel">FlaxBartModel</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/beit#transformers.BeitConfig">BeitConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a> (BEiT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertModel">FlaxBertModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdModel">FlaxBigBirdModel</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.FlaxBlenderbotModel">FlaxBlenderbotModel</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallModel">FlaxBlenderbotSmallModel</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.FlaxBloomModel">FlaxBloomModel</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/clip#transformers.CLIPConfig">CLIPConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/clip#transformers.FlaxCLIPModel">FlaxCLIPModel</a> (CLIP model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>FlaxDistilBertModel</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>FlaxElectraModel</code> (ELECTRA model)</li>
<li><code>GPT2Config</code> configuration class: <code>FlaxGPT2Model</code> (OpenAI GPT-2 model)</li>
<li><code>GPTJConfig</code> configuration class: <code>FlaxGPTJModel</code> (GPT-J model)</li>
<li><code>GPTNeoConfig</code> configuration class: <code>FlaxGPTNeoModel</code> (GPT Neo model)</li>
<li><code>GemmaConfig</code> configuration class: <code>FlaxGemmaModel</code> (Gemma model)</li>
<li><code>LlamaConfig</code> configuration class: <code>FlaxLlamaModel</code> (LLaMA model)</li>
<li><code>LongT5Config</code> configuration class: <code>FlaxLongT5Model</code> (LongT5 model)</li>
<li><code>MBartConfig</code> configuration class: <code>FlaxMBartModel</code> (mBART model)</li>
<li><code>MT5Config</code> configuration class: <code>FlaxMT5Model</code> (MT5 model)</li>
<li><code>MarianConfig</code> configuration class: <code>FlaxMarianModel</code> (Marian model)</li>
<li><code>MistralConfig</code> configuration class: <code>FlaxMistralModel</code> (Mistral model)</li>
<li><code>OPTConfig</code> configuration class: <code>FlaxOPTModel</code> (OPT model)</li>
<li><code>PegasusConfig</code> configuration class: <code>FlaxPegasusModel</code> (Pegasus model)</li>
<li><code>RegNetConfig</code> configuration class: <code>FlaxRegNetModel</code> (RegNet model)</li>
<li><code>ResNetConfig</code> configuration class: <code>FlaxResNetModel</code> (ResNet model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>FlaxRoFormerModel</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>FlaxRobertaModel</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>FlaxRobertaPreLayerNormModel</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>T5Config</code> configuration class: <code>FlaxT5Model</code> (T5 model)</li>
<li><code>ViTConfig</code> configuration class: <code>FlaxViTModel</code> (ViT model)</li>
<li><code>VisionTextDualEncoderConfig</code> configuration class: <code>FlaxVisionTextDualEncoderModel</code> (VisionTextDualEncoder model)</li>
<li><code>Wav2Vec2Config</code> configuration class: <code>FlaxWav2Vec2Model</code> (Wav2Vec2 model)</li>
<li><code>WhisperConfig</code> configuration class: <code>FlaxWhisperModel</code> (Whisper model)</li>
<li><code>XGLMConfig</code> configuration class: <code>FlaxXGLMModel</code> (XGLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>FlaxXLMRobertaModel</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModel.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Is=new k({props:{anchor:"transformers.FlaxAutoModel.from_config.example",$$slots:{default:[$N]},$$scope:{ctx:v}}}),cc=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModel.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModel.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModel.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModel.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModel.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModel.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModel.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModel.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Us=new k({props:{anchor:"transformers.FlaxAutoModel.from_pretrained.example",$$slots:{default:[kN]},$$scope:{ctx:v}}}),mc=new Z({props:{title:"Generic pretraining classes",local:"generic-pretraining-classes",headingTag:"h2"}}),gc=new Z({props:{title:"AutoModelForPreTraining",local:"transformers.AutoModelForPreTraining",headingTag:"h3"}}),pc=new j({props:{name:"class transformers.AutoModelForPreTraining",anchor:"transformers.AutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1392"}}),uc=new j({props:{name:"from_config",anchor:"transformers.AutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForPreTraining">AlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForPreTraining">BertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForPreTraining">BigBirdForPreTraining</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>DistilBertForMaskedLM</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>ElectraForPreTraining</code> (ELECTRA model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieForPreTraining</code> (ERNIE model)</li>
<li><code>FNetConfig</code> configuration class: <code>FNetForPreTraining</code> (FNet model)</li>
<li><code>FSMTConfig</code> configuration class: <code>FSMTForConditionalGeneration</code> (FairSeq Machine-Translation model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>FlaubertWithLMHeadModel</code> (FlauBERT model)</li>
<li><code>FlavaConfig</code> configuration class: <code>FlavaForPreTraining</code> (FLAVA model)</li>
<li><code>FunnelConfig</code> configuration class: <code>FunnelForPreTraining</code> (Funnel Transformer model)</li>
<li><code>GPT2Config</code> configuration class: <code>GPT2LMHeadModel</code> (OpenAI GPT-2 model)</li>
<li><code>GPTBigCodeConfig</code> configuration class: <code>GPTBigCodeForCausalLM</code> (GPTBigCode model)</li>
<li><code>GPTSanJapaneseConfig</code> configuration class: <code>GPTSanJapaneseForConditionalGeneration</code> (GPTSAN-japanese model)</li>
<li><code>IBertConfig</code> configuration class: <code>IBertForMaskedLM</code> (I-BERT model)</li>
<li><code>IdeficsConfig</code> configuration class: <code>IdeficsForVisionText2Text</code> (IDEFICS model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>LayoutLMForMaskedLM</code> (LayoutLM model)</li>
<li><code>LlavaConfig</code> configuration class: <code>LlavaForConditionalGeneration</code> (LLaVa model)</li>
<li><code>LongformerConfig</code> configuration class: <code>LongformerForMaskedLM</code> (Longformer model)</li>
<li><code>LukeConfig</code> configuration class: <code>LukeForMaskedLM</code> (LUKE model)</li>
<li><code>LxmertConfig</code> configuration class: <code>LxmertForPreTraining</code> (LXMERT model)</li>
<li><code>MPNetConfig</code> configuration class: <code>MPNetForMaskedLM</code> (MPNet model)</li>
<li><code>MambaConfig</code> configuration class: <code>MambaForCausalLM</code> (Mamba model)</li>
<li><code>MegaConfig</code> configuration class: <code>MegaForMaskedLM</code> (MEGA model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertForPreTraining</code> (Megatron-BERT model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>MobileBertForPreTraining</code> (MobileBERT model)</li>
<li><code>MptConfig</code> configuration class: <code>MptForCausalLM</code> (MPT model)</li>
<li><code>MraConfig</code> configuration class: <code>MraForMaskedLM</code> (MRA model)</li>
<li><code>MvpConfig</code> configuration class: <code>MvpForConditionalGeneration</code> (MVP model)</li>
<li><code>NezhaConfig</code> configuration class: <code>NezhaForPreTraining</code> (Nezha model)</li>
<li><code>NllbMoeConfig</code> configuration class: <code>NllbMoeForConditionalGeneration</code> (NLLB-MOE model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>OpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li>
<li><code>RetriBertConfig</code> configuration class: <code>RetriBertModel</code> (RetriBERT model)</li>
<li><code>RoCBertConfig</code> configuration class: <code>RoCBertForPreTraining</code> (RoCBert model)</li>
<li><code>RobertaConfig</code> configuration class: <code>RobertaForMaskedLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>RobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>RwkvConfig</code> configuration class: <code>RwkvForCausalLM</code> (RWKV model)</li>
<li><code>SplinterConfig</code> configuration class: <code>SplinterForPreTraining</code> (Splinter model)</li>
<li><code>SqueezeBertConfig</code> configuration class: <code>SqueezeBertForMaskedLM</code> (SqueezeBERT model)</li>
<li><code>SwitchTransformersConfig</code> configuration class: <code>SwitchTransformersForConditionalGeneration</code> (SwitchTransformers model)</li>
<li><code>T5Config</code> configuration class: <code>T5ForConditionalGeneration</code> (T5 model)</li>
<li><code>TapasConfig</code> configuration class: <code>TapasForMaskedLM</code> (TAPAS model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TransfoXLLMHeadModel</code> (Transformer-XL model)</li>
<li><code>TvltConfig</code> configuration class: <code>TvltForPreTraining</code> (TVLT model)</li>
<li><code>UniSpeechConfig</code> configuration class: <code>UniSpeechForPreTraining</code> (UniSpeech model)</li>
<li><code>UniSpeechSatConfig</code> configuration class: <code>UniSpeechSatForPreTraining</code> (UniSpeechSat model)</li>
<li><code>ViTMAEConfig</code> configuration class: <code>ViTMAEForPreTraining</code> (ViTMAE model)</li>
<li><code>VideoMAEConfig</code> configuration class: <code>VideoMAEForPreTraining</code> (VideoMAE model)</li>
<li><code>VipLlavaConfig</code> configuration class: <code>VipLlavaForConditionalGeneration</code> (VipLlava model)</li>
<li><code>VisualBertConfig</code> configuration class: <code>VisualBertForPreTraining</code> (VisualBERT model)</li>
<li><code>Wav2Vec2Config</code> configuration class: <code>Wav2Vec2ForPreTraining</code> (Wav2Vec2 model)</li>
<li><code>Wav2Vec2ConformerConfig</code> configuration class: <code>Wav2Vec2ConformerForPreTraining</code> (Wav2Vec2-Conformer model)</li>
<li><code>XLMConfig</code> configuration class: <code>XLMWithLMHeadModel</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>XLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>
<li><code>XLMRobertaXLConfig</code> configuration class: <code>XLMRobertaXLForMaskedLM</code> (XLM-RoBERTa-XL model)</li>
<li><code>XLNetConfig</code> configuration class: <code>XLNetLMHeadModel</code> (XLNet model)</li>
<li><code>XmodConfig</code> configuration class: <code>XmodForMaskedLM</code> (X-MOD model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForPreTraining.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ps=new k({props:{anchor:"transformers.AutoModelForPreTraining.from_config.example",$$slots:{default:[ZN]},$$scope:{ctx:v}}}),hc=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),qs=new k({props:{anchor:"transformers.AutoModelForPreTraining.from_pretrained.example",$$slots:{default:[AN]},$$scope:{ctx:v}}}),bc=new Z({props:{title:"TFAutoModelForPreTraining",local:"transformers.TFAutoModelForPreTraining",headingTag:"h3"}}),_c=new j({props:{name:"class transformers.TFAutoModelForPreTraining",anchor:"transformers.TFAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L547"}}),Mc=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForPreTraining">TFAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForPreTraining">TFBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>TFDistilBertForMaskedLM</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>TFElectraForPreTraining</code> (ELECTRA model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>TFFlaubertWithLMHeadModel</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>TFFunnelForPreTraining</code> (Funnel Transformer model)</li>
<li><code>GPT2Config</code> configuration class: <code>TFGPT2LMHeadModel</code> (OpenAI GPT-2 model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>TFLayoutLMForMaskedLM</code> (LayoutLM model)</li>
<li><code>LxmertConfig</code> configuration class: <code>TFLxmertForPreTraining</code> (LXMERT model)</li>
<li><code>MPNetConfig</code> configuration class: <code>TFMPNetForMaskedLM</code> (MPNet model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>TFMobileBertForPreTraining</code> (MobileBERT model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>TFOpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li>
<li><code>RobertaConfig</code> configuration class: <code>TFRobertaForMaskedLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>TFRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>T5Config</code> configuration class: <code>TFT5ForConditionalGeneration</code> (T5 model)</li>
<li><code>TapasConfig</code> configuration class: <code>TFTapasForMaskedLM</code> (TAPAS model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TFTransfoXLLMHeadModel</code> (Transformer-XL model)</li>
<li><code>ViTMAEConfig</code> configuration class: <code>TFViTMAEForPreTraining</code> (ViTMAE model)</li>
<li><code>XLMConfig</code> configuration class: <code>TFXLMWithLMHeadModel</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>TFXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>
<li><code>XLNetConfig</code> configuration class: <code>TFXLNetLMHeadModel</code> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForPreTraining.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ns=new k({props:{anchor:"transformers.TFAutoModelForPreTraining.from_config.example",$$slots:{default:[LN]},$$scope:{ctx:v}}}),Tc=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Xs=new k({props:{anchor:"transformers.TFAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[BN]},$$scope:{ctx:v}}}),yc=new Z({props:{title:"FlaxAutoModelForPreTraining",local:"transformers.FlaxAutoModelForPreTraining",headingTag:"h3"}}),Fc=new j({props:{name:"class transformers.FlaxAutoModelForPreTraining",anchor:"transformers.FlaxAutoModelForPreTraining",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L287"}}),vc=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForPreTraining.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForPreTraining">FlaxAlbertForPreTraining</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForPreTraining">FlaxBertForPreTraining</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForPreTraining">FlaxBigBirdForPreTraining</a> (BigBird model)</li>
<li><code>ElectraConfig</code> configuration class: <code>FlaxElectraForPreTraining</code> (ELECTRA model)</li>
<li><code>LongT5Config</code> configuration class: <code>FlaxLongT5ForConditionalGeneration</code> (LongT5 model)</li>
<li><code>MBartConfig</code> configuration class: <code>FlaxMBartForConditionalGeneration</code> (mBART model)</li>
<li><code>MT5Config</code> configuration class: <code>FlaxMT5ForConditionalGeneration</code> (MT5 model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>FlaxRoFormerForMaskedLM</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>FlaxRobertaForMaskedLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>FlaxRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>T5Config</code> configuration class: <code>FlaxT5ForConditionalGeneration</code> (T5 model)</li>
<li><code>Wav2Vec2Config</code> configuration class: <code>FlaxWav2Vec2ForPreTraining</code> (Wav2Vec2 model)</li>
<li><code>WhisperConfig</code> configuration class: <code>FlaxWhisperForConditionalGeneration</code> (Whisper model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>FlaxXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ds=new k({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_config.example",$$slots:{default:[RN]},$$scope:{ctx:v}}}),Cc=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Hs=new k({props:{anchor:"transformers.FlaxAutoModelForPreTraining.from_pretrained.example",$$slots:{default:[WN]},$$scope:{ctx:v}}}),wc=new Z({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),xc=new Z({props:{title:"AutoModelForCausalLM",local:"transformers.AutoModelForCausalLM",headingTag:"h3"}}),$c=new j({props:{name:"class transformers.AutoModelForCausalLM",anchor:"transformers.AutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1407"}}),kc=new j({props:{name:"from_config",anchor:"transformers.AutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForCausalLM">BartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertLMHeadModel">BertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationConfig">BertGenerationConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert-generation#transformers.BertGenerationDecoder">BertGenerationDecoder</a> (Bert Generation model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForCausalLM">BigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForCausalLM">BigBirdPegasusForCausalLM</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptForCausalLM">BioGptForCausalLM</a> (BioGpt model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotForCausalLM">BlenderbotForCausalLM</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallForCausalLM">BlenderbotSmallForCausalLM</a> (BlenderbotSmall model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForCausalLM">BloomForCausalLM</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLLMHeadModel">CTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForCausalLM">CamembertForCausalLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenConfig">CodeGenConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/codegen#transformers.CodeGenForCausalLM">CodeGenForCausalLM</a> (CodeGen model)</li>
<li><code>CohereConfig</code> configuration class: <code>CohereForCausalLM</code> (Cohere model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntConfig">CpmAntConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/cpmant#transformers.CpmAntForCausalLM">CpmAntForCausalLM</a> (CPM-Ant model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForCausalLM">Data2VecTextForCausalLM</a> (Data2VecText model)</li>
<li><code>ElectraConfig</code> configuration class: <code>ElectraForCausalLM</code> (ELECTRA model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieForCausalLM</code> (ERNIE model)</li>
<li><code>FalconConfig</code> configuration class: <code>FalconForCausalLM</code> (Falcon model)</li>
<li><code>FuyuConfig</code> configuration class: <code>FuyuForCausalLM</code> (Fuyu model)</li>
<li><code>GPT2Config</code> configuration class: <code>GPT2LMHeadModel</code> (OpenAI GPT-2 model)</li>
<li><code>GPTBigCodeConfig</code> configuration class: <code>GPTBigCodeForCausalLM</code> (GPTBigCode model)</li>
<li><code>GPTJConfig</code> configuration class: <code>GPTJForCausalLM</code> (GPT-J model)</li>
<li><code>GPTNeoConfig</code> configuration class: <code>GPTNeoForCausalLM</code> (GPT Neo model)</li>
<li><code>GPTNeoXConfig</code> configuration class: <code>GPTNeoXForCausalLM</code> (GPT NeoX model)</li>
<li><code>GPTNeoXJapaneseConfig</code> configuration class: <code>GPTNeoXJapaneseForCausalLM</code> (GPT NeoX Japanese model)</li>
<li><code>GemmaConfig</code> configuration class: <code>GemmaForCausalLM</code> (Gemma model)</li>
<li><code>GitConfig</code> configuration class: <code>GitForCausalLM</code> (GIT model)</li>
<li><code>LlamaConfig</code> configuration class: <code>LlamaForCausalLM</code> (LLaMA model)</li>
<li><code>MBartConfig</code> configuration class: <code>MBartForCausalLM</code> (mBART model)</li>
<li><code>MambaConfig</code> configuration class: <code>MambaForCausalLM</code> (Mamba model)</li>
<li><code>MarianConfig</code> configuration class: <code>MarianForCausalLM</code> (Marian model)</li>
<li><code>MegaConfig</code> configuration class: <code>MegaForCausalLM</code> (MEGA model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertForCausalLM</code> (Megatron-BERT model)</li>
<li><code>MistralConfig</code> configuration class: <code>MistralForCausalLM</code> (Mistral model)</li>
<li><code>MixtralConfig</code> configuration class: <code>MixtralForCausalLM</code> (Mixtral model)</li>
<li><code>MptConfig</code> configuration class: <code>MptForCausalLM</code> (MPT model)</li>
<li><code>MusicgenConfig</code> configuration class: <code>MusicgenForCausalLM</code> (MusicGen model)</li>
<li><code>MvpConfig</code> configuration class: <code>MvpForCausalLM</code> (MVP model)</li>
<li><code>OPTConfig</code> configuration class: <code>OPTForCausalLM</code> (OPT model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>OpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li>
<li><code>OpenLlamaConfig</code> configuration class: <code>OpenLlamaForCausalLM</code> (OpenLlama model)</li>
<li><code>PLBartConfig</code> configuration class: <code>PLBartForCausalLM</code> (PLBart model)</li>
<li><code>PegasusConfig</code> configuration class: <code>PegasusForCausalLM</code> (Pegasus model)</li>
<li><code>PersimmonConfig</code> configuration class: <code>PersimmonForCausalLM</code> (Persimmon model)</li>
<li><code>PhiConfig</code> configuration class: <code>PhiForCausalLM</code> (Phi model)</li>
<li><code>ProphetNetConfig</code> configuration class: <code>ProphetNetForCausalLM</code> (ProphetNet model)</li>
<li><code>QDQBertConfig</code> configuration class: <code>QDQBertLMHeadModel</code> (QDQBert model)</li>
<li><code>Qwen2Config</code> configuration class: <code>Qwen2ForCausalLM</code> (Qwen2 model)</li>
<li><code>ReformerConfig</code> configuration class: <code>ReformerModelWithLMHead</code> (Reformer model)</li>
<li><code>RemBertConfig</code> configuration class: <code>RemBertForCausalLM</code> (RemBERT model)</li>
<li><code>RoCBertConfig</code> configuration class: <code>RoCBertForCausalLM</code> (RoCBert model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>RoFormerForCausalLM</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>RobertaForCausalLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>RobertaPreLayerNormForCausalLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>RwkvConfig</code> configuration class: <code>RwkvForCausalLM</code> (RWKV model)</li>
<li><code>Speech2Text2Config</code> configuration class: <code>Speech2Text2ForCausalLM</code> (Speech2Text2 model)</li>
<li><code>StableLmConfig</code> configuration class: <code>StableLmForCausalLM</code> (StableLm model)</li>
<li><code>Starcoder2Config</code> configuration class: <code>Starcoder2ForCausalLM</code> (Starcoder2 model)</li>
<li><code>TrOCRConfig</code> configuration class: <code>TrOCRForCausalLM</code> (TrOCR model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TransfoXLLMHeadModel</code> (Transformer-XL model)</li>
<li><code>WhisperConfig</code> configuration class: <code>WhisperForCausalLM</code> (Whisper model)</li>
<li><code>XGLMConfig</code> configuration class: <code>XGLMForCausalLM</code> (XGLM model)</li>
<li><code>XLMConfig</code> configuration class: <code>XLMWithLMHeadModel</code> (XLM model)</li>
<li><code>XLMProphetNetConfig</code> configuration class: <code>XLMProphetNetForCausalLM</code> (XLM-ProphetNet model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>XLMRobertaForCausalLM</code> (XLM-RoBERTa model)</li>
<li><code>XLMRobertaXLConfig</code> configuration class: <code>XLMRobertaXLForCausalLM</code> (XLM-RoBERTa-XL model)</li>
<li><code>XLNetConfig</code> configuration class: <code>XLNetLMHeadModel</code> (XLNet model)</li>
<li><code>XmodConfig</code> configuration class: <code>XmodForCausalLM</code> (X-MOD model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForCausalLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Qs=new k({props:{anchor:"transformers.AutoModelForCausalLM.from_config.example",$$slots:{default:[JN]},$$scope:{ctx:v}}}),Zc=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Ys=new k({props:{anchor:"transformers.AutoModelForCausalLM.from_pretrained.example",$$slots:{default:[GN]},$$scope:{ctx:v}}}),Ac=new Z({props:{title:"TFAutoModelForCausalLM",local:"transformers.TFAutoModelForCausalLM",headingTag:"h3"}}),Lc=new j({props:{name:"class transformers.TFAutoModelForCausalLM",anchor:"transformers.TFAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L562"}}),Bc=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertLMHeadModel">TFBertLMHeadModel</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLLMHeadModel">TFCTRLLMHeadModel</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForCausalLM">TFCamembertForCausalLM</a> (CamemBERT model)</li>
<li><code>GPT2Config</code> configuration class: <code>TFGPT2LMHeadModel</code> (OpenAI GPT-2 model)</li>
<li><code>GPTJConfig</code> configuration class: <code>TFGPTJForCausalLM</code> (GPT-J model)</li>
<li><code>OPTConfig</code> configuration class: <code>TFOPTForCausalLM</code> (OPT model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>TFOpenAIGPTLMHeadModel</code> (OpenAI GPT model)</li>
<li><code>RemBertConfig</code> configuration class: <code>TFRemBertForCausalLM</code> (RemBERT model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>TFRoFormerForCausalLM</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>TFRobertaForCausalLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>TFRobertaPreLayerNormForCausalLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TFTransfoXLLMHeadModel</code> (Transformer-XL model)</li>
<li><code>XGLMConfig</code> configuration class: <code>TFXGLMForCausalLM</code> (XGLM model)</li>
<li><code>XLMConfig</code> configuration class: <code>TFXLMWithLMHeadModel</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>TFXLMRobertaForCausalLM</code> (XLM-RoBERTa model)</li>
<li><code>XLNetConfig</code> configuration class: <code>TFXLNetLMHeadModel</code> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForCausalLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),zs=new k({props:{anchor:"transformers.TFAutoModelForCausalLM.from_config.example",$$slots:{default:[VN]},$$scope:{ctx:v}}}),Rc=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Os=new k({props:{anchor:"transformers.TFAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[SN]},$$scope:{ctx:v}}}),Wc=new Z({props:{title:"FlaxAutoModelForCausalLM",local:"transformers.FlaxAutoModelForCausalLM",headingTag:"h3"}}),Jc=new j({props:{name:"class transformers.FlaxAutoModelForCausalLM",anchor:"transformers.FlaxAutoModelForCausalLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L294"}}),Gc=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForCausalLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForCausalLM">FlaxBartForCausalLM</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForCausalLM">FlaxBertForCausalLM</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForCausalLM">FlaxBigBirdForCausalLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.FlaxBloomForCausalLM">FlaxBloomForCausalLM</a> (BLOOM model)</li>
<li><code>ElectraConfig</code> configuration class: <code>FlaxElectraForCausalLM</code> (ELECTRA model)</li>
<li><code>GPT2Config</code> configuration class: <code>FlaxGPT2LMHeadModel</code> (OpenAI GPT-2 model)</li>
<li><code>GPTJConfig</code> configuration class: <code>FlaxGPTJForCausalLM</code> (GPT-J model)</li>
<li><code>GPTNeoConfig</code> configuration class: <code>FlaxGPTNeoForCausalLM</code> (GPT Neo model)</li>
<li><code>GemmaConfig</code> configuration class: <code>FlaxGemmaForCausalLM</code> (Gemma model)</li>
<li><code>LlamaConfig</code> configuration class: <code>FlaxLlamaForCausalLM</code> (LLaMA model)</li>
<li><code>MistralConfig</code> configuration class: <code>FlaxMistralForCausalLM</code> (Mistral model)</li>
<li><code>OPTConfig</code> configuration class: <code>FlaxOPTForCausalLM</code> (OPT model)</li>
<li><code>RobertaConfig</code> configuration class: <code>FlaxRobertaForCausalLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>FlaxRobertaPreLayerNormForCausalLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>XGLMConfig</code> configuration class: <code>FlaxXGLMForCausalLM</code> (XGLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>FlaxXLMRobertaForCausalLM</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Ks=new k({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_config.example",$$slots:{default:[EN]},$$scope:{ctx:v}}}),Vc=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),ei=new k({props:{anchor:"transformers.FlaxAutoModelForCausalLM.from_pretrained.example",$$slots:{default:[IN]},$$scope:{ctx:v}}}),Sc=new Z({props:{title:"AutoModelForMaskedLM",local:"transformers.AutoModelForMaskedLM",headingTag:"h3"}}),Ec=new j({props:{name:"class transformers.AutoModelForMaskedLM",anchor:"transformers.AutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1414"}}),Ic=new j({props:{name:"from_config",anchor:"transformers.AutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForMaskedLM">AlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForMaskedLM">BertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForMaskedLM">BigBirdForMaskedLM</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForMaskedLM">CamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForMaskedLM">ConvBertForMaskedLM</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForMaskedLM">Data2VecTextForMaskedLM</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForMaskedLM">DebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForMaskedLM">DebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>DistilBertForMaskedLM</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>ElectraForMaskedLM</code> (ELECTRA model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieForMaskedLM</code> (ERNIE model)</li>
<li><code>EsmConfig</code> configuration class: <code>EsmForMaskedLM</code> (ESM model)</li>
<li><code>FNetConfig</code> configuration class: <code>FNetForMaskedLM</code> (FNet model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>FlaubertWithLMHeadModel</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>FunnelForMaskedLM</code> (Funnel Transformer model)</li>
<li><code>IBertConfig</code> configuration class: <code>IBertForMaskedLM</code> (I-BERT model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>LayoutLMForMaskedLM</code> (LayoutLM model)</li>
<li><code>LongformerConfig</code> configuration class: <code>LongformerForMaskedLM</code> (Longformer model)</li>
<li><code>LukeConfig</code> configuration class: <code>LukeForMaskedLM</code> (LUKE model)</li>
<li><code>MBartConfig</code> configuration class: <code>MBartForConditionalGeneration</code> (mBART model)</li>
<li><code>MPNetConfig</code> configuration class: <code>MPNetForMaskedLM</code> (MPNet model)</li>
<li><code>MegaConfig</code> configuration class: <code>MegaForMaskedLM</code> (MEGA model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertForMaskedLM</code> (Megatron-BERT model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>MobileBertForMaskedLM</code> (MobileBERT model)</li>
<li><code>MraConfig</code> configuration class: <code>MraForMaskedLM</code> (MRA model)</li>
<li><code>MvpConfig</code> configuration class: <code>MvpForConditionalGeneration</code> (MVP model)</li>
<li><code>NezhaConfig</code> configuration class: <code>NezhaForMaskedLM</code> (Nezha model)</li>
<li><code>NystromformerConfig</code> configuration class: <code>NystromformerForMaskedLM</code> (Nystr&#xF6;mformer model)</li>
<li><code>PerceiverConfig</code> configuration class: <code>PerceiverForMaskedLM</code> (Perceiver model)</li>
<li><code>QDQBertConfig</code> configuration class: <code>QDQBertForMaskedLM</code> (QDQBert model)</li>
<li><code>ReformerConfig</code> configuration class: <code>ReformerForMaskedLM</code> (Reformer model)</li>
<li><code>RemBertConfig</code> configuration class: <code>RemBertForMaskedLM</code> (RemBERT model)</li>
<li><code>RoCBertConfig</code> configuration class: <code>RoCBertForMaskedLM</code> (RoCBert model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>RoFormerForMaskedLM</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>RobertaForMaskedLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>RobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>SqueezeBertConfig</code> configuration class: <code>SqueezeBertForMaskedLM</code> (SqueezeBERT model)</li>
<li><code>TapasConfig</code> configuration class: <code>TapasForMaskedLM</code> (TAPAS model)</li>
<li><code>Wav2Vec2Config</code> configuration class: <code>Wav2Vec2ForMaskedLM</code> (Wav2Vec2 model)</li>
<li><code>XLMConfig</code> configuration class: <code>XLMWithLMHeadModel</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>XLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>
<li><code>XLMRobertaXLConfig</code> configuration class: <code>XLMRobertaXLForMaskedLM</code> (XLM-RoBERTa-XL model)</li>
<li><code>XmodConfig</code> configuration class: <code>XmodForMaskedLM</code> (X-MOD model)</li>
<li><code>YosoConfig</code> configuration class: <code>YosoForMaskedLM</code> (YOSO model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMaskedLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),oi=new k({props:{anchor:"transformers.AutoModelForMaskedLM.from_config.example",$$slots:{default:[UN]},$$scope:{ctx:v}}}),Uc=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForMaskedLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),ti=new k({props:{anchor:"transformers.AutoModelForMaskedLM.from_pretrained.example",$$slots:{default:[PN]},$$scope:{ctx:v}}}),Pc=new Z({props:{title:"TFAutoModelForMaskedLM",local:"transformers.TFAutoModelForMaskedLM",headingTag:"h3"}}),qc=new j({props:{name:"class transformers.TFAutoModelForMaskedLM",anchor:"transformers.TFAutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L612"}}),Nc=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForMaskedLM">TFAlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForMaskedLM">TFBertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForMaskedLM">TFCamembertForMaskedLM</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForMaskedLM">TFConvBertForMaskedLM</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaForMaskedLM">TFDebertaForMaskedLM</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForMaskedLM">TFDebertaV2ForMaskedLM</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>TFDistilBertForMaskedLM</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>TFElectraForMaskedLM</code> (ELECTRA model)</li>
<li><code>EsmConfig</code> configuration class: <code>TFEsmForMaskedLM</code> (ESM model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>TFFlaubertWithLMHeadModel</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>TFFunnelForMaskedLM</code> (Funnel Transformer model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>TFLayoutLMForMaskedLM</code> (LayoutLM model)</li>
<li><code>LongformerConfig</code> configuration class: <code>TFLongformerForMaskedLM</code> (Longformer model)</li>
<li><code>MPNetConfig</code> configuration class: <code>TFMPNetForMaskedLM</code> (MPNet model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>TFMobileBertForMaskedLM</code> (MobileBERT model)</li>
<li><code>RemBertConfig</code> configuration class: <code>TFRemBertForMaskedLM</code> (RemBERT model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>TFRoFormerForMaskedLM</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>TFRobertaForMaskedLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>TFRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>TapasConfig</code> configuration class: <code>TFTapasForMaskedLM</code> (TAPAS model)</li>
<li><code>XLMConfig</code> configuration class: <code>TFXLMWithLMHeadModel</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>TFXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForMaskedLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),ni=new k({props:{anchor:"transformers.TFAutoModelForMaskedLM.from_config.example",$$slots:{default:[qN]},$$scope:{ctx:v}}}),Xc=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),ri=new k({props:{anchor:"transformers.TFAutoModelForMaskedLM.from_pretrained.example",$$slots:{default:[NN]},$$scope:{ctx:v}}}),Dc=new Z({props:{title:"FlaxAutoModelForMaskedLM",local:"transformers.FlaxAutoModelForMaskedLM",headingTag:"h3"}}),Hc=new j({props:{name:"class transformers.FlaxAutoModelForMaskedLM",anchor:"transformers.FlaxAutoModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L301"}}),Qc=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForMaskedLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForMaskedLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForMaskedLM">FlaxAlbertForMaskedLM</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForMaskedLM">FlaxBertForMaskedLM</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForMaskedLM">FlaxBigBirdForMaskedLM</a> (BigBird model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>FlaxDistilBertForMaskedLM</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>FlaxElectraForMaskedLM</code> (ELECTRA model)</li>
<li><code>MBartConfig</code> configuration class: <code>FlaxMBartForConditionalGeneration</code> (mBART model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>FlaxRoFormerForMaskedLM</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>FlaxRobertaForMaskedLM</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>FlaxRobertaPreLayerNormForMaskedLM</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>FlaxXLMRobertaForMaskedLM</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),ai=new k({props:{anchor:"transformers.FlaxAutoModelForMaskedLM.from_config.example",$$slots:{default:[XN]},$$scope:{ctx:v}}}),Yc=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),si=new k({props:{anchor:"transformers.FlaxAutoModelForMaskedLM.from_pretrained.example",$$slots:{default:[DN]},$$scope:{ctx:v}}}),zc=new Z({props:{title:"AutoModelForMaskGeneration",local:"transformers.AutoModelForMaskGeneration",headingTag:"h3"}}),Kc=new j({props:{name:"class transformers.AutoModelForMaskGeneration",anchor:"transformers.AutoModelForMaskGeneration",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1373"}}),em=new Z({props:{title:"TFAutoModelForMaskGeneration",local:"transformers.TFAutoModelForMaskGeneration",headingTag:"h3"}}),tm=new j({props:{name:"class transformers.TFAutoModelForMaskGeneration",anchor:"transformers.TFAutoModelForMaskGeneration",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L523"}}),nm=new Z({props:{title:"AutoModelForSeq2SeqLM",local:"transformers.AutoModelForSeq2SeqLM",headingTag:"h3"}}),rm=new j({props:{name:"class transformers.AutoModelForSeq2SeqLM",anchor:"transformers.AutoModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1421"}}),am=new j({props:{name:"from_config",anchor:"transformers.AutoModelForSeq2SeqLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForSeq2SeqLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForConditionalGeneration">BartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForConditionalGeneration">BigBirdPegasusForConditionalGeneration</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotForConditionalGeneration">BlenderbotForConditionalGeneration</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallForConditionalGeneration">BlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li>
<li><code>EncoderDecoderConfig</code> configuration class: <code>EncoderDecoderModel</code> (Encoder decoder model)</li>
<li><code>FSMTConfig</code> configuration class: <code>FSMTForConditionalGeneration</code> (FairSeq Machine-Translation model)</li>
<li><code>GPTSanJapaneseConfig</code> configuration class: <code>GPTSanJapaneseForConditionalGeneration</code> (GPTSAN-japanese model)</li>
<li><code>LEDConfig</code> configuration class: <code>LEDForConditionalGeneration</code> (LED model)</li>
<li><code>LongT5Config</code> configuration class: <code>LongT5ForConditionalGeneration</code> (LongT5 model)</li>
<li><code>M2M100Config</code> configuration class: <code>M2M100ForConditionalGeneration</code> (M2M100 model)</li>
<li><code>MBartConfig</code> configuration class: <code>MBartForConditionalGeneration</code> (mBART model)</li>
<li><code>MT5Config</code> configuration class: <code>MT5ForConditionalGeneration</code> (MT5 model)</li>
<li><code>MarianConfig</code> configuration class: <code>MarianMTModel</code> (Marian model)</li>
<li><code>MvpConfig</code> configuration class: <code>MvpForConditionalGeneration</code> (MVP model)</li>
<li><code>NllbMoeConfig</code> configuration class: <code>NllbMoeForConditionalGeneration</code> (NLLB-MOE model)</li>
<li><code>PLBartConfig</code> configuration class: <code>PLBartForConditionalGeneration</code> (PLBart model)</li>
<li><code>PegasusConfig</code> configuration class: <code>PegasusForConditionalGeneration</code> (Pegasus model)</li>
<li><code>PegasusXConfig</code> configuration class: <code>PegasusXForConditionalGeneration</code> (PEGASUS-X model)</li>
<li><code>ProphetNetConfig</code> configuration class: <code>ProphetNetForConditionalGeneration</code> (ProphetNet model)</li>
<li><code>SeamlessM4TConfig</code> configuration class: <code>SeamlessM4TForTextToText</code> (SeamlessM4T model)</li>
<li><code>SeamlessM4Tv2Config</code> configuration class: <code>SeamlessM4Tv2ForTextToText</code> (SeamlessM4Tv2 model)</li>
<li><code>SwitchTransformersConfig</code> configuration class: <code>SwitchTransformersForConditionalGeneration</code> (SwitchTransformers model)</li>
<li><code>T5Config</code> configuration class: <code>T5ForConditionalGeneration</code> (T5 model)</li>
<li><code>UMT5Config</code> configuration class: <code>UMT5ForConditionalGeneration</code> (UMT5 model)</li>
<li><code>XLMProphetNetConfig</code> configuration class: <code>XLMProphetNetForConditionalGeneration</code> (XLM-ProphetNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),ii=new k({props:{anchor:"transformers.AutoModelForSeq2SeqLM.from_config.example",$$slots:{default:[HN]},$$scope:{ctx:v}}}),sm=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),li=new k({props:{anchor:"transformers.AutoModelForSeq2SeqLM.from_pretrained.example",$$slots:{default:[QN]},$$scope:{ctx:v}}}),im=new Z({props:{title:"TFAutoModelForSeq2SeqLM",local:"transformers.TFAutoModelForSeq2SeqLM",headingTag:"h3"}}),lm=new j({props:{name:"class transformers.TFAutoModelForSeq2SeqLM",anchor:"transformers.TFAutoModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L619"}}),dm=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForSeq2SeqLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartForConditionalGeneration">TFBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.TFBlenderbotForConditionalGeneration">TFBlenderbotForConditionalGeneration</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.TFBlenderbotSmallForConditionalGeneration">TFBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li>
<li><code>EncoderDecoderConfig</code> configuration class: <code>TFEncoderDecoderModel</code> (Encoder decoder model)</li>
<li><code>LEDConfig</code> configuration class: <code>TFLEDForConditionalGeneration</code> (LED model)</li>
<li><code>MBartConfig</code> configuration class: <code>TFMBartForConditionalGeneration</code> (mBART model)</li>
<li><code>MT5Config</code> configuration class: <code>TFMT5ForConditionalGeneration</code> (MT5 model)</li>
<li><code>MarianConfig</code> configuration class: <code>TFMarianMTModel</code> (Marian model)</li>
<li><code>PegasusConfig</code> configuration class: <code>TFPegasusForConditionalGeneration</code> (Pegasus model)</li>
<li><code>T5Config</code> configuration class: <code>TFT5ForConditionalGeneration</code> (T5 model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),di=new k({props:{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_config.example",$$slots:{default:[YN]},$$scope:{ctx:v}}}),cm=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),ci=new k({props:{anchor:"transformers.TFAutoModelForSeq2SeqLM.from_pretrained.example",$$slots:{default:[zN]},$$scope:{ctx:v}}}),mm=new Z({props:{title:"FlaxAutoModelForSeq2SeqLM",local:"transformers.FlaxAutoModelForSeq2SeqLM",headingTag:"h3"}}),fm=new j({props:{name:"class transformers.FlaxAutoModelForSeq2SeqLM",anchor:"transformers.FlaxAutoModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L308"}}),gm=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForConditionalGeneration">FlaxBartForConditionalGeneration</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.BlenderbotConfig">BlenderbotConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot#transformers.FlaxBlenderbotForConditionalGeneration">FlaxBlenderbotForConditionalGeneration</a> (Blenderbot model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.BlenderbotSmallConfig">BlenderbotSmallConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/blenderbot-small#transformers.FlaxBlenderbotSmallForConditionalGeneration">FlaxBlenderbotSmallForConditionalGeneration</a> (BlenderbotSmall model)</li>
<li><code>EncoderDecoderConfig</code> configuration class: <code>FlaxEncoderDecoderModel</code> (Encoder decoder model)</li>
<li><code>LongT5Config</code> configuration class: <code>FlaxLongT5ForConditionalGeneration</code> (LongT5 model)</li>
<li><code>MBartConfig</code> configuration class: <code>FlaxMBartForConditionalGeneration</code> (mBART model)</li>
<li><code>MT5Config</code> configuration class: <code>FlaxMT5ForConditionalGeneration</code> (MT5 model)</li>
<li><code>MarianConfig</code> configuration class: <code>FlaxMarianMTModel</code> (Marian model)</li>
<li><code>PegasusConfig</code> configuration class: <code>FlaxPegasusForConditionalGeneration</code> (Pegasus model)</li>
<li><code>T5Config</code> configuration class: <code>FlaxT5ForConditionalGeneration</code> (T5 model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),mi=new k({props:{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_config.example",$$slots:{default:[ON]},$$scope:{ctx:v}}}),pm=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),fi=new k({props:{anchor:"transformers.FlaxAutoModelForSeq2SeqLM.from_pretrained.example",$$slots:{default:[KN]},$$scope:{ctx:v}}}),um=new Z({props:{title:"AutoModelForSequenceClassification",local:"transformers.AutoModelForSequenceClassification",headingTag:"h3"}}),hm=new j({props:{name:"class transformers.AutoModelForSequenceClassification",anchor:"transformers.AutoModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1432"}}),bm=new j({props:{name:"from_config",anchor:"transformers.AutoModelForSequenceClassification.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForSequenceClassification.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForSequenceClassification">AlbertForSequenceClassification</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartForSequenceClassification">BartForSequenceClassification</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForSequenceClassification">BertForSequenceClassification</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForSequenceClassification">BigBirdForSequenceClassification</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusConfig">BigBirdPegasusConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bigbird_pegasus#transformers.BigBirdPegasusForSequenceClassification">BigBirdPegasusForSequenceClassification</a> (BigBird-Pegasus model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptConfig">BioGptConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/biogpt#transformers.BioGptForSequenceClassification">BioGptForSequenceClassification</a> (BioGpt model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomConfig">BloomConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bloom#transformers.BloomForSequenceClassification">BloomForSequenceClassification</a> (BLOOM model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLForSequenceClassification">CTRLForSequenceClassification</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForSequenceClassification">CamembertForSequenceClassification</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineConfig">CanineConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineForSequenceClassification">CanineForSequenceClassification</a> (CANINE model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForSequenceClassification">ConvBertForSequenceClassification</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForSequenceClassification">Data2VecTextForSequenceClassification</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaForSequenceClassification">DebertaForSequenceClassification</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForSequenceClassification">DebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>DistilBertForSequenceClassification</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>ElectraForSequenceClassification</code> (ELECTRA model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieForSequenceClassification</code> (ERNIE model)</li>
<li><code>ErnieMConfig</code> configuration class: <code>ErnieMForSequenceClassification</code> (ErnieM model)</li>
<li><code>EsmConfig</code> configuration class: <code>EsmForSequenceClassification</code> (ESM model)</li>
<li><code>FNetConfig</code> configuration class: <code>FNetForSequenceClassification</code> (FNet model)</li>
<li><code>FalconConfig</code> configuration class: <code>FalconForSequenceClassification</code> (Falcon model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>FlaubertForSequenceClassification</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>FunnelForSequenceClassification</code> (Funnel Transformer model)</li>
<li><code>GPT2Config</code> configuration class: <code>GPT2ForSequenceClassification</code> (OpenAI GPT-2 model)</li>
<li><code>GPTBigCodeConfig</code> configuration class: <code>GPTBigCodeForSequenceClassification</code> (GPTBigCode model)</li>
<li><code>GPTJConfig</code> configuration class: <code>GPTJForSequenceClassification</code> (GPT-J model)</li>
<li><code>GPTNeoConfig</code> configuration class: <code>GPTNeoForSequenceClassification</code> (GPT Neo model)</li>
<li><code>GPTNeoXConfig</code> configuration class: <code>GPTNeoXForSequenceClassification</code> (GPT NeoX model)</li>
<li><code>GemmaConfig</code> configuration class: <code>GemmaForSequenceClassification</code> (Gemma model)</li>
<li><code>IBertConfig</code> configuration class: <code>IBertForSequenceClassification</code> (I-BERT model)</li>
<li><code>LEDConfig</code> configuration class: <code>LEDForSequenceClassification</code> (LED model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>LayoutLMForSequenceClassification</code> (LayoutLM model)</li>
<li><code>LayoutLMv2Config</code> configuration class: <code>LayoutLMv2ForSequenceClassification</code> (LayoutLMv2 model)</li>
<li><code>LayoutLMv3Config</code> configuration class: <code>LayoutLMv3ForSequenceClassification</code> (LayoutLMv3 model)</li>
<li><code>LiltConfig</code> configuration class: <code>LiltForSequenceClassification</code> (LiLT model)</li>
<li><code>LlamaConfig</code> configuration class: <code>LlamaForSequenceClassification</code> (LLaMA model)</li>
<li><code>LongformerConfig</code> configuration class: <code>LongformerForSequenceClassification</code> (Longformer model)</li>
<li><code>LukeConfig</code> configuration class: <code>LukeForSequenceClassification</code> (LUKE model)</li>
<li><code>MBartConfig</code> configuration class: <code>MBartForSequenceClassification</code> (mBART model)</li>
<li><code>MPNetConfig</code> configuration class: <code>MPNetForSequenceClassification</code> (MPNet model)</li>
<li><code>MT5Config</code> configuration class: <code>MT5ForSequenceClassification</code> (MT5 model)</li>
<li><code>MarkupLMConfig</code> configuration class: <code>MarkupLMForSequenceClassification</code> (MarkupLM model)</li>
<li><code>MegaConfig</code> configuration class: <code>MegaForSequenceClassification</code> (MEGA model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertForSequenceClassification</code> (Megatron-BERT model)</li>
<li><code>MistralConfig</code> configuration class: <code>MistralForSequenceClassification</code> (Mistral model)</li>
<li><code>MixtralConfig</code> configuration class: <code>MixtralForSequenceClassification</code> (Mixtral model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>MobileBertForSequenceClassification</code> (MobileBERT model)</li>
<li><code>MptConfig</code> configuration class: <code>MptForSequenceClassification</code> (MPT model)</li>
<li><code>MraConfig</code> configuration class: <code>MraForSequenceClassification</code> (MRA model)</li>
<li><code>MvpConfig</code> configuration class: <code>MvpForSequenceClassification</code> (MVP model)</li>
<li><code>NezhaConfig</code> configuration class: <code>NezhaForSequenceClassification</code> (Nezha model)</li>
<li><code>NystromformerConfig</code> configuration class: <code>NystromformerForSequenceClassification</code> (Nystr&#xF6;mformer model)</li>
<li><code>OPTConfig</code> configuration class: <code>OPTForSequenceClassification</code> (OPT model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>OpenAIGPTForSequenceClassification</code> (OpenAI GPT model)</li>
<li><code>OpenLlamaConfig</code> configuration class: <code>OpenLlamaForSequenceClassification</code> (OpenLlama model)</li>
<li><code>PLBartConfig</code> configuration class: <code>PLBartForSequenceClassification</code> (PLBart model)</li>
<li><code>PerceiverConfig</code> configuration class: <code>PerceiverForSequenceClassification</code> (Perceiver model)</li>
<li><code>PersimmonConfig</code> configuration class: <code>PersimmonForSequenceClassification</code> (Persimmon model)</li>
<li><code>PhiConfig</code> configuration class: <code>PhiForSequenceClassification</code> (Phi model)</li>
<li><code>QDQBertConfig</code> configuration class: <code>QDQBertForSequenceClassification</code> (QDQBert model)</li>
<li><code>Qwen2Config</code> configuration class: <code>Qwen2ForSequenceClassification</code> (Qwen2 model)</li>
<li><code>ReformerConfig</code> configuration class: <code>ReformerForSequenceClassification</code> (Reformer model)</li>
<li><code>RemBertConfig</code> configuration class: <code>RemBertForSequenceClassification</code> (RemBERT model)</li>
<li><code>RoCBertConfig</code> configuration class: <code>RoCBertForSequenceClassification</code> (RoCBert model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>RoFormerForSequenceClassification</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>RobertaForSequenceClassification</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>RobertaPreLayerNormForSequenceClassification</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>SqueezeBertConfig</code> configuration class: <code>SqueezeBertForSequenceClassification</code> (SqueezeBERT model)</li>
<li><code>StableLmConfig</code> configuration class: <code>StableLmForSequenceClassification</code> (StableLm model)</li>
<li><code>Starcoder2Config</code> configuration class: <code>Starcoder2ForSequenceClassification</code> (Starcoder2 model)</li>
<li><code>T5Config</code> configuration class: <code>T5ForSequenceClassification</code> (T5 model)</li>
<li><code>TapasConfig</code> configuration class: <code>TapasForSequenceClassification</code> (TAPAS model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TransfoXLForSequenceClassification</code> (Transformer-XL model)</li>
<li><code>UMT5Config</code> configuration class: <code>UMT5ForSequenceClassification</code> (UMT5 model)</li>
<li><code>XLMConfig</code> configuration class: <code>XLMForSequenceClassification</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>XLMRobertaForSequenceClassification</code> (XLM-RoBERTa model)</li>
<li><code>XLMRobertaXLConfig</code> configuration class: <code>XLMRobertaXLForSequenceClassification</code> (XLM-RoBERTa-XL model)</li>
<li><code>XLNetConfig</code> configuration class: <code>XLNetForSequenceClassification</code> (XLNet model)</li>
<li><code>XmodConfig</code> configuration class: <code>XmodForSequenceClassification</code> (X-MOD model)</li>
<li><code>YosoConfig</code> configuration class: <code>YosoForSequenceClassification</code> (YOSO model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForSequenceClassification.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),gi=new k({props:{anchor:"transformers.AutoModelForSequenceClassification.from_config.example",$$slots:{default:[eX]},$$scope:{ctx:v}}}),_m=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForSequenceClassification.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),pi=new k({props:{anchor:"transformers.AutoModelForSequenceClassification.from_pretrained.example",$$slots:{default:[oX]},$$scope:{ctx:v}}}),Mm=new Z({props:{title:"TFAutoModelForSequenceClassification",local:"transformers.TFAutoModelForSequenceClassification",headingTag:"h3"}}),Tm=new j({props:{name:"class transformers.TFAutoModelForSequenceClassification",anchor:"transformers.TFAutoModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L630"}}),ym=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForSequenceClassification.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForSequenceClassification.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForSequenceClassification">TFAlbertForSequenceClassification</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.TFBartForSequenceClassification">TFBartForSequenceClassification</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForSequenceClassification">TFBertForSequenceClassification</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.CTRLConfig">CTRLConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/ctrl#transformers.TFCTRLForSequenceClassification">TFCTRLForSequenceClassification</a> (CTRL model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForSequenceClassification">TFCamembertForSequenceClassification</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForSequenceClassification">TFConvBertForSequenceClassification</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta#transformers.DebertaConfig">DebertaConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta#transformers.TFDebertaForSequenceClassification">TFDebertaForSequenceClassification</a> (DeBERTa model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForSequenceClassification">TFDebertaV2ForSequenceClassification</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>TFDistilBertForSequenceClassification</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>TFElectraForSequenceClassification</code> (ELECTRA model)</li>
<li><code>EsmConfig</code> configuration class: <code>TFEsmForSequenceClassification</code> (ESM model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>TFFlaubertForSequenceClassification</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>TFFunnelForSequenceClassification</code> (Funnel Transformer model)</li>
<li><code>GPT2Config</code> configuration class: <code>TFGPT2ForSequenceClassification</code> (OpenAI GPT-2 model)</li>
<li><code>GPTJConfig</code> configuration class: <code>TFGPTJForSequenceClassification</code> (GPT-J model)</li>
<li><code>LayoutLMConfig</code> configuration class: <code>TFLayoutLMForSequenceClassification</code> (LayoutLM model)</li>
<li><code>LayoutLMv3Config</code> configuration class: <code>TFLayoutLMv3ForSequenceClassification</code> (LayoutLMv3 model)</li>
<li><code>LongformerConfig</code> configuration class: <code>TFLongformerForSequenceClassification</code> (Longformer model)</li>
<li><code>MPNetConfig</code> configuration class: <code>TFMPNetForSequenceClassification</code> (MPNet model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>TFMobileBertForSequenceClassification</code> (MobileBERT model)</li>
<li><code>OpenAIGPTConfig</code> configuration class: <code>TFOpenAIGPTForSequenceClassification</code> (OpenAI GPT model)</li>
<li><code>RemBertConfig</code> configuration class: <code>TFRemBertForSequenceClassification</code> (RemBERT model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>TFRoFormerForSequenceClassification</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>TFRobertaForSequenceClassification</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>TFRobertaPreLayerNormForSequenceClassification</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>TapasConfig</code> configuration class: <code>TFTapasForSequenceClassification</code> (TAPAS model)</li>
<li><code>TransfoXLConfig</code> configuration class: <code>TFTransfoXLForSequenceClassification</code> (Transformer-XL model)</li>
<li><code>XLMConfig</code> configuration class: <code>TFXLMForSequenceClassification</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>TFXLMRobertaForSequenceClassification</code> (XLM-RoBERTa model)</li>
<li><code>XLNetConfig</code> configuration class: <code>TFXLNetForSequenceClassification</code> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),ui=new k({props:{anchor:"transformers.TFAutoModelForSequenceClassification.from_config.example",$$slots:{default:[tX]},$$scope:{ctx:v}}}),Fm=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),hi=new k({props:{anchor:"transformers.TFAutoModelForSequenceClassification.from_pretrained.example",$$slots:{default:[nX]},$$scope:{ctx:v}}}),vm=new Z({props:{title:"FlaxAutoModelForSequenceClassification",local:"transformers.FlaxAutoModelForSequenceClassification",headingTag:"h3"}}),Cm=new j({props:{name:"class transformers.FlaxAutoModelForSequenceClassification",anchor:"transformers.FlaxAutoModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L319"}}),wm=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForSequenceClassification.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForSequenceClassification">FlaxAlbertForSequenceClassification</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bart#transformers.BartConfig">BartConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bart#transformers.FlaxBartForSequenceClassification">FlaxBartForSequenceClassification</a> (BART model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForSequenceClassification">FlaxBertForSequenceClassification</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForSequenceClassification">FlaxBigBirdForSequenceClassification</a> (BigBird model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>FlaxDistilBertForSequenceClassification</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>FlaxElectraForSequenceClassification</code> (ELECTRA model)</li>
<li><code>MBartConfig</code> configuration class: <code>FlaxMBartForSequenceClassification</code> (mBART model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>FlaxRoFormerForSequenceClassification</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>FlaxRobertaForSequenceClassification</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>FlaxRobertaPreLayerNormForSequenceClassification</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>FlaxXLMRobertaForSequenceClassification</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),bi=new k({props:{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_config.example",$$slots:{default:[rX]},$$scope:{ctx:v}}}),jm=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),_i=new k({props:{anchor:"transformers.FlaxAutoModelForSequenceClassification.from_pretrained.example",$$slots:{default:[aX]},$$scope:{ctx:v}}}),xm=new Z({props:{title:"AutoModelForMultipleChoice",local:"transformers.AutoModelForMultipleChoice",headingTag:"h3"}}),$m=new j({props:{name:"class transformers.AutoModelForMultipleChoice",anchor:"transformers.AutoModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1488"}}),km=new j({props:{name:"from_config",anchor:"transformers.AutoModelForMultipleChoice.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMultipleChoice.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertForMultipleChoice">AlbertForMultipleChoice</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForMultipleChoice">BertForMultipleChoice</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdForMultipleChoice">BigBirdForMultipleChoice</a> (BigBird model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertForMultipleChoice">CamembertForMultipleChoice</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineConfig">CanineConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/canine#transformers.CanineForMultipleChoice">CanineForMultipleChoice</a> (CANINE model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertForMultipleChoice">ConvBertForMultipleChoice</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextConfig">Data2VecTextConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/data2vec#transformers.Data2VecTextForMultipleChoice">Data2VecTextForMultipleChoice</a> (Data2VecText model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2ForMultipleChoice">DebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>DistilBertForMultipleChoice</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>ElectraForMultipleChoice</code> (ELECTRA model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieForMultipleChoice</code> (ERNIE model)</li>
<li><code>ErnieMConfig</code> configuration class: <code>ErnieMForMultipleChoice</code> (ErnieM model)</li>
<li><code>FNetConfig</code> configuration class: <code>FNetForMultipleChoice</code> (FNet model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>FlaubertForMultipleChoice</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>FunnelForMultipleChoice</code> (Funnel Transformer model)</li>
<li><code>IBertConfig</code> configuration class: <code>IBertForMultipleChoice</code> (I-BERT model)</li>
<li><code>LongformerConfig</code> configuration class: <code>LongformerForMultipleChoice</code> (Longformer model)</li>
<li><code>LukeConfig</code> configuration class: <code>LukeForMultipleChoice</code> (LUKE model)</li>
<li><code>MPNetConfig</code> configuration class: <code>MPNetForMultipleChoice</code> (MPNet model)</li>
<li><code>MegaConfig</code> configuration class: <code>MegaForMultipleChoice</code> (MEGA model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertForMultipleChoice</code> (Megatron-BERT model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>MobileBertForMultipleChoice</code> (MobileBERT model)</li>
<li><code>MraConfig</code> configuration class: <code>MraForMultipleChoice</code> (MRA model)</li>
<li><code>NezhaConfig</code> configuration class: <code>NezhaForMultipleChoice</code> (Nezha model)</li>
<li><code>NystromformerConfig</code> configuration class: <code>NystromformerForMultipleChoice</code> (Nystr&#xF6;mformer model)</li>
<li><code>QDQBertConfig</code> configuration class: <code>QDQBertForMultipleChoice</code> (QDQBert model)</li>
<li><code>RemBertConfig</code> configuration class: <code>RemBertForMultipleChoice</code> (RemBERT model)</li>
<li><code>RoCBertConfig</code> configuration class: <code>RoCBertForMultipleChoice</code> (RoCBert model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>RoFormerForMultipleChoice</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>RobertaForMultipleChoice</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>RobertaPreLayerNormForMultipleChoice</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>SqueezeBertConfig</code> configuration class: <code>SqueezeBertForMultipleChoice</code> (SqueezeBERT model)</li>
<li><code>XLMConfig</code> configuration class: <code>XLMForMultipleChoice</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>XLMRobertaForMultipleChoice</code> (XLM-RoBERTa model)</li>
<li><code>XLMRobertaXLConfig</code> configuration class: <code>XLMRobertaXLForMultipleChoice</code> (XLM-RoBERTa-XL model)</li>
<li><code>XLNetConfig</code> configuration class: <code>XLNetForMultipleChoice</code> (XLNet model)</li>
<li><code>XmodConfig</code> configuration class: <code>XmodForMultipleChoice</code> (X-MOD model)</li>
<li><code>YosoConfig</code> configuration class: <code>YosoForMultipleChoice</code> (YOSO model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMultipleChoice.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),Mi=new k({props:{anchor:"transformers.AutoModelForMultipleChoice.from_config.example",$$slots:{default:[sX]},$$scope:{ctx:v}}}),Zm=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForMultipleChoice.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Ti=new k({props:{anchor:"transformers.AutoModelForMultipleChoice.from_pretrained.example",$$slots:{default:[iX]},$$scope:{ctx:v}}}),Am=new Z({props:{title:"TFAutoModelForMultipleChoice",local:"transformers.TFAutoModelForMultipleChoice",headingTag:"h3"}}),Lm=new j({props:{name:"class transformers.TFAutoModelForMultipleChoice",anchor:"transformers.TFAutoModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L677"}}),Bm=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForMultipleChoice.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMultipleChoice.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.TFAlbertForMultipleChoice">TFAlbertForMultipleChoice</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForMultipleChoice">TFBertForMultipleChoice</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/camembert#transformers.CamembertConfig">CamembertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/camembert#transformers.TFCamembertForMultipleChoice">TFCamembertForMultipleChoice</a> (CamemBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/convbert#transformers.ConvBertConfig">ConvBertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/convbert#transformers.TFConvBertForMultipleChoice">TFConvBertForMultipleChoice</a> (ConvBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.DebertaV2Config">DebertaV2Config</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/deberta-v2#transformers.TFDebertaV2ForMultipleChoice">TFDebertaV2ForMultipleChoice</a> (DeBERTa-v2 model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>TFDistilBertForMultipleChoice</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>TFElectraForMultipleChoice</code> (ELECTRA model)</li>
<li><code>FlaubertConfig</code> configuration class: <code>TFFlaubertForMultipleChoice</code> (FlauBERT model)</li>
<li><code>FunnelConfig</code> configuration class: <code>TFFunnelForMultipleChoice</code> (Funnel Transformer model)</li>
<li><code>LongformerConfig</code> configuration class: <code>TFLongformerForMultipleChoice</code> (Longformer model)</li>
<li><code>MPNetConfig</code> configuration class: <code>TFMPNetForMultipleChoice</code> (MPNet model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>TFMobileBertForMultipleChoice</code> (MobileBERT model)</li>
<li><code>RemBertConfig</code> configuration class: <code>TFRemBertForMultipleChoice</code> (RemBERT model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>TFRoFormerForMultipleChoice</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>TFRobertaForMultipleChoice</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>TFRobertaPreLayerNormForMultipleChoice</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>XLMConfig</code> configuration class: <code>TFXLMForMultipleChoice</code> (XLM model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>TFXLMRobertaForMultipleChoice</code> (XLM-RoBERTa model)</li>
<li><code>XLNetConfig</code> configuration class: <code>TFXLNetForMultipleChoice</code> (XLNet model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),yi=new k({props:{anchor:"transformers.TFAutoModelForMultipleChoice.from_config.example",$$slots:{default:[lX]},$$scope:{ctx:v}}}),Rm=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Fi=new k({props:{anchor:"transformers.TFAutoModelForMultipleChoice.from_pretrained.example",$$slots:{default:[dX]},$$scope:{ctx:v}}}),Wm=new Z({props:{title:"FlaxAutoModelForMultipleChoice",local:"transformers.FlaxAutoModelForMultipleChoice",headingTag:"h3"}}),Jm=new j({props:{name:"class transformers.FlaxAutoModelForMultipleChoice",anchor:"transformers.FlaxAutoModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L344"}}),Gm=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForMultipleChoice.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/albert#transformers.AlbertConfig">AlbertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/albert#transformers.FlaxAlbertForMultipleChoice">FlaxAlbertForMultipleChoice</a> (ALBERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForMultipleChoice">FlaxBertForMultipleChoice</a> (BERT model)</li>
<li><a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.BigBirdConfig">BigBirdConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/big_bird#transformers.FlaxBigBirdForMultipleChoice">FlaxBigBirdForMultipleChoice</a> (BigBird model)</li>
<li><code>DistilBertConfig</code> configuration class: <code>FlaxDistilBertForMultipleChoice</code> (DistilBERT model)</li>
<li><code>ElectraConfig</code> configuration class: <code>FlaxElectraForMultipleChoice</code> (ELECTRA model)</li>
<li><code>RoFormerConfig</code> configuration class: <code>FlaxRoFormerForMultipleChoice</code> (RoFormer model)</li>
<li><code>RobertaConfig</code> configuration class: <code>FlaxRobertaForMultipleChoice</code> (RoBERTa model)</li>
<li><code>RobertaPreLayerNormConfig</code> configuration class: <code>FlaxRobertaPreLayerNormForMultipleChoice</code> (RoBERTa-PreLayerNorm model)</li>
<li><code>XLMRobertaConfig</code> configuration class: <code>FlaxXLMRobertaForMultipleChoice</code> (XLM-RoBERTa model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),vi=new k({props:{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_config.example",$$slots:{default:[cX]},$$scope:{ctx:v}}}),Vm=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),Ci=new k({props:{anchor:"transformers.FlaxAutoModelForMultipleChoice.from_pretrained.example",$$slots:{default:[mX]},$$scope:{ctx:v}}}),Sm=new Z({props:{title:"AutoModelForNextSentencePrediction",local:"transformers.AutoModelForNextSentencePrediction",headingTag:"h3"}}),Em=new j({props:{name:"class transformers.AutoModelForNextSentencePrediction",anchor:"transformers.AutoModelForNextSentencePrediction",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_auto.py#L1495"}}),Im=new j({props:{name:"from_config",anchor:"transformers.AutoModelForNextSentencePrediction.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForNextSentencePrediction.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertForNextSentencePrediction">BertForNextSentencePrediction</a> (BERT model)</li>
<li><code>ErnieConfig</code> configuration class: <code>ErnieForNextSentencePrediction</code> (ERNIE model)</li>
<li><code>FNetConfig</code> configuration class: <code>FNetForNextSentencePrediction</code> (FNet model)</li>
<li><code>MegatronBertConfig</code> configuration class: <code>MegatronBertForNextSentencePrediction</code> (Megatron-BERT model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>MobileBertForNextSentencePrediction</code> (MobileBERT model)</li>
<li><code>NezhaConfig</code> configuration class: <code>NezhaForNextSentencePrediction</code> (Nezha model)</li>
<li><code>QDQBertConfig</code> configuration class: <code>QDQBertForNextSentencePrediction</code> (QDQBert model)</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),wi=new k({props:{anchor:"transformers.AutoModelForNextSentencePrediction.from_config.example",$$slots:{default:[fX]},$$scope:{ctx:v}}}),Um=new j({props:{name:"from_pretrained",anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>tensorflow index checkpoint file</em> (e.g, <code>./tf_model/model.ckpt.index</code>). In
this case, <code>from_tf</code> should be set to <code>True</code> and a configuration object should be provided as
<code>config</code> argument. This loading path is slower than converting the TensorFlow checkpoint in a
PyTorch model using the provided conversion scripts and loading the PyTorch model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.state_dict",description:`<strong>state_dict</strong> (<em>Dict[str, torch.Tensor]</em>, <em>optional</em>) &#x2014;
A state dictionary to use instead of a state dictionary loaded from saved weights file.</p>
<p>This option can be used if you want to create a model from a pretrained configuration but load your own
weights. In this case though, you should check if using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> is not a simpler option.`,name:"state_dict"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.from_tf",description:`<strong>from_tf</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a TensorFlow checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_tf"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),ji=new k({props:{anchor:"transformers.AutoModelForNextSentencePrediction.from_pretrained.example",$$slots:{default:[gX]},$$scope:{ctx:v}}}),Pm=new Z({props:{title:"TFAutoModelForNextSentencePrediction",local:"transformers.TFAutoModelForNextSentencePrediction",headingTag:"h3"}}),qm=new j({props:{name:"class transformers.TFAutoModelForNextSentencePrediction",anchor:"transformers.TFAutoModelForNextSentencePrediction",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_tf_auto.py#L684"}}),Nm=new j({props:{name:"from_config",anchor:"transformers.TFAutoModelForNextSentencePrediction.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.TFBertForNextSentencePrediction">TFBertForNextSentencePrediction</a> (BERT model)</li>
<li><code>MobileBertConfig</code> configuration class: <code>TFMobileBertForNextSentencePrediction</code> (MobileBERT model)</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),xi=new k({props:{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_config.example",$$slots:{default:[pX]},$$scope:{ctx:v}}}),Xm=new j({props:{name:"from_pretrained",anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.model_args",description:`<strong>model_args</strong> (additional positional arguments, <em>optional</em>) &#x2014;
Will be passed along to the underlying model <code>__init__()</code> method.`,name:"model_args"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014;
Configuration for the model to use instead of an automatically loaded configuration. Configuration can
be automatically loaded when:</p>
<ul>
<li>The model is a model provided by the library (loaded with the <em>model id</em> string of a pretrained
model).</li>
<li>The model was saved using <a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> and is reloaded by supplying the
save directory.</li>
<li>The model is loaded by supplying a local directory as <code>pretrained_model_name_or_path</code> and a
configuration JSON file named <em>config.json</em> is found in the directory.</li>
</ul>`,name:"config"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file (see docstring of
<code>pretrained_model_name_or_path</code> argument).`,name:"from_pt"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received files. Will attempt to resume the download if such a
file exists.`,name:"resume_download"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether ot not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (e.g., not try downloading the model).`,name:"local_files_only(bool,"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom models defined on the Hub in their own modeling files. This option
should only be set to <code>True</code> for repositories you trust and in which you have read the code, as it will
execute code present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.code_revision",description:`<strong>code_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision to use for the code on the Hub, if the code leaves in a different repository than
the rest of the model. It can be a branch name, a tag name, or a commit id, since we use a git-based
system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any identifier
allowed by git.`,name:"code_revision"},{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it being loaded) and initiate the model (e.g.,
<code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>**kwargs</code> will be directly passed to the
underlying model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have
already been done)</li>
<li>If a configuration is not provided, <code>kwargs</code> will be first passed to the configuration class
initialization function (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig.from_pretrained">from_pretrained()</a>). Each key of <code>kwargs</code> that
corresponds to a configuration attribute will be used to override said attribute with the
supplied <code>kwargs</code> value. Remaining keys that do not correspond to any configuration attribute
will be passed to the underlying model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L444"}}),$i=new k({props:{anchor:"transformers.TFAutoModelForNextSentencePrediction.from_pretrained.example",$$slots:{default:[uX]},$$scope:{ctx:v}}}),Dm=new Z({props:{title:"FlaxAutoModelForNextSentencePrediction",local:"transformers.FlaxAutoModelForNextSentencePrediction",headingTag:"h3"}}),Hm=new j({props:{name:"class transformers.FlaxAutoModelForNextSentencePrediction",anchor:"transformers.FlaxAutoModelForNextSentencePrediction",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/modeling_flax_auto.py#L351"}}),Qm=new j({props:{name:"from_config",anchor:"transformers.FlaxAutoModelForNextSentencePrediction.from_config",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForNextSentencePrediction.from_config.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ja/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The model class to instantiate is selected based on the configuration class:</p>
<ul>
<li><a href="/docs/transformers/main/ja/model_doc/bert#transformers.BertConfig">BertConfig</a> configuration class: <a href="/docs/transformers/main/ja/model_doc/bert#transformers.FlaxBertForNextSentencePrediction">FlaxBertForNextSentencePrediction</a> (BERT model)</li>
</ul>`,name:"config"},{anchor:"transformers.FlaxAutoModelForNextSentencePrediction.from_config.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The attention implementation to use in the model (if relevant). Can be any of <code>&quot;eager&quot;</code> (manual implementation of the attention), <code>&quot;sdpa&quot;</code> (using <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>F.scaled_dot_product_attention</code></a>), or <code>&quot;flash_attention_2&quot;</code> (using <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Dao-AILab/flash-attention</a>). By default, if available, SDPA will be used for torch&gt;=2.1.1. The default is otherwise the manual <code>&quot;eager&quot;</code> implementation.`,name:"attn_implementation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/auto/auto_factory.py#L413"}}),ki=new k({props:{anchor:"transformers.FlaxAutoModelForNextSentencePrediction.from_config.example",$$slots:{default:[hX]},$$scope:{ctx:v}}}),Ym=new j({props:{name:"from_pretrained",anchor:"transformers.FlaxAutoModelForNextSentencePrediction.from_pretrained",parameters:[{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxAutoModelForNextSentencePrediction.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.</li>
<li>A path to a <em>directory</em> containing model weights saved using
<a href="/docs/transformers/main/ja/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a>, e.g., <code>./my_model_directory/</code>.</li>
<li>A path or url to a <em>PyTorch state_dict save file</em> (e.g, <code>./pt_model/pytorch_model.bin</code>). In this
case, <code>from_pt</code> should be set to <code>True</code> and a configuration object should be provided as <code>config</code>
argument. This loading path is slower than converting the PyTorch model in a TensorFlow model
using the provided conversion scripts and loading the TensorFlow model afterwards.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"transformers.