import{s as ca,o as Ua,n as Rs}from"../chunks/scheduler.37c15a92.js";import{S as ra,i as ua,g as U,s as t,r as e,A as oa,h as r,f as n,c as p,j as Ja,u as y,x as o,k as ia,y as Ta,a,v as j,d as J,t as i,w as c}from"../chunks/index.2bf4358c.js";import{T as Ws}from"../chunks/Tip.363c041f.js";import{Y as ha}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as wa}from"../chunks/CourseFloatingBanner.33a4139d.js";import{H as mn}from"../chunks/Heading.8ada512a.js";function Ca(C){let M,h="💡 本节深入介绍了BPE,甚至展示了一个完整的实现。如果你只想大致了解标记化算法,可以跳到最后。";return{c(){M=U("p"),M.textContent=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1cypazc"&&(M.textContent=h)},m(u,w){a(u,M,w)},p:Rs,d(u){u&&n(M)}}}function xa(C){let M,h="TGPT-2 和 RoBERTa 标记器(非常相似)有一个聪明的方法来处理这个问题: 他们不把单词看成是用 Unicode 字符写的，而是用字节写的。这样,基本词汇表的大小很小(256),但你能想到的每个字符仍将被包含在内,而不会最终转换为未知标记。这个技巧被称为 <em>字节级 BPE</em>。";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-kpd5nr"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Rs,d(u){u&&n(M)}}}function ma(C){let M,h="✏️ <strong>现在轮到你了!</strong>你认为下一个合并规则是什么？";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1ognczq"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Rs,d(u){u&&n(M)}}}function ga(C){let M,h="✏️ <strong>现在轮到你了!</strong> 你认为这个词 <code>&quot;unhug&quot;</code> 将如何被标记？";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-pbquv2"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Rs,d(u){u&&n(M)}}}function Ia(C){let M,h="💡 在同一语料库上使用 <code>train_new_from_iterator()</code> 不会产生完全相同的词汇表。这是因为当有最频繁对的选择时,我们选择遇到的第一个, 而 🤗 Tokenizers 库根据内部ID选择第一个。";return{c(){M=U("p"),M.innerHTML=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-4trwwy"&&(M.innerHTML=h)},m(u,w){a(u,M,w)},p:Rs,d(u){u&&n(M)}}}function fa(C){let M,h="⚠️ 如果存在未知字符,我们的实现将抛出错误,因为我们没有做任何处理它们。GPT-2 实际上没有未知标记(使用字节级 BPE 时不可能得到未知字符),但这可能发生在这里,因为我们没有在初始词汇表中包含所有可能的字节。 BPE 的这方面超出了本节的范围,因此我们忽略了细节。";return{c(){M=U("p"),M.textContent=h},l(u){M=r(u,"P",{"data-svelte-h":!0}),o(M)!=="svelte-c5loyl"&&(M.textContent=h)},m(u,w){a(u,M,w)},p:Rs,d(u){u&&n(M)}}}function $a(C){let M,h,u,w,d,Ps,q,Ks,Q,gn="字节对编码(BPE)最初被开发为一种压缩文本的算法,然后在预训练 GPT 模型时被 OpenAI 用于标记化。许多 Transformer 模型都使用它,包括 GPT、GPT-2、RoBERTa、BART 和 DeBERTa。",Fs,b,Ls,x,Os,k,sl,A,In="BPE 训练首先计算语料库中使用的唯一单词集(在完成标准化和预标记化步骤之后),然后通过获取用于编写这些单词的所有符号来构建词汇表。一个非常简单的例子,假设我们的语料库使用了这五个词:",ll,B,nl,V,fn="基础词汇将是 <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>。对于实际情况,基本词汇表将包含所有 ASCII 字符,至少,可能还包含一些 Unicode 字符。如果您正在标记的示例使用不在训练语料库中的字符,则该字符将转换为未知标记。这就是为什么许多 NLP 模型在分析带有表情符号的内容方面非常糟糕的原因之一。",al,m,tl,E,$n="获得这个基本词汇后,我们添加新的标记,直到通过学习<em>合并</em>达到所需的词汇量,这是将现有词汇表的两个元素合并为一个新元素的规则。因此,在开始时,这些合并将创建具有两个字符的标记,然后,随着训练的进行,会创建更长的子词。",pl,Z,dn="在分词器训练期间的任何一步,BPE 算法都会搜索最常见的现有标记对 (“对”,这里我们指的是单词中的两个连续标记)。最频繁的一对将被合并,我们冲洗并重复下一步。",Ml,z,qn="回到我们之前的例子,让我们假设单词具有以下频率:",el,G,yl,S,Qn="意味着 <code>&quot;hug&quot;</code> 在语料库中出现了10次, <code>&quot;pug&quot;</code> 5次, <code>&quot;pun&quot;</code> 12次, <code>&quot;bun&quot;</code> 4次, 以及 <code>&quot;hugs&quot;</code> 5次。我们通过将每个单词拆分为字符(形成我们初始词汇表的字符)来开始训练,这样我们就可以将每个单词视为一个标记列表:",jl,_,Jl,N,bn="然后我们看成对。这对 <code>(&quot;h&quot;, &quot;u&quot;)</code> 出现在单词 <code>&quot;hug&quot;</code> 和 <code>&quot;hugs&quot;</code>中,所以语料库中总共有15次。不过,这并不是最频繁的一对:这个荣誉属于 <code>(&quot;u&quot;, &quot;g&quot;)</code>,它出现在 <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, 以及 <code>&quot;hugs&quot;</code>中,在词汇表中总共 20 次。",il,v,kn="因此,标记器学习的第一个合并规则是 <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>,意思就是 <code>&quot;ug&quot;</code> 将被添加到词汇表中,并且这对应该合并到语料库的所有单词中。在这个阶段结束时,词汇表和语料库看起来像这样:",cl,H,Ul,X,An="现在我们有一些导致标记长于两个字符的对: 例如 <code>(&quot;h&quot;, &quot;ug&quot;)</code>, 在语料库中出现15次。然而,这个阶段最频繁的对是 <code>(&quot;u&quot;, &quot;n&quot;)</code>,在语料库中出现16次,所以学到的第二个合并规则是 <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>。将其添加到词汇表并合并所有现有的这个对,将出现:",rl,D,ul,W,Bn="现在最频繁的一对是 <code>(&quot;h&quot;, &quot;ug&quot;)</code>,所以我们学习了合并规则 <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>,这给了我们第一个三个字母的标记。合并后,语料库如下所示:",ol,R,Tl,Y,Vn="我们继续这样合并,直到达到我们所需的词汇量。",hl,g,wl,P,Cl,K,En="标记化紧跟训练过程,从某种意义上说,通过应用以下步骤对新输入进行标记:",xl,F,Zn="<li>规范化</li> <li>预标记化</li> <li>将单词拆分为单个字符</li> <li>将学习的合并规则按顺序应用于这些拆分</li>",ml,L,zn="让我们以我们在训练期间使用的示例为例,学习三个合并规则:",gl,O,Il,ss,Gn="这个单词 <code>&quot;bug&quot;</code> 将被标记为 <code>[&quot;b&quot;, &quot;ug&quot;]</code>。然而 <code>&quot;mug&quot;</code>,将被标记为 <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code>,因为字母 <code>&quot;m&quot;</code> 不再基本词汇表中。同样,单词<code>&quot;thug&quot;</code> 会被标记为 <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: 字母 <code>&quot;t&quot;</code> 不在基本词汇表中,应用合并规则首先导致 <code>&quot;u&quot;</code> 和 <code>&quot;g&quot;</code> 被合并,然后是 <code>&quot;hu&quot;</code> 和 <code>&quot;g&quot;</code> 被合并。",fl,I,$l,ls,dl,ns,Sn="现在让我们看一下 BPE 算法的实现。这不会是你可以在大型语料库上实际使用的优化版本;我们只是想向你展示代码,以便你可以更好地理解算法",ql,as,_n="首先我们需要一个语料库,所以让我们用几句话创建一个简单的语料库:",Ql,ts,bl,ps,Nn="接下来,我们需要将该语料库预先标记为单词。由于我们正在复制 BPE 标记器(如 GPT-2),我们将使用 <code>gpt2</code> 标记器作为预标记化的标记器:",kl,Ms,Al,es,vn="然后我们在进行预标记化时计算语料库中每个单词的频率:",Bl,ys,Vl,js,El,Js,Hn="下一步是计算基本词汇,由语料库中使用的所有字符组成:",Zl,is,zl,cs,Gl,Us,Xn="我们还在该词汇表的开头添加了模型使用的特殊标记。对于GPT-2,唯一的特殊标记是 <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",Sl,rs,_l,us,Dn="我们现在需要将每个单词拆分为单独的字符,以便能够开始训练:",Nl,os,vl,Ts,Wn="现在我们已准备好进行训练,让我们编写一个函数来计算每对的频率。我们需要在训练的每个步骤中使用它:",Hl,hs,Xl,ws,Rn="让我们来看看这个字典在初始拆分后的一部分:",Dl,Cs,Wl,xs,Rl,ms,Yn="现在, 找到最频繁的对只需要一个快速的循环:",Yl,gs,Pl,Is,Kl,fs,Pn="所以第一个要学习的合并是 <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, 我们添加 <code>&#39;Ġt&#39;</code> 到词汇表:",Fl,$s,Ll,ds,Kn="要继续接下来的步骤,我们需要在我们的<code>分词</code>字典中应用该合并。让我们为此编写另一个函数:",Ol,qs,sn,Qs,Fn="我们可以看看第一次合并的结果:",ln,bs,nn,ks,an,As,Ln="现在我们有了循环所需的一切,直到我们学会了我们想要的所有合并。我们的目标是词汇量达到50:",tn,Bs,pn,Vs,On="结果,我们学习了 19 条合并规则(初始词汇表的大小 31 — 30 字母字符,加上特殊标记):",Mn,Es,en,Zs,yn,zs,sa="词汇表由特殊标记、初始字母和所有合并结果组成:",jn,Gs,Jn,Ss,cn,f,Un,_s,la="为了对新文本进行分词,我们对其进行预分词、拆分，然后应用学到的所有合并规则:",rn,Ns,un,vs,na="我们可以在任何由字母表中的字符组成的文本上尝试这个:",on,Hs,Tn,Xs,hn,$,wn,Ds,aa="这就是 BPE 算法！接下来,我们将看看 WordPiece。",Cn,Ys,xn;return d=new mn({props:{title:"字节对编码标记化",local:"字节对编码标记化",headingTag:"h1"}}),q=new wa({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section5.ipynb"}]}}),b=new ha({props:{id:"HEikzVL-lZU"}}),x=new Ws({props:{$$slots:{default:[Ca]},$$scope:{ctx:C}}}),k=new mn({props:{title:"训练算法",local:"训练算法",headingTag:"h2"}}),B=new T({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),m=new Ws({props:{$$slots:{default:[xa]},$$scope:{ctx:C}}}),G=new T({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),_=new T({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),D=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new T({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),g=new Ws({props:{$$slots:{default:[ma]},$$scope:{ctx:C}}}),P=new mn({props:{title:"标记化算法",local:"标记化算法",headingTag:"h2"}}),O=new T({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),I=new Ws({props:{$$slots:{default:[ga]},$$scope:{ctx:C}}}),ls=new mn({props:{title:"实现 BPE",local:"实现 BPE",headingTag:"h2"}}),ts=new T({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),Ms=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),ys=new T({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),js=new T({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),is=new T({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),cs=new T({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),rs=new T({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),os=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),hs=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),Cs=new T({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),xs=new T({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),gs=new T({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),Is=new T({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),$s=new T({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),qs=new T({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),bs=new T({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),ks=new T({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new T({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Es=new T({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),Zs=new T({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Gs=new T({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new T({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),f=new Ws({props:{$$slots:{default:[Ia]},$$scope:{ctx:C}}}),Ns=new T({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new T({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Xs=new T({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$=new Ws({props:{warning:!0,$$slots:{default:[fa]},$$scope:{ctx:C}}}),{c(){M=U("meta"),h=t(),u=U("p"),w=t(),e(d.$$.fragment),Ps=t(),e(q.$$.fragment),Ks=t(),Q=U("p"),Q.textContent=gn,Fs=t(),e(b.$$.fragment),Ls=t(),e(x.$$.fragment),Os=t(),e(k.$$.fragment),sl=t(),A=U("p"),A.textContent=In,ll=t(),e(B.$$.fragment),nl=t(),V=U("p"),V.innerHTML=fn,al=t(),e(m.$$.fragment),tl=t(),E=U("p"),E.innerHTML=$n,pl=t(),Z=U("p"),Z.textContent=dn,Ml=t(),z=U("p"),z.textContent=qn,el=t(),e(G.$$.fragment),yl=t(),S=U("p"),S.innerHTML=Qn,jl=t(),e(_.$$.fragment),Jl=t(),N=U("p"),N.innerHTML=bn,il=t(),v=U("p"),v.innerHTML=kn,cl=t(),e(H.$$.fragment),Ul=t(),X=U("p"),X.innerHTML=An,rl=t(),e(D.$$.fragment),ul=t(),W=U("p"),W.innerHTML=Bn,ol=t(),e(R.$$.fragment),Tl=t(),Y=U("p"),Y.textContent=Vn,hl=t(),e(g.$$.fragment),wl=t(),e(P.$$.fragment),Cl=t(),K=U("p"),K.textContent=En,xl=t(),F=U("ol"),F.innerHTML=Zn,ml=t(),L=U("p"),L.textContent=zn,gl=t(),e(O.$$.fragment),Il=t(),ss=U("p"),ss.innerHTML=Gn,fl=t(),e(I.$$.fragment),$l=t(),e(ls.$$.fragment),dl=t(),ns=U("p"),ns.textContent=Sn,ql=t(),as=U("p"),as.textContent=_n,Ql=t(),e(ts.$$.fragment),bl=t(),ps=U("p"),ps.innerHTML=Nn,kl=t(),e(Ms.$$.fragment),Al=t(),es=U("p"),es.textContent=vn,Bl=t(),e(ys.$$.fragment),Vl=t(),e(js.$$.fragment),El=t(),Js=U("p"),Js.textContent=Hn,Zl=t(),e(is.$$.fragment),zl=t(),e(cs.$$.fragment),Gl=t(),Us=U("p"),Us.innerHTML=Xn,Sl=t(),e(rs.$$.fragment),_l=t(),us=U("p"),us.textContent=Dn,Nl=t(),e(os.$$.fragment),vl=t(),Ts=U("p"),Ts.textContent=Wn,Hl=t(),e(hs.$$.fragment),Xl=t(),ws=U("p"),ws.textContent=Rn,Dl=t(),e(Cs.$$.fragment),Wl=t(),e(xs.$$.fragment),Rl=t(),ms=U("p"),ms.textContent=Yn,Yl=t(),e(gs.$$.fragment),Pl=t(),e(Is.$$.fragment),Kl=t(),fs=U("p"),fs.innerHTML=Pn,Fl=t(),e($s.$$.fragment),Ll=t(),ds=U("p"),ds.innerHTML=Kn,Ol=t(),e(qs.$$.fragment),sn=t(),Qs=U("p"),Qs.textContent=Fn,ln=t(),e(bs.$$.fragment),nn=t(),e(ks.$$.fragment),an=t(),As=U("p"),As.textContent=Ln,tn=t(),e(Bs.$$.fragment),pn=t(),Vs=U("p"),Vs.textContent=On,Mn=t(),e(Es.$$.fragment),en=t(),e(Zs.$$.fragment),yn=t(),zs=U("p"),zs.textContent=sa,jn=t(),e(Gs.$$.fragment),Jn=t(),e(Ss.$$.fragment),cn=t(),e(f.$$.fragment),Un=t(),_s=U("p"),_s.textContent=la,rn=t(),e(Ns.$$.fragment),un=t(),vs=U("p"),vs.textContent=na,on=t(),e(Hs.$$.fragment),Tn=t(),e(Xs.$$.fragment),hn=t(),e($.$$.fragment),wn=t(),Ds=U("p"),Ds.textContent=aa,Cn=t(),Ys=U("p"),this.h()},l(s){const l=oa("svelte-u9bgzb",document.head);M=r(l,"META",{name:!0,content:!0}),l.forEach(n),h=p(s),u=r(s,"P",{}),Ja(u).forEach(n),w=p(s),y(d.$$.fragment,s),Ps=p(s),y(q.$$.fragment,s),Ks=p(s),Q=r(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-lhyfdv"&&(Q.textContent=gn),Fs=p(s),y(b.$$.fragment,s),Ls=p(s),y(x.$$.fragment,s),Os=p(s),y(k.$$.fragment,s),sl=p(s),A=r(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1atqp8i"&&(A.textContent=In),ll=p(s),y(B.$$.fragment,s),nl=p(s),V=r(s,"P",{"data-svelte-h":!0}),o(V)!=="svelte-3rvlij"&&(V.innerHTML=fn),al=p(s),y(m.$$.fragment,s),tl=p(s),E=r(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-8g2ccw"&&(E.innerHTML=$n),pl=p(s),Z=r(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-elpcx5"&&(Z.textContent=dn),Ml=p(s),z=r(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-hna4ud"&&(z.textContent=qn),el=p(s),y(G.$$.fragment,s),yl=p(s),S=r(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1it98ca"&&(S.innerHTML=Qn),jl=p(s),y(_.$$.fragment,s),Jl=p(s),N=r(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-uo8wgf"&&(N.innerHTML=bn),il=p(s),v=r(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1jyoq71"&&(v.innerHTML=kn),cl=p(s),y(H.$$.fragment,s),Ul=p(s),X=r(s,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1pv65ut"&&(X.innerHTML=An),rl=p(s),y(D.$$.fragment,s),ul=p(s),W=r(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-qi19pj"&&(W.innerHTML=Bn),ol=p(s),y(R.$$.fragment,s),Tl=p(s),Y=r(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1llka01"&&(Y.textContent=Vn),hl=p(s),y(g.$$.fragment,s),wl=p(s),y(P.$$.fragment,s),Cl=p(s),K=r(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-r3uwwz"&&(K.textContent=En),xl=p(s),F=r(s,"OL",{"data-svelte-h":!0}),o(F)!=="svelte-qfw9yl"&&(F.innerHTML=Zn),ml=p(s),L=r(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-7qr296"&&(L.textContent=zn),gl=p(s),y(O.$$.fragment,s),Il=p(s),ss=r(s,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-kdcvt1"&&(ss.innerHTML=Gn),fl=p(s),y(I.$$.fragment,s),$l=p(s),y(ls.$$.fragment,s),dl=p(s),ns=r(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1opr2x9"&&(ns.textContent=Sn),ql=p(s),as=r(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-h7ycdp"&&(as.textContent=_n),Ql=p(s),y(ts.$$.fragment,s),bl=p(s),ps=r(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-1mgbnee"&&(ps.innerHTML=Nn),kl=p(s),y(Ms.$$.fragment,s),Al=p(s),es=r(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-iztpt8"&&(es.textContent=vn),Bl=p(s),y(ys.$$.fragment,s),Vl=p(s),y(js.$$.fragment,s),El=p(s),Js=r(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-709vpd"&&(Js.textContent=Hn),Zl=p(s),y(is.$$.fragment,s),zl=p(s),y(cs.$$.fragment,s),Gl=p(s),Us=r(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-eim4rw"&&(Us.innerHTML=Xn),Sl=p(s),y(rs.$$.fragment,s),_l=p(s),us=r(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-dn36sm"&&(us.textContent=Dn),Nl=p(s),y(os.$$.fragment,s),vl=p(s),Ts=r(s,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1pjrlcu"&&(Ts.textContent=Wn),Hl=p(s),y(hs.$$.fragment,s),Xl=p(s),ws=r(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1dpjieb"&&(ws.textContent=Rn),Dl=p(s),y(Cs.$$.fragment,s),Wl=p(s),y(xs.$$.fragment,s),Rl=p(s),ms=r(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-11yh0hx"&&(ms.textContent=Yn),Yl=p(s),y(gs.$$.fragment,s),Pl=p(s),y(Is.$$.fragment,s),Kl=p(s),fs=r(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-lt4qad"&&(fs.innerHTML=Pn),Fl=p(s),y($s.$$.fragment,s),Ll=p(s),ds=r(s,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1c5amqr"&&(ds.innerHTML=Kn),Ol=p(s),y(qs.$$.fragment,s),sn=p(s),Qs=r(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-3nxfgz"&&(Qs.textContent=Fn),ln=p(s),y(bs.$$.fragment,s),nn=p(s),y(ks.$$.fragment,s),an=p(s),As=r(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-7cr8vy"&&(As.textContent=Ln),tn=p(s),y(Bs.$$.fragment,s),pn=p(s),Vs=r(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-6f3til"&&(Vs.textContent=On),Mn=p(s),y(Es.$$.fragment,s),en=p(s),y(Zs.$$.fragment,s),yn=p(s),zs=r(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-41gtyi"&&(zs.textContent=sa),jn=p(s),y(Gs.$$.fragment,s),Jn=p(s),y(Ss.$$.fragment,s),cn=p(s),y(f.$$.fragment,s),Un=p(s),_s=r(s,"P",{"data-svelte-h":!0}),o(_s)!=="svelte-rlzxb3"&&(_s.textContent=la),rn=p(s),y(Ns.$$.fragment,s),un=p(s),vs=r(s,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-1q8xngi"&&(vs.textContent=na),on=p(s),y(Hs.$$.fragment,s),Tn=p(s),y(Xs.$$.fragment,s),hn=p(s),y($.$$.fragment,s),wn=p(s),Ds=r(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-xspolt"&&(Ds.textContent=aa),Cn=p(s),Ys=r(s,"P",{}),Ja(Ys).forEach(n),this.h()},h(){ia(M,"name","hf:doc:metadata"),ia(M,"content",da)},m(s,l){Ta(document.head,M),a(s,h,l),a(s,u,l),a(s,w,l),j(d,s,l),a(s,Ps,l),j(q,s,l),a(s,Ks,l),a(s,Q,l),a(s,Fs,l),j(b,s,l),a(s,Ls,l),j(x,s,l),a(s,Os,l),j(k,s,l),a(s,sl,l),a(s,A,l),a(s,ll,l),j(B,s,l),a(s,nl,l),a(s,V,l),a(s,al,l),j(m,s,l),a(s,tl,l),a(s,E,l),a(s,pl,l),a(s,Z,l),a(s,Ml,l),a(s,z,l),a(s,el,l),j(G,s,l),a(s,yl,l),a(s,S,l),a(s,jl,l),j(_,s,l),a(s,Jl,l),a(s,N,l),a(s,il,l),a(s,v,l),a(s,cl,l),j(H,s,l),a(s,Ul,l),a(s,X,l),a(s,rl,l),j(D,s,l),a(s,ul,l),a(s,W,l),a(s,ol,l),j(R,s,l),a(s,Tl,l),a(s,Y,l),a(s,hl,l),j(g,s,l),a(s,wl,l),j(P,s,l),a(s,Cl,l),a(s,K,l),a(s,xl,l),a(s,F,l),a(s,ml,l),a(s,L,l),a(s,gl,l),j(O,s,l),a(s,Il,l),a(s,ss,l),a(s,fl,l),j(I,s,l),a(s,$l,l),j(ls,s,l),a(s,dl,l),a(s,ns,l),a(s,ql,l),a(s,as,l),a(s,Ql,l),j(ts,s,l),a(s,bl,l),a(s,ps,l),a(s,kl,l),j(Ms,s,l),a(s,Al,l),a(s,es,l),a(s,Bl,l),j(ys,s,l),a(s,Vl,l),j(js,s,l),a(s,El,l),a(s,Js,l),a(s,Zl,l),j(is,s,l),a(s,zl,l),j(cs,s,l),a(s,Gl,l),a(s,Us,l),a(s,Sl,l),j(rs,s,l),a(s,_l,l),a(s,us,l),a(s,Nl,l),j(os,s,l),a(s,vl,l),a(s,Ts,l),a(s,Hl,l),j(hs,s,l),a(s,Xl,l),a(s,ws,l),a(s,Dl,l),j(Cs,s,l),a(s,Wl,l),j(xs,s,l),a(s,Rl,l),a(s,ms,l),a(s,Yl,l),j(gs,s,l),a(s,Pl,l),j(Is,s,l),a(s,Kl,l),a(s,fs,l),a(s,Fl,l),j($s,s,l),a(s,Ll,l),a(s,ds,l),a(s,Ol,l),j(qs,s,l),a(s,sn,l),a(s,Qs,l),a(s,ln,l),j(bs,s,l),a(s,nn,l),j(ks,s,l),a(s,an,l),a(s,As,l),a(s,tn,l),j(Bs,s,l),a(s,pn,l),a(s,Vs,l),a(s,Mn,l),j(Es,s,l),a(s,en,l),j(Zs,s,l),a(s,yn,l),a(s,zs,l),a(s,jn,l),j(Gs,s,l),a(s,Jn,l),j(Ss,s,l),a(s,cn,l),j(f,s,l),a(s,Un,l),a(s,_s,l),a(s,rn,l),j(Ns,s,l),a(s,un,l),a(s,vs,l),a(s,on,l),j(Hs,s,l),a(s,Tn,l),j(Xs,s,l),a(s,hn,l),j($,s,l),a(s,wn,l),a(s,Ds,l),a(s,Cn,l),a(s,Ys,l),xn=!0},p(s,[l]){const ta={};l&2&&(ta.$$scope={dirty:l,ctx:s}),x.$set(ta);const pa={};l&2&&(pa.$$scope={dirty:l,ctx:s}),m.$set(pa);const Ma={};l&2&&(Ma.$$scope={dirty:l,ctx:s}),g.$set(Ma);const ea={};l&2&&(ea.$$scope={dirty:l,ctx:s}),I.$set(ea);const ya={};l&2&&(ya.$$scope={dirty:l,ctx:s}),f.$set(ya);const ja={};l&2&&(ja.$$scope={dirty:l,ctx:s}),$.$set(ja)},i(s){xn||(J(d.$$.fragment,s),J(q.$$.fragment,s),J(b.$$.fragment,s),J(x.$$.fragment,s),J(k.$$.fragment,s),J(B.$$.fragment,s),J(m.$$.fragment,s),J(G.$$.fragment,s),J(_.$$.fragment,s),J(H.$$.fragment,s),J(D.$$.fragment,s),J(R.$$.fragment,s),J(g.$$.fragment,s),J(P.$$.fragment,s),J(O.$$.fragment,s),J(I.$$.fragment,s),J(ls.$$.fragment,s),J(ts.$$.fragment,s),J(Ms.$$.fragment,s),J(ys.$$.fragment,s),J(js.$$.fragment,s),J(is.$$.fragment,s),J(cs.$$.fragment,s),J(rs.$$.fragment,s),J(os.$$.fragment,s),J(hs.$$.fragment,s),J(Cs.$$.fragment,s),J(xs.$$.fragment,s),J(gs.$$.fragment,s),J(Is.$$.fragment,s),J($s.$$.fragment,s),J(qs.$$.fragment,s),J(bs.$$.fragment,s),J(ks.$$.fragment,s),J(Bs.$$.fragment,s),J(Es.$$.fragment,s),J(Zs.$$.fragment,s),J(Gs.$$.fragment,s),J(Ss.$$.fragment,s),J(f.$$.fragment,s),J(Ns.$$.fragment,s),J(Hs.$$.fragment,s),J(Xs.$$.fragment,s),J($.$$.fragment,s),xn=!0)},o(s){i(d.$$.fragment,s),i(q.$$.fragment,s),i(b.$$.fragment,s),i(x.$$.fragment,s),i(k.$$.fragment,s),i(B.$$.fragment,s),i(m.$$.fragment,s),i(G.$$.fragment,s),i(_.$$.fragment,s),i(H.$$.fragment,s),i(D.$$.fragment,s),i(R.$$.fragment,s),i(g.$$.fragment,s),i(P.$$.fragment,s),i(O.$$.fragment,s),i(I.$$.fragment,s),i(ls.$$.fragment,s),i(ts.$$.fragment,s),i(Ms.$$.fragment,s),i(ys.$$.fragment,s),i(js.$$.fragment,s),i(is.$$.fragment,s),i(cs.$$.fragment,s),i(rs.$$.fragment,s),i(os.$$.fragment,s),i(hs.$$.fragment,s),i(Cs.$$.fragment,s),i(xs.$$.fragment,s),i(gs.$$.fragment,s),i(Is.$$.fragment,s),i($s.$$.fragment,s),i(qs.$$.fragment,s),i(bs.$$.fragment,s),i(ks.$$.fragment,s),i(Bs.$$.fragment,s),i(Es.$$.fragment,s),i(Zs.$$.fragment,s),i(Gs.$$.fragment,s),i(Ss.$$.fragment,s),i(f.$$.fragment,s),i(Ns.$$.fragment,s),i(Hs.$$.fragment,s),i(Xs.$$.fragment,s),i($.$$.fragment,s),xn=!1},d(s){s&&(n(h),n(u),n(w),n(Ps),n(Ks),n(Q),n(Fs),n(Ls),n(Os),n(sl),n(A),n(ll),n(nl),n(V),n(al),n(tl),n(E),n(pl),n(Z),n(Ml),n(z),n(el),n(yl),n(S),n(jl),n(Jl),n(N),n(il),n(v),n(cl),n(Ul),n(X),n(rl),n(ul),n(W),n(ol),n(Tl),n(Y),n(hl),n(wl),n(Cl),n(K),n(xl),n(F),n(ml),n(L),n(gl),n(Il),n(ss),n(fl),n($l),n(dl),n(ns),n(ql),n(as),n(Ql),n(bl),n(ps),n(kl),n(Al),n(es),n(Bl),n(Vl),n(El),n(Js),n(Zl),n(zl),n(Gl),n(Us),n(Sl),n(_l),n(us),n(Nl),n(vl),n(Ts),n(Hl),n(Xl),n(ws),n(Dl),n(Wl),n(Rl),n(ms),n(Yl),n(Pl),n(Kl),n(fs),n(Fl),n(Ll),n(ds),n(Ol),n(sn),n(Qs),n(ln),n(nn),n(an),n(As),n(tn),n(pn),n(Vs),n(Mn),n(en),n(yn),n(zs),n(jn),n(Jn),n(cn),n(Un),n(_s),n(rn),n(un),n(vs),n(on),n(Tn),n(hn),n(wn),n(Ds),n(Cn),n(Ys)),n(M),c(d,s),c(q,s),c(b,s),c(x,s),c(k,s),c(B,s),c(m,s),c(G,s),c(_,s),c(H,s),c(D,s),c(R,s),c(g,s),c(P,s),c(O,s),c(I,s),c(ls,s),c(ts,s),c(Ms,s),c(ys,s),c(js,s),c(is,s),c(cs,s),c(rs,s),c(os,s),c(hs,s),c(Cs,s),c(xs,s),c(gs,s),c(Is,s),c($s,s),c(qs,s),c(bs,s),c(ks,s),c(Bs,s),c(Es,s),c(Zs,s),c(Gs,s),c(Ss,s),c(f,s),c(Ns,s),c(Hs,s),c(Xs,s),c($,s)}}}const da='{"title":"字节对编码标记化","local":"字节对编码标记化","sections":[{"title":"训练算法","local":"训练算法","sections":[],"depth":2},{"title":"标记化算法","local":"标记化算法","sections":[],"depth":2},{"title":"实现 BPE","local":"实现 BPE","sections":[],"depth":2}],"depth":1}';function qa(C){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends ra{constructor(M){super(),ua(this,M,qa,$a,ca,{})}}export{Za as component};
