import{s as Me,n as be,o as we}from"../chunks/scheduler.182ea377.js";import{S as Te,i as ye,g as a,s,r as G,A as Je,h as p,f as l,c as i,j as he,u as j,x as o,k as le,y as Ue,a as n,v as I,d as $,t as _,w as B}from"../chunks/index.abf12888.js";import{C as te}from"../chunks/CodeBlock.57fe6e13.js";import{H as ne}from"../chunks/Heading.16916d63.js";function ge(se){let m,C,S,X,r,x,u,ie='🤗 <a href="https://github.com/huggingface/optimum-intel" rel="nofollow">Optimum</a> provides Stable Diffusion pipelines compatible with OpenVINO to perform inference on a variety of Intel processors (see the <a href="(https://docs.openvino.ai/latest/openvino_docs_OV_UG_supported_plugins_Supported_Devices.html)">full list</a> of supported devices).',E,d,ae='You’ll need to install 🤗 Optimum Intel with the <code>--upgrade-strategy eager</code> option to ensure <a href="https://github.com/huggingface/optimum-intel" rel="nofollow"><code>optimum-intel</code></a> is using the latest version:',H,c,L,h,pe="This guide will show you how to use the Stable Diffusion and Stable Diffusion XL (SDXL) pipelines with OpenVINO.",Q,M,R,b,oe="To load and run inference, use the <code>OVStableDiffusionPipeline</code>. If you want to load a PyTorch model and convert it to the OpenVINO format on-the-fly, set <code>export=True</code>:",N,w,k,T,me="To further speed-up inference, statically reshape the model. If you change any parameters such as the outputs height or width, you’ll need to statically reshape your model again.",D,y,Y,f,fe='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/stable_diffusion_v1_5_sail_boat_rembrandt.png"/>',P,J,re='You can find more examples in the 🤗 Optimum <a href="https://huggingface.co/docs/optimum/intel/inference#stable-diffusion" rel="nofollow">documentation</a>, and Stable Diffusion is supported for text-to-image, image-to-image, and inpainting.',O,U,z,g,ue="To load and run inference with SDXL, use the <code>OVStableDiffusionXLPipeline</code>:",F,W,q,Z,de='To further speed-up inference, <a href="#stable-diffusion">statically reshape</a> the model as shown in the Stable Diffusion section.',A,v,ce='You can find more examples in the 🤗 Optimum <a href="https://huggingface.co/docs/optimum/intel/inference#stable-diffusion-xl" rel="nofollow">documentation</a>, and running SDXL in OpenVINO is supported for text-to-image and image-to-image.',K,V,ee;return r=new ne({props:{title:"OpenVINO",local:"openvino",headingTag:"h1"}}),c=new te({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZS1zdHJhdGVneSUyMGVhZ2VyJTIwb3B0aW11bSU1QiUyMm9wZW52aW5vJTIyJTVE",highlighted:'pip install <span class="hljs-attr">--upgrade-strategy</span> eager optimum<span class="hljs-selector-attr">[<span class="hljs-string">&quot;openvino&quot;</span>]</span>',wrap:!1}}),M=new ne({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),w=new te({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwUmVtYnJhbmR0JTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEElMEElMjMlMjBEb24ndCUyMGZvcmdldCUyMHRvJTIwc2F2ZSUyMHRoZSUyMGV4cG9ydGVkJTIwbW9kZWwlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyb3BlbnZpbm8tc2QtdjEtNSUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Rembrandt&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Don&#x27;t forget to save the exported model</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-v1-5&quot;</span>)`,wrap:!1}}),y=new te({props:{code:"JTIzJTIwRGVmaW5lJTIwdGhlJTIwc2hhcGVzJTIwcmVsYXRlZCUyMHRvJTIwdGhlJTIwaW5wdXRzJTIwYW5kJTIwZGVzaXJlZCUyMG91dHB1dHMlMEFiYXRjaF9zaXplJTJDJTIwbnVtX2ltYWdlcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwMSUyQyUyMDElMkMlMjA1MTIlMkMlMjA1MTIlMEElMEElMjMlMjBTdGF0aWNhbGx5JTIwcmVzaGFwZSUyMHRoZSUyMG1vZGVsJTBBcGlwZWxpbmUucmVzaGFwZShiYXRjaF9zaXplJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGglMkMlMjBudW1faW1hZ2VzKSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMGluZmVyZW5jZSUwQXBpcGVsaW5lLmNvbXBpbGUoKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEaGVpZ2h0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0R3aWR0aCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXMlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Define the shapes related to the inputs and desired outputs</span>
batch_size, num_images, height, width = <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>

<span class="hljs-comment"># Statically reshape the model</span>
pipeline.reshape(batch_size, height, width, num_images)
<span class="hljs-comment"># Compile the model before inference</span>
pipeline.<span class="hljs-built_in">compile</span>()

image = pipeline(
    prompt,
    height=height,
    width=width,
    num_images_per_prompt=num_images,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),U=new ne({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),W=new te({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFwcm9tcHQlMjAlM0QlMjAlMjJzYWlsaW5nJTIwc2hpcCUyMGluJTIwc3Rvcm0lMjBieSUyMFJlbWJyYW5kdCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
pipeline = OVStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Rembrandt&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){m=a("meta"),C=s(),S=a("p"),X=s(),G(r.$$.fragment),x=s(),u=a("p"),u.innerHTML=ie,E=s(),d=a("p"),d.innerHTML=ae,H=s(),G(c.$$.fragment),L=s(),h=a("p"),h.textContent=pe,Q=s(),G(M.$$.fragment),R=s(),b=a("p"),b.innerHTML=oe,N=s(),G(w.$$.fragment),k=s(),T=a("p"),T.textContent=me,D=s(),G(y.$$.fragment),Y=s(),f=a("div"),f.innerHTML=fe,P=s(),J=a("p"),J.innerHTML=re,O=s(),G(U.$$.fragment),z=s(),g=a("p"),g.innerHTML=ue,F=s(),G(W.$$.fragment),q=s(),Z=a("p"),Z.innerHTML=de,A=s(),v=a("p"),v.innerHTML=ce,K=s(),V=a("p"),this.h()},l(e){const t=Je("svelte-u9bgzb",document.head);m=p(t,"META",{name:!0,content:!0}),t.forEach(l),C=i(e),S=p(e,"P",{}),he(S).forEach(l),X=i(e),j(r.$$.fragment,e),x=i(e),u=p(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-fdt6r6"&&(u.innerHTML=ie),E=i(e),d=p(e,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1yjuyfl"&&(d.innerHTML=ae),H=i(e),j(c.$$.fragment,e),L=i(e),h=p(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-rxdhyz"&&(h.textContent=pe),Q=i(e),j(M.$$.fragment,e),R=i(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1150q8r"&&(b.innerHTML=oe),N=i(e),j(w.$$.fragment,e),k=i(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-1pgwlbo"&&(T.textContent=me),D=i(e),j(y.$$.fragment,e),Y=i(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1bbei4i"&&(f.innerHTML=fe),P=i(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-al50pl"&&(J.innerHTML=re),O=i(e),j(U.$$.fragment,e),z=i(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1a3vd4r"&&(g.innerHTML=ue),F=i(e),j(W.$$.fragment,e),q=i(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1ku614i"&&(Z.innerHTML=de),A=i(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-ar6dc6"&&(v.innerHTML=ce),K=i(e),V=p(e,"P",{}),he(V).forEach(l),this.h()},h(){le(m,"name","hf:doc:metadata"),le(m,"content",We),le(f,"class","flex justify-center")},m(e,t){Ue(document.head,m),n(e,C,t),n(e,S,t),n(e,X,t),I(r,e,t),n(e,x,t),n(e,u,t),n(e,E,t),n(e,d,t),n(e,H,t),I(c,e,t),n(e,L,t),n(e,h,t),n(e,Q,t),I(M,e,t),n(e,R,t),n(e,b,t),n(e,N,t),I(w,e,t),n(e,k,t),n(e,T,t),n(e,D,t),I(y,e,t),n(e,Y,t),n(e,f,t),n(e,P,t),n(e,J,t),n(e,O,t),I(U,e,t),n(e,z,t),n(e,g,t),n(e,F,t),I(W,e,t),n(e,q,t),n(e,Z,t),n(e,A,t),n(e,v,t),n(e,K,t),n(e,V,t),ee=!0},p:be,i(e){ee||($(r.$$.fragment,e),$(c.$$.fragment,e),$(M.$$.fragment,e),$(w.$$.fragment,e),$(y.$$.fragment,e),$(U.$$.fragment,e),$(W.$$.fragment,e),ee=!0)},o(e){_(r.$$.fragment,e),_(c.$$.fragment,e),_(M.$$.fragment,e),_(w.$$.fragment,e),_(y.$$.fragment,e),_(U.$$.fragment,e),_(W.$$.fragment,e),ee=!1},d(e){e&&(l(C),l(S),l(X),l(x),l(u),l(E),l(d),l(H),l(L),l(h),l(Q),l(R),l(b),l(N),l(k),l(T),l(D),l(Y),l(f),l(P),l(J),l(O),l(z),l(g),l(F),l(q),l(Z),l(A),l(v),l(K),l(V)),l(m),B(r,e),B(c,e),B(M,e),B(w,e),B(y,e),B(U,e),B(W,e)}}}const We='{"title":"OpenVINO","local":"openvino","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2}],"depth":1}';function Ze(se){return we(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $e extends Te{constructor(m){super(),ye(this,m,Ze,ge,Me,{})}}export{$e as component};
