import{s as Ut,n as It,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as $t,g as p,s as e,r as m,A as vt,h as i,f as a,c as n,j as ft,u as o,x as g,k as bt,y as Bt,a as l,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as E}from"../chunks/CodeBlock.52fa569e.js";import{H as _}from"../chunks/Heading.3097d2ed.js";function kt(rt){let y,R,V,Y,d,S,J,ht='<strong>Inception-v4</strong> is a convolutional neural network architecture that builds on previous iterations of the Inception family by simplifying the architecture and using more inception modules than <a href="https://paperswithcode.com/method/inception-v3" rel="nofollow">Inception-v3</a>.',z,j,F,w,Mt="To load a pretrained model:",H,u,A,T,gt="To load and preprocess the image:",L,f,D,b,yt="To get the model predictions:",q,U,P,I,dt="To get the top-5 predictions class names:",K,C,O,Z,Jt="Replace the model name with the variant you want to use, e.g. <code>inception_v4</code>. You can find the IDs in the model summaries at the top of this page.",tt,$,jt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,v,at,B,wt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,k,et,W,ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,x,pt,G,Tt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,N,mt,Q,ot,X,ct;return d=new _({props:{title:"Inception v4",local:"inception-v4",headingTag:"h1"}}),j=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new E({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2luY2VwdGlvbl92NCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v4&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new E({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new E({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),v=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),k=new E({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaW5jZXB0aW9uX3Y0JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;inception_v4&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),N=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new E({props:{code:"JTQwbWlzYyU3QnN6ZWdlZHkyMDE2aW5jZXB0aW9udjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkluY2VwdGlvbi12NCUyQyUyMEluY2VwdGlvbi1SZXNOZXQlMjBhbmQlMjB0aGUlMjBJbXBhY3QlMjBvZiUyMFJlc2lkdWFsJTIwQ29ubmVjdGlvbnMlMjBvbiUyMExlYXJuaW5nJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUyMFNlcmdleSUyMElvZmZlJTIwYW5kJTIwVmluY2VudCUyMFZhbmhvdWNrZSUyMGFuZCUyMEFsZXglMjBBbGVtaSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTYwMi4wNzI2MSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{szegedy2016inceptionv4,
      title={Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Christian Szegedy and Sergey Ioffe and Vincent Vanhoucke and Alex Alemi}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1602.07261}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){y=p("meta"),R=e(),V=p("p"),Y=e(),m(d.$$.fragment),S=e(),J=p("p"),J.innerHTML=ht,z=e(),m(j.$$.fragment),F=e(),w=p("p"),w.textContent=Mt,H=e(),m(u.$$.fragment),A=e(),T=p("p"),T.textContent=gt,L=e(),m(f.$$.fragment),D=e(),b=p("p"),b.textContent=yt,q=e(),m(U.$$.fragment),P=e(),I=p("p"),I.textContent=dt,K=e(),m(C.$$.fragment),O=e(),Z=p("p"),Z.innerHTML=Jt,tt=e(),$=p("p"),$.innerHTML=jt,st=e(),m(v.$$.fragment),at=e(),B=p("p"),B.textContent=wt,lt=e(),m(k.$$.fragment),et=e(),W=p("p"),W.innerHTML=ut,nt=e(),m(x.$$.fragment),pt=e(),G=p("p"),G.innerHTML=Tt,it=e(),m(N.$$.fragment),mt=e(),m(Q.$$.fragment),ot=e(),X=p("p"),this.h()},l(t){const s=vt("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(a),R=n(t),V=i(t,"P",{}),ft(V).forEach(a),Y=n(t),o(d.$$.fragment,t),S=n(t),J=i(t,"P",{"data-svelte-h":!0}),g(J)!=="svelte-884pc9"&&(J.innerHTML=ht),z=n(t),o(j.$$.fragment,t),F=n(t),w=i(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-18ywhxh"&&(w.textContent=Mt),H=n(t),o(u.$$.fragment,t),A=n(t),T=i(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=gt),L=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=yt),q=n(t),o(U.$$.fragment,t),P=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=dt),K=n(t),o(C.$$.fragment,t),O=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-r4n0mi"&&(Z.innerHTML=Jt),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-1wmi3ea"&&($.innerHTML=jt),st=n(t),o(v.$$.fragment,t),at=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-9sr7nh"&&(B.textContent=wt),lt=n(t),o(k.$$.fragment,t),et=n(t),W=i(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1kguc51"&&(W.innerHTML=ut),nt=n(t),o(x.$$.fragment,t),pt=n(t),G=i(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1n0coha"&&(G.innerHTML=Tt),it=n(t),o(N.$$.fragment,t),mt=n(t),o(Q.$$.fragment,t),ot=n(t),X=i(t,"P",{}),ft(X).forEach(a),this.h()},h(){bt(y,"name","hf:doc:metadata"),bt(y,"content",Wt)},m(t,s){Bt(document.head,y),l(t,R,s),l(t,V,s),l(t,Y,s),c(d,t,s),l(t,S,s),l(t,J,s),l(t,z,s),c(j,t,s),l(t,F,s),l(t,w,s),l(t,H,s),c(u,t,s),l(t,A,s),l(t,T,s),l(t,L,s),c(f,t,s),l(t,D,s),l(t,b,s),l(t,q,s),c(U,t,s),l(t,P,s),l(t,I,s),l(t,K,s),c(C,t,s),l(t,O,s),l(t,Z,s),l(t,tt,s),l(t,$,s),l(t,st,s),c(v,t,s),l(t,at,s),l(t,B,s),l(t,lt,s),c(k,t,s),l(t,et,s),l(t,W,s),l(t,nt,s),c(x,t,s),l(t,pt,s),l(t,G,s),l(t,it,s),c(N,t,s),l(t,mt,s),c(Q,t,s),l(t,ot,s),l(t,X,s),ct=!0},p:It,i(t){ct||(r(d.$$.fragment,t),r(j.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(C.$$.fragment,t),r(v.$$.fragment,t),r(k.$$.fragment,t),r(x.$$.fragment,t),r(N.$$.fragment,t),r(Q.$$.fragment,t),ct=!0)},o(t){h(d.$$.fragment,t),h(j.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(v.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(N.$$.fragment,t),h(Q.$$.fragment,t),ct=!1},d(t){t&&(a(R),a(V),a(Y),a(S),a(J),a(z),a(F),a(w),a(H),a(A),a(T),a(L),a(D),a(b),a(q),a(P),a(I),a(K),a(O),a(Z),a(tt),a($),a(st),a(at),a(B),a(lt),a(et),a(W),a(nt),a(pt),a(G),a(it),a(mt),a(ot),a(X)),a(y),M(d,t),M(j,t),M(u,t),M(f,t),M(U,t),M(C,t),M(v,t),M(k,t),M(x,t),M(N,t),M(Q,t)}}}const Wt='{"title":"Inception v4","local":"inception-v4","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xt(rt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Zt{constructor(y){super(),$t(this,y,xt,kt,Ut,{})}}export{Vt as component};
