import{s as te,o as ee,n as ne}from"../chunks/scheduler.924d507e.js";import{S as le,i as ae,g as s,s as a,r as f,A as ie,h as o,f as n,c as i,j as Kt,u as m,x as r,k as Ot,y as se,a as l,v as u,d,t as h,w as c}from"../chunks/index.0ece89e8.js";import{T as oe}from"../chunks/Tip.a5ce8f1d.js";import{C as b}from"../chunks/CodeBlock.d01ac312.js";import{H as K}from"../chunks/Heading.c9bff43c.js";function re(tt){let p,y='LoftQ initialization does not require quantizing the base model with the <code>load_in_4bits</code> parameter in the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method! Learn more about LoftQ initialization in the <a href="../developer_guides/lora#initialization">Initialization options</a> section.';return{c(){p=s("p"),p.innerHTML=y},l(M){p=o(M,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1p70fnx"&&(p.innerHTML=y)},m(M,D){l(M,p,D)},p:ne,d(M){M&&n(p)}}}function pe(tt){let p,y,M,D,J,et,w,Zt="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",nt,g,xt='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li>',lt,_,kt='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',at,$,Qt="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",it,j,st,C,Wt='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',ot,q,Rt="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",rt,v,pt,B,At='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',ft,I,mt,U,Et='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for traininng.',ut,L,dt,z,Gt="Now that the quantized model is ready, let’s set up a configuration.",ht,Z,ct,x,Xt='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Mt,k,Tt,Q,Ht='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',bt,W,yt,R,Nt="You’re all set for training with whichever training method you prefer!",Jt,A,wt,E,Ft='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, create a <code>LoftQConfig</code> and set <code>loftq_bits=4</code> for 4-bit quantization.',gt,T,_t,G,$t,X,Yt='Now pass the <code>loftq_config</code> to the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> to enable LoftQ initialization, and create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> for training.',jt,H,Ct,N,qt,F,Vt="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, we provide a convenient flag <code>&#39;all-linear&#39;</code> for this setting:",vt,Y,Bt,V,It,P,Pt="If you’re interested in learning more about quantization, the following may be helpful:",Ut,S,St='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',Lt,O,zt;return J=new K({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),j=new K({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),v=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),I=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),L=new b({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),Z=new K({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),k=new b({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),W=new b({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),A=new K({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),T=new oe({props:{warning:!0,$$slots:{default:[re]},$$scope:{ctx:tt}}}),G=new b({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMExvZnRRQ29uZmlnJTJDJTIwTG9yYUNvbmZpZyUyQyUyMGdldF9wZWZ0X21vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQWxvZnRxX2NvbmZpZyUyMCUzRCUyMExvZnRRQ29uZmlnKGxvZnRxX2JpdHMlM0Q0KQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoModelForCausalLM, LoftQConfig, LoraConfig, get_peft_model

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>)`,wrap:!1}}),H=new b({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIybG9mdHElMjIlMkMlMEElMjAlMjAlMjAlMjBsb2Z0cV9jb25maWclM0Rsb2Z0cV9jb25maWclMkMlMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBsb3JhX2NvbmZpZyk=",highlighted:`lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>,
    loftq_config=loftq_config,
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, lora_config)`,wrap:!1}}),N=new K({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Y=new b({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4pJTIwJTIzJTIwYWRkcyUyMExvUkElMjB0byUyMGFsbCUyMGxpbmVhciUyMGxheWVycyUyMGxpa2UlMjBpbiUyMFFMb1JB",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...) <span class="hljs-comment"># adds LoRA to all linear layers like in QLoRA</span>',wrap:!1}}),V=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){p=s("meta"),y=a(),M=s("p"),D=a(),f(J.$$.fragment),et=a(),w=s("p"),w.textContent=Zt,nt=a(),g=s("ul"),g.innerHTML=xt,lt=a(),_=s("p"),_.innerHTML=kt,at=a(),$=s("p"),$.textContent=Qt,it=a(),f(j.$$.fragment),st=a(),C=s("p"),C.innerHTML=Wt,ot=a(),q=s("ul"),q.innerHTML=Rt,rt=a(),f(v.$$.fragment),pt=a(),B=s("p"),B.innerHTML=At,ft=a(),f(I.$$.fragment),mt=a(),U=s("p"),U.innerHTML=Et,ut=a(),f(L.$$.fragment),dt=a(),z=s("p"),z.textContent=Gt,ht=a(),f(Z.$$.fragment),ct=a(),x=s("p"),x.innerHTML=Xt,Mt=a(),f(k.$$.fragment),Tt=a(),Q=s("p"),Q.innerHTML=Ht,bt=a(),f(W.$$.fragment),yt=a(),R=s("p"),R.textContent=Nt,Jt=a(),f(A.$$.fragment),wt=a(),E=s("p"),E.innerHTML=Ft,gt=a(),f(T.$$.fragment),_t=a(),f(G.$$.fragment),$t=a(),X=s("p"),X.innerHTML=Yt,jt=a(),f(H.$$.fragment),Ct=a(),f(N.$$.fragment),qt=a(),F=s("p"),F.innerHTML=Vt,vt=a(),f(Y.$$.fragment),Bt=a(),f(V.$$.fragment),It=a(),P=s("p"),P.textContent=Pt,Ut=a(),S=s("ul"),S.innerHTML=St,Lt=a(),O=s("p"),this.h()},l(t){const e=ie("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),y=i(t),M=o(t,"P",{}),Kt(M).forEach(n),D=i(t),m(J.$$.fragment,t),et=i(t),w=o(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-famg4s"&&(w.textContent=Zt),nt=i(t),g=o(t,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-10cnhiv"&&(g.innerHTML=xt),lt=i(t),_=o(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-142xot4"&&(_.innerHTML=kt),at=i(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1demhiu"&&($.textContent=Qt),it=i(t),m(j.$$.fragment,t),st=i(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-p0gbf4"&&(C.innerHTML=Wt),ot=i(t),q=o(t,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-hfynw8"&&(q.innerHTML=Rt),rt=i(t),m(v.$$.fragment,t),pt=i(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-pxonbi"&&(B.innerHTML=At),ft=i(t),m(I.$$.fragment,t),mt=i(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1v2z8y6"&&(U.innerHTML=Et),ut=i(t),m(L.$$.fragment,t),dt=i(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11mx7fc"&&(z.textContent=Gt),ht=i(t),m(Z.$$.fragment,t),ct=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-16xpk8c"&&(x.innerHTML=Xt),Mt=i(t),m(k.$$.fragment,t),Tt=i(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rnh6oi"&&(Q.innerHTML=Ht),bt=i(t),m(W.$$.fragment,t),yt=i(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-xd402n"&&(R.textContent=Nt),Jt=i(t),m(A.$$.fragment,t),wt=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-g845ls"&&(E.innerHTML=Ft),gt=i(t),m(T.$$.fragment,t),_t=i(t),m(G.$$.fragment,t),$t=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-5zbxqc"&&(X.innerHTML=Yt),jt=i(t),m(H.$$.fragment,t),Ct=i(t),m(N.$$.fragment,t),qt=i(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-skv1xp"&&(F.innerHTML=Vt),vt=i(t),m(Y.$$.fragment,t),Bt=i(t),m(V.$$.fragment,t),It=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-agdyn7"&&(P.textContent=Pt),Ut=i(t),S=o(t,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-83nivc"&&(S.innerHTML=St),Lt=i(t),O=o(t,"P",{}),Kt(O).forEach(n),this.h()},h(){Ot(p,"name","hf:doc:metadata"),Ot(p,"content",fe)},m(t,e){se(document.head,p),l(t,y,e),l(t,M,e),l(t,D,e),u(J,t,e),l(t,et,e),l(t,w,e),l(t,nt,e),l(t,g,e),l(t,lt,e),l(t,_,e),l(t,at,e),l(t,$,e),l(t,it,e),u(j,t,e),l(t,st,e),l(t,C,e),l(t,ot,e),l(t,q,e),l(t,rt,e),u(v,t,e),l(t,pt,e),l(t,B,e),l(t,ft,e),u(I,t,e),l(t,mt,e),l(t,U,e),l(t,ut,e),u(L,t,e),l(t,dt,e),l(t,z,e),l(t,ht,e),u(Z,t,e),l(t,ct,e),l(t,x,e),l(t,Mt,e),u(k,t,e),l(t,Tt,e),l(t,Q,e),l(t,bt,e),u(W,t,e),l(t,yt,e),l(t,R,e),l(t,Jt,e),u(A,t,e),l(t,wt,e),l(t,E,e),l(t,gt,e),u(T,t,e),l(t,_t,e),u(G,t,e),l(t,$t,e),l(t,X,e),l(t,jt,e),u(H,t,e),l(t,Ct,e),u(N,t,e),l(t,qt,e),l(t,F,e),l(t,vt,e),u(Y,t,e),l(t,Bt,e),u(V,t,e),l(t,It,e),l(t,P,e),l(t,Ut,e),l(t,S,e),l(t,Lt,e),l(t,O,e),zt=!0},p(t,[e]){const Dt={};e&2&&(Dt.$$scope={dirty:e,ctx:t}),T.$set(Dt)},i(t){zt||(d(J.$$.fragment,t),d(j.$$.fragment,t),d(v.$$.fragment,t),d(I.$$.fragment,t),d(L.$$.fragment,t),d(Z.$$.fragment,t),d(k.$$.fragment,t),d(W.$$.fragment,t),d(A.$$.fragment,t),d(T.$$.fragment,t),d(G.$$.fragment,t),d(H.$$.fragment,t),d(N.$$.fragment,t),d(Y.$$.fragment,t),d(V.$$.fragment,t),zt=!0)},o(t){h(J.$$.fragment,t),h(j.$$.fragment,t),h(v.$$.fragment,t),h(I.$$.fragment,t),h(L.$$.fragment,t),h(Z.$$.fragment,t),h(k.$$.fragment,t),h(W.$$.fragment,t),h(A.$$.fragment,t),h(T.$$.fragment,t),h(G.$$.fragment,t),h(H.$$.fragment,t),h(N.$$.fragment,t),h(Y.$$.fragment,t),h(V.$$.fragment,t),zt=!1},d(t){t&&(n(y),n(M),n(D),n(et),n(w),n(nt),n(g),n(lt),n(_),n(at),n($),n(it),n(st),n(C),n(ot),n(q),n(rt),n(pt),n(B),n(ft),n(mt),n(U),n(ut),n(dt),n(z),n(ht),n(ct),n(x),n(Mt),n(Tt),n(Q),n(bt),n(yt),n(R),n(Jt),n(wt),n(E),n(gt),n(_t),n($t),n(X),n(jt),n(Ct),n(qt),n(F),n(vt),n(Bt),n(It),n(P),n(Ut),n(S),n(Lt),n(O)),n(p),c(J,t),c(j,t),c(v,t),c(I,t),c(L,t),c(Z,t),c(k,t),c(W,t),c(A,t),c(T,t),c(G,t),c(H,t),c(N,t),c(Y,t),c(V,t)}}}const fe='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function me(tt){return ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends le{constructor(p){super(),ae(this,p,me,pe,te,{})}}export{Te as component};
