import{s as kt,f as Rt,o as Zt,n as Ce}from"../chunks/scheduler.9bc65507.js";import{S as Wt,i as Bt,g as d,s as r,r as h,A as Dt,h as c,f as o,c as i,j as I,u as g,x as v,k as M,y as p,a,v as f,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as bt}from"../chunks/Tip.c2ecdbf4.js";import{D as z}from"../chunks/Docstring.17db21ae.js";import{C as wt}from"../chunks/CodeBlock.54a9f38d.js";import{E as yt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as V}from"../chunks/Heading.342b1fa6.js";function Ht($){let n,y=`This is a recently introduced model so the API hasn’t been tested extensively. There may be some bugs or slight
breaking changes to fix it in the future. If you see something strange, file a <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=&amp;template=bug-report.md&amp;title" rel="nofollow">Github Issue</a>.`;return{c(){n=d("p"),n.innerHTML=y},l(l){n=c(l,"P",{"data-svelte-h":!0}),v(n)!=="svelte-j665pk"&&(n.innerHTML=y)},m(l,m){a(l,n,m)},p:Ce,d(l){l&&o(n)}}}function St($){let n,y="Example:",l,m,w;return m=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdMUE5Nb2RlbCUyQyUyMEdMUE5Db25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR0xQTiUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwR0xQTkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GLPNModel, GLPNConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a GLPN vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GLPNConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the vinvino02/glpn-kitti style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,l=r(),h(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),v(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),g(m.$$.fragment,s)},m(s,T){a(s,n,T),a(s,l,T),f(m,s,T),w=!0},p:Ce,i(s){w||(u(m.$$.fragment,s),w=!0)},o(s){_(m.$$.fragment,s),w=!1},d(s){s&&(o(n),o(l)),b(m,s)}}}function Xt($){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=y},l(l){n=c(l,"P",{"data-svelte-h":!0}),v(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(l,m){a(l,n,m)},p:Ce,d(l){l&&o(n)}}}function Vt($){let n,y="Example:",l,m,w;return m=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGVzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNModel.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">15</span>, <span class="hljs-number">20</span>]`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,l=r(),h(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),v(n)!=="svelte-11lpom8"&&(n.textContent=y),l=i(s),g(m.$$.fragment,s)},m(s,T){a(s,n,T),a(s,l,T),f(m,s,T),w=!0},p:Ce,i(s){w||(u(m.$$.fragment,s),w=!0)},o(s){_(m.$$.fragment,s),w=!1},d(s){s&&(o(n),o(l)),b(m,s)}}}function qt($){let n,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=d("p"),n.innerHTML=y},l(l){n=c(l,"P",{"data-svelte-h":!0}),v(n)!=="svelte-fincs2"&&(n.innerHTML=y)},m(l,m){a(l,n,m)},p:Ce,d(l){l&&o(n)}}}function At($){let n,y="Examples:",l,m,w;return m=new wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydmludmlubzAyJTJGZ2xwbi1raXR0aSUyMiklMEFtb2RlbCUyMCUzRCUyMEdMUE5Gb3JEZXB0aEVzdGltYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnZpbnZpbm8wMiUyRmdscG4ta2l0dGklMjIpJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGltYWdlJTIwZm9yJTIwdGhlJTIwbW9kZWwlMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0ZWRfZGVwdGglMEElMEElMjMlMjBpbnRlcnBvbGF0ZSUyMHRvJTIwb3JpZ2luYWwlMjBzaXplJTBBcHJlZGljdGlvbiUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuaW50ZXJwb2xhdGUoJTBBJTIwJTIwJTIwJTIwcHJlZGljdGVkX2RlcHRoLnVuc3F1ZWV6ZSgxKSUyQyUwQSUyMCUyMCUyMCUyMHNpemUlM0RpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIyYmljdWJpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFsaWduX2Nvcm5lcnMlM0RGYWxzZSUyQyUwQSklMEElMEElMjMlMjB2aXN1YWxpemUlMjB0aGUlMjBwcmVkaWN0aW9uJTBBb3V0cHV0JTIwJTNEJTIwcHJlZGljdGlvbi5zcXVlZXplKCkuY3B1KCkubnVtcHkoKSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, GLPNForDepthEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GLPNForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;vinvino02/glpn-kitti&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare image for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># visualize the prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.squeeze().cpu().numpy()
<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)`,wrap:!1}}),{c(){n=d("p"),n.textContent=y,l=r(),h(m.$$.fragment)},l(s){n=c(s,"P",{"data-svelte-h":!0}),v(n)!=="svelte-kvfsh7"&&(n.textContent=y),l=i(s),g(m.$$.fragment,s)},m(s,T){a(s,n,T),a(s,l,T),f(m,s,T),w=!0},p:Ce,i(s){w||(u(m.$$.fragment,s),w=!0)},o(s){_(m.$$.fragment,s),w=!1},d(s){s&&(o(n),o(l)),b(m,s)}}}function Qt($){let n,y,l,m,w,s,T,Ie,q,Ue,A,vt=`The GLPN model was proposed in <a href="https://arxiv.org/abs/2201.07436" rel="nofollow">Global-Local Path Networks for Monocular Depth Estimation with Vertical CutDepth</a>  by Doyeon Kim, Woonghyun Ga, Pyungwhan Ahn, Donggyu Joo, Sehwan Chun, Junmo Kim.
GLPN combines <a href="segformer">SegFormer</a>’s hierarchical mix-Transformer with a lightweight decoder for monocular depth estimation. The proposed decoder shows better performance than the previously proposed decoders, with considerably
less computational complexity.`,Je,Q,Tt="The abstract from the paper is the following:",Ee,Y,$t="<em>Depth estimation from a single image is an important task that can be applied to various fields in computer vision, and has grown rapidly with the development of convolutional neural networks. In this paper, we propose a novel structure and training strategy for monocular depth estimation to further improve the prediction accuracy of the network. We deploy a hierarchical transformer encoder to capture and convey the global context, and design a lightweight yet powerful decoder to generate an estimated depth map while considering local connectivity. By constructing connected paths between multi-scale local features and the global decoding stream with our proposed selective feature fusion module, the network can integrate both representations and recover fine details. In addition, the proposed decoder shows better performance than the previously proposed decoders, with considerably less computational complexity. Furthermore, we improve the depth-specific augmentation method by utilizing an important observation in depth estimation to enhance the model. Our network achieves state-of-the-art performance over the challenging depth dataset NYU Depth V2. Extensive experiments have been conducted to validate and show the effectiveness of the proposed approach. Finally, our model shows better generalisation ability and robustness than other comparative models.</em>",ze,F,Mt,Fe,O,Pt='Summary of the approach. Taken from the <a href="https://arxiv.org/abs/2201.07436" target="_blank">original paper</a>.',ke,K,Nt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/vinvino02/GLPDepth" rel="nofollow">here</a>.',Re,ee,Ze,te,Gt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with GLPN.",We,oe,Lt='<li>Demo notebooks for <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/GLPN" rel="nofollow">here</a>.</li> <li><a href="../tasks/monocular_depth_estimation">Monocular depth estimation task guide</a></li>',Be,ne,De,P,se,et,we,xt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a>. It is used to instantiate an GLPN
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the GLPN
<a href="https://huggingface.co/vinvino02/glpn-kitti" rel="nofollow">vinvino02/glpn-kitti</a> architecture.`,tt,ve,Ct=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ot,k,He,ae,Se,U,re,nt,R,ie,st,Te,jt="Preprocess an image or a batch of images.",Xe,le,Ve,L,de,at,$e,It="Constructs a GLPN image processor.",rt,Z,ce,it,Me,Ut="Preprocess the given images.",qe,me,Ae,x,pe,lt,Pe,Jt=`The bare GLPN encoder (Mix-Transformer) outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,dt,N,he,ct,Ne,Et='The <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNModel">GLPNModel</a> forward method, overrides the <code>__call__</code> special method.',mt,W,pt,B,Qe,ge,Ye,C,fe,ht,Ge,zt=`GLPN Model transformer with a lightweight depth estimation head on top e.g. for KITTI, NYUv2.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,gt,G,ue,ft,Le,Ft='The <a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNForDepthEstimation">GLPNForDepthEstimation</a> forward method, overrides the <code>__call__</code> special method.',ut,D,_t,H,Oe,je,Ke;return w=new V({props:{title:"GLPN",local:"glpn",headingTag:"h1"}}),T=new bt({props:{$$slots:{default:[Ht]},$$scope:{ctx:$}}}),q=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ne=new V({props:{title:"GLPNConfig",local:"transformers.GLPNConfig",headingTag:"h2"}}),se=new z({props:{name:"class transformers.GLPNConfig",anchor:"transformers.GLPNConfig",parameters:[{name:"num_channels",val:" = 3"},{name:"num_encoder_blocks",val:" = 4"},{name:"depths",val:" = [2, 2, 2, 2]"},{name:"sr_ratios",val:" = [8, 4, 2, 1]"},{name:"hidden_sizes",val:" = [32, 64, 160, 256]"},{name:"patch_sizes",val:" = [7, 3, 3, 3]"},{name:"strides",val:" = [4, 2, 2, 2]"},{name:"num_attention_heads",val:" = [1, 2, 5, 8]"},{name:"mlp_ratios",val:" = [4, 4, 4, 4]"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"drop_path_rate",val:" = 0.1"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"decoder_hidden_size",val:" = 64"},{name:"max_depth",val:" = 10"},{name:"head_in_index",val:" = -1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.GLPNConfig.num_encoder_blocks",description:`<strong>num_encoder_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of encoder blocks (i.e. stages in the Mix Transformer encoder).`,name:"num_encoder_blocks"},{anchor:"transformers.GLPNConfig.depths",description:`<strong>depths</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[2, 2, 2, 2]</code>) &#x2014;
The number of layers in each encoder block.`,name:"depths"},{anchor:"transformers.GLPNConfig.sr_ratios",description:`<strong>sr_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[8, 4, 2, 1]</code>) &#x2014;
Sequence reduction ratios in each encoder block.`,name:"sr_ratios"},{anchor:"transformers.GLPNConfig.hidden_sizes",description:`<strong>hidden_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 160, 256]</code>) &#x2014;
Dimension of each of the encoder blocks.`,name:"hidden_sizes"},{anchor:"transformers.GLPNConfig.patch_sizes",description:`<strong>patch_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[7, 3, 3, 3]</code>) &#x2014;
Patch size before each encoder block.`,name:"patch_sizes"},{anchor:"transformers.GLPNConfig.strides",description:`<strong>strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 2, 2, 2]</code>) &#x2014;
Stride before each encoder block.`,name:"strides"},{anchor:"transformers.GLPNConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 5, 8]</code>) &#x2014;
Number of attention heads for each attention layer in each block of the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.GLPNConfig.mlp_ratios",description:`<strong>mlp_ratios</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 4, 4, 4]</code>) &#x2014;
Ratio of the size of the hidden layer compared to the size of the input layer of the Mix FFNs in the
encoder blocks.`,name:"mlp_ratios"},{anchor:"transformers.GLPNConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.GLPNConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.GLPNConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.GLPNConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.GLPNConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for stochastic depth, used in the blocks of the Transformer encoder.`,name:"drop_path_rate"},{anchor:"transformers.GLPNConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.GLPNConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
The dimension of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.GLPNConfig.max_depth",description:`<strong>max_depth</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
The maximum depth of the decoder.`,name:"max_depth"},{anchor:"transformers.GLPNConfig.head_in_index",description:`<strong>head_in_index</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the features to use in the head.`,name:"head_in_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/configuration_glpn.py#L29"}}),k=new yt({props:{anchor:"transformers.GLPNConfig.example",$$slots:{default:[St]},$$scope:{ctx:$}}}),ae=new V({props:{title:"GLPNFeatureExtractor",local:"transformers.GLPNFeatureExtractor",headingTag:"h2"}}),re=new z({props:{name:"class transformers.GLPNFeatureExtractor",anchor:"transformers.GLPNFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/feature_extraction_glpn.py#L26"}}),ie=new z({props:{name:"__call__",anchor:"transformers.GLPNFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L547"}}),le=new V({props:{title:"GLPNImageProcessor",local:"transformers.GLPNImageProcessor",headingTag:"h2"}}),de=new z({props:{name:"class transformers.GLPNImageProcessor",anchor:"transformers.GLPNImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:" = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions, rounding them down to the closest multiple of
<code>size_divisor</code>. Can be overridden by <code>do_resize</code> in <code>preprocess</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the closest
multiple of <code>size_divisor</code>. Can be overridden by <code>size_divisor</code> in <code>preprocess</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in <code>preprocess</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.). Can be
overridden by <code>do_rescale</code> in <code>preprocess</code>.`,name:"do_rescale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/image_processing_glpn.py#L40"}}),ce=new z({props:{name:"preprocess",anchor:"transformers.GLPNImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), transformers.utils.generic.TensorType, typing.List[ForwardRef('PIL.Image.Image')], typing.List[transformers.utils.generic.TensorType]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GLPNImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code> or <code>TensorType</code> or <code>List[np.ndarray]</code> or <code>List[TensorType]</code>) &#x2014;
Images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_normalize=False</code>.`,name:"images"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the input such that the (height, width) dimensions are a multiple of <code>size_divisor</code>.`,name:"do_resize"},{anchor:"transformers.GLPNImageProcessor.preprocess.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.size_divisor</code>) &#x2014;
When <code>do_resize</code> is <code>True</code>, images are resized so their height and width are rounded down to the
closest multiple of <code>size_divisor</code>.`,name:"size_divisor"},{anchor:"transformers.GLPNImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PIL.Image</code> resampling filter, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
<code>PIL.Image</code> resampling filter to use if resizing the image e.g. <code>PILImageResampling.BILINEAR</code>. Only has
an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GLPNImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.GLPNImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li><code>None</code>: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.GLPNImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GLPNImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/image_processing_glpn.py#L124"}}),me=new V({props:{title:"GLPNModel",local:"transformers.GLPNModel",headingTag:"h2"}}),pe=new z({props:{name:"class transformers.GLPNModel",anchor:"transformers.GLPNModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L483"}}),he=new z({props:{name:"forward",anchor:"transformers.GLPNModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L503",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),W=new bt({props:{$$slots:{default:[Xt]},$$scope:{ctx:$}}}),B=new yt({props:{anchor:"transformers.GLPNModel.forward.example",$$slots:{default:[Vt]},$$scope:{ctx:$}}}),ge=new V({props:{title:"GLPNForDepthEstimation",local:"transformers.GLPNForDepthEstimation",headingTag:"h2"}}),fe=new z({props:{name:"class transformers.GLPNForDepthEstimation",anchor:"transformers.GLPNForDepthEstimation",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig">GLPNConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L684"}}),ue=new z({props:{name:"forward",anchor:"transformers.GLPNForDepthEstimation.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.GLPNForDepthEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">GLPNImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GLPNForDepthEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GLPNForDepthEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GLPNForDepthEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth depth estimation maps for computing the loss.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/glpn/modeling_glpn.py#L695",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/glpn#transformers.GLPNConfig"
>GLPNConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>predicted_depth</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, height, width)</code>) — Predicted depth for each pixel.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, num_channels, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.DepthEstimatorOutput"
>transformers.modeling_outputs.DepthEstimatorOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new bt({props:{$$slots:{default:[qt]},$$scope:{ctx:$}}}),H=new yt({props:{anchor:"transformers.GLPNForDepthEstimation.forward.example",$$slots:{default:[At]},$$scope:{ctx:$}}}),{c(){n=d("meta"),y=r(),l=d("p"),m=r(),h(w.$$.fragment),s=r(),h(T.$$.fragment),Ie=r(),h(q.$$.fragment),Ue=r(),A=d("p"),A.innerHTML=vt,Je=r(),Q=d("p"),Q.textContent=Tt,Ee=r(),Y=d("p"),Y.innerHTML=$t,ze=r(),F=d("img"),Fe=r(),O=d("small"),O.innerHTML=Pt,ke=r(),K=d("p"),K.innerHTML=Nt,Re=r(),h(ee.$$.fragment),Ze=r(),te=d("p"),te.textContent=Gt,We=r(),oe=d("ul"),oe.innerHTML=Lt,Be=r(),h(ne.$$.fragment),De=r(),P=d("div"),h(se.$$.fragment),et=r(),we=d("p"),we.innerHTML=xt,tt=r(),ve=d("p"),ve.innerHTML=Ct,ot=r(),h(k.$$.fragment),He=r(),h(ae.$$.fragment),Se=r(),U=d("div"),h(re.$$.fragment),nt=r(),R=d("div"),h(ie.$$.fragment),st=r(),Te=d("p"),Te.textContent=jt,Xe=r(),h(le.$$.fragment),Ve=r(),L=d("div"),h(de.$$.fragment),at=r(),$e=d("p"),$e.textContent=It,rt=r(),Z=d("div"),h(ce.$$.fragment),it=r(),Me=d("p"),Me.textContent=Ut,qe=r(),h(me.$$.fragment),Ae=r(),x=d("div"),h(pe.$$.fragment),lt=r(),Pe=d("p"),Pe.innerHTML=Jt,dt=r(),N=d("div"),h(he.$$.fragment),ct=r(),Ne=d("p"),Ne.innerHTML=Et,mt=r(),h(W.$$.fragment),pt=r(),h(B.$$.fragment),Qe=r(),h(ge.$$.fragment),Ye=r(),C=d("div"),h(fe.$$.fragment),ht=r(),Ge=d("p"),Ge.innerHTML=zt,gt=r(),G=d("div"),h(ue.$$.fragment),ft=r(),Le=d("p"),Le.innerHTML=Ft,ut=r(),h(D.$$.fragment),_t=r(),h(H.$$.fragment),Oe=r(),je=d("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);n=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=i(e),l=c(e,"P",{}),I(l).forEach(o),m=i(e),g(w.$$.fragment,e),s=i(e),g(T.$$.fragment,e),Ie=i(e),g(q.$$.fragment,e),Ue=i(e),A=c(e,"P",{"data-svelte-h":!0}),v(A)!=="svelte-1rdmycr"&&(A.innerHTML=vt),Je=i(e),Q=c(e,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-vfdo9a"&&(Q.textContent=Tt),Ee=i(e),Y=c(e,"P",{"data-svelte-h":!0}),v(Y)!=="svelte-l8ay4x"&&(Y.innerHTML=$t),ze=i(e),F=c(e,"IMG",{src:!0,alt:!0,width:!0}),Fe=i(e),O=c(e,"SMALL",{"data-svelte-h":!0}),v(O)!=="svelte-bacs7t"&&(O.innerHTML=Pt),ke=i(e),K=c(e,"P",{"data-svelte-h":!0}),v(K)!=="svelte-1grdklu"&&(K.innerHTML=Nt),Re=i(e),g(ee.$$.fragment,e),Ze=i(e),te=c(e,"P",{"data-svelte-h":!0}),v(te)!=="svelte-fq64ti"&&(te.textContent=Gt),We=i(e),oe=c(e,"UL",{"data-svelte-h":!0}),v(oe)!=="svelte-pb93f4"&&(oe.innerHTML=Lt),Be=i(e),g(ne.$$.fragment,e),De=i(e),P=c(e,"DIV",{class:!0});var j=I(P);g(se.$$.fragment,j),et=i(j),we=c(j,"P",{"data-svelte-h":!0}),v(we)!=="svelte-qzaip8"&&(we.innerHTML=xt),tt=i(j),ve=c(j,"P",{"data-svelte-h":!0}),v(ve)!=="svelte-o55m63"&&(ve.innerHTML=Ct),ot=i(j),g(k.$$.fragment,j),j.forEach(o),He=i(e),g(ae.$$.fragment,e),Se=i(e),U=c(e,"DIV",{class:!0});var _e=I(U);g(re.$$.fragment,_e),nt=i(_e),R=c(_e,"DIV",{class:!0});var be=I(R);g(ie.$$.fragment,be),st=i(be),Te=c(be,"P",{"data-svelte-h":!0}),v(Te)!=="svelte-khengj"&&(Te.textContent=jt),be.forEach(o),_e.forEach(o),Xe=i(e),g(le.$$.fragment,e),Ve=i(e),L=c(e,"DIV",{class:!0});var J=I(L);g(de.$$.fragment,J),at=i(J),$e=c(J,"P",{"data-svelte-h":!0}),v($e)!=="svelte-1e6g6g5"&&($e.textContent=It),rt=i(J),Z=c(J,"DIV",{class:!0});var ye=I(Z);g(ce.$$.fragment,ye),it=i(ye),Me=c(ye,"P",{"data-svelte-h":!0}),v(Me)!=="svelte-tvrlms"&&(Me.textContent=Ut),ye.forEach(o),J.forEach(o),qe=i(e),g(me.$$.fragment,e),Ae=i(e),x=c(e,"DIV",{class:!0});var E=I(x);g(pe.$$.fragment,E),lt=i(E),Pe=c(E,"P",{"data-svelte-h":!0}),v(Pe)!=="svelte-dvd88g"&&(Pe.innerHTML=Jt),dt=i(E),N=c(E,"DIV",{class:!0});var S=I(N);g(he.$$.fragment,S),ct=i(S),Ne=c(S,"P",{"data-svelte-h":!0}),v(Ne)!=="svelte-1brtns"&&(Ne.innerHTML=Et),mt=i(S),g(W.$$.fragment,S),pt=i(S),g(B.$$.fragment,S),S.forEach(o),E.forEach(o),Qe=i(e),g(ge.$$.fragment,e),Ye=i(e),C=c(e,"DIV",{class:!0});var xe=I(C);g(fe.$$.fragment,xe),ht=i(xe),Ge=c(xe,"P",{"data-svelte-h":!0}),v(Ge)!=="svelte-1ec4khr"&&(Ge.innerHTML=zt),gt=i(xe),G=c(xe,"DIV",{class:!0});var X=I(G);g(ue.$$.fragment,X),ft=i(X),Le=c(X,"P",{"data-svelte-h":!0}),v(Le)!=="svelte-1vek7n8"&&(Le.innerHTML=Ft),ut=i(X),g(D.$$.fragment,X),_t=i(X),g(H.$$.fragment,X),X.forEach(o),xe.forEach(o),Oe=i(e),je=c(e,"P",{}),I(je).forEach(o),this.h()},h(){M(n,"name","hf:doc:metadata"),M(n,"content",Yt),Rt(F.src,Mt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/glpn_architecture.jpg")||M(F,"src",Mt),M(F,"alt","drawing"),M(F,"width","600"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,n),a(e,y,t),a(e,l,t),a(e,m,t),f(w,e,t),a(e,s,t),f(T,e,t),a(e,Ie,t),f(q,e,t),a(e,Ue,t),a(e,A,t),a(e,Je,t),a(e,Q,t),a(e,Ee,t),a(e,Y,t),a(e,ze,t),a(e,F,t),a(e,Fe,t),a(e,O,t),a(e,ke,t),a(e,K,t),a(e,Re,t),f(ee,e,t),a(e,Ze,t),a(e,te,t),a(e,We,t),a(e,oe,t),a(e,Be,t),f(ne,e,t),a(e,De,t),a(e,P,t),f(se,P,null),p(P,et),p(P,we),p(P,tt),p(P,ve),p(P,ot),f(k,P,null),a(e,He,t),f(ae,e,t),a(e,Se,t),a(e,U,t),f(re,U,null),p(U,nt),p(U,R),f(ie,R,null),p(R,st),p(R,Te),a(e,Xe,t),f(le,e,t),a(e,Ve,t),a(e,L,t),f(de,L,null),p(L,at),p(L,$e),p(L,rt),p(L,Z),f(ce,Z,null),p(Z,it),p(Z,Me),a(e,qe,t),f(me,e,t),a(e,Ae,t),a(e,x,t),f(pe,x,null),p(x,lt),p(x,Pe),p(x,dt),p(x,N),f(he,N,null),p(N,ct),p(N,Ne),p(N,mt),f(W,N,null),p(N,pt),f(B,N,null),a(e,Qe,t),f(ge,e,t),a(e,Ye,t),a(e,C,t),f(fe,C,null),p(C,ht),p(C,Ge),p(C,gt),p(C,G),f(ue,G,null),p(G,ft),p(G,Le),p(G,ut),f(D,G,null),p(G,_t),f(H,G,null),a(e,Oe,t),a(e,je,t),Ke=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),T.$set(j);const _e={};t&2&&(_e.$$scope={dirty:t,ctx:e}),k.$set(_e);const be={};t&2&&(be.$$scope={dirty:t,ctx:e}),W.$set(be);const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),B.$set(J);const ye={};t&2&&(ye.$$scope={dirty:t,ctx:e}),D.$set(ye);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),H.$set(E)},i(e){Ke||(u(w.$$.fragment,e),u(T.$$.fragment,e),u(q.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(se.$$.fragment,e),u(k.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(D.$$.fragment,e),u(H.$$.fragment,e),Ke=!0)},o(e){_(w.$$.fragment,e),_(T.$$.fragment,e),_(q.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(se.$$.fragment,e),_(k.$$.fragment,e),_(ae.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(W.$$.fragment,e),_(B.$$.fragment,e),_(ge.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(D.$$.fragment,e),_(H.$$.fragment,e),Ke=!1},d(e){e&&(o(y),o(l),o(m),o(s),o(Ie),o(Ue),o(A),o(Je),o(Q),o(Ee),o(Y),o(ze),o(F),o(Fe),o(O),o(ke),o(K),o(Re),o(Ze),o(te),o(We),o(oe),o(Be),o(De),o(P),o(He),o(Se),o(U),o(Xe),o(Ve),o(L),o(qe),o(Ae),o(x),o(Qe),o(Ye),o(C),o(Oe),o(je)),o(n),b(w,e),b(T,e),b(q,e),b(ee,e),b(ne,e),b(se),b(k),b(ae,e),b(re),b(ie),b(le,e),b(de),b(ce),b(me,e),b(pe),b(he),b(W),b(B),b(ge,e),b(fe),b(ue),b(D),b(H)}}}const Yt='{"title":"GLPN","local":"glpn","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GLPNConfig","local":"transformers.GLPNConfig","sections":[],"depth":2},{"title":"GLPNFeatureExtractor","local":"transformers.GLPNFeatureExtractor","sections":[],"depth":2},{"title":"GLPNImageProcessor","local":"transformers.GLPNImageProcessor","sections":[],"depth":2},{"title":"GLPNModel","local":"transformers.GLPNModel","sections":[],"depth":2},{"title":"GLPNForDepthEstimation","local":"transformers.GLPNForDepthEstimation","sections":[],"depth":2}],"depth":1}';function Ot($){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ro extends Wt{constructor(n){super(),Bt(this,n,Ot,Qt,kt,{})}}export{ro as component};
