import{s as yn,f as _n,o as Tn,n as ho}from"../chunks/scheduler.9bc65507.js";import{S as vn,i as Fn,g as a,s as r,r as m,A as wn,h as i,f as o,c as s,j as w,u as p,x as _,k as T,y as n,a as l,v as g,d as f,t as h,w as u}from"../chunks/index.707bf1b6.js";import{T as bn}from"../chunks/Tip.c2ecdbf4.js";import{D as k}from"../chunks/Docstring.17db21ae.js";import{C as Pt}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ct}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as L}from"../chunks/Heading.342b1fa6.js";function Mn($){let c,M="Examples:",b,y,v;return y=new Pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9uZUZvcm1lckNvbmZpZyUyQyUyME9uZUZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9uZUZvcm1lciUyMHNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME9uZUZvcm1lckNvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPbmVGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerConfig, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OneFormer shi-labs/oneformer_ade20k_swin_tiny configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OneFormerConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the shi-labs/oneformer_ade20k_swin_tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=a("p"),c.textContent=M,b=r(),m(y.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=M),b=s(d),p(y.$$.fragment,d)},m(d,x){l(d,c,x),l(d,b,x),g(y,d,x),v=!0},p:ho,i(d){v||(f(y.$$.fragment,d),v=!0)},o(d){h(y.$$.fragment,d),v=!1},d(d){d&&(o(c),o(b)),u(y,d)}}}function xn($){let c,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=M},l(b){c=i(b,"P",{"data-svelte-h":!0}),_(c)!=="svelte-fincs2"&&(c.innerHTML=M)},m(b,y){l(b,c,y)},p:ho,d(b){b&&o(c)}}}function On($){let c,M="Example:",b,y,v;return y=new Pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBPbmVGb3JtZXJQcm9jZXNzb3IlMkMlMjBPbmVGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMGRvd25sb2FkJTIwdGV4dGluZyUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBwcm9jZXNzb3IlMjBmb3IlMjBwcmVwcm9jZXNzaW5nJTIwdGhlJTIwaW5wdXRzJTBBcHJvY2Vzc29yJTIwJTNEJTIwT25lRm9ybWVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwT25lRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwJTVCJTIyc2VtYW50aWMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza19wcmVkaWN0aW9ucyUyMCUzRCUyMG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9tYXNrX3ByZWRpY3Rpb25zJTBBY2xhc3NfcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLnRyYW5zZm9ybWVyX2RlY29kZXJfY2xhc3NfcHJlZGljdGlvbnMlMEElMEFmJTIyJUYwJTlGJTkxJTg5JTIwTWFzayUyMFByZWRpY3Rpb25zJTIwU2hhcGUlM0ElMjAlN0JsaXN0KG1hc2tfcHJlZGljdGlvbnMuc2hhcGUpJTdEJTJDJTIwQ2xhc3MlMjBQcmVkaWN0aW9ucyUyMFNoYXBlJTNBJTIwJTdCbGlzdChjbGFzc19wcmVkaWN0aW9ucy5zaGFwZSklN0QlMjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download texting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load processor for preprocessing the inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_predictions = outputs.transformer_decoder_mask_predictions
<span class="hljs-meta">&gt;&gt;&gt; </span>class_predictions = outputs.transformer_decoder_class_predictions

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Mask Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(mask_predictions.shape)}</span>, Class Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(class_predictions.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Mask Predictions Shape: [1, 150, 128, 171], Class Predictions Shape: [1, 150, 151]&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=M,b=r(),m(y.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=M),b=s(d),p(y.$$.fragment,d)},m(d,x){l(d,c,x),l(d,b,x),g(y,d,x),v=!0},p:ho,i(d){v||(f(y.$$.fragment,d),v=!0)},o(d){h(y.$$.fragment,d),v=!1},d(d){d&&(o(c),o(b)),u(y,d)}}}function kn($){let c,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=M},l(b){c=i(b,"P",{"data-svelte-h":!0}),_(c)!=="svelte-fincs2"&&(c.innerHTML=M)},m(b,y){l(b,c,y)},p:ho,d(b){b&&o(c)}}}function jn($){let c,M="Universal segmentation example:",b,y,v;return y=new Pt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load OneFormer fine-tuned on ADE20k for universal segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Semantic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for semantic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Semantic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_semantic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Semantic Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Instance Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for instance postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_instance_map = processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Instance Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_instance_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Instance Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Panoptic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for panoptic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Panoptic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Panoptic Predictions Shape: [512, 683]&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=M,b=r(),m(y.$$.fragment)},l(d){c=i(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-9x0o9r"&&(c.textContent=M),b=s(d),p(y.$$.fragment,d)},m(d,x){l(d,c,x),l(d,b,x),g(y,d,x),v=!0},p:ho,i(d){v||(f(y.$$.fragment,d),v=!0)},o(d){h(y.$$.fragment,d),v=!1},d(d){d&&(o(c),o(b)),u(y,d)}}}function In($){let c,M,b,y,v,d,x,uo,te,qt='The OneFormer model was proposed in <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">OneFormer: One Transformer to Rule Universal Image Segmentation</a> by Jitesh Jain, Jiachen Li, MangTik Chiu, Ali Hassani, Nikita Orlov, Humphrey Shi. OneFormer is a universal image segmentation framework that can be trained on a single panoptic dataset to perform semantic, instance, and panoptic segmentation tasks. OneFormer uses a task token to condition the model on the task in focus, making the architecture task-guided for training, and task-dynamic for inference.',_o,ne,Wt,bo,re,Zt="The abstract from the paper is the following:",yo,se,Lt="<em>Universal Image Segmentation is not a new concept. Past attempts to unify image segmentation in the last decades include scene parsing, panoptic segmentation, and, more recently, new panoptic architectures. However, such panoptic architectures do not truly unify image segmentation because they need to be trained individually on the semantic, instance, or panoptic segmentation to achieve the best performance. Ideally, a truly universal framework should be trained only once and achieve SOTA performance across all three image segmentation tasks. To that end, we propose OneFormer, a universal image segmentation framework that unifies segmentation with a multi-task train-once design. We first propose a task-conditioned joint training strategy that enables training on ground truths of each domain (semantic, instance, and panoptic segmentation) within a single multi-task training process. Secondly, we introduce a task token to condition our model on the task at hand, making our model task-dynamic to support multi-task training and inference. Thirdly, we propose using a query-text contrastive loss during training to establish better inter-task and inter-class distinctions. Notably, our single OneFormer model outperforms specialized Mask2Former models across all three segmentation tasks on ADE20k, CityScapes, and COCO, despite the latter being trained on each of the three tasks individually with three times the resources. With new ConvNeXt and DiNAT backbones, we observe even more performance improvement. We believe OneFormer is a significant step towards making image segmentation more universal and accessible.</em>",To,ae,St='The figure below illustrates the architecture of OneFormer. Taken from the <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">original paper</a>.',vo,ie,Bt,Fo,le,Rt='This model was contributed by <a href="https://huggingface.co/praeclarumjj3" rel="nofollow">Jitesh Jain</a>. The original code can be found <a href="https://github.com/SHI-Labs/OneFormer" rel="nofollow">here</a>.',wo,ce,Mo,de,Ht=`<li>OneFormer requires two inputs during inference: <em>image</em> and <em>task token</em>.</li> <li>During training, OneFormer only uses panoptic annotations.</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>OneFormerLoss</code> class of <code>modeling_oneformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/SHI-Labs/OneFormer/blob/33ebb56ed34f970a30ae103e786c0cb64c653d9a/oneformer/modeling/criterion.py#L287" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> to prepare input images and task inputs for the model and optional targets for the model. <code>OneformerProcessor</code> wraps <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both prepare the images and encode the task inputs.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,xo,me,Oo,pe,Gt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OneFormer.",ko,ge,Vt='<li>Demo notebooks regarding inference + fine-tuning on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OneFormer" rel="nofollow">here</a>.</li>',jo,fe,Xt=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,Io,he,Uo,S,ue,Qo,Le,Et='Class for outputs of <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. This class returns all the needed hidden states to compute the logits.',$o,N,_e,Ao,Se,Dt="Class for outputs of <code>OneFormerForUniversalSegmentationOutput</code>.",Ko,Be,Yt=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~OneFormerImageProcessor] for details regarding usage.`,Jo,be,zo,U,ye,et,Re,Qt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. It is used to instantiate a
OneFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OneFormer
<a href="https://huggingface.co/shi-labs/oneformer_ade20k_swin_tiny" rel="nofollow">shi-labs/oneformer_ade20k_swin_tiny</a> architecture
trained on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,ot,He,At=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,tt,R,No,Te,Co,F,ve,nt,Ge,Kt=`Constructs a OneFormer image processor. The image processor can be used to prepare image(s), task input(s) and
optional text inputs and targets for the model.`,rt,Ve,en=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,st,Xe,Fe,at,W,we,it,Ee,on="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",lt,De,tn=`OneFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,ct,H,Me,dt,Ye,nn=`Converts the output of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,mt,G,xe,pt,Qe,rn=`Converts the output of <code>OneFormerForUniversalSegmentationOutput</code> into image instance segmentation
predictions. Only supports PyTorch.`,gt,V,Oe,ft,Ae,sn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Po,ke,qo,j,je,ht,Ke,an=`Constructs an OneFormer processor which wraps <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into a single processor that inherits both the image processor and
tokenizer functionalities.`,ut,X,Ie,_t,eo,ln=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.encode_inputs">OneFormerImageProcessor.encode_inputs()</a> and then tokenizes the
task_inputs. Please refer to the docstring of this method for more information.`,bt,E,Ue,yt,oo,cn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">OneFormerImageProcessor.post_process_instance_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Tt,D,$e,vt,to,dn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">OneFormerImageProcessor.post_process_panoptic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Ft,Y,Je,wt,no,mn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">OneFormerImageProcessor.post_process_semantic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Wo,ze,Zo,C,Ne,Mt,ro,pn=`The bare OneFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,xt,J,Ce,Ot,so,gn='The <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> forward method, overrides the <code>__call__</code> special method.',kt,Q,jt,A,Lo,Pe,So,P,qe,It,ao,fn=`OneFormer Model for instance, semantic and panoptic image segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,Ut,I,We,$t,io,hn='The <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Jt,K,zt,lo,un="Example:",Nt,ee,Bo,go,Ro;return v=new L({props:{title:"OneFormer",local:"oneformer",headingTag:"h1"}}),x=new L({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ce=new L({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new L({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new L({props:{title:"OneFormer specific outputs",local:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",headingTag:"h2"}}),ue=new k({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",parameters:[{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": typing.Union[typing.Tuple[typing.Dict[str, torch.FloatTensor]], NoneType] = None"},{name:"text_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L804"}}),_e=new k({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_predictions",val:": typing.List[typing.Dict[str, torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_object_queries",val:": FloatTensor = None"},{name:"transformer_decoder_contrastive_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_mask_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_class_predictions",val:": FloatTensor = None"},{name:"transformer_decoder_auxiliary_predictions",val:": typing.Union[typing.List[typing.Dict[str, torch.FloatTensor]], NoneType] = None"},{name:"text_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"task_token",val:": FloatTensor = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.auxiliary_predictions",description:`<strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L854"}}),be=new L({props:{title:"OneFormerConfig",local:"transformers.OneFormerConfig",headingTag:"h2"}}),ye=new k({props:{name:"class transformers.OneFormerConfig",anchor:"transformers.OneFormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 150"},{name:"no_object_weight",val:": int = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"contrastive_weight",val:": float = 0.5"},{name:"contrastive_temperature",val:": float = 0.07"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"is_training",val:": bool = False"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"output_auxiliary_logits",val:": bool = True"},{name:"strides",val:": typing.Optional[list] = [4, 8, 16, 32]"},{name:"task_seq_len",val:": int = 77"},{name:"text_encoder_width",val:": int = 256"},{name:"text_encoder_context_length",val:": int = 77"},{name:"text_encoder_num_layers",val:": int = 6"},{name:"text_encoder_vocab_size",val:": int = 49408"},{name:"text_encoder_proj_layers",val:": int = 2"},{name:"text_encoder_n_ctx",val:": int = 16"},{name:"conv_dim",val:": int = 256"},{name:"mask_dim",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"norm",val:": str = 'GN'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"use_task_norm",val:": bool = True"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.1"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_proj",val:": bool = False"},{name:"query_dec_layers",val:": int = 2"},{name:"common_stride",val:": int = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>, defaults to <code>SwinConfig</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.OneFormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Values to be ignored in GT label while calculating loss.`,name:"ignore_value"},{anchor:"transformers.OneFormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 150) &#x2014;
Number of object queries.`,name:"num_queries"},{anchor:"transformers.OneFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight for no-object class predictions.`,name:"no_object_weight"},{anchor:"transformers.OneFormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Weight for Classification CE loss.`,name:"class_weight"},{anchor:"transformers.OneFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for binary CE loss.`,name:"mask_weight"},{anchor:"transformers.OneFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for dice loss.`,name:"dice_weight"},{anchor:"transformers.OneFormerConfig.contrastive_weight",description:`<strong>contrastive_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Weight for contrastive loss.`,name:"contrastive_weight"},{anchor:"transformers.OneFormerConfig.contrastive_temperature",description:`<strong>contrastive_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.07) &#x2014;
Initial value for scaling the contrastive logits.`,name:"contrastive_temperature"},{anchor:"transformers.OneFormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points to sample while calculating losses on mask predictions.`,name:"train_num_points"},{anchor:"transformers.OneFormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Ratio to decide how many points to oversample.`,name:"oversample_ratio"},{anchor:"transformers.OneFormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.OneFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Standard deviation for normal intialization.`,name:"init_std"},{anchor:"transformers.OneFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Standard deviation for xavier uniform initialization.`,name:"init_xavier_std"},{anchor:"transformers.OneFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OneFormerConfig.is_training",description:`<strong>is_training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to run in training or inference mode.`,name:"is_training"},{anchor:"transformers.OneFormerConfig.use_auxiliary_loss",description:`<strong>use_auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to calculate loss using intermediate predictions from transformer decoder.`,name:"use_auxiliary_loss"},{anchor:"transformers.OneFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return intermediate predictions from transformer decoder.`,name:"output_auxiliary_logits"},{anchor:"transformers.OneFormerConfig.strides",description:`<strong>strides</strong> (<code>list</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
List containing the strides for feature maps in the encoder.`,name:"strides"},{anchor:"transformers.OneFormerConfig.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for tokenizing text list input.`,name:"task_seq_len"},{anchor:"transformers.OneFormerConfig.text_encoder_width",description:`<strong>text_encoder_width</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Hidden size for text encoder.`,name:"text_encoder_width"},{anchor:"transformers.OneFormerConfig.text_encoder_context_length",description:`<strong>text_encoder_context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Input sequence length for text encoder.`,name:"text_encoder_context_length"},{anchor:"transformers.OneFormerConfig.text_encoder_num_layers",description:`<strong>text_encoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers for transformer in text encoder.`,name:"text_encoder_num_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_vocab_size",description:`<strong>text_encoder_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size for tokenizer.`,name:"text_encoder_vocab_size"},{anchor:"transformers.OneFormerConfig.text_encoder_proj_layers",description:`<strong>text_encoder_proj_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in MLP for project text queries.`,name:"text_encoder_proj_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_n_ctx",description:`<strong>text_encoder_n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of learnable text context queries.`,name:"text_encoder_n_ctx"},{anchor:"transformers.OneFormerConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Feature map dimension to map outputs from the backbone.`,name:"conv_dim"},{anchor:"transformers.OneFormerConfig.mask_dim",description:`<strong>mask_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for feature maps in pixel decoder.`,name:"mask_dim"},{anchor:"transformers.OneFormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for hidden states in transformer decoder.`,name:"hidden_dim"},{anchor:"transformers.OneFormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension for FFN layer in pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.OneFormerConfig.norm",description:`<strong>norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;GN&quot;</code>) &#x2014;
Type of normalization.`,name:"norm"},{anchor:"transformers.OneFormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.OneFormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.OneFormerConfig.use_task_norm",description:`<strong>use_task_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the task token.`,name:"use_task_norm"},{anchor:"transformers.OneFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads in transformer layers in the pixel and transformer decoders.`,name:"num_attention_heads"},{anchor:"transformers.OneFormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Dropout probability for pixel and transformer decoders.`,name:"dropout"},{anchor:"transformers.OneFormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension for FFN layer in transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.OneFormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize hidden states before attention layers in transformer decoder.`,name:"pre_norm"},{anchor:"transformers.OneFormerConfig.enforce_input_proj",description:`<strong>enforce_input_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to project hidden states in transformer decoder.`,name:"enforce_input_proj"},{anchor:"transformers.OneFormerConfig.query_dec_layers",description:`<strong>query_dec_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in query transformer.`,name:"query_dec_layers"},{anchor:"transformers.OneFormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Common stride used for features in pixel decoder.`,name:"common_stride"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/configuration_oneformer.py#L33"}}),R=new Ct({props:{anchor:"transformers.OneFormerConfig.example",$$slots:{default:[Mn]},$$scope:{ctx:$}}}),Te=new L({props:{title:"OneFormerImageProcessor",local:"transformers.OneFormerImageProcessor",headingTag:"h2"}}),ve=new k({props:{name:"class transformers.OneFormerImageProcessor",anchor:"transformers.OneFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"repo_path",val:": str = 'shi-labs/oneformer_demo'"},{name:"class_info_file",val:": str = None"},{name:"num_text",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.OneFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.OneFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.OneFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.OneFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.OneFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.OneFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.OneFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.OneFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.OneFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.OneFormerImageProcessor.repo_path",description:`<strong>repo_path</strong> (<code>str</code>, defaults to <code>shi-labs/oneformer_demo</code>, <em>optional</em>, defaults to <code>&quot;shi-labs/oneformer_demo&quot;</code>) &#x2014;
Dataset repository on huggingface hub containing the JSON file with class information for the dataset.`,name:"repo_path"},{anchor:"transformers.OneFormerImageProcessor.class_info_file",description:`<strong>class_info_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
JSON file containing class information for the dataset. It is stored inside on the <code>repo_path</code> dataset
repository.`,name:"class_info_file"},{anchor:"transformers.OneFormerImageProcessor.num_text",description:`<strong>num_text</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of text entries in the text input list.`,name:"num_text"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L350"}}),Fe=new k({props:{name:"preprocess",anchor:"transformers.OneFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"task_inputs",val:": typing.Optional[typing.List[str]] = None"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.Dict[int, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L635"}}),we=new k({props:{name:"encode_inputs",anchor:"transformers.OneFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"task_inputs",val:": typing.List[str]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.task_inputs",description:`<strong>task_inputs</strong> (<code>List[str]</code>) &#x2014;
List of task values.`,name:"task_inputs"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred from the input
image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L933",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
<li><strong>text_inputs</strong> — Optional list of text string entries to be fed to a model (when <code>annotations</code> are
provided). They identify the binary masks present in the image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Me=new k({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1068",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),xe=new k({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"task_type",val:": str = 'instance'"},{name:"is_demo",val:": bool = True"},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<code>OneFormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <code>OneFormerForUniversalSegmentationOutput</code>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.task_type",description:`<strong>task_type</strong> (<code>str</code>, <em>optional)</em>, defaults to &#x201C;instance&#x201D;) &#x2014;
The post processing depends on the task token input. If the <code>task_type</code> is &#x201C;panoptic&#x201D;, we need to
ignore the stuff predictions.`,name:"task_type"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.is_demo",description:`<strong>is_demo</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>True</code>) &#x2014;
Whether the model is in demo mode. If true, use threshold to predict final masks.`,name:"is_demo"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>False</code>) &#x2014;
Whether to return predictions in COCO format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1118",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Oe=new k({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1237",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ke=new L({props:{title:"OneFormerProcessor",local:"transformers.OneFormerProcessor",headingTag:"h2"}}),je=new k({props:{name:"class transformers.OneFormerProcessor",anchor:"transformers.OneFormerProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"max_seq_length",val:": int = 77"},{name:"task_seq_length",val:": int = 77"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OneFormerProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.OneFormerProcessor.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77)) &#x2014;
Sequence length for input text list.`,name:"max_seq_len"},{anchor:"transformers.OneFormerProcessor.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for input task token.`,name:"task_seq_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L29"}}),Ie=new k({props:{name:"encode_inputs",anchor:"transformers.OneFormerProcessor.encode_inputs",parameters:[{name:"images",val:" = None"},{name:"task_inputs",val:" = None"},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L145"}}),Ue=new k({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerProcessor.post_process_instance_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L192"}}),$e=new k({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_panoptic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L199"}}),Je=new k({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_semantic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L185"}}),ze=new L({props:{title:"OneFormerModel",local:"transformers.OneFormerModel",headingTag:"h2"}}),Ne=new k({props:{name:"class transformers.OneFormerModel",anchor:"transformers.OneFormerModel",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L2902"}}),Ce=new k({props:{name:"forward",anchor:"transformers.OneFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OneFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerModel.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L2919",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — Tuple of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new bn({props:{$$slots:{default:[xn]},$$scope:{ctx:$}}}),A=new Ct({props:{anchor:"transformers.OneFormerModel.forward.example",$$slots:{default:[On]},$$scope:{ctx:$}}}),Pe=new L({props:{title:"OneFormerForUniversalSegmentation",local:"transformers.OneFormerForUniversalSegmentation",headingTag:"h2"}}),qe=new k({props:{name:"class transformers.OneFormerForUniversalSegmentation",anchor:"transformers.OneFormerForUniversalSegmentation",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L3031"}}),We=new k({props:{name:"forward",anchor:"transformers.OneFormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.text_inputs",description:`<strong>text_inputs</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Tensor fof shape <code>(num_queries, sequence_length)</code> to be fed to a model`,name:"text_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L3098",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new bn({props:{$$slots:{default:[kn]},$$scope:{ctx:$}}}),ee=new Ct({props:{anchor:"transformers.OneFormerForUniversalSegmentation.forward.example",$$slots:{default:[jn]},$$scope:{ctx:$}}}),{c(){c=a("meta"),M=r(),b=a("p"),y=r(),m(v.$$.fragment),d=r(),m(x.$$.fragment),uo=r(),te=a("p"),te.innerHTML=qt,_o=r(),ne=a("img"),bo=r(),re=a("p"),re.textContent=Zt,yo=r(),se=a("p"),se.innerHTML=Lt,To=r(),ae=a("p"),ae.innerHTML=St,vo=r(),ie=a("img"),Fo=r(),le=a("p"),le.innerHTML=Rt,wo=r(),m(ce.$$.fragment),Mo=r(),de=a("ul"),de.innerHTML=Ht,xo=r(),m(me.$$.fragment),Oo=r(),pe=a("p"),pe.textContent=Gt,ko=r(),ge=a("ul"),ge.innerHTML=Vt,jo=r(),fe=a("p"),fe.textContent=Xt,Io=r(),m(he.$$.fragment),Uo=r(),S=a("div"),m(ue.$$.fragment),Qo=r(),Le=a("p"),Le.innerHTML=Et,$o=r(),N=a("div"),m(_e.$$.fragment),Ao=r(),Se=a("p"),Se.innerHTML=Dt,Ko=r(),Be=a("p"),Be.innerHTML=Yt,Jo=r(),m(be.$$.fragment),zo=r(),U=a("div"),m(ye.$$.fragment),et=r(),Re=a("p"),Re.innerHTML=Qt,ot=r(),He=a("p"),He.innerHTML=At,tt=r(),m(R.$$.fragment),No=r(),m(Te.$$.fragment),Co=r(),F=a("div"),m(ve.$$.fragment),nt=r(),Ge=a("p"),Ge.textContent=Kt,rt=r(),Ve=a("p"),Ve.innerHTML=en,st=r(),Xe=a("div"),m(Fe.$$.fragment),at=r(),W=a("div"),m(we.$$.fragment),it=r(),Ee=a("p"),Ee.innerHTML=on,lt=r(),De=a("p"),De.innerHTML=tn,ct=r(),H=a("div"),m(Me.$$.fragment),dt=r(),Ye=a("p"),Ye.innerHTML=nn,mt=r(),G=a("div"),m(xe.$$.fragment),pt=r(),Qe=a("p"),Qe.innerHTML=rn,gt=r(),V=a("div"),m(Oe.$$.fragment),ft=r(),Ae=a("p"),Ae.innerHTML=sn,Po=r(),m(ke.$$.fragment),qo=r(),j=a("div"),m(je.$$.fragment),ht=r(),Ke=a("p"),Ke.innerHTML=an,ut=r(),X=a("div"),m(Ie.$$.fragment),_t=r(),eo=a("p"),eo.innerHTML=ln,bt=r(),E=a("div"),m(Ue.$$.fragment),yt=r(),oo=a("p"),oo.innerHTML=cn,Tt=r(),D=a("div"),m($e.$$.fragment),vt=r(),to=a("p"),to.innerHTML=dn,Ft=r(),Y=a("div"),m(Je.$$.fragment),wt=r(),no=a("p"),no.innerHTML=mn,Wo=r(),m(ze.$$.fragment),Zo=r(),C=a("div"),m(Ne.$$.fragment),Mt=r(),ro=a("p"),ro.innerHTML=pn,xt=r(),J=a("div"),m(Ce.$$.fragment),Ot=r(),so=a("p"),so.innerHTML=gn,kt=r(),m(Q.$$.fragment),jt=r(),m(A.$$.fragment),Lo=r(),m(Pe.$$.fragment),So=r(),P=a("div"),m(qe.$$.fragment),It=r(),ao=a("p"),ao.innerHTML=fn,Ut=r(),I=a("div"),m(We.$$.fragment),$t=r(),io=a("p"),io.innerHTML=hn,Jt=r(),m(K.$$.fragment),zt=r(),lo=a("p"),lo.textContent=un,Nt=r(),m(ee.$$.fragment),Bo=r(),go=a("p"),this.h()},l(e){const t=wn("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(o),M=s(e),b=i(e,"P",{}),w(b).forEach(o),y=s(e),p(v.$$.fragment,e),d=s(e),p(x.$$.fragment,e),uo=s(e),te=i(e,"P",{"data-svelte-h":!0}),_(te)!=="svelte-4uriep"&&(te.innerHTML=qt),_o=s(e),ne=i(e,"IMG",{width:!0,src:!0}),bo=s(e),re=i(e,"P",{"data-svelte-h":!0}),_(re)!=="svelte-vfdo9a"&&(re.textContent=Zt),yo=s(e),se=i(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-lnf9ge"&&(se.innerHTML=Lt),To=s(e),ae=i(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-194z8jz"&&(ae.innerHTML=St),vo=s(e),ie=i(e,"IMG",{width:!0,src:!0}),Fo=s(e),le=i(e,"P",{"data-svelte-h":!0}),_(le)!=="svelte-tphfzt"&&(le.innerHTML=Rt),wo=s(e),p(ce.$$.fragment,e),Mo=s(e),de=i(e,"UL",{"data-svelte-h":!0}),_(de)!=="svelte-1moxus8"&&(de.innerHTML=Ht),xo=s(e),p(me.$$.fragment,e),Oo=s(e),pe=i(e,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-e2wyhg"&&(pe.textContent=Gt),ko=s(e),ge=i(e,"UL",{"data-svelte-h":!0}),_(ge)!=="svelte-1f4vugx"&&(ge.innerHTML=Vt),jo=s(e),fe=i(e,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-1rggs50"&&(fe.textContent=Xt),Io=s(e),p(he.$$.fragment,e),Uo=s(e),S=i(e,"DIV",{class:!0});var Ze=w(S);p(ue.$$.fragment,Ze),Qo=s(Ze),Le=i(Ze,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-l9bgt7"&&(Le.innerHTML=Et),Ze.forEach(o),$o=s(e),N=i(e,"DIV",{class:!0});var B=w(N);p(_e.$$.fragment,B),Ao=s(B),Se=i(B,"P",{"data-svelte-h":!0}),_(Se)!=="svelte-tmsgtt"&&(Se.innerHTML=Dt),Ko=s(B),Be=i(B,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-19d5ptt"&&(Be.innerHTML=Yt),B.forEach(o),Jo=s(e),p(be.$$.fragment,e),zo=s(e),U=i(e,"DIV",{class:!0});var q=w(U);p(ye.$$.fragment,q),et=s(q),Re=i(q,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-1stmifu"&&(Re.innerHTML=Qt),ot=s(q),He=i(q,"P",{"data-svelte-h":!0}),_(He)!=="svelte-o55m63"&&(He.innerHTML=At),tt=s(q),p(R.$$.fragment,q),q.forEach(o),No=s(e),p(Te.$$.fragment,e),Co=s(e),F=i(e,"DIV",{class:!0});var O=w(F);p(ve.$$.fragment,O),nt=s(O),Ge=i(O,"P",{"data-svelte-h":!0}),_(Ge)!=="svelte-5uz02u"&&(Ge.textContent=Kt),rt=s(O),Ve=i(O,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-1wh3jgn"&&(Ve.innerHTML=en),st=s(O),Xe=i(O,"DIV",{class:!0});var fo=w(Xe);p(Fe.$$.fragment,fo),fo.forEach(o),at=s(O),W=i(O,"DIV",{class:!0});var co=w(W);p(we.$$.fragment,co),it=s(co),Ee=i(co,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-1tetyua"&&(Ee.innerHTML=on),lt=s(co),De=i(co,"P",{"data-svelte-h":!0}),_(De)!=="svelte-g5nqd2"&&(De.innerHTML=tn),co.forEach(o),ct=s(O),H=i(O,"DIV",{class:!0});var Ho=w(H);p(Me.$$.fragment,Ho),dt=s(Ho),Ye=i(Ho,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-cqk2tl"&&(Ye.innerHTML=nn),Ho.forEach(o),mt=s(O),G=i(O,"DIV",{class:!0});var Go=w(G);p(xe.$$.fragment,Go),pt=s(Go),Qe=i(Go,"P",{"data-svelte-h":!0}),_(Qe)!=="svelte-ivz9k7"&&(Qe.innerHTML=rn),Go.forEach(o),gt=s(O),V=i(O,"DIV",{class:!0});var Vo=w(V);p(Oe.$$.fragment,Vo),ft=s(Vo),Ae=i(Vo,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-pw2uru"&&(Ae.innerHTML=sn),Vo.forEach(o),O.forEach(o),Po=s(e),p(ke.$$.fragment,e),qo=s(e),j=i(e,"DIV",{class:!0});var z=w(j);p(je.$$.fragment,z),ht=s(z),Ke=i(z,"P",{"data-svelte-h":!0}),_(Ke)!=="svelte-1w5nfyy"&&(Ke.innerHTML=an),ut=s(z),X=i(z,"DIV",{class:!0});var Xo=w(X);p(Ie.$$.fragment,Xo),_t=s(Xo),eo=i(Xo,"P",{"data-svelte-h":!0}),_(eo)!=="svelte-1vyrc9d"&&(eo.innerHTML=ln),Xo.forEach(o),bt=s(z),E=i(z,"DIV",{class:!0});var Eo=w(E);p(Ue.$$.fragment,Eo),yt=s(Eo),oo=i(Eo,"P",{"data-svelte-h":!0}),_(oo)!=="svelte-1s6zzkn"&&(oo.innerHTML=cn),Eo.forEach(o),Tt=s(z),D=i(z,"DIV",{class:!0});var Do=w(D);p($e.$$.fragment,Do),vt=s(Do),to=i(Do,"P",{"data-svelte-h":!0}),_(to)!=="svelte-1sabqt1"&&(to.innerHTML=dn),Do.forEach(o),Ft=s(z),Y=i(z,"DIV",{class:!0});var Yo=w(Y);p(Je.$$.fragment,Yo),wt=s(Yo),no=i(Yo,"P",{"data-svelte-h":!0}),_(no)!=="svelte-133lsut"&&(no.innerHTML=mn),Yo.forEach(o),z.forEach(o),Wo=s(e),p(ze.$$.fragment,e),Zo=s(e),C=i(e,"DIV",{class:!0});var mo=w(C);p(Ne.$$.fragment,mo),Mt=s(mo),ro=i(mo,"P",{"data-svelte-h":!0}),_(ro)!=="svelte-1o75izy"&&(ro.innerHTML=pn),xt=s(mo),J=i(mo,"DIV",{class:!0});var oe=w(J);p(Ce.$$.fragment,oe),Ot=s(oe),so=i(oe,"P",{"data-svelte-h":!0}),_(so)!=="svelte-1dezo66"&&(so.innerHTML=gn),kt=s(oe),p(Q.$$.fragment,oe),jt=s(oe),p(A.$$.fragment,oe),oe.forEach(o),mo.forEach(o),Lo=s(e),p(Pe.$$.fragment,e),So=s(e),P=i(e,"DIV",{class:!0});var po=w(P);p(qe.$$.fragment,po),It=s(po),ao=i(po,"P",{"data-svelte-h":!0}),_(ao)!=="svelte-1c5p7r"&&(ao.innerHTML=fn),Ut=s(po),I=i(po,"DIV",{class:!0});var Z=w(I);p(We.$$.fragment,Z),$t=s(Z),io=i(Z,"P",{"data-svelte-h":!0}),_(io)!=="svelte-28htca"&&(io.innerHTML=hn),Jt=s(Z),p(K.$$.fragment,Z),zt=s(Z),lo=i(Z,"P",{"data-svelte-h":!0}),_(lo)!=="svelte-11lpom8"&&(lo.textContent=un),Nt=s(Z),p(ee.$$.fragment,Z),Z.forEach(o),po.forEach(o),Bo=s(e),go=i(e,"P",{}),w(go).forEach(o),this.h()},h(){T(c,"name","hf:doc:metadata"),T(c,"content",Un),T(ne,"width","600"),_n(ne.src,Wt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_teaser.png")||T(ne,"src",Wt),T(ie,"width","600"),_n(ie.src,Bt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_architecture.png")||T(ie,"src",Bt),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){n(document.head,c),l(e,M,t),l(e,b,t),l(e,y,t),g(v,e,t),l(e,d,t),g(x,e,t),l(e,uo,t),l(e,te,t),l(e,_o,t),l(e,ne,t),l(e,bo,t),l(e,re,t),l(e,yo,t),l(e,se,t),l(e,To,t),l(e,ae,t),l(e,vo,t),l(e,ie,t),l(e,Fo,t),l(e,le,t),l(e,wo,t),g(ce,e,t),l(e,Mo,t),l(e,de,t),l(e,xo,t),g(me,e,t),l(e,Oo,t),l(e,pe,t),l(e,ko,t),l(e,ge,t),l(e,jo,t),l(e,fe,t),l(e,Io,t),g(he,e,t),l(e,Uo,t),l(e,S,t),g(ue,S,null),n(S,Qo),n(S,Le),l(e,$o,t),l(e,N,t),g(_e,N,null),n(N,Ao),n(N,Se),n(N,Ko),n(N,Be),l(e,Jo,t),g(be,e,t),l(e,zo,t),l(e,U,t),g(ye,U,null),n(U,et),n(U,Re),n(U,ot),n(U,He),n(U,tt),g(R,U,null),l(e,No,t),g(Te,e,t),l(e,Co,t),l(e,F,t),g(ve,F,null),n(F,nt),n(F,Ge),n(F,rt),n(F,Ve),n(F,st),n(F,Xe),g(Fe,Xe,null),n(F,at),n(F,W),g(we,W,null),n(W,it),n(W,Ee),n(W,lt),n(W,De),n(F,ct),n(F,H),g(Me,H,null),n(H,dt),n(H,Ye),n(F,mt),n(F,G),g(xe,G,null),n(G,pt),n(G,Qe),n(F,gt),n(F,V),g(Oe,V,null),n(V,ft),n(V,Ae),l(e,Po,t),g(ke,e,t),l(e,qo,t),l(e,j,t),g(je,j,null),n(j,ht),n(j,Ke),n(j,ut),n(j,X),g(Ie,X,null),n(X,_t),n(X,eo),n(j,bt),n(j,E),g(Ue,E,null),n(E,yt),n(E,oo),n(j,Tt),n(j,D),g($e,D,null),n(D,vt),n(D,to),n(j,Ft),n(j,Y),g(Je,Y,null),n(Y,wt),n(Y,no),l(e,Wo,t),g(ze,e,t),l(e,Zo,t),l(e,C,t),g(Ne,C,null),n(C,Mt),n(C,ro),n(C,xt),n(C,J),g(Ce,J,null),n(J,Ot),n(J,so),n(J,kt),g(Q,J,null),n(J,jt),g(A,J,null),l(e,Lo,t),g(Pe,e,t),l(e,So,t),l(e,P,t),g(qe,P,null),n(P,It),n(P,ao),n(P,Ut),n(P,I),g(We,I,null),n(I,$t),n(I,io),n(I,Jt),g(K,I,null),n(I,zt),n(I,lo),n(I,Nt),g(ee,I,null),l(e,Bo,t),l(e,go,t),Ro=!0},p(e,[t]){const Ze={};t&2&&(Ze.$$scope={dirty:t,ctx:e}),R.$set(Ze);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),Q.$set(B);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),A.$set(q);const O={};t&2&&(O.$$scope={dirty:t,ctx:e}),K.$set(O);const fo={};t&2&&(fo.$$scope={dirty:t,ctx:e}),ee.$set(fo)},i(e){Ro||(f(v.$$.fragment,e),f(x.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(R.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(Fe.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(xe.$$.fragment,e),f(Oe.$$.fragment,e),f(ke.$$.fragment,e),f(je.$$.fragment,e),f(Ie.$$.fragment,e),f(Ue.$$.fragment,e),f($e.$$.fragment,e),f(Je.$$.fragment,e),f(ze.$$.fragment,e),f(Ne.$$.fragment,e),f(Ce.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(Pe.$$.fragment,e),f(qe.$$.fragment,e),f(We.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),Ro=!0)},o(e){h(v.$$.fragment,e),h(x.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(R.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(Fe.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(xe.$$.fragment,e),h(Oe.$$.fragment,e),h(ke.$$.fragment,e),h(je.$$.fragment,e),h(Ie.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(Je.$$.fragment,e),h(ze.$$.fragment,e),h(Ne.$$.fragment,e),h(Ce.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(Pe.$$.fragment,e),h(qe.$$.fragment,e),h(We.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),Ro=!1},d(e){e&&(o(M),o(b),o(y),o(d),o(uo),o(te),o(_o),o(ne),o(bo),o(re),o(yo),o(se),o(To),o(ae),o(vo),o(ie),o(Fo),o(le),o(wo),o(Mo),o(de),o(xo),o(Oo),o(pe),o(ko),o(ge),o(jo),o(fe),o(Io),o(Uo),o(S),o($o),o(N),o(Jo),o(zo),o(U),o(No),o(Co),o(F),o(Po),o(qo),o(j),o(Wo),o(Zo),o(C),o(Lo),o(So),o(P),o(Bo),o(go)),o(c),u(v,e),u(x,e),u(ce,e),u(me,e),u(he,e),u(ue),u(_e),u(be,e),u(ye),u(R),u(Te,e),u(ve),u(Fe),u(we),u(Me),u(xe),u(Oe),u(ke,e),u(je),u(Ie),u(Ue),u($e),u(Je),u(ze,e),u(Ne),u(Ce),u(Q),u(A),u(Pe,e),u(qe),u(We),u(K),u(ee)}}}const Un='{"title":"OneFormer","local":"oneformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"OneFormer specific outputs","local":"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput","sections":[],"depth":2},{"title":"OneFormerConfig","local":"transformers.OneFormerConfig","sections":[],"depth":2},{"title":"OneFormerImageProcessor","local":"transformers.OneFormerImageProcessor","sections":[],"depth":2},{"title":"OneFormerProcessor","local":"transformers.OneFormerProcessor","sections":[],"depth":2},{"title":"OneFormerModel","local":"transformers.OneFormerModel","sections":[],"depth":2},{"title":"OneFormerForUniversalSegmentation","local":"transformers.OneFormerForUniversalSegmentation","sections":[],"depth":2}],"depth":1}';function $n($){return Tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends vn{constructor(c){super(),Fn(this,c,$n,In,yn,{})}}export{Zn as component};
