import{s as vs,n as _s,o as ks}from"../chunks/scheduler.bdbef820.js";import{S as $s,i as Is,g as o,s as l,r as m,A as Rs,h as p,f as e,c as n,j as G,u,x as r,k as ms,y as h,a as t,v as y,d as f,t as g,w as M}from"../chunks/index.c0aea24a.js";import{H as us,g as Vs}from"../chunks/Heading.0e005771.js";import{C as z}from"../chunks/CodeBlock.6ccca92e.js";function Xs(hs){let c,E,H,q,j,F,b,ys="This guide shows specific methods for processing audio datasets. Learn how to:",B,J,fs='<li>Resample the sampling rate.</li> <li>Use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> with audio datasets.</li>',Q,T,gs='For a guide on how to process any type of dataset, take a look at the <a class="underline decoration-sky-400 decoration-2 font-semibold" href="./process">general process guide</a>.',A,U,L,w,Ms='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function is used to cast a column to another feature to be decoded. When you use this function with the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature, you can resample the sampling rate:',P,v,S,_,js="Audio files are decoded and resampled on-the-fly, so the next time you access an example, the audio file is resampled to 16kHz:",K,k,D,i,bs='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/resample.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/resample-dark.gif"/>',O,$,ss,I,Js='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function helps preprocess your entire dataset at once. Depending on the type of model you’re working with, you’ll need to either load a <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoFeatureExtractor" rel="nofollow">feature extractor</a> or a <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoProcessor" rel="nofollow">processor</a>.',as,d,R,x,Ts="For pretrained speech recognition models, load a feature extractor and tokenizer and combine them in a <code>processor</code>:",cs,V,is,X,N,Us="For fine-tuned speech recognition models, you only need to load a <code>processor</code>:",ds,Y,es,Z,ws='When you use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> with your preprocessing function, include the <code>audio</code> column to ensure you’re actually resampling the audio data:',ts,C,ls,W,ns;return j=new us({props:{title:"Process audio data",local:"process-audio-data",headingTag:"h1"}}),U=new us({props:{title:"Cast",local:"cast",headingTag:"h2"}}),v=new z({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMlBvbHlBSSUyRm1pbmRzMTQlMjIlMkMlMjAlMjJlbi1VUyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;en-US&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))`,wrap:!1}}),k=new z({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>]
{<span class="hljs-string">&#x27;array&#x27;</span>: array([ <span class="hljs-number">2.3443763e-05</span>,  <span class="hljs-number">2.1729663e-04</span>,  <span class="hljs-number">2.2145823e-04</span>, ...,
         <span class="hljs-number">3.8356509e-05</span>, -<span class="hljs-number">7.3497440e-06</span>, -<span class="hljs-number">2.1754686e-05</span>], dtype=float32),
 <span class="hljs-string">&#x27;path&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-US~JOINT_ACCOUNT/602ba55abb1e6d0fbce92065.wav&#x27;</span>,
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),$=new us({props:{title:"Map",local:"map",headingTag:"h2"}}),V=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUyQyUyMEF1dG9Qcm9jZXNzb3IlMEElMEFtb2RlbF9jaGVja3BvaW50JTIwJTNEJTIwJTIyZmFjZWJvb2slMkZ3YXYydmVjMi1sYXJnZS14bHNyLTUzJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplciglMjIuJTJGdm9jYWIuanNvbiUyMiUyQyUyMHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiU1QlBBRCU1RCUyMiUyQyUyMHdvcmRfZGVsaW1pdGVyX3Rva2VuJTNEJTIyJTdDJTIyKSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUyMHRva2VuaXplciUzRHRva2VuaXplcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoFeatureExtractor, AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;facebook/wav2vec2-large-xlsr-53&quot;</span>
<span class="hljs-comment"># after defining a vocab.json file you can instantiate a tokenizer object:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer(<span class="hljs-string">&quot;./vocab.json&quot;</span>, unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>, pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>, word_delimiter_token=<span class="hljs-string">&quot;|&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(feature_extractor=feature_extractor, tokenizer=tokenizer)`,wrap:!1}}),Y=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRndhdjJ2ZWMyLWJhc2UtOTYwaCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/wav2vec2-base-960h&quot;</span>)`,wrap:!1}}),C=new z({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGJhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwYmF0Y2glNUIlMjJhdWRpbyUyMiU1RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIyaW5wdXRfdmFsdWVzJTIyJTVEJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKS5pbnB1dF92YWx1ZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwYmF0Y2glNUIlMjJpbnB1dF9sZW5ndGglMjIlNUQlMjAlM0QlMjBsZW4oYmF0Y2glNUIlMjJpbnB1dF92YWx1ZXMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHByb2Nlc3Nvci5hc190YXJnZXRfcHJvY2Vzc29yKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMHByb2Nlc3NvcihiYXRjaCU1QiUyMnNlbnRlbmNlJTIyJTVEKS5pbnB1dF9pZHMlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiYXRjaCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    audio = batch[<span class="hljs-string">&quot;audio&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;input_values&quot;</span>] = processor(audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]).input_values[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(batch[<span class="hljs-string">&quot;input_values&quot;</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> processor.as_target_processor():
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = processor(batch[<span class="hljs-string">&quot;sentence&quot;</span>]).input_ids
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)`,wrap:!1}}),{c(){c=o("meta"),E=l(),H=o("p"),q=l(),m(j.$$.fragment),F=l(),b=o("p"),b.textContent=ys,B=l(),J=o("ul"),J.innerHTML=fs,Q=l(),T=o("p"),T.innerHTML=gs,A=l(),m(U.$$.fragment),L=l(),w=o("p"),w.innerHTML=Ms,P=l(),m(v.$$.fragment),S=l(),_=o("p"),_.textContent=js,K=l(),m(k.$$.fragment),D=l(),i=o("div"),i.innerHTML=bs,O=l(),m($.$$.fragment),ss=l(),I=o("p"),I.innerHTML=Js,as=l(),d=o("ul"),R=o("li"),x=o("p"),x.innerHTML=Ts,cs=l(),m(V.$$.fragment),is=l(),X=o("li"),N=o("p"),N.innerHTML=Us,ds=l(),m(Y.$$.fragment),es=l(),Z=o("p"),Z.innerHTML=ws,ts=l(),m(C.$$.fragment),ls=l(),W=o("p"),this.h()},l(s){const a=Rs("svelte-u9bgzb",document.head);c=p(a,"META",{name:!0,content:!0}),a.forEach(e),E=n(s),H=p(s,"P",{}),G(H).forEach(e),q=n(s),u(j.$$.fragment,s),F=n(s),b=p(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-12xza0g"&&(b.textContent=ys),B=n(s),J=p(s,"UL",{"data-svelte-h":!0}),r(J)!=="svelte-g8esxn"&&(J.innerHTML=fs),Q=n(s),T=p(s,"P",{"data-svelte-h":!0}),r(T)!=="svelte-3s2bzp"&&(T.innerHTML=gs),A=n(s),u(U.$$.fragment,s),L=n(s),w=p(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-wfk17"&&(w.innerHTML=Ms),P=n(s),u(v.$$.fragment,s),S=n(s),_=p(s,"P",{"data-svelte-h":!0}),r(_)!=="svelte-cxxpks"&&(_.textContent=js),K=n(s),u(k.$$.fragment,s),D=n(s),i=p(s,"DIV",{class:!0,"data-svelte-h":!0}),r(i)!=="svelte-1e533u5"&&(i.innerHTML=bs),O=n(s),u($.$$.fragment,s),ss=n(s),I=p(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ohkqe4"&&(I.innerHTML=Js),as=n(s),d=p(s,"UL",{});var os=G(d);R=p(os,"LI",{});var ps=G(R);x=p(ps,"P",{"data-svelte-h":!0}),r(x)!=="svelte-eqcmp0"&&(x.innerHTML=Ts),cs=n(ps),u(V.$$.fragment,ps),ps.forEach(e),is=n(os),X=p(os,"LI",{});var rs=G(X);N=p(rs,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1p2th5z"&&(N.innerHTML=Us),ds=n(rs),u(Y.$$.fragment,rs),rs.forEach(e),os.forEach(e),es=n(s),Z=p(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-192vijz"&&(Z.innerHTML=ws),ts=n(s),u(C.$$.fragment,s),ls=n(s),W=p(s,"P",{}),G(W).forEach(e),this.h()},h(){ms(c,"name","hf:doc:metadata"),ms(c,"content",Ys),ms(i,"class","flex justify-center")},m(s,a){h(document.head,c),t(s,E,a),t(s,H,a),t(s,q,a),y(j,s,a),t(s,F,a),t(s,b,a),t(s,B,a),t(s,J,a),t(s,Q,a),t(s,T,a),t(s,A,a),y(U,s,a),t(s,L,a),t(s,w,a),t(s,P,a),y(v,s,a),t(s,S,a),t(s,_,a),t(s,K,a),y(k,s,a),t(s,D,a),t(s,i,a),t(s,O,a),y($,s,a),t(s,ss,a),t(s,I,a),t(s,as,a),t(s,d,a),h(d,R),h(R,x),h(R,cs),y(V,R,null),h(d,is),h(d,X),h(X,N),h(X,ds),y(Y,X,null),t(s,es,a),t(s,Z,a),t(s,ts,a),y(C,s,a),t(s,ls,a),t(s,W,a),ns=!0},p:_s,i(s){ns||(f(j.$$.fragment,s),f(U.$$.fragment,s),f(v.$$.fragment,s),f(k.$$.fragment,s),f($.$$.fragment,s),f(V.$$.fragment,s),f(Y.$$.fragment,s),f(C.$$.fragment,s),ns=!0)},o(s){g(j.$$.fragment,s),g(U.$$.fragment,s),g(v.$$.fragment,s),g(k.$$.fragment,s),g($.$$.fragment,s),g(V.$$.fragment,s),g(Y.$$.fragment,s),g(C.$$.fragment,s),ns=!1},d(s){s&&(e(E),e(H),e(q),e(F),e(b),e(B),e(J),e(Q),e(T),e(A),e(L),e(w),e(P),e(S),e(_),e(K),e(D),e(i),e(O),e(ss),e(I),e(as),e(d),e(es),e(Z),e(ts),e(ls),e(W)),e(c),M(j,s),M(U,s),M(v,s),M(k,s),M($,s),M(V),M(Y),M(C,s)}}}const Ys='{"title":"Process audio data","local":"process-audio-data","sections":[{"title":"Cast","local":"cast","sections":[],"depth":2},{"title":"Map","local":"map","sections":[],"depth":2}],"depth":1}';function Zs(hs){return ks(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Vs}),[]}class Ws extends $s{constructor(c){super(),Is(this,c,Zs,Xs,vs,{})}}export{Ws as component};
