import{s as ut,n as ht,o as mt}from"../chunks/scheduler.bdbef820.js";import{S as gt,i as ft,g as o,s as l,r as p,A as yt,h as i,f as a,c as n,j as le,u as c,x as r,k as ze,y as d,a as s,v as u,d as h,t as m,w as g}from"../chunks/index.c0aea24a.js";import{H as Xe,g as wt}from"../chunks/Heading.0e005771.js";import{C as j}from"../chunks/CodeBlock.6ccca92e.js";function Jt(Qe){let w,ne,ae,oe,k,ie,I,Ve='Sometimes, you may need to create a dataset if you’re working with your own data. Creating a dataset with 🤗 Datasets confers all the advantages of the library to your dataset: fast loading and processing, <a href="stream">stream enormous datasets</a>, <a href="https://huggingface.co/course/chapter5/4?fw=pt#the-magic-of-memory-mapping" rel="nofollow">memory-mapping</a>, and more. You can easily and rapidly create a dataset with 🤗 Datasets low-code approaches, reducing the time it takes to start training a model. In many cases, it is as easy as <a href="upload_dataset#upload-with-the-hub-ui">dragging and dropping</a> your data files into a dataset repository on the Hub.',re,v,Ne="In this tutorial, you’ll learn how to use 🤗 Datasets low-code methods for creating all types of datasets:",de,_,Ee="<li>Folder-based builders for quickly creating an image or audio dataset</li> <li><code>from_</code> methods for creating datasets from local files</li>",pe,$,ce,U,Se="There are two folder-based builders, <code>ImageFolder</code> and <code>AudioFolder</code>. These are low-code methods for quickly creating an image or speech and audio dataset with several thousand examples. They are great for rapidly prototyping computer vision and speech models before scaling to a larger dataset. Folder-based builders takes your data and automatically generates the dataset’s features, splits, and labels. Under the hood:",ue,q,De='<li><code>ImageFolder</code> uses the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Image">Image</a> feature to decode an image file. Many image extension formats are supported, such as jpg and png, but other formats are also supported. You can check the complete <a href="https://github.com/huggingface/datasets/blob/b5672a956d5de864e6f5550e493527d962d6ae55/src/datasets/packaged_modules/imagefolder/imagefolder.py#L39" rel="nofollow">list</a> of supported image extensions.</li> <li><code>AudioFolder</code> uses the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature to decode an audio file. Audio extensions such as wav and mp3 are supported, and you can check the complete <a href="https://github.com/huggingface/datasets/blob/b5672a956d5de864e6f5550e493527d962d6ae55/src/datasets/packaged_modules/audiofolder/audiofolder.py#L39" rel="nofollow">list</a> of supported audio extensions.</li>',he,Z,Pe="The dataset splits are generated from the repository structure, and the label names are automatically inferred from the directory name.",me,G,Ae="For example, if your image dataset (it is the same for an audio dataset) is stored like this:",ge,x,fe,C,Ke="Then this is how the folder-based builder generates an example:",ye,J,Oe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/folder-based-builder.png"/>',we,X,et='Create the image dataset by specifying <code>imagefolder</code> in <a href="/docs/datasets/v2.14.6/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',Je,F,Te,R,tt='An audio dataset is created in the same way, except you specify <code>audiofolder</code> in <a href="/docs/datasets/v2.14.6/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> instead:',be,W,Me,H,at="Any additional information about your dataset, such as text captions or transcriptions, can be included with a <code>metadata.csv</code> file in the folder containing your dataset. The metadata file needs to have a <code>file_name</code> column that links the image or audio file to its corresponding metadata:",je,L,ke,Y,st='To learn more about each of these folder-based builders, check out the and <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder"><span class="underline decoration-yellow-400 decoration-2 font-semibold">ImageFolder</span></a> or <a href="https://huggingface.co/docs/datasets/audio_dataset#audiofolder"><span class="underline decoration-pink-400 decoration-2 font-semibold">AudioFolder</span></a> guides.',Ie,B,ve,z,lt="You can also create a dataset from local files by specifying the path to the data files. There are two ways you can create a dataset using the <code>from_</code> methods:",_e,T,f,K,nt='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.from_generator">from_generator()</a> method is the most memory-efficient way to create a dataset from a <a href="https://wiki.python.org/moin/Generators" rel="nofollow">generator</a> due to a generators iterative behavior. This is especially useful when you’re working with a really large dataset that may not fit in memory, since the dataset is generated on disk progressively and then memory-mapped.',Fe,Q,Re,O,ot='A generator-based <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> needs to be iterated over with a <code>for</code> loop for example:',We,V,He,y,ee,it='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.from_dict">from_dict()</a> method is a straightforward way to create a dataset from a dictionary:',Le,N,Ye,te,rt='To create an image or audio dataset, chain the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> method with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.from_dict">from_dict()</a> and specify the column and feature type. For example, to create an audio dataset:',Be,E,$e,S,Ue,D,dt="We didn’t mention this in the tutorial, but you can also create a dataset with a loading script. A loading script is a more manual and code-intensive method for creating a dataset, but it also gives you the most flexibility and control over how a dataset is generated. It lets you configure additional options such as creating multiple configurations within a dataset, or enabling your dataset to be streamed.",qe,P,pt='To learn more about how to write loading scripts, take a look at the <a href="https://huggingface.co/docs/datasets/main/en/image_dataset#loading-script"><span class="underline decoration-yellow-400 decoration-2 font-semibold">image loading script</span></a>, <a href="https://huggingface.co/docs/datasets/main/en/audio_dataset"><span class="underline decoration-pink-400 decoration-2 font-semibold">audio loading script</span></a>, and <a href="https://huggingface.co/docs/datasets/main/en/dataset_script"><span class="underline decoration-green-400 decoration-2 font-semibold">text loading script</span></a> guides.',Ze,A,ct="Now that you know how to create a dataset, consider sharing it on the Hub so the community can also benefit from your work! Go on to the next section to learn how to share your dataset.",Ge,se,xe;return k=new Xe({props:{title:"Create a dataset",local:"create-a-dataset",headingTag:"h1"}}),$=new Xe({props:{title:"Folder-based builders",local:"folder-based-builders",headingTag:"h2"}}),x=new j({props:{code:"cG9rZW1vbiUyRnRyYWluJTJGZ3Jhc3MlMkZidWxiYXNhdXIucG5nJTBBcG9rZW1vbiUyRnRyYWluJTJGZmlyZSUyRmNoYXJtYW5kZXIucG5nJTBBcG9rZW1vbiUyRnRyYWluJTJGd2F0ZXIlMkZzcXVpcnRsZS5wbmclMEElMEFwb2tlbW9uJTJGdGVzdCUyRmdyYXNzJTJGaXZ5c2F1ci5wbmclMEFwb2tlbW9uJTJGdGVzdCUyRmZpcmUlMkZjaGFybWVsZW9uLnBuZyUwQXBva2Vtb24lMkZ0ZXN0JTJGd2F0ZXIlMkZ3YXJ0b3J0bGUucG5n",highlighted:`pokemon<span class="hljs-regexp">/train/g</span>rass/bulbasaur.png
pokemon<span class="hljs-regexp">/train/</span>fire/charmander.png
pokemon<span class="hljs-regexp">/train/</span>water/squirtle.png

pokemon<span class="hljs-regexp">/test/g</span>rass/ivysaur.png
pokemon<span class="hljs-regexp">/test/</span>fire/charmeleon.png
pokemon<span class="hljs-regexp">/test/</span>water/wartortle.png`,wrap:!1}}),F=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwSW1hZ2VGb2xkZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltYWdlZm9sZGVyJTIyJTJDJTIwZGF0YV9kaXIlM0QlMjIlMkZwYXRoJTJGdG8lMkZwb2tlbW9uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ImageFolder

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;imagefolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/pokemon&quot;</span>)`,wrap:!1}}),W=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW9Gb2xkZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmF1ZGlvZm9sZGVyJTIyJTJDJTIwZGF0YV9kaXIlM0QlMjIlMkZwYXRoJTJGdG8lMkZmb2xkZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> AudioFolder

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;audiofolder&quot;</span>, data_dir=<span class="hljs-string">&quot;/path/to/folder&quot;</span>)`,wrap:!1}}),L=new j({props:{code:"ZmlsZV9uYW1lJTJDJTIwdGV4dCUwQWJ1bGJhc2F1ci5wbmclMkMlMjBUaGVyZSUyMGlzJTIwYSUyMHBsYW50JTIwc2VlZCUyMG9uJTIwaXRzJTIwYmFjayUyMHJpZ2h0JTIwZnJvbSUyMHRoZSUyMGRheSUyMHRoaXMlMjBQb2slQzMlQTltb24lMjBpcyUyMGJvcm4uJTBBY2hhcm1hbmRlci5wbmclMkMlMjBJdCUyMGhhcyUyMGElMjBwcmVmZXJlbmNlJTIwZm9yJTIwaG90JTIwdGhpbmdzLiUwQXNxdWlydGxlLnBuZyUyQyUyMFdoZW4lMjBpdCUyMHJldHJhY3RzJTIwaXRzJTIwbG9uZyUyMG5lY2slMjBpbnRvJTIwaXRzJTIwc2hlbGwlMkMlMjBpdCUyMHNxdWlydHMlMjBvdXQlMjB3YXRlciUyMHdpdGglMjB2aWdvcm91cyUyMGZvcmNlLg==",highlighted:`file_name, <span class="hljs-built_in">text</span>
bulbasaur.png, There <span class="hljs-keyword">is</span> a plant seed <span class="hljs-keyword">on</span> <span class="hljs-keyword">its</span> <span class="hljs-keyword">back</span> right <span class="hljs-keyword">from</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">day</span> this Pokémon <span class="hljs-keyword">is</span> born.
charmander.png, It has a preference <span class="hljs-keyword">for</span> hot things.
squirtle.png, When <span class="hljs-keyword">it</span> retracts <span class="hljs-keyword">its</span> long neck <span class="hljs-keyword">into</span> <span class="hljs-keyword">its</span> shell, <span class="hljs-keyword">it</span> squirts out water <span class="hljs-keyword">with</span> vigorous force.`,wrap:!1}}),B=new Xe({props:{title:"From local files",local:"from-local-files",headingTag:"h2"}}),Q=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRlZiUyMGdlbigpJTNBJTBBJTIwJTIwJTIwJTIweWllbGQlMjAlN0IlMjJwb2tlbW9uJTIyJTNBJTIwJTIyYnVsYmFzYXVyJTIyJTJDJTIwJTIydHlwZSUyMiUzQSUyMCUyMmdyYXNzJTIyJTdEJTBBJTIwJTIwJTIwJTIweWllbGQlMjAlN0IlMjJwb2tlbW9uJTIyJTNBJTIwJTIyc3F1aXJ0bGUlMjIlMkMlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyd2F0ZXIlMjIlN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9nZW5lcmF0b3IoZ2VuKSUwQWRzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">gen</span>():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;squirtle&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;water&quot;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_generator(gen)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}`,wrap:!1}}),V=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwSXRlcmFibGVEYXRhc2V0JTBBZHMlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IoZ2VuKSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> IterableDataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = IterableDataset.from_generator(gen)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> ds:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;squirtle&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;water&quot;</span>}`,wrap:!1}}),N=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIycG9rZW1vbiUyMiUzQSUyMCU1QiUyMmJ1bGJhc2F1ciUyMiUyQyUyMCUyMnNxdWlydGxlJTIyJTVEJTJDJTIwJTIydHlwZSUyMiUzQSUyMCU1QiUyMmdyYXNzJTIyJTJDJTIwJTIyd2F0ZXIlMjIlNUQlN0QpJTBBZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;pokemon&quot;</span>: [<span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;squirtle&quot;</span>], <span class="hljs-string">&quot;type&quot;</span>: [<span class="hljs-string">&quot;grass&quot;</span>, <span class="hljs-string">&quot;water&quot;</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;pokemon&quot;</span>: <span class="hljs-string">&quot;bulbasaur&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;grass&quot;</span>}`,wrap:!1}}),E=new j({props:{code:"YXVkaW9fZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmF1ZGlvJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW9fMSUyMiUyQyUyMC4uLiUyQyUyMCUyMnBhdGglMkZ0byUyRmF1ZGlvX24lMjIlNUQlN0QpLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: [<span class="hljs-string">&quot;path/to/audio_1&quot;</span>, ..., <span class="hljs-string">&quot;path/to/audio_n&quot;</span>]}).cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio())',wrap:!1}}),S=new Xe({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){w=o("meta"),ne=l(),ae=o("p"),oe=l(),p(k.$$.fragment),ie=l(),I=o("p"),I.innerHTML=Ve,re=l(),v=o("p"),v.textContent=Ne,de=l(),_=o("ul"),_.innerHTML=Ee,pe=l(),p($.$$.fragment),ce=l(),U=o("p"),U.innerHTML=Se,ue=l(),q=o("ul"),q.innerHTML=De,he=l(),Z=o("p"),Z.textContent=Pe,me=l(),G=o("p"),G.textContent=Ae,ge=l(),p(x.$$.fragment),fe=l(),C=o("p"),C.textContent=Ke,ye=l(),J=o("div"),J.innerHTML=Oe,we=l(),X=o("p"),X.innerHTML=et,Je=l(),p(F.$$.fragment),Te=l(),R=o("p"),R.innerHTML=tt,be=l(),p(W.$$.fragment),Me=l(),H=o("p"),H.innerHTML=at,je=l(),p(L.$$.fragment),ke=l(),Y=o("p"),Y.innerHTML=st,Ie=l(),p(B.$$.fragment),ve=l(),z=o("p"),z.innerHTML=lt,_e=l(),T=o("ul"),f=o("li"),K=o("p"),K.innerHTML=nt,Fe=l(),p(Q.$$.fragment),Re=l(),O=o("p"),O.innerHTML=ot,We=l(),p(V.$$.fragment),He=l(),y=o("li"),ee=o("p"),ee.innerHTML=it,Le=l(),p(N.$$.fragment),Ye=l(),te=o("p"),te.innerHTML=rt,Be=l(),p(E.$$.fragment),$e=l(),p(S.$$.fragment),Ue=l(),D=o("p"),D.textContent=dt,qe=l(),P=o("p"),P.innerHTML=pt,Ze=l(),A=o("p"),A.textContent=ct,Ge=l(),se=o("p"),this.h()},l(e){const t=yt("svelte-u9bgzb",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(a),ne=n(e),ae=i(e,"P",{}),le(ae).forEach(a),oe=n(e),c(k.$$.fragment,e),ie=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-v9imqp"&&(I.innerHTML=Ve),re=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1cv0g2h"&&(v.textContent=Ne),de=n(e),_=i(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1lzxsuu"&&(_.innerHTML=Ee),pe=n(e),c($.$$.fragment,e),ce=n(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-gu1tts"&&(U.innerHTML=Se),ue=n(e),q=i(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1381vj"&&(q.innerHTML=De),he=n(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-v88ugk"&&(Z.textContent=Pe),me=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-cn9wsj"&&(G.textContent=Ae),ge=n(e),c(x.$$.fragment,e),fe=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-5wcoi"&&(C.textContent=Ke),ye=n(e),J=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-mid65z"&&(J.innerHTML=Oe),we=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1fzeef2"&&(X.innerHTML=et),Je=n(e),c(F.$$.fragment,e),Te=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-6bx3hw"&&(R.innerHTML=tt),be=n(e),c(W.$$.fragment,e),Me=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ai9qzj"&&(H.innerHTML=at),je=n(e),c(L.$$.fragment,e),ke=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-c9ukhj"&&(Y.innerHTML=st),Ie=n(e),c(B.$$.fragment,e),ve=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-c4isg3"&&(z.innerHTML=lt),_e=n(e),T=i(e,"UL",{});var Ce=le(T);f=i(Ce,"LI",{});var b=le(f);K=i(b,"P",{"data-svelte-h":!0}),r(K)!=="svelte-bljgup"&&(K.innerHTML=nt),Fe=n(b),c(Q.$$.fragment,b),Re=n(b),O=i(b,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1putuge"&&(O.innerHTML=ot),We=n(b),c(V.$$.fragment,b),b.forEach(a),He=n(Ce),y=i(Ce,"LI",{});var M=le(y);ee=i(M,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-c9etiq"&&(ee.innerHTML=it),Le=n(M),c(N.$$.fragment,M),Ye=n(M),te=i(M,"P",{"data-svelte-h":!0}),r(te)!=="svelte-de658k"&&(te.innerHTML=rt),Be=n(M),c(E.$$.fragment,M),M.forEach(a),Ce.forEach(a),$e=n(e),c(S.$$.fragment,e),Ue=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1o9me9i"&&(D.textContent=dt),qe=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-cqv4z9"&&(P.innerHTML=pt),Ze=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-uhu1ny"&&(A.textContent=ct),Ge=n(e),se=i(e,"P",{}),le(se).forEach(a),this.h()},h(){ze(w,"name","hf:doc:metadata"),ze(w,"content",Tt),ze(J,"class","flex justify-center")},m(e,t){d(document.head,w),s(e,ne,t),s(e,ae,t),s(e,oe,t),u(k,e,t),s(e,ie,t),s(e,I,t),s(e,re,t),s(e,v,t),s(e,de,t),s(e,_,t),s(e,pe,t),u($,e,t),s(e,ce,t),s(e,U,t),s(e,ue,t),s(e,q,t),s(e,he,t),s(e,Z,t),s(e,me,t),s(e,G,t),s(e,ge,t),u(x,e,t),s(e,fe,t),s(e,C,t),s(e,ye,t),s(e,J,t),s(e,we,t),s(e,X,t),s(e,Je,t),u(F,e,t),s(e,Te,t),s(e,R,t),s(e,be,t),u(W,e,t),s(e,Me,t),s(e,H,t),s(e,je,t),u(L,e,t),s(e,ke,t),s(e,Y,t),s(e,Ie,t),u(B,e,t),s(e,ve,t),s(e,z,t),s(e,_e,t),s(e,T,t),d(T,f),d(f,K),d(f,Fe),u(Q,f,null),d(f,Re),d(f,O),d(f,We),u(V,f,null),d(T,He),d(T,y),d(y,ee),d(y,Le),u(N,y,null),d(y,Ye),d(y,te),d(y,Be),u(E,y,null),s(e,$e,t),u(S,e,t),s(e,Ue,t),s(e,D,t),s(e,qe,t),s(e,P,t),s(e,Ze,t),s(e,A,t),s(e,Ge,t),s(e,se,t),xe=!0},p:ht,i(e){xe||(h(k.$$.fragment,e),h($.$$.fragment,e),h(x.$$.fragment,e),h(F.$$.fragment,e),h(W.$$.fragment,e),h(L.$$.fragment,e),h(B.$$.fragment,e),h(Q.$$.fragment,e),h(V.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),xe=!0)},o(e){m(k.$$.fragment,e),m($.$$.fragment,e),m(x.$$.fragment,e),m(F.$$.fragment,e),m(W.$$.fragment,e),m(L.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(S.$$.fragment,e),xe=!1},d(e){e&&(a(ne),a(ae),a(oe),a(ie),a(I),a(re),a(v),a(de),a(_),a(pe),a(ce),a(U),a(ue),a(q),a(he),a(Z),a(me),a(G),a(ge),a(fe),a(C),a(ye),a(J),a(we),a(X),a(Je),a(Te),a(R),a(be),a(Me),a(H),a(je),a(ke),a(Y),a(Ie),a(ve),a(z),a(_e),a(T),a($e),a(Ue),a(D),a(qe),a(P),a(Ze),a(A),a(Ge),a(se)),a(w),g(k,e),g($,e),g(x,e),g(F,e),g(W,e),g(L,e),g(B,e),g(Q),g(V),g(N),g(E),g(S,e)}}}const Tt='{"title":"Create a dataset","local":"create-a-dataset","sections":[{"title":"Folder-based builders","local":"folder-based-builders","sections":[],"depth":2},{"title":"From local files","local":"from-local-files","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function bt(Qe){return mt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=wt}),[]}class vt extends gt{constructor(w){super(),ft(this,w,bt,Jt,ut,{})}}export{vt as component};
