import{s as xs,o as Fs,n as ls}from"../chunks/scheduler.bdbef820.js";import{S as Ss,i as Ys,g as n,s as a,r as y,A as Qs,h as i,f as s,c as M,j as zs,u as T,x as J,k as _l,y as Hs,a as e,v as p,d as w,t as d,w as r}from"../chunks/index.c0aea24a.js";import{H as c,g as Ws}from"../chunks/Heading.0e005771.js";import{T as Kt}from"../chunks/Tip.31005f7d.js";import{C as U}from"../chunks/CodeBlock.6ccca92e.js";function Ls(h){let o,u=`The dataset script is likely not needed if your dataset is in one of the following formats: CSV, JSON, JSON lines, text or Parquet.
With those formats, you should be able to load your dataset automatically with <a href="/docs/datasets/v2.14.6/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>,
as long as your dataset repository has a <a href="./repository_structure">required structure</a>.`;return{c(){o=n("p"),o.innerHTML=u},l(j){o=i(j,"P",{"data-svelte-h":!0}),J(o)!=="svelte-2n2qvh"&&(o.innerHTML=u)},m(j,I){e(j,o,I)},p:ls,d(j){j&&s(o)}}}function Ds(h){let o,u='To help you get started, try beginning with the dataset loading script <a href="https://github.com/huggingface/datasets/blob/main/templates/new_dataset_script.py" rel="nofollow">template</a>!';return{c(){o=n("p"),o.innerHTML=u},l(j){o=i(j,"P",{"data-svelte-h":!0}),J(o)!=="svelte-1ews9ox"&&(o.innerHTML=u)},m(j,I){e(j,o,I)},p:ls,d(j){j&&s(o)}}}function Ps(h){let o,u="Only use a default configuration when it makes sense. Don’t set one because it may be more convenient for the user to not specify a configuration when they load your dataset. For example, multi-lingual datasets often have a separate configuration for each language. An appropriate default may be an aggregated configuration that loads all the languages of the dataset if the user doesn’t request a particular one.";return{c(){o=n("p"),o.textContent=u},l(j){o=i(j,"P",{"data-svelte-h":!0}),J(o)!=="svelte-1h3crem"&&(o.textContent=u)},m(j,I){e(j,o,I)},p:ls,d(j){j&&s(o)}}}function Os(h){let o,u="If the data files live in the same folder or repository of the dataset script, you can just pass the relative paths to the files instead of URLs.";return{c(){o=n("p"),o.textContent=u},l(j){o=i(j,"P",{"data-svelte-h":!0}),J(o)!=="svelte-1xoorbu"&&(o.textContent=u)},m(j,I){e(j,o,I)},p:ls,d(j){j&&s(o)}}}function Ks(h){let o,u,j,I,B,ql,m,vl,R,ts=`Write a dataset script to load and share datasets that consist of data files in unsupported formats or require more complex data preparation.
This is a more advanced way to define a dataset than using <a href="./repository_structure#define-your-splits-in-yaml">YAML metadata in the dataset card</a>.
A dataset script is a Python file that defines the different configurations and splits of your dataset, as well as how to download and process the data.`,Nl,$,ss="The script can download data files from any website, or from the same dataset repository.",zl,V,es="A dataset loading script should have the same name as a dataset repository or directory. For example, a repository named <code>my_dataset</code> should contain <code>my_dataset.py</code> script. This way it can be loaded with:",xl,k,Fl,X,Sl,_,as="The following guide includes instructions for dataset scripts for how to:",Yl,E,Ms="<li>Add dataset metadata.</li> <li>Download data files.</li> <li>Generate samples.</li> <li>Generate dataset metadata.</li> <li>Upload a dataset to the Hub.</li>",Ql,q,ns='Open the <a href="https://huggingface.co/datasets/squad/blob/main/squad.py" rel="nofollow">SQuAD dataset loading script</a> template to follow along on how to share a dataset.',Hl,f,Wl,v,Ll,N,is="The first step is to add some information, or attributes, about your dataset in <code>DatasetBuilder._info()</code>. The most important attributes you should specify are:",Dl,z,os='<li><p><code>DatasetInfo.description</code> provides a concise description of your dataset. The description informs the user what’s in the dataset, how it was collected, and how it can be used for a NLP task.</p></li> <li><p><code>DatasetInfo.features</code> defines the name and type of each column in your dataset. This will also provide the structure for each example, so it is possible to create nested subfields in a column if you want. Take a look at <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Features">Features</a> for a full list of feature types you can use.</p></li>',Pl,x,Ol,C,Js="<li><p><code>DatasetInfo.homepage</code> contains the URL to the dataset homepage so users can find more details about the dataset.</p></li> <li><p><code>DatasetInfo.citation</code> contains a BibTeX citation for the dataset.</p></li>",Kl,F,ys="After you’ve filled out all these fields in the template, it should look like the following example from the SQuAD loading script:",lt,S,tt,Y,st,Q,Ts='In some cases, your dataset may have multiple configurations. For example, the <a href="https://huggingface.co/datasets/super_glue" rel="nofollow">SuperGLUE</a> dataset is a collection of 5 datasets designed to evaluate language understanding tasks. 🤗 Datasets provides <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> which allows you to create different configurations for the user to select from.',et,H,ps='Let’s study the <a href="https://huggingface.co/datasets/super_glue/blob/main/super_glue.py" rel="nofollow">SuperGLUE loading script</a> to see how you can define several configurations.',at,W,ws='<li>Create a <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass with attributes about your dataset. These attributes can be the features of your dataset, label classes, and a URL to the data files.</li>',Mt,L,nt,A,ds="<li>Create instances of your config to specify the values of the attributes of each configuration. This gives you the flexibility to specify all the name and description of each configuration. These sub-class instances should be listed under <code>DatasetBuilder.BUILDER_CONFIGS</code>:</li>",it,D,ot,g,rs="<li>Now, users can load a specific configuration of the dataset with the configuration <code>name</code>:</li>",Jt,P,yt,O,js='Additionally, users can instantiate a custom builder configuration by passing the builder configuration arguments to <a href="/docs/datasets/v2.14.6/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',Tt,K,pt,ll,wt,tl,Us="Users must specify a configuration name when they load a dataset with multiple configurations. Otherwise, 🤗 Datasets will raise a <code>ValueError</code>, and prompt the user to select a configuration name. You can avoid this by setting a default dataset configuration with the <code>DEFAULT_CONFIG_NAME</code> attribute:",dt,sl,rt,b,jt,el,Ut,al,us="After you’ve defined the attributes of your dataset, the next step is to download the data files and organize them according to their splits.",ut,Ml,Is="<li>Create a dictionary of URLs in the loading script that point to the original SQuAD data files:</li>",It,nl,ct,G,ht,Z,cs='<li><p><a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.DownloadManager.download_and_extract">DownloadManager.download_and_extract()</a> takes this dictionary and downloads the data files. Once the files are downloaded, use <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.SplitGenerator">SplitGenerator</a> to organize each split in the dataset. This is a simple class that contains:</p> <ul><li><p>The <code>name</code> of each split. You should use the standard split names: <code>Split.TRAIN</code>, <code>Split.TEST</code>, and <code>Split.VALIDATION</code>.</p></li> <li><p><code>gen_kwargs</code> provides the file paths to the data files to load for each split.</p></li></ul></li>',mt,il,hs="Your <code>DatasetBuilder._split_generator()</code> should look like this now:",ft,ol,Ct,Jl,At,yl,ms="At this point, you have:",gt,Tl,fs="<li>Added the dataset attributes.</li> <li>Provided instructions for how to download the data files.</li> <li>Organized the splits.</li>",bt,pl,Cs="The next step is to actually generate the samples in each split.",Gt,wl,As="<li><p><code>DatasetBuilder._generate_examples</code> takes the file path provided by <code>gen_kwargs</code> to read and parse the data files. You need to write a function that loads the data files and extracts the columns.</p></li> <li><p>Your function should yield a tuple of an <code>id_</code>, and an example from the dataset.</p></li>",Zt,dl,Bt,rl,Rt,jl,gs="Adding dataset metadata is a great way to include information about your dataset. The metadata is stored in the dataset card <code>README.md</code> in YAML. It includes information like the number of examples required to confirm the dataset was correctly generated, and information about the dataset like its <code>features</code>.",$t,Ul,bs="Run the following command to generate your dataset metadata in <code>README.md</code> and make sure your new dataset loading script works correctly:",Vt,ul,kt,Il,Gs="If your dataset loading script passed the test, you should now have a <code>README.md</code> file in your dataset folder containing a <code>dataset_info</code> field with some metadata.",Xt,cl,_t,hl,Zs='Once your script is ready, <a href="dataset_card">create a dataset card</a> and <a href="share">upload it to the Hub</a>.',Et,ml,Bs="Congratulations, you can now load your dataset from the Hub! 🥳",qt,fl,vt,Cl,Nt,Al,zt,gl,Rs=`If your dataset is made of many big files, 🤗 Datasets automatically runs your script in parallel to make it super fast!
It can help if you have hundreds or thousands of TAR archives, or JSONL files like <a href="https://huggingface.co/datasets/oscar/blob/main/oscar.py" rel="nofollow">oscar</a> for example.`,xt,bl,$s=`To make it work, we consider lists of files in <code>gen_kwargs</code> to be shards.
Therefore 🤗 Datasets can automatically spawn several workers to run <code>_generate_examples</code> in parallel, and each worker is given a subset of shards to process.`,Ft,Gl,St,Zl,Vs="Users can also specify <code>num_proc=</code> in <code>load_dataset()</code> to specify the number of processes to use as workers.",Yt,Bl,Qt,Rl,ks=`For some datasets it can be much faster to yield batches of data rather than examples one by one.
You can speed up the dataset generation by yielding Arrow tables directly, instead of examples.
This is especially useful if your data comes from Pandas DataFrames for example, since the conversion from Pandas to Arrow is as simple as:`,Ht,$l,Wt,Vl,Xs='To yield Arrow tables instead of single examples, make your dataset builder inherit from <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.ArrowBasedBuilder">ArrowBasedBuilder</a> instead of <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.GeneratorBasedBuilder">GeneratorBasedBuilder</a>, and use <code>_generate_tables</code> instead of <code>_generate_examples</code>:',Lt,kl,Dt,Xl,_s="Don’t forget to keep your script memory efficient, in case users run them on machines with a low amount of RAM.",Pt,El,Ot;return B=new c({props:{title:"Create a dataset loading script",local:"create-a-dataset-loading-script",headingTag:"h1"}}),m=new Kt({props:{$$slots:{default:[Ls]},$$scope:{ctx:h}}}),k=new U({props:{code:"bXlfZGF0YXNldCUyRiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMFJFQURNRS5tZCUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG15X2RhdGFzZXQucHk=",highlighted:`my<span class="hljs-emphasis">_dataset/
├── README.md
└── my_</span>dataset.py`,wrap:!1}}),X=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBbG9hZF9kYXRhc2V0KCUyMnBhdGglMkZ0byUyRm15X2RhdGFzZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dataset(<span class="hljs-string">&quot;path/to/my_dataset&quot;</span>)`,wrap:!1}}),f=new Kt({props:{$$slots:{default:[Ds]},$$scope:{ctx:h}}}),v=new c({props:{title:"Add dataset attributes",local:"add-dataset-attributes",headingTag:"h2"}}),x=new U({props:{code:"ZGF0YXNldHMuRmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwZGF0YXNldHMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJfc3RhcnQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJpbnQzMiUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`datasets.Features(
    {
        <span class="hljs-string">&quot;id&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;title&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;context&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;question&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
        <span class="hljs-string">&quot;answers&quot;</span>: datasets.<span class="hljs-type">Sequence</span>(
            {
                <span class="hljs-string">&quot;text&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;answer_start&quot;</span>: datasets.Value(<span class="hljs-string">&quot;int32&quot;</span>),
            }
        ),
    }
)`,wrap:!1}}),S=new U({props:{code:"ZGVmJTIwX2luZm8oc2VsZiklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhc2V0cy5EYXRhc2V0SW5mbyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRF9ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEZGF0YXNldHMuRmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaWQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGl0bGUlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJzdHJpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhbnN3ZXJzJTIyJTNBJTIwZGF0YXNldHMuZmVhdHVyZXMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydGV4dCUyMiUzQSUyMGRhdGFzZXRzLlZhbHVlKCUyMnN0cmluZyUyMiklMkMlMjAlMjJhbnN3ZXJfc3RhcnQlMjIlM0ElMjBkYXRhc2V0cy5WYWx1ZSglMjJpbnQzMiUyMiklMkMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vJTIwZGVmYXVsdCUyMHN1cGVydmlzZWRfa2V5cyUyMChhcyUyMHdlJTIwaGF2ZSUyMHRvJTIwcGFzcyUyMGJvdGglMjBxdWVzdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGFuZCUyMGNvbnRleHQlMjBhcyUyMGlucHV0KS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcnZpc2VkX2tleXMlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaG9tZXBhZ2UlM0QlMjJodHRwcyUzQSUyRiUyRnJhanB1cmthci5naXRodWIuaW8lMkZTUXVBRC1leHBsb3JlciUyRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNpdGF0aW9uJTNEX0NJVEFUSU9OJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_info</span>(<span class="hljs-params">self</span>):
    <span class="hljs-keyword">return</span> datasets.DatasetInfo(
        description=_DESCRIPTION,
        features=datasets.Features(
            {
                <span class="hljs-string">&quot;id&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;title&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;context&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;question&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>),
                <span class="hljs-string">&quot;answers&quot;</span>: datasets.features.<span class="hljs-type">Sequence</span>(
                    {<span class="hljs-string">&quot;text&quot;</span>: datasets.Value(<span class="hljs-string">&quot;string&quot;</span>), <span class="hljs-string">&quot;answer_start&quot;</span>: datasets.Value(<span class="hljs-string">&quot;int32&quot;</span>),}
                ),
            }
        ),
        <span class="hljs-comment"># No default supervised_keys (as we have to pass both question</span>
        <span class="hljs-comment"># and context as input).</span>
        supervised_keys=<span class="hljs-literal">None</span>,
        homepage=<span class="hljs-string">&quot;https://rajpurkar.github.io/SQuAD-explorer/&quot;</span>,
        citation=_CITATION,
    )`,wrap:!1}}),Y=new c({props:{title:"Multiple configurations",local:"multiple-configurations",headingTag:"h3"}}),L=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperGlueConfig</span>(datasets.BuilderConfig):
    <span class="hljs-string">&quot;&quot;&quot;BuilderConfig for SuperGLUE.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, features, data_url, citation, url, label_classes=(<span class="hljs-params"><span class="hljs-string">&quot;False&quot;</span>, <span class="hljs-string">&quot;True&quot;</span></span>), **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;BuilderConfig for SuperGLUE.

        Args:
        features: *list[string]*, list of the features that will appear in the
            feature dict. Should not include &quot;label&quot;.
        data_url: *string*, url to download the zip file from.
        citation: *string*, citation for the data set.
        url: *string*, url for information about the data set.
        label_classes: *list[string]*, the list of classes for the label if the
            label is present as a string. Non-string labels will be cast to either
            &#x27;False&#x27; or &#x27;True&#x27;.
        **kwargs: keyword arguments forwarded to super.
        &quot;&quot;&quot;</span>
        <span class="hljs-comment"># Version history:</span>
        <span class="hljs-comment"># 1.0.2: Fixed non-nondeterminism in ReCoRD.</span>
        <span class="hljs-comment"># 1.0.1: Change from the pre-release trial version of SuperGLUE (v1.9) to</span>
        <span class="hljs-comment">#        the full release (v2.0).</span>
        <span class="hljs-comment"># 1.0.0: S3 (new shuffling, sharding and slicing mechanism).</span>
        <span class="hljs-comment"># 0.0.2: Initial version.</span>
        <span class="hljs-built_in">super</span>().__init__(version=datasets.Version(<span class="hljs-string">&quot;1.0.2&quot;</span>), **kwargs)
        self.features = features
        self.label_classes = label_classes
        self.data_url = data_url
        self.citation = citation
        self.url = url`,wrap:!1}}),D=new U({props:{code:"Y2xhc3MlMjBTdXBlckdsdWUoZGF0YXNldHMuR2VuZXJhdG9yQmFzZWRCdWlsZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoZSUyMFN1cGVyR0xVRSUyMGJlbmNobWFyay4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBCVUlMREVSX0NPTkZJR19DTEFTUyUyMCUzRCUyMFN1cGVyR2x1ZUNvbmZpZyUwQSUwQSUyMCUyMCUyMCUyMEJVSUxERVJfQ09ORklHUyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFN1cGVyR2x1ZUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNEJTIyYm9vbHElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRF9CT09MUV9ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEJTVCJTIycXVlc3Rpb24lMjIlMkMlMjAlMjJwYXNzYWdlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmRsLmZiYWlwdWJsaWNmaWxlcy5jb20lMkZnbHVlJTJGc3VwZXJnbHVlJTJGZGF0YSUyRnYyJTJGQm9vbFEuemlwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2l0YXRpb24lM0RfQk9PTFFfQ0lUQVRJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZnb29nbGUtcmVzZWFyY2gtZGF0YXNldHMlMkZib29sZWFuLXF1ZXN0aW9ucyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTdXBlckdsdWVDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmF4ZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEX0FYR19ERVNDUklQVElPTiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNEJTVCJTIycHJlbWlzZSUyMiUyQyUyMCUyMmh5cG90aGVzaXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbF9jbGFzc2VzJTNEJTVCJTIyZW50YWlsbWVudCUyMiUyQyUyMCUyMm5vdF9lbnRhaWxtZW50JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YV91cmwlM0QlMjJodHRwcyUzQSUyRiUyRmRsLmZiYWlwdWJsaWNmaWxlcy5jb20lMkZnbHVlJTJGc3VwZXJnbHVlJTJGZGF0YSUyRnYyJTJGQVgtZy56aXAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaXRhdGlvbiUzRF9BWEdfQ0lUQVRJT04lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1cmwlM0QlMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZydWRpbmdlciUyRndpbm9nZW5kZXItc2NoZW1hcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkM=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperGlue</span>(datasets.GeneratorBasedBuilder):
    <span class="hljs-string">&quot;&quot;&quot;The SuperGLUE benchmark.&quot;&quot;&quot;</span>

    BUILDER_CONFIG_CLASS = SuperGlueConfig

    BUILDER_CONFIGS = [
        SuperGlueConfig(
            name=<span class="hljs-string">&quot;boolq&quot;</span>,
            description=_BOOLQ_DESCRIPTION,
            features=[<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;passage&quot;</span>],
            data_url=<span class="hljs-string">&quot;https://dl.fbaipublicfiles.com/glue/superglue/data/v2/BoolQ.zip&quot;</span>,
            citation=_BOOLQ_CITATION,
            url=<span class="hljs-string">&quot;https://github.com/google-research-datasets/boolean-questions&quot;</span>,
        ),
        ...
        ...
        SuperGlueConfig(
            name=<span class="hljs-string">&quot;axg&quot;</span>,
            description=_AXG_DESCRIPTION,
            features=[<span class="hljs-string">&quot;premise&quot;</span>, <span class="hljs-string">&quot;hypothesis&quot;</span>],
            label_classes=[<span class="hljs-string">&quot;entailment&quot;</span>, <span class="hljs-string">&quot;not_entailment&quot;</span>],
            data_url=<span class="hljs-string">&quot;https://dl.fbaipublicfiles.com/glue/superglue/data/v2/AX-g.zip&quot;</span>,
            citation=_AXG_CITATION,
            url=<span class="hljs-string">&quot;https://github.com/rudinger/winogender-schemas&quot;</span>,
        ),`,wrap:!1}}),P=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnc3VwZXJfZ2x1ZSclMkMlMjAnYm9vbHEnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;super_glue&#x27;</span>, <span class="hljs-string">&#x27;boolq&#x27;</span>)`,wrap:!1}}),K=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnc3VwZXJfZ2x1ZSclMkMlMjBkYXRhX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGY3VzdG9tX3VybCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;super_glue&#x27;</span>, data_url=<span class="hljs-string">&quot;https://custom_url&quot;</span>)`,wrap:!1}}),ll=new c({props:{title:"Default configurations",local:"default-configurations",headingTag:"h3"}}),sl=new U({props:{code:"Y2xhc3MlMjBOZXdEYXRhc2V0KGRhdGFzZXRzLkdlbmVyYXRvckJhc2VkQnVpbGRlciklM0ElMEElMEFWRVJTSU9OJTIwJTNEJTIwZGF0YXNldHMuVmVyc2lvbiglMjIxLjEuMCUyMiklMEElMEFCVUlMREVSX0NPTkZJR1MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBkYXRhc2V0cy5CdWlsZGVyQ29uZmlnKG5hbWUlM0QlMjJmaXJzdF9kb21haW4lMjIlMkMlMjB2ZXJzaW9uJTNEVkVSU0lPTiUyQyUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMHBhcnQlMjBvZiUyMG15JTIwZGF0YXNldCUyMGNvdmVycyUyMGElMjBmaXJzdCUyMGRvbWFpbiUyMiklMkMlMEElMjAlMjAlMjAlMjBkYXRhc2V0cy5CdWlsZGVyQ29uZmlnKG5hbWUlM0QlMjJzZWNvbmRfZG9tYWluJTIyJTJDJTIwdmVyc2lvbiUzRFZFUlNJT04lMkMlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBwYXJ0JTIwb2YlMjBteSUyMGRhdGFzZXQlMjBjb3ZlcnMlMjBhJTIwc2Vjb25kJTIwZG9tYWluJTIyKSUyQyUwQSU1RCUwQSUwQURFRkFVTFRfQ09ORklHX05BTUUlMjAlM0QlMjAlMjJmaXJzdF9kb21haW4lMjI=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">NewDataset</span>(datasets.GeneratorBasedBuilder):

VERSION = datasets.Version(<span class="hljs-string">&quot;1.1.0&quot;</span>)

BUILDER_CONFIGS = [
    datasets.BuilderConfig(name=<span class="hljs-string">&quot;first_domain&quot;</span>, version=VERSION, description=<span class="hljs-string">&quot;This part of my dataset covers a first domain&quot;</span>),
    datasets.BuilderConfig(name=<span class="hljs-string">&quot;second_domain&quot;</span>, version=VERSION, description=<span class="hljs-string">&quot;This part of my dataset covers a second domain&quot;</span>),
]

DEFAULT_CONFIG_NAME = <span class="hljs-string">&quot;first_domain&quot;</span>`,wrap:!1}}),b=new Kt({props:{warning:!0,$$slots:{default:[Ps]},$$scope:{ctx:h}}}),el=new c({props:{title:"Download data files and organize splits",local:"download-data-files-and-organize-splits",headingTag:"h2"}}),nl=new U({props:{code:"X1VSTCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmFqcHVya2FyLmdpdGh1Yi5pbyUyRlNRdUFELWV4cGxvcmVyJTJGZGF0YXNldCUyRiUyMiUwQV9VUkxTJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIydHJhaW4lMjIlM0ElMjBfVVJMJTIwJTJCJTIwJTIydHJhaW4tdjEuMS5qc29uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGV2JTIyJTNBJTIwX1VSTCUyMCUyQiUyMCUyMmRldi12MS4xLmpzb24lMjIlMkMlMEElN0Q=",highlighted:`_URL = <span class="hljs-string">&quot;https://rajpurkar.github.io/SQuAD-explorer/dataset/&quot;</span>
_URLS = {
    <span class="hljs-string">&quot;train&quot;</span>: _URL + <span class="hljs-string">&quot;train-v1.1.json&quot;</span>,
    <span class="hljs-string">&quot;dev&quot;</span>: _URL + <span class="hljs-string">&quot;dev-v1.1.json&quot;</span>,
}`,wrap:!1}}),G=new Kt({props:{$$slots:{default:[Os]},$$scope:{ctx:h}}}),ol=new U({props:{code:"ZGVmJTIwX3NwbGl0X2dlbmVyYXRvcnMoc2VsZiUyQyUyMGRsX21hbmFnZXIlM0ElMjBkYXRhc2V0cy5Eb3dubG9hZE1hbmFnZXIpJTIwLSUzRSUyMExpc3QlNUJkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciU1RCUzQSUwQSUyMCUyMCUyMCUyMHVybHNfdG9fZG93bmxvYWQlMjAlM0QlMjBzZWxmLl9VUkxTJTBBJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWRfYW5kX2V4dHJhY3QodXJsc190b19kb3dubG9hZCklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0cy5TcGxpdEdlbmVyYXRvcihuYW1lJTNEZGF0YXNldHMuU3BsaXQuVFJBSU4lMkMlMjBnZW5fa3dhcmdzJTNEJTdCJTIyZmlsZXBhdGglMjIlM0ElMjBkb3dubG9hZGVkX2ZpbGVzJTVCJTIydHJhaW4lMjIlNUQlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IobmFtZSUzRGRhdGFzZXRzLlNwbGl0LlZBTElEQVRJT04lMkMlMjBnZW5fa3dhcmdzJTNEJTdCJTIyZmlsZXBhdGglMjIlM0ElMjBkb3dubG9hZGVkX2ZpbGVzJTVCJTIyZGV2JTIyJTVEJTdEKSUyQyUwQSUyMCUyMCUyMCUyMCU1RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_split_generators</span>(<span class="hljs-params">self, dl_manager: datasets.DownloadManager</span>) -&gt; <span class="hljs-type">List</span>[datasets.SplitGenerator]:
    urls_to_download = self._URLS
    downloaded_files = dl_manager.download_and_extract(urls_to_download)

    <span class="hljs-keyword">return</span> [
        datasets.SplitGenerator(name=datasets.Split.TRAIN, gen_kwargs={<span class="hljs-string">&quot;filepath&quot;</span>: downloaded_files[<span class="hljs-string">&quot;train&quot;</span>]}),
        datasets.SplitGenerator(name=datasets.Split.VALIDATION, gen_kwargs={<span class="hljs-string">&quot;filepath&quot;</span>: downloaded_files[<span class="hljs-string">&quot;dev&quot;</span>]}),
    ]`,wrap:!1}}),Jl=new c({props:{title:"Generate samples",local:"generate-samples",headingTag:"h2"}}),dl=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_examples</span>(<span class="hljs-params">self, filepath</span>):
    <span class="hljs-string">&quot;&quot;&quot;This function returns the examples in the raw (text) form.&quot;&quot;&quot;</span>
    logger.info(<span class="hljs-string">&quot;generating examples from = %s&quot;</span>, filepath)
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(filepath) <span class="hljs-keyword">as</span> f:
        squad = json.load(f)
        <span class="hljs-keyword">for</span> article <span class="hljs-keyword">in</span> squad[<span class="hljs-string">&quot;data&quot;</span>]:
            title = article.get(<span class="hljs-string">&quot;title&quot;</span>, <span class="hljs-string">&quot;&quot;</span>).strip()
            <span class="hljs-keyword">for</span> paragraph <span class="hljs-keyword">in</span> article[<span class="hljs-string">&quot;paragraphs&quot;</span>]:
                context = paragraph[<span class="hljs-string">&quot;context&quot;</span>].strip()
                <span class="hljs-keyword">for</span> qa <span class="hljs-keyword">in</span> paragraph[<span class="hljs-string">&quot;qas&quot;</span>]:
                    question = qa[<span class="hljs-string">&quot;question&quot;</span>].strip()
                    id_ = qa[<span class="hljs-string">&quot;id&quot;</span>]

                    answer_starts = [answer[<span class="hljs-string">&quot;answer_start&quot;</span>] <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> qa[<span class="hljs-string">&quot;answers&quot;</span>]]
                    answers = [answer[<span class="hljs-string">&quot;text&quot;</span>].strip() <span class="hljs-keyword">for</span> answer <span class="hljs-keyword">in</span> qa[<span class="hljs-string">&quot;answers&quot;</span>]]

                    <span class="hljs-comment"># Features currently used are &quot;context&quot;, &quot;question&quot;, and &quot;answers&quot;.</span>
                    <span class="hljs-comment"># Others are extracted here for the ease of future expansions.</span>
                    <span class="hljs-keyword">yield</span> id_, {
                        <span class="hljs-string">&quot;title&quot;</span>: title,
                        <span class="hljs-string">&quot;context&quot;</span>: context,
                        <span class="hljs-string">&quot;question&quot;</span>: question,
                        <span class="hljs-string">&quot;id&quot;</span>: id_,
                        <span class="hljs-string">&quot;answers&quot;</span>: {<span class="hljs-string">&quot;answer_start&quot;</span>: answer_starts, <span class="hljs-string">&quot;text&quot;</span>: answers,},
                    }`,wrap:!1}}),rl=new c({props:{title:"(Optional) Generate dataset metadata",local:"optional-generate-dataset-metadata",headingTag:"h2"}}),ul=new U({props:{code:"ZGF0YXNldHMtY2xpJTIwdGVzdCUyMHBhdGglMkZ0byUyRiUzQ3lvdXItZGF0YXNldC1sb2FkaW5nLXNjcmlwdCUzRSUyMC0tc2F2ZV9pbmZvJTIwLS1hbGxfY29uZmlncw==",highlighted:'datasets-cli test path/<span class="hljs-keyword">to</span>/&lt;your-dataset-loading-<span class="hljs-keyword">script</span>&gt; <span class="hljs-comment">--save_info --all_configs</span>',wrap:!1}}),cl=new c({props:{title:"Upload to the Hub",local:"upload-to-the-hub",headingTag:"h2"}}),fl=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBbG9hZF9kYXRhc2V0KCUyMiUzQ3VzZXJuYW1lJTNFJTJGbXlfZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>load_dataset(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>)`,wrap:!1}}),Cl=new c({props:{title:"Advanced features",local:"advanced-features",headingTag:"h2"}}),Al=new c({props:{title:"Sharding",local:"sharding",headingTag:"h3"}}),Gl=new U({props:{code:"JTBBY2xhc3MlMjBNeVNoYXJkZWREYXRhc2V0KGRhdGFzZXRzLkdlbmVyYXRvckJhc2VkQnVpbGRlciklM0ElMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc3BsaXRfZ2VuZXJhdG9ycyhzZWxmJTJDJTIwZGxfbWFuYWdlciUzQSUyMGRhdGFzZXRzLkRvd25sb2FkTWFuYWdlciklMjAtJTNFJTIwTGlzdCU1QmRhdGFzZXRzLlNwbGl0R2VuZXJhdG9yJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJTVCZiUyMmRhdGElMkZzaGFyZF8lN0JpJTdELmpzb25sJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAyNCklNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IobmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTIwZ2VuX2t3YXJncyUzRCU3QiUyMmZpbGVwYXRocyUyMiUzQSUyMGRvd25sb2FkZWRfZmlsZXMlN0QpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2dlbmVyYXRlX2V4YW1wbGVzKHNlbGYlMkMlMjBmaWxlcGF0aHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRWFjaCUyMHdvcmtlciUyMGNhbiUyMGJlJTIwZ2l2ZW4lMjBhJTIwc2xpY2UlMjBvZiUyMHRoZSUyMG9yaWdpbmFsJTIwJTYwZmlsZXBhdGhzJTYwJTIwbGlzdCUyMGRlZmluZWQlMjBpbiUyMHRoZSUyMCU2MGdlbl9rd2FyZ3MlNjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBzbyUyMHRoYXQlMjB0aGlzJTIwY29kZSUyMGNhbiUyMHJ1biUyMGluJTIwcGFyYWxsZWwlMjBvbiUyMHNldmVyYWwlMjBzaGFyZHMlMjBhdCUyMHRoZSUyMHNhbWUlMjB0aW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwZmlsZXBhdGglMjBpbiUyMGZpbGVwYXRocyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyShardedDataset</span>(datasets.GeneratorBasedBuilder):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_split_generators</span>(<span class="hljs-params">self, dl_manager: datasets.DownloadManager</span>) -&gt; <span class="hljs-type">List</span>[datasets.SplitGenerator]:
        downloaded_files = dl_manager.download([<span class="hljs-string">f&quot;data/shard_<span class="hljs-subst">{i}</span>.jsonl&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)])
        <span class="hljs-keyword">return</span> [
            datasets.SplitGenerator(name=datasets.Split.TRAIN, gen_kwargs={<span class="hljs-string">&quot;filepaths&quot;</span>: downloaded_files}),
        ]

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_examples</span>(<span class="hljs-params">self, filepaths</span>):
        <span class="hljs-comment"># Each worker can be given a slice of the original \`filepaths\` list defined in the \`gen_kwargs\`</span>
        <span class="hljs-comment"># so that this code can run in parallel on several shards at the same time</span>
        <span class="hljs-keyword">for</span> filepath <span class="hljs-keyword">in</span> filepaths:
            ...`,wrap:!1}}),Bl=new c({props:{title:"ArrowBasedBuilder",local:"arrowbasedbuilder",headingTag:"h3"}}),$l=new U({props:{code:"aW1wb3J0JTIwcHlhcnJvdyUyMGFzJTIwcGElMEFwYV90YWJsZSUyMCUzRCUyMHBhLlRhYmxlLmZyb21fcGFuZGFzKGRmKQ==",highlighted:`<span class="hljs-keyword">import</span> pyarrow <span class="hljs-keyword">as</span> pa
pa_table = pa.Table.from_pandas(df)`,wrap:!1}}),kl=new U({props:{code:"Y2xhc3MlMjBNeVN1cGVyRmFzdERhdGFzZXQoZGF0YXNldHMuQXJyb3dCYXNlZEJ1aWxkZXIpJTNBJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX2dlbmVyYXRlX3RhYmxlcyhzZWxmJTJDJTIwZmlsZXBhdGhzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkeCUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBmaWxlcGF0aCUyMGluJTIwZmlsZXBhdGhzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBpZHglMkMlMjBwYV90YWJsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkeCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MySuperFastDataset</span>(datasets.ArrowBasedBuilder):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_tables</span>(<span class="hljs-params">self, filepaths</span>):
        idx = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> filepath <span class="hljs-keyword">in</span> filepaths:
            ...
            <span class="hljs-keyword">yield</span> idx, pa_table
            idx += <span class="hljs-number">1</span>`,wrap:!1}}),{c(){o=n("meta"),u=a(),j=n("p"),I=a(),y(B.$$.fragment),ql=a(),y(m.$$.fragment),vl=a(),R=n("p"),R.innerHTML=ts,Nl=a(),$=n("p"),$.textContent=ss,zl=a(),V=n("p"),V.innerHTML=es,xl=a(),y(k.$$.fragment),Fl=a(),y(X.$$.fragment),Sl=a(),_=n("p"),_.textContent=as,Yl=a(),E=n("ul"),E.innerHTML=Ms,Ql=a(),q=n("p"),q.innerHTML=ns,Hl=a(),y(f.$$.fragment),Wl=a(),y(v.$$.fragment),Ll=a(),N=n("p"),N.innerHTML=is,Dl=a(),z=n("ol"),z.innerHTML=os,Pl=a(),y(x.$$.fragment),Ol=a(),C=n("ol"),C.innerHTML=Js,Kl=a(),F=n("p"),F.textContent=ys,lt=a(),y(S.$$.fragment),tt=a(),y(Y.$$.fragment),st=a(),Q=n("p"),Q.innerHTML=Ts,et=a(),H=n("p"),H.innerHTML=ps,at=a(),W=n("ol"),W.innerHTML=ws,Mt=a(),y(L.$$.fragment),nt=a(),A=n("ol"),A.innerHTML=ds,it=a(),y(D.$$.fragment),ot=a(),g=n("ol"),g.innerHTML=rs,Jt=a(),y(P.$$.fragment),yt=a(),O=n("p"),O.innerHTML=js,Tt=a(),y(K.$$.fragment),pt=a(),y(ll.$$.fragment),wt=a(),tl=n("p"),tl.innerHTML=Us,dt=a(),y(sl.$$.fragment),rt=a(),y(b.$$.fragment),jt=a(),y(el.$$.fragment),Ut=a(),al=n("p"),al.textContent=us,ut=a(),Ml=n("ol"),Ml.innerHTML=Is,It=a(),y(nl.$$.fragment),ct=a(),y(G.$$.fragment),ht=a(),Z=n("ol"),Z.innerHTML=cs,mt=a(),il=n("p"),il.innerHTML=hs,ft=a(),y(ol.$$.fragment),Ct=a(),y(Jl.$$.fragment),At=a(),yl=n("p"),yl.textContent=ms,gt=a(),Tl=n("ul"),Tl.innerHTML=fs,bt=a(),pl=n("p"),pl.textContent=Cs,Gt=a(),wl=n("ol"),wl.innerHTML=As,Zt=a(),y(dl.$$.fragment),Bt=a(),y(rl.$$.fragment),Rt=a(),jl=n("p"),jl.innerHTML=gs,$t=a(),Ul=n("p"),Ul.innerHTML=bs,Vt=a(),y(ul.$$.fragment),kt=a(),Il=n("p"),Il.innerHTML=Gs,Xt=a(),y(cl.$$.fragment),_t=a(),hl=n("p"),hl.innerHTML=Zs,Et=a(),ml=n("p"),ml.textContent=Bs,qt=a(),y(fl.$$.fragment),vt=a(),y(Cl.$$.fragment),Nt=a(),y(Al.$$.fragment),zt=a(),gl=n("p"),gl.innerHTML=Rs,xt=a(),bl=n("p"),bl.innerHTML=$s,Ft=a(),y(Gl.$$.fragment),St=a(),Zl=n("p"),Zl.innerHTML=Vs,Yt=a(),y(Bl.$$.fragment),Qt=a(),Rl=n("p"),Rl.textContent=ks,Ht=a(),y($l.$$.fragment),Wt=a(),Vl=n("p"),Vl.innerHTML=Xs,Lt=a(),y(kl.$$.fragment),Dt=a(),Xl=n("p"),Xl.textContent=_s,Pt=a(),El=n("p"),this.h()},l(l){const t=Qs("svelte-u9bgzb",document.head);o=i(t,"META",{name:!0,content:!0}),t.forEach(s),u=M(l),j=i(l,"P",{}),zs(j).forEach(s),I=M(l),T(B.$$.fragment,l),ql=M(l),T(m.$$.fragment,l),vl=M(l),R=i(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1k7fcoj"&&(R.innerHTML=ts),Nl=M(l),$=i(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-gltuje"&&($.textContent=ss),zl=M(l),V=i(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1qit7w"&&(V.innerHTML=es),xl=M(l),T(k.$$.fragment,l),Fl=M(l),T(X.$$.fragment,l),Sl=M(l),_=i(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-mekosh"&&(_.textContent=as),Yl=M(l),E=i(l,"UL",{"data-svelte-h":!0}),J(E)!=="svelte-v28gob"&&(E.innerHTML=Ms),Ql=M(l),q=i(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-3izox6"&&(q.innerHTML=ns),Hl=M(l),T(f.$$.fragment,l),Wl=M(l),T(v.$$.fragment,l),Ll=M(l),N=i(l,"P",{"data-svelte-h":!0}),J(N)!=="svelte-1yjv3de"&&(N.innerHTML=is),Dl=M(l),z=i(l,"OL",{"data-svelte-h":!0}),J(z)!=="svelte-1voms9n"&&(z.innerHTML=os),Pl=M(l),T(x.$$.fragment,l),Ol=M(l),C=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(C)!=="svelte-1gzz03n"&&(C.innerHTML=Js),Kl=M(l),F=i(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-j8hcd0"&&(F.textContent=ys),lt=M(l),T(S.$$.fragment,l),tt=M(l),T(Y.$$.fragment,l),st=M(l),Q=i(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-1msjovm"&&(Q.innerHTML=Ts),et=M(l),H=i(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1wah8i0"&&(H.innerHTML=ps),at=M(l),W=i(l,"OL",{"data-svelte-h":!0}),J(W)!=="svelte-f1q4ux"&&(W.innerHTML=ws),Mt=M(l),T(L.$$.fragment,l),nt=M(l),A=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(A)!=="svelte-1hlknx7"&&(A.innerHTML=ds),it=M(l),T(D.$$.fragment,l),ot=M(l),g=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(g)!=="svelte-odp277"&&(g.innerHTML=rs),Jt=M(l),T(P.$$.fragment,l),yt=M(l),O=i(l,"P",{"data-svelte-h":!0}),J(O)!=="svelte-1rcgnh5"&&(O.innerHTML=js),Tt=M(l),T(K.$$.fragment,l),pt=M(l),T(ll.$$.fragment,l),wt=M(l),tl=i(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-19zng3q"&&(tl.innerHTML=Us),dt=M(l),T(sl.$$.fragment,l),rt=M(l),T(b.$$.fragment,l),jt=M(l),T(el.$$.fragment,l),Ut=M(l),al=i(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-jmz9cn"&&(al.textContent=us),ut=M(l),Ml=i(l,"OL",{"data-svelte-h":!0}),J(Ml)!=="svelte-1o1li8d"&&(Ml.innerHTML=Is),It=M(l),T(nl.$$.fragment,l),ct=M(l),T(G.$$.fragment,l),ht=M(l),Z=i(l,"OL",{start:!0,"data-svelte-h":!0}),J(Z)!=="svelte-1uvk8yv"&&(Z.innerHTML=cs),mt=M(l),il=i(l,"P",{"data-svelte-h":!0}),J(il)!=="svelte-leta0s"&&(il.innerHTML=hs),ft=M(l),T(ol.$$.fragment,l),Ct=M(l),T(Jl.$$.fragment,l),At=M(l),yl=i(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-1edtbpg"&&(yl.textContent=ms),gt=M(l),Tl=i(l,"UL",{"data-svelte-h":!0}),J(Tl)!=="svelte-1dze5ec"&&(Tl.innerHTML=fs),bt=M(l),pl=i(l,"P",{"data-svelte-h":!0}),J(pl)!=="svelte-atwoq9"&&(pl.textContent=Cs),Gt=M(l),wl=i(l,"OL",{"data-svelte-h":!0}),J(wl)!=="svelte-1euwcht"&&(wl.innerHTML=As),Zt=M(l),T(dl.$$.fragment,l),Bt=M(l),T(rl.$$.fragment,l),Rt=M(l),jl=i(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-pxkn08"&&(jl.innerHTML=gs),$t=M(l),Ul=i(l,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-10rffde"&&(Ul.innerHTML=bs),Vt=M(l),T(ul.$$.fragment,l),kt=M(l),Il=i(l,"P",{"data-svelte-h":!0}),J(Il)!=="svelte-1p203tz"&&(Il.innerHTML=Gs),Xt=M(l),T(cl.$$.fragment,l),_t=M(l),hl=i(l,"P",{"data-svelte-h":!0}),J(hl)!=="svelte-1oe26y1"&&(hl.innerHTML=Zs),Et=M(l),ml=i(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-1539djf"&&(ml.textContent=Bs),qt=M(l),T(fl.$$.fragment,l),vt=M(l),T(Cl.$$.fragment,l),Nt=M(l),T(Al.$$.fragment,l),zt=M(l),gl=i(l,"P",{"data-svelte-h":!0}),J(gl)!=="svelte-1sxj7ge"&&(gl.innerHTML=Rs),xt=M(l),bl=i(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-1abrkus"&&(bl.innerHTML=$s),Ft=M(l),T(Gl.$$.fragment,l),St=M(l),Zl=i(l,"P",{"data-svelte-h":!0}),J(Zl)!=="svelte-r6j4wy"&&(Zl.innerHTML=Vs),Yt=M(l),T(Bl.$$.fragment,l),Qt=M(l),Rl=i(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-1s4bc00"&&(Rl.textContent=ks),Ht=M(l),T($l.$$.fragment,l),Wt=M(l),Vl=i(l,"P",{"data-svelte-h":!0}),J(Vl)!=="svelte-mlbeg1"&&(Vl.innerHTML=Xs),Lt=M(l),T(kl.$$.fragment,l),Dt=M(l),Xl=i(l,"P",{"data-svelte-h":!0}),J(Xl)!=="svelte-15xk2c2"&&(Xl.textContent=_s),Pt=M(l),El=i(l,"P",{}),zs(El).forEach(s),this.h()},h(){_l(o,"name","hf:doc:metadata"),_l(o,"content",le),_l(C,"start","3"),_l(A,"start","2"),_l(g,"start","3"),_l(Z,"start","2")},m(l,t){Hs(document.head,o),e(l,u,t),e(l,j,t),e(l,I,t),p(B,l,t),e(l,ql,t),p(m,l,t),e(l,vl,t),e(l,R,t),e(l,Nl,t),e(l,$,t),e(l,zl,t),e(l,V,t),e(l,xl,t),p(k,l,t),e(l,Fl,t),p(X,l,t),e(l,Sl,t),e(l,_,t),e(l,Yl,t),e(l,E,t),e(l,Ql,t),e(l,q,t),e(l,Hl,t),p(f,l,t),e(l,Wl,t),p(v,l,t),e(l,Ll,t),e(l,N,t),e(l,Dl,t),e(l,z,t),e(l,Pl,t),p(x,l,t),e(l,Ol,t),e(l,C,t),e(l,Kl,t),e(l,F,t),e(l,lt,t),p(S,l,t),e(l,tt,t),p(Y,l,t),e(l,st,t),e(l,Q,t),e(l,et,t),e(l,H,t),e(l,at,t),e(l,W,t),e(l,Mt,t),p(L,l,t),e(l,nt,t),e(l,A,t),e(l,it,t),p(D,l,t),e(l,ot,t),e(l,g,t),e(l,Jt,t),p(P,l,t),e(l,yt,t),e(l,O,t),e(l,Tt,t),p(K,l,t),e(l,pt,t),p(ll,l,t),e(l,wt,t),e(l,tl,t),e(l,dt,t),p(sl,l,t),e(l,rt,t),p(b,l,t),e(l,jt,t),p(el,l,t),e(l,Ut,t),e(l,al,t),e(l,ut,t),e(l,Ml,t),e(l,It,t),p(nl,l,t),e(l,ct,t),p(G,l,t),e(l,ht,t),e(l,Z,t),e(l,mt,t),e(l,il,t),e(l,ft,t),p(ol,l,t),e(l,Ct,t),p(Jl,l,t),e(l,At,t),e(l,yl,t),e(l,gt,t),e(l,Tl,t),e(l,bt,t),e(l,pl,t),e(l,Gt,t),e(l,wl,t),e(l,Zt,t),p(dl,l,t),e(l,Bt,t),p(rl,l,t),e(l,Rt,t),e(l,jl,t),e(l,$t,t),e(l,Ul,t),e(l,Vt,t),p(ul,l,t),e(l,kt,t),e(l,Il,t),e(l,Xt,t),p(cl,l,t),e(l,_t,t),e(l,hl,t),e(l,Et,t),e(l,ml,t),e(l,qt,t),p(fl,l,t),e(l,vt,t),p(Cl,l,t),e(l,Nt,t),p(Al,l,t),e(l,zt,t),e(l,gl,t),e(l,xt,t),e(l,bl,t),e(l,Ft,t),p(Gl,l,t),e(l,St,t),e(l,Zl,t),e(l,Yt,t),p(Bl,l,t),e(l,Qt,t),e(l,Rl,t),e(l,Ht,t),p($l,l,t),e(l,Wt,t),e(l,Vl,t),e(l,Lt,t),p(kl,l,t),e(l,Dt,t),e(l,Xl,t),e(l,Pt,t),e(l,El,t),Ot=!0},p(l,[t]){const Es={};t&2&&(Es.$$scope={dirty:t,ctx:l}),m.$set(Es);const qs={};t&2&&(qs.$$scope={dirty:t,ctx:l}),f.$set(qs);const vs={};t&2&&(vs.$$scope={dirty:t,ctx:l}),b.$set(vs);const Ns={};t&2&&(Ns.$$scope={dirty:t,ctx:l}),G.$set(Ns)},i(l){Ot||(w(B.$$.fragment,l),w(m.$$.fragment,l),w(k.$$.fragment,l),w(X.$$.fragment,l),w(f.$$.fragment,l),w(v.$$.fragment,l),w(x.$$.fragment,l),w(S.$$.fragment,l),w(Y.$$.fragment,l),w(L.$$.fragment,l),w(D.$$.fragment,l),w(P.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(sl.$$.fragment,l),w(b.$$.fragment,l),w(el.$$.fragment,l),w(nl.$$.fragment,l),w(G.$$.fragment,l),w(ol.$$.fragment,l),w(Jl.$$.fragment,l),w(dl.$$.fragment,l),w(rl.$$.fragment,l),w(ul.$$.fragment,l),w(cl.$$.fragment,l),w(fl.$$.fragment,l),w(Cl.$$.fragment,l),w(Al.$$.fragment,l),w(Gl.$$.fragment,l),w(Bl.$$.fragment,l),w($l.$$.fragment,l),w(kl.$$.fragment,l),Ot=!0)},o(l){d(B.$$.fragment,l),d(m.$$.fragment,l),d(k.$$.fragment,l),d(X.$$.fragment,l),d(f.$$.fragment,l),d(v.$$.fragment,l),d(x.$$.fragment,l),d(S.$$.fragment,l),d(Y.$$.fragment,l),d(L.$$.fragment,l),d(D.$$.fragment,l),d(P.$$.fragment,l),d(K.$$.fragment,l),d(ll.$$.fragment,l),d(sl.$$.fragment,l),d(b.$$.fragment,l),d(el.$$.fragment,l),d(nl.$$.fragment,l),d(G.$$.fragment,l),d(ol.$$.fragment,l),d(Jl.$$.fragment,l),d(dl.$$.fragment,l),d(rl.$$.fragment,l),d(ul.$$.fragment,l),d(cl.$$.fragment,l),d(fl.$$.fragment,l),d(Cl.$$.fragment,l),d(Al.$$.fragment,l),d(Gl.$$.fragment,l),d(Bl.$$.fragment,l),d($l.$$.fragment,l),d(kl.$$.fragment,l),Ot=!1},d(l){l&&(s(u),s(j),s(I),s(ql),s(vl),s(R),s(Nl),s($),s(zl),s(V),s(xl),s(Fl),s(Sl),s(_),s(Yl),s(E),s(Ql),s(q),s(Hl),s(Wl),s(Ll),s(N),s(Dl),s(z),s(Pl),s(Ol),s(C),s(Kl),s(F),s(lt),s(tt),s(st),s(Q),s(et),s(H),s(at),s(W),s(Mt),s(nt),s(A),s(it),s(ot),s(g),s(Jt),s(yt),s(O),s(Tt),s(pt),s(wt),s(tl),s(dt),s(rt),s(jt),s(Ut),s(al),s(ut),s(Ml),s(It),s(ct),s(ht),s(Z),s(mt),s(il),s(ft),s(Ct),s(At),s(yl),s(gt),s(Tl),s(bt),s(pl),s(Gt),s(wl),s(Zt),s(Bt),s(Rt),s(jl),s($t),s(Ul),s(Vt),s(kt),s(Il),s(Xt),s(_t),s(hl),s(Et),s(ml),s(qt),s(vt),s(Nt),s(zt),s(gl),s(xt),s(bl),s(Ft),s(St),s(Zl),s(Yt),s(Qt),s(Rl),s(Ht),s(Wt),s(Vl),s(Lt),s(Dt),s(Xl),s(Pt),s(El)),s(o),r(B,l),r(m,l),r(k,l),r(X,l),r(f,l),r(v,l),r(x,l),r(S,l),r(Y,l),r(L,l),r(D,l),r(P,l),r(K,l),r(ll,l),r(sl,l),r(b,l),r(el,l),r(nl,l),r(G,l),r(ol,l),r(Jl,l),r(dl,l),r(rl,l),r(ul,l),r(cl,l),r(fl,l),r(Cl,l),r(Al,l),r(Gl,l),r(Bl,l),r($l,l),r(kl,l)}}}const le='{"title":"Create a dataset loading script","local":"create-a-dataset-loading-script","sections":[{"title":"Add dataset attributes","local":"add-dataset-attributes","sections":[{"title":"Multiple configurations","local":"multiple-configurations","sections":[],"depth":3},{"title":"Default configurations","local":"default-configurations","sections":[],"depth":3}],"depth":2},{"title":"Download data files and organize splits","local":"download-data-files-and-organize-splits","sections":[],"depth":2},{"title":"Generate samples","local":"generate-samples","sections":[],"depth":2},{"title":"(Optional) Generate dataset metadata","local":"optional-generate-dataset-metadata","sections":[],"depth":2},{"title":"Upload to the Hub","local":"upload-to-the-hub","sections":[],"depth":2},{"title":"Advanced features","local":"advanced-features","sections":[{"title":"Sharding","local":"sharding","sections":[],"depth":3},{"title":"ArrowBasedBuilder","local":"arrowbasedbuilder","sections":[],"depth":3}],"depth":2}],"depth":1}';function te(h){return Fs(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Ws}),[]}class ie extends Ss{constructor(o){super(),Ys(this,o,te,Ks,xs,{})}}export{ie as component};
