import{s as as,n as es,o as ls}from"../chunks/scheduler.bdbef820.js";import{S as ns,i as is,g as p,s as l,r as b,A as ps,h as o,f as a,c as n,j as O,u as U,x as T,k as ss,y as os,a as e,v as J,d as $,t as k,w as C}from"../chunks/index.c0aea24a.js";import{H as S,g as rs}from"../chunks/Heading.0e005771.js";import{C as ts}from"../chunks/CodeBlock.6ccca92e.js";function ms(Y){let i,_,v,B,r,I,m,Q,c,V='<a href="https://arrow.apache.org/" rel="nofollow">Arrow</a> enables large amounts of data to be processed and moved quickly. It is a specific data format that stores data in a columnar memory layout. This provides several significant advantages:',W,M,F='<li>Arrow’s standard format allows <a href="https://en.wikipedia.org/wiki/Zero-copy" rel="nofollow">zero-copy reads</a> which removes virtually all serialization overhead.</li> <li>Arrow is language-agnostic so it supports different programming languages.</li> <li>Arrow is column-oriented so it is faster at querying and processing slices or columns of data.</li> <li>Arrow allows for copy-free hand-offs to standard machine learning tools such as NumPy, Pandas, PyTorch, and TensorFlow.</li> <li>Arrow supports many, possibly nested, column types.</li>',x,u,X,h,K=`🤗 Datasets uses Arrow for its local caching system. It allows datasets to be backed by an on-disk cache, which is memory-mapped for fast lookup.
This architecture allows for large datasets to be used on machines with relatively small device memory.`,Z,d,H="For example, loading the full English Wikipedia dataset only takes a few MB of RAM:",q,f,z,y,L=`This is possible because the Arrow data is actually memory-mapped from disk, and not loaded in memory.
Memory-mapping allows access to data on disk, and leverages virtual memory capabilities for fast lookups.`,G,w,R,j,D="Iterating over a memory-mapped dataset using Arrow is fast. Iterating over Wikipedia on a laptop gives you speeds of 1-3 Gbit/s:",E,g,N,A,P;return r=new S({props:{title:"Datasets 🤝 Arrow",local:"datasets--arrow",headingTag:"h1"}}),m=new S({props:{title:"What is Arrow?",local:"what-is-arrow",headingTag:"h2"}}),u=new S({props:{title:"Memory-mapping",local:"memory-mapping",headingTag:"h2"}}),f=new ts({props:{code:"aW1wb3J0JTIwb3MlM0IlMjBpbXBvcnQlMjBwc3V0aWwlM0IlMjBpbXBvcnQlMjB0aW1laXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFtZW1fYmVmb3JlJTIwJTNEJTIwcHN1dGlsLlByb2Nlc3Mob3MuZ2V0cGlkKCkpLm1lbW9yeV9pbmZvKCkucnNzJTIwJTJGJTIwKDEwMjQlMjAqJTIwMTAyNCklMEF3aWtpJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMndpa2lwZWRpYSUyMiUyQyUyMCUyMjIwMjIwMzAxLmVuJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtZW1fYWZ0ZXIlMjAlM0QlMjBwc3V0aWwuUHJvY2Vzcyhvcy5nZXRwaWQoKSkubWVtb3J5X2luZm8oKS5yc3MlMjAlMkYlMjAoMTAyNCUyMColMjAxMDI0KSUwQSUwQXByaW50KGYlMjJSQU0lMjBtZW1vcnklMjB1c2VkJTNBJTIwJTdCKG1lbV9hZnRlciUyMC0lMjBtZW1fYmVmb3JlKSU3RCUyME1CJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os; <span class="hljs-keyword">import</span> psutil; <span class="hljs-keyword">import</span> timeit
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Process.memory_info is expressed in bytes, so convert to megabytes </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mem_before = psutil.Process(os.getpid()).memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = load_dataset(<span class="hljs-string">&quot;wikipedia&quot;</span>, <span class="hljs-string">&quot;20220301.en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mem_after = psutil.Process(os.getpid()).memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM memory used: <span class="hljs-subst">{(mem_after - mem_before)}</span> MB&quot;</span>)
RAM memory used: <span class="hljs-number">50</span> MB`,wrap:!1}}),w=new S({props:{title:"Performance",local:"performance",headingTag:"h2"}}),g=new ts({props:{code:"cyUyMCUzRCUyMCUyMiUyMiUyMmJhdGNoX3NpemUlMjAlM0QlMjAxMDAwJTBBZm9yJTIwYmF0Y2glMjBpbiUyMHdpa2kuaXRlcihiYXRjaF9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUwQSUyMiUyMiUyMiUwQSUwQXRpbWUlMjAlM0QlMjB0aW1laXQudGltZWl0KHN0bXQlM0RzJTJDJTIwbnVtYmVyJTNEMSUyQyUyMGdsb2JhbHMlM0RnbG9iYWxzKCkpJTBBcHJpbnQoZiUyMlRpbWUlMjB0byUyMGl0ZXJhdGUlMjBvdmVyJTIwdGhlJTIwJTdCd2lraS5kYXRhc2V0X3NpemUlMjAlM0UlM0UlMjAzMCU3RCUyMEdCJTIwZGF0YXNldCUzQSUyMCU3QnRpbWUlM0EuMWYlN0QlMjBzZWMlMkMlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjBmJTIyaWUuJTIwJTdCZmxvYXQod2lraS5kYXRhc2V0X3NpemUlMjAlM0UlM0UlMjAyNyklMkZ0aW1lJTNBLjFmJTdEJTIwR2IlMkZzJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>s = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000
<span class="hljs-meta">... </span>for batch in wiki.iter(batch_size):
<span class="hljs-meta">... </span>    ...
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>time = timeit.timeit(stmt=s, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time to iterate over the <span class="hljs-subst">{wiki.dataset_size &gt;&gt; <span class="hljs-number">30</span>}</span> GB dataset: <span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span> sec, &quot;</span>
<span class="hljs-meta">... </span>      <span class="hljs-string">f&quot;ie. <span class="hljs-subst">{<span class="hljs-built_in">float</span>(wiki.dataset_size &gt;&gt; <span class="hljs-number">27</span>)/time:<span class="hljs-number">.1</span>f}</span> Gb/s&quot;</span>)
Time to iterate over the <span class="hljs-number">18</span> GB dataset: <span class="hljs-number">31.8</span> sec, ie. <span class="hljs-number">4.8</span> Gb/s`,wrap:!1}}),{c(){i=p("meta"),_=l(),v=p("p"),B=l(),b(r.$$.fragment),I=l(),b(m.$$.fragment),Q=l(),c=p("p"),c.innerHTML=V,W=l(),M=p("ul"),M.innerHTML=F,x=l(),b(u.$$.fragment),X=l(),h=p("p"),h.textContent=K,Z=l(),d=p("p"),d.textContent=H,q=l(),b(f.$$.fragment),z=l(),y=p("p"),y.textContent=L,G=l(),b(w.$$.fragment),R=l(),j=p("p"),j.textContent=D,E=l(),b(g.$$.fragment),N=l(),A=p("p"),this.h()},l(s){const t=ps("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(a),_=n(s),v=o(s,"P",{}),O(v).forEach(a),B=n(s),U(r.$$.fragment,s),I=n(s),U(m.$$.fragment,s),Q=n(s),c=o(s,"P",{"data-svelte-h":!0}),T(c)!=="svelte-52goft"&&(c.innerHTML=V),W=n(s),M=o(s,"UL",{"data-svelte-h":!0}),T(M)!=="svelte-6kbcii"&&(M.innerHTML=F),x=n(s),U(u.$$.fragment,s),X=n(s),h=o(s,"P",{"data-svelte-h":!0}),T(h)!=="svelte-xad2nu"&&(h.textContent=K),Z=n(s),d=o(s,"P",{"data-svelte-h":!0}),T(d)!=="svelte-k9gzax"&&(d.textContent=H),q=n(s),U(f.$$.fragment,s),z=n(s),y=o(s,"P",{"data-svelte-h":!0}),T(y)!=="svelte-kx9jy5"&&(y.textContent=L),G=n(s),U(w.$$.fragment,s),R=n(s),j=o(s,"P",{"data-svelte-h":!0}),T(j)!=="svelte-1telpcz"&&(j.textContent=D),E=n(s),U(g.$$.fragment,s),N=n(s),A=o(s,"P",{}),O(A).forEach(a),this.h()},h(){ss(i,"name","hf:doc:metadata"),ss(i,"content",cs)},m(s,t){os(document.head,i),e(s,_,t),e(s,v,t),e(s,B,t),J(r,s,t),e(s,I,t),J(m,s,t),e(s,Q,t),e(s,c,t),e(s,W,t),e(s,M,t),e(s,x,t),J(u,s,t),e(s,X,t),e(s,h,t),e(s,Z,t),e(s,d,t),e(s,q,t),J(f,s,t),e(s,z,t),e(s,y,t),e(s,G,t),J(w,s,t),e(s,R,t),e(s,j,t),e(s,E,t),J(g,s,t),e(s,N,t),e(s,A,t),P=!0},p:es,i(s){P||($(r.$$.fragment,s),$(m.$$.fragment,s),$(u.$$.fragment,s),$(f.$$.fragment,s),$(w.$$.fragment,s),$(g.$$.fragment,s),P=!0)},o(s){k(r.$$.fragment,s),k(m.$$.fragment,s),k(u.$$.fragment,s),k(f.$$.fragment,s),k(w.$$.fragment,s),k(g.$$.fragment,s),P=!1},d(s){s&&(a(_),a(v),a(B),a(I),a(Q),a(c),a(W),a(M),a(x),a(X),a(h),a(Z),a(d),a(q),a(z),a(y),a(G),a(R),a(j),a(E),a(N),a(A)),a(i),C(r,s),C(m,s),C(u,s),C(f,s),C(w,s),C(g,s)}}}const cs='{"title":"Datasets 🤝 Arrow","local":"datasets--arrow","sections":[{"title":"What is Arrow?","local":"what-is-arrow","sections":[],"depth":2},{"title":"Memory-mapping","local":"memory-mapping","sections":[],"depth":2},{"title":"Performance","local":"performance","sections":[],"depth":2}],"depth":1}';function Ms(Y){return ls(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=rs}),[]}class ys extends ns{constructor(i){super(),is(this,i,Ms,ms,as,{})}}export{ys as component};
