import{s as Es,o as Ys,n as Xs}from"../chunks/scheduler.bdbef820.js";import{S as Rs,i as Hs,g as p,s as n,r as h,A as zs,h as c,f as e,c as t,j as Qs,u as r,x as o,k as F,y as Ss,a as l,v as j,d as J,t as M,w as b}from"../chunks/index.c0aea24a.js";import{H as Fs,g as Ls}from"../chunks/Heading.0e005771.js";import{T as Ds}from"../chunks/Tip.31005f7d.js";import{C as w}from"../chunks/CodeBlock.6ccca92e.js";function Ps(L){let i,u=`Now that you know how to process a dataset for object detection, learn
<a href="https://colab.research.google.com/github/NielsRogge/Transformers-Tutorials/blob/master/YOLOS/Fine_tuning_YOLOS_for_object_detection_on_custom_dataset_(balloon).ipynb" rel="nofollow">how to train an object detection model</a>
and use it for inference.`;return{c(){i=p("p"),i.innerHTML=u},l(m){i=c(m,"P",{"data-svelte-h":!0}),o(i)!=="svelte-cn2hue"&&(i.innerHTML=u)},m(m,z){l(m,i,z)},p:Xs,d(m){m&&e(i)}}}function Ks(L){let i,u,m,z,x,D,f,us='Object detection models identify something in an image, and object detection datasets are used for applications such as autonomous driving and detecting natural hazards like wildfire. This guide will show you how to apply transformations to an object detection dataset following the <a href="https://albumentations.ai/docs/examples/example_bboxes/" rel="nofollow">tutorial</a> from <a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a>.',P,U,xs="To run these examples, make sure you have up-to-date versions of <code>albumentations</code> and <code>cv2</code> installed:",K,I,q,C,fs='In this example, you’ll use the <a href="https://huggingface.co/datasets/cppe-5" rel="nofollow"><code>cppe-5</code></a> dataset for identifying medical personal protective equipment (PPE) in the context of the COVID-19 pandemic.',O,v,Us="Load the dataset and take a look at an example:",ss,B,as,_,Is="The dataset has the following fields:",es,k,Cs='<li><code>image</code>: PIL.Image.Image object containing the image.</li> <li><code>image_id</code>: The image ID.</li> <li><code>height</code>: The image height.</li> <li><code>width</code>: The image width.</li> <li><code>objects</code>: A dictionary containing bounding box metadata for the objects in the image:<ul><li><code>id</code>: The annotation id.</li> <li><code>area</code>: The area of the bounding box.</li> <li><code>bbox</code>: The object’s bounding box (in the <a href="https://albumentations.ai/docs/getting_started/bounding_boxes_augmentation/#coco" rel="nofollow">coco</a> format).</li> <li><code>category</code>: The object’s category, with possible values including <code>Coverall (0)</code>, <code>Face_Shield (1)</code>, <code>Gloves (2)</code>, <code>Goggles (3)</code> and <code>Mask (4)</code>.</li></ul></li>',ls,Z,vs='You can visualize the <code>bboxes</code> on the image using some internal torch utilities. To do that, you will need to reference the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> feature associated with the category IDs so you can look up the string labels:',ns,G,ts,g,Bs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/visualize_detection_example.png"/>',ps,A,_s="With <code>albumentations</code>, you can apply transforms that will affect the image while also updating the <code>bboxes</code> accordingly. In this case, the image is resized to (480, 480), flipped horizontally, and brightened.",cs,$,ks="<code>albumentations</code> expects the image to be in BGR format, not RGB, so you’ll have to convert the image before applying the transform.",is,W,os,N,Zs="Now when you visualize the result, the image should be flipped, but the <code>bboxes</code> should still be in the right places.",ms,V,hs,d,Gs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/visualize_detection_example_transformed.png"/>',rs,Q,As="Create a function to apply the transform to a batch of examples:",js,E,Js,Y,$s='Use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to apply the transform on-the-fly which consumes less disk space. The randomness of data augmentation may return a different image if you access the same example twice. It is especially useful when training a model for several epochs.',Ms,X,bs,R,Ws="You can verify the transform works by visualizing the 10th example:",gs,H,ds,T,Ns='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/visualize_detection_example_transformed_2.png"/>',Ts,y,ys,S,ws;return x=new Fs({props:{title:"Object detection",local:"object-detection",headingTag:"h1"}}),I=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYWxidW1lbnRhdGlvbnMlMjBvcGVuY3YtcHl0aG9u",highlighted:'pip <span class="hljs-keyword">install</span> -U albumentations opencv-python',wrap:!1}}),B=new w({props:{code:"JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3BwZS01JTIyKSUwQWV4YW1wbGUlMjAlM0QlMjBkcyU1Qid0cmFpbiclNUQlNUIwJTVEJTBBZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;cppe-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example = ds[<span class="hljs-string">&#x27;train&#x27;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>example
{<span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">663</span>,
 <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=943x663 at <span class="hljs-number">0x7FC3DC756250</span>&gt;,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;area&#x27;</span>: [<span class="hljs-number">3796</span>, <span class="hljs-number">1596</span>, <span class="hljs-number">152768</span>, <span class="hljs-number">81002</span>],
  <span class="hljs-string">&#x27;bbox&#x27;</span>: [[<span class="hljs-number">302.0</span>, <span class="hljs-number">109.0</span>, <span class="hljs-number">73.0</span>, <span class="hljs-number">52.0</span>],
   [<span class="hljs-number">810.0</span>, <span class="hljs-number">100.0</span>, <span class="hljs-number">57.0</span>, <span class="hljs-number">28.0</span>],
   [<span class="hljs-number">160.0</span>, <span class="hljs-number">31.0</span>, <span class="hljs-number">248.0</span>, <span class="hljs-number">616.0</span>],
   [<span class="hljs-number">741.0</span>, <span class="hljs-number">68.0</span>, <span class="hljs-number">202.0</span>, <span class="hljs-number">401.0</span>]],
  <span class="hljs-string">&#x27;category&#x27;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
  <span class="hljs-string">&#x27;id&#x27;</span>: [<span class="hljs-number">114</span>, <span class="hljs-number">115</span>, <span class="hljs-number">116</span>, <span class="hljs-number">117</span>]},
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">943</span>}`,wrap:!1}}),G=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24ub3BzJTIwaW1wb3J0JTIwYm94X2NvbnZlcnQlMEFmcm9tJTIwdG9yY2h2aXNpb24udXRpbHMlMjBpbXBvcnQlMjBkcmF3X2JvdW5kaW5nX2JveGVzJTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMuZnVuY3Rpb25hbCUyMGltcG9ydCUyMHBpbF90b190ZW5zb3IlMkMlMjB0b19waWxfaW1hZ2UlMEElMEFjYXRlZ29yaWVzJTIwJTNEJTIwZHMlNUIndHJhaW4nJTVELmZlYXR1cmVzJTVCJ29iamVjdHMnJTVELmZlYXR1cmUlNUInY2F0ZWdvcnknJTVEJTBBJTBBYm94ZXNfeHl3aCUyMCUzRCUyMHRvcmNoLnRlbnNvcihleGFtcGxlJTVCJ29iamVjdHMnJTVEJTVCJ2Jib3gnJTVEKSUwQWJveGVzX3h5eHklMjAlM0QlMjBib3hfY29udmVydChib3hlc194eXdoJTJDJTIwJ3h5d2gnJTJDJTIwJ3h5eHknKSUwQWxhYmVscyUyMCUzRCUyMCU1QmNhdGVnb3JpZXMuaW50MnN0cih4KSUyMGZvciUyMHglMjBpbiUyMGV4YW1wbGUlNUInb2JqZWN0cyclNUQlNUInY2F0ZWdvcnknJTVEJTVEJTBBdG9fcGlsX2ltYWdlKCUwQSUyMCUyMCUyMCUyMGRyYXdfYm91bmRpbmdfYm94ZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlsX3RvX3RlbnNvcihleGFtcGxlJTVCJ2ltYWdlJyU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3hlc194eXh5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29sb3JzJTNEJTIycmVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEbGFiZWxzJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.ops <span class="hljs-keyword">import</span> box_convert
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.utils <span class="hljs-keyword">import</span> draw_bounding_boxes
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms.functional <span class="hljs-keyword">import</span> pil_to_tensor, to_pil_image

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = ds[<span class="hljs-string">&#x27;train&#x27;</span>].features[<span class="hljs-string">&#x27;objects&#x27;</span>].feature[<span class="hljs-string">&#x27;category&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xywh = torch.tensor(example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;bbox&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xyxy = box_convert(boxes_xywh, <span class="hljs-string">&#x27;xywh&#x27;</span>, <span class="hljs-string">&#x27;xyxy&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [categories.int2str(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;category&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>to_pil_image(
<span class="hljs-meta">... </span>    draw_bounding_boxes(
<span class="hljs-meta">... </span>        pil_to_tensor(example[<span class="hljs-string">&#x27;image&#x27;</span>]),
<span class="hljs-meta">... </span>        boxes_xyxy,
<span class="hljs-meta">... </span>        colors=<span class="hljs-string">&quot;red&quot;</span>,
<span class="hljs-meta">... </span>        labels=labels,
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new w({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEF0cmFuc2Zvcm0lMjAlM0QlMjBhbGJ1bWVudGF0aW9ucy5Db21wb3NlKCU1QiUwQSUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJlc2l6ZSg0ODAlMkMlMjA0ODApJTJDJTBBJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuSG9yaXpvbnRhbEZsaXAocCUzRDEuMCklMkMlMEElMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5SYW5kb21CcmlnaHRuZXNzQ29udHJhc3QocCUzRDEuMCklMkMlMEElNUQlMkMlMjBiYm94X3BhcmFtcyUzRGFsYnVtZW50YXRpb25zLkJib3hQYXJhbXMoZm9ybWF0JTNEJ2NvY28nJTJDJTIwJTIwbGFiZWxfZmllbGRzJTNEJTVCJ2NhdGVnb3J5JyU1RCkpJTBBJTBBJTIzJTIwUkdCJTIwUElMJTIwSW1hZ2UlMjAtJTNFJTIwQkdSJTIwTnVtcHklMjBhcnJheSUwQWltYWdlJTIwJTNEJTIwbnAuZmxpcChucC5hcnJheShleGFtcGxlJTVCJ2ltYWdlJyU1RCklMkMlMjAtMSklMEFvdXQlMjAlM0QlMjB0cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGJib3hlcyUzRGV4YW1wbGUlNUInb2JqZWN0cyclNUQlNUInYmJveCclNUQlMkMlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUzRGV4YW1wbGUlNUInb2JqZWN0cyclNUQlNUInY2F0ZWdvcnknJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose([
<span class="hljs-meta">... </span>    albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
<span class="hljs-meta">... </span>    albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>    albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>], bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&#x27;coco&#x27;</span>,  label_fields=[<span class="hljs-string">&#x27;category&#x27;</span>]))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># RGB PIL Image -&gt; BGR Numpy array</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.flip(np.array(example[<span class="hljs-string">&#x27;image&#x27;</span>]), -<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = transform(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    bboxes=example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;bbox&#x27;</span>],
<span class="hljs-meta">... </span>    category=example[<span class="hljs-string">&#x27;objects&#x27;</span>][<span class="hljs-string">&#x27;category&#x27;</span>],
<span class="hljs-meta">... </span>)`,wrap:!1}}),V=new w({props:{code:"aW1hZ2UlMjAlM0QlMjB0b3JjaC50ZW5zb3Iob3V0JTVCJ2ltYWdlJyU1RCkuZmxpcCgtMSkucGVybXV0ZSgyJTJDJTIwMCUyQyUyMDEpJTBBYm94ZXNfeHl3aCUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QnRvcmNoLnRlbnNvcih4KSUyMGZvciUyMHglMjBpbiUyMG91dCU1QidiYm94ZXMnJTVEJTVEKSUwQWJveGVzX3h5eHklMjAlM0QlMjBib3hfY29udmVydChib3hlc194eXdoJTJDJTIwJ3h5d2gnJTJDJTIwJ3h5eHknKSUwQWxhYmVscyUyMCUzRCUyMCU1QmNhdGVnb3JpZXMuaW50MnN0cih4KSUyMGZvciUyMHglMjBpbiUyMG91dCU1QidjYXRlZ29yeSclNUQlNUQlMEF0b19waWxfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwZHJhd19ib3VuZGluZ19ib3hlcyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJveGVzX3h5eHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb2xvcnMlM0QncmVkJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVscyUzRGxhYmVscyUwQSUyMCUyMCUyMCUyMCklMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image = torch.tensor(out[<span class="hljs-string">&#x27;image&#x27;</span>]).flip(-<span class="hljs-number">1</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xywh = torch.stack([torch.tensor(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> out[<span class="hljs-string">&#x27;bboxes&#x27;</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes_xyxy = box_convert(boxes_xywh, <span class="hljs-string">&#x27;xywh&#x27;</span>, <span class="hljs-string">&#x27;xyxy&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [categories.int2str(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> out[<span class="hljs-string">&#x27;category&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>to_pil_image(
<span class="hljs-meta">... </span>    draw_bounding_boxes(
<span class="hljs-meta">... </span>        image,
<span class="hljs-meta">... </span>        boxes_xyxy,
<span class="hljs-meta">... </span>        colors=<span class="hljs-string">&#x27;red&#x27;</span>,
<span class="hljs-meta">... </span>        labels=labels
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),E=new w({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMkMlMjBiYm94ZXMlMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUInaW1hZ2UnJTVEJTJDJTIwZXhhbXBsZXMlNUInb2JqZWN0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZS5jb252ZXJ0KCUyMlJHQiUyMikpJTVCJTNBJTJDJTIwJTNBJTJDJTIwJTNBJTNBLTElNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXQlMjAlM0QlMjB0cmFuc2Zvcm0oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJib3hlcyUzRG9iamVjdHMlNUInYmJveCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXRlZ29yeSUzRG9iamVjdHMlNUInY2F0ZWdvcnknJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlcy5hcHBlbmQodG9yY2gudGVuc29yKG91dCU1QidpbWFnZSclNUQpLmZsaXAoLTEpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYm94ZXMuYXBwZW5kKHRvcmNoLnRlbnNvcihvdXQlNUInYmJveGVzJyU1RCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2F0ZWdvcmllcy5hcHBlbmQob3V0JTVCJ2NhdGVnb3J5JyU1RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0InaW1hZ2UnJTNBJTIwaW1hZ2VzJTJDJTIwJ2Jib3gnJTNBJTIwYmJveGVzJTJDJTIwJ2NhdGVnb3J5JyUzQSUyMGNhdGVnb3JpZXMlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images, bboxes, categories = [], [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;image&#x27;</span>], examples[<span class="hljs-string">&#x27;objects&#x27;</span>]):
<span class="hljs-meta">... </span>        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        out = transform(
<span class="hljs-meta">... </span>            image=image,
<span class="hljs-meta">... </span>            bboxes=objects[<span class="hljs-string">&#x27;bbox&#x27;</span>],
<span class="hljs-meta">... </span>            category=objects[<span class="hljs-string">&#x27;category&#x27;</span>]
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        images.append(torch.tensor(out[<span class="hljs-string">&#x27;image&#x27;</span>]).flip(-<span class="hljs-number">1</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">... </span>        bboxes.append(torch.tensor(out[<span class="hljs-string">&#x27;bboxes&#x27;</span>]))
<span class="hljs-meta">... </span>        categories.append(out[<span class="hljs-string">&#x27;category&#x27;</span>])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&#x27;image&#x27;</span>: images, <span class="hljs-string">&#x27;bbox&#x27;</span>: bboxes, <span class="hljs-string">&#x27;category&#x27;</span>: categories}`,wrap:!1}}),X=new w({props:{code:"ZHMlNUIndHJhaW4nJTVELnNldF90cmFuc2Zvcm0odHJhbnNmb3Jtcyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-string">&#x27;train&#x27;</span>].set_transform(transforms)',wrap:!1}}),H=new w({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRzJTVCJ3RyYWluJyU1RCU1QjEwJTVEJTBBdG9fcGlsX2ltYWdlKCUwQSUyMCUyMCUyMCUyMGRyYXdfYm91bmRpbmdfYm94ZXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZSU1QidpbWFnZSclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBib3hfY29udmVydChleGFtcGxlJTVCJ2Jib3gnJTVEJTJDJTIwJ3h5d2gnJTJDJTIwJ3h5eHknKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbG9ycyUzRCdyZWQnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCY2F0ZWdvcmllcy5pbnQyc3RyKHgpJTIwZm9yJTIweCUyMGluJTIwZXhhbXBsZSU1QidjYXRlZ29yeSclNUQlNUQlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = ds[<span class="hljs-string">&#x27;train&#x27;</span>][<span class="hljs-number">10</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>to_pil_image(
<span class="hljs-meta">... </span>    draw_bounding_boxes(
<span class="hljs-meta">... </span>        example[<span class="hljs-string">&#x27;image&#x27;</span>],
<span class="hljs-meta">... </span>        box_convert(example[<span class="hljs-string">&#x27;bbox&#x27;</span>], <span class="hljs-string">&#x27;xywh&#x27;</span>, <span class="hljs-string">&#x27;xyxy&#x27;</span>),
<span class="hljs-meta">... </span>        colors=<span class="hljs-string">&#x27;red&#x27;</span>,
<span class="hljs-meta">... </span>        labels=[categories.int2str(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example[<span class="hljs-string">&#x27;category&#x27;</span>]]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>)`,wrap:!1}}),y=new Ds({props:{$$slots:{default:[Ps]},$$scope:{ctx:L}}}),{c(){i=p("meta"),u=n(),m=p("p"),z=n(),h(x.$$.fragment),D=n(),f=p("p"),f.innerHTML=us,P=n(),U=p("p"),U.innerHTML=xs,K=n(),h(I.$$.fragment),q=n(),C=p("p"),C.innerHTML=fs,O=n(),v=p("p"),v.textContent=Us,ss=n(),h(B.$$.fragment),as=n(),_=p("p"),_.textContent=Is,es=n(),k=p("ul"),k.innerHTML=Cs,ls=n(),Z=p("p"),Z.innerHTML=vs,ns=n(),h(G.$$.fragment),ts=n(),g=p("div"),g.innerHTML=Bs,ps=n(),A=p("p"),A.innerHTML=_s,cs=n(),$=p("p"),$.innerHTML=ks,is=n(),h(W.$$.fragment),os=n(),N=p("p"),N.innerHTML=Zs,ms=n(),h(V.$$.fragment),hs=n(),d=p("div"),d.innerHTML=Gs,rs=n(),Q=p("p"),Q.textContent=As,js=n(),h(E.$$.fragment),Js=n(),Y=p("p"),Y.innerHTML=$s,Ms=n(),h(X.$$.fragment),bs=n(),R=p("p"),R.textContent=Ws,gs=n(),h(H.$$.fragment),ds=n(),T=p("div"),T.innerHTML=Ns,Ts=n(),h(y.$$.fragment),ys=n(),S=p("p"),this.h()},l(s){const a=zs("svelte-u9bgzb",document.head);i=c(a,"META",{name:!0,content:!0}),a.forEach(e),u=t(s),m=c(s,"P",{}),Qs(m).forEach(e),z=t(s),r(x.$$.fragment,s),D=t(s),f=c(s,"P",{"data-svelte-h":!0}),o(f)!=="svelte-jruc7r"&&(f.innerHTML=us),P=t(s),U=c(s,"P",{"data-svelte-h":!0}),o(U)!=="svelte-129tu0o"&&(U.innerHTML=xs),K=t(s),r(I.$$.fragment,s),q=t(s),C=c(s,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1weiyre"&&(C.innerHTML=fs),O=t(s),v=c(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1yzvpv3"&&(v.textContent=Us),ss=t(s),r(B.$$.fragment,s),as=t(s),_=c(s,"P",{"data-svelte-h":!0}),o(_)!=="svelte-ybiosu"&&(_.textContent=Is),es=t(s),k=c(s,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1fspv27"&&(k.innerHTML=Cs),ls=t(s),Z=c(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-ixl7cz"&&(Z.innerHTML=vs),ns=t(s),r(G.$$.fragment,s),ts=t(s),g=c(s,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-12m4ojo"&&(g.innerHTML=Bs),ps=t(s),A=c(s,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1mco384"&&(A.innerHTML=_s),cs=t(s),$=c(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-x3197i"&&($.innerHTML=ks),is=t(s),r(W.$$.fragment,s),os=t(s),N=c(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-kmv35f"&&(N.innerHTML=Zs),ms=t(s),r(V.$$.fragment,s),hs=t(s),d=c(s,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-1hy8dte"&&(d.innerHTML=Gs),rs=t(s),Q=c(s,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-di1rb7"&&(Q.textContent=As),js=t(s),r(E.$$.fragment,s),Js=t(s),Y=c(s,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-6dvz9"&&(Y.innerHTML=$s),Ms=t(s),r(X.$$.fragment,s),bs=t(s),R=c(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-u7hwut"&&(R.textContent=Ws),gs=t(s),r(H.$$.fragment,s),ds=t(s),T=c(s,"DIV",{class:!0,"data-svelte-h":!0}),o(T)!=="svelte-70kk7f"&&(T.innerHTML=Ns),Ts=t(s),r(y.$$.fragment,s),ys=t(s),S=c(s,"P",{}),Qs(S).forEach(e),this.h()},h(){F(i,"name","hf:doc:metadata"),F(i,"content",qs),F(g,"class","flex justify-center"),F(d,"class","flex justify-center"),F(T,"class","flex justify-center")},m(s,a){Ss(document.head,i),l(s,u,a),l(s,m,a),l(s,z,a),j(x,s,a),l(s,D,a),l(s,f,a),l(s,P,a),l(s,U,a),l(s,K,a),j(I,s,a),l(s,q,a),l(s,C,a),l(s,O,a),l(s,v,a),l(s,ss,a),j(B,s,a),l(s,as,a),l(s,_,a),l(s,es,a),l(s,k,a),l(s,ls,a),l(s,Z,a),l(s,ns,a),j(G,s,a),l(s,ts,a),l(s,g,a),l(s,ps,a),l(s,A,a),l(s,cs,a),l(s,$,a),l(s,is,a),j(W,s,a),l(s,os,a),l(s,N,a),l(s,ms,a),j(V,s,a),l(s,hs,a),l(s,d,a),l(s,rs,a),l(s,Q,a),l(s,js,a),j(E,s,a),l(s,Js,a),l(s,Y,a),l(s,Ms,a),j(X,s,a),l(s,bs,a),l(s,R,a),l(s,gs,a),j(H,s,a),l(s,ds,a),l(s,T,a),l(s,Ts,a),j(y,s,a),l(s,ys,a),l(s,S,a),ws=!0},p(s,[a]){const Vs={};a&2&&(Vs.$$scope={dirty:a,ctx:s}),y.$set(Vs)},i(s){ws||(J(x.$$.fragment,s),J(I.$$.fragment,s),J(B.$$.fragment,s),J(G.$$.fragment,s),J(W.$$.fragment,s),J(V.$$.fragment,s),J(E.$$.fragment,s),J(X.$$.fragment,s),J(H.$$.fragment,s),J(y.$$.fragment,s),ws=!0)},o(s){M(x.$$.fragment,s),M(I.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M(W.$$.fragment,s),M(V.$$.fragment,s),M(E.$$.fragment,s),M(X.$$.fragment,s),M(H.$$.fragment,s),M(y.$$.fragment,s),ws=!1},d(s){s&&(e(u),e(m),e(z),e(D),e(f),e(P),e(U),e(K),e(q),e(C),e(O),e(v),e(ss),e(as),e(_),e(es),e(k),e(ls),e(Z),e(ns),e(ts),e(g),e(ps),e(A),e(cs),e($),e(is),e(os),e(N),e(ms),e(hs),e(d),e(rs),e(Q),e(js),e(Js),e(Y),e(Ms),e(bs),e(R),e(gs),e(ds),e(T),e(Ts),e(ys),e(S)),e(i),b(x,s),b(I,s),b(B,s),b(G,s),b(W,s),b(V,s),b(E,s),b(X,s),b(H,s),b(y,s)}}}const qs='{"title":"Object detection","local":"object-detection","sections":[],"depth":1}';function Os(L){return Ys(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Ls}),[]}class ta extends Rs{constructor(i){super(),Hs(this,i,Os,Ks,Es,{})}}export{ta as component};
