import{s as Qr,o as Yr,n as C}from"../chunks/scheduler.bdbef820.js";import{S as Wr,i as Hr,g as c,s as o,r as f,A as Pr,h as p,f as d,c as r,j as M,u as h,x as v,k as T,y as n,a as u,v as _,d as b,t as $,w as x}from"../chunks/index.c0aea24a.js";import{H as ms,g as Ar}from"../chunks/Heading.0e005771.js";import{D as k}from"../chunks/Docstring.698fed07.js";import{C as U}from"../chunks/CodeBlock.6ccca92e.js";import{E as J}from"../chunks/ExampleCodeBlock.b13a4277.js";function qr(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSgpJTBBZHMlMjAlM0QlMjBidWlsZGVyLmFzX2RhdGFzZXQoc3BsaXQlM0QndHJhaW4nKSUwQWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = builder.as_dataset(split=<span class="hljs-string">&#x27;train&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">8530</span>
})`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function Or(y){let a,w="Download and prepare the dataset as Arrow files that can be loaded as a Dataset using <code>builder.as_dataset()</code>:",i,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-i6fpq7"&&(a.innerHTML=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function Kr(y){let a,w="Download and prepare the dataset as sharded Parquet files locally:",i,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoJTIyLiUyRm91dHB1dF9kaXIlMjIlMkMlMjBmaWxlX2Zvcm1hdCUzRCUyMnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;./output_dir&quot;</span>, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1035kd7"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function el(y){let a,w="Download and prepare the dataset as sharded Parquet files in a cloud storage:",i,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFzdG9yYWdlX29wdGlvbnMlMjAlM0QlMjAlN0IlMjJrZXklMjIlM0ElMjBhd3NfYWNjZXNzX2tleV9pZCUyQyUyMCUyMnNlY3JldCUyMiUzQSUyMGF3c19zZWNyZXRfYWNjZXNzX2tleSU3RCUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJyb3R0ZW5fdG9tYXRvZXMlMjIpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSglMjJzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRm15X3JvdHRlbl90b21hdG9lcyUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyUyQyUyMGZpbGVfZm9ybWF0JTNEJTIycGFycXVldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;key&quot;</span>: aws_access_key_id, <span class="hljs-string">&quot;secret&quot;</span>: aws_secret_access_key}
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;s3://my-bucket/my_rotten_tomatoes&quot;</span>, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-y7m7rz"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function tl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfYWxsX2V4cG9ydGVkX2RhdGFzZXRfaW5mb3MoKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_all_exported_dataset_infos()
{<span class="hljs-string">&#x27;default&#x27;</span>: DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), task_templates=[TextClassification(task=&#x27;text-classification&#x27;, text_column=&#x27;text&#x27;, label_column=&#x27;label&#x27;)], builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)}</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function al(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfZXhwb3J0ZWRfZGF0YXNldF9pbmZvKCklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_exported_dataset_info()
DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), task_templates=[TextClassification(task=&#x27;text-classification&#x27;, text_column=&#x27;text&#x27;, label_column=&#x27;label&#x27;)], builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function sl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function nl(y){let a,w="Is roughly equivalent to:",i,s,l;return s=new U({props:{code:"ZXh0cmFjdGVkX3BhdGhzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRsX21hbmFnZXIuZG93bmxvYWQodXJsX29yX3VybHMpKQ==",highlighted:'<span class="hljs-attr">extracted_paths</span> = dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-yva38v"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function ol(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWRfY3VzdG9tKCdzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRmRhdGEuemlwJyUyQyUyMGN1c3RvbV9kb3dubG9hZF9mb3JfbXlfcHJpdmF0ZV9idWNrZXQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download_custom(<span class="hljs-string">&#x27;s3://my-bucket/data.zip&#x27;</span>, custom_download_for_my_private_bucket)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function rl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function ll(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function dl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function il(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function cl(y){let a,w="Is equivalent to:",i,s,l;return s=new U({props:{code:"dXJscyUyMCUzRCUyMGRsX21hbmFnZXIuZXh0cmFjdChkbF9tYW5hZ2VyLmRvd25sb2FkKHVybF9vcl91cmxzKSk=",highlighted:'<span class="hljs-attribute">urls</span> <span class="hljs-operator">=</span> dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-b0lbw9"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function pl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function ml(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function gl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function ul(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KHVybCklN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and_extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function fl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVkFMSURBVElPTiUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVEVTVCUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ0ZXN0JTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.VALIDATION,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;validation&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TEST,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;test&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function hl(y){let a,w="Each descriptor can be composed with other using addition or slice:",i,s,l;return s=new U({props:{code:"c3BsaXQlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCMCUzQTI1JTVEKSUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1Q=",highlighted:'split = datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">0</span>:<span class="hljs-number">25</span>]) + datasets.Split.TEST',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-in376m"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function _l(y){let a,w="A split cannot be added twice, so the following will fail:",i,s,l;return s=new U({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRSQUlOLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUI3NSUzQSU1RCklMEEpJTIwJTIwJTIzJTIwRXJyb3IlMEFzcGxpdCUyMCUzRCUyMGRhdGFzZXRzLlNwbGl0LlRFU1QlMjAlMkIlMjBkYXRhc2V0cy5TcGxpdC5BTEwlMjAlMjAlMjMlMjBFcnJvcg==",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">75</span>:])
)  <span class="hljs-comment"># Error</span>
split = datasets.Split.TEST + datasets.Split.ALL  <span class="hljs-comment"># Error</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1dn84z5"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function bl(y){let a,w="The slices can be applied only one time. So the following are valid:",i,s,l;return s=new U({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRFU1Quc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKSUwQSklMEFzcGxpdCUyMCUzRCUyMChkYXRhc2V0cy5TcGxpdC5UUkFJTiUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1QpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0E1MCU1RCk=",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TEST.subsplit(datasets.percent[:<span class="hljs-number">50</span>])
)
split = (datasets.Split.TRAIN + datasets.Split.TEST).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-f377rx"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function $l(y){let a,w="But this is not valid:",i,s,l;return s=new U({props:{code:"dHJhaW4lMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTiUwQXRlc3QlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5URVNUJTBBc3BsaXQlMjAlM0QlMjB0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0EyNSU1RCklMEFzcGxpdCUyMCUzRCUyMCh0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpJTIwJTJCJTIwdGVzdCkuc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKQ==",highlighted:`train = datasets.Split.TRAIN
test = datasets.Split.TEST
split = train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]).subsplit(datasets.percent[:<span class="hljs-number">25</span>])
split = (train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) + test).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1jf0xuu"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function xl(y){let a,w="Examples:",i,s,l;return s=new U({props:{code:"JTIzJTIwVGhlJTIwZm9sbG93aW5nJTIwbGluZXMlMjBhcmUlMjBlcXVpdmFsZW50JTNBJTBBZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJ21uaXN0JyUyQyUyMHNwbGl0JTNEJ3Rlc3QlNUIlM0EzMyUyNSU1RCcpJTBBZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJ21uaXN0JyUyQyUyMHNwbGl0JTNEZGF0YXNldHMuUmVhZEluc3RydWN0aW9uLmZyb21fc3BlYygndGVzdCU1QiUzQTMzJTI1JTVEJykpJTBBZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJ21uaXN0JyUyQyUyMHNwbGl0JTNEZGF0YXNldHMuUmVhZEluc3RydWN0aW9uKCd0ZXN0JyUyQyUyMHRvJTNEMzMlMkMlMjB1bml0JTNEJyUyNScpKSUwQWRzJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCdtbmlzdCclMkMlMjBzcGxpdCUzRGRhdGFzZXRzLlJlYWRJbnN0cnVjdGlvbiglMEEndGVzdCclMkMlMjBmcm9tXyUzRDAlMkMlMjB0byUzRDMzJTJDJTIwdW5pdCUzRCclMjUnKSklMEElMEElMjMlMjBUaGUlMjBmb2xsb3dpbmclMjBsaW5lcyUyMGFyZSUyMGVxdWl2YWxlbnQlM0ElMEFkcyUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCgnbW5pc3QnJTJDJTIwc3BsaXQlM0QndGVzdCU1QiUzQTMzJTI1JTVEJTJCdHJhaW4lNUIxJTNBLTElNUQnKSUwQWRzJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCdtbmlzdCclMkMlMjBzcGxpdCUzRGRhdGFzZXRzLlJlYWRJbnN0cnVjdGlvbi5mcm9tX3NwZWMoJTBBJ3Rlc3QlNUIlM0EzMyUyNSU1RCUyQnRyYWluJTVCMSUzQS0xJTVEJykpJTBBZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJ21uaXN0JyUyQyUyMHNwbGl0JTNEKCUwQWRhdGFzZXRzLlJlYWRJbnN0cnVjdGlvbigndGVzdCclMkMlMjB0byUzRDMzJTJDJTIwdW5pdCUzRCclMjUnKSUyMCUyQiUwQWRhdGFzZXRzLlJlYWRJbnN0cnVjdGlvbigndHJhaW4nJTJDJTIwZnJvbV8lM0QxJTJDJTIwdG8lM0QtMSUyQyUyMHVuaXQlM0QnYWJzJykpKSUwQSUwQSUyMyUyMFRoZSUyMGZvbGxvd2luZyUyMGxpbmVzJTIwYXJlJTIwZXF1aXZhbGVudCUzQSUwQWRzJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCdtbmlzdCclMkMlMjBzcGxpdCUzRCd0ZXN0JTVCJTNBMzMlMjUlNUQocGN0MV9kcm9wcmVtYWluZGVyKScpJTBBZHMlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJ21uaXN0JyUyQyUyMHNwbGl0JTNEZGF0YXNldHMuUmVhZEluc3RydWN0aW9uLmZyb21fc3BlYyglMEEndGVzdCU1QiUzQTMzJTI1JTVEKHBjdDFfZHJvcHJlbWFpbmRlciknKSklMEFkcyUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCgnbW5pc3QnJTJDJTIwc3BsaXQlM0RkYXRhc2V0cy5SZWFkSW5zdHJ1Y3Rpb24oJTBBJ3Rlc3QnJTJDJTIwZnJvbV8lM0QwJTJDJTIwdG8lM0QzMyUyQyUyMHVuaXQlM0QnJTI1JyUyQyUyMHJvdW5kaW5nJTNEJTIycGN0MV9kcm9wcmVtYWluZGVyJTIyKSklMEElMEElMjMlMjAxMC1mb2xkJTIwdmFsaWRhdGlvbiUzQSUwQXRlc3RzJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUwQSdtbmlzdCclMkMlMEElNUJkYXRhc2V0cy5SZWFkSW5zdHJ1Y3Rpb24oJ3RyYWluJyUyQyUyMGZyb21fJTNEayUyQyUyMHRvJTNEayUyQjEwJTJDJTIwdW5pdCUzRCclMjUnKSUwQWZvciUyMGslMjBpbiUyMHJhbmdlKDAlMkMlMjAxMDAlMkMlMjAxMCklNUQpJTBBdHJhaW5zJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUwQSdtbmlzdCclMkMlMEElNUJkYXRhc2V0cy5SZWFkSW5zdHJ1Y3Rpb24oJ3RyYWluJyUyQyUyMHRvJTNEayUyQyUyMHVuaXQlM0QnJTI1JyklMjAlMkIlMjBkYXRhc2V0cy5SZWFkSW5zdHJ1Y3Rpb24oJ3RyYWluJyUyQyUyMGZyb21fJTNEayUyQjEwJTJDJTIwdW5pdCUzRCclMjUnKSUwQWZvciUyMGslMjBpbiUyMHJhbmdlKDAlMkMlMjAxMDAlMkMlMjAxMCklNUQp",highlighted:`<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(<span class="hljs-string">&#x27;test[:33%]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=(
datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>) +
datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=<span class="hljs-number">1</span>, to=-<span class="hljs-number">1</span>, unit=<span class="hljs-string">&#x27;abs&#x27;</span>)))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>, rounding=<span class="hljs-string">&quot;pct1_dropremainder&quot;</span>))

<span class="hljs-comment"># 10-fold validation:</span>
tests = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k, to=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])
trains = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, to=k, unit=<span class="hljs-string">&#x27;%&#x27;</span>) + datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function vl(y){let a,w="Examples:",i,s,l;return s=new U({props:{code:"dGVzdCUzQSUyMHRlc3QlMjBzcGxpdC4lMEF0ZXN0JTIwJTJCJTIwdmFsaWRhdGlvbiUzQSUyMHRlc3QlMjBzcGxpdCUyMCUyQiUyMHZhbGlkYXRpb24lMjBzcGxpdC4lMEF0ZXN0JTVCMTAlM0ElNUQlM0ElMjB0ZXN0JTIwc3BsaXQlMkMlMjBtaW51cyUyMGl0cyUyMGZpcnN0JTIwMTAlMjByZWNvcmRzLiUwQXRlc3QlNUIlM0ExMCUyNSU1RCUzQSUyMGZpcnN0JTIwMTAlMjUlMjByZWNvcmRzJTIwb2YlMjB0ZXN0JTIwc3BsaXQuJTBBdGVzdCU1QiUzQTIwJTI1JTVEKHBjdDFfZHJvcHJlbWFpbmRlciklM0ElMjBmaXJzdCUyMDEwJTI1JTIwcmVjb3JkcyUyQyUyMHJvdW5kZWQlMjB3aXRoJTIwdGhlJTIwcGN0MV9kcm9wcmVtYWluZGVyJTIwcm91bmRpbmcuJTBBdGVzdCU1QiUzQS01JTI1JTVEJTJCdHJhaW4lNUI0MCUyNSUzQTYwJTI1JTVEJTNBJTIwZmlyc3QlMjA5NSUyNSUyMG9mJTIwdGVzdCUyMCUyQiUyMG1pZGRsZSUyMDIwJTI1JTIwb2YlMjB0cmFpbi4=",highlighted:`<span class="hljs-keyword">test: test</span> split.
<span class="hljs-keyword">test </span>+ validation: test split + validation split.
test[10:]: test split, minus its first 10 records.
test[:10%]: first 10% records of test split.
test[:20%](pct1_dropremainder): first 10% records, rounded with the pct1_dropremainder rounding.
test[:<span class="hljs-string">-5</span>%]+train[40%:60%]: first 95% of test + middle 20% of train.`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function wl(y){let a,w="Example:",i,s,l;return s=new U({props:{code:"VkVSU0lPTiUyMCUzRCUyMGRhdGFzZXRzLlZlcnNpb24oJTIyMS4wLjAlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>VERSION = datasets.Version(<span class="hljs-string">&quot;1.0.0&quot;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(s.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(s.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(s,e,m),l=!0},p:C,i(e){l||(b(s.$$.fragment,e),l=!0)},o(e){$(s.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(s,e)}}}function yl(y){let a,w,i,s,l,e,m,us,pt,Zo='🤗 Datasets relies on two main classes during the dataset building process: <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.DatasetBuilder">DatasetBuilder</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a>.',fs,R,mt,Zs,sa,Fo="Abstract base class for all datasets.",Fs,na,zo="<code>DatasetBuilder</code> has 3 key methods:",zs,oa,Vo=`<li><code>DatasetBuilder.info</code>: Documents the dataset, including feature
names, types, shapes, version, splits, citation, etc.</li> <li><a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.DatasetBuilder.download_and_prepare">DatasetBuilder.download_and_prepare()</a>: Downloads the source data
and writes it to disk.</li> <li><a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.DatasetBuilder.as_dataset">DatasetBuilder.as_dataset()</a>: Generates a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a>.</li>`,Vs,ra,So=`Some <code>DatasetBuilder</code>s expose multiple variants of the
dataset by defining a <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass and accepting a
config object (or name) on construction. Configurable datasets expose a
pre-defined set of configurations in <code>DatasetBuilder.builder_configs()</code>.`,Ss,ne,gt,Es,la,Eo="Return a Dataset for the specified split.",Ls,Be,Qs,Z,ut,Ys,da,Lo="Downloads and prepares dataset for reading.",Ws,ia,Qo="Example:",Hs,Xe,Ps,Ze,As,Fe,qs,oe,ft,Os,ca,Yo="Empty dict if doesn’t exist",Ks,ze,en,re,ht,tn,pa,Wo="Empty <code>DatasetInfo</code> if doesn’t exist",an,Ve,sn,Se,_t,nn,ma,Ho="Return the path of the module of this class or subclass.",hs,q,bt,on,ga,Po="Base class for datasets with data generation based on dict generators.",rn,ua,Ao=`<code>GeneratorBasedBuilder</code> is a convenience class that abstracts away much
of the data writing and reading of <code>DatasetBuilder</code>. It expects subclasses to
implement generators of feature dictionaries across the dataset splits
(<code>_split_generators</code>). See the method docstrings for details.`,_s,xe,$t,ln,fa,qo="Beam-based Builder.",bs,ve,xt,dn,ha,Oo="Base class for datasets with data generation based on Arrow loading functions (CSV/JSON/Parquet).",$s,Q,vt,cn,_a,Ko="Base class for <code>DatasetBuilder</code> data configuration.",pn,ba,er=`<code>DatasetBuilder</code> subclasses with data configuration options should subclass
<code>BuilderConfig</code> and add their own properties.`,mn,W,wt,gn,$a,tr=`The config id is used to build the cache directory.
By default it is equal to the config name.
However the name of a config is not sufficient to have a unique identifier for the dataset being generated
since it doesn’t take into account:`,un,xa,ar="<li>the config kwargs that can be used to overwrite attributes</li> <li>the custom features used to write the dataset</li> <li>the data_files for json/text/csv/pandas datasets</li>",fn,va,sr="Therefore the config id is just the config name with an optional suffix based on these.",xs,yt,vs,N,Mt,hn,H,Tt,_n,wa,nr="Download given URL(s).",bn,ya,or="By default, only one process is used for download. Pass customized <code>download_config.num_proc</code> to change this behavior.",$n,Ee,xn,le,kt,vn,Ma,rr="Download and extract given <code>url_or_urls</code>.",wn,Le,yn,de,Jt,Mn,Ta,lr="Download given urls(s) by calling <code>custom_download</code>.",Tn,Qe,kn,ie,Ct,Jn,ka,dr="Extract given path(s).",Cn,Ye,Un,ce,Ut,Rn,Ja,ir="Iterate over files within an archive.",jn,We,Nn,pe,Rt,Gn,Ca,cr="Iterate over file paths.",Dn,He,In,Pe,jt,Bn,Ua,pr="Ship the files using Beam FileSystems to the pipeline temp dir.",ws,D,Nt,Xn,Ra,mr=`Download manager that uses the ”::” separator to navigate through (possibly remote) compressed archives.
Contrary to the regular <code>DownloadManager</code>, the <code>download</code> and <code>extract</code> methods don’t actually download nor extract
data, but they rather return the path or url that could be opened using the <code>xopen</code> function which extends the
built-in <code>open</code> function to stream data from remote files.`,Zn,me,Gt,Fn,ja,gr=`Normalize URL(s) of files to stream data from.
This is the lazy version of <code>DownloadManager.download</code> for streaming.`,zn,Ae,Vn,P,Dt,Sn,Na,ur="Prepare given <code>url_or_urls</code> for streaming (add extraction protocol).",En,Ga,fr="This is the lazy version of <code>DownloadManager.download_and_extract</code> for streaming.",Ln,qe,Qn,A,It,Yn,Da,hr="Add extraction protocol for given url(s) for streaming.",Wn,Ia,_r="This is the lazy version of <code>DownloadManager.extract</code> for streaming.",Hn,Oe,Pn,ge,Bt,An,Ba,br="Iterate over files within an archive.",qn,Ke,On,ue,Xt,Kn,Xa,$r="Iterate over files.",eo,et,ys,we,Zt,to,Za,xr="Configuration for our cached path manager.",Ms,z,Ft,ao,Fa,vr="<code>Enum</code> for how to treat pre-existing downloads and data.",so,za,wr=`The default mode is <code>REUSE_DATASET_IF_EXISTS</code>, which will reuse both
raw downloads and the prepared dataset if they exist.`,no,Va,yr="The generations modes:",oo,Sa,Mr="<thead><tr><th></th> <th>Downloads</th> <th>Dataset</th></tr></thead> <tbody><tr><td><code>REUSE_DATASET_IF_EXISTS</code> (default)</td> <td>Reuse</td> <td>Reuse</td></tr> <tr><td><code>REUSE_CACHE_IF_EXISTS</code></td> <td>Reuse</td> <td>Fresh</td></tr> <tr><td><code>FORCE_REDOWNLOAD</code></td> <td>Fresh</td> <td>Fresh</td></tr></tbody>",Ts,zt,ks,V,Vt,ro,Ea,Tr="<code>Enum</code> that specifies which verification checks to run.",lo,La,kr=`The default mode is <code>BASIC_CHECKS</code>, which will perform only rudimentary checks to avoid slowdowns
when generating/downloading a dataset for the first time.`,io,Qa,Jr="The verification modes:",co,Ya,Cr="<thead><tr><th></th> <th>Verification checks</th></tr></thead> <tbody><tr><td><code>ALL_CHECKS</code></td> <td>Split checks, uniqueness of the keys yielded in case of the GeneratorBuilder</td></tr> <tr><td></td> <td>and the validity (number of files, checksums, etc.) of downloaded files</td></tr> <tr><td><code>BASIC_CHECKS</code> (default)</td> <td>Same as <code>ALL_CHECKS</code> but without checking downloaded files</td></tr> <tr><td><code>NO_CHECKS</code></td> <td>None</td></tr></tbody>",Js,St,Cs,Y,Et,po,Wa,Ur="Defines the split information for the generator.",mo,Ha,Rr=`This should be used as returned value of
<code>GeneratorBasedBuilder._split_generators</code>.
See <code>GeneratorBasedBuilder._split_generators</code> for more info and example
of usage.`,go,tt,Us,I,Lt,uo,Pa,jr="<code>Enum</code> for dataset splits.",fo,Aa,Nr=`Datasets are typically split into different subsets to be used at various
stages of training and evaluation.`,ho,qa,Gr=`<li><code>TRAIN</code>: the training data.</li> <li><code>VALIDATION</code>: the validation data. If present, this is typically used as
evaluation data while iterating on a model (e.g. changing hyperparameters,
model architecture, etc.).</li> <li><code>TEST</code>: the testing data. This is the data to report metrics on. Typically
you do not want to use this during model iteration as you may overfit to it.</li> <li><code>ALL</code>: the union of all defined dataset splits.</li>`,_o,Oa,Dr="All splits, including compositions inherit from <code>datasets.SplitBase</code>.",bo,Ka,Ir='See the <a href="../load_hub#splits">guide</a> on splits for more information.',$o,at,Rs,G,Qt,xo,es,Br="Descriptor corresponding to a named split (train, test, …).",vo,ts,Xr="Example:",wo,st,yo,as,Zr=`The resulting split will correspond to 25% of the train split merged with
100% of the test split.`,Mo,nt,To,ot,ko,rt,js,ye,Yt,Jo,ss,Fr="Split corresponding to the union of all defined dataset splits.",Ns,S,Wt,Co,ns,zr="Reading instruction for a dataset.",Uo,lt,Ro,fe,Ht,jo,os,Vr="Creates a <code>ReadInstruction</code> instance out of a string spec.",No,dt,Go,he,Pt,Do,rs,Sr="Translate instruction into a list of absolute instructions.",Io,ls,Er="Those absolute instructions are then to be added together.",Gs,At,Ds,O,qt,Bo,ds,Lr="Dataset version <code>MAJOR.MINOR.PATCH</code>.",Xo,it,Is,gs,Bs;return l=new ms({props:{title:"Builder classes",local:"builder-classes",headingTag:"h1"}}),m=new ms({props:{title:"Builders",local:"datasets.DatasetBuilder",headingTag:"h2"}}),mt=new k({props:{name:"class datasets.DatasetBuilder",anchor:"datasets.DatasetBuilder",parameters:[{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"config_name",val:": typing.Optional[str] = None"},{name:"hash",val:": typing.Optional[str] = None"},{name:"base_path",val:": typing.Optional[str] = None"},{name:"info",val:": typing.Optional[datasets.info.DatasetInfo] = None"},{name:"features",val:": typing.Optional[datasets.features.features.Features] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": typing.Optional[str] = None"},{name:"data_files",val:": typing.Union[str, list, dict, datasets.data_files.DataFilesDict, NoneType] = None"},{name:"data_dir",val:": typing.Optional[str] = None"},{name:"storage_options",val:": typing.Optional[dict] = None"},{name:"writer_batch_size",val:": typing.Optional[int] = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Directory to cache data. Defaults to <code>&quot;~/.cache/huggingface/datasets&quot;</code>.`,name:"cache_dir"},{anchor:"datasets.DatasetBuilder.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset, if different from the builder name. Useful for packaged builders
like csv, imagefolder, audiofolder, etc. to reflect the difference between datasets
that use the same packaged builder.`,name:"dataset_name"},{anchor:"datasets.DatasetBuilder.config_name",description:`<strong>config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset configuration.
It affects the data generated on disk. Different configurations will have their own subdirectories and
versions.
If not provided, the default configuration is used (if it exists).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.3.0</p>
						
<p>Parameter <code>name</code> was renamed to <code>config_name</code>.</p>

					</div>`,name:"config_name"},{anchor:"datasets.DatasetBuilder.hash",description:`<strong>hash</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hash specific to the dataset code. Used to update the caching directory when the
dataset loading script code is updated (to avoid reusing old data).
The typical caching directory (defined in <code>self._relative_data_dir</code>) is <code>name/version/hash/</code>.`,name:"hash"},{anchor:"datasets.DatasetBuilder.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files.
This can be a remote URL.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.features",description:`<strong>features</strong> (<a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Features">Features</a>, <em>optional</em>) &#x2014;
Features types to use with this dataset.
It can be used to change the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Features">Features</a> types of a dataset, for example.`,name:"features"},{anchor:"datasets.DatasetBuilder.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
String or boolean to use as Bearer token for remote files on the
Datasets Hub. If <code>True</code>, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.DatasetBuilder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the dataset repository.
Used to distinguish builders with the same name but not coming from the same namespace, for example &#x201C;squad&#x201D;
and &#x201C;lhoestq/squad&#x201D; repo IDs. In the latter, the builder name would be &#x201C;lhoestq___squad&#x201D;.`,name:"repo_id"},{anchor:"datasets.DatasetBuilder.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).
For builders like &#x201C;csv&#x201D; or &#x201C;json&#x201D; that need the user to specify data files. They can be either
local or remote files. For convenience, you can use a <code>DataFilesDict</code>.`,name:"data_files"},{anchor:"datasets.DatasetBuilder.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to directory containing source data file(s).
Use only if <code>data_files</code> is not passed, in which case it is equivalent to passing
<code>os.path.join(data_dir, &quot;**&quot;)</code> as <code>data_files</code>.
For builders that require manual download, it must be the path to the local directory containing the
manually downloaded data.`,name:"data_dir"},{anchor:"datasets.DatasetBuilder.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.writer_batch_size",description:`<strong>writer_batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size used by the ArrowWriter.
It defines the number of samples that are kept in memory before writing them
and also the length of the arrow chunks.
None means that the ArrowWriter will use its default value.`,name:"writer_batch_size"},{anchor:"datasets.DatasetBuilder.name",description:`<strong>name</strong> (<code>str</code>) &#x2014; Configuration name for the dataset.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.3.0</p>
						
<p>Use <code>config_name</code> instead.</p>

					</div>`,name:"name"},{anchor:"datasets.DatasetBuilder.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments to be passed to the corresponding builder
configuration class, set on the class attribute <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.BuilderConfig">DatasetBuilder.BUILDER_CONFIG_CLASS</a>. The builder
configuration class is <a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> or a subclass of it.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L216"}}),gt=new k({props:{name:"as_dataset",anchor:"datasets.DatasetBuilder.as_dataset",parameters:[{name:"split",val:": typing.Optional[datasets.splits.Split] = None"},{name:"run_post_process",val:" = True"},{name:"verification_mode",val:": typing.Union[datasets.utils.info_utils.VerificationMode, str, NoneType] = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"in_memory",val:" = False"}],parametersDescription:[{anchor:"datasets.DatasetBuilder.as_dataset.split",description:`<strong>split</strong> (<code>datasets.Split</code>) &#x2014;
Which subset of the data to return.`,name:"split"},{anchor:"datasets.DatasetBuilder.as_dataset.run_post_process",description:`<strong>run_post_process</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to run post-processing dataset transforms and/or add
indexes.`,name:"run_post_process"},{anchor:"datasets.DatasetBuilder.as_dataset.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.as_dataset.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to ignore the verifications of the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.DatasetBuilder.as_dataset.in_memory",description:`<strong>in_memory</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to copy the data in-memory.`,name:"in_memory"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L1111",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>datasets.Dataset</p>
`}}),Be=new J({props:{anchor:"datasets.DatasetBuilder.as_dataset.example",$$slots:{default:[qr]},$$scope:{ctx:y}}}),ut=new k({props:{name:"download_and_prepare",anchor:"datasets.DatasetBuilder.download_and_prepare",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"download_config",val:": typing.Optional[datasets.download.download_config.DownloadConfig] = None"},{name:"download_mode",val:": typing.Union[datasets.download.download_manager.DownloadMode, str, NoneType] = None"},{name:"verification_mode",val:": typing.Union[datasets.utils.info_utils.VerificationMode, str, NoneType] = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"try_from_hf_gcs",val:": bool = True"},{name:"dl_manager",val:": typing.Optional[datasets.download.download_manager.DownloadManager] = None"},{name:"base_path",val:": typing.Optional[str] = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"file_format",val:": str = 'arrow'"},{name:"max_shard_size",val:": typing.Union[str, int, NoneType] = None"},{name:"num_proc",val:": typing.Optional[int] = None"},{name:"storage_options",val:": typing.Optional[dict] = None"},{name:"**download_and_prepare_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.download_and_prepare.output_dir",description:`<strong>output_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Output directory for the dataset.
Default to this builder&#x2019;s <code>cache_dir</code>, which is inside <code>~/.cache/huggingface/datasets</code> by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"output_dir"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_config",description:`<strong>download_config</strong> (<code>DownloadConfig</code>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, <em>optional</em>) &#x2014;
Select the download/generate mode, default to <code>REUSE_DATASET_IF_EXISTS</code>.`,name:"download_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/v2.14.6/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Ignore the verifications of the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.DatasetBuilder.download_and_prepare.try_from_hf_gcs",description:`<strong>try_from_hf_gcs</strong> (<code>bool</code>) &#x2014;
If <code>True</code>, it will try to download the already prepared dataset from the HF Google cloud storage.`,name:"try_from_hf_gcs"},{anchor:"datasets.DatasetBuilder.download_and_prepare.dl_manager",description:`<strong>dl_manager</strong> (<code>DownloadManager</code>, <em>optional</em>) &#x2014;
Specific <code>DownloadManger</code> to use.`,name:"dl_manager"},{anchor:"datasets.DatasetBuilder.download_and_prepare.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files. This can be a remote url.
If not specified, the value of the <code>base_path</code> attribute (<code>self.base_path</code>) will be used instead.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.download_and_prepare.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If True, or not specified, will get token from ~/.huggingface.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.7.1</p>
						
<p>Pass <code>use_auth_token</code> to <code>load_dataset_builder</code> instead.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.DatasetBuilder.download_and_prepare.file_format",description:`<strong>file_format</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Format of the data files in which the dataset will be written.
Supported formats: &#x201C;arrow&#x201D;, &#x201C;parquet&#x201D;. Default to &#x201C;arrow&#x201D; format.
If the format is &#x201C;parquet&#x201D;, then image and audio data are embedded into the Parquet files instead of pointing to local files.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"file_format"},{anchor:"datasets.DatasetBuilder.download_and_prepare.max_shard_size",description:`<strong>max_shard_size</strong> (<code>Union[str, int]</code>, <em>optional</em>) &#x2014;
Maximum number of bytes written per shard, default is &#x201C;500MB&#x201D;.
The size is based on uncompressed data size, so in practice your shard files may be smaller than
<code>max_shard_size</code> thanks to Parquet compression for example.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"max_shard_size"},{anchor:"datasets.DatasetBuilder.download_and_prepare.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes when downloading and generating the dataset locally.
Multiprocessing is disabled by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.7.0</p>
						
					</div>`,name:"num_proc"},{anchor:"datasets.DatasetBuilder.download_and_prepare.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the caching file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.download_and_prepare.*download_and_prepare_kwargs",description:"*<strong>*download_and_prepare_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments.",name:"*download_and_prepare_kwargs"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L693"}}),Xe=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example",$$slots:{default:[Or]},$$scope:{ctx:y}}}),Ze=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-2",$$slots:{default:[Kr]},$$scope:{ctx:y}}}),Fe=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-3",$$slots:{default:[el]},$$scope:{ctx:y}}}),ft=new k({props:{name:"get_all_exported_dataset_infos",anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos",parameters:[],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L479"}}),ze=new J({props:{anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos.example",$$slots:{default:[tl]},$$scope:{ctx:y}}}),ht=new k({props:{name:"get_exported_dataset_info",anchor:"datasets.DatasetBuilder.get_exported_dataset_info",parameters:[],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L494"}}),Ve=new J({props:{anchor:"datasets.DatasetBuilder.get_exported_dataset_info.example",$$slots:{default:[al]},$$scope:{ctx:y}}}),_t=new k({props:{name:"get_imported_module_dir",anchor:"datasets.DatasetBuilder.get_imported_module_dir",parameters:[],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L685"}}),bt=new k({props:{name:"class datasets.GeneratorBasedBuilder",anchor:"datasets.GeneratorBasedBuilder",parameters:[{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"config_name",val:": typing.Optional[str] = None"},{name:"hash",val:": typing.Optional[str] = None"},{name:"base_path",val:": typing.Optional[str] = None"},{name:"info",val:": typing.Optional[datasets.info.DatasetInfo] = None"},{name:"features",val:": typing.Optional[datasets.features.features.Features] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": typing.Optional[str] = None"},{name:"data_files",val:": typing.Union[str, list, dict, datasets.data_files.DataFilesDict, NoneType] = None"},{name:"data_dir",val:": typing.Optional[str] = None"},{name:"storage_options",val:": typing.Optional[dict] = None"},{name:"writer_batch_size",val:": typing.Optional[int] = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L1461"}}),$t=new k({props:{name:"class datasets.BeamBasedBuilder",anchor:"datasets.BeamBasedBuilder",parameters:[{name:"*args",val:""},{name:"beam_runner",val:" = None"},{name:"beam_options",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L1970"}}),xt=new k({props:{name:"class datasets.ArrowBasedBuilder",anchor:"datasets.ArrowBasedBuilder",parameters:[{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"config_name",val:": typing.Optional[str] = None"},{name:"hash",val:": typing.Optional[str] = None"},{name:"base_path",val:": typing.Optional[str] = None"},{name:"info",val:": typing.Optional[datasets.info.DatasetInfo] = None"},{name:"features",val:": typing.Optional[datasets.features.features.Features] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": typing.Optional[str] = None"},{name:"data_files",val:": typing.Union[str, list, dict, datasets.data_files.DataFilesDict, NoneType] = None"},{name:"data_dir",val:": typing.Optional[str] = None"},{name:"storage_options",val:": typing.Optional[dict] = None"},{name:"writer_batch_size",val:": typing.Optional[int] = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L1729"}}),vt=new k({props:{name:"class datasets.BuilderConfig",anchor:"datasets.BuilderConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": typing.Union[str, datasets.utils.version.Version, NoneType] = 0.0.0"},{name:"data_dir",val:": typing.Optional[str] = None"},{name:"data_files",val:": typing.Optional[datasets.data_files.DataFilesDict] = None"},{name:"description",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"datasets.BuilderConfig.name",description:`<strong>name</strong> (<code>str</code>, defaults to <code>default</code>) &#x2014;
The name of the configuration.`,name:"name"},{anchor:"datasets.BuilderConfig.version",description:`<strong>version</strong> (<code>Version</code> or <code>str</code>, defaults to <code>0.0.0</code>) &#x2014;
The version of the configuration.`,name:"version"},{anchor:"datasets.BuilderConfig.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the directory containing the source data.`,name:"data_dir"},{anchor:"datasets.BuilderConfig.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.BuilderConfig.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A human description of the configuration.`,name:"description"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L108"}}),wt=new k({props:{name:"create_config_id",anchor:"datasets.BuilderConfig.create_config_id",parameters:[{name:"config_kwargs",val:": dict"},{name:"custom_features",val:": typing.Optional[datasets.features.features.Features] = None"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/builder.py#L151"}}),yt=new ms({props:{title:"Download",local:"datasets.DownloadManager",headingTag:"h2"}}),Mt=new k({props:{name:"class datasets.DownloadManager",anchor:"datasets.DownloadManager",parameters:[{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"data_dir",val:": typing.Optional[str] = None"},{name:"download_config",val:": typing.Optional[datasets.download.download_config.DownloadConfig] = None"},{name:"base_path",val:": typing.Optional[str] = None"},{name:"record_checksums",val:" = True"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L254"}}),Tt=new k({props:{name:"download",anchor:"datasets.DownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L401",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The downloaded paths matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>list</code> or <code>dict</code></p>
`}}),Ee=new J({props:{anchor:"datasets.DownloadManager.download.example",$$slots:{default:[sl]},$$scope:{ctx:y}}}),kt=new k({props:{name:"download_and_extract",anchor:"datasets.DownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L549",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, extracted paths of given URL(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Le=new J({props:{anchor:"datasets.DownloadManager.download_and_extract.example",$$slots:{default:[nl]},$$scope:{ctx:y}}}),Jt=new k({props:{name:"download_custom",anchor:"datasets.DownloadManager.download_custom",parameters:[{name:"url_or_urls",val:""},{name:"custom_download",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_custom.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"},{anchor:"datasets.DownloadManager.download_custom.custom_download",description:`<strong>custom_download</strong> (<code>Callable[src_url, dst_path]</code>) &#x2014;
The source URL and destination path. For example
<code>tf.io.gfile.copy</code>, that lets you download from  Google storage.`,name:"custom_download"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L352",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The downloaded paths matching the given input
<code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>downloaded_path(s)</p>
`}}),Qe=new J({props:{anchor:"datasets.DownloadManager.download_custom.example",$$slots:{default:[ol]},$$scope:{ctx:y}}}),Ct=new k({props:{name:"extract",anchor:"datasets.DownloadManager.extract",parameters:[{name:"path_or_paths",val:""},{name:"num_proc",val:" = 'deprecated'"}],parametersDescription:[{anchor:"datasets.DownloadManager.extract.path_or_paths",description:`<strong>path_or_paths</strong> (path or <code>list</code> or <code>dict</code>) &#x2014;
Path of file to extract. Each path is a <code>str</code>.`,name:"path_or_paths"},{anchor:"datasets.DownloadManager.extract.num_proc",description:`<strong>num_proc</strong> (<code>int</code>) &#x2014;
Use multi-processing if <code>num_proc</code> &gt; 1 and the length of
<code>path_or_paths</code> is larger than <code>num_proc</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.6.2</p>
						
<p>Pass <code>DownloadConfig(num_proc=&lt;num_proc&gt;)</code> to the initializer instead.</p>

					</div>`,name:"num_proc"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The extracted paths matching the given input
path_or_paths.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Ye=new J({props:{anchor:"datasets.DownloadManager.extract.example",$$slots:{default:[rl]},$$scope:{ctx:y}}}),Ut=new k({props:{name:"iter_archive",anchor:"datasets.DownloadManager.iter_archive",parameters:[{name:"path_or_buf",val:": typing.Union[str, _io.BufferedReader]"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_archive.path_or_buf",description:`<strong>path_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"path_or_buf"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L456",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),We=new J({props:{anchor:"datasets.DownloadManager.iter_archive.example",$$slots:{default:[ll]},$$scope:{ctx:y}}}),Rt=new k({props:{name:"iter_files",anchor:"datasets.DownloadManager.iter_files",parameters:[{name:"paths",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_files.paths",description:`<strong>paths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"paths"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L481",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,isYield:!0}}),He=new J({props:{anchor:"datasets.DownloadManager.iter_files.example",$$slots:{default:[dl]},$$scope:{ctx:y}}}),jt=new k({props:{name:"ship_files_with_pipeline",anchor:"datasets.DownloadManager.ship_files_with_pipeline",parameters:[{name:"downloaded_path_or_paths",val:""},{name:"pipeline",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.ship_files_with_pipeline.downloaded_path_or_paths",description:`<strong>downloaded_path_or_paths</strong> (<code>str</code> or <code>list[str]</code> or <code>dict[str, str]</code>) &#x2014;
Nested structure containing the
downloaded path(s).`,name:"downloaded_path_or_paths"},{anchor:"datasets.DownloadManager.ship_files_with_pipeline.pipeline",description:`<strong>pipeline</strong> (<code>utils.beam_utils.BeamPipeline</code>) &#x2014;
Apache Beam Pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L301",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>list[str]</code> or <code>dict[str, str]</code></p>
`}}),Nt=new k({props:{name:"class datasets.StreamingDownloadManager",anchor:"datasets.StreamingDownloadManager",parameters:[{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"data_dir",val:": typing.Optional[str] = None"},{name:"download_config",val:": typing.Optional[datasets.download.download_config.DownloadConfig] = None"},{name:"base_path",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/streaming_download_manager.py#L943"}}),Gt=new k({props:{name:"download",anchor:"datasets.StreamingDownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/streaming_download_manager.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input url_or_urls.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Ae=new J({props:{anchor:"datasets.StreamingDownloadManager.download.example",$$slots:{default:[il]},$$scope:{ctx:y}}}),Dt=new k({props:{name:"download_and_extract",anchor:"datasets.StreamingDownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) to stream from data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/streaming_download_manager.py#L1045",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),qe=new J({props:{anchor:"datasets.StreamingDownloadManager.download_and_extract.example",$$slots:{default:[cl]},$$scope:{ctx:y}}}),It=new k({props:{name:"extract",anchor:"datasets.StreamingDownloadManager.extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/streaming_download_manager.py#L996",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Oe=new J({props:{anchor:"datasets.StreamingDownloadManager.extract.example",$$slots:{default:[pl]},$$scope:{ctx:y}}}),Bt=new k({props:{name:"iter_archive",anchor:"datasets.StreamingDownloadManager.iter_archive",parameters:[{name:"urlpath_or_buf",val:": typing.Union[str, _io.BufferedReader]"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_archive.urlpath_or_buf",description:`<strong>urlpath_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"urlpath_or_buf"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/streaming_download_manager.py#L1065",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),Ke=new J({props:{anchor:"datasets.StreamingDownloadManager.iter_archive.example",$$slots:{default:[ml]},$$scope:{ctx:y}}}),Xt=new k({props:{name:"iter_files",anchor:"datasets.StreamingDownloadManager.iter_files",parameters:[{name:"urlpaths",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_files.urlpaths",description:`<strong>urlpaths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"urlpaths"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/streaming_download_manager.py#L1090",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`,isYield:!0}}),et=new J({props:{anchor:"datasets.StreamingDownloadManager.iter_files.example",$$slots:{default:[gl]},$$scope:{ctx:y}}}),Zt=new k({props:{name:"class datasets.DownloadConfig",anchor:"datasets.DownloadConfig",parameters:[{name:"cache_dir",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"proxies",val:": typing.Optional[typing.Dict] = None"},{name:"user_agent",val:": typing.Optional[str] = None"},{name:"extract_compressed_file",val:": bool = False"},{name:"force_extract",val:": bool = False"},{name:"delete_extracted",val:": bool = False"},{name:"use_etag",val:": bool = True"},{name:"num_proc",val:": typing.Optional[int] = None"},{name:"max_retries",val:": int = 1"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"use_auth_token",val:": dataclasses.InitVar[typing.Union[str, bool, NoneType]] = 'deprecated'"},{name:"ignore_url_params",val:": bool = False"},{name:"storage_options",val:": typing.Dict[str, typing.Any] = <factory>"},{name:"download_desc",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"datasets.DownloadConfig.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
Specify a cache directory to save the file to (overwrite the
default cache dir).`,name:"cache_dir"},{anchor:"datasets.DownloadConfig.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, re-dowload the file even if it&#x2019;s already cached in
the cache dir.`,name:"force_download"},{anchor:"datasets.DownloadConfig.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, resume the download if an incompletely received file is
found.`,name:"resume_download"},{anchor:"datasets.DownloadConfig.proxies",description:"<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;",name:"proxies"},{anchor:"datasets.DownloadConfig.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional string or dict that will be appended to the user-agent on remote
requests.`,name:"user_agent"},{anchor:"datasets.DownloadConfig.extract_compressed_file",description:`<strong>extract_compressed_file</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> and the path point to a zip or tar file,
extract the compressed file in a folder along the archive.`,name:"extract_compressed_file"},{anchor:"datasets.DownloadConfig.force_extract",description:`<strong>force_extract</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> when <code>extract_compressed_file</code> is <code>True</code> and the archive
was already extracted, re-extract the archive and override the folder where it was extracted.`,name:"force_extract"},{anchor:"datasets.DownloadConfig.delete_extracted",description:`<strong>delete_extracted</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to delete (or keep) the extracted files.`,name:"delete_extracted"},{anchor:"datasets.DownloadConfig.use_etag",description:`<strong>use_etag</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use the ETag HTTP response header to validate the cached files.`,name:"use_etag"},{anchor:"datasets.DownloadConfig.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of processes to launch to download the files in parallel.`,name:"num_proc"},{anchor:"datasets.DownloadConfig.max_retries",description:`<strong>max_retries</strong> (<code>int</code>, default to <code>1</code>) &#x2014;
The number of times to retry an HTTP request if it fails.`,name:"max_retries"},{anchor:"datasets.DownloadConfig.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.`,name:"token"},{anchor:"datasets.DownloadConfig.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.DownloadConfig.ignore_url_params",description:`<strong>ignore_url_params</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to strip all query parameters and fragments from
the download URL before using it for caching the file.`,name:"ignore_url_params"},{anchor:"datasets.DownloadConfig.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DownloadConfig.download_desc",description:`<strong>download_desc</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A description to be displayed alongside with the progress bar while downloading the files.`,name:"download_desc"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_config.py#L11"}}),Ft=new k({props:{name:"class datasets.DownloadMode",anchor:"datasets.DownloadMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/download/download_manager.py#L76"}}),zt=new ms({props:{title:"Verification",local:"datasets.VerificationMode",headingTag:"h2"}}),Vt=new k({props:{name:"class datasets.VerificationMode",anchor:"datasets.VerificationMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/utils/info_utils.py#L13"}}),St=new ms({props:{title:"Splits",local:"datasets.SplitGenerator",headingTag:"h2"}}),Et=new k({props:{name:"class datasets.SplitGenerator",anchor:"datasets.SplitGenerator",parameters:[{name:"name",val:": str"},{name:"gen_kwargs",val:": typing.Dict = <factory>"}],parametersDescription:[{anchor:"datasets.SplitGenerator.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the <code>Split</code> for which the generator will
create the examples.`,name:"name"},{anchor:"datasets.SplitGenerator.*gen_kwargs",description:`*<strong>*gen_kwargs</strong> (additional keyword arguments) &#x2014;
Keyword arguments to forward to the <code>DatasetBuilder._generate_examples</code> method
of the builder.`,name:"*gen_kwargs"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/splits.py#L602"}}),tt=new J({props:{anchor:"datasets.SplitGenerator.example",$$slots:{default:[ul]},$$scope:{ctx:y}}}),Lt=new k({props:{name:"class datasets.Split",anchor:"datasets.Split",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/splits.py#L405"}}),at=new J({props:{anchor:"datasets.Split.example",$$slots:{default:[fl]},$$scope:{ctx:y}}}),Qt=new k({props:{name:"class datasets.NamedSplit",anchor:"datasets.NamedSplit",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/splits.py#L313"}}),st=new J({props:{anchor:"datasets.NamedSplit.example",$$slots:{default:[hl]},$$scope:{ctx:y}}}),nt=new J({props:{anchor:"datasets.NamedSplit.example-2",$$slots:{default:[_l]},$$scope:{ctx:y}}}),ot=new J({props:{anchor:"datasets.NamedSplit.example-3",$$slots:{default:[bl]},$$scope:{ctx:y}}}),rt=new J({props:{anchor:"datasets.NamedSplit.example-4",$$slots:{default:[$l]},$$scope:{ctx:y}}}),Yt=new k({props:{name:"class datasets.NamedSplitAll",anchor:"datasets.NamedSplitAll",parameters:[],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/splits.py#L390"}}),Wt=new k({props:{name:"class datasets.ReadInstruction",anchor:"datasets.ReadInstruction",parameters:[{name:"split_name",val:""},{name:"rounding",val:" = None"},{name:"from_",val:" = None"},{name:"to",val:" = None"},{name:"unit",val:" = None"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/arrow_reader.py#L489"}}),lt=new J({props:{anchor:"datasets.ReadInstruction.example",$$slots:{default:[xl]},$$scope:{ctx:y}}}),Ht=new k({props:{name:"from_spec",anchor:"datasets.ReadInstruction.from_spec",parameters:[{name:"spec",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.from_spec.spec",description:`<strong>spec</strong> (<code>str</code>) &#x2014;
Split(s) + optional slice(s) to read + optional rounding
if percents are used as the slicing unit. A slice can be specified,
using absolute numbers (<code>int</code>) or percentages (<code>int</code>).`,name:"spec"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/arrow_reader.py#L569",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>ReadInstruction instance.</p>
`}}),dt=new J({props:{anchor:"datasets.ReadInstruction.from_spec.example",$$slots:{default:[vl]},$$scope:{ctx:y}}}),Pt=new k({props:{name:"to_absolute",anchor:"datasets.ReadInstruction.to_absolute",parameters:[{name:"name2len",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.to_absolute.name2len",description:`<strong>name2len</strong> (<code>dict</code>) &#x2014;
Associating split names to number of examples.`,name:"name2len"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/arrow_reader.py#L641",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of _AbsoluteInstruction instances (corresponds to the + in spec).</p>
`}}),At=new ms({props:{title:"Version",local:"datasets.Version",headingTag:"h2"}}),qt=new k({props:{name:"class datasets.Version",anchor:"datasets.Version",parameters:[{name:"version_str",val:": str"},{name:"description",val:": typing.Optional[str] = None"},{name:"major",val:": typing.Union[str, int, NoneType] = None"},{name:"minor",val:": typing.Union[str, int, NoneType] = None"},{name:"patch",val:": typing.Union[str, int, NoneType] = None"}],parametersDescription:[{anchor:"datasets.Version.version_str",description:`<strong>version_str</strong> (<code>str</code>) &#x2014;
The dataset version.`,name:"version_str"},{anchor:"datasets.Version.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
A description of what is new in this version.`,name:"description"},{anchor:"datasets.Version.major",description:"<strong>major</strong> (<code>str</code>) &#x2014;",name:"major"},{anchor:"datasets.Version.minor",description:"<strong>minor</strong> (<code>str</code>) &#x2014;",name:"minor"},{anchor:"datasets.Version.patch",description:"<strong>patch</strong> (<code>str</code>) &#x2014;",name:"patch"}],source:"https://github.com/huggingface/datasets/blob/2.14.6/src/datasets/utils/version.py#L30"}}),it=new J({props:{anchor:"datasets.Version.example",$$slots:{default:[wl]},$$scope:{ctx:y}}}),{c(){a=c("meta"),w=o(),i=c("p"),s=o(),f(l.$$.fragment),e=o(),f(m.$$.fragment),us=o(),pt=c("p"),pt.innerHTML=Zo,fs=o(),R=c("div"),f(mt.$$.fragment),Zs=o(),sa=c("p"),sa.textContent=Fo,Fs=o(),na=c("p"),na.innerHTML=zo,zs=o(),oa=c("ul"),oa.innerHTML=Vo,Vs=o(),ra=c("p"),ra.innerHTML=So,Ss=o(),ne=c("div"),f(gt.$$.fragment),Es=o(),la=c("p"),la.textContent=Eo,Ls=o(),f(Be.$$.fragment),Qs=o(),Z=c("div"),f(ut.$$.fragment),Ys=o(),da=c("p"),da.textContent=Lo,Ws=o(),ia=c("p"),ia.textContent=Qo,Hs=o(),f(Xe.$$.fragment),Ps=o(),f(Ze.$$.fragment),As=o(),f(Fe.$$.fragment),qs=o(),oe=c("div"),f(ft.$$.fragment),Os=o(),ca=c("p"),ca.textContent=Yo,Ks=o(),f(ze.$$.fragment),en=o(),re=c("div"),f(ht.$$.fragment),tn=o(),pa=c("p"),pa.innerHTML=Wo,an=o(),f(Ve.$$.fragment),sn=o(),Se=c("div"),f(_t.$$.fragment),nn=o(),ma=c("p"),ma.textContent=Ho,hs=o(),q=c("div"),f(bt.$$.fragment),on=o(),ga=c("p"),ga.textContent=Po,rn=o(),ua=c("p"),ua.innerHTML=Ao,_s=o(),xe=c("div"),f($t.$$.fragment),ln=o(),fa=c("p"),fa.textContent=qo,bs=o(),ve=c("div"),f(xt.$$.fragment),dn=o(),ha=c("p"),ha.textContent=Oo,$s=o(),Q=c("div"),f(vt.$$.fragment),cn=o(),_a=c("p"),_a.innerHTML=Ko,pn=o(),ba=c("p"),ba.innerHTML=er,mn=o(),W=c("div"),f(wt.$$.fragment),gn=o(),$a=c("p"),$a.textContent=tr,un=o(),xa=c("ul"),xa.innerHTML=ar,fn=o(),va=c("p"),va.textContent=sr,xs=o(),f(yt.$$.fragment),vs=o(),N=c("div"),f(Mt.$$.fragment),hn=o(),H=c("div"),f(Tt.$$.fragment),_n=o(),wa=c("p"),wa.textContent=nr,bn=o(),ya=c("p"),ya.innerHTML=or,$n=o(),f(Ee.$$.fragment),xn=o(),le=c("div"),f(kt.$$.fragment),vn=o(),Ma=c("p"),Ma.innerHTML=rr,wn=o(),f(Le.$$.fragment),yn=o(),de=c("div"),f(Jt.$$.fragment),Mn=o(),Ta=c("p"),Ta.innerHTML=lr,Tn=o(),f(Qe.$$.fragment),kn=o(),ie=c("div"),f(Ct.$$.fragment),Jn=o(),ka=c("p"),ka.textContent=dr,Cn=o(),f(Ye.$$.fragment),Un=o(),ce=c("div"),f(Ut.$$.fragment),Rn=o(),Ja=c("p"),Ja.textContent=ir,jn=o(),f(We.$$.fragment),Nn=o(),pe=c("div"),f(Rt.$$.fragment),Gn=o(),Ca=c("p"),Ca.textContent=cr,Dn=o(),f(He.$$.fragment),In=o(),Pe=c("div"),f(jt.$$.fragment),Bn=o(),Ua=c("p"),Ua.textContent=pr,ws=o(),D=c("div"),f(Nt.$$.fragment),Xn=o(),Ra=c("p"),Ra.innerHTML=mr,Zn=o(),me=c("div"),f(Gt.$$.fragment),Fn=o(),ja=c("p"),ja.innerHTML=gr,zn=o(),f(Ae.$$.fragment),Vn=o(),P=c("div"),f(Dt.$$.fragment),Sn=o(),Na=c("p"),Na.innerHTML=ur,En=o(),Ga=c("p"),Ga.innerHTML=fr,Ln=o(),f(qe.$$.fragment),Qn=o(),A=c("div"),f(It.$$.fragment),Yn=o(),Da=c("p"),Da.textContent=hr,Wn=o(),Ia=c("p"),Ia.innerHTML=_r,Hn=o(),f(Oe.$$.fragment),Pn=o(),ge=c("div"),f(Bt.$$.fragment),An=o(),Ba=c("p"),Ba.textContent=br,qn=o(),f(Ke.$$.fragment),On=o(),ue=c("div"),f(Xt.$$.fragment),Kn=o(),Xa=c("p"),Xa.textContent=$r,eo=o(),f(et.$$.fragment),ys=o(),we=c("div"),f(Zt.$$.fragment),to=o(),Za=c("p"),Za.textContent=xr,Ms=o(),z=c("div"),f(Ft.$$.fragment),ao=o(),Fa=c("p"),Fa.innerHTML=vr,so=o(),za=c("p"),za.innerHTML=wr,no=o(),Va=c("p"),Va.textContent=yr,oo=o(),Sa=c("table"),Sa.innerHTML=Mr,Ts=o(),f(zt.$$.fragment),ks=o(),V=c("div"),f(Vt.$$.fragment),ro=o(),Ea=c("p"),Ea.innerHTML=Tr,lo=o(),La=c("p"),La.innerHTML=kr,io=o(),Qa=c("p"),Qa.textContent=Jr,co=o(),Ya=c("table"),Ya.innerHTML=Cr,Js=o(),f(St.$$.fragment),Cs=o(),Y=c("div"),f(Et.$$.fragment),po=o(),Wa=c("p"),Wa.textContent=Ur,mo=o(),Ha=c("p"),Ha.innerHTML=Rr,go=o(),f(tt.$$.fragment),Us=o(),I=c("div"),f(Lt.$$.fragment),uo=o(),Pa=c("p"),Pa.innerHTML=jr,fo=o(),Aa=c("p"),Aa.textContent=Nr,ho=o(),qa=c("ul"),qa.innerHTML=Gr,_o=o(),Oa=c("p"),Oa.innerHTML=Dr,bo=o(),Ka=c("p"),Ka.innerHTML=Ir,$o=o(),f(at.$$.fragment),Rs=o(),G=c("div"),f(Qt.$$.fragment),xo=o(),es=c("p"),es.textContent=Br,vo=o(),ts=c("p"),ts.textContent=Xr,wo=o(),f(st.$$.fragment),yo=o(),as=c("p"),as.textContent=Zr,Mo=o(),f(nt.$$.fragment),To=o(),f(ot.$$.fragment),ko=o(),f(rt.$$.fragment),js=o(),ye=c("div"),f(Yt.$$.fragment),Jo=o(),ss=c("p"),ss.textContent=Fr,Ns=o(),S=c("div"),f(Wt.$$.fragment),Co=o(),ns=c("p"),ns.textContent=zr,Uo=o(),f(lt.$$.fragment),Ro=o(),fe=c("div"),f(Ht.$$.fragment),jo=o(),os=c("p"),os.innerHTML=Vr,No=o(),f(dt.$$.fragment),Go=o(),he=c("div"),f(Pt.$$.fragment),Do=o(),rs=c("p"),rs.textContent=Sr,Io=o(),ls=c("p"),ls.textContent=Er,Gs=o(),f(At.$$.fragment),Ds=o(),O=c("div"),f(qt.$$.fragment),Bo=o(),ds=c("p"),ds.innerHTML=Lr,Xo=o(),f(it.$$.fragment),Is=o(),gs=c("p"),this.h()},l(t){const g=Pr("svelte-u9bgzb",document.head);a=p(g,"META",{name:!0,content:!0}),g.forEach(d),w=r(t),i=p(t,"P",{}),M(i).forEach(d),s=r(t),h(l.$$.fragment,t),e=r(t),h(m.$$.fragment,t),us=r(t),pt=p(t,"P",{"data-svelte-h":!0}),v(pt)!=="svelte-4ix4ls"&&(pt.innerHTML=Zo),fs=r(t),R=p(t,"DIV",{class:!0});var j=M(R);h(mt.$$.fragment,j),Zs=r(j),sa=p(j,"P",{"data-svelte-h":!0}),v(sa)!=="svelte-krqj9a"&&(sa.textContent=Fo),Fs=r(j),na=p(j,"P",{"data-svelte-h":!0}),v(na)!=="svelte-apl31e"&&(na.innerHTML=zo),zs=r(j),oa=p(j,"UL",{"data-svelte-h":!0}),v(oa)!=="svelte-oy626z"&&(oa.innerHTML=Vo),Vs=r(j),ra=p(j,"P",{"data-svelte-h":!0}),v(ra)!=="svelte-107a13f"&&(ra.innerHTML=So),Ss=r(j),ne=p(j,"DIV",{class:!0});var Me=M(ne);h(gt.$$.fragment,Me),Es=r(Me),la=p(Me,"P",{"data-svelte-h":!0}),v(la)!=="svelte-1q1652n"&&(la.textContent=Eo),Ls=r(Me),h(Be.$$.fragment,Me),Me.forEach(d),Qs=r(j),Z=p(j,"DIV",{class:!0});var E=M(Z);h(ut.$$.fragment,E),Ys=r(E),da=p(E,"P",{"data-svelte-h":!0}),v(da)!=="svelte-9mag6f"&&(da.textContent=Lo),Ws=r(E),ia=p(E,"P",{"data-svelte-h":!0}),v(ia)!=="svelte-11lpom8"&&(ia.textContent=Qo),Hs=r(E),h(Xe.$$.fragment,E),Ps=r(E),h(Ze.$$.fragment,E),As=r(E),h(Fe.$$.fragment,E),E.forEach(d),qs=r(j),oe=p(j,"DIV",{class:!0});var Te=M(oe);h(ft.$$.fragment,Te),Os=r(Te),ca=p(Te,"P",{"data-svelte-h":!0}),v(ca)!=="svelte-1o5q38l"&&(ca.textContent=Yo),Ks=r(Te),h(ze.$$.fragment,Te),Te.forEach(d),en=r(j),re=p(j,"DIV",{class:!0});var ke=M(re);h(ht.$$.fragment,ke),tn=r(ke),pa=p(ke,"P",{"data-svelte-h":!0}),v(pa)!=="svelte-168h2s0"&&(pa.innerHTML=Wo),an=r(ke),h(Ve.$$.fragment,ke),ke.forEach(d),sn=r(j),Se=p(j,"DIV",{class:!0});var Ot=M(Se);h(_t.$$.fragment,Ot),nn=r(Ot),ma=p(Ot,"P",{"data-svelte-h":!0}),v(ma)!=="svelte-1jq5ljq"&&(ma.textContent=Ho),Ot.forEach(d),j.forEach(d),hs=r(t),q=p(t,"DIV",{class:!0});var Je=M(q);h(bt.$$.fragment,Je),on=r(Je),ga=p(Je,"P",{"data-svelte-h":!0}),v(ga)!=="svelte-5e48ll"&&(ga.textContent=Po),rn=r(Je),ua=p(Je,"P",{"data-svelte-h":!0}),v(ua)!=="svelte-1b18j1y"&&(ua.innerHTML=Ao),Je.forEach(d),_s=r(t),xe=p(t,"DIV",{class:!0});var Kt=M(xe);h($t.$$.fragment,Kt),ln=r(Kt),fa=p(Kt,"P",{"data-svelte-h":!0}),v(fa)!=="svelte-1wgsupk"&&(fa.textContent=qo),Kt.forEach(d),bs=r(t),ve=p(t,"DIV",{class:!0});var ea=M(ve);h(xt.$$.fragment,ea),dn=r(ea),ha=p(ea,"P",{"data-svelte-h":!0}),v(ha)!=="svelte-17aolem"&&(ha.textContent=Oo),ea.forEach(d),$s=r(t),Q=p(t,"DIV",{class:!0});var K=M(Q);h(vt.$$.fragment,K),cn=r(K),_a=p(K,"P",{"data-svelte-h":!0}),v(_a)!=="svelte-15gz2dy"&&(_a.innerHTML=Ko),pn=r(K),ba=p(K,"P",{"data-svelte-h":!0}),v(ba)!=="svelte-1m2o9um"&&(ba.innerHTML=er),mn=r(K),W=p(K,"DIV",{class:!0});var ee=M(W);h(wt.$$.fragment,ee),gn=r(ee),$a=p(ee,"P",{"data-svelte-h":!0}),v($a)!=="svelte-1h03lp6"&&($a.textContent=tr),un=r(ee),xa=p(ee,"UL",{"data-svelte-h":!0}),v(xa)!=="svelte-y69nf2"&&(xa.innerHTML=ar),fn=r(ee),va=p(ee,"P",{"data-svelte-h":!0}),v(va)!=="svelte-d2y9u1"&&(va.textContent=sr),ee.forEach(d),K.forEach(d),xs=r(t),h(yt.$$.fragment,t),vs=r(t),N=p(t,"DIV",{class:!0});var B=M(N);h(Mt.$$.fragment,B),hn=r(B),H=p(B,"DIV",{class:!0});var te=M(H);h(Tt.$$.fragment,te),_n=r(te),wa=p(te,"P",{"data-svelte-h":!0}),v(wa)!=="svelte-19i8z0e"&&(wa.textContent=nr),bn=r(te),ya=p(te,"P",{"data-svelte-h":!0}),v(ya)!=="svelte-a30fyv"&&(ya.innerHTML=or),$n=r(te),h(Ee.$$.fragment,te),te.forEach(d),xn=r(B),le=p(B,"DIV",{class:!0});var Ce=M(le);h(kt.$$.fragment,Ce),vn=r(Ce),Ma=p(Ce,"P",{"data-svelte-h":!0}),v(Ma)!=="svelte-xkawo0"&&(Ma.innerHTML=rr),wn=r(Ce),h(Le.$$.fragment,Ce),Ce.forEach(d),yn=r(B),de=p(B,"DIV",{class:!0});var Ue=M(de);h(Jt.$$.fragment,Ue),Mn=r(Ue),Ta=p(Ue,"P",{"data-svelte-h":!0}),v(Ta)!=="svelte-1tww4ej"&&(Ta.innerHTML=lr),Tn=r(Ue),h(Qe.$$.fragment,Ue),Ue.forEach(d),kn=r(B),ie=p(B,"DIV",{class:!0});var Re=M(ie);h(Ct.$$.fragment,Re),Jn=r(Re),ka=p(Re,"P",{"data-svelte-h":!0}),v(ka)!=="svelte-1vlembv"&&(ka.textContent=dr),Cn=r(Re),h(Ye.$$.fragment,Re),Re.forEach(d),Un=r(B),ce=p(B,"DIV",{class:!0});var je=M(ce);h(Ut.$$.fragment,je),Rn=r(je),Ja=p(je,"P",{"data-svelte-h":!0}),v(Ja)!=="svelte-1ephcm7"&&(Ja.textContent=ir),jn=r(je),h(We.$$.fragment,je),je.forEach(d),Nn=r(B),pe=p(B,"DIV",{class:!0});var Ne=M(pe);h(Rt.$$.fragment,Ne),Gn=r(Ne),Ca=p(Ne,"P",{"data-svelte-h":!0}),v(Ca)!=="svelte-1sadrg0"&&(Ca.textContent=cr),Dn=r(Ne),h(He.$$.fragment,Ne),Ne.forEach(d),In=r(B),Pe=p(B,"DIV",{class:!0});var ta=M(Pe);h(jt.$$.fragment,ta),Bn=r(ta),Ua=p(ta,"P",{"data-svelte-h":!0}),v(Ua)!=="svelte-1ue62pg"&&(Ua.textContent=pr),ta.forEach(d),B.forEach(d),ws=r(t),D=p(t,"DIV",{class:!0});var X=M(D);h(Nt.$$.fragment,X),Xn=r(X),Ra=p(X,"P",{"data-svelte-h":!0}),v(Ra)!=="svelte-2x5qds"&&(Ra.innerHTML=mr),Zn=r(X),me=p(X,"DIV",{class:!0});var Ge=M(me);h(Gt.$$.fragment,Ge),Fn=r(Ge),ja=p(Ge,"P",{"data-svelte-h":!0}),v(ja)!=="svelte-z89fig"&&(ja.innerHTML=gr),zn=r(Ge),h(Ae.$$.fragment,Ge),Ge.forEach(d),Vn=r(X),P=p(X,"DIV",{class:!0});var ae=M(P);h(Dt.$$.fragment,ae),Sn=r(ae),Na=p(ae,"P",{"data-svelte-h":!0}),v(Na)!=="svelte-vb22br"&&(Na.innerHTML=ur),En=r(ae),Ga=p(ae,"P",{"data-svelte-h":!0}),v(Ga)!=="svelte-1hkl2pt"&&(Ga.innerHTML=fr),Ln=r(ae),h(qe.$$.fragment,ae),ae.forEach(d),Qn=r(X),A=p(X,"DIV",{class:!0});var se=M(A);h(It.$$.fragment,se),Yn=r(se),Da=p(se,"P",{"data-svelte-h":!0}),v(Da)!=="svelte-sgtbuc"&&(Da.textContent=hr),Wn=r(se),Ia=p(se,"P",{"data-svelte-h":!0}),v(Ia)!=="svelte-5qr3om"&&(Ia.innerHTML=_r),Hn=r(se),h(Oe.$$.fragment,se),se.forEach(d),Pn=r(X),ge=p(X,"DIV",{class:!0});var De=M(ge);h(Bt.$$.fragment,De),An=r(De),Ba=p(De,"P",{"data-svelte-h":!0}),v(Ba)!=="svelte-1ephcm7"&&(Ba.textContent=br),qn=r(De),h(Ke.$$.fragment,De),De.forEach(d),On=r(X),ue=p(X,"DIV",{class:!0});var Ie=M(ue);h(Xt.$$.fragment,Ie),Kn=r(Ie),Xa=p(Ie,"P",{"data-svelte-h":!0}),v(Xa)!=="svelte-1kdi5en"&&(Xa.textContent=$r),eo=r(Ie),h(et.$$.fragment,Ie),Ie.forEach(d),X.forEach(d),ys=r(t),we=p(t,"DIV",{class:!0});var aa=M(we);h(Zt.$$.fragment,aa),to=r(aa),Za=p(aa,"P",{"data-svelte-h":!0}),v(Za)!=="svelte-1equdtb"&&(Za.textContent=xr),aa.forEach(d),Ms=r(t),z=p(t,"DIV",{class:!0});var _e=M(z);h(Ft.$$.fragment,_e),ao=r(_e),Fa=p(_e,"P",{"data-svelte-h":!0}),v(Fa)!=="svelte-nmj2uv"&&(Fa.innerHTML=vr),so=r(_e),za=p(_e,"P",{"data-svelte-h":!0}),v(za)!=="svelte-xtdw9q"&&(za.innerHTML=wr),no=r(_e),Va=p(_e,"P",{"data-svelte-h":!0}),v(Va)!=="svelte-a4zsdi"&&(Va.textContent=yr),oo=r(_e),Sa=p(_e,"TABLE",{"data-svelte-h":!0}),v(Sa)!=="svelte-pv0x4r"&&(Sa.innerHTML=Mr),_e.forEach(d),Ts=r(t),h(zt.$$.fragment,t),ks=r(t),V=p(t,"DIV",{class:!0});var be=M(V);h(Vt.$$.fragment,be),ro=r(be),Ea=p(be,"P",{"data-svelte-h":!0}),v(Ea)!=="svelte-1eqexd"&&(Ea.innerHTML=Tr),lo=r(be),La=p(be,"P",{"data-svelte-h":!0}),v(La)!=="svelte-13iynk4"&&(La.innerHTML=kr),io=r(be),Qa=p(be,"P",{"data-svelte-h":!0}),v(Qa)!=="svelte-1luabaw"&&(Qa.textContent=Jr),co=r(be),Ya=p(be,"TABLE",{"data-svelte-h":!0}),v(Ya)!=="svelte-6p84mg"&&(Ya.innerHTML=Cr),be.forEach(d),Js=r(t),h(St.$$.fragment,t),Cs=r(t),Y=p(t,"DIV",{class:!0});var ct=M(Y);h(Et.$$.fragment,ct),po=r(ct),Wa=p(ct,"P",{"data-svelte-h":!0}),v(Wa)!=="svelte-18qkgha"&&(Wa.textContent=Ur),mo=r(ct),Ha=p(ct,"P",{"data-svelte-h":!0}),v(Ha)!=="svelte-fn7w0y"&&(Ha.innerHTML=Rr),go=r(ct),h(tt.$$.fragment,ct),ct.forEach(d),Us=r(t),I=p(t,"DIV",{class:!0});var L=M(I);h(Lt.$$.fragment,L),uo=r(L),Pa=p(L,"P",{"data-svelte-h":!0}),v(Pa)!=="svelte-ewaslg"&&(Pa.innerHTML=jr),fo=r(L),Aa=p(L,"P",{"data-svelte-h":!0}),v(Aa)!=="svelte-l59ai2"&&(Aa.textContent=Nr),ho=r(L),qa=p(L,"UL",{"data-svelte-h":!0}),v(qa)!=="svelte-sbyekb"&&(qa.innerHTML=Gr),_o=r(L),Oa=p(L,"P",{"data-svelte-h":!0}),v(Oa)!=="svelte-20xdby"&&(Oa.innerHTML=Dr),bo=r(L),Ka=p(L,"P",{"data-svelte-h":!0}),v(Ka)!=="svelte-1cn2wk0"&&(Ka.innerHTML=Ir),$o=r(L),h(at.$$.fragment,L),L.forEach(d),Rs=r(t),G=p(t,"DIV",{class:!0});var F=M(G);h(Qt.$$.fragment,F),xo=r(F),es=p(F,"P",{"data-svelte-h":!0}),v(es)!=="svelte-124iux6"&&(es.textContent=Br),vo=r(F),ts=p(F,"P",{"data-svelte-h":!0}),v(ts)!=="svelte-11lpom8"&&(ts.textContent=Xr),wo=r(F),h(st.$$.fragment,F),yo=r(F),as=p(F,"P",{"data-svelte-h":!0}),v(as)!=="svelte-5jjbkq"&&(as.textContent=Zr),Mo=r(F),h(nt.$$.fragment,F),To=r(F),h(ot.$$.fragment,F),ko=r(F),h(rt.$$.fragment,F),F.forEach(d),js=r(t),ye=p(t,"DIV",{class:!0});var Xs=M(ye);h(Yt.$$.fragment,Xs),Jo=r(Xs),ss=p(Xs,"P",{"data-svelte-h":!0}),v(ss)!=="svelte-11ie63y"&&(ss.textContent=Fr),Xs.forEach(d),Ns=r(t),S=p(t,"DIV",{class:!0});var $e=M(S);h(Wt.$$.fragment,$e),Co=r($e),ns=p($e,"P",{"data-svelte-h":!0}),v(ns)!=="svelte-3dhs2m"&&(ns.textContent=zr),Uo=r($e),h(lt.$$.fragment,$e),Ro=r($e),fe=p($e,"DIV",{class:!0});var is=M(fe);h(Ht.$$.fragment,is),jo=r(is),os=p(is,"P",{"data-svelte-h":!0}),v(os)!=="svelte-1g1y80g"&&(os.innerHTML=Vr),No=r(is),h(dt.$$.fragment,is),is.forEach(d),Go=r($e),he=p($e,"DIV",{class:!0});var cs=M(he);h(Pt.$$.fragment,cs),Do=r(cs),rs=p(cs,"P",{"data-svelte-h":!0}),v(rs)!=="svelte-14tg07e"&&(rs.textContent=Sr),Io=r(cs),ls=p(cs,"P",{"data-svelte-h":!0}),v(ls)!=="svelte-l773xk"&&(ls.textContent=Er),cs.forEach(d),$e.forEach(d),Gs=r(t),h(At.$$.fragment,t),Ds=r(t),O=p(t,"DIV",{class:!0});var ps=M(O);h(qt.$$.fragment,ps),Bo=r(ps),ds=p(ps,"P",{"data-svelte-h":!0}),v(ds)!=="svelte-14lq7j5"&&(ds.innerHTML=Lr),Xo=r(ps),h(it.$$.fragment,ps),ps.forEach(d),Is=r(t),gs=p(t,"P",{}),M(gs).forEach(d),this.h()},h(){T(a,"name","hf:doc:metadata"),T(a,"content",Ml),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,g){n(document.head,a),u(t,w,g),u(t,i,g),u(t,s,g),_(l,t,g),u(t,e,g),_(m,t,g),u(t,us,g),u(t,pt,g),u(t,fs,g),u(t,R,g),_(mt,R,null),n(R,Zs),n(R,sa),n(R,Fs),n(R,na),n(R,zs),n(R,oa),n(R,Vs),n(R,ra),n(R,Ss),n(R,ne),_(gt,ne,null),n(ne,Es),n(ne,la),n(ne,Ls),_(Be,ne,null),n(R,Qs),n(R,Z),_(ut,Z,null),n(Z,Ys),n(Z,da),n(Z,Ws),n(Z,ia),n(Z,Hs),_(Xe,Z,null),n(Z,Ps),_(Ze,Z,null),n(Z,As),_(Fe,Z,null),n(R,qs),n(R,oe),_(ft,oe,null),n(oe,Os),n(oe,ca),n(oe,Ks),_(ze,oe,null),n(R,en),n(R,re),_(ht,re,null),n(re,tn),n(re,pa),n(re,an),_(Ve,re,null),n(R,sn),n(R,Se),_(_t,Se,null),n(Se,nn),n(Se,ma),u(t,hs,g),u(t,q,g),_(bt,q,null),n(q,on),n(q,ga),n(q,rn),n(q,ua),u(t,_s,g),u(t,xe,g),_($t,xe,null),n(xe,ln),n(xe,fa),u(t,bs,g),u(t,ve,g),_(xt,ve,null),n(ve,dn),n(ve,ha),u(t,$s,g),u(t,Q,g),_(vt,Q,null),n(Q,cn),n(Q,_a),n(Q,pn),n(Q,ba),n(Q,mn),n(Q,W),_(wt,W,null),n(W,gn),n(W,$a),n(W,un),n(W,xa),n(W,fn),n(W,va),u(t,xs,g),_(yt,t,g),u(t,vs,g),u(t,N,g),_(Mt,N,null),n(N,hn),n(N,H),_(Tt,H,null),n(H,_n),n(H,wa),n(H,bn),n(H,ya),n(H,$n),_(Ee,H,null),n(N,xn),n(N,le),_(kt,le,null),n(le,vn),n(le,Ma),n(le,wn),_(Le,le,null),n(N,yn),n(N,de),_(Jt,de,null),n(de,Mn),n(de,Ta),n(de,Tn),_(Qe,de,null),n(N,kn),n(N,ie),_(Ct,ie,null),n(ie,Jn),n(ie,ka),n(ie,Cn),_(Ye,ie,null),n(N,Un),n(N,ce),_(Ut,ce,null),n(ce,Rn),n(ce,Ja),n(ce,jn),_(We,ce,null),n(N,Nn),n(N,pe),_(Rt,pe,null),n(pe,Gn),n(pe,Ca),n(pe,Dn),_(He,pe,null),n(N,In),n(N,Pe),_(jt,Pe,null),n(Pe,Bn),n(Pe,Ua),u(t,ws,g),u(t,D,g),_(Nt,D,null),n(D,Xn),n(D,Ra),n(D,Zn),n(D,me),_(Gt,me,null),n(me,Fn),n(me,ja),n(me,zn),_(Ae,me,null),n(D,Vn),n(D,P),_(Dt,P,null),n(P,Sn),n(P,Na),n(P,En),n(P,Ga),n(P,Ln),_(qe,P,null),n(D,Qn),n(D,A),_(It,A,null),n(A,Yn),n(A,Da),n(A,Wn),n(A,Ia),n(A,Hn),_(Oe,A,null),n(D,Pn),n(D,ge),_(Bt,ge,null),n(ge,An),n(ge,Ba),n(ge,qn),_(Ke,ge,null),n(D,On),n(D,ue),_(Xt,ue,null),n(ue,Kn),n(ue,Xa),n(ue,eo),_(et,ue,null),u(t,ys,g),u(t,we,g),_(Zt,we,null),n(we,to),n(we,Za),u(t,Ms,g),u(t,z,g),_(Ft,z,null),n(z,ao),n(z,Fa),n(z,so),n(z,za),n(z,no),n(z,Va),n(z,oo),n(z,Sa),u(t,Ts,g),_(zt,t,g),u(t,ks,g),u(t,V,g),_(Vt,V,null),n(V,ro),n(V,Ea),n(V,lo),n(V,La),n(V,io),n(V,Qa),n(V,co),n(V,Ya),u(t,Js,g),_(St,t,g),u(t,Cs,g),u(t,Y,g),_(Et,Y,null),n(Y,po),n(Y,Wa),n(Y,mo),n(Y,Ha),n(Y,go),_(tt,Y,null),u(t,Us,g),u(t,I,g),_(Lt,I,null),n(I,uo),n(I,Pa),n(I,fo),n(I,Aa),n(I,ho),n(I,qa),n(I,_o),n(I,Oa),n(I,bo),n(I,Ka),n(I,$o),_(at,I,null),u(t,Rs,g),u(t,G,g),_(Qt,G,null),n(G,xo),n(G,es),n(G,vo),n(G,ts),n(G,wo),_(st,G,null),n(G,yo),n(G,as),n(G,Mo),_(nt,G,null),n(G,To),_(ot,G,null),n(G,ko),_(rt,G,null),u(t,js,g),u(t,ye,g),_(Yt,ye,null),n(ye,Jo),n(ye,ss),u(t,Ns,g),u(t,S,g),_(Wt,S,null),n(S,Co),n(S,ns),n(S,Uo),_(lt,S,null),n(S,Ro),n(S,fe),_(Ht,fe,null),n(fe,jo),n(fe,os),n(fe,No),_(dt,fe,null),n(S,Go),n(S,he),_(Pt,he,null),n(he,Do),n(he,rs),n(he,Io),n(he,ls),u(t,Gs,g),_(At,t,g),u(t,Ds,g),u(t,O,g),_(qt,O,null),n(O,Bo),n(O,ds),n(O,Xo),_(it,O,null),u(t,Is,g),u(t,gs,g),Bs=!0},p(t,[g]){const j={};g&2&&(j.$$scope={dirty:g,ctx:t}),Be.$set(j);const Me={};g&2&&(Me.$$scope={dirty:g,ctx:t}),Xe.$set(Me);const E={};g&2&&(E.$$scope={dirty:g,ctx:t}),Ze.$set(E);const Te={};g&2&&(Te.$$scope={dirty:g,ctx:t}),Fe.$set(Te);const ke={};g&2&&(ke.$$scope={dirty:g,ctx:t}),ze.$set(ke);const Ot={};g&2&&(Ot.$$scope={dirty:g,ctx:t}),Ve.$set(Ot);const Je={};g&2&&(Je.$$scope={dirty:g,ctx:t}),Ee.$set(Je);const Kt={};g&2&&(Kt.$$scope={dirty:g,ctx:t}),Le.$set(Kt);const ea={};g&2&&(ea.$$scope={dirty:g,ctx:t}),Qe.$set(ea);const K={};g&2&&(K.$$scope={dirty:g,ctx:t}),Ye.$set(K);const ee={};g&2&&(ee.$$scope={dirty:g,ctx:t}),We.$set(ee);const B={};g&2&&(B.$$scope={dirty:g,ctx:t}),He.$set(B);const te={};g&2&&(te.$$scope={dirty:g,ctx:t}),Ae.$set(te);const Ce={};g&2&&(Ce.$$scope={dirty:g,ctx:t}),qe.$set(Ce);const Ue={};g&2&&(Ue.$$scope={dirty:g,ctx:t}),Oe.$set(Ue);const Re={};g&2&&(Re.$$scope={dirty:g,ctx:t}),Ke.$set(Re);const je={};g&2&&(je.$$scope={dirty:g,ctx:t}),et.$set(je);const Ne={};g&2&&(Ne.$$scope={dirty:g,ctx:t}),tt.$set(Ne);const ta={};g&2&&(ta.$$scope={dirty:g,ctx:t}),at.$set(ta);const X={};g&2&&(X.$$scope={dirty:g,ctx:t}),st.$set(X);const Ge={};g&2&&(Ge.$$scope={dirty:g,ctx:t}),nt.$set(Ge);const ae={};g&2&&(ae.$$scope={dirty:g,ctx:t}),ot.$set(ae);const se={};g&2&&(se.$$scope={dirty:g,ctx:t}),rt.$set(se);const De={};g&2&&(De.$$scope={dirty:g,ctx:t}),lt.$set(De);const Ie={};g&2&&(Ie.$$scope={dirty:g,ctx:t}),dt.$set(Ie);const aa={};g&2&&(aa.$$scope={dirty:g,ctx:t}),it.$set(aa)},i(t){Bs||(b(l.$$.fragment,t),b(m.$$.fragment,t),b(mt.$$.fragment,t),b(gt.$$.fragment,t),b(Be.$$.fragment,t),b(ut.$$.fragment,t),b(Xe.$$.fragment,t),b(Ze.$$.fragment,t),b(Fe.$$.fragment,t),b(ft.$$.fragment,t),b(ze.$$.fragment,t),b(ht.$$.fragment,t),b(Ve.$$.fragment,t),b(_t.$$.fragment,t),b(bt.$$.fragment,t),b($t.$$.fragment,t),b(xt.$$.fragment,t),b(vt.$$.fragment,t),b(wt.$$.fragment,t),b(yt.$$.fragment,t),b(Mt.$$.fragment,t),b(Tt.$$.fragment,t),b(Ee.$$.fragment,t),b(kt.$$.fragment,t),b(Le.$$.fragment,t),b(Jt.$$.fragment,t),b(Qe.$$.fragment,t),b(Ct.$$.fragment,t),b(Ye.$$.fragment,t),b(Ut.$$.fragment,t),b(We.$$.fragment,t),b(Rt.$$.fragment,t),b(He.$$.fragment,t),b(jt.$$.fragment,t),b(Nt.$$.fragment,t),b(Gt.$$.fragment,t),b(Ae.$$.fragment,t),b(Dt.$$.fragment,t),b(qe.$$.fragment,t),b(It.$$.fragment,t),b(Oe.$$.fragment,t),b(Bt.$$.fragment,t),b(Ke.$$.fragment,t),b(Xt.$$.fragment,t),b(et.$$.fragment,t),b(Zt.$$.fragment,t),b(Ft.$$.fragment,t),b(zt.$$.fragment,t),b(Vt.$$.fragment,t),b(St.$$.fragment,t),b(Et.$$.fragment,t),b(tt.$$.fragment,t),b(Lt.$$.fragment,t),b(at.$$.fragment,t),b(Qt.$$.fragment,t),b(st.$$.fragment,t),b(nt.$$.fragment,t),b(ot.$$.fragment,t),b(rt.$$.fragment,t),b(Yt.$$.fragment,t),b(Wt.$$.fragment,t),b(lt.$$.fragment,t),b(Ht.$$.fragment,t),b(dt.$$.fragment,t),b(Pt.$$.fragment,t),b(At.$$.fragment,t),b(qt.$$.fragment,t),b(it.$$.fragment,t),Bs=!0)},o(t){$(l.$$.fragment,t),$(m.$$.fragment,t),$(mt.$$.fragment,t),$(gt.$$.fragment,t),$(Be.$$.fragment,t),$(ut.$$.fragment,t),$(Xe.$$.fragment,t),$(Ze.$$.fragment,t),$(Fe.$$.fragment,t),$(ft.$$.fragment,t),$(ze.$$.fragment,t),$(ht.$$.fragment,t),$(Ve.$$.fragment,t),$(_t.$$.fragment,t),$(bt.$$.fragment,t),$($t.$$.fragment,t),$(xt.$$.fragment,t),$(vt.$$.fragment,t),$(wt.$$.fragment,t),$(yt.$$.fragment,t),$(Mt.$$.fragment,t),$(Tt.$$.fragment,t),$(Ee.$$.fragment,t),$(kt.$$.fragment,t),$(Le.$$.fragment,t),$(Jt.$$.fragment,t),$(Qe.$$.fragment,t),$(Ct.$$.fragment,t),$(Ye.$$.fragment,t),$(Ut.$$.fragment,t),$(We.$$.fragment,t),$(Rt.$$.fragment,t),$(He.$$.fragment,t),$(jt.$$.fragment,t),$(Nt.$$.fragment,t),$(Gt.$$.fragment,t),$(Ae.$$.fragment,t),$(Dt.$$.fragment,t),$(qe.$$.fragment,t),$(It.$$.fragment,t),$(Oe.$$.fragment,t),$(Bt.$$.fragment,t),$(Ke.$$.fragment,t),$(Xt.$$.fragment,t),$(et.$$.fragment,t),$(Zt.$$.fragment,t),$(Ft.$$.fragment,t),$(zt.$$.fragment,t),$(Vt.$$.fragment,t),$(St.$$.fragment,t),$(Et.$$.fragment,t),$(tt.$$.fragment,t),$(Lt.$$.fragment,t),$(at.$$.fragment,t),$(Qt.$$.fragment,t),$(st.$$.fragment,t),$(nt.$$.fragment,t),$(ot.$$.fragment,t),$(rt.$$.fragment,t),$(Yt.$$.fragment,t),$(Wt.$$.fragment,t),$(lt.$$.fragment,t),$(Ht.$$.fragment,t),$(dt.$$.fragment,t),$(Pt.$$.fragment,t),$(At.$$.fragment,t),$(qt.$$.fragment,t),$(it.$$.fragment,t),Bs=!1},d(t){t&&(d(w),d(i),d(s),d(e),d(us),d(pt),d(fs),d(R),d(hs),d(q),d(_s),d(xe),d(bs),d(ve),d($s),d(Q),d(xs),d(vs),d(N),d(ws),d(D),d(ys),d(we),d(Ms),d(z),d(Ts),d(ks),d(V),d(Js),d(Cs),d(Y),d(Us),d(I),d(Rs),d(G),d(js),d(ye),d(Ns),d(S),d(Gs),d(Ds),d(O),d(Is),d(gs)),d(a),x(l,t),x(m,t),x(mt),x(gt),x(Be),x(ut),x(Xe),x(Ze),x(Fe),x(ft),x(ze),x(ht),x(Ve),x(_t),x(bt),x($t),x(xt),x(vt),x(wt),x(yt,t),x(Mt),x(Tt),x(Ee),x(kt),x(Le),x(Jt),x(Qe),x(Ct),x(Ye),x(Ut),x(We),x(Rt),x(He),x(jt),x(Nt),x(Gt),x(Ae),x(Dt),x(qe),x(It),x(Oe),x(Bt),x(Ke),x(Xt),x(et),x(Zt),x(Ft),x(zt,t),x(Vt),x(St,t),x(Et),x(tt),x(Lt),x(at),x(Qt),x(st),x(nt),x(ot),x(rt),x(Yt),x(Wt),x(lt),x(Ht),x(dt),x(Pt),x(At,t),x(qt),x(it)}}}const Ml='{"title":"Builder classes","local":"builder-classes","sections":[{"title":"Builders","local":"datasets.DatasetBuilder","sections":[],"depth":2},{"title":"Download","local":"datasets.DownloadManager","sections":[],"depth":2},{"title":"Verification","local":"datasets.VerificationMode","sections":[],"depth":2},{"title":"Splits","local":"datasets.SplitGenerator","sections":[],"depth":2},{"title":"Version","local":"datasets.Version","sections":[],"depth":2}],"depth":1}';function Tl(y){return Yr(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Ar}),[]}class Nl extends Wr{constructor(a){super(),Hr(this,a,Tl,yl,Qr,{})}}export{Nl as component};
