import{s as fp,o as bp,n as ie}from"../chunks/scheduler.bdbef820.js";import{S as Mp,i as yp,g as p,s as n,r as c,A as wp,h as i,f as e,c as l,j as jp,u as h,x as r,k as gp,y as Tp,a as t,v as o,d as m,t as d,w as u}from"../chunks/index.c0aea24a.js";import{H as b,g as Jp}from"../chunks/Heading.0e005771.js";import{T as pe}from"../chunks/Tip.31005f7d.js";import{C as g}from"../chunks/CodeBlock.6ccca92e.js";function xp(w){let j,M='All processing methods in this guide return a new <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. Modification is not done in-place. Be careful about overriding your previous dataset!';return{c(){j=p("p"),j.innerHTML=M},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-icwf1a"&&(j.innerHTML=M)},m(f,y){t(f,j,y)},p:ie,d(f){f&&e(j)}}}function $p(w){let j,M="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&quot;int32&quot;)</code> to <code>Value(&quot;bool&quot;)</code> if the original column only contains ones and zeros.";return{c(){j=p("p"),j.innerHTML=M},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1cevxd4"&&(j.innerHTML=M)},m(f,y){t(f,j,y)},p:ie,d(f){f&&e(j)}}}function _p(w){let j,M='🤗 Datasets also has a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.remove_columns">remove_columns()</a> function which is faster because it doesn’t copy the data of the remaining columns.';return{c(){j=p("p"),j.innerHTML=M},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-7guzne"&&(j.innerHTML=M)},m(f,y){t(f,j,y)},p:ie,d(f){f&&e(j)}}}function Up(w){let j,M='🤗 Datasets also provides support for other common data formats such as NumPy, Pandas, and JAX. Check out the <a href="https://huggingface.co/docs/datasets/master/en/use_with_tensorflow#using-totfdataset" rel="nofollow">Using Datasets with TensorFlow</a> guide for more details on how to efficiently create a TensorFlow dataset.';return{c(){j=p("p"),j.innerHTML=M},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1alh0vh"&&(j.innerHTML=M)},m(f,y){t(f,j,y)},p:ie,d(f){f&&e(j)}}}function kp(w){let j,M='Want to save your dataset to a cloud storage provider? Read our <a href="./filesystems">Cloud Storage</a> guide to learn how to save your dataset to AWS or Google Cloud Storage.';return{c(){j=p("p"),j.innerHTML=M},l(f){j=i(f,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1vp9a9n"&&(j.innerHTML=M)},m(f,y){t(f,j,y)},p:ie,d(f){f&&e(j)}}}function vp(w){let j,M,f,y,U,re,k,An="🤗 Datasets provides many tools for modifying the structure and content of a dataset. These tools are important for tidying up a dataset, creating additional columns, converting between features and formats, and much more.",ce,v,Sn="This guide will show you how to:",he,C,Dn="<li>Reorder rows and split the dataset.</li> <li>Rename and remove columns, and other common column operations.</li> <li>Apply processing functions to each example in a dataset.</li> <li>Concatenate datasets.</li> <li>Apply a custom formatting transform.</li> <li>Save and export processed datasets.</li>",oe,I,Ln='For more details specific to processing other dataset modalities, take a look at the <a class="underline decoration-pink-400 decoration-2 font-semibold" href="./audio_process">process audio dataset guide</a>, the <a class="underline decoration-yellow-400 decoration-2 font-semibold" href="./image_process">process image dataset guide</a>, or the <a class="underline decoration-green-400 decoration-2 font-semibold" href="./nlp_process">process text dataset guide</a>.',me,Z,Pn="The examples in this guide use the MRPC dataset, but feel free to load any dataset of your choice and follow along!",de,G,ue,T,je,X,ge,R,Kn=`There are several functions for rearranging the structure of a dataset.
These functions are useful for selecting only the rows you want, creating train and test splits, and sharding very large datasets into smaller chunks.`,fe,V,be,Y,On='Use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.sort">sort()</a> to sort column values according to their numerical values. The provided column must be NumPy compatible.',Me,F,ye,N,sl=`Under the hood, this creates a list of indices that is sorted according to values of the column.
This indices mapping is then used to access the right rows in the underlying Arrow table.`,we,Q,Te,B,al='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.shuffle">shuffle()</a> function randomly rearranges the column values. You can specify the <code>generator</code> parameter in this function to use a different <code>numpy.random.Generator</code> if you want more control over the algorithm used to shuffle the dataset.',Je,W,xe,q,el=`Shuffling takes the list of indices <code>[0:len(my_dataset)]</code> and shuffles it to create an indices mapping.
However as soon as your <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> has an indices mapping, the speed can become 10x slower.
This is because there is an extra step to get the row index to read using the indices mapping, and most importantly, you aren’t reading contiguous chunks of data anymore.
To restore the speed, you’d need to rewrite the entire dataset on your disk again using <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.flatten_indices">Dataset.flatten_indices()</a>, which removes the indices mapping.
Alternatively, you can switch to an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> and leverage its fast approximate shuffling <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>:`,$e,z,_e,H,Ue,E,tl='There are two options for filtering rows in a dataset: <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.select">select()</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a>.',ke,A,nl='<li><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.select">select()</a> returns rows according to a list of indices:</li>',ve,S,Ce,D,ll='<li><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> returns rows that match a specified condition:</li>',Ie,L,Ze,P,pl='<a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.filter">filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',Ge,K,Xe,O,il="Unless the list of indices to keep is contiguous, those methods also create an indices mapping under the hood.",Re,ss,Ve,as,rl='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.train_test_split">train_test_split()</a> function creates train and test splits if your dataset doesn’t already have them. This allows you to adjust the relative proportions or an absolute number of samples in each split. In the example below, use the <code>test_size</code> parameter to create a test split that is 10% of the original dataset:',Ye,es,Fe,ts,cl="The splits are shuffled by default, but you can set <code>shuffle=False</code> to prevent shuffling.",Ne,ns,Qe,ls,hl='🤗 Datasets supports sharding to divide a very large dataset into a predefined number of chunks. Specify the <code>num_shards</code> parameter in <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.shard">shard()</a> to determine the number of shards to split the dataset into. You’ll also need to provide the shard you want to return with the <code>index</code> parameter.',Be,ps,ol='For example, the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">imdb</a> dataset has 25000 examples:',We,is,qe,rs,ml="After sharding the dataset into four chunks, the first shard will only have 6250 examples:",ze,cs,He,hs,Ee,os,dl="The following functions allow you to modify the columns of a dataset. These functions are useful for renaming or removing columns, changing columns to a new set of features, and flattening nested column structures.",Ae,ms,Se,ds,ul='Use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.rename_column">rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',De,us,jl='Provide <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.rename_column">rename_column()</a> with the name of the original column, and the new column name:',Le,js,Pe,gs,Ke,fs,gl='When you need to remove one or more columns, provide the column name to remove to the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.remove_columns">remove_columns()</a> function. Remove more than one column by providing a list of column names:',Oe,bs,st,Ms,fl='Conversely, <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.select_columns">select_columns()</a> selects one or more columns to keep and removes the rest. This function takes either one or a list of column names:',at,ys,et,ws,tt,Ts,bl='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.cast">cast()</a> function transforms the feature type of one or more columns. This function accepts your new <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Features">Features</a> as its argument. The example below demonstrates how to change the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Value">Value</a> features:',nt,Js,lt,J,pt,xs,Ml='Use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.cast_column">cast_column()</a> function to change the feature type of a single column. Pass the column name and its new feature type as arguments:',it,$s,rt,_s,ct,Us,yl="Sometimes a column can be a nested structure of several types. Take a look at the nested structure below from the SQuAD dataset:",ht,ks,ot,vs,wl='The <code>answers</code> field contains two subfields: <code>text</code> and <code>answer_start</code>. Use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.flatten">flatten()</a> function to extract the subfields into their own separate columns:',mt,Cs,dt,Is,Tl="Notice how the subfields are now their own independent columns: <code>answers.text</code> and <code>answers.answer_start</code>.",ut,Zs,jt,Gs,Jl='Some of the more powerful applications of 🤗 Datasets come from using the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function. The primary purpose of <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> is to speed up processing functions. It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.',gt,Xs,xl="In the following example, prefix each <code>sentence1</code> value in the dataset with <code>&#39;My sentence: &#39;</code>.",ft,Rs,$l="Start by creating a function that adds <code>&#39;My sentence: &#39;</code> to the beginning of each sentence. The function needs to accept and output a <code>dict</code>:",bt,Vs,Mt,Ys,_l='Now use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to apply the <code>add_prefix</code> function to the entire dataset:',yt,Fs,wt,Ns,Ul='Let’s take a look at another example, except this time, you’ll remove a column with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',Tt,Qs,kl='Specify the column to remove with the <code>remove_columns</code> parameter in <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a>:',Jt,Bs,xt,x,$t,Ws,vl='You can also use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> with indices if you set <code>with_indices=True</code>. The example below adds the index to the beginning of each sentence:',_t,qs,Ut,zs,Cl='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> also works with the rank of the process if you set <code>with_rank=True</code>. This is analogous to the <code>with_indices</code> parameter. The <code>with_rank</code> parameter in the mapped function goes after the <code>index</code> one if it is already present.',kt,Hs,vt,Es,Il="The main use-case for rank is to parallelize computation across several GPUs. This requires setting <code>multiprocess.set_start_method(&quot;spawn&quot;)</code>. If you don’t you’ll receive the following CUDA error:",Ct,As,It,Ss,Zt,Ds,Zl='Multiprocessing significantly speeds up processing by parallelizing processes on the CPU. Set the <code>num_proc</code> parameter in <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to set the number of processes to use:',Gt,Ls,Xt,Ps,Rt,Ks,Gl='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> parameter. Batch processing enables interesting applications such as splitting long sentences into shorter chunks and data augmentation.',Vt,Os,Yt,sa,Xl="When examples are too long, you may want to split them into several smaller chunks. Begin by creating a function that:",Ft,aa,Rl="<li><p>Splits the <code>sentence1</code> field into chunks of 50 characters.</p></li> <li><p>Stacks all the chunks together to create the new dataset.</p></li>",Nt,ea,Qt,ta,Vl='Apply the function with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a>:',Bt,na,Wt,la,Yl="Notice how the sentences are split into shorter chunks now, and there are more rows in the dataset.",qt,pa,zt,ia,Ht,ra,Fl='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> function could also be used for data augmentation. The following example generates additional words for a masked token in a sentence.',Et,ca,Nl='Load and use the <a href="https://huggingface.co/roberta-base" rel="nofollow">RoBERTA</a> model in 🤗 Transformers’ <a href="https://huggingface.co/transformers/main_classes/pipelines#transformers.FillMaskPipeline" rel="nofollow">FillMaskPipeline</a>:',At,ha,St,oa,Ql="Create a function to randomly select a word to mask in the sentence. The function should also return the original sentence and the top two replacements generated by RoBERTA.",Dt,ma,Lt,da,Bl='Use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> to apply the function over the whole dataset:',Pt,ua,Kt,ja,Wl="For each original sentence, RoBERTA augmented a random word with three alternatives. The original word <code>distorting</code> is supplemented by <code>withholding</code>, <code>suppressing</code>, and <code>destroying</code>.",Ot,ga,sn,fa,ql='Many datasets have splits that can be processed simultaneously with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.DatasetDict.map">DatasetDict.map()</a>. For example, tokenize the <code>sentence1</code> field in the train and test split by:',an,ba,en,Ma,tn,ya,zl='When you use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">map()</a> in a distributed setting, you should also use <a href="https://pytorch.org/docs/stable/distributed?highlight=barrier#torch.distributed.barrier" rel="nofollow">torch.distributed.barrier</a>. This ensures the main process performs the mapping, while the other processes load the results, thereby avoiding duplicate work.',nn,wa,Hl="The following example shows how you can use <code>torch.distributed.barrier</code> to synchronize the processes:",ln,Ta,pn,Ja,rn,xa,El='Separate datasets can be concatenated if they share the same column types. Concatenate datasets with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.concatenate_datasets">concatenate_datasets()</a>:',cn,$a,hn,_a,Al="You can also concatenate two datasets horizontally by setting <code>axis=1</code> as long as the datasets have the same number of rows:",on,Ua,mn,ka,dn,va,Sl=`You can also mix several datasets together by taking alternating examples from each one to create a new dataset. This is known as <em>interleaving</em>, which is enabled by the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> function. Both <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.concatenate_datasets">concatenate_datasets()</a> work with regular <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> objects.
Refer to the <a href="./stream#interleave">Stream</a> guide for an example of how to interleave <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> objects.`,un,Ca,Dl=`You can define sampling probabilities for each of the original datasets to specify how to interleave the datasets.
In this case, the new dataset is constructed by getting examples one by one from a random dataset until one of the datasets runs out of samples.`,jn,Ia,gn,Za,Ll=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,fn,Ga,bn,Xa,Mn,Ra,Pl='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.set_format">set_format()</a> function changes the format of a column to be compatible with some common data formats. Specify the output you’d like in the <code>type</code> parameter and the columns you want to format. Formatting is applied on-the-fly.',yn,Va,Kl="For example, create PyTorch tensors by setting <code>type=&quot;torch&quot;</code>:",wn,Ya,Tn,Fa,Ol='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.with_format">with_format()</a> function also changes the format of a column, except it returns a new <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object:',Jn,Na,xn,$,$n,Qa,sp='If you need to reset the dataset to its original format, use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.reset_format">reset_format()</a> function:',_n,Ba,Un,Wa,kn,qa,ap='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function applies a custom formatting transform on-the-fly. This function replaces any previously specified format. For example, you can use this function to tokenize and pad tokens on-the-fly. Tokenization is only applied when examples are accessed:',vn,za,Cn,Ha,ep='You can also use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> function to decode formats not supported by <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Features">Features</a>. For example, the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature uses <a href="https://python-soundfile.readthedocs.io/en/0.11.0/" rel="nofollow"><code>soundfile</code></a> - a fast and simple library to install - but it does not provide support for less common audio formats. Here is where you can use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.set_transform">set_transform()</a> to apply a custom decoding transform on the fly. You’re free to use any library you like to decode the audio files.',In,Ea,tp='The example below uses the <a href="http://pydub.com/" rel="nofollow"><code>pydub</code></a> package to open an audio format not supported by <code>soundfile</code>:',Zn,Aa,Gn,Sa,Xn,Da,np='Once you are done processing your dataset, you can save and reuse it later with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.save_to_disk">save_to_disk()</a>.',Rn,La,lp="Save your dataset by providing the path to the directory you wish to save it to:",Vn,Pa,Yn,Ka,pp='Use the <a href="/docs/datasets/v2.14.6/en/package_reference/loading_methods#datasets.load_from_disk">load_from_disk()</a> function to reload the dataset:',Fn,Oa,Nn,_,Qn,se,Bn,ae,ip="🤗 Datasets supports exporting as well so you can work with your dataset in other applications. The following table shows currently supported file formats you can export to:",Wn,ee,rp='<thead><tr><th>File type</th> <th>Export method</th></tr></thead> <tbody><tr><td>CSV</td> <td><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.to_csv">Dataset.to_csv()</a></td></tr> <tr><td>JSON</td> <td><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.to_json">Dataset.to_json()</a></td></tr> <tr><td>Parquet</td> <td><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.to_parquet">Dataset.to_parquet()</a></td></tr> <tr><td>SQL</td> <td><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.to_sql">Dataset.to_sql()</a></td></tr> <tr><td>In-memory Python object</td> <td><a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.to_pandas">Dataset.to_pandas()</a> or <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.to_dict">Dataset.to_dict()</a></td></tr></tbody>',qn,te,cp="For example, export your dataset to a CSV file like this:",zn,ne,Hn,le,En;return U=new b({props:{title:"Process",local:"process",headingTag:"h1"}}),G=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),T=new pe({props:{warning:!0,$$slots:{default:[xp]},$$scope:{ctx:w}}}),X=new b({props:{title:"Sort, shuffle, select, split, and shard",local:"sort-shuffle-select-split-and-shard",headingTag:"h2"}}),V=new b({props:{title:"Sort",local:"sort",headingTag:"h3"}}),F=new g({props:{code:"ZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCJTNBMTAlNUQlMEFzb3J0ZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJsYWJlbCUyMiklMEFzb3J0ZWRfZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCJTNBMTAlNUQlMEFzb3J0ZWRfZGF0YXNldCU1QiUyMmxhYmVsJTIyJTVEJTVCLTEwJTNBJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset = dataset.sort(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>sorted_dataset[<span class="hljs-string">&quot;label&quot;</span>][-<span class="hljs-number">10</span>:]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Q=new b({props:{title:"Shuffle",local:"shuffle",headingTag:"h3"}}),W=new g({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHNvcnRlZF9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyKSUwQXNodWZmbGVkX2RhdGFzZXQlNUIlMjJsYWJlbCUyMiU1RCU1QiUzQTEwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = sorted_dataset.shuffle(seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset[<span class="hljs-string">&quot;label&quot;</span>][:<span class="hljs-number">10</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),z=new g({props:{code:"aXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMTI4KSUwQXNodWZmbGVkX2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBpdGVyYWJsZV9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMDAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">128</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_iterable_dataset = iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">1000</span>)`,wrap:!1}}),H=new b({props:{title:"Select and Filter",local:"select-and-filter",headingTag:"h3"}}),S=new g({props:{code:"c21hbGxfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0KCU1QjAlMkMlMjAxMCUyQyUyMDIwJTJDJTIwMzAlMkMlMjA0MCUyQyUyMDUwJTVEKSUwQWxlbihzbWFsbF9kYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_dataset = dataset.select([<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>, <span class="hljs-number">30</span>, <span class="hljs-number">40</span>, <span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(small_dataset)
<span class="hljs-number">6</span>`,wrap:!1}}),L=new g({props:{code:"c3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJTIyc2VudGVuY2UxJTIyJTVELnN0YXJ0c3dpdGgoJTIyQXIlMjIpKSUwQWxlbihzdGFydF93aXRoX2FyKSUwQXN0YXJ0X3dpdGhfYXIlNUIlMjJzZW50ZW5jZTElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&quot;sentence1&quot;</span>].startswith(<span class="hljs-string">&quot;Ar&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(start_with_ar)
<span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar[<span class="hljs-string">&quot;sentence1&quot;</span>]
[<span class="hljs-string">&#x27;Around 0335 GMT , Tab shares were up 19 cents , or 4.4 % , at A $ 4.56 , having earlier set a record high of A $ 4.57 .&#x27;</span>,
<span class="hljs-string">&#x27;Arison said Mann may have been one of the pioneers of the world music movement and he had a deep love of Brazilian music .&#x27;</span>,
<span class="hljs-string">&#x27;Arts helped coach the youth on an eighth-grade football team at Lombardi Middle School in Green Bay .&#x27;</span>,
<span class="hljs-string">&#x27;Around 9 : 00 a.m. EDT ( 1300 GMT ) , the euro was at $ 1.1566 against the dollar , up 0.07 percent on the day .&#x27;</span>,
<span class="hljs-string">&quot;Arguing that the case was an isolated example , Canada has threatened a trade backlash if Tokyo &#x27;s ban is not justified on scientific grounds .&quot;</span>,
<span class="hljs-string">&#x27;Artists are worried the plan would harm those who need help most - performers who have a difficult time lining up shows .&#x27;</span>
]`,wrap:!1}}),K=new g({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsZW4oZXZlbl9kYXRhc2V0KSUwQWxlbihkYXRhc2V0KSUyMCUyRiUyMDI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(even_dataset)
<span class="hljs-number">1834</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset) / <span class="hljs-number">2</span>
<span class="hljs-number">1834.0</span>`,wrap:!1}}),ss=new b({props:{title:"Split",local:"split",headingTag:"h3"}}),es=new g({props:{code:"ZGF0YXNldC50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMSklMEEwLjElMjAqJTIwbGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)
{<span class="hljs-string">&#x27;train&#x27;</span>: Dataset(schema: {<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-string">&#x27;int32&#x27;</span>}, num_rows: <span class="hljs-number">3301</span>),
<span class="hljs-string">&#x27;test&#x27;</span>: Dataset(schema: {<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-string">&#x27;int32&#x27;</span>}, num_rows: <span class="hljs-number">367</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-number">0.1</span> * <span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">366.8</span>`,wrap:!1}}),ns=new b({props:{title:"Shard",local:"shard",headingTag:"h3"}}),is=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBcHJpbnQoZGF0YXNldCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>datasets = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset)
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">25000</span>
})`,wrap:!1}}),cs=new g({props:{code:"ZGF0YXNldC5zaGFyZChudW1fc2hhcmRzJTNENCUyQyUyMGluZGV4JTNEMCklMEFwcmludCgyNTAwMCUyRjQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.shard(num_shards=<span class="hljs-number">4</span>, index=<span class="hljs-number">0</span>)
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">6250</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-number">25000</span>/<span class="hljs-number">4</span>)
<span class="hljs-number">6250.0</span>`,wrap:!1}}),hs=new b({props:{title:"Rename, remove, cast, and flatten",local:"rename-remove-cast-and-flatten",headingTag:"h2"}}),ms=new b({props:{title:"Rename",local:"rename",headingTag:"h3"}}),js=new g({props:{code:"ZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIyc2VudGVuY2UxJTIyJTJDJTIwJTIyc2VudGVuY2VBJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIyc2VudGVuY2UyJTIyJTJDJTIwJTIyc2VudGVuY2VCJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentenceA&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;sentenceB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentenceA&#x27;</span>, <span class="hljs-string">&#x27;sentenceB&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),gs=new b({props:{title:"Remove",local:"remove",headingTag:"h3"}}),bs=new g({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTIybGFiZWwlMjIpJTBBZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiU1RCklMEFkYXRhc2V0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&quot;label&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),ys=new g({props:{code:"ZGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNlbGVjdF9jb2x1bW5zKCU1QidzZW50ZW5jZTEnJTJDJTIwJ3NlbnRlbmNlMiclMkMlMjAnaWR4JyU1RCklMEFkYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc2VsZWN0X2NvbHVtbnMoJ2lkeCcpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.select_columns([<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.select_columns(<span class="hljs-string">&#x27;idx&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;idx&#x27;</span>],
    num_rows: <span class="hljs-number">3668</span>
})`,wrap:!1}}),ws=new b({props:{title:"Cast",local:"cast",headingTag:"h3"}}),Js=new g({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMENsYXNzTGFiZWwlMkMlMjBWYWx1ZSUwQW5ld19mZWF0dXJlcyUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMuY29weSgpJTBBbmV3X2ZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQlMjAlM0QlMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklMEFuZXdfZmVhdHVyZXMlNUIlMjJpZHglMjIlNUQlMjAlM0QlMjBWYWx1ZSglMjJpbnQ2NCUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5jYXN0KG5ld19mZWF0dXJlcyklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&quot;int64&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),J=new pe({props:{$$slots:{default:[$p]},$$scope:{ctx:w}}}),$s=new g({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),_s=new b({props:{title:"Flatten",local:"flatten",headingTag:"h3"}}),ks=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzcXVhZCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;answers&#x27;</span>: <span class="hljs-type">Sequence</span>(feature={<span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), <span class="hljs-string">&#x27;answer_start&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}, length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;context&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;title&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Cs=new g({props:{code:"ZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;context&#x27;</span>, <span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;answers.text&#x27;</span>, <span class="hljs-string">&#x27;answers.answer_start&#x27;</span>],
 num_rows: <span class="hljs-number">87599</span>
})`,wrap:!1}}),Zs=new b({props:{title:"Map",local:"map",headingTag:"h2"}}),Vs=new g({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMjAlM0QlMjAnTXklMjBzZW50ZW5jZSUzQSUyMCclMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UxJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;sentence1&quot;</span>] = <span class="hljs-string">&#x27;My sentence: &#x27;</span> + example[<span class="hljs-string">&quot;sentence1&quot;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Fs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEF1cGRhdGVkX2RhdGFzZXQlNUIlMjJzZW50ZW5jZTElMjIlNUQlNUIlM0E1JTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = small_dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;sentence1&quot;</span>][:<span class="hljs-number">5</span>]
[<span class="hljs-string">&#x27;My sentence: Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&quot;My sentence: Yucaipa owned Dominick &#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion .&quot;</span>,
<span class="hljs-string">&#x27;My sentence: They had published an advertisement on the Internet on June 10 , offering the cargo for sale , he added .&#x27;</span>,
<span class="hljs-string">&#x27;My sentence: Around 0335 GMT , Tab shares were up 19 cents , or 4.4 % , at A $ 4.56 , having earlier set a record high of A $ 4.57 .&#x27;</span>,
]`,wrap:!1}}),Bs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUzQSUyMCU3QiUyMm5ld19zZW50ZW5jZSUyMiUzQSUyMGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlN0QlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnNlbnRlbmNlMSUyMiU1RCklMEF1cGRhdGVkX2RhdGFzZXQuY29sdW1uX25hbWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example: {<span class="hljs-string">&quot;new_sentence&quot;</span>: example[<span class="hljs-string">&quot;sentence1&quot;</span>]}, remove_columns=[<span class="hljs-string">&quot;sentence1&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset.column_names
[<span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;new_sentence&#x27;</span>]`,wrap:!1}}),x=new pe({props:{$$slots:{default:[_p]},$$scope:{ctx:w}}}),qs=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMCU3QiUyMnNlbnRlbmNlMiUyMiUzQSUyMGYlMjIlN0JpZHglN0QlM0ElMjAlMjIlMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTdEJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEF1cGRhdGVkX2RhdGFzZXQlNUIlMjJzZW50ZW5jZTIlMjIlNUQlNUIlM0E1JTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example, idx: {<span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{idx}</span>: &quot;</span> + example[<span class="hljs-string">&quot;sentence2&quot;</span>]}, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset[<span class="hljs-string">&quot;sentence2&quot;</span>][:<span class="hljs-number">5</span>]
[<span class="hljs-string">&#x27;0: Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
 <span class="hljs-string">&quot;1: Yucaipa bought Dominick &#x27;s in 1995 for $ 693 million and sold it to Safeway for $ 1.8 billion in 1998 .&quot;</span>,
 <span class="hljs-string">&quot;2: On June 10 , the ship &#x27;s owners had published an advertisement on the Internet , offering the explosives for sale .&quot;</span>,
 <span class="hljs-string">&#x27;3: Tab shares jumped 20 cents , or 4.6 % , to set a record closing high at A $ 4.57 .&#x27;</span>,
 <span class="hljs-string">&#x27;4: PG &amp; E Corp. shares jumped $ 1.63 or 8 percent to $ 21.03 on the New York Stock Exchange on Friday .&#x27;</span>
]`,wrap:!1}}),Hs=new g({props:{code:"ZnJvbSUyMG11bHRpcHJvY2VzcyUyMGltcG9ydCUyMHNldF9zdGFydF9tZXRob2QlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMG9zJTBBc2V0X3N0YXJ0X21ldGhvZCglMjJzcGF3biUyMiklMEFkZWYlMjBncHVfY29tcHV0YXRpb24oZXhhbXBsZSUyQyUyMHJhbmspJTNBJTBBJTIwJTIwJTIwJTIwb3MuZW52aXJvbiU1QiUyMkNVREFfVklTSUJMRV9ERVZJQ0VTJTIyJTVEJTIwJTNEJTIwc3RyKHJhbmslMjAlMjUlMjB0b3JjaC5jdWRhLmRldmljZV9jb3VudCgpKSUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBiaWclMjBHUFUlMjBjYWxsJTIwZ29lcyUyMGhlcmUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxlcyUwQXVwZGF0ZWRfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGdwdV9jb21wdXRhdGlvbiUyQyUyMHdpdGhfcmFuayUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> multiprocess <span class="hljs-keyword">import</span> set_start_method
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span>set_start_method(<span class="hljs-string">&quot;spawn&quot;</span>)
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">gpu_computation</span>(<span class="hljs-params">example, rank</span>):
<span class="hljs-meta">&gt;&gt;&gt; </span>    os.environ[<span class="hljs-string">&quot;CUDA_VISIBLE_DEVICES&quot;</span>] = <span class="hljs-built_in">str</span>(rank % torch.cuda.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-comment"># Your big GPU call goes here</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">return</span> examples
&gt;&gt;&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(gpu_computation, with_rank=<span class="hljs-literal">True</span>)`,wrap:!1}}),As=new g({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ2Fubm90JTIwcmUtaW5pdGlhbGl6ZSUyMENVREElMjBpbiUyMGZvcmtlZCUyMHN1YnByb2Nlc3MuJTIwVG8lMjB1c2UlMjBDVURBJTIwd2l0aCUyMG11bHRpcHJvY2Vzc2luZyUyQyUyMHlvdSUyMG11c3QlMjB1c2UlMjB0aGUlMjAnc3Bhd24nJTIwc3RhcnQlMjBtZXRob2Qu",highlighted:'RuntimeError: Cannot re-initialize CUDA <span class="hljs-keyword">in</span> forked subprocess. To use CUDA with multiprocessing, you must use the <span class="hljs-string">&#x27;spawn&#x27;</span> start method.',wrap:!1}}),Ss=new b({props:{title:"Multiprocessing",local:"multiprocessing",headingTag:"h3"}}),Ls=new g({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMCU3QiUyMnNlbnRlbmNlMiUyMiUzQSUyMGYlMjIlN0JpZHglN0QlM0ElMjAlMjIlMjAlMkIlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTdEJTJDJTIwbnVtX3Byb2MlM0Q0KQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> example, idx: {<span class="hljs-string">&quot;sentence2&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{idx}</span>: &quot;</span> + example[<span class="hljs-string">&quot;sentence2&quot;</span>]}, num_proc=<span class="hljs-number">4</span>)',wrap:!1}}),Ps=new b({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),Os=new b({props:{title:"Split long examples",local:"split-long-examples",headingTag:"h4"}}),ea=new g({props:{code:"ZGVmJTIwY2h1bmtfZXhhbXBsZXMoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwY2h1bmtzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwc2VudGVuY2UlMjBpbiUyMGV4YW1wbGVzJTVCJTIyc2VudGVuY2UxJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2h1bmtzJTIwJTJCJTNEJTIwJTVCc2VudGVuY2UlNUJpJTNBaSUyMCUyQiUyMDUwJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihzZW50ZW5jZSklMkMlMjA1MCklNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJjaHVua3MlMjIlM0ElMjBjaHVua3MlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk_examples</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    chunks = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sentence1&quot;</span>]:
<span class="hljs-meta">... </span>        chunks += [sentence[i:i + <span class="hljs-number">50</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(sentence), <span class="hljs-number">50</span>)]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chunks&quot;</span>: chunks}`,wrap:!1}}),na=new g({props:{code:"Y2h1bmtlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2h1bmtfZXhhbXBsZXMlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMpJTBBY2h1bmtlZF9kYXRhc2V0JTVCJTNBMTAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset = dataset.<span class="hljs-built_in">map</span>(chunk_examples, batched=<span class="hljs-literal">True</span>, remove_columns=dataset.column_names)
<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset[:<span class="hljs-number">10</span>]
{<span class="hljs-string">&#x27;chunks&#x27;</span>: [<span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the &#x27;</span>,
            <span class="hljs-string">&#x27;witness &quot; , of deliberately distorting his evidenc&#x27;</span>,
            <span class="hljs-string">&#x27;e .&#x27;</span>,
            <span class="hljs-string">&quot;Yucaipa owned Dominick &#x27;s before selling the chain&quot;</span>,
            <span class="hljs-string">&#x27; to Safeway in 1998 for $ 2.5 billion .&#x27;</span>,
            <span class="hljs-string">&#x27;They had published an advertisement on the Interne&#x27;</span>,
            <span class="hljs-string">&#x27;t on June 10 , offering the cargo for sale , he ad&#x27;</span>,
            <span class="hljs-string">&#x27;ded .&#x27;</span>,
            <span class="hljs-string">&#x27;Around 0335 GMT , Tab shares were up 19 cents , or&#x27;</span>,
            <span class="hljs-string">&#x27; 4.4 % , at A $ 4.56 , having earlier set a record&#x27;</span>]}`,wrap:!1}}),pa=new g({props:{code:"ZGF0YXNldCUwQWNodW5rZWRfZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
 features: [<span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;idx&#x27;</span>],
 num_rows: <span class="hljs-number">3668</span>
})
<span class="hljs-meta">&gt;&gt;&gt; </span>chunked_dataset
Dataset(schema: {<span class="hljs-string">&#x27;chunks&#x27;</span>: <span class="hljs-string">&#x27;string&#x27;</span>}, num_rows: <span class="hljs-number">10470</span>)`,wrap:!1}}),ia=new b({props:{title:"Data augmentation",local:"data-augmentation",headingTag:"h4"}}),ha=new g({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRpbnQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFmaWxsbWFzayUyMCUzRCUyMHBpcGVsaW5lKCUyMmZpbGwtbWFzayUyMiUyQyUyMG1vZGVsJTNEJTIycm9iZXJ0YS1iYXNlJTIyKSUwQW1hc2tfdG9rZW4lMjAlM0QlMjBmaWxsbWFzay50b2tlbml6ZXIubWFza190b2tlbiUwQXNtYWxsZXJfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGUlMkMlMjBpJTNBJTIwaSUzQzEwMCUyQyUyMHdpdGhfaW5kaWNlcyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>fillmask = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=<span class="hljs-string">&quot;roberta-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_token = fillmask.tokenizer.mask_token
<span class="hljs-meta">&gt;&gt;&gt; </span>smaller_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> e, i: i&lt;<span class="hljs-number">100</span>, with_indices=<span class="hljs-literal">True</span>)`,wrap:!1}}),ma=new g({props:{code:"ZGVmJTIwYXVnbWVudF9kYXRhKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBzZW50ZW5jZSUyMGluJTIwZXhhbXBsZXMlNUIlMjJzZW50ZW5jZTElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3JkcyUyMCUzRCUyMHNlbnRlbmNlLnNwbGl0KCclMjAnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEslMjAlM0QlMjByYW5kaW50KDElMkMlMjBsZW4od29yZHMpLTEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFza2VkX3NlbnRlbmNlJTIwJTNEJTIwJTIyJTIwJTIyLmpvaW4od29yZHMlNUIlM0FLJTVEJTIwJTIwJTJCJTIwJTVCbWFza190b2tlbiU1RCUyMCUyQiUyMHdvcmRzJTVCSyUyQjElM0ElNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBmaWxsbWFzayhtYXNrZWRfc2VudGVuY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVnbWVudGVkX3NlcXVlbmNlcyUyMCUzRCUyMCU1QnByZWRpY3Rpb25zJTVCaSU1RCU1QiUyMnNlcXVlbmNlJTIyJTVEJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMyklNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTJCJTNEJTIwJTVCc2VudGVuY2UlNUQlMjAlMkIlMjBhdWdtZW50ZWRfc2VxdWVuY2VzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyZGF0YSUyMiUzQSUyMG91dHB1dHMlN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">augment_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    outputs = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> sentence <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sentence1&quot;</span>]:
<span class="hljs-meta">... </span>        words = sentence.split(<span class="hljs-string">&#x27; &#x27;</span>)
<span class="hljs-meta">... </span>        K = randint(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(words)-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>        masked_sentence = <span class="hljs-string">&quot; &quot;</span>.join(words[:K]  + [mask_token] + words[K+<span class="hljs-number">1</span>:])
<span class="hljs-meta">... </span>        predictions = fillmask(masked_sentence)
<span class="hljs-meta">... </span>        augmented_sequences = [predictions[i][<span class="hljs-string">&quot;sequence&quot;</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>)]
<span class="hljs-meta">... </span>        outputs += [sentence] + augmented_sequences
...
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;data&quot;</span>: outputs}`,wrap:!1}}),ua=new g({props:{code:"YXVnbWVudGVkX2RhdGFzZXQlMjAlM0QlMjBzbWFsbGVyX2RhdGFzZXQubWFwKGF1Z21lbnRfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RkYXRhc2V0LmNvbHVtbl9uYW1lcyUyQyUyMGJhdGNoX3NpemUlM0Q4KSUwQWF1Z21lbnRlZF9kYXRhc2V0JTVCJTNBOSU1RCU1QiUyMmRhdGElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>augmented_dataset = smaller_dataset.<span class="hljs-built_in">map</span>(augment_data, batched=<span class="hljs-literal">True</span>, remove_columns=dataset.column_names, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>augmented_dataset[:<span class="hljs-number">9</span>][<span class="hljs-string">&quot;data&quot;</span>]
[<span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately withholding his evidence.&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately suppressing his evidence.&#x27;</span>,
 <span class="hljs-string">&#x27;Amrozi accused his brother, whom he called &quot; the witness &quot;, of deliberately destroying his evidence.&#x27;</span>,
 <span class="hljs-string">&quot;Yucaipa owned Dominick &#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion .&quot;</span>,
 <span class="hljs-string">&#x27;Yucaipa owned Dominick Stores before selling the chain to Safeway in 1998 for $ 2.5 billion.&#x27;</span>,
 <span class="hljs-string">&quot;Yucaipa owned Dominick&#x27;s before selling the chain to Safeway in 1998 for $ 2.5 billion.&quot;</span>,
 <span class="hljs-string">&#x27;Yucaipa owned Dominick Pizza before selling the chain to Safeway in 1998 for $ 2.5 billion.&#x27;</span>
]`,wrap:!1}}),ga=new b({props:{title:"Process multiple splits",local:"process-multiple-splits",headingTag:"h3"}}),ba=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYycpJTBBZW5jb2RlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwZXhhbXBsZXMlM0ElMjB0b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJzZW50ZW5jZTElMjIlNUQpJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBZW5jb2RlZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># load all the splits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> examples: tokenizer(examples[<span class="hljs-string">&quot;sentence1&quot;</span>]), batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: <span class="hljs-string">&#x27;Amrozi accused his brother , whom he called &quot; the witness &quot; , of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&#x27;sentence2&#x27;</span>: <span class="hljs-string">&#x27;Referring to him as only &quot; the witness &quot; , Amrozi accused his brother of deliberately distorting his evidence .&#x27;</span>,
<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
<span class="hljs-string">&#x27;idx&#x27;</span>: <span class="hljs-number">0</span>,
<span class="hljs-string">&#x27;input_ids&#x27;</span>: [  <span class="hljs-number">101</span>,  <span class="hljs-number">7277</span>,  <span class="hljs-number">2180</span>,  <span class="hljs-number">5303</span>,  <span class="hljs-number">4806</span>,  <span class="hljs-number">1117</span>,  <span class="hljs-number">1711</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">2292</span>, <span class="hljs-number">1119</span>,  <span class="hljs-number">1270</span>,   <span class="hljs-number">107</span>,  <span class="hljs-number">1103</span>,  <span class="hljs-number">7737</span>,   <span class="hljs-number">107</span>,   <span class="hljs-number">117</span>,  <span class="hljs-number">1104</span>,  <span class="hljs-number">9938</span>, <span class="hljs-number">4267</span>, <span class="hljs-number">12223</span>, <span class="hljs-number">21811</span>,  <span class="hljs-number">1117</span>,  <span class="hljs-number">2554</span>,   <span class="hljs-number">119</span>,   <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;token_type_ids&#x27;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]
}`,wrap:!1}}),Ma=new b({props:{title:"Distributed usage",local:"distributed-usage",headingTag:"h3"}}),Ta=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWltcG9ydCUyMHRvcmNoLmRpc3RyaWJ1dGVkJTBBJTBBZGF0YXNldDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQSUwQWlmJTIwdHJhaW5pbmdfYXJncy5sb2NhbF9yYW5rJTIwJTNFJTIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMldhaXRpbmclMjBmb3IlMjBtYWluJTIwcHJvY2VzcyUyMHRvJTIwcGVyZm9ybSUyMHRoZSUyMG1hcHBpbmclMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYmFycmllcigpJTBBJTBBZGF0YXNldDIlMjAlM0QlMjBkYXRhc2V0MS5tYXAobGFtYmRhJTIweCUzQSUyMCU3QiUyMmElMjIlM0ElMjB4JTVCJTIyYSUyMiU1RCUyMCUyQiUyMDElN0QpJTBBJTBBaWYlMjB0cmFpbmluZ19hcmdzLmxvY2FsX3JhbmslMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTG9hZGluZyUyMHJlc3VsdHMlMjBmcm9tJTIwbWFpbiUyMHByb2Nlc3MlMjIpJTBBJTIwJTIwJTIwJTIwdG9yY2guZGlzdHJpYnV0ZWQuYmFycmllcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.distributed

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> training_args.local_rank &gt; <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Waiting for main process to perform the mapping&quot;</span>)
<span class="hljs-meta">... </span>    torch.distributed.barrier()

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset2 = dataset1.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;a&quot;</span>: x[<span class="hljs-string">&quot;a&quot;</span>] + <span class="hljs-number">1</span>})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> training_args.local_rank == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading results from main process&quot;</span>)
<span class="hljs-meta">... </span>    torch.distributed.barrier()`,wrap:!1}}),Ja=new b({props:{title:"Concatenate",local:"concatenate",headingTag:"h2"}}),$a=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwY29uY2F0ZW5hdGVfZGF0YXNldHMlMkMlMjBsb2FkX2RhdGFzZXQlMEElMEFib29rY29ycHVzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmJvb2tjb3JwdXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXdpa2klMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyd2lraXBlZGlhJTIyJTJDJTIwJTIyMjAyMjAzMDEuZW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXdpa2klMjAlM0QlMjB3aWtpLnJlbW92ZV9jb2x1bW5zKCU1QmNvbCUyMGZvciUyMGNvbCUyMGluJTIwd2lraS5jb2x1bW5fbmFtZXMlMjBpZiUyMGNvbCUyMCElM0QlMjAlMjJ0ZXh0JTIyJTVEKSUyMCUyMCUyMyUyMG9ubHklMjBrZWVwJTIwdGhlJTIwJ3RleHQnJTIwY29sdW1uJTBBJTBBYXNzZXJ0JTIwYm9va2NvcnB1cy5mZWF0dXJlcy50eXBlJTIwJTNEJTNEJTIwd2lraS5mZWF0dXJlcy50eXBlJTBBYmVydF9kYXRhc2V0JTIwJTNEJTIwY29uY2F0ZW5hdGVfZGF0YXNldHMoJTVCYm9va2NvcnB1cyUyQyUyMHdpa2klNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> concatenate_datasets, load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus = load_dataset(<span class="hljs-string">&quot;bookcorpus&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = load_dataset(<span class="hljs-string">&quot;wikipedia&quot;</span>, <span class="hljs-string">&quot;20220301.en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = wiki.remove_columns([col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> wiki.column_names <span class="hljs-keyword">if</span> col != <span class="hljs-string">&quot;text&quot;</span>])  <span class="hljs-comment"># only keep the &#x27;text&#x27; column</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> bookcorpus.features.<span class="hljs-built_in">type</span> == wiki.features.<span class="hljs-built_in">type</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bert_dataset = concatenate_datasets([bookcorpus, wiki])`,wrap:!1}}),Ua=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWJvb2tjb3JwdXNfaWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaWRzJTIyJTNBJTIwbGlzdChyYW5nZShsZW4oYm9va2NvcnB1cykpKSU3RCklMEFib29rY29ycHVzX3dpdGhfaWRzJTIwJTNEJTIwY29uY2F0ZW5hdGVfZGF0YXNldHMoJTVCYm9va2NvcnB1cyUyQyUyMGJvb2tjb3JwdXNfaWRzJTVEJTJDJTIwYXhpcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus_ids = Dataset.from_dict({<span class="hljs-string">&quot;ids&quot;</span>: <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(bookcorpus)))})
<span class="hljs-meta">&gt;&gt;&gt; </span>bookcorpus_with_ids = concatenate_datasets([bookcorpus, bookcorpus_ids], axis=<span class="hljs-number">1</span>)`,wrap:!1}}),ka=new b({props:{title:"Interleave",local:"interleave",headingTag:"h3"}}),Ia=new g({props:{code:"c2VlZCUyMCUzRCUyMDQyJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuNSUyQyUyMDAuMiU1RCUwQWQxJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCU3RCklMEFkMiUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmElMjIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyU1RCU3RCklMEFkMyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmElMjIlM0ElMjAlNUIyMCUyQyUyMDIxJTJDJTIwMjIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGludGVybGVhdmVfZGF0YXNldHMoJTVCZDElMkMlMjBkMiUyQyUyMGQzJTVEJTJDJTIwcHJvYmFiaWxpdGllcyUzRHByb2JhYmlsaXRpZXMlMkMlMjBzZWVkJTNEc2VlZCklMEFkYXRhc2V0JTVCJTIyYSUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>seed = <span class="hljs-number">42</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.2</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>d1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d2 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d3 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = interleave_datasets([d1, d2, d3], probabilities=probabilities, seed=seed)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;a&quot;</span>]
[<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">20</span>, <span class="hljs-number">12</span>, <span class="hljs-number">0</span>, <span class="hljs-number">21</span>, <span class="hljs-number">13</span>]`,wrap:!1}}),Ga=new g({props:{code:"ZDElMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWQyJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTVEJTdEKSUwQWQzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYSUyMiUzQSUyMCU1QjIwJTJDJTIwMjElMkMlMjAyMiU1RCU3RCklMEFkYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJkMSUyQyUyMGQyJTJDJTIwZDMlNUQlMkMlMjBzdG9wcGluZ19zdHJhdGVneSUzRCUyMmFsbF9leGhhdXN0ZWQlMjIpJTBBZGF0YXNldCU1QiUyMmElMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>d1 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d2 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>d3 = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = interleave_datasets([d1, d2, d3], stopping_strategy=<span class="hljs-string">&quot;all_exhausted&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;a&quot;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">10</span>, <span class="hljs-number">20</span>, <span class="hljs-number">1</span>, <span class="hljs-number">11</span>, <span class="hljs-number">21</span>, <span class="hljs-number">2</span>, <span class="hljs-number">12</span>, <span class="hljs-number">22</span>, <span class="hljs-number">0</span>, <span class="hljs-number">13</span>, <span class="hljs-number">20</span>]`,wrap:!1}}),Xa=new b({props:{title:"Format",local:"format",headingTag:"h2"}}),Ya=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFkYXRhc2V0LnNldF9mb3JtYXQodHlwZSUzRCUyMnRvcmNoJTIyJTJDJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Na=new g({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQodHlwZSUzRCUyMnRvcmNoJTIyJTJDJTIwY29sdW1ucyUzRCU1QiUyMmlucHV0X2lkcyUyMiUyQyUyMCUyMnRva2VuX3R5cGVfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])',wrap:!1}}),$=new pe({props:{$$slots:{default:[Up]},$$scope:{ctx:w}}}),Ba=new g({props:{code:"ZGF0YXNldC5mb3JtYXQlMEFkYXRhc2V0LnJlc2V0X2Zvcm1hdCgpJTBBZGF0YXNldC5mb3JtYXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;torch&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;label&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.reset_format()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;python&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),Wa=new b({props:{title:"Format transform",local:"format-transform",headingTag:"h3"}}),za=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEFkZWYlMjBlbmNvZGUoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGJhdGNoJTVCJTIyc2VudGVuY2UxJTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMmxvbmdlc3QlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMG1heF9sZW5ndGglM0Q1MTIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWRhdGFzZXQuc2V0X3RyYW5zZm9ybShlbmNvZGUpJTBBZGF0YXNldC5mb3JtYXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;sentence1&quot;</span>], padding=<span class="hljs-string">&quot;longest&quot;</span>, truncation=<span class="hljs-literal">True</span>, max_length=<span class="hljs-number">512</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(encode)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">format</span>
{<span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;custom&#x27;</span>, <span class="hljs-string">&#x27;format_kwargs&#x27;</span>: {<span class="hljs-string">&#x27;transform&#x27;</span>: &lt;function __main__.encode(batch)&gt;}, <span class="hljs-string">&#x27;columns&#x27;</span>: [<span class="hljs-string">&#x27;idx&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>, <span class="hljs-string">&#x27;sentence1&#x27;</span>, <span class="hljs-string">&#x27;sentence2&#x27;</span>], <span class="hljs-string">&#x27;output_all_columns&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),Aa=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMHB5ZHViJTIwaW1wb3J0JTIwQXVkaW9TZWdtZW50JTBBJTBBYXVkaW9fZGF0YXNldF9hbXIlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMCU1QiUyMmF1ZGlvX3NhbXBsZXMlMkZhdWRpby5hbXIlMjIlNUQlN0QpJTBBJTBBZGVmJTIwZGVjb2RlX2F1ZGlvX3dpdGhfcHlkdWIoYmF0Y2glMkMlMjBzYW1wbGluZ19yYXRlJTNEMTZfMDAwKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB5ZHViX2RlY29kZV9maWxlKGF1ZGlvX3BhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291bmQlMjAlM0QlMjBBdWRpb1NlZ21lbnQuZnJvbV9maWxlKGF1ZGlvX3BhdGgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzb3VuZC5mcmFtZV9yYXRlJTIwISUzRCUyMHNhbXBsaW5nX3JhdGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzb3VuZCUyMCUzRCUyMHNvdW5kLnNldF9mcmFtZV9yYXRlKHNhbXBsaW5nX3JhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2hhbm5lbF9zb3VuZHMlMjAlM0QlMjBzb3VuZC5zcGxpdF90b19tb25vKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGVzJTIwJTNEJTIwJTVCcy5nZXRfYXJyYXlfb2Zfc2FtcGxlcygpJTIwZm9yJTIwcyUyMGluJTIwY2hhbm5lbF9zb3VuZHMlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcF9hcnIlMjAlM0QlMjBucC5hcnJheShzYW1wbGVzKS5ULmFzdHlwZShucC5mbG9hdDMyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwX2FyciUyMCUyRiUzRCUyMG5wLmlpbmZvKHNhbXBsZXMlNUIwJTVELnR5cGVjb2RlKS5tYXglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmcF9hcnIlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmF1ZGlvJTIyJTVEJTIwJTNEJTIwJTVCcHlkdWJfZGVjb2RlX2ZpbGUoYXVkaW9fcGF0aCklMjBmb3IlMjBhdWRpb19wYXRoJTIwaW4lMjBiYXRjaCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEFhdWRpb19kYXRhc2V0X2Ftci5zZXRfdHJhbnNmb3JtKGRlY29kZV9hdWRpb193aXRoX3B5ZHViKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pydub <span class="hljs-keyword">import</span> AudioSegment

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset_amr = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: [<span class="hljs-string">&quot;audio_samples/audio.amr&quot;</span>]})

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">decode_audio_with_pydub</span>(<span class="hljs-params">batch, sampling_rate=<span class="hljs-number">16_000</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">pydub_decode_file</span>(<span class="hljs-params">audio_path</span>):
<span class="hljs-meta">... </span>        sound = AudioSegment.from_file(audio_path)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> sound.frame_rate != sampling_rate:
<span class="hljs-meta">... </span>            sound = sound.set_frame_rate(sampling_rate)
<span class="hljs-meta">... </span>        channel_sounds = sound.split_to_mono()
<span class="hljs-meta">... </span>        samples = [s.get_array_of_samples() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> channel_sounds]
<span class="hljs-meta">... </span>        fp_arr = np.array(samples).T.astype(np.float32)
<span class="hljs-meta">... </span>        fp_arr /= np.iinfo(samples[<span class="hljs-number">0</span>].typecode).<span class="hljs-built_in">max</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> fp_arr
...
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;audio&quot;</span>] = [pydub_decode_file(audio_path) <span class="hljs-keyword">for</span> audio_path <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;audio&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_dataset_amr.set_transform(decode_audio_with_pydub)`,wrap:!1}}),Sa=new b({props:{title:"Save",local:"save",headingTag:"h2"}}),Pa=new g({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnNhdmVfdG9fZGlzayglMjJwYXRoJTJGb2YlMkZteSUyRmRhdGFzZXQlMkZkaXJlY3RvcnklMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.save_to_disk(<span class="hljs-string">&quot;path/of/my/dataset/directory&quot;</span>)',wrap:!1}}),Oa=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEFyZWxvYWRlZF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9mcm9tX2Rpc2soJTIycGF0aCUyRm9mJTJGbXklMkZkYXRhc2V0JTJGZGlyZWN0b3J5JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span>reloaded_dataset = load_from_disk(<span class="hljs-string">&quot;path/of/my/dataset/directory&quot;</span>)`,wrap:!1}}),_=new pe({props:{$$slots:{default:[kp]},$$scope:{ctx:w}}}),se=new b({props:{title:"Export",local:"export",headingTag:"h2"}}),ne=new g({props:{code:"ZW5jb2RlZF9kYXRhc2V0LnRvX2NzdiglMjJwYXRoJTJGb2YlMkZteSUyRmRhdGFzZXQuY3N2JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_dataset.to_csv(<span class="hljs-string">&quot;path/of/my/dataset.csv&quot;</span>)',wrap:!1}}),{c(){j=p("meta"),M=n(),f=p("p"),y=n(),c(U.$$.fragment),re=n(),k=p("p"),k.textContent=An,ce=n(),v=p("p"),v.textContent=Sn,he=n(),C=p("ul"),C.innerHTML=Dn,oe=n(),I=p("p"),I.innerHTML=Ln,me=n(),Z=p("p"),Z.textContent=Pn,de=n(),c(G.$$.fragment),ue=n(),c(T.$$.fragment),je=n(),c(X.$$.fragment),ge=n(),R=p("p"),R.textContent=Kn,fe=n(),c(V.$$.fragment),be=n(),Y=p("p"),Y.innerHTML=On,Me=n(),c(F.$$.fragment),ye=n(),N=p("p"),N.textContent=sl,we=n(),c(Q.$$.fragment),Te=n(),B=p("p"),B.innerHTML=al,Je=n(),c(W.$$.fragment),xe=n(),q=p("p"),q.innerHTML=el,$e=n(),c(z.$$.fragment),_e=n(),c(H.$$.fragment),Ue=n(),E=p("p"),E.innerHTML=tl,ke=n(),A=p("ul"),A.innerHTML=nl,ve=n(),c(S.$$.fragment),Ce=n(),D=p("ul"),D.innerHTML=ll,Ie=n(),c(L.$$.fragment),Ze=n(),P=p("p"),P.innerHTML=pl,Ge=n(),c(K.$$.fragment),Xe=n(),O=p("p"),O.textContent=il,Re=n(),c(ss.$$.fragment),Ve=n(),as=p("p"),as.innerHTML=rl,Ye=n(),c(es.$$.fragment),Fe=n(),ts=p("p"),ts.innerHTML=cl,Ne=n(),c(ns.$$.fragment),Qe=n(),ls=p("p"),ls.innerHTML=hl,Be=n(),ps=p("p"),ps.innerHTML=ol,We=n(),c(is.$$.fragment),qe=n(),rs=p("p"),rs.textContent=ml,ze=n(),c(cs.$$.fragment),He=n(),c(hs.$$.fragment),Ee=n(),os=p("p"),os.textContent=dl,Ae=n(),c(ms.$$.fragment),Se=n(),ds=p("p"),ds.innerHTML=ul,De=n(),us=p("p"),us.innerHTML=jl,Le=n(),c(js.$$.fragment),Pe=n(),c(gs.$$.fragment),Ke=n(),fs=p("p"),fs.innerHTML=gl,Oe=n(),c(bs.$$.fragment),st=n(),Ms=p("p"),Ms.innerHTML=fl,at=n(),c(ys.$$.fragment),et=n(),c(ws.$$.fragment),tt=n(),Ts=p("p"),Ts.innerHTML=bl,nt=n(),c(Js.$$.fragment),lt=n(),c(J.$$.fragment),pt=n(),xs=p("p"),xs.innerHTML=Ml,it=n(),c($s.$$.fragment),rt=n(),c(_s.$$.fragment),ct=n(),Us=p("p"),Us.textContent=yl,ht=n(),c(ks.$$.fragment),ot=n(),vs=p("p"),vs.innerHTML=wl,mt=n(),c(Cs.$$.fragment),dt=n(),Is=p("p"),Is.innerHTML=Tl,ut=n(),c(Zs.$$.fragment),jt=n(),Gs=p("p"),Gs.innerHTML=Jl,gt=n(),Xs=p("p"),Xs.innerHTML=xl,ft=n(),Rs=p("p"),Rs.innerHTML=$l,bt=n(),c(Vs.$$.fragment),Mt=n(),Ys=p("p"),Ys.innerHTML=_l,yt=n(),c(Fs.$$.fragment),wt=n(),Ns=p("p"),Ns.innerHTML=Ul,Tt=n(),Qs=p("p"),Qs.innerHTML=kl,Jt=n(),c(Bs.$$.fragment),xt=n(),c(x.$$.fragment),$t=n(),Ws=p("p"),Ws.innerHTML=vl,_t=n(),c(qs.$$.fragment),Ut=n(),zs=p("p"),zs.innerHTML=Cl,kt=n(),c(Hs.$$.fragment),vt=n(),Es=p("p"),Es.innerHTML=Il,Ct=n(),c(As.$$.fragment),It=n(),c(Ss.$$.fragment),Zt=n(),Ds=p("p"),Ds.innerHTML=Zl,Gt=n(),c(Ls.$$.fragment),Xt=n(),c(Ps.$$.fragment),Rt=n(),Ks=p("p"),Ks.innerHTML=Gl,Vt=n(),c(Os.$$.fragment),Yt=n(),sa=p("p"),sa.textContent=Xl,Ft=n(),aa=p("ol"),aa.innerHTML=Rl,Nt=n(),c(ea.$$.fragment),Qt=n(),ta=p("p"),ta.innerHTML=Vl,Bt=n(),c(na.$$.fragment),Wt=n(),la=p("p"),la.textContent=Yl,qt=n(),c(pa.$$.fragment),zt=n(),c(ia.$$.fragment),Ht=n(),ra=p("p"),ra.innerHTML=Fl,Et=n(),ca=p("p"),ca.innerHTML=Nl,At=n(),c(ha.$$.fragment),St=n(),oa=p("p"),oa.textContent=Ql,Dt=n(),c(ma.$$.fragment),Lt=n(),da=p("p"),da.innerHTML=Bl,Pt=n(),c(ua.$$.fragment),Kt=n(),ja=p("p"),ja.innerHTML=Wl,Ot=n(),c(ga.$$.fragment),sn=n(),fa=p("p"),fa.innerHTML=ql,an=n(),c(ba.$$.fragment),en=n(),c(Ma.$$.fragment),tn=n(),ya=p("p"),ya.innerHTML=zl,nn=n(),wa=p("p"),wa.innerHTML=Hl,ln=n(),c(Ta.$$.fragment),pn=n(),c(Ja.$$.fragment),rn=n(),xa=p("p"),xa.innerHTML=El,cn=n(),c($a.$$.fragment),hn=n(),_a=p("p"),_a.innerHTML=Al,on=n(),c(Ua.$$.fragment),mn=n(),c(ka.$$.fragment),dn=n(),va=p("p"),va.innerHTML=Sl,un=n(),Ca=p("p"),Ca.textContent=Dl,jn=n(),c(Ia.$$.fragment),gn=n(),Za=p("p"),Za.innerHTML=Ll,fn=n(),c(Ga.$$.fragment),bn=n(),c(Xa.$$.fragment),Mn=n(),Ra=p("p"),Ra.innerHTML=Pl,yn=n(),Va=p("p"),Va.innerHTML=Kl,wn=n(),c(Ya.$$.fragment),Tn=n(),Fa=p("p"),Fa.innerHTML=Ol,Jn=n(),c(Na.$$.fragment),xn=n(),c($.$$.fragment),$n=n(),Qa=p("p"),Qa.innerHTML=sp,_n=n(),c(Ba.$$.fragment),Un=n(),c(Wa.$$.fragment),kn=n(),qa=p("p"),qa.innerHTML=ap,vn=n(),c(za.$$.fragment),Cn=n(),Ha=p("p"),Ha.innerHTML=ep,In=n(),Ea=p("p"),Ea.innerHTML=tp,Zn=n(),c(Aa.$$.fragment),Gn=n(),c(Sa.$$.fragment),Xn=n(),Da=p("p"),Da.innerHTML=np,Rn=n(),La=p("p"),La.textContent=lp,Vn=n(),c(Pa.$$.fragment),Yn=n(),Ka=p("p"),Ka.innerHTML=pp,Fn=n(),c(Oa.$$.fragment),Nn=n(),c(_.$$.fragment),Qn=n(),c(se.$$.fragment),Bn=n(),ae=p("p"),ae.textContent=ip,Wn=n(),ee=p("table"),ee.innerHTML=rp,qn=n(),te=p("p"),te.textContent=cp,zn=n(),c(ne.$$.fragment),Hn=n(),le=p("p"),this.h()},l(s){const a=wp("svelte-u9bgzb",document.head);j=i(a,"META",{name:!0,content:!0}),a.forEach(e),M=l(s),f=i(s,"P",{}),jp(f).forEach(e),y=l(s),h(U.$$.fragment,s),re=l(s),k=i(s,"P",{"data-svelte-h":!0}),r(k)!=="svelte-o0c0lx"&&(k.textContent=An),ce=l(s),v=i(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1aff4p7"&&(v.textContent=Sn),he=l(s),C=i(s,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-141dx8c"&&(C.innerHTML=Dn),oe=l(s),I=i(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1xlvt1h"&&(I.innerHTML=Ln),me=l(s),Z=i(s,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1bplt66"&&(Z.textContent=Pn),de=l(s),h(G.$$.fragment,s),ue=l(s),h(T.$$.fragment,s),je=l(s),h(X.$$.fragment,s),ge=l(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1bmil1o"&&(R.textContent=Kn),fe=l(s),h(V.$$.fragment,s),be=l(s),Y=i(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-rwkze8"&&(Y.innerHTML=On),Me=l(s),h(F.$$.fragment,s),ye=l(s),N=i(s,"P",{"data-svelte-h":!0}),r(N)!=="svelte-50nyg6"&&(N.textContent=sl),we=l(s),h(Q.$$.fragment,s),Te=l(s),B=i(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-64ep7j"&&(B.innerHTML=al),Je=l(s),h(W.$$.fragment,s),xe=l(s),q=i(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-sq2k2n"&&(q.innerHTML=el),$e=l(s),h(z.$$.fragment,s),_e=l(s),h(H.$$.fragment,s),Ue=l(s),E=i(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1mnpwdf"&&(E.innerHTML=tl),ke=l(s),A=i(s,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-pkt1rd"&&(A.innerHTML=nl),ve=l(s),h(S.$$.fragment,s),Ce=l(s),D=i(s,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1buk6w3"&&(D.innerHTML=ll),Ie=l(s),h(L.$$.fragment,s),Ze=l(s),P=i(s,"P",{"data-svelte-h":!0}),r(P)!=="svelte-6tyr6x"&&(P.innerHTML=pl),Ge=l(s),h(K.$$.fragment,s),Xe=l(s),O=i(s,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1y27i4k"&&(O.textContent=il),Re=l(s),h(ss.$$.fragment,s),Ve=l(s),as=i(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-epyare"&&(as.innerHTML=rl),Ye=l(s),h(es.$$.fragment,s),Fe=l(s),ts=i(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-kxs7ja"&&(ts.innerHTML=cl),Ne=l(s),h(ns.$$.fragment,s),Qe=l(s),ls=i(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-el7jvp"&&(ls.innerHTML=hl),Be=l(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1fijfvt"&&(ps.innerHTML=ol),We=l(s),h(is.$$.fragment,s),qe=l(s),rs=i(s,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-189aje2"&&(rs.textContent=ml),ze=l(s),h(cs.$$.fragment,s),He=l(s),h(hs.$$.fragment,s),Ee=l(s),os=i(s,"P",{"data-svelte-h":!0}),r(os)!=="svelte-1vk4iy9"&&(os.textContent=dl),Ae=l(s),h(ms.$$.fragment,s),Se=l(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1120n0q"&&(ds.innerHTML=ul),De=l(s),us=i(s,"P",{"data-svelte-h":!0}),r(us)!=="svelte-15vityn"&&(us.innerHTML=jl),Le=l(s),h(js.$$.fragment,s),Pe=l(s),h(gs.$$.fragment,s),Ke=l(s),fs=i(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-msbfwk"&&(fs.innerHTML=gl),Oe=l(s),h(bs.$$.fragment,s),st=l(s),Ms=i(s,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-1xzo4dt"&&(Ms.innerHTML=fl),at=l(s),h(ys.$$.fragment,s),et=l(s),h(ws.$$.fragment,s),tt=l(s),Ts=i(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-x7vdrq"&&(Ts.innerHTML=bl),nt=l(s),h(Js.$$.fragment,s),lt=l(s),h(J.$$.fragment,s),pt=l(s),xs=i(s,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-4p4hki"&&(xs.innerHTML=Ml),it=l(s),h($s.$$.fragment,s),rt=l(s),h(_s.$$.fragment,s),ct=l(s),Us=i(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-68ctim"&&(Us.textContent=yl),ht=l(s),h(ks.$$.fragment,s),ot=l(s),vs=i(s,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1g05bbu"&&(vs.innerHTML=wl),mt=l(s),h(Cs.$$.fragment,s),dt=l(s),Is=i(s,"P",{"data-svelte-h":!0}),r(Is)!=="svelte-80t9a4"&&(Is.innerHTML=Tl),ut=l(s),h(Zs.$$.fragment,s),jt=l(s),Gs=i(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-19za6by"&&(Gs.innerHTML=Jl),gt=l(s),Xs=i(s,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-1tkgss"&&(Xs.innerHTML=xl),ft=l(s),Rs=i(s,"P",{"data-svelte-h":!0}),r(Rs)!=="svelte-1t98b4r"&&(Rs.innerHTML=$l),bt=l(s),h(Vs.$$.fragment,s),Mt=l(s),Ys=i(s,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-1qqnozj"&&(Ys.innerHTML=_l),yt=l(s),h(Fs.$$.fragment,s),wt=l(s),Ns=i(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-111zwwr"&&(Ns.innerHTML=Ul),Tt=l(s),Qs=i(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-1gtddjd"&&(Qs.innerHTML=kl),Jt=l(s),h(Bs.$$.fragment,s),xt=l(s),h(x.$$.fragment,s),$t=l(s),Ws=i(s,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-cmtsur"&&(Ws.innerHTML=vl),_t=l(s),h(qs.$$.fragment,s),Ut=l(s),zs=i(s,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-phw0qq"&&(zs.innerHTML=Cl),kt=l(s),h(Hs.$$.fragment,s),vt=l(s),Es=i(s,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-1k52pqi"&&(Es.innerHTML=Il),Ct=l(s),h(As.$$.fragment,s),It=l(s),h(Ss.$$.fragment,s),Zt=l(s),Ds=i(s,"P",{"data-svelte-h":!0}),r(Ds)!=="svelte-1hrg8r0"&&(Ds.innerHTML=Zl),Gt=l(s),h(Ls.$$.fragment,s),Xt=l(s),h(Ps.$$.fragment,s),Rt=l(s),Ks=i(s,"P",{"data-svelte-h":!0}),r(Ks)!=="svelte-uvww7n"&&(Ks.innerHTML=Gl),Vt=l(s),h(Os.$$.fragment,s),Yt=l(s),sa=i(s,"P",{"data-svelte-h":!0}),r(sa)!=="svelte-1k1qy5p"&&(sa.textContent=Xl),Ft=l(s),aa=i(s,"OL",{"data-svelte-h":!0}),r(aa)!=="svelte-75f7q"&&(aa.innerHTML=Rl),Nt=l(s),h(ea.$$.fragment,s),Qt=l(s),ta=i(s,"P",{"data-svelte-h":!0}),r(ta)!=="svelte-uwmco9"&&(ta.innerHTML=Vl),Bt=l(s),h(na.$$.fragment,s),Wt=l(s),la=i(s,"P",{"data-svelte-h":!0}),r(la)!=="svelte-cmzler"&&(la.textContent=Yl),qt=l(s),h(pa.$$.fragment,s),zt=l(s),h(ia.$$.fragment,s),Ht=l(s),ra=i(s,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-g52c2z"&&(ra.innerHTML=Fl),Et=l(s),ca=i(s,"P",{"data-svelte-h":!0}),r(ca)!=="svelte-2g3b8l"&&(ca.innerHTML=Nl),At=l(s),h(ha.$$.fragment,s),St=l(s),oa=i(s,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-17o5i9a"&&(oa.textContent=Ql),Dt=l(s),h(ma.$$.fragment,s),Lt=l(s),da=i(s,"P",{"data-svelte-h":!0}),r(da)!=="svelte-1f0la5p"&&(da.innerHTML=Bl),Pt=l(s),h(ua.$$.fragment,s),Kt=l(s),ja=i(s,"P",{"data-svelte-h":!0}),r(ja)!=="svelte-1ww14wc"&&(ja.innerHTML=Wl),Ot=l(s),h(ga.$$.fragment,s),sn=l(s),fa=i(s,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-1xq405v"&&(fa.innerHTML=ql),an=l(s),h(ba.$$.fragment,s),en=l(s),h(Ma.$$.fragment,s),tn=l(s),ya=i(s,"P",{"data-svelte-h":!0}),r(ya)!=="svelte-pewz5p"&&(ya.innerHTML=zl),nn=l(s),wa=i(s,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-1jo5sei"&&(wa.innerHTML=Hl),ln=l(s),h(Ta.$$.fragment,s),pn=l(s),h(Ja.$$.fragment,s),rn=l(s),xa=i(s,"P",{"data-svelte-h":!0}),r(xa)!=="svelte-3idhws"&&(xa.innerHTML=El),cn=l(s),h($a.$$.fragment,s),hn=l(s),_a=i(s,"P",{"data-svelte-h":!0}),r(_a)!=="svelte-qilcw"&&(_a.innerHTML=Al),on=l(s),h(Ua.$$.fragment,s),mn=l(s),h(ka.$$.fragment,s),dn=l(s),va=i(s,"P",{"data-svelte-h":!0}),r(va)!=="svelte-1jw319v"&&(va.innerHTML=Sl),un=l(s),Ca=i(s,"P",{"data-svelte-h":!0}),r(Ca)!=="svelte-1k6sf3c"&&(Ca.textContent=Dl),jn=l(s),h(Ia.$$.fragment,s),gn=l(s),Za=i(s,"P",{"data-svelte-h":!0}),r(Za)!=="svelte-13euv56"&&(Za.innerHTML=Ll),fn=l(s),h(Ga.$$.fragment,s),bn=l(s),h(Xa.$$.fragment,s),Mn=l(s),Ra=i(s,"P",{"data-svelte-h":!0}),r(Ra)!=="svelte-7cjn4g"&&(Ra.innerHTML=Pl),yn=l(s),Va=i(s,"P",{"data-svelte-h":!0}),r(Va)!=="svelte-n6dynl"&&(Va.innerHTML=Kl),wn=l(s),h(Ya.$$.fragment,s),Tn=l(s),Fa=i(s,"P",{"data-svelte-h":!0}),r(Fa)!=="svelte-1yqwvud"&&(Fa.innerHTML=Ol),Jn=l(s),h(Na.$$.fragment,s),xn=l(s),h($.$$.fragment,s),$n=l(s),Qa=i(s,"P",{"data-svelte-h":!0}),r(Qa)!=="svelte-u8hrea"&&(Qa.innerHTML=sp),_n=l(s),h(Ba.$$.fragment,s),Un=l(s),h(Wa.$$.fragment,s),kn=l(s),qa=i(s,"P",{"data-svelte-h":!0}),r(qa)!=="svelte-1qy1ix1"&&(qa.innerHTML=ap),vn=l(s),h(za.$$.fragment,s),Cn=l(s),Ha=i(s,"P",{"data-svelte-h":!0}),r(Ha)!=="svelte-1biz6uk"&&(Ha.innerHTML=ep),In=l(s),Ea=i(s,"P",{"data-svelte-h":!0}),r(Ea)!=="svelte-14kj1ho"&&(Ea.innerHTML=tp),Zn=l(s),h(Aa.$$.fragment,s),Gn=l(s),h(Sa.$$.fragment,s),Xn=l(s),Da=i(s,"P",{"data-svelte-h":!0}),r(Da)!=="svelte-1xnitf8"&&(Da.innerHTML=np),Rn=l(s),La=i(s,"P",{"data-svelte-h":!0}),r(La)!=="svelte-14rfihg"&&(La.textContent=lp),Vn=l(s),h(Pa.$$.fragment,s),Yn=l(s),Ka=i(s,"P",{"data-svelte-h":!0}),r(Ka)!=="svelte-3ao4x6"&&(Ka.innerHTML=pp),Fn=l(s),h(Oa.$$.fragment,s),Nn=l(s),h(_.$$.fragment,s),Qn=l(s),h(se.$$.fragment,s),Bn=l(s),ae=i(s,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-t9rz5l"&&(ae.textContent=ip),Wn=l(s),ee=i(s,"TABLE",{"data-svelte-h":!0}),r(ee)!=="svelte-1to2csi"&&(ee.innerHTML=rp),qn=l(s),te=i(s,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1w51t97"&&(te.textContent=cp),zn=l(s),h(ne.$$.fragment,s),Hn=l(s),le=i(s,"P",{}),jp(le).forEach(e),this.h()},h(){gp(j,"name","hf:doc:metadata"),gp(j,"content",Cp)},m(s,a){Tp(document.head,j),t(s,M,a),t(s,f,a),t(s,y,a),o(U,s,a),t(s,re,a),t(s,k,a),t(s,ce,a),t(s,v,a),t(s,he,a),t(s,C,a),t(s,oe,a),t(s,I,a),t(s,me,a),t(s,Z,a),t(s,de,a),o(G,s,a),t(s,ue,a),o(T,s,a),t(s,je,a),o(X,s,a),t(s,ge,a),t(s,R,a),t(s,fe,a),o(V,s,a),t(s,be,a),t(s,Y,a),t(s,Me,a),o(F,s,a),t(s,ye,a),t(s,N,a),t(s,we,a),o(Q,s,a),t(s,Te,a),t(s,B,a),t(s,Je,a),o(W,s,a),t(s,xe,a),t(s,q,a),t(s,$e,a),o(z,s,a),t(s,_e,a),o(H,s,a),t(s,Ue,a),t(s,E,a),t(s,ke,a),t(s,A,a),t(s,ve,a),o(S,s,a),t(s,Ce,a),t(s,D,a),t(s,Ie,a),o(L,s,a),t(s,Ze,a),t(s,P,a),t(s,Ge,a),o(K,s,a),t(s,Xe,a),t(s,O,a),t(s,Re,a),o(ss,s,a),t(s,Ve,a),t(s,as,a),t(s,Ye,a),o(es,s,a),t(s,Fe,a),t(s,ts,a),t(s,Ne,a),o(ns,s,a),t(s,Qe,a),t(s,ls,a),t(s,Be,a),t(s,ps,a),t(s,We,a),o(is,s,a),t(s,qe,a),t(s,rs,a),t(s,ze,a),o(cs,s,a),t(s,He,a),o(hs,s,a),t(s,Ee,a),t(s,os,a),t(s,Ae,a),o(ms,s,a),t(s,Se,a),t(s,ds,a),t(s,De,a),t(s,us,a),t(s,Le,a),o(js,s,a),t(s,Pe,a),o(gs,s,a),t(s,Ke,a),t(s,fs,a),t(s,Oe,a),o(bs,s,a),t(s,st,a),t(s,Ms,a),t(s,at,a),o(ys,s,a),t(s,et,a),o(ws,s,a),t(s,tt,a),t(s,Ts,a),t(s,nt,a),o(Js,s,a),t(s,lt,a),o(J,s,a),t(s,pt,a),t(s,xs,a),t(s,it,a),o($s,s,a),t(s,rt,a),o(_s,s,a),t(s,ct,a),t(s,Us,a),t(s,ht,a),o(ks,s,a),t(s,ot,a),t(s,vs,a),t(s,mt,a),o(Cs,s,a),t(s,dt,a),t(s,Is,a),t(s,ut,a),o(Zs,s,a),t(s,jt,a),t(s,Gs,a),t(s,gt,a),t(s,Xs,a),t(s,ft,a),t(s,Rs,a),t(s,bt,a),o(Vs,s,a),t(s,Mt,a),t(s,Ys,a),t(s,yt,a),o(Fs,s,a),t(s,wt,a),t(s,Ns,a),t(s,Tt,a),t(s,Qs,a),t(s,Jt,a),o(Bs,s,a),t(s,xt,a),o(x,s,a),t(s,$t,a),t(s,Ws,a),t(s,_t,a),o(qs,s,a),t(s,Ut,a),t(s,zs,a),t(s,kt,a),o(Hs,s,a),t(s,vt,a),t(s,Es,a),t(s,Ct,a),o(As,s,a),t(s,It,a),o(Ss,s,a),t(s,Zt,a),t(s,Ds,a),t(s,Gt,a),o(Ls,s,a),t(s,Xt,a),o(Ps,s,a),t(s,Rt,a),t(s,Ks,a),t(s,Vt,a),o(Os,s,a),t(s,Yt,a),t(s,sa,a),t(s,Ft,a),t(s,aa,a),t(s,Nt,a),o(ea,s,a),t(s,Qt,a),t(s,ta,a),t(s,Bt,a),o(na,s,a),t(s,Wt,a),t(s,la,a),t(s,qt,a),o(pa,s,a),t(s,zt,a),o(ia,s,a),t(s,Ht,a),t(s,ra,a),t(s,Et,a),t(s,ca,a),t(s,At,a),o(ha,s,a),t(s,St,a),t(s,oa,a),t(s,Dt,a),o(ma,s,a),t(s,Lt,a),t(s,da,a),t(s,Pt,a),o(ua,s,a),t(s,Kt,a),t(s,ja,a),t(s,Ot,a),o(ga,s,a),t(s,sn,a),t(s,fa,a),t(s,an,a),o(ba,s,a),t(s,en,a),o(Ma,s,a),t(s,tn,a),t(s,ya,a),t(s,nn,a),t(s,wa,a),t(s,ln,a),o(Ta,s,a),t(s,pn,a),o(Ja,s,a),t(s,rn,a),t(s,xa,a),t(s,cn,a),o($a,s,a),t(s,hn,a),t(s,_a,a),t(s,on,a),o(Ua,s,a),t(s,mn,a),o(ka,s,a),t(s,dn,a),t(s,va,a),t(s,un,a),t(s,Ca,a),t(s,jn,a),o(Ia,s,a),t(s,gn,a),t(s,Za,a),t(s,fn,a),o(Ga,s,a),t(s,bn,a),o(Xa,s,a),t(s,Mn,a),t(s,Ra,a),t(s,yn,a),t(s,Va,a),t(s,wn,a),o(Ya,s,a),t(s,Tn,a),t(s,Fa,a),t(s,Jn,a),o(Na,s,a),t(s,xn,a),o($,s,a),t(s,$n,a),t(s,Qa,a),t(s,_n,a),o(Ba,s,a),t(s,Un,a),o(Wa,s,a),t(s,kn,a),t(s,qa,a),t(s,vn,a),o(za,s,a),t(s,Cn,a),t(s,Ha,a),t(s,In,a),t(s,Ea,a),t(s,Zn,a),o(Aa,s,a),t(s,Gn,a),o(Sa,s,a),t(s,Xn,a),t(s,Da,a),t(s,Rn,a),t(s,La,a),t(s,Vn,a),o(Pa,s,a),t(s,Yn,a),t(s,Ka,a),t(s,Fn,a),o(Oa,s,a),t(s,Nn,a),o(_,s,a),t(s,Qn,a),o(se,s,a),t(s,Bn,a),t(s,ae,a),t(s,Wn,a),t(s,ee,a),t(s,qn,a),t(s,te,a),t(s,zn,a),o(ne,s,a),t(s,Hn,a),t(s,le,a),En=!0},p(s,[a]){const hp={};a&2&&(hp.$$scope={dirty:a,ctx:s}),T.$set(hp);const op={};a&2&&(op.$$scope={dirty:a,ctx:s}),J.$set(op);const mp={};a&2&&(mp.$$scope={dirty:a,ctx:s}),x.$set(mp);const dp={};a&2&&(dp.$$scope={dirty:a,ctx:s}),$.$set(dp);const up={};a&2&&(up.$$scope={dirty:a,ctx:s}),_.$set(up)},i(s){En||(m(U.$$.fragment,s),m(G.$$.fragment,s),m(T.$$.fragment,s),m(X.$$.fragment,s),m(V.$$.fragment,s),m(F.$$.fragment,s),m(Q.$$.fragment,s),m(W.$$.fragment,s),m(z.$$.fragment,s),m(H.$$.fragment,s),m(S.$$.fragment,s),m(L.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(es.$$.fragment,s),m(ns.$$.fragment,s),m(is.$$.fragment,s),m(cs.$$.fragment,s),m(hs.$$.fragment,s),m(ms.$$.fragment,s),m(js.$$.fragment,s),m(gs.$$.fragment,s),m(bs.$$.fragment,s),m(ys.$$.fragment,s),m(ws.$$.fragment,s),m(Js.$$.fragment,s),m(J.$$.fragment,s),m($s.$$.fragment,s),m(_s.$$.fragment,s),m(ks.$$.fragment,s),m(Cs.$$.fragment,s),m(Zs.$$.fragment,s),m(Vs.$$.fragment,s),m(Fs.$$.fragment,s),m(Bs.$$.fragment,s),m(x.$$.fragment,s),m(qs.$$.fragment,s),m(Hs.$$.fragment,s),m(As.$$.fragment,s),m(Ss.$$.fragment,s),m(Ls.$$.fragment,s),m(Ps.$$.fragment,s),m(Os.$$.fragment,s),m(ea.$$.fragment,s),m(na.$$.fragment,s),m(pa.$$.fragment,s),m(ia.$$.fragment,s),m(ha.$$.fragment,s),m(ma.$$.fragment,s),m(ua.$$.fragment,s),m(ga.$$.fragment,s),m(ba.$$.fragment,s),m(Ma.$$.fragment,s),m(Ta.$$.fragment,s),m(Ja.$$.fragment,s),m($a.$$.fragment,s),m(Ua.$$.fragment,s),m(ka.$$.fragment,s),m(Ia.$$.fragment,s),m(Ga.$$.fragment,s),m(Xa.$$.fragment,s),m(Ya.$$.fragment,s),m(Na.$$.fragment,s),m($.$$.fragment,s),m(Ba.$$.fragment,s),m(Wa.$$.fragment,s),m(za.$$.fragment,s),m(Aa.$$.fragment,s),m(Sa.$$.fragment,s),m(Pa.$$.fragment,s),m(Oa.$$.fragment,s),m(_.$$.fragment,s),m(se.$$.fragment,s),m(ne.$$.fragment,s),En=!0)},o(s){d(U.$$.fragment,s),d(G.$$.fragment,s),d(T.$$.fragment,s),d(X.$$.fragment,s),d(V.$$.fragment,s),d(F.$$.fragment,s),d(Q.$$.fragment,s),d(W.$$.fragment,s),d(z.$$.fragment,s),d(H.$$.fragment,s),d(S.$$.fragment,s),d(L.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(is.$$.fragment,s),d(cs.$$.fragment,s),d(hs.$$.fragment,s),d(ms.$$.fragment,s),d(js.$$.fragment,s),d(gs.$$.fragment,s),d(bs.$$.fragment,s),d(ys.$$.fragment,s),d(ws.$$.fragment,s),d(Js.$$.fragment,s),d(J.$$.fragment,s),d($s.$$.fragment,s),d(_s.$$.fragment,s),d(ks.$$.fragment,s),d(Cs.$$.fragment,s),d(Zs.$$.fragment,s),d(Vs.$$.fragment,s),d(Fs.$$.fragment,s),d(Bs.$$.fragment,s),d(x.$$.fragment,s),d(qs.$$.fragment,s),d(Hs.$$.fragment,s),d(As.$$.fragment,s),d(Ss.$$.fragment,s),d(Ls.$$.fragment,s),d(Ps.$$.fragment,s),d(Os.$$.fragment,s),d(ea.$$.fragment,s),d(na.$$.fragment,s),d(pa.$$.fragment,s),d(ia.$$.fragment,s),d(ha.$$.fragment,s),d(ma.$$.fragment,s),d(ua.$$.fragment,s),d(ga.$$.fragment,s),d(ba.$$.fragment,s),d(Ma.$$.fragment,s),d(Ta.$$.fragment,s),d(Ja.$$.fragment,s),d($a.$$.fragment,s),d(Ua.$$.fragment,s),d(ka.$$.fragment,s),d(Ia.$$.fragment,s),d(Ga.$$.fragment,s),d(Xa.$$.fragment,s),d(Ya.$$.fragment,s),d(Na.$$.fragment,s),d($.$$.fragment,s),d(Ba.$$.fragment,s),d(Wa.$$.fragment,s),d(za.$$.fragment,s),d(Aa.$$.fragment,s),d(Sa.$$.fragment,s),d(Pa.$$.fragment,s),d(Oa.$$.fragment,s),d(_.$$.fragment,s),d(se.$$.fragment,s),d(ne.$$.fragment,s),En=!1},d(s){s&&(e(M),e(f),e(y),e(re),e(k),e(ce),e(v),e(he),e(C),e(oe),e(I),e(me),e(Z),e(de),e(ue),e(je),e(ge),e(R),e(fe),e(be),e(Y),e(Me),e(ye),e(N),e(we),e(Te),e(B),e(Je),e(xe),e(q),e($e),e(_e),e(Ue),e(E),e(ke),e(A),e(ve),e(Ce),e(D),e(Ie),e(Ze),e(P),e(Ge),e(Xe),e(O),e(Re),e(Ve),e(as),e(Ye),e(Fe),e(ts),e(Ne),e(Qe),e(ls),e(Be),e(ps),e(We),e(qe),e(rs),e(ze),e(He),e(Ee),e(os),e(Ae),e(Se),e(ds),e(De),e(us),e(Le),e(Pe),e(Ke),e(fs),e(Oe),e(st),e(Ms),e(at),e(et),e(tt),e(Ts),e(nt),e(lt),e(pt),e(xs),e(it),e(rt),e(ct),e(Us),e(ht),e(ot),e(vs),e(mt),e(dt),e(Is),e(ut),e(jt),e(Gs),e(gt),e(Xs),e(ft),e(Rs),e(bt),e(Mt),e(Ys),e(yt),e(wt),e(Ns),e(Tt),e(Qs),e(Jt),e(xt),e($t),e(Ws),e(_t),e(Ut),e(zs),e(kt),e(vt),e(Es),e(Ct),e(It),e(Zt),e(Ds),e(Gt),e(Xt),e(Rt),e(Ks),e(Vt),e(Yt),e(sa),e(Ft),e(aa),e(Nt),e(Qt),e(ta),e(Bt),e(Wt),e(la),e(qt),e(zt),e(Ht),e(ra),e(Et),e(ca),e(At),e(St),e(oa),e(Dt),e(Lt),e(da),e(Pt),e(Kt),e(ja),e(Ot),e(sn),e(fa),e(an),e(en),e(tn),e(ya),e(nn),e(wa),e(ln),e(pn),e(rn),e(xa),e(cn),e(hn),e(_a),e(on),e(mn),e(dn),e(va),e(un),e(Ca),e(jn),e(gn),e(Za),e(fn),e(bn),e(Mn),e(Ra),e(yn),e(Va),e(wn),e(Tn),e(Fa),e(Jn),e(xn),e($n),e(Qa),e(_n),e(Un),e(kn),e(qa),e(vn),e(Cn),e(Ha),e(In),e(Ea),e(Zn),e(Gn),e(Xn),e(Da),e(Rn),e(La),e(Vn),e(Yn),e(Ka),e(Fn),e(Nn),e(Qn),e(Bn),e(ae),e(Wn),e(ee),e(qn),e(te),e(zn),e(Hn),e(le)),e(j),u(U,s),u(G,s),u(T,s),u(X,s),u(V,s),u(F,s),u(Q,s),u(W,s),u(z,s),u(H,s),u(S,s),u(L,s),u(K,s),u(ss,s),u(es,s),u(ns,s),u(is,s),u(cs,s),u(hs,s),u(ms,s),u(js,s),u(gs,s),u(bs,s),u(ys,s),u(ws,s),u(Js,s),u(J,s),u($s,s),u(_s,s),u(ks,s),u(Cs,s),u(Zs,s),u(Vs,s),u(Fs,s),u(Bs,s),u(x,s),u(qs,s),u(Hs,s),u(As,s),u(Ss,s),u(Ls,s),u(Ps,s),u(Os,s),u(ea,s),u(na,s),u(pa,s),u(ia,s),u(ha,s),u(ma,s),u(ua,s),u(ga,s),u(ba,s),u(Ma,s),u(Ta,s),u(Ja,s),u($a,s),u(Ua,s),u(ka,s),u(Ia,s),u(Ga,s),u(Xa,s),u(Ya,s),u(Na,s),u($,s),u(Ba,s),u(Wa,s),u(za,s),u(Aa,s),u(Sa,s),u(Pa,s),u(Oa,s),u(_,s),u(se,s),u(ne,s)}}}const Cp='{"title":"Process","local":"process","sections":[{"title":"Sort, shuffle, select, split, and shard","local":"sort-shuffle-select-split-and-shard","sections":[{"title":"Sort","local":"sort","sections":[],"depth":3},{"title":"Shuffle","local":"shuffle","sections":[],"depth":3},{"title":"Select and Filter","local":"select-and-filter","sections":[],"depth":3},{"title":"Split","local":"split","sections":[],"depth":3},{"title":"Shard","local":"shard","sections":[],"depth":3}],"depth":2},{"title":"Rename, remove, cast, and flatten","local":"rename-remove-cast-and-flatten","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3},{"title":"Flatten","local":"flatten","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Multiprocessing","local":"multiprocessing","sections":[],"depth":3},{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Split long examples","local":"split-long-examples","sections":[],"depth":4},{"title":"Data augmentation","local":"data-augmentation","sections":[],"depth":4}],"depth":3},{"title":"Process multiple splits","local":"process-multiple-splits","sections":[],"depth":3},{"title":"Distributed usage","local":"distributed-usage","sections":[],"depth":3}],"depth":2},{"title":"Concatenate","local":"concatenate","sections":[{"title":"Interleave","local":"interleave","sections":[],"depth":3}],"depth":2},{"title":"Format","local":"format","sections":[{"title":"Format transform","local":"format-transform","sections":[],"depth":3}],"depth":2},{"title":"Save","local":"save","sections":[],"depth":2},{"title":"Export","local":"export","sections":[],"depth":2}],"depth":1}';function Ip(w){return bp(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Jp}),[]}class Yp extends Mp{constructor(j){super(),yp(this,j,Ip,vp,fp,{})}}export{Yp as component};
