import{s as ra,o as ia,n as Gs}from"../chunks/scheduler.bdbef820.js";import{S as ca,i as oa,g as i,s as n,r as o,A as ma,h as c,f as t,c as p,j as na,u as m,x as g,k as pa,y as ha,a as e,v as h,d,t as j,w as u}from"../chunks/index.c0aea24a.js";import{H as as,g as da}from"../chunks/Heading.0e005771.js";import{T as Qs}from"../chunks/Tip.31005f7d.js";import{C as J}from"../chunks/CodeBlock.6ccca92e.js";function ja(f){let l,M=`<code>jax</code> and <code>jaxlib</code> are required to reproduce to code above, so please make sure you
install them as <code>pip install datasets[jax]</code>.`;return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1i2qrbm"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Gs,d(r){r&&t(l)}}}function ua(f){let l,M='A <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast reads from arrays in the dataset to JAX arrays.';return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-a15ajw"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Gs,d(r){r&&t(l)}}}function ga(f){let l,M=`To use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1yizw38"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Gs,d(r){r&&t(l)}}}function Ma(f){let l,M=`To use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-ws1rne"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Gs,d(r){r&&t(l)}}}function ya(f){let l,M,r,y,$,es,C,Vs=`This document is a quick introduction to using <code>datasets</code> with JAX, with a particular focus on how to get
<code>jax.Array</code> objects out of our datasets, and how to use them to train JAX models.`,ls,T,ns,I,ps,R,Bs=`By default, datasets return regular Python objects: integers, floats, strings, lists, etc., and
string and binary objects are unchanged, since JAX only supports numbers.`,rs,Z,Es="To get JAX arrays (numpy-like) instead, you can set the format of the dataset to <code>jax</code>:",is,v,cs,b,os,k,Ys=`Note that the exact same procedure applies to <code>DatasetDict</code> objects, so that
when setting the format of a <code>DatasetDict</code> to <code>jax</code>, all the <code>Dataset</code>s there
will be formatted as <code>jax</code>:`,ms,X,hs,x,Fs=`Another thing you’ll need to take into consideration is that the formatting is not applied
until you actually access the data. So if you want to get a JAX array out of a dataset,
you’ll need to access the data first, otherwise the format will remain the same.`,ds,A,zs=`Finally, to load the data in the device of your choice, you can specify the <code>device</code> argument,
but note that <code>jaxlib.xla_extension.Device</code> is not supported as it’s not serializable with neither
<code>pickle</code> not <code>dill</code>, so you’ll need to use its string identifier instead:`,js,N,us,_,Hs=`Note that if the <code>device</code> argument is not provided to <code>with_format</code> then it will use the default
device which is <code>jax.devices()[0]</code>.`,gs,q,Ms,Q,Ds=`If your dataset consists of N-dimensional arrays, you will see that by default they are considered as nested lists.
In particular, a JAX formatted dataset outputs a <code>DeviceArray</code> object, which is a numpy-like array, so it does not
need the <code>Array</code> feature type to be specified as opposed to PyTorch or TensorFlow formatters.`,ys,G,fs,V,Js,B,Ws='<a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data is properly converted to arrays:',Ts,E,bs,Y,Ls="String and binary objects are unchanged, since JAX only supports numbers.",ws,F,Ss='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Us,w,$s,z,Cs,U,Is,H,Rs,D,Zs,W,Ps=`JAX doesn’t have any built-in data loading capabilities, so you’ll need to use a library such
as <a href="https://pytorch.org/" rel="nofollow">PyTorch</a> to load your data using a <code>DataLoader</code> or <a href="https://www.tensorflow.org/" rel="nofollow">TensorFlow</a>
using a <code>tf.data.Dataset</code>. Citing the <a href="https://jax.readthedocs.io/en/latest/notebooks/Neural_Network_and_Data_Loading.html#data-loading-with-pytorch" rel="nofollow">JAX documentation</a> on this topic:
“JAX is laser-focused on program transformations and accelerator-backed NumPy, so we don’t
include data loading or munging in the JAX library. There are already a lot of great data loaders
out there, so let’s just use them instead of reinventing anything. We’ll grab PyTorch’s data loader,
and make a tiny shim to make it work with NumPy arrays.”.`,vs,L,Ks=`So that’s the reason why JAX-formatting in <code>datasets</code> is so useful, because it lets you use
any model from the HuggingFace Hub with JAX, without having to worry about the data loading
part.`,ks,S,Xs,P,Os=`The easiest way to get JAX arrays out of a dataset is to use the <code>with_format(&#39;jax&#39;)</code> method. Lets assume
that we want to train a neural network on the <a href="http://yann.lecun.com/exdb/mnist/" rel="nofollow">MNIST dataset</a> available
at the HuggingFace Hub at <a href="https://huggingface.co/datasets/mnist" rel="nofollow">https://huggingface.co/datasets/mnist</a>.`,xs,K,As,O,sa=`Once the format is set we can feed the dataset to the JAX model in batches using the <code>Dataset.iter()</code>
method:`,Ns,ss,_s,ts,qs;return $=new as({props:{title:"Use with JAX",local:"use-with-jax",headingTag:"h1"}}),T=new Qs({props:{$$slots:{default:[ja]},$$scope:{ctx:f}}}),I=new as({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),v=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMmpheCUyMiklMEFkcyU1QjAlNUQlMEFkcyU1QiUzQTIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], dtype=int32)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([
    [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], dtype=int32)}`,wrap:!1}}),b=new Qs({props:{$$slots:{default:[ua]},$$scope:{ctx:f}}}),X=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldERpY3QlMEFkYXRhJTIwJTNEJTIwJTdCJTIydHJhaW4lMjIlM0ElMjAlN0IlMjJkYXRhJTIyJTNBJTIwJTVCJTVCMSUyQyUyMDIlNUQlMkMlMjAlNUIzJTJDJTIwNCU1RCU1RCU3RCUyQyUyMCUyMnRlc3QlMjIlM0ElMjAlN0IlMjJkYXRhJTIyJTNBJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU3RCU3RCUwQWRkcyUyMCUzRCUyMERhdGFzZXREaWN0LmZyb21fZGljdChkYXRhKSUwQWRkcyUyMCUzRCUyMGRkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZGRzJTVCJTIydHJhaW4lMjIlNUQlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> DatasetDict
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;train&quot;</span>: {<span class="hljs-string">&quot;data&quot;</span>: [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]}, <span class="hljs-string">&quot;test&quot;</span>: {<span class="hljs-string">&quot;data&quot;</span>: [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>], [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]}}
<span class="hljs-meta">&gt;&gt;&gt; </span>dds = DatasetDict.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>dds = dds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dds[<span class="hljs-string">&quot;train&quot;</span>][:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([
    [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], dtype=int32)}`,wrap:!1}}),N=new J({props:{code:"aW1wb3J0JTIwamF4JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkZXZpY2UlMjAlM0QlMjBzdHIoamF4LmRldmljZXMoKSU1QjAlNUQpJTIwJTIwJTIzJTIwTm90JTIwY2FzdGluZyUyMHRvJTIwJTYwc3RyJTYwJTIwYmVmb3JlJTIwcGFzc2luZyUyMGl0JTIwdG8lMjAlNjB3aXRoX2Zvcm1hdCU2MCUyMHdpbGwlMjByYWlzZSUyMGElMjAlNjBWYWx1ZUVycm9yJTYwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2UpJTBBZHMlNUIwJTVEJTBBZHMlNUIwJTVEJTVCJTIyZGF0YSUyMiU1RC5kZXZpY2UoKSUwQWFzc2VydCUyMGRzJTVCMCU1RCU1QiUyMmRhdGElMjIlNUQuZGV2aWNlKCklMjAlM0QlM0QlMjBqYXguZGV2aWNlcygpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-built_in">str</span>(jax.devices()[<span class="hljs-number">0</span>])  <span class="hljs-comment"># Not casting to \`str\` before passing it to \`with_format\` will raise a \`ValueError\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>, device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], dtype=int32)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;data&quot;</span>].device()
TFRT_CPU_0
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;data&quot;</span>].device() == jax.devices()[<span class="hljs-number">0</span>]
<span class="hljs-literal">True</span>`,wrap:!1}}),q=new as({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),G=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
             [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], dtype=int32)}`,wrap:!1}}),V=new as({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),E=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIlM0EzJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: DeviceArray([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>], dtype=int32)}`,wrap:!1}}),w=new Qs({props:{$$slots:{default:[ga]},$$scope:{ctx:f}}}),z=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwSW1hZ2UlMEFpbWFnZXMlMjAlM0QlMjAlNUIlMjJwYXRoJTJGdG8lMkZpbWFnZS5wbmclMjIlNUQlMjAqJTIwMTAlMEFmZWF0dXJlcyUyMCUzRCUyMEZlYXR1cmVzKCU3QiUyMmltYWdlJTIyJTNBJTIwSW1hZ2UoKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmltYWdlJTIyJTNBJTIwaW1hZ2VzJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMmpheCUyMiklMEFkcyU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RC5zaGFwZSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RCU1QiUyMmltYWdlJTIyJTVELnNoYXBlJTBBZHMlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: DeviceArray([[[ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              ...,
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=uint8)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
(<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: DeviceArray([[[[ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              ...,
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=uint8)}`,wrap:!1}}),U=new Qs({props:{$$slots:{default:[Ma]},$$scope:{ctx:f}}}),H=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMEFhdWRpbyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmF1ZGlvLndhdiUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyYXVkaW8lMjIlM0ElMjBBdWRpbygpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYXVkaW8lMjIlM0ElMjBhdWRpbyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
DeviceArray([-<span class="hljs-number">0.059021</span>  , -<span class="hljs-number">0.03894043</span>, -<span class="hljs-number">0.00735474</span>, ...,  <span class="hljs-number">0.0133667</span> ,
              <span class="hljs-number">0.01809692</span>,  <span class="hljs-number">0.00268555</span>], dtype=float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
DeviceArray(<span class="hljs-number">44100</span>, dtype=int32, weak_type=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new as({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),S=new as({props:{title:"Using with_format('jax')",local:"using-withformatjax",headingTag:"h3"}}),K=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybW5pc3QlMjIpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;mnist&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: DeviceArray([[  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...],
                       [  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...],
                       ...,
                       [  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...],
                       [  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...]], dtype=uint8),
 <span class="hljs-string">&#x27;label&#x27;</span>: DeviceArray(<span class="hljs-number">5</span>, dtype=int32)}`,wrap:!1}}),ss=new J({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGVwb2NocyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5pdGVyKGJhdGNoX3NpemUlM0QzMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTJDJTIweSUyMCUzRCUyMGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMkMlMjBiYXRjaCU1QiUyMmxhYmVsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">iter</span>(batch_size=<span class="hljs-number">32</span>):
<span class="hljs-meta">... </span>        x, y = batch[<span class="hljs-string">&quot;image&quot;</span>], batch[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>        ...`,wrap:!1}}),{c(){l=i("meta"),M=n(),r=i("p"),y=n(),o($.$$.fragment),es=n(),C=i("p"),C.innerHTML=Vs,ls=n(),o(T.$$.fragment),ns=n(),o(I.$$.fragment),ps=n(),R=i("p"),R.textContent=Bs,rs=n(),Z=i("p"),Z.innerHTML=Es,is=n(),o(v.$$.fragment),cs=n(),o(b.$$.fragment),os=n(),k=i("p"),k.innerHTML=Ys,ms=n(),o(X.$$.fragment),hs=n(),x=i("p"),x.textContent=Fs,ds=n(),A=i("p"),A.innerHTML=zs,js=n(),o(N.$$.fragment),us=n(),_=i("p"),_.innerHTML=Hs,gs=n(),o(q.$$.fragment),Ms=n(),Q=i("p"),Q.innerHTML=Ds,ys=n(),o(G.$$.fragment),fs=n(),o(V.$$.fragment),Js=n(),B=i("p"),B.innerHTML=Ws,Ts=n(),o(E.$$.fragment),bs=n(),Y=i("p"),Y.textContent=Ls,ws=n(),F=i("p"),F.innerHTML=Ss,Us=n(),o(w.$$.fragment),$s=n(),o(z.$$.fragment),Cs=n(),o(U.$$.fragment),Is=n(),o(H.$$.fragment),Rs=n(),o(D.$$.fragment),Zs=n(),W=i("p"),W.innerHTML=Ps,vs=n(),L=i("p"),L.innerHTML=Ks,ks=n(),o(S.$$.fragment),Xs=n(),P=i("p"),P.innerHTML=Os,xs=n(),o(K.$$.fragment),As=n(),O=i("p"),O.innerHTML=sa,Ns=n(),o(ss.$$.fragment),_s=n(),ts=i("p"),this.h()},l(s){const a=ma("svelte-u9bgzb",document.head);l=c(a,"META",{name:!0,content:!0}),a.forEach(t),M=p(s),r=c(s,"P",{}),na(r).forEach(t),y=p(s),m($.$$.fragment,s),es=p(s),C=c(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1a2kcgx"&&(C.innerHTML=Vs),ls=p(s),m(T.$$.fragment,s),ns=p(s),m(I.$$.fragment,s),ps=p(s),R=c(s,"P",{"data-svelte-h":!0}),g(R)!=="svelte-1ix49d8"&&(R.textContent=Bs),rs=p(s),Z=c(s,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1upv66g"&&(Z.innerHTML=Es),is=p(s),m(v.$$.fragment,s),cs=p(s),m(b.$$.fragment,s),os=p(s),k=c(s,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1b7i338"&&(k.innerHTML=Ys),ms=p(s),m(X.$$.fragment,s),hs=p(s),x=c(s,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1c29vp0"&&(x.textContent=Fs),ds=p(s),A=c(s,"P",{"data-svelte-h":!0}),g(A)!=="svelte-1ooxy7c"&&(A.innerHTML=zs),js=p(s),m(N.$$.fragment,s),us=p(s),_=c(s,"P",{"data-svelte-h":!0}),g(_)!=="svelte-hj2cy7"&&(_.innerHTML=Hs),gs=p(s),m(q.$$.fragment,s),Ms=p(s),Q=c(s,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-ubc06l"&&(Q.innerHTML=Ds),ys=p(s),m(G.$$.fragment,s),fs=p(s),m(V.$$.fragment,s),Js=p(s),B=c(s,"P",{"data-svelte-h":!0}),g(B)!=="svelte-gpgme7"&&(B.innerHTML=Ws),Ts=p(s),m(E.$$.fragment,s),bs=p(s),Y=c(s,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-gkri0z"&&(Y.textContent=Ls),ws=p(s),F=c(s,"P",{"data-svelte-h":!0}),g(F)!=="svelte-irvfgq"&&(F.innerHTML=Ss),Us=p(s),m(w.$$.fragment,s),$s=p(s),m(z.$$.fragment,s),Cs=p(s),m(U.$$.fragment,s),Is=p(s),m(H.$$.fragment,s),Rs=p(s),m(D.$$.fragment,s),Zs=p(s),W=c(s,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1msw6w0"&&(W.innerHTML=Ps),vs=p(s),L=c(s,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1xmbhz7"&&(L.innerHTML=Ks),ks=p(s),m(S.$$.fragment,s),Xs=p(s),P=c(s,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1pw5xoa"&&(P.innerHTML=Os),xs=p(s),m(K.$$.fragment,s),As=p(s),O=c(s,"P",{"data-svelte-h":!0}),g(O)!=="svelte-lnmbh3"&&(O.innerHTML=sa),Ns=p(s),m(ss.$$.fragment,s),_s=p(s),ts=c(s,"P",{}),na(ts).forEach(t),this.h()},h(){pa(l,"name","hf:doc:metadata"),pa(l,"content",fa)},m(s,a){ha(document.head,l),e(s,M,a),e(s,r,a),e(s,y,a),h($,s,a),e(s,es,a),e(s,C,a),e(s,ls,a),h(T,s,a),e(s,ns,a),h(I,s,a),e(s,ps,a),e(s,R,a),e(s,rs,a),e(s,Z,a),e(s,is,a),h(v,s,a),e(s,cs,a),h(b,s,a),e(s,os,a),e(s,k,a),e(s,ms,a),h(X,s,a),e(s,hs,a),e(s,x,a),e(s,ds,a),e(s,A,a),e(s,js,a),h(N,s,a),e(s,us,a),e(s,_,a),e(s,gs,a),h(q,s,a),e(s,Ms,a),e(s,Q,a),e(s,ys,a),h(G,s,a),e(s,fs,a),h(V,s,a),e(s,Js,a),e(s,B,a),e(s,Ts,a),h(E,s,a),e(s,bs,a),e(s,Y,a),e(s,ws,a),e(s,F,a),e(s,Us,a),h(w,s,a),e(s,$s,a),h(z,s,a),e(s,Cs,a),h(U,s,a),e(s,Is,a),h(H,s,a),e(s,Rs,a),h(D,s,a),e(s,Zs,a),e(s,W,a),e(s,vs,a),e(s,L,a),e(s,ks,a),h(S,s,a),e(s,Xs,a),e(s,P,a),e(s,xs,a),h(K,s,a),e(s,As,a),e(s,O,a),e(s,Ns,a),h(ss,s,a),e(s,_s,a),e(s,ts,a),qs=!0},p(s,[a]){const aa={};a&2&&(aa.$$scope={dirty:a,ctx:s}),T.$set(aa);const ta={};a&2&&(ta.$$scope={dirty:a,ctx:s}),b.$set(ta);const ea={};a&2&&(ea.$$scope={dirty:a,ctx:s}),w.$set(ea);const la={};a&2&&(la.$$scope={dirty:a,ctx:s}),U.$set(la)},i(s){qs||(d($.$$.fragment,s),d(T.$$.fragment,s),d(I.$$.fragment,s),d(v.$$.fragment,s),d(b.$$.fragment,s),d(X.$$.fragment,s),d(N.$$.fragment,s),d(q.$$.fragment,s),d(G.$$.fragment,s),d(V.$$.fragment,s),d(E.$$.fragment,s),d(w.$$.fragment,s),d(z.$$.fragment,s),d(U.$$.fragment,s),d(H.$$.fragment,s),d(D.$$.fragment,s),d(S.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),qs=!0)},o(s){j($.$$.fragment,s),j(T.$$.fragment,s),j(I.$$.fragment,s),j(v.$$.fragment,s),j(b.$$.fragment,s),j(X.$$.fragment,s),j(N.$$.fragment,s),j(q.$$.fragment,s),j(G.$$.fragment,s),j(V.$$.fragment,s),j(E.$$.fragment,s),j(w.$$.fragment,s),j(z.$$.fragment,s),j(U.$$.fragment,s),j(H.$$.fragment,s),j(D.$$.fragment,s),j(S.$$.fragment,s),j(K.$$.fragment,s),j(ss.$$.fragment,s),qs=!1},d(s){s&&(t(M),t(r),t(y),t(es),t(C),t(ls),t(ns),t(ps),t(R),t(rs),t(Z),t(is),t(cs),t(os),t(k),t(ms),t(hs),t(x),t(ds),t(A),t(js),t(us),t(_),t(gs),t(Ms),t(Q),t(ys),t(fs),t(Js),t(B),t(Ts),t(bs),t(Y),t(ws),t(F),t(Us),t($s),t(Cs),t(Is),t(Rs),t(Zs),t(W),t(vs),t(L),t(ks),t(Xs),t(P),t(xs),t(As),t(O),t(Ns),t(_s),t(ts)),t(l),u($,s),u(T,s),u(I,s),u(v,s),u(b,s),u(X,s),u(N,s),u(q,s),u(G,s),u(V,s),u(E,s),u(w,s),u(z,s),u(U,s),u(H,s),u(D,s),u(S,s),u(K,s),u(ss,s)}}}const fa=`{"title":"Use with JAX","local":"use-with-jax","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Using with_format('jax')","local":"using-withformatjax","sections":[],"depth":3}],"depth":2}],"depth":1}`;function Ja(f){return ia(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=da}),[]}class Ca extends ca{constructor(l){super(),oa(this,l,Ja,ya,ra,{})}}export{Ca as component};
