import{s as qa,o as Ea,n as da}from"../chunks/scheduler.bdbef820.js";import{S as Ba,i as Da,g as r,s as l,r as h,A as Ha,h as c,f as t,c as n,j as Wa,u as m,x as i,k as Va,y as La,a as e,v as o,d,t as u,w as j}from"../chunks/index.c0aea24a.js";import{H as w,g as Sa}from"../chunks/Heading.0e005771.js";import{T as oa}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";function Aa(M){let p,J='A <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast zero-copy reads from arrays in the dataset to PyTorch tensors.';return{c(){p=r("p"),p.innerHTML=J},l(g){p=c(g,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1rxr76g"&&(p.innerHTML=J)},m(g,T){e(g,p,T)},p:da,d(g){g&&t(p)}}}function Pa(M){let p,J=`To use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){p=r("p"),p.innerHTML=J},l(g){p=c(g,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1yizw38"&&(p.innerHTML=J)},m(g,T){e(g,p,T)},p:da,d(g){g&&t(p)}}}function Ka(M){let p,J=`To use the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){p=r("p"),p.innerHTML=J},l(g){p=c(g,"P",{"data-svelte-h":!0}),i(p)!=="svelte-ws1rne"&&(p.innerHTML=J)},m(g,T){e(g,p,T)},p:da,d(g){g&&t(p)}}}function Oa(M){let p,J,g,T,I,Js,$,ua=`This document is a quick introduction to using <code>datasets</code> with PyTorch, with a particular focus on how to get
<code>torch.Tensor</code> objects out of our datasets, and how to use a PyTorch <code>DataLoader</code> and a Hugging Face <code>Dataset</code>
with the best performance.`,ys,R,Ts,C,ja="By default, datasets return regular python objects: integers, floats, strings, lists, etc.",ws,k,ga='To get PyTorch tensors instead, you can set the format of the dataset to <code>pytorch</code> using <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.with_format">Dataset.with_format()</a>:',Ms,G,bs,b,fs,_,Ja="To load the data as tensors on a GPU, specify the <code>device</code> argument:",Us,v,Is,Z,$s,X,ya=`If your dataset consists of N-dimensional arrays, you will see that by default they are considered as nested lists.
In particular, a PyTorch formatted dataset outputs nested lists instead of a single tensor:`,Rs,Q,Cs,F,Ta="To get a single tensor, you must explicitly use the <code>Array</code> feature type and specify the shape of your tensors:",ks,Y,Gs,z,_s,x,wa='<a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data are properly converted to tensors:',vs,N,Zs,W,Ma="String and binary objects are unchanged, since PyTorch only supports numbers.",Xs,V,ba='The <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Qs,f,Fs,q,Ys,U,zs,E,xs,B,Ns,D,fa='Like <code>torch.utils.data.Dataset</code> objects, a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> can be passed directly to a PyTorch <code>DataLoader</code>:',Ws,H,Vs,L,qs,S,Ua=`There are several ways you can increase the speed your data is loaded which can save you time, especially if you are working with large datasets.
PyTorch offers parallelized data loading, retrieving batches of indices instead of individually, and streaming to iterate over the dataset without downloading it on disk.`,Es,A,Bs,P,Ia="You can parallelize data loading with the <code>num_workers</code> argument of a PyTorch <code>DataLoader</code> and get a higher throughput.",Ds,K,$a=`Under the hood, the <code>DataLoader</code> starts <code>num_workers</code> processes.
Each process reloads the dataset passed to the <code>DataLoader</code> and is used to query examples.
Reloading the dataset inside a worker doesn’t fill up your RAM, since it simply memory-maps the dataset again from your disk.`,Hs,O,Ls,ss,Ss,as,Ra=`Stream a dataset by loading it as an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. This allows you to progressively iterate over a remote dataset without downloading it on disk and or over local data files.
Learn more about which type of dataset is best for your use case in the <a href="./about_mapstyle_vs_iterable">choosing between a regular dataset or an iterable dataset</a> guide.`,As,ts,Ca="An iterable dataset from <code>datasets</code> inherits from <code>torch.utils.data.IterableDataset</code> so you can pass it to a <code>torch.utils.data.DataLoader</code>:",Ps,es,Ks,ls,ka="If the dataset is split in several shards (i.e. if the dataset consists of multiple data files), then you can stream in parallel using <code>num_workers</code>:",Os,ns,sa,ps,Ga="In this case each worker is given a subset of the list of shards to stream from.",aa,rs,ta,cs,_a='To split your dataset across your training nodes, you can use <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.distributed.split_dataset_by_node">datasets.distributed.split_dataset_by_node()</a>:',ea,is,la,hs,va=`This works for both map-style datasets and iterable datasets.
The dataset is split for the node at rank <code>rank</code> in a pool of nodes of size <code>world_size</code>.`,na,ms,Za="For map-style datasets:",pa,os,Xa="Each node is assigned a chunk of data, e.g. rank 0 is given the first chunk of the dataset.",ra,ds,Qa="For iterable datasets:",ca,us,Fa=`If the dataset has a number of shards that is a factor of <code>world_size</code> (i.e. if <code>dataset.n_shards % world_size == 0</code>),
then the shards are evenly assigned across the nodes, which is the most optimized.
Otherwise, each node keeps 1 example out of <code>world_size</code>, skipping the other examples.`,ia,js,Ya="This can also be combined with a <code>torch.utils.data.DataLoader</code> if you want each node to use multiple workers to load the data.",ha,gs,ma;return I=new w({props:{title:"Use with PyTorch",local:"use-with-pytorch",headingTag:"h1"}}),R=new w({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),G=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>])}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}`,wrap:!1}}),b=new oa({props:{$$slots:{default:[Aa]},$$scope:{ctx:M}}}),v=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>, device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], device=<span class="hljs-string">&#x27;cuda:0&#x27;</span>)}`,wrap:!1}}),Z=new w({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),Q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: [tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]), tensor([<span class="hljs-number">3</span>, <span class="hljs-number">4</span>])]}`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXJyYXkyRCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyZGF0YSUyMiUzQSUyMEFycmF5MkQoc2hhcGUlM0QoMiUyQyUyMDIpJTJDJTIwZHR5cGUlM0QnaW50MzInKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Array2D
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;data&quot;</span>: Array2D(shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=<span class="hljs-string">&#x27;int32&#x27;</span>)})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
          [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],
 
         [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
          [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]])}`,wrap:!1}}),z=new w({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTIwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMjAlMjAlMEFkcyU1QiUzQTMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])}`,wrap:!1}}),f=new oa({props:{$$slots:{default:[Pa]},$$scope:{ctx:M}}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWltYWdlcyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmltYWdlLnBuZyUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZXMlN0QlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUyMCUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZHMlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQuc2hhcGUlMEFkcyU1QjAlNUQlMEFkcyU1QiUzQTIlNUQlNUIlMjJpbWFnZSUyMiU1RC5zaGFwZSUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: tensor([[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         ...,
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=torch.uint8)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
torch.Size([<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: tensor([[[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          ...,
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=torch.uint8)}`,wrap:!1}}),U=new oa({props:{$$slots:{default:[Ka]},$$scope:{ctx:M}}}),E=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWF1ZGlvJTIwJTNEJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW8ud2F2JTIyJTVEJTIwKiUyMDEwJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMjJhdWRpbyUyMiUzQSUyMEF1ZGlvKCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMGF1ZGlvJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUyMCUyMCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
tensor([ <span class="hljs-number">6.1035e-05</span>,  <span class="hljs-number">1.5259e-05</span>,  <span class="hljs-number">1.6785e-04</span>,  ..., -<span class="hljs-number">1.5259e-05</span>,
        -<span class="hljs-number">1.5259e-05</span>,  <span class="hljs-number">1.5259e-05</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
tensor(<span class="hljs-number">44100</span>)`,wrap:!1}}),B=new w({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),H=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyMCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWRhdGElMjAlM0QlMjBucC5yYW5kb20ucmFuZCgxNiklMEFsYWJlbCUyMCUzRCUyMG5wLnJhbmRvbS5yYW5kaW50KDAlMkMlMjAyJTJDJTIwc2l6ZSUzRDE2KSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMGxhYmVsJTdEKS53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihkcyUyQyUyMGJhdGNoX3NpemUlM0Q0KSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoYmF0Y2gpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">16</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>label = np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, size=<span class="hljs-number">16</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data, <span class="hljs-string">&quot;label&quot;</span>: label}).with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(ds, batch_size=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(batch)                                                                                            
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.0047</span>, <span class="hljs-number">0.4979</span>, <span class="hljs-number">0.6726</span>, <span class="hljs-number">0.8105</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.4832</span>, <span class="hljs-number">0.2723</span>, <span class="hljs-number">0.4259</span>, <span class="hljs-number">0.2224</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.5837</span>, <span class="hljs-number">0.3444</span>, <span class="hljs-number">0.4658</span>, <span class="hljs-number">0.6417</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.7022</span>, <span class="hljs-number">0.1225</span>, <span class="hljs-number">0.7228</span>, <span class="hljs-number">0.8259</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>])}`,wrap:!1}}),L=new w({props:{title:"Optimize data loading",local:"optimize-data-loading",headingTag:"h3"}}),A=new w({props:{title:"Use multiple Workers",local:"use-multiple-workers",headingTag:"h4"}}),O=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGxvYWRfZnJvbV9kaXNrJTBBZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZGF0YSUyMCUzRCUyMG5wLnJhbmRvbS5yYW5kKDEwXzAwMCklMEFEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCkuc2F2ZV90b19kaXNrKCUyMm15X2RhdGFzZXQlMjIpJTBBZHMlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayglMjJteV9kYXRhc2V0JTIyKS53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihkcyUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMG51bV93b3JrZXJzJTNENCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">10_000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}).save_to_disk(<span class="hljs-string">&quot;my_dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_from_disk(<span class="hljs-string">&quot;my_dataset&quot;</span>).with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(ds, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)`,wrap:!1}}),ss=new w({props:{title:"Stream data",local:"stream-data",headingTag:"h3"}}),es=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWRhdGElMjAlM0QlMjBucC5yYW5kb20ucmFuZCgxMF8wMDApJTBBRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpLnB1c2hfdG9faHViKCUyMiUzQ3VzZXJuYW1lJTNFJTJGbXlfZGF0YXNldCUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjIlM0N1c2VybmFtZSUzRSUyRm15X2RhdGFzZXQlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihteV9pdGVyYWJsZV9kYXRhc2V0JTJDJTIwYmF0Y2hfc2l6ZSUzRDMyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">10_000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}).push_to_hub(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>)  <span class="hljs-comment"># Upload to the Hugging Face Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>)`,wrap:!1}}),ns=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjNCUyMiUyQyUyMCUyMmVuJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUwQWRhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKG15X2l0ZXJhYmxlX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEMzIlMkMlMjBudW1fd29ya2VycyUzRDQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;c4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset.n_shards
<span class="hljs-number">1024</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)`,wrap:!1}}),rs=new w({props:{title:"Distributed",local:"distributed",headingTag:"h3"}}),is=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZGF0YXNldHMuZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBzcGxpdF9kYXRhc2V0X2J5X25vZGUlMEElMEFkcyUyMCUzRCUyMHNwbGl0X2RhdGFzZXRfYnlfbm9kZShkcyUyQyUyMHJhbmslM0RpbnQob3MuZW52aXJvbiU1QiUyMlJBTkslMjIlNUQpJTJDJTIwd29ybGRfc2l6ZSUzRGludChvcy5lbnZpcm9uJTVCJTIyV09STERfU0laRSUyMiU1RCkp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> datasets.distributed <span class="hljs-keyword">import</span> split_dataset_by_node

ds = split_dataset_by_node(ds, rank=<span class="hljs-built_in">int</span>(os.environ[<span class="hljs-string">&quot;RANK&quot;</span>]), world_size=<span class="hljs-built_in">int</span>(os.environ[<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>]))`,wrap:!1}}),{c(){p=r("meta"),J=l(),g=r("p"),T=l(),h(I.$$.fragment),Js=l(),$=r("p"),$.innerHTML=ua,ys=l(),h(R.$$.fragment),Ts=l(),C=r("p"),C.textContent=ja,ws=l(),k=r("p"),k.innerHTML=ga,Ms=l(),h(G.$$.fragment),bs=l(),h(b.$$.fragment),fs=l(),_=r("p"),_.innerHTML=Ja,Us=l(),h(v.$$.fragment),Is=l(),h(Z.$$.fragment),$s=l(),X=r("p"),X.textContent=ya,Rs=l(),h(Q.$$.fragment),Cs=l(),F=r("p"),F.innerHTML=Ta,ks=l(),h(Y.$$.fragment),Gs=l(),h(z.$$.fragment),_s=l(),x=r("p"),x.innerHTML=wa,vs=l(),h(N.$$.fragment),Zs=l(),W=r("p"),W.textContent=Ma,Xs=l(),V=r("p"),V.innerHTML=ba,Qs=l(),h(f.$$.fragment),Fs=l(),h(q.$$.fragment),Ys=l(),h(U.$$.fragment),zs=l(),h(E.$$.fragment),xs=l(),h(B.$$.fragment),Ns=l(),D=r("p"),D.innerHTML=fa,Ws=l(),h(H.$$.fragment),Vs=l(),h(L.$$.fragment),qs=l(),S=r("p"),S.textContent=Ua,Es=l(),h(A.$$.fragment),Bs=l(),P=r("p"),P.innerHTML=Ia,Ds=l(),K=r("p"),K.innerHTML=$a,Hs=l(),h(O.$$.fragment),Ls=l(),h(ss.$$.fragment),Ss=l(),as=r("p"),as.innerHTML=Ra,As=l(),ts=r("p"),ts.innerHTML=Ca,Ps=l(),h(es.$$.fragment),Ks=l(),ls=r("p"),ls.innerHTML=ka,Os=l(),h(ns.$$.fragment),sa=l(),ps=r("p"),ps.textContent=Ga,aa=l(),h(rs.$$.fragment),ta=l(),cs=r("p"),cs.innerHTML=_a,ea=l(),h(is.$$.fragment),la=l(),hs=r("p"),hs.innerHTML=va,na=l(),ms=r("p"),ms.textContent=Za,pa=l(),os=r("p"),os.textContent=Xa,ra=l(),ds=r("p"),ds.textContent=Qa,ca=l(),us=r("p"),us.innerHTML=Fa,ia=l(),js=r("p"),js.innerHTML=Ya,ha=l(),gs=r("p"),this.h()},l(s){const a=Ha("svelte-u9bgzb",document.head);p=c(a,"META",{name:!0,content:!0}),a.forEach(t),J=n(s),g=c(s,"P",{}),Wa(g).forEach(t),T=n(s),m(I.$$.fragment,s),Js=n(s),$=c(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-1116k3w"&&($.innerHTML=ua),ys=n(s),m(R.$$.fragment,s),Ts=n(s),C=c(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-j9f3ms"&&(C.textContent=ja),ws=n(s),k=c(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-u6snia"&&(k.innerHTML=ga),Ms=n(s),m(G.$$.fragment,s),bs=n(s),m(b.$$.fragment,s),fs=n(s),_=c(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1ezbzoy"&&(_.innerHTML=Ja),Us=n(s),m(v.$$.fragment,s),Is=n(s),m(Z.$$.fragment,s),$s=n(s),X=c(s,"P",{"data-svelte-h":!0}),i(X)!=="svelte-hbe3u7"&&(X.textContent=ya),Rs=n(s),m(Q.$$.fragment,s),Cs=n(s),F=c(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1nq7c44"&&(F.innerHTML=Ta),ks=n(s),m(Y.$$.fragment,s),Gs=n(s),m(z.$$.fragment,s),_s=n(s),x=c(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-ezwi95"&&(x.innerHTML=wa),vs=n(s),m(N.$$.fragment,s),Zs=n(s),W=c(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1hobffv"&&(W.textContent=Ma),Xs=n(s),V=c(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-irvfgq"&&(V.innerHTML=ba),Qs=n(s),m(f.$$.fragment,s),Fs=n(s),m(q.$$.fragment,s),Ys=n(s),m(U.$$.fragment,s),zs=n(s),m(E.$$.fragment,s),xs=n(s),m(B.$$.fragment,s),Ns=n(s),D=c(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1yc8vup"&&(D.innerHTML=fa),Ws=n(s),m(H.$$.fragment,s),Vs=n(s),m(L.$$.fragment,s),qs=n(s),S=c(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-nw1d6c"&&(S.textContent=Ua),Es=n(s),m(A.$$.fragment,s),Bs=n(s),P=c(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1wyypch"&&(P.innerHTML=Ia),Ds=n(s),K=c(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1u9vub"&&(K.innerHTML=$a),Hs=n(s),m(O.$$.fragment,s),Ls=n(s),m(ss.$$.fragment,s),Ss=n(s),as=c(s,"P",{"data-svelte-h":!0}),i(as)!=="svelte-1jo28w3"&&(as.innerHTML=Ra),As=n(s),ts=c(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-1t3p6zv"&&(ts.innerHTML=Ca),Ps=n(s),m(es.$$.fragment,s),Ks=n(s),ls=c(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-gqi02o"&&(ls.innerHTML=ka),Os=n(s),m(ns.$$.fragment,s),sa=n(s),ps=c(s,"P",{"data-svelte-h":!0}),i(ps)!=="svelte-i7csup"&&(ps.textContent=Ga),aa=n(s),m(rs.$$.fragment,s),ta=n(s),cs=c(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-tz8s2c"&&(cs.innerHTML=_a),ea=n(s),m(is.$$.fragment,s),la=n(s),hs=c(s,"P",{"data-svelte-h":!0}),i(hs)!=="svelte-utgciv"&&(hs.innerHTML=va),na=n(s),ms=c(s,"P",{"data-svelte-h":!0}),i(ms)!=="svelte-1a3gkys"&&(ms.textContent=Za),pa=n(s),os=c(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-41cx6v"&&(os.textContent=Xa),ra=n(s),ds=c(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-1kujsme"&&(ds.textContent=Qa),ca=n(s),us=c(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-nsc411"&&(us.innerHTML=Fa),ia=n(s),js=c(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-19jtkan"&&(js.innerHTML=Ya),ha=n(s),gs=c(s,"P",{}),Wa(gs).forEach(t),this.h()},h(){Va(p,"name","hf:doc:metadata"),Va(p,"content",st)},m(s,a){La(document.head,p),e(s,J,a),e(s,g,a),e(s,T,a),o(I,s,a),e(s,Js,a),e(s,$,a),e(s,ys,a),o(R,s,a),e(s,Ts,a),e(s,C,a),e(s,ws,a),e(s,k,a),e(s,Ms,a),o(G,s,a),e(s,bs,a),o(b,s,a),e(s,fs,a),e(s,_,a),e(s,Us,a),o(v,s,a),e(s,Is,a),o(Z,s,a),e(s,$s,a),e(s,X,a),e(s,Rs,a),o(Q,s,a),e(s,Cs,a),e(s,F,a),e(s,ks,a),o(Y,s,a),e(s,Gs,a),o(z,s,a),e(s,_s,a),e(s,x,a),e(s,vs,a),o(N,s,a),e(s,Zs,a),e(s,W,a),e(s,Xs,a),e(s,V,a),e(s,Qs,a),o(f,s,a),e(s,Fs,a),o(q,s,a),e(s,Ys,a),o(U,s,a),e(s,zs,a),o(E,s,a),e(s,xs,a),o(B,s,a),e(s,Ns,a),e(s,D,a),e(s,Ws,a),o(H,s,a),e(s,Vs,a),o(L,s,a),e(s,qs,a),e(s,S,a),e(s,Es,a),o(A,s,a),e(s,Bs,a),e(s,P,a),e(s,Ds,a),e(s,K,a),e(s,Hs,a),o(O,s,a),e(s,Ls,a),o(ss,s,a),e(s,Ss,a),e(s,as,a),e(s,As,a),e(s,ts,a),e(s,Ps,a),o(es,s,a),e(s,Ks,a),e(s,ls,a),e(s,Os,a),o(ns,s,a),e(s,sa,a),e(s,ps,a),e(s,aa,a),o(rs,s,a),e(s,ta,a),e(s,cs,a),e(s,ea,a),o(is,s,a),e(s,la,a),e(s,hs,a),e(s,na,a),e(s,ms,a),e(s,pa,a),e(s,os,a),e(s,ra,a),e(s,ds,a),e(s,ca,a),e(s,us,a),e(s,ia,a),e(s,js,a),e(s,ha,a),e(s,gs,a),ma=!0},p(s,[a]){const za={};a&2&&(za.$$scope={dirty:a,ctx:s}),b.$set(za);const xa={};a&2&&(xa.$$scope={dirty:a,ctx:s}),f.$set(xa);const Na={};a&2&&(Na.$$scope={dirty:a,ctx:s}),U.$set(Na)},i(s){ma||(d(I.$$.fragment,s),d(R.$$.fragment,s),d(G.$$.fragment,s),d(b.$$.fragment,s),d(v.$$.fragment,s),d(Z.$$.fragment,s),d(Q.$$.fragment,s),d(Y.$$.fragment,s),d(z.$$.fragment,s),d(N.$$.fragment,s),d(f.$$.fragment,s),d(q.$$.fragment,s),d(U.$$.fragment,s),d(E.$$.fragment,s),d(B.$$.fragment,s),d(H.$$.fragment,s),d(L.$$.fragment,s),d(A.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(rs.$$.fragment,s),d(is.$$.fragment,s),ma=!0)},o(s){u(I.$$.fragment,s),u(R.$$.fragment,s),u(G.$$.fragment,s),u(b.$$.fragment,s),u(v.$$.fragment,s),u(Z.$$.fragment,s),u(Q.$$.fragment,s),u(Y.$$.fragment,s),u(z.$$.fragment,s),u(N.$$.fragment,s),u(f.$$.fragment,s),u(q.$$.fragment,s),u(U.$$.fragment,s),u(E.$$.fragment,s),u(B.$$.fragment,s),u(H.$$.fragment,s),u(L.$$.fragment,s),u(A.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(es.$$.fragment,s),u(ns.$$.fragment,s),u(rs.$$.fragment,s),u(is.$$.fragment,s),ma=!1},d(s){s&&(t(J),t(g),t(T),t(Js),t($),t(ys),t(Ts),t(C),t(ws),t(k),t(Ms),t(bs),t(fs),t(_),t(Us),t(Is),t($s),t(X),t(Rs),t(Cs),t(F),t(ks),t(Gs),t(_s),t(x),t(vs),t(Zs),t(W),t(Xs),t(V),t(Qs),t(Fs),t(Ys),t(zs),t(xs),t(Ns),t(D),t(Ws),t(Vs),t(qs),t(S),t(Es),t(Bs),t(P),t(Ds),t(K),t(Hs),t(Ls),t(Ss),t(as),t(As),t(ts),t(Ps),t(Ks),t(ls),t(Os),t(sa),t(ps),t(aa),t(ta),t(cs),t(ea),t(la),t(hs),t(na),t(ms),t(pa),t(os),t(ra),t(ds),t(ca),t(us),t(ia),t(js),t(ha),t(gs)),t(p),j(I,s),j(R,s),j(G,s),j(b,s),j(v,s),j(Z,s),j(Q,s),j(Y,s),j(z,s),j(N,s),j(f,s),j(q,s),j(U,s),j(E,s),j(B,s),j(H,s),j(L,s),j(A,s),j(O,s),j(ss,s),j(es,s),j(ns,s),j(rs,s),j(is,s)}}}const st='{"title":"Use with PyTorch","local":"use-with-pytorch","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Optimize data loading","local":"optimize-data-loading","sections":[{"title":"Use multiple Workers","local":"use-multiple-workers","sections":[],"depth":4}],"depth":3},{"title":"Stream data","local":"stream-data","sections":[],"depth":3},{"title":"Distributed","local":"distributed","sections":[],"depth":3}],"depth":2}],"depth":1}';function at(M){return Ea(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=Sa}),[]}class rt extends Ba{constructor(p){super(),Da(this,p,at,Oa,qa,{})}}export{rt as component};
