import{s as rt,n as ht,o as mt}from"../chunks/scheduler.bdbef820.js";import{S as ut,i as ct,g as i,s as n,r as I,A as dt,h as o,f as s,c as l,j as it,u as _,x as r,k as ot,y as ft,a,v as x,d as z,t as U,w as k}from"../chunks/index.c0aea24a.js";import{H as V,g as wt}from"../chunks/Heading.0e005771.js";import{C as pt}from"../chunks/CodeBlock.6ccca92e.js";function yt(B){let p,C,v,G,h,N,m,S='Combining the utility of <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a> with batch mode is very powerful. It allows you to speed up processing, and freely control the size of the generated dataset.',F,u,R,c,K='The primary objective of batch mapping is to speed up processing. Often times, it is faster to work with batches of data instead of single examples. Naturally, batch mapping lends itself to tokenization. For example, the 🤗 <a href="https://huggingface.co/docs/tokenizers/python/latest/" rel="nofollow">Tokenizers</a> library works faster with batches because it parallelizes the tokenization of all the examples in a batch.',Y,d,H,f,O='The ability to control the size of the generated dataset can be leveraged for many interesting use-cases. In the How-to <a href="#map">map</a> section, there are examples of using batch mapping to:',L,w,tt="<li>Split long sentences into shorter chunks.</li> <li>Augment a dataset with additional tokens.</li>",Z,y,et="It is helpful to understand how this works, so you can come up with your own ways to use batch mapping. At this point, you may be wondering how you can control the size of the generated dataset. The answer is: <strong>the mapped function does not have to return an output batch of the same size</strong>.",E,b,st="In other words, your mapped function input can be a batch of size <code>N</code> and return a batch of size <code>M</code>. The output <code>M</code> can be greater than or less than <code>N</code>. This means you can concatenate your examples, divide it up, and even add more examples!",A,T,at="However, remember that all values in the output dictionary must contain the <strong>same number of elements</strong> as the other fields in the output dictionary. Otherwise, it is not possible to define the number of examples in the output returned by the mapped function. The number can vary between successive batches processed by the mapped function. For a single batch though, all values of the output dictionary should have the same length (i.e., the number of elements).",Q,g,nt=`For example, from a dataset of 1 column and 3 rows, if you use <code>map</code> to return a new column with twice as many rows, then you will have an error.
In this case, you end up with one column with 3 rows, and one column with 6 rows. As you can see, the table will not be valid:`,X,M,q,j,lt="To make it valid, you have to drop one of the columns:",D,J,W,$,P;return h=new V({props:{title:"Batch mapping",local:"batch-mapping",headingTag:"h1"}}),u=new V({props:{title:"Need for speed",local:"need-for-speed",headingTag:"h2"}}),d=new V({props:{title:"Input size != output size",local:"input-size--output-size",headingTag:"h2"}}),M=new pt({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWRhdGFzZXQubWFwKGxhbWJkYSUyMGJhdGNoJTNBJTIwJTdCJTIyYiUyMiUzQSUyMGJhdGNoJTVCJTIyYSUyMiU1RCUyMColMjAyJTdEJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTIwJTIwJTIzJTIwbmV3JTIwY29sdW1uJTIwd2l0aCUyMDYlMjBlbGVtZW50cyUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDAlMkMlMjAxJTJDJTIwMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> batch: {<span class="hljs-string">&quot;b&quot;</span>: batch[<span class="hljs-string">&quot;a&quot;</span>] * <span class="hljs-number">2</span>}, batched=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># new column with 6 elements: [0, 1, 2, 0, 1, 2]</span>
<span class="hljs-string">&#x27;ArrowInvalid: Column 1 named b expected length 3 but got length 6&#x27;</span>`,wrap:!1}}),J=new pt({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTVEJTdEKSUwQWRhdGFzZXRfd2l0aF9kdXBsaWNhdGVzJTIwJTNEJTIwZGF0YXNldC5tYXAobGFtYmRhJTIwYmF0Y2glM0ElMjAlN0IlMjJiJTIyJTNBJTIwYmF0Y2glNUIlMjJhJTIyJTVEJTIwKiUyMDIlN0QlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMmElMjIlNUQlMkMlMjBiYXRjaGVkJTNEVHJ1ZSklMEFsZW4oZGF0YXNldF93aXRoX2R1cGxpY2F0ZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = Dataset.from_dict({<span class="hljs-string">&quot;a&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]})
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_with_duplicates = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> batch: {<span class="hljs-string">&quot;b&quot;</span>: batch[<span class="hljs-string">&quot;a&quot;</span>] * <span class="hljs-number">2</span>}, remove_columns=[<span class="hljs-string">&quot;a&quot;</span>], batched=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset_with_duplicates)
<span class="hljs-number">6</span>`,wrap:!1}}),{c(){p=i("meta"),C=n(),v=i("p"),G=n(),I(h.$$.fragment),N=n(),m=i("p"),m.innerHTML=S,F=n(),I(u.$$.fragment),R=n(),c=i("p"),c.innerHTML=K,Y=n(),I(d.$$.fragment),H=n(),f=i("p"),f.innerHTML=O,L=n(),w=i("ul"),w.innerHTML=tt,Z=n(),y=i("p"),y.innerHTML=et,E=n(),b=i("p"),b.innerHTML=st,A=n(),T=i("p"),T.innerHTML=at,Q=n(),g=i("p"),g.innerHTML=nt,X=n(),I(M.$$.fragment),q=n(),j=i("p"),j.textContent=lt,D=n(),I(J.$$.fragment),W=n(),$=i("p"),this.h()},l(t){const e=dt("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(s),C=l(t),v=o(t,"P",{}),it(v).forEach(s),G=l(t),_(h.$$.fragment,t),N=l(t),m=o(t,"P",{"data-svelte-h":!0}),r(m)!=="svelte-xbicur"&&(m.innerHTML=S),F=l(t),_(u.$$.fragment,t),R=l(t),c=o(t,"P",{"data-svelte-h":!0}),r(c)!=="svelte-ftplyc"&&(c.innerHTML=K),Y=l(t),_(d.$$.fragment,t),H=l(t),f=o(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-catkrd"&&(f.innerHTML=O),L=l(t),w=o(t,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-min2km"&&(w.innerHTML=tt),Z=l(t),y=o(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1t0thr9"&&(y.innerHTML=et),E=l(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-14uwqpb"&&(b.innerHTML=st),A=l(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-5jxdnp"&&(T.innerHTML=at),Q=l(t),g=o(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1ac2mdx"&&(g.innerHTML=nt),X=l(t),_(M.$$.fragment,t),q=l(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-b6xcy8"&&(j.textContent=lt),D=l(t),_(J.$$.fragment,t),W=l(t),$=o(t,"P",{}),it($).forEach(s),this.h()},h(){ot(p,"name","hf:doc:metadata"),ot(p,"content",bt)},m(t,e){ft(document.head,p),a(t,C,e),a(t,v,e),a(t,G,e),x(h,t,e),a(t,N,e),a(t,m,e),a(t,F,e),x(u,t,e),a(t,R,e),a(t,c,e),a(t,Y,e),x(d,t,e),a(t,H,e),a(t,f,e),a(t,L,e),a(t,w,e),a(t,Z,e),a(t,y,e),a(t,E,e),a(t,b,e),a(t,A,e),a(t,T,e),a(t,Q,e),a(t,g,e),a(t,X,e),x(M,t,e),a(t,q,e),a(t,j,e),a(t,D,e),x(J,t,e),a(t,W,e),a(t,$,e),P=!0},p:ht,i(t){P||(z(h.$$.fragment,t),z(u.$$.fragment,t),z(d.$$.fragment,t),z(M.$$.fragment,t),z(J.$$.fragment,t),P=!0)},o(t){U(h.$$.fragment,t),U(u.$$.fragment,t),U(d.$$.fragment,t),U(M.$$.fragment,t),U(J.$$.fragment,t),P=!1},d(t){t&&(s(C),s(v),s(G),s(N),s(m),s(F),s(R),s(c),s(Y),s(H),s(f),s(L),s(w),s(Z),s(y),s(E),s(b),s(A),s(T),s(Q),s(g),s(X),s(q),s(j),s(D),s(W),s($)),s(p),k(h,t),k(u,t),k(d,t),k(M,t),k(J,t)}}}const bt='{"title":"Batch mapping","local":"batch-mapping","sections":[{"title":"Need for speed","local":"need-for-speed","sections":[],"depth":2},{"title":"Input size != output size","local":"input-size--output-size","sections":[],"depth":2}],"depth":1}';function Tt(B){return mt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=wt}),[]}class vt extends ut{constructor(p){super(),ct(this,p,Tt,yt,rt,{})}}export{vt as component};
