import{s as ia,n as ra,o as pa}from"../chunks/scheduler.bdbef820.js";import{S as oa,i as ma,g as i,s as n,r as o,A as ca,h as r,f as s,c as l,j as na,u as m,x as p,k as la,y as ha,a as t,v as c,d as h,t as d,w as g}from"../chunks/index.c0aea24a.js";import{H as K,g as da}from"../chunks/Heading.0e005771.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";function ga(Be){let u,ae,O,se,x,te,b,Le='There are two types of dataset objects, a regular <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and then an ✨ <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> ✨. A <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> provides fast random access to the rows, and memory-mapping so that loading even large datasets only uses a relatively small amount of device memory. But for really, really big datasets that won’t even fit on disk or in memory, an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> allows you to access and use the dataset without waiting for it to download completely!',ne,j,ze='This tutorial will show you how to load and access a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',le,w,ie,$,qe='When you load a dataset split, you’ll get a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. You can do many things with a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, which is why it’s important to learn how to manipulate and interact with the data stored inside.',re,y,He='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset, but feel free to load any dataset you’d like and follow along!',pe,v,oe,_,me,M,Pe='A <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> contains columns of data, and each column can be a different type of data. The <em>index</em>, or axis label, is used to access examples from the dataset. For example, indexing by the row returns a dictionary of an example from the dataset:',ce,k,he,T,Qe="Use the <code>-</code> operator to start from the end of the dataset:",de,I,ge,U,Ne="Indexing by the column name returns a list of all the values in the column:",fe,C,ue,J,Ee="You can combine row and column name indexing to return a specific value at a position:",xe,G,be,D,We="But it is important to remember that indexing order matters, especially when working with large audio and image datasets. Indexing by the column name returns all the values in the column first, then loads the value at that position. For large datasets, it may be slower to index by the column name first.",je,R,we,X,$e,F,Ve="Slicing returns a slice - or subset - of the dataset, which is useful for viewing several rows at once. To slice a dataset, use the <code>:</code> operator to specify a range of positions.",ye,Z,ve,Y,_e,B,Se='An <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is loaded when you set the <code>streaming</code> parameter to <code>True</code> in <a href="/docs/datasets/v2.14.6/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',Me,L,ke,z,Ae='You can also create an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> from an <em>existing</em> <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, but it is faster than streaming mode because the dataset is streamed from local files:',Te,q,Ie,H,Ke='An <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> progressively iterates over a dataset one example at a time, so you don’t have to wait for the whole dataset to download before you can use it. As you can imagine, this is quite useful for large datasets you want to use immediately!',Ue,P,Oe='However, this means an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>’s behavior is different from a regular <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a>. You don’t get random access to examples in an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. Instead, you should iterate over its elements, for example, by calling <code>next(iter())</code> or with a <code>for</code> loop to return the next item from the <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Ce,Q,Je,N,ea='You can return a subset of the dataset with a specific number of examples in it with <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a>:',Ge,E,De,W,aa='But unlike <a href="access/#slicing">slicing</a>, <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> creates a new <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Re,V,Xe,S,sa='Interested in learning more about the differences between these two types of datasets? Learn more about them in the <a href="about_mapstyle_vs_iterable">Differences between <code>Dataset</code> and <code>IterableDataset</code></a> conceptual guide.',Fe,A,ta='To get more hands-on with these datasets types, check out the <a href="process">Process</a> guide to learn how to preprocess a <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or the <a href="stream">Stream</a> guide to learn how to preprocess an <a href="/docs/datasets/v2.14.6/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Ze,ee,Ye;return x=new K({props:{title:"Know your dataset",local:"know-your-dataset",headingTag:"h1"}}),w=new K({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),v=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),_=new K({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),k=new f({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Get the first row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>}`,wrap:!1}}),I=new f({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:`<span class="hljs-comment"># Get the last row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[-<span class="hljs-number">1</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>}`,wrap:!1}}),C=new f({props:{code:"ZGF0YXNldCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;text&quot;</span>]
[<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
 <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
 <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
 ...,
 <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>]`,wrap:!1}}),G=new f({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>`,wrap:!1}}),R=new f({props:{code:"d2l0aCUyMFRpbWVyKCklM0ElMEElMjAlMjAlMjBkYXRhc2V0JTVCMCU1RCU1Qid0ZXh0JyU1RCUwQSUwQXdpdGglMjBUaW1lcigpJTNBJTBBJTIwJTIwZGF0YXNldCU1QiUyMnRleHQlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Timer():
<span class="hljs-meta">... </span>   dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;text&#x27;</span>]
Elapsed time: <span class="hljs-number">0.0031</span> seconds

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Timer():
<span class="hljs-meta">... </span>  dataset[<span class="hljs-string">&quot;text&quot;</span>][<span class="hljs-number">0</span>]
Elapsed time: <span class="hljs-number">0.0094</span> seconds`,wrap:!1}}),X=new K({props:{title:"Slicing",local:"slicing",headingTag:"h3"}}),Z=new f({props:{code:"ZGF0YXNldCU1QiUzQTMlNUQlMEElMEFkYXRhc2V0JTVCMyUzQTYlNUQ=",highlighted:`<span class="hljs-comment"># Get the first three rows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
  <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
  <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>]}

<span class="hljs-comment"># Get rows between three and six</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">3</span>:<span class="hljs-number">6</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>,
  <span class="hljs-string">&quot;emerges as something rare , an issue movie that&#x27;s so honest and keenly observed that it doesn&#x27;t feel like one .&quot;</span>,
  <span class="hljs-string">&#x27;the film provides some great insight into the neurotic mindset of all comics -- even those who have reached the absolute top of the game .&#x27;</span>]}`,wrap:!1}}),Y=new K({props:{title:"IterableDataset",local:"iterabledataset",headingTag:"h2"}}),L=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F5C520</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),q=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()`,wrap:!1}}),Q=new f({props:{code:"bmV4dChpdGVyKGl0ZXJhYmxlX2RhdGFzZXQpKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGl0ZXJhYmxlX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(iterable_dataset))
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F59B50</span>&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DE82B0</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),E=new f({props:{code:"bGlzdChpdGVyYWJsZV9kYXRhc2V0LnRha2UoMykp",highlighted:`<span class="hljs-comment"># Get first three examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(iterable_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DEE9D0</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x512 at <span class="hljs-number">0x7F7479DE8190</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x383 at <span class="hljs-number">0x7F7479DE8310</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}]`,wrap:!1}}),V=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){u=i("meta"),ae=n(),O=i("p"),se=n(),o(x.$$.fragment),te=n(),b=i("p"),b.innerHTML=Le,ne=n(),j=i("p"),j.innerHTML=ze,le=n(),o(w.$$.fragment),ie=n(),$=i("p"),$.innerHTML=qe,re=n(),y=i("p"),y.innerHTML=He,pe=n(),o(v.$$.fragment),oe=n(),o(_.$$.fragment),me=n(),M=i("p"),M.innerHTML=Pe,ce=n(),o(k.$$.fragment),he=n(),T=i("p"),T.innerHTML=Qe,de=n(),o(I.$$.fragment),ge=n(),U=i("p"),U.textContent=Ne,fe=n(),o(C.$$.fragment),ue=n(),J=i("p"),J.textContent=Ee,xe=n(),o(G.$$.fragment),be=n(),D=i("p"),D.textContent=We,je=n(),o(R.$$.fragment),we=n(),o(X.$$.fragment),$e=n(),F=i("p"),F.innerHTML=Ve,ye=n(),o(Z.$$.fragment),ve=n(),o(Y.$$.fragment),_e=n(),B=i("p"),B.innerHTML=Se,Me=n(),o(L.$$.fragment),ke=n(),z=i("p"),z.innerHTML=Ae,Te=n(),o(q.$$.fragment),Ie=n(),H=i("p"),H.innerHTML=Ke,Ue=n(),P=i("p"),P.innerHTML=Oe,Ce=n(),o(Q.$$.fragment),Je=n(),N=i("p"),N.innerHTML=ea,Ge=n(),o(E.$$.fragment),De=n(),W=i("p"),W.innerHTML=aa,Re=n(),o(V.$$.fragment),Xe=n(),S=i("p"),S.innerHTML=sa,Fe=n(),A=i("p"),A.innerHTML=ta,Ze=n(),ee=i("p"),this.h()},l(e){const a=ca("svelte-u9bgzb",document.head);u=r(a,"META",{name:!0,content:!0}),a.forEach(s),ae=l(e),O=r(e,"P",{}),na(O).forEach(s),se=l(e),m(x.$$.fragment,e),te=l(e),b=r(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-4fcew4"&&(b.innerHTML=Le),ne=l(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1m5kog1"&&(j.innerHTML=ze),le=l(e),m(w.$$.fragment,e),ie=l(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-134m4x7"&&($.innerHTML=qe),re=l(e),y=r(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-jz751l"&&(y.innerHTML=He),pe=l(e),m(v.$$.fragment,e),oe=l(e),m(_.$$.fragment,e),me=l(e),M=r(e,"P",{"data-svelte-h":!0}),p(M)!=="svelte-15zyw9z"&&(M.innerHTML=Pe),ce=l(e),m(k.$$.fragment,e),he=l(e),T=r(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-18jqw8v"&&(T.innerHTML=Qe),de=l(e),m(I.$$.fragment,e),ge=l(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-18othzs"&&(U.textContent=Ne),fe=l(e),m(C.$$.fragment,e),ue=l(e),J=r(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1gzsqvo"&&(J.textContent=Ee),xe=l(e),m(G.$$.fragment,e),be=l(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-158alym"&&(D.textContent=We),je=l(e),m(R.$$.fragment,e),we=l(e),m(X.$$.fragment,e),$e=l(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1gt5d64"&&(F.innerHTML=Ve),ye=l(e),m(Z.$$.fragment,e),ve=l(e),m(Y.$$.fragment,e),_e=l(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-vljyhj"&&(B.innerHTML=Se),Me=l(e),m(L.$$.fragment,e),ke=l(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-bdw5h1"&&(z.innerHTML=Ae),Te=l(e),m(q.$$.fragment,e),Ie=l(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1it3j2"&&(H.innerHTML=Ke),Ue=l(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-9s8vxf"&&(P.innerHTML=Oe),Ce=l(e),m(Q.$$.fragment,e),Je=l(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-atwnyy"&&(N.innerHTML=ea),Ge=l(e),m(E.$$.fragment,e),De=l(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1epz7mh"&&(W.innerHTML=aa),Re=l(e),m(V.$$.fragment,e),Xe=l(e),S=r(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-51y7bk"&&(S.innerHTML=sa),Fe=l(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-gvibb6"&&(A.innerHTML=ta),Ze=l(e),ee=r(e,"P",{}),na(ee).forEach(s),this.h()},h(){la(u,"name","hf:doc:metadata"),la(u,"content",fa)},m(e,a){ha(document.head,u),t(e,ae,a),t(e,O,a),t(e,se,a),c(x,e,a),t(e,te,a),t(e,b,a),t(e,ne,a),t(e,j,a),t(e,le,a),c(w,e,a),t(e,ie,a),t(e,$,a),t(e,re,a),t(e,y,a),t(e,pe,a),c(v,e,a),t(e,oe,a),c(_,e,a),t(e,me,a),t(e,M,a),t(e,ce,a),c(k,e,a),t(e,he,a),t(e,T,a),t(e,de,a),c(I,e,a),t(e,ge,a),t(e,U,a),t(e,fe,a),c(C,e,a),t(e,ue,a),t(e,J,a),t(e,xe,a),c(G,e,a),t(e,be,a),t(e,D,a),t(e,je,a),c(R,e,a),t(e,we,a),c(X,e,a),t(e,$e,a),t(e,F,a),t(e,ye,a),c(Z,e,a),t(e,ve,a),c(Y,e,a),t(e,_e,a),t(e,B,a),t(e,Me,a),c(L,e,a),t(e,ke,a),t(e,z,a),t(e,Te,a),c(q,e,a),t(e,Ie,a),t(e,H,a),t(e,Ue,a),t(e,P,a),t(e,Ce,a),c(Q,e,a),t(e,Je,a),t(e,N,a),t(e,Ge,a),c(E,e,a),t(e,De,a),t(e,W,a),t(e,Re,a),c(V,e,a),t(e,Xe,a),t(e,S,a),t(e,Fe,a),t(e,A,a),t(e,Ze,a),t(e,ee,a),Ye=!0},p:ra,i(e){Ye||(h(x.$$.fragment,e),h(w.$$.fragment,e),h(v.$$.fragment,e),h(_.$$.fragment,e),h(k.$$.fragment,e),h(I.$$.fragment,e),h(C.$$.fragment,e),h(G.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(Z.$$.fragment,e),h(Y.$$.fragment,e),h(L.$$.fragment,e),h(q.$$.fragment,e),h(Q.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),Ye=!0)},o(e){d(x.$$.fragment,e),d(w.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(Z.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),Ye=!1},d(e){e&&(s(ae),s(O),s(se),s(te),s(b),s(ne),s(j),s(le),s(ie),s($),s(re),s(y),s(pe),s(oe),s(me),s(M),s(ce),s(he),s(T),s(de),s(ge),s(U),s(fe),s(ue),s(J),s(xe),s(be),s(D),s(je),s(we),s($e),s(F),s(ye),s(ve),s(_e),s(B),s(Me),s(ke),s(z),s(Te),s(Ie),s(H),s(Ue),s(P),s(Ce),s(Je),s(N),s(Ge),s(De),s(W),s(Re),s(Xe),s(S),s(Fe),s(A),s(Ze),s(ee)),s(u),g(x,e),g(w,e),g(v,e),g(_,e),g(k,e),g(I,e),g(C,e),g(G,e),g(R,e),g(X,e),g(Z,e),g(Y,e),g(L,e),g(q,e),g(Q,e),g(E,e),g(V,e)}}}const fa='{"title":"Know your dataset","local":"know-your-dataset","sections":[{"title":"Dataset","local":"dataset","sections":[{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Slicing","local":"slicing","sections":[],"depth":3}],"depth":2},{"title":"IterableDataset","local":"iterabledataset","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ua(Be){return pa(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=da}),[]}class $a extends oa{constructor(u){super(),ma(this,u,ua,ga,ia,{})}}export{$a as component};
