import{s as $l,n as Bl,o as Rl}from"../chunks/scheduler.4cd3e004.js";import{S as El,i as Vl,e as o,s as n,c as p,h as Xl,a as i,d as l,b as a,f as Il,g as r,j as m,k as Ge,l as Fl,m as s,n as c,t as d,o as u,p as y}from"../chunks/index.b664cb2d.js";import{C as M}from"../chunks/CodeBlock.8601e34e.js";import{H as Ce,E as Nl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";function Al(St){let h,_e,ve,We,T,Ie,J,Qt=`Some fine-tuning techniques, such as prompt tuning, are specific to language models. That means in 🤗 PEFT, it is
assumed a 🤗 Transformers model is being used. However, other fine-tuning techniques - like
<a href="../conceptual_guides/lora">LoRA</a> - are not restricted to specific model types.`,$e,j,zt='In this guide, we will see how LoRA can be applied to a multilayer perceptron, a computer vision model from the <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library, or a new 🤗 Transformers architecture.',Be,g,Re,k,qt="Let’s assume that we want to fine-tune a multilayer perceptron with LoRA. Here is the definition:",Ee,U,Ve,x,Pt="This is a straightforward multilayer perceptron with an input layer, a hidden layer, and an output layer.",Xe,f,Dt=`<p>For this toy example, we choose an exceedingly large number of hidden units to highlight the efficiency gains
from PEFT, but those gains are in line with more realistic examples.</p>`,Fe,Z,Kt=`There are a few linear layers in this model that could be tuned with LoRA. When working with common 🤗 Transformers
models, PEFT will know which layers to apply LoRA to, but in this case, it is up to us as a user to choose the layers.
To determine the names of the layers to tune:`,Ne,C,Ae,v,Ot="This should print:",Ye,L,He,G,el=`Let’s say we want to apply LoRA to the input layer and to the hidden layer, those are <code>&#39;seq.0&#39;</code> and <code>&#39;seq.2&#39;</code>. Moreover,
let’s assume we want to update the output layer without LoRA, that would be <code>&#39;seq.4&#39;</code>. The corresponding config would
be:`,Se,_,Qe,W,tl="With that, we can create our PEFT model and check the fraction of parameters trained:",ze,I,qe,$,ll="Finally, we can use any training framework we like, or write our own fit loop, to train the <code>peft_model</code>.",Pe,B,sl='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/multilayer_perceptron/multilayer_perceptron_lora.ipynb" rel="nofollow">this notebook</a>.',De,R,Ke,E,nl=`The <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library contains a large number of pretrained computer vision models.
Those can also be fine-tuned with PEFT. Let’s check out how this works in practice.`,Oe,V,al="To start, ensure that timm is installed in the Python environment:",et,X,tt,F,ol="Next we load a timm model for an image classification task:",lt,N,st,A,il=`Again, we need to make a decision about what layers to apply LoRA to. Since LoRA supports 2D conv layers, and since
those are a major building block of this model, we should apply LoRA to the 2D conv layers. To identify the names of
those layers, let’s look at all the layer names:`,nt,Y,at,H,ml="This will print a very long list, we’ll only show the first few:",ot,S,it,Q,pl=`Upon closer inspection, we see that the 2D conv layers have names such as <code>&quot;stages.0.blocks.0.mlp.fc1&quot;</code> and
<code>&quot;stages.0.blocks.0.mlp.fc2&quot;</code>. How can we match those layer names specifically? You can write a <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular
expressions</a> to match the layer names. For our case, the regex
<code>r&quot;.*\\.mlp\\.fc\\d&quot;</code> should do the job.`,mt,z,rl=`Furthermore, as in the first example, we should ensure that the output layer, in this case the classification head, is
also updated. Looking at the end of the list printed above, we can see that it’s named <code>&#39;head.fc&#39;</code>. With that in mind,
here is our LoRA config:`,pt,q,rt,P,cl="Then we only need to create the PEFT model by passing our base model and the config to <code>get_peft_model</code>:",ct,D,dt,K,dl="This shows us that we only need to train less than 2% of all parameters, which is a huge efficiency gain.",ut,O,ul='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/image_classification/image_classification_timm_peft_lora.ipynb" rel="nofollow">this notebook</a>.',yt,ee,Mt,te,yl="When new popular transformers architectures are released, we do our best to quickly add them to PEFT. If you come across a transformers model that is not supported out of the box, don’t worry, it will most likely still work if the config is set correctly. Specifically, you have to identify the layers that should be adapted and set them correctly when initializing the corresponding config class, e.g. <code>LoraConfig</code>. Here are some tips to help with this.",ht,le,Ml='As a first step, it is a good idea to check the existing models for inspiration. You can find them inside of <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> in the PEFT repository. Often, you’ll find a similar architecture that uses the same names. For example, if the new model architecture is a variation of the “mistral” model and you want to apply LoRA, you can see that the entry for “mistral” in <code>TRANSFORMERS_MODELS_TO_LORA_TARGET_MODULES_MAPPING</code> contains <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>. This tells you that for “mistral” models, the <code>target_modules</code> for LoRA should be <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>:',ft,se,bt,ne,hl="If that doesn’t help, check the existing modules in your model architecture with the <code>named_modules</code> method and try to identify the attention layers, especially the key, query, and value layers. Those will often have names such as <code>c_attn</code>, <code>query</code>, <code>q_proj</code>, etc. The key layer is not always adapted, and ideally, you should check whether including it results in better performance.",wt,ae,fl='Additionally, linear layers are common targets to be adapted (e.g. in <a href="https://huggingface.co/papers/2305.14314" rel="nofollow">QLoRA paper</a>, authors suggest to adapt them as well). Their names will often contain the strings <code>fc</code> or <code>dense</code>.',Tt,oe,bl='If you want to add a new model to PEFT, please create an entry in <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> and open a pull request on the <a href="https://github.com/huggingface/peft/pulls" rel="nofollow">repository</a>. Don’t forget to update the <a href="https://github.com/huggingface/peft#models-support-matrix" rel="nofollow">README</a> as well.',Jt,ie,jt,me,wl="You can verify whether you’ve correctly applied a PEFT method to your model in a few ways.",gt,pe,Tl='<li>Check the fraction of parameters that are trainable with the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method. If this number is lower or higher than expected, check the model <code>repr</code> by printing the model. This shows the names of all the layer types in the model. Ensure that only the intended target layers are replaced by the adapter layers. For example, if LoRA is applied to <code>nn.Linear</code> layers, then you should only see <code>lora.Linear</code> layers being used.</li>',kt,re,Ut,ce,Jl="<li>Another way you can view the adapted layers is to use the <code>targeted_module_names</code> attribute to list the name of each module that was adapted.</li>",xt,de,Zt,ue,Ct,ye,jl="Methods like LoRA only work if the target modules are supported by PEFT. For example, it’s possible to apply LoRA to <code>nn.Linear</code> and <code>nn.Conv2d</code> layers, but not, for instance, to <code>nn.LSTM</code>. If you find a layer class you want to apply PEFT to is not supported, you can:",vt,Me,gl='<li>define a custom mapping to dynamically dispatch custom modules in LoRA</li> <li>open an <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> and request the feature where maintainers will implement it or guide you on how to implement it yourself if demand for this module type is sufficiently high</li>',Lt,he,Gt,b,kl="<p>This feature is experimental and subject to change, depending on its reception by the community. We will introduce a public and stable API if there is significant demand for it.</p>",_t,fe,Ul="PEFT supports an experimental API for custom module types for LoRA. Let’s assume you have a LoRA implementation for LSTMs. Normally, you would not be able to tell PEFT to use it, even if it would theoretically work with PEFT. However, this is possible with dynamic dispatch of custom layers.",Wt,be,xl="The experimental API currently looks like this:",It,we,$t,w,Zl='<p>When you call <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>, you will see a warning because PEFT does not recognize the targeted module type. In this case, you can ignore this warning.</p>',Bt,Te,Cl="By supplying a custom mapping, PEFT first checks the base model’s layers against the custom mapping and dispatches to the custom LoRA layer type if there is a match. If there is no match, PEFT checks the built-in LoRA layer types for a match.",Rt,Je,vl="Therefore, this feature can also be used to override existing dispatch logic, e.g. if you want to use your own LoRA layer for <code>nn.Linear</code> instead of using the one provided by PEFT.",Et,je,Ll='When creating your custom LoRA module, please follow the same rules as the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/layer.py" rel="nofollow">existing LoRA modules</a>. Some important constraints to consider:',Vt,ge,Gl="<li>The custom module should inherit from <code>nn.Module</code> and <code>peft.tuners.lora.layer.LoraLayer</code>.</li> <li>The <code>__init__</code> method of the custom module should have the positional arguments <code>base_layer</code> and <code>adapter_name</code>. After this, there are additional <code>**kwargs</code> that you are free to use or ignore.</li> <li>The learnable parameters should be stored in an <code>nn.ModuleDict</code> or <code>nn.ParameterDict</code>, where the key corresponds to the name of the specific adapter (remember that a model can have more than one adapter at a time).</li> <li>The name of these learnable parameter attributes should start with <code>&quot;lora_&quot;</code>, e.g. <code>self.lora_new_param = ...</code>.</li> <li>Some methods are optional, e.g. you only need to implement <code>merge</code> and <code>unmerge</code> if you want to support weight merging.</li>",Xt,ke,_l="Currently, the information about the custom module does not persist when you save the model. When loading the model, you have to register the custom modules again.",Ft,Ue,Nt,xe,Wl="If you use this feature and find it useful, or if you encounter problems, let us know by creating an issue or a discussion on GitHub. This allows us to estimate the demand for this feature and add a public API if it is sufficiently high.",At,Ze,Yt,Le,Ht;return T=new Ce({props:{title:"Custom models",local:"custom-models",headingTag:"h1"}}),g=new Ce({props:{title:"Multilayer perceptron",local:"multilayer-perceptron",headingTag:"h2"}}),U=new M({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyME1MUChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV91bml0c19oaWRkZW4lM0QyMDAwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2VxJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIoMjAlMkMlMjBudW1fdW5pdHNfaGlkZGVuKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcihudW1fdW5pdHNfaGlkZGVuJTJDJTIwbnVtX3VuaXRzX2hpZGRlbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIobnVtX3VuaXRzX2hpZGRlbiUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTG9nU29mdG1heChkaW0lM0QtMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwWCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnNlcShYKQ==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MLP</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_units_hidden=<span class="hljs-number">2000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.seq = nn.Sequential(
            nn.Linear(<span class="hljs-number">20</span>, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, <span class="hljs-number">2</span>),
            nn.LogSoftmax(dim=-<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, X</span>):
        <span class="hljs-keyword">return</span> self.seq(X)`,wrap:!1}}),C=new M({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),L=new M({props:{code:"JTVCKCcnJTJDJTIwX19tYWluX18uTUxQKSUyQyUwQSUyMCgnc2VxJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuY29udGFpbmVyLlNlcXVlbnRpYWwpJTJDJTBBJTIwKCdzZXEuMCclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmxpbmVhci5MaW5lYXIpJTJDJTBBJTIwKCdzZXEuMSclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmFjdGl2YXRpb24uUmVMVSklMkMlMEElMjAoJ3NlcS4yJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMubGluZWFyLkxpbmVhciklMkMlMEElMjAoJ3NlcS4zJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuYWN0aXZhdGlvbi5SZUxVKSUyQyUwQSUyMCgnc2VxLjQnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5saW5lYXIuTGluZWFyKSUyQyUwQSUyMCgnc2VxLjUnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5hY3RpdmF0aW9uLkxvZ1NvZnRtYXgpJTVE",highlighted:`[(&#x27;&#x27;, __main__.MLP),
 (<span class="hljs-symbol">&#x27;seq</span>&#x27;, torch.nn.modules.container.Sequential),
 (<span class="hljs-symbol">&#x27;seq.0</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.1</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.2</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.3</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.4</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.5</span>&#x27;, torch.nn.modules.activation.LogSoftmax)]`,wrap:!1}}),_=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnNlcS4wJTIyJTJDJTIwJTIyc2VxLjIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJzZXEuNCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;seq.0&quot;</span>, <span class="hljs-string">&quot;seq.2&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;seq.4&quot;</span>],
)`,wrap:!1}}),I=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxQKCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIzJTIwcHJpbnRzJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTYlMkMxNjQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA0JTJDMTAwJTJDMTY0JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4zNjk3OTg4NjY1ODE5MjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = MLP()
peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 56,164 || all params: 4,100,164 || trainable%: 1.369798866581922</span>`,wrap:!1}}),R=new Ce({props:{title:"timm models",local:"timm-models",headingTag:"h2"}}),X=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0aW1t",highlighted:"python -m pip install -U timm",wrap:!1}}),N=new M({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW51bV9jbGFzc2VzJTIwJTNEJTIwLi4uJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0aW1tJTJGcG9vbGZvcm1lcl9tMzYuc2FpbF9pbjFrJTIyJTBBbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbChtb2RlbF9pZCUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fY2xhc3Nlcyk=",highlighted:`<span class="hljs-keyword">import</span> timm

num_classes = ...
model_id = <span class="hljs-string">&quot;timm/poolformer_m36.sail_in1k&quot;</span>
model = timm.create_model(model_id, pretrained=<span class="hljs-literal">True</span>, num_classes=num_classes)`,wrap:!1}}),Y=new M({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBtb2RlbC5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> model.named_modules()])',wrap:!1}}),S=new M({props:{code:"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",highlighted:`[(<span class="hljs-string">&#x27;&#x27;</span>, timm.models.metaformer.MetaFormer),
 (<span class="hljs-string">&#x27;stem&#x27;</span>, timm.models.metaformer.Stem),
 (<span class="hljs-string">&#x27;stem.conv&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stem.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0&#x27;</span>, timm.models.metaformer.MetaFormerStage),
 (<span class="hljs-string">&#x27;stages.0.downsample&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0.blocks.0&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale1&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm2&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp&#x27;</span>, timm.layers.mlp.Mlp),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.act&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.activation.GELU),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale2&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.1&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 ...
 (<span class="hljs-string">&#x27;head.global_pool.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.norm&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.LayerNorm2d),
 (<span class="hljs-string">&#x27;head.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.flatten.Flatten),
 (<span class="hljs-string">&#x27;head.drop&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.fc&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Linear)]
 ]`,wrap:!1}}),q=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRHIlMjIuKiU1Qy5tbHAlNUMuZmMlNUNkJTIyJTJDJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyaGVhZC5mYyUyMiU1RCk=",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">r&quot;.*\\.mlp\\.fc\\d&quot;</span>, modules_to_save=[<span class="hljs-string">&quot;head.fc&quot;</span>])',wrap:!1}}),D=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMyUyMHByaW50cyUyMHRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDElMkMwNjQlMkM0NTQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NiUyQzQ2NyUyQzk3NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEuODg1MDU3ODkxMzk4NzY=",highlighted:`peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 1,064,454 || all params: 56,467,974 || trainable%: 1.88505789139876</span>`,wrap:!1}}),ee=new Ce({props:{title:"New transformers architectures",local:"new-transformers-architectures",headingTag:"h2"}}),se=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFteV9taXN0cmFsX21vZGVsJTIwJTNEJTIwLi4uJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMC4uLiUyQyUyMCUyMCUyMyUyMG90aGVyJTIwTG9SQSUyMGFyZ3VtZW50cyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobXlfbWlzdHJhbF9tb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

my_mistral_model = ...
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    ...,  <span class="hljs-comment"># other LoRA arguments</span>
)
peft_model = get_peft_model(my_mistral_model, config)`,wrap:!1}}),ie=new Ce({props:{title:"Verify parameters and layers",local:"verify-parameters-and-layers",headingTag:"h2"}}),re=new M({props:{code:"cGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygp",highlighted:"peft_model.print_trainable_parameters()",wrap:!1}}),de=new M({props:{code:"cHJpbnQocGVmdF9tb2RlbC50YXJnZXRlZF9tb2R1bGVfbmFtZXMp",highlighted:'<span class="hljs-built_in">print</span>(peft_model.targeted_module_names)',wrap:!1}}),ue=new Ce({props:{title:"Unsupported module types",local:"unsupported-module-types",headingTag:"h2"}}),he=new Ce({props:{title:"Experimental support for dynamic dispatch of custom modules in LoRA",local:"experimental-support-for-dynamic-dispatch-of-custom-modules-in-lora",headingTag:"h3"}}),we=new M({props:{code:"Y2xhc3MlMjBNeUxvcmFMU1RNTGF5ZXIlM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwLi4uJTIwJTIwJTIzJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyMHRoYXQlMjB1c2VzJTIwTFNUTXMlMEElMEElMjMlMjBhZGQlMjB0aGUlMjBMU1RNJTIwbGF5ZXIlMjBuYW1lcyUyMHRvJTIwdGFyZ2V0X21vZHVsZXMlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIybHN0bSUyMiU1RCklMEElMjMlMjBkZWZpbmUlMjBhJTIwbWFwcGluZyUyMGZyb20lMjBiYXNlJTIwbGF5ZXIlMjB0eXBlJTIwdG8lMjBMb1JBJTIwbGF5ZXIlMjB0eXBlJTBBY3VzdG9tX21vZHVsZV9tYXBwaW5nJTIwJTNEJTIwJTdCbm4uTFNUTSUzQSUyME15TG9yYUxTVE1MYXllciU3RCUwQSUyMyUyMHJlZ2lzdGVyJTIwdGhlJTIwbmV3JTIwbWFwcGluZyUwQWNvbmZpZy5fcmVnaXN0ZXJfY3VzdG9tX21vZHVsZShjdXN0b21fbW9kdWxlX21hcHBpbmcpJTBBJTIzJTIwYWZ0ZXIlMjByZWdpc3RyYXRpb24lMkMlMjBjcmVhdGUlMjB0aGUlMjBQRUZUJTIwbW9kZWwlMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoYmFzZV9tb2RlbCUyQyUyMGNvbmZpZyklMEElMjMlMjBkbyUyMHRyYWluaW5n",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyLoraLSTMLayer</span>:
    ...

base_model = ...  <span class="hljs-comment"># load the base model that uses LSTMs</span>

<span class="hljs-comment"># add the LSTM layer names to target_modules</span>
config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;lstm&quot;</span>])
<span class="hljs-comment"># define a mapping from base layer type to LoRA layer type</span>
custom_module_mapping = {nn.LSTM: MyLoraLSTMLayer}
<span class="hljs-comment"># register the new mapping</span>
config._register_custom_module(custom_module_mapping)
<span class="hljs-comment"># after registration, create the PEFT model</span>
peft_model = get_peft_model(base_model, config)
<span class="hljs-comment"># do training</span>`,wrap:!1}}),Ue=new M({props:{code:"JTIzJTIwc2F2aW5nJTIwd29ya3MlMjBhcyUyMGFsd2F5cyUyMGFuZCUyMGluY2x1ZGVzJTIwdGhlJTIwcGFyYW1ldGVycyUyMG9mJTIwdGhlJTIwY3VzdG9tJTIwbW9kdWxlcyUwQXBlZnRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUzQ21vZGVsLXBhdGglM0UpJTBBJTBBJTIzJTIwbG9hZGluZyUyMHRoZSUyMG1vZGVsJTIwbGF0ZXIlM0ElMEFiYXNlX21vZGVsJTIwJTNEJTIwLi4uJTBBJTIzJTIwbG9hZCUyMHRoZSUyMExvUkElMjBjb25maWclMjB0aGF0JTIweW91JTIwc2F2ZWQlMjBlYXJsaWVyJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTNDbW9kZWwtcGF0aCUzRSklMEElMjMlMjByZWdpc3RlciUyMHRoZSUyMGN1c3RvbSUyMG1vZHVsZSUyMGFnYWluJTJDJTIwdGhlJTIwc2FtZSUyMHdheSUyMGFzJTIwdGhlJTIwZmlyc3QlMjB0aW1lJTBBY3VzdG9tX21vZHVsZV9tYXBwaW5nJTIwJTNEJTIwJTdCbm4uTFNUTSUzQSUyME15TG9yYUxTVE1MYXllciU3RCUwQWNvbmZpZy5fcmVnaXN0ZXJfY3VzdG9tX21vZHVsZShjdXN0b21fbW9kdWxlX21hcHBpbmcpJTBBJTIzJTIwcGFzcyUyMHRoZSUyMGNvbmZpZyUyMGluc3RhbmNlJTIwdG8lMjBmcm9tX3ByZXRyYWluZWQlM0ElMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMHRtcF9wYXRoJTIwJTJGJTIwJTIybG9yYS1jdXN0b20tbW9kdWxlJTIyJTJDJTIwY29uZmlnJTNEY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># saving works as always and includes the parameters of the custom modules</span>
peft_model.save_pretrained(&lt;model-path&gt;)

<span class="hljs-comment"># loading the model later:</span>
base_model = ...
<span class="hljs-comment"># load the LoRA config that you saved earlier</span>
config = LoraConfig.from_pretrained(&lt;model-path&gt;)
<span class="hljs-comment"># register the custom module again, the same way as the first time</span>
custom_module_mapping = {nn.LSTM: MyLoraLSTMLayer}
config._register_custom_module(custom_module_mapping)
<span class="hljs-comment"># pass the config instance to from_pretrained:</span>
peft_model = PeftModel.from_pretrained(model, tmp_path / <span class="hljs-string">&quot;lora-custom-module&quot;</span>, config=config)`,wrap:!1}}),Ze=new Nl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/custom_models.md"}}),{c(){h=o("meta"),_e=n(),ve=o("p"),We=n(),p(T.$$.fragment),Ie=n(),J=o("p"),J.innerHTML=Qt,$e=n(),j=o("p"),j.innerHTML=zt,Be=n(),p(g.$$.fragment),Re=n(),k=o("p"),k.textContent=qt,Ee=n(),p(U.$$.fragment),Ve=n(),x=o("p"),x.textContent=Pt,Xe=n(),f=o("blockquote"),f.innerHTML=Dt,Fe=n(),Z=o("p"),Z.textContent=Kt,Ne=n(),p(C.$$.fragment),Ae=n(),v=o("p"),v.textContent=Ot,Ye=n(),p(L.$$.fragment),He=n(),G=o("p"),G.innerHTML=el,Se=n(),p(_.$$.fragment),Qe=n(),W=o("p"),W.textContent=tl,ze=n(),p(I.$$.fragment),qe=n(),$=o("p"),$.innerHTML=ll,Pe=n(),B=o("p"),B.innerHTML=sl,De=n(),p(R.$$.fragment),Ke=n(),E=o("p"),E.innerHTML=nl,Oe=n(),V=o("p"),V.textContent=al,et=n(),p(X.$$.fragment),tt=n(),F=o("p"),F.textContent=ol,lt=n(),p(N.$$.fragment),st=n(),A=o("p"),A.textContent=il,nt=n(),p(Y.$$.fragment),at=n(),H=o("p"),H.textContent=ml,ot=n(),p(S.$$.fragment),it=n(),Q=o("p"),Q.innerHTML=pl,mt=n(),z=o("p"),z.innerHTML=rl,pt=n(),p(q.$$.fragment),rt=n(),P=o("p"),P.innerHTML=cl,ct=n(),p(D.$$.fragment),dt=n(),K=o("p"),K.textContent=dl,ut=n(),O=o("p"),O.innerHTML=ul,yt=n(),p(ee.$$.fragment),Mt=n(),te=o("p"),te.innerHTML=yl,ht=n(),le=o("p"),le.innerHTML=Ml,ft=n(),p(se.$$.fragment),bt=n(),ne=o("p"),ne.innerHTML=hl,wt=n(),ae=o("p"),ae.innerHTML=fl,Tt=n(),oe=o("p"),oe.innerHTML=bl,Jt=n(),p(ie.$$.fragment),jt=n(),me=o("p"),me.textContent=wl,gt=n(),pe=o("ul"),pe.innerHTML=Tl,kt=n(),p(re.$$.fragment),Ut=n(),ce=o("ul"),ce.innerHTML=Jl,xt=n(),p(de.$$.fragment),Zt=n(),p(ue.$$.fragment),Ct=n(),ye=o("p"),ye.innerHTML=jl,vt=n(),Me=o("ul"),Me.innerHTML=gl,Lt=n(),p(he.$$.fragment),Gt=n(),b=o("blockquote"),b.innerHTML=kl,_t=n(),fe=o("p"),fe.textContent=Ul,Wt=n(),be=o("p"),be.textContent=xl,It=n(),p(we.$$.fragment),$t=n(),w=o("blockquote"),w.innerHTML=Zl,Bt=n(),Te=o("p"),Te.textContent=Cl,Rt=n(),Je=o("p"),Je.innerHTML=vl,Et=n(),je=o("p"),je.innerHTML=Ll,Vt=n(),ge=o("ul"),ge.innerHTML=Gl,Xt=n(),ke=o("p"),ke.textContent=_l,Ft=n(),p(Ue.$$.fragment),Nt=n(),xe=o("p"),xe.textContent=Wl,At=n(),p(Ze.$$.fragment),Yt=n(),Le=o("p"),this.h()},l(e){const t=Xl("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),_e=a(e),ve=i(e,"P",{}),Il(ve).forEach(l),We=a(e),r(T.$$.fragment,e),Ie=a(e),J=i(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1twj2ga"&&(J.innerHTML=Qt),$e=a(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-14u0q1"&&(j.innerHTML=zt),Be=a(e),r(g.$$.fragment,e),Re=a(e),k=i(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1vzm18b"&&(k.textContent=qt),Ee=a(e),r(U.$$.fragment,e),Ve=a(e),x=i(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-ifflo"&&(x.textContent=Pt),Xe=a(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(f)!=="svelte-z1rh00"&&(f.innerHTML=Dt),Fe=a(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-19hnh19"&&(Z.textContent=Kt),Ne=a(e),r(C.$$.fragment,e),Ae=a(e),v=i(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-47m0b6"&&(v.textContent=Ot),Ye=a(e),r(L.$$.fragment,e),He=a(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-hvbljg"&&(G.innerHTML=el),Se=a(e),r(_.$$.fragment,e),Qe=a(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-12m4713"&&(W.textContent=tl),ze=a(e),r(I.$$.fragment,e),qe=a(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-3iyeuu"&&($.innerHTML=ll),Pe=a(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-12a8po"&&(B.innerHTML=sl),De=a(e),r(R.$$.fragment,e),Ke=a(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1el2qhw"&&(E.innerHTML=nl),Oe=a(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-132k8n8"&&(V.textContent=al),et=a(e),r(X.$$.fragment,e),tt=a(e),F=i(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1i7knza"&&(F.textContent=ol),lt=a(e),r(N.$$.fragment,e),st=a(e),A=i(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-66d7qt"&&(A.textContent=il),nt=a(e),r(Y.$$.fragment,e),at=a(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-132x2pj"&&(H.textContent=ml),ot=a(e),r(S.$$.fragment,e),it=a(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-odd6w6"&&(Q.innerHTML=pl),mt=a(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-vtvaop"&&(z.innerHTML=rl),pt=a(e),r(q.$$.fragment,e),rt=a(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1ym7j5n"&&(P.innerHTML=cl),ct=a(e),r(D.$$.fragment,e),dt=a(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1a6hk12"&&(K.textContent=dl),ut=a(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-13ceymq"&&(O.innerHTML=ul),yt=a(e),r(ee.$$.fragment,e),Mt=a(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-zh7y7t"&&(te.innerHTML=yl),ht=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1hpkhh2"&&(le.innerHTML=Ml),ft=a(e),r(se.$$.fragment,e),bt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-tkcysf"&&(ne.innerHTML=hl),wt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1x641jx"&&(ae.innerHTML=fl),Tt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-485c9z"&&(oe.innerHTML=bl),Jt=a(e),r(ie.$$.fragment,e),jt=a(e),me=i(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-g4uxja"&&(me.textContent=wl),gt=a(e),pe=i(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-1809myv"&&(pe.innerHTML=Tl),kt=a(e),r(re.$$.fragment,e),Ut=a(e),ce=i(e,"UL",{"data-svelte-h":!0}),m(ce)!=="svelte-1lks9wd"&&(ce.innerHTML=Jl),xt=a(e),r(de.$$.fragment,e),Zt=a(e),r(ue.$$.fragment,e),Ct=a(e),ye=i(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1nivrxo"&&(ye.innerHTML=jl),vt=a(e),Me=i(e,"UL",{"data-svelte-h":!0}),m(Me)!=="svelte-1pyzk0w"&&(Me.innerHTML=gl),Lt=a(e),r(he.$$.fragment,e),Gt=a(e),b=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-1vrnyaz"&&(b.innerHTML=kl),_t=a(e),fe=i(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1ve93t1"&&(fe.textContent=Ul),Wt=a(e),be=i(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-hzxzie"&&(be.textContent=xl),It=a(e),r(we.$$.fragment,e),$t=a(e),w=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-uhqcde"&&(w.innerHTML=Zl),Bt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1rh0r2d"&&(Te.textContent=Cl),Rt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1p8m775"&&(Je.innerHTML=vl),Et=a(e),je=i(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-qp8f4l"&&(je.innerHTML=Ll),Vt=a(e),ge=i(e,"UL",{"data-svelte-h":!0}),m(ge)!=="svelte-c8ydbv"&&(ge.innerHTML=Gl),Xt=a(e),ke=i(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1bmvvdg"&&(ke.textContent=_l),Ft=a(e),r(Ue.$$.fragment,e),Nt=a(e),xe=i(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-n2s6f5"&&(xe.textContent=Wl),At=a(e),r(Ze.$$.fragment,e),Yt=a(e),Le=i(e,"P",{}),Il(Le).forEach(l),this.h()},h(){Ge(h,"name","hf:doc:metadata"),Ge(h,"content",Yl),Ge(f,"class","tip"),Ge(b,"class","warning"),Ge(w,"class","tip")},m(e,t){Fl(document.head,h),s(e,_e,t),s(e,ve,t),s(e,We,t),c(T,e,t),s(e,Ie,t),s(e,J,t),s(e,$e,t),s(e,j,t),s(e,Be,t),c(g,e,t),s(e,Re,t),s(e,k,t),s(e,Ee,t),c(U,e,t),s(e,Ve,t),s(e,x,t),s(e,Xe,t),s(e,f,t),s(e,Fe,t),s(e,Z,t),s(e,Ne,t),c(C,e,t),s(e,Ae,t),s(e,v,t),s(e,Ye,t),c(L,e,t),s(e,He,t),s(e,G,t),s(e,Se,t),c(_,e,t),s(e,Qe,t),s(e,W,t),s(e,ze,t),c(I,e,t),s(e,qe,t),s(e,$,t),s(e,Pe,t),s(e,B,t),s(e,De,t),c(R,e,t),s(e,Ke,t),s(e,E,t),s(e,Oe,t),s(e,V,t),s(e,et,t),c(X,e,t),s(e,tt,t),s(e,F,t),s(e,lt,t),c(N,e,t),s(e,st,t),s(e,A,t),s(e,nt,t),c(Y,e,t),s(e,at,t),s(e,H,t),s(e,ot,t),c(S,e,t),s(e,it,t),s(e,Q,t),s(e,mt,t),s(e,z,t),s(e,pt,t),c(q,e,t),s(e,rt,t),s(e,P,t),s(e,ct,t),c(D,e,t),s(e,dt,t),s(e,K,t),s(e,ut,t),s(e,O,t),s(e,yt,t),c(ee,e,t),s(e,Mt,t),s(e,te,t),s(e,ht,t),s(e,le,t),s(e,ft,t),c(se,e,t),s(e,bt,t),s(e,ne,t),s(e,wt,t),s(e,ae,t),s(e,Tt,t),s(e,oe,t),s(e,Jt,t),c(ie,e,t),s(e,jt,t),s(e,me,t),s(e,gt,t),s(e,pe,t),s(e,kt,t),c(re,e,t),s(e,Ut,t),s(e,ce,t),s(e,xt,t),c(de,e,t),s(e,Zt,t),c(ue,e,t),s(e,Ct,t),s(e,ye,t),s(e,vt,t),s(e,Me,t),s(e,Lt,t),c(he,e,t),s(e,Gt,t),s(e,b,t),s(e,_t,t),s(e,fe,t),s(e,Wt,t),s(e,be,t),s(e,It,t),c(we,e,t),s(e,$t,t),s(e,w,t),s(e,Bt,t),s(e,Te,t),s(e,Rt,t),s(e,Je,t),s(e,Et,t),s(e,je,t),s(e,Vt,t),s(e,ge,t),s(e,Xt,t),s(e,ke,t),s(e,Ft,t),c(Ue,e,t),s(e,Nt,t),s(e,xe,t),s(e,At,t),c(Ze,e,t),s(e,Yt,t),s(e,Le,t),Ht=!0},p:Bl,i(e){Ht||(d(T.$$.fragment,e),d(g.$$.fragment,e),d(U.$$.fragment,e),d(C.$$.fragment,e),d(L.$$.fragment,e),d(_.$$.fragment,e),d(I.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(he.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(Ze.$$.fragment,e),Ht=!0)},o(e){u(T.$$.fragment,e),u(g.$$.fragment,e),u(U.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u(_.$$.fragment,e),u(I.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(S.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),Ht=!1},d(e){e&&(l(_e),l(ve),l(We),l(Ie),l(J),l($e),l(j),l(Be),l(Re),l(k),l(Ee),l(Ve),l(x),l(Xe),l(f),l(Fe),l(Z),l(Ne),l(Ae),l(v),l(Ye),l(He),l(G),l(Se),l(Qe),l(W),l(ze),l(qe),l($),l(Pe),l(B),l(De),l(Ke),l(E),l(Oe),l(V),l(et),l(tt),l(F),l(lt),l(st),l(A),l(nt),l(at),l(H),l(ot),l(it),l(Q),l(mt),l(z),l(pt),l(rt),l(P),l(ct),l(dt),l(K),l(ut),l(O),l(yt),l(Mt),l(te),l(ht),l(le),l(ft),l(bt),l(ne),l(wt),l(ae),l(Tt),l(oe),l(Jt),l(jt),l(me),l(gt),l(pe),l(kt),l(Ut),l(ce),l(xt),l(Zt),l(Ct),l(ye),l(vt),l(Me),l(Lt),l(Gt),l(b),l(_t),l(fe),l(Wt),l(be),l(It),l($t),l(w),l(Bt),l(Te),l(Rt),l(Je),l(Et),l(je),l(Vt),l(ge),l(Xt),l(ke),l(Ft),l(Nt),l(xe),l(At),l(Yt),l(Le)),l(h),y(T,e),y(g,e),y(U,e),y(C,e),y(L,e),y(_,e),y(I,e),y(R,e),y(X,e),y(N,e),y(Y,e),y(S,e),y(q,e),y(D,e),y(ee,e),y(se,e),y(ie,e),y(re,e),y(de,e),y(ue,e),y(he,e),y(we,e),y(Ue,e),y(Ze,e)}}}const Yl='{"title":"Custom models","local":"custom-models","sections":[{"title":"Multilayer perceptron","local":"multilayer-perceptron","sections":[],"depth":2},{"title":"timm models","local":"timm-models","sections":[],"depth":2},{"title":"New transformers architectures","local":"new-transformers-architectures","sections":[],"depth":2},{"title":"Verify parameters and layers","local":"verify-parameters-and-layers","sections":[],"depth":2},{"title":"Unsupported module types","local":"unsupported-module-types","sections":[{"title":"Experimental support for dynamic dispatch of custom modules in LoRA","local":"experimental-support-for-dynamic-dispatch-of-custom-modules-in-lora","sections":[],"depth":3}],"depth":2}],"depth":1}';function Hl(St){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pl extends El{constructor(h){super(),Vl(this,h,Hl,Al,$l,{})}}export{Pl as component};
