import{s as mr,n as cr,o as hr}from"../chunks/scheduler.4cd3e004.js";import{S as fr,i as ur,e as o,s as n,c as p,h as Mr,a as i,d as a,b as s,f as Ya,g as d,j as r,k as Z,l as w,m as l,n as m,t as c,o as h,p as f}from"../chunks/index.b664cb2d.js";import{C as u}from"../chunks/CodeBlock.8601e34e.js";import{H as M,E as wr}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";function yr(co){let T,Ha,xa,Qa,U,Ea,B,ho='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',za,I,fo="This guide explores in more detail other options and features for using LoRA.",qa,C,Na,R,uo='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Sa,$,Mo='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Pa,W,Da,L,wo="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",Ka,G,Oa,A,el,V,yo='<a href="https://huggingface.co/papers/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',tl,X,bo="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",al,x,ll,F,To="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",nl,Y,sl,H,go='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',ol,Q,il,E,Jo=`<a href="https://huggingface.co/papers/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,rl,z,jo="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",pl,q,dl,N,_o='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',ml,S,cl,P,vo='<a href="https://huggingface.co/papers/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',hl,D,ko="You just need to pass a single additional option to use OLoRA:",fl,K,ul,O,Zo='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',Ml,ee,wl,te,Uo='<a href="https://huggingface.co/papers/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',yl,ae,Bo='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/main/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',bl,le,Tl,ne,Io="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",gl,se,Co='It is recommended to perform EVA initialization on an accelerator(e.g. CUDA GPU, Intel XPU) as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',Jl,oe,jl,ie,Ro='Then, call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',_l,re,vl,pe,$o='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',kl,J,Wo='<p>For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.</p>',Zl,de,Ul,me,Bl,ce,Lo='When quantizing the base model for QLoRA training, consider using the <a href="https://huggingface.co/papers/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Il,he,Go="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Cl,fe,Rl,ue,Ao="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",$l,Me,Wl,we,Vo='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Ll,ye,Xo="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratively updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Gl,be,xo="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Al,Te,Fo="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Vl,j,Yo='<p>Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.</p>',Xl,ge,xl,Je,Ho='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Fl,je,Yl,_e,Hl,ve,Qo='Activated LoRA (aLoRA) is a low rank adapter architecture for Causal LMs that allows for reusing existing base model KV cache for more efficient inference. This approach is best suited for inference pipelines which rely on the base model for most tasks/generations, but use aLoRA adapter(s) to perform specialized task(s) within the chain. For example, checking or correcting generated outputs of the base model. In these settings, inference times can be sped up by an order of magnitude or more. For more information on aLoRA and many example use cases, see <a href="https://huggingface.co/papers/2504.12397" rel="nofollow">https://huggingface.co/papers/2504.12397</a>.',Ql,ke,Eo="This technique scans for the last occurence of an invocation sequence (<code>alora_invocation_tokens</code>) in each input (this can be as short as 1 token), and activates the adapter weights on tokens starting with the beginning of the invocation sequence (any inputs after the invocation sequence are also adapted, and all generated tokens will use the adapted weights). Weights on prior tokens are left un-adapted — making the cache for those tokens interchangeable with base model cache due to the causal attention mask in Causal LMs. Usage is very similar to standard LoRA, with the key difference that this invocation sequence must be specified when the adapter is created:",El,Ze,zl,Ue,zo="where <code>alora_invocation_tokens</code> is a list of integer token ids. Given a desired invocation string, this can be obtained as",ql,Be,Nl,Ie,qo="where the tokenizer is the tokenizer for the base model. Note that we have <code>add_special_tokens=False</code> to avoid adding SOS/EOS tokens in our search string (which will most likely cause failure to find).",Sl,Ce,No="<strong>Notes</strong>",Pl,Re,So='<li>aLoRA is only supported for <code>task_type=CAUSAL_LM</code> tasks due to its focus on cache reuse.</li> <li>Since the weights are adapted on fewer tokens, often (not always) aLoRA requires higher rank (<code>r</code>) than LoRA. <code>r=32</code> can be a good starting point.</li> <li>aLoRA weights cannot be merged into the base model by definition, since the adapter weights are selectively applied to a subset of tokens. Attempts to merge will throw errors.</li> <li>Beam search is not yet supported.</li> <li>It is generally not recommended to add new tokens to the tokenizer that are not present in the base model, as this can complicate the target use case of both the base model and adapter model operating on overlapping context. That said, there is a possible workaround by first efficiently adding <a href="https://huggingface.co/docs/peft/en/package_reference/trainable_tokens" rel="nofollow">trainable tokens</a> to the base model prior to training the adapter.</li>',Dl,$e,Kl,We,Po=`Each input must have the <code>alora_invocation_tokens</code> sequence present, it is not added automatically. To maximize model performance without compromising cache reuse, it is recommended to have the adapter weights activated early, i.e. at the start of any adapter-specific prompting, but after any long inputs such as prior generations or documents. As with any model,
formatting should be consistent between train and test.`,Ol,Le,Do=`Consider the following example, where the base model has a chat template,
and the goal is to train the adapter to generate a desired output.`,en,Ge,Ko="<li>Option 1: If there is no task-specific prompt, i.e. the input is a chat history with the <code>assistant</code> prompt, then the chat template’s <code>assistant</code> prompt (e.g. <code>&lt;|start_of_role|&gt;assistant&lt;|end_of_role|&gt;</code>) is a natural choice for the invocation string. See the model’s chat template to find the prompt for the model.</li> <li>Option 2: If there is a task-specific prompt for the adapter that describes the task the adapter is learning, and that prompt is put as a <code>user</code> turn immediately prior to the generation, then the chat template’s <code>user</code> prompt (e.g. <code>&lt;|start_of_role|&gt;user&lt;|end_of_role|&gt;</code>) is a natural choice for the invocation string.</li>",tn,Ae,Oo="Once deciding on an invocation string, get the model tokenizer and obtain <code>alora_invocation_tokens</code> as",an,Ve,ln,Xe,ei='An example inference setup is at <a href="https://github.com/huggingface/peft/blob/main/examples/alora_finetuning/alora_finetuning.py" rel="nofollow">alora finetuning</a>.',nn,xe,ti="<strong>Note</strong> If using custom strings for the invocation string, make sure that the start and end of the string are special tokens to avoid issues with tokenization at the boundaries.",sn,Fe,ai="To see why, imagine that ‘a’, ‘b’, ‘c’, and ‘ab’ are tokens in your tokenizer (numbers 1, 2, 3, 4 respectively). Suppose that your alora_invocation_tokens = [2, 3]. Now imagine your input string is “abc”. Because “ab” is a token, this will get tokenized as [4,3]. So the alora_invocation_tokens will fail to be found, despite the string “bc” being in it. If the start and end of the invocation string are special tokens, however, this failure case will never happen since special tokens are never tokenized into the same token with other characters.",on,Ye,rn,He,li="The main purpose of Activated LoRA is to make KV cache interchangeable between the base model and aLoRA adapter models <strong>prior to the invocation sequence</strong> since base and adapted KV values are not compatible. Specifically, keys and values stored during one model generation can be used in subsequent generations to avoid expensive prefill operations for context tokens. When sharing cache between the base model and aLoRA adapters, there are 2 main patterns:",pn,Qe,ni="<li>The base model has generated something, and an aLoRA adapter is then called to do a followup generation. Example: the base model answers a question, and an aLoRA trained to detect hallucinations checks the base model response.</li> <li>An aLoRA adapter has generated something, and the base model or a different aLoRA adapter is called to do a followup generation where there is partial context overlap with the original aLoRA. Example: The user provides a query, and an aLoRA rewrites the query to be more self-contained and improve retrieval in a RAG system. Then, documents are retrieved and loaded into context, an aLoRA checks if these documents are indeed relevant to the question, and then the base model generates an answer.</li>",dn,Ee,si='To demonstrate the above behaviors when using caching, we’re using <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">DynamicCache</a> from <code>transformers</code>. Care must be taken to ensure that adapted cache values are not mixed with base cache values. In particular, an extra step is required for sharing the cache when there is partial context overlap (pattern 2).',mn,ze,oi="<strong>Pattern 1: Base model followed by aLoRA</strong> Here, the entire input and generation from the base model is input into the aLoRA adapter, along with the invocation sequence:",cn,qe,hn,Ne,ii="<strong>Pattern 2: aLoRA generation followed by base model (or another aLoRA) with partial context overlap</strong> Here, we prefill the shared context using the base model, and then generate.",fn,Se,un,Pe,Mn,De,ri='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://huggingface.co/papers/2402.09353" rel="nofollow">https://huggingface.co/papers/2402.09353</a>.',wn,Ke,yn,Oe,pi="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",bn,et,Tn,tt,di="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",gn,at,Jn,lt,mi=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 ZE_AFFINITY_MASK=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,jn,nt,ci='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',_n,st,vn,ot,hi='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',kn,it,Zn,rt,fi='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',Un,pt,Bn,dt,In,mt,ui='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://huggingface.co/papers/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Cn,ct,Rn,ht,Mi='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',$n,ft,wi=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Wn,ut,Ln,Mt,yi='By default, all layers targeted with LoRA will have the same rank <code>r</code> and the same <code>lora_alpha</code> (which determines the LoRA scaling), depending on what was specified in the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. In some cases, however, you may want to indicate different values for different layers. This is possible by passing the <code>rank_pattern</code> and <code>alpha_pattern</code> arguments to <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. These arguments should be dictionaries with the key being the layer name and the value being the rank/alpha value. The keys can be <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular expressions</a> (regex). All LoRA layers that are not explicitly mentioned in <code>rank_pattern</code> and <code>alpha_pattern</code> will take the default <code>r</code> and <code>lora_alpha</code> values.',Gn,wt,bi="To give an example, let’s assume that we have a model with the following structure:",An,yt,Vn,bt,Ti="<li><code>rank_pattern={&quot;foo&quot;: 42}</code> will match all 3 <code>foo</code> layers. Neither <code>foobar</code> nor <code>barfoo</code> are matched.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42}</code> will only match the <code>foo</code> layer of the model, but neither <code>module.foo</code> nor <code>module.module.foo</code>. This is because the <code>^</code> means “start of string” when using regular expressions, and only <code>foo</code> starts with <code>&quot;foo&quot;</code>, the other layer names have prefixes.</li> <li><code>rank_pattern={&quot;^module.foo&quot;: 42}</code> matches only <code>module.foo</code>, but not <code>module.module.foo</code>, for the same reason.</li> <li><code>rank_pattern={&quot;module.foo&quot;: 42}</code> matches both <code>module.foo</code> and <code>module.module.foo</code>, but not <code>foo</code>.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42, &quot;^module.module.foo&quot;: 55}</code> matches <code>foo</code> and <code>module.module.foo</code>, respectively, but not <code>module.foo</code>.</li> <li>There is no need to indicate <code>$</code> to mark the end of the match, as this is added automatically by PEFT.</li>",Xn,Tt,gi="The same logic applies to <code>alpha_pattern</code>. If you’re in doubt, don’t try to get fancy with regular expressions — just pass the full name for each module with a different rank/alpha, preceded by the <code>^</code> prefix, and you should be good.",xn,gt,Fn,_,Ji="<p>This feature is experimental and subject to change.</p>",Yn,Jt,ji='Generally, you should use <code>target_modules</code> to target the module (e.g. <code>nn.Linear</code>). However, in some circumstances, this is not possible. E.g., in many mixture of expert (MoE) layers in HF Transformers, instead of using <code>nn.Linear</code>, an <code>nn.Parameter</code> is used. PEFT normally overwrites the <code>forward</code> method for LoRA, but for <code>nn.Parameter</code>, there is none. Therefore, to apply LoRA to that parameter, it needs to be targeted with <code>target_parameters</code>. As an example, for <a href="https://huggingface.co/collections/meta-llama/llama-4-67f0c30d9fe03840bc9d0164" rel="nofollow">Llama4</a>, you can pass: <code>target_parameters=[&#39;feed_forward.experts.gate_up_proj&#39;, &#39;feed_forward.experts.down_proj]</code>.',Hn,jt,Qn,_t,_i="<li>At the moment, this argument allows to target 2-dim or 3-dim <code>nn.Parameter</code>s. It is assumed that in the case of a 3-dim parameter, the 0th dimension is the expert dimension.</li> <li>It is currently not possible to add multiple LoRA adapters (via <code>model.add_adapter</code> or <code>model.load_adapter</code>) that use <code>target_parameters</code> at the same time.</li>",En,vt,zn,kt,vi="LoRA training can optionally include special purpose optimizers. Currently PEFT supports LoRA-FA and LoRA+.",qn,Zt,Nn,Ut,ki='LoRA training can be more effective and efficient using LoRA-FA, as described in <a href="https://huggingface.co/papers/2308.03303" rel="nofollow">LoRA-FA</a>. LoRA-FA reduces activation memory consumption by fixing the matrix A and only tuning the matrix B. During training, the gradient of B is optimized to approximate the full parameter fine-tuning gradient. Moreover, the memory consumption of LoRA-FA is not sensitive to the rank (since it erases the activation of $A$), therefore it can improve performance by enlarging lora rank without increasing memory consumption.',Sn,Bt,Pn,It,Dn,Ct,Zi='LoRA training can be optimized using <a href="https://huggingface.co/papers/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',Kn,Rt,On,$t,es,Wt,Ui='Sometimes it is necessary to not only change some layer’s weights but to add new tokens as well. With larger models this can be a memory-costly endeavour. PEFT LoRA adapters support the <code>trainable_token_indices</code> parameter which allows tuning of other tokens alongside fine-tuning of specific layers with LoRA. This method only trains the tokens you specify and leaves all other tokens untouched. This saves memory and doesn’t throw away learned context of existing token embeddings in contrast to when training the whole embedding matrix. Under the hood this method uses the layer of <a href="/docs/peft/main/en/package_reference/trainable_tokens#peft.TrainableTokensModel">TrainableTokensModel</a>.',ts,Lt,as,Gt,Bi="In the snippet below we show how to add new tokens to the model and how to train it alongside the other layers in the model.",ls,At,ns,Vt,Ii=`The token weights are part of your adapter state dict and saved alongside the LoRA weights.
If we would have used full fine-tuning with <code>modules_to_save=[&#39;embed_tokens&#39;]</code> we would have stored the full embedding matrix in the checkpoint, leading to a much bigger file.`,ss,Xt,Ci="To give a bit of an indication how much VRAM can be saved, a rudimentary comparison of the above example was made between training the embedding matrix fully (<code>modules_to_save=[&quot;embed_tokens&quot;]</code>), using a LoRA for the embedding matrix (<code>target_modules=[..., &quot;embed_tokens&quot;]</code>, rank 32) and trainable tokens (<code>trainable_token_indices=[...]</code>, 6 tokens). Trainable tokens used about as much VRAM (15,562MB vs. 15,581MB) as LoRA while being specific to the tokens and saved ~1GB of VRAM over fully training the embedding matrix.",os,xt,is,Ft,Ri='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',rs,Yt,$i="Below is a diagram that explains the intuition of LoRA adapter merging:",ps,v,Wi='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',ds,Ht,Li="We show in the snippets below how to run that using PEFT.",ms,Qt,cs,Et,Gi='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',hs,zt,fs,qt,Ai='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',us,Nt,Vi="First load the base model:",Ms,St,ws,Pt,Xi="Then we load the first adapter:",ys,Dt,bs,Kt,xi="Then load a different adapter and merge it with the first one:",Ts,Ot,gs,k,Fi='<p>There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.</p>',Js,ea,Yi="Now, perform inference:",js,ta,_s,aa,vs,la,Hi='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.set_adapter">set_adapter()</a> function.',ks,na,Zs,sa,Qi='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Us,oa,Bs,ia,Is,ra,Ei="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Cs,pa,zi="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Rs,da,$s,ma,qi="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Ws,ca,Ls,ha,Ni="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Gs,fa,Si="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",As,ua,Vs,Ma,Pi="Using this feature has some drawbacks, namely:",Xs,wa,Di='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights were merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handful of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',xs,ya,Fs,ba,Ys,Ta,Ki='<a href="https://huggingface.co/papers/2405.11157" rel="nofollow">Arrow</a> is a modular routing algorithm designed to combine multiple pre-trained task-specific LoRA adapters to solve a given task. Rather than merging all adapters naively, Arrow introduces a <strong>gradient-free, token-wise mixture-of-experts (MoE) routing mechanism</strong>. At inference time, it first computes a <em>prototype</em> for each LoRA by extracting the top right singular vector from its SVD decomposition. Each token representation is then compared to these prototypes via cosine similarity to obtain routing coefficients. Tokens are assigned to the top-k most relevant LoRA adapters, with the coefficients normalized through softmax, and their outputs linearly combined. This allows effective reuse of existing LoRA modules for new tasks and leads to stronger zero-shot generalization.',Hs,ga,Oi="In PEFT, Arrow is enabled through <code>ArrowConfig</code> and <code>create_arrow_model</code>. You can also configure parameters such as <code>top_k</code> (the number of LoRA adapters combined per token), <code>router_temperature</code> (the softmax temperature applied to the routing coefficients), and <code>rng_seed</code> (for reproducibility).",Qs,Ja,Es,ja,er="Furthermore, you can add or remove adapters after calling <code>create_arrow_model</code>—for example, to fine-tune a new adapter or discard an unnecessary one. Once the adapters are in place, you can activate the <code>&quot;arrow_router&quot;</code> for inference to use Arrow. Note that if you add a new LoRA adapter after <code>create_arrow_model</code> and want to fine-tune it, you must explicitly set the new adapter as active, since <code>&quot;arrow_router&quot;</code> is activated by default in <code>create_arrow_model</code>.",zs,_a,qs,va,Ns,ka,tr='<a href="https://aclanthology.org/2025.acl-short.54/" rel="nofollow">GenKnowSub</a> augments Arrow by purifying task-specific LoRA adapters before routing. The key idea is to subtract general knowledge encoded in LoRA space—based on the <a href="https://huggingface.co/papers/2212.04089" rel="nofollow">forgetting-via-negation principle</a>—so that task adapters become more isolated and focused on task-relevant signals. Concretely, GenKnowSub estimates a low-dimensional “general” subspace from a set of general (non task-specific) LoRA adapters and removes this component from each task adapter’s LoRA update prior to Arrow’s token-wise routing. This typically improves compositionality and reduces interference when combining many task adapters.',Ss,Za,ar="In PEFT, enable GenKnowSub by setting <code>use_gks=True</code> in ArrowConfig, and providing <code>general_adapter_paths</code> in <code>create_arrow_model</code>:",Ps,Ua,Ds,Ba,lr="To encode general knowledge, GenKnowSub subtracts the average of the provided general adapters from each task-specific adapter once, before routing begins. Furthermore, the ability to add or remove adapters after calling <code>create_arrow_model</code> (as described in the Arrow section) is still supported in this case.",Ks,g,$a,nr="<strong>Things to keep in mind when using Arrow + GenKnowSub:</strong>",no,y,Wa,sr="<p>All LoRA adapters (task-specific and general) must share the same <code>rank</code> and <code>target_modules</code>.</p>",so,La,or="<p>Any inconsistency in these settings will raise an error in <code>create_arrow_model</code>.</p>",oo,Ga,ir="<p>Having different scaling factors (<code>lora_alpha</code>) across task adapters is supported — Arrow handles them automatically.</p>",io,Aa,rr="<p>Merging the <code>&quot;arrow_router&quot;</code> is not supported, due to its dynamic routing behavior.</p>",ro,Va,pr="<p>In create_arrow_model, task adapters are loaded as <code>task_i</code> and general adapters as <code>gks_j</code> (where <code>i</code> and <code>j</code> are indices). The function ensures consistency of <code>target_modules</code>, <code>rank</code>, and whether adapters are applied to <code>Linear</code> or <code>Linear4bit</code> layers. It then adds the <code>&quot;arrow_router&quot;</code> module and activates it. Any customization of this process requires overriding <code>create_arrow_model</code>.</p>",po,Ia,Xa,dr="This implementation is compatible with 4-bit quantization (via bitsandbytes):",mo,Ca,Os,Ra,eo,Fa,to;return U=new M({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),C=new M({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),W=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),G=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),A=new M({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),x=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),Y=new u({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLik=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...)',wrap:!1}}),Q=new M({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),q=new u({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),S=new M({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),K=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),ee=new M({props:{title:"EVA",local:"eva",headingTag:"h3"}}),le=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),oe=new u({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),re=new u({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),de=new M({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),me=new M({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),fe=new M({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),Me=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),ge=new M({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),je=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),_e=new M({props:{title:"Activated LoRA (aLoRA)",local:"activated-lora-alora",headingTag:"h3"}}),Ze=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhhbG9yYV9pbnZvY2F0aW9uX3Rva2VucyUzRGFsb3JhX2ludm9jYXRpb25fdG9rZW5zJTJDJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(alora_invocation_tokens=alora_invocation_tokens, task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, ...)`,wrap:!1}}),Be=new u({props:{code:"aW52b2NhdGlvbl9zdHJpbmclMjAlM0QlMjAlMjJwbGFjZWhvbGRlciUyMiUwQWFsb3JhX2ludm9jYXRpb25fdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShpbnZvY2F0aW9uX3N0cmluZyUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS4=",highlighted:`<span class="hljs-attr">invocation_string</span> = <span class="hljs-string">&quot;placeholder&quot;</span>
<span class="hljs-attr">alora_invocation_tokens</span> = tokenizer.encode(invocation_string, add_special_tokens=<span class="hljs-literal">False</span>).`,wrap:!1}}),$e=new M({props:{title:"Choice of invocation sequence and SFT design",local:"choice-of-invocation-sequence-and-sft-design",headingTag:"h4"}}),Ve=new u({props:{code:"YWxvcmFfaW52b2NhdGlvbl90b2tlbnMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKGludm9jYXRpb25fc3RyaW5nJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLg==",highlighted:'<span class="hljs-attr">alora_invocation_tokens</span> = tokenizer.encode(invocation_string, add_special_tokens=<span class="hljs-literal">False</span>).',wrap:!1}}),Ye=new M({props:{title:"Using (and reusing) cache for generation",local:"using-and-reusing-cache-for-generation",headingTag:"h4"}}),qe=new u({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> transformers import DynamicCache
<span class="hljs-built_in">..</span>.
cache = DynamicCache()
inputs_base = tokenizer(prompt_base, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment"># Generate from base model and save cache</span>
with model_alora.disable_adapter(): 
    output = model_alora.generate(inputs_base[<span class="hljs-string">&quot;input_ids&quot;</span>].<span class="hljs-keyword">to</span>(device),<span class="hljs-attribute">attention_mask</span>=inputs_base[<span class="hljs-string">&quot;attention_mask&quot;</span>].<span class="hljs-keyword">to</span>(device),past_key_values = cache,<span class="hljs-attribute">return_dict_in_generate</span>=<span class="hljs-literal">True</span>)
output_text_base = tokenizer.decode(output.sequences[0])
cache = output.past_key_values

<span class="hljs-comment"># Generate with aLoRA adapter from cache</span>
prompt_alora = output_text + INVOCATION_STRING
inputs_alora = tokenizer(prompt_alora, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
output = model_alora.generate(**inputs_alora, <span class="hljs-attribute">past_key_values</span>=cache)
output_text_alora = tokenizer.decode(output[0])

<span class="hljs-comment"># <span class="hljs-doctag">Note:</span> cache is now tainted with adapter values and cannot be used in base model from here on!</span>`,wrap:!1}}),Se=new u({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> transformers import DynamicCache
import copy
<span class="hljs-built_in">..</span>.
cache = DynamicCache()
inputs_shared = tokenizer(prompt_shared, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Prefill from base model and save cache</span>
with model_alora.disable_adapter():
    with torch.no_grad():
        model_alora(**inputs_shared, <span class="hljs-attribute">past_key_values</span>=cache)
cache_copy = copy.deepcopy(cache)

<span class="hljs-comment"># Generate from aLoRA using prefilled cache</span>
prompt_alora = prompt_shared + INVOCATION_STRING
inputs_alora = tokenizer(prompt_alora, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
output = model_alora.generate(**inputs_alora, <span class="hljs-attribute">past_key_values</span>=cache)
output_text_alora = tokenizer.decode(output[0])

<span class="hljs-comment"># Generate from base model using saved cache not tainted by aLoRA KV values</span>
prompt_base = prompt_shared
inputs_base = tokenizer(prompt_base, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
with model_alora.disable_adapter(): 
    output = model_alora.generate(**inputs_base, <span class="hljs-attribute">past_key_values</span>=cache_copy)
output_text_base = tokenizer.decode(output[0])`,wrap:!1}}),Pe=new M({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),Ke=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),et=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),at=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),st=new M({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),it=new M({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),pt=new u({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),dt=new M({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),ct=new u({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),ut=new M({props:{title:"Fine grained control over ranks and alpha (scaling)",local:"fine-grained-control-over-ranks-and-alpha-scaling",headingTag:"h3"}}),yt=new u({props:{code:"cHJpbnQobW9kZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
Outer(
  (foo): Linear(...)
  (module): Middle(
    (foo): Linear(...)
    (foobar): Linear(...)
    (module): Inner(
      (foo): Linear(...)
      (barfoo): Linear(...)
    )
  )
)`,wrap:!1}}),gt=new M({props:{title:"Targeting nn.Parameter directly",local:"targeting-nnparameter-directly",headingTag:"h3"}}),jt=new M({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),vt=new M({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),Zt=new M({props:{title:"LoRA-FA Optimizer",local:"lora-fa-optimizer",headingTag:"h3"}}),Bt=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwcGVmdC5vcHRpbWl6ZXJzJTIwaW1wb3J0JTIwY3JlYXRlX2xvcmFmYV9vcHRpbWl6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVHJhaW5lciUyQyUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4pJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwY29uZmlnKSUwQSUwQW9wdGltaXplciUyMCUzRCUyMGNyZWF0ZV9sb3JhZmFfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0Q3ZS01JTJDJTBBKSUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRDEwMDAlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_lorafa_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, get_cosine_schedule_with_warmup

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)

config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_lorafa_optimizer(
    model=model,
    r=<span class="hljs-number">128</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lr=<span class="hljs-number">7e-5</span>,
)

scheduler = get_cosine_schedule_with_warmup(
    optimizer,
    num_warmup_steps=<span class="hljs-number">100</span>,
    num_training_steps=<span class="hljs-number">1000</span>,
)

trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),It=new M({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),Rt=new u({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),$t=new M({props:{title:"Efficiently train tokens alongside LoRA",local:"efficiently-train-tokens-alongside-lora",headingTag:"h2"}}),Lt=new u({props:{code:"JTIzJTIwZm9yJTIwbGF5ZXIlMjAnZW1iZWRfdG9rZW5zJyUwQWNvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlNUJpZHhfMSUyQyUyMGlkeF8yJTJDJTIwLi4uJTVEJTJDJTIwLi4uKSUwQSUwQSUyMyUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYl90b2tlbnMnJTNBJTIwJTVCaWR4XzElMkMlMjBpZHhfMiUyQyUyMC4uLiU1RCU3RCUyQyUyMC4uLik=",highlighted:`<span class="hljs-comment"># for layer &#x27;embed_tokens&#x27;</span>
config = LoraConfig(trainable_token_indices=[idx_1, idx_2, ...], ...)

<span class="hljs-comment"># specific embedding layer</span>
config = LoraConfig(trainable_token_indices={<span class="hljs-string">&#x27;emb_tokens&#x27;</span>: [idx_1, idx_2, ...]}, ...)`,wrap:!1}}),At=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQSUyMyUyMHdlJTIwZGVmaW5lJTIwb3VyJTIwbmV3JTIwdG9rZW5zJTIwYW5kJTIwYWRkJTIwdGhlbSUyMHRvJTIwdGhlJTIwdG9rZW5pemVyJTIwYXMlMjBzcGVjaWFsJTIwdG9rZW5zJTBBc3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUInJTNDJTdDc3RhcnRfdGhpbmslN0MlM0UnJTJDJTIwJyUzQyU3Q3N0b3BfdGhpbmslN0MlM0UnJTVEJTBBdG9rZW5pemVyLmFkZF9zcGVjaWFsX3Rva2VucyglN0InYWRkaXRpb25hbF9zcGVjaWFsX3Rva2VucyclM0ElMjBzcGVjaWFsX3Rva2VucyU3RCklMEElMEElMjMlMjBtYWtlJTIwcm9vbSUyMGZvciUyMG5ldyUyMHRva2VucyUyMGluJTIwdGhlJTIwZW1iZWRkaW5nJTIwbWF0cml4JTIwaWYlMjBpdCUyMGlzbid0JTIwYmlnJTIwZW5vdWdoJTIwYWxyZWFkeSUwQWJhc2VfbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobWF4KGxlbih0b2tlbml6ZXIpJTJDJTIwYmFzZV9tb2RlbC5tb2RlbC5lbWJlZF90b2tlbnMubnVtX2VtYmVkZGluZ3MpKSUwQSUwQSUyMyUyMHR5cGljYWwlMjBMb1JBJTIwY29uZmlnJTIwd2l0aCUyMCU2MHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTYwJTIwdGFyZ2V0aW5nJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMjAlNjBlbWJlZF90b2tlbnMlNjAlMEElMjMlMjBhbmQlMjBzcGVjaWZpY2FsbHklMjBvdXIlMjBuZXclMjB0b2tlbnMlMjB3ZSUyMGp1c3QlMjBhZGRlZCUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCdhbGwtbGluZWFyJyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYmVkX3Rva2VucyclM0ElMjB0b2tlbml6ZXIuY29udmVydF90b2tlbnNfdG9faWRzKHNwZWNpYWxfdG9rZW5zKSU3RCUyQyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoYmFzZV9tb2RlbCUyQyUyMGxvcmFfY29uZmlnKSUwQSUwQSUyMyUyMHByb2NlZWQlMjB0byUyMHRyYWluJTIwdGhlJTIwbW9kZWwlMjBsaWtlJTIwbm9ybWFsJTBBJTVCLi4uJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

<span class="hljs-comment"># we define our new tokens and add them to the tokenizer as special tokens</span>
special_tokens = [<span class="hljs-string">&#x27;&lt;|start_think|&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;|stop_think|&gt;&#x27;</span>]
tokenizer.add_special_tokens({<span class="hljs-string">&#x27;additional_special_tokens&#x27;</span>: special_tokens})

<span class="hljs-comment"># make room for new tokens in the embedding matrix if it isn&#x27;t big enough already</span>
base_model.resize_token_embeddings(<span class="hljs-built_in">max</span>(<span class="hljs-built_in">len</span>(tokenizer), base_model.model.embed_tokens.num_embeddings))

<span class="hljs-comment"># typical LoRA config with \`trainable_token_indices\` targeting embedding layer \`embed_tokens\`</span>
<span class="hljs-comment"># and specifically our new tokens we just added</span>
lora_config = LoraConfig(
    target_modules=<span class="hljs-string">&#x27;all-linear&#x27;</span>,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(special_tokens)},
)
peft_model = get_peft_model(base_model, lora_config)

<span class="hljs-comment"># proceed to train the model like normal</span>
[...]`,wrap:!1}}),xt=new M({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Qt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),zt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),St=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Dt=new u({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Ot=new u({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),ta=new u({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),aa=new M({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),na=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),oa=new u({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ia=new M({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),da=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),ca=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),ua=new M({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),ya=new M({props:{title:"Composing and Reusing LoRA Adapters",local:"composing-and-reusing-lora-adapters",headingTag:"h2"}}),ba=new M({props:{title:"Arrow",local:"arrow",headingTag:"h3"}}),Ja=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> create_arrow_model, ArrowConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Loading the model</span>
base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-comment"># Creating the Arrow config</span>
arrow_config = ArrowConfig(
    top_k=<span class="hljs-number">3</span>,
    router_temperature=<span class="hljs-number">1.0</span>,
    rng_seed=<span class="hljs-number">42</span>,
)

<span class="hljs-comment"># The LoRA adapters below were trained on a clustered FLAN dataset.</span>
<span class="hljs-comment"># Task clustering was performed using the Model-Based Clustering (MBC) method,</span>
<span class="hljs-comment"># as described in the Arrow paper.</span>
<span class="hljs-comment"># While one could train a separate LoRA for each task and let Arrow route tokens among them,</span>
<span class="hljs-comment"># training LoRAs on clusters of tasks instead provides an indirect optimization for</span>
<span class="hljs-comment"># transfer across the multi-task dataset.</span>
task_specific_adapter_paths = [
        <span class="hljs-string">f&quot;TahaBa/phi3-mini-clustered-flan/ts_expert_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)
    ]

<span class="hljs-comment"># Creating the Arrow model</span>
model = create_arrow_model(
        base_model=base_model,
        task_specific_adapter_paths=task_specific_adapter_paths,
        arrow_config=arrow_config,
    )

<span class="hljs-comment"># Now the forward path could be called on this model, like a normal PeftModel.</span>`,wrap:!1}}),_a=new u({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEElMjMlMjBBZGRpbmclMjBhJTIwbmV3JTIwYWRhcHRlciUyMGFuZCUyMGFjdGl2YXRpbmclMjBpdCUwQW1vZGVsLmFkZF9hZGFwdGVyKGFkYXB0ZXJfbmFtZSUzRCduZXdfYWRhcHRlcicpJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJ25ld19hZGFwdGVyJyklMEElMEElMjMlMjBOb3clMjB0aGUlMjBtb2RlbCUyMGNvdWxkJTIwYmUlMjB0cmFpbmVkJTIwYWxvbmclMjB0aGUlMjAlNjBuZXdfYWRhcHRlciU2MC4lMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRFNGVENvbmZpZyguLi4pJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyME9uY2UlMjB0aGUlMjB0cmFpbmluZyUyMGlzJTIwZG9uZSUyQyUyMHlvdSUyMGNhbiUyMGFjdGl2YXRlJTIwJTYwYXJyb3dfcm91dGVyJTYwJTIwYW5kJTIwdXNlJTIwaXQlMjBpbiUyMGluZmVyZW5jZSUwQW1vZGVsLnNldF9hZGFwdGVyKCdhcnJvd19yb3V0ZXInKSUyMCUyMCUyMCUyMCUyMyUyME1vZGVsJTIwaXMlMjByZWFkeSUyMHRvJTIwYmUlMjB1c2VkJTIwYXQlMjBpbmZlcmVuY2UlMjB0aW1lJTIwbm93",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-comment"># Adding a new adapter and activating it</span>
model.add_adapter(adapter_name=<span class="hljs-string">&#x27;new_adapter&#x27;</span>)
model.set_adapter(<span class="hljs-string">&#x27;new_adapter&#x27;</span>)

<span class="hljs-comment"># Now the model could be trained along the \`new_adapter\`.</span>
trainer = SFTTrainer(
        model=model,
        args=SFTConfig(...),
        ...
    )

<span class="hljs-comment"># Once the training is done, you can activate \`arrow_router\` and use it in inference</span>
model.set_adapter(<span class="hljs-string">&#x27;arrow_router&#x27;</span>)    <span class="hljs-comment"># Model is ready to be used at inference time now</span>`,wrap:!1}}),va=new M({props:{title:"GenKnowSub",local:"genknowsub",headingTag:"h3"}}),Ua=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> create_arrow_model, ArrowConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Loading the model</span>
base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-comment"># Creating the Arrow config</span>
arrow_config = ArrowConfig(
    top_k=<span class="hljs-number">3</span>,
    router_temperature=<span class="hljs-number">1.0</span>,
    use_gks=<span class="hljs-literal">True</span>,
    rng_seed=<span class="hljs-number">42</span>,
)

<span class="hljs-comment"># Path to task-specific, trained on flan clustered dataset (as we explained before.)</span>
task_specific_adapter_paths = [
        <span class="hljs-string">f&quot;TahaBa/phi3-mini-clustered-flan/ts_expert_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)
    ]
<span class="hljs-comment"># These general adapters are trained on English, German, and French Wikipedia dataset,</span>
<span class="hljs-comment"># with causal language modelling objective, each pair like: (507 token tsentence, 5 token completion), and the loss computed on the completion</span>
general_adapter_paths = [
        <span class="hljs-string">&quot;TahaBa/phi3-mini-general-adapters/cluster0_batch16_prop1.0_langen/checkpoint-17&quot;</span>,
        <span class="hljs-string">&quot;TahaBa/phi3-mini-general-adapters/cluster0_batch16_prop1.0_langfr/checkpoint-35&quot;</span>,
        <span class="hljs-string">&quot;TahaBa/phi3-mini-general-adapters/cluster0_batch16_prop1.0_langger/checkpoint-17&quot;</span>
    ]

<span class="hljs-comment"># Creating the Arrow model</span>
model = create_arrow_model(
        base_model=base_model,
        task_specific_adapter_paths=task_specific_adapter_paths,
        general_adapter_paths=general_adapter_paths,
        arrow_config=arrow_config,
    )

<span class="hljs-comment"># Now the forward path could be called on this model, like a normal PeftModel.</span>`,wrap:!1}}),Ca=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBRdWFudGlzYXRpb24lMjBjb25maWclMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyMExvYWRpbmclMjB0aGUlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWljcm9zb2Z0JTJGUGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnJTJDJTBBKSUwQSUwQSUyMyUyME5vdyUyMGNhbGwlMjBjcmVhdGVfYXJyb3dfbW9kZWwoKSUyMGFzJTIwd2UlMjBleHBsYWluZWQlMjBiZWZvcmUu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Quantisation config</span>
bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
        bnb_4bit_compute_dtype=torch.bfloat16,
        bnb_4bit_use_double_quant=<span class="hljs-literal">False</span>,
    )

<span class="hljs-comment"># Loading the model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=bnb_config,
)

<span class="hljs-comment"># Now call create_arrow_model() as we explained before.</span>`,wrap:!1}}),Ra=new wr({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){T=o("meta"),Ha=n(),xa=o("p"),Qa=n(),p(U.$$.fragment),Ea=n(),B=o("p"),B.innerHTML=ho,za=n(),I=o("p"),I.textContent=fo,qa=n(),p(C.$$.fragment),Na=n(),R=o("p"),R.innerHTML=uo,Sa=n(),$=o("p"),$.innerHTML=Mo,Pa=n(),p(W.$$.fragment),Da=n(),L=o("p"),L.innerHTML=wo,Ka=n(),p(G.$$.fragment),Oa=n(),p(A.$$.fragment),el=n(),V=o("p"),V.innerHTML=yo,tl=n(),X=o("p"),X.textContent=bo,al=n(),p(x.$$.fragment),ll=n(),F=o("p"),F.textContent=To,nl=n(),p(Y.$$.fragment),sl=n(),H=o("p"),H.innerHTML=go,ol=n(),p(Q.$$.fragment),il=n(),E=o("p"),E.innerHTML=Jo,rl=n(),z=o("p"),z.textContent=jo,pl=n(),p(q.$$.fragment),dl=n(),N=o("p"),N.innerHTML=_o,ml=n(),p(S.$$.fragment),cl=n(),P=o("p"),P.innerHTML=vo,hl=n(),D=o("p"),D.textContent=ko,fl=n(),p(K.$$.fragment),ul=n(),O=o("p"),O.innerHTML=Zo,Ml=n(),p(ee.$$.fragment),wl=n(),te=o("p"),te.innerHTML=Uo,yl=n(),ae=o("p"),ae.innerHTML=Bo,bl=n(),p(le.$$.fragment),Tl=n(),ne=o("p"),ne.innerHTML=Io,gl=n(),se=o("p"),se.innerHTML=Co,Jl=n(),p(oe.$$.fragment),jl=n(),ie=o("p"),ie.innerHTML=Ro,_l=n(),p(re.$$.fragment),vl=n(),pe=o("p"),pe.innerHTML=$o,kl=n(),J=o("blockquote"),J.innerHTML=Wo,Zl=n(),p(de.$$.fragment),Ul=n(),p(me.$$.fragment),Bl=n(),ce=o("p"),ce.innerHTML=Lo,Il=n(),he=o("p"),he.innerHTML=Go,Cl=n(),p(fe.$$.fragment),Rl=n(),ue=o("p"),ue.innerHTML=Ao,$l=n(),p(Me.$$.fragment),Wl=n(),we=o("p"),we.innerHTML=Vo,Ll=n(),ye=o("p"),ye.innerHTML=Xo,Gl=n(),be=o("p"),be.innerHTML=xo,Al=n(),Te=o("ul"),Te.innerHTML=Fo,Vl=n(),j=o("blockquote"),j.innerHTML=Yo,Xl=n(),p(ge.$$.fragment),xl=n(),Je=o("p"),Je.innerHTML=Ho,Fl=n(),p(je.$$.fragment),Yl=n(),p(_e.$$.fragment),Hl=n(),ve=o("p"),ve.innerHTML=Qo,Ql=n(),ke=o("p"),ke.innerHTML=Eo,El=n(),p(Ze.$$.fragment),zl=n(),Ue=o("p"),Ue.innerHTML=zo,ql=n(),p(Be.$$.fragment),Nl=n(),Ie=o("p"),Ie.innerHTML=qo,Sl=n(),Ce=o("p"),Ce.innerHTML=No,Pl=n(),Re=o("ul"),Re.innerHTML=So,Dl=n(),p($e.$$.fragment),Kl=n(),We=o("p"),We.innerHTML=Po,Ol=n(),Le=o("p"),Le.textContent=Do,en=n(),Ge=o("ul"),Ge.innerHTML=Ko,tn=n(),Ae=o("p"),Ae.innerHTML=Oo,an=n(),p(Ve.$$.fragment),ln=n(),Xe=o("p"),Xe.innerHTML=ei,nn=n(),xe=o("p"),xe.innerHTML=ti,sn=n(),Fe=o("p"),Fe.textContent=ai,on=n(),p(Ye.$$.fragment),rn=n(),He=o("p"),He.innerHTML=li,pn=n(),Qe=o("ol"),Qe.innerHTML=ni,dn=n(),Ee=o("p"),Ee.innerHTML=si,mn=n(),ze=o("p"),ze.innerHTML=oi,cn=n(),p(qe.$$.fragment),hn=n(),Ne=o("p"),Ne.innerHTML=ii,fn=n(),p(Se.$$.fragment),un=n(),p(Pe.$$.fragment),Mn=n(),De=o("p"),De.innerHTML=ri,wn=n(),p(Ke.$$.fragment),yn=n(),Oe=o("p"),Oe.innerHTML=pi,bn=n(),p(et.$$.fragment),Tn=n(),tt=o("p"),tt.innerHTML=di,gn=n(),p(at.$$.fragment),Jn=n(),lt=o("p"),lt.innerHTML=mi,jn=n(),nt=o("table"),nt.innerHTML=ci,_n=n(),p(st.$$.fragment),vn=n(),ot=o("ul"),ot.innerHTML=hi,kn=n(),p(it.$$.fragment),Zn=n(),rt=o("p"),rt.innerHTML=fi,Un=n(),p(pt.$$.fragment),Bn=n(),p(dt.$$.fragment),In=n(),mt=o("p"),mt.innerHTML=ui,Cn=n(),p(ct.$$.fragment),Rn=n(),ht=o("p"),ht.innerHTML=Mi,$n=n(),ft=o("p"),ft.innerHTML=wi,Wn=n(),p(ut.$$.fragment),Ln=n(),Mt=o("p"),Mt.innerHTML=yi,Gn=n(),wt=o("p"),wt.textContent=bi,An=n(),p(yt.$$.fragment),Vn=n(),bt=o("ul"),bt.innerHTML=Ti,Xn=n(),Tt=o("p"),Tt.innerHTML=gi,xn=n(),p(gt.$$.fragment),Fn=n(),_=o("blockquote"),_.innerHTML=Ji,Yn=n(),Jt=o("p"),Jt.innerHTML=ji,Hn=n(),p(jt.$$.fragment),Qn=n(),_t=o("ul"),_t.innerHTML=_i,En=n(),p(vt.$$.fragment),zn=n(),kt=o("p"),kt.textContent=vi,qn=n(),p(Zt.$$.fragment),Nn=n(),Ut=o("p"),Ut.innerHTML=ki,Sn=n(),p(Bt.$$.fragment),Pn=n(),p(It.$$.fragment),Dn=n(),Ct=o("p"),Ct.innerHTML=Zi,Kn=n(),p(Rt.$$.fragment),On=n(),p($t.$$.fragment),es=n(),Wt=o("p"),Wt.innerHTML=Ui,ts=n(),p(Lt.$$.fragment),as=n(),Gt=o("p"),Gt.textContent=Bi,ls=n(),p(At.$$.fragment),ns=n(),Vt=o("p"),Vt.innerHTML=Ii,ss=n(),Xt=o("p"),Xt.innerHTML=Ci,os=n(),p(xt.$$.fragment),is=n(),Ft=o("p"),Ft.innerHTML=Ri,rs=n(),Yt=o("p"),Yt.textContent=$i,ps=n(),v=o("div"),v.innerHTML=Wi,ds=n(),Ht=o("p"),Ht.textContent=Li,ms=n(),p(Qt.$$.fragment),cs=n(),Et=o("p"),Et.innerHTML=Gi,hs=n(),p(zt.$$.fragment),fs=n(),qt=o("p"),qt.innerHTML=Ai,us=n(),Nt=o("p"),Nt.textContent=Vi,Ms=n(),p(St.$$.fragment),ws=n(),Pt=o("p"),Pt.textContent=Xi,ys=n(),p(Dt.$$.fragment),bs=n(),Kt=o("p"),Kt.textContent=xi,Ts=n(),p(Ot.$$.fragment),gs=n(),k=o("blockquote"),k.innerHTML=Fi,Js=n(),ea=o("p"),ea.textContent=Yi,js=n(),p(ta.$$.fragment),_s=n(),p(aa.$$.fragment),vs=n(),la=o("p"),la.innerHTML=Hi,ks=n(),p(na.$$.fragment),Zs=n(),sa=o("p"),sa.innerHTML=Qi,Us=n(),p(oa.$$.fragment),Bs=n(),p(ia.$$.fragment),Is=n(),ra=o("p"),ra.textContent=Ei,Cs=n(),pa=o("p"),pa.innerHTML=zi,Rs=n(),p(da.$$.fragment),$s=n(),ma=o("p"),ma.innerHTML=qi,Ws=n(),p(ca.$$.fragment),Ls=n(),ha=o("p"),ha.innerHTML=Ni,Gs=n(),fa=o("p"),fa.innerHTML=Si,As=n(),p(ua.$$.fragment),Vs=n(),Ma=o("p"),Ma.textContent=Pi,Xs=n(),wa=o("ul"),wa.innerHTML=Di,xs=n(),p(ya.$$.fragment),Fs=n(),p(ba.$$.fragment),Ys=n(),Ta=o("p"),Ta.innerHTML=Ki,Hs=n(),ga=o("p"),ga.innerHTML=Oi,Qs=n(),p(Ja.$$.fragment),Es=n(),ja=o("p"),ja.innerHTML=er,zs=n(),p(_a.$$.fragment),qs=n(),p(va.$$.fragment),Ns=n(),ka=o("p"),ka.innerHTML=tr,Ss=n(),Za=o("p"),Za.innerHTML=ar,Ps=n(),p(Ua.$$.fragment),Ds=n(),Ba=o("p"),Ba.innerHTML=lr,Ks=n(),g=o("blockquote"),$a=o("p"),$a.innerHTML=nr,no=n(),y=o("ul"),Wa=o("li"),Wa.innerHTML=sr,so=n(),La=o("li"),La.innerHTML=or,oo=n(),Ga=o("li"),Ga.innerHTML=ir,io=n(),Aa=o("li"),Aa.innerHTML=rr,ro=n(),Va=o("li"),Va.innerHTML=pr,po=n(),Ia=o("li"),Xa=o("p"),Xa.textContent=dr,mo=n(),p(Ca.$$.fragment),Os=n(),p(Ra.$$.fragment),eo=n(),Fa=o("p"),this.h()},l(e){const t=Mr("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(a),Ha=s(e),xa=i(e,"P",{}),Ya(xa).forEach(a),Qa=s(e),d(U.$$.fragment,e),Ea=s(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-38uxl6"&&(B.innerHTML=ho),za=s(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ovsn32"&&(I.textContent=fo),qa=s(e),d(C.$$.fragment,e),Na=s(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-j883mf"&&(R.innerHTML=uo),Sa=s(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1fujb7a"&&($.innerHTML=Mo),Pa=s(e),d(W.$$.fragment,e),Da=s(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-mwvui1"&&(L.innerHTML=wo),Ka=s(e),d(G.$$.fragment,e),Oa=s(e),d(A.$$.fragment,e),el=s(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1dv6v3"&&(V.innerHTML=yo),tl=s(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1hy0lgx"&&(X.textContent=bo),al=s(e),d(x.$$.fragment,e),ll=s(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-auzrbb"&&(F.textContent=To),nl=s(e),d(Y.$$.fragment,e),sl=s(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16k39wq"&&(H.innerHTML=go),ol=s(e),d(Q.$$.fragment,e),il=s(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-53sj5j"&&(E.innerHTML=Jo),rl=s(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1s3c5rd"&&(z.textContent=jo),pl=s(e),d(q.$$.fragment,e),dl=s(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-19qemwc"&&(N.innerHTML=_o),ml=s(e),d(S.$$.fragment,e),cl=s(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1iny7jf"&&(P.innerHTML=vo),hl=s(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1j9g8qn"&&(D.textContent=ko),fl=s(e),d(K.$$.fragment,e),ul=s(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-sulxp4"&&(O.innerHTML=Zo),Ml=s(e),d(ee.$$.fragment,e),wl=s(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-zsbb0y"&&(te.innerHTML=Uo),yl=s(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1gqkzq0"&&(ae.innerHTML=Bo),bl=s(e),d(le.$$.fragment,e),Tl=s(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-168zxvb"&&(ne.innerHTML=Io),gl=s(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-18j5yjn"&&(se.innerHTML=Co),Jl=s(e),d(oe.$$.fragment,e),jl=s(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-8ll8w8"&&(ie.innerHTML=Ro),_l=s(e),d(re.$$.fragment,e),vl=s(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-ryiojp"&&(pe.innerHTML=$o),kl=s(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-2xjfr6"&&(J.innerHTML=Wo),Zl=s(e),d(de.$$.fragment,e),Ul=s(e),d(me.$$.fragment,e),Bl=s(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-icixot"&&(ce.innerHTML=Lo),Il=s(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-7f0aai"&&(he.innerHTML=Go),Cl=s(e),d(fe.$$.fragment,e),Rl=s(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-14vtcq9"&&(ue.innerHTML=Ao),$l=s(e),d(Me.$$.fragment,e),Wl=s(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1nywyxh"&&(we.innerHTML=Vo),Ll=s(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1m1yphh"&&(ye.innerHTML=Xo),Gl=s(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-yl8kok"&&(be.innerHTML=xo),Al=s(e),Te=i(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-12tl4fy"&&(Te.innerHTML=Fo),Vl=s(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-4geq86"&&(j.innerHTML=Yo),Xl=s(e),d(ge.$$.fragment,e),xl=s(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-omuw13"&&(Je.innerHTML=Ho),Fl=s(e),d(je.$$.fragment,e),Yl=s(e),d(_e.$$.fragment,e),Hl=s(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-4un44o"&&(ve.innerHTML=Qo),Ql=s(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-5dffjs"&&(ke.innerHTML=Eo),El=s(e),d(Ze.$$.fragment,e),zl=s(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1a9b12s"&&(Ue.innerHTML=zo),ql=s(e),d(Be.$$.fragment,e),Nl=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-11qncp"&&(Ie.innerHTML=qo),Sl=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1dbt04g"&&(Ce.innerHTML=No),Pl=s(e),Re=i(e,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-8grvus"&&(Re.innerHTML=So),Dl=s(e),d($e.$$.fragment,e),Kl=s(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-6nmqpq"&&(We.innerHTML=Po),Ol=s(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1mvzru2"&&(Le.textContent=Do),en=s(e),Ge=i(e,"UL",{"data-svelte-h":!0}),r(Ge)!=="svelte-1rhx7b3"&&(Ge.innerHTML=Ko),tn=s(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-xa532g"&&(Ae.innerHTML=Oo),an=s(e),d(Ve.$$.fragment,e),ln=s(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-n95elu"&&(Xe.innerHTML=ei),nn=s(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1obb8uu"&&(xe.innerHTML=ti),sn=s(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-qgp1p0"&&(Fe.textContent=ai),on=s(e),d(Ye.$$.fragment,e),rn=s(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1f6e96e"&&(He.innerHTML=li),pn=s(e),Qe=i(e,"OL",{"data-svelte-h":!0}),r(Qe)!=="svelte-4kkan"&&(Qe.innerHTML=ni),dn=s(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-177u8nb"&&(Ee.innerHTML=si),mn=s(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1qt6a9e"&&(ze.innerHTML=oi),cn=s(e),d(qe.$$.fragment,e),hn=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-e9wr3d"&&(Ne.innerHTML=ii),fn=s(e),d(Se.$$.fragment,e),un=s(e),d(Pe.$$.fragment,e),Mn=s(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-x8nt61"&&(De.innerHTML=ri),wn=s(e),d(Ke.$$.fragment,e),yn=s(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-8wzhde"&&(Oe.innerHTML=pi),bn=s(e),d(et.$$.fragment,e),Tn=s(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-16lyt50"&&(tt.innerHTML=di),gn=s(e),d(at.$$.fragment,e),Jn=s(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-a1fvzo"&&(lt.innerHTML=mi),jn=s(e),nt=i(e,"TABLE",{"data-svelte-h":!0}),r(nt)!=="svelte-1iyfgt7"&&(nt.innerHTML=ci),_n=s(e),d(st.$$.fragment,e),vn=s(e),ot=i(e,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-16sw3ja"&&(ot.innerHTML=hi),kn=s(e),d(it.$$.fragment,e),Zn=s(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-15vxux2"&&(rt.innerHTML=fi),Un=s(e),d(pt.$$.fragment,e),Bn=s(e),d(dt.$$.fragment,e),In=s(e),mt=i(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-ku1fuj"&&(mt.innerHTML=ui),Cn=s(e),d(ct.$$.fragment,e),Rn=s(e),ht=i(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1ttqqw0"&&(ht.innerHTML=Mi),$n=s(e),ft=i(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-foj0wd"&&(ft.innerHTML=wi),Wn=s(e),d(ut.$$.fragment,e),Ln=s(e),Mt=i(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-ed0v39"&&(Mt.innerHTML=yi),Gn=s(e),wt=i(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-dtt8e"&&(wt.textContent=bi),An=s(e),d(yt.$$.fragment,e),Vn=s(e),bt=i(e,"UL",{"data-svelte-h":!0}),r(bt)!=="svelte-1qf6hnm"&&(bt.innerHTML=Ti),Xn=s(e),Tt=i(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-qh5siy"&&(Tt.innerHTML=gi),xn=s(e),d(gt.$$.fragment,e),Fn=s(e),_=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-19cd168"&&(_.innerHTML=Ji),Yn=s(e),Jt=i(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-jvkb1r"&&(Jt.innerHTML=ji),Hn=s(e),d(jt.$$.fragment,e),Qn=s(e),_t=i(e,"UL",{"data-svelte-h":!0}),r(_t)!=="svelte-1h2fpez"&&(_t.innerHTML=_i),En=s(e),d(vt.$$.fragment,e),zn=s(e),kt=i(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-ws58tf"&&(kt.textContent=vi),qn=s(e),d(Zt.$$.fragment,e),Nn=s(e),Ut=i(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-18tpzlm"&&(Ut.innerHTML=ki),Sn=s(e),d(Bt.$$.fragment,e),Pn=s(e),d(It.$$.fragment,e),Dn=s(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1i0u5p9"&&(Ct.innerHTML=Zi),Kn=s(e),d(Rt.$$.fragment,e),On=s(e),d($t.$$.fragment,e),es=s(e),Wt=i(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-iri31w"&&(Wt.innerHTML=Ui),ts=s(e),d(Lt.$$.fragment,e),as=s(e),Gt=i(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-66nz7l"&&(Gt.textContent=Bi),ls=s(e),d(At.$$.fragment,e),ns=s(e),Vt=i(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-32mf1g"&&(Vt.innerHTML=Ii),ss=s(e),Xt=i(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-sspyjf"&&(Xt.innerHTML=Ci),os=s(e),d(xt.$$.fragment,e),is=s(e),Ft=i(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-23q4ca"&&(Ft.innerHTML=Ri),rs=s(e),Yt=i(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1wwmf5r"&&(Yt.textContent=$i),ps=s(e),v=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1f6iuw5"&&(v.innerHTML=Wi),ds=s(e),Ht=i(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-hlzwis"&&(Ht.textContent=Li),ms=s(e),d(Qt.$$.fragment,e),cs=s(e),Et=i(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-m3cr6r"&&(Et.innerHTML=Gi),hs=s(e),d(zt.$$.fragment,e),fs=s(e),qt=i(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-kbqhpl"&&(qt.innerHTML=Ai),us=s(e),Nt=i(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1mwdwt1"&&(Nt.textContent=Vi),Ms=s(e),d(St.$$.fragment,e),ws=s(e),Pt=i(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1lnmg1d"&&(Pt.textContent=Xi),ys=s(e),d(Dt.$$.fragment,e),bs=s(e),Kt=i(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1n53hd9"&&(Kt.textContent=xi),Ts=s(e),d(Ot.$$.fragment,e),gs=s(e),k=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-18gsis4"&&(k.innerHTML=Fi),Js=s(e),ea=i(e,"P",{"data-svelte-h":!0}),r(ea)!=="svelte-qwbdkg"&&(ea.textContent=Yi),js=s(e),d(ta.$$.fragment,e),_s=s(e),d(aa.$$.fragment,e),vs=s(e),la=i(e,"P",{"data-svelte-h":!0}),r(la)!=="svelte-xr6qp7"&&(la.innerHTML=Hi),ks=s(e),d(na.$$.fragment,e),Zs=s(e),sa=i(e,"P",{"data-svelte-h":!0}),r(sa)!=="svelte-b1sqs0"&&(sa.innerHTML=Qi),Us=s(e),d(oa.$$.fragment,e),Bs=s(e),d(ia.$$.fragment,e),Is=s(e),ra=i(e,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-1fq5tpu"&&(ra.textContent=Ei),Cs=s(e),pa=i(e,"P",{"data-svelte-h":!0}),r(pa)!=="svelte-lcywla"&&(pa.innerHTML=zi),Rs=s(e),d(da.$$.fragment,e),$s=s(e),ma=i(e,"P",{"data-svelte-h":!0}),r(ma)!=="svelte-6wkyom"&&(ma.innerHTML=qi),Ws=s(e),d(ca.$$.fragment,e),Ls=s(e),ha=i(e,"P",{"data-svelte-h":!0}),r(ha)!=="svelte-1o40ch6"&&(ha.innerHTML=Ni),Gs=s(e),fa=i(e,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-mqf2jo"&&(fa.innerHTML=Si),As=s(e),d(ua.$$.fragment,e),Vs=s(e),Ma=i(e,"P",{"data-svelte-h":!0}),r(Ma)!=="svelte-e0xhf6"&&(Ma.textContent=Pi),Xs=s(e),wa=i(e,"UL",{"data-svelte-h":!0}),r(wa)!=="svelte-brh7gh"&&(wa.innerHTML=Di),xs=s(e),d(ya.$$.fragment,e),Fs=s(e),d(ba.$$.fragment,e),Ys=s(e),Ta=i(e,"P",{"data-svelte-h":!0}),r(Ta)!=="svelte-1qlwkok"&&(Ta.innerHTML=Ki),Hs=s(e),ga=i(e,"P",{"data-svelte-h":!0}),r(ga)!=="svelte-1dov8xe"&&(ga.innerHTML=Oi),Qs=s(e),d(Ja.$$.fragment,e),Es=s(e),ja=i(e,"P",{"data-svelte-h":!0}),r(ja)!=="svelte-13ney51"&&(ja.innerHTML=er),zs=s(e),d(_a.$$.fragment,e),qs=s(e),d(va.$$.fragment,e),Ns=s(e),ka=i(e,"P",{"data-svelte-h":!0}),r(ka)!=="svelte-1damsga"&&(ka.innerHTML=tr),Ss=s(e),Za=i(e,"P",{"data-svelte-h":!0}),r(Za)!=="svelte-bisu0r"&&(Za.innerHTML=ar),Ps=s(e),d(Ua.$$.fragment,e),Ds=s(e),Ba=i(e,"P",{"data-svelte-h":!0}),r(Ba)!=="svelte-19fqfkj"&&(Ba.innerHTML=lr),Ks=s(e),g=i(e,"BLOCKQUOTE",{class:!0});var ao=Ya(g);$a=i(ao,"P",{"data-svelte-h":!0}),r($a)!=="svelte-14xydvq"&&($a.innerHTML=nr),no=s(ao),y=i(ao,"UL",{});var b=Ya(y);Wa=i(b,"LI",{"data-svelte-h":!0}),r(Wa)!=="svelte-1g552yx"&&(Wa.innerHTML=sr),so=s(b),La=i(b,"LI",{"data-svelte-h":!0}),r(La)!=="svelte-1kqmy9e"&&(La.innerHTML=or),oo=s(b),Ga=i(b,"LI",{"data-svelte-h":!0}),r(Ga)!=="svelte-o6l66k"&&(Ga.innerHTML=ir),io=s(b),Aa=i(b,"LI",{"data-svelte-h":!0}),r(Aa)!=="svelte-3a8u10"&&(Aa.innerHTML=rr),ro=s(b),Va=i(b,"LI",{"data-svelte-h":!0}),r(Va)!=="svelte-1f7byj"&&(Va.innerHTML=pr),po=s(b),Ia=i(b,"LI",{});var lo=Ya(Ia);Xa=i(lo,"P",{"data-svelte-h":!0}),r(Xa)!=="svelte-1j9rbu8"&&(Xa.textContent=dr),mo=s(lo),d(Ca.$$.fragment,lo),lo.forEach(a),b.forEach(a),ao.forEach(a),Os=s(e),d(Ra.$$.fragment,e),eo=s(e),Fa=i(e,"P",{}),Ya(Fa).forEach(a),this.h()},h(){Z(T,"name","hf:doc:metadata"),Z(T,"content",br),Z(J,"class","tip"),Z(j,"class","tip"),Z(_,"class","warning"),Z(v,"class","flex justify-center"),Z(k,"class","tip"),Z(g,"class","tip")},m(e,t){w(document.head,T),l(e,Ha,t),l(e,xa,t),l(e,Qa,t),m(U,e,t),l(e,Ea,t),l(e,B,t),l(e,za,t),l(e,I,t),l(e,qa,t),m(C,e,t),l(e,Na,t),l(e,R,t),l(e,Sa,t),l(e,$,t),l(e,Pa,t),m(W,e,t),l(e,Da,t),l(e,L,t),l(e,Ka,t),m(G,e,t),l(e,Oa,t),m(A,e,t),l(e,el,t),l(e,V,t),l(e,tl,t),l(e,X,t),l(e,al,t),m(x,e,t),l(e,ll,t),l(e,F,t),l(e,nl,t),m(Y,e,t),l(e,sl,t),l(e,H,t),l(e,ol,t),m(Q,e,t),l(e,il,t),l(e,E,t),l(e,rl,t),l(e,z,t),l(e,pl,t),m(q,e,t),l(e,dl,t),l(e,N,t),l(e,ml,t),m(S,e,t),l(e,cl,t),l(e,P,t),l(e,hl,t),l(e,D,t),l(e,fl,t),m(K,e,t),l(e,ul,t),l(e,O,t),l(e,Ml,t),m(ee,e,t),l(e,wl,t),l(e,te,t),l(e,yl,t),l(e,ae,t),l(e,bl,t),m(le,e,t),l(e,Tl,t),l(e,ne,t),l(e,gl,t),l(e,se,t),l(e,Jl,t),m(oe,e,t),l(e,jl,t),l(e,ie,t),l(e,_l,t),m(re,e,t),l(e,vl,t),l(e,pe,t),l(e,kl,t),l(e,J,t),l(e,Zl,t),m(de,e,t),l(e,Ul,t),m(me,e,t),l(e,Bl,t),l(e,ce,t),l(e,Il,t),l(e,he,t),l(e,Cl,t),m(fe,e,t),l(e,Rl,t),l(e,ue,t),l(e,$l,t),m(Me,e,t),l(e,Wl,t),l(e,we,t),l(e,Ll,t),l(e,ye,t),l(e,Gl,t),l(e,be,t),l(e,Al,t),l(e,Te,t),l(e,Vl,t),l(e,j,t),l(e,Xl,t),m(ge,e,t),l(e,xl,t),l(e,Je,t),l(e,Fl,t),m(je,e,t),l(e,Yl,t),m(_e,e,t),l(e,Hl,t),l(e,ve,t),l(e,Ql,t),l(e,ke,t),l(e,El,t),m(Ze,e,t),l(e,zl,t),l(e,Ue,t),l(e,ql,t),m(Be,e,t),l(e,Nl,t),l(e,Ie,t),l(e,Sl,t),l(e,Ce,t),l(e,Pl,t),l(e,Re,t),l(e,Dl,t),m($e,e,t),l(e,Kl,t),l(e,We,t),l(e,Ol,t),l(e,Le,t),l(e,en,t),l(e,Ge,t),l(e,tn,t),l(e,Ae,t),l(e,an,t),m(Ve,e,t),l(e,ln,t),l(e,Xe,t),l(e,nn,t),l(e,xe,t),l(e,sn,t),l(e,Fe,t),l(e,on,t),m(Ye,e,t),l(e,rn,t),l(e,He,t),l(e,pn,t),l(e,Qe,t),l(e,dn,t),l(e,Ee,t),l(e,mn,t),l(e,ze,t),l(e,cn,t),m(qe,e,t),l(e,hn,t),l(e,Ne,t),l(e,fn,t),m(Se,e,t),l(e,un,t),m(Pe,e,t),l(e,Mn,t),l(e,De,t),l(e,wn,t),m(Ke,e,t),l(e,yn,t),l(e,Oe,t),l(e,bn,t),m(et,e,t),l(e,Tn,t),l(e,tt,t),l(e,gn,t),m(at,e,t),l(e,Jn,t),l(e,lt,t),l(e,jn,t),l(e,nt,t),l(e,_n,t),m(st,e,t),l(e,vn,t),l(e,ot,t),l(e,kn,t),m(it,e,t),l(e,Zn,t),l(e,rt,t),l(e,Un,t),m(pt,e,t),l(e,Bn,t),m(dt,e,t),l(e,In,t),l(e,mt,t),l(e,Cn,t),m(ct,e,t),l(e,Rn,t),l(e,ht,t),l(e,$n,t),l(e,ft,t),l(e,Wn,t),m(ut,e,t),l(e,Ln,t),l(e,Mt,t),l(e,Gn,t),l(e,wt,t),l(e,An,t),m(yt,e,t),l(e,Vn,t),l(e,bt,t),l(e,Xn,t),l(e,Tt,t),l(e,xn,t),m(gt,e,t),l(e,Fn,t),l(e,_,t),l(e,Yn,t),l(e,Jt,t),l(e,Hn,t),m(jt,e,t),l(e,Qn,t),l(e,_t,t),l(e,En,t),m(vt,e,t),l(e,zn,t),l(e,kt,t),l(e,qn,t),m(Zt,e,t),l(e,Nn,t),l(e,Ut,t),l(e,Sn,t),m(Bt,e,t),l(e,Pn,t),m(It,e,t),l(e,Dn,t),l(e,Ct,t),l(e,Kn,t),m(Rt,e,t),l(e,On,t),m($t,e,t),l(e,es,t),l(e,Wt,t),l(e,ts,t),m(Lt,e,t),l(e,as,t),l(e,Gt,t),l(e,ls,t),m(At,e,t),l(e,ns,t),l(e,Vt,t),l(e,ss,t),l(e,Xt,t),l(e,os,t),m(xt,e,t),l(e,is,t),l(e,Ft,t),l(e,rs,t),l(e,Yt,t),l(e,ps,t),l(e,v,t),l(e,ds,t),l(e,Ht,t),l(e,ms,t),m(Qt,e,t),l(e,cs,t),l(e,Et,t),l(e,hs,t),m(zt,e,t),l(e,fs,t),l(e,qt,t),l(e,us,t),l(e,Nt,t),l(e,Ms,t),m(St,e,t),l(e,ws,t),l(e,Pt,t),l(e,ys,t),m(Dt,e,t),l(e,bs,t),l(e,Kt,t),l(e,Ts,t),m(Ot,e,t),l(e,gs,t),l(e,k,t),l(e,Js,t),l(e,ea,t),l(e,js,t),m(ta,e,t),l(e,_s,t),m(aa,e,t),l(e,vs,t),l(e,la,t),l(e,ks,t),m(na,e,t),l(e,Zs,t),l(e,sa,t),l(e,Us,t),m(oa,e,t),l(e,Bs,t),m(ia,e,t),l(e,Is,t),l(e,ra,t),l(e,Cs,t),l(e,pa,t),l(e,Rs,t),m(da,e,t),l(e,$s,t),l(e,ma,t),l(e,Ws,t),m(ca,e,t),l(e,Ls,t),l(e,ha,t),l(e,Gs,t),l(e,fa,t),l(e,As,t),m(ua,e,t),l(e,Vs,t),l(e,Ma,t),l(e,Xs,t),l(e,wa,t),l(e,xs,t),m(ya,e,t),l(e,Fs,t),m(ba,e,t),l(e,Ys,t),l(e,Ta,t),l(e,Hs,t),l(e,ga,t),l(e,Qs,t),m(Ja,e,t),l(e,Es,t),l(e,ja,t),l(e,zs,t),m(_a,e,t),l(e,qs,t),m(va,e,t),l(e,Ns,t),l(e,ka,t),l(e,Ss,t),l(e,Za,t),l(e,Ps,t),m(Ua,e,t),l(e,Ds,t),l(e,Ba,t),l(e,Ks,t),l(e,g,t),w(g,$a),w(g,no),w(g,y),w(y,Wa),w(y,so),w(y,La),w(y,oo),w(y,Ga),w(y,io),w(y,Aa),w(y,ro),w(y,Va),w(y,po),w(y,Ia),w(Ia,Xa),w(Ia,mo),m(Ca,Ia,null),l(e,Os,t),m(Ra,e,t),l(e,eo,t),l(e,Fa,t),to=!0},p:cr,i(e){to||(c(U.$$.fragment,e),c(C.$$.fragment,e),c(W.$$.fragment,e),c(G.$$.fragment,e),c(A.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(S.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(fe.$$.fragment,e),c(Me.$$.fragment,e),c(ge.$$.fragment,e),c(je.$$.fragment,e),c(_e.$$.fragment,e),c(Ze.$$.fragment,e),c(Be.$$.fragment,e),c($e.$$.fragment,e),c(Ve.$$.fragment,e),c(Ye.$$.fragment,e),c(qe.$$.fragment,e),c(Se.$$.fragment,e),c(Pe.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(at.$$.fragment,e),c(st.$$.fragment,e),c(it.$$.fragment,e),c(pt.$$.fragment,e),c(dt.$$.fragment,e),c(ct.$$.fragment,e),c(ut.$$.fragment,e),c(yt.$$.fragment,e),c(gt.$$.fragment,e),c(jt.$$.fragment,e),c(vt.$$.fragment,e),c(Zt.$$.fragment,e),c(Bt.$$.fragment,e),c(It.$$.fragment,e),c(Rt.$$.fragment,e),c($t.$$.fragment,e),c(Lt.$$.fragment,e),c(At.$$.fragment,e),c(xt.$$.fragment,e),c(Qt.$$.fragment,e),c(zt.$$.fragment,e),c(St.$$.fragment,e),c(Dt.$$.fragment,e),c(Ot.$$.fragment,e),c(ta.$$.fragment,e),c(aa.$$.fragment,e),c(na.$$.fragment,e),c(oa.$$.fragment,e),c(ia.$$.fragment,e),c(da.$$.fragment,e),c(ca.$$.fragment,e),c(ua.$$.fragment,e),c(ya.$$.fragment,e),c(ba.$$.fragment,e),c(Ja.$$.fragment,e),c(_a.$$.fragment,e),c(va.$$.fragment,e),c(Ua.$$.fragment,e),c(Ca.$$.fragment,e),c(Ra.$$.fragment,e),to=!0)},o(e){h(U.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(G.$$.fragment,e),h(A.$$.fragment,e),h(x.$$.fragment,e),h(Y.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(S.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(fe.$$.fragment,e),h(Me.$$.fragment,e),h(ge.$$.fragment,e),h(je.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(Be.$$.fragment,e),h($e.$$.fragment,e),h(Ve.$$.fragment,e),h(Ye.$$.fragment,e),h(qe.$$.fragment,e),h(Se.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(pt.$$.fragment,e),h(dt.$$.fragment,e),h(ct.$$.fragment,e),h(ut.$$.fragment,e),h(yt.$$.fragment,e),h(gt.$$.fragment,e),h(jt.$$.fragment,e),h(vt.$$.fragment,e),h(Zt.$$.fragment,e),h(Bt.$$.fragment,e),h(It.$$.fragment,e),h(Rt.$$.fragment,e),h($t.$$.fragment,e),h(Lt.$$.fragment,e),h(At.$$.fragment,e),h(xt.$$.fragment,e),h(Qt.$$.fragment,e),h(zt.$$.fragment,e),h(St.$$.fragment,e),h(Dt.$$.fragment,e),h(Ot.$$.fragment,e),h(ta.$$.fragment,e),h(aa.$$.fragment,e),h(na.$$.fragment,e),h(oa.$$.fragment,e),h(ia.$$.fragment,e),h(da.$$.fragment,e),h(ca.$$.fragment,e),h(ua.$$.fragment,e),h(ya.$$.fragment,e),h(ba.$$.fragment,e),h(Ja.$$.fragment,e),h(_a.$$.fragment,e),h(va.$$.fragment,e),h(Ua.$$.fragment,e),h(Ca.$$.fragment,e),h(Ra.$$.fragment,e),to=!1},d(e){e&&(a(Ha),a(xa),a(Qa),a(Ea),a(B),a(za),a(I),a(qa),a(Na),a(R),a(Sa),a($),a(Pa),a(Da),a(L),a(Ka),a(Oa),a(el),a(V),a(tl),a(X),a(al),a(ll),a(F),a(nl),a(sl),a(H),a(ol),a(il),a(E),a(rl),a(z),a(pl),a(dl),a(N),a(ml),a(cl),a(P),a(hl),a(D),a(fl),a(ul),a(O),a(Ml),a(wl),a(te),a(yl),a(ae),a(bl),a(Tl),a(ne),a(gl),a(se),a(Jl),a(jl),a(ie),a(_l),a(vl),a(pe),a(kl),a(J),a(Zl),a(Ul),a(Bl),a(ce),a(Il),a(he),a(Cl),a(Rl),a(ue),a($l),a(Wl),a(we),a(Ll),a(ye),a(Gl),a(be),a(Al),a(Te),a(Vl),a(j),a(Xl),a(xl),a(Je),a(Fl),a(Yl),a(Hl),a(ve),a(Ql),a(ke),a(El),a(zl),a(Ue),a(ql),a(Nl),a(Ie),a(Sl),a(Ce),a(Pl),a(Re),a(Dl),a(Kl),a(We),a(Ol),a(Le),a(en),a(Ge),a(tn),a(Ae),a(an),a(ln),a(Xe),a(nn),a(xe),a(sn),a(Fe),a(on),a(rn),a(He),a(pn),a(Qe),a(dn),a(Ee),a(mn),a(ze),a(cn),a(hn),a(Ne),a(fn),a(un),a(Mn),a(De),a(wn),a(yn),a(Oe),a(bn),a(Tn),a(tt),a(gn),a(Jn),a(lt),a(jn),a(nt),a(_n),a(vn),a(ot),a(kn),a(Zn),a(rt),a(Un),a(Bn),a(In),a(mt),a(Cn),a(Rn),a(ht),a($n),a(ft),a(Wn),a(Ln),a(Mt),a(Gn),a(wt),a(An),a(Vn),a(bt),a(Xn),a(Tt),a(xn),a(Fn),a(_),a(Yn),a(Jt),a(Hn),a(Qn),a(_t),a(En),a(zn),a(kt),a(qn),a(Nn),a(Ut),a(Sn),a(Pn),a(Dn),a(Ct),a(Kn),a(On),a(es),a(Wt),a(ts),a(as),a(Gt),a(ls),a(ns),a(Vt),a(ss),a(Xt),a(os),a(is),a(Ft),a(rs),a(Yt),a(ps),a(v),a(ds),a(Ht),a(ms),a(cs),a(Et),a(hs),a(fs),a(qt),a(us),a(Nt),a(Ms),a(ws),a(Pt),a(ys),a(bs),a(Kt),a(Ts),a(gs),a(k),a(Js),a(ea),a(js),a(_s),a(vs),a(la),a(ks),a(Zs),a(sa),a(Us),a(Bs),a(Is),a(ra),a(Cs),a(pa),a(Rs),a($s),a(ma),a(Ws),a(Ls),a(ha),a(Gs),a(fa),a(As),a(Vs),a(Ma),a(Xs),a(wa),a(xs),a(Fs),a(Ys),a(Ta),a(Hs),a(ga),a(Qs),a(Es),a(ja),a(zs),a(qs),a(Ns),a(ka),a(Ss),a(Za),a(Ps),a(Ds),a(Ba),a(Ks),a(g),a(Os),a(eo),a(Fa)),a(T),f(U,e),f(C,e),f(W,e),f(G,e),f(A,e),f(x,e),f(Y,e),f(Q,e),f(q,e),f(S,e),f(K,e),f(ee,e),f(le,e),f(oe,e),f(re,e),f(de,e),f(me,e),f(fe,e),f(Me,e),f(ge,e),f(je,e),f(_e,e),f(Ze,e),f(Be,e),f($e,e),f(Ve,e),f(Ye,e),f(qe,e),f(Se,e),f(Pe,e),f(Ke,e),f(et,e),f(at,e),f(st,e),f(it,e),f(pt,e),f(dt,e),f(ct,e),f(ut,e),f(yt,e),f(gt,e),f(jt,e),f(vt,e),f(Zt,e),f(Bt,e),f(It,e),f(Rt,e),f($t,e),f(Lt,e),f(At,e),f(xt,e),f(Qt,e),f(zt,e),f(St,e),f(Dt,e),f(Ot,e),f(ta,e),f(aa,e),f(na,e),f(oa,e),f(ia,e),f(da,e),f(ca,e),f(ua,e),f(ya,e),f(ba,e),f(Ja,e),f(_a,e),f(va,e),f(Ua,e),f(Ca),f(Ra,e)}}}const br='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Activated LoRA (aLoRA)","local":"activated-lora-alora","sections":[{"title":"Choice of invocation sequence and SFT design","local":"choice-of-invocation-sequence-and-sft-design","sections":[],"depth":4},{"title":"Using (and reusing) cache for generation","local":"using-and-reusing-cache-for-generation","sections":[],"depth":4}],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3},{"title":"Fine grained control over ranks and alpha (scaling)","local":"fine-grained-control-over-ranks-and-alpha-scaling","sections":[],"depth":3},{"title":"Targeting nn.Parameter directly","local":"targeting-nnparameter-directly","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA-FA Optimizer","local":"lora-fa-optimizer","sections":[],"depth":3},{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Efficiently train tokens alongside LoRA","local":"efficiently-train-tokens-alongside-lora","sections":[],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Composing and Reusing LoRA Adapters","local":"composing-and-reusing-lora-adapters","sections":[{"title":"Arrow","local":"arrow","sections":[],"depth":3},{"title":"GenKnowSub","local":"genknowsub","sections":[],"depth":3}],"depth":2}],"depth":1}';function Tr(co){return hr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vr extends fr{constructor(T){super(),ur(this,T,Tr,yr,mr,{})}}export{vr as component};
