import{s as xe,n as Qe,o as Ne}from"../chunks/scheduler.4cd3e004.js";import{S as He,i as Ye,e as i,s,c as p,h as Le,a as o,d as l,b as n,f as Ae,g as m,j as d,k as je,l as Se,m as a,n as c,t as r,o as M,p as f}from"../chunks/index.b664cb2d.js";import{C as N}from"../chunks/CodeBlock.8601e34e.js";import{H as L,E as ze}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";function Pe(Ue){let h,S,H,z,T,P,w,ge="With PEFT, you can inject trainable adapters into any <code>torch</code> module which allows you to use adapter methods without relying on the modeling classes in PEFT. This works for all adapters except for those based on prompt learning (e.g. prefix tuning or p-tuning).",D,y,Ce="Check the table below to see when you should inject adapters.",K,_,Ze="<thead><tr><th>Pros</th> <th>Cons</th></tr></thead> <tbody><tr><td>the model is modified inplace, keeping all the original attributes and methods</td> <td>manually write the <code>from_pretrained</code> and <code>save_pretrained</code> utility functions from Hugging Face to save and load adapters</td></tr> <tr><td>works for any <code>torch</code> module and modality</td> <td>doesn’t work with any of the utility methods provided by <code>PeftModel</code> such as disabling and merging adapters</td></tr></tbody>",q,J,O,b,ke='To perform the adapter injection, use the <a href="/docs/peft/main/en/package_reference/functional#peft.inject_adapter_in_model">inject_adapter_in_model()</a> method. This method takes 3 arguments, the PEFT config, the model, and an optional adapter name. You can also attach multiple adapters to the model if you call <a href="/docs/peft/main/en/package_reference/functional#peft.inject_adapter_in_model">inject_adapter_in_model()</a> multiple times with different adapter names.',ee,j,Ie="For example, to inject LoRA adapters into the <code>linear</code> submodule of the <code>DummyModel</code> module:",te,U,le,g,We="Print the model to see that the adapters have been correctly injected.",ae,C,se,Z,ne,k,Ee='Sometimes, it is possible that there is a PEFT adapter checkpoint but the corresponding PEFT config is not known for whatever reason. To inject the PEFT layers for this checkpoint, you would usually have to reverse-engineer the corresponding PEFT config, most notably the <code>target_modules</code> argument, based on the <code>state_dict</code> from the checkpoint. This can be cumbersome and error prone. To avoid this, it is also possible to call <a href="/docs/peft/main/en/package_reference/functional#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and pass the loaded <code>state_dict</code> as an argument:',ie,I,oe,W,Be="In this case, PEFT will use the <code>state_dict</code> as reference for which layers to target instead of using the PEFT config. As a user, you don’t have to set the exact <code>target_modules</code> of the PEFT config for this to work. However, you should still pass a PEFT config of the right type, in this example <code>LoraConfig</code>, you can leave the <code>target_modules</code> as <code>None</code>.",de,E,Ge='Be aware that this still only creates the uninitialized PEFT layers, the values from the <code>state_dict</code> are not used to populate the model weights. To populate the weights, proceed with calling <a href="/docs/peft/main/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> as described below.',pe,B,$e="⚠️ Note that if there is a mismatch between what is configured in the PEFT config and what is found in the <code>state_dict</code>, PEFT will warn you about this. You can ignore the warning if you know that the PEFT config is not correctly specified.",me,u,ve="<p>If the original PEFT adapters was using <code>target_parameters</code> instead of <code>target_modules</code>, injecting from a <code>state_dict</code> will not work correctly. In this case, it is mandatory to use the correct PEFT config for injection.</p>",ce,G,re,$,Ve='To only save the adapter, use the <a href="/docs/peft/main/en/package_reference/functional#peft.get_peft_model_state_dict">get_peft_model_state_dict()</a> function:',Me,v,fe,V,Fe="Otherwise, <code>model.state_dict()</code> returns the full state dict of the model.",he,F,ue,R,Re='After loading the saved <code>state_dict</code>, it can be applied using the <a href="/docs/peft/main/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> function:',Te,X,we,A,Xe='If injecting the adapter is slow or you need to load a large number of adapters, you may use an optimization that allows to create an “empty” adapter on meta device and only fills the weights with real weights when the <a href="/docs/peft/main/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a> is called. To do this, pass <code>low_cpu_mem_usage=True</code> to both <a href="/docs/peft/main/en/package_reference/functional#peft.inject_adapter_in_model">inject_adapter_in_model()</a> and <a href="/docs/peft/main/en/package_reference/functional#peft.set_peft_model_state_dict">set_peft_model_state_dict()</a>.',ye,x,_e,Q,Je,Y,be;return T=new L({props:{title:"Adapter injection",local:"adapter-injection",headingTag:"h1"}}),J=new L({props:{title:"Creating a new PEFT model",local:"creating-a-new-peft-model",headingTag:"h2"}}),U=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),C=new N({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),Z=new L({props:{title:"Injection based on a state_dict",local:"injection-based-on-a-statedict",headingTag:"h3"}}),I=new N({props:{code:"ZnJvbSUyMHNhZmV0ZW5zb3JzLnRvcmNoJTIwaW1wb3J0JTIwbG9hZF9maWxlJTBBJTBBbW9kZWwlMjAlM0QlMjAuLi4lMEFzdGF0ZV9kaWN0JTIwJTNEJTIwbG9hZF9maWxlKCUzQ3BhdGgtdG8tc2FmZXRlbnNvcnMtZmlsZSUzRSklMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCUyQyUyMHN0YXRlX2RpY3QlM0RzdGF0ZV9kaWN0KQ==",highlighted:`<span class="hljs-keyword">from</span> safetensors.torch <span class="hljs-keyword">import</span> load_file

model = ...
state_dict = load_file(&lt;path-to-safetensors-file&gt;)
lora_config = LoraConfig(...)
model = inject_adapter_in_model(lora_config, model, state_dict=state_dict)`,wrap:!1}}),G=new L({props:{title:"Saving the model",local:"saving-the-model",headingTag:"h2"}}),v=new N({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),F=new L({props:{title:"Loading the model",local:"loading-the-model",headingTag:"h2"}}),X=new N({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBbW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwpJTBBb3V0Y29tZSUyMCUzRCUyMHNldF9wZWZ0X21vZGVsX3N0YXRlX2RpY3QobW9kZWwlMkMlMjBwZWZ0X3N0YXRlX2RpY3QpJTBBJTIzJTIwY2hlY2slMjB0aGF0JTIwdGhlcmUlMjB3ZXJlJTIwbm8lMjB3cm9uZyUyMGtleXMlMEFwcmludChvdXRjb21lLnVuZXhwZWN0ZWRfa2V5cyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> set_peft_model_state_dict

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)
outcome = set_peft_model_state_dict(model, peft_state_dict)
<span class="hljs-comment"># check that there were no wrong keys</span>
<span class="hljs-built_in">print</span>(outcome.unexpected_keys)`,wrap:!1}}),x=new N({props:{code:"bW9kZWwlMjAlM0QlMjBEdW1teU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsKGxvcmFfY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUpJTBBJTBBcHJpbnQobW9kZWwubGluZWFyLmxvcmFfQSU1QiUyMmRlZmF1bHQlMjIlNUQud2VpZ2h0LmRldmljZS50eXBlJTIwJTNEJTNEJTIwJTIybWV0YSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWUlMEFzZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0KG1vZGVsJTJDJTIwcGVmdF9zdGF0ZV9kaWN0JTJDJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlKSUwQXByaW50KG1vZGVsLmxpbmVhci5sb3JhX0ElNUIlMjJkZWZhdWx0JTIyJTVELndlaWdodC5kZXZpY2UudHlwZSUyMCUzRCUzRCUyMCUyMmNwdSUyMiklMjAlMjAlMjMlMjBzaG91bGQlMjBiZSUyMFRydWU=",highlighted:`model = DummyModel()
model = inject_adapter_in_model(lora_config, model, low_cpu_mem_usage=<span class="hljs-literal">True</span>)

<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;meta&quot;</span>)  <span class="hljs-comment"># should be True</span>
set_peft_model_state_dict(model, peft_state_dict, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(model.linear.lora_A[<span class="hljs-string">&quot;default&quot;</span>].weight.device.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;cpu&quot;</span>)  <span class="hljs-comment"># should be True</span>`,wrap:!1}}),Q=new ze({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/low_level_api.md"}}),{c(){h=i("meta"),S=s(),H=i("p"),z=s(),p(T.$$.fragment),P=s(),w=i("p"),w.innerHTML=ge,D=s(),y=i("p"),y.textContent=Ce,K=s(),_=i("table"),_.innerHTML=Ze,q=s(),p(J.$$.fragment),O=s(),b=i("p"),b.innerHTML=ke,ee=s(),j=i("p"),j.innerHTML=Ie,te=s(),p(U.$$.fragment),le=s(),g=i("p"),g.textContent=We,ae=s(),p(C.$$.fragment),se=s(),p(Z.$$.fragment),ne=s(),k=i("p"),k.innerHTML=Ee,ie=s(),p(I.$$.fragment),oe=s(),W=i("p"),W.innerHTML=Be,de=s(),E=i("p"),E.innerHTML=Ge,pe=s(),B=i("p"),B.innerHTML=$e,me=s(),u=i("blockquote"),u.innerHTML=ve,ce=s(),p(G.$$.fragment),re=s(),$=i("p"),$.innerHTML=Ve,Me=s(),p(v.$$.fragment),fe=s(),V=i("p"),V.innerHTML=Fe,he=s(),p(F.$$.fragment),ue=s(),R=i("p"),R.innerHTML=Re,Te=s(),p(X.$$.fragment),we=s(),A=i("p"),A.innerHTML=Xe,ye=s(),p(x.$$.fragment),_e=s(),p(Q.$$.fragment),Je=s(),Y=i("p"),this.h()},l(e){const t=Le("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),S=n(e),H=o(e,"P",{}),Ae(H).forEach(l),z=n(e),m(T.$$.fragment,e),P=n(e),w=o(e,"P",{"data-svelte-h":!0}),d(w)!=="svelte-9e5cx8"&&(w.innerHTML=ge),D=n(e),y=o(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-mj4045"&&(y.textContent=Ce),K=n(e),_=o(e,"TABLE",{"data-svelte-h":!0}),d(_)!=="svelte-j2tc6m"&&(_.innerHTML=Ze),q=n(e),m(J.$$.fragment,e),O=n(e),b=o(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-suwdhc"&&(b.innerHTML=ke),ee=n(e),j=o(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-tifeyo"&&(j.innerHTML=Ie),te=n(e),m(U.$$.fragment,e),le=n(e),g=o(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-3xa704"&&(g.textContent=We),ae=n(e),m(C.$$.fragment,e),se=n(e),m(Z.$$.fragment,e),ne=n(e),k=o(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-wpm1fo"&&(k.innerHTML=Ee),ie=n(e),m(I.$$.fragment,e),oe=n(e),W=o(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-aqktpe"&&(W.innerHTML=Be),de=n(e),E=o(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-q1kulb"&&(E.innerHTML=Ge),pe=n(e),B=o(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-sc7gea"&&(B.innerHTML=$e),me=n(e),u=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(u)!=="svelte-pvc8g0"&&(u.innerHTML=ve),ce=n(e),m(G.$$.fragment,e),re=n(e),$=o(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-xxrvel"&&($.innerHTML=Ve),Me=n(e),m(v.$$.fragment,e),fe=n(e),V=o(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-1hk759o"&&(V.innerHTML=Fe),he=n(e),m(F.$$.fragment,e),ue=n(e),R=o(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1wx1e4m"&&(R.innerHTML=Re),Te=n(e),m(X.$$.fragment,e),we=n(e),A=o(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ih2p3b"&&(A.innerHTML=Xe),ye=n(e),m(x.$$.fragment,e),_e=n(e),m(Q.$$.fragment,e),Je=n(e),Y=o(e,"P",{}),Ae(Y).forEach(l),this.h()},h(){je(h,"name","hf:doc:metadata"),je(h,"content",De),je(u,"class","warning")},m(e,t){Se(document.head,h),a(e,S,t),a(e,H,t),a(e,z,t),c(T,e,t),a(e,P,t),a(e,w,t),a(e,D,t),a(e,y,t),a(e,K,t),a(e,_,t),a(e,q,t),c(J,e,t),a(e,O,t),a(e,b,t),a(e,ee,t),a(e,j,t),a(e,te,t),c(U,e,t),a(e,le,t),a(e,g,t),a(e,ae,t),c(C,e,t),a(e,se,t),c(Z,e,t),a(e,ne,t),a(e,k,t),a(e,ie,t),c(I,e,t),a(e,oe,t),a(e,W,t),a(e,de,t),a(e,E,t),a(e,pe,t),a(e,B,t),a(e,me,t),a(e,u,t),a(e,ce,t),c(G,e,t),a(e,re,t),a(e,$,t),a(e,Me,t),c(v,e,t),a(e,fe,t),a(e,V,t),a(e,he,t),c(F,e,t),a(e,ue,t),a(e,R,t),a(e,Te,t),c(X,e,t),a(e,we,t),a(e,A,t),a(e,ye,t),c(x,e,t),a(e,_e,t),c(Q,e,t),a(e,Je,t),a(e,Y,t),be=!0},p:Qe,i(e){be||(r(T.$$.fragment,e),r(J.$$.fragment,e),r(U.$$.fragment,e),r(C.$$.fragment,e),r(Z.$$.fragment,e),r(I.$$.fragment,e),r(G.$$.fragment,e),r(v.$$.fragment,e),r(F.$$.fragment,e),r(X.$$.fragment,e),r(x.$$.fragment,e),r(Q.$$.fragment,e),be=!0)},o(e){M(T.$$.fragment,e),M(J.$$.fragment,e),M(U.$$.fragment,e),M(C.$$.fragment,e),M(Z.$$.fragment,e),M(I.$$.fragment,e),M(G.$$.fragment,e),M(v.$$.fragment,e),M(F.$$.fragment,e),M(X.$$.fragment,e),M(x.$$.fragment,e),M(Q.$$.fragment,e),be=!1},d(e){e&&(l(S),l(H),l(z),l(P),l(w),l(D),l(y),l(K),l(_),l(q),l(O),l(b),l(ee),l(j),l(te),l(le),l(g),l(ae),l(se),l(ne),l(k),l(ie),l(oe),l(W),l(de),l(E),l(pe),l(B),l(me),l(u),l(ce),l(re),l($),l(Me),l(fe),l(V),l(he),l(ue),l(R),l(Te),l(we),l(A),l(ye),l(_e),l(Je),l(Y)),l(h),f(T,e),f(J,e),f(U,e),f(C,e),f(Z,e),f(I,e),f(G,e),f(v,e),f(F,e),f(X,e),f(x,e),f(Q,e)}}}const De='{"title":"Adapter injection","local":"adapter-injection","sections":[{"title":"Creating a new PEFT model","local":"creating-a-new-peft-model","sections":[{"title":"Injection based on a state_dict","local":"injection-based-on-a-statedict","sections":[],"depth":3}],"depth":2},{"title":"Saving the model","local":"saving-the-model","sections":[],"depth":2},{"title":"Loading the model","local":"loading-the-model","sections":[],"depth":2}],"depth":1}';function Ke(Ue){return Ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends He{constructor(h){super(),Ye(this,h,Ke,Pe,xe,{})}}export{lt as component};
