import{s as Xl,n as Rl,o as El}from"../chunks/scheduler.4cd3e004.js";import{S as Il,i as xl,e as o,s as a,c as p,h as Gl,a as s,d as l,b as i,f as Fl,g as m,j as r,k as Ul,l as Al,m as n,n as f,t as u,o as d,p as h}from"../chunks/index.b664cb2d.js";import{C as c}from"../chunks/CodeBlock.8601e34e.js";import{H as M,E as Hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";function Nl(Ot){let b,Le,Qe,Fe,g,Ue,y,el="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",Xe,w,tl='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://huggingface.co/papers/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',Re,T,ll='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',Ee,J,nl="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",Ie,$,xe,_,al='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',Ge,q,il="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",Ae,v,He,j,ol='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',Ne,Z,Ve,C,sl='Next, you should call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',Ye,W,Pe,z,rl="Now that the quantized model is ready, let’s set up a configuration.",Se,k,De,Q,pl='Create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Ke,B,Oe,L,ml='Then use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',et,F,tt,U,fl="You’re all set for training with whichever training method you prefer!",lt,X,nt,R,ul='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',at,E,dl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",it,I,ot,x,hl="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",st,G,rt,A,pt,H,cl='You can learn more about gptq based <code>[2, 3, 4, 8]</code> bits quantization at <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> and the Transformers <a href="https://huggingface.co/docs/transformers/quantization/gptq" rel="nofollow">GPTQ</a> doc. Post-quant training, PEFT can use both <a href="https://github.com/ModelCloud/GPTQModel" rel="nofollow">GPTQModel</a> or <a href="https://github.com/autogptq/autogptq" rel="nofollow">AutoGPTQ</a> libraries, but we recommend GPTQModel because AutoGPTQ will be deprecated in a future release.',mt,N,ft,V,ut,Y,Ml="Once quantized, you can post-train GPTQ models with PEFT APIs.",dt,P,ht,S,bl='Additive Quantization of Language Models (<a href="https://huggingface.co/papers/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',ct,D,gl='Since the AQLM quantization process is computationally expensive, the use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Mt,K,yl="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",bt,O,gt,ee,wl='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',yt,te,wt,le,Tl='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',Tt,ne,Jt,ae,Jl='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',$t,ie,_t,oe,$l="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",qt,se,vt,re,jt,pe,_l='The models that are quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',Zt,me,Ct,fe,ql="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",Wt,ue,zt,de,kt,he,vl='PEFT supports models quantized with <a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> (“ao”) for int8 quantization.',Qt,ce,Bt,Me,Lt,be,jl="<li>Use the most recent versions of torchao (&gt;= v0.4.0) and transformers (&gt; 4.42).</li> <li>Only linear layers are currently supported.</li> <li><code>quant_type = &quot;int4_weight_only&quot;</code> is currently not supported.</li> <li><code>NF4</code> is not implemented in transformers as of yet and is thus also not supported.</li> <li>DoRA only works with <code>quant_type = &quot;int8_weight_only&quot;</code> at the moment.</li> <li>There is explicit support for torchao when used with LoRA. However, when torchao quantizes a layer, its class does not change, only the type of the underlying tensor. For this reason, PEFT methods other than LoRA will generally also work with torchao, even if not explicitly supported. Be aware, however, that <strong>merging only works correctly with LoRA and with <code>quant_type = &quot;int8_weight_only&quot;</code></strong>. If you use a different PEFT method or dtype, merging will likely result in an error, and even it doesn’t, the results will still be incorrect.</li>",Ft,ge,Ut,ye,Zl=`Intel Neural Compressor (<a href="https://github.com/intel/neural-compressor" rel="nofollow">INC</a>) enables model quantization for various devices,
including Intel Gaudi accelerators (also known as HPU devices). You can perform LoRA fine-tuning on models that have been
quantized using INC. To use INC with PyTorch models, install the library with: <code>pip install neural-compressor[pt]</code>.
Quantizing a model to FP8 precision for HPU devices can be done with the following single-step quantization workflow:`,Xt,we,Rt,Te,Cl=`Pass the config to the <code>prepare</code> method, run inference to gather calibration stats, and call <code>finalize_calibration</code>
and <code>convert</code> methods to quantize model to FP8 precision:`,Et,Je,It,$e,Wl=`An example demonstrating how to load a PEFT LoRA adapter into an INC-quantized FLUX text-to-image model for HPU
devices is provided <a href="https://github.com/huggingface/peft/blob/main/examples/stable_diffusion/inc_flux_lora_hpu.py" rel="nofollow">here</a>.`,xt,_e,Gt,qe,zl="<li><code>merge()</code> and <code>unmerge()</code> methods are currently not supported for INC-quantized models.</li> <li>Currently, only <strong>Linear</strong> INC-quantized layers are supported when loading PEFT adapters.</li>",At,ve,Ht,je,kl="Besides LoRA, the following PEFT methods also support quantization:",Nt,Ze,Ql="<li><strong>VeRA</strong> (supports bitsandbytes quantization)</li> <li><strong>AdaLoRA</strong> (supports both bitsandbytes and GPTQ quantization)</li> <li><strong>(IA)³</strong> (supports bitsandbytes quantization)</li>",Vt,Ce,Yt,We,Bl="If you’re interested in learning more about quantization, the following may be helpful:",Pt,ze,Ll='<li>Learn more details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',St,ke,Dt,Be,Kt;return g=new M({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),$=new M({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),v=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),Z=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),W=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),k=new M({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),B=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),F=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),X=new M({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),I=new M({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),G=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),A=new M({props:{title:"GPTQ quantization",local:"gptq-quantization",headingTag:"h2"}}),N=new c({props:{code:"JTIzJTIwZ3B0cW1vZGVsJTIwaW5zdGFsbCUwQXBpcCUyMGluc3RhbGwlMjBncHRxbW9kZWwlMjAtLW5vLWJ1aWxkLWlzb2xhdGlvbg==",highlighted:`<span class="hljs-comment"># gptqmodel install</span>
pip install gptqmodel --no-build-isolation`,wrap:!1}}),V=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEdQVFFDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBncm91cF9zaXplJTNEMTI4JTJDJTIwZGF0YXNldCUzRCUyMndpa2l0ZXh0MiUyMiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyklMEElMEElMjMlMjBzYXZlJTIwcXVhbnRpemVkJTIwbW9kZWwlMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyLiUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, GPTQConfig

model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">128</span>, dataset=<span class="hljs-string">&quot;wikitext2&quot;</span>, tokenizer=tokenizer)

quantized_model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)

<span class="hljs-comment"># save quantized model</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;./opt-125m-gptq&quot;</span>)`,wrap:!1}}),P=new M({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),O=new c({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),te=new M({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),ne=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),ie=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),se=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),re=new M({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),me=new c({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMEhRUU1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9xdWFudGl6ZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2UlM0RkZXZpY2UpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=device)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),ue=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2VfbWFwJTNEZGV2aWNlX21hcCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device_map=device_map, quantization_config=quant_config)
peft_config = LoraConfig(...)
quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),de=new M({props:{title:"torchao (PyTorch Architecture Optimization)",local:"torchao-pytorch-architecture-optimization",headingTag:"h2"}}),ce=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEJTIyaW50OF93ZWlnaHRfb25seSUyMiklMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWcpJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, TorchAoConfig

model_id = ...
quantization_config = TorchAoConfig(quant_type=<span class="hljs-string">&quot;int8_weight_only&quot;</span>)
base_model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=quantization_config)
peft_config = LoraConfig(...)
model = get_peft_model(base_model, peft_config)`,wrap:!1}}),Me=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),ge=new M({props:{title:"INC quantization",local:"inc-quantization",headingTag:"h2"}}),we=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwbmV1cmFsX2NvbXByZXNzb3IudG9yY2gucXVhbnRpemF0aW9uJTIwaW1wb3J0JTIwRlA4Q29uZmlnJTJDJTIwY29udmVydCUyQyUyMGZpbmFsaXplX2NhbGlicmF0aW9uJTJDJTIwcHJlcGFyZSUwQXF1YW50X2NvbmZpZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAuLi4lMEElN0QlMEFjb25maWclMjAlM0QlMjBGUDhDb25maWcoKipxdWFudF9jb25maWdzKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> neural_compressor.torch.quantization <span class="hljs-keyword">import</span> FP8Config, convert, finalize_calibration, prepare
quant_configs = {
    ...
}
config = FP8Config(**quant_configs)`,wrap:!1}}),Je=new c({props:{code:"",highlighted:`model = prepare(model, config)
<span class="hljs-comment"># Run inference to collect calibration statistics</span>
...
<span class="hljs-comment"># Finalize calibration and convert the model to FP8 precision</span>
finalize_calibration(model)
model = convert(model)
<span class="hljs-comment"># Load PEFT LoRA adapter as usual</span>
...`,wrap:!1}}),_e=new M({props:{title:"Caveats:",local:"caveats",headingTag:"h3"}}),ve=new M({props:{title:"Other Supported PEFT Methods",local:"other-supported-peft-methods",headingTag:"h2"}}),Ce=new M({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),ke=new Hl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){b=o("meta"),Le=a(),Qe=o("p"),Fe=a(),p(g.$$.fragment),Ue=a(),y=o("p"),y.textContent=el,Xe=a(),w=o("ul"),w.innerHTML=tl,Re=a(),T=o("p"),T.innerHTML=ll,Ee=a(),J=o("p"),J.textContent=nl,Ie=a(),p($.$$.fragment),xe=a(),_=o("p"),_.innerHTML=al,Ge=a(),q=o("ul"),q.innerHTML=il,Ae=a(),p(v.$$.fragment),He=a(),j=o("p"),j.innerHTML=ol,Ne=a(),p(Z.$$.fragment),Ve=a(),C=o("p"),C.innerHTML=sl,Ye=a(),p(W.$$.fragment),Pe=a(),z=o("p"),z.textContent=rl,Se=a(),p(k.$$.fragment),De=a(),Q=o("p"),Q.innerHTML=pl,Ke=a(),p(B.$$.fragment),Oe=a(),L=o("p"),L.innerHTML=ml,et=a(),p(F.$$.fragment),tt=a(),U=o("p"),U.textContent=fl,lt=a(),p(X.$$.fragment),nt=a(),R=o("p"),R.innerHTML=ul,at=a(),E=o("p"),E.innerHTML=dl,it=a(),p(I.$$.fragment),ot=a(),x=o("p"),x.innerHTML=hl,st=a(),p(G.$$.fragment),rt=a(),p(A.$$.fragment),pt=a(),H=o("p"),H.innerHTML=cl,mt=a(),p(N.$$.fragment),ft=a(),p(V.$$.fragment),ut=a(),Y=o("p"),Y.textContent=Ml,dt=a(),p(P.$$.fragment),ht=a(),S=o("p"),S.innerHTML=bl,ct=a(),D=o("p"),D.innerHTML=gl,Mt=a(),K=o("p"),K.innerHTML=yl,bt=a(),p(O.$$.fragment),gt=a(),ee=o("p"),ee.innerHTML=wl,yt=a(),p(te.$$.fragment),wt=a(),le=o("p"),le.innerHTML=Tl,Tt=a(),p(ne.$$.fragment),Jt=a(),ae=o("p"),ae.innerHTML=Jl,$t=a(),p(ie.$$.fragment),_t=a(),oe=o("p"),oe.innerHTML=$l,qt=a(),p(se.$$.fragment),vt=a(),p(re.$$.fragment),jt=a(),pe=o("p"),pe.innerHTML=_l,Zt=a(),p(me.$$.fragment),Ct=a(),fe=o("p"),fe.textContent=ql,Wt=a(),p(ue.$$.fragment),zt=a(),p(de.$$.fragment),kt=a(),he=o("p"),he.innerHTML=vl,Qt=a(),p(ce.$$.fragment),Bt=a(),p(Me.$$.fragment),Lt=a(),be=o("ul"),be.innerHTML=jl,Ft=a(),p(ge.$$.fragment),Ut=a(),ye=o("p"),ye.innerHTML=Zl,Xt=a(),p(we.$$.fragment),Rt=a(),Te=o("p"),Te.innerHTML=Cl,Et=a(),p(Je.$$.fragment),It=a(),$e=o("p"),$e.innerHTML=Wl,xt=a(),p(_e.$$.fragment),Gt=a(),qe=o("ul"),qe.innerHTML=zl,At=a(),p(ve.$$.fragment),Ht=a(),je=o("p"),je.textContent=kl,Nt=a(),Ze=o("ul"),Ze.innerHTML=Ql,Vt=a(),p(Ce.$$.fragment),Yt=a(),We=o("p"),We.textContent=Bl,Pt=a(),ze=o("ul"),ze.innerHTML=Ll,St=a(),p(ke.$$.fragment),Dt=a(),Be=o("p"),this.h()},l(e){const t=Gl("svelte-u9bgzb",document.head);b=s(t,"META",{name:!0,content:!0}),t.forEach(l),Le=i(e),Qe=s(e,"P",{}),Fl(Qe).forEach(l),Fe=i(e),m(g.$$.fragment,e),Ue=i(e),y=s(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-famg4s"&&(y.textContent=el),Xe=i(e),w=s(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-1hhuofo"&&(w.innerHTML=tl),Re=i(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-142xot4"&&(T.innerHTML=ll),Ee=i(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1demhiu"&&(J.textContent=nl),Ie=i(e),m($.$$.fragment,e),xe=i(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-p0gbf4"&&(_.innerHTML=al),Ge=i(e),q=s(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-hfynw8"&&(q.innerHTML=il),Ae=i(e),m(v.$$.fragment,e),He=i(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-pxonbi"&&(j.innerHTML=ol),Ne=i(e),m(Z.$$.fragment,e),Ve=i(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1i20kxq"&&(C.innerHTML=sl),Ye=i(e),m(W.$$.fragment,e),Pe=i(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11mx7fc"&&(z.textContent=rl),Se=i(e),m(k.$$.fragment,e),De=i(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16xpk8c"&&(Q.innerHTML=pl),Ke=i(e),m(B.$$.fragment,e),Oe=i(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-rnh6oi"&&(L.innerHTML=ml),et=i(e),m(F.$$.fragment,e),tt=i(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-xd402n"&&(U.textContent=fl),lt=i(e),m(X.$$.fragment,e),nt=i(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-f32n60"&&(R.innerHTML=ul),at=i(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-7f0aai"&&(E.innerHTML=dl),it=i(e),m(I.$$.fragment,e),ot=i(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1c7jiea"&&(x.innerHTML=hl),st=i(e),m(G.$$.fragment,e),rt=i(e),m(A.$$.fragment,e),pt=i(e),H=s(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-waooev"&&(H.innerHTML=cl),mt=i(e),m(N.$$.fragment,e),ft=i(e),m(V.$$.fragment,e),ut=i(e),Y=s(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-lqq230"&&(Y.textContent=Ml),dt=i(e),m(P.$$.fragment,e),ht=i(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1myyhap"&&(S.innerHTML=bl),ct=i(e),D=s(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1qhybjf"&&(D.innerHTML=gl),Mt=i(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-wlm3ol"&&(K.innerHTML=yl),bt=i(e),m(O.$$.fragment,e),gt=i(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1f1bzer"&&(ee.innerHTML=wl),yt=i(e),m(te.$$.fragment,e),wt=i(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-16tz5mo"&&(le.innerHTML=Tl),Tt=i(e),m(ne.$$.fragment,e),Jt=i(e),ae=s(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-pxonbi"&&(ae.innerHTML=Jl),$t=i(e),m(ie.$$.fragment,e),_t=i(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1wgonl8"&&(oe.innerHTML=$l),qt=i(e),m(se.$$.fragment,e),vt=i(e),m(re.$$.fragment,e),jt=i(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1yzgecf"&&(pe.innerHTML=_l),Zt=i(e),m(me.$$.fragment,e),Ct=i(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-p9acs7"&&(fe.textContent=ql),Wt=i(e),m(ue.$$.fragment,e),zt=i(e),m(de.$$.fragment,e),kt=i(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-gynv46"&&(he.innerHTML=vl),Qt=i(e),m(ce.$$.fragment,e),Bt=i(e),m(Me.$$.fragment,e),Lt=i(e),be=s(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-4si0iy"&&(be.innerHTML=jl),Ft=i(e),m(ge.$$.fragment,e),Ut=i(e),ye=s(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-8d7dps"&&(ye.innerHTML=Zl),Xt=i(e),m(we.$$.fragment,e),Rt=i(e),Te=s(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-10yr85u"&&(Te.innerHTML=Cl),Et=i(e),m(Je.$$.fragment,e),It=i(e),$e=s(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1ugpcug"&&($e.innerHTML=Wl),xt=i(e),m(_e.$$.fragment,e),Gt=i(e),qe=s(e,"UL",{"data-svelte-h":!0}),r(qe)!=="svelte-h65blx"&&(qe.innerHTML=zl),At=i(e),m(ve.$$.fragment,e),Ht=i(e),je=s(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-14evo3v"&&(je.textContent=kl),Nt=i(e),Ze=s(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-ro48c4"&&(Ze.innerHTML=Ql),Vt=i(e),m(Ce.$$.fragment,e),Yt=i(e),We=s(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-agdyn7"&&(We.textContent=Bl),Pt=i(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-10zqaf7"&&(ze.innerHTML=Ll),St=i(e),m(ke.$$.fragment,e),Dt=i(e),Be=s(e,"P",{}),Fl(Be).forEach(l),this.h()},h(){Ul(b,"name","hf:doc:metadata"),Ul(b,"content",Vl)},m(e,t){Al(document.head,b),n(e,Le,t),n(e,Qe,t),n(e,Fe,t),f(g,e,t),n(e,Ue,t),n(e,y,t),n(e,Xe,t),n(e,w,t),n(e,Re,t),n(e,T,t),n(e,Ee,t),n(e,J,t),n(e,Ie,t),f($,e,t),n(e,xe,t),n(e,_,t),n(e,Ge,t),n(e,q,t),n(e,Ae,t),f(v,e,t),n(e,He,t),n(e,j,t),n(e,Ne,t),f(Z,e,t),n(e,Ve,t),n(e,C,t),n(e,Ye,t),f(W,e,t),n(e,Pe,t),n(e,z,t),n(e,Se,t),f(k,e,t),n(e,De,t),n(e,Q,t),n(e,Ke,t),f(B,e,t),n(e,Oe,t),n(e,L,t),n(e,et,t),f(F,e,t),n(e,tt,t),n(e,U,t),n(e,lt,t),f(X,e,t),n(e,nt,t),n(e,R,t),n(e,at,t),n(e,E,t),n(e,it,t),f(I,e,t),n(e,ot,t),n(e,x,t),n(e,st,t),f(G,e,t),n(e,rt,t),f(A,e,t),n(e,pt,t),n(e,H,t),n(e,mt,t),f(N,e,t),n(e,ft,t),f(V,e,t),n(e,ut,t),n(e,Y,t),n(e,dt,t),f(P,e,t),n(e,ht,t),n(e,S,t),n(e,ct,t),n(e,D,t),n(e,Mt,t),n(e,K,t),n(e,bt,t),f(O,e,t),n(e,gt,t),n(e,ee,t),n(e,yt,t),f(te,e,t),n(e,wt,t),n(e,le,t),n(e,Tt,t),f(ne,e,t),n(e,Jt,t),n(e,ae,t),n(e,$t,t),f(ie,e,t),n(e,_t,t),n(e,oe,t),n(e,qt,t),f(se,e,t),n(e,vt,t),f(re,e,t),n(e,jt,t),n(e,pe,t),n(e,Zt,t),f(me,e,t),n(e,Ct,t),n(e,fe,t),n(e,Wt,t),f(ue,e,t),n(e,zt,t),f(de,e,t),n(e,kt,t),n(e,he,t),n(e,Qt,t),f(ce,e,t),n(e,Bt,t),f(Me,e,t),n(e,Lt,t),n(e,be,t),n(e,Ft,t),f(ge,e,t),n(e,Ut,t),n(e,ye,t),n(e,Xt,t),f(we,e,t),n(e,Rt,t),n(e,Te,t),n(e,Et,t),f(Je,e,t),n(e,It,t),n(e,$e,t),n(e,xt,t),f(_e,e,t),n(e,Gt,t),n(e,qe,t),n(e,At,t),f(ve,e,t),n(e,Ht,t),n(e,je,t),n(e,Nt,t),n(e,Ze,t),n(e,Vt,t),f(Ce,e,t),n(e,Yt,t),n(e,We,t),n(e,Pt,t),n(e,ze,t),n(e,St,t),f(ke,e,t),n(e,Dt,t),n(e,Be,t),Kt=!0},p:Rl,i(e){Kt||(u(g.$$.fragment,e),u($.$$.fragment,e),u(v.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(B.$$.fragment,e),u(F.$$.fragment,e),u(X.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(A.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(Ce.$$.fragment,e),u(ke.$$.fragment,e),Kt=!0)},o(e){d(g.$$.fragment,e),d($.$$.fragment,e),d(v.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(k.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(X.$$.fragment,e),d(I.$$.fragment,e),d(G.$$.fragment,e),d(A.$$.fragment,e),d(N.$$.fragment,e),d(V.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(ce.$$.fragment,e),d(Me.$$.fragment,e),d(ge.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(_e.$$.fragment,e),d(ve.$$.fragment,e),d(Ce.$$.fragment,e),d(ke.$$.fragment,e),Kt=!1},d(e){e&&(l(Le),l(Qe),l(Fe),l(Ue),l(y),l(Xe),l(w),l(Re),l(T),l(Ee),l(J),l(Ie),l(xe),l(_),l(Ge),l(q),l(Ae),l(He),l(j),l(Ne),l(Ve),l(C),l(Ye),l(Pe),l(z),l(Se),l(De),l(Q),l(Ke),l(Oe),l(L),l(et),l(tt),l(U),l(lt),l(nt),l(R),l(at),l(E),l(it),l(ot),l(x),l(st),l(rt),l(pt),l(H),l(mt),l(ft),l(ut),l(Y),l(dt),l(ht),l(S),l(ct),l(D),l(Mt),l(K),l(bt),l(gt),l(ee),l(yt),l(wt),l(le),l(Tt),l(Jt),l(ae),l($t),l(_t),l(oe),l(qt),l(vt),l(jt),l(pe),l(Zt),l(Ct),l(fe),l(Wt),l(zt),l(kt),l(he),l(Qt),l(Bt),l(Lt),l(be),l(Ft),l(Ut),l(ye),l(Xt),l(Rt),l(Te),l(Et),l(It),l($e),l(xt),l(Gt),l(qe),l(At),l(Ht),l(je),l(Nt),l(Ze),l(Vt),l(Yt),l(We),l(Pt),l(ze),l(St),l(Dt),l(Be)),l(b),h(g,e),h($,e),h(v,e),h(Z,e),h(W,e),h(k,e),h(B,e),h(F,e),h(X,e),h(I,e),h(G,e),h(A,e),h(N,e),h(V,e),h(P,e),h(O,e),h(te,e),h(ne,e),h(ie,e),h(se,e),h(re,e),h(me,e),h(ue,e),h(de,e),h(ce,e),h(Me,e),h(ge,e),h(we,e),h(Je,e),h(_e,e),h(ve,e),h(Ce,e),h(ke,e)}}}const Vl='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"GPTQ quantization","local":"gptq-quantization","sections":[],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"torchao (PyTorch Architecture Optimization)","local":"torchao-pytorch-architecture-optimization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"INC quantization","local":"inc-quantization","sections":[{"title":"Caveats:","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Other Supported PEFT Methods","local":"other-supported-peft-methods","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Yl(Ot){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Il{constructor(b){super(),xl(this,b,Yl,Nl,Xl,{})}}export{Ol as component};
