import{s as hn,n as fn,o as un}from"../chunks/scheduler.4cd3e004.js";import{S as cn,i as yn,e as i,s,c as p,h as gn,a as o,d as l,b as n,f as mn,g as d,j as r,k as Zt,l as bn,m as a,n as m,t as h,o as f,p as u}from"../chunks/index.b664cb2d.js";import{C as c}from"../chunks/CodeBlock.8601e34e.js";import{H as y,E as wn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";function Mn(Qa){let g,Wt,Ut,Bt,v,Gt,$,za="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",Lt,j,Ft,k,Na="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the following package versions:",Rt,x,Aa="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",It,J,Sa="In general, you can update the package version by running this command inside your Python environment:",Xt,Z,Vt,U,Ka="Installing PEFT from source is useful for keeping up with the latest developments:",Ht,C,Et,W,Yt,B,Pt,G,Da='This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without loading the whole model in fp32, add the following to your code:',qt,L,Qt,F,Oa='Alternatively, you can use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.cast_mixed_precision_params">cast_mixed_precision_params()</a> function to correctly cast the weights:',zt,R,Nt,b,es='<p>Starting from PEFT version v0.12.0, PEFT automatically promotes the dtype of adapter weights from <code>torch.float16</code> and <code>torch.bfloat16</code> to <code>torch.float32</code> where appropriate. To <em>prevent</em> this behavior, you can pass <code>autocast_adapter_dtype=False</code> to <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>, to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>, and to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.</p>',At,I,St,X,ts="Most PEFT methods, like LoRA, work by adding trainable adapter weights. By default, those weights are stored in float32 dtype (fp32), i.e. at a relatively high precision. Therefore, even if the base model is loaded in float16 (fp16) or bfloat16 (bf16), the adapter weights are float32. When the adapter results are calculated during the forward pass, the input will typically be in the dtype of the base model, thus it will be upcast to float32 if necessary, then cast back to the original dtype.",Kt,V,ls='If you prefer to have the adapter weights in the lower precision of the base model, i.e. in float16 or bfloat16, you can pass <code>autocast_adapter_dtype=False</code> when creating the model (<a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">~get_peft_model()</a>) or loading the model (<a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a>). There are some advantages and disadvantages to this:',Dt,H,as="Advantages of half precision adapter:",Ot,E,ss="<li>computation slightly faster</li> <li>slightly less memory</li> <li>smaller file size of checkpoint (half the size)</li>",el,Y,ns="Disadvantages of half precision adapter:",tl,P,is="<li>slightly worse loss</li> <li>higher risk of overflow or underflow</li>",ll,q,os="Note that for most use cases, overall runtime and memory cost will be determined by the size of the base model and by the dataset, while the dtype of the PEFT adapter will only have a small impact.",al,Q,sl,z,rs='There can be several reasons for getting a poor result from a loaded PEFT model which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',nl,N,ps="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",il,A,ol,S,ds="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",rl,K,ms='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',pl,D,dl,O,hs='Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> which is incorrect. Instead, the loading code should look like this:',ml,ee,hl,te,fl,le,fs="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",ul,ae,us="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",cl,se,cs="PEFT tries to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",yl,ne,ys="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",gl,ie,bl,oe,gs="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",wl,w,bs="<p>As an example, when loading a model that is using the DeBERTa architecture for sequence classification, you’ll see a warning that the following weights are newly initialized: <code>[&#39;classifier.bias&#39;, &#39;classifier.weight&#39;, &#39;pooler.dense.bias&#39;, &#39;pooler.dense.weight&#39;]</code>. From this, it follows that the <code>classifier</code> and <code>pooler</code> layers should be added to: <code>modules_to_save=[&quot;classifier&quot;, &quot;pooler&quot;]</code>.</p>",Ml,re,Tl,pe,ws="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and, depending on the fine-tuning method, also storing the embedding layer in addition to the adapter weights when saving the adapter. There are a few ways of achieving this ordered by parameter effectiveness:",_l,de,Ms='<li><a href="../package_reference/trainable_tokens">trainable tokens</a>, train only the specified tokens, optionally store only the updated values</li> <li>training an adapter on the embedding matrix, optionally store only the updated values</li> <li>full-finetuning of the embedding layer</li>',vl,me,$l,he,Ts='Let’s start with trainable tokens, in this case its <a href="../developer_guides/lora#efficiently-train-tokens-alongside-lora">LoRA integration</a>.  If you’re interested in only training the new embeddings and nothing else, refer to the <a href="../package_reference/trainable_tokens">standalone documentation</a>.',jl,fe,_s="To enable selective token training of the embedding layer, you’ll need to supply the token ids of your newly added tokens via the <code>trainable_token_indices</code> parameter.  Optionally you can specify which layer to target if there is more than one embedding layer. For a Mistral model this could look like this:",kl,ue,xl,ce,vs="If your model uses tied weights (such as the <code>lm_head</code>), trainable tokens will try to resolve those and keep them updated as well, so in that case there should be no need for adding <code>modules_to_save=[&quot;lm_head&quot;]</code>. This only works if the model uses the Transformers convention for tying weights.",Jl,ye,$s=`Saving the model with <code>model.save_pretrained</code> may save the full embedding matrix instead of
only the difference as a precaution because the embedding matrix was resized. To save space you can disable this behavior by setting <code>save_embedding_layers=False</code> when calling <code>save_pretrained</code>. This is safe to do as long as you don’t modify the embedding matrix through other means as well, as such changes will be not tracked by trainable tokens.`,Zl,ge,Ul,be,js="Prepare the embedding layer by adding it to the <code>target_modules</code> of your adapter config. For example, the Mistral config could look like this:",Cl,we,Wl,Me,ks="Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <code>get_input_embeddings</code> and <code>get_output_embeddings</code>. This is generally the case for Transformers models.",Bl,Te,xs="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme but nevertheless implements <code>get_input_embeddings</code>, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",Gl,_e,Ll,ve,Js="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",Fl,$e,Zs='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',Rl,je,Il,ke,Us="Full fine-tuning is more costly in terms of VRAM or storage space but if all else fails, you can fall back to this and see if it works for you. Achieve it by adding the name of the embedding layer to <code>modules_to_save</code>. Note that you need to add tied layers as well, e.g. <code>lm_head</code>. Example for a Mistral model with LoRA:",Xl,xe,Vl,Je,Hl,Ze,Cs="When you load your PEFT model which has been trained on a task (for example, classification), you may get a warning like:",El,Ue,Ws="<p>Some weights of LlamaForSequenceClassification were not initialized from the model checkpoint at meta-llama/Llama-3.2-1B and are newly initialized: [‘score.weight’]. You should probably TRAIN this model on a down-stream task to be able to use it for predictions and inference.</p>",Yl,Ce,Bs="Although this looks scary, it is most likely nothing to worry about. This warning comes from Transformers, and it isn’t a PEFT specific warning. It lets you know that a randomly initialized classification head (<code>score</code>) is attached to the base model, and the head must be trained to produce sensible predictions.",Pl,We,Gs="When you get this warning <em>before</em> training the model, PEFT automatically takes care of making the classification head trainable if you correctly passed the <code>task_type</code> argument to the PEFT config.",ql,Be,Ql,Ge,Ls="If your classification head does not follow the usual naming conventions from Transformers (which is rare), you have to explicitly tell PEFT the name of the head in <code>modules_to_save</code>.",zl,Le,Nl,Fe,Fs="To check the name of the classification head, print the model and it should be the last module.",Al,Re,Rs="If you get this warning from your inference code, i.e. <em>after</em> training the model, when you load the PEFT model, you always have to load the Transformers model first. Since Transformers does not know that you will load PEFT weights afterwards, it still gives the warning.",Sl,Ie,Is="As always, it is best practice to ensure the model works correctly for inference by running some validation on it.",Kl,Xe,Dl,Ve,Xs='Sometimes a PEFT model can end up in a bad state, especially when handling multiple adapters. There can be some confusion around what adapters exist, which one is active, which one is merged, etc. To help investigate this issue, call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> and the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_model_status">get_model_status()</a> methods.',Ol,He,Vs='The <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.get_layer_status">get_layer_status()</a> method gives you a detailed overview of each targeted layer’s active, merged, and available adapters.',ea,Ee,ta,Ye,Hs="In the model state output, you should look out for entries that say <code>&quot;irregular&quot;</code>. This means PEFT detected an inconsistent state in the model. For instance, if <code>merged_adapters=&quot;irregular&quot;</code>, it means that for at least one adapter, it was merged on some target modules but not on others. The inference results will most likely be incorrect as a result.",la,Pe,Es="The best way to resolve this issue is to reload the whole model and adapter checkpoint(s). Ensure that you don’t perform any incorrect operations on the model, e.g. manually merging adapters on some modules but not others.",aa,qe,Ys="Convert the layer status into a pandas <code>DataFrame</code> for an easier visual inspection.",sa,Qe,na,ze,Ps='It is possible to get this information for non-PEFT models if they are using PEFT layers under the hood, but some information like the <code>base_model_type</code> or the <code>peft_types</code> cannot be determined in that case. As an example, you can call this on a <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> model like so:',ia,Ne,oa,Ae,ra,Se,pa,Ke,qs='Loading adapters like LoRA weights should generally be fast compared to loading the base model. However, there can be use cases where the adapter weights are quite large or where users need to load a large number of adapters — the loading time can add up in this case. The reason for this is that the adapter weights are first initialized and then overridden by the loaded weights, which is wasteful. To speed up the loading time, you can pass the <code>low_cpu_mem_usage=True</code> argument to <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.from_pretrained">from_pretrained()</a> and <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>.',da,M,Qs="<p>If this option works well across different use cases, it may become the default for adapter loading in the future.</p>",ma,De,ha,Oe,fa,et,zs="When loading a trained PEFT model where the base model uses batch norm (e.g. <code>torch.nn.BatchNorm1d</code> or <code>torch.nn.BatchNorm2d</code>), you may find that you cannot reproduce the exact same outputs. This is because the batch norm layers keep track of running stats during training, but these stats are not part of the PEFT checkpoint. Therefore, when you load the PEFT model, the running stats of the base model will be used (i.e. from before training with PEFT).",ua,tt,Ns="Depending on your use case, this may not be a big deal. If, however, you need your outputs to be 100% reproducible, you can achieve this by adding the batch norm layers to <code>modules_to_save</code>. Below is an example of this using resnet and LoRA. Notice that we set <code>modules_to_save=[&quot;classifier&quot;, &quot;normalization&quot;]</code>. We need the <code>&quot;classifier&quot;</code> argument because our task is image classification, and we add the <code>&quot;normalization&quot;</code> argument to ensure that the batch norm layers are saved in the PEFT checkpoint.",ca,lt,ya,at,As="Depending on the type of model you use, the batch norm layers could have different names than <code>&quot;normalization&quot;</code>, so please ensure that the name matches your model architecture.",ga,st,ba,nt,wa,it,Ss="When you encounter an error like the one shown below, it means the adapter you’re trying to load was trained with a more recent version of PEFT than the version you have installed on your system.",Ma,ot,Ta,rt,Ks="The best way to resolve this issue is to install the latest PEFT version:",_a,pt,va,dt,Ds="If the adapter was trained from a source install of PEFT (an unreleased version of PEFT), then you also need to install PEFT from source.",$a,mt,ja,ht,Os="If it is not possible for you to upgrade PEFT, there is a workaround you can try.",ka,ft,en="Assume the error message says that the unknown keyword argument is named <code>foobar</code>. Search inside the <code>adapter_config.json</code> of this PEFT adapter for the <code>foobar</code> entry and delete it from the file. Then save the file and try loading the model again.",xa,ut,tn="This solution works most of the time. As long as it is the default value for <code>foobar</code>, it can be ignored. However, when it is set to some other value, you will get incorrect results. Upgrading PEFT is the recommended solution.",Ja,ct,Za,yt,Ua,gt,ln="PEFT allows you to create more than one adapter on the same model. This can be useful in many situations. For example, for inference, you may want to serve two fine-tuned models from the same base model instead of loading the base model once for each fine-tuned model, which would cost more memory. However, multiple adapters can be activated at the same time. This way, the model may leverage the learnings from all those adapters at the same time. As an example, if you have a diffusion model, you may want to use one LoRA adapter to change the style and a different one to change the subject.",Ca,bt,an="Activating multiple adapters at the same time is generally possible on all PEFT methods (LoRA, LoHa, IA³, etc.) except for prompt learning methods (p-tuning, prefix tuning, etc.). The following example illustrates how to achieve this:",Wa,wt,Ba,T,sn="<p>In the example above, you can see that we need to call <code>model.base_model.set_adapter([&quot;default&quot;, &quot;other&quot;])</code>. Why can we not call <code>model.set_adapter([&quot;default&quot;, &quot;other&quot;])</code>? This is unfortunately not possible because, as explained earlier, some PEFT methods don’t support activating more than one adapter at a time.</p>",Ga,Mt,nn="It is also possible to train two adapters at the same time, but you should be careful to ensure that the weights of both adapters are known to the optimizer. Otherwise, only one adapter will receive updates.",La,Tt,Fa,_t,on="If we would now call:",Ra,vt,Ia,$t,rn="or",Xa,jt,Va,kt,pn="then the second LoRA adapter (<code>&quot;other&quot;</code>) would not be trained. This is because it is inactive at this moment, which means the <code>requires_grad</code> attribute on its parameters is set to <code>False</code> and the optimizer will ignore it. Therefore, make sure to activate all adapters that should be trained <em>before</em> initializing the optimizer:",Ha,xt,Ea,_,dn='<p>This section deals with using multiple adapters <em>of the same type</em> on the same model, for example, using multiple LoRA adapters at the same time. It does not apply to using <em>different types</em> of adapters on the same model, for example one LoRA adapter and one LoHa adapter. For this, please check <a href="https://huggingface.co/docs/peft/developer_guides/mixed_models" rel="nofollow"><code>PeftMixedModel</code></a>.</p>',Ya,Jt,Pa,Ct,qa;return v=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),j=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),Z=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),C=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),W=new y({props:{title:"Dtype-related issues",local:"dtype-related-issues",headingTag:"h2"}}),B=new y({props:{title:"ValueError: Attempting to unscale FP16 gradients",local:"valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h3"}}),L=new c({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),R=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),I=new y({props:{title:"Selecting the dtype of the adapter",local:"selecting-the-dtype-of-the-adapter",headingTag:"h3"}}),Q=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),A=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),D=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),ee=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),te=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),ie=new c({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),re=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),me=new y({props:{title:"Using trainable tokens",local:"using-trainable-tokens",headingTag:"h4"}}),ue=new c({props:{code:"bmV3X3Rva2VucyUyMCUzRCUyMCU1QiclM0N0aGluayUzRSclMkMlMjAnJTNDJTJGdGhpbmslM0UnJTVEJTBBdG9rZW5pemVyLmFkZF90b2tlbnMobmV3X3Rva2VucyklMEFiYXNlX21vZGVsLnJlc2l6ZV90b2tlbl9lbWJlZGRpbmdzKGxlbih0b2tlbml6ZXIpKSUwQSUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjB0cmFpbmFibGVfdG9rZW5faW5kaWNlcyUzRCU3QidlbWJlZF90b2tlbnMnJTNBJTIwdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyhuZXdfdG9rZW5zKSU3RCUyQyUwQSk=",highlighted:`new_tokens = [<span class="hljs-string">&#x27;&lt;think&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;/think&gt;&#x27;</span>]
tokenizer.add_tokens(new_tokens)
base_model.resize_token_embeddings(<span class="hljs-built_in">len</span>(tokenizer))

lora_config = LoraConfig(
    ...,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(new_tokens)},
)`,wrap:!1}}),ge=new y({props:{title:"Using an adapter, e.g. LoRA",local:"using-an-adapter-eg-lora",headingTag:"h4"}}),we=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),_e=new c({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_pretrained(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),je=new y({props:{title:"Full fine-tuning",local:"full-fine-tuning",headingTag:"h4"}}),xe=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJlbWJlZF90b2tlbnMlMjIlMkMlMjAlMjJsbV9oZWFkJTIyJTVEJTJDJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>], target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),Je=new y({props:{title:"Getting a warning about “weights not being initialized from the model checkpoint”",local:"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint",headingTag:"h3"}}),Be=new c({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uJTJDJTIwdGFza190eXBlJTNEVGFza1R5cGUuU0VRX0NMUyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType

lora_config = LoraConfig(..., task_type=TaskType.SEQ_CLS)`,wrap:!1}}),Le=new c({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiUyQyUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMm5hbWUtb2YtY2xhc3NpZmljYXRpb24taGVhZCUyMiU1RCk=",highlighted:'lora_config = LoraConfig(..., modules_to_save=[<span class="hljs-string">&quot;name-of-classification-head&quot;</span>])',wrap:!1}}),Xe=new y({props:{title:"Check layer and model status",local:"check-layer-and-model-status",headingTag:"h3"}}),Ee=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBMb3JhQ29uZmlnKCkpJTBBJTBBbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpJTBBJTBBbW9kZWwuZ2V0X21vZGVsX3N0YXR1cygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;google/flan-t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = get_peft_model(model, LoraConfig())

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_layer_status()
[TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.q&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;model.encoder.block.0.layer.0.SelfAttention.v&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>]),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>model.get_model_status()
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;T5Model&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;LoraModel&#x27;</span>,
    peft_types={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-string">&#x27;LORA&#x27;</span>},
    trainable_params=<span class="hljs-number">344064</span>,
    total_params=<span class="hljs-number">60855680</span>,
    num_adapter_layers=<span class="hljs-number">48</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;default&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;default&#x27;</span>],
)`,wrap:!1}}),Qe=new c({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwYXNkaWN0JTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKGFzZGljdChsYXllciklMjBmb3IlMjBsYXllciUyMGluJTIwbW9kZWwuZ2V0X2xheWVyX3N0YXR1cygpKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> asdict
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

df = pd.DataFrame(asdict(layer) <span class="hljs-keyword">for</span> layer <span class="hljs-keyword">in</span> model.get_layer_status())`,wrap:!1}}),Ne=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGdldF9tb2RlbF9zdGF0dXMlMkMlMjBnZXRfbGF5ZXJfc3RhdHVzJTBBJTBBcGF0aCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbG9yYV9pZCUyMCUzRCUyMCUyMnRha3VtYTEwNCUyRmxvcmEtdGVzdC10ZXh0LWVuY29kZXItbG9yYS10YXJnZXQlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHBhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyhsb3JhX2lkJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlci0xJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMobG9yYV9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXItMiUyMiklMEFwaXBlLnNldF9sb3JhX2RldmljZSglNUIlMjJhZGFwdGVyLTIlMjIlNUQlMkMlMjAlMjJjdWRhJTIyKSUwQWdldF9sYXllcl9zdGF0dXMocGlwZS50ZXh0X2VuY29kZXIpJTBBJTBBZ2V0X21vZGVsX3N0YXR1cyhwaXBlLnVuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_model_status, get_layer_status

<span class="hljs-meta">&gt;&gt;&gt; </span>path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lora_id = <span class="hljs-string">&quot;takuma104/lora-test-text-encoder-lora-target&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_lora_weights(lora_id, adapter_name=<span class="hljs-string">&quot;adapter-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.set_lora_device([<span class="hljs-string">&quot;adapter-2&quot;</span>], <span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_layer_status(pipe.text_encoder)
[TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.k_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
 TunerLayerStatus(name=<span class="hljs-string">&#x27;text_model.encoder.layers.0.self_attn.v_proj&#x27;</span>,
                  module_type=<span class="hljs-string">&#x27;lora.Linear&#x27;</span>,
                  enabled=<span class="hljs-literal">True</span>,
                  active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
                  merged_adapters=[],
                  requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
                  devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]}),
...]

<span class="hljs-meta">&gt;&gt;&gt; </span>get_model_status(pipe.unet)
TunerModelStatus(
    base_model_type=<span class="hljs-string">&#x27;other&#x27;</span>,
    adapter_model_type=<span class="hljs-string">&#x27;None&#x27;</span>,
    peft_types={},
    trainable_params=<span class="hljs-number">797184</span>,
    total_params=<span class="hljs-number">861115332</span>,
    num_adapter_layers=<span class="hljs-number">128</span>,
    enabled=<span class="hljs-literal">True</span>,
    active_adapters=[<span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    merged_adapters=[],
    requires_grad={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: <span class="hljs-literal">False</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>: <span class="hljs-literal">True</span>},
    available_adapters=[<span class="hljs-string">&#x27;adapter-1&#x27;</span>, <span class="hljs-string">&#x27;adapter-2&#x27;</span>],
    devices={<span class="hljs-string">&#x27;adapter-1&#x27;</span>: [<span class="hljs-string">&#x27;cpu&#x27;</span>], <span class="hljs-string">&#x27;adapter-2&#x27;</span>: [<span class="hljs-string">&#x27;cuda&#x27;</span>]},
)`,wrap:!1}}),Ae=new y({props:{title:"Speed",local:"speed",headingTag:"h2"}}),Se=new y({props:{title:"Loading adapter weights is slow",local:"loading-adapter-weights-is-slow",headingTag:"h3"}}),De=new y({props:{title:"Reproducibility",local:"reproducibility",headingTag:"h2"}}),Oe=new y({props:{title:"Models using batch norm",local:"models-using-batch-norm",headingTag:"h3"}}),lt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGcmVzbmV0LTE4JTIyJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNlbGYubW9kZWxfaWQpJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmNvbnZvbHV0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiUyQyUyMCUyMm5vcm1hbGl6YXRpb24lMjIlNUQlMkMlMEEpJTJD",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = <span class="hljs-string">&quot;microsoft/resnet-18&quot;</span>
base_model = AutoModelForImageClassification.from_pretrained(self.model_id)
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;convolution&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>, <span class="hljs-string">&quot;normalization&quot;</span>],
),`,wrap:!1}}),st=new y({props:{title:"Version mismatch",local:"version-mismatch",headingTag:"h2"}}),nt=new y({props:{title:"Error while loading the config because of an unexpected keyword argument",local:"error-while-loading-the-config-because-of-an-unexpected-keyword-argument",headingTag:"h3"}}),ot=new c({props:{code:"VHlwZUVycm9yJTNBJTIwTG9yYUNvbmZpZy5fX2luaXRfXygpJTIwZ290JTIwYW4lMjB1bmV4cGVjdGVkJTIwa2V5d29yZCUyMGFyZ3VtZW50JTIwJTNDYXJndW1lbnQtbmFtZSUzRQ==",highlighted:'TypeError: LoraConfig.__init__() got an unexpected keyword <span class="hljs-variable language_">argument</span> &lt;<span class="hljs-variable language_">argument</span>-name&gt;',wrap:!1}}),pt=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBQRUZU",highlighted:"python -m pip install -U PEFT",wrap:!1}}),mt=new c({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnBlZnQuZ2l0",highlighted:"python -m pip install -U git+https://github.com/huggingface/peft.git",wrap:!1}}),ct=new y({props:{title:"Adapter handling",local:"adapter-handling",headingTag:"h2"}}),yt=new y({props:{title:"Using multiple adapters at the same time",local:"using-multiple-adapters-at-the-same-time",headingTag:"h3"}}),wt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBsb3JhX3BhdGhfMCklMjAlMjAlMjMlMjBkZWZhdWx0JTIwYWRhcHRlcl9uYW1lJTIwaXMlMjAnZGVmYXVsdCclMEFtb2RlbC5sb2FkX2FkYXB0ZXIobG9yYV9wYXRoXzElMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJvdGhlciUyMiklMEElMjMlMjB0aGUlMjAnb3RoZXInJTIwYWRhcHRlciUyMHdhcyUyMGxvYWRlZCUyMGJ1dCUyMGl0J3MlMjBub3QlMjBhY3RpdmUlMjB5ZXQlMkMlMjBzbyUyMHRvJTIwYWN0aXZhdGUlMjBib3RoJTIwYWRhcHRlcnMlM0ElMEFtb2RlbC5iYXNlX21vZGVsLnNldF9hZGFwdGVyKCU1QiUyMmRlZmF1bHQlMjIlMkMlMjAlMjJvdGhlciUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
base_model = AutoModelForCausalLM.from_pretrained(model_id)
model = PeftModel.from_pretrained(base_model, lora_path_0)  <span class="hljs-comment"># default adapter_name is &#x27;default&#x27;</span>
model.load_adapter(lora_path_1, adapter_name=<span class="hljs-string">&quot;other&quot;</span>)
<span class="hljs-comment"># the &#x27;other&#x27; adapter was loaded but it&#x27;s not active yet, so to activate both adapters:</span>
model.base_model.set_adapter([<span class="hljs-string">&quot;default&quot;</span>, <span class="hljs-string">&quot;other&quot;</span>])`,wrap:!1}}),Tt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFtb2RlbF9pZCUyMCUzRCUyMC4uLiUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbG9yYV9jb25maWdfMCUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQWxvcmFfY29uZmlnXzElMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZ18wKSUwQW1vZGVsLmFkZF9hZGFwdGVyKGFkYXB0ZXJfbmFtZSUzRCUyMm90aGVyJTIyJTJDJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZ18xKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

model_id = ...
base_model = AutoModelForCausalLM.from_pretrained(model_id)
lora_config_0 = LoraConfig(...)
lora_config_1 = LoraConfig(...)
model = get_peft_model(base_model, lora_config_0)
model.add_adapter(adapter_name=<span class="hljs-string">&quot;other&quot;</span>, peft_config=lora_config_1)`,wrap:!1}}),vt=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lcihtb2RlbCUzRG1vZGVsJTJDJTIwJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(model=model,  ...)
trainer.train()`,wrap:!1}}),jt=new c({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcoJTVCcGFyYW0lMjBmb3IlMjBwYXJhbSUyMGluJTIwbW9kZWwucGFyYW1ldGVycygpJTIwaWYlMjBwYXJhbS5yZXF1aXJlc19ncmFkJTVEJTJDJTIwLi4uKQ==",highlighted:'optimizer = torch.optim.AdamW([param <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters() <span class="hljs-keyword">if</span> param.requires_grad], ...)',wrap:!1}}),xt=new c({props:{code:"JTIzJTIwYWN0aXZhdGUlMjBhbGwlMjBhZGFwdGVycyUwQW1vZGVsLmJhc2VfbW9kZWwuc2V0X2FkYXB0ZXIoJTVCJTIyZGVmYXVsdCUyMiUyQyUyMCUyMm90aGVyJTIyJTVEKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjAlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-comment"># activate all adapters</span>
model.base_model.set_adapter([<span class="hljs-string">&quot;default&quot;</span>, <span class="hljs-string">&quot;other&quot;</span>])
trainer = Trainer(model=model,  ...)
trainer.train()`,wrap:!1}}),Jt=new wn({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/troubleshooting.md"}}),{c(){g=i("meta"),Wt=s(),Ut=i("p"),Bt=s(),p(v.$$.fragment),Gt=s(),$=i("p"),$.textContent=za,Lt=s(),p(j.$$.fragment),Ft=s(),k=i("p"),k.textContent=Na,Rt=s(),x=i("ul"),x.innerHTML=Aa,It=s(),J=i("p"),J.textContent=Sa,Xt=s(),p(Z.$$.fragment),Vt=s(),U=i("p"),U.textContent=Ka,Ht=s(),p(C.$$.fragment),Et=s(),p(W.$$.fragment),Yt=s(),p(B.$$.fragment),Pt=s(),G=i("p"),G.innerHTML=Da,qt=s(),p(L.$$.fragment),Qt=s(),F=i("p"),F.innerHTML=Oa,zt=s(),p(R.$$.fragment),Nt=s(),b=i("blockquote"),b.innerHTML=es,At=s(),p(I.$$.fragment),St=s(),X=i("p"),X.textContent=ts,Kt=s(),V=i("p"),V.innerHTML=ls,Dt=s(),H=i("p"),H.textContent=as,Ot=s(),E=i("ul"),E.innerHTML=ss,el=s(),Y=i("p"),Y.textContent=ns,tl=s(),P=i("ul"),P.innerHTML=is,ll=s(),q=i("p"),q.textContent=os,al=s(),p(Q.$$.fragment),sl=s(),z=i("p"),z.innerHTML=rs,nl=s(),N=i("p"),N.textContent=ps,il=s(),p(A.$$.fragment),ol=s(),S=i("p"),S.textContent=ds,rl=s(),K=i("ol"),K.innerHTML=ms,pl=s(),p(D.$$.fragment),dl=s(),O=i("p"),O.innerHTML=hs,ml=s(),p(ee.$$.fragment),hl=s(),p(te.$$.fragment),fl=s(),le=i("p"),le.innerHTML=fs,ul=s(),ae=i("p"),ae.innerHTML=us,cl=s(),se=i("p"),se.innerHTML=cs,yl=s(),ne=i("p"),ne.textContent=ys,gl=s(),p(ie.$$.fragment),bl=s(),oe=i("p"),oe.innerHTML=gs,wl=s(),w=i("blockquote"),w.innerHTML=bs,Ml=s(),p(re.$$.fragment),Tl=s(),pe=i("p"),pe.textContent=ws,_l=s(),de=i("ul"),de.innerHTML=Ms,vl=s(),p(me.$$.fragment),$l=s(),he=i("p"),he.innerHTML=Ts,jl=s(),fe=i("p"),fe.innerHTML=_s,kl=s(),p(ue.$$.fragment),xl=s(),ce=i("p"),ce.innerHTML=vs,Jl=s(),ye=i("p"),ye.innerHTML=$s,Zl=s(),p(ge.$$.fragment),Ul=s(),be=i("p"),be.innerHTML=js,Cl=s(),p(we.$$.fragment),Wl=s(),Me=i("p"),Me.innerHTML=ks,Bl=s(),Te=i("p"),Te.innerHTML=xs,Gl=s(),p(_e.$$.fragment),Ll=s(),ve=i("p"),ve.textContent=Js,Fl=s(),$e=i("p"),$e.innerHTML=Zs,Rl=s(),p(je.$$.fragment),Il=s(),ke=i("p"),ke.innerHTML=Us,Xl=s(),p(xe.$$.fragment),Vl=s(),p(Je.$$.fragment),Hl=s(),Ze=i("p"),Ze.textContent=Cs,El=s(),Ue=i("blockquote"),Ue.innerHTML=Ws,Yl=s(),Ce=i("p"),Ce.innerHTML=Bs,Pl=s(),We=i("p"),We.innerHTML=Gs,ql=s(),p(Be.$$.fragment),Ql=s(),Ge=i("p"),Ge.innerHTML=Ls,zl=s(),p(Le.$$.fragment),Nl=s(),Fe=i("p"),Fe.textContent=Fs,Al=s(),Re=i("p"),Re.innerHTML=Rs,Sl=s(),Ie=i("p"),Ie.textContent=Is,Kl=s(),p(Xe.$$.fragment),Dl=s(),Ve=i("p"),Ve.innerHTML=Xs,Ol=s(),He=i("p"),He.innerHTML=Vs,ea=s(),p(Ee.$$.fragment),ta=s(),Ye=i("p"),Ye.innerHTML=Hs,la=s(),Pe=i("p"),Pe.textContent=Es,aa=s(),qe=i("p"),qe.innerHTML=Ys,sa=s(),p(Qe.$$.fragment),na=s(),ze=i("p"),ze.innerHTML=Ps,ia=s(),p(Ne.$$.fragment),oa=s(),p(Ae.$$.fragment),ra=s(),p(Se.$$.fragment),pa=s(),Ke=i("p"),Ke.innerHTML=qs,da=s(),M=i("blockquote"),M.innerHTML=Qs,ma=s(),p(De.$$.fragment),ha=s(),p(Oe.$$.fragment),fa=s(),et=i("p"),et.innerHTML=zs,ua=s(),tt=i("p"),tt.innerHTML=Ns,ca=s(),p(lt.$$.fragment),ya=s(),at=i("p"),at.innerHTML=As,ga=s(),p(st.$$.fragment),ba=s(),p(nt.$$.fragment),wa=s(),it=i("p"),it.textContent=Ss,Ma=s(),p(ot.$$.fragment),Ta=s(),rt=i("p"),rt.textContent=Ks,_a=s(),p(pt.$$.fragment),va=s(),dt=i("p"),dt.textContent=Ds,$a=s(),p(mt.$$.fragment),ja=s(),ht=i("p"),ht.textContent=Os,ka=s(),ft=i("p"),ft.innerHTML=en,xa=s(),ut=i("p"),ut.innerHTML=tn,Ja=s(),p(ct.$$.fragment),Za=s(),p(yt.$$.fragment),Ua=s(),gt=i("p"),gt.textContent=ln,Ca=s(),bt=i("p"),bt.textContent=an,Wa=s(),p(wt.$$.fragment),Ba=s(),T=i("blockquote"),T.innerHTML=sn,Ga=s(),Mt=i("p"),Mt.textContent=nn,La=s(),p(Tt.$$.fragment),Fa=s(),_t=i("p"),_t.textContent=on,Ra=s(),p(vt.$$.fragment),Ia=s(),$t=i("p"),$t.textContent=rn,Xa=s(),p(jt.$$.fragment),Va=s(),kt=i("p"),kt.innerHTML=pn,Ha=s(),p(xt.$$.fragment),Ea=s(),_=i("blockquote"),_.innerHTML=dn,Ya=s(),p(Jt.$$.fragment),Pa=s(),Ct=i("p"),this.h()},l(e){const t=gn("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(l),Wt=n(e),Ut=o(e,"P",{}),mn(Ut).forEach(l),Bt=n(e),d(v.$$.fragment,e),Gt=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-wwms7a"&&($.textContent=za),Lt=n(e),d(j.$$.fragment,e),Ft=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-18nlz3r"&&(k.textContent=Na),Rt=n(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-ccv654"&&(x.innerHTML=Aa),It=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1cuqjyb"&&(J.textContent=Sa),Xt=n(e),d(Z.$$.fragment,e),Vt=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-h5ykrw"&&(U.textContent=Ka),Ht=n(e),d(C.$$.fragment,e),Et=n(e),d(W.$$.fragment,e),Yt=n(e),d(B.$$.fragment,e),Pt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-oa0e54"&&(G.innerHTML=Da),qt=n(e),d(L.$$.fragment,e),Qt=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-p7trz1"&&(F.innerHTML=Oa),zt=n(e),d(R.$$.fragment,e),Nt=n(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-iihc0b"&&(b.innerHTML=es),At=n(e),d(I.$$.fragment,e),St=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1w3ww7i"&&(X.textContent=ts),Kt=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wkpq53"&&(V.innerHTML=ls),Dt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-3n96y7"&&(H.textContent=as),Ot=n(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1ghjkcl"&&(E.innerHTML=ss),el=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1yqgo19"&&(Y.textContent=ns),tl=n(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-pdypmd"&&(P.innerHTML=is),ll=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1gmj2pd"&&(q.textContent=os),al=n(e),d(Q.$$.fragment,e),sl=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ns8zue"&&(z.innerHTML=rs),nl=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-lfc2ft"&&(N.textContent=ps),il=n(e),d(A.$$.fragment,e),ol=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-16feh"&&(S.textContent=ds),rl=n(e),K=o(e,"OL",{"data-svelte-h":!0}),r(K)!=="svelte-1fvhlks"&&(K.innerHTML=ms),pl=n(e),d(D.$$.fragment,e),dl=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-q1qqrd"&&(O.innerHTML=hs),ml=n(e),d(ee.$$.fragment,e),hl=n(e),d(te.$$.fragment,e),fl=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-5heszj"&&(le.innerHTML=fs),ul=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-c4824l"&&(ae.innerHTML=us),cl=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1ou3c35"&&(se.innerHTML=cs),yl=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1g4txs2"&&(ne.textContent=ys),gl=n(e),d(ie.$$.fragment,e),bl=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1fbeum6"&&(oe.innerHTML=gs),wl=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-lmc43w"&&(w.innerHTML=bs),Ml=n(e),d(re.$$.fragment,e),Tl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1ftgm9w"&&(pe.textContent=ws),_l=n(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1cu50cp"&&(de.innerHTML=Ms),vl=n(e),d(me.$$.fragment,e),$l=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-p4bcqv"&&(he.innerHTML=Ts),jl=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-ffklcx"&&(fe.innerHTML=_s),kl=n(e),d(ue.$$.fragment,e),xl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-12n0r5k"&&(ce.innerHTML=vs),Jl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1r5fwm9"&&(ye.innerHTML=$s),Zl=n(e),d(ge.$$.fragment,e),Ul=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1bq6qvj"&&(be.innerHTML=js),Cl=n(e),d(we.$$.fragment,e),Wl=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1lr155g"&&(Me.innerHTML=ks),Bl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1kaw5hl"&&(Te.innerHTML=xs),Gl=n(e),d(_e.$$.fragment,e),Ll=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-nkv7o7"&&(ve.textContent=Js),Fl=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-a0ibfa"&&($e.innerHTML=Zs),Rl=n(e),d(je.$$.fragment,e),Il=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-u2918x"&&(ke.innerHTML=Us),Xl=n(e),d(xe.$$.fragment,e),Vl=n(e),d(Je.$$.fragment,e),Hl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-q2uzbp"&&(Ze.textContent=Cs),El=n(e),Ue=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Ue)!=="svelte-ray7nl"&&(Ue.innerHTML=Ws),Yl=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1cejahg"&&(Ce.innerHTML=Bs),Pl=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-m24cow"&&(We.innerHTML=Gs),ql=n(e),d(Be.$$.fragment,e),Ql=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1c6v178"&&(Ge.innerHTML=Ls),zl=n(e),d(Le.$$.fragment,e),Nl=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-f59lgd"&&(Fe.textContent=Fs),Al=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-k7fvy1"&&(Re.innerHTML=Rs),Sl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-16spx00"&&(Ie.textContent=Is),Kl=n(e),d(Xe.$$.fragment,e),Dl=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1f0hxdh"&&(Ve.innerHTML=Xs),Ol=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1ygf8mz"&&(He.innerHTML=Vs),ea=n(e),d(Ee.$$.fragment,e),ta=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1gb1r7d"&&(Ye.innerHTML=Hs),la=n(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-19sfzdf"&&(Pe.textContent=Es),aa=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-18r4lni"&&(qe.innerHTML=Ys),sa=n(e),d(Qe.$$.fragment,e),na=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-17rnlhh"&&(ze.innerHTML=Ps),ia=n(e),d(Ne.$$.fragment,e),oa=n(e),d(Ae.$$.fragment,e),ra=n(e),d(Se.$$.fragment,e),pa=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1hc62kc"&&(Ke.innerHTML=qs),da=n(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-gscfhd"&&(M.innerHTML=Qs),ma=n(e),d(De.$$.fragment,e),ha=n(e),d(Oe.$$.fragment,e),fa=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-yt67c7"&&(et.innerHTML=zs),ua=n(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-wblxho"&&(tt.innerHTML=Ns),ca=n(e),d(lt.$$.fragment,e),ya=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1e3stb1"&&(at.innerHTML=As),ga=n(e),d(st.$$.fragment,e),ba=n(e),d(nt.$$.fragment,e),wa=n(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-5zz36e"&&(it.textContent=Ss),Ma=n(e),d(ot.$$.fragment,e),Ta=n(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1dqw1qx"&&(rt.textContent=Ks),_a=n(e),d(pt.$$.fragment,e),va=n(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1k207nl"&&(dt.textContent=Ds),$a=n(e),d(mt.$$.fragment,e),ja=n(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1jt6x31"&&(ht.textContent=Os),ka=n(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1a81pzz"&&(ft.innerHTML=en),xa=n(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1wt4m5g"&&(ut.innerHTML=tn),Ja=n(e),d(ct.$$.fragment,e),Za=n(e),d(yt.$$.fragment,e),Ua=n(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-11stw7g"&&(gt.textContent=ln),Ca=n(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-a9hnjs"&&(bt.textContent=an),Wa=n(e),d(wt.$$.fragment,e),Ba=n(e),T=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-t4lclb"&&(T.innerHTML=sn),Ga=n(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-164a5vl"&&(Mt.textContent=nn),La=n(e),d(Tt.$$.fragment,e),Fa=n(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1p5ltyy"&&(_t.textContent=on),Ra=n(e),d(vt.$$.fragment,e),Ia=n(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-93sdsf"&&($t.textContent=rn),Xa=n(e),d(jt.$$.fragment,e),Va=n(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-176115b"&&(kt.innerHTML=pn),Ha=n(e),d(xt.$$.fragment,e),Ea=n(e),_=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-awfkct"&&(_.innerHTML=dn),Ya=n(e),d(Jt.$$.fragment,e),Pa=n(e),Ct=o(e,"P",{}),mn(Ct).forEach(l),this.h()},h(){Zt(g,"name","hf:doc:metadata"),Zt(g,"content",Tn),Zt(b,"class","tip"),Zt(w,"class","tip"),Zt(M,"class","tip"),Zt(T,"class","tip"),Zt(_,"class","tip")},m(e,t){bn(document.head,g),a(e,Wt,t),a(e,Ut,t),a(e,Bt,t),m(v,e,t),a(e,Gt,t),a(e,$,t),a(e,Lt,t),m(j,e,t),a(e,Ft,t),a(e,k,t),a(e,Rt,t),a(e,x,t),a(e,It,t),a(e,J,t),a(e,Xt,t),m(Z,e,t),a(e,Vt,t),a(e,U,t),a(e,Ht,t),m(C,e,t),a(e,Et,t),m(W,e,t),a(e,Yt,t),m(B,e,t),a(e,Pt,t),a(e,G,t),a(e,qt,t),m(L,e,t),a(e,Qt,t),a(e,F,t),a(e,zt,t),m(R,e,t),a(e,Nt,t),a(e,b,t),a(e,At,t),m(I,e,t),a(e,St,t),a(e,X,t),a(e,Kt,t),a(e,V,t),a(e,Dt,t),a(e,H,t),a(e,Ot,t),a(e,E,t),a(e,el,t),a(e,Y,t),a(e,tl,t),a(e,P,t),a(e,ll,t),a(e,q,t),a(e,al,t),m(Q,e,t),a(e,sl,t),a(e,z,t),a(e,nl,t),a(e,N,t),a(e,il,t),m(A,e,t),a(e,ol,t),a(e,S,t),a(e,rl,t),a(e,K,t),a(e,pl,t),m(D,e,t),a(e,dl,t),a(e,O,t),a(e,ml,t),m(ee,e,t),a(e,hl,t),m(te,e,t),a(e,fl,t),a(e,le,t),a(e,ul,t),a(e,ae,t),a(e,cl,t),a(e,se,t),a(e,yl,t),a(e,ne,t),a(e,gl,t),m(ie,e,t),a(e,bl,t),a(e,oe,t),a(e,wl,t),a(e,w,t),a(e,Ml,t),m(re,e,t),a(e,Tl,t),a(e,pe,t),a(e,_l,t),a(e,de,t),a(e,vl,t),m(me,e,t),a(e,$l,t),a(e,he,t),a(e,jl,t),a(e,fe,t),a(e,kl,t),m(ue,e,t),a(e,xl,t),a(e,ce,t),a(e,Jl,t),a(e,ye,t),a(e,Zl,t),m(ge,e,t),a(e,Ul,t),a(e,be,t),a(e,Cl,t),m(we,e,t),a(e,Wl,t),a(e,Me,t),a(e,Bl,t),a(e,Te,t),a(e,Gl,t),m(_e,e,t),a(e,Ll,t),a(e,ve,t),a(e,Fl,t),a(e,$e,t),a(e,Rl,t),m(je,e,t),a(e,Il,t),a(e,ke,t),a(e,Xl,t),m(xe,e,t),a(e,Vl,t),m(Je,e,t),a(e,Hl,t),a(e,Ze,t),a(e,El,t),a(e,Ue,t),a(e,Yl,t),a(e,Ce,t),a(e,Pl,t),a(e,We,t),a(e,ql,t),m(Be,e,t),a(e,Ql,t),a(e,Ge,t),a(e,zl,t),m(Le,e,t),a(e,Nl,t),a(e,Fe,t),a(e,Al,t),a(e,Re,t),a(e,Sl,t),a(e,Ie,t),a(e,Kl,t),m(Xe,e,t),a(e,Dl,t),a(e,Ve,t),a(e,Ol,t),a(e,He,t),a(e,ea,t),m(Ee,e,t),a(e,ta,t),a(e,Ye,t),a(e,la,t),a(e,Pe,t),a(e,aa,t),a(e,qe,t),a(e,sa,t),m(Qe,e,t),a(e,na,t),a(e,ze,t),a(e,ia,t),m(Ne,e,t),a(e,oa,t),m(Ae,e,t),a(e,ra,t),m(Se,e,t),a(e,pa,t),a(e,Ke,t),a(e,da,t),a(e,M,t),a(e,ma,t),m(De,e,t),a(e,ha,t),m(Oe,e,t),a(e,fa,t),a(e,et,t),a(e,ua,t),a(e,tt,t),a(e,ca,t),m(lt,e,t),a(e,ya,t),a(e,at,t),a(e,ga,t),m(st,e,t),a(e,ba,t),m(nt,e,t),a(e,wa,t),a(e,it,t),a(e,Ma,t),m(ot,e,t),a(e,Ta,t),a(e,rt,t),a(e,_a,t),m(pt,e,t),a(e,va,t),a(e,dt,t),a(e,$a,t),m(mt,e,t),a(e,ja,t),a(e,ht,t),a(e,ka,t),a(e,ft,t),a(e,xa,t),a(e,ut,t),a(e,Ja,t),m(ct,e,t),a(e,Za,t),m(yt,e,t),a(e,Ua,t),a(e,gt,t),a(e,Ca,t),a(e,bt,t),a(e,Wa,t),m(wt,e,t),a(e,Ba,t),a(e,T,t),a(e,Ga,t),a(e,Mt,t),a(e,La,t),m(Tt,e,t),a(e,Fa,t),a(e,_t,t),a(e,Ra,t),m(vt,e,t),a(e,Ia,t),a(e,$t,t),a(e,Xa,t),m(jt,e,t),a(e,Va,t),a(e,kt,t),a(e,Ha,t),m(xt,e,t),a(e,Ea,t),a(e,_,t),a(e,Ya,t),m(Jt,e,t),a(e,Pa,t),a(e,Ct,t),qa=!0},p:fn,i(e){qa||(h(v.$$.fragment,e),h(j.$$.fragment,e),h(Z.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(L.$$.fragment,e),h(R.$$.fragment,e),h(I.$$.fragment,e),h(Q.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(re.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(we.$$.fragment,e),h(_e.$$.fragment,e),h(je.$$.fragment,e),h(xe.$$.fragment,e),h(Je.$$.fragment,e),h(Be.$$.fragment,e),h(Le.$$.fragment,e),h(Xe.$$.fragment,e),h(Ee.$$.fragment,e),h(Qe.$$.fragment,e),h(Ne.$$.fragment,e),h(Ae.$$.fragment,e),h(Se.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(pt.$$.fragment,e),h(mt.$$.fragment,e),h(ct.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(vt.$$.fragment,e),h(jt.$$.fragment,e),h(xt.$$.fragment,e),h(Jt.$$.fragment,e),qa=!0)},o(e){f(v.$$.fragment,e),f(j.$$.fragment,e),f(Z.$$.fragment,e),f(C.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(R.$$.fragment,e),f(I.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(D.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(we.$$.fragment,e),f(_e.$$.fragment,e),f(je.$$.fragment,e),f(xe.$$.fragment,e),f(Je.$$.fragment,e),f(Be.$$.fragment,e),f(Le.$$.fragment,e),f(Xe.$$.fragment,e),f(Ee.$$.fragment,e),f(Qe.$$.fragment,e),f(Ne.$$.fragment,e),f(Ae.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(lt.$$.fragment,e),f(st.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(pt.$$.fragment,e),f(mt.$$.fragment,e),f(ct.$$.fragment,e),f(yt.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f(vt.$$.fragment,e),f(jt.$$.fragment,e),f(xt.$$.fragment,e),f(Jt.$$.fragment,e),qa=!1},d(e){e&&(l(Wt),l(Ut),l(Bt),l(Gt),l($),l(Lt),l(Ft),l(k),l(Rt),l(x),l(It),l(J),l(Xt),l(Vt),l(U),l(Ht),l(Et),l(Yt),l(Pt),l(G),l(qt),l(Qt),l(F),l(zt),l(Nt),l(b),l(At),l(St),l(X),l(Kt),l(V),l(Dt),l(H),l(Ot),l(E),l(el),l(Y),l(tl),l(P),l(ll),l(q),l(al),l(sl),l(z),l(nl),l(N),l(il),l(ol),l(S),l(rl),l(K),l(pl),l(dl),l(O),l(ml),l(hl),l(fl),l(le),l(ul),l(ae),l(cl),l(se),l(yl),l(ne),l(gl),l(bl),l(oe),l(wl),l(w),l(Ml),l(Tl),l(pe),l(_l),l(de),l(vl),l($l),l(he),l(jl),l(fe),l(kl),l(xl),l(ce),l(Jl),l(ye),l(Zl),l(Ul),l(be),l(Cl),l(Wl),l(Me),l(Bl),l(Te),l(Gl),l(Ll),l(ve),l(Fl),l($e),l(Rl),l(Il),l(ke),l(Xl),l(Vl),l(Hl),l(Ze),l(El),l(Ue),l(Yl),l(Ce),l(Pl),l(We),l(ql),l(Ql),l(Ge),l(zl),l(Nl),l(Fe),l(Al),l(Re),l(Sl),l(Ie),l(Kl),l(Dl),l(Ve),l(Ol),l(He),l(ea),l(ta),l(Ye),l(la),l(Pe),l(aa),l(qe),l(sa),l(na),l(ze),l(ia),l(oa),l(ra),l(pa),l(Ke),l(da),l(M),l(ma),l(ha),l(fa),l(et),l(ua),l(tt),l(ca),l(ya),l(at),l(ga),l(ba),l(wa),l(it),l(Ma),l(Ta),l(rt),l(_a),l(va),l(dt),l($a),l(ja),l(ht),l(ka),l(ft),l(xa),l(ut),l(Ja),l(Za),l(Ua),l(gt),l(Ca),l(bt),l(Wa),l(Ba),l(T),l(Ga),l(Mt),l(La),l(Fa),l(_t),l(Ra),l(Ia),l($t),l(Xa),l(Va),l(kt),l(Ha),l(Ea),l(_),l(Ya),l(Pa),l(Ct)),l(g),u(v,e),u(j,e),u(Z,e),u(C,e),u(W,e),u(B,e),u(L,e),u(R,e),u(I,e),u(Q,e),u(A,e),u(D,e),u(ee,e),u(te,e),u(ie,e),u(re,e),u(me,e),u(ue,e),u(ge,e),u(we,e),u(_e,e),u(je,e),u(xe,e),u(Je,e),u(Be,e),u(Le,e),u(Xe,e),u(Ee,e),u(Qe,e),u(Ne,e),u(Ae,e),u(Se,e),u(De,e),u(Oe,e),u(lt,e),u(st,e),u(nt,e),u(ot,e),u(pt,e),u(mt,e),u(ct,e),u(yt,e),u(wt,e),u(Tt,e),u(vt,e),u(jt,e),u(xt,e),u(Jt,e)}}}const Tn='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"Dtype-related issues","local":"dtype-related-issues","sections":[{"title":"ValueError: Attempting to unscale FP16 gradients","local":"valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":3},{"title":"Selecting the dtype of the adapter","local":"selecting-the-dtype-of-the-adapter","sections":[],"depth":3}],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[{"title":"Using trainable tokens","local":"using-trainable-tokens","sections":[],"depth":4},{"title":"Using an adapter, e.g. LoRA","local":"using-an-adapter-eg-lora","sections":[],"depth":4},{"title":"Full fine-tuning","local":"full-fine-tuning","sections":[],"depth":4}],"depth":3},{"title":"Getting a warning about “weights not being initialized from the model checkpoint”","local":"getting-a-warning-about-weights-not-being-initialized-from-the-model-checkpoint","sections":[],"depth":3},{"title":"Check layer and model status","local":"check-layer-and-model-status","sections":[],"depth":3}],"depth":2},{"title":"Speed","local":"speed","sections":[{"title":"Loading adapter weights is slow","local":"loading-adapter-weights-is-slow","sections":[],"depth":3}],"depth":2},{"title":"Reproducibility","local":"reproducibility","sections":[{"title":"Models using batch norm","local":"models-using-batch-norm","sections":[],"depth":3}],"depth":2},{"title":"Version mismatch","local":"version-mismatch","sections":[{"title":"Error while loading the config because of an unexpected keyword argument","local":"error-while-loading-the-config-because-of-an-unexpected-keyword-argument","sections":[],"depth":3}],"depth":2},{"title":"Adapter handling","local":"adapter-handling","sections":[{"title":"Using multiple adapters at the same time","local":"using-multiple-adapters-at-the-same-time","sections":[],"depth":3}],"depth":2}],"depth":1}';function _n(Qa){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xn extends cn{constructor(g){super(),yn(this,g,_n,Mn,hn,{})}}export{xn as component};
