import{s as Et,o as Nt,n as Ut}from"../chunks/scheduler.4cd3e004.js";import{S as Ht,i as qt,e as d,s as n,c as h,h as Lt,a as y,d as a,b as o,f as Vt,g as f,j as b,k as be,l as St,m as l,n as u,t as J,o as U,p as w}from"../chunks/index.b664cb2d.js";import{C as j}from"../chunks/CodeBlock.8601e34e.js";import{H as we,E as Dt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";import{H as Pt,a as Jt}from"../chunks/HfOption.7d47ae41.js";function Kt(C){let r,g='<a href="../conceptual_guides/adapter#low-rank-adaptation-lora">LoRA</a> decomposes the weight update matrix into <em>two</em> smaller matrices. The size of these low-rank matrices is determined by its <em>rank</em> or <code>r</code>. A higher rank means the model has more parameters to train, but it also means the model has more learning capacity. You’ll also want to specify the <code>target_modules</code> which determine where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>lora_alpha</code> (scaling factor), <code>bias</code> (whether <code>none</code>, <code>all</code> or only the LoRA bias parameters should be trained), and <code>modules_to_save</code> (the modules apart from the LoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>.',c,i,m;return i=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQW1vZGVsLnByaW50X3RyYWluYWJsZV9wYXJhbWV0ZXJzKCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2NjclMkM0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NiUyQzU0MyUyQzgxOCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzcxMjc3NTA0NzY2NDI5NCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 667,493 || all params: 86,543,818 || trainable%: 0.7712775047664294&quot;</span>`,wrap:!1}}),{c(){r=d("p"),r.innerHTML=g,c=n(),h(i.$$.fragment)},l(s){r=y(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1gwq7xr"&&(r.innerHTML=g),c=o(s),f(i.$$.fragment,s)},m(s,M){l(s,r,M),l(s,c,M),u(i,s,M),m=!0},p:Ut,i(s){m||(J(i.$$.fragment,s),m=!0)},o(s){U(i.$$.fragment,s),m=!1},d(s){s&&(a(r),a(c)),w(i,s)}}}function Ot(C){let r,g='<a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">LoHa</a> decomposes the weight update matrix into <em>four</em> smaller matrices and each pair of smaller matrices is combined with the Hadamard product. This allows the weight update matrix to keep the same number of trainable parameters when compared to LoRA, but with a higher rank (<code>r^2</code> for LoHA when compared to <code>2*r</code> for LoRA). The size of the smaller matrices is determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoHa layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/main/en/package_reference/loha#peft.LoHaConfig">LoHaConfig</a>.',c,i,m;return i=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0hhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0hhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMSUyQzI1NyUyQzMxNyUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDg3JTJDMTMzJTJDNjQyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS40NDI5NzUzNzc5ODMxNjc2JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoHaConfig, get_peft_model

config = LoHaConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 1,257,317 || all params: 87,133,642 || trainable%: 1.4429753779831676&quot;</span>`,wrap:!1}}),{c(){r=d("p"),r.innerHTML=g,c=n(),h(i.$$.fragment)},l(s){r=y(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-17t05gw"&&(r.innerHTML=g),c=o(s),f(i.$$.fragment,s)},m(s,M){l(s,r,M),l(s,c,M),u(i,s,M),m=!0},p:Ut,i(s){m||(J(i.$$.fragment,s),m=!0)},o(s){U(i.$$.fragment,s),m=!1},d(s){s&&(a(r),a(c)),w(i,s)}}}function ea(C){let r,g='<a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">LoKr</a> expresses the weight update matrix as a decomposition of a Kronecker product, creating a block matrix that is able to preserve the rank of the original weight matrix. The size of the smaller matrices are determined by its <em>rank</em> or <code>r</code>. You’ll also want to specify the <code>target_modules</code> which determines where the smaller matrices are inserted. For this guide, you’ll target the <em>query</em> and <em>value</em> matrices of the attention blocks. Other important parameters to set are <code>alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the LoKr layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/main/en/package_reference/lokr#peft.LoKrConfig">LoKrConfig</a>.',c,i,m;return i=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb0tyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb0tyQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnF1ZXJ5JTIyJTJDJTIwJTIydmFsdWUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMTE2JTJDMDY5JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkMxNzIlMkMwNDIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjEzMzE0OTM0MTYyMDMzMjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoKrConfig, get_peft_model

config = LoKrConfig(
    r=<span class="hljs-number">16</span>,
    alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    module_dropout=<span class="hljs-number">0.1</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 116,069 || all params: 87,172,042 || trainable%: 0.13314934162033282&quot;</span>`,wrap:!1}}),{c(){r=d("p"),r.innerHTML=g,c=n(),h(i.$$.fragment)},l(s){r=y(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-171fmsp"&&(r.innerHTML=g),c=o(s),f(i.$$.fragment,s)},m(s,M){l(s,r,M),l(s,c,M),u(i,s,M),m=!0},p:Ut,i(s){m||(J(i.$$.fragment,s),m=!0)},o(s){U(i.$$.fragment,s),m=!1},d(s){s&&(a(r),a(c)),w(i,s)}}}function ta(C){let r,g='<a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">AdaLoRA</a> efficiently manages the LoRA parameter budget by assigning important weight matrices more parameters and pruning less important ones. In contrast, LoRA evenly distributes parameters across all modules. You can control the average desired <em>rank</em> or <code>r</code> of the matrices, and which modules to apply AdaLoRA to with <code>target_modules</code>. Other important parameters to set are <code>lora_alpha</code> (scaling factor), and <code>modules_to_save</code> (the modules apart from the AdaLoRA layers to be trained and saved). All of these parameters - and more - are found in the <a href="/docs/peft/main/en/package_reference/adalora#peft.AdaLoraConfig">AdaLoraConfig</a>.',c,i,m;return i=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBZGFMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBBZGFMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwaW5pdF9yJTNEMTIlMkMlMEElMjAlMjAlMjAlMjB0aW5pdCUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRmaW5hbCUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBkZWx0YVQlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTIwJTJDMzI1JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwODclMkM2MTQlMkM3MjIlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjU5Mzg3ODUwMzY2MDYwNjIlMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AdaLoraConfig, get_peft_model

config = AdaLoraConfig(
    r=<span class="hljs-number">8</span>,
    init_r=<span class="hljs-number">12</span>,
    tinit=<span class="hljs-number">200</span>,
    tfinal=<span class="hljs-number">1000</span>,
    deltaT=<span class="hljs-number">10</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
model = get_peft_model(model, config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 520,325 || all params: 87,614,722 || trainable%: 0.5938785036606062&quot;</span>`,wrap:!1}}),{c(){r=d("p"),r.innerHTML=g,c=n(),h(i.$$.fragment)},l(s){r=y(s,"P",{"data-svelte-h":!0}),b(r)!=="svelte-7hro09"&&(r.innerHTML=g),c=o(s),f(i.$$.fragment,s)},m(s,M){l(s,r,M),l(s,c,M),u(i,s,M),m=!0},p:Ut,i(s){m||(J(i.$$.fragment,s),m=!0)},o(s){U(i.$$.fragment,s),m=!1},d(s){s&&(a(r),a(c)),w(i,s)}}}function aa(C){let r,g,c,i,m,s,M,B;return r=new Jt({props:{id:"loras",option:"LoRA",$$slots:{default:[Kt]},$$scope:{ctx:C}}}),c=new Jt({props:{id:"loras",option:"LoHa",$$slots:{default:[Ot]},$$scope:{ctx:C}}}),m=new Jt({props:{id:"loras",option:"LoKr",$$slots:{default:[ea]},$$scope:{ctx:C}}}),M=new Jt({props:{id:"loras",option:"AdaLoRA",$$slots:{default:[ta]},$$scope:{ctx:C}}}),{c(){h(r.$$.fragment),g=n(),h(c.$$.fragment),i=n(),h(m.$$.fragment),s=n(),h(M.$$.fragment)},l(p){f(r.$$.fragment,p),g=o(p),f(c.$$.fragment,p),i=o(p),f(m.$$.fragment,p),s=o(p),f(M.$$.fragment,p)},m(p,T){u(r,p,T),l(p,g,T),u(c,p,T),l(p,i,T),u(m,p,T),l(p,s,T),u(M,p,T),B=!0},p(p,T){const Te={};T&2&&(Te.$$scope={dirty:T,ctx:p}),r.$set(Te);const v={};T&2&&(v.$$scope={dirty:T,ctx:p}),c.$set(v);const Z={};T&2&&(Z.$$scope={dirty:T,ctx:p}),m.$set(Z);const ge={};T&2&&(ge.$$scope={dirty:T,ctx:p}),M.$set(ge)},i(p){B||(J(r.$$.fragment,p),J(c.$$.fragment,p),J(m.$$.fragment,p),J(M.$$.fragment,p),B=!0)},o(p){U(r.$$.fragment,p),U(c.$$.fragment,p),U(m.$$.fragment,p),U(M.$$.fragment,p),B=!1},d(p){p&&(a(g),a(i),a(s)),w(r,p),w(c,p),w(m,p),w(M,p)}}}function la(C){let r,g,c,i,m,s,M,B="A popular way to efficiently train large models is to insert (typically in the attention blocks) smaller trainable matrices that are a low-rank decomposition of the delta weight matrix to be learnt during finetuning. The pretrained model’s original weight matrix is frozen and only the smaller matrices are updated during training. This reduces the number of trainable parameters, reducing memory usage and training time which can be very expensive for large models.",p,T,Te='There are several different ways to express the weight matrix as a low-rank decomposition, but <a href="../conceptual_guides/adapter#low-rank-adaptation-lora">Low-Rank Adaptation (LoRA)</a> is the most common method. The PEFT library supports several other LoRA variants, such as <a href="../conceptual_guides/adapter#low-rank-hadamard-product-loha">Low-Rank Hadamard Product (LoHa)</a>, <a href="../conceptual_guides/adapter#low-rank-kronecker-product-lokr">Low-Rank Kronecker Product (LoKr)</a>, and <a href="../conceptual_guides/adapter#adaptive-low-rank-adaptation-adalora">Adaptive Low-Rank Adaptation (AdaLoRA)</a>. You can learn more about how these methods work conceptually in the <a href="../conceptual_guides/adapter">Adapters</a> guide. If you’re interested in applying these methods to other tasks and use cases like semantic segmentation, token classification, take a look at our <a href="https://huggingface.co/collections/PEFT/notebooks-6573b28b33e5a4bf5b157fc1" rel="nofollow">notebook collection</a>!',v,Z,ge='Additionally, PEFT supports the <a href="../conceptual_guides/adapter#mixture-of-lora-experts-x-lora">X-LoRA</a> Mixture of LoRA Experts method.',Ce,Q,wt="This guide will show you how to quickly train an image classification model - with a low-rank decomposition method - to identify the class of food shown in an image.",Ze,_,bt='<p>Some familiarity with the general process of training an image classification model would be really helpful and allow you to focus on the low-rank decomposition methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/image_classification" rel="nofollow">Image classification</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!</p>',_e,R,Tt="Before you begin, make sure you have all the necessary libraries installed.",$e,G,Ie,X,ke,F,gt='In this guide, you’ll use the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101</a> dataset which contains images of 101 food classes (take a look at the <a href="https://huggingface.co/datasets/food101/viewer/default/train" rel="nofollow">dataset viewer</a> to get a better idea of what the dataset looks like).',We,Y,jt='Load the dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function.',Be,A,ve,z,Ct="Each food class is labeled with an integer, so to make it easier to understand what these integers represent, you’ll create a <code>label2id</code> and <code>id2label</code> dictionary to map the integer to its class label.",Qe,x,Re,V,Zt="Load an image processor to properly resize and normalize the pixel values of the training and evaluation images.",Ge,E,Xe,N,_t="You can also use the image processor to prepare some transformation functions for data augmentation and pixel scaling.",Fe,H,Ye,q,$t='Define the training and validation datasets, and use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.set_transform" rel="nofollow">set_transform</a> function to apply the transformations on-the-fly.',Ae,L,ze,S,It="Finally, you’ll need a data collator to create a batch of training and evaluation data and convert the labels to <code>torch.tensor</code> objects.",xe,D,Ve,P,Ee,K,kt='Now let’s load a pretrained model to use as the base model. This guide uses the <a href="https://huggingface.co/google/vit-base-patch16-224-in21k" rel="nofollow">google/vit-base-patch16-224-in21k</a> model, but you can use any image classification model you want. Pass the <code>label2id</code> and <code>id2label</code> dictionaries to the model so it knows how to map the integer labels to their class labels, and you can optionally pass the <code>ignore_mismatched_sizes=True</code> parameter if you’re finetuning a checkpoint that has already been finetuned.',Ne,O,He,ee,qe,te,Wt='Every PEFT method requires a configuration that holds all the parameters specifying how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Le,$,Bt='<p>Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of parameters of <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!</p>',Se,I,De,ae,Pe,le,vt='For training, let’s use the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class from Transformers. The <code>Trainer</code> contains a PyTorch training loop, and when you’re ready, call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training. To customize the training run, configure the training hyperparameters in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class. With LoRA-like methods, you can afford to use a higher batch size and learning rate.',Ke,k,Qt='<p>AdaLoRA has an <a href="/docs/peft/main/en/package_reference/adalora#peft.AdaLoraModel.update_and_allocate">update_and_allocate()</a> method that should be called at each training step to update the parameter budget and mask, otherwise the adaptation step is not performed. This requires writing a custom training loop or subclassing the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to incorporate this method. As an example, take a look at this <a href="https://github.com/huggingface/peft/blob/912ad41e96e03652cabf47522cd876076f7a0c4f/examples/conditional_generation/peft_adalora_seq2seq.py#L120" rel="nofollow">custom training loop</a>.</p>',Oe,se,et,ne,Rt='Begin training with <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a>.',tt,oe,at,re,lt,ie,Gt='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',st,pe,nt,me,Xt='Call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> to save your model to your repositoy.',ot,ce,rt,Me,it,de,Ft="Let’s load the model from the Hub and test it out on a food image.",pt,ye,mt,W,Yt='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg"/>',ct,he,At="Convert the image to RGB and return the underlying PyTorch tensors.",Mt,fe,dt,ue,zt="Now run the model and return the predicted class!",yt,Je,ht,Ue,ft,je,ut;return m=new we({props:{title:"LoRA methods",local:"lora-methods",headingTag:"h1"}}),G=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),X=new we({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),A=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)`,wrap:!1}}),x=new j({props:{code:"bGFiZWxzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),E=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQtaW4yMWslMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>)`,wrap:!1}}),H=new j({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ2VudGVyQ3JvcCUyQyUwQSUyMCUyMCUyMCUyMENvbXBvc2UlMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVJlc2l6ZWRDcm9wJTJDJTBBJTIwJTIwJTIwJTIwUmVzaXplJTJDJTBBJTIwJTIwJTIwJTIwVG9UZW5zb3IlMkMlMEEpJTBBJTBBbm9ybWFsaXplJTIwJTNEJTIwTm9ybWFsaXplKG1lYW4lM0RpbWFnZV9wcm9jZXNzb3IuaW1hZ2VfbWVhbiUyQyUyMHN0ZCUzRGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9zdGQpJTBBdHJhaW5fdHJhbnNmb3JtcyUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tUmVzaXplZENyb3AoaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJoZWlnaHQlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX3RyYW5zZm9ybXMlMjAlM0QlMjBDb21wb3NlKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDZW50ZXJDcm9wKGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyaGVpZ2h0JTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemUlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVfYmF0Y2glNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjAlNUJ0cmFpbl90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaCUwQSUwQWRlZiUyMHByZXByb2Nlc3NfdmFsKGV4YW1wbGVfYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZV9iYXRjaCU1QiUyMnBpeGVsX3ZhbHVlcyUyMiU1RCUyMCUzRCUyMCU1QnZhbF90cmFuc2Zvcm1zKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZV9iYXRjaCU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZV9iYXRjaA==",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),L=new j({props:{code:"dHJhaW5fZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTBBJTBBdHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = ds[<span class="hljs-string">&quot;validation&quot;</span>]

train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),D=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),P=new we({props:{title:"Model",local:"model",headingTag:"h2"}}),O=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),ee=new we({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),I=new Pt({props:{id:"loras",options:["LoRA","LoHa","LoKr","AdaLoRA"],$$slots:{default:[aa]},$$scope:{ctx:C}}}),ae=new we({props:{title:"Training",local:"training",headingTag:"h3"}}),se=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQWFjY291bnQlMjAlM0QlMjAlMjJzdGV2aGxpdSUyMiUwQXBlZnRfbW9kZWxfaWQlMjAlM0QlMjBmJTIyJTdCYWNjb3VudCU3RCUyRmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrLWxvcmElMjIlMEFiYXRjaF9zaXplJTIwJTNEJTIwMTI4JTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMHBlZnRfbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS0zJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9uYW1lcyUzRCU1QiUyMmxhYmVscyUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

account = <span class="hljs-string">&quot;stevhliu&quot;</span>
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/google/vit-base-patch16-224-in21k-lora&quot;</span>
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    peft_model_id,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),oe=new j({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdmFsX2RzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer = Trainer(
    model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    processing_class=image_processor,
    data_collator=collate_fn,
)
trainer.train()`,wrap:!1}}),re=new we({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),pe=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ce=new j({props:{code:"bW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:"model.push_to_hub(peft_model_id)",wrap:!1}}),Me=new we({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ye=new j({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKG1vZGVsJTJDJTIwJTIyc3RldmhsaXUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxay1sb3JhJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNheWFrcGF1bCUyRnNhbXBsZS1kYXRhc2V0cyUyRnJlc29sdmUlMkZtYWluJTJGYmVpZ25ldHMuanBlZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

config = PeftConfig.from_pretrained(<span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
)
model = PeftModel.from_pretrained(model, <span class="hljs-string">&quot;stevhliu/vit-base-patch16-224-in21k-lora&quot;</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),fe=new j({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Je=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCklMEElMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMGJlaWduZXRzJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),Ue=new Dt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/lora_based_methods.md"}}),{c(){r=d("meta"),g=n(),c=d("p"),i=n(),h(m.$$.fragment),s=n(),M=d("p"),M.textContent=B,p=n(),T=d("p"),T.innerHTML=Te,v=n(),Z=d("p"),Z.innerHTML=ge,Ce=n(),Q=d("p"),Q.textContent=wt,Ze=n(),_=d("blockquote"),_.innerHTML=bt,_e=n(),R=d("p"),R.textContent=Tt,$e=n(),h(G.$$.fragment),Ie=n(),h(X.$$.fragment),ke=n(),F=d("p"),F.innerHTML=gt,We=n(),Y=d("p"),Y.innerHTML=jt,Be=n(),h(A.$$.fragment),ve=n(),z=d("p"),z.innerHTML=Ct,Qe=n(),h(x.$$.fragment),Re=n(),V=d("p"),V.textContent=Zt,Ge=n(),h(E.$$.fragment),Xe=n(),N=d("p"),N.textContent=_t,Fe=n(),h(H.$$.fragment),Ye=n(),q=d("p"),q.innerHTML=$t,Ae=n(),h(L.$$.fragment),ze=n(),S=d("p"),S.innerHTML=It,xe=n(),h(D.$$.fragment),Ve=n(),h(P.$$.fragment),Ee=n(),K=d("p"),K.innerHTML=kt,Ne=n(),h(O.$$.fragment),He=n(),h(ee.$$.fragment),qe=n(),te=d("p"),te.innerHTML=Wt,Le=n(),$=d("blockquote"),$.innerHTML=Bt,Se=n(),h(I.$$.fragment),De=n(),h(ae.$$.fragment),Pe=n(),le=d("p"),le.innerHTML=vt,Ke=n(),k=d("blockquote"),k.innerHTML=Qt,Oe=n(),h(se.$$.fragment),et=n(),ne=d("p"),ne.innerHTML=Rt,tt=n(),h(oe.$$.fragment),at=n(),h(re.$$.fragment),lt=n(),ie=d("p"),ie.innerHTML=Gt,st=n(),h(pe.$$.fragment),nt=n(),me=d("p"),me.innerHTML=Xt,ot=n(),h(ce.$$.fragment),rt=n(),h(Me.$$.fragment),it=n(),de=d("p"),de.textContent=Ft,pt=n(),h(ye.$$.fragment),mt=n(),W=d("div"),W.innerHTML=Yt,ct=n(),he=d("p"),he.textContent=At,Mt=n(),h(fe.$$.fragment),dt=n(),ue=d("p"),ue.textContent=zt,yt=n(),h(Je.$$.fragment),ht=n(),h(Ue.$$.fragment),ft=n(),je=d("p"),this.h()},l(e){const t=Lt("svelte-u9bgzb",document.head);r=y(t,"META",{name:!0,content:!0}),t.forEach(a),g=o(e),c=y(e,"P",{}),Vt(c).forEach(a),i=o(e),f(m.$$.fragment,e),s=o(e),M=y(e,"P",{"data-svelte-h":!0}),b(M)!=="svelte-3c4mx2"&&(M.textContent=B),p=o(e),T=y(e,"P",{"data-svelte-h":!0}),b(T)!=="svelte-1mec8a1"&&(T.innerHTML=Te),v=o(e),Z=y(e,"P",{"data-svelte-h":!0}),b(Z)!=="svelte-wawyyc"&&(Z.innerHTML=ge),Ce=o(e),Q=y(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-3yvnz9"&&(Q.textContent=wt),Ze=o(e),_=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(_)!=="svelte-bg3xwr"&&(_.innerHTML=bt),_e=o(e),R=y(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-1rdzhb1"&&(R.textContent=Tt),$e=o(e),f(G.$$.fragment,e),Ie=o(e),f(X.$$.fragment,e),ke=o(e),F=y(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-l33v6t"&&(F.innerHTML=gt),We=o(e),Y=y(e,"P",{"data-svelte-h":!0}),b(Y)!=="svelte-zwwqy7"&&(Y.innerHTML=jt),Be=o(e),f(A.$$.fragment,e),ve=o(e),z=y(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-1a5q7dy"&&(z.innerHTML=Ct),Qe=o(e),f(x.$$.fragment,e),Re=o(e),V=y(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-13cytaa"&&(V.textContent=Zt),Ge=o(e),f(E.$$.fragment,e),Xe=o(e),N=y(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1p1x6w4"&&(N.textContent=_t),Fe=o(e),f(H.$$.fragment,e),Ye=o(e),q=y(e,"P",{"data-svelte-h":!0}),b(q)!=="svelte-xbqbtr"&&(q.innerHTML=$t),Ae=o(e),f(L.$$.fragment,e),ze=o(e),S=y(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-mznco7"&&(S.innerHTML=It),xe=o(e),f(D.$$.fragment,e),Ve=o(e),f(P.$$.fragment,e),Ee=o(e),K=y(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-akpunr"&&(K.innerHTML=kt),Ne=o(e),f(O.$$.fragment,e),He=o(e),f(ee.$$.fragment,e),qe=o(e),te=y(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-1c5a83e"&&(te.innerHTML=Wt),Le=o(e),$=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b($)!=="svelte-149555a"&&($.innerHTML=Bt),Se=o(e),f(I.$$.fragment,e),De=o(e),f(ae.$$.fragment,e),Pe=o(e),le=y(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-wcjxic"&&(le.innerHTML=vt),Ke=o(e),k=y(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),b(k)!=="svelte-87y1jb"&&(k.innerHTML=Qt),Oe=o(e),f(se.$$.fragment,e),et=o(e),ne=y(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-ntqszh"&&(ne.innerHTML=Rt),tt=o(e),f(oe.$$.fragment,e),at=o(e),f(re.$$.fragment,e),lt=o(e),ie=y(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-vaxac6"&&(ie.innerHTML=Gt),st=o(e),f(pe.$$.fragment,e),nt=o(e),me=y(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-1qc4exu"&&(me.innerHTML=Xt),ot=o(e),f(ce.$$.fragment,e),rt=o(e),f(Me.$$.fragment,e),it=o(e),de=y(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-1whrqzq"&&(de.textContent=Ft),pt=o(e),f(ye.$$.fragment,e),mt=o(e),W=y(e,"DIV",{class:!0,"data-svelte-h":!0}),b(W)!=="svelte-sucph9"&&(W.innerHTML=Yt),ct=o(e),he=y(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1nlb27h"&&(he.textContent=At),Mt=o(e),f(fe.$$.fragment,e),dt=o(e),ue=y(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-1mvhoi"&&(ue.textContent=zt),yt=o(e),f(Je.$$.fragment,e),ht=o(e),f(Ue.$$.fragment,e),ft=o(e),je=y(e,"P",{}),Vt(je).forEach(a),this.h()},h(){be(r,"name","hf:doc:metadata"),be(r,"content",sa),be(_,"class","tip"),be($,"class","tip"),be(k,"class","warning"),be(W,"class","flex justify-center")},m(e,t){St(document.head,r),l(e,g,t),l(e,c,t),l(e,i,t),u(m,e,t),l(e,s,t),l(e,M,t),l(e,p,t),l(e,T,t),l(e,v,t),l(e,Z,t),l(e,Ce,t),l(e,Q,t),l(e,Ze,t),l(e,_,t),l(e,_e,t),l(e,R,t),l(e,$e,t),u(G,e,t),l(e,Ie,t),u(X,e,t),l(e,ke,t),l(e,F,t),l(e,We,t),l(e,Y,t),l(e,Be,t),u(A,e,t),l(e,ve,t),l(e,z,t),l(e,Qe,t),u(x,e,t),l(e,Re,t),l(e,V,t),l(e,Ge,t),u(E,e,t),l(e,Xe,t),l(e,N,t),l(e,Fe,t),u(H,e,t),l(e,Ye,t),l(e,q,t),l(e,Ae,t),u(L,e,t),l(e,ze,t),l(e,S,t),l(e,xe,t),u(D,e,t),l(e,Ve,t),u(P,e,t),l(e,Ee,t),l(e,K,t),l(e,Ne,t),u(O,e,t),l(e,He,t),u(ee,e,t),l(e,qe,t),l(e,te,t),l(e,Le,t),l(e,$,t),l(e,Se,t),u(I,e,t),l(e,De,t),u(ae,e,t),l(e,Pe,t),l(e,le,t),l(e,Ke,t),l(e,k,t),l(e,Oe,t),u(se,e,t),l(e,et,t),l(e,ne,t),l(e,tt,t),u(oe,e,t),l(e,at,t),u(re,e,t),l(e,lt,t),l(e,ie,t),l(e,st,t),u(pe,e,t),l(e,nt,t),l(e,me,t),l(e,ot,t),u(ce,e,t),l(e,rt,t),u(Me,e,t),l(e,it,t),l(e,de,t),l(e,pt,t),u(ye,e,t),l(e,mt,t),l(e,W,t),l(e,ct,t),l(e,he,t),l(e,Mt,t),u(fe,e,t),l(e,dt,t),l(e,ue,t),l(e,yt,t),u(Je,e,t),l(e,ht,t),u(Ue,e,t),l(e,ft,t),l(e,je,t),ut=!0},p(e,[t]){const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),I.$set(xt)},i(e){ut||(J(m.$$.fragment,e),J(G.$$.fragment,e),J(X.$$.fragment,e),J(A.$$.fragment,e),J(x.$$.fragment,e),J(E.$$.fragment,e),J(H.$$.fragment,e),J(L.$$.fragment,e),J(D.$$.fragment,e),J(P.$$.fragment,e),J(O.$$.fragment,e),J(ee.$$.fragment,e),J(I.$$.fragment,e),J(ae.$$.fragment,e),J(se.$$.fragment,e),J(oe.$$.fragment,e),J(re.$$.fragment,e),J(pe.$$.fragment,e),J(ce.$$.fragment,e),J(Me.$$.fragment,e),J(ye.$$.fragment,e),J(fe.$$.fragment,e),J(Je.$$.fragment,e),J(Ue.$$.fragment,e),ut=!0)},o(e){U(m.$$.fragment,e),U(G.$$.fragment,e),U(X.$$.fragment,e),U(A.$$.fragment,e),U(x.$$.fragment,e),U(E.$$.fragment,e),U(H.$$.fragment,e),U(L.$$.fragment,e),U(D.$$.fragment,e),U(P.$$.fragment,e),U(O.$$.fragment,e),U(ee.$$.fragment,e),U(I.$$.fragment,e),U(ae.$$.fragment,e),U(se.$$.fragment,e),U(oe.$$.fragment,e),U(re.$$.fragment,e),U(pe.$$.fragment,e),U(ce.$$.fragment,e),U(Me.$$.fragment,e),U(ye.$$.fragment,e),U(fe.$$.fragment,e),U(Je.$$.fragment,e),U(Ue.$$.fragment,e),ut=!1},d(e){e&&(a(g),a(c),a(i),a(s),a(M),a(p),a(T),a(v),a(Z),a(Ce),a(Q),a(Ze),a(_),a(_e),a(R),a($e),a(Ie),a(ke),a(F),a(We),a(Y),a(Be),a(ve),a(z),a(Qe),a(Re),a(V),a(Ge),a(Xe),a(N),a(Fe),a(Ye),a(q),a(Ae),a(ze),a(S),a(xe),a(Ve),a(Ee),a(K),a(Ne),a(He),a(qe),a(te),a(Le),a($),a(Se),a(De),a(Pe),a(le),a(Ke),a(k),a(Oe),a(et),a(ne),a(tt),a(at),a(lt),a(ie),a(st),a(nt),a(me),a(ot),a(rt),a(it),a(de),a(pt),a(mt),a(W),a(ct),a(he),a(Mt),a(dt),a(ue),a(yt),a(ht),a(ft),a(je)),a(r),w(m,e),w(G,e),w(X,e),w(A,e),w(x,e),w(E,e),w(H,e),w(L,e),w(D,e),w(P,e),w(O,e),w(ee,e),w(I,e),w(ae,e),w(se,e),w(oe,e),w(re,e),w(pe,e),w(ce,e),w(Me,e),w(ye,e),w(fe,e),w(Je,e),w(Ue,e)}}}const sa='{"title":"LoRA methods","local":"lora-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function na(C){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ca extends Ht{constructor(r){super(),qt(this,r,na,la,Et,{})}}export{ca as component};
