import{s as gt,o as _t,n as at}from"../chunks/scheduler.4cd3e004.js";import{S as Zt,i as kt,e as c,s as n,c as u,h as Bt,a as d,d as e,b as p,f as Ct,g as J,j as U,k as Jl,l as Gt,m as s,n as y,t as T,o as h,p as w}from"../chunks/index.b664cb2d.js";import{C}from"../chunks/CodeBlock.8601e34e.js";import{H as cl,E as Wt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";import{H as Vt,a as st}from"../chunks/HfOption.7d47ae41.js";function Xt(g){let i,b='<a href="../conceptual_guides/prompting#p-tuning">P-tuning</a> adds a trainable embedding tensor where the prompt tokens can be added anywhere in the input sequence. Create a <a href="/docs/peft/main/en/package_reference/p_tuning#peft.PromptEncoderConfig">PromptEncoderConfig</a> with the task type, the number of virtual tokens to add and learn, and the hidden size of the encoder for learning the prompt parameters.',r,M,m;return M=new C({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRFbmNvZGVyQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMFByb21wdEVuY29kZXJDb25maWcodGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTIwbnVtX3ZpcnR1YWxfdG9rZW5zJTNEMjAlMkMlMjBlbmNvZGVyX2hpZGRlbl9zaXplJTNEMTI4KSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMzAwJTJDMjg4JTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTU5JTJDNTE0JTJDODgwJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4wNTM2NjkzNTAxMzQxNzMzOCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptEncoderConfig, get_peft_model

peft_config = PromptEncoderConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>, encoder_hidden_size=<span class="hljs-number">128</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 300,288 || all params: 559,514,880 || trainable%: 0.05366935013417338&quot;</span>`,wrap:!1}}),{c(){i=c("p"),i.innerHTML=b,r=n(),u(M.$$.fragment)},l(o){i=d(o,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1xwh8g2"&&(i.innerHTML=b),r=p(o),J(M.$$.fragment,o)},m(o,a){s(o,i,a),s(o,r,a),y(M,o,a),m=!0},p:at,i(o){m||(T(M.$$.fragment,o),m=!0)},o(o){h(M.$$.fragment,o),m=!1},d(o){o&&(e(i),e(r)),w(M,o)}}}function $t(g){let i,b='<a href="../conceptual_guides/prompting#prefix-tuning">Prefix tuning</a> adds task-specific parameters in all of the model layers, which are optimized by a separate feed-forward network. Create a <a href="/docs/peft/main/en/package_reference/prefix_tuning#peft.PrefixTuningConfig">PrefixTuningConfig</a> with the task type and number of virtual tokens to add and learn.',r,M,m;return M=new C({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcmVmaXhUdW5pbmdDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJlZml4VHVuaW5nQ29uZmlnKHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUyMG51bV92aXJ0dWFsX3Rva2VucyUzRDIwKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOTgzJTJDMDQwJTIwJTdDJTdDJTIwYWxsJTIwcGFyYW1zJTNBJTIwNTYwJTJDMTk3JTJDNjMyJTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMC4xNzU0ODA5Mjc0MTY3MDE0JTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PrefixTuningConfig, get_peft_model

peft_config = PrefixTuningConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, num_virtual_tokens=<span class="hljs-number">20</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 983,040 || all params: 560,197,632 || trainable%: 0.1754809274167014&quot;</span>`,wrap:!1}}),{c(){i=c("p"),i.innerHTML=b,r=n(),u(M.$$.fragment)},l(o){i=d(o,"P",{"data-svelte-h":!0}),U(i)!=="svelte-sqvmle"&&(i.innerHTML=b),r=p(o),J(M.$$.fragment,o)},m(o,a){s(o,i,a),s(o,r,a),y(M,o,a),m=!0},p:at,i(o){m||(T(M.$$.fragment,o),m=!0)},o(o){h(M.$$.fragment,o),m=!1},d(o){o&&(e(i),e(r)),w(M,o)}}}function Rt(g){let i,b='<a href="../conceptual_guides/prompting#prompt-tuning">Prompt tuning</a> formulates all tasks as a <em>generation</em> task and it adds a task-specific prompt to the input which is updated independently. The <code>prompt_tuning_init_text</code> parameter specifies how to finetune the model (in this case, it is classifying whether tweets are complaints or not). For the best results, the <code>prompt_tuning_init_text</code> should have the same number of tokens that should be predicted. To do this, you can set <code>num_virtual_tokens</code> to the number of tokens of the <code>prompt_tuning_init_text</code>.',r,M,m='Create a <a href="/docs/peft/main/en/package_reference/prompt_tuning#peft.PromptTuningConfig">PromptTuningConfig</a> with the task type, the initial prompt tuning text to train the model with, the number of virtual tokens to add and learn, and a tokenizer.',o,a,j;return a=new C({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQcm9tcHRUdW5pbmdDb25maWclMkMlMjBQcm9tcHRUdW5pbmdJbml0JTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFwcm9tcHRfdHVuaW5nX2luaXRfdGV4dCUyMCUzRCUyMCUyMkNsYXNzaWZ5JTIwaWYlMjB0aGUlMjB0d2VldCUyMGlzJTIwYSUyMGNvbXBsYWludCUyMG9yJTIwbm8lMjBjb21wbGFpbnQuJTVDbiUyMiUwQXBlZnRfY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuVEVYVCUyQyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRGxlbih0b2tlbml6ZXIocHJvbXB0X3R1bmluZ19pbml0X3RleHQpJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdF90ZXh0JTNEcHJvbXB0X3R1bmluZ19pbml0X3RleHQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfbmFtZV9vcl9wYXRoJTNEJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwOCUyQzE5MiUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDU1OSUyQzIyMiUyQzc4NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuMDAxNDY0ODkwMjQzMDk4NTM1OCUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PromptTuningConfig, PromptTuningInit, get_peft_model

prompt_tuning_init_text = <span class="hljs-string">&quot;Classify if the tweet is a complaint or no complaint.\\n&quot;</span>
peft_config = PromptTuningConfig(
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
    prompt_tuning_init=PromptTuningInit.TEXT,
    num_virtual_tokens=<span class="hljs-built_in">len</span>(tokenizer(prompt_tuning_init_text)[<span class="hljs-string">&quot;input_ids&quot;</span>]),
    prompt_tuning_init_text=prompt_tuning_init_text,
    tokenizer_name_or_path=<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>,
)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 8,192 || all params: 559,222,784 || trainable%: 0.0014648902430985358&quot;</span>`,wrap:!1}}),{c(){i=c("p"),i.innerHTML=b,r=n(),M=c("p"),M.innerHTML=m,o=n(),u(a.$$.fragment)},l(f){i=d(f,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1vtqt32"&&(i.innerHTML=b),r=p(f),M=d(f,"P",{"data-svelte-h":!0}),U(M)!=="svelte-sm7geg"&&(M.innerHTML=m),o=p(f),J(a.$$.fragment,f)},m(f,I){s(f,i,I),s(f,r,I),s(f,M,I),s(f,o,I),y(a,f,I),j=!0},p:at,i(f){j||(T(a.$$.fragment,f),j=!0)},o(f){h(a.$$.fragment,f),j=!1},d(f){f&&(e(i),e(r),e(M),e(o)),w(a,f)}}}function Nt(g){let i,b,r,M,m,o;return i=new st({props:{id:"configurations",option:"p-tuning",$$slots:{default:[Xt]},$$scope:{ctx:g}}}),r=new st({props:{id:"configurations",option:"prefix tuning",$$slots:{default:[$t]},$$scope:{ctx:g}}}),m=new st({props:{id:"configurations",option:"prompt tuning",$$slots:{default:[Rt]},$$scope:{ctx:g}}}),{c(){u(i.$$.fragment),b=n(),u(r.$$.fragment),M=n(),u(m.$$.fragment)},l(a){J(i.$$.fragment,a),b=p(a),J(r.$$.fragment,a),M=p(a),J(m.$$.fragment,a)},m(a,j){y(i,a,j),s(a,b,j),y(r,a,j),s(a,M,j),y(m,a,j),o=!0},p(a,j){const f={};j&2&&(f.$$scope={dirty:j,ctx:a}),i.$set(f);const I={};j&2&&(I.$$scope={dirty:j,ctx:a}),r.$set(I);const dl={};j&2&&(dl.$$scope={dirty:j,ctx:a}),m.$set(dl)},i(a){o||(T(i.$$.fragment,a),T(r.$$.fragment,a),T(m.$$.fragment,a),o=!0)},o(a){h(i.$$.fragment,a),h(r.$$.fragment,a),h(m.$$.fragment,a),o=!1},d(a){a&&(e(b),e(M)),w(i,a),w(r,a),w(m,a)}}}function zt(g){let i,b,r,M,m,o,a,j="A prompt can describe a task or provide an example of a task you want the model to learn. Instead of manually creating these prompts, soft prompting methods add learnable parameters to the input embeddings that can be optimized for a specific task while keeping the pretrained model’s parameters frozen. This makes it both faster and easier to finetune large language models (LLMs) for new downstream tasks.",f,I,dl='The PEFT library supports several types of prompting methods (p-tuning, prefix tuning, prompt tuning) and you can learn more about how these methods work conceptually in the <a href="../conceptual_guides/prompting">Soft prompts</a> guide. If you’re interested in applying these methods to other tasks and use cases, take a look at our <a href="https://huggingface.co/spaces/PEFT/soft-prompting" rel="nofollow">notebook collection</a>!',yl,G,nt="This guide will show you how to train a causal language model - with a soft prompting method - to <em>generate a classification</em> for whether a tweet is a complaint or not.",Tl,_,pt='<p>Some familiarity with the general process of training a causal language model would be really helpful and allow you to focus on the soft prompting methods. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling" rel="nofollow">Causal language modeling</a> guide first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!</p>',hl,W,ot="Before you begin, make sure you have all the necessary libraries installed.",wl,V,fl,X,Ul,$,it='For this guide, you’ll use the <code>twitter_complaints</code> subset of the <a href="https://huggingface.co/datasets/ought/raft" rel="nofollow">RAFT</a> dataset. The <code>twitter_complaints</code> subset contains tweets labeled as <code>complaint</code> and <code>no complaint</code> and you can check out the <a href="https://huggingface.co/datasets/ought/raft/viewer/twitter_complaints" rel="nofollow">dataset viewer</a> for a better idea of what the data looks like.',jl,R,Mt='Use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function to load the dataset and create a new <code>text_label</code> column so it is easier to understand what the <code>Label</code> values, <code>1</code> and <code>2</code> mean.',bl,N,Il,z,rt="Load a tokenizer, define the padding token to use, and determine the maximum length of the tokenized label.",Cl,v,gl,E,mt="Create a preprocessing function that tokenizes the tweet text and labels, pad the inputs and labels in each batch, create an attention mask, and truncate sequences to the <code>max_length</code>. Then convert the <code>input_ids</code>, <code>attention_mask</code>, and <code>labels</code> to PyTorch tensors.",_l,F,Zl,Q,ct='Apply the preprocessing function to the entire dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function, and remove the unprocessed columns because the model won’t need them.',kl,Y,Bl,x,dt='Finally, create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>. You can set <code>pin_memory=True</code> to speed up the data transfer to the GPU during training if the samples in your dataset are on a CPU.',Gl,A,Wl,H,Vl,q,ut='Now let’s load a pretrained model to use as the base model for the soft prompt method. This guide uses the <a href="https://huggingface.co/bigscience/bloomz-560m" rel="nofollow">bigscience/bloomz-560m</a> model, but you can use any causal language model you want.',Xl,S,$l,L,Rl,D,Jt='For any PEFT method, you’ll need to create a configuration which contains all the parameters that specify how the PEFT method should be applied. Once the configuration is setup, pass it to the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Nl,Z,yt='<p>Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!</p>',zl,k,vl,P,El,K,Tt="Set up an optimizer and learning rate scheduler.",Fl,O,Ql,ll,ht="Move the model to the GPU and create a training loop that reports the loss and perplexity for each epoch.",Yl,tl,xl,el,Al,sl,wt='Once training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',Hl,al,ql,nl,ft="If you check the model file size in the repository, you’ll see that it is a lot smaller than a full sized model!",Sl,B,Ut='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">For example, the adapter weights for a opt-350m model stored on the Hub are only ~6MB compared to the full model size which can be ~700MB.</figcaption>',Ll,pl,Dl,ol,jt="Let’s load the model for inference and test it out on a tweet!",Pl,il,Kl,Ml,bt='Call the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> method to generate the predicted classification label.',Ol,rl,lt,ml,tt,ul,et;return m=new cl({props:{title:"Prompt-based methods",local:"prompt-based-methods",headingTag:"h1"}}),V=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcGVmdCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRz",highlighted:"pip install -q peft transformers datasets",wrap:!1}}),X=new cl({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),N=new C({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIycGFycXVldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFpbiUyMiUzQSUyMCUyMmhmJTNBJTJGJTJGZGF0YXNldHMlMkZvdWdodCUyRnJhZnQlNDByZWZzJTJGY29udmVydCUyRnBhcnF1ZXQlMkZ0d2l0dGVyX2NvbXBsYWludHMlMkZ0cmFpbiUyRjAwMDAucGFycXVldCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlc3QlMjIlM0ElMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGb3VnaHQlMkZyYWZ0JTQwcmVmcyUyRmNvbnZlcnQlMkZwYXJxdWV0JTJGdHdpdHRlcl9jb21wbGFpbnRzJTJGdGVzdCUyRjAwMDAucGFycXVldCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSklMEElMEFjbGFzc2VzJTIwJTNEJTIwJTVCay5yZXBsYWNlKCUyMl8lMjIlMkMlMjAlMjIlMjAlMjIpJTIwZm9yJTIwayUyMGluJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMkxhYmVsJTIyJTVELm5hbWVzJTVEJTBBZHMlMjAlM0QlMjBkcy5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIweCUzQSUyMCU3QiUyMnRleHRfbGFiZWwlMjIlM0ElMjAlNUJjbGFzc2VzJTVCbGFiZWwlNUQlMjBmb3IlMjBsYWJlbCUyMGluJTIweCU1QiUyMkxhYmVsJTIyJTVEJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBudW1fcHJvYyUzRDElMkMlMEEpJTBBZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlMEElN0IlMjJUd2VldCUyMHRleHQlMjIlM0ElMjAlMjIlNDBITVJDY3VzdG9tZXJzJTIwTm8lMjB0aGlzJTIwaXMlMjBteSUyMGZpcnN0JTIwam9iJTIyJTJDJTIwJTIySUQlMjIlM0ElMjAwJTJDJTIwJTIyTGFiZWwlMjIlM0ElMjAyJTJDJTIwJTIydGV4dF9sYWJlbCUyMiUzQSUyMCUyMm5vJTIwY29tcGxhaW50JTIyJTdE",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(
    <span class="hljs-string">&quot;parquet&quot;</span>,
    data_files={
        <span class="hljs-string">&quot;train&quot;</span>: <span class="hljs-string">&quot;hf://datasets/ought/raft@refs/convert/parquet/twitter_complaints/train/0000.parquet&quot;</span>,
        <span class="hljs-string">&quot;test&quot;</span>: <span class="hljs-string">&quot;hf://datasets/ought/raft@refs/convert/parquet/twitter_complaints/test/0000.parquet&quot;</span>
    }
)

classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;Label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)
ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&quot;Tweet text&quot;</span>: <span class="hljs-string">&quot;@HMRCcustomers No this is my first job&quot;</span>, <span class="hljs-string">&quot;ID&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;Label&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;text_label&quot;</span>: <span class="hljs-string">&quot;no complaint&quot;</span>}`,wrap:!1}}),v=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBaWYlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyLnBhZF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMEF0YXJnZXRfbWF4X2xlbmd0aCUyMCUzRCUyMG1heCglNUJsZW4odG9rZW5pemVyKGNsYXNzX2xhYmVsKSU1QiUyMmlucHV0X2lkcyUyMiU1RCklMjBmb3IlMjBjbGFzc19sYWJlbCUyMGluJTIwY2xhc3NlcyU1RCklMEFwcmludCh0YXJnZXRfbWF4X2xlbmd0aCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-keyword">if</span> tokenizer.pad_token_id <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
    tokenizer.pad_token_id = tokenizer.eos_token_id
target_max_length = <span class="hljs-built_in">max</span>([<span class="hljs-built_in">len</span>(tokenizer(class_label)[<span class="hljs-string">&quot;input_ids&quot;</span>]) <span class="hljs-keyword">for</span> class_label <span class="hljs-keyword">in</span> classes])
<span class="hljs-built_in">print</span>(target_max_length)`,wrap:!1}}),F=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

max_length = <span class="hljs-number">64</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples, text_column=<span class="hljs-string">&quot;Tweet text&quot;</span>, label_column=<span class="hljs-string">&quot;text_label&quot;</span></span>):
    batch_size = <span class="hljs-built_in">len</span>(examples[text_column])
    inputs = [<span class="hljs-string">f&quot;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{x}</span> Label : &quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[text_column]]
    targets = [<span class="hljs-built_in">str</span>(x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> examples[label_column]]
    model_inputs = tokenizer(inputs)
    labels = tokenizer(targets)
    classes = [k.replace(<span class="hljs-string">&quot;_&quot;</span>, <span class="hljs-string">&quot; &quot;</span>) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;Label&quot;</span>].names]
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(batch_size):
        sample_input_ids = model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        label_input_ids = labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i]
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [tokenizer.pad_token_id] * (
            max_length - <span class="hljs-built_in">len</span>(sample_input_ids)
        ) + sample_input_ids
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = [<span class="hljs-number">0</span>] * (max_length - <span class="hljs-built_in">len</span>(sample_input_ids)) + model_inputs[
            <span class="hljs-string">&quot;attention_mask&quot;</span>
        ][i]
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = [-<span class="hljs-number">100</span>] * (max_length - <span class="hljs-built_in">len</span>(label_input_ids)) + label_input_ids
        model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
        model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i] = torch.tensor(model_inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>][i][:max_length])
        labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i] = torch.tensor(labels[<span class="hljs-string">&quot;input_ids&quot;</span>][i][:max_length])
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),Y=new C({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),A=new C({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKHRyYWluX2RzJTJDJTIwc2h1ZmZsZSUzRFRydWUlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSklMEFldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGV2YWxfZHMlMkMlMjBjb2xsYXRlX2ZuJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBwaW5fbWVtb3J5JTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;test&quot;</span>]

batch_size = <span class="hljs-number">16</span>

train_dataloader = DataLoader(train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new cl({props:{title:"Model",local:"model",headingTag:"h2"}}),S=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)`,wrap:!1}}),L=new cl({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),k=new Vt({props:{id:"configurations",options:["p-tuning","prefix tuning","prompt tuning"],$$slots:{default:[Nt]},$$scope:{ctx:g}}}),P=new cl({props:{title:"Training",local:"training",headingTag:"h3"}}),O=new C({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFsciUyMCUzRCUyMDNlLTIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjB0b3JjaC5vcHRpbS5BZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGxyKSUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMGdldF9saW5lYXJfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0QobGVuKHRyYWluX2RhdGFsb2FkZXIpJTIwKiUyMG51bV9lcG9jaHMpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">3e-2</span>
num_epochs = <span class="hljs-number">50</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),tl=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),el=new cl({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),al=new C({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGYmxvb216LTU2MC1tLXBlZnQtbWV0aG9kJTIyJTBBbW9kZWwucHVzaF90b19odWIocGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/bloomz-560-m-peft-method&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),pl=new cl({props:{title:"Inference",local:"inference",headingTag:"h2"}}),il=new C({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9QZWZ0TW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdF9tb2RlbF9pZCUyMikudG8oJTIyY3VkYSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaSUyMCUzRCUyMDE1JTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGYnJTdCdGV4dF9jb2x1bW4lN0QlMjAlM0ElMjAlN0JkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEJTdEJTIwTGFiZWwlMjAlM0ElMjAnJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnRlc3QlMjIlNUQlNUJpJTVEJTVCJTIyVHdlZXQlMjB0ZXh0JTIyJTVEKSUwQSUyMiU0ME5ZVHN1cHBvcnQlMjBpJTIwaGF2ZSUyMGNvbXBsYWluZWQlMjBhJTIwZG96ZW4lMjB0aW1lcyUyMCUyNmFtcCUzQiUyMHlldCUyMG15JTIwcGFwZXJzJTIwYXJlJTIwc3RpbGwlMjB0aHJvd24lMjBGQVIlMjBmcm9tJTIwbXklMjBkb29yLiUyMFdoeSUyMGlzJTIwdGhpcyUyMHNvJTIwaGFyZCUyMHRvJTIwcmVzb2x2ZSUzRiUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForCausalLM

model = AutoPeftModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft_model_id&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(<span class="hljs-string">f&#x27;<span class="hljs-subst">{text_column}</span> : <span class="hljs-subst">{ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>]}</span> Label : &#x27;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;test&quot;</span>][i][<span class="hljs-string">&quot;Tweet text&quot;</span>])
<span class="hljs-string">&quot;@NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve?&quot;</span>`,wrap:!1}}),rl=new C({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMjIlNUInVHdlZXQlMjB0ZXh0JTIwJTNBJTIwJTQwTllUc3VwcG9ydCUyMGklMjBoYXZlJTIwY29tcGxhaW5lZCUyMGElMjBkb3plbiUyMHRpbWVzJTIwJTI2YW1wJTNCJTIweWV0JTIwbXklMjBwYXBlcnMlMjBhcmUlMjBzdGlsbCUyMHRocm93biUyMEZBUiUyMGZyb20lMjBteSUyMGRvb3IuJTIwV2h5JTIwaXMlMjB0aGlzJTIwc28lMjBoYXJkJTIwdG8lMjByZXNvbHZlJTNGJTIwTGFiZWwlMjAlM0ElMjBjb21wbGFpbnQnJTVEJTIy",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&quot;[&#x27;Tweet text : @NYTsupport i have complained a dozen times &amp;amp; yet my papers are still thrown FAR from my door. Why is this so hard to resolve? Label : complaint&#x27;]&quot;</span>`,wrap:!1}}),ml=new Wt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/prompt_based_methods.md"}}),{c(){i=c("meta"),b=n(),r=c("p"),M=n(),u(m.$$.fragment),o=n(),a=c("p"),a.textContent=j,f=n(),I=c("p"),I.innerHTML=dl,yl=n(),G=c("p"),G.innerHTML=nt,Tl=n(),_=c("blockquote"),_.innerHTML=pt,hl=n(),W=c("p"),W.textContent=ot,wl=n(),u(V.$$.fragment),fl=n(),u(X.$$.fragment),Ul=n(),$=c("p"),$.innerHTML=it,jl=n(),R=c("p"),R.innerHTML=Mt,bl=n(),u(N.$$.fragment),Il=n(),z=c("p"),z.textContent=rt,Cl=n(),u(v.$$.fragment),gl=n(),E=c("p"),E.innerHTML=mt,_l=n(),u(F.$$.fragment),Zl=n(),Q=c("p"),Q.innerHTML=ct,kl=n(),u(Y.$$.fragment),Bl=n(),x=c("p"),x.innerHTML=dt,Gl=n(),u(A.$$.fragment),Wl=n(),u(H.$$.fragment),Vl=n(),q=c("p"),q.innerHTML=ut,Xl=n(),u(S.$$.fragment),$l=n(),u(L.$$.fragment),Rl=n(),D=c("p"),D.innerHTML=Jt,Nl=n(),Z=c("blockquote"),Z.innerHTML=yt,zl=n(),u(k.$$.fragment),vl=n(),u(P.$$.fragment),El=n(),K=c("p"),K.textContent=Tt,Fl=n(),u(O.$$.fragment),Ql=n(),ll=c("p"),ll.textContent=ht,Yl=n(),u(tl.$$.fragment),xl=n(),u(el.$$.fragment),Al=n(),sl=c("p"),sl.innerHTML=wt,Hl=n(),u(al.$$.fragment),ql=n(),nl=c("p"),nl.textContent=ft,Sl=n(),B=c("div"),B.innerHTML=Ut,Ll=n(),u(pl.$$.fragment),Dl=n(),ol=c("p"),ol.textContent=jt,Pl=n(),u(il.$$.fragment),Kl=n(),Ml=c("p"),Ml.innerHTML=bt,Ol=n(),u(rl.$$.fragment),lt=n(),u(ml.$$.fragment),tt=n(),ul=c("p"),this.h()},l(l){const t=Bt("svelte-u9bgzb",document.head);i=d(t,"META",{name:!0,content:!0}),t.forEach(e),b=p(l),r=d(l,"P",{}),Ct(r).forEach(e),M=p(l),J(m.$$.fragment,l),o=p(l),a=d(l,"P",{"data-svelte-h":!0}),U(a)!=="svelte-1nma30k"&&(a.textContent=j),f=p(l),I=d(l,"P",{"data-svelte-h":!0}),U(I)!=="svelte-qxepz2"&&(I.innerHTML=dl),yl=p(l),G=d(l,"P",{"data-svelte-h":!0}),U(G)!=="svelte-10gyoze"&&(G.innerHTML=nt),Tl=p(l),_=d(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(_)!=="svelte-1p5rdzu"&&(_.innerHTML=pt),hl=p(l),W=d(l,"P",{"data-svelte-h":!0}),U(W)!=="svelte-1rdzhb1"&&(W.textContent=ot),wl=p(l),J(V.$$.fragment,l),fl=p(l),J(X.$$.fragment,l),Ul=p(l),$=d(l,"P",{"data-svelte-h":!0}),U($)!=="svelte-b49pm"&&($.innerHTML=it),jl=p(l),R=d(l,"P",{"data-svelte-h":!0}),U(R)!=="svelte-5j9yqq"&&(R.innerHTML=Mt),bl=p(l),J(N.$$.fragment,l),Il=p(l),z=d(l,"P",{"data-svelte-h":!0}),U(z)!=="svelte-gjlxro"&&(z.textContent=rt),Cl=p(l),J(v.$$.fragment,l),gl=p(l),E=d(l,"P",{"data-svelte-h":!0}),U(E)!=="svelte-s6tghk"&&(E.innerHTML=mt),_l=p(l),J(F.$$.fragment,l),Zl=p(l),Q=d(l,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-fdx4gc"&&(Q.innerHTML=ct),kl=p(l),J(Y.$$.fragment,l),Bl=p(l),x=d(l,"P",{"data-svelte-h":!0}),U(x)!=="svelte-zejkx4"&&(x.innerHTML=dt),Gl=p(l),J(A.$$.fragment,l),Wl=p(l),J(H.$$.fragment,l),Vl=p(l),q=d(l,"P",{"data-svelte-h":!0}),U(q)!=="svelte-bbm736"&&(q.innerHTML=ut),Xl=p(l),J(S.$$.fragment,l),$l=p(l),J(L.$$.fragment,l),Rl=p(l),D=d(l,"P",{"data-svelte-h":!0}),U(D)!=="svelte-y2bm59"&&(D.innerHTML=Jt),Nl=p(l),Z=d(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(Z)!=="svelte-1eb563c"&&(Z.innerHTML=yt),zl=p(l),J(k.$$.fragment,l),vl=p(l),J(P.$$.fragment,l),El=p(l),K=d(l,"P",{"data-svelte-h":!0}),U(K)!=="svelte-tlkvop"&&(K.textContent=Tt),Fl=p(l),J(O.$$.fragment,l),Ql=p(l),ll=d(l,"P",{"data-svelte-h":!0}),U(ll)!=="svelte-bqhytl"&&(ll.textContent=ht),Yl=p(l),J(tl.$$.fragment,l),xl=p(l),J(el.$$.fragment,l),Al=p(l),sl=d(l,"P",{"data-svelte-h":!0}),U(sl)!=="svelte-vaxac6"&&(sl.innerHTML=wt),Hl=p(l),J(al.$$.fragment,l),ql=p(l),nl=d(l,"P",{"data-svelte-h":!0}),U(nl)!=="svelte-b4rki0"&&(nl.textContent=ft),Sl=p(l),B=d(l,"DIV",{class:!0,"data-svelte-h":!0}),U(B)!=="svelte-i5cvgh"&&(B.innerHTML=Ut),Ll=p(l),J(pl.$$.fragment,l),Dl=p(l),ol=d(l,"P",{"data-svelte-h":!0}),U(ol)!=="svelte-19ver11"&&(ol.textContent=jt),Pl=p(l),J(il.$$.fragment,l),Kl=p(l),Ml=d(l,"P",{"data-svelte-h":!0}),U(Ml)!=="svelte-1gths0y"&&(Ml.innerHTML=bt),Ol=p(l),J(rl.$$.fragment,l),lt=p(l),J(ml.$$.fragment,l),tt=p(l),ul=d(l,"P",{}),Ct(ul).forEach(e),this.h()},h(){Jl(i,"name","hf:doc:metadata"),Jl(i,"content",vt),Jl(_,"class","tip"),Jl(Z,"class","tip"),Jl(B,"class","flex flex-col justify-center")},m(l,t){Gt(document.head,i),s(l,b,t),s(l,r,t),s(l,M,t),y(m,l,t),s(l,o,t),s(l,a,t),s(l,f,t),s(l,I,t),s(l,yl,t),s(l,G,t),s(l,Tl,t),s(l,_,t),s(l,hl,t),s(l,W,t),s(l,wl,t),y(V,l,t),s(l,fl,t),y(X,l,t),s(l,Ul,t),s(l,$,t),s(l,jl,t),s(l,R,t),s(l,bl,t),y(N,l,t),s(l,Il,t),s(l,z,t),s(l,Cl,t),y(v,l,t),s(l,gl,t),s(l,E,t),s(l,_l,t),y(F,l,t),s(l,Zl,t),s(l,Q,t),s(l,kl,t),y(Y,l,t),s(l,Bl,t),s(l,x,t),s(l,Gl,t),y(A,l,t),s(l,Wl,t),y(H,l,t),s(l,Vl,t),s(l,q,t),s(l,Xl,t),y(S,l,t),s(l,$l,t),y(L,l,t),s(l,Rl,t),s(l,D,t),s(l,Nl,t),s(l,Z,t),s(l,zl,t),y(k,l,t),s(l,vl,t),y(P,l,t),s(l,El,t),s(l,K,t),s(l,Fl,t),y(O,l,t),s(l,Ql,t),s(l,ll,t),s(l,Yl,t),y(tl,l,t),s(l,xl,t),y(el,l,t),s(l,Al,t),s(l,sl,t),s(l,Hl,t),y(al,l,t),s(l,ql,t),s(l,nl,t),s(l,Sl,t),s(l,B,t),s(l,Ll,t),y(pl,l,t),s(l,Dl,t),s(l,ol,t),s(l,Pl,t),y(il,l,t),s(l,Kl,t),s(l,Ml,t),s(l,Ol,t),y(rl,l,t),s(l,lt,t),y(ml,l,t),s(l,tt,t),s(l,ul,t),et=!0},p(l,[t]){const It={};t&2&&(It.$$scope={dirty:t,ctx:l}),k.$set(It)},i(l){et||(T(m.$$.fragment,l),T(V.$$.fragment,l),T(X.$$.fragment,l),T(N.$$.fragment,l),T(v.$$.fragment,l),T(F.$$.fragment,l),T(Y.$$.fragment,l),T(A.$$.fragment,l),T(H.$$.fragment,l),T(S.$$.fragment,l),T(L.$$.fragment,l),T(k.$$.fragment,l),T(P.$$.fragment,l),T(O.$$.fragment,l),T(tl.$$.fragment,l),T(el.$$.fragment,l),T(al.$$.fragment,l),T(pl.$$.fragment,l),T(il.$$.fragment,l),T(rl.$$.fragment,l),T(ml.$$.fragment,l),et=!0)},o(l){h(m.$$.fragment,l),h(V.$$.fragment,l),h(X.$$.fragment,l),h(N.$$.fragment,l),h(v.$$.fragment,l),h(F.$$.fragment,l),h(Y.$$.fragment,l),h(A.$$.fragment,l),h(H.$$.fragment,l),h(S.$$.fragment,l),h(L.$$.fragment,l),h(k.$$.fragment,l),h(P.$$.fragment,l),h(O.$$.fragment,l),h(tl.$$.fragment,l),h(el.$$.fragment,l),h(al.$$.fragment,l),h(pl.$$.fragment,l),h(il.$$.fragment,l),h(rl.$$.fragment,l),h(ml.$$.fragment,l),et=!1},d(l){l&&(e(b),e(r),e(M),e(o),e(a),e(f),e(I),e(yl),e(G),e(Tl),e(_),e(hl),e(W),e(wl),e(fl),e(Ul),e($),e(jl),e(R),e(bl),e(Il),e(z),e(Cl),e(gl),e(E),e(_l),e(Zl),e(Q),e(kl),e(Bl),e(x),e(Gl),e(Wl),e(Vl),e(q),e(Xl),e($l),e(Rl),e(D),e(Nl),e(Z),e(zl),e(vl),e(El),e(K),e(Fl),e(Ql),e(ll),e(Yl),e(xl),e(Al),e(sl),e(Hl),e(ql),e(nl),e(Sl),e(B),e(Ll),e(Dl),e(ol),e(Pl),e(Kl),e(Ml),e(Ol),e(lt),e(tt),e(ul)),e(i),w(m,l),w(V,l),w(X,l),w(N,l),w(v,l),w(F,l),w(Y,l),w(A,l),w(H,l),w(S,l),w(L,l),w(k,l),w(P,l),w(O,l),w(tl,l),w(el,l),w(al,l),w(pl,l),w(il,l),w(rl,l),w(ml,l)}}}const vt='{"title":"Prompt-based methods","local":"prompt-based-methods","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Et(g){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Zt{constructor(i){super(),kt(this,i,Et,zt,gt,{})}}export{Ht as component};
