import{s as is,n as ps,o as cs}from"../chunks/scheduler.4cd3e004.js";import{S as rs,i as us,e as o,s as l,c,h as hs,a as i,d as s,b as n,f as os,g as r,j as p,k as Te,l as ds,m as a,n as u,t as h,o as d,p as m}from"../chunks/index.b664cb2d.js";import{C as Me}from"../chunks/CodeBlock.8601e34e.js";import{H as J,E as ms}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.179b63f8.js";function ys(Ut){let y,Je,fe,we,w,Ue,U,bt="This document describes how PEFT’s checkpoint files are structured and how to convert between the PEFT format and other formats.",be,b,_e,_,_t="PEFT (parameter-efficient fine-tuning) methods only update a small subset of a model’s parameters rather than all of them. This is nice because checkpoint files can generally be much smaller than the original model files and are easier to store and share. However, this also means that to load a PEFT model, you need to have the original model available as well.",Ie,I,It='When you call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.save_pretrained">save_pretrained()</a> on a PEFT model, the PEFT model saves three files, described below:',Ce,C,Ct="<li><code>adapter_model.safetensors</code> or <code>adapter_model.bin</code></li>",ge,g,gt='By default, the model is saved in the <code>safetensors</code> format, a secure alternative to the <code>bin</code> format, which is known to be susceptible to <a href="https://huggingface.co/docs/hub/security-pickle" rel="nofollow">security vulnerabilities</a> because it uses the pickle utility under the hood. Both formats store the same <code>state_dict</code> though, and are interchangeable.',ve,v,vt="The <code>state_dict</code> only contains the parameters of the adapter module, not the base model. To illustrate the difference in size, a normal BERT model requires ~420MB of disk space, whereas an IA³ adapter on top of this BERT model only requires ~260KB.",qe,M,qt="<li><code>adapter_config.json</code></li>",Be,q,Bt="The <code>adapter_config.json</code> file contains the configuration of the adapter module, which is necessary to load the model. Below is an example of an <code>adapter_config.json</code> for an IA³ adapter with standard settings applied to a BERT model:",Ee,B,ke,E,Et="The configuration file contains:",Ae,k,kt="<li>the adapter module type stored, <code>&quot;peft_type&quot;: &quot;IA3&quot;</code></li> <li>information about the base model like <code>&quot;base_model_name_or_path&quot;: &quot;bert-base-uncased&quot;</code></li> <li>the revision of the model (if any), <code>&quot;revision&quot;: null</code></li>",Ze,A,At="If the base model is not a pretrained Transformers model, the latter two entries will be <code>null</code>. Other than that, the settings are all related to the specific IA³ adapter that was used to fine-tune the model.",$e,T,Zt="<li><code>README.md</code></li>",xe,Z,$t="The generated <code>README.md</code> is the model card of a PEFT model and contains a few pre-filled entries. The intent of this is to make it easier to share the model with others and to provide some basic information about the model. This file is not needed to load the model.",Ve,$,Fe,x,xt="When converting from another format to the PEFT format, we require both the <code>adapter_model.safetensors</code> (or <code>adapter_model.bin</code>) file and the <code>adapter_config.json</code> file.",Le,V,Qe,F,Vt="For the model weights, it is important to use the correct mapping from parameter name to value for PEFT to load the file. Getting this mapping right is an exercise in checking the implementation details, as there is no generally agreed upon format for PEFT adapters.",He,L,Ft='Fortunately, figuring out this mapping is not overly complicated for common base cases. Let’s look at a concrete example, the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/layer.py" rel="nofollow"><code>LoraLayer</code></a>:',Re,Q,Xe,H,Lt="In the <code>__init__</code> code used by all <code>LoraLayer</code> classes in PEFT, there are a bunch of parameters used to initialize the model, but only a few are relevant for the checkpoint file: <code>lora_A</code>, <code>lora_B</code>, <code>lora_embedding_A</code>, and <code>lora_embedding_B</code>. These parameters are listed in the class attribute <code>adapter_layer_names</code> and contain the learnable parameters, so they must be included in the checkpoint file. All the other parameters, like the rank <code>r</code>, are derived from the <code>adapter_config.json</code> and must be included there (unless the default value is used).",We,R,Qt="Let’s check the <code>state_dict</code> of a PEFT LoRA model applied to BERT. When printing the first five keys using the default LoRA settings (the remaining keys are the same, just with different layer numbers), we get:",Ge,X,Ht="<li><code>base_model.model.encoder.layer.0.attention.self.query.lora_A.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.query.lora_B.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.value.lora_A.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.value.lora_B.weight</code></li> <li><code>base_model.model.encoder.layer.1.attention.self.query.lora_A.weight</code></li> <li>etc.</li>",Pe,W,Rt="Let’s break this down:",Ye,G,Xt="<li>By default, for BERT models, LoRA is applied to the <code>query</code> and <code>value</code> layers of the attention module. This is why you see <code>attention.self.query</code> and <code>attention.self.value</code> in the key names for each layer.</li> <li>LoRA decomposes the weights into two low-rank matrices, <code>lora_A</code> and <code>lora_B</code>. This is where <code>lora_A</code> and <code>lora_B</code> come from in the key names.</li> <li>These LoRA matrices are implemented as <code>nn.Linear</code> layers, so the parameters are stored in the <code>.weight</code> attribute (<code>lora_A.weight</code>, <code>lora_B.weight</code>).</li> <li>By default, LoRA isn’t applied to BERT’s embedding layer, so there are <em>no entries</em> for <code>lora_A_embedding</code> and <code>lora_B_embedding</code>.</li> <li>The keys of the <code>state_dict</code> always start with <code>&quot;base_model.model.&quot;</code>. The reason is that, in PEFT, we wrap the base model inside a tuner-specific model (<code>LoraModel</code> in this case), which itself is wrapped in a general PEFT model (<code>PeftModel</code>). For this reason, these two prefixes are added to the keys. When converting to the PEFT format, it is required to add these prefixes.</li>",Ne,f,Wt="<p>This last point is not true for prefix tuning techniques like prompt tuning. There, the extra embeddings are directly stored in the <code>state_dict</code> without any prefixes added to the keys.</p>",Se,P,Gt="When inspecting the parameter names in the loaded model, you might be surprised to find that they look a bit different, e.g. <code>base_model.model.encoder.layer.0.attention.self.query.lora_A.default.weight</code>. The difference is the <em><code>.default</code></em> part in the second to last segment. This part exists because PEFT generally allows the addition of multiple adapters at once (using an <code>nn.ModuleDict</code> or <code>nn.ParameterDict</code> to store them). For example, if you add another adapter called “other”, the key for that adapter would be <code>base_model.model.encoder.layer.0.attention.self.query.lora_A.other.weight</code>.",ze,Y,Pt='When you call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.save_pretrained">save_pretrained()</a>, the adapter name is stripped from the keys. The reason is that the adapter name is not an important part of the model architecture; it is just an arbitrary name. When loading the adapter, you could choose a totally different name, and the model would still work the same way. This is why the adapter name is not stored in the checkpoint file.',De,j,Yt="<p>If you call <code>save_pretrained(&quot;some/path&quot;)</code> and the adapter name is not <code>&quot;default&quot;</code>, the adapter is stored in a sub-directory with the same name as the adapter. So if the name is “other”, it would be stored inside of <code>some/path/other</code>.</p>",Oe,N,Nt="In some circumstances, deciding which values to add to the checkpoint file can become a bit more complicated. For example, in PEFT, DoRA is implemented as a special case of LoRA. If you want to convert a DoRA model to PEFT, you should create a LoRA checkpoint with extra entries for DoRA. You can see this in the <code>__init__</code> of the previous <code>LoraLayer</code> code:",Ke,S,et,z,St="This indicates that there is an optional extra parameter per layer for DoRA.",tt,D,st,O,zt="All the other information needed to load a PEFT model is contained in the <code>adapter_config.json</code> file. Let’s check this file for a LoRA model applied to BERT:",at,K,lt,ee,Dt="This contains a lot of entries, and at first glance, it could feel overwhelming to figure out all the right values to put in there. However, most of the entries are not necessary to load the model. This is either because they use the default values and don’t need to be added or because they only affect the initialization of the LoRA weights, which is irrelevant when it comes to loading the model. If you find that you don’t know what a specific parameter does, e.g., <code>&quot;use_rslora&quot;,</code> don’t add it, and you should be fine. Also note that as more options are added, this file will get more entries in the future, but it should be backward compatible.",nt,te,Ot="At the minimum, you should include the following entries:",ot,se,it,ae,Kt='However, adding as many entries as possible, like the rank <code>r</code> or the <code>base_model_name_or_path</code> (if it’s a Transformers model) is recommended. This information can help others understand the model better and share it more easily. To check which keys and values are expected, check out the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/config.py" rel="nofollow">config.py</a> file (as an example, this is the config file for LoRA) in the PEFT source code.',pt,le,ct,ne,es="In some circumstances, you might want to store the whole PEFT model, including the base weights. This can be necessary if, for instance, the base model is not available to the users trying to load the PEFT model. You can merge the weights first or convert it into a Transformer model.",rt,oe,ut,ie,ts="The most straightforward way to store the whole PEFT model is to merge the adapter weights into the base weights:",ht,pe,dt,ce,ss="There are some disadvantages to this approach, though:",mt,re,as='<li>Once <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">merge_and_unload()</a> is called, you get a basic model without any PEFT-specific functionality. This means you can’t use any of the PEFT-specific methods anymore.</li> <li>You cannot unmerge the weights, load multiple adapters at once, disable the adapter, etc.</li> <li>Not all PEFT methods support merging weights.</li> <li>Some PEFT methods may generally allow merging, but not with specific settings (e.g. when using certain quantization techniques).</li> <li>The whole model will be much larger than the PEFT model, as it will contain all the base weights as well.</li>',yt,ue,ls="But inference with a merged model should be a bit faster.",Mt,he,Tt,de,ns="Another way to save the whole model, assuming the base model is a Transformers model, is to use this hacky approach to directly insert the PEFT weights into the base model and save it, which only works if you “trick” Transformers into believing the PEFT model is not a PEFT model. This only works with LoRA because other adapters are not implemented in Transformers.",ft,me,jt,ye,Jt,je,wt;return w=new J({props:{title:"PEFT checkpoint format",local:"peft-checkpoint-format",headingTag:"h1"}}),b=new J({props:{title:"PEFT files",local:"peft-files",headingTag:"h2"}}),B=new Me({props:{code:"JTdCJTBBJTIwJTIwJTIyYXV0b19tYXBwaW5nJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9jbGFzcyUyMiUzQSUyMCUyMkJlcnRNb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmVudF9saWJyYXJ5JTIyJTNBJTIwJTIydHJhbnNmb3JtZXJzLm1vZGVscy5iZXJ0Lm1vZGVsaW5nX2JlcnQlMjIlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJiYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyMiUzQSUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTBBJTIwJTIwJTIyZmFuX2luX2Zhbl9vdXQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMmZlZWRmb3J3YXJkX21vZHVsZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJvdXRwdXQuZGVuc2UlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJpbmZlcmVuY2VfbW9kZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJpbml0X2lhM193ZWlnaHRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMm1vZHVsZXNfdG9fc2F2ZSUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjJwZWZ0X3R5cGUlMjIlM0ElMjAlMjJJQTMlMjIlMkMlMEElMjAlMjAlMjJyZXZpc2lvbiUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjJ0YXJnZXRfbW9kdWxlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmtleSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbHVlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0LmRlbnNlJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGFza190eXBlJTIyJTNBJTIwbnVsbCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;auto_mapping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;base_model_class&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;BertModel&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parent_library&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;transformers.models.bert.modeling_bert&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;base_model_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fan_in_fan_out&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feedforward_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;output.dense&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;inference_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;init_ia3_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;modules_to_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;IA3&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;key&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;value&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;output.dense&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;task_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),$=new J({props:{title:"Convert to PEFT format",local:"convert-to-peft-format",headingTag:"h2"}}),V=new J({props:{title:"adapter_model",local:"adaptermodel",headingTag:"h3"}}),Q=new Me({props:{code:"JTIzJTIwc2hvd2luZyUyMG9ubHklMjBwYXJ0JTIwb2YlMjB0aGUlMjBjb2RlJTBBJTBBY2xhc3MlMjBMb3JhTGF5ZXIoQmFzZVR1bmVyTGF5ZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQWxsJTIwbmFtZXMlMjBvZiUyMGxheWVycyUyMHRoYXQlMjBtYXklMjBjb250YWluJTIwKHRyYWluYWJsZSklMjBhZGFwdGVyJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbGF5ZXJfbmFtZXMlMjAlM0QlMjAoJTIybG9yYV9BJTIyJTJDJTIwJTIybG9yYV9CJTIyJTJDJTIwJTIybG9yYV9lbWJlZGRpbmdfQSUyMiUyQyUyMCUyMmxvcmFfZW1iZWRkaW5nX0IlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwQWxsJTIwbmFtZXMlMjBvZiUyMG90aGVyJTIwcGFyYW1ldGVycyUyMHRoYXQlMjBtYXklMjBjb250YWluJTIwYWRhcHRlci1yZWxhdGVkJTIwcGFyYW1ldGVycyUwQSUyMCUyMCUyMCUyMG90aGVyX3BhcmFtX25hbWVzJTIwJTNEJTIwKCUyMnIlMjIlMkMlMjAlMjJsb3JhX2FscGhhJTIyJTJDJTIwJTIyc2NhbGluZyUyMiUyQyUyMCUyMmxvcmFfZHJvcG91dCUyMiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwYmFzZV9sYXllciUzQSUyMG5uLk1vZHVsZSUyQyUyMCoqa3dhcmdzKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5iYXNlX2xheWVyJTIwJTNEJTIwYmFzZV9sYXllciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuciUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubG9yYV9hbHBoYSUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2NhbGluZyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubG9yYV9kcm9wb3V0JTIwJTNEJTIwbm4uTW9kdWxlRGljdCglN0IlN0QpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sb3JhX0ElMjAlM0QlMjBubi5Nb2R1bGVEaWN0KCU3QiU3RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxvcmFfQiUyMCUzRCUyMG5uLk1vZHVsZURpY3QoJTdCJTdEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMEVtYmVkZGluZyUyMGxheWVyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sb3JhX2VtYmVkZGluZ19BJTIwJTNEJTIwbm4uUGFyYW1ldGVyRGljdCglN0IlN0QpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sb3JhX2VtYmVkZGluZ19CJTIwJTNEJTIwbm4uUGFyYW1ldGVyRGljdCglN0IlN0QpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTWFyayUyMHRoZSUyMHdlaWdodCUyMGFzJTIwdW5tZXJnZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLl9kaXNhYmxlX2FkYXB0ZXJzJTIwJTNEJTIwRmFsc2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1lcmdlZF9hZGFwdGVycyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYudXNlX2RvcmElM0ElMjBkaWN0JTVCc3RyJTJDJTIwYm9vbCU1RCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubG9yYV9tYWduaXR1ZGVfdmVjdG9yJTNBJTIwT3B0aW9uYWwlNUJ0b3JjaC5ubi5QYXJhbWV0ZXJEaWN0JTVEJTIwJTNEJTIwTm9uZSUyMCUyMCUyMyUyMGZvciUyMERvUkElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLl9jYWNoZXMlM0ElMjBkaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5rd2FyZ3MlMjAlM0QlMjBrd2FyZ3M=",highlighted:`<span class="hljs-comment"># showing only part of the code</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoraLayer</span>(<span class="hljs-title class_ inherited__">BaseTunerLayer</span>):
    <span class="hljs-comment"># All names of layers that may contain (trainable) adapter weights</span>
    adapter_layer_names = (<span class="hljs-string">&quot;lora_A&quot;</span>, <span class="hljs-string">&quot;lora_B&quot;</span>, <span class="hljs-string">&quot;lora_embedding_A&quot;</span>, <span class="hljs-string">&quot;lora_embedding_B&quot;</span>)
    <span class="hljs-comment"># All names of other parameters that may contain adapter-related parameters</span>
    other_param_names = (<span class="hljs-string">&quot;r&quot;</span>, <span class="hljs-string">&quot;lora_alpha&quot;</span>, <span class="hljs-string">&quot;scaling&quot;</span>, <span class="hljs-string">&quot;lora_dropout&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, base_layer: nn.Module, **kwargs</span>) -&gt; <span class="hljs-literal">None</span>:
        self.base_layer = base_layer
        self.r = {}
        self.lora_alpha = {}
        self.scaling = {}
        self.lora_dropout = nn.ModuleDict({})
        self.lora_A = nn.ModuleDict({})
        self.lora_B = nn.ModuleDict({})
        <span class="hljs-comment"># For Embedding layer</span>
        self.lora_embedding_A = nn.ParameterDict({})
        self.lora_embedding_B = nn.ParameterDict({})
        <span class="hljs-comment"># Mark the weight as unmerged</span>
        self._disable_adapters = <span class="hljs-literal">False</span>
        self.merged_adapters = []
        self.use_dora: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>] = {}
        self.lora_magnitude_vector: <span class="hljs-type">Optional</span>[torch.nn.ParameterDict] = <span class="hljs-literal">None</span>  <span class="hljs-comment"># for DoRA</span>
        self._caches: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {}
        self.kwargs = kwargs`,wrap:!1}}),S=new Me({props:{code:"c2VsZi5sb3JhX21hZ25pdHVkZV92ZWN0b3IlM0ElMjBPcHRpb25hbCU1QnRvcmNoLm5uLlBhcmFtZXRlckRpY3QlNUQlMjAlM0QlMjBOb25lJTIwJTIwJTIzJTIwZm9yJTIwRG9SQQ==",highlighted:'self.lora_magnitude_vector: <span class="hljs-type">Optional</span>[torch.nn.ParameterDict] = <span class="hljs-literal">None</span>  <span class="hljs-comment"># for DoRA</span>',wrap:!1}}),D=new J({props:{title:"adapter_config",local:"adapterconfig",headingTag:"h3"}}),K=new Me({props:{code:"JTdCJTBBJTIwJTIwJTIyYWxwaGFfcGF0dGVybiUyMiUzQSUyMCU3QiU3RCUyQyUwQSUyMCUyMCUyMmF1dG9fbWFwcGluZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmJhc2VfbW9kZWxfY2xhc3MlMjIlM0ElMjAlMjJCZXJ0TW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJlbnRfbGlicmFyeSUyMiUzQSUyMCUyMnRyYW5zZm9ybWVycy5tb2RlbHMuYmVydC5tb2RlbGluZ19iZXJ0JTIyJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMjIlM0ElMjAlMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMmJpYXMlMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIyZmFuX2luX2Zhbl9vdXQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMmluZmVyZW5jZV9tb2RlJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmluaXRfbG9yYV93ZWlnaHRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmxheWVyX3JlcGxpY2F0aW9uJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMmxheWVyc19wYXR0ZXJuJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMmxheWVyc190b190cmFuc2Zvcm0lMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIybG9mdHFfY29uZmlnJTIyJTNBJTIwJTdCJTdEJTJDJTBBJTIwJTIwJTIybG9yYV9hbHBoYSUyMiUzQSUyMDglMkMlMEElMjAlMjAlMjJsb3JhX2Ryb3BvdXQlMjIlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjJtZWdhdHJvbl9jb25maWclMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIybWVnYXRyb25fY29yZSUyMiUzQSUyMCUyMm1lZ2F0cm9uLmNvcmUlMjIlMkMlMEElMjAlMjAlMjJtb2R1bGVzX3RvX3NhdmUlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIycGVmdF90eXBlJTIyJTNBJTIwJTIyTE9SQSUyMiUyQyUwQSUyMCUyMCUyMnIlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIycmFua19wYXR0ZXJuJTIyJTNBJTIwJTdCJTdEJTJDJTBBJTIwJTIwJTIycmV2aXNpb24lMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIydGFyZ2V0X21vZHVsZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbHVlJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGFza190eXBlJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMnVzZV9kb3JhJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjJ1c2VfcnNsb3JhJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;alpha_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;auto_mapping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;base_model_class&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;BertModel&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parent_library&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;transformers.models.bert.modeling_bert&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;base_model_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fan_in_fan_out&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;inference_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;init_lora_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layer_replication&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layers_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layers_to_transform&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;loftq_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;lora_alpha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;lora_dropout&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;megatron_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;megatron_core&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;megatron.core&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;modules_to_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;LORA&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;r&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;rank_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;query&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;value&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;task_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;use_dora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;use_rslora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),se=new Me({props:{code:"JTdCJTBBJTIwJTIwJTIydGFyZ2V0X21vZHVsZXMlMjIlM0ElMjAlNUIlMjJxdWVyeSUyMiUyQyUyMCUyMnZhbHVlJTIyJTVEJTJDJTBBJTIwJTIwJTIycGVmdF90eXBlJTIyJTNBJTIwJTIyTE9SQSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;query&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;value&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;LORA&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),le=new J({props:{title:"Model storage",local:"model-storage",headingTag:"h2"}}),oe=new J({props:{title:"Merge the weights",local:"merge-the-weights",headingTag:"h3"}}),pe=new Me({props:{code:"bWVyZ2VkX21vZGVsJTIwJTNEJTIwbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBbWVyZ2VkX21vZGVsLnNhdmVfcHJldHJhaW5lZCguLi4p",highlighted:`merged_model = model.merge_and_unload()
merged_model.save_pretrained(...)`,wrap:!1}}),he=new J({props:{title:"Convert to a Transformers model",local:"convert-to-a-transformers-model",headingTag:"h3"}}),me=new Me({props:{code:"",highlighted:`model = ...  <span class="hljs-comment"># the PEFT model</span>
...
<span class="hljs-comment"># after you finish training the model, save it in a temporary location</span>
model.save_pretrained(&lt;temp_location&gt;)
<span class="hljs-comment"># now load this model directly into a transformers model, without the PEFT wrapper</span>
<span class="hljs-comment"># the PEFT weights are directly injected into the base model</span>
model_loaded = AutoModel.from_pretrained(&lt;temp_location&gt;)
<span class="hljs-comment"># now make the loaded model believe that it is _not_ a PEFT model</span>
model_loaded._hf_peft_config_loaded = <span class="hljs-literal">False</span>
<span class="hljs-comment"># now when we save it, it will save the whole model</span>
model_loaded.save_pretrained(&lt;final_location&gt;)
<span class="hljs-comment"># or upload to Hugging Face Hub</span>
model_loaded.push_to_hub(&lt;final_location&gt;)`,wrap:!1}}),ye=new ms({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/checkpoint.md"}}),{c(){y=o("meta"),Je=l(),fe=o("p"),we=l(),c(w.$$.fragment),Ue=l(),U=o("p"),U.textContent=bt,be=l(),c(b.$$.fragment),_e=l(),_=o("p"),_.textContent=_t,Ie=l(),I=o("p"),I.innerHTML=It,Ce=l(),C=o("ol"),C.innerHTML=Ct,ge=l(),g=o("p"),g.innerHTML=gt,ve=l(),v=o("p"),v.innerHTML=vt,qe=l(),M=o("ol"),M.innerHTML=qt,Be=l(),q=o("p"),q.innerHTML=Bt,Ee=l(),c(B.$$.fragment),ke=l(),E=o("p"),E.textContent=Et,Ae=l(),k=o("ul"),k.innerHTML=kt,Ze=l(),A=o("p"),A.innerHTML=At,$e=l(),T=o("ol"),T.innerHTML=Zt,xe=l(),Z=o("p"),Z.innerHTML=$t,Ve=l(),c($.$$.fragment),Fe=l(),x=o("p"),x.innerHTML=xt,Le=l(),c(V.$$.fragment),Qe=l(),F=o("p"),F.textContent=Vt,He=l(),L=o("p"),L.innerHTML=Ft,Re=l(),c(Q.$$.fragment),Xe=l(),H=o("p"),H.innerHTML=Lt,We=l(),R=o("p"),R.innerHTML=Qt,Ge=l(),X=o("ul"),X.innerHTML=Ht,Pe=l(),W=o("p"),W.textContent=Rt,Ye=l(),G=o("ul"),G.innerHTML=Xt,Ne=l(),f=o("blockquote"),f.innerHTML=Wt,Se=l(),P=o("p"),P.innerHTML=Gt,ze=l(),Y=o("p"),Y.innerHTML=Pt,De=l(),j=o("blockquote"),j.innerHTML=Yt,Oe=l(),N=o("p"),N.innerHTML=Nt,Ke=l(),c(S.$$.fragment),et=l(),z=o("p"),z.textContent=St,tt=l(),c(D.$$.fragment),st=l(),O=o("p"),O.innerHTML=zt,at=l(),c(K.$$.fragment),lt=l(),ee=o("p"),ee.innerHTML=Dt,nt=l(),te=o("p"),te.textContent=Ot,ot=l(),c(se.$$.fragment),it=l(),ae=o("p"),ae.innerHTML=Kt,pt=l(),c(le.$$.fragment),ct=l(),ne=o("p"),ne.textContent=es,rt=l(),c(oe.$$.fragment),ut=l(),ie=o("p"),ie.textContent=ts,ht=l(),c(pe.$$.fragment),dt=l(),ce=o("p"),ce.textContent=ss,mt=l(),re=o("ul"),re.innerHTML=as,yt=l(),ue=o("p"),ue.textContent=ls,Mt=l(),c(he.$$.fragment),Tt=l(),de=o("p"),de.textContent=ns,ft=l(),c(me.$$.fragment),jt=l(),c(ye.$$.fragment),Jt=l(),je=o("p"),this.h()},l(e){const t=hs("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(s),Je=n(e),fe=i(e,"P",{}),os(fe).forEach(s),we=n(e),r(w.$$.fragment,e),Ue=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-i846eh"&&(U.textContent=bt),be=n(e),r(b.$$.fragment,e),_e=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1jlobya"&&(_.textContent=_t),Ie=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-npkoss"&&(I.innerHTML=It),Ce=n(e),C=i(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-1buhd3i"&&(C.innerHTML=Ct),ge=n(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-12xl22z"&&(g.innerHTML=gt),ve=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1uhgqli"&&(v.innerHTML=vt),qe=n(e),M=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(M)!=="svelte-u9vwkh"&&(M.innerHTML=qt),Be=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-ubabis"&&(q.innerHTML=Bt),Ee=n(e),r(B.$$.fragment,e),ke=n(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-18i1sdg"&&(E.textContent=Et),Ae=n(e),k=i(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-1fi0uuu"&&(k.innerHTML=kt),Ze=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1nfr73w"&&(A.innerHTML=At),$e=n(e),T=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-11vms8t"&&(T.innerHTML=Zt),xe=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-bfnv50"&&(Z.innerHTML=$t),Ve=n(e),r($.$$.fragment,e),Fe=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1k4p1z7"&&(x.innerHTML=xt),Le=n(e),r(V.$$.fragment,e),Qe=n(e),F=i(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-kd80je"&&(F.textContent=Vt),He=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-vjr9ez"&&(L.innerHTML=Ft),Re=n(e),r(Q.$$.fragment,e),Xe=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1bnpl7i"&&(H.innerHTML=Lt),We=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-my5lpq"&&(R.innerHTML=Qt),Ge=n(e),X=i(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-18g5t5x"&&(X.innerHTML=Ht),Pe=n(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1cey2tw"&&(W.textContent=Rt),Ye=n(e),G=i(e,"UL",{"data-svelte-h":!0}),p(G)!=="svelte-12zgb0p"&&(G.innerHTML=Xt),Ne=n(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-xj9vfo"&&(f.innerHTML=Wt),Se=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1g2h6ud"&&(P.innerHTML=Gt),ze=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-bu31s0"&&(Y.innerHTML=Pt),De=n(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-a8hmi4"&&(j.innerHTML=Yt),Oe=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1bo4lop"&&(N.innerHTML=Nt),Ke=n(e),r(S.$$.fragment,e),et=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-34pnf6"&&(z.textContent=St),tt=n(e),r(D.$$.fragment,e),st=n(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-6fxao8"&&(O.innerHTML=zt),at=n(e),r(K.$$.fragment,e),lt=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-6hfyn3"&&(ee.innerHTML=Dt),nt=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-190wzyy"&&(te.textContent=Ot),ot=n(e),r(se.$$.fragment,e),it=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-19ijgni"&&(ae.innerHTML=Kt),pt=n(e),r(le.$$.fragment,e),ct=n(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1bwnzmb"&&(ne.textContent=es),rt=n(e),r(oe.$$.fragment,e),ut=n(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1k0zco1"&&(ie.textContent=ts),ht=n(e),r(pe.$$.fragment,e),dt=n(e),ce=i(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-scpch6"&&(ce.textContent=ss),mt=n(e),re=i(e,"UL",{"data-svelte-h":!0}),p(re)!=="svelte-1d2h65c"&&(re.innerHTML=as),yt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-ohejod"&&(ue.textContent=ls),Mt=n(e),r(he.$$.fragment,e),Tt=n(e),de=i(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-lzrdax"&&(de.textContent=ns),ft=n(e),r(me.$$.fragment,e),jt=n(e),r(ye.$$.fragment,e),Jt=n(e),je=i(e,"P",{}),os(je).forEach(s),this.h()},h(){Te(y,"name","hf:doc:metadata"),Te(y,"content",Ms),Te(M,"start","2"),Te(T,"start","3"),Te(f,"class","tip"),Te(j,"class","tip")},m(e,t){ds(document.head,y),a(e,Je,t),a(e,fe,t),a(e,we,t),u(w,e,t),a(e,Ue,t),a(e,U,t),a(e,be,t),u(b,e,t),a(e,_e,t),a(e,_,t),a(e,Ie,t),a(e,I,t),a(e,Ce,t),a(e,C,t),a(e,ge,t),a(e,g,t),a(e,ve,t),a(e,v,t),a(e,qe,t),a(e,M,t),a(e,Be,t),a(e,q,t),a(e,Ee,t),u(B,e,t),a(e,ke,t),a(e,E,t),a(e,Ae,t),a(e,k,t),a(e,Ze,t),a(e,A,t),a(e,$e,t),a(e,T,t),a(e,xe,t),a(e,Z,t),a(e,Ve,t),u($,e,t),a(e,Fe,t),a(e,x,t),a(e,Le,t),u(V,e,t),a(e,Qe,t),a(e,F,t),a(e,He,t),a(e,L,t),a(e,Re,t),u(Q,e,t),a(e,Xe,t),a(e,H,t),a(e,We,t),a(e,R,t),a(e,Ge,t),a(e,X,t),a(e,Pe,t),a(e,W,t),a(e,Ye,t),a(e,G,t),a(e,Ne,t),a(e,f,t),a(e,Se,t),a(e,P,t),a(e,ze,t),a(e,Y,t),a(e,De,t),a(e,j,t),a(e,Oe,t),a(e,N,t),a(e,Ke,t),u(S,e,t),a(e,et,t),a(e,z,t),a(e,tt,t),u(D,e,t),a(e,st,t),a(e,O,t),a(e,at,t),u(K,e,t),a(e,lt,t),a(e,ee,t),a(e,nt,t),a(e,te,t),a(e,ot,t),u(se,e,t),a(e,it,t),a(e,ae,t),a(e,pt,t),u(le,e,t),a(e,ct,t),a(e,ne,t),a(e,rt,t),u(oe,e,t),a(e,ut,t),a(e,ie,t),a(e,ht,t),u(pe,e,t),a(e,dt,t),a(e,ce,t),a(e,mt,t),a(e,re,t),a(e,yt,t),a(e,ue,t),a(e,Mt,t),u(he,e,t),a(e,Tt,t),a(e,de,t),a(e,ft,t),u(me,e,t),a(e,jt,t),u(ye,e,t),a(e,Jt,t),a(e,je,t),wt=!0},p:ps,i(e){wt||(h(w.$$.fragment,e),h(b.$$.fragment,e),h(B.$$.fragment,e),h($.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),wt=!0)},o(e){d(w.$$.fragment,e),d(b.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(V.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),wt=!1},d(e){e&&(s(Je),s(fe),s(we),s(Ue),s(U),s(be),s(_e),s(_),s(Ie),s(I),s(Ce),s(C),s(ge),s(g),s(ve),s(v),s(qe),s(M),s(Be),s(q),s(Ee),s(ke),s(E),s(Ae),s(k),s(Ze),s(A),s($e),s(T),s(xe),s(Z),s(Ve),s(Fe),s(x),s(Le),s(Qe),s(F),s(He),s(L),s(Re),s(Xe),s(H),s(We),s(R),s(Ge),s(X),s(Pe),s(W),s(Ye),s(G),s(Ne),s(f),s(Se),s(P),s(ze),s(Y),s(De),s(j),s(Oe),s(N),s(Ke),s(et),s(z),s(tt),s(st),s(O),s(at),s(lt),s(ee),s(nt),s(te),s(ot),s(it),s(ae),s(pt),s(ct),s(ne),s(rt),s(ut),s(ie),s(ht),s(dt),s(ce),s(mt),s(re),s(yt),s(ue),s(Mt),s(Tt),s(de),s(ft),s(jt),s(Jt),s(je)),s(y),m(w,e),m(b,e),m(B,e),m($,e),m(V,e),m(Q,e),m(S,e),m(D,e),m(K,e),m(se,e),m(le,e),m(oe,e),m(pe,e),m(he,e),m(me,e),m(ye,e)}}}const Ms='{"title":"PEFT checkpoint format","local":"peft-checkpoint-format","sections":[{"title":"PEFT files","local":"peft-files","sections":[],"depth":2},{"title":"Convert to PEFT format","local":"convert-to-peft-format","sections":[{"title":"adapter_model","local":"adaptermodel","sections":[],"depth":3},{"title":"adapter_config","local":"adapterconfig","sections":[],"depth":3}],"depth":2},{"title":"Model storage","local":"model-storage","sections":[{"title":"Merge the weights","local":"merge-the-weights","sections":[],"depth":3},{"title":"Convert to a Transformers model","local":"convert-to-a-transformers-model","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ts(Ut){return cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends rs{constructor(y){super(),us(this,y,Ts,ys,is,{})}}export{Us as component};
