import{s as yt,n as it,o as rt}from"../chunks/scheduler.c59d9fbb.js";import{S as mt,i as ct,g as i,s as a,r as J,A as ot,h as r,f as e,c as n,j as Tt,u as U,x as c,k as pt,y as jt,a as l,v as M,d as T,t as p,w as y}from"../chunks/index.a47918e3.js";import{C as m}from"../chunks/CodeBlock.f26209eb.js";import{D as ht}from"../chunks/DocNotebookDropdown.537a75c5.js";import{H as es,E as gt}from"../chunks/getInferenceSnippets.5e4e569f.js";function wt(Hs){let o,ns,ls,Js,j,Us,h,Ms,g,qs="Your class names are likely already good descriptors of the text that you’re looking to classify. With 🤗 SetFit, you can use these class names with strong pretrained Sentence Transformer models to get a strong baseline model without any training samples.",Ts,w,Ds="This guide will show you how to perform zero-shot text classification.",ps,d,ys,b,Ls='We’ll use the <a href="https://huggingface.co/datasets/dair-ai/emotion" rel="nofollow">dair-ai/emotion</a> dataset to test the performance of our zero-shot model.',is,u,rs,f,Ps="This dataset stores the class names within the dataset <code>Features</code>, so we’ll extract the classes like so:",ms,k,cs,C,Ks="Otherwise, we could manually set the list of classes.",os,I,js,$,Os='Then, we can use <a href="/docs/setfit/main/en/reference/utility#setfit.get_templated_dataset">get_templated_dataset()</a> to synthetically generate a dummy dataset given these class names.',hs,A,gs,Z,ws,x,ds,G,st="We can use this dataset to train a SetFit model just like normal:",bs,B,us,z,fs,W,tt="Once trained, we can evaluate the model:",ks,R,Cs,X,Is,_,et="And run predictions:",$s,N,As,Y,Zs,Q,lt="These predictions all look right!",xs,V,Gs,F,at="To show that the zero-shot performance of SetFit works well, we’ll compare it against a zero-shot classification model from <code>transformers</code>.",Bs,S,zs,v,Ws,E,nt="With its 59.1% accuracy, the 0-shot SetFit heavily outperforms the recommended zero-shot model by <code>transformers</code>.",Rs,H,Xs,q,Jt="Beyond getting higher accuracies, SetFit is much faster too. Let’s compute the latency of SetFit with <code>BAAI/bge-small-en-v1.5</code> versus the latency of <code>transformers</code> with <code>facebook/bart-large-mnli</code>. Both tests were performed on a GPU.",_s,D,Ns,L,Ys,P,Qs,K,Vs,O,Ut="So, SetFit with <code>BAAI/bge-small-en-v1.5</code> is 67x faster than <code>transformers</code> with <code>facebook/bart-large-mnli</code>, alongside being more accurate:",Fs,ss,Mt='<img src="https://github.com/huggingface/setfit/assets/37621491/33f574d9-c51b-4e02-8d98-6e04e18427ef" alt="zero_shot_transformers_vs_setfit"/>',Ss,ts,vs,as,Es;return j=new es({props:{title:"Zero-shot Text Classification",local:"zero-shot-text-classification",headingTag:"h1"}}),h=new ht({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/zero_shot.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/pytorch/zero_shot.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/setfit_doc/en/tensorflow/zero_shot.ipynb"}]}}),d=new es({props:{title:"Testing dataset",local:"testing-dataset",headingTag:"h2"}}),u=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmRhaXItYWklMkZlbW90aW9uJTIyJTJDJTIwJTIyc3BsaXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRlc3QlMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

test_dataset = load_dataset(<span class="hljs-string">&quot;dair-ai/emotion&quot;</span>, <span class="hljs-string">&quot;split&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)`,wrap:!1}}),k=new m({props:{code:"Y2xhc3NlcyUyMCUzRCUyMHRlc3RfZGF0YXNldC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBJTIzJTIwJTNEJTNFJTIwJTVCJ3NhZG5lc3MnJTJDJTIwJ2pveSclMkMlMjAnbG92ZSclMkMlMjAnYW5nZXInJTJDJTIwJ2ZlYXInJTJDJTIwJ3N1cnByaXNlJyU1RA==",highlighted:`classes = test_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names
<span class="hljs-comment"># =&gt; [&#x27;sadness&#x27;, &#x27;joy&#x27;, &#x27;love&#x27;, &#x27;anger&#x27;, &#x27;fear&#x27;, &#x27;surprise&#x27;]</span>`,wrap:!1}}),I=new es({props:{title:"Synthetic dataset",local:"synthetic-dataset",headingTag:"h2"}}),A=new m({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMGdldF90ZW1wbGF0ZWRfZGF0YXNldCUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBnZXRfdGVtcGxhdGVkX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> get_templated_dataset

train_dataset = get_templated_dataset()`,wrap:!1}}),Z=new m({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldCklMEElMjMlMjAlM0QlM0UlMjBEYXRhc2V0KCU3QiUwQSUyMyUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3RleHQnJTJDJTIwJ2xhYmVsJyU1RCUyQyUwQSUyMyUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDglMEElMjMlMjAlN0QpJTBBcHJpbnQodHJhaW5fZGF0YXNldCU1QjAlNUQpJTBBJTIzJTIwJTdCJ3RleHQnJTNBJTIwJ1RoaXMlMjBzZW50ZW5jZSUyMGlzJTIwc2FkbmVzcyclMkMlMjAnbGFiZWwnJTNBJTIwMCU3RA==",highlighted:`<span class="hljs-built_in">print</span>(train_dataset)
<span class="hljs-comment"># =&gt; Dataset({</span>
<span class="hljs-comment">#     features: [&#x27;text&#x27;, &#x27;label&#x27;],</span>
<span class="hljs-comment">#     num_rows: 48</span>
<span class="hljs-comment"># })</span>
<span class="hljs-built_in">print</span>(train_dataset[<span class="hljs-number">0</span>])
<span class="hljs-comment"># {&#x27;text&#x27;: &#x27;This sentence is sadness&#x27;, &#x27;label&#x27;: 0}</span>`,wrap:!1}}),x=new es({props:{title:"Training",local:"training",headingTag:"h2"}}),B=new m({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTJDJTIwVHJhaW5lciUyQyUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyKSUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTNEMSUyQyUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRHRlc3RfZGF0YXNldCUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments

model = SetFitModel.from_pretrained(<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)

args = TrainingArguments(
    batch_size=<span class="hljs-number">32</span>,
    num_epochs=<span class="hljs-number">1</span>,
)

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=test_dataset,
)
trainer.train()`,wrap:!1}}),z=new m({props:{code:"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",highlighted:`***** Running training *****
  <span class="hljs-type">Num</span> <span class="hljs-variable">examples</span> <span class="hljs-operator">=</span> <span class="hljs-number">60</span>
  <span class="hljs-type">Num</span> <span class="hljs-variable">epochs</span> <span class="hljs-operator">=</span> <span class="hljs-number">1</span>
  Total <span class="hljs-type">optimization</span> <span class="hljs-variable">steps</span> <span class="hljs-operator">=</span> <span class="hljs-number">60</span>
  Total train <span class="hljs-type">batch</span> <span class="hljs-variable">size</span> <span class="hljs-operator">=</span> <span class="hljs-number">32</span>
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.2628</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.3333333333333333e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.02</span>}                                                                                 
{<span class="hljs-string">&#x27;embedding_loss&#x27;</span>: <span class="hljs-number">0.0222</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>: <span class="hljs-number">3.7037037037037037e-06</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">0.83</span>}                                                                                 
{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-number">15.4717</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-number">124.098</span>, <span class="hljs-string">&#x27;train_steps_per_second&#x27;</span>: <span class="hljs-number">3.878</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-number">1.0</span>}                                                     
<span class="hljs-number">100</span>%|█████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| <span class="hljs-number">60</span>/<span class="hljs-number">60</span> [<span class="hljs-number">00</span>:09&lt;<span class="hljs-number">00</span>:<span class="hljs-number">00</span>,  <span class="hljs-number">6.</span>35it/s]`,wrap:!1}}),R=new m({props:{code:"bWV0cmljcyUyMCUzRCUyMHRyYWluZXIuZXZhbHVhdGUoKSUwQXByaW50KG1ldHJpY3Mp",highlighted:`metrics = trainer.evaluate()
<span class="hljs-built_in">print</span>(metrics)`,wrap:!1}}),X=new m({props:{code:"KioqKiolMjBSdW5uaW5nJTIwZXZhbHVhdGlvbiUyMCoqKioqJTBBJTdCJ2FjY3VyYWN5JyUzQSUyMDAuNTkxJTdE",highlighted:`<span class="hljs-bullet">***** </span>Running evaluation <span class="hljs-strong">*****</span>
{<span class="hljs-emphasis">&#x27;accuracy&#x27;</span>: 0.591}`,wrap:!1}}),N=new m({props:{code:"cHJlZHMlMjAlM0QlMjBtb2RlbC5wcmVkaWN0KCU1QiUwQSUyMCUyMCUyMCUyMCUyMmklMjBhbSUyMGp1c3QlMjBmZWVsaW5nJTIwY3Jhbmt5JTIwYW5kJTIwYmx1ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmklMjBmZWVsJTIwaW5jcmVkaWJseSUyMGx1Y2t5JTIwanVzdCUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB0YWxrJTIwdG8lMjBoZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ5b3UncmUlMjBwaXNzaW5nJTIwbWUlMjBvZmYlMjByaWdodCUyMG5vdyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmklMjBkZWZpbml0ZWx5JTIwaGF2ZSUyMHRoYWxhc3NvcGhvYmlhJTJDJTIwZG9uJ3QlMjBnZXQlMjBtZSUyMG5lYXIlMjB3YXRlciUyMGxpa2UlMjB0aGF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyaSUyMGRpZCUyMG5vdCUyMHNlZSUyMHRoYXQlMjBjb21pbmclMjBhdCUyMGFsbCUyMiUyQyUwQSU1RCklMEFwcmludCglNUJjbGFzc2VzJTVCaWR4JTVEJTIwZm9yJTIwaWR4JTIwaW4lMjBwcmVkcyU1RCk=",highlighted:`preds = model.predict([
    <span class="hljs-string">&quot;i am just feeling cranky and blue&quot;</span>,
    <span class="hljs-string">&quot;i feel incredibly lucky just to be able to talk to her&quot;</span>,
    <span class="hljs-string">&quot;you&#x27;re pissing me off right now&quot;</span>,
    <span class="hljs-string">&quot;i definitely have thalassophobia, don&#x27;t get me near water like that&quot;</span>,
    <span class="hljs-string">&quot;i did not see that coming at all&quot;</span>,
])
<span class="hljs-built_in">print</span>([classes[idx] <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> preds])`,wrap:!1}}),Y=new m({props:{code:"JTVCJ3NhZG5lc3MnJTJDJTIwJ2pveSclMkMlMjAnYW5nZXInJTJDJTIwJ2ZlYXInJTJDJTIwJ3N1cnByaXNlJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;sadness&#x27;</span>, <span class="hljs-string">&#x27;joy&#x27;</span>, <span class="hljs-string">&#x27;anger&#x27;</span>, <span class="hljs-string">&#x27;fear&#x27;</span>, <span class="hljs-string">&#x27;surprise&#x27;</span>]',wrap:!1}}),V=new es({props:{title:"Baseline",local:"baseline",headingTag:"h2"}}),S=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwZXZhbHVhdGUlMEElMEElMjMlMjBQcmVwYXJlJTIwdGhlJTIwdGVzdGluZyUyMGRhdGFzZXQlMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGFpci1haSUyRmVtb3Rpb24lMjIlMkMlMjAlMjJzcGxpdCUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiklMEFjbGFzc2VzJTIwJTNEJTIwdGVzdF9kYXRhc2V0LmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMHplcm8tc2hvdCUyMGNsYXNzaWZpY2F0aW9uJTIwcGlwZWxpbmUlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwVXNlcyUyMCdmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSclMjBieSUyMGRlZmF1bHQlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwZGV2aWNlJTNEMCklMEF6ZXJvc2hvdF9wcmVkcyUyMCUzRCUyMHBpcGUodGVzdF9kYXRhc2V0JTVCJTIydGV4dCUyMiU1RCUyQyUyMGJhdGNoX3NpemUlM0QxNiUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RjbGFzc2VzKSUwQXByZWRzJTIwJTNEJTIwJTVCY2xhc3Nlcy5pbmRleChwcmVkJTVCJTIybGFiZWxzJTIyJTVEJTVCMCU1RCklMjBmb3IlMjBwcmVkJTIwaW4lMjB6ZXJvc2hvdF9wcmVkcyU1RCUwQSUwQSUyMyUyMENvbXB1dGUlMjB0aGUlMjBhY2N1cmFjeSUwQW1ldHJpYyUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIpJTBBdHJhbnNmb3JtZXJzX2FjY3VyYWN5JTIwJTNEJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkcyUyQyUyMHJlZmVyZW5jZXMlM0R0ZXN0X2RhdGFzZXQlNUIlMjJsYWJlbCUyMiU1RCklMEFwcmludCh0cmFuc2Zvcm1lcnNfYWNjdXJhY3kp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> evaluate

<span class="hljs-comment"># Prepare the testing dataset</span>
test_dataset = load_dataset(<span class="hljs-string">&quot;dair-ai/emotion&quot;</span>, <span class="hljs-string">&quot;split&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
classes = test_dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names

<span class="hljs-comment"># Set up the zero-shot classification pipeline from transformers</span>
<span class="hljs-comment"># Uses &#x27;facebook/bart-large-mnli&#x27; by default</span>
pipe = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, device=<span class="hljs-number">0</span>)
zeroshot_preds = pipe(test_dataset[<span class="hljs-string">&quot;text&quot;</span>], batch_size=<span class="hljs-number">16</span>, candidate_labels=classes)
preds = [classes.index(pred[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> zeroshot_preds]

<span class="hljs-comment"># Compute the accuracy</span>
metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)
transformers_accuracy = metric.compute(predictions=preds, references=test_dataset[<span class="hljs-string">&quot;label&quot;</span>])
<span class="hljs-built_in">print</span>(transformers_accuracy)`,wrap:!1}}),v=new m({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuMzc2NSU3RA==",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.3765</span>}',wrap:!1}}),H=new es({props:{title:"Prediction latency",local:"prediction-latency",headingTag:"h2"}}),D=new m({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3QlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXBpcGUodGVzdF9kYXRhc2V0JTVCJTIydGV4dCUyMiU1RCUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMGNhbmRpZGF0ZV9sYWJlbHMlM0RjbGFzc2VzKSUwQWRlbHRhX3QlMjAlM0QlMjB0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90JTBBcHJpbnQoZiUyMiU2MHRyYW5zZm9ybWVycyU2MCUyMHdpdGglMjAlNjBmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSU2MCUyMGxhdGVuY3klM0ElMjAlN0JkZWx0YV90JTIwJTJGJTIwbGVuKHRlc3RfZGF0YXNldCU1Qid0ZXh0JyU1RCklMjAqJTIwMTAwMCUzQS40ZiU3RG1zJTIwcGVyJTIwc2VudGVuY2UlMjIp",highlighted:`<span class="hljs-keyword">import</span> time

start_t = time.time()
pipe(test_dataset[<span class="hljs-string">&quot;text&quot;</span>], batch_size=<span class="hljs-number">32</span>, candidate_labels=classes)
delta_t = time.time() - start_t
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\`transformers\` with \`facebook/bart-large-mnli\` latency: <span class="hljs-subst">{delta_t / <span class="hljs-built_in">len</span>(test_dataset[<span class="hljs-string">&#x27;text&#x27;</span>]) * <span class="hljs-number">1000</span>:<span class="hljs-number">.4</span>f}</span>ms per sentence&quot;</span>)`,wrap:!1}}),L=new m({props:{code:"JTYwdHJhbnNmb3JtZXJzJTYwJTIwd2l0aCUyMCU2MGZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJTYwJTIwbGF0ZW5jeSUzQSUyMDMxLjE3NjVtcyUyMHBlciUyMHNlbnRlbmNl",highlighted:'`transformers` with `facebook/bart-large-mnli` latency: <span class="hljs-number">31.1765</span>ms per sentence',wrap:!1}}),P=new m({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3QlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQW1vZGVsLnByZWRpY3QodGVzdF9kYXRhc2V0JTVCJTIydGV4dCUyMiU1RCklMEFkZWx0YV90JTIwJTNEJTIwdGltZS50aW1lKCklMjAtJTIwc3RhcnRfdCUwQXByaW50KGYlMjJTZXRGaXQlMjB3aXRoJTIwJTYwQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTYwJTIwbGF0ZW5jeSUzQSUyMCU3QmRlbHRhX3QlMjAlMkYlMjBsZW4odGVzdF9kYXRhc2V0JTVCJ3RleHQnJTVEKSUyMColMjAxMDAwJTNBLjRmJTdEbXMlMjBwZXIlMjBzZW50ZW5jZSUyMik=",highlighted:`<span class="hljs-keyword">import</span> time

start_t = time.time()
model.predict(test_dataset[<span class="hljs-string">&quot;text&quot;</span>])
delta_t = time.time() - start_t
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SetFit with \`BAAI/bge-small-en-v1.5\` latency: <span class="hljs-subst">{delta_t / <span class="hljs-built_in">len</span>(test_dataset[<span class="hljs-string">&#x27;text&#x27;</span>]) * <span class="hljs-number">1000</span>:<span class="hljs-number">.4</span>f}</span>ms per sentence&quot;</span>)`,wrap:!1}}),K=new m({props:{code:"U2V0Rml0JTIwd2l0aCUyMCU2MEJBQUklMkZiZ2Utc21hbGwtZW4tdjEuNSU2MCUyMGxhdGVuY3klM0ElMjAwLjQ2MDBtcyUyMHBlciUyMHNlbnRlbmNl",highlighted:'<span class="hljs-attribute">SetFit</span> with `BAAI/bge-small-en-v1.<span class="hljs-number">5</span>` latency: <span class="hljs-number">0</span>.<span class="hljs-number">4600</span>ms per sentence',wrap:!1}}),ts=new gt({props:{source:"https://github.com/huggingface/setfit/blob/main/docs/source/en/how_to/zero_shot.mdx"}}),{c(){o=i("meta"),ns=a(),ls=i("p"),Js=a(),J(j.$$.fragment),Us=a(),J(h.$$.fragment),Ms=a(),g=i("p"),g.textContent=qs,Ts=a(),w=i("p"),w.textContent=Ds,ps=a(),J(d.$$.fragment),ys=a(),b=i("p"),b.innerHTML=Ls,is=a(),J(u.$$.fragment),rs=a(),f=i("p"),f.innerHTML=Ps,ms=a(),J(k.$$.fragment),cs=a(),C=i("p"),C.textContent=Ks,os=a(),J(I.$$.fragment),js=a(),$=i("p"),$.innerHTML=Os,hs=a(),J(A.$$.fragment),gs=a(),J(Z.$$.fragment),ws=a(),J(x.$$.fragment),ds=a(),G=i("p"),G.textContent=st,bs=a(),J(B.$$.fragment),us=a(),J(z.$$.fragment),fs=a(),W=i("p"),W.textContent=tt,ks=a(),J(R.$$.fragment),Cs=a(),J(X.$$.fragment),Is=a(),_=i("p"),_.textContent=et,$s=a(),J(N.$$.fragment),As=a(),J(Y.$$.fragment),Zs=a(),Q=i("p"),Q.textContent=lt,xs=a(),J(V.$$.fragment),Gs=a(),F=i("p"),F.innerHTML=at,Bs=a(),J(S.$$.fragment),zs=a(),J(v.$$.fragment),Ws=a(),E=i("p"),E.innerHTML=nt,Rs=a(),J(H.$$.fragment),Xs=a(),q=i("p"),q.innerHTML=Jt,_s=a(),J(D.$$.fragment),Ns=a(),J(L.$$.fragment),Ys=a(),J(P.$$.fragment),Qs=a(),J(K.$$.fragment),Vs=a(),O=i("p"),O.innerHTML=Ut,Fs=a(),ss=i("p"),ss.innerHTML=Mt,Ss=a(),J(ts.$$.fragment),vs=a(),as=i("p"),this.h()},l(s){const t=ot("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(e),ns=n(s),ls=r(s,"P",{}),Tt(ls).forEach(e),Js=n(s),U(j.$$.fragment,s),Us=n(s),U(h.$$.fragment,s),Ms=n(s),g=r(s,"P",{"data-svelte-h":!0}),c(g)!=="svelte-u49hsh"&&(g.textContent=qs),Ts=n(s),w=r(s,"P",{"data-svelte-h":!0}),c(w)!=="svelte-13fxshi"&&(w.textContent=Ds),ps=n(s),U(d.$$.fragment,s),ys=n(s),b=r(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1i80jyz"&&(b.innerHTML=Ls),is=n(s),U(u.$$.fragment,s),rs=n(s),f=r(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-1gwdkg3"&&(f.innerHTML=Ps),ms=n(s),U(k.$$.fragment,s),cs=n(s),C=r(s,"P",{"data-svelte-h":!0}),c(C)!=="svelte-2dxojw"&&(C.textContent=Ks),os=n(s),U(I.$$.fragment,s),js=n(s),$=r(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-1n14wev"&&($.innerHTML=Os),hs=n(s),U(A.$$.fragment,s),gs=n(s),U(Z.$$.fragment,s),ws=n(s),U(x.$$.fragment,s),ds=n(s),G=r(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-10h3047"&&(G.textContent=st),bs=n(s),U(B.$$.fragment,s),us=n(s),U(z.$$.fragment,s),fs=n(s),W=r(s,"P",{"data-svelte-h":!0}),c(W)!=="svelte-24emgz"&&(W.textContent=tt),ks=n(s),U(R.$$.fragment,s),Cs=n(s),U(X.$$.fragment,s),Is=n(s),_=r(s,"P",{"data-svelte-h":!0}),c(_)!=="svelte-io97e0"&&(_.textContent=et),$s=n(s),U(N.$$.fragment,s),As=n(s),U(Y.$$.fragment,s),Zs=n(s),Q=r(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-16fgheu"&&(Q.textContent=lt),xs=n(s),U(V.$$.fragment,s),Gs=n(s),F=r(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1xcvsej"&&(F.innerHTML=at),Bs=n(s),U(S.$$.fragment,s),zs=n(s),U(v.$$.fragment,s),Ws=n(s),E=r(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1anyja6"&&(E.innerHTML=nt),Rs=n(s),U(H.$$.fragment,s),Xs=n(s),q=r(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1a47b37"&&(q.innerHTML=Jt),_s=n(s),U(D.$$.fragment,s),Ns=n(s),U(L.$$.fragment,s),Ys=n(s),U(P.$$.fragment,s),Qs=n(s),U(K.$$.fragment,s),Vs=n(s),O=r(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-n991oh"&&(O.innerHTML=Ut),Fs=n(s),ss=r(s,"P",{"data-svelte-h":!0}),c(ss)!=="svelte-bqzz6k"&&(ss.innerHTML=Mt),Ss=n(s),U(ts.$$.fragment,s),vs=n(s),as=r(s,"P",{}),Tt(as).forEach(e),this.h()},h(){pt(o,"name","hf:doc:metadata"),pt(o,"content",dt)},m(s,t){jt(document.head,o),l(s,ns,t),l(s,ls,t),l(s,Js,t),M(j,s,t),l(s,Us,t),M(h,s,t),l(s,Ms,t),l(s,g,t),l(s,Ts,t),l(s,w,t),l(s,ps,t),M(d,s,t),l(s,ys,t),l(s,b,t),l(s,is,t),M(u,s,t),l(s,rs,t),l(s,f,t),l(s,ms,t),M(k,s,t),l(s,cs,t),l(s,C,t),l(s,os,t),M(I,s,t),l(s,js,t),l(s,$,t),l(s,hs,t),M(A,s,t),l(s,gs,t),M(Z,s,t),l(s,ws,t),M(x,s,t),l(s,ds,t),l(s,G,t),l(s,bs,t),M(B,s,t),l(s,us,t),M(z,s,t),l(s,fs,t),l(s,W,t),l(s,ks,t),M(R,s,t),l(s,Cs,t),M(X,s,t),l(s,Is,t),l(s,_,t),l(s,$s,t),M(N,s,t),l(s,As,t),M(Y,s,t),l(s,Zs,t),l(s,Q,t),l(s,xs,t),M(V,s,t),l(s,Gs,t),l(s,F,t),l(s,Bs,t),M(S,s,t),l(s,zs,t),M(v,s,t),l(s,Ws,t),l(s,E,t),l(s,Rs,t),M(H,s,t),l(s,Xs,t),l(s,q,t),l(s,_s,t),M(D,s,t),l(s,Ns,t),M(L,s,t),l(s,Ys,t),M(P,s,t),l(s,Qs,t),M(K,s,t),l(s,Vs,t),l(s,O,t),l(s,Fs,t),l(s,ss,t),l(s,Ss,t),M(ts,s,t),l(s,vs,t),l(s,as,t),Es=!0},p:it,i(s){Es||(T(j.$$.fragment,s),T(h.$$.fragment,s),T(d.$$.fragment,s),T(u.$$.fragment,s),T(k.$$.fragment,s),T(I.$$.fragment,s),T(A.$$.fragment,s),T(Z.$$.fragment,s),T(x.$$.fragment,s),T(B.$$.fragment,s),T(z.$$.fragment,s),T(R.$$.fragment,s),T(X.$$.fragment,s),T(N.$$.fragment,s),T(Y.$$.fragment,s),T(V.$$.fragment,s),T(S.$$.fragment,s),T(v.$$.fragment,s),T(H.$$.fragment,s),T(D.$$.fragment,s),T(L.$$.fragment,s),T(P.$$.fragment,s),T(K.$$.fragment,s),T(ts.$$.fragment,s),Es=!0)},o(s){p(j.$$.fragment,s),p(h.$$.fragment,s),p(d.$$.fragment,s),p(u.$$.fragment,s),p(k.$$.fragment,s),p(I.$$.fragment,s),p(A.$$.fragment,s),p(Z.$$.fragment,s),p(x.$$.fragment,s),p(B.$$.fragment,s),p(z.$$.fragment,s),p(R.$$.fragment,s),p(X.$$.fragment,s),p(N.$$.fragment,s),p(Y.$$.fragment,s),p(V.$$.fragment,s),p(S.$$.fragment,s),p(v.$$.fragment,s),p(H.$$.fragment,s),p(D.$$.fragment,s),p(L.$$.fragment,s),p(P.$$.fragment,s),p(K.$$.fragment,s),p(ts.$$.fragment,s),Es=!1},d(s){s&&(e(ns),e(ls),e(Js),e(Us),e(Ms),e(g),e(Ts),e(w),e(ps),e(ys),e(b),e(is),e(rs),e(f),e(ms),e(cs),e(C),e(os),e(js),e($),e(hs),e(gs),e(ws),e(ds),e(G),e(bs),e(us),e(fs),e(W),e(ks),e(Cs),e(Is),e(_),e($s),e(As),e(Zs),e(Q),e(xs),e(Gs),e(F),e(Bs),e(zs),e(Ws),e(E),e(Rs),e(Xs),e(q),e(_s),e(Ns),e(Ys),e(Qs),e(Vs),e(O),e(Fs),e(ss),e(Ss),e(vs),e(as)),e(o),y(j,s),y(h,s),y(d,s),y(u,s),y(k,s),y(I,s),y(A,s),y(Z,s),y(x,s),y(B,s),y(z,s),y(R,s),y(X,s),y(N,s),y(Y,s),y(V,s),y(S,s),y(v,s),y(H,s),y(D,s),y(L,s),y(P,s),y(K,s),y(ts,s)}}}const dt='{"title":"Zero-shot Text Classification","local":"zero-shot-text-classification","sections":[{"title":"Testing dataset","local":"testing-dataset","sections":[],"depth":2},{"title":"Synthetic dataset","local":"synthetic-dataset","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Baseline","local":"baseline","sections":[],"depth":2},{"title":"Prediction latency","local":"prediction-latency","sections":[],"depth":2}],"depth":1}';function bt(Hs){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends mt{constructor(o){super(),ct(this,o,bt,wt,yt,{})}}export{$t as component};
