import{s as xe,n as ke,o as $e}from"../chunks/scheduler.85c25b89.js";import{S as Ue,i as Ie,g as a,s as i,u as c,A as Ce,h as n,f as e,c as o,j as h,v as d,y as m,k as p,o as r,a as l,w as f,d as u,t as g,x as w}from"../chunks/index.9633332f.js";import{I as ct}from"../chunks/IconCopyLink.a4acffac.js";import{C as at}from"../chunks/CodeBlock.00597c71.js";function Ne(qt){let M,dt,nt,ft,j,v,it,I,Yt,O,Dt="(Tensorflow) EfficientNet",ut,C,Kt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",gt,N,Ot="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",wt,Z,te='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>, in addition to <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a>.',Mt,E,ee='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',jt,y,x,ot,_,zt,tt,se="How do I use this model on an image?",yt,B,le="To load a pretrained model:",Jt,W,bt,G,ae="To load and preprocess the image:",Tt,A,vt,Q,ne="To get the model predictions:",xt,R,kt,V,ie="To get the top-5 predictions class names:",$t,X,Ut,S,oe="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_b0</code>. You can find the IDs in the model summaries at the top of this page.",It,H,pe='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ct,J,k,pt,Y,Ft,et,re="How do I finetune this model?",Nt,z,me="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Zt,F,Et,P,he=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,_t,b,$,rt,L,Pt,st,ce="How do I train this model?",Bt,q,de='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Wt,T,U,mt,D,Lt,lt,fe="Citation",Gt,K,At,ht,Qt;return I=new ct({}),_=new ct({}),W=new at({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9iMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),A=new at({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),R=new at({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),X=new at({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),Y=new ct({}),F=new at({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2IwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_b0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),L=new ct({}),D=new ct({}),K=new at({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`}}),{c(){M=a("meta"),dt=i(),nt=a("p"),ft=i(),j=a("h1"),v=a("a"),it=a("span"),c(I.$$.fragment),Yt=i(),O=a("span"),O.textContent=Dt,ut=i(),C=a("p"),C.innerHTML=Kt,gt=i(),N=a("p"),N.textContent=Ot,wt=i(),Z=a("p"),Z.innerHTML=te,Mt=i(),E=a("p"),E.innerHTML=ee,jt=i(),y=a("h2"),x=a("a"),ot=a("span"),c(_.$$.fragment),zt=i(),tt=a("span"),tt.textContent=se,yt=i(),B=a("p"),B.textContent=le,Jt=i(),c(W.$$.fragment),bt=i(),G=a("p"),G.textContent=ae,Tt=i(),c(A.$$.fragment),vt=i(),Q=a("p"),Q.textContent=ne,xt=i(),c(R.$$.fragment),kt=i(),V=a("p"),V.textContent=ie,$t=i(),c(X.$$.fragment),Ut=i(),S=a("p"),S.innerHTML=oe,It=i(),H=a("p"),H.innerHTML=pe,Ct=i(),J=a("h2"),k=a("a"),pt=a("span"),c(Y.$$.fragment),Ft=i(),et=a("span"),et.textContent=re,Nt=i(),z=a("p"),z.textContent=me,Zt=i(),c(F.$$.fragment),Et=i(),P=a("p"),P.innerHTML=he,_t=i(),b=a("h2"),$=a("a"),rt=a("span"),c(L.$$.fragment),Pt=i(),st=a("span"),st.textContent=ce,Bt=i(),q=a("p"),q.innerHTML=de,Wt=i(),T=a("h2"),U=a("a"),mt=a("span"),c(D.$$.fragment),Lt=i(),lt=a("span"),lt.textContent=fe,Gt=i(),c(K.$$.fragment),At=i(),ht=a("p"),this.h()},l(t){const s=Ce("svelte-1phssyn",document.head);M=n(s,"META",{name:!0,content:!0}),s.forEach(e),dt=o(t),nt=n(t,"P",{}),h(nt).forEach(e),ft=o(t),j=n(t,"H1",{class:!0});var Rt=h(j);v=n(Rt,"A",{id:!0,class:!0,href:!0});var ue=h(v);it=n(ue,"SPAN",{});var ge=h(it);d(I.$$.fragment,ge),ge.forEach(e),ue.forEach(e),Yt=o(Rt),O=n(Rt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1dz75hh"&&(O.textContent=Dt),Rt.forEach(e),ut=o(t),C=n(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1bwkfja"&&(C.innerHTML=Kt),gt=o(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5z334a"&&(N.textContent=Ot),wt=o(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1j8z7ka"&&(Z.innerHTML=te),Mt=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-k8hpf1"&&(E.innerHTML=ee),jt=o(t),y=n(t,"H2",{class:!0});var Vt=h(y);x=n(Vt,"A",{id:!0,class:!0,href:!0});var we=h(x);ot=n(we,"SPAN",{});var Me=h(ot);d(_.$$.fragment,Me),Me.forEach(e),we.forEach(e),zt=o(Vt),tt=n(Vt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1c1hspn"&&(tt.textContent=se),Vt.forEach(e),yt=o(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-18ywhxh"&&(B.textContent=le),Jt=o(t),d(W.$$.fragment,t),bt=o(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1c2ipa8"&&(G.textContent=ae),Tt=o(t),d(A.$$.fragment,t),vt=o(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1n9qsq1"&&(Q.textContent=ne),xt=o(t),d(R.$$.fragment,t),kt=o(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-19cnvx1"&&(V.textContent=ie),$t=o(t),d(X.$$.fragment,t),Ut=o(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1jdhw10"&&(S.innerHTML=oe),It=o(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1wmi3ea"&&(H.innerHTML=pe),Ct=o(t),J=n(t,"H2",{class:!0});var Xt=h(J);k=n(Xt,"A",{id:!0,class:!0,href:!0});var je=h(k);pt=n(je,"SPAN",{});var ye=h(pt);d(Y.$$.fragment,ye),ye.forEach(e),je.forEach(e),Ft=o(Xt),et=n(Xt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-1viv4qv"&&(et.textContent=re),Xt.forEach(e),Nt=o(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-9sr7nh"&&(z.textContent=me),Zt=o(t),d(F.$$.fragment,t),Et=o(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1kguc51"&&(P.innerHTML=he),_t=o(t),b=n(t,"H2",{class:!0});var St=h(b);$=n(St,"A",{id:!0,class:!0,href:!0});var Je=h($);rt=n(Je,"SPAN",{});var be=h(rt);d(L.$$.fragment,be),be.forEach(e),Je.forEach(e),Pt=o(St),st=n(St,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-1ce591d"&&(st.textContent=ce),St.forEach(e),Bt=o(t),q=n(t,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1n0coha"&&(q.innerHTML=de),Wt=o(t),T=n(t,"H2",{class:!0});var Ht=h(T);U=n(Ht,"A",{id:!0,class:!0,href:!0});var Te=h(U);mt=n(Te,"SPAN",{});var ve=h(mt);d(D.$$.fragment,ve),ve.forEach(e),Te.forEach(e),Lt=o(Ht),lt=n(Ht,"SPAN",{"data-svelte-h":!0}),m(lt)!=="svelte-15mb3gy"&&(lt.textContent=fe),Ht.forEach(e),Gt=o(t),d(K.$$.fragment,t),At=o(t),ht=n(t,"P",{}),h(ht).forEach(e),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",JSON.stringify(Ze)),p(v,"id","tensorflow-efficientnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#tensorflow-efficientnet"),p(j,"class","relative group"),p(x,"id","how-do-i-use-this-model-on-an-image"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-use-this-model-on-an-image"),p(y,"class","relative group"),p(k,"id","how-do-i-finetune-this-model"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p($,"id","how-do-i-train-this-model"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#how-do-i-train-this-model"),p(b,"class","relative group"),p(U,"id","citation"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#citation"),p(T,"class","relative group")},m(t,s){r(document.head,M),l(t,dt,s),l(t,nt,s),l(t,ft,s),l(t,j,s),r(j,v),r(v,it),f(I,it,null),r(j,Yt),r(j,O),l(t,ut,s),l(t,C,s),l(t,gt,s),l(t,N,s),l(t,wt,s),l(t,Z,s),l(t,Mt,s),l(t,E,s),l(t,jt,s),l(t,y,s),r(y,x),r(x,ot),f(_,ot,null),r(y,zt),r(y,tt),l(t,yt,s),l(t,B,s),l(t,Jt,s),f(W,t,s),l(t,bt,s),l(t,G,s),l(t,Tt,s),f(A,t,s),l(t,vt,s),l(t,Q,s),l(t,xt,s),f(R,t,s),l(t,kt,s),l(t,V,s),l(t,$t,s),f(X,t,s),l(t,Ut,s),l(t,S,s),l(t,It,s),l(t,H,s),l(t,Ct,s),l(t,J,s),r(J,k),r(k,pt),f(Y,pt,null),r(J,Ft),r(J,et),l(t,Nt,s),l(t,z,s),l(t,Zt,s),f(F,t,s),l(t,Et,s),l(t,P,s),l(t,_t,s),l(t,b,s),r(b,$),r($,rt),f(L,rt,null),r(b,Pt),r(b,st),l(t,Bt,s),l(t,q,s),l(t,Wt,s),l(t,T,s),r(T,U),r(U,mt),f(D,mt,null),r(T,Lt),r(T,lt),l(t,Gt,s),f(K,t,s),l(t,At,s),l(t,ht,s),Qt=!0},p:ke,i(t){Qt||(u(I.$$.fragment,t),u(_.$$.fragment,t),u(W.$$.fragment,t),u(A.$$.fragment,t),u(R.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),u(K.$$.fragment,t),Qt=!0)},o(t){g(I.$$.fragment,t),g(_.$$.fragment,t),g(W.$$.fragment,t),g(A.$$.fragment,t),g(R.$$.fragment,t),g(X.$$.fragment,t),g(Y.$$.fragment,t),g(F.$$.fragment,t),g(L.$$.fragment,t),g(D.$$.fragment,t),g(K.$$.fragment,t),Qt=!1},d(t){t&&(e(dt),e(nt),e(ft),e(j),e(ut),e(C),e(gt),e(N),e(wt),e(Z),e(Mt),e(E),e(jt),e(y),e(yt),e(B),e(Jt),e(bt),e(G),e(Tt),e(vt),e(Q),e(xt),e(kt),e(V),e($t),e(Ut),e(S),e(It),e(H),e(Ct),e(J),e(Nt),e(z),e(Zt),e(Et),e(P),e(_t),e(b),e(Bt),e(q),e(Wt),e(T),e(Gt),e(At),e(ht)),e(M),w(I),w(_),w(W,t),w(A,t),w(R,t),w(X,t),w(Y),w(F,t),w(L),w(D),w(K,t)}}}const Ze={local:"tensorflow-efficientnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"(Tensorflow) EfficientNet"};function Ee(qt){return $e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends Ue{constructor(M){super(),Ie(this,M,Ee,Ne,xe,{})}}export{Ae as component};
