import{s as na,f as aa,o as sa,n as en}from"../chunks/scheduler.25b97de1.js";import{S as ta,i as ia,g as i,s,r as m,A as ra,h as r,f as n,c as t,j as J,u as p,x as f,k as _,y as d,a,v as h,d as g,t as M,w as u}from"../chunks/index.d9030fc9.js";import{T as ea}from"../chunks/Tip.baa67368.js";import{D as z}from"../chunks/Docstring.ffac8efa.js";import{C as E}from"../chunks/CodeBlock.e6cd0d95.js";import{E as oa}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as C,E as la}from"../chunks/EditOnGithub.91d95064.js";function ca(x){let c,T="<li>Llava-OneVision uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){c=i("ul"),c.innerHTML=T},l(v){c=r(v,"UL",{"data-svelte-h":!0}),f(c)!=="svelte-zcrbqx"&&(c.innerHTML=T)},m(v,y){a(v,c,y)},p:en,d(v){v&&n(c)}}}function da(x){let c,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',v,y,U='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){c=i("p"),c.innerHTML=T,v=s(),y=i("p"),y.innerHTML=U},l(l){c=r(l,"P",{"data-svelte-h":!0}),f(c)!=="svelte-nz63kd"&&(c.innerHTML=T),v=t(l),y=r(l,"P",{"data-svelte-h":!0}),f(y)!=="svelte-aze40l"&&(y.innerHTML=U)},m(l,b){a(l,c,b),a(l,v,b),a(l,y,b)},p:en,d(l){l&&(n(c),n(v),n(y))}}}function ma(x){let c,T="Example:",v,y,U;return y=new E({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFPbmV2aXNpb25Db25maWclMkMlMjBTaWdsaXBWaXNpb25Db25maWclMkMlMjBRd2VuMkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBTaWdsaXBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwUXdlbjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGF2YS1OZXh0JTIwbGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Db25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBsbGF2YS1oZiUyRmxsYXZhLW9uZXZpc2lvbi1xd2VuMi03Yi1vdi1oZiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, LlavaOnevisionConfig, SiglipVisionConfig, Qwen2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = SiglipVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = Qwen2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaOnevisionConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,v=s(),m(y.$$.fragment)},l(l){c=r(l,"P",{"data-svelte-h":!0}),f(c)!=="svelte-11lpom8"&&(c.textContent=T),v=t(l),p(y.$$.fragment,l)},m(l,b){a(l,c,b),a(l,v,b),h(y,l,b),U=!0},p:en,i(l){U||(g(y.$$.fragment,l),U=!0)},o(l){M(y.$$.fragment,l),U=!1},d(l){l&&(n(c),n(v)),u(y,l)}}}function pa(x){let c,T="Example:",v,y,U;return y=new E({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBMbGF2YU9uZXZpc2lvblByb2Nlc3NvciUyQyUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRCUyMmZsb2F0MTYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUzQTAlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtb25ldmlzaW9uLXF3ZW4yLTdiLW92LWhmJTIyKSUwQSUwQWNvbnZlcnNhdGlvbiUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShjb252ZXJzYXRpb24lMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQSUwQWltYWdlX2ZpbGUlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1hZ2VfZmlsZSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRHJhd19pbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JykudG8oMCUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;float16&quot;</span>, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = LlavaOnevisionProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>conversation = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_file = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(image_file, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=raw_image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(<span class="hljs-number">0</span>, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;user\\n\\nWhat is shown in this image?\\nassistant\\ncat&quot;</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,v=s(),m(y.$$.fragment)},l(l){c=r(l,"P",{"data-svelte-h":!0}),f(c)!=="svelte-11lpom8"&&(c.textContent=T),v=t(l),p(y.$$.fragment,l)},m(l,b){a(l,c,b),a(l,v,b),h(y,l,b),U=!0},p:en,i(l){U||(g(y.$$.fragment,l),U=!0)},o(l){M(y.$$.fragment,l),U=!1},d(l){l&&(n(c),n(v)),u(y,l)}}}function ha(x){let c,T,v,y,U,l,b,to,S,Tn='The LLaVA-OneVision model was proposed in <a href="https://arxiv.org/abs/2408.03326" rel="nofollow">LLaVA-OneVision: Easy Visual Task Transfer</a> by &lt;Bo Li, Yuanhan Zhang, Dong Guo, Renrui Zhang, Feng Li, Hao Zhang, Kaichen Zhang, Yanwei Li, Ziwei Liu, Chunyuan Li',io,H,jn="LLaVA-OneVision is a Vision-Language Model that can generate text conditioned on one or several images/videos. The model consists of SigLIP vision encoder and a Qwen2 language backbone. The images are processed with anyres-9 technique where the image is split into 9 patches to better process high resolution images and capture as much details as possible. However, videos are pooled to a total sequence length of 196 tokens each frame for more memory efficient computation. LLaVA-OneVision is available in three sizes: 0.5B, 7B and 72B and achieves remarkable performance on benchmark evaluations.",ro,P,wn="The abstract from the paper is the following:",lo,O,Jn=`<em>We present LLaVA-OneVision, a family of open large multimodal models (LMMs)
developed by consolidating our insights into data, models, and visual representations in the LLaVA-NeXT blog series. Our experimental results demonstrate that
LLaVA-OneVision is the first single model that can simultaneously push the performance boundaries of open LMMs in three important computer vision scenarios:
single-image, multi-image, and video scenarios. Importantly, the design of LLaVAOneVision allows strong transfer learning across different modalities/scenarios,
yielding new emerging capabilities. In particular, strong video understanding and
cross-scenario capabilities are demonstrated through task transfer from images to
videos.</em>`,co,k,Cn,mo,D,In='LLaVA-OneVision architecture. Taken from the <a href="https://arxiv.org/abs/2408.03326">original paper.</a>',po,K,Zn="Tips:",ho,ee,Ln="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",go,R,Mo,oe,zn="<li>Note that the model should use a specific prompt format, on which the large language model (LLM) was trained. You can use the processor’s <code>apply_chat_template</code> to format your prompts correctly. For that you have to construct a conversation history, passing a plain string will not format your prompt. Each message in the conversation history for chat templates is a dictionary with keys “role” and “content”. The “content” should be a list of dictionaries, for “text” and “image” modalities.</li>",uo,ne,Gn='We will use <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-si-hf" rel="nofollow">llava-onevision-qwen2-7b-si-hf</a> and a conversation history of text and image. Each content field has to be a list of dicts, as follows:',fo,ae,yo,se,Bn=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/LLaVA-VL/LLaVA-NeXT/tree/main" rel="nofollow">here</a>.`,vo,te,Uo,ie,bo,re,xn="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",_o,le,To,ce,jo,de,Wn="LLaVa-OneVision can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). For that you have to use checkpoints with an “ov” suffix. Here is how you can do it:",wo,me,Jo,pe,Co,he,kn="LLaVa-OneVision also can perform inference with videos as input, where video frames are treated as multiple images. Here is how you can do it:",Io,ge,Zo,Me,Lo,ue,zo,fe,Rn="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and make sure to have access to a GPU/accelerator that is supported by the library.",Go,N,Bo,ye,Nn="Simply change the snippet above with:",xo,ve,Wo,Ue,ko,be,qn='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',Ro,_e,No,Te,qo,I,je,on,$e,Vn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionForConditionalGeneration">LlavaOnevisionForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-ov-hf" rel="nofollow">llava-hf/llava-onevision-qwen2-7b-ov-hf</a>
model.`,nn,Ae,Xn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,an,q,Vo,we,Xo,j,Je,sn,Ye,Qn="Constructs a LLaVa-Onevision processor which wraps a LLaVa-Onevision video processor, LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",tn,Fe,$n=`<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__"><strong>call</strong>()</a>, <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,rn,V,Ce,ln,Ee,An=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,cn,X,Ie,dn,Se,Yn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Qo,Ze,$o,w,Le,mn,He,Fn='Constructs a LLaVa-Onevisino-Video video processor. Based on <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',pn,Q,ze,hn,Pe,En="Process an image with variable resolutions by dividing it into patches.",gn,$,Ge,Mn,Oe,Sn=`Pads the <code>image</code> with the specified <code>padding</code> and <code>mode</code>. Padding can be in the (<code>height</code>, <code>width</code>)
dimension of in the (<code>num_patches</code>) dimension. In the second case an iterable if tuples is expected
as input.`,un,De,Be,Ao,xe,Yo,G,We,fn,Ke,Hn='Constructs a LLaVa-Onevisino-Video video processor. Based on <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',yn,eo,ke,Fo,Re,Eo,Z,Ne,vn,oo,Pn=`The LLaVA-Onevision model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Un,no,On=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bn,A,qe,_n,Y,So,Ve,Ho,so,Po;return U=new C({props:{title:"LLaVA-OneVision",local:"llava-onevision",headingTag:"h1"}}),b=new C({props:{title:"Overview",local:"overview",headingTag:"h2"}}),R=new ea({props:{warning:!0,$$slots:{default:[ca]},$$scope:{ctx:x}}}),ae=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-si-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-string">&#x27;&lt;|im_start|&gt;user\\n&lt;image&gt;What is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nPage showing the list of options.&lt;|im_end|&gt;&#x27;</span>`,wrap:!1}}),te=new C({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ie=new C({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),le=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>) 
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>) 
model.to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>, torch.float16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThe image shows a radar chart, also known as a spider chart or a star chart, which is used to compare multiple quantitative variables. Each axis represents a different variable, and the chart is filled with&#x27;</span>`,wrap:!1}}),ce=new C({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),me=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

prompt_1 = processor.apply_chat_template(conversation_1, add_generation_prompt=<span class="hljs-literal">True</span>)
prompt_2 = processor.apply_chat_template(conversation_2, add_generation_prompt=<span class="hljs-literal">True</span>)
prompts = [prompt_1, prompt_2]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, torch.float16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThere is a red stop sign in the image.\\nuser\\n\\nWhat about this image? How many cats do you see?\\nassistant\\ntwo&#x27;</span>, <span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\n&#x27;</span>]`,wrap:!1}}),pe=new C({props:{title:"Video inference",local:"video-inference",headingTag:"h3"}}),ge=new E({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-comment"># Load the video as an np.array, sampling uniformly 8 frames (can sample more for longer videos, up to 32 frames)</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

<span class="hljs-comment"># For videos we have to feed a &quot;video&quot; type instead of &quot;image&quot;</span>
conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            ],
    },
]

prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(videos=<span class="hljs-built_in">list</span>(video), text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>, torch.float16)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;user\\n\\nWhy is this video funny?\\nassistant\\nThe video appears to be humorous because it shows a young child, who is wearing glasses and holding a book, seemingly reading with a serious and focused expression. The child&#x27;s glasses are a bit oversized for their face, which adds a comical touch, as it&#x27;s a common trope to see children wearing&quot;</span>]`,wrap:!1}}),Me=new C({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ue=new C({props:{title:"Quantization using bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),N=new ea({props:{$$slots:{default:[da]},$$scope:{ctx:x}}}),ve=new E({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBJTIzJTIwc3BlY2lmeSUyMGhvdyUyMHRvJTIwcXVhbnRpemUlMjB0aGUlMjBtb2RlbCUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Ue=new C({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),_e=new E({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMjAlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjAlMEElMjAlMjAlMjAlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2VfZmxhc2hfYXR0ZW50aW9uXzIlM0RUcnVlJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration

model = LlavaOnevisionForConditionalGeneration.from_pretrained(
    model_id, 
    torch_dtype=torch.float16, 
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Te=new C({props:{title:"LlavaOnevisionConfig",local:"transformers.LlavaOnevisionConfig",headingTag:"h2"}}),je=new z({props:{name:"class transformers.LlavaOnevisionConfig",anchor:"transformers.LlavaOnevisionConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 151646"},{name:"video_token_index",val:" = 151647"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'full'"},{name:"vision_feature_layer",val:" = -1"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>SiglipVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaOnevisionConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>Qwen2Config</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaOnevisionConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151646) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaOnevisionConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151647) &#x2014;
The video token index to encode the video prompt.`,name:"video_token_index"},{anchor:"transformers.LlavaOnevisionConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;full&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionConfig.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaOnevisionConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/configuration_llava_onevision.py#L27"}}),q=new oa({props:{anchor:"transformers.LlavaOnevisionConfig.example",$$slots:{default:[ma]},$$scope:{ctx:x}}}),we=new C({props:{title:"LlavaOnevisionProcessor",local:"transformers.LlavaOnevisionProcessor",headingTag:"h2"}}),Je=new z({props:{name:"class transformers.LlavaOnevisionProcessor",anchor:"transformers.LlavaOnevisionProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"video_processor",val:" = None"},{name:"num_image_tokens",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaOnevisionProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaOnevisionProcessor.video_processor",description:`<strong>video_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <em>optional</em>) &#x2014;
The video processor is a required input.`,name:"video_processor"},{anchor:"transformers.LlavaOnevisionProcessor.num_image_tokens",description:`<strong>num_image_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of image tokens for one imagethat will be returned by vision tower.`,name:"num_image_tokens"},{anchor:"transformers.LlavaOnevisionProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaOnevisionProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaOnevisionProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L48"}}),Ce=new z({props:{name:"batch_decode",anchor:"transformers.LlavaOnevisionProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L260"}}),Ie=new z({props:{name:"decode",anchor:"transformers.LlavaOnevisionProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L268"}}),Ze=new C({props:{title:"LlavaOnevisionImageProcessor",local:"transformers.LlavaOnevisionImageProcessor",headingTag:"h2"}}),Le=new z({props:{name:"class transformers.LlavaOnevisionImageProcessor",anchor:"transformers.LlavaOnevisionImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processinf videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L144"}}),ze=new z({props:{name:"get_image_patches",anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches",parameters:[{name:"image",val:": <built-in function array>"},{name:"grid_pinpoints",val:""},{name:"size",val:": tuple"},{name:"patch_size",val:": int"},{name:"resample",val:": Resampling"},{name:"data_format",val:": ChannelDimension"},{name:"input_data_format",val:": ChannelDimension"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.image",description:`<strong>image</strong> (np.array) &#x2014;
The input image to be processed.`,name:"image"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.grid_pinpoints",description:`<strong>grid_pinpoints</strong> (List) &#x2014;
A string representation of a list of possible resolutions.`,name:"grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.size",description:`<strong>size</strong> (<code>tuple</code>) &#x2014;
Size to resize the original image to.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.patch_size",description:`<strong>patch_size</strong> (<code>int</code>) &#x2014;
Size of the patches to divide the image into.`,name:"patch_size"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>) &#x2014;
The channel dimension format for the output image.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>) &#x2014;
The channel dimension format of the input image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L373",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of NumPy arrays containing the processed image patches.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[np.array]</p>
`}}),Ge=new z({props:{name:"pad",anchor:"transformers.LlavaOnevisionImageProcessor.pad",parameters:[{name:"image",val:": ndarray"},{name:"padding",val:": typing.Union[int, typing.Tuple[int, int], typing.Iterable[typing.Tuple[int, int]]]"},{name:"mode",val:": PaddingMode = <PaddingMode.CONSTANT: 'constant'>"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0.0"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
The image to pad.`,name:"image"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.padding",description:`<strong>padding</strong> (<code>int</code> or <code>Tuple[int, int]</code> or <code>Iterable[Tuple[int, int]]</code>) &#x2014;
Padding to apply to the edges of the height, width axes. Can be one of three formats:<ul>
<li><code>((before_height, after_height), (before_width, after_width))</code> unique pad widths for each axis.</li>
<li><code>((before, after),)</code> yields same before and after pad for height and width.</li>
<li><code>(pad,)</code> or int is a shortcut for before = after = pad width for all axes.</li>
</ul>`,name:"padding"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.mode",description:`<strong>mode</strong> (<code>PaddingMode</code>) &#x2014;
The padding mode to use. Can be one of:<ul>
<li><code>&quot;constant&quot;</code>: pads with a constant value.</li>
<li><code>&quot;reflect&quot;</code>: pads with the reflection of the vector mirrored on the first and last values of the
vector along each axis.</li>
<li><code>&quot;replicate&quot;</code>: pads with the replication of the last value on the edge of the array along each axis.</li>
<li><code>&quot;symmetric&quot;</code>: pads with the reflection of the vector mirrored along the edge of the array.</li>
</ul>`,name:"mode"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use same as the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use the inferred format of the input image.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L260",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The padded image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Be=new z({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L552"}}),xe=new C({props:{title:"LlavaOnevisionVideoProcessor",local:"transformers.LlavaOnevisionVideoProcessor",headingTag:"h2"}}),We=new z({props:{name:"class transformers.LlavaOnevisionVideoProcessor",anchor:"transformers.LlavaOnevisionVideoProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionVideoProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionVideoProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionVideoProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionVideoProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L65"}}),ke=new z({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[typing.List[ForwardRef('PIL.Image.Image')], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), typing.List[ForwardRef('np.ndarray')], typing.List[ForwardRef('torch.Tensor')], typing.List[typing.List[ForwardRef('PIL.Image.Image')]], typing.List[typing.List[ForwardRef('np.ndarrray')]], typing.List[typing.List[ForwardRef('torch.Tensor')]]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of videos to be prepared. Each video can be a 4D NumPy array or PyTorch`,name:"videos"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L218"}}),Re=new C({props:{title:"LlavaOnevisionForConditionalGeneration",local:"transformers.LlavaOnevisionForConditionalGeneration",headingTag:"h2"}}),Ne=new z({props:{name:"class transformers.LlavaOnevisionForConditionalGeneration",anchor:"transformers.LlavaOnevisionForConditionalGeneration",parameters:[{name:"config",val:": LlavaOnevisionConfig"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L369"}}),qe=new z({props:{name:"forward",anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes_videos",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"vision_aspect_ratio",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input videos. Pixel values can be obtained using [LlavaNextVideoProcessor](/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor). See </code>LlavaNextVideoProcessor.<strong>call</strong>()` for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses\n<a href="/docs/transformers/main/en/model_doc/llava_next_video#transformers.LlavaNextVideoProcessor">LlavaNextVideoProcessor</a> for processing videos.',name:"pixel_values_videos"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes_videos",description:`<strong>image_sizes_videos</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, frames, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the videos in the batch, being (height, width) for each frame in the video.`,name:"image_sizes_videos"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>logits_to_keep (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>):
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L599",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~LlavaOnevisionCausalLMOutputWithPast</code> (if <code>return_dict=True</code>) or a <code>tuple</code>.</p>
`}}),Y=new oa({props:{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.example",$$slots:{default:[pa]},$$scope:{ctx:x}}}),Ve=new la({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_onevision.md"}}),{c(){c=i("meta"),T=s(),v=i("p"),y=s(),m(U.$$.fragment),l=s(),m(b.$$.fragment),to=s(),S=i("p"),S.innerHTML=Tn,io=s(),H=i("p"),H.textContent=jn,ro=s(),P=i("p"),P.textContent=wn,lo=s(),O=i("p"),O.innerHTML=Jn,co=s(),k=i("img"),mo=s(),D=i("small"),D.innerHTML=In,po=s(),K=i("p"),K.textContent=Zn,ho=s(),ee=i("ul"),ee.innerHTML=Ln,go=s(),m(R.$$.fragment),Mo=s(),oe=i("ul"),oe.innerHTML=zn,uo=s(),ne=i("p"),ne.innerHTML=Gn,fo=s(),m(ae.$$.fragment),yo=s(),se=i("p"),se.innerHTML=Bn,vo=s(),m(te.$$.fragment),Uo=s(),m(ie.$$.fragment),bo=s(),re=i("p"),re.innerHTML=xn,_o=s(),m(le.$$.fragment),To=s(),m(ce.$$.fragment),jo=s(),de=i("p"),de.textContent=Wn,wo=s(),m(me.$$.fragment),Jo=s(),m(pe.$$.fragment),Co=s(),he=i("p"),he.textContent=kn,Io=s(),m(ge.$$.fragment),Zo=s(),m(Me.$$.fragment),Lo=s(),m(ue.$$.fragment),zo=s(),fe=i("p"),fe.innerHTML=Rn,Go=s(),m(N.$$.fragment),Bo=s(),ye=i("p"),ye.textContent=Nn,xo=s(),m(ve.$$.fragment),Wo=s(),m(Ue.$$.fragment),ko=s(),be=i("p"),be.innerHTML=qn,Ro=s(),m(_e.$$.fragment),No=s(),m(Te.$$.fragment),qo=s(),I=i("div"),m(je.$$.fragment),on=s(),$e=i("p"),$e.innerHTML=Vn,nn=s(),Ae=i("p"),Ae.innerHTML=Xn,an=s(),m(q.$$.fragment),Vo=s(),m(we.$$.fragment),Xo=s(),j=i("div"),m(Je.$$.fragment),sn=s(),Ye=i("p"),Ye.textContent=Qn,tn=s(),Fe=i("p"),Fe.innerHTML=$n,rn=s(),V=i("div"),m(Ce.$$.fragment),ln=s(),Ee=i("p"),Ee.innerHTML=An,cn=s(),X=i("div"),m(Ie.$$.fragment),dn=s(),Se=i("p"),Se.innerHTML=Yn,Qo=s(),m(Ze.$$.fragment),$o=s(),w=i("div"),m(Le.$$.fragment),mn=s(),He=i("p"),He.innerHTML=Fn,pn=s(),Q=i("div"),m(ze.$$.fragment),hn=s(),Pe=i("p"),Pe.textContent=En,gn=s(),$=i("div"),m(Ge.$$.fragment),Mn=s(),Oe=i("p"),Oe.innerHTML=Sn,un=s(),De=i("div"),m(Be.$$.fragment),Ao=s(),m(xe.$$.fragment),Yo=s(),G=i("div"),m(We.$$.fragment),fn=s(),Ke=i("p"),Ke.innerHTML=Hn,yn=s(),eo=i("div"),m(ke.$$.fragment),Fo=s(),m(Re.$$.fragment),Eo=s(),Z=i("div"),m(Ne.$$.fragment),vn=s(),oo=i("p"),oo.innerHTML=Pn,Un=s(),no=i("p"),no.innerHTML=On,bn=s(),A=i("div"),m(qe.$$.fragment),_n=s(),m(Y.$$.fragment),So=s(),m(Ve.$$.fragment),Ho=s(),so=i("p"),this.h()},l(e){const o=ra("svelte-u9bgzb",document.head);c=r(o,"META",{name:!0,content:!0}),o.forEach(n),T=t(e),v=r(e,"P",{}),J(v).forEach(n),y=t(e),p(U.$$.fragment,e),l=t(e),p(b.$$.fragment,e),to=t(e),S=r(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-41eoyp"&&(S.innerHTML=Tn),io=t(e),H=r(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-zyuhly"&&(H.textContent=jn),ro=t(e),P=r(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-vfdo9a"&&(P.textContent=wn),lo=t(e),O=r(e,"P",{"data-svelte-h":!0}),f(O)!=="svelte-e9kp7g"&&(O.innerHTML=Jn),co=t(e),k=r(e,"IMG",{src:!0,alt:!0,width:!0}),mo=t(e),D=r(e,"SMALL",{"data-svelte-h":!0}),f(D)!=="svelte-m653qt"&&(D.innerHTML=In),po=t(e),K=r(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-axv494"&&(K.textContent=Zn),ho=t(e),ee=r(e,"UL",{"data-svelte-h":!0}),f(ee)!=="svelte-b32abk"&&(ee.innerHTML=Ln),go=t(e),p(R.$$.fragment,e),Mo=t(e),oe=r(e,"UL",{"data-svelte-h":!0}),f(oe)!=="svelte-1vjnybt"&&(oe.innerHTML=zn),uo=t(e),ne=r(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1x1wp4w"&&(ne.innerHTML=Gn),fo=t(e),p(ae.$$.fragment,e),yo=t(e),se=r(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-18dym15"&&(se.innerHTML=Bn),vo=t(e),p(te.$$.fragment,e),Uo=t(e),p(ie.$$.fragment,e),bo=t(e),re=r(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-19yw9ck"&&(re.innerHTML=xn),_o=t(e),p(le.$$.fragment,e),To=t(e),p(ce.$$.fragment,e),jo=t(e),de=r(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1f25s48"&&(de.textContent=Wn),wo=t(e),p(me.$$.fragment,e),Jo=t(e),p(pe.$$.fragment,e),Co=t(e),he=r(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1delota"&&(he.textContent=kn),Io=t(e),p(ge.$$.fragment,e),Zo=t(e),p(Me.$$.fragment,e),Lo=t(e),p(ue.$$.fragment,e),zo=t(e),fe=r(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-tychdj"&&(fe.innerHTML=Rn),Go=t(e),p(N.$$.fragment,e),Bo=t(e),ye=r(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-gwf9h7"&&(ye.textContent=Nn),xo=t(e),p(ve.$$.fragment,e),Wo=t(e),p(Ue.$$.fragment,e),ko=t(e),be=r(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-ujer0t"&&(be.innerHTML=qn),Ro=t(e),p(_e.$$.fragment,e),No=t(e),p(Te.$$.fragment,e),qo=t(e),I=r(e,"DIV",{class:!0});var B=J(I);p(je.$$.fragment,B),on=t(B),$e=r(B,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1ksh786"&&($e.innerHTML=Vn),nn=t(B),Ae=r(B,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-o55m63"&&(Ae.innerHTML=Xn),an=t(B),p(q.$$.fragment,B),B.forEach(n),Vo=t(e),p(we.$$.fragment,e),Xo=t(e),j=r(e,"DIV",{class:!0});var L=J(j);p(Je.$$.fragment,L),sn=t(L),Ye=r(L,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-13282x9"&&(Ye.textContent=Qn),tn=t(L),Fe=r(L,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-1n2s5pa"&&(Fe.innerHTML=$n),rn=t(L),V=r(L,"DIV",{class:!0});var Xe=J(V);p(Ce.$$.fragment,Xe),ln=t(Xe),Ee=r(Xe,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-1o9eza"&&(Ee.innerHTML=An),Xe.forEach(n),cn=t(L),X=r(L,"DIV",{class:!0});var Qe=J(X);p(Ie.$$.fragment,Qe),dn=t(Qe),Se=r(Qe,"P",{"data-svelte-h":!0}),f(Se)!=="svelte-kk16qw"&&(Se.innerHTML=Yn),Qe.forEach(n),L.forEach(n),Qo=t(e),p(Ze.$$.fragment,e),$o=t(e),w=r(e,"DIV",{class:!0});var W=J(w);p(Le.$$.fragment,W),mn=t(W),He=r(W,"P",{"data-svelte-h":!0}),f(He)!=="svelte-1api4zg"&&(He.innerHTML=Fn),pn=t(W),Q=r(W,"DIV",{class:!0});var Oo=J(Q);p(ze.$$.fragment,Oo),hn=t(Oo),Pe=r(Oo,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1ycjrv2"&&(Pe.textContent=En),Oo.forEach(n),gn=t(W),$=r(W,"DIV",{class:!0});var Do=J($);p(Ge.$$.fragment,Do),Mn=t(Do),Oe=r(Do,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-1wucq2q"&&(Oe.innerHTML=Sn),Do.forEach(n),un=t(W),De=r(W,"DIV",{class:!0});var Dn=J(De);p(Be.$$.fragment,Dn),Dn.forEach(n),W.forEach(n),Ao=t(e),p(xe.$$.fragment,e),Yo=t(e),G=r(e,"DIV",{class:!0});var ao=J(G);p(We.$$.fragment,ao),fn=t(ao),Ke=r(ao,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-1api4zg"&&(Ke.innerHTML=Hn),yn=t(ao),eo=r(ao,"DIV",{class:!0});var Kn=J(eo);p(ke.$$.fragment,Kn),Kn.forEach(n),ao.forEach(n),Fo=t(e),p(Re.$$.fragment,e),Eo=t(e),Z=r(e,"DIV",{class:!0});var F=J(Z);p(Ne.$$.fragment,F),vn=t(F),oo=r(F,"P",{"data-svelte-h":!0}),f(oo)!=="svelte-1wh0gb4"&&(oo.innerHTML=Pn),Un=t(F),no=r(F,"P",{"data-svelte-h":!0}),f(no)!=="svelte-hswkmf"&&(no.innerHTML=On),bn=t(F),A=r(F,"DIV",{class:!0});var Ko=J(A);p(qe.$$.fragment,Ko),_n=t(Ko),p(Y.$$.fragment,Ko),Ko.forEach(n),F.forEach(n),So=t(e),p(Ve.$$.fragment,e),Ho=t(e),so=r(e,"P",{}),J(so).forEach(n),this.h()},h(){_(c,"name","hf:doc:metadata"),_(c,"content",ga),aa(k.src,Cn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava-ov-acrhitecture.png")||_(k,"src",Cn),_(k,"alt","drawing"),_(k,"width","600"),_(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),_(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){d(document.head,c),a(e,T,o),a(e,v,o),a(e,y,o),h(U,e,o),a(e,l,o),h(b,e,o),a(e,to,o),a(e,S,o),a(e,io,o),a(e,H,o),a(e,ro,o),a(e,P,o),a(e,lo,o),a(e,O,o),a(e,co,o),a(e,k,o),a(e,mo,o),a(e,D,o),a(e,po,o),a(e,K,o),a(e,ho,o),a(e,ee,o),a(e,go,o),h(R,e,o),a(e,Mo,o),a(e,oe,o),a(e,uo,o),a(e,ne,o),a(e,fo,o),h(ae,e,o),a(e,yo,o),a(e,se,o),a(e,vo,o),h(te,e,o),a(e,Uo,o),h(ie,e,o),a(e,bo,o),a(e,re,o),a(e,_o,o),h(le,e,o),a(e,To,o),h(ce,e,o),a(e,jo,o),a(e,de,o),a(e,wo,o),h(me,e,o),a(e,Jo,o),h(pe,e,o),a(e,Co,o),a(e,he,o),a(e,Io,o),h(ge,e,o),a(e,Zo,o),h(Me,e,o),a(e,Lo,o),h(ue,e,o),a(e,zo,o),a(e,fe,o),a(e,Go,o),h(N,e,o),a(e,Bo,o),a(e,ye,o),a(e,xo,o),h(ve,e,o),a(e,Wo,o),h(Ue,e,o),a(e,ko,o),a(e,be,o),a(e,Ro,o),h(_e,e,o),a(e,No,o),h(Te,e,o),a(e,qo,o),a(e,I,o),h(je,I,null),d(I,on),d(I,$e),d(I,nn),d(I,Ae),d(I,an),h(q,I,null),a(e,Vo,o),h(we,e,o),a(e,Xo,o),a(e,j,o),h(Je,j,null),d(j,sn),d(j,Ye),d(j,tn),d(j,Fe),d(j,rn),d(j,V),h(Ce,V,null),d(V,ln),d(V,Ee),d(j,cn),d(j,X),h(Ie,X,null),d(X,dn),d(X,Se),a(e,Qo,o),h(Ze,e,o),a(e,$o,o),a(e,w,o),h(Le,w,null),d(w,mn),d(w,He),d(w,pn),d(w,Q),h(ze,Q,null),d(Q,hn),d(Q,Pe),d(w,gn),d(w,$),h(Ge,$,null),d($,Mn),d($,Oe),d(w,un),d(w,De),h(Be,De,null),a(e,Ao,o),h(xe,e,o),a(e,Yo,o),a(e,G,o),h(We,G,null),d(G,fn),d(G,Ke),d(G,yn),d(G,eo),h(ke,eo,null),a(e,Fo,o),h(Re,e,o),a(e,Eo,o),a(e,Z,o),h(Ne,Z,null),d(Z,vn),d(Z,oo),d(Z,Un),d(Z,no),d(Z,bn),d(Z,A),h(qe,A,null),d(A,_n),h(Y,A,null),a(e,So,o),h(Ve,e,o),a(e,Ho,o),a(e,so,o),Po=!0},p(e,[o]){const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),R.$set(B);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),N.$set(L);const Xe={};o&2&&(Xe.$$scope={dirty:o,ctx:e}),q.$set(Xe);const Qe={};o&2&&(Qe.$$scope={dirty:o,ctx:e}),Y.$set(Qe)},i(e){Po||(g(U.$$.fragment,e),g(b.$$.fragment,e),g(R.$$.fragment,e),g(ae.$$.fragment,e),g(te.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(Me.$$.fragment,e),g(ue.$$.fragment,e),g(N.$$.fragment,e),g(ve.$$.fragment,e),g(Ue.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(je.$$.fragment,e),g(q.$$.fragment,e),g(we.$$.fragment,e),g(Je.$$.fragment,e),g(Ce.$$.fragment,e),g(Ie.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(ze.$$.fragment,e),g(Ge.$$.fragment,e),g(Be.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g(ke.$$.fragment,e),g(Re.$$.fragment,e),g(Ne.$$.fragment,e),g(qe.$$.fragment,e),g(Y.$$.fragment,e),g(Ve.$$.fragment,e),Po=!0)},o(e){M(U.$$.fragment,e),M(b.$$.fragment,e),M(R.$$.fragment,e),M(ae.$$.fragment,e),M(te.$$.fragment,e),M(ie.$$.fragment,e),M(le.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(pe.$$.fragment,e),M(ge.$$.fragment,e),M(Me.$$.fragment,e),M(ue.$$.fragment,e),M(N.$$.fragment,e),M(ve.$$.fragment,e),M(Ue.$$.fragment,e),M(_e.$$.fragment,e),M(Te.$$.fragment,e),M(je.$$.fragment,e),M(q.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(Ce.$$.fragment,e),M(Ie.$$.fragment,e),M(Ze.$$.fragment,e),M(Le.$$.fragment,e),M(ze.$$.fragment,e),M(Ge.$$.fragment,e),M(Be.$$.fragment,e),M(xe.$$.fragment,e),M(We.$$.fragment,e),M(ke.$$.fragment,e),M(Re.$$.fragment,e),M(Ne.$$.fragment,e),M(qe.$$.fragment,e),M(Y.$$.fragment,e),M(Ve.$$.fragment,e),Po=!1},d(e){e&&(n(T),n(v),n(y),n(l),n(to),n(S),n(io),n(H),n(ro),n(P),n(lo),n(O),n(co),n(k),n(mo),n(D),n(po),n(K),n(ho),n(ee),n(go),n(Mo),n(oe),n(uo),n(ne),n(fo),n(yo),n(se),n(vo),n(Uo),n(bo),n(re),n(_o),n(To),n(jo),n(de),n(wo),n(Jo),n(Co),n(he),n(Io),n(Zo),n(Lo),n(zo),n(fe),n(Go),n(Bo),n(ye),n(xo),n(Wo),n(ko),n(be),n(Ro),n(No),n(qo),n(I),n(Vo),n(Xo),n(j),n(Qo),n($o),n(w),n(Ao),n(Yo),n(G),n(Fo),n(Eo),n(Z),n(So),n(Ho),n(so)),n(c),u(U,e),u(b,e),u(R,e),u(ae,e),u(te,e),u(ie,e),u(le,e),u(ce,e),u(me,e),u(pe,e),u(ge,e),u(Me,e),u(ue,e),u(N,e),u(ve,e),u(Ue,e),u(_e,e),u(Te,e),u(je),u(q),u(we,e),u(Je),u(Ce),u(Ie),u(Ze,e),u(Le),u(ze),u(Ge),u(Be),u(xe,e),u(We),u(ke),u(Re,e),u(Ne),u(qe),u(Y),u(Ve,e)}}}const ga='{"title":"LLaVA-OneVision","local":"llava-onevision","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3},{"title":"Video inference","local":"video-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaOnevisionConfig","local":"transformers.LlavaOnevisionConfig","sections":[],"depth":2},{"title":"LlavaOnevisionProcessor","local":"transformers.LlavaOnevisionProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionImageProcessor","local":"transformers.LlavaOnevisionImageProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionVideoProcessor","local":"transformers.LlavaOnevisionVideoProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionForConditionalGeneration","local":"transformers.LlavaOnevisionForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Ma(x){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends ta{constructor(c){super(),ia(this,c,Ma,ha,na,{})}}export{Ta as component};
