import{s as Fo,o as Go,n as we}from"../chunks/scheduler.25b97de1.js";import{S as qo,i as Uo,g as h,s as a,r as g,A as jo,h as p,f as s,c as r,j as J,u as _,x as u,k as W,y as l,a as i,v as y,d as b,t as v,w as T}from"../chunks/index.d9030fc9.js";import{T as co}from"../chunks/Tip.baa67368.js";import{D as le}from"../chunks/Docstring.ffac8efa.js";import{C as ho}from"../chunks/CodeBlock.e6cd0d95.js";import{E as lo}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Me,E as Io}from"../chunks/EditOnGithub.91d95064.js";function Jo(x){let n,M="Example:",c,d,m;return d=new ho({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1vb25zaGluZU1vZGVsJTJDJTIwTW9vbnNoaW5lQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME1vb25zaGluZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNb29uc2hpbmVDb25maWcoKS5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS10aW55JTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBNb29uc2hpbmVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MoonshineModel, MoonshineConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Moonshine style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MoonshineConfig().from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=h("p"),n.textContent=M,c=a(),g(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=M),c=r(o),_(d.$$.fragment,o)},m(o,f){i(o,n,f),i(o,c,f),y(d,o,f),m=!0},p:we,i(o){m||(b(d.$$.fragment,o),m=!0)},o(o){v(d.$$.fragment,o),m=!1},d(o){o&&(s(n),s(c)),T(d,o)}}}function Wo(x){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=h("p"),n.innerHTML=M},l(c){n=p(c,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(c,d){i(c,n,d)},p:we,d(c){c&&s(n)}}}function No(x){let n,M="Example:",c,d,m;return d=new ho({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBNb29uc2hpbmVNb2RlbCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQW1vZGVsJTIwJTNEJTIwTW9vbnNoaW5lTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtdGlueSUyMiklMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJVc2VmdWxTZW5zb3JzJTJGbW9vbnNoaW5lLXRpbnklMjIpJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0X3ZhbHVlcyUyMCUzRCUyMGlucHV0cy5pbnB1dF92YWx1ZXMlMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUIxJTJDJTIwMSU1RCU1RCklMjAqJTIwbW9kZWwuY29uZmlnLmRlY29kZXJfc3RhcnRfdG9rZW5faWQlMEFsYXN0X2hpZGRlbl9zdGF0ZSUyMCUzRCUyMG1vZGVsKGlucHV0X3ZhbHVlcyUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, MoonshineModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineModel.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = torch.tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]) * model.config.decoder_start_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = model(input_values, decoder_input_ids=decoder_input_ids).last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">288</span>]`,wrap:!1}}),{c(){n=h("p"),n.textContent=M,c=a(),g(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=M),c=r(o),_(d.$$.fragment,o)},m(o,f){i(o,n,f),i(o,c,f),y(d,o,f),m=!0},p:we,i(o){m||(b(d.$$.fragment,o),m=!0)},o(o){v(d.$$.fragment,o),m=!1},d(o){o&&(s(n),s(c)),T(d,o)}}}function Zo(x){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=h("p"),n.innerHTML=M},l(c){n=p(c,"P",{"data-svelte-h":!0}),u(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(c,d){i(c,n,d)},p:we,d(c){c&&s(n)}}}function Lo(x){let n,M="Example:",c,d,m;return d=new ho({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMlVzZWZ1bFNlbnNvcnMlMkZtb29uc2hpbmUtdGlueSUyMiklMEFtb2RlbCUyMCUzRCUyME1vb25zaGluZUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyVXNlZnVsU2Vuc29ycyUyRm1vb25zaGluZS10aW55JTIyKSUwQSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfdmFsdWVzJTIwJTNEJTIwaW5wdXRzLmlucHV0X3ZhbHVlcyUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dF92YWx1ZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXRyYW5zY3JpcHRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MoonshineForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MoonshineForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;UsefulSensors/moonshine-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_values = inputs.input_values

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(input_values, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription
<span class="hljs-string">&#x27;Mr. Quilter is the apostle of the middle classes, and we are glad to welcome his gospel.&#x27;</span>`,wrap:!1}}),{c(){n=h("p"),n.textContent=M,c=a(),g(d.$$.fragment)},l(o){n=p(o,"P",{"data-svelte-h":!0}),u(n)!=="svelte-11lpom8"&&(n.textContent=M),c=r(o),_(d.$$.fragment,o)},m(o,f){i(o,n,f),i(o,c,f),y(d,o,f),m=!0},p:we,i(o){m||(b(d.$$.fragment,o),m=!0)},o(o){v(d.$$.fragment,o),m=!1},d(o){o&&(s(n),s(c)),T(d,o)}}}function Ro(x){let n,M=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,c,d,m=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){n=h("p"),n.innerHTML=M,c=a(),d=h("p"),d.innerHTML=m},l(o){n=p(o,"P",{"data-svelte-h":!0}),u(n)!=="svelte-1c5u34l"&&(n.innerHTML=M),c=r(o),d=p(o,"P",{"data-svelte-h":!0}),u(d)!=="svelte-fvlq1g"&&(d.innerHTML=m)},m(o,f){i(o,n,f),i(o,c,f),i(o,d,f)},p:we,d(o){o&&(s(n),s(c),s(d))}}}function Po(x){let n,M,c,d,m,o,f,xe,V,po='The Moonshine model was proposed in <a href="https://arxiv.org/abs/2410.15608" rel="nofollow">Moonshine: Speech Recognition for Live Transcription and Voice Commands</a> by Nat Jeffries, Evan King, Manjunath Kudlur, Guy Nicholson, James Wang, Pete Warden.',$e,E,mo="The abstract from the paper is the following:",Ce,H,uo="<em>This paper introduces Moonshine, a family of speech recognition models optimized for live transcription and voice command processing. Moonshine is based on an encoder-decoder transformer architecture and employs Rotary Position Embedding (RoPE) instead of traditional absolute position embeddings. The model is trained on speech segments of various lengths, but without using zero-padding, leading to greater efficiency for the encoder during inference time. When benchmarked against OpenAI’s Whisper tiny-en, Moonshine Tiny demonstrates a 5x reduction in compute requirements for transcribing a 10-second speech segment while incurring no increase in word error rates across standard evaluation datasets. These results highlight Moonshine’s potential for real-time and resource-constrained applications.</em>",ze,X,fo="Tips:",Fe,A,go="<li>Moonshine improves upon Whisper’s architecture:<ol><li>It uses SwiGLU activation instead of GELU in the decoder layers</li> <li>Most importantly, it replaces absolute position embeddings with Rotary Position Embeddings (RoPE). This allows Moonshine to handle audio inputs of any length, unlike Whisper which is restricted to fixed 30-second windows.</li></ol></li>",Ge,B,_o=`This model was contributed by <a href="https://huggingface.co/eustlb" rel="nofollow">Eustache Le Bihan (eustlb)</a>.
The original code can be found <a href="https://github.com/usefulsensors/moonshine" rel="nofollow">here</a>.`,qe,Q,Ue,D,yo='<li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',je,Y,Ie,$,K,Se,he,bo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a>. It is used to instantiate a Moonshine
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Moonshine
<a href="https://huggingface.co/UsefulSensors/moonshine-tiny" rel="nofollow">UsefulSensors/moonshine-tiny</a>.`,Oe,pe,vo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ve,N,Je,ee,We,w,oe,Ee,me,To=`The bare Moonshine Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,He,ue,Mo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Xe,F,ne,Ae,fe,wo='The <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a> forward method, overrides the <code>__call__</code> special method.',Be,Z,Qe,L,De,R,te,Ye,ge,ko=`Masks extracted features along time axis and/or along feature axis according to
<a href="https://arxiv.org/abs/1904.08779" rel="nofollow">SpecAugment</a>.`,Ne,se,Ze,k,ae,Ke,_e,xo=`The Moonshine Model with a language modeling head. Can be used for automatic speech recognition.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,eo,ye,$o=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oo,G,re,no,be,Co='The <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineForConditionalGeneration">MoonshineForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',to,P,so,S,ao,I,ie,ro,ve,zo="Generates sequences of token ids for models with a language modeling head.",io,O,Le,de,Re,ke,Pe;return m=new Me({props:{title:"Moonshine",local:"moonshine",headingTag:"h1"}}),f=new Me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new Me({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Y=new Me({props:{title:"MoonshineConfig",local:"transformers.MoonshineConfig",headingTag:"h2"}}),K=new le({props:{name:"class transformers.MoonshineConfig",anchor:"transformers.MoonshineConfig",parameters:[{name:"vocab_size",val:" = 32768"},{name:"hidden_size",val:" = 288"},{name:"intermediate_size",val:" = 1152"},{name:"encoder_num_hidden_layers",val:" = 6"},{name:"decoder_num_hidden_layers",val:" = 6"},{name:"encoder_num_attention_heads",val:" = 8"},{name:"decoder_num_attention_heads",val:" = 8"},{name:"encoder_num_key_value_heads",val:" = None"},{name:"decoder_num_key_value_heads",val:" = None"},{name:"encoder_hidden_act",val:" = 'gelu'"},{name:"decoder_hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 512"},{name:"initializer_range",val:" = 0.02"},{name:"decoder_start_token_id",val:" = 1"},{name:"use_cache",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"partial_rotary_factor",val:" = 0.9"},{name:"is_encoder_decoder",val:" = True"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoonshineConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32768) &#x2014;
Vocabulary size of the Moonshine model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineModel">MoonshineModel</a>.`,name:"vocab_size"},{anchor:"transformers.MoonshineConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 288) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.MoonshineConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1152) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.MoonshineConfig.encoder_num_hidden_layers",description:`<strong>encoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"encoder_num_hidden_layers"},{anchor:"transformers.MoonshineConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.MoonshineConfig.encoder_num_attention_heads",description:`<strong>encoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_num_attention_heads"},{anchor:"transformers.MoonshineConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.MoonshineConfig.encoder_num_key_value_heads",description:`<strong>encoder_num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>encoder_num_key_value_heads=encoder_num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>encoder_num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"encoder_num_key_value_heads"},{anchor:"transformers.MoonshineConfig.decoder_num_key_value_heads",description:`<strong>decoder_num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>decoder_num_key_value_heads=decoder_num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>decoder_num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>decoder_num_attention_heads</code>.`,name:"decoder_num_key_value_heads"},{anchor:"transformers.MoonshineConfig.encoder_hidden_act",description:`<strong>encoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder.`,name:"encoder_hidden_act"},{anchor:"transformers.MoonshineConfig.decoder_hidden_act",description:`<strong>decoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"decoder_hidden_act"},{anchor:"transformers.MoonshineConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.MoonshineConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MoonshineConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Corresponds to the &#x201D;&lt;|startoftranscript|&gt;&#x201D; token, which is automatically used when no <code>decoder_input_ids</code>
are provided to the <code>generate</code> function. It is used to guide the model\`s generation process depending on
the task.`,name:"decoder_start_token_id"},{anchor:"transformers.MoonshineConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.MoonshineConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.MoonshineConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.MoonshineConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.MoonshineConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.MoonshineConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.MoonshineConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MoonshineConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Denotes beginning of sequences token id.`,name:"bos_token_id"},{anchor:"transformers.MoonshineConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Denotes end of sequences token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/configuration_moonshine.py#L25"}}),N=new lo({props:{anchor:"transformers.MoonshineConfig.example",$$slots:{default:[Jo]},$$scope:{ctx:x}}}),ee=new Me({props:{title:"MoonshineModel",local:"transformers.MoonshineModel",headingTag:"h2"}}),oe=new le({props:{name:"class transformers.MoonshineModel",anchor:"transformers.MoonshineModel",parameters:[{name:"config",val:": MoonshineConfig"}],parametersDescription:[{anchor:"transformers.MoonshineModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig">MoonshineConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1251"}}),ne=new le({props:{name:"forward",anchor:"transformers.MoonshineModel.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.EncoderDecoderCache, typing.Tuple[torch.FloatTensor], NoneType] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_position_ids",val:": typing.Optional[typing.Tuple[torch.LongTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoonshineModel.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) &#x2014;
Float values of the raw speech waveform. Raw speech waveform can be
obtained by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a
<code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into
<code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> should be used for padding
and conversion into a tensor of type <code>torch.FloatTensor</code>.`,name:"input_values"},{anchor:"transformers.MoonshineModel.forward.attention_mask",description:"<strong>attention_mask</strong> (<code>torch.Tensor</code>)<code>, *optional*) -- Moonshine does not support masking of the </code>input_values`, this argument is preserved for compatibility,\nbut it is not used.",name:"attention_mask"},{anchor:"transformers.MoonshineModel.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"decoder_input_ids"},{anchor:"transformers.MoonshineModel.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_attention_mask"},{anchor:"transformers.MoonshineModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MoonshineModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>decoder_input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoonshineModel.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>decoder_input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MoonshineModel.forward.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"decoder_position_ids"},{anchor:"transformers.MoonshineModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoonshineModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoonshineModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoonshineModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoonshineModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>decoder_position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1326",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig"
>MoonshineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Z=new co({props:{$$slots:{default:[Wo]},$$scope:{ctx:x}}}),L=new lo({props:{anchor:"transformers.MoonshineModel.forward.example",$$slots:{default:[No]},$$scope:{ctx:x}}}),te=new le({props:{name:"_mask_input_features",anchor:"transformers.MoonshineModel._mask_input_features",parameters:[{name:"input_features",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1283"}}),se=new Me({props:{title:"MoonshineForConditionalGeneration",local:"transformers.MoonshineForConditionalGeneration",headingTag:"h2"}}),ae=new le({props:{name:"class transformers.MoonshineForConditionalGeneration",anchor:"transformers.MoonshineForConditionalGeneration",parameters:[{name:"config",val:": MoonshineConfig"}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig">MoonshineConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1432"}}),re=new le({props:{name:"forward",anchor:"transformers.MoonshineForConditionalGeneration.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.EncoderDecoderCache, typing.Tuple[torch.FloatTensor], NoneType] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_position_ids",val:": typing.Optional[typing.Tuple[torch.LongTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.forward.input_values",description:`<strong>input_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, audio_length)</code>) &#x2014;
Float values of the raw speech waveform. Raw speech waveform can be
obtained by loading a <code>.flac</code> or <code>.wav</code> audio file into an array of type <code>List[float]</code> or a
<code>numpy.ndarray</code>, <em>e.g.</em> via the soundfile library (<code>pip install soundfile</code>). To prepare the array into
<code>input_values</code>, the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoFeatureExtractor">AutoFeatureExtractor</a> should be used for padding
and conversion into a tensor of type <code>torch.FloatTensor</code>.`,name:"input_values"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.attention_mask",description:"<strong>attention_mask</strong> (<code>torch.Tensor</code>)<code>, *optional*) -- Moonshine does not support masking of the </code>input_values`, this argument is preserved for compatibility,\nbut it is not used.",name:"attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"decoder_input_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our
<a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>decoder_input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>decoder_input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.decoder_position_ids",description:`<strong>decoder_position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"decoder_position_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>decoder_position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MoonshineForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code>
or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored (masked), the loss is
only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/moonshine/modeling_moonshine.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/moonshine#transformers.MoonshineConfig"
>MoonshineConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new co({props:{$$slots:{default:[Zo]},$$scope:{ctx:x}}}),S=new lo({props:{anchor:"transformers.MoonshineForConditionalGeneration.forward.example",$$slots:{default:[Lo]},$$scope:{ctx:x}}}),ie=new le({props:{name:"generate",anchor:"transformers.MoonshineForConditionalGeneration.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Optional[typing.Callable[[int, torch.Tensor], typing.List[int]]] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MoonshineForConditionalGeneration.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should be in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.generation_config",description:`<strong>generation_config</strong> (<a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which has the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complements the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden, this flag will be set
to <code>True</code> if using <code>FullyShardedDataParallel</code> or DeepSpeed ZeRO Stage 3 with multiple GPUs to avoid
deadlocking if one GPU finishes generating before other GPUs. Otherwise, defaults to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistant model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.MoonshineForConditionalGeneration.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generation_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1879",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.LongTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput"
>GenerateDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamDecoderOnlyOutput"
>GenerateBeamDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateEncoderDecoderOutput"
>GenerateEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GenerateBeamEncoderDecoderOutput"
>GenerateBeamEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),O=new co({props:{warning:!0,$$slots:{default:[Ro]},$$scope:{ctx:x}}}),de=new Io({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/moonshine.md"}}),{c(){n=h("meta"),M=a(),c=h("p"),d=a(),g(m.$$.fragment),o=a(),g(f.$$.fragment),xe=a(),V=h("p"),V.innerHTML=po,$e=a(),E=h("p"),E.textContent=mo,Ce=a(),H=h("p"),H.innerHTML=uo,ze=a(),X=h("p"),X.textContent=fo,Fe=a(),A=h("ul"),A.innerHTML=go,Ge=a(),B=h("p"),B.innerHTML=_o,qe=a(),g(Q.$$.fragment),Ue=a(),D=h("ul"),D.innerHTML=yo,je=a(),g(Y.$$.fragment),Ie=a(),$=h("div"),g(K.$$.fragment),Se=a(),he=h("p"),he.innerHTML=bo,Oe=a(),pe=h("p"),pe.innerHTML=vo,Ve=a(),g(N.$$.fragment),Je=a(),g(ee.$$.fragment),We=a(),w=h("div"),g(oe.$$.fragment),Ee=a(),me=h("p"),me.innerHTML=To,He=a(),ue=h("p"),ue.innerHTML=Mo,Xe=a(),F=h("div"),g(ne.$$.fragment),Ae=a(),fe=h("p"),fe.innerHTML=wo,Be=a(),g(Z.$$.fragment),Qe=a(),g(L.$$.fragment),De=a(),R=h("div"),g(te.$$.fragment),Ye=a(),ge=h("p"),ge.innerHTML=ko,Ne=a(),g(se.$$.fragment),Ze=a(),k=h("div"),g(ae.$$.fragment),Ke=a(),_e=h("p"),_e.innerHTML=xo,eo=a(),ye=h("p"),ye.innerHTML=$o,oo=a(),G=h("div"),g(re.$$.fragment),no=a(),be=h("p"),be.innerHTML=Co,to=a(),g(P.$$.fragment),so=a(),g(S.$$.fragment),ao=a(),I=h("div"),g(ie.$$.fragment),ro=a(),ve=h("p"),ve.textContent=zo,io=a(),g(O.$$.fragment),Le=a(),g(de.$$.fragment),Re=a(),ke=h("p"),this.h()},l(e){const t=jo("svelte-u9bgzb",document.head);n=p(t,"META",{name:!0,content:!0}),t.forEach(s),M=r(e),c=p(e,"P",{}),J(c).forEach(s),d=r(e),_(m.$$.fragment,e),o=r(e),_(f.$$.fragment,e),xe=r(e),V=p(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-102gja4"&&(V.innerHTML=po),$e=r(e),E=p(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-vfdo9a"&&(E.textContent=mo),Ce=r(e),H=p(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-hjmi0f"&&(H.innerHTML=uo),ze=r(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-axv494"&&(X.textContent=fo),Fe=r(e),A=p(e,"UL",{"data-svelte-h":!0}),u(A)!=="svelte-701nga"&&(A.innerHTML=go),Ge=r(e),B=p(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-py8twc"&&(B.innerHTML=_o),qe=r(e),_(Q.$$.fragment,e),Ue=r(e),D=p(e,"UL",{"data-svelte-h":!0}),u(D)!=="svelte-c521vh"&&(D.innerHTML=yo),je=r(e),_(Y.$$.fragment,e),Ie=r(e),$=p(e,"DIV",{class:!0});var q=J($);_(K.$$.fragment,q),Se=r(q),he=p(q,"P",{"data-svelte-h":!0}),u(he)!=="svelte-hx4u80"&&(he.innerHTML=bo),Oe=r(q),pe=p(q,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-o55m63"&&(pe.innerHTML=vo),Ve=r(q),_(N.$$.fragment,q),q.forEach(s),Je=r(e),_(ee.$$.fragment,e),We=r(e),w=p(e,"DIV",{class:!0});var C=J(w);_(oe.$$.fragment,C),Ee=r(C),me=p(C,"P",{"data-svelte-h":!0}),u(me)!=="svelte-136j98c"&&(me.innerHTML=To),He=r(C),ue=p(C,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-hswkmf"&&(ue.innerHTML=Mo),Xe=r(C),F=p(C,"DIV",{class:!0});var U=J(F);_(ne.$$.fragment,U),Ae=r(U),fe=p(U,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1vn92r5"&&(fe.innerHTML=wo),Be=r(U),_(Z.$$.fragment,U),Qe=r(U),_(L.$$.fragment,U),U.forEach(s),De=r(C),R=p(C,"DIV",{class:!0});var ce=J(R);_(te.$$.fragment,ce),Ye=r(ce),ge=p(ce,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-1iyovru"&&(ge.innerHTML=ko),ce.forEach(s),C.forEach(s),Ne=r(e),_(se.$$.fragment,e),Ze=r(e),k=p(e,"DIV",{class:!0});var z=J(k);_(ae.$$.fragment,z),Ke=r(z),_e=p(z,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-aii2zx"&&(_e.innerHTML=xo),eo=r(z),ye=p(z,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-hswkmf"&&(ye.innerHTML=$o),oo=r(z),G=p(z,"DIV",{class:!0});var j=J(G);_(re.$$.fragment,j),no=r(j),be=p(j,"P",{"data-svelte-h":!0}),u(be)!=="svelte-n5grur"&&(be.innerHTML=Co),to=r(j),_(P.$$.fragment,j),so=r(j),_(S.$$.fragment,j),j.forEach(s),ao=r(z),I=p(z,"DIV",{class:!0});var Te=J(I);_(ie.$$.fragment,Te),ro=r(Te),ve=p(Te,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-s5ko3x"&&(ve.textContent=zo),io=r(Te),_(O.$$.fragment,Te),Te.forEach(s),z.forEach(s),Le=r(e),_(de.$$.fragment,e),Re=r(e),ke=p(e,"P",{}),J(ke).forEach(s),this.h()},h(){W(n,"name","hf:doc:metadata"),W(n,"content",So),W($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,n),i(e,M,t),i(e,c,t),i(e,d,t),y(m,e,t),i(e,o,t),y(f,e,t),i(e,xe,t),i(e,V,t),i(e,$e,t),i(e,E,t),i(e,Ce,t),i(e,H,t),i(e,ze,t),i(e,X,t),i(e,Fe,t),i(e,A,t),i(e,Ge,t),i(e,B,t),i(e,qe,t),y(Q,e,t),i(e,Ue,t),i(e,D,t),i(e,je,t),y(Y,e,t),i(e,Ie,t),i(e,$,t),y(K,$,null),l($,Se),l($,he),l($,Oe),l($,pe),l($,Ve),y(N,$,null),i(e,Je,t),y(ee,e,t),i(e,We,t),i(e,w,t),y(oe,w,null),l(w,Ee),l(w,me),l(w,He),l(w,ue),l(w,Xe),l(w,F),y(ne,F,null),l(F,Ae),l(F,fe),l(F,Be),y(Z,F,null),l(F,Qe),y(L,F,null),l(w,De),l(w,R),y(te,R,null),l(R,Ye),l(R,ge),i(e,Ne,t),y(se,e,t),i(e,Ze,t),i(e,k,t),y(ae,k,null),l(k,Ke),l(k,_e),l(k,eo),l(k,ye),l(k,oo),l(k,G),y(re,G,null),l(G,no),l(G,be),l(G,to),y(P,G,null),l(G,so),y(S,G,null),l(k,ao),l(k,I),y(ie,I,null),l(I,ro),l(I,ve),l(I,io),y(O,I,null),i(e,Le,t),y(de,e,t),i(e,Re,t),i(e,ke,t),Pe=!0},p(e,[t]){const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),N.$set(q);const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),Z.$set(C);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),L.$set(U);const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),P.$set(ce);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),S.$set(z);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),O.$set(j)},i(e){Pe||(b(m.$$.fragment,e),b(f.$$.fragment,e),b(Q.$$.fragment,e),b(Y.$$.fragment,e),b(K.$$.fragment,e),b(N.$$.fragment,e),b(ee.$$.fragment,e),b(oe.$$.fragment,e),b(ne.$$.fragment,e),b(Z.$$.fragment,e),b(L.$$.fragment,e),b(te.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(P.$$.fragment,e),b(S.$$.fragment,e),b(ie.$$.fragment,e),b(O.$$.fragment,e),b(de.$$.fragment,e),Pe=!0)},o(e){v(m.$$.fragment,e),v(f.$$.fragment,e),v(Q.$$.fragment,e),v(Y.$$.fragment,e),v(K.$$.fragment,e),v(N.$$.fragment,e),v(ee.$$.fragment,e),v(oe.$$.fragment,e),v(ne.$$.fragment,e),v(Z.$$.fragment,e),v(L.$$.fragment,e),v(te.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(re.$$.fragment,e),v(P.$$.fragment,e),v(S.$$.fragment,e),v(ie.$$.fragment,e),v(O.$$.fragment,e),v(de.$$.fragment,e),Pe=!1},d(e){e&&(s(M),s(c),s(d),s(o),s(xe),s(V),s($e),s(E),s(Ce),s(H),s(ze),s(X),s(Fe),s(A),s(Ge),s(B),s(qe),s(Ue),s(D),s(je),s(Ie),s($),s(Je),s(We),s(w),s(Ne),s(Ze),s(k),s(Le),s(Re),s(ke)),s(n),T(m,e),T(f,e),T(Q,e),T(Y,e),T(K),T(N),T(ee,e),T(oe),T(ne),T(Z),T(L),T(te),T(se,e),T(ae),T(re),T(P),T(S),T(ie),T(O),T(de,e)}}}const So='{"title":"Moonshine","local":"moonshine","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MoonshineConfig","local":"transformers.MoonshineConfig","sections":[],"depth":2},{"title":"MoonshineModel","local":"transformers.MoonshineModel","sections":[],"depth":2},{"title":"MoonshineForConditionalGeneration","local":"transformers.MoonshineForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Oo(x){return Go(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Do extends qo{constructor(n){super(),Uo(this,n,Oo,Po,Fo,{})}}export{Do as component};
