import{s as Do,o as Po,n as A}from"../chunks/scheduler.25b97de1.js";import{S as Yo,i as Oo,g as u,s as a,r as g,A as Ko,h,f as l,c as r,j as V,u as _,x as k,k as Z,y as i,a as m,v as M,d as T,t as b,w as y}from"../chunks/index.d9030fc9.js";import{T as Tn}from"../chunks/Tip.baa67368.js";import{D as q}from"../chunks/Docstring.ffac8efa.js";import{C as ae}from"../chunks/CodeBlock.e6cd0d95.js";import{F as es,M as yo}from"../chunks/Markdown.7217f838.js";import{E as oe}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as se,E as ts}from"../chunks/EditOnGithub.91d95064.js";function ns($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1UNU1vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwTVQ1TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBYXJ0aWNsZSUyMCUzRCUyMCUyMlVOJTIwT2ZmaXppZXIlMjBzYWd0JTJDJTIwZGFzcyUyMHdlaXRlciUyMHZlcmhhbmRlbHQlMjB3ZXJkZW4lMjBtdXNzJTIwaW4lMjBTeXJpZW4uJTIyJTBBc3VtbWFyeSUyMCUzRCUyMCUyMldlaXRlciUyMFZlcmhhbmRsdW5nJTIwaW4lMjBTeXJpZW4uJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0ZXh0X3RhcmdldCUzRHN1bW1hcnklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGxhYmVscyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFoaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MT5Model, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], decoder_input_ids=labels[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function os($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"JTIzJTIwT24lMjBhJTIwNCUyMEdQVSUyMG1hY2hpbmUlMjB3aXRoJTIwbXQ1LXhsJTNBJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk10NS14bCUyMiklMEFkZXZpY2VfbWFwJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwMCUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlNUIzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglMkMlMjA5JTVEJTJDJTBBJTIwJTIwJTIwJTIwMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTJDJTIwMTQlMkMlMjAxNSUyQyUyMDE2JTVEJTJDJTBBJTIwJTIwJTIwJTIwMyUzQSUyMCU1QjE3JTJDJTIwMTglMkMlMjAxOSUyQyUyMDIwJTJDJTIwMjElMkMlMjAyMiUyQyUyMDIzJTVEJTJDJTBBJTdEJTBBbW9kZWwucGFyYWxsZWxpemUoZGV2aWNlX21hcCklMjAlMjAlMjMlMjBTcGxpdHMlMjB0aGUlMjBtb2RlbCUyMGFjcm9zcyUyMHNldmVyYWwlMjBkZXZpY2VzJTBBbW9kZWwuZGVwYXJhbGxlbGl6ZSgpJTIwJTIwJTIzJTIwUHV0JTIwdGhlJTIwbW9kZWwlMjBiYWNrJTIwb24lMjBjcHUlMjBhbmQlMjBjbGVhbnMlMjBtZW1vcnklMjBieSUyMGNhbGxpbmclMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCk=",highlighted:`<span class="hljs-comment"># On a 4 GPU machine with mt5-xl:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)  <span class="hljs-comment"># Splits the model across several devices</span>
model.deparallelize()  <span class="hljs-comment"># Put the model back on cpu and cleans memory by calling torch.cuda.empty_cache()</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function ss($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=f},l(n){t=h(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){m(n,t,o)},p:A,d(n){n&&l(t)}}}function as($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNVDVNb2RlbCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyME1UNU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMlN0dWRpZXMlMjBoYXZlJTIwYmVlbiUyMHNob3duJTIwdGhhdCUyMG93bmluZyUyMGElMjBkb2clMjBpcyUyMGdvb2QlMjBmb3IlMjB5b3UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyU3R1ZGllcyUyMHNob3clMjB0aGF0JTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTIwJTIwJTIzJTIwQmF0Y2glMjBzaXplJTIwMSUwQSUwQSUyMyUyMHByZXByb2Nlc3MlM0ElMjBQcmVwZW5kJTIwZGVjb2Rlcl9pbnB1dF9pZHMlMjB3aXRoJTIwc3RhcnQlMjB0b2tlbiUyMHdoaWNoJTIwaXMlMjBwYWQlMjB0b2tlbiUyMGZvciUyME1UNU1vZGVsLiUwQSUyMyUyMFRoaXMlMjBpcyUyMG5vdCUyMG5lZWRlZCUyMGZvciUyMHRvcmNoJ3MlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMjBhcyUyMGl0JTIwZG9lcyUyMHRoaXMlMjBpbnRlcm5hbGx5JTIwdXNpbmclMjBsYWJlbHMlMjBhcmcuJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjBtb2RlbC5fc2hpZnRfcmlnaHQoZGVjb2Rlcl9pbnB1dF9pZHMpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RkZWNvZGVyX2lucHV0X2lkcyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MT5Model

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(<span class="hljs-string">&quot;Studies show that&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids  <span class="hljs-comment"># Batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># preprocess: Prepend decoder_input_ids with start token which is pad token for MT5Model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is not needed for torch&#x27;s MT5ForConditionalGeneration as it does this internally using labels arg.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = model._shift_right(decoder_input_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function rs($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"JTIzJTIwSGVyZSUyMGlzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBhJTIwZGV2aWNlJTIwbWFwJTIwb24lMjBhJTIwbWFjaGluZSUyMHdpdGglMjA0JTIwR1BVcyUyMHVzaW5nJTIwbXQ1LXhsJTJDJTIwd2hpY2glMjBoYXMlMjBhJTIwdG90YWwlMjBvZiUyMDI0JTIwYXR0ZW50aW9uJTIwbW9kdWxlcyUzQSUwQW1vZGVsJTIwJTNEJTIwTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdDUteGwlMjIpJTBBZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMDAlM0ElMjAlNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAxJTNBJTIwJTVCMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyUyQyUyMDE0JTJDJTIwMTUlMkMlMjAxNiU1RCUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlNUIxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTJDJTIwMjIlMkMlMjAyMyU1RCUyQyUwQSU3RCUwQW1vZGVsLnBhcmFsbGVsaXplKGRldmljZV9tYXAp",highlighted:`<span class="hljs-comment"># Here is an example of a device map on a machine with 4 GPUs using mt5-xl, which has a total of 24 attention modules:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function ls($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1UNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyME1UNUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFzdW1tYXJ5JTIwJTNEJTIwJTIyV2VpdGVyJTIwVmVyaGFuZGx1bmclMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHRleHRfdGFyZ2V0JTNEc3VtbWFyeSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MT5ForConditionalGeneration, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, text_target=summary, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function is($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"JTIzJTIwT24lMjBhJTIwNCUyMEdQVSUyMG1hY2hpbmUlMjB3aXRoJTIwbXQ1LXhsJTNBJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk10NS14bCUyMiklMEFkZXZpY2VfbWFwJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwMCUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlNUIzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglMkMlMjA5JTVEJTJDJTBBJTIwJTIwJTIwJTIwMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTJDJTIwMTQlMkMlMjAxNSUyQyUyMDE2JTVEJTJDJTBBJTIwJTIwJTIwJTIwMyUzQSUyMCU1QjE3JTJDJTIwMTglMkMlMjAxOSUyQyUyMDIwJTJDJTIwMjElMkMlMjAyMiUyQyUyMDIzJTVEJTJDJTBBJTdEJTBBbW9kZWwucGFyYWxsZWxpemUoZGV2aWNlX21hcCklMjAlMjAlMjMlMjBTcGxpdHMlMjB0aGUlMjBtb2RlbCUyMGFjcm9zcyUyMHNldmVyYWwlMjBkZXZpY2VzJTBBbW9kZWwuZGVwYXJhbGxlbGl6ZSgpJTIwJTIwJTIzJTIwUHV0JTIwdGhlJTIwbW9kZWwlMjBiYWNrJTIwb24lMjBjcHUlMjBhbmQlMjBjbGVhbnMlMjBtZW1vcnklMjBieSUyMGNhbGxpbmclMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCk=",highlighted:`<span class="hljs-comment"># On a 4 GPU machine with mt5-xl:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)  <span class="hljs-comment"># Splits the model across several devices</span>
model.deparallelize()  <span class="hljs-comment"># Put the model back on cpu and cleans memory by calling torch.cuda.empty_cache()</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function ds($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=f},l(n){t=h(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){m(n,t,o)},p:A,d(n){n&&l(t)}}}function cs($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEElMEElMjMlMjB0cmFpbmluZyUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjAlM0NleHRyYV9pZF8wJTNFJTIwd2Fsa3MlMjBpbiUyMCUzQ2V4dHJhX2lkXzElM0UlMjBwYXJrJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBbGFiZWxzJTIwJTNEJTIwdG9rZW5pemVyKCUyMiUzQ2V4dHJhX2lkXzAlM0UlMjBjdXRlJTIwZG9nJTIwJTNDZXh0cmFfaWRfMSUzRSUyMHRoZSUyMCUzQ2V4dHJhX2lkXzIlM0UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUwQSUyMyUyMGluZmVyZW5jZSUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjJzdW1tYXJpemUlM0ElMjBzdHVkaWVzJTIwaGF2ZSUyMHNob3duJTIwdGhhdCUyMG93bmluZyUyMGElMjBkb2clMjBpcyUyMGdvb2QlMjBmb3IlMjB5b3UlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS5pbnB1dF9pZHMlMjAlMjAlMjMlMjBCYXRjaCUyMHNpemUlMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0X2lkcyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUyMyUyMHN0dWRpZXMlMjBoYXZlJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdS4=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MT5ForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(<span class="hljs-string">&quot;The &lt;extra_id_0&gt; walks in &lt;extra_id_1&gt; park&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(<span class="hljs-string">&quot;&lt;extra_id_0&gt; cute dog &lt;extra_id_1&gt; the &lt;extra_id_2&gt;&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;summarize: studies have shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># studies have shown that owning a dog is good for you.</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function ps($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"JTIzJTIwSGVyZSUyMGlzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBhJTIwZGV2aWNlJTIwbWFwJTIwb24lMjBhJTIwbWFjaGluZSUyMHdpdGglMjA0JTIwR1BVcyUyMHVzaW5nJTIwbXQ1LXhsJTJDJTIwd2hpY2glMjBoYXMlMjBhJTIwdG90YWwlMjBvZiUyMDI0JTIwYXR0ZW50aW9uJTIwbW9kdWxlcyUzQSUwQW1vZGVsJTIwJTNEJTIwTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdDUteGwlMjIpJTBBZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMDAlM0ElMjAlNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAxJTNBJTIwJTVCMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyUyQyUyMDE0JTJDJTIwMTUlMkMlMjAxNiU1RCUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlNUIxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTJDJTIwMjIlMkMlMjAyMyU1RCUyQyUwQSU3RCUwQW1vZGVsLnBhcmFsbGVsaXplKGRldmljZV9tYXAp",highlighted:`<span class="hljs-comment"># Here is an example of a device map on a machine with 4 GPUs using mt5-xl, which has a total of 24 attention modules:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function ms($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1UNUVuY29kZXJNb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyME1UNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9pZHMpJTBBaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MT5EncoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function us($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"JTIzJTIwT24lMjBhJTIwNCUyMEdQVSUyMG1hY2hpbmUlMjB3aXRoJTIwbXQ1LXhsJTNBJTBBbW9kZWwlMjAlM0QlMjBNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMk10NS14bCUyMiklMEFkZXZpY2VfbWFwJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwMCUzQSUyMCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUwQSUyMCUyMCUyMCUyMDElM0ElMjAlNUIzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglMkMlMjA5JTVEJTJDJTBBJTIwJTIwJTIwJTIwMiUzQSUyMCU1QjEwJTJDJTIwMTElMkMlMjAxMiUyQyUyMDEzJTJDJTIwMTQlMkMlMjAxNSUyQyUyMDE2JTVEJTJDJTBBJTIwJTIwJTIwJTIwMyUzQSUyMCU1QjE3JTJDJTIwMTglMkMlMjAxOSUyQyUyMDIwJTJDJTIwMjElMkMlMjAyMiUyQyUyMDIzJTVEJTJDJTBBJTdEJTBBbW9kZWwucGFyYWxsZWxpemUoZGV2aWNlX21hcCklMjAlMjAlMjMlMjBTcGxpdHMlMjB0aGUlMjBtb2RlbCUyMGFjcm9zcyUyMHNldmVyYWwlMjBkZXZpY2VzJTBBbW9kZWwuZGVwYXJhbGxlbGl6ZSgpJTIwJTIwJTIzJTIwUHV0JTIwdGhlJTIwbW9kZWwlMjBiYWNrJTIwb24lMjBjcHUlMjBhbmQlMjBjbGVhbnMlMjBtZW1vcnklMjBieSUyMGNhbGxpbmclMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCk=",highlighted:`<span class="hljs-comment"># On a 4 GPU machine with mt5-xl:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)  <span class="hljs-comment"># Splits the model across several devices</span>
model.deparallelize()  <span class="hljs-comment"># Put the model back on cpu and cleans memory by calling torch.cuda.empty_cache()</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function hs($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=f},l(n){t=h(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){m(n,t,o)},p:A,d(n){n&&l(t)}}}function fs($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNVDVFbmNvZGVyTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIyU3R1ZGllcyUyMGhhdmUlMjBiZWVuJTIwc2hvd24lMjB0aGF0JTIwb3duaW5nJTIwYSUyMGRvZyUyMGlzJTIwZ29vZCUyMGZvciUyMHlvdSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLmlucHV0X2lkcyUyMCUyMCUyMyUyMEJhdGNoJTIwc2l6ZSUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRfaWRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MT5EncoderModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Studies have been shown that owning a dog is good for you&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).input_ids  <span class="hljs-comment"># Batch size 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function gs($){let t,f="Example:",n,o,c;return o=new ae({props:{code:"JTIzJTIwSGVyZSUyMGlzJTIwYW4lMjBleGFtcGxlJTIwb2YlMjBhJTIwZGV2aWNlJTIwbWFwJTIwb24lMjBhJTIwbWFjaGluZSUyMHdpdGglMjA0JTIwR1BVcyUyMHVzaW5nJTIwbXQ1LXhsJTJDJTIwd2hpY2glMjBoYXMlMjBhJTIwdG90YWwlMjBvZiUyMDI0JTIwYXR0ZW50aW9uJTIwbW9kdWxlcyUzQSUwQW1vZGVsJTIwJTNEJTIwTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdDUteGwlMjIpJTBBZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMDAlM0ElMjAlNUIwJTJDJTIwMSUyQyUyMDIlNUQlMkMlMEElMjAlMjAlMjAlMjAxJTNBJTIwJTVCMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCUyQyUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUIxMCUyQyUyMDExJTJDJTIwMTIlMkMlMjAxMyUyQyUyMDE0JTJDJTIwMTUlMkMlMjAxNiU1RCUyQyUwQSUyMCUyMCUyMCUyMDMlM0ElMjAlNUIxNyUyQyUyMDE4JTJDJTIwMTklMkMlMjAyMCUyQyUyMDIxJTJDJTIwMjIlMkMlMjAyMyU1RCUyQyUwQSU3RCUwQW1vZGVsLnBhcmFsbGVsaXplKGRldmljZV9tYXAp",highlighted:`<span class="hljs-comment"># Here is an example of a device map on a machine with 4 GPUs using mt5-xl, which has a total of 24 attention modules:</span>
model = MT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;mt5-xl&quot;</span>)
device_map = {
    <span class="hljs-number">0</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    <span class="hljs-number">1</span>: [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>],
    <span class="hljs-number">2</span>: [<span class="hljs-number">10</span>, <span class="hljs-number">11</span>, <span class="hljs-number">12</span>, <span class="hljs-number">13</span>, <span class="hljs-number">14</span>, <span class="hljs-number">15</span>, <span class="hljs-number">16</span>],
    <span class="hljs-number">3</span>: [<span class="hljs-number">17</span>, <span class="hljs-number">18</span>, <span class="hljs-number">19</span>, <span class="hljs-number">20</span>, <span class="hljs-number">21</span>, <span class="hljs-number">22</span>, <span class="hljs-number">23</span>],
}
model.parallelize(device_map)`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-11lpom8"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function _s($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=f},l(n){t=h(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){m(n,t,o)},p:A,d(n){n&&l(t)}}}function Ms($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=f},l(n){t=h(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){m(n,t,o)},p:A,d(n){n&&l(t)}}}function Ts($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=f},l(n){t=h(n,"P",{"data-svelte-h":!0}),k(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(n,o){m(n,t,o)},p:A,d(n){n&&l(t)}}}function bs($){let t,f,n,o,c,e,w="The bare MT5 Model transformer outputting raw hidden-states without any specific head on top.",Te,G,ee=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,X,E,W=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,H,P,ne=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,be,Q,S,N,C,pe,U,R="Moves the model to cpu from a model parallel state.",ye,B,re,L,I,Y,p,j='The <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> forward method, overrides the <code>__call__</code> special method.',z,x,le,Ge,dt,te,xe,me,we,Et="This is an experimental feature and is a subject to change at a moment’s notice.",Ae,Ke,Ht=`Uses a device map to distribute attention modules of the model across several devices. If no device map is given,
it will evenly distribute blocks across all devices.`,Le,We,et,ue,tt,F,he,ct,ke,bn="MT5 Model with a <code>language modeling</code> head on top.",pt,ve,vt=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,Ve,$e,$t=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Be,nt,jt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ce,je,qe,fe,Je,mt,d,J="Moves the model to cpu from a model parallel state.",Ue,Re,Qt,ze,Jt,Cn,St,wo='The <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForConditionalGeneration">MT5ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',zn,ut,Fn,ht,In,Fe,Ut,Zn,At,ko="This is an experimental feature and is a subject to change at a moment’s notice.",Gn,Lt,vo=`Uses a device map to distribute attention modules of the model across several devices. If no device map is given,
it will evenly distribute blocks across all devices.`,Wn,ft,yn,xt,wn,D,Ct,Vn,Dt,$o="The bare MT5 Model transformer outputting encoder’s raw hidden-states without any specific head on top.",Bn,Pt,jo=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,qn,Yt,Jo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Rn,Ot,Uo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Nn,gt,Xn,De,zt,En,Kt,xo="Moves the model to cpu from a model parallel state.",Hn,_t,Qn,Ie,Ft,Sn,en,Co='The <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5EncoderModel">MT5EncoderModel</a> forward method, overrides the <code>__call__</code> special method.',An,Mt,Ln,Tt,Dn,Ze,It,Pn,tn,zo="This is an experimental feature and is a subject to change at a moment’s notice.",Yn,nn,Fo=`Uses a device map to distribute attention modules of the model across several devices. If no device map is given,
it will evenly distribute blocks across all devices.`,On,bt,kn,Zt,vn,ie,Gt,Kn,on,Io=`MT5 model with a sequence classification/head on top (a linear layer on top of the pooled output) e.g. for GLUE
tasks.`,eo,sn,Zo=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,to,an,Go=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,no,rn,Wo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,oo,Pe,Wt,so,ln,Vo='The <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForSequenceClassification">MT5ForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ao,yt,$n,Vt,jn,de,Bt,ro,dn,Bo=`MT5 Encoder Model with a token classification head on top (a linear layer on top of the hidden-states output)
e.g. for Named-Entity-Recognition (NER) tasks.`,lo,cn,qo=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,io,pn,Ro=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,co,mn,No=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,po,Ye,qt,mo,un,Xo='The <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForTokenClassification">MT5ForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',uo,wt,Jn,Rt,Un,ce,Nt,ho,hn,Eo=`MT5 Model with a span classification head on top for extractive question-answering tasks like SQuAD (linear layers
on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,fo,fn,Ho=`The MT5 model was proposed in <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">Exploring the Limits of Transfer Learning with a Unified Text-to-Text
Transformer</a> by Colin Raffel, Noam Shazeer, Adam Roberts, Katherine Lee, Sharan
Narang, Michael Matena, Yanqi Zhou, Wei Li, Peter J. Liu. It’s an encoder decoder transformer pre-trained in a
text-to-text denoising generative setting.`,go,gn,Qo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,_o,_n,So=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Mo,Oe,Xt,To,Mn,Ao='The <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5ForQuestionAnswering">MT5ForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',bo,kt,xn;return t=new se({props:{title:"MT5Model",local:"transformers.MT5Model",headingTag:"h2"}}),o=new q({props:{name:"class transformers.MT5Model",anchor:"transformers.MT5Model",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5Model.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1469"}}),Q=new oe({props:{anchor:"transformers.MT5Model.example",$$slots:{default:[ns]},$$scope:{ctx:$}}}),C=new q({props:{name:"deparallelize",anchor:"transformers.MT5Model.deparallelize",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1540"}}),B=new oe({props:{anchor:"transformers.MT5Model.deparallelize.example",$$slots:{default:[os]},$$scope:{ctx:$}}}),I=new q({props:{name:"forward",anchor:"transformers.MT5Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MT5Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5Model.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5Model.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5Model.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5Model.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5Model.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5Model.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5Model.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5Model.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5Model.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5Model.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqModelOutput"
>transformers.modeling_outputs.Seq2SeqModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),x=new Tn({props:{$$slots:{default:[ss]},$$scope:{ctx:$}}}),Ge=new oe({props:{anchor:"transformers.MT5Model.forward.example",$$slots:{default:[as]},$$scope:{ctx:$}}}),xe=new q({props:{name:"parallelize",anchor:"transformers.MT5Model.parallelize",parameters:[{name:"device_map",val:" = None"}],parametersDescription:[{anchor:"transformers.MT5Model.parallelize.device_map",description:`<strong>device_map</strong> (<code>Dict[int, list]</code>, <em>optional</em>) &#x2014;
A dictionary that maps attention modules to devices. Note that the embedding module and LMHead are always
automatically mapped to the first device (for esoteric reasons). That means that the first device should
have fewer attention modules mapped to it than other devices. For reference, the mt5 models have the
following number of attention modules:</p>
<ul>
<li>mt5-small: 6</li>
<li>mt5-base: 12</li>
<li>mt5-large: 24</li>
<li>mt5-xl: 24</li>
<li>mt5-xxl: 24</li>
</ul>`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1520"}}),We=new oe({props:{anchor:"transformers.MT5Model.parallelize.example",$$slots:{default:[rs]},$$scope:{ctx:$}}}),ue=new se({props:{title:"MT5ForConditionalGeneration",local:"transformers.MT5ForConditionalGeneration",headingTag:"h2"}}),he=new q({props:{name:"class transformers.MT5ForConditionalGeneration",anchor:"transformers.MT5ForConditionalGeneration",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1700"}}),je=new oe({props:{anchor:"transformers.MT5ForConditionalGeneration.example",$$slots:{default:[ls]},$$scope:{ctx:$}}}),Je=new q({props:{name:"deparallelize",anchor:"transformers.MT5ForConditionalGeneration.deparallelize",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1772"}}),Re=new oe({props:{anchor:"transformers.MT5ForConditionalGeneration.deparallelize.example",$$slots:{default:[is]},$$scope:{ctx:$}}}),Jt=new q({props:{name:"forward",anchor:"transformers.MT5ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.MT5ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[-100, 0, ..., config.vocab_size - 1]</code>. All labels set to <code>-100</code> are ignored (masked), the loss is only computed for
labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1814",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ut=new Tn({props:{$$slots:{default:[ds]},$$scope:{ctx:$}}}),ht=new oe({props:{anchor:"transformers.MT5ForConditionalGeneration.forward.example",$$slots:{default:[cs]},$$scope:{ctx:$}}}),Ut=new q({props:{name:"parallelize",anchor:"transformers.MT5ForConditionalGeneration.parallelize",parameters:[{name:"device_map",val:" = None"}],parametersDescription:[{anchor:"transformers.MT5ForConditionalGeneration.parallelize.device_map",description:`<strong>device_map</strong> (<code>Dict[int, list]</code>, <em>optional</em>) &#x2014;
A dictionary that maps attention modules to devices. Note that the embedding module and LMHead are always
automatically mapped to the first device (for esoteric reasons). That means that the first device should
have fewer attention modules mapped to it than other devices. For reference, the mt5 models have the
following number of attention modules:</p>
<ul>
<li>mt5-small: 6</li>
<li>mt5-base: 12</li>
<li>mt5-large: 24</li>
<li>mt5-xl: 24</li>
<li>mt5-xxl: 24</li>
</ul>`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L1751"}}),ft=new oe({props:{anchor:"transformers.MT5ForConditionalGeneration.parallelize.example",$$slots:{default:[ps]},$$scope:{ctx:$}}}),xt=new se({props:{title:"MT5EncoderModel",local:"transformers.MT5EncoderModel",headingTag:"h2"}}),Ct=new q({props:{name:"class transformers.MT5EncoderModel",anchor:"transformers.MT5EncoderModel",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5EncoderModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2008"}}),gt=new oe({props:{anchor:"transformers.MT5EncoderModel.example",$$slots:{default:[ms]},$$scope:{ctx:$}}}),zt=new q({props:{name:"deparallelize",anchor:"transformers.MT5EncoderModel.deparallelize",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2067"}}),_t=new oe({props:{anchor:"transformers.MT5EncoderModel.deparallelize.example",$$slots:{default:[us]},$$scope:{ctx:$}}}),Ft=new q({props:{name:"forward",anchor:"transformers.MT5EncoderModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MT5EncoderModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5EncoderModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5EncoderModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5EncoderModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5EncoderModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5EncoderModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5EncoderModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Mt=new Tn({props:{$$slots:{default:[hs]},$$scope:{ctx:$}}}),Tt=new oe({props:{anchor:"transformers.MT5EncoderModel.forward.example",$$slots:{default:[fs]},$$scope:{ctx:$}}}),It=new q({props:{name:"parallelize",anchor:"transformers.MT5EncoderModel.parallelize",parameters:[{name:"device_map",val:" = None"}],parametersDescription:[{anchor:"transformers.MT5EncoderModel.parallelize.device_map",description:`<strong>device_map</strong> (<code>Dict[int, list]</code>, <em>optional</em>) &#x2014;
A dictionary that maps attention modules to devices. Note that the embedding module and LMHead are always
automatically mapped to the first device (for esoteric reasons). That means that the first device should
have fewer attention modules mapped to it than other devices. For reference, the mt5 models have the
following number of attention modules:</p>
<ul>
<li>mt5-small: 6</li>
<li>mt5-base: 12</li>
<li>mt5-large: 24</li>
<li>mt5-xl: 24</li>
<li>mt5-xxl: 24</li>
</ul>`,name:"device_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2048"}}),bt=new oe({props:{anchor:"transformers.MT5EncoderModel.parallelize.example",$$slots:{default:[gs]},$$scope:{ctx:$}}}),Zt=new se({props:{title:"MT5ForSequenceClassification",local:"transformers.MT5ForSequenceClassification",headingTag:"h2"}}),Gt=new q({props:{name:"class transformers.MT5ForSequenceClassification",anchor:"transformers.MT5ForSequenceClassification",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2146"}}),Wt=new q({props:{name:"forward",anchor:"transformers.MT5ForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MT5ForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForSequenceClassification.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForSequenceClassification.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2168",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"
>transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>label</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput"
>transformers.modeling_outputs.Seq2SeqSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),yt=new Tn({props:{$$slots:{default:[_s]},$$scope:{ctx:$}}}),Vt=new se({props:{title:"MT5ForTokenClassification",local:"transformers.MT5ForTokenClassification",headingTag:"h2"}}),Bt=new q({props:{name:"class transformers.MT5ForTokenClassification",anchor:"transformers.MT5ForTokenClassification",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2281"}}),qt=new q({props:{name:"forward",anchor:"transformers.MT5ForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MT5ForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForTokenClassification.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForTokenClassification.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2303",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),wt=new Tn({props:{$$slots:{default:[Ms]},$$scope:{ctx:$}}}),Rt=new se({props:{title:"MT5ForQuestionAnswering",local:"transformers.MT5ForQuestionAnswering",headingTag:"h2"}}),Nt=new q({props:{name:"class transformers.MT5ForQuestionAnswering",anchor:"transformers.MT5ForQuestionAnswering",parameters:[{name:"config",val:": MT5Config"}],parametersDescription:[{anchor:"transformers.MT5ForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config">MT5Config</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2355"}}),Xt=new q({props:{name:"forward",anchor:"transformers.MT5ForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MT5ForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. MT5 is a model with relative position embeddings so you
should be able to pad the inputs on both the right and the left.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for detail.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<p>To know more on how to prepare <code>input_ids</code> for pretraining take a look a <a href="./mt5#training">MT5 Training</a>.`,name:"input_ids"},{anchor:"transformers.MT5ForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<p>MT5 uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If <code>past_key_values</code>
is used, optionally only the last <code>decoder_input_ids</code> have to be input (see <code>past_key_values</code>).</p>
<p>To know more on how to prepare <code>decoder_input_ids</code> for pretraining take a look at <a href="./mt5#training">MT5
Training</a>.`,name:"decoder_input_ids"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in
<code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MT5ForQuestionAnswering.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MT5ForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MT5ForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MT5ForQuestionAnswering.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MT5ForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MT5ForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MT5ForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MT5ForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MT5ForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.MT5ForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<em>sequence_length</em>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_mt5.py#L2411",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"
>transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Config"
>MT5Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput"
>transformers.modeling_outputs.Seq2SeqQuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),kt=new Tn({props:{$$slots:{default:[Ts]},$$scope:{ctx:$}}}),{c(){g(t.$$.fragment),f=a(),n=u("div"),g(o.$$.fragment),c=a(),e=u("p"),e.textContent=w,Te=a(),G=u("p"),G.innerHTML=ee,X=a(),E=u("p"),E.innerHTML=W,H=a(),P=u("p"),P.innerHTML=ne,be=a(),g(Q.$$.fragment),S=a(),N=u("div"),g(C.$$.fragment),pe=a(),U=u("p"),U.textContent=R,ye=a(),g(B.$$.fragment),re=a(),L=u("div"),g(I.$$.fragment),Y=a(),p=u("p"),p.innerHTML=j,z=a(),g(x.$$.fragment),le=a(),g(Ge.$$.fragment),dt=a(),te=u("div"),g(xe.$$.fragment),me=a(),we=u("p"),we.textContent=Et,Ae=a(),Ke=u("p"),Ke.textContent=Ht,Le=a(),g(We.$$.fragment),et=a(),g(ue.$$.fragment),tt=a(),F=u("div"),g(he.$$.fragment),ct=a(),ke=u("p"),ke.innerHTML=bn,pt=a(),ve=u("p"),ve.innerHTML=vt,Ve=a(),$e=u("p"),$e.innerHTML=$t,Be=a(),nt=u("p"),nt.innerHTML=jt,Ce=a(),g(je.$$.fragment),qe=a(),fe=u("div"),g(Je.$$.fragment),mt=a(),d=u("p"),d.textContent=J,Ue=a(),g(Re.$$.fragment),Qt=a(),ze=u("div"),g(Jt.$$.fragment),Cn=a(),St=u("p"),St.innerHTML=wo,zn=a(),g(ut.$$.fragment),Fn=a(),g(ht.$$.fragment),In=a(),Fe=u("div"),g(Ut.$$.fragment),Zn=a(),At=u("p"),At.textContent=ko,Gn=a(),Lt=u("p"),Lt.textContent=vo,Wn=a(),g(ft.$$.fragment),yn=a(),g(xt.$$.fragment),wn=a(),D=u("div"),g(Ct.$$.fragment),Vn=a(),Dt=u("p"),Dt.textContent=$o,Bn=a(),Pt=u("p"),Pt.innerHTML=jo,qn=a(),Yt=u("p"),Yt.innerHTML=Jo,Rn=a(),Ot=u("p"),Ot.innerHTML=Uo,Nn=a(),g(gt.$$.fragment),Xn=a(),De=u("div"),g(zt.$$.fragment),En=a(),Kt=u("p"),Kt.textContent=xo,Hn=a(),g(_t.$$.fragment),Qn=a(),Ie=u("div"),g(Ft.$$.fragment),Sn=a(),en=u("p"),en.innerHTML=Co,An=a(),g(Mt.$$.fragment),Ln=a(),g(Tt.$$.fragment),Dn=a(),Ze=u("div"),g(It.$$.fragment),Pn=a(),tn=u("p"),tn.textContent=zo,Yn=a(),nn=u("p"),nn.textContent=Fo,On=a(),g(bt.$$.fragment),kn=a(),g(Zt.$$.fragment),vn=a(),ie=u("div"),g(Gt.$$.fragment),Kn=a(),on=u("p"),on.textContent=Io,eo=a(),sn=u("p"),sn.innerHTML=Zo,to=a(),an=u("p"),an.innerHTML=Go,no=a(),rn=u("p"),rn.innerHTML=Wo,oo=a(),Pe=u("div"),g(Wt.$$.fragment),so=a(),ln=u("p"),ln.innerHTML=Vo,ao=a(),g(yt.$$.fragment),$n=a(),g(Vt.$$.fragment),jn=a(),de=u("div"),g(Bt.$$.fragment),ro=a(),dn=u("p"),dn.textContent=Bo,lo=a(),cn=u("p"),cn.innerHTML=qo,io=a(),pn=u("p"),pn.innerHTML=Ro,co=a(),mn=u("p"),mn.innerHTML=No,po=a(),Ye=u("div"),g(qt.$$.fragment),mo=a(),un=u("p"),un.innerHTML=Xo,uo=a(),g(wt.$$.fragment),Jn=a(),g(Rt.$$.fragment),Un=a(),ce=u("div"),g(Nt.$$.fragment),ho=a(),hn=u("p"),hn.innerHTML=Eo,fo=a(),fn=u("p"),fn.innerHTML=Ho,go=a(),gn=u("p"),gn.innerHTML=Qo,_o=a(),_n=u("p"),_n.innerHTML=So,Mo=a(),Oe=u("div"),g(Xt.$$.fragment),To=a(),Mn=u("p"),Mn.innerHTML=Ao,bo=a(),g(kt.$$.fragment),this.h()},l(s){_(t.$$.fragment,s),f=r(s),n=h(s,"DIV",{class:!0});var v=V(n);_(o.$$.fragment,v),c=r(v),e=h(v,"P",{"data-svelte-h":!0}),k(e)!=="svelte-r01pan"&&(e.textContent=w),Te=r(v),G=h(v,"P",{"data-svelte-h":!0}),k(G)!=="svelte-1hbaqlt"&&(G.innerHTML=ee),X=r(v),E=h(v,"P",{"data-svelte-h":!0}),k(E)!=="svelte-6pahdo"&&(E.innerHTML=W),H=r(v),P=h(v,"P",{"data-svelte-h":!0}),k(P)!=="svelte-hswkmf"&&(P.innerHTML=ne),be=r(v),_(Q.$$.fragment,v),S=r(v),N=h(v,"DIV",{class:!0});var ot=V(N);_(C.$$.fragment,ot),pe=r(ot),U=h(ot,"P",{"data-svelte-h":!0}),k(U)!=="svelte-ewr91v"&&(U.textContent=R),ye=r(ot),_(B.$$.fragment,ot),ot.forEach(l),re=r(v),L=h(v,"DIV",{class:!0});var Ne=V(L);_(I.$$.fragment,Ne),Y=r(Ne),p=h(Ne,"P",{"data-svelte-h":!0}),k(p)!=="svelte-1t10xed"&&(p.innerHTML=j),z=r(Ne),_(x.$$.fragment,Ne),le=r(Ne),_(Ge.$$.fragment,Ne),Ne.forEach(l),dt=r(v),te=h(v,"DIV",{class:!0});var Xe=V(te);_(xe.$$.fragment,Xe),me=r(Xe),we=h(Xe,"P",{"data-svelte-h":!0}),k(we)!=="svelte-1wtkcqk"&&(we.textContent=Et),Ae=r(Xe),Ke=h(Xe,"P",{"data-svelte-h":!0}),k(Ke)!=="svelte-16fuwd4"&&(Ke.textContent=Ht),Le=r(Xe),_(We.$$.fragment,Xe),Xe.forEach(l),v.forEach(l),et=r(s),_(ue.$$.fragment,s),tt=r(s),F=h(s,"DIV",{class:!0});var O=V(F);_(he.$$.fragment,O),ct=r(O),ke=h(O,"P",{"data-svelte-h":!0}),k(ke)!=="svelte-1mzt99y"&&(ke.innerHTML=bn),pt=r(O),ve=h(O,"P",{"data-svelte-h":!0}),k(ve)!=="svelte-1hbaqlt"&&(ve.innerHTML=vt),Ve=r(O),$e=h(O,"P",{"data-svelte-h":!0}),k($e)!=="svelte-6pahdo"&&($e.innerHTML=$t),Be=r(O),nt=h(O,"P",{"data-svelte-h":!0}),k(nt)!=="svelte-hswkmf"&&(nt.innerHTML=jt),Ce=r(O),_(je.$$.fragment,O),qe=r(O),fe=h(O,"DIV",{class:!0});var st=V(fe);_(Je.$$.fragment,st),mt=r(st),d=h(st,"P",{"data-svelte-h":!0}),k(d)!=="svelte-ewr91v"&&(d.textContent=J),Ue=r(st),_(Re.$$.fragment,st),st.forEach(l),Qt=r(O),ze=h(O,"DIV",{class:!0});var Ee=V(ze);_(Jt.$$.fragment,Ee),Cn=r(Ee),St=h(Ee,"P",{"data-svelte-h":!0}),k(St)!=="svelte-d1xuhv"&&(St.innerHTML=wo),zn=r(Ee),_(ut.$$.fragment,Ee),Fn=r(Ee),_(ht.$$.fragment,Ee),Ee.forEach(l),In=r(O),Fe=h(O,"DIV",{class:!0});var He=V(Fe);_(Ut.$$.fragment,He),Zn=r(He),At=h(He,"P",{"data-svelte-h":!0}),k(At)!=="svelte-1wtkcqk"&&(At.textContent=ko),Gn=r(He),Lt=h(He,"P",{"data-svelte-h":!0}),k(Lt)!=="svelte-16fuwd4"&&(Lt.textContent=vo),Wn=r(He),_(ft.$$.fragment,He),He.forEach(l),O.forEach(l),yn=r(s),_(xt.$$.fragment,s),wn=r(s),D=h(s,"DIV",{class:!0});var K=V(D);_(Ct.$$.fragment,K),Vn=r(K),Dt=h(K,"P",{"data-svelte-h":!0}),k(Dt)!=="svelte-1ixg1pn"&&(Dt.textContent=$o),Bn=r(K),Pt=h(K,"P",{"data-svelte-h":!0}),k(Pt)!=="svelte-1hbaqlt"&&(Pt.innerHTML=jo),qn=r(K),Yt=h(K,"P",{"data-svelte-h":!0}),k(Yt)!=="svelte-6pahdo"&&(Yt.innerHTML=Jo),Rn=r(K),Ot=h(K,"P",{"data-svelte-h":!0}),k(Ot)!=="svelte-hswkmf"&&(Ot.innerHTML=Uo),Nn=r(K),_(gt.$$.fragment,K),Xn=r(K),De=h(K,"DIV",{class:!0});var at=V(De);_(zt.$$.fragment,at),En=r(at),Kt=h(at,"P",{"data-svelte-h":!0}),k(Kt)!=="svelte-ewr91v"&&(Kt.textContent=xo),Hn=r(at),_(_t.$$.fragment,at),at.forEach(l),Qn=r(K),Ie=h(K,"DIV",{class:!0});var Qe=V(Ie);_(Ft.$$.fragment,Qe),Sn=r(Qe),en=h(Qe,"P",{"data-svelte-h":!0}),k(en)!=="svelte-15a408f"&&(en.innerHTML=Co),An=r(Qe),_(Mt.$$.fragment,Qe),Ln=r(Qe),_(Tt.$$.fragment,Qe),Qe.forEach(l),Dn=r(K),Ze=h(K,"DIV",{class:!0});var Se=V(Ze);_(It.$$.fragment,Se),Pn=r(Se),tn=h(Se,"P",{"data-svelte-h":!0}),k(tn)!=="svelte-1wtkcqk"&&(tn.textContent=zo),Yn=r(Se),nn=h(Se,"P",{"data-svelte-h":!0}),k(nn)!=="svelte-16fuwd4"&&(nn.textContent=Fo),On=r(Se),_(bt.$$.fragment,Se),Se.forEach(l),K.forEach(l),kn=r(s),_(Zt.$$.fragment,s),vn=r(s),ie=h(s,"DIV",{class:!0});var ge=V(ie);_(Gt.$$.fragment,ge),Kn=r(ge),on=h(ge,"P",{"data-svelte-h":!0}),k(on)!=="svelte-176h55s"&&(on.textContent=Io),eo=r(ge),sn=h(ge,"P",{"data-svelte-h":!0}),k(sn)!=="svelte-1hbaqlt"&&(sn.innerHTML=Zo),to=r(ge),an=h(ge,"P",{"data-svelte-h":!0}),k(an)!=="svelte-6pahdo"&&(an.innerHTML=Go),no=r(ge),rn=h(ge,"P",{"data-svelte-h":!0}),k(rn)!=="svelte-hswkmf"&&(rn.innerHTML=Wo),oo=r(ge),Pe=h(ge,"DIV",{class:!0});var rt=V(Pe);_(Wt.$$.fragment,rt),so=r(rt),ln=h(rt,"P",{"data-svelte-h":!0}),k(ln)!=="svelte-1nt340b"&&(ln.innerHTML=Vo),ao=r(rt),_(yt.$$.fragment,rt),rt.forEach(l),ge.forEach(l),$n=r(s),_(Vt.$$.fragment,s),jn=r(s),de=h(s,"DIV",{class:!0});var _e=V(de);_(Bt.$$.fragment,_e),ro=r(_e),dn=h(_e,"P",{"data-svelte-h":!0}),k(dn)!=="svelte-16wnj"&&(dn.textContent=Bo),lo=r(_e),cn=h(_e,"P",{"data-svelte-h":!0}),k(cn)!=="svelte-1hbaqlt"&&(cn.innerHTML=qo),io=r(_e),pn=h(_e,"P",{"data-svelte-h":!0}),k(pn)!=="svelte-6pahdo"&&(pn.innerHTML=Ro),co=r(_e),mn=h(_e,"P",{"data-svelte-h":!0}),k(mn)!=="svelte-hswkmf"&&(mn.innerHTML=No),po=r(_e),Ye=h(_e,"DIV",{class:!0});var lt=V(Ye);_(qt.$$.fragment,lt),mo=r(lt),un=h(lt,"P",{"data-svelte-h":!0}),k(un)!=="svelte-19qs4gn"&&(un.innerHTML=Xo),uo=r(lt),_(wt.$$.fragment,lt),lt.forEach(l),_e.forEach(l),Jn=r(s),_(Rt.$$.fragment,s),Un=r(s),ce=h(s,"DIV",{class:!0});var Me=V(ce);_(Nt.$$.fragment,Me),ho=r(Me),hn=h(Me,"P",{"data-svelte-h":!0}),k(hn)!=="svelte-1v5r6h0"&&(hn.innerHTML=Eo),fo=r(Me),fn=h(Me,"P",{"data-svelte-h":!0}),k(fn)!=="svelte-1hbaqlt"&&(fn.innerHTML=Ho),go=r(Me),gn=h(Me,"P",{"data-svelte-h":!0}),k(gn)!=="svelte-6pahdo"&&(gn.innerHTML=Qo),_o=r(Me),_n=h(Me,"P",{"data-svelte-h":!0}),k(_n)!=="svelte-hswkmf"&&(_n.innerHTML=So),Mo=r(Me),Oe=h(Me,"DIV",{class:!0});var it=V(Oe);_(Xt.$$.fragment,it),To=r(it),Mn=h(it,"P",{"data-svelte-h":!0}),k(Mn)!=="svelte-kgrb83"&&(Mn.innerHTML=Ao),bo=r(it),_(kt.$$.fragment,it),it.forEach(l),Me.forEach(l),this.h()},h(){Z(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,v){M(t,s,v),m(s,f,v),m(s,n,v),M(o,n,null),i(n,c),i(n,e),i(n,Te),i(n,G),i(n,X),i(n,E),i(n,H),i(n,P),i(n,be),M(Q,n,null),i(n,S),i(n,N),M(C,N,null),i(N,pe),i(N,U),i(N,ye),M(B,N,null),i(n,re),i(n,L),M(I,L,null),i(L,Y),i(L,p),i(L,z),M(x,L,null),i(L,le),M(Ge,L,null),i(n,dt),i(n,te),M(xe,te,null),i(te,me),i(te,we),i(te,Ae),i(te,Ke),i(te,Le),M(We,te,null),m(s,et,v),M(ue,s,v),m(s,tt,v),m(s,F,v),M(he,F,null),i(F,ct),i(F,ke),i(F,pt),i(F,ve),i(F,Ve),i(F,$e),i(F,Be),i(F,nt),i(F,Ce),M(je,F,null),i(F,qe),i(F,fe),M(Je,fe,null),i(fe,mt),i(fe,d),i(fe,Ue),M(Re,fe,null),i(F,Qt),i(F,ze),M(Jt,ze,null),i(ze,Cn),i(ze,St),i(ze,zn),M(ut,ze,null),i(ze,Fn),M(ht,ze,null),i(F,In),i(F,Fe),M(Ut,Fe,null),i(Fe,Zn),i(Fe,At),i(Fe,Gn),i(Fe,Lt),i(Fe,Wn),M(ft,Fe,null),m(s,yn,v),M(xt,s,v),m(s,wn,v),m(s,D,v),M(Ct,D,null),i(D,Vn),i(D,Dt),i(D,Bn),i(D,Pt),i(D,qn),i(D,Yt),i(D,Rn),i(D,Ot),i(D,Nn),M(gt,D,null),i(D,Xn),i(D,De),M(zt,De,null),i(De,En),i(De,Kt),i(De,Hn),M(_t,De,null),i(D,Qn),i(D,Ie),M(Ft,Ie,null),i(Ie,Sn),i(Ie,en),i(Ie,An),M(Mt,Ie,null),i(Ie,Ln),M(Tt,Ie,null),i(D,Dn),i(D,Ze),M(It,Ze,null),i(Ze,Pn),i(Ze,tn),i(Ze,Yn),i(Ze,nn),i(Ze,On),M(bt,Ze,null),m(s,kn,v),M(Zt,s,v),m(s,vn,v),m(s,ie,v),M(Gt,ie,null),i(ie,Kn),i(ie,on),i(ie,eo),i(ie,sn),i(ie,to),i(ie,an),i(ie,no),i(ie,rn),i(ie,oo),i(ie,Pe),M(Wt,Pe,null),i(Pe,so),i(Pe,ln),i(Pe,ao),M(yt,Pe,null),m(s,$n,v),M(Vt,s,v),m(s,jn,v),m(s,de,v),M(Bt,de,null),i(de,ro),i(de,dn),i(de,lo),i(de,cn),i(de,io),i(de,pn),i(de,co),i(de,mn),i(de,po),i(de,Ye),M(qt,Ye,null),i(Ye,mo),i(Ye,un),i(Ye,uo),M(wt,Ye,null),m(s,Jn,v),M(Rt,s,v),m(s,Un,v),m(s,ce,v),M(Nt,ce,null),i(ce,ho),i(ce,hn),i(ce,fo),i(ce,fn),i(ce,go),i(ce,gn),i(ce,_o),i(ce,_n),i(ce,Mo),i(ce,Oe),M(Xt,Oe,null),i(Oe,To),i(Oe,Mn),i(Oe,bo),M(kt,Oe,null),xn=!0},p(s,v){const ot={};v&2&&(ot.$$scope={dirty:v,ctx:s}),Q.$set(ot);const Ne={};v&2&&(Ne.$$scope={dirty:v,ctx:s}),B.$set(Ne);const Xe={};v&2&&(Xe.$$scope={dirty:v,ctx:s}),x.$set(Xe);const O={};v&2&&(O.$$scope={dirty:v,ctx:s}),Ge.$set(O);const st={};v&2&&(st.$$scope={dirty:v,ctx:s}),We.$set(st);const Ee={};v&2&&(Ee.$$scope={dirty:v,ctx:s}),je.$set(Ee);const He={};v&2&&(He.$$scope={dirty:v,ctx:s}),Re.$set(He);const K={};v&2&&(K.$$scope={dirty:v,ctx:s}),ut.$set(K);const at={};v&2&&(at.$$scope={dirty:v,ctx:s}),ht.$set(at);const Qe={};v&2&&(Qe.$$scope={dirty:v,ctx:s}),ft.$set(Qe);const Se={};v&2&&(Se.$$scope={dirty:v,ctx:s}),gt.$set(Se);const ge={};v&2&&(ge.$$scope={dirty:v,ctx:s}),_t.$set(ge);const rt={};v&2&&(rt.$$scope={dirty:v,ctx:s}),Mt.$set(rt);const _e={};v&2&&(_e.$$scope={dirty:v,ctx:s}),Tt.$set(_e);const lt={};v&2&&(lt.$$scope={dirty:v,ctx:s}),bt.$set(lt);const Me={};v&2&&(Me.$$scope={dirty:v,ctx:s}),yt.$set(Me);const it={};v&2&&(it.$$scope={dirty:v,ctx:s}),wt.$set(it);const Lo={};v&2&&(Lo.$$scope={dirty:v,ctx:s}),kt.$set(Lo)},i(s){xn||(T(t.$$.fragment,s),T(o.$$.fragment,s),T(Q.$$.fragment,s),T(C.$$.fragment,s),T(B.$$.fragment,s),T(I.$$.fragment,s),T(x.$$.fragment,s),T(Ge.$$.fragment,s),T(xe.$$.fragment,s),T(We.$$.fragment,s),T(ue.$$.fragment,s),T(he.$$.fragment,s),T(je.$$.fragment,s),T(Je.$$.fragment,s),T(Re.$$.fragment,s),T(Jt.$$.fragment,s),T(ut.$$.fragment,s),T(ht.$$.fragment,s),T(Ut.$$.fragment,s),T(ft.$$.fragment,s),T(xt.$$.fragment,s),T(Ct.$$.fragment,s),T(gt.$$.fragment,s),T(zt.$$.fragment,s),T(_t.$$.fragment,s),T(Ft.$$.fragment,s),T(Mt.$$.fragment,s),T(Tt.$$.fragment,s),T(It.$$.fragment,s),T(bt.$$.fragment,s),T(Zt.$$.fragment,s),T(Gt.$$.fragment,s),T(Wt.$$.fragment,s),T(yt.$$.fragment,s),T(Vt.$$.fragment,s),T(Bt.$$.fragment,s),T(qt.$$.fragment,s),T(wt.$$.fragment,s),T(Rt.$$.fragment,s),T(Nt.$$.fragment,s),T(Xt.$$.fragment,s),T(kt.$$.fragment,s),xn=!0)},o(s){b(t.$$.fragment,s),b(o.$$.fragment,s),b(Q.$$.fragment,s),b(C.$$.fragment,s),b(B.$$.fragment,s),b(I.$$.fragment,s),b(x.$$.fragment,s),b(Ge.$$.fragment,s),b(xe.$$.fragment,s),b(We.$$.fragment,s),b(ue.$$.fragment,s),b(he.$$.fragment,s),b(je.$$.fragment,s),b(Je.$$.fragment,s),b(Re.$$.fragment,s),b(Jt.$$.fragment,s),b(ut.$$.fragment,s),b(ht.$$.fragment,s),b(Ut.$$.fragment,s),b(ft.$$.fragment,s),b(xt.$$.fragment,s),b(Ct.$$.fragment,s),b(gt.$$.fragment,s),b(zt.$$.fragment,s),b(_t.$$.fragment,s),b(Ft.$$.fragment,s),b(Mt.$$.fragment,s),b(Tt.$$.fragment,s),b(It.$$.fragment,s),b(bt.$$.fragment,s),b(Zt.$$.fragment,s),b(Gt.$$.fragment,s),b(Wt.$$.fragment,s),b(yt.$$.fragment,s),b(Vt.$$.fragment,s),b(Bt.$$.fragment,s),b(qt.$$.fragment,s),b(wt.$$.fragment,s),b(Rt.$$.fragment,s),b(Nt.$$.fragment,s),b(Xt.$$.fragment,s),b(kt.$$.fragment,s),xn=!1},d(s){s&&(l(f),l(n),l(et),l(tt),l(F),l(yn),l(wn),l(D),l(kn),l(vn),l(ie),l($n),l(jn),l(de),l(Jn),l(Un),l(ce)),y(t,s),y(o),y(Q),y(C),y(B),y(I),y(x),y(Ge),y(xe),y(We),y(ue,s),y(he),y(je),y(Je),y(Re),y(Jt),y(ut),y(ht),y(Ut),y(ft),y(xt,s),y(Ct),y(gt),y(zt),y(_t),y(Ft),y(Mt),y(Tt),y(It),y(bt),y(Zt,s),y(Gt),y(Wt),y(yt),y(Vt,s),y(Bt),y(qt),y(wt),y(Rt,s),y(Nt),y(Xt),y(kt)}}}function ys($){let t,f;return t=new yo({props:{$$slots:{default:[bs]},$$scope:{ctx:$}}}),{c(){g(t.$$.fragment)},l(n){_(t.$$.fragment,n)},m(n,o){M(t,n,o),f=!0},p(n,o){const c={};o&2&&(c.$$scope={dirty:o,ctx:n}),t.$set(c)},i(n){f||(T(t.$$.fragment,n),f=!0)},o(n){b(t.$$.fragment,n),f=!1},d(n){y(t,n)}}}function ws($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGTVQ1TW9kZWwlMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBURk1UNU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQWFydGljbGUlMjAlM0QlMjAlMjJVTiUyME9mZml6aWVyJTIwc2FndCUyQyUyMGRhc3MlMjB3ZWl0ZXIlMjB2ZXJoYW5kZWx0JTIwd2VyZGVuJTIwbXVzcyUyMGluJTIwU3lyaWVuLiUyMiUwQXN1bW1hcnklMjAlM0QlMjAlMjJXZWl0ZXIlMjBWZXJoYW5kbHVuZyUyMGluJTIwU3lyaWVuLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihhcnRpY2xlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEFsYWJlbHMlMjAlM0QlMjB0b2tlbml6ZXIodGV4dF90YXJnZXQlM0RzdW1tYXJ5JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZGVjb2Rlcl9pbnB1dF9pZHMlM0RsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFMT5Model, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], decoder_input_ids=labels[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function ks($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGTVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwVEZNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBYXJ0aWNsZSUyMCUzRCUyMCUyMlVOJTIwT2ZmaXppZXIlMjBzYWd0JTJDJTIwZGFzcyUyMHdlaXRlciUyMHZlcmhhbmRlbHQlMjB3ZXJkZW4lMjBtdXNzJTIwaW4lMjBTeXJpZW4uJTIyJTBBc3VtbWFyeSUyMCUzRCUyMCUyMldlaXRlciUyMFZlcmhhbmRsdW5nJTIwaW4lMjBTeXJpZW4uJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjB0ZXh0X3RhcmdldCUzRHN1bW1hcnklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFMT5ForConditionalGeneration, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, text_target=summary, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function vs($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGTVQ1RW5jb2Rlck1vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwVEZNVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBYXJ0aWNsZSUyMCUzRCUyMCUyMlVOJTIwT2ZmaXppZXIlMjBzYWd0JTJDJTIwZGFzcyUyMHdlaXRlciUyMHZlcmhhbmRlbHQlMjB3ZXJkZW4lMjBtdXNzJTIwaW4lMjBTeXJpZW4uJTIyJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5pbnB1dF9pZHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKSUwQWhpZGRlbl9zdGF0ZSUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFMT5EncoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFMT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(article, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function $s($){let t,f,n,o,c,e,w=`This class overrides <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a>. Please check the superclass for the appropriate documentation alongside usage
examples.`,Te,G,ee,X,E,W,H,P,ne,be=`This class overrides <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5ForConditionalGeneration">TFT5ForConditionalGeneration</a>. Please check the superclass for the appropriate
documentation alongside usage examples.`,Q,S,N,C,pe,U,R,ye,B,re=`This class overrides <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5EncoderModel">TFT5EncoderModel</a>. Please check the superclass for the appropriate documentation alongside
usage examples.`,L,I,Y;return t=new se({props:{title:"TFMT5Model",local:"transformers.TFMT5Model",headingTag:"h2"}}),o=new q({props:{name:"class transformers.TFMT5Model",anchor:"transformers.TFMT5Model",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_tf_mt5.py#L27"}}),G=new oe({props:{anchor:"transformers.TFMT5Model.example",$$slots:{default:[ws]},$$scope:{ctx:$}}}),X=new se({props:{title:"TFMT5ForConditionalGeneration",local:"transformers.TFMT5ForConditionalGeneration",headingTag:"h2"}}),H=new q({props:{name:"class transformers.TFMT5ForConditionalGeneration",anchor:"transformers.TFMT5ForConditionalGeneration",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_tf_mt5.py#L52"}}),S=new oe({props:{anchor:"transformers.TFMT5ForConditionalGeneration.example",$$slots:{default:[ks]},$$scope:{ctx:$}}}),C=new se({props:{title:"TFMT5EncoderModel",local:"transformers.TFMT5EncoderModel",headingTag:"h2"}}),R=new q({props:{name:"class transformers.TFMT5EncoderModel",anchor:"transformers.TFMT5EncoderModel",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_tf_mt5.py#L76"}}),I=new oe({props:{anchor:"transformers.TFMT5EncoderModel.example",$$slots:{default:[vs]},$$scope:{ctx:$}}}),{c(){g(t.$$.fragment),f=a(),n=u("div"),g(o.$$.fragment),c=a(),e=u("p"),e.innerHTML=w,Te=a(),g(G.$$.fragment),ee=a(),g(X.$$.fragment),E=a(),W=u("div"),g(H.$$.fragment),P=a(),ne=u("p"),ne.innerHTML=be,Q=a(),g(S.$$.fragment),N=a(),g(C.$$.fragment),pe=a(),U=u("div"),g(R.$$.fragment),ye=a(),B=u("p"),B.innerHTML=re,L=a(),g(I.$$.fragment),this.h()},l(p){_(t.$$.fragment,p),f=r(p),n=h(p,"DIV",{class:!0});var j=V(n);_(o.$$.fragment,j),c=r(j),e=h(j,"P",{"data-svelte-h":!0}),k(e)!=="svelte-101uvgs"&&(e.innerHTML=w),Te=r(j),_(G.$$.fragment,j),j.forEach(l),ee=r(p),_(X.$$.fragment,p),E=r(p),W=h(p,"DIV",{class:!0});var z=V(W);_(H.$$.fragment,z),P=r(z),ne=h(z,"P",{"data-svelte-h":!0}),k(ne)!=="svelte-19n28ds"&&(ne.innerHTML=be),Q=r(z),_(S.$$.fragment,z),z.forEach(l),N=r(p),_(C.$$.fragment,p),pe=r(p),U=h(p,"DIV",{class:!0});var x=V(U);_(R.$$.fragment,x),ye=r(x),B=h(x,"P",{"data-svelte-h":!0}),k(B)!=="svelte-14or754"&&(B.innerHTML=re),L=r(x),_(I.$$.fragment,x),x.forEach(l),this.h()},h(){Z(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(p,j){M(t,p,j),m(p,f,j),m(p,n,j),M(o,n,null),i(n,c),i(n,e),i(n,Te),M(G,n,null),m(p,ee,j),M(X,p,j),m(p,E,j),m(p,W,j),M(H,W,null),i(W,P),i(W,ne),i(W,Q),M(S,W,null),m(p,N,j),M(C,p,j),m(p,pe,j),m(p,U,j),M(R,U,null),i(U,ye),i(U,B),i(U,L),M(I,U,null),Y=!0},p(p,j){const z={};j&2&&(z.$$scope={dirty:j,ctx:p}),G.$set(z);const x={};j&2&&(x.$$scope={dirty:j,ctx:p}),S.$set(x);const le={};j&2&&(le.$$scope={dirty:j,ctx:p}),I.$set(le)},i(p){Y||(T(t.$$.fragment,p),T(o.$$.fragment,p),T(G.$$.fragment,p),T(X.$$.fragment,p),T(H.$$.fragment,p),T(S.$$.fragment,p),T(C.$$.fragment,p),T(R.$$.fragment,p),T(I.$$.fragment,p),Y=!0)},o(p){b(t.$$.fragment,p),b(o.$$.fragment,p),b(G.$$.fragment,p),b(X.$$.fragment,p),b(H.$$.fragment,p),b(S.$$.fragment,p),b(C.$$.fragment,p),b(R.$$.fragment,p),b(I.$$.fragment,p),Y=!1},d(p){p&&(l(f),l(n),l(ee),l(E),l(W),l(N),l(pe),l(U)),y(t,p),y(o),y(G),y(X,p),y(H),y(S),y(C,p),y(R),y(I)}}}function js($){let t,f;return t=new yo({props:{$$slots:{default:[$s]},$$scope:{ctx:$}}}),{c(){g(t.$$.fragment)},l(n){_(t.$$.fragment,n)},m(n,o){M(t,n,o),f=!0},p(n,o){const c={};o&2&&(c.$$scope={dirty:o,ctx:n}),t.$set(c)},i(n){f||(T(t.$$.fragment,n),f=!0)},o(n){b(t.$$.fragment,n),f=!1},d(n){y(t,n)}}}function Js($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhNVDVNb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEZsYXhNVDVNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEElMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFzdW1tYXJ5JTIwJTNEJTIwJTIyV2VpdGVyJTIwVmVyaGFuZGx1bmclMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIodGV4dF90YXJnZXQlM0RzdW1tYXJ5JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMikuaW5wdXRfaWRzJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGRlY29kZXJfaW5wdXRfaWRzJTNEZGVjb2Rlcl9pbnB1dF9pZHMpJTBBaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxMT5Model, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxMT5Model.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function Us($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhNVDVGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBGbGF4TVQ1Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZtdDUtc21hbGwlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjJVTiUyME9mZml6aWVyJTIwc2FndCUyQyUyMGRhc3MlMjB3ZWl0ZXIlMjB2ZXJoYW5kZWx0JTIwd2VyZGVuJTIwbXVzcyUyMGluJTIwU3lyaWVuLiUyMiUwQXN1bW1hcnklMjAlM0QlMjAlMjJXZWl0ZXIlMjBWZXJoYW5kbHVuZyUyMGluJTIwU3lyaWVuLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihhcnRpY2xlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFkZWNvZGVyX2lucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcih0ZXh0X3RhcmdldCUzRHN1bW1hcnklMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKS5pbnB1dF9pZHMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxMT5ForConditionalGeneration, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxMT5ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, decoder_input_ids=decoder_input_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function xs($){let t,f="Examples:",n,o,c;return o=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZsYXhUNUVuY29kZXJNb2RlbCUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEZsYXhUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGbXQ1LXNtYWxsJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm10NS1zbWFsbCUyMiklMEElMEFhcnRpY2xlJTIwJTNEJTIwJTIyVU4lMjBPZmZpemllciUyMHNhZ3QlMkMlMjBkYXNzJTIwd2VpdGVyJTIwdmVyaGFuZGVsdCUyMHdlcmRlbiUyMG11c3MlMjBpbiUyMFN5cmllbi4lMjIlMEFzdW1tYXJ5JTIwJTNEJTIwJTIyV2VpdGVyJTIwVmVyaGFuZGx1bmclMjBpbiUyMFN5cmllbi4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoYXJ0aWNsZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBZGVjb2Rlcl9pbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIodGV4dF90YXJnZXQlM0RzdW1tYXJ5JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMikuaW5wdXRfaWRzJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEFoaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FlaxT5EncoderModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxT5EncoderModel.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/mt5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Offizier sagt, dass weiter verhandelt werden muss in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary = <span class="hljs-string">&quot;Weiter Verhandlung in Syrien.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = tokenizer(text_target=summary, return_tensors=<span class="hljs-string">&quot;np&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=u("p"),t.textContent=f,n=a(),g(o.$$.fragment)},l(e){t=h(e,"P",{"data-svelte-h":!0}),k(t)!=="svelte-kvfsh7"&&(t.textContent=f),n=r(e),_(o.$$.fragment,e)},m(e,w){m(e,t,w),m(e,n,w),M(o,e,w),c=!0},p:A,i(e){c||(T(o.$$.fragment,e),c=!0)},o(e){b(o.$$.fragment,e),c=!1},d(e){e&&(l(t),l(n)),y(o,e)}}}function Cs($){let t,f,n,o,c,e,w=`This class overrides <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5Model">FlaxT5Model</a>. Please check the superclass for the appropriate documentation alongside usage
examples.`,Te,G,ee,X,E,W,H,P,ne,be=`This class overrides <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5ForConditionalGeneration">FlaxT5ForConditionalGeneration</a>. Please check the superclass for the appropriate
documentation alongside usage examples.`,Q,S,N,C,pe,U,R,ye,B,re=`This class overrides <a href="/docs/transformers/main/en/model_doc/t5#transformers.FlaxT5EncoderModel">FlaxT5EncoderModel</a>. Please check the superclass for the appropriate documentation
alongside usage examples.`,L,I,Y;return t=new se({props:{title:"FlaxMT5Model",local:"transformers.FlaxMT5Model",headingTag:"h2"}}),o=new q({props:{name:"class transformers.FlaxMT5Model",anchor:"transformers.FlaxMT5Model",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_flax_mt5.py#L42"}}),G=new oe({props:{anchor:"transformers.FlaxMT5Model.example",$$slots:{default:[Js]},$$scope:{ctx:$}}}),X=new se({props:{title:"FlaxMT5ForConditionalGeneration",local:"transformers.FlaxMT5ForConditionalGeneration",headingTag:"h2"}}),H=new q({props:{name:"class transformers.FlaxMT5ForConditionalGeneration",anchor:"transformers.FlaxMT5ForConditionalGeneration",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_flax_mt5.py#L96"}}),S=new oe({props:{anchor:"transformers.FlaxMT5ForConditionalGeneration.example",$$slots:{default:[Us]},$$scope:{ctx:$}}}),C=new se({props:{title:"FlaxMT5EncoderModel",local:"transformers.FlaxMT5EncoderModel",headingTag:"h2"}}),R=new q({props:{name:"class transformers.FlaxMT5EncoderModel",anchor:"transformers.FlaxMT5EncoderModel",parameters:[{name:"config",val:": T5Config"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"gradient_checkpointing",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/modeling_flax_mt5.py#L69"}}),I=new oe({props:{anchor:"transformers.FlaxMT5EncoderModel.example",$$slots:{default:[xs]},$$scope:{ctx:$}}}),{c(){g(t.$$.fragment),f=a(),n=u("div"),g(o.$$.fragment),c=a(),e=u("p"),e.innerHTML=w,Te=a(),g(G.$$.fragment),ee=a(),g(X.$$.fragment),E=a(),W=u("div"),g(H.$$.fragment),P=a(),ne=u("p"),ne.innerHTML=be,Q=a(),g(S.$$.fragment),N=a(),g(C.$$.fragment),pe=a(),U=u("div"),g(R.$$.fragment),ye=a(),B=u("p"),B.innerHTML=re,L=a(),g(I.$$.fragment),this.h()},l(p){_(t.$$.fragment,p),f=r(p),n=h(p,"DIV",{class:!0});var j=V(n);_(o.$$.fragment,j),c=r(j),e=h(j,"P",{"data-svelte-h":!0}),k(e)!=="svelte-qhhjac"&&(e.innerHTML=w),Te=r(j),_(G.$$.fragment,j),j.forEach(l),ee=r(p),_(X.$$.fragment,p),E=r(p),W=h(p,"DIV",{class:!0});var z=V(W);_(H.$$.fragment,z),P=r(z),ne=h(z,"P",{"data-svelte-h":!0}),k(ne)!=="svelte-hq6xku"&&(ne.innerHTML=be),Q=r(z),_(S.$$.fragment,z),z.forEach(l),N=r(p),_(C.$$.fragment,p),pe=r(p),U=h(p,"DIV",{class:!0});var x=V(U);_(R.$$.fragment,x),ye=r(x),B=h(x,"P",{"data-svelte-h":!0}),k(B)!=="svelte-16rg8iq"&&(B.innerHTML=re),L=r(x),_(I.$$.fragment,x),x.forEach(l),this.h()},h(){Z(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(p,j){M(t,p,j),m(p,f,j),m(p,n,j),M(o,n,null),i(n,c),i(n,e),i(n,Te),M(G,n,null),m(p,ee,j),M(X,p,j),m(p,E,j),m(p,W,j),M(H,W,null),i(W,P),i(W,ne),i(W,Q),M(S,W,null),m(p,N,j),M(C,p,j),m(p,pe,j),m(p,U,j),M(R,U,null),i(U,ye),i(U,B),i(U,L),M(I,U,null),Y=!0},p(p,j){const z={};j&2&&(z.$$scope={dirty:j,ctx:p}),G.$set(z);const x={};j&2&&(x.$$scope={dirty:j,ctx:p}),S.$set(x);const le={};j&2&&(le.$$scope={dirty:j,ctx:p}),I.$set(le)},i(p){Y||(T(t.$$.fragment,p),T(o.$$.fragment,p),T(G.$$.fragment,p),T(X.$$.fragment,p),T(H.$$.fragment,p),T(S.$$.fragment,p),T(C.$$.fragment,p),T(R.$$.fragment,p),T(I.$$.fragment,p),Y=!0)},o(p){b(t.$$.fragment,p),b(o.$$.fragment,p),b(G.$$.fragment,p),b(X.$$.fragment,p),b(H.$$.fragment,p),b(S.$$.fragment,p),b(C.$$.fragment,p),b(R.$$.fragment,p),b(I.$$.fragment,p),Y=!1},d(p){p&&(l(f),l(n),l(ee),l(E),l(W),l(N),l(pe),l(U)),y(t,p),y(o),y(G),y(X,p),y(H),y(S),y(C,p),y(R),y(I)}}}function zs($){let t,f;return t=new yo({props:{$$slots:{default:[Cs]},$$scope:{ctx:$}}}),{c(){g(t.$$.fragment)},l(n){_(t.$$.fragment,n)},m(n,o){M(t,n,o),f=!0},p(n,o){const c={};o&2&&(c.$$scope={dirty:o,ctx:n}),t.$set(c)},i(n){f||(T(t.$$.fragment,n),f=!0)},o(n){b(t.$$.fragment,n),f=!1},d(n){y(t,n)}}}function Fs($){let t,f,n,o,c,e,w,Te='<a href="https://huggingface.co/models?filter=mt5"><img alt="Models" src="https://img.shields.io/badge/All_model_pages-mt5-blueviolet"/></a> <a href="https://huggingface.co/spaces/docs-demos/mt5-small-finetuned-arxiv-cs-finetuned-arxiv-cs-full"><img alt="Spaces" src="https://img.shields.io/badge/%F0%9F%A4%97%20Hugging%20Face-Spaces-blue"/></a>',G,ee,X,E,W=`The mT5 model was presented in <a href="https://arxiv.org/abs/2010.11934" rel="nofollow">mT5: A massively multilingual pre-trained text-to-text transformer</a> by Linting Xue, Noah Constant, Adam Roberts, Mihir Kale, Rami Al-Rfou, Aditya
Siddhant, Aditya Barua, Colin Raffel.`,H,P,ne="The abstract from the paper is the following:",be,Q,S=`<em>The recent “Text-to-Text Transfer Transformer” (T5) leveraged a unified text-to-text format and scale to attain
state-of-the-art results on a wide variety of English-language NLP tasks. In this paper, we introduce mT5, a
multilingual variant of T5 that was pre-trained on a new Common Crawl-based dataset covering 101 languages. We detail
the design and modified training of mT5 and demonstrate its state-of-the-art performance on many multilingual
benchmarks. We also describe a simple technique to prevent “accidental translation” in the zero-shot setting, where a
generative model chooses to (partially) translate its prediction into the wrong language. All of the code and model
checkpoints used in this work are publicly available.</em>`,N,C,pe=`Note: mT5 was only pre-trained on <a href="https://huggingface.co/datasets/mc4" rel="nofollow">mC4</a> excluding any supervised training.
Therefore, this model has to be fine-tuned before it is usable on a downstream task, unlike the original T5 model.
Since mT5 was pre-trained unsupervisedly, there’s no real advantage to using a task prefix during single-task
fine-tuning. If you are doing multi-task fine-tuning, you should use a prefix.`,U,R,ye="Google has released the following variants:",B,re,L='<li><p><a href="https://huggingface.co/google/mt5-small" rel="nofollow">google/mt5-small</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-base" rel="nofollow">google/mt5-base</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-large" rel="nofollow">google/mt5-large</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-xl" rel="nofollow">google/mt5-xl</a></p></li> <li><p><a href="https://huggingface.co/google/mt5-xxl" rel="nofollow">google/mt5-xxl</a>.</p></li>',I,Y,p=`This model was contributed by <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">patrickvonplaten</a>. The original code can be
found <a href="https://github.com/google-research/multilingual-t5" rel="nofollow">here</a>.`,j,z,x,le,Ge='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',dt,te,xe,me,we,Et,Ae,Ke=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mt5#transformers.MT5Model">MT5Model</a> or a <a href="/docs/transformers/main/en/model_doc/mt5#transformers.TFMT5Model">TFMT5Model</a>. It is used to
instantiate a mT5 model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the mT5
<a href="https://huggingface.co/google/mt5-small" rel="nofollow">google/mt5-small</a> architecture.`,Ht,Le,We=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,et,ue,tt,F,he,ct,ke,bn='See <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a> for all details.',pt,ve,vt,Ve,$e,$t,Be,nt='See <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5TokenizerFast">T5TokenizerFast</a> for all details.',jt,Ce,je,qe,fe,Je,mt;return c=new se({props:{title:"mT5",local:"mt5",headingTag:"h1"}}),ee=new se({props:{title:"Overview",local:"overview",headingTag:"h2"}}),z=new se({props:{title:"Resources",local:"resources",headingTag:"h2"}}),te=new se({props:{title:"MT5Config",local:"transformers.MT5Config",headingTag:"h2"}}),we=new q({props:{name:"class transformers.MT5Config",anchor:"transformers.MT5Config",parameters:[{name:"vocab_size",val:" = 250112"},{name:"d_model",val:" = 512"},{name:"d_kv",val:" = 64"},{name:"d_ff",val:" = 1024"},{name:"num_layers",val:" = 8"},{name:"num_decoder_layers",val:" = None"},{name:"num_heads",val:" = 6"},{name:"relative_attention_num_buckets",val:" = 32"},{name:"relative_attention_max_distance",val:" = 128"},{name:"dropout_rate",val:" = 0.1"},{name:"layer_norm_epsilon",val:" = 1e-06"},{name:"initializer_factor",val:" = 1.0"},{name:"feed_forward_proj",val:" = 'gated-gelu'"},{name:"is_encoder_decoder",val:" = True"},{name:"use_cache",val:" = True"},{name:"tokenizer_class",val:" = 'T5Tokenizer'"},{name:"tie_word_embeddings",val:" = False"},{name:"pad_token_id",val:" = 0"},{name:"eos_token_id",val:" = 1"},{name:"decoder_start_token_id",val:" = 0"},{name:"classifier_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MT5Config.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250112) &#x2014;
Vocabulary size of the T5 model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Model">T5Model</a> or <a href="/docs/transformers/main/en/model_doc/t5#transformers.TFT5Model">TFT5Model</a>.`,name:"vocab_size"},{anchor:"transformers.MT5Config.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Size of the encoder layers and the pooler layer.`,name:"d_model"},{anchor:"transformers.MT5Config.d_kv",description:`<strong>d_kv</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the key, query, value projections per attention head. In the conventional context, it is typically expected that <code>d_kv</code> has to be equal to <code>d_model // num_heads</code>.
But in the architecture of mt5-small, <code>d_kv</code> is not equal to <code>d_model //num_heads</code>. The <code>inner_dim</code> of the projection layer will be defined as <code>num_heads * d_kv</code>.`,name:"d_kv"},{anchor:"transformers.MT5Config.d_ff",description:`<strong>d_ff</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the intermediate feed forward layer in each <code>T5Block</code>.`,name:"d_ff"},{anchor:"transformers.MT5Config.num_layers",description:`<strong>num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_layers"},{anchor:"transformers.MT5Config.num_decoder_layers",description:`<strong>num_decoder_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of hidden layers in the Transformer decoder. Will use the same value as <code>num_layers</code> if not set.`,name:"num_decoder_layers"},{anchor:"transformers.MT5Config.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.MT5Config.relative_attention_num_buckets",description:`<strong>relative_attention_num_buckets</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The number of buckets to use for each attention layer.`,name:"relative_attention_num_buckets"},{anchor:"transformers.MT5Config.relative_attention_max_distance",description:`<strong>relative_attention_max_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The maximum distance of the longer sequences for the bucket separation.`,name:"relative_attention_max_distance"},{anchor:"transformers.MT5Config.dropout_rate",description:`<strong>dropout_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The ratio for all dropout layers.`,name:"dropout_rate"},{anchor:"transformers.MT5Config.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for classifier.`,name:"classifier_dropout"},{anchor:"transformers.MT5Config.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.MT5Config.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.MT5Config.feed_forward_proj",description:`<strong>feed_forward_proj</strong> (<code>string</code>, <em>optional</em>, defaults to <code>&quot;gated-gelu&quot;</code>) &#x2014;
Type of feed forward layer to be used. Should be one of <code>&quot;relu&quot;</code> or <code>&quot;gated-gelu&quot;</code>.`,name:"feed_forward_proj"},{anchor:"transformers.MT5Config.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/configuration_mt5.py#L27"}}),ue=new se({props:{title:"MT5Tokenizer",local:"transformers.MT5Tokenizer",headingTag:"h2"}}),he=new q({props:{name:"class transformers.MT5Tokenizer",anchor:"transformers.MT5Tokenizer",parameters:[{name:"vocab_file",val:""},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"extra_ids",val:" = 100"},{name:"additional_special_tokens",val:" = None"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"legacy",val:" = None"},{name:"add_prefix_space",val:" = True"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/tokenization_mt5.py#L20"}}),ve=new se({props:{title:"MT5TokenizerFast",local:"transformers.MT5TokenizerFast",headingTag:"h2"}}),$e=new q({props:{name:"class transformers.MT5TokenizerFast",anchor:"transformers.MT5TokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"eos_token",val:" = '</s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"extra_ids",val:" = 100"},{name:"additional_special_tokens",val:" = None"},{name:"add_prefix_space",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mt5/tokenization_mt5_fast.py#L20"}}),Ce=new es({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[zs],tensorflow:[js],pytorch:[ys]},$$scope:{ctx:$}}}),qe=new ts({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mt5.md"}}),{c(){t=u("meta"),f=a(),n=u("p"),o=a(),g(c.$$.fragment),e=a(),w=u("div"),w.innerHTML=Te,G=a(),g(ee.$$.fragment),X=a(),E=u("p"),E.innerHTML=W,H=a(),P=u("p"),P.textContent=ne,be=a(),Q=u("p"),Q.innerHTML=S,N=a(),C=u("p"),C.innerHTML=pe,U=a(),R=u("p"),R.textContent=ye,B=a(),re=u("ul"),re.innerHTML=L,I=a(),Y=u("p"),Y.innerHTML=p,j=a(),g(z.$$.fragment),x=a(),le=u("ul"),le.innerHTML=Ge,dt=a(),g(te.$$.fragment),xe=a(),me=u("div"),g(we.$$.fragment),Et=a(),Ae=u("p"),Ae.innerHTML=Ke,Ht=a(),Le=u("p"),Le.innerHTML=We,et=a(),g(ue.$$.fragment),tt=a(),F=u("div"),g(he.$$.fragment),ct=a(),ke=u("p"),ke.innerHTML=bn,pt=a(),g(ve.$$.fragment),vt=a(),Ve=u("div"),g($e.$$.fragment),$t=a(),Be=u("p"),Be.innerHTML=nt,jt=a(),g(Ce.$$.fragment),je=a(),g(qe.$$.fragment),fe=a(),Je=u("p"),this.h()},l(d){const J=Ko("svelte-u9bgzb",document.head);t=h(J,"META",{name:!0,content:!0}),J.forEach(l),f=r(d),n=h(d,"P",{}),V(n).forEach(l),o=r(d),_(c.$$.fragment,d),e=r(d),w=h(d,"DIV",{class:!0,"data-svelte-h":!0}),k(w)!=="svelte-1ts56sn"&&(w.innerHTML=Te),G=r(d),_(ee.$$.fragment,d),X=r(d),E=h(d,"P",{"data-svelte-h":!0}),k(E)!=="svelte-1roqcuv"&&(E.innerHTML=W),H=r(d),P=h(d,"P",{"data-svelte-h":!0}),k(P)!=="svelte-vfdo9a"&&(P.textContent=ne),be=r(d),Q=h(d,"P",{"data-svelte-h":!0}),k(Q)!=="svelte-zubcnw"&&(Q.innerHTML=S),N=r(d),C=h(d,"P",{"data-svelte-h":!0}),k(C)!=="svelte-k2hj4w"&&(C.innerHTML=pe),U=r(d),R=h(d,"P",{"data-svelte-h":!0}),k(R)!=="svelte-1p0jqca"&&(R.textContent=ye),B=r(d),re=h(d,"UL",{"data-svelte-h":!0}),k(re)!=="svelte-1w0nbyl"&&(re.innerHTML=L),I=r(d),Y=h(d,"P",{"data-svelte-h":!0}),k(Y)!=="svelte-1lbi4r5"&&(Y.innerHTML=p),j=r(d),_(z.$$.fragment,d),x=r(d),le=h(d,"UL",{"data-svelte-h":!0}),k(le)!=="svelte-6ej6p2"&&(le.innerHTML=Ge),dt=r(d),_(te.$$.fragment,d),xe=r(d),me=h(d,"DIV",{class:!0});var Ue=V(me);_(we.$$.fragment,Ue),Et=r(Ue),Ae=h(Ue,"P",{"data-svelte-h":!0}),k(Ae)!=="svelte-vssys"&&(Ae.innerHTML=Ke),Ht=r(Ue),Le=h(Ue,"P",{"data-svelte-h":!0}),k(Le)!=="svelte-o55m63"&&(Le.innerHTML=We),Ue.forEach(l),et=r(d),_(ue.$$.fragment,d),tt=r(d),F=h(d,"DIV",{class:!0});var Re=V(F);_(he.$$.fragment,Re),Re.forEach(l),ct=r(d),ke=h(d,"P",{"data-svelte-h":!0}),k(ke)!=="svelte-mxqym1"&&(ke.innerHTML=bn),pt=r(d),_(ve.$$.fragment,d),vt=r(d),Ve=h(d,"DIV",{class:!0});var Qt=V(Ve);_($e.$$.fragment,Qt),Qt.forEach(l),$t=r(d),Be=h(d,"P",{"data-svelte-h":!0}),k(Be)!=="svelte-6ixpf9"&&(Be.innerHTML=nt),jt=r(d),_(Ce.$$.fragment,d),je=r(d),_(qe.$$.fragment,d),fe=r(d),Je=h(d,"P",{}),V(Je).forEach(l),this.h()},h(){Z(t,"name","hf:doc:metadata"),Z(t,"content",Is),Z(w,"class","flex flex-wrap space-x-1"),Z(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(d,J){i(document.head,t),m(d,f,J),m(d,n,J),m(d,o,J),M(c,d,J),m(d,e,J),m(d,w,J),m(d,G,J),M(ee,d,J),m(d,X,J),m(d,E,J),m(d,H,J),m(d,P,J),m(d,be,J),m(d,Q,J),m(d,N,J),m(d,C,J),m(d,U,J),m(d,R,J),m(d,B,J),m(d,re,J),m(d,I,J),m(d,Y,J),m(d,j,J),M(z,d,J),m(d,x,J),m(d,le,J),m(d,dt,J),M(te,d,J),m(d,xe,J),m(d,me,J),M(we,me,null),i(me,Et),i(me,Ae),i(me,Ht),i(me,Le),m(d,et,J),M(ue,d,J),m(d,tt,J),m(d,F,J),M(he,F,null),m(d,ct,J),m(d,ke,J),m(d,pt,J),M(ve,d,J),m(d,vt,J),m(d,Ve,J),M($e,Ve,null),m(d,$t,J),m(d,Be,J),m(d,jt,J),M(Ce,d,J),m(d,je,J),M(qe,d,J),m(d,fe,J),m(d,Je,J),mt=!0},p(d,[J]){const Ue={};J&2&&(Ue.$$scope={dirty:J,ctx:d}),Ce.$set(Ue)},i(d){mt||(T(c.$$.fragment,d),T(ee.$$.fragment,d),T(z.$$.fragment,d),T(te.$$.fragment,d),T(we.$$.fragment,d),T(ue.$$.fragment,d),T(he.$$.fragment,d),T(ve.$$.fragment,d),T($e.$$.fragment,d),T(Ce.$$.fragment,d),T(qe.$$.fragment,d),mt=!0)},o(d){b(c.$$.fragment,d),b(ee.$$.fragment,d),b(z.$$.fragment,d),b(te.$$.fragment,d),b(we.$$.fragment,d),b(ue.$$.fragment,d),b(he.$$.fragment,d),b(ve.$$.fragment,d),b($e.$$.fragment,d),b(Ce.$$.fragment,d),b(qe.$$.fragment,d),mt=!1},d(d){d&&(l(f),l(n),l(o),l(e),l(w),l(G),l(X),l(E),l(H),l(P),l(be),l(Q),l(N),l(C),l(U),l(R),l(B),l(re),l(I),l(Y),l(j),l(x),l(le),l(dt),l(xe),l(me),l(et),l(tt),l(F),l(ct),l(ke),l(pt),l(vt),l(Ve),l($t),l(Be),l(jt),l(je),l(fe),l(Je)),l(t),y(c,d),y(ee,d),y(z,d),y(te,d),y(we),y(ue,d),y(he),y(ve,d),y($e),y(Ce,d),y(qe,d)}}}const Is='{"title":"mT5","local":"mt5","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MT5Config","local":"transformers.MT5Config","sections":[],"depth":2},{"title":"MT5Tokenizer","local":"transformers.MT5Tokenizer","sections":[],"depth":2},{"title":"MT5TokenizerFast","local":"transformers.MT5TokenizerFast","sections":[],"depth":2},{"title":"MT5Model","local":"transformers.MT5Model","sections":[],"depth":2},{"title":"MT5ForConditionalGeneration","local":"transformers.MT5ForConditionalGeneration","sections":[],"depth":2},{"title":"MT5EncoderModel","local":"transformers.MT5EncoderModel","sections":[],"depth":2},{"title":"MT5ForSequenceClassification","local":"transformers.MT5ForSequenceClassification","sections":[],"depth":2},{"title":"MT5ForTokenClassification","local":"transformers.MT5ForTokenClassification","sections":[],"depth":2},{"title":"MT5ForQuestionAnswering","local":"transformers.MT5ForQuestionAnswering","sections":[],"depth":2},{"title":"TFMT5Model","local":"transformers.TFMT5Model","sections":[],"depth":2},{"title":"TFMT5ForConditionalGeneration","local":"transformers.TFMT5ForConditionalGeneration","sections":[],"depth":2},{"title":"TFMT5EncoderModel","local":"transformers.TFMT5EncoderModel","sections":[],"depth":2},{"title":"FlaxMT5Model","local":"transformers.FlaxMT5Model","sections":[],"depth":2},{"title":"FlaxMT5ForConditionalGeneration","local":"transformers.FlaxMT5ForConditionalGeneration","sections":[],"depth":2},{"title":"FlaxMT5EncoderModel","local":"transformers.FlaxMT5EncoderModel","sections":[],"depth":2}],"depth":1}';function Zs($){return Po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Es extends Yo{constructor(t){super(),Oo(this,t,Zs,Fs,Do,{})}}export{Es as component};
