import{s as Xt,o as Qt,n as xe}from"../chunks/scheduler.25b97de1.js";import{S as At,i as Yt,g as c,s as i,r as T,A as Dt,h as p,f as s,c as l,j as pe,u as b,x as _,k as ue,l as Et,y as m,a as r,v as y,d as M,t as w,w as v}from"../chunks/index.d9030fc9.js";import{T as $t}from"../chunks/Tip.baa67368.js";import{D as ye}from"../chunks/Docstring.ffac8efa.js";import{C as qe}from"../chunks/CodeBlock.e6cd0d95.js";import{F as Kt,M as Ht}from"../chunks/Markdown.7217f838.js";import{E as et}from"../chunks/ExampleCodeBlock.22dfe688.js";import{P as Bt}from"../chunks/PipelineTag.5f100392.js";import{H as be,E as en}from"../chunks/EditOnGithub.91d95064.js";function tn(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9QVENvbmZpZyUyQyUyME9QVE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9QVCUyMGZhY2Vib29rJTJGb3B0LWxhcmdlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME9QVENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRm9wdC1sYXJnZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwT1BUTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OPTConfig, OPTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OPT facebook/opt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OPTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/opt-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function nn(F){let t,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=g},l(o){t=p(o,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=g)},m(o,a){r(o,t,a)},p:xe,d(o){o&&s(t)}}}function on(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPUFRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbCUyMCUzRCUyME9QVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTModel.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function sn(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPUFRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwT1BURm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OPTForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious. I&#x27;m just a little bit of a weirdo.&quot;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function an(F){let t,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=g},l(o){t=p(o,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=g)},m(o,a){r(o,t,a)},p:xe,d(o){o&&s(t)}}}function rn(F){let t,g="Example of single-label classification:",o,a,h;return a=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9QVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJBcnRodXJaJTJGb3B0LTM1MG0tZHVtbXktc2MlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJBcnRodXJaJTJGb3B0LTM1MG0tZHVtbXktc2MlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQW1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZCU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyME9QVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkFydGh1clolMkZvcHQtMzUwbS1kdW1teS1zYyUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OPTForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ArthurZ/opt-350m-dummy-sc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;ArthurZ/opt-350m-dummy-sc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.id2label[predicted_class_id]
<span class="hljs-string">&#x27;LABEL_0&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;ArthurZ/opt-350m-dummy-sc&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">1.71</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-ykxpe4"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function ln(F){let t,g="Example of multi-label classification:",o,a,h;return a=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyME9QVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJBcnRodXJaJTJGb3B0LTM1MG0tZHVtbXktc2MlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUFRGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJBcnRodXJaJTJGb3B0LTM1MG0tZHVtbXktc2MlMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyME9QVEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkFydGh1clolMkZvcHQtMzUwbS1kdW1teS1zYyUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OPTForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ArthurZ/opt-350m-dummy-sc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;ArthurZ/opt-350m-dummy-sc&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;ArthurZ/opt-350m-dummy-sc&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-1l8e32d"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function dn(F){let t,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=g},l(o){t=p(o,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=g)},m(o,a){r(o,t,a)},p:xe,d(o){o&&s(t)}}}function cn(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBPUFRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9yY2gubWFudWFsX3NlZWQoNCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQSUwQSUyMyUyMG5vdGUlM0ElMjB3ZSUyMGFyZSUyMGxvYWRpbmclMjBhJTIwT1BURm9yUXVlc3Rpb25BbnN3ZXJpbmclMjBmcm9tJTIwdGhlJTIwaHViJTIwaGVyZSUyQyUwQSUyMyUyMHNvJTIwdGhlJTIwaGVhZCUyMHdpbGwlMjBiZSUyMHJhbmRvbWx5JTIwaW5pdGlhbGl6ZWQlMkMlMjBoZW5jZSUyMHRoZSUyMHByZWRpY3Rpb25zJTIwd2lsbCUyMGJlJTIwcmFuZG9tJTBBbW9kZWwlMjAlM0QlMjBPUFRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBYW5zd2VyX29mZnNldCUyMCUzRCUyMGxlbih0b2tlbml6ZXIocXVlc3Rpb24pJTVCMCU1RCklMEElMEFwcmVkaWN0X2Fuc3dlcl90b2tlbnMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzJTVCJTBBJTIwJTIwJTIwJTIwMCUyQyUyMGFuc3dlcl9vZmZzZXQlMjAlMkIlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfb2Zmc2V0JTIwJTJCJTIwYW5zd2VyX2VuZF9pbmRleCUyMCUyQiUyMDElMEElNUQlMEFwcmVkaWN0ZWQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3RfYW5zd2VyX3Rva2VucyklMEFwcmVkaWN0ZWQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, OPTForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># note: we are loading a OPTForQuestionAnswering from the hub here,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># so the head will be randomly initialized, hence the predictions will be random</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_offset = <span class="hljs-built_in">len</span>(tokenizer(question)[<span class="hljs-number">0</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>, answer_offset + answer_start_index : answer_offset + answer_end_index + <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted = tokenizer.decode(predict_answer_tokens)
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted
<span class="hljs-string">&#x27; a nice puppet&#x27;</span>`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function pn(F){let t,g,o,a,h,n,f=`The bare OPT Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Y,z,L=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,N,P,j,W,k,U='The <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTModel">OPTModel</a> forward method, overrides the <code>__call__</code> special method.',me,E,fe,R,ae,V,_e,B,D,H,G,X,oe,he,K,q,Me,O,ee,x,Z,S="The OPT Model transformer with a sequence classification head on top (linear layer).",I,Q,je=`<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForSequenceClassification">OPTForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,Ce,re,Fe=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,$,J,te=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ne,le,Ue=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,tt,de,Pe,ot,ze,xt='The <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForSequenceClassification">OPTForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',st,we,at,ve,_t,Ze,Le,Ae,nt,A,Be,Ne,Ve,Ye=`The OPT Model transformer with a span classification head on top for extractive question-answering tasks like SQuAD
(a linear layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,Tt,Re,Se=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,bt,Ee,De=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,yt,Te,ke,Mt,Xe,Ke='The <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForQuestionAnswering">OPTForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',rt,$e,wt,We,He;return t=new be({props:{title:"OPTModel",local:"transformers.OPTModel",headingTag:"h2"}}),a=new ye({props:{name:"class transformers.OPTModel",anchor:"transformers.OPTModel",parameters:[{name:"config",val:": OPTConfig"}],parametersDescription:[{anchor:"transformers.OPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L971"}}),j=new ye({props:{name:"forward",anchor:"transformers.OPTModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.OPTModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OPTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.`,name:"attention_mask"},{anchor:"transformers.OPTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OPTModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.OPTModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OPTModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.OPTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OPTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OPTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OPTModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. for padding use -1.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L991",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new $t({props:{$$slots:{default:[nn]},$$scope:{ctx:F}}}),R=new et({props:{anchor:"transformers.OPTModel.forward.example",$$slots:{default:[on]},$$scope:{ctx:F}}}),V=new be({props:{title:"OPTForCausalLM",local:"transformers.OPTForCausalLM",headingTag:"h2"}}),D=new ye({props:{name:"class transformers.OPTForCausalLM",anchor:"transformers.OPTForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L1043"}}),X=new ye({props:{name:"forward",anchor:"transformers.OPTForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.OPTForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OPTForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.OPTForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_hidden_layers, num_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OPTForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those
that don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of
all <code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.OPTForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OPTForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.OPTForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.OPTForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OPTForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.OPTForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OPTForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. for padding use -1.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L1074",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new et({props:{anchor:"transformers.OPTForCausalLM.forward.example",$$slots:{default:[sn]},$$scope:{ctx:F}}}),q=new be({props:{title:"OPTForSequenceClassification",local:"transformers.OPTForSequenceClassification",headingTag:"h2"}}),ee=new ye({props:{name:"class transformers.OPTForSequenceClassification",anchor:"transformers.OPTForSequenceClassification",parameters:[{name:"config",val:": OPTConfig"}],parametersDescription:[{anchor:"transformers.OPTForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L1223"}}),Pe=new ye({props:{name:"forward",anchor:"transformers.OPTForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.OPTForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OPTForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.`,name:"attention_mask"},{anchor:"transformers.OPTForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OPTForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.OPTForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OPTForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.OPTForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OPTForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OPTForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OPTForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. for padding use -1.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OPTForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L1248",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),we=new $t({props:{$$slots:{default:[an]},$$scope:{ctx:F}}}),ve=new et({props:{anchor:"transformers.OPTForSequenceClassification.forward.example",$$slots:{default:[rn]},$$scope:{ctx:F}}}),Ze=new et({props:{anchor:"transformers.OPTForSequenceClassification.forward.example-2",$$slots:{default:[ln]},$$scope:{ctx:F}}}),Ae=new be({props:{title:"OPTForQuestionAnswering",local:"transformers.OPTForQuestionAnswering",headingTag:"h2"}}),Be=new ye({props:{name:"class transformers.OPTForQuestionAnswering",anchor:"transformers.OPTForQuestionAnswering",parameters:[{name:"config",val:": OPTConfig"}],parametersDescription:[{anchor:"transformers.OPTForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L1356"}}),ke=new ye({props:{name:"forward",anchor:"transformers.OPTForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.OPTForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.OPTForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.`,name:"attention_mask"},{anchor:"transformers.OPTForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.OPTForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.OPTForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.OPTForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.OPTForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.OPTForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OPTForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OPTForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. for padding use -1.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.OPTForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.OPTForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_opt.py#L1372",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),$e=new $t({props:{$$slots:{default:[dn]},$$scope:{ctx:F}}}),We=new et({props:{anchor:"transformers.OPTForQuestionAnswering.forward.example",$$slots:{default:[cn]},$$scope:{ctx:F}}}),{c(){T(t.$$.fragment),g=i(),o=c("div"),T(a.$$.fragment),h=i(),n=c("p"),n.innerHTML=f,Y=i(),z=c("p"),z.innerHTML=L,N=i(),P=c("div"),T(j.$$.fragment),W=i(),k=c("p"),k.innerHTML=U,me=i(),T(E.$$.fragment),fe=i(),T(R.$$.fragment),ae=i(),T(V.$$.fragment),_e=i(),B=c("div"),T(D.$$.fragment),H=i(),G=c("div"),T(X.$$.fragment),oe=i(),T(he.$$.fragment),K=i(),T(q.$$.fragment),Me=i(),O=c("div"),T(ee.$$.fragment),x=i(),Z=c("p"),Z.textContent=S,I=i(),Q=c("p"),Q.innerHTML=je,Ce=i(),re=c("p"),re.innerHTML=Fe,$=i(),J=c("p"),J.innerHTML=te,ne=i(),le=c("p"),le.innerHTML=Ue,tt=i(),de=c("div"),T(Pe.$$.fragment),ot=i(),ze=c("p"),ze.innerHTML=xt,st=i(),T(we.$$.fragment),at=i(),T(ve.$$.fragment),_t=i(),T(Ze.$$.fragment),Le=i(),T(Ae.$$.fragment),nt=i(),A=c("div"),T(Be.$$.fragment),Ne=i(),Ve=c("p"),Ve.innerHTML=Ye,Tt=i(),Re=c("p"),Re.innerHTML=Se,bt=i(),Ee=c("p"),Ee.innerHTML=De,yt=i(),Te=c("div"),T(ke.$$.fragment),Mt=i(),Xe=c("p"),Xe.innerHTML=Ke,rt=i(),T($e.$$.fragment),wt=i(),T(We.$$.fragment),this.h()},l(u){b(t.$$.fragment,u),g=l(u),o=p(u,"DIV",{class:!0});var C=pe(o);b(a.$$.fragment,C),h=l(C),n=p(C,"P",{"data-svelte-h":!0}),_(n)!=="svelte-19zlmzf"&&(n.innerHTML=f),Y=l(C),z=p(C,"P",{"data-svelte-h":!0}),_(z)!=="svelte-hswkmf"&&(z.innerHTML=L),N=l(C),P=p(C,"DIV",{class:!0});var ce=pe(P);b(j.$$.fragment,ce),W=l(ce),k=p(ce,"P",{"data-svelte-h":!0}),_(k)!=="svelte-1l5tgze"&&(k.innerHTML=U),me=l(ce),b(E.$$.fragment,ce),fe=l(ce),b(R.$$.fragment,ce),ce.forEach(s),C.forEach(s),ae=l(u),b(V.$$.fragment,u),_e=l(u),B=p(u,"DIV",{class:!0});var Ge=pe(B);b(D.$$.fragment,Ge),H=l(Ge),G=p(Ge,"DIV",{class:!0});var Je=pe(G);b(X.$$.fragment,Je),oe=l(Je),b(he.$$.fragment,Je),Je.forEach(s),Ge.forEach(s),K=l(u),b(q.$$.fragment,u),Me=l(u),O=p(u,"DIV",{class:!0});var ie=pe(O);b(ee.$$.fragment,ie),x=l(ie),Z=p(ie,"P",{"data-svelte-h":!0}),_(Z)!=="svelte-1hcah69"&&(Z.textContent=S),I=l(ie),Q=p(ie,"P",{"data-svelte-h":!0}),_(Q)!=="svelte-v93vpl"&&(Q.innerHTML=je),Ce=l(ie),re=p(ie,"P",{"data-svelte-h":!0}),_(re)!=="svelte-10ugs3m"&&(re.innerHTML=Fe),$=l(ie),J=p(ie,"P",{"data-svelte-h":!0}),_(J)!=="svelte-6pahdo"&&(J.innerHTML=te),ne=l(ie),le=p(ie,"P",{"data-svelte-h":!0}),_(le)!=="svelte-hswkmf"&&(le.innerHTML=Ue),tt=l(ie),de=p(ie,"DIV",{class:!0});var ge=pe(de);b(Pe.$$.fragment,ge),ot=l(ge),ze=p(ge,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-vm54g"&&(ze.innerHTML=xt),st=l(ge),b(we.$$.fragment,ge),at=l(ge),b(ve.$$.fragment,ge),_t=l(ge),b(Ze.$$.fragment,ge),ge.forEach(s),ie.forEach(s),Le=l(u),b(Ae.$$.fragment,u),nt=l(u),A=p(u,"DIV",{class:!0});var se=pe(A);b(Be.$$.fragment,se),Ne=l(se),Ve=p(se,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-7pga04"&&(Ve.innerHTML=Ye),Tt=l(se),Re=p(se,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-6pahdo"&&(Re.innerHTML=Se),bt=l(se),Ee=p(se,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-hswkmf"&&(Ee.innerHTML=De),yt=l(se),Te=p(se,"DIV",{class:!0});var Oe=pe(Te);b(ke.$$.fragment,Oe),Mt=l(Oe),Xe=p(Oe,"P",{"data-svelte-h":!0}),_(Xe)!=="svelte-jhpkae"&&(Xe.innerHTML=Ke),rt=l(Oe),b($e.$$.fragment,Oe),wt=l(Oe),b(We.$$.fragment,Oe),Oe.forEach(s),se.forEach(s),this.h()},h(){ue(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(u,C){y(t,u,C),r(u,g,C),r(u,o,C),y(a,o,null),m(o,h),m(o,n),m(o,Y),m(o,z),m(o,N),m(o,P),y(j,P,null),m(P,W),m(P,k),m(P,me),y(E,P,null),m(P,fe),y(R,P,null),r(u,ae,C),y(V,u,C),r(u,_e,C),r(u,B,C),y(D,B,null),m(B,H),m(B,G),y(X,G,null),m(G,oe),y(he,G,null),r(u,K,C),y(q,u,C),r(u,Me,C),r(u,O,C),y(ee,O,null),m(O,x),m(O,Z),m(O,I),m(O,Q),m(O,Ce),m(O,re),m(O,$),m(O,J),m(O,ne),m(O,le),m(O,tt),m(O,de),y(Pe,de,null),m(de,ot),m(de,ze),m(de,st),y(we,de,null),m(de,at),y(ve,de,null),m(de,_t),y(Ze,de,null),r(u,Le,C),y(Ae,u,C),r(u,nt,C),r(u,A,C),y(Be,A,null),m(A,Ne),m(A,Ve),m(A,Tt),m(A,Re),m(A,bt),m(A,Ee),m(A,yt),m(A,Te),y(ke,Te,null),m(Te,Mt),m(Te,Xe),m(Te,rt),y($e,Te,null),m(Te,wt),y(We,Te,null),He=!0},p(u,C){const ce={};C&2&&(ce.$$scope={dirty:C,ctx:u}),E.$set(ce);const Ge={};C&2&&(Ge.$$scope={dirty:C,ctx:u}),R.$set(Ge);const Je={};C&2&&(Je.$$scope={dirty:C,ctx:u}),he.$set(Je);const ie={};C&2&&(ie.$$scope={dirty:C,ctx:u}),we.$set(ie);const ge={};C&2&&(ge.$$scope={dirty:C,ctx:u}),ve.$set(ge);const se={};C&2&&(se.$$scope={dirty:C,ctx:u}),Ze.$set(se);const Oe={};C&2&&(Oe.$$scope={dirty:C,ctx:u}),$e.$set(Oe);const dt={};C&2&&(dt.$$scope={dirty:C,ctx:u}),We.$set(dt)},i(u){He||(M(t.$$.fragment,u),M(a.$$.fragment,u),M(j.$$.fragment,u),M(E.$$.fragment,u),M(R.$$.fragment,u),M(V.$$.fragment,u),M(D.$$.fragment,u),M(X.$$.fragment,u),M(he.$$.fragment,u),M(q.$$.fragment,u),M(ee.$$.fragment,u),M(Pe.$$.fragment,u),M(we.$$.fragment,u),M(ve.$$.fragment,u),M(Ze.$$.fragment,u),M(Ae.$$.fragment,u),M(Be.$$.fragment,u),M(ke.$$.fragment,u),M($e.$$.fragment,u),M(We.$$.fragment,u),He=!0)},o(u){w(t.$$.fragment,u),w(a.$$.fragment,u),w(j.$$.fragment,u),w(E.$$.fragment,u),w(R.$$.fragment,u),w(V.$$.fragment,u),w(D.$$.fragment,u),w(X.$$.fragment,u),w(he.$$.fragment,u),w(q.$$.fragment,u),w(ee.$$.fragment,u),w(Pe.$$.fragment,u),w(we.$$.fragment,u),w(ve.$$.fragment,u),w(Ze.$$.fragment,u),w(Ae.$$.fragment,u),w(Be.$$.fragment,u),w(ke.$$.fragment,u),w($e.$$.fragment,u),w(We.$$.fragment,u),He=!1},d(u){u&&(s(g),s(o),s(ae),s(_e),s(B),s(K),s(Me),s(O),s(Le),s(nt),s(A)),v(t,u),v(a),v(j),v(E),v(R),v(V,u),v(D),v(X),v(he),v(q,u),v(ee),v(Pe),v(we),v(ve),v(Ze),v(Ae,u),v(Be),v(ke),v($e),v(We)}}}function un(F){let t,g;return t=new Ht({props:{$$slots:{default:[pn]},$$scope:{ctx:F}}}),{c(){T(t.$$.fragment)},l(o){b(t.$$.fragment,o)},m(o,a){y(t,o,a),g=!0},p(o,a){const h={};a&2&&(h.$$scope={dirty:a,ctx:o}),t.$set(h)},i(o){g||(M(t.$$.fragment,o),g=!0)},o(o){w(t.$$.fragment,o),g=!1},d(o){v(t,o)}}}function mn(F){let t,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",o,a,h="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,f,Y=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,z,L,N=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,P,j,W=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=c("p"),t.innerHTML=g,o=i(),a=c("ul"),a.innerHTML=h,n=i(),f=c("p"),f.innerHTML=Y,z=i(),L=c("ul"),L.innerHTML=N,P=i(),j=c("p"),j.innerHTML=W},l(k){t=p(k,"P",{"data-svelte-h":!0}),_(t)!=="svelte-1ajbfxg"&&(t.innerHTML=g),o=l(k),a=p(k,"UL",{"data-svelte-h":!0}),_(a)!=="svelte-qm1t26"&&(a.innerHTML=h),n=l(k),f=p(k,"P",{"data-svelte-h":!0}),_(f)!=="svelte-1v9qsc5"&&(f.innerHTML=Y),z=l(k),L=p(k,"UL",{"data-svelte-h":!0}),_(L)!=="svelte-15scerc"&&(L.innerHTML=N),P=l(k),j=p(k,"P",{"data-svelte-h":!0}),_(j)!=="svelte-1an3odd"&&(j.innerHTML=W)},m(k,U){r(k,t,U),r(k,o,U),r(k,a,U),r(k,n,U),r(k,f,U),r(k,z,U),r(k,L,U),r(k,P,U),r(k,j,U)},p:xe,d(k){k&&(s(t),s(o),s(a),s(n),s(f),s(z),s(L),s(P),s(j))}}}function hn(F){let t,g=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=g},l(o){t=p(o,"P",{"data-svelte-h":!0}),_(t)!=="svelte-fincs2"&&(t.innerHTML=g)},m(o,a){r(o,t,a)},p:xe,d(o){o&&s(t)}}}function gn(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9QVE1vZGVsJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZPUFRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOPTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOPTModel.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function fn(F){let t,g="TensorFlow models and layers in <code>transformers</code> accept two formats as input:",o,a,h="<li>having all inputs as keyword arguments (like PyTorch models), or</li> <li>having all inputs as a list, tuple or dict in the first positional argument.</li>",n,f,Y=`The reason the second format is supported is that Keras methods prefer this format when passing inputs to models
and layers. Because of this support, when using methods like <code>model.fit()</code> things should “just work” for you - just
pass your inputs and labels in any format that <code>model.fit()</code> supports! If, however, you want to use the second
format outside of Keras methods like <code>fit()</code> and <code>predict()</code>, such as when creating your own layers or models with
the Keras <code>Functional</code> API, there are three possibilities you can use to gather all the input Tensors in the first
positional argument:`,z,L,N=`<li>a single Tensor with <code>input_ids</code> only and nothing else: <code>model(input_ids)</code></li> <li>a list of varying length with one or several input Tensors IN THE ORDER given in the docstring:
<code>model([input_ids, attention_mask])</code> or <code>model([input_ids, attention_mask, token_type_ids])</code></li> <li>a dictionary with one or several input Tensors associated to the input names given in the docstring:
<code>model({&quot;input_ids&quot;: input_ids, &quot;token_type_ids&quot;: token_type_ids})</code></li>`,P,j,W=`Note that when creating models and layers with
<a href="https://keras.io/guides/making_new_layers_and_models_via_subclassing/" rel="nofollow">subclassing</a> then you don’t need to worry
about any of this, as you can just pass inputs like you would to any other Python function!`;return{c(){t=c("p"),t.innerHTML=g,o=i(),a=c("ul"),a.innerHTML=h,n=i(),f=c("p"),f.innerHTML=Y,z=i(),L=c("ul"),L.innerHTML=N,P=i(),j=c("p"),j.innerHTML=W},l(k){t=p(k,"P",{"data-svelte-h":!0}),_(t)!=="svelte-1ajbfxg"&&(t.innerHTML=g),o=l(k),a=p(k,"UL",{"data-svelte-h":!0}),_(a)!=="svelte-qm1t26"&&(a.innerHTML=h),n=l(k),f=p(k,"P",{"data-svelte-h":!0}),_(f)!=="svelte-1v9qsc5"&&(f.innerHTML=Y),z=l(k),L=p(k,"UL",{"data-svelte-h":!0}),_(L)!=="svelte-15scerc"&&(L.innerHTML=N),P=l(k),j=p(k,"P",{"data-svelte-h":!0}),_(j)!=="svelte-1an3odd"&&(j.innerHTML=W)},m(k,U){r(k,t,U),r(k,o,U),r(k,a,U),r(k,n,U),r(k,f,U),r(k,z,U),r(k,L,U),r(k,P,U),r(k,j,U)},p:xe,d(k){k&&(s(t),s(o),s(a),s(n),s(f),s(z),s(L),s(P),s(j))}}}function _n(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURk9QVEZvckNhdXNhbExNJTBBaW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZPUFRGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFOPTForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFOPTForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function Tn(F){let t,g,o,a,h,n,f=`The bare TF OPT Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Y,z,L=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,N,P,j,W,k,U,me,E='The <a href="/docs/transformers/main/en/model_doc/opt#transformers.TFOPTModel">TFOPTModel</a> forward method, overrides the <code>__call__</code> special method.',fe,R,ae,V,_e,B,D,H,G,X,oe,he="The OPT Model transformer with a language modeling head on top.",K,q,Me=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,O,ee,x=`This model is also a <a href="https://www.tensorflow.org/api_docs/python/tf/keras/Model" rel="nofollow">keras.Model</a> subclass. Use it
as a regular TF 2.0 Keras Model and refer to the TF 2.0 documentation for all matter related to general usage and
behavior.`,Z,S,I,Q,je,Ce,re,Fe;return t=new be({props:{title:"TFOPTModel",local:"transformers.TFOPTModel",headingTag:"h2"}}),a=new ye({props:{name:"class transformers.TFOPTModel",anchor:"transformers.TFOPTModel",parameters:[{name:"config",val:": OPTConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOPTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_tf_opt.py#L831"}}),P=new $t({props:{$$slots:{default:[mn]},$$scope:{ctx:F}}}),k=new ye({props:{name:"call",anchor:"transformers.TFOPTModel.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOPTModel.call.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOPTModel.call.attention_mask",description:`<strong>attention_mask</strong> (<code>tf.Tensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOPTModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOPTModel.call.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[tf.Tensor]]</code> of length <code>config.n_layers</code>) &#x2014;
contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFOPTModel.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>). Set to <code>False</code> during training, <code>True</code> during generation`,name:"use_cache"},{anchor:"transformers.TFOPTModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail. This argument can be used only in eager mode, in graph mode the value in the
config will be used instead.`,name:"output_attentions"},{anchor:"transformers.TFOPTModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail. This argument can be used only in eager mode, in graph mode the value in the config will be
used instead.`,name:"output_hidden_states"},{anchor:"transformers.TFOPTModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple. This argument can be used in
eager mode, in graph mode the value will always be set to True.`,name:"return_dict"},{anchor:"transformers.TFOPTModel.call.training",description:`<strong>training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use the model in training mode (some modules like dropout modules have different
behaviors between training and evaluation).`,name:"training"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_tf_opt.py#L850",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFBaseModelOutputWithPast"
>transformers.modeling_tf_outputs.TFBaseModelOutputWithPast</a> or <code>tuple(tf.Tensor)</code></p>
`}}),R=new $t({props:{$$slots:{default:[hn]},$$scope:{ctx:F}}}),V=new et({props:{anchor:"transformers.TFOPTModel.call.example",$$slots:{default:[gn]},$$scope:{ctx:F}}}),B=new be({props:{title:"TFOPTForCausalLM",local:"transformers.TFOPTForCausalLM",headingTag:"h2"}}),G=new ye({props:{name:"class transformers.TFOPTForCausalLM",anchor:"transformers.TFOPTForCausalLM",parameters:[{name:"config",val:": OPTConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOPTForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_tf_opt.py#L923"}}),S=new $t({props:{$$slots:{default:[fn]},$$scope:{ctx:F}}}),je=new ye({props:{name:"call",anchor:"transformers.TFOPTForCausalLM.call",parameters:[{name:"input_ids",val:": TFModelInputType | None = None"},{name:"past_key_values",val:": Optional[Tuple[Tuple[Union[np.ndarray, tf.Tensor]]]] = None"},{name:"attention_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"position_ids",val:": np.ndarray | tf.Tensor | None = None"},{name:"head_mask",val:": np.ndarray | tf.Tensor | None = None"},{name:"inputs_embeds",val:": np.ndarray | tf.Tensor | None = None"},{name:"labels",val:": np.ndarray | tf.Tensor | None = None"},{name:"use_cache",val:": Optional[bool] = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": Optional[bool] = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFOPTForCausalLM.call.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you
provide it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFOPTForCausalLM.call.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.TFOPTForCausalLM.call.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_hidden_layers, num_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFOPTForCausalLM.call.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of
shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>. The two additional
tensors are only required when the model is used as a decoder in a Sequence to Sequence model.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the
cross-attention blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.TFOPTForCausalLM.call.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.TFOPTForCausalLM.call.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.TFOPTForCausalLM.call.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding
(see <code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.TFOPTForCausalLM.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFOPTForCausalLM.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFOPTForCausalLM.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_tf_opt.py#L955",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or <code>tuple(tf.Tensor)</code>: A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(n,)</code>, <em>optional</em>, where n is the number of non-masked labels, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>List[tf.Tensor]</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — List of <code>tf.Tensor</code> of length <code>config.n_layers</code>, with each tensor of shape <code>(2, batch_size, num_heads, sequence_length, embed_size_per_head)</code>).</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_tf_outputs.TFCausalLMOutputWithPast"
>transformers.modeling_tf_outputs.TFCausalLMOutputWithPast</a> or <code>tuple(tf.Tensor)</code></p>
`}}),re=new et({props:{anchor:"transformers.TFOPTForCausalLM.call.example",$$slots:{default:[_n]},$$scope:{ctx:F}}}),{c(){T(t.$$.fragment),g=i(),o=c("div"),T(a.$$.fragment),h=i(),n=c("p"),n.innerHTML=f,Y=i(),z=c("p"),z.innerHTML=L,N=i(),T(P.$$.fragment),j=i(),W=c("div"),T(k.$$.fragment),U=i(),me=c("p"),me.innerHTML=E,fe=i(),T(R.$$.fragment),ae=i(),T(V.$$.fragment),_e=i(),T(B.$$.fragment),D=i(),H=c("div"),T(G.$$.fragment),X=i(),oe=c("p"),oe.textContent=he,K=i(),q=c("p"),q.innerHTML=Me,O=i(),ee=c("p"),ee.innerHTML=x,Z=i(),T(S.$$.fragment),I=i(),Q=c("div"),T(je.$$.fragment),Ce=i(),T(re.$$.fragment),this.h()},l($){b(t.$$.fragment,$),g=l($),o=p($,"DIV",{class:!0});var J=pe(o);b(a.$$.fragment,J),h=l(J),n=p(J,"P",{"data-svelte-h":!0}),_(n)!=="svelte-11rvf79"&&(n.innerHTML=f),Y=l(J),z=p(J,"P",{"data-svelte-h":!0}),_(z)!=="svelte-1be7e3c"&&(z.innerHTML=L),N=l(J),b(P.$$.fragment,J),j=l(J),W=p(J,"DIV",{class:!0});var te=pe(W);b(k.$$.fragment,te),U=l(te),me=p(te,"P",{"data-svelte-h":!0}),_(me)!=="svelte-1t5qzja"&&(me.innerHTML=E),fe=l(te),b(R.$$.fragment,te),ae=l(te),b(V.$$.fragment,te),te.forEach(s),J.forEach(s),_e=l($),b(B.$$.fragment,$),D=l($),H=p($,"DIV",{class:!0});var ne=pe(H);b(G.$$.fragment,ne),X=l(ne),oe=p(ne,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-17041eg"&&(oe.textContent=he),K=l(ne),q=p(ne,"P",{"data-svelte-h":!0}),_(q)!=="svelte-1qaxm70"&&(q.innerHTML=Me),O=l(ne),ee=p(ne,"P",{"data-svelte-h":!0}),_(ee)!=="svelte-1be7e3c"&&(ee.innerHTML=x),Z=l(ne),b(S.$$.fragment,ne),I=l(ne),Q=p(ne,"DIV",{class:!0});var le=pe(Q);b(je.$$.fragment,le),Ce=l(le),b(re.$$.fragment,le),le.forEach(s),ne.forEach(s),this.h()},h(){ue(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m($,J){y(t,$,J),r($,g,J),r($,o,J),y(a,o,null),m(o,h),m(o,n),m(o,Y),m(o,z),m(o,N),y(P,o,null),m(o,j),m(o,W),y(k,W,null),m(W,U),m(W,me),m(W,fe),y(R,W,null),m(W,ae),y(V,W,null),r($,_e,J),y(B,$,J),r($,D,J),r($,H,J),y(G,H,null),m(H,X),m(H,oe),m(H,K),m(H,q),m(H,O),m(H,ee),m(H,Z),y(S,H,null),m(H,I),m(H,Q),y(je,Q,null),m(Q,Ce),y(re,Q,null),Fe=!0},p($,J){const te={};J&2&&(te.$$scope={dirty:J,ctx:$}),P.$set(te);const ne={};J&2&&(ne.$$scope={dirty:J,ctx:$}),R.$set(ne);const le={};J&2&&(le.$$scope={dirty:J,ctx:$}),V.$set(le);const Ue={};J&2&&(Ue.$$scope={dirty:J,ctx:$}),S.$set(Ue);const tt={};J&2&&(tt.$$scope={dirty:J,ctx:$}),re.$set(tt)},i($){Fe||(M(t.$$.fragment,$),M(a.$$.fragment,$),M(P.$$.fragment,$),M(k.$$.fragment,$),M(R.$$.fragment,$),M(V.$$.fragment,$),M(B.$$.fragment,$),M(G.$$.fragment,$),M(S.$$.fragment,$),M(je.$$.fragment,$),M(re.$$.fragment,$),Fe=!0)},o($){w(t.$$.fragment,$),w(a.$$.fragment,$),w(P.$$.fragment,$),w(k.$$.fragment,$),w(R.$$.fragment,$),w(V.$$.fragment,$),w(B.$$.fragment,$),w(G.$$.fragment,$),w(S.$$.fragment,$),w(je.$$.fragment,$),w(re.$$.fragment,$),Fe=!1},d($){$&&(s(g),s(o),s(_e),s(D),s(H)),v(t,$),v(a),v(P),v(k),v(R),v(V),v(B,$),v(G),v(S),v(je),v(re)}}}function bn(F){let t,g;return t=new Ht({props:{$$slots:{default:[Tn]},$$scope:{ctx:F}}}),{c(){T(t.$$.fragment)},l(o){b(t.$$.fragment,o)},m(o,a){y(t,o,a),g=!0},p(o,a){const h={};a&2&&(h.$$scope={dirty:a,ctx:o}),t.$set(h)},i(o){g||(M(t.$$.fragment,o),g=!0)},o(o){w(t.$$.fragment,o),g=!1},d(o){v(t,o)}}}function yn(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4T1BUTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheE9QVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJqYXglMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxOPTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxOPTModel.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function Mn(F){let t,g="Example:",o,a,h;return a=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGbGF4T1BURm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheE9QVEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwcmV0cmlldmUlMjBsb2d0cyUyMGZvciUyMG5leHQlMjB0b2tlbiUwQW5leHRfdG9rZW5fbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlNUIlM0ElMkMlMjAtMSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FlaxOPTForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxOPTForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># retrieve logts for next token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>next_token_logits = outputs.logits[:, -<span class="hljs-number">1</span>]`,wrap:!1}}),{c(){t=c("p"),t.textContent=g,o=i(),T(a.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),_(t)!=="svelte-11lpom8"&&(t.textContent=g),o=l(n),b(a.$$.fragment,n)},m(n,f){r(n,t,f),r(n,o,f),y(a,n,f),h=!0},p:xe,i(n){h||(M(a.$$.fragment,n),h=!0)},o(n){w(a.$$.fragment,n),h=!1},d(n){n&&(s(t),s(o)),v(a,n)}}}function wn(F){let t,g,o,a,h,n,f,Y,z,L,N,P,j,W,k,U,me=`OPT Model with a language modeling head on top (linear layer with weights tied to the input embeddings) e.g for
autoregressive tasks.`,E,fe,R=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ae,V,_e=`This model is also a Flax Linen
<a href="https://flax.readthedocs.io/en/latest/_autosummary/flax.nn.module.html" rel="nofollow">flax.nn.Module</a> subclass. Use it as a
regular Flax Module and refer to the Flax documentation for all matter related to general usage and behavior.`,B,D,H="Finally, this model supports inherent JAX features such as:",G,X,oe='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',he,K,q,Me,O,ee;return t=new be({props:{title:"FlaxOPTModel",local:"transformers.FlaxOPTModel",headingTag:"h2"}}),a=new ye({props:{name:"class transformers.FlaxOPTModel",anchor:"transformers.FlaxOPTModel",parameters:[{name:"config",val:": OPTConfig"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_flax_opt.py#L690"}}),f=new ye({props:{name:"__call__",anchor:"transformers.FlaxOPTModel.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"position_ids",val:": typing.Optional[jax.Array] = None"},{name:"params",val:": dict = None"},{name:"past_key_values",val:": dict = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f7987a02c20> = None"},{name:"deterministic",val:": bool = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_flax_opt.py#L583",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),z=new et({props:{anchor:"transformers.FlaxOPTModel.__call__.example",$$slots:{default:[yn]},$$scope:{ctx:F}}}),N=new be({props:{title:"FlaxOPTForCausalLM",local:"transformers.FlaxOPTForCausalLM",headingTag:"h2"}}),W=new ye({props:{name:"class transformers.FlaxOPTForCausalLM",anchor:"transformers.FlaxOPTForCausalLM",parameters:[{name:"config",val:": OPTConfig"},{name:"input_shape",val:": typing.Tuple[int] = (1, 1)"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxOPTForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig">OPTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxOPTForCausalLM.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_flax_opt.py#L756"}}),q=new ye({props:{name:"__call__",anchor:"transformers.FlaxOPTForCausalLM.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"attention_mask",val:": typing.Optional[jax.Array] = None"},{name:"position_ids",val:": typing.Optional[jax.Array] = None"},{name:"params",val:": dict = None"},{name:"past_key_values",val:": dict = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7f7987a02c20> = None"},{name:"deterministic",val:": bool = True"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/modeling_flax_opt.py#L583",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/opt#transformers.OPTConfig"
>OPTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxBaseModelOutput"
>transformers.modeling_flax_outputs.FlaxBaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new et({props:{anchor:"transformers.FlaxOPTForCausalLM.__call__.example",$$slots:{default:[Mn]},$$scope:{ctx:F}}}),{c(){T(t.$$.fragment),g=i(),o=c("div"),T(a.$$.fragment),h=i(),n=c("div"),T(f.$$.fragment),Y=i(),T(z.$$.fragment),L=i(),T(N.$$.fragment),P=i(),j=c("div"),T(W.$$.fragment),k=i(),U=c("p"),U.textContent=me,E=i(),fe=c("p"),fe.innerHTML=R,ae=i(),V=c("p"),V.innerHTML=_e,B=i(),D=c("p"),D.textContent=H,G=i(),X=c("ul"),X.innerHTML=oe,he=i(),K=c("div"),T(q.$$.fragment),Me=i(),T(O.$$.fragment),this.h()},l(x){b(t.$$.fragment,x),g=l(x),o=p(x,"DIV",{class:!0});var Z=pe(o);b(a.$$.fragment,Z),h=l(Z),n=p(Z,"DIV",{class:!0});var S=pe(n);b(f.$$.fragment,S),Y=l(S),b(z.$$.fragment,S),S.forEach(s),Z.forEach(s),L=l(x),b(N.$$.fragment,x),P=l(x),j=p(x,"DIV",{class:!0});var I=pe(j);b(W.$$.fragment,I),k=l(I),U=p(I,"P",{"data-svelte-h":!0}),_(U)!=="svelte-lbc411"&&(U.textContent=me),E=l(I),fe=p(I,"P",{"data-svelte-h":!0}),_(fe)!=="svelte-18ki9f4"&&(fe.innerHTML=R),ae=l(I),V=p(I,"P",{"data-svelte-h":!0}),_(V)!=="svelte-idybz1"&&(V.innerHTML=_e),B=l(I),D=p(I,"P",{"data-svelte-h":!0}),_(D)!=="svelte-1pplc4a"&&(D.textContent=H),G=l(I),X=p(I,"UL",{"data-svelte-h":!0}),_(X)!=="svelte-1w7z84m"&&(X.innerHTML=oe),he=l(I),K=p(I,"DIV",{class:!0});var Q=pe(K);b(q.$$.fragment,Q),Me=l(Q),b(O.$$.fragment,Q),Q.forEach(s),I.forEach(s),this.h()},h(){ue(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ue(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(x,Z){y(t,x,Z),r(x,g,Z),r(x,o,Z),y(a,o,null),m(o,h),m(o,n),y(f,n,null),m(n,Y),y(z,n,null),r(x,L,Z),y(N,x,Z),r(x,P,Z),r(x,j,Z),y(W,j,null),m(j,k),m(j,U),m(j,E),m(j,fe),m(j,ae),m(j,V),m(j,B),m(j,D),m(j,G),m(j,X),m(j,he),m(j,K),y(q,K,null),m(K,Me),y(O,K,null),ee=!0},p(x,Z){const S={};Z&2&&(S.$$scope={dirty:Z,ctx:x}),z.$set(S);const I={};Z&2&&(I.$$scope={dirty:Z,ctx:x}),O.$set(I)},i(x){ee||(M(t.$$.fragment,x),M(a.$$.fragment,x),M(f.$$.fragment,x),M(z.$$.fragment,x),M(N.$$.fragment,x),M(W.$$.fragment,x),M(q.$$.fragment,x),M(O.$$.fragment,x),ee=!0)},o(x){w(t.$$.fragment,x),w(a.$$.fragment,x),w(f.$$.fragment,x),w(z.$$.fragment,x),w(N.$$.fragment,x),w(W.$$.fragment,x),w(q.$$.fragment,x),w(O.$$.fragment,x),ee=!1},d(x){x&&(s(g),s(o),s(L),s(P),s(j)),v(t,x),v(a),v(f),v(z),v(N,x),v(W),v(q),v(O)}}}function vn(F){let t,g;return t=new Ht({props:{$$slots:{default:[wn]},$$scope:{ctx:F}}}),{c(){T(t.$$.fragment)},l(o){b(t.$$.fragment,o)},m(o,a){y(t,o,a),g=!0},p(o,a){const h={};a&2&&(h.$$scope={dirty:a,ctx:o}),t.$set(h)},i(o){g||(M(t.$$.fragment,o),g=!0)},o(o){w(t.$$.fragment,o),g=!1},d(o){v(t,o)}}}function kn(F){let t,g,o,a,h,n,f,Y,z,L=`The OPT model was proposed in <a href="https://arxiv.org/pdf/2205.01068" rel="nofollow">Open Pre-trained Transformer Language Models</a> by Meta AI.
OPT is a series of open-sourced large causal language models which perform similar in performance to GPT3.`,N,P,j="The abstract from the paper is the following:",W,k,U="<em>Large language models, which are often trained for hundreds of thousands of compute days, have shown remarkable capabilities for zero- and few-shot learning. Given their computational cost, these models are difficult to replicate without significant capital. For the few that are available through APIs, no access is granted to the full model weights, making them difficult to study. We present Open Pre-trained Transformers (OPT), a suite of decoder-only pre-trained transformers ranging from 125M to 175B parameters, which we aim to fully and responsibly share with interested researchers. We show that OPT-175B is comparable to GPT-3, while requiring only 1/7th the carbon footprint to develop. We are also releasing our logbook detailing the infrastructure challenges we faced, along with code for experimenting with all of the released models.</em>",me,E,fe=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a>, <a href="https://huggingface.co/ybelkada" rel="nofollow">Younes Belkada</a>, and <a href="https://huggingface.co/patrickvonplaten" rel="nofollow">Patrick Von Platen</a>.
The original code can be found <a href="https://github.com/facebookresearch/metaseq" rel="nofollow">here</a>.`,R,ae,V="Tips:",_e,B,D="<li>OPT has the same architecture as <code>BartDecoder</code>.</li> <li>Contrary to GPT2, OPT adds the EOS token <code>&lt;/s&gt;</code> to the beginning of every prompt.</li>",H,G,X,oe,he=`A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OPT. If you’re
interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,K,q,Me,O,ee='<li>A notebook on <a href="https://colab.research.google.com/drive/1jCkpikz0J2o20FBQmYmAGdiKmJGOMo-o?usp=sharing" rel="nofollow">fine-tuning OPT with PEFT, bitsandbytes, and Transformers</a>. 🌎</li> <li>A blog post on <a href="https://huggingface.co/blog/introducing-csearch#62-example-two---opt" rel="nofollow">decoding strategies with OPT</a>.</li> <li><a href="https://huggingface.co/course/en/chapter7/6?fw=pt#training-a-causal-language-model-from-scratch" rel="nofollow">Causal language modeling</a> chapter of the 🤗 Hugging Face Course.</li> <li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForCausalLM">OPTForCausalLM</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/language-modeling#gpt-2gpt-and-causal-language-modeling" rel="nofollow">causal language modeling example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/language_modeling.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/main/en/model_doc/opt#transformers.TFOPTForCausalLM">TFOPTForCausalLM</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/tensorflow/language-modeling#run_clmpy" rel="nofollow">causal language modeling example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/language_modeling-tf.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="/docs/transformers/main/en/model_doc/opt#transformers.FlaxOPTForCausalLM">FlaxOPTForCausalLM</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/flax/language-modeling#causal-language-modeling" rel="nofollow">causal language modeling example script</a>.</li>',x,Z,S,I,Q='<li><a href="sequence_classification.md">Text classification task guide</a></li> <li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForSequenceClassification">OPTForSequenceClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/text_classification.ipynb" rel="nofollow">notebook</a>.</li>',je,Ce,re,Fe,$=`<li><a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTForQuestionAnswering">OPTForQuestionAnswering</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/question-answering" rel="nofollow">question answering example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/question_answering.ipynb" rel="nofollow">notebook</a>.</li> <li><a href="https://huggingface.co/course/chapter7/7?fw=pt" rel="nofollow">Question answering</a> chapter
of the 🤗 Hugging Face Course.</li>`,J,te,ne="⚡️ Inference",le,Ue,tt='<li>A blog post on <a href="https://huggingface.co/blog/accelerate-large-models" rel="nofollow">How 🤗 Accelerate runs very large models thanks to PyTorch</a> with OPT.</li>',de,Pe,ot,ze,xt="First, make sure to install the latest version of Flash Attention 2 to include the sliding window attention feature.",st,we,at,ve,_t="Make also sure that you have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of flash-attn repository. Make also sure to load your model in half-precision (e.g. `torch.float16“)",Ze,Le,Ae="To load and run a model using Flash Attention 2, refer to the snippet below:",nt,A,Be,Ne,Ve,Ye,Tt="Below is an expected speedup diagram that compares pure inference time between the native implementation in transformers using <code>facebook/opt-2.7b</code> checkpoint and the Flash Attention 2 version of the model using two different sequence lengths.",Re,Se,bt='<img src="https://user-images.githubusercontent.com/49240599/281101546-d2fca6d2-ee44-48f3-9534-ba8d5bee4531.png"/>',Ee,De,yt="Below is an expected speedup diagram that compares pure inference time between the native implementation in transformers using <code>facebook/opt-350m</code> checkpoint and the Flash Attention 2 version of the model using two different sequence lengths.",Te,ke,Mt='<img src="https://user-images.githubusercontent.com/49240599/281101682-d1144e90-0dbc-46f4-8fc8-c6206cb793c9.png"/>',Xe,Ke,rt,$e,wt=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,We,He,u=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,C,ce,Ge,Je,ie="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",ge,se,Oe=`On a local benchmark (L40S-45GB, PyTorch 2.4.0, OS Debian GNU/Linux 11) using <code>float16</code> with
<a href="https://huggingface.co/facebook/opt-350m" rel="nofollow">facebook/opt-350m</a>, we saw the
following speedups during training and inference.`,dt,ct,Ct,pt,Gt='<thead><tr><th align="right">batch_size</th> <th align="right">seq_len</th> <th align="left">Time per batch (eager - s)</th> <th align="right">Time per batch (sdpa - s)</th> <th align="left">Speedup (%)</th> <th align="left">Eager peak mem (MB)</th> <th align="right">sdpa peak mem (MB)</th> <th align="left">Mem saving (%)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">128</td> <td align="left">0.047</td> <td align="right">0.037</td> <td align="left">26.360</td> <td align="left">1474.611</td> <td align="right">1474.32</td> <td align="left">0.019</td></tr> <tr><td align="right">1</td> <td align="right">256</td> <td align="left">0.046</td> <td align="right">0.037</td> <td align="left">24.335</td> <td align="left">1498.541</td> <td align="right">1499.49</td> <td align="left">-0.063</td></tr> <tr><td align="right">1</td> <td align="right">512</td> <td align="left">0.046</td> <td align="right">0.037</td> <td align="left">24.959</td> <td align="left">1973.544</td> <td align="right">1551.35</td> <td align="left">27.215</td></tr> <tr><td align="right">1</td> <td align="right">1024</td> <td align="left">0.062</td> <td align="right">0.038</td> <td align="left">65.135</td> <td align="left">4867.113</td> <td align="right">1698.35</td> <td align="left">186.578</td></tr> <tr><td align="right">1</td> <td align="right">2048</td> <td align="left">0.230</td> <td align="right">0.039</td> <td align="left">483.933</td> <td align="left">15662.224</td> <td align="right">2715.75</td> <td align="left">476.718</td></tr> <tr><td align="right">2</td> <td align="right">128</td> <td align="left">0.045</td> <td align="right">0.037</td> <td align="left">20.455</td> <td align="left">1498.164</td> <td align="right">1499.49</td> <td align="left">-0.089</td></tr> <tr><td align="right">2</td> <td align="right">256</td> <td align="left">0.046</td> <td align="right">0.037</td> <td align="left">24.027</td> <td align="left">1569.367</td> <td align="right">1551.35</td> <td align="left">1.161</td></tr> <tr><td align="right">2</td> <td align="right">512</td> <td align="left">0.045</td> <td align="right">0.037</td> <td align="left">20.965</td> <td align="left">3257.074</td> <td align="right">1698.35</td> <td align="left">91.778</td></tr> <tr><td align="right">2</td> <td align="right">1024</td> <td align="left">0.122</td> <td align="right">0.038</td> <td align="left">225.958</td> <td align="left">9054.405</td> <td align="right">2715.75</td> <td align="left">233.403</td></tr> <tr><td align="right">2</td> <td align="right">2048</td> <td align="left">0.464</td> <td align="right">0.067</td> <td align="left">593.646</td> <td align="left">30572.058</td> <td align="right">4750.55</td> <td align="left">543.548</td></tr> <tr><td align="right">4</td> <td align="right">128</td> <td align="left">0.045</td> <td align="right">0.037</td> <td align="left">21.918</td> <td align="left">1549.448</td> <td align="right">1551.35</td> <td align="left">-0.123</td></tr> <tr><td align="right">4</td> <td align="right">256</td> <td align="left">0.044</td> <td align="right">0.038</td> <td align="left">18.084</td> <td align="left">2451.768</td> <td align="right">1698.35</td> <td align="left">44.361</td></tr> <tr><td align="right">4</td> <td align="right">512</td> <td align="left">0.069</td> <td align="right">0.037</td> <td align="left">84.421</td> <td align="left">5833.180</td> <td align="right">2715.75</td> <td align="left">114.791</td></tr> <tr><td align="right">4</td> <td align="right">1024</td> <td align="left">0.262</td> <td align="right">0.062</td> <td align="left">319.475</td> <td align="left">17427.842</td> <td align="right">4750.55</td> <td align="left">266.860</td></tr> <tr><td align="right">4</td> <td align="right">2048</td> <td align="left">OOM</td> <td align="right">0.062</td> <td align="left">Eager OOM</td> <td align="left">OOM</td> <td align="right">4750.55</td> <td align="left">Eager OOM</td></tr> <tr><td align="right">8</td> <td align="right">128</td> <td align="left">0.044</td> <td align="right">0.037</td> <td align="left">18.436</td> <td align="left">2049.115</td> <td align="right">1697.78</td> <td align="left">20.694</td></tr> <tr><td align="right">8</td> <td align="right">256</td> <td align="left">0.048</td> <td align="right">0.036</td> <td align="left">32.887</td> <td align="left">4222.567</td> <td align="right">2715.75</td> <td align="left">55.484</td></tr> <tr><td align="right">8</td> <td align="right">512</td> <td align="left">0.153</td> <td align="right">0.06</td> <td align="left">154.862</td> <td align="left">10985.391</td> <td align="right">4750.55</td> <td align="left">131.245</td></tr> <tr><td align="right">8</td> <td align="right">1024</td> <td align="left">0.526</td> <td align="right">0.122</td> <td align="left">330.697</td> <td align="left">34175.763</td> <td align="right">8821.18</td> <td align="left">287.428</td></tr> <tr><td align="right">8</td> <td align="right">2048</td> <td align="left">OOM</td> <td align="right">0.122</td> <td align="left">Eager OOM</td> <td align="left">OOM</td> <td align="right">8821.18</td> <td align="left">Eager OOM</td></tr></tbody>',Ft,ut,Pt,mt,Nt='<thead><tr><th align="right">batch_size</th> <th align="right">seq_len</th> <th align="right">Per token latency eager (ms)</th> <th align="right">Per token latency SDPA (ms)</th> <th align="right">Speedup (%)</th> <th align="right">Mem eager (MB)</th> <th align="right">Mem BT (MB)</th> <th align="right">Mem saved (%)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">128</td> <td align="right">11.634</td> <td align="right">8.647</td> <td align="right">34.546</td> <td align="right">717.676</td> <td align="right">717.674</td> <td align="right">0</td></tr> <tr><td align="right">1</td> <td align="right">256</td> <td align="right">11.593</td> <td align="right">8.86</td> <td align="right">30.851</td> <td align="right">742.852</td> <td align="right">742.845</td> <td align="right">0.001</td></tr> <tr><td align="right">1</td> <td align="right">512</td> <td align="right">11.515</td> <td align="right">8.816</td> <td align="right">30.614</td> <td align="right">798.232</td> <td align="right">799.593</td> <td align="right">-0.17</td></tr> <tr><td align="right">1</td> <td align="right">1024</td> <td align="right">11.556</td> <td align="right">8.915</td> <td align="right">29.628</td> <td align="right">917.265</td> <td align="right">895.538</td> <td align="right">2.426</td></tr> <tr><td align="right">2</td> <td align="right">128</td> <td align="right">12.724</td> <td align="right">11.002</td> <td align="right">15.659</td> <td align="right">762.434</td> <td align="right">762.431</td> <td align="right">0</td></tr> <tr><td align="right">2</td> <td align="right">256</td> <td align="right">12.704</td> <td align="right">11.063</td> <td align="right">14.83</td> <td align="right">816.809</td> <td align="right">816.733</td> <td align="right">0.009</td></tr> <tr><td align="right">2</td> <td align="right">512</td> <td align="right">12.757</td> <td align="right">10.947</td> <td align="right">16.535</td> <td align="right">917.383</td> <td align="right">918.339</td> <td align="right">-0.104</td></tr> <tr><td align="right">2</td> <td align="right">1024</td> <td align="right">13.018</td> <td align="right">11.018</td> <td align="right">18.147</td> <td align="right">1162.65</td> <td align="right">1114.81</td> <td align="right">4.291</td></tr> <tr><td align="right">4</td> <td align="right">128</td> <td align="right">12.739</td> <td align="right">10.959</td> <td align="right">16.243</td> <td align="right">856.335</td> <td align="right">856.483</td> <td align="right">-0.017</td></tr> <tr><td align="right">4</td> <td align="right">256</td> <td align="right">12.718</td> <td align="right">10.837</td> <td align="right">17.355</td> <td align="right">957.298</td> <td align="right">957.674</td> <td align="right">-0.039</td></tr> <tr><td align="right">4</td> <td align="right">512</td> <td align="right">12.813</td> <td align="right">10.822</td> <td align="right">18.393</td> <td align="right">1158.44</td> <td align="right">1158.45</td> <td align="right">-0.001</td></tr> <tr><td align="right">4</td> <td align="right">1024</td> <td align="right">13.416</td> <td align="right">11.06</td> <td align="right">21.301</td> <td align="right">1653.42</td> <td align="right">1557.19</td> <td align="right">6.18</td></tr> <tr><td align="right">8</td> <td align="right">128</td> <td align="right">12.763</td> <td align="right">10.891</td> <td align="right">17.193</td> <td align="right">1036.13</td> <td align="right">1036.51</td> <td align="right">-0.036</td></tr> <tr><td align="right">8</td> <td align="right">256</td> <td align="right">12.89</td> <td align="right">11.104</td> <td align="right">16.085</td> <td align="right">1236.98</td> <td align="right">1236.87</td> <td align="right">0.01</td></tr> <tr><td align="right">8</td> <td align="right">512</td> <td align="right">13.327</td> <td align="right">10.939</td> <td align="right">21.836</td> <td align="right">1642.29</td> <td align="right">1641.78</td> <td align="right">0.031</td></tr> <tr><td align="right">8</td> <td align="right">1024</td> <td align="right">15.181</td> <td align="right">11.175</td> <td align="right">35.848</td> <td align="right">2634.98</td> <td align="right">2443.35</td> <td align="right">7.843</td></tr></tbody>',Jt,ht,zt,Ie,gt,It,vt,Vt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTModel">OPTModel</a>. It is used to instantiate a OPT model
according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the OPT
<a href="https://huggingface.co/facebook/opt-350m" rel="nofollow">facebook/opt-350m</a> architecture.`,qt,kt,Rt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Lt,it,Ot,lt,Ut,ft,Zt,jt,Wt;return h=new be({props:{title:"OPT",local:"opt",headingTag:"h1"}}),f=new be({props:{title:"Overview",local:"overview",headingTag:"h2"}}),G=new be({props:{title:"Resources",local:"resources",headingTag:"h2"}}),q=new Bt({props:{pipeline:"text-generation"}}),Z=new Bt({props:{pipeline:"text-classification"}}),Ce=new Bt({props:{pipeline:"question-answering"}}),Pe=new be({props:{title:"Combining OPT and Flash Attention 2",local:"combining-opt-and-flash-attention-2",headingTag:"h2"}}),we=new qe({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),A=new qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwT1BURm9yQ2F1c2FsTE0lMkMlMjBHUFQyVG9rZW5pemVyJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMCUyMyUyMHRoZSUyMGRldmljZSUyMHRvJTIwbG9hZCUyMHRoZSUyMG1vZGVsJTIwb250byUwQSUwQW1vZGVsJTIwJTNEJTIwT1BURm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAoJTIyQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjBodW1hbiUyMGFuZCUyMHRoZSUyMFN0YXR1ZSUyMG9mJTIwTGliZXJ0eS4lNUNuJTVDbkh1bWFuJTNBJTIwV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlNUNuU3RhdHVlJTNBJTIwSSUyMGFtJTIwdGhlJTIwJTIyJTBBJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QnByb21wdCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEFtb2RlbC50byhkZXZpY2UpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QzMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OPTForCausalLM, GPT2Tokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-comment"># the device to load the model onto</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>model = OPTForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (<span class="hljs-string">&quot;A chat between a curious human and the Statue of Liberty.\\n\\nHuman: What is your name?\\nStatue: I am the &quot;</span>
              <span class="hljs-string">&quot;Statue of Liberty.\\nHuman: Where do you live?\\nStatue: New York City.\\nHuman: How long have you lived &quot;</span>
              <span class="hljs-string">&quot;there?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">30</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;&lt;/s&gt;A chat between a curious human and the Statue of Liberty.\\n\\nHuman: What is your name?\\nStatue: I am the Statue of Liberty.\\nHuman: Where do you live?\\nStatue: New York City.\\nHuman: How long have you lived there?\\nStatue: I have lived here for about a year.\\nHuman: What is your favorite place to eat?\\nStatue: I love&#x27;</span>`,wrap:!1}}),Ne=new be({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),Ke=new be({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),ce=new qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9QVEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBPUFRGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJzZHBhJTIyKSUwQS4uLg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OPTForCausalLM
model = OPTForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>)
...`,wrap:!1}}),ct=new be({props:{title:"Training",local:"training",headingTag:"h3"}}),ut=new be({props:{title:"Inference",local:"inference",headingTag:"h3"}}),ht=new be({props:{title:"OPTConfig",local:"transformers.OPTConfig",headingTag:"h2"}}),gt=new ye({props:{name:"class transformers.OPTConfig",anchor:"transformers.OPTConfig",parameters:[{name:"vocab_size",val:" = 50272"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"ffn_dim",val:" = 3072"},{name:"max_position_embeddings",val:" = 2048"},{name:"do_layer_norm_before",val:" = True"},{name:"_remove_final_layer_norm",val:" = False"},{name:"word_embed_proj_dim",val:" = None"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"num_attention_heads",val:" = 12"},{name:"activation_function",val:" = 'relu'"},{name:"layerdrop",val:" = 0.0"},{name:"init_std",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 2"},{name:"eos_token_id",val:" = 2"},{name:"enable_bias",val:" = True"},{name:"layer_norm_elementwise_affine",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OPTConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 50272) &#x2014;
Vocabulary size of the OPT model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/opt#transformers.OPTModel">OPTModel</a>`,name:"vocab_size"},{anchor:"transformers.OPTConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.OPTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.OPTConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"ffn_dim"},{anchor:"transformers.OPTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.OPTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.OPTConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.OPTConfig.do_layer_norm_before",description:`<strong>do_layer_norm_before</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to perform layer normalization before the attention block.`,name:"do_layer_norm_before"},{anchor:"transformers.OPTConfig.word_embed_proj_dim",description:`<strong>word_embed_proj_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014;
<code>word_embed_proj_dim</code> can be set to down-project word embeddings, <em>e.g.</em> <code>opt-350m</code>. Defaults to
<code>hidden_size</code>.`,name:"word_embed_proj_dim"},{anchor:"transformers.OPTConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.OPTConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.OPTConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>) for more
details.`,name:"layerdrop"},{anchor:"transformers.OPTConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.OPTConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models).`,name:"use_cache"},{anchor:"transformers.OPTConfig.enable_bias",description:`<strong>enable_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not if the linear layers in the attention blocks should use the bias term.`,name:"enable_bias"},{anchor:"transformers.OPTConfig.layer_norm_elementwise_affine",description:`<strong>layer_norm_elementwise_affine</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not if the layer norms should have learnable parameters.`,name:"layer_norm_elementwise_affine"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/opt/configuration_opt.py#L24"}}),it=new et({props:{anchor:"transformers.OPTConfig.example",$$slots:{default:[tn]},$$scope:{ctx:F}}}),lt=new Kt({props:{pytorch:!0,tensorflow:!0,jax:!0,$$slots:{jax:[vn],tensorflow:[bn],pytorch:[un]},$$scope:{ctx:F}}}),ft=new en({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/opt.md"}}),{c(){t=c("meta"),g=i(),o=c("p"),a=i(),T(h.$$.fragment),n=i(),T(f.$$.fragment),Y=i(),z=c("p"),z.innerHTML=L,N=i(),P=c("p"),P.textContent=j,W=i(),k=c("p"),k.innerHTML=U,me=i(),E=c("p"),E.innerHTML=fe,R=i(),ae=c("p"),ae.textContent=V,_e=i(),B=c("ul"),B.innerHTML=D,H=i(),T(G.$$.fragment),X=i(),oe=c("p"),oe.textContent=he,K=i(),T(q.$$.fragment),Me=i(),O=c("ul"),O.innerHTML=ee,x=i(),T(Z.$$.fragment),S=i(),I=c("ul"),I.innerHTML=Q,je=i(),T(Ce.$$.fragment),re=i(),Fe=c("ul"),Fe.innerHTML=$,J=i(),te=c("p"),te.textContent=ne,le=i(),Ue=c("ul"),Ue.innerHTML=tt,de=i(),T(Pe.$$.fragment),ot=i(),ze=c("p"),ze.textContent=xt,st=i(),T(we.$$.fragment),at=i(),ve=c("p"),ve.textContent=_t,Ze=i(),Le=c("p"),Le.textContent=Ae,nt=i(),T(A.$$.fragment),Be=i(),T(Ne.$$.fragment),Ve=i(),Ye=c("p"),Ye.innerHTML=Tt,Re=i(),Se=c("div"),Se.innerHTML=bt,Ee=i(),De=c("p"),De.innerHTML=yt,Te=i(),ke=c("div"),ke.innerHTML=Mt,Xe=i(),T(Ke.$$.fragment),rt=i(),$e=c("p"),$e.innerHTML=wt,We=i(),He=c("p"),He.innerHTML=u,C=i(),T(ce.$$.fragment),Ge=i(),Je=c("p"),Je.innerHTML=ie,ge=i(),se=c("p"),se.innerHTML=Oe,dt=i(),T(ct.$$.fragment),Ct=i(),pt=c("table"),pt.innerHTML=Gt,Ft=i(),T(ut.$$.fragment),Pt=i(),mt=c("table"),mt.innerHTML=Nt,Jt=i(),T(ht.$$.fragment),zt=i(),Ie=c("div"),T(gt.$$.fragment),It=i(),vt=c("p"),vt.innerHTML=Vt,qt=i(),kt=c("p"),kt.innerHTML=Rt,Lt=i(),T(it.$$.fragment),Ot=i(),T(lt.$$.fragment),Ut=i(),T(ft.$$.fragment),Zt=i(),jt=c("p"),this.h()},l(e){const d=Dt("svelte-u9bgzb",document.head);t=p(d,"META",{name:!0,content:!0}),d.forEach(s),g=l(e),o=p(e,"P",{}),pe(o).forEach(s),a=l(e),b(h.$$.fragment,e),n=l(e),b(f.$$.fragment,e),Y=l(e),z=p(e,"P",{"data-svelte-h":!0}),_(z)!=="svelte-uv4l0c"&&(z.innerHTML=L),N=l(e),P=p(e,"P",{"data-svelte-h":!0}),_(P)!=="svelte-vfdo9a"&&(P.textContent=j),W=l(e),k=p(e,"P",{"data-svelte-h":!0}),_(k)!=="svelte-lygqbw"&&(k.innerHTML=U),me=l(e),E=p(e,"P",{"data-svelte-h":!0}),_(E)!=="svelte-1muftuv"&&(E.innerHTML=fe),R=l(e),ae=p(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-axv494"&&(ae.textContent=V),_e=l(e),B=p(e,"UL",{"data-svelte-h":!0}),_(B)!=="svelte-1bmdbn0"&&(B.innerHTML=D),H=l(e),b(G.$$.fragment,e),X=l(e),oe=p(e,"P",{"data-svelte-h":!0}),_(oe)!=="svelte-1uxlnve"&&(oe.textContent=he),K=l(e),b(q.$$.fragment,e),Me=l(e),O=p(e,"UL",{"data-svelte-h":!0}),_(O)!=="svelte-32kdey"&&(O.innerHTML=ee),x=l(e),b(Z.$$.fragment,e),S=l(e),I=p(e,"UL",{"data-svelte-h":!0}),_(I)!=="svelte-5gprd3"&&(I.innerHTML=Q),je=l(e),b(Ce.$$.fragment,e),re=l(e),Fe=p(e,"UL",{"data-svelte-h":!0}),_(Fe)!=="svelte-1j1azns"&&(Fe.innerHTML=$),J=l(e),te=p(e,"P",{"data-svelte-h":!0}),_(te)!=="svelte-1wntqpp"&&(te.textContent=ne),le=l(e),Ue=p(e,"UL",{"data-svelte-h":!0}),_(Ue)!=="svelte-jbh4b4"&&(Ue.innerHTML=tt),de=l(e),b(Pe.$$.fragment,e),ot=l(e),ze=p(e,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-o3pzzu"&&(ze.textContent=xt),st=l(e),b(we.$$.fragment,e),at=l(e),ve=p(e,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-enej3y"&&(ve.textContent=_t),Ze=l(e),Le=p(e,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-14hchid"&&(Le.textContent=Ae),nt=l(e),b(A.$$.fragment,e),Be=l(e),b(Ne.$$.fragment,e),Ve=l(e),Ye=p(e,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-1qq0atk"&&(Ye.innerHTML=Tt),Re=l(e),Se=p(e,"DIV",{style:!0,"data-svelte-h":!0}),_(Se)!=="svelte-zu70eq"&&(Se.innerHTML=bt),Ee=l(e),De=p(e,"P",{"data-svelte-h":!0}),_(De)!=="svelte-kfzpee"&&(De.innerHTML=yt),Te=l(e),ke=p(e,"DIV",{style:!0,"data-svelte-h":!0}),_(ke)!=="svelte-z4xso5"&&(ke.innerHTML=Mt),Xe=l(e),b(Ke.$$.fragment,e),rt=l(e),$e=p(e,"P",{"data-svelte-h":!0}),_($e)!=="svelte-1cid2pe"&&($e.innerHTML=wt),We=l(e),He=p(e,"P",{"data-svelte-h":!0}),_(He)!=="svelte-1x11lxg"&&(He.innerHTML=u),C=l(e),b(ce.$$.fragment,e),Ge=l(e),Je=p(e,"P",{"data-svelte-h":!0}),_(Je)!=="svelte-djb2w0"&&(Je.innerHTML=ie),ge=l(e),se=p(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-1qqo2fg"&&(se.innerHTML=Oe),dt=l(e),b(ct.$$.fragment,e),Ct=l(e),pt=p(e,"TABLE",{"data-svelte-h":!0}),_(pt)!=="svelte-1xonfn0"&&(pt.innerHTML=Gt),Ft=l(e),b(ut.$$.fragment,e),Pt=l(e),mt=p(e,"TABLE",{"data-svelte-h":!0}),_(mt)!=="svelte-6lf873"&&(mt.innerHTML=Nt),Jt=l(e),b(ht.$$.fragment,e),zt=l(e),Ie=p(e,"DIV",{class:!0});var Qe=pe(Ie);b(gt.$$.fragment,Qe),It=l(Qe),vt=p(Qe,"P",{"data-svelte-h":!0}),_(vt)!=="svelte-hz3o8c"&&(vt.innerHTML=Vt),qt=l(Qe),kt=p(Qe,"P",{"data-svelte-h":!0}),_(kt)!=="svelte-o55m63"&&(kt.innerHTML=Rt),Lt=l(Qe),b(it.$$.fragment,Qe),Qe.forEach(s),Ot=l(e),b(lt.$$.fragment,e),Ut=l(e),b(ft.$$.fragment,e),Zt=l(e),jt=p(e,"P",{}),pe(jt).forEach(s),this.h()},h(){ue(t,"name","hf:doc:metadata"),ue(t,"content",$n),Et(Se,"text-align","center"),Et(ke,"text-align","center"),ue(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){m(document.head,t),r(e,g,d),r(e,o,d),r(e,a,d),y(h,e,d),r(e,n,d),y(f,e,d),r(e,Y,d),r(e,z,d),r(e,N,d),r(e,P,d),r(e,W,d),r(e,k,d),r(e,me,d),r(e,E,d),r(e,R,d),r(e,ae,d),r(e,_e,d),r(e,B,d),r(e,H,d),y(G,e,d),r(e,X,d),r(e,oe,d),r(e,K,d),y(q,e,d),r(e,Me,d),r(e,O,d),r(e,x,d),y(Z,e,d),r(e,S,d),r(e,I,d),r(e,je,d),y(Ce,e,d),r(e,re,d),r(e,Fe,d),r(e,J,d),r(e,te,d),r(e,le,d),r(e,Ue,d),r(e,de,d),y(Pe,e,d),r(e,ot,d),r(e,ze,d),r(e,st,d),y(we,e,d),r(e,at,d),r(e,ve,d),r(e,Ze,d),r(e,Le,d),r(e,nt,d),y(A,e,d),r(e,Be,d),y(Ne,e,d),r(e,Ve,d),r(e,Ye,d),r(e,Re,d),r(e,Se,d),r(e,Ee,d),r(e,De,d),r(e,Te,d),r(e,ke,d),r(e,Xe,d),y(Ke,e,d),r(e,rt,d),r(e,$e,d),r(e,We,d),r(e,He,d),r(e,C,d),y(ce,e,d),r(e,Ge,d),r(e,Je,d),r(e,ge,d),r(e,se,d),r(e,dt,d),y(ct,e,d),r(e,Ct,d),r(e,pt,d),r(e,Ft,d),y(ut,e,d),r(e,Pt,d),r(e,mt,d),r(e,Jt,d),y(ht,e,d),r(e,zt,d),r(e,Ie,d),y(gt,Ie,null),m(Ie,It),m(Ie,vt),m(Ie,qt),m(Ie,kt),m(Ie,Lt),y(it,Ie,null),r(e,Ot,d),y(lt,e,d),r(e,Ut,d),y(ft,e,d),r(e,Zt,d),r(e,jt,d),Wt=!0},p(e,[d]){const Qe={};d&2&&(Qe.$$scope={dirty:d,ctx:e}),it.$set(Qe);const St={};d&2&&(St.$$scope={dirty:d,ctx:e}),lt.$set(St)},i(e){Wt||(M(h.$$.fragment,e),M(f.$$.fragment,e),M(G.$$.fragment,e),M(q.$$.fragment,e),M(Z.$$.fragment,e),M(Ce.$$.fragment,e),M(Pe.$$.fragment,e),M(we.$$.fragment,e),M(A.$$.fragment,e),M(Ne.$$.fragment,e),M(Ke.$$.fragment,e),M(ce.$$.fragment,e),M(ct.$$.fragment,e),M(ut.$$.fragment,e),M(ht.$$.fragment,e),M(gt.$$.fragment,e),M(it.$$.fragment,e),M(lt.$$.fragment,e),M(ft.$$.fragment,e),Wt=!0)},o(e){w(h.$$.fragment,e),w(f.$$.fragment,e),w(G.$$.fragment,e),w(q.$$.fragment,e),w(Z.$$.fragment,e),w(Ce.$$.fragment,e),w(Pe.$$.fragment,e),w(we.$$.fragment,e),w(A.$$.fragment,e),w(Ne.$$.fragment,e),w(Ke.$$.fragment,e),w(ce.$$.fragment,e),w(ct.$$.fragment,e),w(ut.$$.fragment,e),w(ht.$$.fragment,e),w(gt.$$.fragment,e),w(it.$$.fragment,e),w(lt.$$.fragment,e),w(ft.$$.fragment,e),Wt=!1},d(e){e&&(s(g),s(o),s(a),s(n),s(Y),s(z),s(N),s(P),s(W),s(k),s(me),s(E),s(R),s(ae),s(_e),s(B),s(H),s(X),s(oe),s(K),s(Me),s(O),s(x),s(S),s(I),s(je),s(re),s(Fe),s(J),s(te),s(le),s(Ue),s(de),s(ot),s(ze),s(st),s(at),s(ve),s(Ze),s(Le),s(nt),s(Be),s(Ve),s(Ye),s(Re),s(Se),s(Ee),s(De),s(Te),s(ke),s(Xe),s(rt),s($e),s(We),s(He),s(C),s(Ge),s(Je),s(ge),s(se),s(dt),s(Ct),s(pt),s(Ft),s(Pt),s(mt),s(Jt),s(zt),s(Ie),s(Ot),s(Ut),s(Zt),s(jt)),s(t),v(h,e),v(f,e),v(G,e),v(q,e),v(Z,e),v(Ce,e),v(Pe,e),v(we,e),v(A,e),v(Ne,e),v(Ke,e),v(ce,e),v(ct,e),v(ut,e),v(ht,e),v(gt),v(it),v(lt,e),v(ft,e)}}}const $n='{"title":"OPT","local":"opt","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Combining OPT and Flash Attention 2","local":"combining-opt-and-flash-attention-2","sections":[{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Inference","local":"inference","sections":[],"depth":3}],"depth":2},{"title":"OPTConfig","local":"transformers.OPTConfig","sections":[],"depth":2},{"title":"OPTModel","local":"transformers.OPTModel","sections":[],"depth":2},{"title":"OPTForCausalLM","local":"transformers.OPTForCausalLM","sections":[],"depth":2},{"title":"OPTForSequenceClassification","local":"transformers.OPTForSequenceClassification","sections":[],"depth":2},{"title":"OPTForQuestionAnswering","local":"transformers.OPTForQuestionAnswering","sections":[],"depth":2},{"title":"TFOPTModel","local":"transformers.TFOPTModel","sections":[],"depth":2},{"title":"TFOPTForCausalLM","local":"transformers.TFOPTForCausalLM","sections":[],"depth":2},{"title":"FlaxOPTModel","local":"transformers.FlaxOPTModel","sections":[],"depth":2},{"title":"FlaxOPTForCausalLM","local":"transformers.FlaxOPTForCausalLM","sections":[],"depth":2}],"depth":1}';function xn(F){return Qt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends At{constructor(t){super(),Yt(this,t,xn,kn,Xt,{})}}export{Wn as component};
