import{s as ta,o as sa,n as hs}from"../chunks/scheduler.25b97de1.js";import{S as aa,i as na,g as o,s as n,r,A as la,h as c,f as s,c as l,j as ps,u as h,x as i,k as ea,y as w,a,v as m,d,t as u,w as y}from"../chunks/index.d9030fc9.js";import{T as rs}from"../chunks/Tip.baa67368.js";import{C as b}from"../chunks/CodeBlock.e6cd0d95.js";import{H as T,E as oa}from"../chunks/EditOnGithub.91d95064.js";function ca(U){let p,j="One important concept you need to know when writing your own generation loop, is <code>cache_position</code>. In case you want to reuse an already filled Cache object by calling <code>forward()</code>, you have to pass in a valid <code>cache_position</code> which will indicate the positions of inputs in the sequence. Note that <code>cache_position</code> is not affected by padding, and always adds one more position for each token. For example, if key/value cache contains 10 tokens (no matter how many of it is a pad token), the cache position for the next token should be <code>torch.tensor([10])</code>.";return{c(){p=o("p"),p.innerHTML=j},l(M){p=c(M,"P",{"data-svelte-h":!0}),i(p)!=="svelte-fyl20k"&&(p.innerHTML=j)},m(M,f){a(M,p,f)},p:hs,d(M){M&&s(p)}}}function ia(U){let p,j="Cache quantization can be detrimental in terms of latency if the context length is short and there is enough GPU VRAM available to run without cache quantization. It is recommended to seek balance between memory efficiency and latency.";return{c(){p=o("p"),p.textContent=j},l(M){p=c(M,"P",{"data-svelte-h":!0}),i(p)!=="svelte-46etli"&&(p.textContent=j)},m(M,f){a(M,p,f)},p:hs,d(M){M&&s(p)}}}function pa(U){let p,j="Cache offloading requires a CUDA GPU and can be slower than dynamic KV cache. Use it if you are getting CUDA out of memory errors.";return{c(){p=o("p"),p.textContent=j},l(M){p=c(M,"P",{"data-svelte-h":!0}),i(p)!=="svelte-82c9ia"&&(p.textContent=j)},m(M,f){a(M,p,f)},p:hs,d(M){M&&s(p)}}}function ra(U){let p,j,M,f,Z,Ee,G,ms=`Efficient caching is crucial for optimizing the performance of models in various generative tasks,
including text generation, translation, summarization and other transformer-based applications.
Effective caching helps reduce computation time and improve response rates, especially in real-time or resource-intensive applications.`,$e,v,ds=`Transformers support various caching methods, leveraging “Cache” classes to abstract and manage the caching logic.
This document outlines best practices for using these classes to maximize performance and efficiency.
Check out all the available <code>Cache</code> classes in the <a href="./internal/generation_utils">API documentation</a>.`,qe,B,Se,V,us="Imagine you’re having a conversation with someone, and instead of remembering what was said previously, you have to start from scratch every time you respond. This would be slow and inefficient, right? In the world of Transformer models, a similar concept applies, and that’s where Caching keys and values come into play. From now on, I’ll refer to the concept as KV Cache.",Le,X,ys="KV cache is needed to optimize the generation in autoregressive models, where the model predicts text token by token. This process can be slow since the model can generate only one token at a time, and each new prediction is dependent on the previous context. That means, to predict token number 1000 in the generation, you need information from the previous 999 tokens, which comes in the form of some matrix multiplications across the representations of those tokens. But to predict token number 1001, you also need the same information from the first 999 tokens, plus additional information from token number 1000. That is where key-value cache is used to optimize the sequential generation process by storing previous calculations to reuse in subsequent tokens, so they don’t need to be computed again.",Ae,W,Ms="More concretely, key-value cache acts as a memory bank for these generative models, where the model stores key-value pairs derived from self-attention layers for previously processed tokens. By storing this information, the model can avoid redundant computations and instead retrieve keys and values of previous tokens from the cache. Note that caching can be used only in inference and should be disabled when training, otherwise it might cause unexpected errors.",De,g,Ye,gs="<em>For the Curious Minds Who Like to Dive Deep</em>",ts,_,ss,ze,Js="When utilizing a cache object in the input, the Attention module performs several critical steps to integrate past and present information seamlessly.",as,Qe,Ts="The Attention module concatenates the current key-values with the past key-values stored in the cache. This results in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>. Essentially, the past and current key-values are combined to compute attention scores, ensuring that the model considers both previous context and new input. The concatenated key-values are used to compute the attention scores resulting in attention weights of shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>.",ns,xe,ws="Therefore, when iteratively calling <code>forward()</code> instead of the <code>generate()</code> method, it’s crucial to ensure that the attention mask shape matches the combined length of past and current key-values. The attention mask should have the shape <code>(batch_size, past_kv_length + new_tokens_length)</code>. This is usually handled internally when you call <code>generate()</code> method. If you want to implement your own generation loop with Cache classes, take this into consideration and prepare the attention mask to hold values to current and past tokens.",ls,k,os,Fe,js="See an example below for how to implement your own generation loop.",cs,R,is,N,Ke,Y,Pe,z,bs=`In 🤗 Transformers, we support various Cache types to optimize the performance across different models and tasks. By default, all models generate with caching,
with the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">~DynamicCache</a> class being the default cache for most models. It allows us to dynamically grow cache size, by saving more and more keys and values as we generate. If for some reason you don’t want to use caches, you can pass <code>use_cache=False</code> into the <code>generate()</code> method.`,Oe,Q,fs="Refer to the table below to see the difference between cache types and choose the one that suits best for your use-case. Models for which initialization is recommended should be initialized before calling the model and passed to model as a kwarg. In all other cases you can simply define desired <code>cache_implementation</code> and we take care of the rest for you.",et,x,Us="<thead><tr><th>Cache Type</th> <th>Memory Efficient</th> <th>Supports torch.compile()</th> <th>Initialization Recommended</th> <th>Latency</th> <th>Long Context Generation</th></tr></thead> <tbody><tr><td>Dynamic Cache</td> <td>No</td> <td>No</td> <td>No</td> <td>Mid</td> <td>No</td></tr> <tr><td>Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Offloaded Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Offloaded Static Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>Yes</td></tr> <tr><td>Quantized Cache</td> <td>Yes</td> <td>No</td> <td>No</td> <td>Low</td> <td>Yes</td></tr> <tr><td>Sliding Window Cache</td> <td>No</td> <td>Yes</td> <td>Yes</td> <td>High</td> <td>No</td></tr> <tr><td>Sink Cache</td> <td>Yes</td> <td>No</td> <td>Yes</td> <td>Mid</td> <td>Yes</td></tr></tbody>",tt,F,ks='These cache classes can be set with a <code>cache_implementation</code> argument when generating. To learn about the available options for the cache_implementation flag, please refer to the <a href="./main_classes/text_generation#transformers.GenerationConfig">API Documentation</a>. Now, let’s explore each cache type in detail and see how to use them. Note that the below examples are for decoder-only Tranformer-based models. We also support [“Model-Specific Cache”] classes for models such as Mamba or Jamba, keep reading for more details.',st,H,at,E,Cs=`The key and value cache can occupy a large portion of memory, becoming a <a href="https://huggingface.co/blog/llama31#inference-memory-requirements" rel="nofollow">bottleneck for long-context generation</a>, especially for Large Language Models.
Quantizing the cache when using <code>generate()</code> can significantly reduce memory requirements at the cost of speed.`,nt,$,Is='KV Cache quantization in <code>transformers</code> is largely inspired by the paper <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">“KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache”</a> and currently supports <a href="/docs/transformers/main/en/internal/generation_utils#transformers.QuantoQuantizedCache">~QuantoQuantizedCache</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.HQQQuantizedCache">~HQQQuantizedCache</a> classes. For more information on the inner workings see the paper.',lt,q,Zs=`To enable quantization of the key-value cache, one needs to indicate <code>cache_implementation=&quot;quantized&quot;</code> in the <code>generation_config</code>.
Quantization related arguments should be passed to the <code>generation_config</code> either as a <code>dict</code> or an instance of a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a> class.
One has to indicate which quantization backend to use in the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.QuantizedCacheConfig">~QuantizedCacheConfig</a>, the default is <code>quanto</code>.`,ot,S,Gs="It is recommended to set <code>axis-key/axis-value</code> parameters in the cache config to <code>0</code> if you’re using the <code>quanto</code> backend and to <code>1</code> if you’re using the <code>HQQ</code> backend. For other config values, please use the defaults unless you’re running out of memory. In that case, you may consider decreasing the residual length.",ct,C,it,L,pt,A,rt,D,vs=`Similarly to KV cache quantization, <a href="/docs/transformers/main/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> strategy aims to reduce GPU VRAM usage.
It does so by moving the KV cache for most layers to the CPU.
As the model’s <code>forward()</code> method iterates over the layers, this strategy maintains the current layer cache on the GPU.
At the same time it asynchronously prefetches the next layer cache as well as sending the previous layer cache back to the CPU.
Unlike KV cache quantization, this strategy always produces the same result as the default KV cache implementation.
Thus, it can serve as a drop-in replacement or a fallback for it.`,ht,K,Bs=`Depending on your model and the characteristics of your generation task (size of context, number of generated tokens, number of beams, etc.)
you may notice a small degradation in generation throughput compared to the default KV cache implementation.`,mt,P,Vs=`To enable KV cache offloading, pass <code>cache_implementation=&quot;offloaded&quot;</code> in the <code>generation_config</code> or directly to the <code>generate()</code> call.
Use <code>cache_implementation=&quot;offloaded_static&quot;</code> for an offloaded static cache (see also <a href="#offloaded-static-cache">Offloaded Static Cache</a> below).`,dt,O,ut,I,yt,ee,Xs="The example below shows how KV cache offloading can be used as a fallback strategy.",Mt,te,gt,se,Ws="On a GPU with 50 GB of RAM, running this code will print",Jt,ae,Tt,ne,_s="before successfully generating 40 beams.",wt,le,jt,oe,Rs=`Since the “DynamicCache” dynamically grows with each generation step, it prevents you from taking advantage of JIT optimizations. The <a href="/docs/transformers/main/en/internal/generation_utils#transformers.StaticCache">~StaticCache</a> pre-allocates
a specific maximum size for the keys and values, allowing you to generate up to the maximum length without having to modify cache size. Check the below usage example.`,bt,ce,Ns='For more examples with Static Cache and JIT compilation, take a look at <a href="./llm_optims#static-kv-cache-and-torchcompile">StaticCache &amp; torchcompile</a>',ft,ie,Ut,pe,kt,re,Ys=`Like <a href="/docs/transformers/main/en/internal/generation_utils#transformers.OffloadedCache">~OffloadedCache</a> exists for offloading a “DynamicCache”, there is also an offloaded static cache. It fully supports
JIT optimizations. Just pass <code>cache_implementation=&quot;offloaded_static&quot;</code> in the <code>generation_config</code> or directly to the <code>generate()</code> call.
This will use the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.OffloadedStaticCache">~OffloadedStaticCache</a> implementation instead.`,Ct,he,It,me,zs="Cache offloading requires a CUDA GPU.",Zt,de,Gt,ue,Qs="As the name suggests, this cache type implements a sliding window over previous keys and values, retaining only the last <code>sliding_window</code> tokens. It should be used with models like Mistral that support sliding window attention. Additionally, similar to Static Cache, this one is JIT-friendly and can be used with the same compile tecniques as Static Cache.",vt,ye,xs="Note that you can use this cache only for models that support sliding window, e.g. Mistral models.",Bt,Me,Vt,ge,Xt,Je,Fs='Sink Cache was introduced in <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">“Efficient Streaming Language Models with Attention Sinks”</a>. It allows you to generate long sequences of text (“infinite length” according to the paper) without any fine-tuning. That is achieved by smart handling of previous keys and values, specifically it retains a few initial tokens from the sequence, called “sink tokens”. This is based on the observation that these initial tokens attract a significant portion of attention scores during the generation process. Tokens that come after “sink tokens” are discarded on a sliding windowed basis, keeping only the latest <code>window_size</code> tokens. By keeping these initial tokens as “attention sinks,” the model maintains stable performance even when dealing with very long texts, thus discarding most of the previous knowledge.',Wt,Te,Hs="Unlike other cache classes, this one can’t be used directly by indicating a <code>cache_implementation</code>. You have to initialize the Cache before calling on <code>generate()</code> as follows.",_t,we,Rt,je,Nt,be,Es='The <a href="/docs/transformers/main/en/internal/generation_utils#transformers.EncoderDecoderCache">~EncoderDecoderCache</a> is a wrapper designed to handle the caching needs of encoder-decoder models. This cache type is specifically built to manage both self-attention and cross-attention caches, ensuring storage and retrieval of past key/values required for these complex models. Cool thing about Encoder-Decoder Cache is that you can set different cache types for the encoder and for the decoder, depending on your use case. Currently this cache is only supported in <a href="./model_doc/whisper">Whisper</a> models but we will be adding more models soon.',Yt,fe,$s="In terms of usage, there is nothing special to be done and calling <code>generate()</code> or <code>forward()</code> will handle everything for you.",zt,Ue,Qt,ke,qs='Some models require storing previous keys, values, or states in a specific way, and the above cache classes cannot be used. For such cases, we have several specialized cache classes that are designed for specific models. These models only accept their own dedicated cache classes and do not support using any other cache types. Some examples include <a href="/docs/transformers/main/en/internal/generation_utils#transformers.HybridCache">~HybridCache</a> for <a href="./model_doc/gemma2">Gemma2</a> series models or <a href="/docs/transformers/main/en/internal/generation_utils#transformers.MambaCache">~MambaCache</a> for <a href="./model_doc/mamba">Mamba</a> architecture models.',xt,Ce,Ft,Ie,Ss="We have seen how to use each of the cache types when generating. What if you want to use cache in iterative generation setting, for example in applications like chatbots, where interactions involve multiple turns and continuous back-and-forth exchanges. Iterative generation with cache allows these systems to handle ongoing conversations effectively without reprocessing the entire context at each step. But there are some tips that you should know before you start implementing:",Ht,Ze,Ls='The general format when doing iterative generation is as below. First you have to initialize an empty cache of the type you want, and you can start feeding in new prompts iteratively. Keeping track of dialogues history and formatting can be done with chat templates, read more on that in <a href="./chat_templating">chat_templating</a>',Et,Ge,As="In case you are using Sink Cache, you have to crop your inputs to that maximum length because Sink Cache can generate text longer than its maximum window size, but it expects the first input to not exceed the maximum cache length.",$t,ve,qt,Be,St,Ve,Ds="Sometimes you would want to first fill-in cache object with key/values for certain prefix prompt and re-use it several times to generate different sequences from it. In that case you can construct a <code>Cache</code> object that will hold the instruction prompt, and re-use it several times with different text sequences.",Lt,Xe,At,We,Dt,_e,Ks=`Prior to the introduction of the <code>Cache</code> object, the cache of LLMs used to be a tuple of tuples of tensors. The legacy
format has a dynamic size, growing as we generate text — very similar to <code>DynamicCache</code>. If your project depend on
this legacy format, you can seamlessly convert it to a <code>DynamicCache</code> and back.`,Kt,Re,Pt,Ne,Ot,He,es;return Z=new T({props:{title:"Best Practices for Generation with Cache",local:"best-practices-for-generation-with-cache",headingTag:"h1"}}),B=new T({props:{title:"What is Cache and why we should care?",local:"what-is-cache-and-why-we-should-care",headingTag:"h2"}}),_=new T({props:{title:"Under the Hood: How Cache Object Works in Attention Mechanism",local:"under-the-hood-how-cache-object-works-in-attention-mechanism",headingTag:"h3"}}),k=new rs({props:{warning:!0,$$slots:{default:[ca]},$$scope:{ctx:U}}}),R=new b({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name.&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = inputs.input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_position = torch.arange(inputs.input_ids.shape[<span class="hljs-number">1</span>], dtype=torch.int64, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>max_new_tokens = <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_new_tokens):
<span class="hljs-meta">... </span>    outputs = model(**inputs, cache_position=cache_position, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Greedily sample one next token</span>
<span class="hljs-meta">... </span>    next_token_ids = outputs.logits[:, -<span class="hljs-number">1</span>:].argmax(-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    generated_ids = torch.cat([generated_ids, next_token_ids], dim=-<span class="hljs-number">1</span>)
...
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare inputs for the next generation step by leaaving unprocessed tokens, in our case we have only one new token</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># and expanding attn mask for the new token, as explained above</span>
<span class="hljs-meta">... </span>    attention_mask = inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
<span class="hljs-meta">... </span>    attention_mask = torch.cat([attention_mask, attention_mask.new_ones((attention_mask.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>))], dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    inputs = {<span class="hljs-string">&quot;input_ids&quot;</span>: next_token_ids, <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask}
<span class="hljs-meta">... </span>    cache_position = cache_position[-<span class="hljs-number">1</span>:] + <span class="hljs-number">1</span> <span class="hljs-comment"># add one more position for the next token</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])`,wrap:!1}}),N=new b({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwd2hhdCdzJTIweW91ciUyMG5hbWUuJTIwJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBTXklMjBuYW1lJTIwaXMlMjBTYXJhaC4lMjAlMEElM0MlN0M=",highlighted:`&lt;|user|&gt;
Hello, what&#x27;s your name. 
&lt;|assistant|&gt;
My name is Sarah. 
&lt;|`,wrap:!1}}),Y=new T({props:{title:"Generate with Cache",local:"generate-with-cache",headingTag:"h2"}}),H=new T({props:{title:"Quantized Cache",local:"quantized-cache",headingTag:"h3"}}),C=new rs({props:{warning:!0,$$slots:{default:[ia]},$$scope:{ctx:U}}}),L=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyVGlueUxsYW1hJTJGVGlueUxsYW1hLTEuMUItQ2hhdC12MS4wJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlRpbnlMbGFtYSUyRlRpbnlMbGFtYS0xLjFCLUNoYXQtdjEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUzQTAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkklMjBsaWtlJTIwcm9jayUyMG11c2ljJTIwYmVjYXVzZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSklMEElMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIycXVhbnRpemVkJTIyJTJDJTIwY2FjaGVfY29uZmlnJTNEJTdCJTIybmJpdHMlMjIlM0ElMjA0JTJDJTIwJTIyYmFja2VuZCUyMiUzQSUyMCUyMnF1YW50byUyMiU3RCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I like rock music because&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;quantized&quot;</span>, cache_config={<span class="hljs-string">&quot;nbits&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;backend&quot;</span>: <span class="hljs-string">&quot;quanto&quot;</span>})
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I like rock music because it<span class="hljs-string">&#x27;s a great way to express myself. I like the way it makes me feel, the</span>`,wrap:!1}}),A=new T({props:{title:"Offloaded Cache",local:"offloaded-cache",headingTag:"h3"}}),O=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBY2twdCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChja3B0KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNrcHQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElM0EwJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJGdW4lMjBmYWN0JTNBJTIwVGhlJTIwc2hvcnRlc3QlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMm9mZmxvYWRlZCUyMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Fun fact: The shortest&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>, cache_implementation=<span class="hljs-string">&quot;offloaded&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">23</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Fun fact: The shortest war <span class="hljs-keyword">in</span> history was between Britain <span class="hljs-keyword">and</span> Zanzibar on August <span class="hljs-number">27</span>, <span class="hljs-number">1896.</span>`,wrap:!1}}),I=new rs({props:{warning:!0,$$slots:{default:[pa]},$$scope:{ctx:U}}}),te=new b({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">resilient_generate</span>(<span class="hljs-params">model, *args, **kwargs</span>):
<span class="hljs-meta">... </span>    oom = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> torch.cuda.OutOfMemoryError <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(e)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;retrying with cache_implementation=&#x27;offloaded&#x27;&quot;</span>)
<span class="hljs-meta">... </span>        oom = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> oom:
<span class="hljs-meta">... </span>        torch.cuda.empty_cache()
<span class="hljs-meta">... </span>        kwargs[<span class="hljs-string">&quot;cache_implementation&quot;</span>] = <span class="hljs-string">&quot;offloaded&quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> model.generate(*args, **kwargs)
...
...
<span class="hljs-meta">&gt;&gt;&gt; </span>ckpt = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(ckpt, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [<span class="hljs-string">&quot;okay &quot;</span>*<span class="hljs-number">1000</span> + <span class="hljs-string">&quot;Fun fact: The most&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
<span class="hljs-meta">&gt;&gt;&gt; </span>beams = { <span class="hljs-string">&quot;num_beams&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_beam_groups&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">40</span>, <span class="hljs-string">&quot;diversity_penalty&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">23</span>, <span class="hljs-string">&quot;early_stopping&quot;</span>: <span class="hljs-literal">True</span>, }
<span class="hljs-meta">&gt;&gt;&gt; </span>out = resilient_generate(model, **inputs, **beams)
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = tokenizer.batch_decode(out[:,-<span class="hljs-number">28</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),ae=new b({props:{code:"Q1VEQSUyMG91dCUyMG9mJTIwbWVtb3J5LiUyMFRyaWVkJTIwdG8lMjBhbGxvY2F0ZSUyMDQuODMlMjBHaUIuJTIwR1BVJTBBcmV0cnlpbmclMjB3aXRoJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0Qnb2ZmbG9hZGVkJw==",highlighted:`CUDA <span class="hljs-keyword">out</span> <span class="hljs-keyword">of</span> memory. Tried <span class="hljs-keyword">to</span> allocate <span class="hljs-number">4.83</span> GiB. GPU
retrying <span class="hljs-keyword">with</span> cache_implementation=<span class="hljs-string">&#x27;offloaded&#x27;</span>`,wrap:!1}}),le=new T({props:{title:"Static Cache",local:"static-cache",headingTag:"h3"}}),ie=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyVGlueUxsYW1hJTJGVGlueUxsYW1hLTEuMUItQ2hhdC12MS4wJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlRpbnlMbGFtYSUyRlRpbnlMbGFtYS0xLjFCLUNoYXQtdjEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMHNpbXBseSUyMHBhc3MlMjB0aGUlMjBjYWNoZSUyMGltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMnN0YXRpYyUyMiklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name] and I am a [Your Position] at [Your Company]. I am writing&quot;</span>`,wrap:!1}}),pe=new T({props:{title:"Offloaded Static Cache",local:"offloaded-static-cache",headingTag:"h2"}}),he=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwc2ltcGx5JTIwcGFzcyUyMHRoZSUyMGNhY2hlJTIwaW1wbGVtZW50YXRpb24lM0QlMjJvZmZsb2FkZWRfc3RhdGljJTIyJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAlMkMlMjBjYWNoZV9pbXBsZW1lbnRhdGlvbiUzRCUyMm9mZmxvYWRlZF9zdGF0aWMlMjIpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># simply pass the cache implementation=&quot;offloaded_static&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">20</span>, cache_implementation=<span class="hljs-string">&quot;offloaded_static&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hello, my name is [Your Name], and I am a [Your Profession] with [Number of Years] of&quot;</span>`,wrap:!1}}),de=new T({props:{title:"Sliding Window Cache",local:"sliding-window-cache",headingTag:"h3"}}),Me=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydGVrbml1bSUyRk9wZW5IZXJtZXMtMi41LU1pc3RyYWwtN0IlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIydGVrbml1bSUyRk9wZW5IZXJtZXMtMi41LU1pc3RyYWwtN0IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElM0EwJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJZZXN0ZXJkYXklMjBJJTIwd2FzJTIwb24lMjBhJTIwcm9jayUyMGNvbmNlcnQlMjBhbmQuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMGNhbiUyMGJlJTIwdXNlZCUyMGJ5JTIwcGFzc2luZyUyMGluJTIwY2FjaGUlMjBpbXBsZW1lbnRhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzbGlkaW5nX3dpbmRvdyUyMiklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;teknium/OpenHermes-2.5-Mistral-7B&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;teknium/OpenHermes-2.5-Mistral-7B&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Yesterday I was on a rock concert and.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># can be used by passing in cache implementation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, cache_implementation=<span class="hljs-string">&quot;sliding_window&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Yesterday I was on a rock concert and. I was so excited to see my favorite band perform live. I was so happy that I could hardly contain myself. I was jumping up and down and&quot;</span>`,wrap:!1}}),ge=new T({props:{title:"Sink Cache",local:"sink-cache",headingTag:"h3"}}),we=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwU2lua0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyVGlueUxsYW1hJTJGVGlueUxsYW1hLTEuMUItQ2hhdC12MS4wJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlRpbnlMbGFtYSUyRlRpbnlMbGFtYS0xLjFCLUNoYXQtdjEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUzQTAlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwc3RvcnklMjBhYm91dCUyMHVuaWNvcm5zJTJDJTIwZmFpcmllcyUyMGFuZCUyMG1hZ2ljLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSklMEElMEElMjMlMjBnZXQlMjBvdXIlMjBjYWNoZSUyQyUyMHNwZWNpZnklMjBudW1iZXIlMjBvZiUyMHNpbmslMjB0b2tlbnMlMjBhbmQlMjB3aW5kb3clMjBzaXplJTBBJTIzJTIwTm90ZSUyMHRoYXQlMjB3aW5kb3clMjBzaXplJTIwYWxyZWFkeSUyMGluY2x1ZGVzJTIwc2luayUyMHRva2VucyUyQyUyMHNvJTIwaGFzJTIwdG8lMjBiZSUyMGxhcmdlciUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzREZhbHNlJTJDJTIwbWF4X25ld190b2tlbnMlM0QzMCUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get our cache, specify number of sink tokens and window size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that window size already includes sink tokens, so has to be larger</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">30</span>, past_key_values=past_key_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;This is a long story about unicorns, fairies and magic. It is a story about a young girl named Lily who discovers that she has the power to control the elements. She learns that she can&quot;</span>`,wrap:!1}}),je=new T({props:{title:"Encoder-Decoder Cache",local:"encoder-decoder-cache",headingTag:"h3"}}),Ue=new T({props:{title:"Model-specific Cache Classes",local:"model-specific-cache-classes",headingTag:"h3"}}),Ce=new T({props:{title:"Iterative Generation with Cache",local:"iterative-generation-with-cache",headingTag:"h2"}}),ve=new b({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer,AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.cache_utils <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>   DynamicCache,
<span class="hljs-meta">... </span>   SinkCache,
<span class="hljs-meta">... </span>   StaticCache,
<span class="hljs-meta">... </span>   SlidingWindowCache,
<span class="hljs-meta">... </span>   QuantoQuantizedCache,
<span class="hljs-meta">... </span>   QuantizedCacheConfig,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&#x27;auto&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span>user_prompts = [<span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>, <span class="hljs-string">&quot;Btw, yesterday I was on a rock concert.&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>max_cache_length = past_key_values.get_max_cache_shape()

<span class="hljs-meta">&gt;&gt;&gt; </span>messages = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> user_prompts:
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt})
<span class="hljs-meta">... </span>    inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(model.device)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(past_key_values, SinkCache):
<span class="hljs-meta">... </span>        inputs = {k: v[:, -max_cache_length:] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
...
<span class="hljs-meta">... </span>    input_length = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
...
<span class="hljs-meta">... </span>    outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">256</span>, past_key_values=past_key_values)
<span class="hljs-meta">... </span>    completion = tokenizer.decode(outputs[<span class="hljs-number">0</span>, input_length: ], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: completion})

<span class="hljs-built_in">print</span>(messages)
[{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name?&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;Hello, I&#x27;m AI.&quot;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;Btw, yesterday I was on a rock concert.&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&quot;I&#x27;m sorry to hear that you were on a rock concert yesterday. It sounds like a fun experience, but I&#x27;m not capable of experiencing music or concerts. However, I can provide you with some information about rock music and its history. Rock music emerged in the 1950s and 1960s in the United States and Britain, and it quickly gained popularity around the world. Some of the most famous rock bands of all time include The Beatles, The Rolling Stones, Led Zeppelin, and Pink Floyd. Rock music has a distinct sound and style, with elements of blues, country, and folk music. It often features guitar solos, heavy bass lines, and drums. Rock music has had a significant impact on popular culture, influencing genres such as punk rock, heavy metal, and alternative rock.&quot;</span>}]`,wrap:!1}}),Be=new T({props:{title:"Re-use Cache to continue generation",local:"re-use-cache-to-continue-generation",headingTag:"h2"}}),Xe=new b({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> copy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, DynamicCache, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Init StaticCache with big enough max-length (1024 tokens for the below example)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also init a DynamicCache, if that suits you better</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_cache = StaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=<span class="hljs-number">1024</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>INITIAL_PROMPT = <span class="hljs-string">&quot;You are a helpful assistant. &quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs_initial_prompt = tokenizer(INITIAL_PROMPT, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This is the common prompt cached, we need to run forward without grad to be abel to copy</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>     prompt_cache = model(**inputs_initial_prompt, past_key_values = prompt_cache).past_key_values

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [<span class="hljs-string">&quot;Help me to write a blogpost about travelling.&quot;</span>, <span class="hljs-string">&quot;What is the capital of France?&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>responses = []
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> prompt <span class="hljs-keyword">in</span> prompts:
<span class="hljs-meta">... </span>    new_inputs = tokenizer(INITIAL_PROMPT + prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">... </span>    past_key_values = copy.deepcopy(prompt_cache)
<span class="hljs-meta">... </span>    outputs = model.generate(**new_inputs, past_key_values=past_key_values,max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">... </span>    response = tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    responses.append(response)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(responses)
[<span class="hljs-string">&#x27;&lt;s&gt; You are a helpful assistant. Help me to write a blogpost about travelling.  I am excited to share my experiences with you.  I have been traveling for the past&#x27;</span>, <span class="hljs-string">&#x27;&lt;s&gt; You are a helpful assistant. What is the capital of France? \\n\\nAnswer: Paris is the capital of France.&lt;/s&gt;&#x27;</span>]`,wrap:!1}}),We=new T({props:{title:"Legacy cache format",local:"legacy-cache-format",headingTag:"h2"}}),Re=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwRHluYW1pY0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyVGlueUxsYW1hJTJGVGlueUxsYW1hLTEuMUItQ2hhdC12MS4wJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlRpbnlMbGFtYSUyRlRpbnlMbGFtYS0xLjFCLUNoYXQtdjEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMCU2MHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSU2MCUyMGlzJTIwcmVxdWlyZWQlMjB0byUyMHJldHVybiUyMHRoZSUyMGNhY2hlLiUyMCU2MHJldHVybl9sZWdhY3lfY2FjaGUlNjAlMjBmb3JjZXMlMjB0aGUlMjByZXR1cm5lZCUyMGNhY2hlJTBBJTIzJTIwdG8lMjBiZSUyMG9mJTIwdGhlJTIwbGVnYWN5JTIwdHlwZSUwQWdlbmVyYXRpb25fb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwcmV0dXJuX2xlZ2FjeV9jYWNoZSUzRFRydWUlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUpJTBBJTBBJTIzJTIwV2UlMjBjYW4lMjBjb252ZXJ0JTIwYSUyMGxlZ2FjeSUyMGNhY2hlJTIwdG8lMjBhJTIwRHluYW1pY0NhY2hlJTIwLS0lMjBhbmQlMjB0aGUlMjBvdGhlciUyMHdheSUyMGFyb3VuZC4lMjBUaGlzJTIwaXMlMjBoZWxwZnVsJTIwaWYlMjB5b3UlMjBoYXZlJTIwY3VzdG9tJTBBJTIzJTIwbG9naWMlMjB0byUyMG1hbmlwdWxhdGUlMjBhJTIwY2FjaGUlMjBpbiUyMGElMjBzcGVjaWZpYyUyMGZvcm1hdC4lMEFjYWNoZSUyMCUzRCUyMER5bmFtaWNDYWNoZS5mcm9tX2xlZ2FjeV9jYWNoZShnZW5lcmF0aW9uX291dHB1dHMucGFzdF9rZXlfdmFsdWVzKSUwQWxlZ2FjeV9mb3JtYXRfY2FjaGUlMjAlM0QlMjBjYWNoZS50b19sZWdhY3lfY2FjaGUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;TinyLlama/TinyLlama-1.1B-Chat-v1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`return_dict_in_generate=True\` is required to return the cache. \`return_legacy_cache\` forces the returned cache</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to be of the legacy type</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, return_legacy_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">5</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can convert a legacy cache to a DynamicCache -- and the other way around. This is helpful if you have custom</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># logic to manipulate a cache in a specific format.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache = DynamicCache.from_legacy_cache(generation_outputs.past_key_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>legacy_format_cache = cache.to_legacy_cache()`,wrap:!1}}),Ne=new oa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/kv_cache.md"}}),{c(){p=o("meta"),j=n(),M=o("p"),f=n(),r(Z.$$.fragment),Ee=n(),G=o("p"),G.textContent=ms,$e=n(),v=o("p"),v.innerHTML=ds,qe=n(),r(B.$$.fragment),Se=n(),V=o("p"),V.textContent=us,Le=n(),X=o("p"),X.textContent=ys,Ae=n(),W=o("p"),W.textContent=Ms,De=n(),g=o("details"),Ye=o("summary"),Ye.innerHTML=gs,ts=n(),r(_.$$.fragment),ss=n(),ze=o("p"),ze.textContent=Js,as=n(),Qe=o("p"),Qe.innerHTML=Ts,ns=n(),xe=o("p"),xe.innerHTML=ws,ls=n(),r(k.$$.fragment),os=n(),Fe=o("p"),Fe.textContent=js,cs=n(),r(R.$$.fragment),is=n(),r(N.$$.fragment),Ke=n(),r(Y.$$.fragment),Pe=n(),z=o("p"),z.innerHTML=bs,Oe=n(),Q=o("p"),Q.innerHTML=fs,et=n(),x=o("table"),x.innerHTML=Us,tt=n(),F=o("p"),F.innerHTML=ks,st=n(),r(H.$$.fragment),at=n(),E=o("p"),E.innerHTML=Cs,nt=n(),$=o("p"),$.innerHTML=Is,lt=n(),q=o("p"),q.innerHTML=Zs,ot=n(),S=o("p"),S.innerHTML=Gs,ct=n(),r(C.$$.fragment),it=n(),r(L.$$.fragment),pt=n(),r(A.$$.fragment),rt=n(),D=o("p"),D.innerHTML=vs,ht=n(),K=o("p"),K.textContent=Bs,mt=n(),P=o("p"),P.innerHTML=Vs,dt=n(),r(O.$$.fragment),ut=n(),r(I.$$.fragment),yt=n(),ee=o("p"),ee.textContent=Xs,Mt=n(),r(te.$$.fragment),gt=n(),se=o("p"),se.textContent=Ws,Jt=n(),r(ae.$$.fragment),Tt=n(),ne=o("p"),ne.textContent=_s,wt=n(),r(le.$$.fragment),jt=n(),oe=o("p"),oe.innerHTML=Rs,bt=n(),ce=o("p"),ce.innerHTML=Ns,ft=n(),r(ie.$$.fragment),Ut=n(),r(pe.$$.fragment),kt=n(),re=o("p"),re.innerHTML=Ys,Ct=n(),r(he.$$.fragment),It=n(),me=o("p"),me.textContent=zs,Zt=n(),r(de.$$.fragment),Gt=n(),ue=o("p"),ue.innerHTML=Qs,vt=n(),ye=o("p"),ye.textContent=xs,Bt=n(),r(Me.$$.fragment),Vt=n(),r(ge.$$.fragment),Xt=n(),Je=o("p"),Je.innerHTML=Fs,Wt=n(),Te=o("p"),Te.innerHTML=Hs,_t=n(),r(we.$$.fragment),Rt=n(),r(je.$$.fragment),Nt=n(),be=o("p"),be.innerHTML=Es,Yt=n(),fe=o("p"),fe.innerHTML=$s,zt=n(),r(Ue.$$.fragment),Qt=n(),ke=o("p"),ke.innerHTML=qs,xt=n(),r(Ce.$$.fragment),Ft=n(),Ie=o("p"),Ie.textContent=Ss,Ht=n(),Ze=o("p"),Ze.innerHTML=Ls,Et=n(),Ge=o("p"),Ge.textContent=As,$t=n(),r(ve.$$.fragment),qt=n(),r(Be.$$.fragment),St=n(),Ve=o("p"),Ve.innerHTML=Ds,Lt=n(),r(Xe.$$.fragment),At=n(),r(We.$$.fragment),Dt=n(),_e=o("p"),_e.innerHTML=Ks,Kt=n(),r(Re.$$.fragment),Pt=n(),r(Ne.$$.fragment),Ot=n(),He=o("p"),this.h()},l(e){const t=la("svelte-u9bgzb",document.head);p=c(t,"META",{name:!0,content:!0}),t.forEach(s),j=l(e),M=c(e,"P",{}),ps(M).forEach(s),f=l(e),h(Z.$$.fragment,e),Ee=l(e),G=c(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-ivdsz6"&&(G.textContent=ms),$e=l(e),v=c(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1ru3n2s"&&(v.innerHTML=ds),qe=l(e),h(B.$$.fragment,e),Se=l(e),V=c(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-pgg2dh"&&(V.textContent=us),Le=l(e),X=c(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1pcidqj"&&(X.textContent=ys),Ae=l(e),W=c(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-19ueo1l"&&(W.textContent=Ms),De=l(e),g=c(e,"DETAILS",{});var J=ps(g);Ye=c(J,"SUMMARY",{"data-svelte-h":!0}),i(Ye)!=="svelte-8dl4q2"&&(Ye.innerHTML=gs),ts=l(J),h(_.$$.fragment,J),ss=l(J),ze=c(J,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-1e25at2"&&(ze.textContent=Js),as=l(J),Qe=c(J,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-1l5g8w7"&&(Qe.innerHTML=Ts),ns=l(J),xe=c(J,"P",{"data-svelte-h":!0}),i(xe)!=="svelte-8mjlg7"&&(xe.innerHTML=ws),ls=l(J),h(k.$$.fragment,J),os=l(J),Fe=c(J,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-181iwu3"&&(Fe.textContent=js),cs=l(J),h(R.$$.fragment,J),is=l(J),h(N.$$.fragment,J),J.forEach(s),Ke=l(e),h(Y.$$.fragment,e),Pe=l(e),z=c(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1sp8xhf"&&(z.innerHTML=bs),Oe=l(e),Q=c(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-ez9zp4"&&(Q.innerHTML=fs),et=l(e),x=c(e,"TABLE",{"data-svelte-h":!0}),i(x)!=="svelte-yhqrld"&&(x.innerHTML=Us),tt=l(e),F=c(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-b5pfm0"&&(F.innerHTML=ks),st=l(e),h(H.$$.fragment,e),at=l(e),E=c(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1yajrsk"&&(E.innerHTML=Cs),nt=l(e),$=c(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-1so9rnx"&&($.innerHTML=Is),lt=l(e),q=c(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-gznk4o"&&(q.innerHTML=Zs),ot=l(e),S=c(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1ke22x8"&&(S.innerHTML=Gs),ct=l(e),h(C.$$.fragment,e),it=l(e),h(L.$$.fragment,e),pt=l(e),h(A.$$.fragment,e),rt=l(e),D=c(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-uj0xty"&&(D.innerHTML=vs),ht=l(e),K=c(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1x4pr6r"&&(K.textContent=Bs),mt=l(e),P=c(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-6aujat"&&(P.innerHTML=Vs),dt=l(e),h(O.$$.fragment,e),ut=l(e),h(I.$$.fragment,e),yt=l(e),ee=c(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-f3m4wg"&&(ee.textContent=Xs),Mt=l(e),h(te.$$.fragment,e),gt=l(e),se=c(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-opu10i"&&(se.textContent=Ws),Jt=l(e),h(ae.$$.fragment,e),Tt=l(e),ne=c(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-83p2wm"&&(ne.textContent=_s),wt=l(e),h(le.$$.fragment,e),jt=l(e),oe=c(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1js08qo"&&(oe.innerHTML=Rs),bt=l(e),ce=c(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-hxs9qp"&&(ce.innerHTML=Ns),ft=l(e),h(ie.$$.fragment,e),Ut=l(e),h(pe.$$.fragment,e),kt=l(e),re=c(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-1hku8s1"&&(re.innerHTML=Ys),Ct=l(e),h(he.$$.fragment,e),It=l(e),me=c(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-zdzdtx"&&(me.textContent=zs),Zt=l(e),h(de.$$.fragment,e),Gt=l(e),ue=c(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-krlgtc"&&(ue.innerHTML=Qs),vt=l(e),ye=c(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-14gr42g"&&(ye.textContent=xs),Bt=l(e),h(Me.$$.fragment,e),Vt=l(e),h(ge.$$.fragment,e),Xt=l(e),Je=c(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-128onc7"&&(Je.innerHTML=Fs),Wt=l(e),Te=c(e,"P",{"data-svelte-h":!0}),i(Te)!=="svelte-1vy8lmv"&&(Te.innerHTML=Hs),_t=l(e),h(we.$$.fragment,e),Rt=l(e),h(je.$$.fragment,e),Nt=l(e),be=c(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-19fdrce"&&(be.innerHTML=Es),Yt=l(e),fe=c(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-159fa3b"&&(fe.innerHTML=$s),zt=l(e),h(Ue.$$.fragment,e),Qt=l(e),ke=c(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-1p1qecq"&&(ke.innerHTML=qs),xt=l(e),h(Ce.$$.fragment,e),Ft=l(e),Ie=c(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-au9ho2"&&(Ie.textContent=Ss),Ht=l(e),Ze=c(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-108v17k"&&(Ze.innerHTML=Ls),Et=l(e),Ge=c(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-1yn0icb"&&(Ge.textContent=As),$t=l(e),h(ve.$$.fragment,e),qt=l(e),h(Be.$$.fragment,e),St=l(e),Ve=c(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-1v9i2j4"&&(Ve.innerHTML=Ds),Lt=l(e),h(Xe.$$.fragment,e),At=l(e),h(We.$$.fragment,e),Dt=l(e),_e=c(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-wtnkn"&&(_e.innerHTML=Ks),Kt=l(e),h(Re.$$.fragment,e),Pt=l(e),h(Ne.$$.fragment,e),Ot=l(e),He=c(e,"P",{}),ps(He).forEach(s),this.h()},h(){ea(p,"name","hf:doc:metadata"),ea(p,"content",ha)},m(e,t){w(document.head,p),a(e,j,t),a(e,M,t),a(e,f,t),m(Z,e,t),a(e,Ee,t),a(e,G,t),a(e,$e,t),a(e,v,t),a(e,qe,t),m(B,e,t),a(e,Se,t),a(e,V,t),a(e,Le,t),a(e,X,t),a(e,Ae,t),a(e,W,t),a(e,De,t),a(e,g,t),w(g,Ye),w(g,ts),m(_,g,null),w(g,ss),w(g,ze),w(g,as),w(g,Qe),w(g,ns),w(g,xe),w(g,ls),m(k,g,null),w(g,os),w(g,Fe),w(g,cs),m(R,g,null),w(g,is),m(N,g,null),a(e,Ke,t),m(Y,e,t),a(e,Pe,t),a(e,z,t),a(e,Oe,t),a(e,Q,t),a(e,et,t),a(e,x,t),a(e,tt,t),a(e,F,t),a(e,st,t),m(H,e,t),a(e,at,t),a(e,E,t),a(e,nt,t),a(e,$,t),a(e,lt,t),a(e,q,t),a(e,ot,t),a(e,S,t),a(e,ct,t),m(C,e,t),a(e,it,t),m(L,e,t),a(e,pt,t),m(A,e,t),a(e,rt,t),a(e,D,t),a(e,ht,t),a(e,K,t),a(e,mt,t),a(e,P,t),a(e,dt,t),m(O,e,t),a(e,ut,t),m(I,e,t),a(e,yt,t),a(e,ee,t),a(e,Mt,t),m(te,e,t),a(e,gt,t),a(e,se,t),a(e,Jt,t),m(ae,e,t),a(e,Tt,t),a(e,ne,t),a(e,wt,t),m(le,e,t),a(e,jt,t),a(e,oe,t),a(e,bt,t),a(e,ce,t),a(e,ft,t),m(ie,e,t),a(e,Ut,t),m(pe,e,t),a(e,kt,t),a(e,re,t),a(e,Ct,t),m(he,e,t),a(e,It,t),a(e,me,t),a(e,Zt,t),m(de,e,t),a(e,Gt,t),a(e,ue,t),a(e,vt,t),a(e,ye,t),a(e,Bt,t),m(Me,e,t),a(e,Vt,t),m(ge,e,t),a(e,Xt,t),a(e,Je,t),a(e,Wt,t),a(e,Te,t),a(e,_t,t),m(we,e,t),a(e,Rt,t),m(je,e,t),a(e,Nt,t),a(e,be,t),a(e,Yt,t),a(e,fe,t),a(e,zt,t),m(Ue,e,t),a(e,Qt,t),a(e,ke,t),a(e,xt,t),m(Ce,e,t),a(e,Ft,t),a(e,Ie,t),a(e,Ht,t),a(e,Ze,t),a(e,Et,t),a(e,Ge,t),a(e,$t,t),m(ve,e,t),a(e,qt,t),m(Be,e,t),a(e,St,t),a(e,Ve,t),a(e,Lt,t),m(Xe,e,t),a(e,At,t),m(We,e,t),a(e,Dt,t),a(e,_e,t),a(e,Kt,t),m(Re,e,t),a(e,Pt,t),m(Ne,e,t),a(e,Ot,t),a(e,He,t),es=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),k.$set(J);const Ps={};t&2&&(Ps.$$scope={dirty:t,ctx:e}),C.$set(Ps);const Os={};t&2&&(Os.$$scope={dirty:t,ctx:e}),I.$set(Os)},i(e){es||(d(Z.$$.fragment,e),d(B.$$.fragment,e),d(_.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(C.$$.fragment,e),d(L.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(I.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(de.$$.fragment,e),d(Me.$$.fragment,e),d(ge.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(Ce.$$.fragment,e),d(ve.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(We.$$.fragment,e),d(Re.$$.fragment,e),d(Ne.$$.fragment,e),es=!0)},o(e){u(Z.$$.fragment,e),u(B.$$.fragment,e),u(_.$$.fragment,e),u(k.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(C.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(I.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(de.$$.fragment,e),u(Me.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(Ce.$$.fragment,e),u(ve.$$.fragment,e),u(Be.$$.fragment,e),u(Xe.$$.fragment,e),u(We.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),es=!1},d(e){e&&(s(j),s(M),s(f),s(Ee),s(G),s($e),s(v),s(qe),s(Se),s(V),s(Le),s(X),s(Ae),s(W),s(De),s(g),s(Ke),s(Pe),s(z),s(Oe),s(Q),s(et),s(x),s(tt),s(F),s(st),s(at),s(E),s(nt),s($),s(lt),s(q),s(ot),s(S),s(ct),s(it),s(pt),s(rt),s(D),s(ht),s(K),s(mt),s(P),s(dt),s(ut),s(yt),s(ee),s(Mt),s(gt),s(se),s(Jt),s(Tt),s(ne),s(wt),s(jt),s(oe),s(bt),s(ce),s(ft),s(Ut),s(kt),s(re),s(Ct),s(It),s(me),s(Zt),s(Gt),s(ue),s(vt),s(ye),s(Bt),s(Vt),s(Xt),s(Je),s(Wt),s(Te),s(_t),s(Rt),s(Nt),s(be),s(Yt),s(fe),s(zt),s(Qt),s(ke),s(xt),s(Ft),s(Ie),s(Ht),s(Ze),s(Et),s(Ge),s($t),s(qt),s(St),s(Ve),s(Lt),s(At),s(Dt),s(_e),s(Kt),s(Pt),s(Ot),s(He)),s(p),y(Z,e),y(B,e),y(_),y(k),y(R),y(N),y(Y,e),y(H,e),y(C,e),y(L,e),y(A,e),y(O,e),y(I,e),y(te,e),y(ae,e),y(le,e),y(ie,e),y(pe,e),y(he,e),y(de,e),y(Me,e),y(ge,e),y(we,e),y(je,e),y(Ue,e),y(Ce,e),y(ve,e),y(Be,e),y(Xe,e),y(We,e),y(Re,e),y(Ne,e)}}}const ha='{"title":"Best Practices for Generation with Cache","local":"best-practices-for-generation-with-cache","sections":[{"title":"What is Cache and why we should care?","local":"what-is-cache-and-why-we-should-care","sections":[{"title":"Under the Hood: How Cache Object Works in Attention Mechanism","local":"under-the-hood-how-cache-object-works-in-attention-mechanism","sections":[],"depth":3}],"depth":2},{"title":"Generate with Cache","local":"generate-with-cache","sections":[{"title":"Quantized Cache","local":"quantized-cache","sections":[],"depth":3},{"title":"Offloaded Cache","local":"offloaded-cache","sections":[],"depth":3},{"title":"Static Cache","local":"static-cache","sections":[],"depth":3}],"depth":2},{"title":"Offloaded Static Cache","local":"offloaded-static-cache","sections":[{"title":"Sliding Window Cache","local":"sliding-window-cache","sections":[],"depth":3},{"title":"Sink Cache","local":"sink-cache","sections":[],"depth":3},{"title":"Encoder-Decoder Cache","local":"encoder-decoder-cache","sections":[],"depth":3},{"title":"Model-specific Cache Classes","local":"model-specific-cache-classes","sections":[],"depth":3}],"depth":2},{"title":"Iterative Generation with Cache","local":"iterative-generation-with-cache","sections":[],"depth":2},{"title":"Re-use Cache to continue generation","local":"re-use-cache-to-continue-generation","sections":[],"depth":2},{"title":"Legacy cache format","local":"legacy-cache-format","sections":[],"depth":2}],"depth":1}';function ma(U){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ja extends aa{constructor(p){super(),na(this,p,ma,ra,ta,{})}}export{Ja as component};
