import{s as ds,o as hs,n as cs}from"../chunks/scheduler.25b97de1.js";import{S as gs,i as Ms,g as o,s as l,r as p,A as ys,h as i,f as s,c as n,j as ms,u as m,x as r,k as vt,y as fs,a,v as u,d as c,t as d,w as h}from"../chunks/index.d9030fc9.js";import{T as us}from"../chunks/Tip.baa67368.js";import{C as b}from"../chunks/CodeBlock.e6cd0d95.js";import{D as bs}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as y,E as ws}from"../chunks/EditOnGithub.91d95064.js";function Ts(Ue){let g,f='If you want to jump straight to chatting with a model, <a href="quicktour#chat-with-text-generation-models">try our chat CLI</a>.';return{c(){g=o("p"),g.innerHTML=f},l(M){g=i(M,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1vc2ejv"&&(g.innerHTML=f)},m(M,w){a(M,g,w)},p:cs,d(M){M&&s(g)}}}function js(Ue){let g,f='If you’re interested in basic LLM usage, our high-level <a href="pipeline_tutorial"><code>Pipeline</code></a> interface is a great starting point. However, LLMs often require advanced features like quantization and fine control of the token selection step, which is best done through <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. Autoregressive generation with LLMs is also resource-intensive and should be executed on a GPU for adequate throughput.';return{c(){g=o("p"),g.innerHTML=f},l(M){g=i(M,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1wydxnv"&&(g.innerHTML=f)},m(M,w){a(M,g,w)},p:cs,d(M){M&&s(g)}}}function Js(Ue){let g,f,M,w,k,Ze,Z,Ge,G,$t="LLMs, or Large Language Models, are the key component behind text generation. In a nutshell, they consist of large pretrained transformer models trained to predict the next word (or, more precisely, token) given some input text. Since they predict one token at a time, you need to do something more elaborate to generate new sentences other than just calling the model — you need to do autoregressive generation.",Ie,I,Wt='Autoregressive generation is the inference-time procedure of iteratively calling a model with its own generated outputs, given a few initial inputs. In 🤗 Transformers, this is handled by the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, which is available to all models with generative capabilities.',_e,T,ve,_,Bt="This tutorial will show you how to:",$e,v,Vt="<li>Generate text with an LLM</li> <li>Avoid common pitfalls</li> <li>Next steps to help you get the most out of your LLM</li>",We,$,Rt="Before you begin, make sure you have all the necessary libraries installed:",Be,W,Ve,B,Re,V,xt='A language model trained for <a href="tasks/language_modeling">causal language modeling</a> takes a sequence of text tokens as input and returns the probability distribution for the next token.',xe,j,Xt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',Xe,R,Ct="A critical aspect of autoregressive generation with LLMs is how to select the next token from this probability distribution. Anything goes in this step as long as you end up with a token for the next iteration. This means it can be as simple as selecting the most likely token from the probability distribution or as complex as applying a dozen transformations before sampling from the resulting distribution.",Ce,J,zt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Autoregressive generation iteratively selects the next token from a probability distribution to generate text&quot;</figcaption>',ze,x,Ht="The process depicted above is repeated iteratively until some stopping condition is reached. Ideally, the stopping condition is dictated by the model, which should learn when to output an end-of-sequence (<code>EOS</code>) token. If this is not the case, generation stops when some predefined maximum length is reached.",He,X,Lt='Properly setting up the token selection step and the stopping condition is essential to make your model behave as you’d expect on your task. That is why we have a <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file associated with each model, which contains a good default generative parameterization and is loaded alongside your model.',Le,C,qt="Let’s talk code!",qe,U,Fe,z,Ft="First, you need to load the model.",Ne,H,Qe,L,Nt="You’ll notice two flags in the <code>from_pretrained</code> call:",Ee,q,Qt='<li><code>device_map</code> ensures the model is moved to your GPU(s)</li> <li><code>load_in_4bit</code> applies <a href="main_classes/quantization">4-bit dynamic quantization</a> to massively reduce the resource requirements</li>',Se,F,Et="There are other ways to initialize a model, but this is a good baseline to begin with an LLM.",Ye,N,St='Next, you need to preprocess your text input with a <a href="tokenizer_summary">tokenizer</a>.',Ae,Q,De,E,Yt='The <code>model_inputs</code> variable holds the tokenized text input, as well as the attention mask. While <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> does its best effort to infer the attention mask when it is not passed, we recommend passing it whenever possible for optimal results.',Pe,S,At='After tokenizing the inputs, you can call the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to returns the generated tokens. The generated tokens then should be converted to text before printing.',Ke,Y,Oe,A,Dt="Finally, you don’t need to do it one sequence at a time! You can batch your inputs, which will greatly improve the throughput at a small latency and memory cost. All you need to do is to make sure you pad your inputs properly (more on that below).",et,D,tt,P,Pt="And that’s it! In a few lines of code, you can harness the power of an LLM.",st,K,at,O,Kt='There are many <a href="generation_strategies">generation strategies</a>, and sometimes the default values may not be appropriate for your use case. If your outputs aren’t aligned with what you’re expecting, we’ve created a list of the most common pitfalls and how to avoid them.',lt,ee,nt,te,ot,se,Ot='If not specified in the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> returns up to 20 tokens by default. We highly recommend manually setting <code>max_new_tokens</code> in your <code>generate</code> call to control the maximum number of new tokens it can return. Keep in mind LLMs (more precisely, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) also return the input prompt as part of the output.',it,ae,rt,le,pt,ne,es='By default, and unless specified in the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> selects the most likely token at each iteration (greedy decoding). Depending on your task, this may be undesirable; creative tasks like chatbots or writing an essay benefit from sampling. On the other hand, input-grounded tasks like audio transcription or translation benefit from greedy decoding. Enable sampling with <code>do_sample=True</code>, and you can learn more about this topic in this <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">blog post</a>.',mt,oe,ut,ie,ct,re,ts='LLMs are <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a> architectures, meaning they continue to iterate on your input prompt. If your inputs do not have the same length, they need to be padded. Since LLMs are not trained to continue from pad tokens, your input needs to be left-padded. Make sure you also don’t forget to pass the attention mask to generate!',dt,pe,ht,me,gt,ue,ss='Some models and tasks expect a certain input prompt format to work properly. When this format is not applied, you will get a silent performance degradation: the model kinda works, but not as well as if you were following the expected prompt. More information about prompting, including which models and tasks need to be careful, is available in this <a href="tasks/prompting">guide</a>. Let’s see an example with a chat LLM, which makes use of <a href="chat_templating">chat templating</a>:',Mt,ce,yt,de,ft,he,as="While the autoregressive generation process is relatively straightforward, making the most out of your LLM can be a challenging endeavor because there are many moving parts. For your next steps to help you dive deeper into LLM usage and understanding:",bt,ge,wt,Me,ls='<li>Guide on how to <a href="generation_strategies">control different generation methods</a>, how to set up the generation configuration file, and how to stream the output;</li> <li><a href="llm_optims">Accelerating text generation</a>;</li> <li><a href="chat_templating">Prompt templates for chat LLMs</a>;</li> <li><a href="tasks/prompting">Prompt design guide</a>;</li> <li>API reference on <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, and <a href="internal/generation_utils">generate-related classes</a>. Most of the classes, including the logits processors, have usage examples!</li>',Tt,ye,jt,fe,ns='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, which focuses on the quality of the open-source models;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, which focuses on LLM throughput.</li>',Jt,be,Ut,we,os='<li>Guide on how to <a href="llm_tutorial_optimization">optimize LLMs for speed and memory</a>;</li> <li>Guide on <a href="main_classes/quantization">quantization</a> such as bitsandbytes and autogptq, which shows you how to drastically reduce your memory requirements.</li>',kt,Te,Zt,je,is='<li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, an extension of 🤗 Transformers that optimizes for specific hardware devices;</li> <li><a href="https://github.com/outlines-dev/outlines" rel="nofollow"><code>outlines</code></a>, a library where you can constrain text generation (e.g. to generate JSON files);</li> <li><a href="https://github.com/uiuc-focal-lab/syncode" rel="nofollow"><code>SynCode</code></a>, a library for context-free grammar guided generation (e.g. JSON, SQL, Python);</li> <li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, a production-ready server for LLMs;</li> <li><a href="https://github.com/oobabooga/text-generation-webui" rel="nofollow"><code>text-generation-webui</code></a>, a UI for text generation;</li> <li><a href="https://github.com/NVIDIA/logits-processor-zoo" rel="nofollow"><code>logits-processor-zoo</code></a>, containing additional options to control text generation with 🤗 Transformers. See our related <a href="https://huggingface.co/blog/logits-processor-zoo" rel="nofollow">blog post</a>.</li>',Gt,Je,It,ke,_t;return k=new y({props:{title:"Generation with LLMs",local:"generation-with-llms",headingTag:"h1"}}),Z=new bs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"}]}}),T=new us({props:{$$slots:{default:[Ts]},$$scope:{ctx:Ue}}}),W=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),B=new y({props:{title:"Generate text",local:"generate-text",headingTag:"h2"}}),U=new us({props:{$$slots:{default:[js]},$$scope:{ctx:Ue}}}),H=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Q=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Y=new b({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>`,wrap:!1}}),D=new b({props:{code:"dG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiUyQyUyMCUyMlBvcnR1Z2FsJTIwaXMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>, <span class="hljs-string">&quot;Portugal is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>,
<span class="hljs-string">&#x27;Portugal is a country in southwestern Europe, on the Iber&#x27;</span>]`,wrap:!1}}),K=new y({props:{title:"Common pitfalls",local:"common-pitfalls",headingTag:"h2"}}),ee=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1vc3QlMjBMTE1zJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),te=new y({props:{title:"Generated output is too short/long",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),ae=new b({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),le=new y({props:{title:"Incorrect generation mode",local:"incorrect-generation-mode",headingTag:"h3"}}),oe=new b({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUyMC0tJTIweW91JTIwZG9uJ3QlMjBuZWVkJTIwdGhpcyUyMHVubGVzcyUyMHlvdSUyMHdhbnQlMjBmdWxsJTIwcmVwcm9kdWNpYmlsaXR5JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTBBJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkklMjBhbSUyMGElMjBjYXQuJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBMTE0lMjAlMkIlMjBncmVlZHklMjBkZWNvZGluZyUyMCUzRCUyMHJlcGV0aXRpdmUlMkMlMjBib3JpbmclMjBvdXRwdXQlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGJlY29tZXMlMjBtb3JlJTIwY3JlYXRpdmUhJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed for reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.  Specifically, I am an indoor-only cat.  I&#x27;</span>`,wrap:!1}}),ie=new y({props:{title:"Wrong padding side",local:"wrong-padding-side",headingTag:"h3"}}),pe=new b({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscyUyMHRvJTIwY2FwdHVyZSUyMHRoZSUyMGxvZ2ljLiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFdpdGglMjBsZWZ0LXBhZGRpbmclMkMlMjBpdCUyMHdvcmtzJTIwYXMlMjBleHBlY3RlZCElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTW9zdCUyMExMTXMlMjBkb24ndCUyMGhhdmUlMjBhJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails to capture the logic.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 33333333333&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),me=new y({props:{title:"Wrong prompt",local:"wrong-prompt",headingTag:"h3"}}),ce=new b({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;How many helicopters can a human eat in one sitting? Reply as a thug.&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;I&#x27;m not a thug, but i can tell you that a human cannot eat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Oh no, it did not follow our instruction to reply as a thug! Let&#x27;s see what happens when we write</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># a better prompt and use the right template for this model (through \`tokenizer.apply_chat_template\`)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a thug&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;None, you thug. How bout you try to focus on more useful questions?&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># As we can see, it followed a proper thug style 😎</span>`,wrap:!1}}),de=new y({props:{title:"Further resources",local:"further-resources",headingTag:"h2"}}),ge=new y({props:{title:"Advanced generate usage",local:"advanced-generate-usage",headingTag:"h3"}}),ye=new y({props:{title:"LLM leaderboards",local:"llm-leaderboards",headingTag:"h3"}}),be=new y({props:{title:"Latency, throughput and memory utilization",local:"latency-throughput-and-memory-utilization",headingTag:"h3"}}),Te=new y({props:{title:"Related libraries",local:"related-libraries",headingTag:"h3"}}),Je=new ws({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_tutorial.md"}}),{c(){g=o("meta"),f=l(),M=o("p"),w=l(),p(k.$$.fragment),Ze=l(),p(Z.$$.fragment),Ge=l(),G=o("p"),G.textContent=$t,Ie=l(),I=o("p"),I.innerHTML=Wt,_e=l(),p(T.$$.fragment),ve=l(),_=o("p"),_.textContent=Bt,$e=l(),v=o("ul"),v.innerHTML=Vt,We=l(),$=o("p"),$.textContent=Rt,Be=l(),p(W.$$.fragment),Ve=l(),p(B.$$.fragment),Re=l(),V=o("p"),V.innerHTML=xt,xe=l(),j=o("figure"),j.innerHTML=Xt,Xe=l(),R=o("p"),R.textContent=Ct,Ce=l(),J=o("figure"),J.innerHTML=zt,ze=l(),x=o("p"),x.innerHTML=Ht,He=l(),X=o("p"),X.innerHTML=Lt,Le=l(),C=o("p"),C.textContent=qt,qe=l(),p(U.$$.fragment),Fe=l(),z=o("p"),z.textContent=Ft,Ne=l(),p(H.$$.fragment),Qe=l(),L=o("p"),L.innerHTML=Nt,Ee=l(),q=o("ul"),q.innerHTML=Qt,Se=l(),F=o("p"),F.textContent=Et,Ye=l(),N=o("p"),N.innerHTML=St,Ae=l(),p(Q.$$.fragment),De=l(),E=o("p"),E.innerHTML=Yt,Pe=l(),S=o("p"),S.innerHTML=At,Ke=l(),p(Y.$$.fragment),Oe=l(),A=o("p"),A.textContent=Dt,et=l(),p(D.$$.fragment),tt=l(),P=o("p"),P.textContent=Pt,st=l(),p(K.$$.fragment),at=l(),O=o("p"),O.innerHTML=Kt,lt=l(),p(ee.$$.fragment),nt=l(),p(te.$$.fragment),ot=l(),se=o("p"),se.innerHTML=Ot,it=l(),p(ae.$$.fragment),rt=l(),p(le.$$.fragment),pt=l(),ne=o("p"),ne.innerHTML=es,mt=l(),p(oe.$$.fragment),ut=l(),p(ie.$$.fragment),ct=l(),re=o("p"),re.innerHTML=ts,dt=l(),p(pe.$$.fragment),ht=l(),p(me.$$.fragment),gt=l(),ue=o("p"),ue.innerHTML=ss,Mt=l(),p(ce.$$.fragment),yt=l(),p(de.$$.fragment),ft=l(),he=o("p"),he.textContent=as,bt=l(),p(ge.$$.fragment),wt=l(),Me=o("ol"),Me.innerHTML=ls,Tt=l(),p(ye.$$.fragment),jt=l(),fe=o("ol"),fe.innerHTML=ns,Jt=l(),p(be.$$.fragment),Ut=l(),we=o("ol"),we.innerHTML=os,kt=l(),p(Te.$$.fragment),Zt=l(),je=o("ol"),je.innerHTML=is,Gt=l(),p(Je.$$.fragment),It=l(),ke=o("p"),this.h()},l(e){const t=ys("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(s),f=n(e),M=i(e,"P",{}),ms(M).forEach(s),w=n(e),m(k.$$.fragment,e),Ze=n(e),m(Z.$$.fragment,e),Ge=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-tihwde"&&(G.textContent=$t),Ie=n(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-fnigcq"&&(I.innerHTML=Wt),_e=n(e),m(T.$$.fragment,e),ve=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1g5tmp7"&&(_.textContent=Bt),$e=n(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-jbjjoq"&&(v.innerHTML=Vt),We=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1c9nexd"&&($.textContent=Rt),Be=n(e),m(W.$$.fragment,e),Ve=n(e),m(B.$$.fragment,e),Re=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-e3t4o0"&&(V.innerHTML=xt),xe=n(e),j=i(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-hjgddv"&&(j.innerHTML=Xt),Xe=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1qja5m9"&&(R.textContent=Ct),Ce=n(e),J=i(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1uqc9hk"&&(J.innerHTML=zt),ze=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-pprvht"&&(x.innerHTML=Ht),He=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1l96zw0"&&(X.innerHTML=Lt),Le=n(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1wpt61n"&&(C.textContent=qt),qe=n(e),m(U.$$.fragment,e),Fe=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-17lmqvk"&&(z.textContent=Ft),Ne=n(e),m(H.$$.fragment,e),Qe=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1ibsgq1"&&(L.innerHTML=Nt),Ee=n(e),q=i(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1ut1fuh"&&(q.innerHTML=Qt),Se=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-14llc8d"&&(F.textContent=Et),Ye=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-9uk3l0"&&(N.innerHTML=St),Ae=n(e),m(Q.$$.fragment,e),De=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-isqmga"&&(E.innerHTML=Yt),Pe=n(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1c42551"&&(S.innerHTML=At),Ke=n(e),m(Y.$$.fragment,e),Oe=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1p82il9"&&(A.textContent=Dt),et=n(e),m(D.$$.fragment,e),tt=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-wj0v9f"&&(P.textContent=Pt),st=n(e),m(K.$$.fragment,e),at=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1h0ongv"&&(O.innerHTML=Kt),lt=n(e),m(ee.$$.fragment,e),nt=n(e),m(te.$$.fragment,e),ot=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-16wmhsj"&&(se.innerHTML=Ot),it=n(e),m(ae.$$.fragment,e),rt=n(e),m(le.$$.fragment,e),pt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-9pvt4j"&&(ne.innerHTML=es),mt=n(e),m(oe.$$.fragment,e),ut=n(e),m(ie.$$.fragment,e),ct=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1n0cu3a"&&(re.innerHTML=ts),dt=n(e),m(pe.$$.fragment,e),ht=n(e),m(me.$$.fragment,e),gt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-136mw01"&&(ue.innerHTML=ss),Mt=n(e),m(ce.$$.fragment,e),yt=n(e),m(de.$$.fragment,e),ft=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1w0my5d"&&(he.textContent=as),bt=n(e),m(ge.$$.fragment,e),wt=n(e),Me=i(e,"OL",{"data-svelte-h":!0}),r(Me)!=="svelte-1fhcqea"&&(Me.innerHTML=ls),Tt=n(e),m(ye.$$.fragment,e),jt=n(e),fe=i(e,"OL",{"data-svelte-h":!0}),r(fe)!=="svelte-x6edjm"&&(fe.innerHTML=ns),Jt=n(e),m(be.$$.fragment,e),Ut=n(e),we=i(e,"OL",{"data-svelte-h":!0}),r(we)!=="svelte-15885m8"&&(we.innerHTML=os),kt=n(e),m(Te.$$.fragment,e),Zt=n(e),je=i(e,"OL",{"data-svelte-h":!0}),r(je)!=="svelte-154hiyq"&&(je.innerHTML=is),Gt=n(e),m(Je.$$.fragment,e),It=n(e),ke=i(e,"P",{}),ms(ke).forEach(s),this.h()},h(){vt(g,"name","hf:doc:metadata"),vt(g,"content",Us),vt(j,"class","image table text-center m-0 w-full"),vt(J,"class","image table text-center m-0 w-full")},m(e,t){fs(document.head,g),a(e,f,t),a(e,M,t),a(e,w,t),u(k,e,t),a(e,Ze,t),u(Z,e,t),a(e,Ge,t),a(e,G,t),a(e,Ie,t),a(e,I,t),a(e,_e,t),u(T,e,t),a(e,ve,t),a(e,_,t),a(e,$e,t),a(e,v,t),a(e,We,t),a(e,$,t),a(e,Be,t),u(W,e,t),a(e,Ve,t),u(B,e,t),a(e,Re,t),a(e,V,t),a(e,xe,t),a(e,j,t),a(e,Xe,t),a(e,R,t),a(e,Ce,t),a(e,J,t),a(e,ze,t),a(e,x,t),a(e,He,t),a(e,X,t),a(e,Le,t),a(e,C,t),a(e,qe,t),u(U,e,t),a(e,Fe,t),a(e,z,t),a(e,Ne,t),u(H,e,t),a(e,Qe,t),a(e,L,t),a(e,Ee,t),a(e,q,t),a(e,Se,t),a(e,F,t),a(e,Ye,t),a(e,N,t),a(e,Ae,t),u(Q,e,t),a(e,De,t),a(e,E,t),a(e,Pe,t),a(e,S,t),a(e,Ke,t),u(Y,e,t),a(e,Oe,t),a(e,A,t),a(e,et,t),u(D,e,t),a(e,tt,t),a(e,P,t),a(e,st,t),u(K,e,t),a(e,at,t),a(e,O,t),a(e,lt,t),u(ee,e,t),a(e,nt,t),u(te,e,t),a(e,ot,t),a(e,se,t),a(e,it,t),u(ae,e,t),a(e,rt,t),u(le,e,t),a(e,pt,t),a(e,ne,t),a(e,mt,t),u(oe,e,t),a(e,ut,t),u(ie,e,t),a(e,ct,t),a(e,re,t),a(e,dt,t),u(pe,e,t),a(e,ht,t),u(me,e,t),a(e,gt,t),a(e,ue,t),a(e,Mt,t),u(ce,e,t),a(e,yt,t),u(de,e,t),a(e,ft,t),a(e,he,t),a(e,bt,t),u(ge,e,t),a(e,wt,t),a(e,Me,t),a(e,Tt,t),u(ye,e,t),a(e,jt,t),a(e,fe,t),a(e,Jt,t),u(be,e,t),a(e,Ut,t),a(e,we,t),a(e,kt,t),u(Te,e,t),a(e,Zt,t),a(e,je,t),a(e,Gt,t),u(Je,e,t),a(e,It,t),a(e,ke,t),_t=!0},p(e,[t]){const rs={};t&2&&(rs.$$scope={dirty:t,ctx:e}),T.$set(rs);const ps={};t&2&&(ps.$$scope={dirty:t,ctx:e}),U.$set(ps)},i(e){_t||(c(k.$$.fragment,e),c(Z.$$.fragment,e),c(T.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(U.$$.fragment,e),c(H.$$.fragment,e),c(Q.$$.fragment,e),c(Y.$$.fragment,e),c(D.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(ge.$$.fragment,e),c(ye.$$.fragment,e),c(be.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),_t=!0)},o(e){d(k.$$.fragment,e),d(Z.$$.fragment,e),d(T.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d(U.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),_t=!1},d(e){e&&(s(f),s(M),s(w),s(Ze),s(Ge),s(G),s(Ie),s(I),s(_e),s(ve),s(_),s($e),s(v),s(We),s($),s(Be),s(Ve),s(Re),s(V),s(xe),s(j),s(Xe),s(R),s(Ce),s(J),s(ze),s(x),s(He),s(X),s(Le),s(C),s(qe),s(Fe),s(z),s(Ne),s(Qe),s(L),s(Ee),s(q),s(Se),s(F),s(Ye),s(N),s(Ae),s(De),s(E),s(Pe),s(S),s(Ke),s(Oe),s(A),s(et),s(tt),s(P),s(st),s(at),s(O),s(lt),s(nt),s(ot),s(se),s(it),s(rt),s(pt),s(ne),s(mt),s(ut),s(ct),s(re),s(dt),s(ht),s(gt),s(ue),s(Mt),s(yt),s(ft),s(he),s(bt),s(wt),s(Me),s(Tt),s(jt),s(fe),s(Jt),s(Ut),s(we),s(kt),s(Zt),s(je),s(Gt),s(It),s(ke)),s(g),h(k,e),h(Z,e),h(T,e),h(W,e),h(B,e),h(U,e),h(H,e),h(Q,e),h(Y,e),h(D,e),h(K,e),h(ee,e),h(te,e),h(ae,e),h(le,e),h(oe,e),h(ie,e),h(pe,e),h(me,e),h(ce,e),h(de,e),h(ge,e),h(ye,e),h(be,e),h(Te,e),h(Je,e)}}}const Us='{"title":"Generation with LLMs","local":"generation-with-llms","sections":[{"title":"Generate text","local":"generate-text","sections":[],"depth":2},{"title":"Common pitfalls","local":"common-pitfalls","sections":[{"title":"Generated output is too short/long","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"Incorrect generation mode","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"Wrong padding side","local":"wrong-padding-side","sections":[],"depth":3},{"title":"Wrong prompt","local":"wrong-prompt","sections":[],"depth":3}],"depth":2},{"title":"Further resources","local":"further-resources","sections":[{"title":"Advanced generate usage","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM leaderboards","local":"llm-leaderboards","sections":[],"depth":3},{"title":"Latency, throughput and memory utilization","local":"latency-throughput-and-memory-utilization","sections":[],"depth":3},{"title":"Related libraries","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function ks(Ue){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends gs{constructor(g){super(),Ms(this,g,ks,Js,ds,{})}}export{Ws as component};
