import{s as ue,n as ye,o as Je}from"../chunks/scheduler.85c25b89.js";import{S as je,i as we,g as a,s as p,u as c,A as Te,h as n,f as e,c as i,j as h,v as M,y as m,k as o,o as r,a as l,w as d,d as g,t as u,x as y}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function be(Ht){let J,ht,st,mt,j,v,lt,N,Rt,D,Xt="Res2Net",ct,C,Ft='<strong>Res2Net</strong> is an image model that employs a variation on bottleneck residual blocks, <a href="https://paperswithcode.com/method/res2net-block" rel="nofollow">Res2Net Blocks</a>. The motivation is to be able to represent features at multiple scales. This is achieved through a novel building block for CNNs that constructs hierarchical residual-like connections within one single residual block. This represents multi-scale features at a granular level and increases the range of receptive fields for each network layer.',Mt,w,U,at,E,St,q,zt="How do I use this model on an image?",dt,W,Lt="To load a pretrained model:",gt,B,ut,Z,Pt="To load and preprocess the image:",yt,$,Jt,G,Dt="To get the model predictions:",jt,Q,wt,_,qt="To get the top-5 predictions class names:",Tt,R,bt,S,Kt="Replace the model name with the variant you want to use, e.g. <code>res2net101_26w_4s</code>. You can find the IDs in the model summaries at the top of this page.",ft,A,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,T,I,nt,Y,At,K,te="How do I finetune this model?",Ut,V,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",It,H,xt,X,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,b,x,pt,F,Yt,O,le="How do I train this model?",Nt,z,ae='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Ct,f,k,it,L,Vt,tt,ne="Citation",Et,P,Wt,ot,Bt;return N=new rt({}),E=new rt({}),B=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JlczJuZXQxMDFfMjZ3XzRzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2net101_26w_4s&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),$=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Q=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),R=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),Y=new rt({}),H=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzMm5ldDEwMV8yNndfNHMnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;res2net101_26w_4s&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),F=new rt({}),L=new rt({}),P=new et({props:{code:"JTQwYXJ0aWNsZSU3Qkdhb18yMDIxJTJDJTBBJTIwJTIwJTIwdGl0bGUlM0QlN0JSZXMyTmV0JTNBJTIwQSUyME5ldyUyME11bHRpLVNjYWxlJTIwQmFja2JvbmUlMjBBcmNoaXRlY3R1cmUlN0QlMkMlMEElMjAlMjAlMjB2b2x1bWUlM0QlN0I0MyU3RCUyQyUwQSUyMCUyMCUyMElTU04lM0QlN0IxOTM5LTM1MzklN0QlMkMlMEElMjAlMjAlMjB1cmwlM0QlN0JodHRwJTNBJTJGJTJGZHguZG9pLm9yZyUyRjEwLjExMDklMkZUUEFNSS4yMDE5LjI5Mzg3NTglN0QlMkMlMEElMjAlMjAlMjBET0klM0QlN0IxMC4xMTA5JTJGdHBhbWkuMjAxOS4yOTM4NzU4JTdEJTJDJTBBJTIwJTIwJTIwbnVtYmVyJTNEJTdCMiU3RCUyQyUwQSUyMCUyMCUyMGpvdXJuYWwlM0QlN0JJRUVFJTIwVHJhbnNhY3Rpb25zJTIwb24lMjBQYXR0ZXJuJTIwQW5hbHlzaXMlMjBhbmQlMjBNYWNoaW5lJTIwSW50ZWxsaWdlbmNlJTdEJTJDJTBBJTIwJTIwJTIwcHVibGlzaGVyJTNEJTdCSW5zdGl0dXRlJTIwb2YlMjBFbGVjdHJpY2FsJTIwYW5kJTIwRWxlY3Ryb25pY3MlMjBFbmdpbmVlcnMlMjAoSUVFRSklN0QlMkMlMEElMjAlMjAlMjBhdXRob3IlM0QlN0JHYW8lMkMlMjBTaGFuZy1IdWElMjBhbmQlMjBDaGVuZyUyQyUyME1pbmctTWluZyUyMGFuZCUyMFpoYW8lMkMlMjBLYWklMjBhbmQlMjBaaGFuZyUyQyUyMFhpbi1ZdSUyMGFuZCUyMFlhbmclMkMlMjBNaW5nLUhzdWFuJTIwYW5kJTIwVG9yciUyQyUyMFBoaWxpcCU3RCUyQyUwQSUyMCUyMCUyMHllYXIlM0QlN0IyMDIxJTdEJTJDJTBBJTIwJTIwJTIwbW9udGglM0QlN0JGZWIlN0QlMkMlMEElMjAlMjAlMjBwYWdlcyUzRCU3QjY1MiVFMiU4MCU5MzY2MiU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{Gao_2021,
   title={Res2Net: A New Multi-Scale Backbone Architecture}</span><span class="language-xml">,
   volume=</span><span class="hljs-template-variable">{43}</span><span class="language-xml">,
   ISSN=</span><span class="hljs-template-variable">{1939-3539}</span><span class="language-xml">,
   url=</span><span class="hljs-template-variable">{http://dx.doi.org/10.1109/TPAMI.2019.2938758}</span><span class="language-xml">,
   DOI=</span><span class="hljs-template-variable">{10.1109/tpami.2019.2938758}</span><span class="language-xml">,
   number=</span><span class="hljs-template-variable">{2}</span><span class="language-xml">,
   journal=</span><span class="hljs-template-variable">{IEEE Transactions on Pattern Analysis and Machine Intelligence}</span><span class="language-xml">,
   publisher=</span><span class="hljs-template-variable">{Institute of Electrical and Electronics Engineers (IEEE)}</span><span class="language-xml">,
   author=</span><span class="hljs-template-variable">{Gao, Shang-Hua and Cheng, Ming-Ming and Zhao, Kai and Zhang, Xin-Yu and Yang, Ming-Hsuan and Torr, Philip}</span><span class="language-xml">,
   year=</span><span class="hljs-template-variable">{2021}</span><span class="language-xml">,
   month=</span><span class="hljs-template-variable">{Feb}</span><span class="language-xml">,
   pages=</span><span class="hljs-template-variable">{652–662}</span><span class="language-xml">
}</span>`}}),{c(){J=a("meta"),ht=p(),st=a("p"),mt=p(),j=a("h1"),v=a("a"),lt=a("span"),c(N.$$.fragment),Rt=p(),D=a("span"),D.textContent=Xt,ct=p(),C=a("p"),C.innerHTML=Ft,Mt=p(),w=a("h2"),U=a("a"),at=a("span"),c(E.$$.fragment),St=p(),q=a("span"),q.textContent=zt,dt=p(),W=a("p"),W.textContent=Lt,gt=p(),c(B.$$.fragment),ut=p(),Z=a("p"),Z.textContent=Pt,yt=p(),c($.$$.fragment),Jt=p(),G=a("p"),G.textContent=Dt,jt=p(),c(Q.$$.fragment),wt=p(),_=a("p"),_.textContent=qt,Tt=p(),c(R.$$.fragment),bt=p(),S=a("p"),S.innerHTML=Kt,ft=p(),A=a("p"),A.innerHTML=Ot,vt=p(),T=a("h2"),I=a("a"),nt=a("span"),c(Y.$$.fragment),At=p(),K=a("span"),K.textContent=te,Ut=p(),V=a("p"),V.textContent=ee,It=p(),c(H.$$.fragment),xt=p(),X=a("p"),X.innerHTML=se,kt=p(),b=a("h2"),x=a("a"),pt=a("span"),c(F.$$.fragment),Yt=p(),O=a("span"),O.textContent=le,Nt=p(),z=a("p"),z.innerHTML=ae,Ct=p(),f=a("h2"),k=a("a"),it=a("span"),c(L.$$.fragment),Vt=p(),tt=a("span"),tt.textContent=ne,Et=p(),c(P.$$.fragment),Wt=p(),ot=a("p"),this.h()},l(t){const s=Te("svelte-1phssyn",document.head);J=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=i(t),st=n(t,"P",{}),h(st).forEach(e),mt=i(t),j=n(t,"H1",{class:!0});var Zt=h(j);v=n(Zt,"A",{id:!0,class:!0,href:!0});var pe=h(v);lt=n(pe,"SPAN",{});var ie=h(lt);M(N.$$.fragment,ie),ie.forEach(e),pe.forEach(e),Rt=i(Zt),D=n(Zt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-10jf1fg"&&(D.textContent=Xt),Zt.forEach(e),ct=i(t),C=n(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1l410x7"&&(C.innerHTML=Ft),Mt=i(t),w=n(t,"H2",{class:!0});var $t=h(w);U=n($t,"A",{id:!0,class:!0,href:!0});var oe=h(U);at=n(oe,"SPAN",{});var re=h(at);M(E.$$.fragment,re),re.forEach(e),oe.forEach(e),St=i($t),q=n($t,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=zt),$t.forEach(e),dt=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=Lt),gt=i(t),M(B.$$.fragment,t),ut=i(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1c2ipa8"&&(Z.textContent=Pt),yt=i(t),M($.$$.fragment,t),Jt=i(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Dt),jt=i(t),M(Q.$$.fragment,t),wt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-19cnvx1"&&(_.textContent=qt),Tt=i(t),M(R.$$.fragment,t),bt=i(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-nb3svj"&&(S.innerHTML=Kt),ft=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1wmi3ea"&&(A.innerHTML=Ot),vt=i(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var he=h(I);nt=n(he,"SPAN",{});var me=h(nt);M(Y.$$.fragment,me),me.forEach(e),he.forEach(e),At=i(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Gt.forEach(e),Ut=i(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-9sr7nh"&&(V.textContent=ee),It=i(t),M(H.$$.fragment,t),xt=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1kguc51"&&(X.innerHTML=se),kt=i(t),b=n(t,"H2",{class:!0});var Qt=h(b);x=n(Qt,"A",{id:!0,class:!0,href:!0});var ce=h(x);pt=n(ce,"SPAN",{});var Me=h(pt);M(F.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Yt=i(Qt),O=n(Qt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=le),Qt.forEach(e),Nt=i(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=ae),Ct=i(t),f=n(t,"H2",{class:!0});var _t=h(f);k=n(_t,"A",{id:!0,class:!0,href:!0});var de=h(k);it=n(de,"SPAN",{});var ge=h(it);M(L.$$.fragment,ge),ge.forEach(e),de.forEach(e),Vt=i(_t),tt=n(_t,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),_t.forEach(e),Et=i(t),M(P.$$.fragment,t),Wt=i(t),ot=n(t,"P",{}),h(ot).forEach(e),this.h()},h(){o(J,"name","hf:doc:metadata"),o(J,"content",JSON.stringify(fe)),o(v,"id","res2net"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#res2net"),o(j,"class","relative group"),o(U,"id","how-do-i-use-this-model-on-an-image"),o(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(U,"href","#how-do-i-use-this-model-on-an-image"),o(w,"class","relative group"),o(I,"id","how-do-i-finetune-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-finetune-this-model"),o(T,"class","relative group"),o(x,"id","how-do-i-train-this-model"),o(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(x,"href","#how-do-i-train-this-model"),o(b,"class","relative group"),o(k,"id","citation"),o(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(k,"href","#citation"),o(f,"class","relative group")},m(t,s){r(document.head,J),l(t,ht,s),l(t,st,s),l(t,mt,s),l(t,j,s),r(j,v),r(v,lt),d(N,lt,null),r(j,Rt),r(j,D),l(t,ct,s),l(t,C,s),l(t,Mt,s),l(t,w,s),r(w,U),r(U,at),d(E,at,null),r(w,St),r(w,q),l(t,dt,s),l(t,W,s),l(t,gt,s),d(B,t,s),l(t,ut,s),l(t,Z,s),l(t,yt,s),d($,t,s),l(t,Jt,s),l(t,G,s),l(t,jt,s),d(Q,t,s),l(t,wt,s),l(t,_,s),l(t,Tt,s),d(R,t,s),l(t,bt,s),l(t,S,s),l(t,ft,s),l(t,A,s),l(t,vt,s),l(t,T,s),r(T,I),r(I,nt),d(Y,nt,null),r(T,At),r(T,K),l(t,Ut,s),l(t,V,s),l(t,It,s),d(H,t,s),l(t,xt,s),l(t,X,s),l(t,kt,s),l(t,b,s),r(b,x),r(x,pt),d(F,pt,null),r(b,Yt),r(b,O),l(t,Nt,s),l(t,z,s),l(t,Ct,s),l(t,f,s),r(f,k),r(k,it),d(L,it,null),r(f,Vt),r(f,tt),l(t,Et,s),d(P,t,s),l(t,Wt,s),l(t,ot,s),Bt=!0},p:ye,i(t){Bt||(g(N.$$.fragment,t),g(E.$$.fragment,t),g(B.$$.fragment,t),g($.$$.fragment,t),g(Q.$$.fragment,t),g(R.$$.fragment,t),g(Y.$$.fragment,t),g(H.$$.fragment,t),g(F.$$.fragment,t),g(L.$$.fragment,t),g(P.$$.fragment,t),Bt=!0)},o(t){u(N.$$.fragment,t),u(E.$$.fragment,t),u(B.$$.fragment,t),u($.$$.fragment,t),u(Q.$$.fragment,t),u(R.$$.fragment,t),u(Y.$$.fragment,t),u(H.$$.fragment,t),u(F.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),Bt=!1},d(t){t&&(e(ht),e(st),e(mt),e(j),e(ct),e(C),e(Mt),e(w),e(dt),e(W),e(gt),e(ut),e(Z),e(yt),e(Jt),e(G),e(jt),e(wt),e(_),e(Tt),e(bt),e(S),e(ft),e(A),e(vt),e(T),e(Ut),e(V),e(It),e(xt),e(X),e(kt),e(b),e(Nt),e(z),e(Ct),e(f),e(Et),e(Wt),e(ot)),e(J),y(N),y(E),y(B,t),y($,t),y(Q,t),y(R,t),y(Y),y(H,t),y(F),y(L),y(P,t)}}}const fe={local:"res2net",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Res2Net"};function ve(Ht){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ne extends je{constructor(J){super(),we(this,J,ve,be,ue,{})}}export{Ne as component};
