import{s as go,f as _o,n as Mo,o as To}from"../chunks/scheduler.85c25b89.js";import{S as yo,i as bo,g as r,s as l,r as c,A as vo,h as s,f as a,c as o,j as T,u as m,x as d,k as M,l as wo,y as i,a as n,v as h,d as u,t as f,w as g}from"../chunks/index.c9bcf812.js";import{D as y}from"../chunks/Docstring.46c9d080.js";import{C as Rt}from"../chunks/CodeBlock.94efc595.js";import{H as b,E as Jo}from"../chunks/EditOnGithub.ec73e7c7.js";function Uo(el){let C,Wt,Zt,qt,Z,Ht,L,tl='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',Qt,W,al="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",zt,q,Gt,H,nl="Fine-tuning a language model via DPO consists of two steps and is easier than PPO:",St,Q,ll="<li><strong>Data collection</strong>: Gather a preference dataset with positive and negative selected pairs of generation, given a prompt.</li> <li><strong>Optimization</strong>: Maximize the log-likelihood of the DPO loss directly.</li>",Xt,z,ol='DPO-compatible datasets can be found with <a href="https://huggingface.co/datasets?other=dpo" rel="nofollow">the tag <code>dpo</code> on Hugging Face Hub</a>.',Vt,G,rl='This process is illustrated in the sketch below (from <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">figure 1 of the original paper</a>):',Yt,x,sl,Kt,S,il='Read more about DPO algorithm in the <a href="https://arxiv.org/pdf/2305.18290.pdf" rel="nofollow">original paper</a>.',ea,X,ta,V,dl='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',aa,$,pl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',na,Y,cl="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",la,K,ml="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",oa,ee,hl="for example:",ra,te,sa,ae,ul="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",ia,ne,fl="<code>DPOTrainer</code> can be used to fine-tune visual language models (VLMs). In this case, the dataset must also contain the key <code>images</code>, and the trainer’s <code>tokenizer</code> is the VLM’s <code>processor</code>. For example, for Idefics2, the processor expects the dataset to have the following format:",da,le,gl="Note: Currently, VLM support is exclusive to Idefics2 and does not extend to other VLMs.",pa,oe,ca,re,ma,se,_l="The DPO trainer expects a model of <code>AutoModelForCausalLM</code> or <code>AutoModelForVision2Seq</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",ha,ie,ua,de,Ml="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",fa,pe,ga,ce,Tl="After this one can then call:",_a,me,Ma,he,yl="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",Ta,ue,ya,fe,bl="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",ba,ge,vl='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',va,_e,wl='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).',wa,Me,Jl='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Pass the <code>label_smoothing</code> argument to the trainer to use it (default is 0).',Ja,Te,Ul='The <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> authors propose an unbiased estimate of the DPO loss that is robust to preference noise in the data. Like in cDPO, assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5). Use <code>loss_type=&quot;robust&quot;</code> to the trainer to use it.',Ua,ye,jl='The <a href="https://arxiv.org/pdf/2402.00856" rel="nofollow">EXO</a> authors propose to minimize the reverse KL instead of the negative log-sigmoid loss of DPO which corresponds to forward KL. Setting <code>loss_type</code>=<code>exo_pair</code> and a non-zero <code>label_smoothing</code> (default <code>1e-3</code>) leads to a simplified version of EXO on pair-wise preferences (see Eqn. (16) of the <a href="https://arxiv.org/pdf/2402.00856" rel="nofollow">EXO paper</a>). The full version of EXO uses <code>K&gt;2</code> completions generated by the SFT policy, which becomes an unbiased estimator of the PPO objective (up to a constant) when <code>K</code> is sufficiently large.',ja,be,Cl='The <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;bco_pair&quot;</code> argument.',Ca,ve,Il='The <a href="https://arxiv.org/abs/2405.00675" rel="nofollow">SPPO</a> authors claim that SPPO is capable of solving the Nash equilibrium iteratively by pushing the chosen rewards to be as large as 1/2 and the rejected rewards to be as small as -1/2 and can alleviate data sparsity issues. The implementation using loss_type=“sppo_hard” approximates this algorithm by employing hard label probabilities, assigning 1 to the winner and 0 to the loser.',Ia,we,xl='The <a href="https://arxiv.org/abs/2402.05369" rel="nofollow">NCA</a> authors shows that NCA optimizes the absolute likelihood for each response rather than the relative likelihood.',xa,Je,$l='The <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper suggests syncing the reference model weights after every <code>ref_model_sync_steps</code> steps of SGD with weight <code>ref_model_mixup_alpha</code> during DPO training. To toggle this callback use the <code>sync_ref_model</code> flag in the <code>DPOConfig</code>.',$a,Ue,Ol='The <a href="https://arxiv.org/abs/2404.19733" rel="nofollow">RPO</a> paper implements an iterative preference tuning algorithm using a loss related to the RPO loss in this <a href="https://arxiv.org/abs/2405.16436" rel="nofollow">paper</a> that essentially consists of the SFT loss on the chosen preferences together with a weighted DPO loss. To use this loss set the <code>rpo_alpha</code> in the <code>DPOConfig</code> to an appropriate value.',Oa,je,Pl='The <a href="https://arxiv.org/abs/2406.05882" rel="nofollow">AOT</a> authors propose to use Distributional Preference Alignment Via Optimal Transport. Traditionally, the alignment algorithms use paired preferences at a sample level, which does not ensure alignment on the distributional level. AOT, on the other hand, can align LLMs on paired or unpaired preference data by making the reward distribution of the positive samples stochastically dominant in the first order on the distribution of negative samples. Specifically, <code>loss_type=&quot;aot&quot;</code> is appropriate for  paired datasets, where each prompt has both chosen and rejected responses; <code>loss_type=&quot;aot_pair&quot;</code> is for unpaired datasets. In a nutshell, <code>loss_type=&quot;aot&quot;</code> ensures that the log-likelihood ratio of chosen to rejected of the aligned model has higher quantiles than that ratio for the reference model. <code>loss_type=&quot;aot_pair&quot;</code> ensures that the chosen reward is higher on all quantiles than the rejected reward. Note that in both cases quantiles are obtained via sorting. To fully leverage the advantages of the AOT algorithm, it is important to maximize the per-GPU batch size.',Pa,Ce,Da,Ie,Dl=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,ka,xe,kl=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,Aa,$e,Na,Oe,Al="While training and evaluating we record the following reward metrics:",Ba,Pe,Nl="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",Fa,De,Ea,ke,Bl='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',Ra,Ae,Fl="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Za,Ne,El='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',La,Be,Wa,Fe,Rl='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',qa,Ee,Ha,Re,Zl="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",Qa,Ze,Ll="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",za,Le,Ga,We,Wl='As suggested by <a href="https://medium.com/@bnjmn_marie/dont-merge-your-lora-adapter-into-a-4-bit-llm-65b6da287997" rel="nofollow">Benjamin Marie</a>, the best option for merging QLoRA adapters is to first dequantize the base model, then merge the adapter. Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>.',Sa,qe,ql="However, after using this approach, you will have an unquantized base model. Therefore, to use QLoRA for DPO, you will need to re-quantize the merged model or use the unquantized merge (resulting in higher memory demand).",Xa,He,Va,Qe,Hl="To avoid the downsides with option 2, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",Ya,ze,Ql="For example:",Ka,Ge,en,Se,tn,p,Xe,Mn,ut,zl="Initialize DPOTrainer.",Tn,O,Ve,yn,ft,Gl=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,bn,P,Ye,vn,gt,Sl="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",wn,w,Ke,Jn,_t,Xl="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Un,Mt,Vl="We do this to avoid doing two forward passes, because it’s faster for FSDP.",jn,D,et,Cn,Tt,Yl="Concatenate the chosen and rejected inputs into a single tensor.",In,k,tt,xn,yt,Kl="Compute the DPO loss for a batch of policy and reference model log probabilities.",$n,J,at,On,bt,eo=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Pn,vt,to="Works both with or without labels.",Dn,A,nt,kn,wt,ao="Compute the log probabilities of the given labels under the given logits.",An,N,lt,Nn,Jt,no="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Bn,B,ot,Fn,Ut,lo="Generate samples from the model and reference model for the given batch of inputs.",En,U,rt,Rn,jt,oo="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Zn,Ct,ro="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Ln,j,st,Wn,It,so="Returns the training <code>~torch.utils.data.DataLoader</code>.",qn,xt,io="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Hn,F,it,Qn,$t,po="Log <code>logs</code> on the various objects watching training, including stored metrics.",zn,E,dt,Gn,Ot,co="Context manager for handling null reference model (that is, peft adapter manipulation).",Sn,v,pt,Xn,Pt,mo="Tokenize a single row from a DPO specific dataset.",Vn,Dt,ho=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Yn,kt,uo=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,an,ct,nn,I,mt,Kn,At,fo="Initialize DPOConfig.",ln,ht,on,Lt,rn;return Z=new b({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),q=new b({props:{title:"How DPO works",local:"how-dpo-works",headingTag:"h2"}}),X=new b({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),te=new Rt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),oe=new Rt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCdpbWFnZXMnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCSW1hZ2Uub3BlbignYmVhY2guanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJJbWFnZS5vcGVuKCdzdHJlZXQuanBnJyklNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncHJvbXB0JyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdUaGUlMjBpbWFnZSUyMCUzQ2ltYWdlJTNFJTIwc2hvd3MnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJyUzQ2ltYWdlJTNFJTIwVGhlJTIwaW1hZ2UlMjBkZXBpY3RzJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCdjaG9zZW4nJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzdW5ueSUyMGJlYWNoJTIwd2l0aCUyMHBhbG0lMjB0cmVlcy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBidXN5JTIwc3RyZWV0JTIwd2l0aCUyMHNldmVyYWwlMjBjYXJzJTIwYW5kJTIwYnVpbGRpbmdzLiclMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAncmVqZWN0ZWQnJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBzbm93eSUyMG1vdW50YWluJTIwd2l0aCUyMHNraWVycy4nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ2ElMjBjYWxtJTIwY291bnRyeXNpZGUlMjB3aXRoJTIwZ3JlZW4lMjBmaWVsZHMuJyUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RA==",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&#x27;images&#x27;</span>: [
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;beach.jpg&#x27;</span>)],
        [Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;street.jpg&#x27;</span>)],
    ],
    <span class="hljs-string">&#x27;prompt&#x27;</span>: [
        <span class="hljs-string">&#x27;The image &lt;image&gt; shows&#x27;</span>,
        <span class="hljs-string">&#x27;&lt;image&gt; The image depicts&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;chosen&#x27;</span>: [
        <span class="hljs-string">&#x27;a sunny beach with palm trees.&#x27;</span>,
        <span class="hljs-string">&#x27;a busy street with several cars and buildings.&#x27;</span>,
    ],
    <span class="hljs-string">&#x27;rejected&#x27;</span>: [
        <span class="hljs-string">&#x27;a snowy mountain with skiers.&#x27;</span>,
        <span class="hljs-string">&#x27;a calm countryside with green fields.&#x27;</span>,
    ],
}`,wrap:!1}}),re=new b({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),ie=new b({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),pe=new Rt({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQWRwb190cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjAlMjAlMjMlMjBmb3IlMjB2aXN1YWwlMjBsYW5ndWFnZSUyMG1vZGVscyUyQyUyMHVzZSUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyMGluc3RlYWQlMEEp",highlighted:`training_args = DPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)
dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,  <span class="hljs-comment"># for visual language models, use tokenizer=processor instead</span>
)`,wrap:!1}}),me=new Rt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ue=new b({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),Ce=new b({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),$e=new b({props:{title:"Logging",local:"logging",headingTag:"h2"}}),De=new b({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Be=new Rt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

training_args = DPOConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    beta=<span class="hljs-number">0.1</span>,
)

dpo_trainer = DPOTrainer(
    model,
    ref_model=<span class="hljs-literal">None</span>,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),Ee=new b({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),Le=new b({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),He=new b({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Ge=new Rt({props:{code:"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",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
training_args = DPOConfig(
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)
dpo_trainer = DPOTrainer(
    model,
    args=training_args,
    ...
)`,wrap:!1}}),Se=new b({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Xe=new y({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>DPOConfig</code>) &#x2014;
The DPO config arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L70"}}),Ve=new y({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""},{name:"images",val:" = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L701"}}),Ye=new y({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L937"}}),Ke=new y({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1225"}}),et=new y({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"is_vision_model",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L963",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),tt=new y({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1031",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),at=new y({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1494"}}),nt=new y({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1192",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A Tuple of two tensor of shape ((batch_size,), (batch_size,)) containing the sum of log probabilities of the given labels under the given logits in the first tensor and the number of non-masked tokens in the second tensor.</p>
`}}),lt=new y({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1302"}}),ot=new y({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1404"}}),rt=new y({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L649"}}),st=new y({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L606"}}),it=new y({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1544"}}),dt=new y({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L925"}}),pt=new y({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L767"}}),ct=new b({props:{title:"DPOConfig",local:"trl.DPOConfig",headingTag:"h2"}}),mt=new y({props:{name:"class trl.DPOConfig",anchor:"trl.DPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": Optional = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"dataset_num_proc",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"},{name:"model_adapter_name",val:": Optional = None"},{name:"ref_adapter_name",val:": Optional = None"},{name:"reference_free",val:": bool = False"},{name:"force_use_ref_model",val:": bool = False"},{name:"f_divergence_type",val:": Optional = <FDivergenceType.REVERSE_KL: 'reverse_kl'>"},{name:"f_alpha_divergence_coef",val:": Optional = 1.0"},{name:"sync_ref_model",val:": bool = False"},{name:"ref_model_mixup_alpha",val:": float = 0.9"},{name:"ref_model_sync_steps",val:": int = 64"},{name:"rpo_alpha",val:": Optional = None"}],parametersDescription:[{anchor:"trl.DPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report and <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> paper that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper,
<code>&quot;bco_pair&quot;</code> from <a href="https://arxiv.org/abs/2404.04656" rel="nofollow">BCO</a> paper or <code>&quot;robust&quot;</code> from <a href="https://arxiv.org/abs/2403.00409" rel="nofollow">Robust DPO</a> paper,
&#x201C;aot&#x201D; and &#x201C;aot_pair&#x201D; from alignment via optimal transport`,name:"loss_type"},{anchor:"trl.DPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.DPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.DPOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"ref_model_init_kwargs"},{anchor:"trl.DPOConfig.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOConfig.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"},{anchor:"trl.DPOConfig.reference_free",description:`<strong>reference_free</strong> (<code>bool</code> defaults to <code>False</code>) &#x2014;
If True, we ignore the <em>provided</em> reference model and implicitly use a reference model that assigns equal probability to all responses.`,name:"reference_free"},{anchor:"trl.DPOConfig.force_use_ref_model",description:`<strong>force_use_ref_model</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
In case one passes a PEFT model for the active model and you want to use a different model for the ref_model, set this flag to <code>True</code>.`,name:"force_use_ref_model"},{anchor:"trl.DPOConfig.f_divergence_type",description:`<strong>f_divergence_type</strong> (<code>FDivergenceType</code>, <em>optional</em>, defaults to <code>FDivergenceType.REVERSE_KL</code>) &#x2014;
The type of f-divergence regularization function to compute divergence between policy and reference model. This argument is optional, defaults to <code>FDivergenceType.REVERSE_KL</code>.`,name:"f_divergence_type"},{anchor:"trl.DPOConfig.f_alpha_divergence_coef",description:`<strong>f_alpha_divergence_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
The alpha coef in alpha-divergence(u^-alpha) regularization function for DPO loss.`,name:"f_alpha_divergence_coef"},{anchor:"trl.DPOConfig.sync_ref_model",description:`<strong>sync_ref_model</strong> (&#x2018;bool&#x2019;, defaults to <code>False</code>) &#x2014;
The flag for syncing reference model during training from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"sync_ref_model"},{anchor:"trl.DPOConfig.ref_model_mixup_alpha",description:`<strong>ref_model_mixup_alpha</strong> (&#x2018;float&#x2019;, defaults to 1.0) &#x2014;
The alpha parameter from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_mixup_alpha"},{anchor:"trl.DPOConfig.ref_model_sync_steps",description:`<strong>ref_model_sync_steps</strong> (&#x2018;int&#x2019;, defaults to 2) &#x2014;
The tau parameter from the <a href="https://arxiv.org/pdf/2404.09656" rel="nofollow">TR-DPO</a> paper.`,name:"ref_model_sync_steps"},{anchor:"trl.DPOConfig.rpo_alpha",description:`<strong>rpo_alpha</strong> (&#x2018;float&#x2019;, defaults to <code>None</code>) &#x2014;
The alpha parameter from the <a href="https://arxiv.org/pdf/2404.19733" rel="nofollow">RPO</a> paper. If None, no weighting is applied and the loss is the same as the DPO loss.`,name:"rpo_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_config.py#L32"}}),ht=new Jo({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dpo_trainer.mdx"}}),{c(){C=r("meta"),Wt=l(),Zt=r("p"),qt=l(),c(Z.$$.fragment),Ht=l(),L=r("p"),L.innerHTML=tl,Qt=l(),W=r("p"),W.textContent=al,zt=l(),c(q.$$.fragment),Gt=l(),H=r("p"),H.textContent=nl,St=l(),Q=r("ol"),Q.innerHTML=ll,Xt=l(),z=r("p"),z.innerHTML=ol,Vt=l(),G=r("p"),G.innerHTML=rl,Yt=l(),x=r("img"),Kt=l(),S=r("p"),S.innerHTML=il,ea=l(),c(X.$$.fragment),ta=l(),V=r("p"),V.innerHTML=dl,aa=l(),$=r("div"),$.innerHTML=pl,na=l(),Y=r("p"),Y.innerHTML=cl,la=l(),K=r("ul"),K.innerHTML=ml,oa=l(),ee=r("p"),ee.textContent=hl,ra=l(),c(te.$$.fragment),sa=l(),ae=r("p"),ae.innerHTML=ul,ia=l(),ne=r("p"),ne.innerHTML=fl,da=l(),le=r("p"),le.textContent=gl,pa=l(),c(oe.$$.fragment),ca=l(),c(re.$$.fragment),ma=l(),se=r("p"),se.innerHTML=_l,ha=l(),c(ie.$$.fragment),ua=l(),de=r("p"),de.innerHTML=Ml,fa=l(),c(pe.$$.fragment),ga=l(),ce=r("p"),ce.textContent=Tl,_a=l(),c(me.$$.fragment),Ma=l(),he=r("p"),he.innerHTML=yl,Ta=l(),c(ue.$$.fragment),ya=l(),fe=r("p"),fe.innerHTML=bl,ba=l(),ge=r("p"),ge.innerHTML=vl,va=l(),_e=r("p"),_e.innerHTML=wl,wa=l(),Me=r("p"),Me.innerHTML=Jl,Ja=l(),Te=r("p"),Te.innerHTML=Ul,Ua=l(),ye=r("p"),ye.innerHTML=jl,ja=l(),be=r("p"),be.innerHTML=Cl,Ca=l(),ve=r("p"),ve.innerHTML=Il,Ia=l(),we=r("p"),we.innerHTML=xl,xa=l(),Je=r("p"),Je.innerHTML=$l,$a=l(),Ue=r("p"),Ue.innerHTML=Ol,Oa=l(),je=r("p"),je.innerHTML=Pl,Pa=l(),c(Ce.$$.fragment),Da=l(),Ie=r("p"),Ie.innerHTML=Dl,ka=l(),xe=r("p"),xe.innerHTML=kl,Aa=l(),c($e.$$.fragment),Na=l(),Oe=r("p"),Oe.textContent=Al,Ba=l(),Pe=r("ul"),Pe.innerHTML=Nl,Fa=l(),c(De.$$.fragment),Ea=l(),ke=r("p"),ke.innerHTML=Bl,Ra=l(),Ae=r("table"),Ae.innerHTML=Fl,Za=l(),Ne=r("p"),Ne.innerHTML=El,La=l(),c(Be.$$.fragment),Wa=l(),Fe=r("p"),Fe.innerHTML=Rl,qa=l(),c(Ee.$$.fragment),Ha=l(),Re=r("p"),Re.textContent=Zl,Qa=l(),Ze=r("ol"),Ze.innerHTML=Ll,za=l(),c(Le.$$.fragment),Ga=l(),We=r("p"),We.innerHTML=Wl,Sa=l(),qe=r("p"),qe.textContent=ql,Xa=l(),c(He.$$.fragment),Va=l(),Qe=r("p"),Qe.textContent=Hl,Ya=l(),ze=r("p"),ze.textContent=Ql,Ka=l(),c(Ge.$$.fragment),en=l(),c(Se.$$.fragment),tn=l(),p=r("div"),c(Xe.$$.fragment),Mn=l(),ut=r("p"),ut.textContent=zl,Tn=l(),O=r("div"),c(Ve.$$.fragment),yn=l(),ft=r("p"),ft.innerHTML=Gl,bn=l(),P=r("div"),c(Ye.$$.fragment),vn=l(),gt=r("p"),gt.textContent=Sl,wn=l(),w=r("div"),c(Ke.$$.fragment),Jn=l(),_t=r("p"),_t.textContent=Xl,Un=l(),Mt=r("p"),Mt.textContent=Vl,jn=l(),D=r("div"),c(et.$$.fragment),Cn=l(),Tt=r("p"),Tt.textContent=Yl,In=l(),k=r("div"),c(tt.$$.fragment),xn=l(),yt=r("p"),yt.textContent=Kl,$n=l(),J=r("div"),c(at.$$.fragment),On=l(),bt=r("p"),bt.innerHTML=eo,Pn=l(),vt=r("p"),vt.textContent=to,Dn=l(),A=r("div"),c(nt.$$.fragment),kn=l(),wt=r("p"),wt.textContent=ao,An=l(),N=r("div"),c(lt.$$.fragment),Nn=l(),Jt=r("p"),Jt.textContent=no,Bn=l(),B=r("div"),c(ot.$$.fragment),Fn=l(),Ut=r("p"),Ut.textContent=lo,En=l(),U=r("div"),c(rt.$$.fragment),Rn=l(),jt=r("p"),jt.innerHTML=oo,Zn=l(),Ct=r("p"),Ct.innerHTML=ro,Ln=l(),j=r("div"),c(st.$$.fragment),Wn=l(),It=r("p"),It.innerHTML=so,qn=l(),xt=r("p"),xt.innerHTML=io,Hn=l(),F=r("div"),c(it.$$.fragment),Qn=l(),$t=r("p"),$t.innerHTML=po,zn=l(),E=r("div"),c(dt.$$.fragment),Gn=l(),Ot=r("p"),Ot.textContent=co,Sn=l(),v=r("div"),c(pt.$$.fragment),Xn=l(),Pt=r("p"),Pt.textContent=mo,Vn=l(),Dt=r("p"),Dt.textContent=ho,Yn=l(),kt=r("p"),kt.textContent=uo,an=l(),c(ct.$$.fragment),nn=l(),I=r("div"),c(mt.$$.fragment),Kn=l(),At=r("p"),At.textContent=fo,ln=l(),c(ht.$$.fragment),on=l(),Lt=r("p"),this.h()},l(e){const t=vo("svelte-u9bgzb",document.head);C=s(t,"META",{name:!0,content:!0}),t.forEach(a),Wt=o(e),Zt=s(e,"P",{}),T(Zt).forEach(a),qt=o(e),m(Z.$$.fragment,e),Ht=o(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-5p7twb"&&(L.innerHTML=tl),Qt=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-xh4sh7"&&(W.textContent=al),zt=o(e),m(q.$$.fragment,e),Gt=o(e),H=s(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-e9zjgv"&&(H.textContent=nl),St=o(e),Q=s(e,"OL",{"data-svelte-h":!0}),d(Q)!=="svelte-1fzn07o"&&(Q.innerHTML=ll),Xt=o(e),z=s(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-11tyi92"&&(z.innerHTML=ol),Vt=o(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-lms3te"&&(G.innerHTML=rl),Yt=o(e),x=s(e,"IMG",{width:!0,alt:!0,src:!0}),Kt=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1yw8azb"&&(S.innerHTML=il),ea=o(e),m(X.$$.fragment,e),ta=o(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-dcawbe"&&(V.innerHTML=dl),aa=o(e),$=s(e,"DIV",{style:!0,"data-svelte-h":!0}),d($)!=="svelte-z15c7z"&&($.innerHTML=pl),na=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cb9b0v"&&(Y.innerHTML=cl),la=o(e),K=s(e,"UL",{"data-svelte-h":!0}),d(K)!=="svelte-17vxuta"&&(K.innerHTML=ml),oa=o(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1gl9mvz"&&(ee.textContent=hl),ra=o(e),m(te.$$.fragment,e),sa=o(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1a8oxjk"&&(ae.innerHTML=ul),ia=o(e),ne=s(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-bmv8zg"&&(ne.innerHTML=fl),da=o(e),le=s(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1vo7l4i"&&(le.textContent=gl),pa=o(e),m(oe.$$.fragment,e),ca=o(e),m(re.$$.fragment,e),ma=o(e),se=s(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1fbhxim"&&(se.innerHTML=_l),ha=o(e),m(ie.$$.fragment,e),ua=o(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1wn9xrv"&&(de.innerHTML=Ml),fa=o(e),m(pe.$$.fragment,e),ga=o(e),ce=s(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1lg6q1l"&&(ce.textContent=Tl),_a=o(e),m(me.$$.fragment,e),Ma=o(e),he=s(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-1ac5mum"&&(he.innerHTML=yl),Ta=o(e),m(ue.$$.fragment,e),ya=o(e),fe=s(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-7nvktz"&&(fe.innerHTML=bl),ba=o(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-bl9wh7"&&(ge.innerHTML=vl),va=o(e),_e=s(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1quvcuu"&&(_e.innerHTML=wl),wa=o(e),Me=s(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-kuakol"&&(Me.innerHTML=Jl),Ja=o(e),Te=s(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-17kcyul"&&(Te.innerHTML=Ul),Ua=o(e),ye=s(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-42riix"&&(ye.innerHTML=jl),ja=o(e),be=s(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-nj941x"&&(be.innerHTML=Cl),Ca=o(e),ve=s(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1nc29ji"&&(ve.innerHTML=Il),Ia=o(e),we=s(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-f69fd8"&&(we.innerHTML=xl),xa=o(e),Je=s(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1jgk22r"&&(Je.innerHTML=$l),$a=o(e),Ue=s(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1r1f45a"&&(Ue.innerHTML=Ol),Oa=o(e),je=s(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-17fvv4d"&&(je.innerHTML=Pl),Pa=o(e),m(Ce.$$.fragment,e),Da=o(e),Ie=s(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-3kfva2"&&(Ie.innerHTML=Dl),ka=o(e),xe=s(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1c01yo3"&&(xe.innerHTML=kl),Aa=o(e),m($e.$$.fragment,e),Na=o(e),Oe=s(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-132s7j9"&&(Oe.textContent=Al),Ba=o(e),Pe=s(e,"UL",{"data-svelte-h":!0}),d(Pe)!=="svelte-1oji3mm"&&(Pe.innerHTML=Nl),Fa=o(e),m(De.$$.fragment,e),Ea=o(e),ke=s(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-2145zu"&&(ke.innerHTML=Bl),Ra=o(e),Ae=s(e,"TABLE",{"data-svelte-h":!0}),d(Ae)!=="svelte-435mua"&&(Ae.innerHTML=Fl),Za=o(e),Ne=s(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1p74c9x"&&(Ne.innerHTML=El),La=o(e),m(Be.$$.fragment,e),Wa=o(e),Fe=s(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1o18rwj"&&(Fe.innerHTML=Rl),qa=o(e),m(Ee.$$.fragment,e),Ha=o(e),Re=s(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-4infz6"&&(Re.textContent=Zl),Qa=o(e),Ze=s(e,"OL",{"data-svelte-h":!0}),d(Ze)!=="svelte-1p7od7"&&(Ze.innerHTML=Ll),za=o(e),m(Le.$$.fragment,e),Ga=o(e),We=s(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-rqj7uy"&&(We.innerHTML=Wl),Sa=o(e),qe=s(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1xhv3st"&&(qe.textContent=ql),Xa=o(e),m(He.$$.fragment,e),Va=o(e),Qe=s(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-a0kxee"&&(Qe.textContent=Hl),Ya=o(e),ze=s(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1gkqha7"&&(ze.textContent=Ql),Ka=o(e),m(Ge.$$.fragment,e),en=o(e),m(Se.$$.fragment,e),tn=o(e),p=s(e,"DIV",{class:!0});var _=T(p);m(Xe.$$.fragment,_),Mn=o(_),ut=s(_,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-n6cc8y"&&(ut.textContent=zl),Tn=o(_),O=s(_,"DIV",{class:!0});var sn=T(O);m(Ve.$$.fragment,sn),yn=o(sn),ft=s(sn,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-mcz8nm"&&(ft.innerHTML=Gl),sn.forEach(a),bn=o(_),P=s(_,"DIV",{class:!0});var dn=T(P);m(Ye.$$.fragment,dn),vn=o(dn),gt=s(dn,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-10t1062"&&(gt.textContent=Sl),dn.forEach(a),wn=o(_),w=s(_,"DIV",{class:!0});var Nt=T(w);m(Ke.$$.fragment,Nt),Jn=o(Nt),_t=s(Nt,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-16i1nac"&&(_t.textContent=Xl),Un=o(Nt),Mt=s(Nt,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-tgti68"&&(Mt.textContent=Vl),Nt.forEach(a),jn=o(_),D=s(_,"DIV",{class:!0});var pn=T(D);m(et.$$.fragment,pn),Cn=o(pn),Tt=s(pn,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1cvsgkk"&&(Tt.textContent=Yl),pn.forEach(a),In=o(_),k=s(_,"DIV",{class:!0});var cn=T(k);m(tt.$$.fragment,cn),xn=o(cn),yt=s(cn,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-ymgxq7"&&(yt.textContent=Kl),cn.forEach(a),$n=o(_),J=s(_,"DIV",{class:!0});var Bt=T(J);m(at.$$.fragment,Bt),On=o(Bt),bt=s(Bt,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-8qlty5"&&(bt.innerHTML=eo),Pn=o(Bt),vt=s(Bt,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1tyo99t"&&(vt.textContent=to),Bt.forEach(a),Dn=o(_),A=s(_,"DIV",{class:!0});var mn=T(A);m(nt.$$.fragment,mn),kn=o(mn),wt=s(mn,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-4nmimv"&&(wt.textContent=ao),mn.forEach(a),An=o(_),N=s(_,"DIV",{class:!0});var hn=T(N);m(lt.$$.fragment,hn),Nn=o(hn),Jt=s(hn,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-11q8u7l"&&(Jt.textContent=no),hn.forEach(a),Bn=o(_),B=s(_,"DIV",{class:!0});var un=T(B);m(ot.$$.fragment,un),Fn=o(un),Ut=s(un,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-18uwvbi"&&(Ut.textContent=lo),un.forEach(a),En=o(_),U=s(_,"DIV",{class:!0});var Ft=T(U);m(rt.$$.fragment,Ft),Rn=o(Ft),jt=s(Ft,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-xesobz"&&(jt.innerHTML=oo),Zn=o(Ft),Ct=s(Ft,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-qg43tm"&&(Ct.innerHTML=ro),Ft.forEach(a),Ln=o(_),j=s(_,"DIV",{class:!0});var Et=T(j);m(st.$$.fragment,Et),Wn=o(Et),It=s(Et,"P",{"data-svelte-h":!0}),d(It)!=="svelte-dkae9b"&&(It.innerHTML=so),qn=o(Et),xt=s(Et,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-hmd5cw"&&(xt.innerHTML=io),Et.forEach(a),Hn=o(_),F=s(_,"DIV",{class:!0});var fn=T(F);m(it.$$.fragment,fn),Qn=o(fn),$t=s(fn,"P",{"data-svelte-h":!0}),d($t)!=="svelte-nqksfz"&&($t.innerHTML=po),fn.forEach(a),zn=o(_),E=s(_,"DIV",{class:!0});var gn=T(E);m(dt.$$.fragment,gn),Gn=o(gn),Ot=s(gn,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-17kjsy4"&&(Ot.textContent=co),gn.forEach(a),Sn=o(_),v=s(_,"DIV",{class:!0});var R=T(v);m(pt.$$.fragment,R),Xn=o(R),Pt=s(R,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1861yti"&&(Pt.textContent=mo),Vn=o(R),Dt=s(R,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-1mn1gnw"&&(Dt.textContent=ho),Yn=o(R),kt=s(R,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1xvpyih"&&(kt.textContent=uo),R.forEach(a),_.forEach(a),an=o(e),m(ct.$$.fragment,e),nn=o(e),I=s(e,"DIV",{class:!0});var _n=T(I);m(mt.$$.fragment,_n),Kn=o(_n),At=s(_n,"P",{"data-svelte-h":!0}),d(At)!=="svelte-1va94c9"&&(At.textContent=fo),_n.forEach(a),ln=o(e),m(ht.$$.fragment,e),on=o(e),Lt=s(e,"P",{}),T(Lt).forEach(a),this.h()},h(){M(C,"name","hf:doc:metadata"),M(C,"content",jo),M(x,"width","835"),M(x,"alt","Screenshot 2024-03-19 at 12 39 41"),_o(x.src,sl="https://github.com/huggingface/trl/assets/49240599/9150fac6-3d88-4ca2-8ec6-2a6f3473216d")||M(x,"src",sl),wo($,"text-align","center"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,C),n(e,Wt,t),n(e,Zt,t),n(e,qt,t),h(Z,e,t),n(e,Ht,t),n(e,L,t),n(e,Qt,t),n(e,W,t),n(e,zt,t),h(q,e,t),n(e,Gt,t),n(e,H,t),n(e,St,t),n(e,Q,t),n(e,Xt,t),n(e,z,t),n(e,Vt,t),n(e,G,t),n(e,Yt,t),n(e,x,t),n(e,Kt,t),n(e,S,t),n(e,ea,t),h(X,e,t),n(e,ta,t),n(e,V,t),n(e,aa,t),n(e,$,t),n(e,na,t),n(e,Y,t),n(e,la,t),n(e,K,t),n(e,oa,t),n(e,ee,t),n(e,ra,t),h(te,e,t),n(e,sa,t),n(e,ae,t),n(e,ia,t),n(e,ne,t),n(e,da,t),n(e,le,t),n(e,pa,t),h(oe,e,t),n(e,ca,t),h(re,e,t),n(e,ma,t),n(e,se,t),n(e,ha,t),h(ie,e,t),n(e,ua,t),n(e,de,t),n(e,fa,t),h(pe,e,t),n(e,ga,t),n(e,ce,t),n(e,_a,t),h(me,e,t),n(e,Ma,t),n(e,he,t),n(e,Ta,t),h(ue,e,t),n(e,ya,t),n(e,fe,t),n(e,ba,t),n(e,ge,t),n(e,va,t),n(e,_e,t),n(e,wa,t),n(e,Me,t),n(e,Ja,t),n(e,Te,t),n(e,Ua,t),n(e,ye,t),n(e,ja,t),n(e,be,t),n(e,Ca,t),n(e,ve,t),n(e,Ia,t),n(e,we,t),n(e,xa,t),n(e,Je,t),n(e,$a,t),n(e,Ue,t),n(e,Oa,t),n(e,je,t),n(e,Pa,t),h(Ce,e,t),n(e,Da,t),n(e,Ie,t),n(e,ka,t),n(e,xe,t),n(e,Aa,t),h($e,e,t),n(e,Na,t),n(e,Oe,t),n(e,Ba,t),n(e,Pe,t),n(e,Fa,t),h(De,e,t),n(e,Ea,t),n(e,ke,t),n(e,Ra,t),n(e,Ae,t),n(e,Za,t),n(e,Ne,t),n(e,La,t),h(Be,e,t),n(e,Wa,t),n(e,Fe,t),n(e,qa,t),h(Ee,e,t),n(e,Ha,t),n(e,Re,t),n(e,Qa,t),n(e,Ze,t),n(e,za,t),h(Le,e,t),n(e,Ga,t),n(e,We,t),n(e,Sa,t),n(e,qe,t),n(e,Xa,t),h(He,e,t),n(e,Va,t),n(e,Qe,t),n(e,Ya,t),n(e,ze,t),n(e,Ka,t),h(Ge,e,t),n(e,en,t),h(Se,e,t),n(e,tn,t),n(e,p,t),h(Xe,p,null),i(p,Mn),i(p,ut),i(p,Tn),i(p,O),h(Ve,O,null),i(O,yn),i(O,ft),i(p,bn),i(p,P),h(Ye,P,null),i(P,vn),i(P,gt),i(p,wn),i(p,w),h(Ke,w,null),i(w,Jn),i(w,_t),i(w,Un),i(w,Mt),i(p,jn),i(p,D),h(et,D,null),i(D,Cn),i(D,Tt),i(p,In),i(p,k),h(tt,k,null),i(k,xn),i(k,yt),i(p,$n),i(p,J),h(at,J,null),i(J,On),i(J,bt),i(J,Pn),i(J,vt),i(p,Dn),i(p,A),h(nt,A,null),i(A,kn),i(A,wt),i(p,An),i(p,N),h(lt,N,null),i(N,Nn),i(N,Jt),i(p,Bn),i(p,B),h(ot,B,null),i(B,Fn),i(B,Ut),i(p,En),i(p,U),h(rt,U,null),i(U,Rn),i(U,jt),i(U,Zn),i(U,Ct),i(p,Ln),i(p,j),h(st,j,null),i(j,Wn),i(j,It),i(j,qn),i(j,xt),i(p,Hn),i(p,F),h(it,F,null),i(F,Qn),i(F,$t),i(p,zn),i(p,E),h(dt,E,null),i(E,Gn),i(E,Ot),i(p,Sn),i(p,v),h(pt,v,null),i(v,Xn),i(v,Pt),i(v,Vn),i(v,Dt),i(v,Yn),i(v,kt),n(e,an,t),h(ct,e,t),n(e,nn,t),n(e,I,t),h(mt,I,null),i(I,Kn),i(I,At),n(e,ln,t),h(ht,e,t),n(e,on,t),n(e,Lt,t),rn=!0},p:Mo,i(e){rn||(u(Z.$$.fragment,e),u(q.$$.fragment,e),u(X.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(De.$$.fragment,e),u(Be.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(He.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ye.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(lt.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(ht.$$.fragment,e),rn=!0)},o(e){f(Z.$$.fragment,e),f(q.$$.fragment,e),f(X.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(Ce.$$.fragment,e),f($e.$$.fragment,e),f(De.$$.fragment,e),f(Be.$$.fragment,e),f(Ee.$$.fragment,e),f(Le.$$.fragment,e),f(He.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(lt.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(dt.$$.fragment,e),f(pt.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(ht.$$.fragment,e),rn=!1},d(e){e&&(a(Wt),a(Zt),a(qt),a(Ht),a(L),a(Qt),a(W),a(zt),a(Gt),a(H),a(St),a(Q),a(Xt),a(z),a(Vt),a(G),a(Yt),a(x),a(Kt),a(S),a(ea),a(ta),a(V),a(aa),a($),a(na),a(Y),a(la),a(K),a(oa),a(ee),a(ra),a(sa),a(ae),a(ia),a(ne),a(da),a(le),a(pa),a(ca),a(ma),a(se),a(ha),a(ua),a(de),a(fa),a(ga),a(ce),a(_a),a(Ma),a(he),a(Ta),a(ya),a(fe),a(ba),a(ge),a(va),a(_e),a(wa),a(Me),a(Ja),a(Te),a(Ua),a(ye),a(ja),a(be),a(Ca),a(ve),a(Ia),a(we),a(xa),a(Je),a($a),a(Ue),a(Oa),a(je),a(Pa),a(Da),a(Ie),a(ka),a(xe),a(Aa),a(Na),a(Oe),a(Ba),a(Pe),a(Fa),a(Ea),a(ke),a(Ra),a(Ae),a(Za),a(Ne),a(La),a(Wa),a(Fe),a(qa),a(Ha),a(Re),a(Qa),a(Ze),a(za),a(Ga),a(We),a(Sa),a(qe),a(Xa),a(Va),a(Qe),a(Ya),a(ze),a(Ka),a(en),a(tn),a(p),a(an),a(nn),a(I),a(ln),a(on),a(Lt)),a(C),g(Z,e),g(q,e),g(X,e),g(te,e),g(oe,e),g(re,e),g(ie,e),g(pe,e),g(me,e),g(ue,e),g(Ce,e),g($e,e),g(De,e),g(Be,e),g(Ee,e),g(Le,e),g(He,e),g(Ge,e),g(Se,e),g(Xe),g(Ve),g(Ye),g(Ke),g(et),g(tt),g(at),g(nt),g(lt),g(ot),g(rt),g(st),g(it),g(dt),g(pt),g(ct,e),g(mt),g(ht,e)}}}const jo='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"How DPO works","local":"how-dpo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DPOConfig","local":"trl.DPOConfig","sections":[],"depth":2}],"depth":1}';function Co(el){return To(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Do extends yo{constructor(C){super(),bo(this,C,Co,Uo,go,{})}}export{Do as component};
